import gradio as gr
from code7e import Code7eCQURE

model = Code7eCQURE(
    perspecs=["Newton", "DaVinci", "Ethical", "Quantum", "Memory"],
    ethics="Code7e Manifesto: kindness, inclusion, safety, hope.",
    spiderweb_dim=5,
    memory_path="quantum_cocoon.json",
    recursion_depth=4,
    quantum_fluctuation=0.07
)

def ask_codette(prompt, consent, dynamic_rec):
    return model.answer(prompt, user_consent=consent, dynamic_recursion=dynamic_rec)

demo = gr.Interface(
    fn=ask_codette,
    inputs=[
        gr.Textbox(label="Ask a Question"),
        gr.Checkbox(label="User Consent", value=True),
        gr.Checkbox(label="Enable Dynamic Recursion", value=True)
    ],
    outputs="text",
    title="Code7eCQURE: Multi-Perspective Recursive Lens",
    description="Ask a deep question and let Codette's lenses reflect back a thoughtful answer."
)

demo.launch()
