import{s as fe,n as Te,o as we}from"../chunks/scheduler.8c3d61f6.js";import{S as Ue,i as Ze,g as i,s as n,r as d,A as be,h as p,f as a,c as s,j as Je,u as c,x as M,k as ue,l as y,y as je,a as l,v as h,d as J,t as u,w as g}from"../chunks/index.da70eac4.js";import{C as E}from"../chunks/CodeBlock.a9c4becf.js";import{H as ge,E as Be}from"../chunks/getInferenceSnippets.28ca3596.js";function We(se){let r,F,Y,x,f,Q,T,ie='<a href="https://huggingface.co/papers/2302.08453" rel="nofollow">T2I-Adapter</a> is an adapter that enables controllable generation like <a href="./controlnet">ControlNet</a>. A T2I-Adapter works by learning a <em>mapping</em> between a control signal (for example, a depth map) and a pretrained model’s internal knowledge. The adapter is plugged in to the base model to provide extra guidance based on the control signal during generation.',_,w,pe='Load a T2I-Adapter conditioned on a specific control, such as canny edge, and pass it to the pipeline in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>.',V,U,N,Z,oe='Generate a canny image with <a href="https://github.com/opencv/opencv-python" rel="nofollow">opencv-python</a>.',H,b,S,j,me="Pass the canny image to the pipeline to generate an image.",$,B,L,o,Me='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png" width="300" alt="Generated image (prompt only)"/> <figcaption style="text-align: center;">original image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/canny-cat.png" width="300" alt="Control image (Canny edges)"/> <figcaption style="text-align: center;">canny image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/t2i-canny-cat-generated.png" width="300" alt="Generated image (ControlNet + prompt)"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',z,W,q,G,re="You can compose multiple controls, such as canny image and a depth map, with the <code>MultiAdapter</code> class.",D,C,de="The example below composes a canny image and depth map.",P,I,ce="Load the control images and T2I-Adapters as a list.",K,k,O,v,ye='Pass the adapters, prompt, and control images to <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/adapter#diffusers.StableDiffusionXLAdapterPipeline">StableDiffusionXLAdapterPipeline</a>. Use the <code>adapter_conditioning_scale</code> parameter to determine how much weight to assign to each control.',ee,R,te,m,he='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/canny-cat.png" width="300" alt="Generated image (prompt only)"/> <figcaption style="text-align: center;">canny image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl_depth_image.png" width="300" alt="Control image (Canny edges)"/> <figcaption style="text-align: center;">depth map</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/t2i-multi-rabbit.png" width="300" alt="Generated image (ControlNet + prompt)"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',ae,A,le,X,ne;return f=new ge({props:{title:"T2I-Adapter",local:"t2i-adapter",headingTag:"h1"}}),U=new E({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVDJJQWRhcHRlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMQWRhcHRlclBpcGVsaW5lJTJDJTIwQXV0b2VuY29kZXJLTCUwQSUwQXQyaV9hZGFwdGVyJTIwJTNEJTIwVDJJQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyVGVuY2VudEFSQyUyRnQyaS1hZGFwdGVyLWNhbm55LXNkeGwtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> T2IAdapter, StableDiffusionXLAdapterPipeline, AutoencoderKL

t2i_adapter = T2IAdapter.from_pretrained(
    <span class="hljs-string">&quot;TencentARC/t2i-adapter-canny-sdxl-1.0&quot;</span>,
    torch_dtype=torch.float16,
)`,wrap:!1}}),b=new E({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGbm9uLWVuaGFuY2VkLXByb21wdC5wbmclMjIlMEEpJTBBJTBBaW1hZ2UlMjAlM0QlMjBucC5hcnJheShvcmlnaW5hbF9pbWFnZSklMEElMEFsb3dfdGhyZXNob2xkJTIwJTNEJTIwMTAwJTBBaGlnaF90aHJlc2hvbGQlMjAlM0QlMjAyMDAlMEElMEFpbWFnZSUyMCUzRCUyMGN2Mi5DYW5ueShpbWFnZSUyQyUyMGxvd190aHJlc2hvbGQlMkMlMjBoaWdoX3RocmVzaG9sZCklMEFpbWFnZSUyMCUzRCUyMGltYWdlJTVCJTNBJTJDJTIwJTNBJTJDJTIwTm9uZSU1RCUwQWltYWdlJTIwJTNEJTIwbnAuY29uY2F0ZW5hdGUoJTVCaW1hZ2UlMkMlMjBpbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwYXhpcyUzRDIpJTBBY2FubnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoaW1hZ2Up",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)`,wrap:!1}}),B=new E({props:{code:"dmFlJTIwJTNEJTIwQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZzZHhsLXZhZS1mcDE2LWZpeCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMQWRhcHRlclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBhZGFwdGVyJTNEdDJpX2FkYXB0ZXIlMkMlMEElMjAlMjAlMjAlMjB2YWUlM0R2YWUlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBQSUyMHBob3RvcmVhbGlzdGljJTIwb3ZlcmhlYWQlMjBpbWFnZSUyMG9mJTIwYSUyMGNhdCUyMHJlY2xpbmluZyUyMHNpZGV3YXlzJTIwaW4lMjBhJTIwZmxhbWluZ28lMjBwb29sJTIwZmxvYXRpZSUyMGhvbGRpbmclMjBhJTIwbWFyZ2FyaXRhLiUyMCUwQVRoZSUyMGNhdCUyMGlzJTIwZmxvYXRpbmclMjBsZWlzdXJlbHklMjBpbiUyMHRoZSUyMHBvb2wlMjBhbmQlMjBjb21wbGV0ZWx5JTIwcmVsYXhlZCUyMGFuZCUyMGhhcHB5LiUwQSUyMiUyMiUyMiUwQSUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEY2FubnlfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTIwJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16)
pipeline = StableDiffusionXLAdapterPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    adapter=t2i_adapter,
    vae=vae,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;&quot;&quot;
A photorealistic overhead image of a cat reclining sideways in a flamingo pool floatie holding a margarita. 
The cat is floating leisurely in the pool and completely relaxed and happy.
&quot;&quot;&quot;</span>

pipeline(
    prompt, 
    image=canny_image,
    num_inference_steps=<span class="hljs-number">100</span>, 
    guidance_scale=<span class="hljs-number">10</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),W=new ge({props:{title:"MultiAdapter",local:"multiadapter",headingTag:"h2"}}),k=new E({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25YTEFkYXB0ZXJQaXBlbGluZSUyQyUyMEF1dG9lbmNvZGVyS0wlMkMlMjBNdWx0aUFkYXB0ZXIlMkMlMjBUMklBZGFwdGVyJTBBJTBBY2FubnlfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNhbm55LWNhdC5wbmclMjIlMEEpJTBBZGVwdGhfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGxfZGVwdGhfaW1hZ2UucG5nJTIyJTBBKSUwQWNvbnRyb2xzJTIwJTNEJTIwJTVCY2FubnlfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSU1RCUwQXByb21wdCUyMCUzRCUyMCU1QiUyMiUyMiUyMiUwQWElMjByZWxheGVkJTIwcmFiYml0JTIwc2l0dGluZyUyMG9uJTIwYSUyMHN0cmlwZWQlMjB0b3dlbCUyMG5leHQlMjB0byUyMGElMjBwb29sJTIwd2l0aCUyMGElMjB0cm9waWNhbCUyMGRyaW5rJTIwbmVhcmJ5JTJDJTIwJTBBYnJpZ2h0JTIwc3VubnklMjBkYXklMkMlMjB2YWNhdGlvbiUyMHNjZW5lJTJDJTIwMzVtbSUyMHBob3RvZ3JhcGglMkMlMjBmaWxtJTJDJTIwcHJvZmVzc2lvbmFsJTJDJTIwNGslMkMlMjBoaWdobHklMjBkZXRhaWxlZCUwQSUyMiUyMiUyMiU1RCUwQSUwQWFkYXB0ZXJzJTIwJTNEJTIwTXVsdGlBZGFwdGVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFQySUFkYXB0ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlRlbmNlbnRBUkMlMkZ0MmktYWRhcHRlci1jYW5ueS1zZHhsLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUMklBZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJUZW5jZW50QVJDJTJGdDJpLWFkYXB0ZXItZGVwdGgtbWlkYXMtc2R4bC0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLAdapterPipeline, AutoencoderKL, MultiAdapter, T2IAdapter

canny_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/canny-cat.png&quot;</span>
)
depth_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl_depth_image.png&quot;</span>
)
controls = [canny_image, depth_image]
prompt = [<span class="hljs-string">&quot;&quot;&quot;
a relaxed rabbit sitting on a striped towel next to a pool with a tropical drink nearby, 
bright sunny day, vacation scene, 35mm photograph, film, professional, 4k, highly detailed
&quot;&quot;&quot;</span>]

adapters = MultiAdapter(
    [
        T2IAdapter.from_pretrained(<span class="hljs-string">&quot;TencentARC/t2i-adapter-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16),
        T2IAdapter.from_pretrained(<span class="hljs-string">&quot;TencentARC/t2i-adapter-depth-midas-sdxl-1.0&quot;</span>, torch_dtype=torch.float16),
    ]
)`,wrap:!1}}),R=new E({props:{code:"dmFlJTIwJTNEJTIwQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZzZHhsLXZhZS1mcDE2LWZpeCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMQWRhcHRlclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB2YWUlM0R2YWUlMkMlMEElMjAlMjAlMjAlMjBhZGFwdGVyJTNEYWRhcHRlcnMlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rjb250cm9scyUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBhZGFwdGVyX2NvbmRpdGlvbmluZ19zY2FsZSUzRCU1QjAuNyUyQyUyMDAuNyU1RCUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16)
pipeline = StableDiffusionXLAdapterPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    vae=vae,
    adapter=adapters,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline(
    prompt,
    image=controls,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    adapter_conditioning_scale=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.7</span>]
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),A=new Be({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/t2i_adapter.md"}}),{c(){r=i("meta"),F=n(),Y=i("p"),x=n(),d(f.$$.fragment),Q=n(),T=i("p"),T.innerHTML=ie,_=n(),w=i("p"),w.innerHTML=pe,V=n(),d(U.$$.fragment),N=n(),Z=i("p"),Z.innerHTML=oe,H=n(),d(b.$$.fragment),S=n(),j=i("p"),j.textContent=me,$=n(),d(B.$$.fragment),L=n(),o=i("div"),o.innerHTML=Me,z=n(),d(W.$$.fragment),q=n(),G=i("p"),G.innerHTML=re,D=n(),C=i("p"),C.textContent=de,P=n(),I=i("p"),I.textContent=ce,K=n(),d(k.$$.fragment),O=n(),v=i("p"),v.innerHTML=ye,ee=n(),d(R.$$.fragment),te=n(),m=i("div"),m.innerHTML=he,ae=n(),d(A.$$.fragment),le=n(),X=i("p"),this.h()},l(e){const t=be("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(a),F=s(e),Y=p(e,"P",{}),Je(Y).forEach(a),x=s(e),c(f.$$.fragment,e),Q=s(e),T=p(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1p3jhu3"&&(T.innerHTML=ie),_=s(e),w=p(e,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1d1686s"&&(w.innerHTML=pe),V=s(e),c(U.$$.fragment,e),N=s(e),Z=p(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-odtmr5"&&(Z.innerHTML=oe),H=s(e),c(b.$$.fragment,e),S=s(e),j=p(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-at49c"&&(j.textContent=me),$=s(e),c(B.$$.fragment,e),L=s(e),o=p(e,"DIV",{style:!0,"data-svelte-h":!0}),M(o)!=="svelte-riltjh"&&(o.innerHTML=Me),z=s(e),c(W.$$.fragment,e),q=s(e),G=p(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-tucbd1"&&(G.innerHTML=re),D=s(e),C=p(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-ueyms4"&&(C.textContent=de),P=s(e),I=p(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1k0b7f8"&&(I.textContent=ce),K=s(e),c(k.$$.fragment,e),O=s(e),v=p(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1qih0a3"&&(v.innerHTML=ye),ee=s(e),c(R.$$.fragment,e),te=s(e),m=p(e,"DIV",{style:!0,"data-svelte-h":!0}),M(m)!=="svelte-1ireybo"&&(m.innerHTML=he),ae=s(e),c(A.$$.fragment,e),le=s(e),X=p(e,"P",{}),Je(X).forEach(a),this.h()},h(){ue(r,"name","hf:doc:metadata"),ue(r,"content",Ge),y(o,"display","flex"),y(o,"gap","10px"),y(o,"justify-content","space-around"),y(o,"align-items","flex-end"),y(m,"display","flex"),y(m,"gap","10px"),y(m,"justify-content","space-around"),y(m,"align-items","flex-end")},m(e,t){je(document.head,r),l(e,F,t),l(e,Y,t),l(e,x,t),h(f,e,t),l(e,Q,t),l(e,T,t),l(e,_,t),l(e,w,t),l(e,V,t),h(U,e,t),l(e,N,t),l(e,Z,t),l(e,H,t),h(b,e,t),l(e,S,t),l(e,j,t),l(e,$,t),h(B,e,t),l(e,L,t),l(e,o,t),l(e,z,t),h(W,e,t),l(e,q,t),l(e,G,t),l(e,D,t),l(e,C,t),l(e,P,t),l(e,I,t),l(e,K,t),h(k,e,t),l(e,O,t),l(e,v,t),l(e,ee,t),h(R,e,t),l(e,te,t),l(e,m,t),l(e,ae,t),h(A,e,t),l(e,le,t),l(e,X,t),ne=!0},p:Te,i(e){ne||(J(f.$$.fragment,e),J(U.$$.fragment,e),J(b.$$.fragment,e),J(B.$$.fragment,e),J(W.$$.fragment,e),J(k.$$.fragment,e),J(R.$$.fragment,e),J(A.$$.fragment,e),ne=!0)},o(e){u(f.$$.fragment,e),u(U.$$.fragment,e),u(b.$$.fragment,e),u(B.$$.fragment,e),u(W.$$.fragment,e),u(k.$$.fragment,e),u(R.$$.fragment,e),u(A.$$.fragment,e),ne=!1},d(e){e&&(a(F),a(Y),a(x),a(Q),a(T),a(_),a(w),a(V),a(N),a(Z),a(H),a(S),a(j),a($),a(L),a(o),a(z),a(q),a(G),a(D),a(C),a(P),a(I),a(K),a(O),a(v),a(ee),a(te),a(m),a(ae),a(le),a(X)),a(r),g(f,e),g(U,e),g(b,e),g(B,e),g(W,e),g(k,e),g(R,e),g(A,e)}}}const Ge='{"title":"T2I-Adapter","local":"t2i-adapter","sections":[{"title":"MultiAdapter","local":"multiadapter","sections":[],"depth":2}],"depth":1}';function Ce(se){return we(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ae extends Ue{constructor(r){super(),Ze(this,r,Ce,We,fe,{})}}export{Ae as component};
