import{s as ht,o as Mt,n as ct}from"../chunks/scheduler.8c3d61f6.js";import{S as wt,i as bt,g as n,s,r,A as yt,h as p,f as t,c as a,j as ft,u as m,x as o,k as dt,y as Jt,a as i,v as f,d,t as u,w as c}from"../chunks/index.da70eac4.js";import{T as ut}from"../chunks/Tip.1d9b8c37.js";import{C as w}from"../chunks/CodeBlock.a9c4becf.js";import{D as Tt}from"../chunks/DocNotebookDropdown.48852948.js";import{H as y,E as gt}from"../chunks/getInferenceSnippets.28ca3596.js";function jt(Ue){let h,b='Use <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForText2Image">AutoPipelineForText2Image</a> because <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> doesn’t support PAG. Refer to the <a href="../tutorials/autopipeline">AutoPipeline</a> docs to learn more.';return{c(){h=n("p"),h.innerHTML=b},l(M){h=p(M,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1h6ozwy"&&(h.innerHTML=b)},m(M,J){i(M,h,J)},p:ct,d(M){M&&t(h)}}}function Zt(Ue){let h,b='Pipelines created by <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> share the same models and <em>state</em>. Modifying the state of a model in one pipeline affects all the other pipelines that share the same model.';return{c(){h=n("p"),h.innerHTML=b},l(M){h=p(M,"P",{"data-svelte-h":!0}),o(h)!=="svelte-yhkiqa"&&(h.innerHTML=b)},m(M,J){i(M,h,J)},p:ct,d(M){M&&t(h)}}}function Ut(Ue){let h,b,M,J,j,$e,Z,We,U,Bl='Diffusion models consists of multiple components like UNets or diffusion transformers (DiTs), text encoders, variational autoencoders (VAEs), and schedulers. The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> wraps all of these components into a single easy-to-use API without giving up the flexibility to modify it’s components.',Ie,v,kl='This guide will show you how to load a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',Ge,$,_e,W,xl='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is a base pipeline class that automatically selects and returns an instance of a model’s pipeline subclass, like <a href="/docs/diffusers/main/en/api/pipelines/qwenimage#diffusers.QwenImagePipeline">QwenImagePipeline</a>, by scanning the <code>model_index.json</code> file for the class name.',Be,I,El='Pass a model id to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load a pipeline.',ke,G,xe,_,Hl='Every model has a specific pipeline subclass that inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. A subclass usually has a narrow focus and are task-specific. See the table below for an example.',Ee,B,Cl='<thead><tr><th>pipeline subclass</th> <th>task</th></tr></thead> <tbody><tr><td><a href="/docs/diffusers/main/en/api/pipelines/qwenimage#diffusers.QwenImagePipeline">QwenImagePipeline</a></td> <td>text-to-image</td></tr> <tr><td><a href="/docs/diffusers/main/en/api/pipelines/qwenimage#diffusers.QwenImageImg2ImgPipeline">QwenImageImg2ImgPipeline</a></td> <td>image-to-image</td></tr> <tr><td><a href="/docs/diffusers/main/en/api/pipelines/qwenimage#diffusers.QwenImageInpaintPipeline">QwenImageInpaintPipeline</a></td> <td>inpaint</td></tr></tbody>',He,k,Rl='You could use the subclass directly by passing a model id to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>.',Ce,x,Re,E,Xe,H,Xl='Pipelines can also be run locally. Use <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download" rel="nofollow">snapshot_download</a> to download a model repository.',Pe,C,Qe,R,Pl='The model is downloaded to your <a href="../installation#cache">cache</a>. Pass the folder path to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load it.',Ye,X,Ve,P,Ql='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method won’t download files from the Hub when it detects a local path. But this also means it won’t download and cache any updates that have been made to the model either.',Fe,Q,Le,Y,Yl='Use the <code>torch_dtype</code> argument in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load a model with a specific data type. This allows you to load different models in different precisions. For example, loading a large transformer model in half-precision reduces the memory required.',Ne,V,Vl="Pass the data type for each model as a dictionary to <code>torch_dtype</code>. Use the <code>default</code> key to set the default data type. If a model isn’t in the dictionary and <code>default</code> isn’t provided, it is loaded in full precision (<code>torch.float32</code>).",qe,F,Se,L,Fl="You don’t need to use a dictionary if you’re loading all the models in the same data type.",De,N,ze,q,Ae,S,Ll="The <code>device_map</code> argument determines individual model or pipeline placement on an accelerator like a GPU. It is especially helpful when there are multiple GPUs.",Ke,D,Nl="A pipeline supports two options for <code>device_map</code>, <code>&quot;cuda&quot;</code> and <code>&quot;balanced&quot;</code>. Refer to the table below to compare the placement strategies.",Oe,z,ql="<thead><tr><th>parameter</th> <th>description</th></tr></thead> <tbody><tr><td><code>&quot;cuda&quot;</code></td> <td>places pipeline on a supported accelerator device like CUDA</td></tr> <tr><td><code>&quot;balanced&quot;</code></td> <td>evenly distributes pipeline on all GPUs</td></tr></tbody>",el,A,Sl='Use the <code>max_memory</code> argument in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to allocate a maximum amount of memory to use on each device. By default, Diffusers uses the maximum amount available.',ll,K,tl,O,Dl="The <code>hf_device_map</code> attribute allows you to access and view the <code>device_map</code>.",il,ee,sl,le,zl='Reset a pipeline’s <code>device_map</code> with the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.reset_device_map">reset_device_map()</a> method. This is necessary if you want to use methods such as <code>.to()</code>, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, and <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a>.',al,te,nl,ie,pl,se,Al='Large models are often <a href="../training/distributed_inference#model-sharding">sharded</a> into smaller files so that they are easier to load. Diffusers supports loading shards in parallel to speed up the loading process.',ol,ae,Kl="Set <code>HF_ENABLE_PARALLEL_LOADING</code> to <code>&quot;YES&quot;</code> to enable parallel loading of shards.",rl,ne,Ol="The <code>device_map</code> argument should be set to <code>&quot;cuda&quot;</code> to pre-allocate a large chunk of memory based on the model size. This substantially reduces model load time because warming up the memory allocator now avoids many smaller calls to the allocator later.",ml,pe,fl,oe,dl,re,et='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is flexible and accommodates loading different models or schedulers. You can experiment with different schedulers to optimize for generation speed or quality, and you can replace models with more performant ones.',ul,me,lt="The example below uses a more stable VAE version.",cl,fe,hl,de,Ml,ue,tt='When working with multiple pipelines that use the same model, the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method enables reusing a model instead of reloading it each time. This allows you to use multiple pipelines without increasing memory usage.',wl,ce,it="Memory usage is determined by the pipeline with the highest memory requirement regardless of the number of pipelines.",bl,he,st='The example below loads a pipeline and then loads a second pipeline with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> to use <a href="../api/pipelines/pag">perturbed-attention guidance (PAG)</a> to improve generation quality.',yl,T,Jl,Me,Tl,we,at="Set <code>enable_pag=True</code> in the second pipeline to enable PAG. The second pipeline uses the same amount of memory because it shares model weights with the first one.",gl,be,jl,g,Zl,ye,nt='Some methods may not work correctly on pipelines created with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a>. For example, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> relies on a unique model execution order, which may differ in the new pipeline. To ensure proper functionality, reapply these methods on the new pipeline.',Ul,Je,vl,Te,pt='Diffusers provides a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">safety checker</a> for older Stable Diffusion models to prevent generating harmful content. It screens the generated output against a set of hardcoded harmful concepts.',$l,ge,ot='If you want to disable the safety checker, pass <code>safety_checker=None</code> in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> as shown below.',Wl,je,Il,Ze,Gl,ve,_l;return j=new Tt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"}]}}),Z=new y({props:{title:"DiffusionPipeline",local:"diffusionpipeline",headingTag:"h1"}}),$=new y({props:{title:"Loading a pipeline",local:"loading-a-pipeline",headingTag:"h2"}}),G=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),x=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),E=new y({props:{title:"Local pipelines",local:"local-pipelines",headingTag:"h3"}}),C=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

snapshot_download(repo_id=<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>)`,wrap:!1}}),X=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJwYXRoJTJGdG8lMkZ5b3VyJTJGY2FjaGUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
  <span class="hljs-string">&quot;path/to/your/cache&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),Q=new y({props:{title:"Pipeline data types",local:"pipeline-data-types",headingTag:"h2"}}),F=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUwQSUyMCUyMHRvcmNoX2R0eXBlJTNEJTdCJTIydHJhbnNmb3JtZXIlMjIlM0ElMjB0b3JjaC5iZmxvYXQxNiUyQyUyMCUyMmRlZmF1bHQlMjIlM0ElMjB0b3JjaC5mbG9hdDE2JTdEJTJDJTBBKSUwQXByaW50KHBpcGVsaW5lLnRyYW5zZm9ybWVyLmR0eXBlJTJDJTIwcGlwZWxpbmUudmFlLmR0eXBlKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>,
  torch_dtype={<span class="hljs-string">&quot;transformer&quot;</span>: torch.bfloat16, <span class="hljs-string">&quot;default&quot;</span>: torch.float16},
)
<span class="hljs-built_in">print</span>(pipeline.transformer.dtype, pipeline.vae.dtype)`,wrap:!1}}),N=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcHJpbnQocGlwZWxpbmUudHJhbnNmb3JtZXIuZHR5cGUlMkMlMjBwaXBlbGluZS52YWUuZHR5cGUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16
)
<span class="hljs-built_in">print</span>(pipeline.transformer.dtype, pipeline.vae.dtype)`,wrap:!1}}),q=new y({props:{title:"Device placement",local:"device-placement",headingTag:"h2"}}),K=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtYXhfbWVtb3J5JTIwJTNEJTIwJTdCMCUzQSUyMCUyMjE2R0IlMjIlMkMlMjAxJTNBJTIwJTIyMTZHQiUyMiU3RCUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyJTJDJTIwJTBBJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

max_memory = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;16GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;16GB&quot;</span>}
pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, 
  torch_dtype=torch.bfloat16,
  device_map=<span class="hljs-string">&quot;cuda&quot;</span>,
)`,wrap:!1}}),ee=new w({props:{code:"cHJpbnQocGlwZWxpbmUuaGZfZGV2aWNlX21hcCklMEElMjMlMjAlN0IndW5ldCclM0ElMjAxJTJDJTIwJ3ZhZSclM0ElMjAxJTJDJTIwJ3NhZmV0eV9jaGVja2VyJyUzQSUyMDAlMkMlMjAndGV4dF9lbmNvZGVyJyUzQSUyMDAlN0Q=",highlighted:`<span class="hljs-built_in">print</span>(pipeline.hf_device_map)
<span class="hljs-comment"># {&#x27;unet&#x27;: 1, &#x27;vae&#x27;: 1, &#x27;safety_checker&#x27;: 0, &#x27;text_encoder&#x27;: 0}</span>`,wrap:!1}}),te=new w({props:{code:"cGlwZWxpbmUucmVzZXRfZGV2aWNlX21hcCgp",highlighted:"pipeline.reset_device_map()",wrap:!1}}),ie=new y({props:{title:"Parallel loading",local:"parallel-loading",headingTag:"h2"}}),pe=new w({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQW9zLmVudmlyb24lNUIlMjJIRl9FTkFCTEVfUEFSQUxMRUxfTE9BRElORyUyMiU1RCUyMCUzRCUyMCUyMllFUyUyMiUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMldhbi1BSSUyRldhbjIuMi1JMlYtQTE0Qi1EaWZmdXNlcnMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

os.environ[<span class="hljs-string">&quot;HF_ENABLE_PARALLEL_LOADING&quot;</span>] = <span class="hljs-string">&quot;YES&quot;</span>

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;Wan-AI/Wan2.2-I2V-A14B-Diffusers&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),oe=new y({props:{title:"Replacing models in a pipeline",local:"replacing-models-in-a-pipeline",headingTag:"h2"}}),fe=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBBdXRvTW9kZWwlMEElMEF2YWUlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMm1hZGVieW9sbGluJTJGc2R4bC12YWUtZnAxNi1maXglMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwdmFlJTNEdmFlJTJDJTBBJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, AutoModel

vae = AutoModel.from_pretrained(
  <span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16
)

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  vae=vae,
  torch_dtype=torch.float16,
  device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),de=new y({props:{title:"Reusing models in multiple pipelines",local:"reusing-models-in-multiple-pipelines",headingTag:"h2"}}),T=new ut({props:{warning:!0,$$slots:{default:[jt]},$$scope:{ctx:Ue}}}),Me=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQSUwQXBpcGVsaW5lX3NkeGwlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBzaXBwaW5nJTIwYSUyMG1hcmdhcml0YSUyMGluJTIwYSUyMHBvb2wlMjBpbiUyMFBhbG0lMjBTcHJpbmdzJTJDJTIwQ2FsaWZvcm5pYSUwQWhpZ2hseSUyMGRldGFpbGVkJTJDJTIwaGlnaCUyMGJ1ZGdldCUyMGhvbGx5d29vZCUyMG1vdmllJTJDJTIwY2luZW1hc2NvcGUlMkMlMjBtb29keSUyQyUyMGVwaWMlMkMlMjBnb3JnZW91cyUyQyUyMGZpbG0lMjBncmFpbiUwQSUyMiUyMiUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmVfc2R4bChwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFwcmludChmJTIyTWF4JTIwbWVtb3J5JTIwcmVzZXJ2ZWQlM0ElMjAlN0J0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCklMjAlMkYlMjAxMDI0KiozJTNBLjJmJTdEJTIwR0IlMjIpJTBBJTIzJTIwTWF4JTIwbWVtb3J5JTIwcmVzZXJ2ZWQlM0ElMjAxMC40NyUyMEdC",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image

pipeline_sdxl = AutoPipelineForText2Image.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
image = pipeline_sdxl(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
<span class="hljs-comment"># Max memory reserved: 10.47 GB</span>`,wrap:!1}}),be=new w({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcGlwZSglMEElMjAlMjBwaXBlbGluZV9zZHhsJTJDJTIwZW5hYmxlX3BhZyUzRFRydWUlMEEpJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwc2lwcGluZyUyMGElMjBtYXJnYXJpdGElMjBpbiUyMGElMjBwb29sJTIwaW4lMjBQYWxtJTIwU3ByaW5ncyUyQyUyMENhbGlmb3JuaWElMEFoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMEElMjIlMjIlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCkuaW1hZ2VzJTVCMCU1RCUwQXByaW50KGYlMjJNYXglMjBtZW1vcnklMjByZXNlcnZlZCUzQSUyMCU3QnRvcmNoLmN1ZGEubWF4X21lbW9yeV9hbGxvY2F0ZWQoKSUyMCUyRiUyMDEwMjQqKjMlM0EuMmYlN0QlMjBHQiUyMiklMEElMjMlMjBNYXglMjBtZW1vcnklMjByZXNlcnZlZCUzQSUyMDEwLjQ3JTIwR0I=",highlighted:`pipeline = AutoPipelineForText2Image.from_pipe(
  pipeline_sdxl, enable_pag=<span class="hljs-literal">True</span>
)
prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
image = pipeline(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
<span class="hljs-comment"># Max memory reserved: 10.47 GB</span>`,wrap:!1}}),g=new ut({props:{warning:!0,$$slots:{default:[Zt]},$$scope:{ctx:Ue}}}),Je=new y({props:{title:"Safety checker",local:"safety-checker",headingTag:"h2"}}),je=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTBBKSUwQSUyMiUyMiUyMiUwQVlvdSUyMGhhdmUlMjBkaXNhYmxlZCUyMHRoZSUyMHNhZmV0eSUyMGNoZWNrZXIlMjBmb3IlMjAlM0NjbGFzcyUyMCdkaWZmdXNlcnMucGlwZWxpbmVzLnN0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmVfc3RhYmxlX2RpZmZ1c2lvbi5TdGFibGVEaWZmdXNpb25QaXBlbGluZSclM0UlMjBieSUyMHBhc3NpbmclMjAlNjBzYWZldHlfY2hlY2tlciUzRE5vbmUlNjAuJTIwRW5zdXJlJTIwdGhhdCUyMHlvdSUyMGFiaWRlJTIwYnklMjB0aGUlMjBjb25kaXRpb25zJTIwb2YlMjB0aGUlMjBTdGFibGUlMjBEaWZmdXNpb24lMjBsaWNlbnNlJTIwYW5kJTIwZG8lMjBub3QlMjBleHBvc2UlMjB1bmZpbHRlcmVkJTIwcmVzdWx0cyUyMGluJTIwc2VydmljZXMlMjBvciUyMGFwcGxpY2F0aW9ucyUyMG9wZW4lMjB0byUyMHRoZSUyMHB1YmxpYy4lMjBCb3RoJTIwdGhlJTIwZGlmZnVzZXJzJTIwdGVhbSUyMGFuZCUyMEh1Z2dpbmclMjBGYWNlJTIwc3Ryb25nbHklMjByZWNvbW1lbmQlMjBrZWVwaW5nJTIwdGhlJTIwc2FmZXR5JTIwZmlsdGVyJTIwZW5hYmxlZCUyMGluJTIwYWxsJTIwcHVibGljLWZhY2luZyUyMGNpcmN1bXN0YW5jZXMlMkMlMjBkaXNhYmxpbmclMjBpdCUyMG9ubHklMjBmb3IlMjB1c2UlMjBjYXNlcyUyMHRoYXQlMjBpbnZvbHZlJTIwYW5hbHl6aW5nJTIwbmV0d29yayUyMGJlaGF2aW9yJTIwb3IlMjBhdWRpdGluZyUyMGl0cyUyMHJlc3VsdHMuJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTJDJTIwcGxlYXNlJTIwaGF2ZSUyMGElMjBsb29rJTIwYXQlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUyRnB1bGwlMkYyNTQlMjAuJTBBJTIyJTIyJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, safety_checker=<span class="hljs-literal">None</span>
)
<span class="hljs-string">&quot;&quot;&quot;
You have disabled the safety checker for &lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt; by passing \`safety_checker=None\`. Ensure that you abide by the conditions of the Stable Diffusion license and do not expose unfiltered results in services or applications open to the public. Both the diffusers team and Hugging Face strongly recommend keeping the safety filter enabled in all public-facing circumstances, disabling it only for use cases that involve analyzing network behavior or auditing its results. For more information, please have a look at https://github.com/huggingface/diffusers/pull/254 .
&quot;&quot;&quot;</span>`,wrap:!1}}),Ze=new gt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/loading.md"}}),{c(){h=n("meta"),b=s(),M=n("p"),J=s(),r(j.$$.fragment),$e=s(),r(Z.$$.fragment),We=s(),U=n("p"),U.innerHTML=Bl,Ie=s(),v=n("p"),v.innerHTML=kl,Ge=s(),r($.$$.fragment),_e=s(),W=n("p"),W.innerHTML=xl,Be=s(),I=n("p"),I.innerHTML=El,ke=s(),r(G.$$.fragment),xe=s(),_=n("p"),_.innerHTML=Hl,Ee=s(),B=n("table"),B.innerHTML=Cl,He=s(),k=n("p"),k.innerHTML=Rl,Ce=s(),r(x.$$.fragment),Re=s(),r(E.$$.fragment),Xe=s(),H=n("p"),H.innerHTML=Xl,Pe=s(),r(C.$$.fragment),Qe=s(),R=n("p"),R.innerHTML=Pl,Ye=s(),r(X.$$.fragment),Ve=s(),P=n("p"),P.innerHTML=Ql,Fe=s(),r(Q.$$.fragment),Le=s(),Y=n("p"),Y.innerHTML=Yl,Ne=s(),V=n("p"),V.innerHTML=Vl,qe=s(),r(F.$$.fragment),Se=s(),L=n("p"),L.textContent=Fl,De=s(),r(N.$$.fragment),ze=s(),r(q.$$.fragment),Ae=s(),S=n("p"),S.innerHTML=Ll,Ke=s(),D=n("p"),D.innerHTML=Nl,Oe=s(),z=n("table"),z.innerHTML=ql,el=s(),A=n("p"),A.innerHTML=Sl,ll=s(),r(K.$$.fragment),tl=s(),O=n("p"),O.innerHTML=Dl,il=s(),r(ee.$$.fragment),sl=s(),le=n("p"),le.innerHTML=zl,al=s(),r(te.$$.fragment),nl=s(),r(ie.$$.fragment),pl=s(),se=n("p"),se.innerHTML=Al,ol=s(),ae=n("p"),ae.innerHTML=Kl,rl=s(),ne=n("p"),ne.innerHTML=Ol,ml=s(),r(pe.$$.fragment),fl=s(),r(oe.$$.fragment),dl=s(),re=n("p"),re.innerHTML=et,ul=s(),me=n("p"),me.textContent=lt,cl=s(),r(fe.$$.fragment),hl=s(),r(de.$$.fragment),Ml=s(),ue=n("p"),ue.innerHTML=tt,wl=s(),ce=n("p"),ce.textContent=it,bl=s(),he=n("p"),he.innerHTML=st,yl=s(),r(T.$$.fragment),Jl=s(),r(Me.$$.fragment),Tl=s(),we=n("p"),we.innerHTML=at,gl=s(),r(be.$$.fragment),jl=s(),r(g.$$.fragment),Zl=s(),ye=n("p"),ye.innerHTML=nt,Ul=s(),r(Je.$$.fragment),vl=s(),Te=n("p"),Te.innerHTML=pt,$l=s(),ge=n("p"),ge.innerHTML=ot,Wl=s(),r(je.$$.fragment),Il=s(),r(Ze.$$.fragment),Gl=s(),ve=n("p"),this.h()},l(e){const l=yt("svelte-u9bgzb",document.head);h=p(l,"META",{name:!0,content:!0}),l.forEach(t),b=a(e),M=p(e,"P",{}),ft(M).forEach(t),J=a(e),m(j.$$.fragment,e),$e=a(e),m(Z.$$.fragment,e),We=a(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-15acv4d"&&(U.innerHTML=Bl),Ie=a(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1r7k4fu"&&(v.innerHTML=kl),Ge=a(e),m($.$$.fragment,e),_e=a(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-77vcgr"&&(W.innerHTML=xl),Be=a(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-ebiflz"&&(I.innerHTML=El),ke=a(e),m(G.$$.fragment,e),xe=a(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-18gmtm6"&&(_.innerHTML=Hl),Ee=a(e),B=p(e,"TABLE",{"data-svelte-h":!0}),o(B)!=="svelte-yqi7at"&&(B.innerHTML=Cl),He=a(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-7u1us2"&&(k.innerHTML=Rl),Ce=a(e),m(x.$$.fragment,e),Re=a(e),m(E.$$.fragment,e),Xe=a(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-12ybt7d"&&(H.innerHTML=Xl),Pe=a(e),m(C.$$.fragment,e),Qe=a(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-18vxmhu"&&(R.innerHTML=Pl),Ye=a(e),m(X.$$.fragment,e),Ve=a(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-km3nn9"&&(P.innerHTML=Ql),Fe=a(e),m(Q.$$.fragment,e),Le=a(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-ht6trw"&&(Y.innerHTML=Yl),Ne=a(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-xbxzon"&&(V.innerHTML=Vl),qe=a(e),m(F.$$.fragment,e),Se=a(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-17eskne"&&(L.textContent=Fl),De=a(e),m(N.$$.fragment,e),ze=a(e),m(q.$$.fragment,e),Ae=a(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-16dgqhw"&&(S.innerHTML=Ll),Ke=a(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-yjq2nu"&&(D.innerHTML=Nl),Oe=a(e),z=p(e,"TABLE",{"data-svelte-h":!0}),o(z)!=="svelte-1u6nxso"&&(z.innerHTML=ql),el=a(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-ssiv2x"&&(A.innerHTML=Sl),ll=a(e),m(K.$$.fragment,e),tl=a(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-jt67uv"&&(O.innerHTML=Dl),il=a(e),m(ee.$$.fragment,e),sl=a(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-17qp95k"&&(le.innerHTML=zl),al=a(e),m(te.$$.fragment,e),nl=a(e),m(ie.$$.fragment,e),pl=a(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-14tzv1s"&&(se.innerHTML=Al),ol=a(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-uz1jzg"&&(ae.innerHTML=Kl),rl=a(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-34lk0z"&&(ne.innerHTML=Ol),ml=a(e),m(pe.$$.fragment,e),fl=a(e),m(oe.$$.fragment,e),dl=a(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1ejgwxl"&&(re.innerHTML=et),ul=a(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1i6angb"&&(me.textContent=lt),cl=a(e),m(fe.$$.fragment,e),hl=a(e),m(de.$$.fragment,e),Ml=a(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-2i9f2r"&&(ue.innerHTML=tt),wl=a(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-fe2l13"&&(ce.textContent=it),bl=a(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-142eqve"&&(he.innerHTML=st),yl=a(e),m(T.$$.fragment,e),Jl=a(e),m(Me.$$.fragment,e),Tl=a(e),we=p(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-tea5ze"&&(we.innerHTML=at),gl=a(e),m(be.$$.fragment,e),jl=a(e),m(g.$$.fragment,e),Zl=a(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1iyxpvz"&&(ye.innerHTML=nt),Ul=a(e),m(Je.$$.fragment,e),vl=a(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-1fc5mnv"&&(Te.innerHTML=pt),$l=a(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-3onxuv"&&(ge.innerHTML=ot),Wl=a(e),m(je.$$.fragment,e),Il=a(e),m(Ze.$$.fragment,e),Gl=a(e),ve=p(e,"P",{}),ft(ve).forEach(t),this.h()},h(){dt(h,"name","hf:doc:metadata"),dt(h,"content",vt)},m(e,l){Jt(document.head,h),i(e,b,l),i(e,M,l),i(e,J,l),f(j,e,l),i(e,$e,l),f(Z,e,l),i(e,We,l),i(e,U,l),i(e,Ie,l),i(e,v,l),i(e,Ge,l),f($,e,l),i(e,_e,l),i(e,W,l),i(e,Be,l),i(e,I,l),i(e,ke,l),f(G,e,l),i(e,xe,l),i(e,_,l),i(e,Ee,l),i(e,B,l),i(e,He,l),i(e,k,l),i(e,Ce,l),f(x,e,l),i(e,Re,l),f(E,e,l),i(e,Xe,l),i(e,H,l),i(e,Pe,l),f(C,e,l),i(e,Qe,l),i(e,R,l),i(e,Ye,l),f(X,e,l),i(e,Ve,l),i(e,P,l),i(e,Fe,l),f(Q,e,l),i(e,Le,l),i(e,Y,l),i(e,Ne,l),i(e,V,l),i(e,qe,l),f(F,e,l),i(e,Se,l),i(e,L,l),i(e,De,l),f(N,e,l),i(e,ze,l),f(q,e,l),i(e,Ae,l),i(e,S,l),i(e,Ke,l),i(e,D,l),i(e,Oe,l),i(e,z,l),i(e,el,l),i(e,A,l),i(e,ll,l),f(K,e,l),i(e,tl,l),i(e,O,l),i(e,il,l),f(ee,e,l),i(e,sl,l),i(e,le,l),i(e,al,l),f(te,e,l),i(e,nl,l),f(ie,e,l),i(e,pl,l),i(e,se,l),i(e,ol,l),i(e,ae,l),i(e,rl,l),i(e,ne,l),i(e,ml,l),f(pe,e,l),i(e,fl,l),f(oe,e,l),i(e,dl,l),i(e,re,l),i(e,ul,l),i(e,me,l),i(e,cl,l),f(fe,e,l),i(e,hl,l),f(de,e,l),i(e,Ml,l),i(e,ue,l),i(e,wl,l),i(e,ce,l),i(e,bl,l),i(e,he,l),i(e,yl,l),f(T,e,l),i(e,Jl,l),f(Me,e,l),i(e,Tl,l),i(e,we,l),i(e,gl,l),f(be,e,l),i(e,jl,l),f(g,e,l),i(e,Zl,l),i(e,ye,l),i(e,Ul,l),f(Je,e,l),i(e,vl,l),i(e,Te,l),i(e,$l,l),i(e,ge,l),i(e,Wl,l),f(je,e,l),i(e,Il,l),f(Ze,e,l),i(e,Gl,l),i(e,ve,l),_l=!0},p(e,[l]){const rt={};l&2&&(rt.$$scope={dirty:l,ctx:e}),T.$set(rt);const mt={};l&2&&(mt.$$scope={dirty:l,ctx:e}),g.$set(mt)},i(e){_l||(d(j.$$.fragment,e),d(Z.$$.fragment,e),d($.$$.fragment,e),d(G.$$.fragment,e),d(x.$$.fragment,e),d(E.$$.fragment,e),d(C.$$.fragment,e),d(X.$$.fragment,e),d(Q.$$.fragment,e),d(F.$$.fragment,e),d(N.$$.fragment,e),d(q.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(oe.$$.fragment,e),d(fe.$$.fragment,e),d(de.$$.fragment,e),d(T.$$.fragment,e),d(Me.$$.fragment,e),d(be.$$.fragment,e),d(g.$$.fragment,e),d(Je.$$.fragment,e),d(je.$$.fragment,e),d(Ze.$$.fragment,e),_l=!0)},o(e){u(j.$$.fragment,e),u(Z.$$.fragment,e),u($.$$.fragment,e),u(G.$$.fragment,e),u(x.$$.fragment,e),u(E.$$.fragment,e),u(C.$$.fragment,e),u(X.$$.fragment,e),u(Q.$$.fragment,e),u(F.$$.fragment,e),u(N.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(oe.$$.fragment,e),u(fe.$$.fragment,e),u(de.$$.fragment,e),u(T.$$.fragment,e),u(Me.$$.fragment,e),u(be.$$.fragment,e),u(g.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u(Ze.$$.fragment,e),_l=!1},d(e){e&&(t(b),t(M),t(J),t($e),t(We),t(U),t(Ie),t(v),t(Ge),t(_e),t(W),t(Be),t(I),t(ke),t(xe),t(_),t(Ee),t(B),t(He),t(k),t(Ce),t(Re),t(Xe),t(H),t(Pe),t(Qe),t(R),t(Ye),t(Ve),t(P),t(Fe),t(Le),t(Y),t(Ne),t(V),t(qe),t(Se),t(L),t(De),t(ze),t(Ae),t(S),t(Ke),t(D),t(Oe),t(z),t(el),t(A),t(ll),t(tl),t(O),t(il),t(sl),t(le),t(al),t(nl),t(pl),t(se),t(ol),t(ae),t(rl),t(ne),t(ml),t(fl),t(dl),t(re),t(ul),t(me),t(cl),t(hl),t(Ml),t(ue),t(wl),t(ce),t(bl),t(he),t(yl),t(Jl),t(Tl),t(we),t(gl),t(jl),t(Zl),t(ye),t(Ul),t(vl),t(Te),t($l),t(ge),t(Wl),t(Il),t(Gl),t(ve)),t(h),c(j,e),c(Z,e),c($,e),c(G,e),c(x,e),c(E,e),c(C,e),c(X,e),c(Q,e),c(F,e),c(N,e),c(q,e),c(K,e),c(ee,e),c(te,e),c(ie,e),c(pe,e),c(oe,e),c(fe,e),c(de,e),c(T,e),c(Me,e),c(be,e),c(g,e),c(Je,e),c(je,e),c(Ze,e)}}}const vt='{"title":"DiffusionPipeline","local":"diffusionpipeline","sections":[{"title":"Loading a pipeline","local":"loading-a-pipeline","sections":[{"title":"Local pipelines","local":"local-pipelines","sections":[],"depth":3}],"depth":2},{"title":"Pipeline data types","local":"pipeline-data-types","sections":[],"depth":2},{"title":"Device placement","local":"device-placement","sections":[],"depth":2},{"title":"Parallel loading","local":"parallel-loading","sections":[],"depth":2},{"title":"Replacing models in a pipeline","local":"replacing-models-in-a-pipeline","sections":[],"depth":2},{"title":"Reusing models in multiple pipelines","local":"reusing-models-in-multiple-pipelines","sections":[],"depth":2},{"title":"Safety checker","local":"safety-checker","sections":[],"depth":2}],"depth":1}';function $t(Ue){return Mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends wt{constructor(h){super(),bt(this,h,$t,Ut,ht,{})}}export{xt as component};
