import{s as re,o as de,n as ie}from"../chunks/scheduler.8c3d61f6.js";import{S as me,i as pe,g as i,s as o,r as p,A as ce,h as r,f as l,c as s,j as oe,u as c,x as d,k as se,y as ue,a,v as u,d as h,t as f,w as y}from"../chunks/index.da70eac4.js";import{T as ne}from"../chunks/Tip.1d9b8c37.js";import{C as O}from"../chunks/CodeBlock.a9c4becf.js";import{H as Wt,E as he}from"../chunks/getInferenceSnippets.28ca3596.js";function fe(K){let n,M="The FP8 post-training quantization schemes in torchao are effective for GPUs with compute capability of at least 8.9 (RTX-4090, Hopper, etc.). FP8 often provides the best speed, memory, and quality trade-off when generating images and videos. We recommend combining FP8 and torch.compile if your GPU is compatible.";return{c(){n=i("p"),n.textContent=M},l(m){n=r(m,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1lf7ms9"&&(n.textContent=M)},m(m,w){a(m,n,w)},p:ie,d(m){m&&l(n)}}}function ye(K){let n,M='The <a href="/docs/diffusers/main/en/api/models/auto_model#diffusers.AutoModel">AutoModel</a> API is supported for PyTorch &gt;= 2.6 as shown in the examples below.';return{c(){n=i("p"),n.innerHTML=M},l(m){n=r(m,"P",{"data-svelte-h":!0}),d(n)!=="svelte-hh3qdm"&&(n.innerHTML=M)},m(m,w){a(m,n,w)},p:ie,d(m){m&&l(n)}}}function Me(K){let n,M,m,w,J,et,g,Gt='<a href="https://github.com/pytorch/ao" rel="nofollow">TorchAO</a> is an architecture optimization library for PyTorch. It provides high-performance dtypes, optimization techniques, and kernels for inference and training, featuring composability with native PyTorch features like <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a>, FullyShardedDataParallel (FSDP), and more.',lt,U,Xt="Before you begin, make sure you have Pytorch 2.5+ and TorchAO installed.",at,j,ot,_,kt='Quantize a model by passing <a href="/docs/diffusers/main/en/api/quantization#diffusers.TorchAoConfig">TorchAoConfig</a> to <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> (you can also load pre-quantized models). This works for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',st,Z,Rt="The example below only quantizes the weights to int8.",nt,v,it,q,Ht='TorchAO is fully compatible with <a href="../optimization/fp16#torchcompile">torch.compile</a>, setting it apart from other quantization methods. This makes it easy to speed up inference with just one line of code.',rt,x,dt,C,Ft='For speed and memory benchmarks on Flux and CogVideoX, please refer to the table <a href="https://github.com/huggingface/diffusers/pull/10009#issue-2688781450" rel="nofollow">here</a>. You can also find some torchao <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#benchmarks" rel="nofollow">benchmarks</a> numbers for various hardware.',mt,b,pt,B,Qt='torchao also supports an automatic quantization API through <a href="https://github.com/pytorch/ao/blob/main/torchao/quantization/README.md#autoquantization" rel="nofollow">autoquant</a>. Autoquantization determines the best quantization strategy applicable to a model by comparing the performance of each technique on chosen input types and shapes. Currently, this can be used directly on the underlying modeling components. Diffusers will also expose an autoquant configuration option in the future.',ct,$,Vt="The <code>TorchAoConfig</code> class accepts three parameters:",ut,z,Et='<li><code>quant_type</code>: A string value mentioning one of the quantization types below.</li> <li><code>modules_to_not_convert</code>: A list of module full/partial module names for which quantization should not be performed. For example, to not perform any quantization of the <a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>’s first block, one would specify: <code>modules_to_not_convert=[&quot;single_transformer_blocks.0&quot;]</code>.</li> <li><code>kwargs</code>: A dict of keyword arguments to pass to the underlying quantization method which will be invoked based on <code>quant_type</code>.</li>',ht,I,ft,W,Nt="torchao supports weight-only quantization and weight and dynamic-activation quantization for int8, float3-float8, and uint1-uint7.",yt,G,Yt="Weight-only quantization stores the model weights in a specific low-bit data type but performs computation with a higher-precision data type, like <code>bfloat16</code>. This lowers the memory requirements from model weights but retains the memory peaks for activation computation.",Mt,X,At="Dynamic activation quantization stores the model weights in a low-bit dtype, while also quantizing the activations on-the-fly to save additional memory. This lowers the memory requirements from model weights, while also lowering the memory overhead from activation computations. However, this may come at a quality tradeoff at times, so it is recommended to test different models thoroughly.",wt,k,Lt="The quantization methods supported are as follows:",bt,R,St="<thead><tr><th><strong>Category</strong></th> <th><strong>Full Function Names</strong></th> <th><strong>Shorthands</strong></th></tr></thead> <tbody><tr><td><strong>Integer quantization</strong></td> <td><code>int4_weight_only</code>, <code>int8_dynamic_activation_int4_weight</code>, <code>int8_weight_only</code>, <code>int8_dynamic_activation_int8_weight</code></td> <td><code>int4wo</code>, <code>int4dq</code>, <code>int8wo</code>, <code>int8dq</code></td></tr> <tr><td><strong>Floating point 8-bit quantization</strong></td> <td><code>float8_weight_only</code>, <code>float8_dynamic_activation_float8_weight</code>, <code>float8_static_activation_float8_weight</code></td> <td><code>float8wo</code>, <code>float8wo_e5m2</code>, <code>float8wo_e4m3</code>, <code>float8dq</code>, <code>float8dq_e4m3</code>, <code>float8dq_e4m3_tensor</code>, <code>float8dq_e4m3_row</code></td></tr> <tr><td><strong>Floating point X-bit quantization</strong></td> <td><code>fpx_weight_only</code></td> <td><code>fpX_eAwB</code> where <code>X</code> is the number of bits (1-7), <code>A</code> is exponent bits, and <code>B</code> is mantissa bits. Constraint: <code>X == A + B + 1</code></td></tr> <tr><td><strong>Unsigned Integer quantization</strong></td> <td><code>uintx_weight_only</code></td> <td><code>uint1wo</code>, <code>uint2wo</code>, <code>uint3wo</code>, <code>uint4wo</code>, <code>uint5wo</code>, <code>uint6wo</code>, <code>uint7wo</code></td></tr></tbody>",Tt,H,Pt="Some quantization methods are aliases (for example, <code>int8wo</code> is the commonly used shorthand for <code>int8_weight_only</code>). This allows using the quantization methods described in the torchao docs as-is, while also making it convenient to remember their shorthand notations.",Jt,F,Dt='Refer to the <a href="https://docs.pytorch.org/ao/stable/index.html" rel="nofollow">official torchao documentation</a> for a better understanding of the available quantization methods and the exhaustive list of configuration options available.',gt,Q,Ut,V,Kt='To serialize a quantized model in a given dtype, first load the model with the desired quantization dtype and then save it using the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a> method.',jt,E,_t,N,Ot='To load a serialized quantized model, use the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method.',Zt,Y,vt,A,te="If you are using <code>torch&lt;=2.6.0</code>, some quantization methods, such as <code>uint4wo</code>, cannot be loaded directly and may result in an <code>UnpicklingError</code> when trying to load the models, but work as expected when saving them. In order to work around this, one can load the state dict manually into the model. Note, however, that this requires using <code>weights_only=False</code> in <code>torch.load</code>, so it should be run only if the weights were obtained from a trustable source.",qt,L,xt,T,Ct,S,Bt,P,ee='<li><a href="https://docs.pytorch.org/ao/stable/index.html" rel="nofollow">TorchAO Quantization API</a></li> <li><a href="https://github.com/sayakpaul/diffusers-torchao" rel="nofollow">Diffusers-TorchAO examples</a></li>',$t,D,zt,tt,It;return J=new Wt({props:{title:"torchao",local:"torchao",headingTag:"h1"}}),j=new O({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwdG9yY2glMjB0b3JjaGFv",highlighted:"pip install -U torch torchao",wrap:!1}}),v=new O({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTJDJTIwQXV0b01vZGVsJTJDJTIwVG9yY2hBb0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTBBZHR5cGUlMjAlM0QlMjB0b3JjaC5iZmxvYXQxNiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBUb3JjaEFvQ29uZmlnKCUyMmludDh3byUyMiklMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0RkdHlwZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwRmx1eFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRGR0eXBlJTJDJTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBXaXRob3V0JTIwcXVhbnRpemF0aW9uJTNBJTIwfjMxLjQ0NyUyMEdCJTBBJTIzJTIwV2l0aCUyMHF1YW50aXphdGlvbiUzQSUyMH4yMC40MCUyMEdCJTBBcHJpbnQoZiUyMlBpcGVsaW5lJTIwbWVtb3J5JTIwdXNhZ2UlM0ElMjAlN0J0b3JjaC5jdWRhLm1heF9tZW1vcnlfcmVzZXJ2ZWQoKSUyMCUyRiUyMDEwMjQqKjMlM0EuM2YlN0QlMjBHQiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENC41JTJDJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyb3V0cHV0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, AutoModel, TorchAoConfig

model_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
dtype = torch.bfloat16

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int8wo&quot;</span>)
transformer = AutoModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=dtype,
)
pipe = FluxPipeline.from_pretrained(
    model_id,
    transformer=transformer,
    torch_dtype=dtype,
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Without quantization: ~31.447 GB</span>
<span class="hljs-comment"># With quantization: ~20.40 GB</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Pipeline memory usage: <span class="hljs-subst">{torch.cuda.max_memory_reserved() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.3</span>f}</span> GB&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">4.5</span>, max_sequence_length=<span class="hljs-number">512</span>
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),x=new O({props:{code:"JTIzJTIwSW4lMjB0aGUlMjBhYm92ZSUyMGNvZGUlMkMlMjBhZGQlMjB0aGUlMjBmb2xsb3dpbmclMjBhZnRlciUyMGluaXRpYWxpemluZyUyMHRoZSUyMHRyYW5zZm9ybWVyJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjB0b3JjaC5jb21waWxlKHRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUp",highlighted:`<span class="hljs-comment"># In the above code, add the following after initializing the transformer</span>
transformer = torch.<span class="hljs-built_in">compile</span>(transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),b=new ne({props:{warning:!1,$$slots:{default:[fe]},$$scope:{ctx:K}}}),I=new Wt({props:{title:"Supported quantization types",local:"supported-quantization-types",headingTag:"h2"}}),Q=new Wt({props:{title:"Serializing and Deserializing quantized models",local:"serializing-and-deserializing-quantized-models",headingTag:"h2"}}),E=new O({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwVG9yY2hBb0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBUb3JjaEFvQ29uZmlnKCUyMmludDh3byUyMiklMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGbHV4LjEtRGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBdHJhbnNmb3JtZXIuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfaW50OHdvJTIyJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNERmFsc2Up",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, TorchAoConfig

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int8wo&quot;</span>)
transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=torch.bfloat16,
)
transformer.save_pretrained(<span class="hljs-string">&quot;/path/to/flux_int8wo&quot;</span>, safe_serialization=<span class="hljs-literal">False</span>)`,wrap:!1}}),Y=new O({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTJDJTIwQXV0b01vZGVsJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfaW50OHdvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzREZhbHNlKSUwQXBpcGUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRmx1eC4xLURldiUyMiUyQyUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy4wKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, AutoModel

transformer = AutoModel.from_pretrained(<span class="hljs-string">&quot;/path/to/flux_int8wo&quot;</span>, torch_dtype=torch.bfloat16, use_safetensors=<span class="hljs-literal">False</span>)
pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>, transformer=transformer, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>, guidance_scale=<span class="hljs-number">7.0</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),L=new O({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMGluaXRfZW1wdHlfd2VpZ2h0cyUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBGbHV4UGlwZWxpbmUlMkMlMjBBdXRvTW9kZWwlMkMlMjBUb3JjaEFvQ29uZmlnJTBBJTBBJTIzJTIwU2VyaWFsaXplJTIwdGhlJTIwbW9kZWwlMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGbHV4LjEtRGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEVG9yY2hBb0NvbmZpZyglMjJ1aW50NHdvJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBdHJhbnNmb3JtZXIuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfdWludDR3byUyMiUyQyUyMHNhZmVfc2VyaWFsaXphdGlvbiUzREZhbHNlJTJDJTIwbWF4X3NoYXJkX3NpemUlM0QlMjI1MEdCJTIyKSUwQSUyMyUyMC4uLiUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBtb2RlbCUwQXN0YXRlX2RpY3QlMjAlM0QlMjB0b3JjaC5sb2FkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfdWludDR3byUyRmRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMHdlaWdodHNfb25seSUzREZhbHNlJTJDJTIwbWFwX2xvY2F0aW9uJTNEJTIyY3B1JTIyKSUwQXdpdGglMjBpbml0X2VtcHR5X3dlaWdodHMoKSUzQSUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fY29uZmlnKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfdWludDR3byUyRmNvbmZpZy5qc29uJTIyKSUwQXRyYW5zZm9ybWVyLmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0JTJDJTIwc3RyaWN0JTNEVHJ1ZSUyQyUyMGFzc2lnbiUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, AutoModel, TorchAoConfig

<span class="hljs-comment"># Serialize the model</span>
transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=TorchAoConfig(<span class="hljs-string">&quot;uint4wo&quot;</span>),
    torch_dtype=torch.bfloat16,
)
transformer.save_pretrained(<span class="hljs-string">&quot;/path/to/flux_uint4wo&quot;</span>, safe_serialization=<span class="hljs-literal">False</span>, max_shard_size=<span class="hljs-string">&quot;50GB&quot;</span>)
<span class="hljs-comment"># ...</span>

<span class="hljs-comment"># Load the model</span>
state_dict = torch.load(<span class="hljs-string">&quot;/path/to/flux_uint4wo/diffusion_pytorch_model.bin&quot;</span>, weights_only=<span class="hljs-literal">False</span>, map_location=<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-keyword">with</span> init_empty_weights():
    transformer = AutoModel.from_config(<span class="hljs-string">&quot;/path/to/flux_uint4wo/config.json&quot;</span>)
transformer.load_state_dict(state_dict, strict=<span class="hljs-literal">True</span>, assign=<span class="hljs-literal">True</span>)`,wrap:!1}}),T=new ne({props:{warning:!1,$$slots:{default:[ye]},$$scope:{ctx:K}}}),S=new Wt({props:{title:"Resources",local:"resources",headingTag:"h2"}}),D=new he({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/torchao.md"}}),{c(){n=i("meta"),M=o(),m=i("p"),w=o(),p(J.$$.fragment),et=o(),g=i("p"),g.innerHTML=Gt,lt=o(),U=i("p"),U.textContent=Xt,at=o(),p(j.$$.fragment),ot=o(),_=i("p"),_.innerHTML=kt,st=o(),Z=i("p"),Z.textContent=Rt,nt=o(),p(v.$$.fragment),it=o(),q=i("p"),q.innerHTML=Ht,rt=o(),p(x.$$.fragment),dt=o(),C=i("p"),C.innerHTML=Ft,mt=o(),p(b.$$.fragment),pt=o(),B=i("p"),B.innerHTML=Qt,ct=o(),$=i("p"),$.innerHTML=Vt,ut=o(),z=i("ul"),z.innerHTML=Et,ht=o(),p(I.$$.fragment),ft=o(),W=i("p"),W.textContent=Nt,yt=o(),G=i("p"),G.innerHTML=Yt,Mt=o(),X=i("p"),X.textContent=At,wt=o(),k=i("p"),k.textContent=Lt,bt=o(),R=i("table"),R.innerHTML=St,Tt=o(),H=i("p"),H.innerHTML=Pt,Jt=o(),F=i("p"),F.innerHTML=Dt,gt=o(),p(Q.$$.fragment),Ut=o(),V=i("p"),V.innerHTML=Kt,jt=o(),p(E.$$.fragment),_t=o(),N=i("p"),N.innerHTML=Ot,Zt=o(),p(Y.$$.fragment),vt=o(),A=i("p"),A.innerHTML=te,qt=o(),p(L.$$.fragment),xt=o(),p(T.$$.fragment),Ct=o(),p(S.$$.fragment),Bt=o(),P=i("ul"),P.innerHTML=ee,$t=o(),p(D.$$.fragment),zt=o(),tt=i("p"),this.h()},l(t){const e=ce("svelte-u9bgzb",document.head);n=r(e,"META",{name:!0,content:!0}),e.forEach(l),M=s(t),m=r(t,"P",{}),oe(m).forEach(l),w=s(t),c(J.$$.fragment,t),et=s(t),g=r(t,"P",{"data-svelte-h":!0}),d(g)!=="svelte-3zt1h"&&(g.innerHTML=Gt),lt=s(t),U=r(t,"P",{"data-svelte-h":!0}),d(U)!=="svelte-xmmcvn"&&(U.textContent=Xt),at=s(t),c(j.$$.fragment,t),ot=s(t),_=r(t,"P",{"data-svelte-h":!0}),d(_)!=="svelte-17lo0nz"&&(_.innerHTML=kt),st=s(t),Z=r(t,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1d14wga"&&(Z.textContent=Rt),nt=s(t),c(v.$$.fragment,t),it=s(t),q=r(t,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1gq6iie"&&(q.innerHTML=Ht),rt=s(t),c(x.$$.fragment,t),dt=s(t),C=r(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-exfnd4"&&(C.innerHTML=Ft),mt=s(t),c(b.$$.fragment,t),pt=s(t),B=r(t,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1fx3nq1"&&(B.innerHTML=Qt),ct=s(t),$=r(t,"P",{"data-svelte-h":!0}),d($)!=="svelte-1eoai4f"&&($.innerHTML=Vt),ut=s(t),z=r(t,"UL",{"data-svelte-h":!0}),d(z)!=="svelte-1m2mgoz"&&(z.innerHTML=Et),ht=s(t),c(I.$$.fragment,t),ft=s(t),W=r(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1dy3rwb"&&(W.textContent=Nt),yt=s(t),G=r(t,"P",{"data-svelte-h":!0}),d(G)!=="svelte-17x1tdo"&&(G.innerHTML=Yt),Mt=s(t),X=r(t,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1nbmql6"&&(X.textContent=At),wt=s(t),k=r(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-4xexxq"&&(k.textContent=Lt),bt=s(t),R=r(t,"TABLE",{"data-svelte-h":!0}),d(R)!=="svelte-1y0n94l"&&(R.innerHTML=St),Tt=s(t),H=r(t,"P",{"data-svelte-h":!0}),d(H)!=="svelte-1r64eqr"&&(H.innerHTML=Pt),Jt=s(t),F=r(t,"P",{"data-svelte-h":!0}),d(F)!=="svelte-6zfuzk"&&(F.innerHTML=Dt),gt=s(t),c(Q.$$.fragment,t),Ut=s(t),V=r(t,"P",{"data-svelte-h":!0}),d(V)!=="svelte-x34suv"&&(V.innerHTML=Kt),jt=s(t),c(E.$$.fragment,t),_t=s(t),N=r(t,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1km1qu3"&&(N.innerHTML=Ot),Zt=s(t),c(Y.$$.fragment,t),vt=s(t),A=r(t,"P",{"data-svelte-h":!0}),d(A)!=="svelte-1m61wn7"&&(A.innerHTML=te),qt=s(t),c(L.$$.fragment,t),xt=s(t),c(T.$$.fragment,t),Ct=s(t),c(S.$$.fragment,t),Bt=s(t),P=r(t,"UL",{"data-svelte-h":!0}),d(P)!=="svelte-ok3vq4"&&(P.innerHTML=ee),$t=s(t),c(D.$$.fragment,t),zt=s(t),tt=r(t,"P",{}),oe(tt).forEach(l),this.h()},h(){se(n,"name","hf:doc:metadata"),se(n,"content",we)},m(t,e){ue(document.head,n),a(t,M,e),a(t,m,e),a(t,w,e),u(J,t,e),a(t,et,e),a(t,g,e),a(t,lt,e),a(t,U,e),a(t,at,e),u(j,t,e),a(t,ot,e),a(t,_,e),a(t,st,e),a(t,Z,e),a(t,nt,e),u(v,t,e),a(t,it,e),a(t,q,e),a(t,rt,e),u(x,t,e),a(t,dt,e),a(t,C,e),a(t,mt,e),u(b,t,e),a(t,pt,e),a(t,B,e),a(t,ct,e),a(t,$,e),a(t,ut,e),a(t,z,e),a(t,ht,e),u(I,t,e),a(t,ft,e),a(t,W,e),a(t,yt,e),a(t,G,e),a(t,Mt,e),a(t,X,e),a(t,wt,e),a(t,k,e),a(t,bt,e),a(t,R,e),a(t,Tt,e),a(t,H,e),a(t,Jt,e),a(t,F,e),a(t,gt,e),u(Q,t,e),a(t,Ut,e),a(t,V,e),a(t,jt,e),u(E,t,e),a(t,_t,e),a(t,N,e),a(t,Zt,e),u(Y,t,e),a(t,vt,e),a(t,A,e),a(t,qt,e),u(L,t,e),a(t,xt,e),u(T,t,e),a(t,Ct,e),u(S,t,e),a(t,Bt,e),a(t,P,e),a(t,$t,e),u(D,t,e),a(t,zt,e),a(t,tt,e),It=!0},p(t,[e]){const le={};e&2&&(le.$$scope={dirty:e,ctx:t}),b.$set(le);const ae={};e&2&&(ae.$$scope={dirty:e,ctx:t}),T.$set(ae)},i(t){It||(h(J.$$.fragment,t),h(j.$$.fragment,t),h(v.$$.fragment,t),h(x.$$.fragment,t),h(b.$$.fragment,t),h(I.$$.fragment,t),h(Q.$$.fragment,t),h(E.$$.fragment,t),h(Y.$$.fragment,t),h(L.$$.fragment,t),h(T.$$.fragment,t),h(S.$$.fragment,t),h(D.$$.fragment,t),It=!0)},o(t){f(J.$$.fragment,t),f(j.$$.fragment,t),f(v.$$.fragment,t),f(x.$$.fragment,t),f(b.$$.fragment,t),f(I.$$.fragment,t),f(Q.$$.fragment,t),f(E.$$.fragment,t),f(Y.$$.fragment,t),f(L.$$.fragment,t),f(T.$$.fragment,t),f(S.$$.fragment,t),f(D.$$.fragment,t),It=!1},d(t){t&&(l(M),l(m),l(w),l(et),l(g),l(lt),l(U),l(at),l(ot),l(_),l(st),l(Z),l(nt),l(it),l(q),l(rt),l(dt),l(C),l(mt),l(pt),l(B),l(ct),l($),l(ut),l(z),l(ht),l(ft),l(W),l(yt),l(G),l(Mt),l(X),l(wt),l(k),l(bt),l(R),l(Tt),l(H),l(Jt),l(F),l(gt),l(Ut),l(V),l(jt),l(_t),l(N),l(Zt),l(vt),l(A),l(qt),l(xt),l(Ct),l(Bt),l(P),l($t),l(zt),l(tt)),l(n),y(J,t),y(j,t),y(v,t),y(x,t),y(b,t),y(I,t),y(Q,t),y(E,t),y(Y,t),y(L,t),y(T,t),y(S,t),y(D,t)}}}const we='{"title":"torchao","local":"torchao","sections":[{"title":"Supported quantization types","local":"supported-quantization-types","sections":[],"depth":2},{"title":"Serializing and Deserializing quantized models","local":"serializing-and-deserializing-quantized-models","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function be(K){return de(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _e extends me{constructor(n){super(),pe(this,n,be,Me,re,{})}}export{_e as component};
