import{s as Je,n as Te,o as be}from"../chunks/scheduler.8c3d61f6.js";import{S as _e,i as ke,g as n,s as a,r as c,A as Ue,h as p,f as s,c as i,j as we,u as M,x as o,k as he,y as Be,a as t,v as d,d as u,t as f,w as m}from"../chunks/index.da70eac4.js";import{C as ie}from"../chunks/CodeBlock.a9c4becf.js";import{H as ne,E as Ie}from"../chunks/getInferenceSnippets.28ca3596.js";function Ce(pe){let r,Y,Z,H,y,q,j,oe='<a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.modular_pipelines.LoopSequentialPipelineBlocks">LoopSequentialPipelineBlocks</a> are a multi-block type that composes other <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> together in a loop. Data flows circularly, using <code>intermediate_inputs</code> and <code>intermediate_outputs</code>, and each block is run iteratively. This is typically used to create a denoising loop which is iterative by default.',g,w,re='This guide shows you how to create <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.modular_pipelines.LoopSequentialPipelineBlocks">LoopSequentialPipelineBlocks</a>.',P,h,R,J,ce='<a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.modular_pipelines.LoopSequentialPipelineBlocks">LoopSequentialPipelineBlocks</a>, is also known as the <em>loop wrapper</em> because it defines the loop structure, iteration variables, and configuration. Within the loop wrapper, you need the following variables.',x,T,Me='<li><code>loop_inputs</code> are user provided values and equivalent to <code>inputs</code>.</li> <li><code>loop_intermediate_inputs</code> are intermediate variables from the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a> and equivalent to <code>~modular_pipelines.ModularPipelineBlocks.intermediate_inputs</code>.</li> <li><code>loop_intermediate_outputs</code> are new intermediate variables created by the block and added to the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a>. It is equivalent to <code>intermediate_outputs</code>.</li> <li><code>__call__</code> method defines the loop structure and iteration logic.</li>',E,b,Q,_,de="The loop wrapper can pass additional arguments, like current iteration index, to the loop blocks.",V,k,N,U,ue='A loop block is a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a>, but the <code>__call__</code> method behaves differently.',W,B,fe='<li>It recieves the iteration variable from the loop wrapper.</li> <li>It works directly with the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.BlockState">BlockState</a> instead of the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a>.</li> <li>It doesn’t require retrieving or updating the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.BlockState">BlockState</a>.</li>',z,I,me='Loop blocks share the same <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.BlockState">BlockState</a> to allow values to accumulate and change for each iteration in the loop.',F,C,K,A,D,v,ye='Use the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.modular_pipelines.LoopSequentialPipelineBlocks.from_blocks_dict">from_blocks_dict()</a> method to add the loop block to the loop wrapper to create <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.modular_pipelines.LoopSequentialPipelineBlocks">LoopSequentialPipelineBlocks</a>.',O,$,ee,G,je='Add more loop blocks to run within each iteration with <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.modular_pipelines.LoopSequentialPipelineBlocks.from_blocks_dict">from_blocks_dict()</a>. This allows you to modify the blocks without changing the loop logic itself.',le,S,se,X,te,L,ae;return y=new ne({props:{title:"LoopSequentialPipelineBlocks",local:"loopsequentialpipelineblocks",headingTag:"h1"}}),h=new ne({props:{title:"Loop wrapper",local:"loop-wrapper",headingTag:"h2"}}),b=new ie({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwTG9vcFNlcXVlbnRpYWxQaXBlbGluZUJsb2NrcyUyQyUyME1vZHVsYXJQaXBlbGluZUJsb2NrcyUyQyUyMElucHV0UGFyYW0lMkMlMjBPdXRwdXRQYXJhbSUwQSUwQWNsYXNzJTIwTG9vcFdyYXBwZXIoTG9vcFNlcXVlbnRpYWxQaXBlbGluZUJsb2NrcyklM0ElMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTIwJTNEJTIwJTIydGVzdCUyMiUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwZGVzY3JpcHRpb24oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJJJ20lMjBhJTIwbG9vcCEhJTIyJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBsb29wX2lucHV0cyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1QklucHV0UGFyYW0obmFtZSUzRCUyMm51bV9zdGVwcyUyMiklNUQlMEElMjAlMjAlMjAlMjAlNDB0b3JjaC5ub19ncmFkKCklMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwY29tcG9uZW50cyUyQyUyMHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX3N0YXRlJTIwJTNEJTIwc2VsZi5nZXRfYmxvY2tfc3RhdGUoc3RhdGUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTG9vcCUyMHN0cnVjdHVyZSUyMC0lMjBjYW4lMjBiZSUyMGN1c3RvbWl6ZWQlMjB0byUyMHlvdXIlMjBuZWVkcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGJsb2NrX3N0YXRlLm51bV9zdGVwcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBsb29wX3N0ZXAlMjBleGVjdXRlcyUyMGFsbCUyMHJlZ2lzdGVyZWQlMjBibG9ja3MlMjBpbiUyMHNlcXVlbmNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29tcG9uZW50cyUyQyUyMGJsb2NrX3N0YXRlJTIwJTNEJTIwc2VsZi5sb29wX3N0ZXAoY29tcG9uZW50cyUyQyUyMGJsb2NrX3N0YXRlJTJDJTIwaSUzRGkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5zZXRfYmxvY2tfc3RhdGUoc3RhdGUlMkMlMjBibG9ja19zdGF0ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBjb21wb25lbnRzJTJDJTIwc3RhdGU=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> LoopSequentialPipelineBlocks, ModularPipelineBlocks, InputParam, OutputParam

<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopWrapper</span>(<span class="hljs-title class_ inherited__">LoopSequentialPipelineBlocks</span>):
    model_name = <span class="hljs-string">&quot;test&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;I&#x27;m a loop!!&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">loop_inputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> [InputParam(name=<span class="hljs-string">&quot;num_steps&quot;</span>)]
<span class="hljs-meta">    @torch.no_grad()</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
        block_state = self.get_block_state(state)
        <span class="hljs-comment"># Loop structure - can be customized to your needs</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(block_state.num_steps):
            <span class="hljs-comment"># loop_step executes all registered blocks in sequence</span>
            components, block_state = self.loop_step(components, block_state, i=i)
        self.set_block_state(state, block_state)
        <span class="hljs-keyword">return</span> components, state`,wrap:!1}}),k=new ne({props:{title:"Loop blocks",local:"loop-blocks",headingTag:"h2"}}),C=new ie({props:{code:"Y2xhc3MlMjBMb29wQmxvY2soTW9kdWxhclBpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMjAlM0QlMjAlMjJ0ZXN0JTIyJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBpbnB1dHMoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJJbnB1dFBhcmFtKG5hbWUlM0QlMjJ4JTIyKSU1RCUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwaW50ZXJtZWRpYXRlX291dHB1dHMoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBvdXRwdXRzJTIwcHJvZHVjZWQlMjBieSUyMHRoaXMlMjBibG9jayUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1Qk91dHB1dFBhcmFtKG5hbWUlM0QlMjJ4JTIyKSU1RCUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwZGVzY3JpcHRpb24oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJJJ20lMjBhJTIwYmxvY2slMjB1c2VkJTIwaW5zaWRlJTIwdGhlJTIwJTYwTG9vcFdyYXBwZXIlNjAlMjBjbGFzcyUyMiUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYlMkMlMjBjb21wb25lbnRzJTJDJTIwYmxvY2tfc3RhdGUlMkMlMjBpJTNBJTIwaW50KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX3N0YXRlLnglMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwY29tcG9uZW50cyUyQyUyMGJsb2NrX3N0YXRl",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopBlock</span>(<span class="hljs-title class_ inherited__">ModularPipelineBlocks</span>):
    model_name = <span class="hljs-string">&quot;test&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> [InputParam(name=<span class="hljs-string">&quot;x&quot;</span>)]
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">intermediate_outputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-comment"># outputs produced by this block</span>
        <span class="hljs-keyword">return</span> [OutputParam(name=<span class="hljs-string">&quot;x&quot;</span>)]
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;I&#x27;m a block used inside the \`LoopWrapper\` class&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, block_state, i: <span class="hljs-built_in">int</span></span>):
        block_state.x += <span class="hljs-number">1</span>
        <span class="hljs-keyword">return</span> components, block_state`,wrap:!1}}),A=new ne({props:{title:"LoopSequentialPipelineBlocks",local:"loopsequentialpipelineblocks",headingTag:"h2"}}),$=new ie({props:{code:"bG9vcCUyMCUzRCUyMExvb3BXcmFwcGVyLmZyb21fYmxvY2tzX2RpY3QoJTdCJTIyYmxvY2sxJTIyJTNBJTIwTG9vcEJsb2NrJTdEKQ==",highlighted:'loop = LoopWrapper.from_blocks_dict({<span class="hljs-string">&quot;block1&quot;</span>: LoopBlock})',wrap:!1}}),S=new ie({props:{code:"bG9vcCUyMCUzRCUyMExvb3BXcmFwcGVyLmZyb21fYmxvY2tzX2RpY3QoJTdCJTIyYmxvY2sxJTIyJTNBJTIwTG9vcEJsb2NrKCklMkMlMjAlMjJibG9jazIlMjIlM0ElMjBMb29wQmxvY2slN0Qp",highlighted:'loop = LoopWrapper.from_blocks_dict({<span class="hljs-string">&quot;block1&quot;</span>: LoopBlock(), <span class="hljs-string">&quot;block2&quot;</span>: LoopBlock})',wrap:!1}}),X=new Ie({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/loop_sequential_pipeline_blocks.md"}}),{c(){r=n("meta"),Y=a(),Z=n("p"),H=a(),c(y.$$.fragment),q=a(),j=n("p"),j.innerHTML=oe,g=a(),w=n("p"),w.innerHTML=re,P=a(),c(h.$$.fragment),R=a(),J=n("p"),J.innerHTML=ce,x=a(),T=n("ul"),T.innerHTML=Me,E=a(),c(b.$$.fragment),Q=a(),_=n("p"),_.textContent=de,V=a(),c(k.$$.fragment),N=a(),U=n("p"),U.innerHTML=ue,W=a(),B=n("ul"),B.innerHTML=fe,z=a(),I=n("p"),I.innerHTML=me,F=a(),c(C.$$.fragment),K=a(),c(A.$$.fragment),D=a(),v=n("p"),v.innerHTML=ye,O=a(),c($.$$.fragment),ee=a(),G=n("p"),G.innerHTML=je,le=a(),c(S.$$.fragment),se=a(),c(X.$$.fragment),te=a(),L=n("p"),this.h()},l(e){const l=Ue("svelte-u9bgzb",document.head);r=p(l,"META",{name:!0,content:!0}),l.forEach(s),Y=i(e),Z=p(e,"P",{}),we(Z).forEach(s),H=i(e),M(y.$$.fragment,e),q=i(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1pt4lhn"&&(j.innerHTML=oe),g=i(e),w=p(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1wqgw9f"&&(w.innerHTML=re),P=i(e),M(h.$$.fragment,e),R=i(e),J=p(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1si1dnb"&&(J.innerHTML=ce),x=i(e),T=p(e,"UL",{"data-svelte-h":!0}),o(T)!=="svelte-zv9pv4"&&(T.innerHTML=Me),E=i(e),M(b.$$.fragment,e),Q=i(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-ldw13v"&&(_.textContent=de),V=i(e),M(k.$$.fragment,e),N=i(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-joy4ry"&&(U.innerHTML=ue),W=i(e),B=p(e,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-gibq50"&&(B.innerHTML=fe),z=i(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-nmx27c"&&(I.innerHTML=me),F=i(e),M(C.$$.fragment,e),K=i(e),M(A.$$.fragment,e),D=i(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-urqqyp"&&(v.innerHTML=ye),O=i(e),M($.$$.fragment,e),ee=i(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-b9s2t6"&&(G.innerHTML=je),le=i(e),M(S.$$.fragment,e),se=i(e),M(X.$$.fragment,e),te=i(e),L=p(e,"P",{}),we(L).forEach(s),this.h()},h(){he(r,"name","hf:doc:metadata"),he(r,"content",Ae)},m(e,l){Be(document.head,r),t(e,Y,l),t(e,Z,l),t(e,H,l),d(y,e,l),t(e,q,l),t(e,j,l),t(e,g,l),t(e,w,l),t(e,P,l),d(h,e,l),t(e,R,l),t(e,J,l),t(e,x,l),t(e,T,l),t(e,E,l),d(b,e,l),t(e,Q,l),t(e,_,l),t(e,V,l),d(k,e,l),t(e,N,l),t(e,U,l),t(e,W,l),t(e,B,l),t(e,z,l),t(e,I,l),t(e,F,l),d(C,e,l),t(e,K,l),d(A,e,l),t(e,D,l),t(e,v,l),t(e,O,l),d($,e,l),t(e,ee,l),t(e,G,l),t(e,le,l),d(S,e,l),t(e,se,l),d(X,e,l),t(e,te,l),t(e,L,l),ae=!0},p:Te,i(e){ae||(u(y.$$.fragment,e),u(h.$$.fragment,e),u(b.$$.fragment,e),u(k.$$.fragment,e),u(C.$$.fragment,e),u(A.$$.fragment,e),u($.$$.fragment,e),u(S.$$.fragment,e),u(X.$$.fragment,e),ae=!0)},o(e){f(y.$$.fragment,e),f(h.$$.fragment,e),f(b.$$.fragment,e),f(k.$$.fragment,e),f(C.$$.fragment,e),f(A.$$.fragment,e),f($.$$.fragment,e),f(S.$$.fragment,e),f(X.$$.fragment,e),ae=!1},d(e){e&&(s(Y),s(Z),s(H),s(q),s(j),s(g),s(w),s(P),s(R),s(J),s(x),s(T),s(E),s(Q),s(_),s(V),s(N),s(U),s(W),s(B),s(z),s(I),s(F),s(K),s(D),s(v),s(O),s(ee),s(G),s(le),s(se),s(te),s(L)),s(r),m(y,e),m(h,e),m(b,e),m(k,e),m(C,e),m(A,e),m($,e),m(S,e),m(X,e)}}}const Ae='{"title":"LoopSequentialPipelineBlocks","local":"loopsequentialpipelineblocks","sections":[{"title":"Loop wrapper","local":"loop-wrapper","sections":[],"depth":2},{"title":"Loop blocks","local":"loop-blocks","sections":[],"depth":2},{"title":"LoopSequentialPipelineBlocks","local":"loopsequentialpipelineblocks","sections":[],"depth":2}],"depth":1}';function ve(pe){return be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends _e{constructor(r){super(),ke(this,r,ve,Ce,Je,{})}}export{Ze as component};
