import{s as vt,o as Jt,n as Se}from"../chunks/scheduler.8c3d61f6.js";import{S as Ut,i as It,g as d,s as i,r as g,A as Wt,h as c,f as t,c as a,j as v,u,x as T,k as J,y as s,a as p,v as f,d as h,t as _,w as y}from"../chunks/index.da70eac4.js";import{T as Zt}from"../chunks/Tip.1d9b8c37.js";import{D as G}from"../chunks/Docstring.91dd4639.js";import{C as De}from"../chunks/CodeBlock.a9c4becf.js";import{E as Ae}from"../chunks/ExampleCodeBlock.d368b7c4.js";import{H as K,E as jt}from"../chunks/getInferenceSnippets.28ca3596.js";function xt(j){let r,w='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){r=d("p"),r.innerHTML=w},l(m){r=c(m,"P",{"data-svelte-h":!0}),T(r)!=="svelte-1qn15hi"&&(r.innerHTML=w)},m(m,l){p(m,r,l)},p:Se,d(m){m&&t(r)}}}function Gt(j){let r,w="Examples:",m,l,b;return l=new De({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29zbW9zVGV4dFRvV29ybGRQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm52aWRpYSUyRkNvc21vcy0xLjAtRGlmZnVzaW9uLTdCLVRleHQyV29ybGQlMjIlMEFwaXBlJTIwJTNEJTIwQ29zbW9zVGV4dFRvV29ybGRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwc2xlZWslMkMlMjBodW1hbm9pZCUyMHJvYm90JTIwc3RhbmRzJTIwaW4lMjBhJTIwdmFzdCUyMHdhcmVob3VzZSUyMGZpbGxlZCUyMHdpdGglMjBuZWF0bHklMjBzdGFja2VkJTIwY2FyZGJvYXJkJTIwYm94ZXMlMjBvbiUyMGluZHVzdHJpYWwlMjBzaGVsdmVzLiUyMFRoZSUyMHJvYm90J3MlMjBtZXRhbGxpYyUyMGJvZHklMjBnbGVhbXMlMjB1bmRlciUyMHRoZSUyMGJyaWdodCUyQyUyMGV2ZW4lMjBsaWdodGluZyUyQyUyMGhpZ2hsaWdodGluZyUyMGl0cyUyMGZ1dHVyaXN0aWMlMjBkZXNpZ24lMjBhbmQlMjBpbnRyaWNhdGUlMjBqb2ludHMuJTIwQSUyMGdsb3dpbmclMjBibHVlJTIwbGlnaHQlMjBlbWFuYXRlcyUyMGZyb20lMjBpdHMlMjBjaGVzdCUyQyUyMGFkZGluZyUyMGElMjB0b3VjaCUyMG9mJTIwYWR2YW5jZWQlMjB0ZWNobm9sb2d5LiUyMFRoZSUyMGJhY2tncm91bmQlMjBpcyUyMGRvbWluYXRlZCUyMGJ5JTIwcm93cyUyMG9mJTIwYm94ZXMlMkMlMjBzdWdnZXN0aW5nJTIwYSUyMGhpZ2hseSUyMG9yZ2FuaXplZCUyMHN0b3JhZ2UlMjBzeXN0ZW0uJTIwVGhlJTIwZmxvb3IlMjBpcyUyMGxpbmVkJTIwd2l0aCUyMHdvb2RlbiUyMHBhbGxldHMlMkMlMjBlbmhhbmNpbmclMjB0aGUlMjBpbmR1c3RyaWFsJTIwc2V0dGluZy4lMjBUaGUlMjBjYW1lcmElMjByZW1haW5zJTIwc3RhdGljJTJDJTIwY2FwdHVyaW5nJTIwdGhlJTIwcm9ib3QncyUyMHBvaXNlZCUyMHN0YW5jZSUyMGFtaWRzdCUyMHRoZSUyMG9yZGVybHklMjBlbnZpcm9ubWVudCUyQyUyMHdpdGglMjBhJTIwc2hhbGxvdyUyMGRlcHRoJTIwb2YlMjBmaWVsZCUyMHRoYXQlMjBrZWVwcyUyMHRoZSUyMGZvY3VzJTIwb24lMjB0aGUlMjByb2JvdCUyMHdoaWxlJTIwc3VidGx5JTIwYmx1cnJpbmclMjB0aGUlMjBiYWNrZ3JvdW5kJTIwZm9yJTIwYSUyMGNpbmVtYXRpYyUyMGVmZmVjdC4lMjIlMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyhvdXRwdXQlMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEMzAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CosmosTextToWorldPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;nvidia/Cosmos-1.0-Diffusion-7B-Text2World&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CosmosTextToWorldPipeline.from_pretrained(model_id, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A sleek, humanoid robot stands in a vast warehouse filled with neatly stacked cardboard boxes on industrial shelves. The robot&#x27;s metallic body gleams under the bright, even lighting, highlighting its futuristic design and intricate joints. A glowing blue light emanates from its chest, adding a touch of advanced technology. The background is dominated by rows of boxes, suggesting a highly organized storage system. The floor is lined with wooden pallets, enhancing the industrial setting. The camera remains static, capturing the robot&#x27;s poised stance amidst the orderly environment, with a shallow depth of field that keeps the focus on the robot while subtly blurring the background for a cinematic effect.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(prompt=prompt).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),{c(){r=d("p"),r.textContent=w,m=i(),g(l.$$.fragment)},l(o){r=c(o,"P",{"data-svelte-h":!0}),T(r)!=="svelte-kvfsh7"&&(r.textContent=w),m=a(o),u(l.$$.fragment,o)},m(o,M){p(o,r,M),p(o,m,M),f(l,o,M),b=!0},p:Se,i(o){b||(h(l.$$.fragment,o),b=!0)},o(o){_(l.$$.fragment,o),b=!1},d(o){o&&(t(r),t(m)),y(l,o)}}}function Ct(j){let r,w="Image conditioning:",m,l,b;return l=new De({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29zbW9zVmlkZW9Ub1dvcmxkUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF9pbWFnZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybnZpZGlhJTJGQ29zbW9zLTEuMC1EaWZmdXNpb24tN0ItVmlkZW8yV29ybGQlMjIlMEFwaXBlJTIwJTNEJTIwQ29zbW9zVmlkZW9Ub1dvcmxkUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVGhlJTIwdmlkZW8lMjBkZXBpY3RzJTIwYSUyMGxvbmclMkMlMjBzdHJhaWdodCUyMGhpZ2h3YXklMjBzdHJldGNoaW5nJTIwaW50byUyMHRoZSUyMGRpc3RhbmNlJTJDJTIwZmxhbmtlZCUyMGJ5JTIwbWV0YWwlMjBndWFyZHJhaWxzLiUyMFRoZSUyMHJvYWQlMjBpcyUyMGRpdmlkZWQlMjBpbnRvJTIwbXVsdGlwbGUlMjBsYW5lcyUyQyUyMHdpdGglMjBhJTIwZmV3JTIwdmVoaWNsZXMlMjB2aXNpYmxlJTIwaW4lMjB0aGUlMjBmYXIlMjBkaXN0YW5jZS4lMjBUaGUlMjBzdXJyb3VuZGluZyUyMGxhbmRzY2FwZSUyMGZlYXR1cmVzJTIwZHJ5JTJDJTIwZ3Jhc3N5JTIwZmllbGRzJTIwb24lMjBvbmUlMjBzaWRlJTIwYW5kJTIwcm9sbGluZyUyMGhpbGxzJTIwb24lMjB0aGUlMjBvdGhlci4lMjBUaGUlMjBza3klMjBpcyUyMG1vc3RseSUyMGNsZWFyJTIwd2l0aCUyMGElMjBmZXclMjBzY2F0dGVyZWQlMjBjbG91ZHMlMkMlMjBzdWdnZXN0aW5nJTIwYSUyMGJyaWdodCUyQyUyMHN1bm55JTIwZGF5LiUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb3Ntb3MlMkZjb3Ntb3MtdmlkZW8yd29ybGQtaW5wdXQuanBnJTIyJTBBKSUwQSUwQXZpZGVvJTIwJTNEJTIwcGlwZShpbWFnZSUzRGltYWdlJTJDJTIwcHJvbXB0JTNEcHJvbXB0KS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDMwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CosmosVideoToWorldPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;nvidia/Cosmos-1.0-Diffusion-7B-Video2World&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CosmosVideoToWorldPipeline.from_pretrained(model_id, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;The video depicts a long, straight highway stretching into the distance, flanked by metal guardrails. The road is divided into multiple lanes, with a few vehicles visible in the far distance. The surrounding landscape features dry, grassy fields on one side and rolling hills on the other. The sky is mostly clear with a few scattered clouds, suggesting a bright, sunny day.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cosmos/cosmos-video2world-input.jpg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(image=image, prompt=prompt).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),{c(){r=d("p"),r.textContent=w,m=i(),g(l.$$.fragment)},l(o){r=c(o,"P",{"data-svelte-h":!0}),T(r)!=="svelte-187s8ri"&&(r.textContent=w),m=a(o),u(l.$$.fragment,o)},m(o,M){p(o,r,M),p(o,m,M),f(l,o,M),b=!0},p:Se,i(o){b||(h(l.$$.fragment,o),b=!0)},o(o){_(l.$$.fragment,o),b=!1},d(o){o&&(t(r),t(m)),y(l,o)}}}function kt(j){let r,w="Video conditioning:",m,l,b;return l=new De({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29zbW9zVmlkZW9Ub1dvcmxkUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF92aWRlbyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybnZpZGlhJTJGQ29zbW9zLTEuMC1EaWZmdXNpb24tN0ItVmlkZW8yV29ybGQlMjIlMEFwaXBlJTIwJTNEJTIwQ29zbW9zVmlkZW9Ub1dvcmxkUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRyYW5zZm9ybWVyJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnRyYW5zZm9ybWVyKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJUaGUlMjB2aWRlbyUyMGRlcGljdHMlMjBhJTIwd2luZGluZyUyMG1vdW50YWluJTIwcm9hZCUyMGNvdmVyZWQlMjBpbiUyMHNub3clMkMlMjB3aXRoJTIwYSUyMHNpbmdsZSUyMHZlaGljbGUlMjB0cmF2ZWxpbmclMjBhbG9uZyUyMGl0LiUyMFRoZSUyMHJvYWQlMjBpcyUyMGZsYW5rZWQlMjBieSUyMHN0ZWVwJTJDJTIwcm9ja3klMjBjbGlmZnMlMjBhbmQlMjBzcGFyc2UlMjB2ZWdldGF0aW9uLiUyMFRoZSUyMGxhbmRzY2FwZSUyMGlzJTIwY2hhcmFjdGVyaXplZCUyMGJ5JTIwcnVnZ2VkJTIwdGVycmFpbiUyMGFuZCUyMGElMjByaXZlciUyMHZpc2libGUlMjBpbiUyMHRoZSUyMGRpc3RhbmNlLiUyMFRoZSUyMHNjZW5lJTIwY2FwdHVyZXMlMjB0aGUlMjBzb2xpdHVkZSUyMGFuZCUyMGJlYXV0eSUyMG9mJTIwYSUyMHdpbnRlciUyMGRyaXZlJTIwdGhyb3VnaCUyMGElMjBtb3VudGFpbm91cyUyMHJlZ2lvbi4lMjIlMEF2aWRlbyUyMCUzRCUyMGxvYWRfdmlkZW8oJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY29zbW9zJTJGY29zbW9zLXZpZGVvMndvcmxkLWlucHV0LXZpZC5tcDQlMjIlMEEpJTVCJTBBJTIwJTIwJTIwJTIwJTNBMjElMEElNUQlMjAlMjAlMjMlMjBUaGlzJTIwZXhhbXBsZSUyMHVzZXMlMjBvbmx5JTIwdGhlJTIwZmlyc3QlMjAyMSUyMGZyYW1lcyUwQSUwQXZpZGVvJTIwJTNEJTIwcGlwZSh2aWRlbyUzRHZpZGVvJTJDJTIwcHJvbXB0JTNEcHJvbXB0KS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDMwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CosmosVideoToWorldPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;nvidia/Cosmos-1.0-Diffusion-7B-Video2World&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CosmosVideoToWorldPipeline.from_pretrained(model_id, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipe.transformer)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;The video depicts a winding mountain road covered in snow, with a single vehicle traveling along it. The road is flanked by steep, rocky cliffs and sparse vegetation. The landscape is characterized by rugged terrain and a river visible in the distance. The scene captures the solitude and beauty of a winter drive through a mountainous region.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = load_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cosmos/cosmos-video2world-input-vid.mp4&quot;</span>
<span class="hljs-meta">... </span>)[
<span class="hljs-meta">... </span>    :<span class="hljs-number">21</span>
<span class="hljs-meta">... </span>]  <span class="hljs-comment"># This example uses only the first 21 frames</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(video=video, prompt=prompt).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),{c(){r=d("p"),r.textContent=w,m=i(),g(l.$$.fragment)},l(o){r=c(o,"P",{"data-svelte-h":!0}),T(r)!=="svelte-8d7hws"&&(r.textContent=w),m=a(o),u(l.$$.fragment,o)},m(o,M){p(o,r,M),p(o,m,M),f(l,o,M),b=!0},p:Se,i(o){b||(h(l.$$.fragment,o),b=!0)},o(o){_(l.$$.fragment,o),b=!1},d(o){o&&(t(r),t(m)),y(l,o)}}}function Vt(j){let r,w="Examples:",m,l,b;return l=new De({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> Cosmos2TextToImagePipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available checkpoints: nvidia/Cosmos-Predict2-2B-Text2Image, nvidia/Cosmos-Predict2-14B-Text2Image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;nvidia/Cosmos-Predict2-2B-Text2Image&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = Cosmos2TextToImagePipeline.from_pretrained(model_id, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A close-up shot captures a vibrant yellow scrubber vigorously working on a grimy plate, its bristles moving in circular motions to lift stubborn grease and food residue. The dish, once covered in remnants of a hearty meal, gradually reveals its original glossy surface. Suds form and bubble around the scrubber, creating a satisfying visual of cleanliness in progress. The sound of scrubbing fills the air, accompanied by the gentle clinking of the dish against the sink. As the scrubber continues its task, the dish transforms, gleaming under the bright kitchen lights, symbolizing the triumph of cleanliness over mess.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;The video captures a series of frames showing ugly scenes, static with no motion, motion blur, over-saturation, shaky footage, low resolution, grainy texture, pixelated images, poorly lit areas, underexposed and overexposed scenes, poor color balance, washed out colors, choppy sequences, jerky movements, low frame rate, artifacting, color banding, unnatural transitions, outdated special effects, fake elements, unconvincing visuals, poorly edited content, jump cuts, visual noise, and flickering. Overall, the video is of poor quality.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=prompt, negative_prompt=negative_prompt, generator=torch.Generator().manual_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>output.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),{c(){r=d("p"),r.textContent=w,m=i(),g(l.$$.fragment)},l(o){r=c(o,"P",{"data-svelte-h":!0}),T(r)!=="svelte-kvfsh7"&&(r.textContent=w),m=a(o),u(l.$$.fragment,o)},m(o,M){p(o,r,M),p(o,m,M),f(l,o,M),b=!0},p:Se,i(o){b||(h(l.$$.fragment,o),b=!0)},o(o){_(l.$$.fragment,o),b=!1},d(o){o&&(t(r),t(m)),y(l,o)}}}function Bt(j){let r,w="Examples:",m,l,b;return l=new De({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> Cosmos2VideoToWorldPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available checkpoints: nvidia/Cosmos-Predict2-2B-Video2World, nvidia/Cosmos-Predict2-14B-Video2World</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;nvidia/Cosmos-Predict2-2B-Video2World&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = Cosmos2VideoToWorldPipeline.from_pretrained(model_id, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A close-up shot captures a vibrant yellow scrubber vigorously working on a grimy plate, its bristles moving in circular motions to lift stubborn grease and food residue. The dish, once covered in remnants of a hearty meal, gradually reveals its original glossy surface. Suds form and bubble around the scrubber, creating a satisfying visual of cleanliness in progress. The sound of scrubbing fills the air, accompanied by the gentle clinking of the dish against the sink. As the scrubber continues its task, the dish transforms, gleaming under the bright kitchen lights, symbolizing the triumph of cleanliness over mess.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;The video captures a series of frames showing ugly scenes, static with no motion, motion blur, over-saturation, shaky footage, low resolution, grainy texture, pixelated images, poorly lit areas, underexposed and overexposed scenes, poor color balance, washed out colors, choppy sequences, jerky movements, low frame rate, artifacting, color banding, unnatural transitions, outdated special effects, fake elements, unconvincing visuals, poorly edited content, jump cuts, visual noise, and flickering. Overall, the video is of poor quality.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/yellow-scrubber.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    image=image, prompt=prompt, negative_prompt=negative_prompt, generator=torch.Generator().manual_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">16</span>)`,wrap:!1}}),{c(){r=d("p"),r.textContent=w,m=i(),g(l.$$.fragment)},l(o){r=c(o,"P",{"data-svelte-h":!0}),T(r)!=="svelte-kvfsh7"&&(r.textContent=w),m=a(o),u(l.$$.fragment,o)},m(o,M){p(o,r,M),p(o,m,M),f(l,o,M),b=!0},p:Se,i(o){b||(h(l.$$.fragment,o),b=!0)},o(o){_(l.$$.fragment,o),b=!1},d(o){o&&(t(r),t(m)),y(l,o)}}}function Pt(j){let r,w,m,l,b,o,M,ot='<a href="https://huggingface.co/papers/2501.03575" rel="nofollow">Cosmos World Foundation Model Platform for Physical AI</a> by NVIDIA.',Oe,ee,tt='<em>Physical AI needs to be trained digitally first. It needs a digital twin of itself, the policy model, and a digital twin of the world, the world model. In this paper, we present the Cosmos World Foundation Model Platform to help developers build customized world models for their Physical AI setups. We position a world foundation model as a general-purpose world model that can be fine-tuned into customized world models for downstream applications. Our platform covers a video curation pipeline, pre-trained world foundation models, examples of post-training of pre-trained world foundation models, and video tokenizers. To help Physical AI builders solve the most critical problems of our society, we make our platform open-source and our models open-weight with permissive licenses available via <a href="https://github.com/NVIDIA/Cosmos" rel="nofollow">https://github.com/NVIDIA/Cosmos</a>.</em>',Ke,R,eo,oe,oo,te,nt="Original format checkpoints that have not been converted to diffusers-expected format can be loaded using the <code>from_single_file</code> method.",to,ne,no,se,so,U,ie,vo,We,st='Pipeline for text-to-world generation using <a href="https://github.com/nvidia-cosmos/cosmos-predict1" rel="nofollow">Cosmos Predict1</a>.',Jo,Ze,it=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Uo,B,ae,Io,je,at="The call function to the pipeline for generation.",Wo,F,Zo,Q,re,jo,xe,rt="Encodes the prompt into text encoder hidden states.",io,le,ao,I,de,xo,Ge,lt=`Pipeline for image-to-world and video-to-world generation using <a href="https://github.com/nvidia-cosmos/cosmos-predict1" rel="nofollow">Cosmos
Predict-1</a>.`,Go,Ce,dt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Co,x,ce,ko,ke,ct="The call function to the pipeline for generation.",Vo,Ve,pt="Examples:",Bo,L,Po,E,$o,S,pe,No,Be,mt="Encodes the prompt into text encoder hidden states.",ro,me,lo,W,ge,zo,Pe,gt='Pipeline for text-to-image generation using <a href="https://github.com/nvidia-cosmos/cosmos-predict2" rel="nofollow">Cosmos Predict2</a>.',Xo,$e,ut=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Yo,P,ue,Ho,Ne,ft="The call function to the pipeline for generation.",Ro,D,Fo,q,fe,Qo,ze,ht="Encodes the prompt into text encoder hidden states.",co,he,po,Z,_e,Lo,Xe,_t='Pipeline for video-to-world generation using <a href="https://github.com/nvidia-cosmos/cosmos-predict2" rel="nofollow">Cosmos Predict2</a>.',Eo,Ye,yt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,So,$,ye,Do,He,bt="The call function to the pipeline for generation.",qo,A,Ao,O,be,Oo,Re,Tt="Encodes the prompt into text encoder hidden states.",mo,Te,go,X,Me,Ko,Fe,Mt="Output class for Cosmos any-to-world/video pipelines.",uo,we,fo,Y,ve,et,Qe,wt="Output class for Cosmos any-to-image pipelines.",ho,Je,_o,qe,yo;return b=new K({props:{title:"Cosmos",local:"cosmos",headingTag:"h1"}}),R=new Zt({props:{$$slots:{default:[xt]},$$scope:{ctx:j}}}),oe=new K({props:{title:"Loading original format checkpoints",local:"loading-original-format-checkpoints",headingTag:"h2"}}),ne=new De({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> Cosmos2TextToImagePipeline, CosmosTransformer3DModel

model_id = <span class="hljs-string">&quot;nvidia/Cosmos-Predict2-2B-Text2Image&quot;</span>
transformer = CosmosTransformer3DModel.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/nvidia/Cosmos-Predict2-2B-Text2Image/blob/main/model.pt&quot;</span>,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe = Cosmos2TextToImagePipeline.from_pretrained(model_id, transformer=transformer, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A close-up shot captures a vibrant yellow scrubber vigorously working on a grimy plate, its bristles moving in circular motions to lift stubborn grease and food residue. The dish, once covered in remnants of a hearty meal, gradually reveals its original glossy surface. Suds form and bubble around the scrubber, creating a satisfying visual of cleanliness in progress. The sound of scrubbing fills the air, accompanied by the gentle clinking of the dish against the sink. As the scrubber continues its task, the dish transforms, gleaming under the bright kitchen lights, symbolizing the triumph of cleanliness over mess.&quot;</span>
negative_prompt = <span class="hljs-string">&quot;The video captures a series of frames showing ugly scenes, static with no motion, motion blur, over-saturation, shaky footage, low resolution, grainy texture, pixelated images, poorly lit areas, underexposed and overexposed scenes, poor color balance, washed out colors, choppy sequences, jerky movements, low frame rate, artifacting, color banding, unnatural transitions, outdated special effects, fake elements, unconvincing visuals, poorly edited content, jump cuts, visual noise, and flickering. Overall, the video is of poor quality.&quot;</span>

output = pipe(
    prompt=prompt, negative_prompt=negative_prompt, generator=torch.Generator().manual_seed(<span class="hljs-number">1</span>)
).images[<span class="hljs-number">0</span>]
output.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),se=new K({props:{title:"CosmosTextToWorldPipeline",local:"diffusers.CosmosTextToWorldPipeline",headingTag:"h2"}}),ie=new G({props:{name:"class diffusers.CosmosTextToWorldPipeline",anchor:"diffusers.CosmosTextToWorldPipeline",parameters:[{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": CosmosTransformer3DModel"},{name:"vae",val:": AutoencoderKLCosmos"},{name:"scheduler",val:": EDMEulerScheduler"},{name:"safety_checker",val:": CosmosSafetyChecker = None"}],parametersDescription:[{anchor:"diffusers.CosmosTextToWorldPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Cosmos uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/google-t5/t5-11b" rel="nofollow">t5-11b</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CosmosTextToWorldPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CosmosTextToWorldPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cosmos_transformer3d#diffusers.CosmosTransformer3DModel">CosmosTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.CosmosTextToWorldPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.CosmosTextToWorldPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl_cosmos#diffusers.AutoencoderKLCosmos">AutoencoderKLCosmos</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos_text2world.py#L132"}}),ae=new G({props:{name:"__call__",anchor:"diffusers.CosmosTextToWorldPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 704"},{name:"width",val:": int = 1280"},{name:"num_frames",val:": int = 121"},{name:"num_inference_steps",val:": int = 36"},{name:"guidance_scale",val:": float = 7.0"},{name:"fps",val:": int = 30"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>720</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>1280</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>121</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>36</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>7.0</code>) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.fps",description:`<strong>fps</strong> (<code>int</code>, defaults to <code>30</code>) &#x2014;
The frames per second of the generated video.`,name:"fps"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>CosmosPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos_text2world.py#L393",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>CosmosPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned where
the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~CosmosPipelineOutput</code> or <code>tuple</code></p>
`}}),F=new Ae({props:{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.example",$$slots:{default:[Gt]},$$scope:{ctx:j}}}),re=new G({props:{name:"encode_prompt",anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos_text2world.py#L231"}}),le=new K({props:{title:"CosmosVideoToWorldPipeline",local:"diffusers.CosmosVideoToWorldPipeline",headingTag:"h2"}}),de=new G({props:{name:"class diffusers.CosmosVideoToWorldPipeline",anchor:"diffusers.CosmosVideoToWorldPipeline",parameters:[{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": CosmosTransformer3DModel"},{name:"vae",val:": AutoencoderKLCosmos"},{name:"scheduler",val:": EDMEulerScheduler"},{name:"safety_checker",val:": CosmosSafetyChecker = None"}],parametersDescription:[{anchor:"diffusers.CosmosVideoToWorldPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Cosmos uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/google-t5/t5-11b" rel="nofollow">t5-11b</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CosmosVideoToWorldPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CosmosVideoToWorldPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cosmos_transformer3d#diffusers.CosmosTransformer3DModel">CosmosTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.CosmosVideoToWorldPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.CosmosVideoToWorldPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl_cosmos#diffusers.AutoencoderKLCosmos">AutoencoderKLCosmos</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos_video2world.py#L175"}}),ce=new G({props:{name:"__call__",anchor:"diffusers.CosmosVideoToWorldPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"video",val:": typing.List[typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 704"},{name:"width",val:": int = 1280"},{name:"num_frames",val:": int = 121"},{name:"num_inference_steps",val:": int = 36"},{name:"guidance_scale",val:": float = 7.0"},{name:"input_frames_guidance",val:": bool = False"},{name:"augment_sigma",val:": float = 0.001"},{name:"fps",val:": int = 30"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>720</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>1280</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>121</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>36</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>7.0</code>) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.fps",description:`<strong>fps</strong> (<code>int</code>, defaults to <code>30</code>) &#x2014;
The frames per second of the generated video.`,name:"fps"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>CosmosPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos_video2world.py#L505",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>CosmosPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned where
the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~CosmosPipelineOutput</code> or <code>tuple</code></p>
`}}),L=new Ae({props:{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.example",$$slots:{default:[Ct]},$$scope:{ctx:j}}}),E=new Ae({props:{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.example-2",$$slots:{default:[kt]},$$scope:{ctx:j}}}),pe=new G({props:{name:"encode_prompt",anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos_video2world.py#L277"}}),me=new K({props:{title:"Cosmos2TextToImagePipeline",local:"diffusers.Cosmos2TextToImagePipeline",headingTag:"h2"}}),ge=new G({props:{name:"class diffusers.Cosmos2TextToImagePipeline",anchor:"diffusers.Cosmos2TextToImagePipeline",parameters:[{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": CosmosTransformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"safety_checker",val:": CosmosSafetyChecker = None"}],parametersDescription:[{anchor:"diffusers.Cosmos2TextToImagePipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Cosmos uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/google-t5/t5-11b" rel="nofollow">t5-11b</a> variant.`,name:"text_encoder"},{anchor:"diffusers.Cosmos2TextToImagePipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.Cosmos2TextToImagePipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cosmos_transformer3d#diffusers.CosmosTransformer3DModel">CosmosTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.Cosmos2TextToImagePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.Cosmos2TextToImagePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos2_text2image.py#L135"}}),ue=new G({props:{name:"__call__",anchor:"diffusers.Cosmos2TextToImagePipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 768"},{name:"width",val:": int = 1360"},{name:"num_inference_steps",val:": int = 35"},{name:"guidance_scale",val:": float = 7.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>768</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>1360</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>35</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>7.0</code>) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>CosmosImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos2_text2image.py#L409",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>CosmosImagePipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~CosmosImagePipelineOutput</code> or <code>tuple</code></p>
`}}),D=new Ae({props:{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.example",$$slots:{default:[Vt]},$$scope:{ctx:j}}}),fe=new G({props:{name:"encode_prompt",anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_images_per_prompt"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos2_text2image.py#L246"}}),he=new K({props:{title:"Cosmos2VideoToWorldPipeline",local:"diffusers.Cosmos2VideoToWorldPipeline",headingTag:"h2"}}),_e=new G({props:{name:"class diffusers.Cosmos2VideoToWorldPipeline",anchor:"diffusers.Cosmos2VideoToWorldPipeline",parameters:[{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": CosmosTransformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"safety_checker",val:": CosmosSafetyChecker = None"}],parametersDescription:[{anchor:"diffusers.Cosmos2VideoToWorldPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Cosmos uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/google-t5/t5-11b" rel="nofollow">t5-11b</a> variant.`,name:"text_encoder"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cosmos_transformer3d#diffusers.CosmosTransformer3DModel">CosmosTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos2_video2world.py#L154"}}),ye=new G({props:{name:"__call__",anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"video",val:": typing.List[typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 704"},{name:"width",val:": int = 1280"},{name:"num_frames",val:": int = 93"},{name:"num_inference_steps",val:": int = 35"},{name:"guidance_scale",val:": float = 7.0"},{name:"fps",val:": int = 16"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"},{name:"sigma_conditioning",val:": float = 0.0001"}],parametersDescription:[{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The image to be used as a conditioning input for the video generation.`,name:"image"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.video",description:`<strong>video</strong> (<code>List[PIL.Image.Image]</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The video to be used as a conditioning input for the video generation.`,name:"video"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>704</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>1280</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>93</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>35</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>7.0</code>) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.fps",description:`<strong>fps</strong> (<code>int</code>, defaults to <code>16</code>) &#x2014;
The frames per second of the generated video.`,name:"fps"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>CosmosPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>512</code>) &#x2014;
The maximum number of tokens in the prompt. If the prompt exceeds this length, it will be truncated. If
the prompt is shorter than this length, it will be padded.`,name:"max_sequence_length"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.sigma_conditioning",description:`<strong>sigma_conditioning</strong> (<code>float</code>, defaults to <code>0.0001</code>) &#x2014;
The sigma value used for scaling conditioning latents. Ideally, it should not be changed or should be
set to a small value close to zero.`,name:"sigma_conditioning"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos2_video2world.py#L477",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>CosmosPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned where
the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~CosmosPipelineOutput</code> or <code>tuple</code></p>
`}}),A=new Ae({props:{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.example",$$slots:{default:[Bt]},$$scope:{ctx:j}}}),be=new G({props:{name:"encode_prompt",anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos2_video2world.py#L265"}}),Te=new K({props:{title:"CosmosPipelineOutput",local:"diffusers.pipelines.cosmos.pipeline_output.CosmosPipelineOutput",headingTag:"h2"}}),Me=new G({props:{name:"class diffusers.pipelines.cosmos.pipeline_output.CosmosPipelineOutput",anchor:"diffusers.pipelines.cosmos.pipeline_output.CosmosPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.cosmos.pipeline_output.CosmosPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_output.py#L15"}}),we=new K({props:{title:"CosmosImagePipelineOutput",local:"diffusers.pipelines.cosmos.pipeline_output.CosmosImagePipelineOutput",headingTag:"h2"}}),ve=new G({props:{name:"class diffusers.pipelines.cosmos.pipeline_output.CosmosImagePipelineOutput",anchor:"diffusers.pipelines.cosmos.pipeline_output.CosmosImagePipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.cosmos.pipeline_output.CosmosImagePipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or numpy array of shape <code>(batch_size, height, width, num_channels)</code>. PIL images or numpy array present the denoised images of the diffusion pipeline.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_output.py#L30"}}),Je=new jt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/cosmos.md"}}),{c(){r=d("meta"),w=i(),m=d("p"),l=i(),g(b.$$.fragment),o=i(),M=d("p"),M.innerHTML=ot,Oe=i(),ee=d("p"),ee.innerHTML=tt,Ke=i(),g(R.$$.fragment),eo=i(),g(oe.$$.fragment),oo=i(),te=d("p"),te.innerHTML=nt,to=i(),g(ne.$$.fragment),no=i(),g(se.$$.fragment),so=i(),U=d("div"),g(ie.$$.fragment),vo=i(),We=d("p"),We.innerHTML=st,Jo=i(),Ze=d("p"),Ze.innerHTML=it,Uo=i(),B=d("div"),g(ae.$$.fragment),Io=i(),je=d("p"),je.textContent=at,Wo=i(),g(F.$$.fragment),Zo=i(),Q=d("div"),g(re.$$.fragment),jo=i(),xe=d("p"),xe.textContent=rt,io=i(),g(le.$$.fragment),ao=i(),I=d("div"),g(de.$$.fragment),xo=i(),Ge=d("p"),Ge.innerHTML=lt,Go=i(),Ce=d("p"),Ce.innerHTML=dt,Co=i(),x=d("div"),g(ce.$$.fragment),ko=i(),ke=d("p"),ke.textContent=ct,Vo=i(),Ve=d("p"),Ve.textContent=pt,Bo=i(),g(L.$$.fragment),Po=i(),g(E.$$.fragment),$o=i(),S=d("div"),g(pe.$$.fragment),No=i(),Be=d("p"),Be.textContent=mt,ro=i(),g(me.$$.fragment),lo=i(),W=d("div"),g(ge.$$.fragment),zo=i(),Pe=d("p"),Pe.innerHTML=gt,Xo=i(),$e=d("p"),$e.innerHTML=ut,Yo=i(),P=d("div"),g(ue.$$.fragment),Ho=i(),Ne=d("p"),Ne.textContent=ft,Ro=i(),g(D.$$.fragment),Fo=i(),q=d("div"),g(fe.$$.fragment),Qo=i(),ze=d("p"),ze.textContent=ht,co=i(),g(he.$$.fragment),po=i(),Z=d("div"),g(_e.$$.fragment),Lo=i(),Xe=d("p"),Xe.innerHTML=_t,Eo=i(),Ye=d("p"),Ye.innerHTML=yt,So=i(),$=d("div"),g(ye.$$.fragment),Do=i(),He=d("p"),He.textContent=bt,qo=i(),g(A.$$.fragment),Ao=i(),O=d("div"),g(be.$$.fragment),Oo=i(),Re=d("p"),Re.textContent=Tt,mo=i(),g(Te.$$.fragment),go=i(),X=d("div"),g(Me.$$.fragment),Ko=i(),Fe=d("p"),Fe.textContent=Mt,uo=i(),g(we.$$.fragment),fo=i(),Y=d("div"),g(ve.$$.fragment),et=i(),Qe=d("p"),Qe.textContent=wt,ho=i(),g(Je.$$.fragment),_o=i(),qe=d("p"),this.h()},l(e){const n=Wt("svelte-u9bgzb",document.head);r=c(n,"META",{name:!0,content:!0}),n.forEach(t),w=a(e),m=c(e,"P",{}),v(m).forEach(t),l=a(e),u(b.$$.fragment,e),o=a(e),M=c(e,"P",{"data-svelte-h":!0}),T(M)!=="svelte-1vce33m"&&(M.innerHTML=ot),Oe=a(e),ee=c(e,"P",{"data-svelte-h":!0}),T(ee)!=="svelte-191cpbh"&&(ee.innerHTML=tt),Ke=a(e),u(R.$$.fragment,e),eo=a(e),u(oe.$$.fragment,e),oo=a(e),te=c(e,"P",{"data-svelte-h":!0}),T(te)!=="svelte-1miaz3s"&&(te.innerHTML=nt),to=a(e),u(ne.$$.fragment,e),no=a(e),u(se.$$.fragment,e),so=a(e),U=c(e,"DIV",{class:!0});var C=v(U);u(ie.$$.fragment,C),vo=a(C),We=c(C,"P",{"data-svelte-h":!0}),T(We)!=="svelte-fc8im0"&&(We.innerHTML=st),Jo=a(C),Ze=c(C,"P",{"data-svelte-h":!0}),T(Ze)!=="svelte-496sm0"&&(Ze.innerHTML=it),Uo=a(C),B=c(C,"DIV",{class:!0});var H=v(B);u(ae.$$.fragment,H),Io=a(H),je=c(H,"P",{"data-svelte-h":!0}),T(je)!=="svelte-50j04k"&&(je.textContent=at),Wo=a(H),u(F.$$.fragment,H),H.forEach(t),Zo=a(C),Q=c(C,"DIV",{class:!0});var Ue=v(Q);u(re.$$.fragment,Ue),jo=a(Ue),xe=c(Ue,"P",{"data-svelte-h":!0}),T(xe)!=="svelte-16q0ax1"&&(xe.textContent=rt),Ue.forEach(t),C.forEach(t),io=a(e),u(le.$$.fragment,e),ao=a(e),I=c(e,"DIV",{class:!0});var k=v(I);u(de.$$.fragment,k),xo=a(k),Ge=c(k,"P",{"data-svelte-h":!0}),T(Ge)!=="svelte-1la8oug"&&(Ge.innerHTML=lt),Go=a(k),Ce=c(k,"P",{"data-svelte-h":!0}),T(Ce)!=="svelte-496sm0"&&(Ce.innerHTML=dt),Co=a(k),x=c(k,"DIV",{class:!0});var V=v(x);u(ce.$$.fragment,V),ko=a(V),ke=c(V,"P",{"data-svelte-h":!0}),T(ke)!=="svelte-50j04k"&&(ke.textContent=ct),Vo=a(V),Ve=c(V,"P",{"data-svelte-h":!0}),T(Ve)!=="svelte-kvfsh7"&&(Ve.textContent=pt),Bo=a(V),u(L.$$.fragment,V),Po=a(V),u(E.$$.fragment,V),V.forEach(t),$o=a(k),S=c(k,"DIV",{class:!0});var Ie=v(S);u(pe.$$.fragment,Ie),No=a(Ie),Be=c(Ie,"P",{"data-svelte-h":!0}),T(Be)!=="svelte-16q0ax1"&&(Be.textContent=mt),Ie.forEach(t),k.forEach(t),ro=a(e),u(me.$$.fragment,e),lo=a(e),W=c(e,"DIV",{class:!0});var N=v(W);u(ge.$$.fragment,N),zo=a(N),Pe=c(N,"P",{"data-svelte-h":!0}),T(Pe)!=="svelte-zibt59"&&(Pe.innerHTML=gt),Xo=a(N),$e=c(N,"P",{"data-svelte-h":!0}),T($e)!=="svelte-496sm0"&&($e.innerHTML=ut),Yo=a(N),P=c(N,"DIV",{class:!0});var Le=v(P);u(ue.$$.fragment,Le),Ho=a(Le),Ne=c(Le,"P",{"data-svelte-h":!0}),T(Ne)!=="svelte-50j04k"&&(Ne.textContent=ft),Ro=a(Le),u(D.$$.fragment,Le),Le.forEach(t),Fo=a(N),q=c(N,"DIV",{class:!0});var bo=v(q);u(fe.$$.fragment,bo),Qo=a(bo),ze=c(bo,"P",{"data-svelte-h":!0}),T(ze)!=="svelte-16q0ax1"&&(ze.textContent=ht),bo.forEach(t),N.forEach(t),co=a(e),u(he.$$.fragment,e),po=a(e),Z=c(e,"DIV",{class:!0});var z=v(Z);u(_e.$$.fragment,z),Lo=a(z),Xe=c(z,"P",{"data-svelte-h":!0}),T(Xe)!=="svelte-zw12d0"&&(Xe.innerHTML=_t),Eo=a(z),Ye=c(z,"P",{"data-svelte-h":!0}),T(Ye)!=="svelte-496sm0"&&(Ye.innerHTML=yt),So=a(z),$=c(z,"DIV",{class:!0});var Ee=v($);u(ye.$$.fragment,Ee),Do=a(Ee),He=c(Ee,"P",{"data-svelte-h":!0}),T(He)!=="svelte-50j04k"&&(He.textContent=bt),qo=a(Ee),u(A.$$.fragment,Ee),Ee.forEach(t),Ao=a(z),O=c(z,"DIV",{class:!0});var To=v(O);u(be.$$.fragment,To),Oo=a(To),Re=c(To,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-16q0ax1"&&(Re.textContent=Tt),To.forEach(t),z.forEach(t),mo=a(e),u(Te.$$.fragment,e),go=a(e),X=c(e,"DIV",{class:!0});var Mo=v(X);u(Me.$$.fragment,Mo),Ko=a(Mo),Fe=c(Mo,"P",{"data-svelte-h":!0}),T(Fe)!=="svelte-1da849m"&&(Fe.textContent=Mt),Mo.forEach(t),uo=a(e),u(we.$$.fragment,e),fo=a(e),Y=c(e,"DIV",{class:!0});var wo=v(Y);u(ve.$$.fragment,wo),et=a(wo),Qe=c(wo,"P",{"data-svelte-h":!0}),T(Qe)!=="svelte-duwse9"&&(Qe.textContent=wt),wo.forEach(t),ho=a(e),u(Je.$$.fragment,e),_o=a(e),qe=c(e,"P",{}),v(qe).forEach(t),this.h()},h(){J(r,"name","hf:doc:metadata"),J(r,"content",$t),J(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){s(document.head,r),p(e,w,n),p(e,m,n),p(e,l,n),f(b,e,n),p(e,o,n),p(e,M,n),p(e,Oe,n),p(e,ee,n),p(e,Ke,n),f(R,e,n),p(e,eo,n),f(oe,e,n),p(e,oo,n),p(e,te,n),p(e,to,n),f(ne,e,n),p(e,no,n),f(se,e,n),p(e,so,n),p(e,U,n),f(ie,U,null),s(U,vo),s(U,We),s(U,Jo),s(U,Ze),s(U,Uo),s(U,B),f(ae,B,null),s(B,Io),s(B,je),s(B,Wo),f(F,B,null),s(U,Zo),s(U,Q),f(re,Q,null),s(Q,jo),s(Q,xe),p(e,io,n),f(le,e,n),p(e,ao,n),p(e,I,n),f(de,I,null),s(I,xo),s(I,Ge),s(I,Go),s(I,Ce),s(I,Co),s(I,x),f(ce,x,null),s(x,ko),s(x,ke),s(x,Vo),s(x,Ve),s(x,Bo),f(L,x,null),s(x,Po),f(E,x,null),s(I,$o),s(I,S),f(pe,S,null),s(S,No),s(S,Be),p(e,ro,n),f(me,e,n),p(e,lo,n),p(e,W,n),f(ge,W,null),s(W,zo),s(W,Pe),s(W,Xo),s(W,$e),s(W,Yo),s(W,P),f(ue,P,null),s(P,Ho),s(P,Ne),s(P,Ro),f(D,P,null),s(W,Fo),s(W,q),f(fe,q,null),s(q,Qo),s(q,ze),p(e,co,n),f(he,e,n),p(e,po,n),p(e,Z,n),f(_e,Z,null),s(Z,Lo),s(Z,Xe),s(Z,Eo),s(Z,Ye),s(Z,So),s(Z,$),f(ye,$,null),s($,Do),s($,He),s($,qo),f(A,$,null),s(Z,Ao),s(Z,O),f(be,O,null),s(O,Oo),s(O,Re),p(e,mo,n),f(Te,e,n),p(e,go,n),p(e,X,n),f(Me,X,null),s(X,Ko),s(X,Fe),p(e,uo,n),f(we,e,n),p(e,fo,n),p(e,Y,n),f(ve,Y,null),s(Y,et),s(Y,Qe),p(e,ho,n),f(Je,e,n),p(e,_o,n),p(e,qe,n),yo=!0},p(e,[n]){const C={};n&2&&(C.$$scope={dirty:n,ctx:e}),R.$set(C);const H={};n&2&&(H.$$scope={dirty:n,ctx:e}),F.$set(H);const Ue={};n&2&&(Ue.$$scope={dirty:n,ctx:e}),L.$set(Ue);const k={};n&2&&(k.$$scope={dirty:n,ctx:e}),E.$set(k);const V={};n&2&&(V.$$scope={dirty:n,ctx:e}),D.$set(V);const Ie={};n&2&&(Ie.$$scope={dirty:n,ctx:e}),A.$set(Ie)},i(e){yo||(h(b.$$.fragment,e),h(R.$$.fragment,e),h(oe.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),h(ae.$$.fragment,e),h(F.$$.fragment,e),h(re.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(L.$$.fragment,e),h(E.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(ge.$$.fragment,e),h(ue.$$.fragment,e),h(D.$$.fragment,e),h(fe.$$.fragment,e),h(he.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),h(A.$$.fragment,e),h(be.$$.fragment,e),h(Te.$$.fragment,e),h(Me.$$.fragment,e),h(we.$$.fragment,e),h(ve.$$.fragment,e),h(Je.$$.fragment,e),yo=!0)},o(e){_(b.$$.fragment,e),_(R.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(ie.$$.fragment,e),_(ae.$$.fragment,e),_(F.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(L.$$.fragment,e),_(E.$$.fragment,e),_(pe.$$.fragment,e),_(me.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(D.$$.fragment,e),_(fe.$$.fragment,e),_(he.$$.fragment,e),_(_e.$$.fragment,e),_(ye.$$.fragment,e),_(A.$$.fragment,e),_(be.$$.fragment,e),_(Te.$$.fragment,e),_(Me.$$.fragment,e),_(we.$$.fragment,e),_(ve.$$.fragment,e),_(Je.$$.fragment,e),yo=!1},d(e){e&&(t(w),t(m),t(l),t(o),t(M),t(Oe),t(ee),t(Ke),t(eo),t(oo),t(te),t(to),t(no),t(so),t(U),t(io),t(ao),t(I),t(ro),t(lo),t(W),t(co),t(po),t(Z),t(mo),t(go),t(X),t(uo),t(fo),t(Y),t(ho),t(_o),t(qe)),t(r),y(b,e),y(R,e),y(oe,e),y(ne,e),y(se,e),y(ie),y(ae),y(F),y(re),y(le,e),y(de),y(ce),y(L),y(E),y(pe),y(me,e),y(ge),y(ue),y(D),y(fe),y(he,e),y(_e),y(ye),y(A),y(be),y(Te,e),y(Me),y(we,e),y(ve),y(Je,e)}}}const $t='{"title":"Cosmos","local":"cosmos","sections":[{"title":"Loading original format checkpoints","local":"loading-original-format-checkpoints","sections":[],"depth":2},{"title":"CosmosTextToWorldPipeline","local":"diffusers.CosmosTextToWorldPipeline","sections":[],"depth":2},{"title":"CosmosVideoToWorldPipeline","local":"diffusers.CosmosVideoToWorldPipeline","sections":[],"depth":2},{"title":"Cosmos2TextToImagePipeline","local":"diffusers.Cosmos2TextToImagePipeline","sections":[],"depth":2},{"title":"Cosmos2VideoToWorldPipeline","local":"diffusers.Cosmos2VideoToWorldPipeline","sections":[],"depth":2},{"title":"CosmosPipelineOutput","local":"diffusers.pipelines.cosmos.pipeline_output.CosmosPipelineOutput","sections":[],"depth":2},{"title":"CosmosImagePipelineOutput","local":"diffusers.pipelines.cosmos.pipeline_output.CosmosImagePipelineOutput","sections":[],"depth":2}],"depth":1}';function Nt(j){return Jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lt extends Ut{constructor(r){super(),It(this,r,Nt,Pt,vt,{})}}export{Lt as component};
