import{s as ml,f as ul,o as cl,n as dl}from"../chunks/scheduler.f6319a2a.js";import{S as Ml,i as yl,g as n,s,r as p,A as bl,h as i,f as l,c as a,j as pl,u as h,x as r,k as jt,y as fl,a as o,v as d,d as m,t as c,w as M}from"../chunks/index.85aa684c.js";import{T as hl}from"../chunks/Tip.3d397a88.js";import{C as f}from"../chunks/CodeBlock.97b48fd2.js";import{D as gl}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as ge,E as wl}from"../chunks/EditOnGithub.006048dd.js";function Ul(we){let u,b='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){u=n("p"),u.innerHTML=b},l(y){u=i(y,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1p1d9vw"&&(u.innerHTML=b)},m(y,g){o(y,u,g)},p:dl,d(y){y&&l(u)}}}function Tl(we){let u,b="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){u=n("p"),u.textContent=b},l(y){u=i(y,"P",{"data-svelte-h":!0}),r(u)!=="svelte-h9mzfm"&&(u.textContent=b)},m(y,g){o(y,u,g)},p:dl,d(y){y&&l(u)}}}function vl(we){let u,b,y,g,T,Je,v,Ce,J,$t="Here, we’re going to see advanced tool usage.",je,w,$e,C,_t='<li><a href="#tools">Tools</a><ul><li><a href="#what-is-a-tool-and-how-to-build-one">What is a tool, and how to build one?</a></li> <li><a href="#share-your-tool-to-the-hub">Share your tool to the Hub</a></li> <li><a href="#import-a-space-as-a-tool">Import a Space as a tool</a></li> <li><a href="#use-langchain-tools">Use LangChain tools</a></li> <li><a href="#manage-your-agents-toolbox">Manage your agent’s toolbox</a></li> <li><a href="#use-a-collection-of-tools">Use a collection of tools</a></li></ul></li>',_e,j,Ie,$,It="A tool is mostly a function that an LLM can use in an agentic system.",Ze,_,Zt="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",Ge,I,Gt="So it cannot be only a function. It should be a class.",He,Z,Ht="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",xe,G,xt="Here’s how it looks:",ke,H,Be,x,kt='The custom tool subclasses <a href="/docs/smolagents/v1.1.0/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',Re,k,Bt='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',We,B,Rt="And that’s all it needs to be used in an agent!",Ve,R,Wt='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/v1.1.0/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',Qe,W,Vt='In this case, you can build your tool by subclassing <a href="/docs/smolagents/v1.1.0/en/reference/tools#smolagents.Tool">Tool</a> as described above.',Ae,V,Ee,Q,Qt='You can share your custom tool to the Hub by calling <a href="/docs/smolagents/v1.1.0/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',Se,A,Le,E,At="For the push to Hub to work, your tool will need to respect some rules:",Ne,S,Et='<li>All method are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directky within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/v1.1.0/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/v1.1.0/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',Fe,L,St='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',qe,N,Lt='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',Ye,F,Nt=`Then you can load the tool with <a href="/docs/smolagents/v1.1.0/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/v1.1.0/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,ze,q,Xe,Y,Pe,z,Ft='You can directly import a Space from the Hub as a tool using the <a href="/docs/smolagents/v1.1.0/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',De,X,qt='You only need to provide the id of the Space on the Hub, its name, and a description that will help you agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',Ke,P,Yt='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',Oe,D,et,K,zt="And voilà, here’s your image! 🏖️",tt,Ue,Xt,lt,O,Pt="Then you can use this tool just like any other tool.  For example, let’s improve the prompt  <code>a rabbit wearing a space suit</code> and generate an image of it.",ot,ee,st,te,at,Te,Dt,nt,le,Kt="How cool is this? 🤩",it,oe,rt,se,Ot=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,ut,ae,el=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,pt,ne,ht,ie,dt,re,tl="You can manage an agent’s toolbox by adding or replacing a tool.",mt,ue,ll="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",ct,pe,Mt,he,ol="Now we can leverage the new tool:",yt,de,bt,U,ft,me,sl=`Use the <code>agent.toolbox.update_tool()</code> method to replace an existing tool in the agent’s toolbox.
This is useful if your new tool is a one-to-one replacement of the existing tool because the agent already knows how to perform that specific task.
Just make sure the new tool follows the same API as the replaced tool or adapt the system prompt template to ensure all examples using the replaced tool are updated.`,gt,ce,wt,Me,al=`You can leverage tool collections by using the ToolCollection object, with the slug of the collection you want to use.
Then pass them as a list to initialize you agent, and start using them!`,Ut,ye,Tt,be,nl="To speed up the start, tools are loaded only if called by the agent.",vt,fe,Jt,ve,Ct;return T=new ge({props:{title:"Tools",local:"tools",headingTag:"h1"}}),v=new gl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),w=new hl({props:{warning:!1,$$slots:{default:[Ul]},$$scope:{ctx:we}}}),j=new ge({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),H=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),V=new ge({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),A=new f({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),q=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Y=new ge({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),D=new f({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),ee=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkltcHJvdmUlMjB0aGlzJTIwcHJvbXB0JTJDJTIwdGhlbiUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwaXQuJTIyJTJDJTIwcHJvbXB0JTNEJ0ElMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMHNwYWNlJTIwc3VpdCclMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, prompt=<span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>
)`,wrap:!1}}),te=new f({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),oe=new ge({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),ne=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),ie=new ge({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),pe=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBYWdlbnQudG9vbGJveC5hZGRfdG9vbChtb2RlbF9kb3dubG9hZF90b29sKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel

model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.toolbox.add_tool(model_download_tool)`,wrap:!1}}),de=new f({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),U=new hl({props:{warning:!1,$$slots:{default:[Tl]},$$scope:{ctx:we}}}),ce=new ge({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),ye=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),fe=new wl({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.md"}}),{c(){u=n("meta"),b=s(),y=n("p"),g=s(),p(T.$$.fragment),Je=s(),p(v.$$.fragment),Ce=s(),J=n("p"),J.textContent=$t,je=s(),p(w.$$.fragment),$e=s(),C=n("ul"),C.innerHTML=_t,_e=s(),p(j.$$.fragment),Ie=s(),$=n("p"),$.textContent=It,Ze=s(),_=n("p"),_.textContent=Zt,Ge=s(),I=n("p"),I.textContent=Gt,He=s(),Z=n("p"),Z.textContent=Ht,xe=s(),G=n("p"),G.textContent=xt,ke=s(),p(H.$$.fragment),Be=s(),x=n("p"),x.innerHTML=kt,Re=s(),k=n("ul"),k.innerHTML=Bt,We=s(),B=n("p"),B.textContent=Rt,Ve=s(),R=n("p"),R.innerHTML=Wt,Qe=s(),W=n("p"),W.innerHTML=Vt,Ae=s(),p(V.$$.fragment),Ee=s(),Q=n("p"),Q.innerHTML=Qt,Se=s(),p(A.$$.fragment),Le=s(),E=n("p"),E.textContent=At,Ne=s(),S=n("ul"),S.innerHTML=Et,Fe=s(),L=n("p"),L.innerHTML=St,qe=s(),N=n("p"),N.innerHTML=Lt,Ye=s(),F=n("p"),F.innerHTML=Nt,ze=s(),p(q.$$.fragment),Xe=s(),p(Y.$$.fragment),Pe=s(),z=n("p"),z.innerHTML=Ft,De=s(),X=n("p"),X.innerHTML=qt,Ke=s(),P=n("p"),P.innerHTML=Yt,Oe=s(),p(D.$$.fragment),et=s(),K=n("p"),K.textContent=zt,tt=s(),Ue=n("img"),lt=s(),O=n("p"),O.innerHTML=Pt,ot=s(),p(ee.$$.fragment),st=s(),p(te.$$.fragment),at=s(),Te=n("img"),nt=s(),le=n("p"),le.textContent=Kt,it=s(),p(oe.$$.fragment),rt=s(),se=n("p"),se.innerHTML=Ot,ut=s(),ae=n("p"),ae.innerHTML=el,pt=s(),p(ne.$$.fragment),ht=s(),p(ie.$$.fragment),dt=s(),re=n("p"),re.textContent=tl,mt=s(),ue=n("p"),ue.innerHTML=ll,ct=s(),p(pe.$$.fragment),Mt=s(),he=n("p"),he.textContent=ol,yt=s(),p(de.$$.fragment),bt=s(),p(U.$$.fragment),ft=s(),me=n("p"),me.innerHTML=sl,gt=s(),p(ce.$$.fragment),wt=s(),Me=n("p"),Me.textContent=al,Ut=s(),p(ye.$$.fragment),Tt=s(),be=n("p"),be.textContent=nl,vt=s(),p(fe.$$.fragment),Jt=s(),ve=n("p"),this.h()},l(e){const t=bl("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(l),b=a(e),y=i(e,"P",{}),pl(y).forEach(l),g=a(e),h(T.$$.fragment,e),Je=a(e),h(v.$$.fragment,e),Ce=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-8951oz"&&(J.textContent=$t),je=a(e),h(w.$$.fragment,e),$e=a(e),C=i(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-gdosxb"&&(C.innerHTML=_t),_e=a(e),h(j.$$.fragment,e),Ie=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-50z9h0"&&($.textContent=It),Ze=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1llqfcr"&&(_.textContent=Zt),Ge=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-eilpgu"&&(I.textContent=Gt),He=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-suz7fy"&&(Z.textContent=Ht),xe=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-x18ywb"&&(G.textContent=xt),ke=a(e),h(H.$$.fragment,e),Be=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-qxlsbg"&&(x.innerHTML=kt),Re=a(e),k=i(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-xqgwuf"&&(k.innerHTML=Bt),We=a(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-220ayw"&&(B.textContent=Rt),Ve=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1qdin6y"&&(R.innerHTML=Wt),Qe=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1oprvee"&&(W.innerHTML=Vt),Ae=a(e),h(V.$$.fragment,e),Ee=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-r6b7n4"&&(Q.innerHTML=Qt),Se=a(e),h(A.$$.fragment,e),Le=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-hoocvd"&&(E.textContent=At),Ne=a(e),S=i(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-17o25nn"&&(S.innerHTML=Et),Fe=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-4n5s3c"&&(L.innerHTML=St),qe=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1knl8v8"&&(N.innerHTML=Lt),Ye=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1ww90v6"&&(F.innerHTML=Nt),ze=a(e),h(q.$$.fragment,e),Xe=a(e),h(Y.$$.fragment,e),Pe=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-ovvqqs"&&(z.innerHTML=Ft),De=a(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1xkj0c9"&&(X.innerHTML=qt),Ke=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1gucs20"&&(P.innerHTML=Yt),Oe=a(e),h(D.$$.fragment,e),et=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-sgspwr"&&(K.textContent=zt),tt=a(e),Ue=i(e,"IMG",{src:!0}),lt=a(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-3y2998"&&(O.innerHTML=Pt),ot=a(e),h(ee.$$.fragment,e),st=a(e),h(te.$$.fragment,e),at=a(e),Te=i(e,"IMG",{src:!0}),nt=a(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-i5dtbz"&&(le.textContent=Kt),it=a(e),h(oe.$$.fragment,e),rt=a(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1rq40pf"&&(se.innerHTML=Ot),ut=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1g7jkvd"&&(ae.innerHTML=el),pt=a(e),h(ne.$$.fragment,e),ht=a(e),h(ie.$$.fragment,e),dt=a(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1upp7uo"&&(re.textContent=tl),mt=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-ocb8u2"&&(ue.innerHTML=ll),ct=a(e),h(pe.$$.fragment,e),Mt=a(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-o3ledg"&&(he.textContent=ol),yt=a(e),h(de.$$.fragment,e),bt=a(e),h(U.$$.fragment,e),ft=a(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-zx9fzv"&&(me.innerHTML=sl),gt=a(e),h(ce.$$.fragment,e),wt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-15fzsol"&&(Me.textContent=al),Ut=a(e),h(ye.$$.fragment,e),Tt=a(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-6r1jgt"&&(be.textContent=nl),vt=a(e),h(fe.$$.fragment,e),Jt=a(e),ve=i(e,"P",{}),pl(ve).forEach(l),this.h()},h(){jt(u,"name","hf:doc:metadata"),jt(u,"content",Jl),ul(Ue.src,Xt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||jt(Ue,"src",Xt),ul(Te.src,Dt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||jt(Te,"src",Dt)},m(e,t){fl(document.head,u),o(e,b,t),o(e,y,t),o(e,g,t),d(T,e,t),o(e,Je,t),d(v,e,t),o(e,Ce,t),o(e,J,t),o(e,je,t),d(w,e,t),o(e,$e,t),o(e,C,t),o(e,_e,t),d(j,e,t),o(e,Ie,t),o(e,$,t),o(e,Ze,t),o(e,_,t),o(e,Ge,t),o(e,I,t),o(e,He,t),o(e,Z,t),o(e,xe,t),o(e,G,t),o(e,ke,t),d(H,e,t),o(e,Be,t),o(e,x,t),o(e,Re,t),o(e,k,t),o(e,We,t),o(e,B,t),o(e,Ve,t),o(e,R,t),o(e,Qe,t),o(e,W,t),o(e,Ae,t),d(V,e,t),o(e,Ee,t),o(e,Q,t),o(e,Se,t),d(A,e,t),o(e,Le,t),o(e,E,t),o(e,Ne,t),o(e,S,t),o(e,Fe,t),o(e,L,t),o(e,qe,t),o(e,N,t),o(e,Ye,t),o(e,F,t),o(e,ze,t),d(q,e,t),o(e,Xe,t),d(Y,e,t),o(e,Pe,t),o(e,z,t),o(e,De,t),o(e,X,t),o(e,Ke,t),o(e,P,t),o(e,Oe,t),d(D,e,t),o(e,et,t),o(e,K,t),o(e,tt,t),o(e,Ue,t),o(e,lt,t),o(e,O,t),o(e,ot,t),d(ee,e,t),o(e,st,t),d(te,e,t),o(e,at,t),o(e,Te,t),o(e,nt,t),o(e,le,t),o(e,it,t),d(oe,e,t),o(e,rt,t),o(e,se,t),o(e,ut,t),o(e,ae,t),o(e,pt,t),d(ne,e,t),o(e,ht,t),d(ie,e,t),o(e,dt,t),o(e,re,t),o(e,mt,t),o(e,ue,t),o(e,ct,t),d(pe,e,t),o(e,Mt,t),o(e,he,t),o(e,yt,t),d(de,e,t),o(e,bt,t),d(U,e,t),o(e,ft,t),o(e,me,t),o(e,gt,t),d(ce,e,t),o(e,wt,t),o(e,Me,t),o(e,Ut,t),d(ye,e,t),o(e,Tt,t),o(e,be,t),o(e,vt,t),d(fe,e,t),o(e,Jt,t),o(e,ve,t),Ct=!0},p(e,[t]){const il={};t&2&&(il.$$scope={dirty:t,ctx:e}),w.$set(il);const rl={};t&2&&(rl.$$scope={dirty:t,ctx:e}),U.$set(rl)},i(e){Ct||(m(T.$$.fragment,e),m(v.$$.fragment,e),m(w.$$.fragment,e),m(j.$$.fragment,e),m(H.$$.fragment,e),m(V.$$.fragment,e),m(A.$$.fragment,e),m(q.$$.fragment,e),m(Y.$$.fragment,e),m(D.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(oe.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(de.$$.fragment,e),m(U.$$.fragment,e),m(ce.$$.fragment,e),m(ye.$$.fragment,e),m(fe.$$.fragment,e),Ct=!0)},o(e){c(T.$$.fragment,e),c(v.$$.fragment,e),c(w.$$.fragment,e),c(j.$$.fragment,e),c(H.$$.fragment,e),c(V.$$.fragment,e),c(A.$$.fragment,e),c(q.$$.fragment,e),c(Y.$$.fragment,e),c(D.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(oe.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),c(U.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),c(fe.$$.fragment,e),Ct=!1},d(e){e&&(l(b),l(y),l(g),l(Je),l(Ce),l(J),l(je),l($e),l(C),l(_e),l(Ie),l($),l(Ze),l(_),l(Ge),l(I),l(He),l(Z),l(xe),l(G),l(ke),l(Be),l(x),l(Re),l(k),l(We),l(B),l(Ve),l(R),l(Qe),l(W),l(Ae),l(Ee),l(Q),l(Se),l(Le),l(E),l(Ne),l(S),l(Fe),l(L),l(qe),l(N),l(Ye),l(F),l(ze),l(Xe),l(Pe),l(z),l(De),l(X),l(Ke),l(P),l(Oe),l(et),l(K),l(tt),l(Ue),l(lt),l(O),l(ot),l(st),l(at),l(Te),l(nt),l(le),l(it),l(rt),l(se),l(ut),l(ae),l(pt),l(ht),l(dt),l(re),l(mt),l(ue),l(ct),l(Mt),l(he),l(yt),l(bt),l(ft),l(me),l(gt),l(wt),l(Me),l(Ut),l(Tt),l(be),l(vt),l(Jt),l(ve)),l(u),M(T,e),M(v,e),M(w,e),M(j,e),M(H,e),M(V,e),M(A,e),M(q,e),M(Y,e),M(D,e),M(ee,e),M(te,e),M(oe,e),M(ne,e),M(ie,e),M(pe,e),M(de,e),M(U,e),M(ce,e),M(ye,e),M(fe,e)}}}const Jl='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[],"depth":3}],"depth":1}';function Cl(we){return cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hl extends Ml{constructor(u){super(),yl(this,u,Cl,vl,ml,{})}}export{Hl as component};
