import{s as rl,o as cl,n as Ml}from"../chunks/scheduler.c57aa7ef.js";import{S as dl,i as ml,g as p,s as a,r as M,A as hl,h as i,f as s,c as n,j as ol,u as r,x as y,k as pl,y as yl,a as t,v as c,d,t as m,w as h}from"../chunks/index.c50cb18e.js";import{T as il}from"../chunks/Tip.9268b0ca.js";import{C as J}from"../chunks/CodeBlock.34f0a53d.js";import{H as se}from"../chunks/Heading.c7d7e0e7.js";function ul(te){let o,w='Some familiarity with the general process of training a sequence-to-sequence would be really helpful and allow you to focus on how to apply IA3. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/translation" rel="nofollow">Translation</a> and <a href="https://huggingface.co/docs/transformers/tasks/summarization" rel="nofollow">Summarization</a> guides first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!';return{c(){o=p("p"),o.innerHTML=w},l(u){o=i(u,"P",{"data-svelte-h":!0}),y(o)!=="svelte-1nn7tj6"&&(o.innerHTML=w)},m(u,f){t(u,o,f)},p:Ml,d(u){u&&s(o)}}}function Jl(te){let o,w='Call the <a href="/docs/peft/v0.9.0/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of trainable parameters of <a href="/docs/peft/v0.9.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!';return{c(){o=p("p"),o.innerHTML=w},l(u){o=i(u,"P",{"data-svelte-h":!0}),y(o)!=="svelte-657v6r"&&(o.innerHTML=w)},m(u,f){t(u,o,f)},p:Ml,d(u){u&&s(o)}}}function wl(te){let o,w,u,f,j,ne,b,Ee='<a href="../conceptual_guides/ia3">IA3</a> multiplies the model’s activations (the keys and values in the self-attention and encoder-decoder attention blocks, and the intermediate activation of the position-wise feedforward network) by three learned vectors. This PEFT method introduces an even smaller number of trainable parameters than LoRA which introduces weight matrices instead of vectors. The original model’s parameters are kept frozen and only these vectors are updated. As a result, it is faster, cheaper and more efficient to finetune for a new downstream task.',oe,C,Ae="This guide will show you how to train a sequence-to-sequence model with IA3 to <em>generate a sentiment</em> given some financial news.",pe,U,ie,I,Me,_,xe='You’ll use the sentences_allagree subset of the <a href="https://huggingface.co/datasets/financial_phrasebank" rel="nofollow">financial_phrasebank</a> dataset. This subset contains financial news with 100% annotator agreement on the sentiment label. Take a look at the <a href="https://huggingface.co/datasets/financial_phrasebank/viewer/sentences_allagree" rel="nofollow">dataset viewer</a> for a better idea of the data and sentences you’ll be working with.',re,g,He='Load the dataset with the <a href="https://huggingface.co/docs/datasets/v2.17.1/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">load_dataset</a> function. This subset of the dataset only contains a train split, so use the <code>train_test_split</code> function to create a train and validation split. Create a new <code>text_label</code> column so it is easier to understand what the <code>label</code> values <code>0</code>, <code>1</code>, and <code>2</code> mean.',ce,Z,de,k,Fe="Load a tokenizer and create a preprocessing function that:",me,B,Se="<li>tokenizes the inputs, pads and truncates the sequence to the <code>max_length</code></li> <li>apply the same tokenizer to the labels but with a shorter <code>max_length</code> that corresponds to the label</li> <li>mask the padding tokens</li>",he,G,ye,W,qe='Use the <a href="https://huggingface.co/docs/datasets/v2.17.1/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> function to apply the preprocessing function to the entire dataset.',ue,v,Je,R,Le='Create a training and evaluation <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a>, and set <code>pin_memory=True</code> to speed up data transfer to the GPU during training if your dataset samples are on a CPU.',we,X,fe,$,Ue,V,Ke='Now you can load a pretrained model to use as the base model for IA3. This guide uses the <a href="https://huggingface.co/bigscience/mt0-large" rel="nofollow">bigscience/mt0-large</a> model, but you can use any sequence-to-sequence model you like.',Te,N,je,Q,be,Y,Pe='All PEFT methods need a configuration that contains and specifies all the parameters for how the PEFT method should be applied. Create an <a href="/docs/peft/v0.9.0/en/package_reference/ia3#peft.IA3Config">IA3Config</a> with the task type and set the inference mode to <code>False</code>. You can find additional parameters for this configuration in the <a href="../package_reference/ia3#ia3config">API reference</a>.',Ce,T,Ie,z,De='Once the configuration is setup, pass it to the <a href="/docs/peft/v0.9.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/v0.9.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',_e,E,ge,A,Ze,x,Oe="Set up an optimizer and learning rate scheduler.",ke,H,Be,F,el="Move the model to the GPU and create a training loop that reports the loss and perplexity for each epoch.",Ge,S,We,q,ve,L,ll='After training is complete, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.',Re,K,Xe,P,$e,D,sl='To load the model for inference, use the <a href="/docs/peft/v0.9.0/en/package_reference/auto_class#peft.AutoPeftModel.from_pretrained">from_pretrained()</a> method. Let’s also load a sentence of financial news from the dataset to generate a sentiment for.',Ve,O,Ne,ee,tl='Call the <a href="https://huggingface.co/docs/transformers/v4.38.1/en/model_doc/phi#transformers.PhiForCausalLM.generate" rel="nofollow">generate</a> method to generate the predicted sentiment label.',Qe,le,Ye,ae,ze;return j=new se({props:{title:"IA3",local:"ia3",headingTag:"h1"}}),U=new il({props:{$$slots:{default:[ul]},$$scope:{ctx:te}}}),I=new se({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),Z=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZmluYW5jaWFsX3BocmFzZWJhbmslMjIlMkMlMjAlMjJzZW50ZW5jZXNfYWxsYWdyZWUlMjIpJTBBZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVELnRyYWluX3Rlc3Rfc3BsaXQodGVzdF9zaXplJTNEMC4xKSUwQWRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCUyMCUzRCUyMGRzJTVCJTIydGVzdCUyMiU1RCUwQWRlbCUyMGRzJTVCJTIydGVzdCUyMiU1RCUwQSUwQWNsYXNzZXMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVELmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMlMEFkcyUyMCUzRCUyMGRzLm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwJTdCJTIydGV4dF9sYWJlbCUyMiUzQSUyMCU1QmNsYXNzZXMlNUJsYWJlbCU1RCUyMGZvciUyMGxhYmVsJTIwaW4lMjB4JTVCJTIybGFiZWwlMjIlNUQlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSklMEElMEFkcyU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RCUwQSU3QidzZW50ZW5jZSclM0ElMjAnSXQlMjB3aWxsJTIwYmUlMjBvcGVyYXRlZCUyMGJ5JTIwTm9raWElMjAlMkMlMjBhbmQlMjBzdXBwb3J0ZWQlMjBieSUyMGl0cyUyME5va2lhJTIwTmV0QWN0JTIwbmV0d29yayUyMGFuZCUyMHNlcnZpY2UlMjBtYW5hZ2VtZW50JTIwc3lzdGVtJTIwLiclMkMlMEElMjAnbGFiZWwnJTNBJTIwMSUyQyUwQSUyMCd0ZXh0X2xhYmVsJyUzQSUyMCduZXV0cmFsJyU3RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;financial_phrasebank&quot;</span>, <span class="hljs-string">&quot;sentences_allagree&quot;</span>)
ds = ds[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(test_size=<span class="hljs-number">0.1</span>)
ds[<span class="hljs-string">&quot;validation&quot;</span>] = ds[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-keyword">del</span> ds[<span class="hljs-string">&quot;test&quot;</span>]

classes = ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>].names
ds = ds.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;text_label&quot;</span>: [classes[label] <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> x[<span class="hljs-string">&quot;label&quot;</span>]]},
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
)

ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;sentence&#x27;</span>: <span class="hljs-string">&#x27;It will be operated by Nokia , and supported by its Nokia NetAct network and service management system .&#x27;</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;text_label&#x27;</span>: <span class="hljs-string">&#x27;neutral&#x27;</span>}`,wrap:!1}}),G=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0ZXh0X2NvbHVtbiUyMCUzRCUyMCUyMnNlbnRlbmNlJTIyJTBBbGFiZWxfY29sdW1uJTIwJTNEJTIwJTIydGV4dF9sYWJlbCUyMiUwQW1heF9sZW5ndGglMjAlM0QlMjAxMjglMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGbXQwLWxhcmdlJTIyKSUwQSUwQWRlZiUyMHByZXByb2Nlc3NfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwZXhhbXBsZXMlNUJ0ZXh0X2NvbHVtbiU1RCUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjBleGFtcGxlcyU1QmxhYmVsX2NvbHVtbiU1RCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplcihpbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEbWF4X2xlbmd0aCUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMHRva2VuaXplcih0YXJnZXRzJTJDJTIwbWF4X2xlbmd0aCUzRDMlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjBsYWJlbHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjAlMjAlMjAlMjBsYWJlbHMlNUJsYWJlbHMlMjAlM0QlM0QlMjB0b2tlbml6ZXIucGFkX3Rva2VuX2lkJTVEJTIwJTNEJTIwLTEwMCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lucHV0cyU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1vZGVsX2lucHV0cw==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

text_column = <span class="hljs-string">&quot;sentence&quot;</span>
label_column = <span class="hljs-string">&quot;text_label&quot;</span>
max_length = <span class="hljs-number">128</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/mt0-large&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    inputs = examples[text_column]
    targets = examples[label_column]
    model_inputs = tokenizer(inputs, max_length=max_length, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = tokenizer(targets, max_length=<span class="hljs-number">3</span>, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = labels[<span class="hljs-string">&quot;input_ids&quot;</span>]
    labels[labels == tokenizer.pad_token_id] = -<span class="hljs-number">100</span>
    model_inputs[<span class="hljs-string">&quot;labels&quot;</span>] = labels
    <span class="hljs-keyword">return</span> model_inputs`,wrap:!1}}),v=new J({props:{code:"cHJvY2Vzc2VkX2RzJTIwJTNEJTIwZHMubWFwKCUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3NfZnVuY3Rpb24lMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV9jb2x1bW5zJTNEZHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXMlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Zyb21fY2FjaGVfZmlsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwZGVzYyUzRCUyMlJ1bm5pbmclMjB0b2tlbml6ZXIlMjBvbiUyMGRhdGFzZXQlMjIlMkMlMEEp",highlighted:`processed_ds = ds.<span class="hljs-built_in">map</span>(
    preprocess_function,
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
    remove_columns=ds[<span class="hljs-string">&quot;train&quot;</span>].column_names,
    load_from_cache_file=<span class="hljs-literal">False</span>,
    desc=<span class="hljs-string">&quot;Running tokenizer on dataset&quot;</span>,
)`,wrap:!1}}),X=new J({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGRlZmF1bHRfZGF0YV9jb2xsYXRvciUwQSUwQXRyYWluX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydHJhaW4lMjIlNUQlMEFldmFsX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCUwQSUwQWJhdGNoX3NpemUlMjAlM0QlMjA4JTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdHJhaW5fZHMlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGNvbGxhdGVfZm4lM0RkZWZhdWx0X2RhdGFfY29sbGF0b3IlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUyMHBpbl9tZW1vcnklM0RUcnVlJTBBKSUwQWV2YWxfZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZXZhbF9kcyUyQyUyMGNvbGxhdGVfZm4lM0RkZWZhdWx0X2RhdGFfY29sbGF0b3IlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUyMHBpbl9tZW1vcnklM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> default_data_collator

train_ds = processed_ds[<span class="hljs-string">&quot;train&quot;</span>]
eval_ds = processed_ds[<span class="hljs-string">&quot;validation&quot;</span>]

batch_size = <span class="hljs-number">8</span>

train_dataloader = DataLoader(
    train_ds, shuffle=<span class="hljs-literal">True</span>, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>
)
eval_dataloader = DataLoader(eval_ds, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)`,wrap:!1}}),$=new se({props:{title:"Model",local:"model",headingTag:"h2"}}),N=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGbXQwLWxhcmdlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM

model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;bigscience/mt0-large&quot;</span>)`,wrap:!1}}),Q=new se({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),T=new il({props:{$$slots:{default:[Jl]},$$scope:{ctx:te}}}),E=new J({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBJQTNDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwSUEzQ29uZmlnKHRhc2tfdHlwZSUzRCUyMlNFUV8yX1NFUV9MTSUyMiklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwcGVmdF9jb25maWcpJTBBbW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKSUwQSUyMnRyYWluYWJsZSUyMHBhcmFtcyUzQSUyMDI4MiUyQzYyNCUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDElMkMyMjklMkM4NjMlMkM5MzYlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjAyMjk4MDEwMzA2MDc2NjU1MyUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> IA3Config, get_peft_model

peft_config = IA3Config(task_type=<span class="hljs-string">&quot;SEQ_2_SEQ_LM&quot;</span>)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 282,624 || all params: 1,229,863,936 || trainable%: 0.022980103060766553&quot;</span>`,wrap:!1}}),A=new se({props:{title:"Training",local:"training",headingTag:"h3"}}),H=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwZ2V0X2xpbmVhcl9zY2hlZHVsZV93aXRoX3dhcm11cCUwQSUwQWxyJTIwJTNEJTIwOGUtMyUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0RsciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfbGluZWFyX3NjaGVkdWxlX3dpdGhfd2FybXVwKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEKGxlbih0cmFpbl9kYXRhbG9hZGVyKSUyMColMjBudW1fZXBvY2hzKSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_linear_schedule_with_warmup

lr = <span class="hljs-number">8e-3</span>
num_epochs = <span class="hljs-number">3</span>

optimizer = torch.optim.AdamW(model.parameters(), lr=lr)
lr_scheduler = get_linear_schedule_with_warmup(
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * num_epochs),
)`,wrap:!1}}),S=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

device = <span class="hljs-string">&quot;cuda&quot;</span>
model = model.to(device)

<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    model.train()
    total_loss = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(train_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        total_loss += loss.detach().<span class="hljs-built_in">float</span>()
        loss.backward()
        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()

    model.<span class="hljs-built_in">eval</span>()
    eval_loss = <span class="hljs-number">0</span>
    eval_preds = []
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(eval_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        <span class="hljs-keyword">with</span> torch.no_grad():
            outputs = model(**batch)
        loss = outputs.loss
        eval_loss += loss.detach().<span class="hljs-built_in">float</span>()
        eval_preds.extend(
            tokenizer.batch_decode(torch.argmax(outputs.logits, -<span class="hljs-number">1</span>).detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>)
        )

    eval_epoch_loss = eval_loss / <span class="hljs-built_in">len</span>(eval_dataloader)
    eval_ppl = torch.exp(eval_epoch_loss)
    train_epoch_loss = total_loss / <span class="hljs-built_in">len</span>(train_dataloader)
    train_ppl = torch.exp(train_epoch_loss)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{epoch=}</span>: <span class="hljs-subst">{train_ppl=}</span> <span class="hljs-subst">{train_epoch_loss=}</span> <span class="hljs-subst">{eval_ppl=}</span> <span class="hljs-subst">{eval_epoch_loss=}</span>&quot;</span>)`,wrap:!1}}),q=new se({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),K=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBYWNjb3VudCUyMCUzRCUyMCUzQ3lvdXItaGYtYWNjb3VudC1uYW1lJTNFJTBBcGVmdF9tb2RlbF9pZCUyMCUzRCUyMGYlMjIlN0JhY2NvdW50JTdEJTJGbXQwLWxhcmdlLWlhMyUyMiUwQW1vZGVsLnB1c2hfdG9faHViKHBlZnRfbW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

account = &lt;your-hf-account-name&gt;
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/mt0-large-ia3&quot;</span>
model.push_to_hub(peft_model_id)`,wrap:!1}}),P=new se({props:{title:"Inference",local:"inference",headingTag:"h2"}}),O=new J({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBdXRvUGVmdE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvUGVmdE1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjIlM0N5b3VyLWhmLWFjY291bnQtbmFtZSUzRSUyRm10MC1sYXJnZS1pYTMlMjIpLnRvKCUyMmN1ZGElMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRm10MC1sYXJnZSUyMiklMEElMEFpJTIwJTNEJTIwMTUlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTVCdGV4dF9jb2x1bW4lNUQlNUJpJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludChkcyU1QiUyMnZhbGlkYXRpb24lMjIlNUQlNUJ0ZXh0X2NvbHVtbiU1RCU1QmklNUQpJTBBJTIyVGhlJTIwcm9idXN0JTIwZ3Jvd3RoJTIwd2FzJTIwdGhlJTIwcmVzdWx0JTIwb2YlMjB0aGUlMjBpbmNsdXNpb24lMjBvZiUyMGNsb3RoaW5nJTIwY2hhaW4lMjBMaW5kZXglMjBpbiUyMHRoZSUyMEdyb3VwJTIwaW4lMjBEZWNlbWJlciUyMDIwMDclMjAuJTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AutoPeftModelForSeq2SeqLM

model = AutoPeftModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;&lt;your-hf-account-name&gt;/mt0-large-ia3&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/mt0-large&quot;</span>)

i = <span class="hljs-number">15</span>
inputs = tokenizer(ds[<span class="hljs-string">&quot;validation&quot;</span>][text_column][i], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(ds[<span class="hljs-string">&quot;validation&quot;</span>][text_column][i])
<span class="hljs-string">&quot;The robust growth was the result of the inclusion of clothing chain Lindex in the Group in December 2007 .&quot;</span>`,wrap:!1}}),le=new J({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUIncG9zaXRpdmUnJTVE",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
    outputs = model.generate(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">10</span>)
    <span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;positive&#x27;</span>]`,wrap:!1}}),{c(){o=p("meta"),w=a(),u=p("p"),f=a(),M(j.$$.fragment),ne=a(),b=p("p"),b.innerHTML=Ee,oe=a(),C=p("p"),C.innerHTML=Ae,pe=a(),M(U.$$.fragment),ie=a(),M(I.$$.fragment),Me=a(),_=p("p"),_.innerHTML=xe,re=a(),g=p("p"),g.innerHTML=He,ce=a(),M(Z.$$.fragment),de=a(),k=p("p"),k.textContent=Fe,me=a(),B=p("ol"),B.innerHTML=Se,he=a(),M(G.$$.fragment),ye=a(),W=p("p"),W.innerHTML=qe,ue=a(),M(v.$$.fragment),Je=a(),R=p("p"),R.innerHTML=Le,we=a(),M(X.$$.fragment),fe=a(),M($.$$.fragment),Ue=a(),V=p("p"),V.innerHTML=Ke,Te=a(),M(N.$$.fragment),je=a(),M(Q.$$.fragment),be=a(),Y=p("p"),Y.innerHTML=Pe,Ce=a(),M(T.$$.fragment),Ie=a(),z=p("p"),z.innerHTML=De,_e=a(),M(E.$$.fragment),ge=a(),M(A.$$.fragment),Ze=a(),x=p("p"),x.textContent=Oe,ke=a(),M(H.$$.fragment),Be=a(),F=p("p"),F.textContent=el,Ge=a(),M(S.$$.fragment),We=a(),M(q.$$.fragment),ve=a(),L=p("p"),L.innerHTML=ll,Re=a(),M(K.$$.fragment),Xe=a(),M(P.$$.fragment),$e=a(),D=p("p"),D.innerHTML=sl,Ve=a(),M(O.$$.fragment),Ne=a(),ee=p("p"),ee.innerHTML=tl,Qe=a(),M(le.$$.fragment),Ye=a(),ae=p("p"),this.h()},l(e){const l=hl("svelte-u9bgzb",document.head);o=i(l,"META",{name:!0,content:!0}),l.forEach(s),w=n(e),u=i(e,"P",{}),ol(u).forEach(s),f=n(e),r(j.$$.fragment,e),ne=n(e),b=i(e,"P",{"data-svelte-h":!0}),y(b)!=="svelte-s2qd7"&&(b.innerHTML=Ee),oe=n(e),C=i(e,"P",{"data-svelte-h":!0}),y(C)!=="svelte-xoc01f"&&(C.innerHTML=Ae),pe=n(e),r(U.$$.fragment,e),ie=n(e),r(I.$$.fragment,e),Me=n(e),_=i(e,"P",{"data-svelte-h":!0}),y(_)!=="svelte-20qrnk"&&(_.innerHTML=xe),re=n(e),g=i(e,"P",{"data-svelte-h":!0}),y(g)!=="svelte-6804ff"&&(g.innerHTML=He),ce=n(e),r(Z.$$.fragment,e),de=n(e),k=i(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-aqyjx7"&&(k.textContent=Fe),me=n(e),B=i(e,"OL",{"data-svelte-h":!0}),y(B)!=="svelte-1xhy766"&&(B.innerHTML=Se),he=n(e),r(G.$$.fragment,e),ye=n(e),W=i(e,"P",{"data-svelte-h":!0}),y(W)!=="svelte-ujx8l5"&&(W.innerHTML=qe),ue=n(e),r(v.$$.fragment,e),Je=n(e),R=i(e,"P",{"data-svelte-h":!0}),y(R)!=="svelte-1tznwdg"&&(R.innerHTML=Le),we=n(e),r(X.$$.fragment,e),fe=n(e),r($.$$.fragment,e),Ue=n(e),V=i(e,"P",{"data-svelte-h":!0}),y(V)!=="svelte-1d06z94"&&(V.innerHTML=Ke),Te=n(e),r(N.$$.fragment,e),je=n(e),r(Q.$$.fragment,e),be=n(e),Y=i(e,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-ehe9v3"&&(Y.innerHTML=Pe),Ce=n(e),r(T.$$.fragment,e),Ie=n(e),z=i(e,"P",{"data-svelte-h":!0}),y(z)!=="svelte-1hid8e2"&&(z.innerHTML=De),_e=n(e),r(E.$$.fragment,e),ge=n(e),r(A.$$.fragment,e),Ze=n(e),x=i(e,"P",{"data-svelte-h":!0}),y(x)!=="svelte-tlkvop"&&(x.textContent=Oe),ke=n(e),r(H.$$.fragment,e),Be=n(e),F=i(e,"P",{"data-svelte-h":!0}),y(F)!=="svelte-bqhytl"&&(F.textContent=el),Ge=n(e),r(S.$$.fragment,e),We=n(e),r(q.$$.fragment,e),ve=n(e),L=i(e,"P",{"data-svelte-h":!0}),y(L)!=="svelte-dirda"&&(L.innerHTML=ll),Re=n(e),r(K.$$.fragment,e),Xe=n(e),r(P.$$.fragment,e),$e=n(e),D=i(e,"P",{"data-svelte-h":!0}),y(D)!=="svelte-15y9abm"&&(D.innerHTML=sl),Ve=n(e),r(O.$$.fragment,e),Ne=n(e),ee=i(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-1x9kc90"&&(ee.innerHTML=tl),Qe=n(e),r(le.$$.fragment,e),Ye=n(e),ae=i(e,"P",{}),ol(ae).forEach(s),this.h()},h(){pl(o,"name","hf:doc:metadata"),pl(o,"content",fl)},m(e,l){yl(document.head,o),t(e,w,l),t(e,u,l),t(e,f,l),c(j,e,l),t(e,ne,l),t(e,b,l),t(e,oe,l),t(e,C,l),t(e,pe,l),c(U,e,l),t(e,ie,l),c(I,e,l),t(e,Me,l),t(e,_,l),t(e,re,l),t(e,g,l),t(e,ce,l),c(Z,e,l),t(e,de,l),t(e,k,l),t(e,me,l),t(e,B,l),t(e,he,l),c(G,e,l),t(e,ye,l),t(e,W,l),t(e,ue,l),c(v,e,l),t(e,Je,l),t(e,R,l),t(e,we,l),c(X,e,l),t(e,fe,l),c($,e,l),t(e,Ue,l),t(e,V,l),t(e,Te,l),c(N,e,l),t(e,je,l),c(Q,e,l),t(e,be,l),t(e,Y,l),t(e,Ce,l),c(T,e,l),t(e,Ie,l),t(e,z,l),t(e,_e,l),c(E,e,l),t(e,ge,l),c(A,e,l),t(e,Ze,l),t(e,x,l),t(e,ke,l),c(H,e,l),t(e,Be,l),t(e,F,l),t(e,Ge,l),c(S,e,l),t(e,We,l),c(q,e,l),t(e,ve,l),t(e,L,l),t(e,Re,l),c(K,e,l),t(e,Xe,l),c(P,e,l),t(e,$e,l),t(e,D,l),t(e,Ve,l),c(O,e,l),t(e,Ne,l),t(e,ee,l),t(e,Qe,l),c(le,e,l),t(e,Ye,l),t(e,ae,l),ze=!0},p(e,[l]){const al={};l&2&&(al.$$scope={dirty:l,ctx:e}),U.$set(al);const nl={};l&2&&(nl.$$scope={dirty:l,ctx:e}),T.$set(nl)},i(e){ze||(d(j.$$.fragment,e),d(U.$$.fragment,e),d(I.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(v.$$.fragment,e),d(X.$$.fragment,e),d($.$$.fragment,e),d(N.$$.fragment,e),d(Q.$$.fragment,e),d(T.$$.fragment,e),d(E.$$.fragment,e),d(A.$$.fragment,e),d(H.$$.fragment,e),d(S.$$.fragment,e),d(q.$$.fragment,e),d(K.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),ze=!0)},o(e){m(j.$$.fragment,e),m(U.$$.fragment,e),m(I.$$.fragment,e),m(Z.$$.fragment,e),m(G.$$.fragment,e),m(v.$$.fragment,e),m(X.$$.fragment,e),m($.$$.fragment,e),m(N.$$.fragment,e),m(Q.$$.fragment,e),m(T.$$.fragment,e),m(E.$$.fragment,e),m(A.$$.fragment,e),m(H.$$.fragment,e),m(S.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),ze=!1},d(e){e&&(s(w),s(u),s(f),s(ne),s(b),s(oe),s(C),s(pe),s(ie),s(Me),s(_),s(re),s(g),s(ce),s(de),s(k),s(me),s(B),s(he),s(ye),s(W),s(ue),s(Je),s(R),s(we),s(fe),s(Ue),s(V),s(Te),s(je),s(be),s(Y),s(Ce),s(Ie),s(z),s(_e),s(ge),s(Ze),s(x),s(ke),s(Be),s(F),s(Ge),s(We),s(ve),s(L),s(Re),s(Xe),s($e),s(D),s(Ve),s(Ne),s(ee),s(Qe),s(Ye),s(ae)),s(o),h(j,e),h(U,e),h(I,e),h(Z,e),h(G,e),h(v,e),h(X,e),h($,e),h(N,e),h(Q,e),h(T,e),h(E,e),h(A,e),h(H,e),h(S,e),h(q,e),h(K,e),h(P,e),h(O,e),h(le,e)}}}const fl='{"title":"IA3","local":"ia3","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Ul(te){return cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _l extends dl{constructor(o){super(),ml(this,o,Ul,wl,rl,{})}}export{_l as component};
