# Prefix tuning

[Prefix tuning](https://hf.co/papers/2101.00190) prefixes a series of task-specific vectors to the input sequence that can be learned while keeping the pretrained model frozen. The prefix parameters are inserted in all of the model layers.

The abstract from the paper is:

*Fine-tuning is the de facto way to leverage large pretrained language models to perform downstream tasks. However, it modifies all the language model parameters and therefore necessitates storing a full copy for each task. In this paper, we propose prefix-tuning, a lightweight alternative to fine-tuning for natural language generation tasks, which keeps language model parameters frozen, but optimizes a small continuous task-specific vector (called the prefix). Prefix-tuning draws inspiration from prompting, allowing subsequent tokens to attend to this prefix as if it were "virtual tokens". We apply prefix-tuning to GPT-2 for table-to-text generation and to BART for summarization. We find that by learning only 0.1\% of the parameters, prefix-tuning obtains comparable performance in the full data setting, outperforms fine-tuning in low-data settings, and extrapolates better to examples with topics unseen during training*.

## PrefixTuningConfig[[peft.PrefixTuningConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.PrefixTuningConfig</name><anchor>peft.PrefixTuningConfig</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/tuners/prefix_tuning/config.py#L22</source><parameters>[{"name": "task_type", "val": ": Optional[Union[str, TaskType]] = None"}, {"name": "peft_type", "val": ": Optional[Union[str, PeftType]] = None"}, {"name": "auto_mapping", "val": ": Optional[dict] = None"}, {"name": "peft_version", "val": ": Optional[str] = None"}, {"name": "base_model_name_or_path", "val": ": Optional[str] = None"}, {"name": "revision", "val": ": Optional[str] = None"}, {"name": "inference_mode", "val": ": bool = False"}, {"name": "num_virtual_tokens", "val": ": int = None"}, {"name": "token_dim", "val": ": int = None"}, {"name": "num_transformer_submodules", "val": ": Optional[int] = None"}, {"name": "num_attention_heads", "val": ": Optional[int] = None"}, {"name": "num_layers", "val": ": Optional[int] = None"}, {"name": "modules_to_save", "val": ": Optional[list[str]] = None"}, {"name": "encoder_hidden_size", "val": ": int = None"}, {"name": "prefix_projection", "val": ": bool = False"}]</parameters><paramsdesc>- **encoder_hidden_size** (`int`) -- The hidden size of the prompt encoder.
- **prefix_projection** (`bool`) -- Whether to project the prefix embeddings.</paramsdesc><paramgroups>0</paramgroups></docstring>

This is the configuration class to store the configuration of a [PrefixEncoder](/docs/peft/v0.18.0.rc0/en/package_reference/prefix_tuning#peft.PrefixEncoder).




</div>

## PrefixEncoder[[peft.PrefixEncoder]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.PrefixEncoder</name><anchor>peft.PrefixEncoder</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/tuners/prefix_tuning/model.py#L20</source><parameters>[{"name": "config", "val": ""}]</parameters><paramsdesc>- **config** ([PrefixTuningConfig](/docs/peft/v0.18.0.rc0/en/package_reference/prefix_tuning#peft.PrefixTuningConfig)) -- The configuration of the prefix encoder.</paramsdesc><paramgroups>0</paramgroups></docstring>

The `torch.nn` model to encode the prefix.



<ExampleCodeBlock anchor="peft.PrefixEncoder.example">

Example:

```py
>>> from peft import PrefixEncoder, PrefixTuningConfig

>>> config = PrefixTuningConfig(
...     peft_type="PREFIX_TUNING",
...     task_type="SEQ_2_SEQ_LM",
...     num_virtual_tokens=20,
...     token_dim=768,
...     num_transformer_submodules=1,
...     num_attention_heads=12,
...     num_layers=12,
...     encoder_hidden_size=768,
... )
>>> prefix_encoder = PrefixEncoder(config)
```

</ExampleCodeBlock>

**Attributes**:
- **embedding** (`torch.nn.Embedding`) -- The embedding layer of the prefix encoder.
- **transform** (`torch.nn.Sequential`) -- The two-layer MLP to transform the prefix embeddings if
  `prefix_projection` is `True`.
- **prefix_projection** (`bool`) -- Whether to project the prefix embeddings.

Input shape: (`batch_size`, `num_virtual_tokens`)

Output shape: (`batch_size`, `num_virtual_tokens`, `2*layers*hidden`)


</div>

<EditOnGithub source="https://github.com/huggingface/peft/blob/main/docs/source/package_reference/prefix_tuning.md" />