# Configuration

`PeftConfigMixin` is the base configuration class for storing the adapter configuration of a [PeftModel](/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.PeftModel), and [PromptLearningConfig](/docs/peft/v0.18.0.rc0/en/package_reference/config#peft.PromptLearningConfig) is the base configuration class for soft prompt methods (p-tuning, prefix tuning, and prompt tuning). These base classes contain methods for saving and loading model configurations from the Hub, specifying the PEFT method to use, type of task to perform, and model configurations like number of layers and number of attention heads.

## PeftConfigMixin[[peft.config.PeftConfigMixin]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.config.PeftConfigMixin</name><anchor>peft.config.PeftConfigMixin</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/config.py#L77</source><parameters>[{"name": "task_type", "val": ": Optional[TaskType] = None"}, {"name": "peft_type", "val": ": Optional[PeftType] = None"}, {"name": "auto_mapping", "val": ": Optional[dict] = None"}, {"name": "peft_version", "val": ": Optional[str] = None"}]</parameters><paramsdesc>- **peft_type** (Union[`~peft.utils.config.PeftType`, `str`]) -- The type of Peft method to use.</paramsdesc><paramgroups>0</paramgroups></docstring>

This is the base configuration class for PEFT adapter models. It contains all the methods that are common to all
PEFT adapter models. This class inherits from [PushToHubMixin](https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/model#transformers.utils.PushToHubMixin) which contains the methods to
push your model to the Hub. The method `save_pretrained` will save the configuration of your adapter model in a
directory. The method `from_pretrained` will load the configuration of your adapter model from a directory.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>check_kwargs</name><anchor>peft.config.PeftConfigMixin.check_kwargs</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/config.py#L328</source><parameters>[{"name": "**kwargs", "val": ""}]</parameters></docstring>
Check kwargs before initializing the config instance.

Subclasses can override this method to add specific checks.



</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_json_file</name><anchor>peft.config.PeftConfigMixin.from_json_file</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/config.py#L266</source><parameters>[{"name": "path_json_file", "val": ": str"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **path_json_file** (`str`) --
  The path to the json file.</paramsdesc><paramgroups>0</paramgroups></docstring>

Loads a configuration file from a json file.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_peft_type</name><anchor>peft.config.PeftConfigMixin.from_peft_type</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/config.py#L165</source><parameters>[{"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **kwargs** (configuration keyword arguments) --
  Keyword arguments passed along to the configuration initialization.</paramsdesc><paramgroups>0</paramgroups></docstring>

This method loads the configuration of your adapter model from a set of kwargs.

The appropriate configuration type is determined by the `peft_type` argument. If `peft_type` is not provided,
the calling class type is instantiated.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_pretrained</name><anchor>peft.config.PeftConfigMixin.from_pretrained</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/config.py#L230</source><parameters>[{"name": "pretrained_model_name_or_path", "val": ": str"}, {"name": "subfolder", "val": ": Optional[str] = None"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **pretrained_model_name_or_path** (`str`) --
  The directory or the Hub repository id where the configuration is saved.
- **kwargs** (additional keyword arguments, *optional*) --
  Additional keyword arguments passed along to the child class initialization.</paramsdesc><paramgroups>0</paramgroups></docstring>

This method loads the configuration of your adapter model from a directory.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>save_pretrained</name><anchor>peft.config.PeftConfigMixin.save_pretrained</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/config.py#L132</source><parameters>[{"name": "save_directory", "val": ": str"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **save_directory** (`str`) --
  The directory where the configuration will be saved.
- **kwargs** (additional keyword arguments, *optional*) --
  Additional keyword arguments passed along to the [push_to_hub](https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub)
  method.</paramsdesc><paramgroups>0</paramgroups></docstring>

This method saves the configuration of your adapter model in a directory.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>to_dict</name><anchor>peft.config.PeftConfigMixin.to_dict</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/config.py#L126</source><parameters>[]</parameters></docstring>

Returns the configuration for your adapter model as a dictionary.


</div></div>

## PeftConfig[[peft.PeftConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.PeftConfig</name><anchor>peft.PeftConfig</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/config.py#L351</source><parameters>[{"name": "task_type", "val": ": Optional[Union[str, TaskType]] = None"}, {"name": "peft_type", "val": ": Optional[Union[str, PeftType]] = None"}, {"name": "auto_mapping", "val": ": Optional[dict] = None"}, {"name": "peft_version", "val": ": Optional[str] = None"}, {"name": "base_model_name_or_path", "val": ": Optional[str] = None"}, {"name": "revision", "val": ": Optional[str] = None"}, {"name": "inference_mode", "val": ": bool = False"}]</parameters><paramsdesc>- **peft_type** (Union[`~peft.utils.config.PeftType`, `str`]) -- The type of Peft method to use.
- **task_type** (Union[`~peft.utils.config.TaskType`, `str`]) -- The type of task to perform.
- **inference_mode** (`bool`, defaults to `False`) -- Whether to use the Peft model in inference mode.</paramsdesc><paramgroups>0</paramgroups></docstring>

This is the base configuration class to store the configuration of a [PeftModel](/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.PeftModel).




</div>

## PromptLearningConfig[[peft.PromptLearningConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.PromptLearningConfig</name><anchor>peft.PromptLearningConfig</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/config.py#L371</source><parameters>[{"name": "task_type", "val": ": Optional[Union[str, TaskType]] = None"}, {"name": "peft_type", "val": ": Optional[Union[str, PeftType]] = None"}, {"name": "auto_mapping", "val": ": Optional[dict] = None"}, {"name": "peft_version", "val": ": Optional[str] = None"}, {"name": "base_model_name_or_path", "val": ": Optional[str] = None"}, {"name": "revision", "val": ": Optional[str] = None"}, {"name": "inference_mode", "val": ": bool = False"}, {"name": "num_virtual_tokens", "val": ": int = None"}, {"name": "token_dim", "val": ": int = None"}, {"name": "num_transformer_submodules", "val": ": Optional[int] = None"}, {"name": "num_attention_heads", "val": ": Optional[int] = None"}, {"name": "num_layers", "val": ": Optional[int] = None"}, {"name": "modules_to_save", "val": ": Optional[list[str]] = None"}]</parameters><paramsdesc>- **num_virtual_tokens** (`int`) -- The number of virtual tokens to use.
- **token_dim** (`int`) -- The hidden embedding dimension of the base transformer model.
- **num_transformer_submodules** (`int`) -- The number of transformer submodules in the base transformer model.
- **num_attention_heads** (`int`) -- The number of attention heads in the base transformer model.
- **num_layers** (`int`) -- The number of layers in the base transformer model.</paramsdesc><paramgroups>0</paramgroups></docstring>

This is the base configuration class to store the configuration of `PrefixTuning`, [PromptEncoder](/docs/peft/v0.18.0.rc0/en/package_reference/p_tuning#peft.PromptEncoder), or
`PromptTuning`.




</div>

<EditOnGithub source="https://github.com/huggingface/peft/blob/main/docs/source/package_reference/config.md" />