import{s as nt,n as st,o as at}from"../chunks/scheduler.78382b47.js";import{S as rt,i as ct,e as s,s as i,c,h as mt,a,d as o,b as n,f as lt,g as m,j as r,k as ze,l as ft,m as l,n as f,t as d,o as p,p as u}from"../chunks/index.6dd35eb6.js";import{C as dt,H as T,E as pt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8d7e60c0.js";import{C as it}from"../chunks/CodeBlock.4d4112a9.js";function ut(Ie){let b,D,Y,K,g,ee,M,te,w,Ze='This conceptual guide gives a brief overview of <a href="https://huggingface.co/papers/2306.07280" rel="nofollow">OFT</a>, <a href="https://www.arxiv.org/abs/2506.19847" rel="nofollow">OFTv2</a> and <a href="https://huggingface.co/papers/2311.06243" rel="nofollow">BOFT</a>, a parameter-efficient fine-tuning technique that utilizes orthogonal matrix to multiplicatively transform the pretrained weight matrices.',oe,_,Re="To achieve efficient fine-tuning, OFT represents the weight updates with an orthogonal transformation. The orthogonal transformation is parameterized by an orthogonal matrix multiplied to the pretrained weight matrix. These new matrices can be trained to adapt to the new data while keeping the overall number of changes low. The original weight matrix remains frozen and doesn’t receive any further adjustments. To produce the final results, both the original and the adapted weights are multiplied togethor.",le,J,We="Orthogonal Butterfly (BOFT) generalizes OFT with Butterfly factorization and further improves its parameter efficiency and finetuning flexibility. In short, OFT can be viewed as a special case of BOFT. Different from LoRA that uses additive low-rank weight updates, BOFT uses multiplicative orthogonal weight updates. The comparison is shown below.",ie,y,Ee='<img src="https://raw.githubusercontent.com/wy1iu/butterfly-oft/main/assets/BOFT_comparison.png"/>',ne,F,qe="BOFT has some advantages compared to LoRA:",se,U,Ae='<li>BOFT proposes a simple yet generic way to finetune pretrained models to downstream tasks, yielding a better preservation of pretraining knowledge and a better parameter efficiency.</li> <li>Through the orthogonality, BOFT introduces a structural constraint, i.e., keeping the <a href="https://huggingface.co/papers/1805.09298" rel="nofollow">hyperspherical energy</a> unchanged during finetuning. This can effectively reduce the forgetting of pretraining knowledge.</li> <li>BOFT uses the butterfly factorization to efficiently parameterize the orthogonal matrix, which yields a compact yet expressive learning space (i.e., hypothesis class).</li> <li>The sparse matrix decomposition in BOFT brings in additional inductive biases that are beneficial to generalization.</li>',ae,C,Xe="In principle, BOFT can be applied to any subset of weight matrices in a neural network to reduce the number of trainable parameters. Given the target layers for injecting BOFT parameters, the number of trainable parameters can be determined based on the size of the weight matrices.",re,B,ce,j,Ge="Similar to LoRA, the weights learned by OFT/BOFT can be integrated into the pretrained weight matrices using the merge_and_unload() function. This function merges the adapter weights with the base model which allows you to effectively use the newly merged model as a standalone model.",me,h,Qe='<img src="https://raw.githubusercontent.com/wy1iu/butterfly-oft/main/assets/boft_merge.png"/>',fe,v,He="This works because during training, the orthogonal weight matrix (R in the diagram above) and the pretrained weight matrices are separate. But once training is complete, these weights can actually be merged (multiplied) into a new weight matrix that is equivalent.",de,k,pe,x,ue,$,Ne="As with other methods supported by PEFT, to fine-tune a model using OFT or BOFT, you need to:",be,O,Le="<li>Instantiate a base model.</li> <li>Create a configuration (<code>OFTConfig</code> or <code>BOFTConfig</code>) where you define OFT/BOFT-specific parameters.</li> <li>Wrap the base model with <code>get_peft_model()</code> to get a trainable <code>PeftModel</code>.</li> <li>Train the <code>PeftModel</code> as you normally would train the base model.</li>",ye,z,he,I,Se="<code>OFTConfig</code> allows you to control how OFT is applied to the base model through the following parameters:",Te,Z,Ve="<li><code>r</code>: OFT rank, number of OFT blocks per injected layer. <strong>Bigger</strong> <code>r</code> results in more sparse update matrices with <strong>fewer</strong> trainable paramters. <strong>Note</strong>: You can only specify either <code>r</code> or <code>oft_block_size</code>, but not both simultaneously, because <code>r</code> × <code>oft_block_size</code> = layer dimension. For simplicity, we let the user speficy either <code>r</code> or <code>oft_block_size</code> and infer the other one. Default set to <code>r = 0</code>, the user is advised to set the <code>oft_block_size</code> instead for better clarity.</li> <li><code>oft_block_size</code>: OFT block size across different layers. <strong>Bigger</strong> <code>oft_block_size</code> results in more dense update matrices with <strong>more</strong> trainable parameters. <strong>Note</strong>: Please choose <code>oft_block_size</code> to be divisible by layer’s input dimension (<code>in_features</code>), e.g., 4, 8, 16. You can only specify either <code>r</code> or <code>oft_block_size</code>, but not both simultaneously, because <code>r</code> × <code>oft_block_size</code> = layer dimension. For simplicity, we let the user speficy either <code>r</code> or <code>oft_block_size</code> and infer the other one. Default set to <code>oft_block_size = 32</code>.</li> <li><code>use_cayley_neumann</code>: Specifies whether to use the Cayley-Neumann parameterization (efficient but approximate) or the vanilla Cayley parameterization (exact but computationally expensive because of matrix inverse). We recommend to set it to <code>True</code> for better efficiency, but performance may be slightly worse because of the approximation error. Please test both settings (<code>True</code> and <code>False</code>) depending on your needs. Default is <code>False</code>.</li> <li><code>module_dropout</code>: The multiplicative dropout probability, by setting OFT blocks to identity during training, similar to the dropout layer in LoRA.</li> <li><code>bias</code>: specify if the <code>bias</code> parameters should be trained. Can be <code>&quot;none&quot;</code>, <code>&quot;all&quot;</code> or <code>&quot;oft_only&quot;</code>.</li> <li><code>target_modules</code>: The modules (for example, attention blocks) to inject the OFT matrices.</li> <li><code>modules_to_save</code>: List of modules apart from OFT matrices to be set as trainable and saved in the final checkpoint. These typically include model’s custom head that is randomly initialized for the fine-tuning task.</li>",ge,R,Me,W,Ye="<code>BOFTConfig</code> allows you to control how BOFT is applied to the base model through the following parameters:",we,E,Pe=`<li><code>boft_block_size</code>: the BOFT matrix block size across different layers, expressed in <code>int</code>. <strong>Bigger</strong> <code>boft_block_size</code> results in more dense update matrices with <strong>more</strong> trainable parameters. <strong>Note</strong>, please choose <code>boft_block_size</code> to be divisible by most layer’s input dimension (<code>in_features</code>), e.g., 4, 8, 16. Also, please only
specify either <code>boft_block_size</code> or <code>boft_block_num</code>, but not both simultaneously or leaving both to 0, because <code>boft_block_size</code> x <code>boft_block_num</code> must equal the layer’s input dimension.</li> <li><code>boft_block_num</code>: the number of BOFT matrix blocks across different layers, expressed in <code>int</code>. <strong>Bigger</strong> <code>boft_block_num</code> result in sparser update matrices with <strong>fewer</strong> trainable parameters. <strong>Note</strong>, please choose <code>boft_block_num</code> to be divisible by most layer’s input dimension (<code>in_features</code>), e.g., 4, 8, 16. Also, please only
specify either <code>boft_block_size</code> or <code>boft_block_num</code>, but not both simultaneously or leaving both to 0, because <code>boft_block_size</code> x <code>boft_block_num</code> must equal the layer’s input dimension.</li> <li><code>boft_n_butterfly_factor</code>: the number of butterfly factors. <strong>Note</strong>, for <code>boft_n_butterfly_factor=1</code>, BOFT is the same as vanilla OFT, for <code>boft_n_butterfly_factor=2</code>, the effective block size of OFT becomes twice as big and the number of blocks become half.</li> <li><code>bias</code>: specify if the <code>bias</code> parameters should be trained. Can be <code>&quot;none&quot;</code>, <code>&quot;all&quot;</code> or <code>&quot;boft_only&quot;</code>.</li> <li><code>boft_dropout</code>: specify the probability of multiplicative dropout.</li> <li><code>target_modules</code>: The modules (for example, attention blocks) to inject the OFT/BOFT matrices.</li> <li><code>modules_to_save</code>: List of modules apart from OFT/BOFT matrices to be set as trainable and saved in the final checkpoint. These typically include model’s custom head that is randomly initialized for the fine-tuning task.</li>`,_e,q,Je,A,De='For using OFT for quantized finetuning with <a href="https://github.com/huggingface/trl" rel="nofollow">TRL</a> for <code>SFT</code>, <code>PPO</code>, or <code>DPO</code> fine-tuning, follow the following outline:',Fe,X,Ue,G,Ce,Q,Ke="For an example of the BOFT method application to various downstream tasks, please refer to the following guides:",Be,H,et="Take a look at the following step-by-step guides on how to finetune a model with BOFT:",je,N,tt='<li><a href="https://github.com/huggingface/peft/blob/main/examples/boft_dreambooth/boft_dreambooth.md" rel="nofollow">Dreambooth finetuning with BOFT</a></li> <li><a href="https://github.com/huggingface/peft/blob/main/examples/boft_controlnet/boft_controlnet.md" rel="nofollow">Controllable generation finetuning with BOFT (ControlNet)</a></li>',ve,L,ot="For the task of image classification, one can initialize the BOFT config for a DinoV2 model as follows:",ke,S,xe,V,$e,P,Oe;return g=new dt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),M=new T({props:{title:"Orthogonal Finetuning (OFT and BOFT)",local:"orthogonal-finetuning-oft-and-boft",headingTag:"h1"}}),B=new T({props:{title:"Merge OFT/BOFT weights into the base model",local:"merge-oftboft-weights-into-the-base-model",headingTag:"h2"}}),k=new T({props:{title:"Utils for OFT / BOFT",local:"utils-for-oft--boft",headingTag:"h2"}}),x=new T({props:{title:"Common OFT / BOFT parameters in PEFT",local:"common-oft--boft-parameters-in-peft",headingTag:"h3"}}),z=new T({props:{title:"OFT-specific parameters",local:"oft-specific-parameters",headingTag:"h3"}}),R=new T({props:{title:"BOFT-specific parameters",local:"boft-specific-parameters",headingTag:"h3"}}),q=new T({props:{title:"OFT Example Usage",local:"oft-example-usage",headingTag:"h2"}}),X=new it({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBPRlRDb25maWclMEElMEFpZiUyMHVzZV9xdWFudGl6YXRpb24lM0ElMEElMjAlMjAlMjAlMjBibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF9zdG9yYWdlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RibmJfY29uZmlnJTBBKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1vZGVsX25hbWUlMjIpJTBBJTBBJTIzJTIwQ29uZmlndXJlJTIwT0ZUJTBBcGVmdF9jb25maWclMjAlM0QlMjBPRlRDb25maWcoJTBBJTIwJTIwJTIwJTIwb2Z0X2Jsb2NrX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYXlsZXlfbmV1bWFubiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUwQSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRzJTVCJ3RyYWluJyU1RCUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3VtZW50cyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> OFTConfig

<span class="hljs-keyword">if</span> use_quantization:
    bnb_config = BitsAndBytesConfig(
        load_in_4bit=<span class="hljs-literal">True</span>,
        bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
        bnb_4bit_compute_dtype=torch.bfloat16,
        bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
        bnb_4bit_quant_storage=torch.bfloat16,
    )

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;model_name&quot;</span>, 
    quantization_config=bnb_config
)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;model_name&quot;</span>)

<span class="hljs-comment"># Configure OFT</span>
peft_config = OFTConfig(
    oft_block_size=<span class="hljs-number">32</span>,
    use_cayley_neumann=<span class="hljs-literal">True</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

trainer = SFTTrainer(
    model=model,
    train_dataset=ds[<span class="hljs-string">&#x27;train&#x27;</span>],
    peft_config=peft_config,
    processing_class=tokenizer,
    args=training_arguments,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),G=new T({props:{title:"BOFT Example Usage",local:"boft-example-usage",headingTag:"h2"}}),S=new it({props:{code:"aW1wb3J0JTIwdHJhbnNmb3JtZXJzJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEJPRlRDb25maWclMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMEJPRlRDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQWNvbmZpZyUyMCUzRCUyMEJPRlRDb25maWcoJTBBJTIwJTIwJTIwJTIwYm9mdF9ibG9ja19zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMGJvZnRfbl9idXR0ZXJmbHlfZmFjdG9yJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiUyQyUyMCUyMmtleSUyMiUyQyUyMCUyMm91dHB1dC5kZW5zZSUyMiUyQyUyMCUyMm1scC5mYzElMjIlMkMlMjAlMjJtbHAuZmMyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYm9mdF9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMmJvZnRfb25seSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjB0cmFuc2Zvcm1lcnMuRGlub3YyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZmFjZWJvb2slMkZkaW5vdjItbGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fbGFiZWxzJTNEMTAwJTJDJTBBKSUwQSUwQWJvZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">import</span> transformers
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, BOFTConfig
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> BOFTConfig, get_peft_model

config = BOFTConfig(
    boft_block_size=<span class="hljs-number">4</span>,
    boft_n_butterfly_factor=<span class="hljs-number">2</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>, <span class="hljs-string">&quot;key&quot;</span>, <span class="hljs-string">&quot;output.dense&quot;</span>, <span class="hljs-string">&quot;mlp.fc1&quot;</span>, <span class="hljs-string">&quot;mlp.fc2&quot;</span>],
    boft_dropout=<span class="hljs-number">0.1</span>,
    bias=<span class="hljs-string">&quot;boft_only&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)

model = transformers.Dinov2ForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;facebook/dinov2-large&quot;</span>,
    num_labels=<span class="hljs-number">100</span>,
)

boft_model = get_peft_model(model, config)`,wrap:!1}}),V=new pt({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/conceptual_guides/oft.md"}}),{c(){b=s("meta"),D=i(),Y=s("p"),K=i(),c(g.$$.fragment),ee=i(),c(M.$$.fragment),te=i(),w=s("p"),w.innerHTML=Ze,oe=i(),_=s("p"),_.textContent=Re,le=i(),J=s("p"),J.textContent=We,ie=i(),y=s("div"),y.innerHTML=Ee,ne=i(),F=s("p"),F.textContent=qe,se=i(),U=s("ul"),U.innerHTML=Ae,ae=i(),C=s("p"),C.textContent=Xe,re=i(),c(B.$$.fragment),ce=i(),j=s("p"),j.textContent=Ge,me=i(),h=s("div"),h.innerHTML=Qe,fe=i(),v=s("p"),v.textContent=He,de=i(),c(k.$$.fragment),pe=i(),c(x.$$.fragment),ue=i(),$=s("p"),$.textContent=Ne,be=i(),O=s("ol"),O.innerHTML=Le,ye=i(),c(z.$$.fragment),he=i(),I=s("p"),I.innerHTML=Se,Te=i(),Z=s("ul"),Z.innerHTML=Ve,ge=i(),c(R.$$.fragment),Me=i(),W=s("p"),W.innerHTML=Ye,we=i(),E=s("ul"),E.innerHTML=Pe,_e=i(),c(q.$$.fragment),Je=i(),A=s("p"),A.innerHTML=De,Fe=i(),c(X.$$.fragment),Ue=i(),c(G.$$.fragment),Ce=i(),Q=s("p"),Q.textContent=Ke,Be=i(),H=s("p"),H.textContent=et,je=i(),N=s("ul"),N.innerHTML=tt,ve=i(),L=s("p"),L.textContent=ot,ke=i(),c(S.$$.fragment),xe=i(),c(V.$$.fragment),$e=i(),P=s("p"),this.h()},l(e){const t=mt("svelte-u9bgzb",document.head);b=a(t,"META",{name:!0,content:!0}),t.forEach(o),D=n(e),Y=a(e,"P",{}),lt(Y).forEach(o),K=n(e),m(g.$$.fragment,e),ee=n(e),m(M.$$.fragment,e),te=n(e),w=a(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1ip40zx"&&(w.innerHTML=Ze),oe=n(e),_=a(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-91fr84"&&(_.textContent=Re),le=n(e),J=a(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-lal94n"&&(J.textContent=We),ie=n(e),y=a(e,"DIV",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-1veppqu"&&(y.innerHTML=Ee),ne=n(e),F=a(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1dyux9"&&(F.textContent=qe),se=n(e),U=a(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-1tn8i92"&&(U.innerHTML=Ae),ae=n(e),C=a(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-18dbsba"&&(C.textContent=Xe),re=n(e),m(B.$$.fragment,e),ce=n(e),j=a(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-10xuh5x"&&(j.textContent=Ge),me=n(e),h=a(e,"DIV",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-1a4qpj5"&&(h.innerHTML=Qe),fe=n(e),v=a(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-6kbdta"&&(v.textContent=He),de=n(e),m(k.$$.fragment,e),pe=n(e),m(x.$$.fragment,e),ue=n(e),$=a(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-qq3gtj"&&($.textContent=Ne),be=n(e),O=a(e,"OL",{"data-svelte-h":!0}),r(O)!=="svelte-psegni"&&(O.innerHTML=Le),ye=n(e),m(z.$$.fragment,e),he=n(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-19hbjqq"&&(I.innerHTML=Se),Te=n(e),Z=a(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-zsxfpf"&&(Z.innerHTML=Ve),ge=n(e),m(R.$$.fragment,e),Me=n(e),W=a(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1wxeuea"&&(W.innerHTML=Ye),we=n(e),E=a(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-1u1opeo"&&(E.innerHTML=Pe),_e=n(e),m(q.$$.fragment,e),Je=n(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1or7048"&&(A.innerHTML=De),Fe=n(e),m(X.$$.fragment,e),Ue=n(e),m(G.$$.fragment,e),Ce=n(e),Q=a(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1py8k9k"&&(Q.textContent=Ke),Be=n(e),H=a(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-5zw2dt"&&(H.textContent=et),je=n(e),N=a(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-yv73mp"&&(N.innerHTML=tt),ve=n(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-9y5ksw"&&(L.textContent=ot),ke=n(e),m(S.$$.fragment,e),xe=n(e),m(V.$$.fragment,e),$e=n(e),P=a(e,"P",{}),lt(P).forEach(o),this.h()},h(){ze(b,"name","hf:doc:metadata"),ze(b,"content",bt),ze(y,"class","flex justify-center"),ze(h,"class","flex justify-center")},m(e,t){ft(document.head,b),l(e,D,t),l(e,Y,t),l(e,K,t),f(g,e,t),l(e,ee,t),f(M,e,t),l(e,te,t),l(e,w,t),l(e,oe,t),l(e,_,t),l(e,le,t),l(e,J,t),l(e,ie,t),l(e,y,t),l(e,ne,t),l(e,F,t),l(e,se,t),l(e,U,t),l(e,ae,t),l(e,C,t),l(e,re,t),f(B,e,t),l(e,ce,t),l(e,j,t),l(e,me,t),l(e,h,t),l(e,fe,t),l(e,v,t),l(e,de,t),f(k,e,t),l(e,pe,t),f(x,e,t),l(e,ue,t),l(e,$,t),l(e,be,t),l(e,O,t),l(e,ye,t),f(z,e,t),l(e,he,t),l(e,I,t),l(e,Te,t),l(e,Z,t),l(e,ge,t),f(R,e,t),l(e,Me,t),l(e,W,t),l(e,we,t),l(e,E,t),l(e,_e,t),f(q,e,t),l(e,Je,t),l(e,A,t),l(e,Fe,t),f(X,e,t),l(e,Ue,t),f(G,e,t),l(e,Ce,t),l(e,Q,t),l(e,Be,t),l(e,H,t),l(e,je,t),l(e,N,t),l(e,ve,t),l(e,L,t),l(e,ke,t),f(S,e,t),l(e,xe,t),f(V,e,t),l(e,$e,t),l(e,P,t),Oe=!0},p:st,i(e){Oe||(d(g.$$.fragment,e),d(M.$$.fragment,e),d(B.$$.fragment,e),d(k.$$.fragment,e),d(x.$$.fragment,e),d(z.$$.fragment,e),d(R.$$.fragment,e),d(q.$$.fragment,e),d(X.$$.fragment,e),d(G.$$.fragment,e),d(S.$$.fragment,e),d(V.$$.fragment,e),Oe=!0)},o(e){p(g.$$.fragment,e),p(M.$$.fragment,e),p(B.$$.fragment,e),p(k.$$.fragment,e),p(x.$$.fragment,e),p(z.$$.fragment,e),p(R.$$.fragment,e),p(q.$$.fragment,e),p(X.$$.fragment,e),p(G.$$.fragment,e),p(S.$$.fragment,e),p(V.$$.fragment,e),Oe=!1},d(e){e&&(o(D),o(Y),o(K),o(ee),o(te),o(w),o(oe),o(_),o(le),o(J),o(ie),o(y),o(ne),o(F),o(se),o(U),o(ae),o(C),o(re),o(ce),o(j),o(me),o(h),o(fe),o(v),o(de),o(pe),o(ue),o($),o(be),o(O),o(ye),o(he),o(I),o(Te),o(Z),o(ge),o(Me),o(W),o(we),o(E),o(_e),o(Je),o(A),o(Fe),o(Ue),o(Ce),o(Q),o(Be),o(H),o(je),o(N),o(ve),o(L),o(ke),o(xe),o($e),o(P)),o(b),u(g,e),u(M,e),u(B,e),u(k,e),u(x,e),u(z,e),u(R,e),u(q,e),u(X,e),u(G,e),u(S,e),u(V,e)}}}const bt='{"title":"Orthogonal Finetuning (OFT and BOFT)","local":"orthogonal-finetuning-oft-and-boft","sections":[{"title":"Merge OFT/BOFT weights into the base model","local":"merge-oftboft-weights-into-the-base-model","sections":[],"depth":2},{"title":"Utils for OFT / BOFT","local":"utils-for-oft--boft","sections":[{"title":"Common OFT / BOFT parameters in PEFT","local":"common-oft--boft-parameters-in-peft","sections":[],"depth":3},{"title":"OFT-specific parameters","local":"oft-specific-parameters","sections":[],"depth":3},{"title":"BOFT-specific parameters","local":"boft-specific-parameters","sections":[],"depth":3}],"depth":2},{"title":"OFT Example Usage","local":"oft-example-usage","sections":[],"depth":2},{"title":"BOFT Example Usage","local":"boft-example-usage","sections":[],"depth":2}],"depth":1}';function yt(Ie){return at(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wt extends rt{constructor(b){super(),ct(this,b,yt,ut,nt,{})}}export{wt as component};
