import{s as Rl,n as El,o as Vl}from"../chunks/scheduler.78382b47.js";import{S as Xl,i as Fl,e as o,s as n,c as p,h as Nl,a as i,d as l,b as a,f as Bl,g as r,j as m,k as _e,l as Al,m as s,n as c,t as d,o as u,p as y}from"../chunks/index.6dd35eb6.js";import{C as Yl,H as ve,E as Hl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8d7e60c0.js";import{C as M}from"../chunks/CodeBlock.4d4112a9.js";function Sl(zt){let h,We,Le,Ie,T,$e,J,Be,j,qt=`Some fine-tuning techniques, such as prompt tuning, are specific to language models. That means in 🤗 PEFT, it is
assumed a 🤗 Transformers model is being used. However, other fine-tuning techniques - like
<a href="../conceptual_guides/lora">LoRA</a> - are not restricted to specific model types.`,Re,g,Pt='In this guide, we will see how LoRA can be applied to a multilayer perceptron, a computer vision model from the <a href="https://huggingface.co/docs/timm/index" rel="nofollow">timm</a> library, or a new 🤗 Transformers architecture.',Ee,k,Ve,x,Dt="Let’s assume that we want to fine-tune a multilayer perceptron with LoRA. Here is the definition:",Xe,U,Fe,Z,Kt="This is a straightforward multilayer perceptron with an input layer, a hidden layer, and an output layer.",Ne,f,Ot=`<p>For this toy example, we choose an exceedingly large number of hidden units to highlight the efficiency gains
from PEFT, but those gains are in line with more realistic examples.</p>`,Ae,C,el=`There are a few linear layers in this model that could be tuned with LoRA. When working with common 🤗 Transformers
models, PEFT will know which layers to apply LoRA to, but in this case, it is up to us as a user to choose the layers.
To determine the names of the layers to tune:`,Ye,v,He,L,tl="This should print:",Se,G,Qe,_,ll=`Let’s say we want to apply LoRA to the input layer and to the hidden layer, those are <code>&#39;seq.0&#39;</code> and <code>&#39;seq.2&#39;</code>. Moreover,
let’s assume we want to update the output layer without LoRA, that would be <code>&#39;seq.4&#39;</code>. The corresponding config would
be:`,ze,W,qe,I,sl="With that, we can create our PEFT model and check the fraction of parameters trained:",Pe,$,De,B,nl="Finally, we can use any training framework we like, or write our own fit loop, to train the <code>peft_model</code>.",Ke,R,al='For a complete example, check out <a href="https://github.com/huggingface/peft/blob/main/examples/multilayer_perceptron/multilayer_perceptron_lora.ipynb" rel="nofollow">this notebook</a>.',Oe,E,et,V,ol=`The <a href="https://huggingface.co/docs/timm/index" rel="nofollow">timm</a> library contains a large number of pretrained computer vision models.
Those can also be fine-tuned with PEFT. Let’s check out how this works in practice.`,tt,X,il="To start, ensure that timm is installed in the Python environment:",lt,F,st,N,ml="Next we load a timm model for an image classification task:",nt,A,at,Y,pl=`Again, we need to make a decision about what layers to apply LoRA to. Since LoRA supports 2D conv layers, and since
those are a major building block of this model, we should apply LoRA to the 2D conv layers. To identify the names of
those layers, let’s look at all the layer names:`,ot,H,it,S,rl="This will print a very long list, we’ll only show the first few:",mt,Q,pt,z,cl=`Upon closer inspection, we see that the 2D conv layers have names such as <code>&quot;stages.0.blocks.0.mlp.fc1&quot;</code> and
<code>&quot;stages.0.blocks.0.mlp.fc2&quot;</code>. How can we match those layer names specifically? You can write a <a href="https://docs.python.org/3/library/re.html" rel="nofollow">regular
expressions</a> to match the layer names. For our case, the regex
<code>r&quot;.*\\.mlp\\.fc\\d&quot;</code> should do the job.`,rt,q,dl=`Furthermore, as in the first example, we should ensure that the output layer, in this case the classification head, is
also updated. Looking at the end of the list printed above, we can see that it’s named <code>&#39;head.fc&#39;</code>. With that in mind,
here is our LoRA config:`,ct,P,dt,D,ul="Then we only need to create the PEFT model by passing our base model and the config to <code>get_peft_model</code>:",ut,K,yt,O,yl="This shows us that we only need to train less than 2% of all parameters, which is a huge efficiency gain.",Mt,ee,Ml='For a complete example, check out <a href="https://github.com/huggingface/peft/blob/main/examples/image_classification/image_classification_timm_peft_lora.ipynb" rel="nofollow">this notebook</a>.',ht,te,ft,le,hl="When new popular transformers architectures are released, we do our best to quickly add them to PEFT. If you come across a transformers model that is not supported out of the box, don’t worry, it will most likely still work if the config is set correctly. Specifically, you have to identify the layers that should be adapted and set them correctly when initializing the corresponding config class, e.g. <code>LoraConfig</code>. Here are some tips to help with this.",bt,se,fl='As a first step, it is a good idea to check the existing models for inspiration. You can find them inside of <a href="https://github.com/huggingface/peft/blob/main/src/peft/utils/constants.py" rel="nofollow">constants.py</a> in the PEFT repository. Often, you’ll find a similar architecture that uses the same names. For example, if the new model architecture is a variation of the “mistral” model and you want to apply LoRA, you can see that the entry for “mistral” in <code>TRANSFORMERS_MODELS_TO_LORA_TARGET_MODULES_MAPPING</code> contains <code>[&quot;q_proj&quot;, &quot;v_proj&quot;]</code>. This tells you that for “mistral” models, the <code>target_modules</code> for LoRA should be <code>[&quot;q_proj&quot;, &quot;v_proj&quot;]</code>:',wt,ne,Tt,ae,bl="If that doesn’t help, check the existing modules in your model architecture with the <code>named_modules</code> method and try to identify the attention layers, especially the key, query, and value layers. Those will often have names such as <code>c_attn</code>, <code>query</code>, <code>q_proj</code>, etc. The key layer is not always adapted, and ideally, you should check whether including it results in better performance.",Jt,oe,wl='Additionally, linear layers are common targets to be adapted (e.g. in <a href="https://huggingface.co/papers/2305.14314" rel="nofollow">QLoRA paper</a>, authors suggest to adapt them as well). Their names will often contain the strings <code>fc</code> or <code>dense</code>.',jt,ie,Tl='If you want to add a new model to PEFT, please create an entry in <a href="https://github.com/huggingface/peft/blob/main/src/peft/utils/constants.py" rel="nofollow">constants.py</a> and open a pull request on the <a href="https://github.com/huggingface/peft/pulls" rel="nofollow">repository</a>. Don’t forget to update the <a href="https://github.com/huggingface/peft#models-support-matrix" rel="nofollow">README</a> as well.',gt,me,kt,pe,Jl="You can verify whether you’ve correctly applied a PEFT method to your model in a few ways.",xt,re,jl='<li>Check the fraction of parameters that are trainable with the <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method. If this number is lower or higher than expected, check the model <code>repr</code> by printing the model. This shows the names of all the layer types in the model. Ensure that only the intended target layers are replaced by the adapter layers. For example, if LoRA is applied to <code>nn.Linear</code> layers, then you should only see <code>lora.Linear</code> layers being used.</li>',Ut,ce,Zt,de,gl="<li>Another way you can view the adapted layers is to use the <code>targeted_module_names</code> attribute to list the name of each module that was adapted.</li>",Ct,ue,vt,ye,Lt,Me,kl="Methods like LoRA only work if the target modules are supported by PEFT. For example, it’s possible to apply LoRA to <code>nn.Linear</code> and <code>nn.Conv2d</code> layers, but not, for instance, to <code>nn.LSTM</code>. If you find a layer class you want to apply PEFT to is not supported, you can:",Gt,he,xl='<li>define a custom mapping to dynamically dispatch custom modules in LoRA</li> <li>open an <a href="https://github.com/huggingface/peft/issues" rel="nofollow">issue</a> and request the feature where maintainers will implement it or guide you on how to implement it yourself if demand for this module type is sufficiently high</li>',_t,fe,Wt,b,Ul="<p>This feature is experimental and subject to change, depending on its reception by the community. We will introduce a public and stable API if there is significant demand for it.</p>",It,be,Zl="PEFT supports an experimental API for custom module types for LoRA. Let’s assume you have a LoRA implementation for LSTMs. Normally, you would not be able to tell PEFT to use it, even if it would theoretically work with PEFT. However, this is possible with dynamic dispatch of custom layers.",$t,we,Cl="The experimental API currently looks like this:",Bt,Te,Rt,w,vl='<p>When you call <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a>, you will see a warning because PEFT does not recognize the targeted module type. In this case, you can ignore this warning.</p>',Et,Je,Ll="By supplying a custom mapping, PEFT first checks the base model’s layers against the custom mapping and dispatches to the custom LoRA layer type if there is a match. If there is no match, PEFT checks the built-in LoRA layer types for a match.",Vt,je,Gl="Therefore, this feature can also be used to override existing dispatch logic, e.g. if you want to use your own LoRA layer for <code>nn.Linear</code> instead of using the one provided by PEFT.",Xt,ge,_l='When creating your custom LoRA module, please follow the same rules as the <a href="https://github.com/huggingface/peft/blob/main/src/peft/tuners/lora/layer.py" rel="nofollow">existing LoRA modules</a>. Some important constraints to consider:',Ft,ke,Wl="<li>The custom module should inherit from <code>nn.Module</code> and <code>peft.tuners.lora.layer.LoraLayer</code>.</li> <li>The <code>__init__</code> method of the custom module should have the positional arguments <code>base_layer</code> and <code>adapter_name</code>. After this, there are additional <code>**kwargs</code> that you are free to use or ignore.</li> <li>The learnable parameters should be stored in an <code>nn.ModuleDict</code> or <code>nn.ParameterDict</code>, where the key corresponds to the name of the specific adapter (remember that a model can have more than one adapter at a time).</li> <li>The name of these learnable parameter attributes should start with <code>&quot;lora_&quot;</code>, e.g. <code>self.lora_new_param = ...</code>.</li> <li>Some methods are optional, e.g. you only need to implement <code>merge</code> and <code>unmerge</code> if you want to support weight merging.</li>",Nt,xe,Il="Currently, the information about the custom module does not persist when you save the model. When loading the model, you have to register the custom modules again.",At,Ue,Yt,Ze,$l="If you use this feature and find it useful, or if you encounter problems, let us know by creating an issue or a discussion on GitHub. This allows us to estimate the demand for this feature and add a public API if it is sufficiently high.",Ht,Ce,St,Ge,Qt;return T=new Yl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new ve({props:{title:"Custom models",local:"custom-models",headingTag:"h1"}}),k=new ve({props:{title:"Multilayer perceptron",local:"multilayer-perceptron",headingTag:"h2"}}),U=new M({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyME1MUChubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG51bV91bml0c19oaWRkZW4lM0QyMDAwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuc2VxJTIwJTNEJTIwbm4uU2VxdWVudGlhbCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5MaW5lYXIoMjAlMkMlMjBudW1fdW5pdHNfaGlkZGVuKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLlJlTFUoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLkxpbmVhcihudW1fdW5pdHNfaGlkZGVuJTJDJTIwbnVtX3VuaXRzX2hpZGRlbiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5SZUxVKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5MaW5lYXIobnVtX3VuaXRzX2hpZGRlbiUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uTG9nU29mdG1heChkaW0lM0QtMSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwWCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLnNlcShYKQ==",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MLP</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_units_hidden=<span class="hljs-number">2000</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.seq = nn.Sequential(
            nn.Linear(<span class="hljs-number">20</span>, num_units_hidden),
            nn.ReLU(),
            nn.Linear(num_units_hidden, num_units_hidden),
            nn.ReLU(),
            nn.Linear(num_units_hidden, <span class="hljs-number">2</span>),
            nn.LogSoftmax(dim=-<span class="hljs-number">1</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, X</span>):
        <span class="hljs-keyword">return</span> self.seq(X)`,wrap:!1}}),v=new M({props:{code:"cHJpbnQoJTVCKG4lMkMlMjB0eXBlKG0pKSUyMGZvciUyMG4lMkMlMjBtJTIwaW4lMjBNTFAoKS5uYW1lZF9tb2R1bGVzKCklNUQp",highlighted:'<span class="hljs-built_in">print</span>([(n, <span class="hljs-built_in">type</span>(m)) <span class="hljs-keyword">for</span> n, m <span class="hljs-keyword">in</span> MLP().named_modules()])',wrap:!1}}),G=new M({props:{code:"JTVCKCcnJTJDJTIwX19tYWluX18uTUxQKSUyQyUwQSUyMCgnc2VxJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMuY29udGFpbmVyLlNlcXVlbnRpYWwpJTJDJTBBJTIwKCdzZXEuMCclMkMlMjB0b3JjaC5ubi5tb2R1bGVzLmxpbmVhci5MaW5lYXIpJTJDJTBBJTIwKCdzZXEuMSclMkMlMjB0b3JjaC5ubi5tb2R1bGVzLmFjdGl2YXRpb24uUmVMVSklMkMlMEElMjAoJ3NlcS4yJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMubGluZWFyLkxpbmVhciklMkMlMEElMjAoJ3NlcS4zJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMuYWN0aXZhdGlvbi5SZUxVKSUyQyUwQSUyMCgnc2VxLjQnJTJDJTIwdG9yY2gubm4ubW9kdWxlcy5saW5lYXIuTGluZWFyKSUyQyUwQSUyMCgnc2VxLjUnJTJDJTIwdG9yY2gubm4ubW9kdWxlcy5hY3RpdmF0aW9uLkxvZ1NvZnRtYXgpJTVE",highlighted:`[(&#x27;&#x27;, __main__.MLP),
 (<span class="hljs-symbol">&#x27;seq</span>&#x27;, torch.nn.modules.container.Sequential),
 (<span class="hljs-symbol">&#x27;seq.0</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.1</span>&#x27;, torch.nn.modules.activation.ReLU),
 (<span class="hljs-symbol">&#x27;seq.2</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.3</span>&#x27;, torch.nn.modules.activation.ReLU),
 (<span class="hljs-symbol">&#x27;seq.4</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.5</span>&#x27;, torch.nn.modules.activation.LogSoftmax)]`,wrap:!1}}),W=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnNlcS4wJTIyJTJDJTIwJTIyc2VxLjIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMjJzZXEuNCUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;seq.0&quot;</span>, <span class="hljs-string">&quot;seq.2&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;seq.4&quot;</span>],
)`,wrap:!1}}),$=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwTUxQKCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcpJTBBcGVmdF9tb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIzJTIwcHJpbnRzJTIwdHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNTYlMkMxNjQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA0JTJDMTAwJTJDMTY0JTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS4zNjk3OTg4NjY1ODE5MjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = MLP()
peft_model = get_peft_model(model, config)
peft_model.print_trainable_parameters()
<span class="hljs-comment"># prints trainable params: 56,164 || all params: 4,100,164 || trainable%: 1.369798866581922</span>`,wrap:!1}}),E=new ve({props:{title:"timm models",local:"timm-models",headingTag:"h2"}}),F=new M({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjB0aW1t",highlighted:"python -m pip install -U timm",wrap:!1}}),A=new M({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQW51bV9jbGFzc2VzJTIwJTNEJTIwLi4uJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJ0aW1tJTJGcG9vbGZvcm1lcl9tMzYuc2FpbF9pbjFrJTIyJTBBbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbChtb2RlbF9pZCUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fY2xhc3Nlcyk=",highlighted:`<span class="hljs-keyword">import</span> timm

num_classes = ...
model_id = <span class="hljs-string">&quot;timm/poolformer_m36.sail_in1k&quot;</span>
model = timm.create_model(model_id, pretrained=<span class="hljs-literal">True</span>, num_classes=num_classes)`,wrap:!1}}),H=new M({props:{code:"cHJpbnQoJTVCKG4lMkMlMjB0eXBlKG0pKSUyMGZvciUyMG4lMkMlMjBtJTIwaW4lMjBtb2RlbC5uYW1lZF9tb2R1bGVzKCklNUQp",highlighted:'<span class="hljs-built_in">print</span>([(n, <span class="hljs-built_in">type</span>(m)) <span class="hljs-keyword">for</span> n, m <span class="hljs-keyword">in</span> model.named_modules()])',wrap:!1}}),Q=new M({props:{code:"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",highlighted:`[(<span class="hljs-string">&#x27;&#x27;</span>, timm.models.metaformer.MetaFormer),
 (<span class="hljs-string">&#x27;stem&#x27;</span>, timm.models.metaformer.Stem),
 (<span class="hljs-string">&#x27;stem.conv&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stem.norm&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.container.Sequential),
 (<span class="hljs-string">&#x27;stages.0&#x27;</span>, timm.models.metaformer.MetaFormerStage),
 (<span class="hljs-string">&#x27;stages.0.downsample&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.container.Sequential),
 (<span class="hljs-string">&#x27;stages.0.blocks.0&#x27;</span>, timm.models.metaformer.MetaFormerBlock),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.norm1&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.token_mixer&#x27;</span>, timm.models.metaformer.Pooling),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.token_mixer.pool&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.pooling.AvgPool2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.drop_path1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.layer_scale1&#x27;</span>, timm.models.metaformer.Scale),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.res_scale1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.norm2&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp&#x27;</span>, timm.layers.mlp.Mlp),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.fc1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.act&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.activation.GELU),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.drop1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.dropout.Dropout),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.norm&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.fc2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.drop2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.dropout.Dropout),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.drop_path2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.layer_scale2&#x27;</span>, timm.models.metaformer.Scale),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.res_scale2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.1&#x27;</span>, timm.models.metaformer.MetaFormerBlock),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.norm1&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.token_mixer&#x27;</span>, timm.models.metaformer.Pooling),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.token_mixer.pool&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.pooling.AvgPool2d),
 ...
 (<span class="hljs-string">&#x27;head.global_pool.flatten&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;head.norm&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.LayerNorm2d),
 (<span class="hljs-string">&#x27;head.flatten&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.flatten.Flatten),
 (<span class="hljs-string">&#x27;head.drop&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;head.fc&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Linear)]
 ]`,wrap:!1}}),P=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRHIlMjIuKiU1Qy5tbHAlNUMuZmMlNUNkJTIyJTJDJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyaGVhZC5mYyUyMiU1RCk=",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">r&quot;.*\\.mlp\\.fc\\d&quot;</span>, modules_to_save=[<span class="hljs-string">&quot;head.fc&quot;</span>])',wrap:!1}}),K=new M({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKSUwQXBlZnRfbW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKSUwQSUyMyUyMHByaW50cyUyMHRyYWluYWJsZSUyMHBhcmFtcyUzQSUyMDElMkMwNjQlMkM0NTQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA1NiUyQzQ2NyUyQzk3NCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDEuODg1MDU3ODkxMzk4NzY=",highlighted:`peft_model = get_peft_model(model, config)
peft_model.print_trainable_parameters()
<span class="hljs-comment"># prints trainable params: 1,064,454 || all params: 56,467,974 || trainable%: 1.88505789139876</span>`,wrap:!1}}),te=new ve({props:{title:"New transformers architectures",local:"new-transformers-architectures",headingTag:"h2"}}),ne=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFteV9taXN0cmFsX21vZGVsJTIwJTNEJTIwLi4uJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnFfcHJvaiUyMiUyQyUyMCUyMnZfcHJvaiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMC4uLiUyQyUyMCUyMCUyMyUyMG90aGVyJTIwTG9SQSUyMGFyZ3VtZW50cyUwQSklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobXlfbWlzdHJhbF9tb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

my_mistral_model = ...
config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],
    ...,  <span class="hljs-comment"># other LoRA arguments</span>
)
peft_model = get_peft_model(my_mistral_model, config)`,wrap:!1}}),me=new ve({props:{title:"Verify parameters and layers",local:"verify-parameters-and-layers",headingTag:"h2"}}),ce=new M({props:{code:"cGVmdF9tb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygp",highlighted:"peft_model.print_trainable_parameters()",wrap:!1}}),ue=new M({props:{code:"cHJpbnQocGVmdF9tb2RlbC50YXJnZXRlZF9tb2R1bGVfbmFtZXMp",highlighted:'<span class="hljs-built_in">print</span>(peft_model.targeted_module_names)',wrap:!1}}),ye=new ve({props:{title:"Unsupported module types",local:"unsupported-module-types",headingTag:"h2"}}),fe=new ve({props:{title:"Experimental support for dynamic dispatch of custom modules in LoRA",local:"experimental-support-for-dynamic-dispatch-of-custom-modules-in-lora",headingTag:"h3"}}),Te=new M({props:{code:"Y2xhc3MlMjBNeUxvcmFMU1RNTGF5ZXIlM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwLi4uJTIwJTIwJTIzJTIwbG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyMHRoYXQlMjB1c2VzJTIwTFNUTXMlMEElMEElMjMlMjBhZGQlMjB0aGUlMjBMU1RNJTIwbGF5ZXIlMjBuYW1lcyUyMHRvJTIwdGFyZ2V0X21vZHVsZXMlMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiUyQyUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIybHN0bSUyMiU1RCklMEElMjMlMjBkZWZpbmUlMjBhJTIwbWFwcGluZyUyMGZyb20lMjBiYXNlJTIwbGF5ZXIlMjB0eXBlJTIwdG8lMjBMb1JBJTIwbGF5ZXIlMjB0eXBlJTBBY3VzdG9tX21vZHVsZV9tYXBwaW5nJTIwJTNEJTIwJTdCbm4uTFNUTSUzQSUyME15TG9yYUxTVE1MYXllciU3RCUwQSUyMyUyMHJlZ2lzdGVyJTIwdGhlJTIwbmV3JTIwbWFwcGluZyUwQWNvbmZpZy5fcmVnaXN0ZXJfY3VzdG9tX21vZHVsZShjdXN0b21fbW9kdWxlX21hcHBpbmcpJTBBJTIzJTIwYWZ0ZXIlMjByZWdpc3RyYXRpb24lMkMlMjBjcmVhdGUlMjB0aGUlMjBQRUZUJTIwbW9kZWwlMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoYmFzZV9tb2RlbCUyQyUyMGNvbmZpZyklMEElMjMlMjBkbyUyMHRyYWluaW5n",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyLoraLSTMLayer</span>:
    ...

base_model = ...  <span class="hljs-comment"># load the base model that uses LSTMs</span>

<span class="hljs-comment"># add the LSTM layer names to target_modules</span>
config = LoraConfig(..., target_modules=[<span class="hljs-string">&quot;lstm&quot;</span>])
<span class="hljs-comment"># define a mapping from base layer type to LoRA layer type</span>
custom_module_mapping = {nn.LSTM: MyLoraLSTMLayer}
<span class="hljs-comment"># register the new mapping</span>
config._register_custom_module(custom_module_mapping)
<span class="hljs-comment"># after registration, create the PEFT model</span>
peft_model = get_peft_model(base_model, config)
<span class="hljs-comment"># do training</span>`,wrap:!1}}),Ue=new M({props:{code:"JTIzJTIwc2F2aW5nJTIwd29ya3MlMjBhcyUyMGFsd2F5cyUyMGFuZCUyMGluY2x1ZGVzJTIwdGhlJTIwcGFyYW1ldGVycyUyMG9mJTIwdGhlJTIwY3VzdG9tJTIwbW9kdWxlcyUwQXBlZnRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUzQ21vZGVsLXBhdGglM0UpJTBBJTBBJTIzJTIwbG9hZGluZyUyMHRoZSUyMG1vZGVsJTIwbGF0ZXIlM0ElMEFiYXNlX21vZGVsJTIwJTNEJTIwLi4uJTBBJTIzJTIwbG9hZCUyMHRoZSUyMExvUkElMjBjb25maWclMjB0aGF0JTIweW91JTIwc2F2ZWQlMjBlYXJsaWVyJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTNDbW9kZWwtcGF0aCUzRSklMEElMjMlMjByZWdpc3RlciUyMHRoZSUyMGN1c3RvbSUyMG1vZHVsZSUyMGFnYWluJTJDJTIwdGhlJTIwc2FtZSUyMHdheSUyMGFzJTIwdGhlJTIwZmlyc3QlMjB0aW1lJTBBY3VzdG9tX21vZHVsZV9tYXBwaW5nJTIwJTNEJTIwJTdCbm4uTFNUTSUzQSUyME15TG9yYUxTVE1MYXllciU3RCUwQWNvbmZpZy5fcmVnaXN0ZXJfY3VzdG9tX21vZHVsZShjdXN0b21fbW9kdWxlX21hcHBpbmcpJTBBJTIzJTIwcGFzcyUyMHRoZSUyMGNvbmZpZyUyMGluc3RhbmNlJTIwdG8lMjBmcm9tX3ByZXRyYWluZWQlM0ElMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMHRtcF9wYXRoJTIwJTJGJTIwJTIybG9yYS1jdXN0b20tbW9kdWxlJTIyJTJDJTIwY29uZmlnJTNEY29uZmlnKQ==",highlighted:`<span class="hljs-comment"># saving works as always and includes the parameters of the custom modules</span>
peft_model.save_pretrained(&lt;model-path&gt;)

<span class="hljs-comment"># loading the model later:</span>
base_model = ...
<span class="hljs-comment"># load the LoRA config that you saved earlier</span>
config = LoraConfig.from_pretrained(&lt;model-path&gt;)
<span class="hljs-comment"># register the custom module again, the same way as the first time</span>
custom_module_mapping = {nn.LSTM: MyLoraLSTMLayer}
config._register_custom_module(custom_module_mapping)
<span class="hljs-comment"># pass the config instance to from_pretrained:</span>
peft_model = PeftModel.from_pretrained(model, tmp_path / <span class="hljs-string">&quot;lora-custom-module&quot;</span>, config=config)`,wrap:!1}}),Ce=new Hl({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/custom_models.md"}}),{c(){h=o("meta"),We=n(),Le=o("p"),Ie=n(),p(T.$$.fragment),$e=n(),p(J.$$.fragment),Be=n(),j=o("p"),j.innerHTML=qt,Re=n(),g=o("p"),g.innerHTML=Pt,Ee=n(),p(k.$$.fragment),Ve=n(),x=o("p"),x.textContent=Dt,Xe=n(),p(U.$$.fragment),Fe=n(),Z=o("p"),Z.textContent=Kt,Ne=n(),f=o("blockquote"),f.innerHTML=Ot,Ae=n(),C=o("p"),C.textContent=el,Ye=n(),p(v.$$.fragment),He=n(),L=o("p"),L.textContent=tl,Se=n(),p(G.$$.fragment),Qe=n(),_=o("p"),_.innerHTML=ll,ze=n(),p(W.$$.fragment),qe=n(),I=o("p"),I.textContent=sl,Pe=n(),p($.$$.fragment),De=n(),B=o("p"),B.innerHTML=nl,Ke=n(),R=o("p"),R.innerHTML=al,Oe=n(),p(E.$$.fragment),et=n(),V=o("p"),V.innerHTML=ol,tt=n(),X=o("p"),X.textContent=il,lt=n(),p(F.$$.fragment),st=n(),N=o("p"),N.textContent=ml,nt=n(),p(A.$$.fragment),at=n(),Y=o("p"),Y.textContent=pl,ot=n(),p(H.$$.fragment),it=n(),S=o("p"),S.textContent=rl,mt=n(),p(Q.$$.fragment),pt=n(),z=o("p"),z.innerHTML=cl,rt=n(),q=o("p"),q.innerHTML=dl,ct=n(),p(P.$$.fragment),dt=n(),D=o("p"),D.innerHTML=ul,ut=n(),p(K.$$.fragment),yt=n(),O=o("p"),O.textContent=yl,Mt=n(),ee=o("p"),ee.innerHTML=Ml,ht=n(),p(te.$$.fragment),ft=n(),le=o("p"),le.innerHTML=hl,bt=n(),se=o("p"),se.innerHTML=fl,wt=n(),p(ne.$$.fragment),Tt=n(),ae=o("p"),ae.innerHTML=bl,Jt=n(),oe=o("p"),oe.innerHTML=wl,jt=n(),ie=o("p"),ie.innerHTML=Tl,gt=n(),p(me.$$.fragment),kt=n(),pe=o("p"),pe.textContent=Jl,xt=n(),re=o("ul"),re.innerHTML=jl,Ut=n(),p(ce.$$.fragment),Zt=n(),de=o("ul"),de.innerHTML=gl,Ct=n(),p(ue.$$.fragment),vt=n(),p(ye.$$.fragment),Lt=n(),Me=o("p"),Me.innerHTML=kl,Gt=n(),he=o("ul"),he.innerHTML=xl,_t=n(),p(fe.$$.fragment),Wt=n(),b=o("blockquote"),b.innerHTML=Ul,It=n(),be=o("p"),be.textContent=Zl,$t=n(),we=o("p"),we.textContent=Cl,Bt=n(),p(Te.$$.fragment),Rt=n(),w=o("blockquote"),w.innerHTML=vl,Et=n(),Je=o("p"),Je.textContent=Ll,Vt=n(),je=o("p"),je.innerHTML=Gl,Xt=n(),ge=o("p"),ge.innerHTML=_l,Ft=n(),ke=o("ul"),ke.innerHTML=Wl,Nt=n(),xe=o("p"),xe.textContent=Il,At=n(),p(Ue.$$.fragment),Yt=n(),Ze=o("p"),Ze.textContent=$l,Ht=n(),p(Ce.$$.fragment),St=n(),Ge=o("p"),this.h()},l(e){const t=Nl("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(l),We=a(e),Le=i(e,"P",{}),Bl(Le).forEach(l),Ie=a(e),r(T.$$.fragment,e),$e=a(e),r(J.$$.fragment,e),Be=a(e),j=i(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1twj2ga"&&(j.innerHTML=qt),Re=a(e),g=i(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-14u0q1"&&(g.innerHTML=Pt),Ee=a(e),r(k.$$.fragment,e),Ve=a(e),x=i(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1vzm18b"&&(x.textContent=Dt),Xe=a(e),r(U.$$.fragment,e),Fe=a(e),Z=i(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-ifflo"&&(Z.textContent=Kt),Ne=a(e),f=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(f)!=="svelte-z1rh00"&&(f.innerHTML=Ot),Ae=a(e),C=i(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-19hnh19"&&(C.textContent=el),Ye=a(e),r(v.$$.fragment,e),He=a(e),L=i(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-47m0b6"&&(L.textContent=tl),Se=a(e),r(G.$$.fragment,e),Qe=a(e),_=i(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-hvbljg"&&(_.innerHTML=ll),ze=a(e),r(W.$$.fragment,e),qe=a(e),I=i(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-12m4713"&&(I.textContent=sl),Pe=a(e),r($.$$.fragment,e),De=a(e),B=i(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-3iyeuu"&&(B.innerHTML=nl),Ke=a(e),R=i(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-12a8po"&&(R.innerHTML=al),Oe=a(e),r(E.$$.fragment,e),et=a(e),V=i(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1el2qhw"&&(V.innerHTML=ol),tt=a(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-132k8n8"&&(X.textContent=il),lt=a(e),r(F.$$.fragment,e),st=a(e),N=i(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1i7knza"&&(N.textContent=ml),nt=a(e),r(A.$$.fragment,e),at=a(e),Y=i(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-66d7qt"&&(Y.textContent=pl),ot=a(e),r(H.$$.fragment,e),it=a(e),S=i(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-132x2pj"&&(S.textContent=rl),mt=a(e),r(Q.$$.fragment,e),pt=a(e),z=i(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-odd6w6"&&(z.innerHTML=cl),rt=a(e),q=i(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-vtvaop"&&(q.innerHTML=dl),ct=a(e),r(P.$$.fragment,e),dt=a(e),D=i(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1ym7j5n"&&(D.innerHTML=ul),ut=a(e),r(K.$$.fragment,e),yt=a(e),O=i(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1a6hk12"&&(O.textContent=yl),Mt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-13ceymq"&&(ee.innerHTML=Ml),ht=a(e),r(te.$$.fragment,e),ft=a(e),le=i(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-zh7y7t"&&(le.innerHTML=hl),bt=a(e),se=i(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1hpkhh2"&&(se.innerHTML=fl),wt=a(e),r(ne.$$.fragment,e),Tt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-tkcysf"&&(ae.innerHTML=bl),Jt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-1x641jx"&&(oe.innerHTML=wl),jt=a(e),ie=i(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-485c9z"&&(ie.innerHTML=Tl),gt=a(e),r(me.$$.fragment,e),kt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-g4uxja"&&(pe.textContent=Jl),xt=a(e),re=i(e,"UL",{"data-svelte-h":!0}),m(re)!=="svelte-1sxqmgi"&&(re.innerHTML=jl),Ut=a(e),r(ce.$$.fragment,e),Zt=a(e),de=i(e,"UL",{"data-svelte-h":!0}),m(de)!=="svelte-1lks9wd"&&(de.innerHTML=gl),Ct=a(e),r(ue.$$.fragment,e),vt=a(e),r(ye.$$.fragment,e),Lt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1nivrxo"&&(Me.innerHTML=kl),Gt=a(e),he=i(e,"UL",{"data-svelte-h":!0}),m(he)!=="svelte-1pyzk0w"&&(he.innerHTML=xl),_t=a(e),r(fe.$$.fragment,e),Wt=a(e),b=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-1vrnyaz"&&(b.innerHTML=Ul),It=a(e),be=i(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1ve93t1"&&(be.textContent=Zl),$t=a(e),we=i(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-hzxzie"&&(we.textContent=Cl),Bt=a(e),r(Te.$$.fragment,e),Rt=a(e),w=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(w)!=="svelte-csfsth"&&(w.innerHTML=vl),Et=a(e),Je=i(e,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-1rh0r2d"&&(Je.textContent=Ll),Vt=a(e),je=i(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-1p8m775"&&(je.innerHTML=Gl),Xt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-qp8f4l"&&(ge.innerHTML=_l),Ft=a(e),ke=i(e,"UL",{"data-svelte-h":!0}),m(ke)!=="svelte-c8ydbv"&&(ke.innerHTML=Wl),Nt=a(e),xe=i(e,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-1bmvvdg"&&(xe.textContent=Il),At=a(e),r(Ue.$$.fragment,e),Yt=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-n2s6f5"&&(Ze.textContent=$l),Ht=a(e),r(Ce.$$.fragment,e),St=a(e),Ge=i(e,"P",{}),Bl(Ge).forEach(l),this.h()},h(){_e(h,"name","hf:doc:metadata"),_e(h,"content",Ql),_e(f,"class","tip"),_e(b,"class","warning"),_e(w,"class","tip")},m(e,t){Al(document.head,h),s(e,We,t),s(e,Le,t),s(e,Ie,t),c(T,e,t),s(e,$e,t),c(J,e,t),s(e,Be,t),s(e,j,t),s(e,Re,t),s(e,g,t),s(e,Ee,t),c(k,e,t),s(e,Ve,t),s(e,x,t),s(e,Xe,t),c(U,e,t),s(e,Fe,t),s(e,Z,t),s(e,Ne,t),s(e,f,t),s(e,Ae,t),s(e,C,t),s(e,Ye,t),c(v,e,t),s(e,He,t),s(e,L,t),s(e,Se,t),c(G,e,t),s(e,Qe,t),s(e,_,t),s(e,ze,t),c(W,e,t),s(e,qe,t),s(e,I,t),s(e,Pe,t),c($,e,t),s(e,De,t),s(e,B,t),s(e,Ke,t),s(e,R,t),s(e,Oe,t),c(E,e,t),s(e,et,t),s(e,V,t),s(e,tt,t),s(e,X,t),s(e,lt,t),c(F,e,t),s(e,st,t),s(e,N,t),s(e,nt,t),c(A,e,t),s(e,at,t),s(e,Y,t),s(e,ot,t),c(H,e,t),s(e,it,t),s(e,S,t),s(e,mt,t),c(Q,e,t),s(e,pt,t),s(e,z,t),s(e,rt,t),s(e,q,t),s(e,ct,t),c(P,e,t),s(e,dt,t),s(e,D,t),s(e,ut,t),c(K,e,t),s(e,yt,t),s(e,O,t),s(e,Mt,t),s(e,ee,t),s(e,ht,t),c(te,e,t),s(e,ft,t),s(e,le,t),s(e,bt,t),s(e,se,t),s(e,wt,t),c(ne,e,t),s(e,Tt,t),s(e,ae,t),s(e,Jt,t),s(e,oe,t),s(e,jt,t),s(e,ie,t),s(e,gt,t),c(me,e,t),s(e,kt,t),s(e,pe,t),s(e,xt,t),s(e,re,t),s(e,Ut,t),c(ce,e,t),s(e,Zt,t),s(e,de,t),s(e,Ct,t),c(ue,e,t),s(e,vt,t),c(ye,e,t),s(e,Lt,t),s(e,Me,t),s(e,Gt,t),s(e,he,t),s(e,_t,t),c(fe,e,t),s(e,Wt,t),s(e,b,t),s(e,It,t),s(e,be,t),s(e,$t,t),s(e,we,t),s(e,Bt,t),c(Te,e,t),s(e,Rt,t),s(e,w,t),s(e,Et,t),s(e,Je,t),s(e,Vt,t),s(e,je,t),s(e,Xt,t),s(e,ge,t),s(e,Ft,t),s(e,ke,t),s(e,Nt,t),s(e,xe,t),s(e,At,t),c(Ue,e,t),s(e,Yt,t),s(e,Ze,t),s(e,Ht,t),c(Ce,e,t),s(e,St,t),s(e,Ge,t),Qt=!0},p:El,i(e){Qt||(d(T.$$.fragment,e),d(J.$$.fragment,e),d(k.$$.fragment,e),d(U.$$.fragment,e),d(v.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d($.$$.fragment,e),d(E.$$.fragment,e),d(F.$$.fragment,e),d(A.$$.fragment,e),d(H.$$.fragment,e),d(Q.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(ye.$$.fragment,e),d(fe.$$.fragment,e),d(Te.$$.fragment,e),d(Ue.$$.fragment,e),d(Ce.$$.fragment,e),Qt=!0)},o(e){u(T.$$.fragment,e),u(J.$$.fragment,e),u(k.$$.fragment,e),u(U.$$.fragment,e),u(v.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u($.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(A.$$.fragment,e),u(H.$$.fragment,e),u(Q.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(ye.$$.fragment,e),u(fe.$$.fragment,e),u(Te.$$.fragment,e),u(Ue.$$.fragment,e),u(Ce.$$.fragment,e),Qt=!1},d(e){e&&(l(We),l(Le),l(Ie),l($e),l(Be),l(j),l(Re),l(g),l(Ee),l(Ve),l(x),l(Xe),l(Fe),l(Z),l(Ne),l(f),l(Ae),l(C),l(Ye),l(He),l(L),l(Se),l(Qe),l(_),l(ze),l(qe),l(I),l(Pe),l(De),l(B),l(Ke),l(R),l(Oe),l(et),l(V),l(tt),l(X),l(lt),l(st),l(N),l(nt),l(at),l(Y),l(ot),l(it),l(S),l(mt),l(pt),l(z),l(rt),l(q),l(ct),l(dt),l(D),l(ut),l(yt),l(O),l(Mt),l(ee),l(ht),l(ft),l(le),l(bt),l(se),l(wt),l(Tt),l(ae),l(Jt),l(oe),l(jt),l(ie),l(gt),l(kt),l(pe),l(xt),l(re),l(Ut),l(Zt),l(de),l(Ct),l(vt),l(Lt),l(Me),l(Gt),l(he),l(_t),l(Wt),l(b),l(It),l(be),l($t),l(we),l(Bt),l(Rt),l(w),l(Et),l(Je),l(Vt),l(je),l(Xt),l(ge),l(Ft),l(ke),l(Nt),l(xe),l(At),l(Yt),l(Ze),l(Ht),l(St),l(Ge)),l(h),y(T,e),y(J,e),y(k,e),y(U,e),y(v,e),y(G,e),y(W,e),y($,e),y(E,e),y(F,e),y(A,e),y(H,e),y(Q,e),y(P,e),y(K,e),y(te,e),y(ne,e),y(me,e),y(ce,e),y(ue,e),y(ye,e),y(fe,e),y(Te,e),y(Ue,e),y(Ce,e)}}}const Ql='{"title":"Custom models","local":"custom-models","sections":[{"title":"Multilayer perceptron","local":"multilayer-perceptron","sections":[],"depth":2},{"title":"timm models","local":"timm-models","sections":[],"depth":2},{"title":"New transformers architectures","local":"new-transformers-architectures","sections":[],"depth":2},{"title":"Verify parameters and layers","local":"verify-parameters-and-layers","sections":[],"depth":2},{"title":"Unsupported module types","local":"unsupported-module-types","sections":[{"title":"Experimental support for dynamic dispatch of custom modules in LoRA","local":"experimental-support-for-dynamic-dispatch-of-custom-modules-in-lora","sections":[],"depth":3}],"depth":2}],"depth":1}';function zl(zt){return Vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ol extends Xl{constructor(h){super(),Fl(this,h,zl,Sl,Rl,{})}}export{Ol as component};
