import{s as Ms,n as hs,o as fs}from"../chunks/scheduler.6062bdaf.js";import{S as Ts,i as Js,g as o,s as n,r,A as ds,h as p,f as a,c as l,j as ws,u as i,x as h,k as ys,y as Us,a as e,v as c,d as w,t as y,w as M}from"../chunks/index.4bca734e.js";import{C as as}from"../chunks/CodeBlock.fa01571c.js";import{H as R}from"../chunks/Heading.723dceba.js";function us(es){let m,x,z,G,f,S,T,ns="The <code>optimum.fx.optimization</code> module provides a set of torch.fx graph transformations, along with classes and functions to write your own transformations and compose them.",F,J,Q,d,ls="In 🤗 Optimum, there are two kinds of transformations: reversible and non-reversible transformations.",X,U,E,u,os='The most basic case of transformations is non-reversible transformations. Those transformations cannot be reversed, meaning that after applying them to a graph module, there is no way to get the original model back. To implement such transformations in 🤗 Optimum, it is very easy: you just need to subclass <a href="/docs/optimum/v1.17.1/en/torch_fx/package_reference/optimization#optimum.fx.optimization.Transformation">Transformation</a> and implement the <a href="/docs/optimum/v1.17.1/en/torch_fx/package_reference/optimization#optimum.fx.optimization.Transformation.transform">transform()</a> method.',N,j,ps="For instance, the following transformation changes all the multiplications to additions:",A,C,H,b,ms="After implementing it, your transformation can be used as a regular function:",V,g,Y,I,q,v,rs='A reversible transformation implements both the transformation and its reverse, allowing to retrieve the original model from the transformed one. To implement such transformation, you need to subclass <a href="/docs/optimum/v1.17.1/en/torch_fx/package_reference/optimization#optimum.fx.optimization.ReversibleTransformation">ReversibleTransformation</a> and implement the <a href="/docs/optimum/v1.17.1/en/torch_fx/package_reference/optimization#optimum.fx.optimization.Transformation.transform">transform()</a> and <a href="/docs/optimum/v1.17.1/en/torch_fx/package_reference/optimization#optimum.fx.optimization.ReversibleTransformation.reverse">reverse()</a> methods.',L,k,is="For instance, the following transformation is reversible:",P,Z,K,$,D,_,cs='As applying multiple transformations in chain is needed more often that not, <a href="/docs/optimum/v1.17.1/en/torch_fx/package_reference/optimization#optimum.fx.optimization.compose">compose()</a> is provided. It is an utility function that allows you to create a transformation by chaining multiple other transformations.',O,B,ss,W,ts;return f=new R({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),J=new R({props:{title:"The transformation guide",local:"the-transformation-guide",headingTag:"h2"}}),U=new R({props:{title:"Write a non-reversible transformation",local:"write-a-non-reversible-transformation",headingTag:"h3"}}),C=new as({props:{code:"aW1wb3J0JTIwb3BlcmF0b3IlMEFmcm9tJTIwb3B0aW11bS5meC5vcHRpbWl6YXRpb24lMjBpbXBvcnQlMjBUcmFuc2Zvcm1hdGlvbiUwQSUwQWNsYXNzJTIwQ2hhbmdlTXVsVG9BZGQoVHJhbnNmb3JtYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwdHJhbnNmb3JtKHNlbGYlMkMlMjBncmFwaF9tb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwbm9kZSUyMGluJTIwZ3JhcGhfbW9kdWxlLmdyYXBoLm5vZGVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBub2RlLm9wJTIwJTNEJTNEJTIwJTIyY2FsbF9mdW5jdGlvbiUyMiUyMGFuZCUyMG5vZGUudGFyZ2V0JTIwJTNEJTNEJTIwb3BlcmF0b3IubXVsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9kZS50YXJnZXQlMjAlM0QlMjBvcGVyYXRvci5hZGQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBncmFwaF9tb2R1bGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> operator
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.fx.optimization <span class="hljs-keyword">import</span> Transformation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">ChangeMulToAdd</span>(<span class="hljs-title class_ inherited__">Transformation</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">self, graph_module</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> node <span class="hljs-keyword">in</span> graph_module.graph.nodes:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> node.op == <span class="hljs-string">&quot;call_function&quot;</span> <span class="hljs-keyword">and</span> node.target == operator.mul:
<span class="hljs-meta">... </span>                node.target = operator.add
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> graph_module`,wrap:!1}}),g=new as({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRNb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMudXRpbHMuZnglMjBpbXBvcnQlMjBzeW1ib2xpY190cmFjZSUwQSUwQW1vZGVsJTIwJTNEJTIwQmVydE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEF0cmFjZWQlMjAlM0QlMjBzeW1ib2xpY190cmFjZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGlucHV0X25hbWVzJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RCUyQyUwQSklMEElMEF0cmFuc2Zvcm1hdGlvbiUyMCUzRCUyMENoYW5nZU11bFRvQWRkKCklMEF0cmFuc2Zvcm1lZF9tb2RlbCUyMCUzRCUyMHRyYW5zZm9ybWF0aW9uKHRyYWNlZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.utils.fx <span class="hljs-keyword">import</span> symbolic_trace

<span class="hljs-meta">&gt;&gt;&gt; </span>model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>traced = symbolic_trace(
<span class="hljs-meta">... </span>    model,
<span class="hljs-meta">... </span>    input_names=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transformation = ChangeMulToAdd()
<span class="hljs-meta">&gt;&gt;&gt; </span>transformed_model = transformation(traced)`,wrap:!1}}),I=new R({props:{title:"Write a reversible transformation",local:"write-a-reversible-transformation",headingTag:"h3"}}),Z=new as({props:{code:"aW1wb3J0JTIwb3BlcmF0b3IlMEFmcm9tJTIwb3B0aW11bS5meC5vcHRpbWl6YXRpb24lMjBpbXBvcnQlMjBSZXZlcnNpYmxlVHJhbnNmb3JtYXRpb24lMEElMEFjbGFzcyUyME11bFRvTXVsVGltZXNUd28oUmV2ZXJzaWJsZVRyYW5zZm9ybWF0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHRyYW5zZm9ybShzZWxmJTJDJTIwZ3JhcGhfbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMG5vZGUlMjBpbiUyMGdyYXBoX21vZHVsZS5ncmFwaC5ub2RlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbm9kZS5vcCUyMCUzRCUzRCUyMCUyMmNhbGxfZnVuY3Rpb24lMjIlMjBhbmQlMjBub2RlLnRhcmdldCUyMCUzRCUzRCUyMG9wZXJhdG9yLm11bCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMkMlMjB5JTIwJTNEJTIwbm9kZS5hcmdzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9kZS5hcmdzJTIwJTNEJTIwKDIlMjAqJTIweCUyQyUyMHkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZ3JhcGhfbW9kdWxlJTBBJTIwJTIwJTIwJTIwZGVmJTIwcmV2ZXJzZShzZWxmJTJDJTIwZ3JhcGhfbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMG5vZGUlMjBpbiUyMGdyYXBoX21vZHVsZS5ncmFwaC5ub2RlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbm9kZS5vcCUyMCUzRCUzRCUyMCUyMmNhbGxfZnVuY3Rpb24lMjIlMjBhbmQlMjBub2RlLnRhcmdldCUyMCUzRCUzRCUyMG9wZXJhdG9yLm11bCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMkMlMjB5JTIwJTNEJTIwbm9kZS5hcmdzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9kZS5hcmdzJTIwJTNEJTIwKHglMjAlMkYlMjAyJTJDJTIweSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBncmFwaF9tb2R1bGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> operator
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.fx.optimization <span class="hljs-keyword">import</span> ReversibleTransformation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MulToMulTimesTwo</span>(<span class="hljs-title class_ inherited__">ReversibleTransformation</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">self, graph_module</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> node <span class="hljs-keyword">in</span> graph_module.graph.nodes:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> node.op == <span class="hljs-string">&quot;call_function&quot;</span> <span class="hljs-keyword">and</span> node.target == operator.mul:
<span class="hljs-meta">... </span>                x, y = node.args
<span class="hljs-meta">... </span>                node.args = (<span class="hljs-number">2</span> * x, y)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> graph_module
...
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse</span>(<span class="hljs-params">self, graph_module</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> node <span class="hljs-keyword">in</span> graph_module.graph.nodes:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> node.op == <span class="hljs-string">&quot;call_function&quot;</span> <span class="hljs-keyword">and</span> node.target == operator.mul:
<span class="hljs-meta">... </span>                x, y = node.args
<span class="hljs-meta">... </span>                node.args = (x / <span class="hljs-number">2</span>, y)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> graph_module`,wrap:!1}}),$=new R({props:{title:"Composing transformations together",local:"composing-transformations-together",headingTag:"h3"}}),B=new as({props:{code:"ZnJvbSUyMG9wdGltdW0uZngub3B0aW1pemF0aW9uJTIwaW1wb3J0JTIwY29tcG9zZSUwQWNvbXBvc2l0aW9uJTIwJTNEJTIwY29tcG9zZShNdWxUb011bFRpbWVzVHdvKCklMkMlMjBDaGFuZ2VNdWxUb0FkZCgpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.fx.optimization <span class="hljs-keyword">import</span> compose
<span class="hljs-meta">&gt;&gt;&gt; </span>composition = compose(MulToMulTimesTwo(), ChangeMulToAdd())`,wrap:!1}}),{c(){m=o("meta"),x=n(),z=o("p"),G=n(),r(f.$$.fragment),S=n(),T=o("p"),T.innerHTML=ns,F=n(),r(J.$$.fragment),Q=n(),d=o("p"),d.textContent=ls,X=n(),r(U.$$.fragment),E=n(),u=o("p"),u.innerHTML=os,N=n(),j=o("p"),j.textContent=ps,A=n(),r(C.$$.fragment),H=n(),b=o("p"),b.textContent=ms,V=n(),r(g.$$.fragment),Y=n(),r(I.$$.fragment),q=n(),v=o("p"),v.innerHTML=rs,L=n(),k=o("p"),k.textContent=is,P=n(),r(Z.$$.fragment),K=n(),r($.$$.fragment),D=n(),_=o("p"),_.innerHTML=cs,O=n(),r(B.$$.fragment),ss=n(),W=o("p"),this.h()},l(s){const t=ds("svelte-u9bgzb",document.head);m=p(t,"META",{name:!0,content:!0}),t.forEach(a),x=l(s),z=p(s,"P",{}),ws(z).forEach(a),G=l(s),i(f.$$.fragment,s),S=l(s),T=p(s,"P",{"data-svelte-h":!0}),h(T)!=="svelte-pyegu9"&&(T.innerHTML=ns),F=l(s),i(J.$$.fragment,s),Q=l(s),d=p(s,"P",{"data-svelte-h":!0}),h(d)!=="svelte-1u0ybww"&&(d.textContent=ls),X=l(s),i(U.$$.fragment,s),E=l(s),u=p(s,"P",{"data-svelte-h":!0}),h(u)!=="svelte-1758bfl"&&(u.innerHTML=os),N=l(s),j=p(s,"P",{"data-svelte-h":!0}),h(j)!=="svelte-16d1zd5"&&(j.textContent=ps),A=l(s),i(C.$$.fragment,s),H=l(s),b=p(s,"P",{"data-svelte-h":!0}),h(b)!=="svelte-4h2eh7"&&(b.textContent=ms),V=l(s),i(g.$$.fragment,s),Y=l(s),i(I.$$.fragment,s),q=l(s),v=p(s,"P",{"data-svelte-h":!0}),h(v)!=="svelte-1778yct"&&(v.innerHTML=rs),L=l(s),k=p(s,"P",{"data-svelte-h":!0}),h(k)!=="svelte-84g68q"&&(k.textContent=is),P=l(s),i(Z.$$.fragment,s),K=l(s),i($.$$.fragment,s),D=l(s),_=p(s,"P",{"data-svelte-h":!0}),h(_)!=="svelte-y1d2qn"&&(_.innerHTML=cs),O=l(s),i(B.$$.fragment,s),ss=l(s),W=p(s,"P",{}),ws(W).forEach(a),this.h()},h(){ys(m,"name","hf:doc:metadata"),ys(m,"content",js)},m(s,t){Us(document.head,m),e(s,x,t),e(s,z,t),e(s,G,t),c(f,s,t),e(s,S,t),e(s,T,t),e(s,F,t),c(J,s,t),e(s,Q,t),e(s,d,t),e(s,X,t),c(U,s,t),e(s,E,t),e(s,u,t),e(s,N,t),e(s,j,t),e(s,A,t),c(C,s,t),e(s,H,t),e(s,b,t),e(s,V,t),c(g,s,t),e(s,Y,t),c(I,s,t),e(s,q,t),e(s,v,t),e(s,L,t),e(s,k,t),e(s,P,t),c(Z,s,t),e(s,K,t),c($,s,t),e(s,D,t),e(s,_,t),e(s,O,t),c(B,s,t),e(s,ss,t),e(s,W,t),ts=!0},p:hs,i(s){ts||(w(f.$$.fragment,s),w(J.$$.fragment,s),w(U.$$.fragment,s),w(C.$$.fragment,s),w(g.$$.fragment,s),w(I.$$.fragment,s),w(Z.$$.fragment,s),w($.$$.fragment,s),w(B.$$.fragment,s),ts=!0)},o(s){y(f.$$.fragment,s),y(J.$$.fragment,s),y(U.$$.fragment,s),y(C.$$.fragment,s),y(g.$$.fragment,s),y(I.$$.fragment,s),y(Z.$$.fragment,s),y($.$$.fragment,s),y(B.$$.fragment,s),ts=!1},d(s){s&&(a(x),a(z),a(G),a(S),a(T),a(F),a(Q),a(d),a(X),a(E),a(u),a(N),a(j),a(A),a(H),a(b),a(V),a(Y),a(q),a(v),a(L),a(k),a(P),a(K),a(D),a(_),a(O),a(ss),a(W)),a(m),M(f,s),M(J,s),M(U,s),M(C,s),M(g,s),M(I,s),M(Z,s),M($,s),M(B,s)}}}const js='{"title":"Optimization","local":"optimization","sections":[{"title":"The transformation guide","local":"the-transformation-guide","sections":[{"title":"Write a non-reversible transformation","local":"write-a-non-reversible-transformation","sections":[],"depth":3},{"title":"Write a reversible transformation","local":"write-a-reversible-transformation","sections":[],"depth":3},{"title":"Composing transformations together","local":"composing-transformations-together","sections":[],"depth":3}],"depth":2}],"depth":1}';function Cs(es){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ks extends Ts{constructor(m){super(),Js(this,m,Cs,us,Ms,{})}}export{ks as component};
