# Quiz 2: MCP SDK

Test your knowledge of the MCP SDKs and their functionalities.

### Q1: What is the main purpose of the MCP SDKs?

<Question
  choices={[
    {
      text: "To define the MCP protocol specification",
      explain: "The SDKs implement the protocol, they don't define it. The specification is separate."
    },
    {
      text: "To make it easier to implement MCP clients and servers",
      explain: "Correct! SDKs abstract away low-level protocol details.",
      correct: true
    },
    {
      text: "To provide a visual interface for MCP interactions",
      explain: "While some tools might offer this (like MCP Inspector), it's not the primary purpose of the SDKs themselves."
    },
    {
      text: "To replace the need for programming languages",
      explain: "SDKs are libraries used within programming languages."
    }
  ]}
/>

### Q2: Which of the following functionalities do the MCP SDKs typically handle?

<Question
  choices={[
    {
      text: "Optimizing MCP Servers",
      explain: "This is outside the scope of MCP SDKs, which focus on protocol implementation."
    },
    {
      text: "Defining new AI algorithms",
      explain: "This is outside the scope of MCP SDKs, which focus on protocol implementation."
    },
    {
      text: "Message serialization/deserialization",
      explain: "Correct! This is a core function for handling JSON-RPC messages.",
      correct: true
    },
    {
      text: "Hosting Large Language Models",
      explain: "MCP enables connection to LLMs, but the SDKs themselves don't host them."
    }
  ]}
/>

### Q3: According to the provided text, which company maintains the official Python SDK for MCP?

<Question
  choices={[
    {
      text: "Google",
      explain: "The text lists Anthropic as the maintainer."
    },
    {
      text: "Anthropic",
      explain: "Correct! The course material indicates Anthropic maintains the Python SDK.",
      correct: true
    },
    {
      text: "Microsoft",
      explain: "Microsoft maintains the C# SDK according to the text."
    },
    {
      text: "JetBrains",
      explain: "JetBrains maintains the Kotlin SDK according to the text."
    }
  ]}
/>

### Q4: What command is used to start a development MCP server using a Python file named `server.py`?

<Question
  choices={[
    {
      text: "python server.py run",
      explain: "While you run Python scripts with `python`, MCP has a specific CLI command."
    },
    {
      text: "mcp start server.py",
      explain: "The command is `mcp dev`, not `mcp start`."
    },
    {
      text: "mcp dev server.py",
      explain: "Correct! This command initializes the development server.",
      correct: true
    },
    {
      text: "serve mcp server.py",
      explain: "This is not the standard MCP CLI command shown in the course material."
    }
  ]}
/>

### Q5: What is the role of JSON-RPC 2.0 in MCP?

<Question
  choices={[
    {
      text: "As a primary transport mechanism for remote communication",
      explain: "HTTP+SSE or Streamable HTTP are transport mechanisms; JSON-RPC is the message format."
    },
    {
      text: "As the message format for all communication between Clients and Servers",
      explain: "Correct! MCP uses JSON-RPC 2.0 for structuring messages.",
      correct: true
    },
    {
      text: "As a tool for debugging AI models",
      explain: "While its human-readable nature helps in debugging communications, it's not a debugging tool for AI models themselves."
    },
    {
      text: "As a method for defining AI capabilities like Tools and Resources",
      explain: "Capabilities are defined by their own schemas; JSON-RPC is used to invoke them and exchange data."
    }
  ]}
/>

Congrats on finishing this Quiz 🥳! If you need to review any elements, take the time to revisit the chapter to reinforce your knowledge. 

<EditOnGithub source="https://github.com/huggingface/mcp-course/blob/main/units/en/unit1/quiz2.mdx" />