import{s as me,n as fe,o as ce}from"../chunks/scheduler.8a2cc2fa.js";import{S as de,i as be,e as s,s as a,c as p,h as ye,a as o,d as n,b as i,f as pe,g as m,j as r,k as O,l as ge,m as l,n as f,t as c,o as d,p as b}from"../chunks/index.7079e750.js";import{C as ue,H as w,E as he}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.70817bb7.js";import{C as tt}from"../chunks/CodeBlock.374d71d9.js";function Me(Ft){let y,lt,et,at,T,it,_,st,U,At="bitsandbytes is widely integrated with many of the libraries in the Hugging Face and wider PyTorch ecosystem. This guide provides a brief overview of the integrations and how to use bitsandbytes with them. For more details, you should refer to the linked documentation for each library.",ot,C,rt,g,Vt='<p>Learn more in the bitsandbytes Transformers integration <a href="https://huggingface.co/docs/transformers/quantization#bitsandbytes" rel="nofollow">guide</a>.</p>',pt,$,qt='With Transformers, it’s very easy to load any model in 4 or 8-bit and quantize them on the fly. To configure the quantization parameters, specify them in the <a href="https://huggingface.co/docs/transformers/v5.0.0rc1/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class.',mt,v,Yt="For example, to load and quantize a model to 4-bits and use the bfloat16 data type for compute:",ft,u,It='<p>bfloat16 is the ideal <code>compute_dtype</code> if your hardware supports it. While the default <code>compute_dtype</code>, float32, ensures backward compatibility (due to wide-ranging hardware support) and numerical stability, it is large and slows down computations. In contrast, float16 is smaller and faster but can lead to numerical instabilities. bfloat16 combines the best aspects of both; it offers the numerical stability of float32 and the reduced memory footprint and speed of a 16-bit data type. Check if your hardware supports bfloat16 and configure it using the <code>bnb_4bit_compute_dtype</code> parameter in <a href="https://huggingface.co/docs/transformers/v5.0.0rc1/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a>!</p>',ct,J,dt,Z,bt,j,Nt='You can use any of the 8-bit or paged optimizers with Transformers by passing them to the <a href="https://huggingface.co/docs/transformers/v5.0.0rc1/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class on initialization. All bitsandbytes optimizers are supported by passing the correct string in the <a href="https://huggingface.co/docs/transformers/v5.0.0rc1/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> <code>optim</code> parameter. For example, to load a <a href="/docs/bitsandbytes/v0.49.0/en/reference/optim/adamw#bitsandbytes.optim.PagedAdamW32bit">PagedAdamW32bit</a> optimizer:',yt,B,gt,X,ut,h,Pt='<p>Learn more in the bitsandbytes PEFT integration <a href="https://huggingface.co/docs/peft/developer_guides/quantization#quantization" rel="nofollow">guide</a>.</p>',ht,k,St="PEFT builds on the bitsandbytes Transformers integration, and extends it for training with a few more steps. Let’s prepare the 4-bit model from the section above for training.",Mt,L,Dt='Call the <a href="https://huggingface.co/docs/peft/v0.18.0/en/package_reference/peft_model#peft.prepare_model_for_kbit_training" rel="nofollow">prepare_model_for_kbit_training</a> method to prepare the model for training. This only works for Transformers models!',wt,z,Tt,G,Kt='Setup a <a href="https://huggingface.co/docs/peft/v0.18.0/en/package_reference/lora#peft.LoraConfig" rel="nofollow">LoraConfig</a> to use QLoRA:',_t,W,Ut,R,Ot='Now call the <a href="https://huggingface.co/docs/peft/v0.18.0/en/package_reference/peft_model#peft.get_peft_model" rel="nofollow">get_peft_model</a> function on your model and config to create a trainable <code>PeftModel</code>.',Ct,x,$t,H,vt,M,te='<p>Learn more in the bitsandbytes Accelerate integration <a href="https://huggingface.co/docs/accelerate/usage_guides/quantization" rel="nofollow">guide</a>.</p>',Jt,Q,ee='bitsandbytes is also easily usable from Accelerate and you can quantize any PyTorch model by passing a <a href="https://huggingface.co/docs/accelerate/v1.12.0/en/package_reference/utilities#accelerate.utils.BnbQuantizationConfig" rel="nofollow">BnbQuantizationConfig</a> with your desired settings, and then calling the <a href="https://huggingface.co/docs/accelerate/v1.12.0/en/package_reference/utilities#accelerate.utils.load_and_quantize_model" rel="nofollow">load_and_quantize_model</a> function to quantize it.',Zt,E,jt,F,Bt,A,ne="bitsandbytes is available from:",Xt,V,le='<li><a href="https://lightning.ai/docs/pytorch/stable/" rel="nofollow">PyTorch Lightning</a>, a deep learning framework for professional AI researchers and machine learning engineers who need maximal flexibility without sacrificing performance at scale.</li> <li><a href="https://lightning.ai/docs/fabric/stable/" rel="nofollow">Lightning Fabric</a>, a fast and lightweight way to scale PyTorch models without boilerplate.</li>',kt,q,ae='Learn more in the bitsandbytes PyTorch Lightning integration <a href="https://lightning.ai/docs/pytorch/stable/common/precision_intermediate.html#quantization-via-bitsandbytes" rel="nofollow">guide</a>.',Lt,Y,zt,I,ie='bitsandbytes is integrated with <a href="https://github.com/Lightning-AI/lit-gpt" rel="nofollow">Lit-GPT</a>, a hackable implementation of state-of-the-art open-source large language models. Lit-GPT is based on Lightning Fabric, and it can be used for quantization during training, finetuning, and inference.',Gt,N,se='Learn more in the bitsandbytes Lit-GPT integration <a href="https://github.com/Lightning-AI/lit-gpt/blob/main/tutorials/quantize.md" rel="nofollow">guide</a>.',Wt,P,Rt,S,oe="To learn in more detail about some of bitsandbytes integrations, take a look at the following blog posts:",xt,D,re='<li><a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a></li> <li><a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">A Gentle Introduction to 8-bit Matrix Multiplication for transformers at scale using Hugging Face Transformers, Accelerate and bitsandbytes</a></li>',Ht,K,Qt,nt,Et;return T=new ue({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),_=new w({props:{title:"Integrations",local:"integrations",headingTag:"h1"}}),C=new w({props:{title:"Transformers",local:"transformers",headingTag:"h2"}}),J=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQW1vZGVsXzRiaXQlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RkZXZpY2VfbWFwJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)
model_4bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),Z=new w({props:{title:"8-bit optimizers",local:"8-bit-optimizers",headingTag:"h3"}}),B=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBvcHRpbSUzRCUyMnBhZ2VkX2FkYW13XzMyYml0JTIyJTJDJTBBKSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTJDJTIwdHJhaW5pbmdfYXJncyUyQyUyMC4uLiklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

training_args = TrainingArguments(
    ...,
    optim=<span class="hljs-string">&quot;paged_adamw_32bit&quot;</span>,
)
trainer = Trainer(model, training_args, ...)
trainer.train()`,wrap:!1}}),X=new w({props:{title:"PEFT",local:"peft",headingTag:"h2"}}),z=new tt({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWxfNGJpdCUyMCUzRCUyMHByZXBhcmVfbW9kZWxfZm9yX2tiaXRfdHJhaW5pbmcobW9kZWxfNGJpdCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model_4bit = prepare_model_for_kbit_training(model_4bit)`,wrap:!1}}),W=new tt({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTIyYWxsLWxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
    lora_dropout=<span class="hljs-number">0.05</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),x=new tt({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWxfNGJpdCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model_4bit, config)`,wrap:!1}}),H=new w({props:{title:"Accelerate",local:"accelerate",headingTag:"h2"}}),E=new tt({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyUyQyUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsJTBBZnJvbSUyMG1pbmdwdC5tb2RlbCUyMGltcG9ydCUyMEdQVCUwQSUwQW1vZGVsX2NvbmZpZyUyMCUzRCUyMEdQVC5nZXRfZGVmYXVsdF9jb25maWcoKSUwQW1vZGVsX2NvbmZpZy5tb2RlbF90eXBlJTIwJTNEJTIwJ2dwdDIteGwnJTBBbW9kZWxfY29uZmlnLnZvY2FiX3NpemUlMjAlM0QlMjA1MDI1NyUwQW1vZGVsX2NvbmZpZy5ibG9ja19zaXplJTIwJTNEJTIwMTAyNCUwQSUwQXdpdGglMjBpbml0X2VtcHR5X3dlaWdodHMoKSUzQSUwQSUyMCUyMCUyMCUyMGVtcHR5X21vZGVsJTIwJTNEJTIwR1BUKG1vZGVsX2NvbmZpZyklMEElMEFibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyglMEElMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwJTIwJTIzJTIwb3B0aW9uYWwlMEElMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG9wdGlvbmFsJTBBJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG9wdGlvbmFsJTBBKSUwQSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsKCUwQSUyMCUyMGVtcHR5X21vZGVsJTJDJTBBJTIwJTIwd2VpZ2h0c19sb2NhdGlvbiUzRHdlaWdodHNfbG9jYXRpb24lMkMlMEElMjAlMjBibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9xdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwZGV2aWNlX21hcCUyMCUzRCUyMCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> BnbQuantizationConfig, load_and_quantize_model
<span class="hljs-keyword">from</span> mingpt.model <span class="hljs-keyword">import</span> GPT

model_config = GPT.get_default_config()
model_config.model_type = <span class="hljs-string">&#x27;gpt2-xl&#x27;</span>
model_config.vocab_size = <span class="hljs-number">50257</span>
model_config.block_size = <span class="hljs-number">1024</span>

<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = GPT(model_config)

bnb_quantization_config = BnbQuantizationConfig(
  load_in_4bit=<span class="hljs-literal">True</span>,
  bnb_4bit_compute_dtype=torch.bfloat16,  <span class="hljs-comment"># optional</span>
  bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,         <span class="hljs-comment"># optional</span>
  bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>               <span class="hljs-comment"># optional</span>
)

quantized_model = load_and_quantize_model(
  empty_model,
  weights_location=weights_location,
  bnb_quantization_config=bnb_quantization_config,
  device_map = <span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),F=new w({props:{title:"PyTorch Lightning and Lightning Fabric",local:"pytorch-lightning-and-lightning-fabric",headingTag:"h2"}}),Y=new w({props:{title:"Lit-GPT",local:"lit-gpt",headingTag:"h2"}}),P=new w({props:{title:"Blog posts",local:"blog-posts",headingTag:"h2"}}),K=new he({props:{source:"https://github.com/bitsandbytes-foundation/bitsandbytes/blob/main/docs/source/integrations.mdx"}}),{c(){y=s("meta"),lt=a(),et=s("p"),at=a(),p(T.$$.fragment),it=a(),p(_.$$.fragment),st=a(),U=s("p"),U.textContent=At,ot=a(),p(C.$$.fragment),rt=a(),g=s("blockquote"),g.innerHTML=Vt,pt=a(),$=s("p"),$.innerHTML=qt,mt=a(),v=s("p"),v.textContent=Yt,ft=a(),u=s("blockquote"),u.innerHTML=It,ct=a(),p(J.$$.fragment),dt=a(),p(Z.$$.fragment),bt=a(),j=s("p"),j.innerHTML=Nt,yt=a(),p(B.$$.fragment),gt=a(),p(X.$$.fragment),ut=a(),h=s("blockquote"),h.innerHTML=Pt,ht=a(),k=s("p"),k.textContent=St,Mt=a(),L=s("p"),L.innerHTML=Dt,wt=a(),p(z.$$.fragment),Tt=a(),G=s("p"),G.innerHTML=Kt,_t=a(),p(W.$$.fragment),Ut=a(),R=s("p"),R.innerHTML=Ot,Ct=a(),p(x.$$.fragment),$t=a(),p(H.$$.fragment),vt=a(),M=s("blockquote"),M.innerHTML=te,Jt=a(),Q=s("p"),Q.innerHTML=ee,Zt=a(),p(E.$$.fragment),jt=a(),p(F.$$.fragment),Bt=a(),A=s("p"),A.textContent=ne,Xt=a(),V=s("ul"),V.innerHTML=le,kt=a(),q=s("p"),q.innerHTML=ae,Lt=a(),p(Y.$$.fragment),zt=a(),I=s("p"),I.innerHTML=ie,Gt=a(),N=s("p"),N.innerHTML=se,Wt=a(),p(P.$$.fragment),Rt=a(),S=s("p"),S.textContent=oe,xt=a(),D=s("ul"),D.innerHTML=re,Ht=a(),p(K.$$.fragment),Qt=a(),nt=s("p"),this.h()},l(t){const e=ye("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(n),lt=i(t),et=o(t,"P",{}),pe(et).forEach(n),at=i(t),m(T.$$.fragment,t),it=i(t),m(_.$$.fragment,t),st=i(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-17oloa0"&&(U.textContent=At),ot=i(t),m(C.$$.fragment,t),rt=i(t),g=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-1a8u5ay"&&(g.innerHTML=Vt),pt=i(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-6frz85"&&($.innerHTML=qt),mt=i(t),v=o(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-fugr8i"&&(v.textContent=Yt),ft=i(t),u=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(u)!=="svelte-wrii2r"&&(u.innerHTML=It),ct=i(t),m(J.$$.fragment,t),dt=i(t),m(Z.$$.fragment,t),bt=i(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-h9sjve"&&(j.innerHTML=Nt),yt=i(t),m(B.$$.fragment,t),gt=i(t),m(X.$$.fragment,t),ut=i(t),h=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-ts8pmq"&&(h.innerHTML=Pt),ht=i(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-945c4h"&&(k.textContent=St),Mt=i(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1ttefbo"&&(L.innerHTML=Dt),wt=i(t),m(z.$$.fragment,t),Tt=i(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-rc9jl1"&&(G.innerHTML=Kt),_t=i(t),m(W.$$.fragment,t),Ut=i(t),R=o(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-m4zcs9"&&(R.innerHTML=Ot),Ct=i(t),m(x.$$.fragment,t),$t=i(t),m(H.$$.fragment,t),vt=i(t),M=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-ebimhp"&&(M.innerHTML=te),Jt=i(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1n9hi1h"&&(Q.innerHTML=ee),Zt=i(t),m(E.$$.fragment,t),jt=i(t),m(F.$$.fragment,t),Bt=i(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-zm0jix"&&(A.textContent=ne),Xt=i(t),V=o(t,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-c4dddp"&&(V.innerHTML=le),kt=i(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-xrv468"&&(q.innerHTML=ae),Lt=i(t),m(Y.$$.fragment,t),zt=i(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-jne5kj"&&(I.innerHTML=ie),Gt=i(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-144d081"&&(N.innerHTML=se),Wt=i(t),m(P.$$.fragment,t),Rt=i(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-hhb45g"&&(S.textContent=oe),xt=i(t),D=o(t,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-1opwyey"&&(D.innerHTML=re),Ht=i(t),m(K.$$.fragment,t),Qt=i(t),nt=o(t,"P",{}),pe(nt).forEach(n),this.h()},h(){O(y,"name","hf:doc:metadata"),O(y,"content",we),O(g,"class","tip"),O(u,"class","warning"),O(h,"class","tip"),O(M,"class","tip")},m(t,e){ge(document.head,y),l(t,lt,e),l(t,et,e),l(t,at,e),f(T,t,e),l(t,it,e),f(_,t,e),l(t,st,e),l(t,U,e),l(t,ot,e),f(C,t,e),l(t,rt,e),l(t,g,e),l(t,pt,e),l(t,$,e),l(t,mt,e),l(t,v,e),l(t,ft,e),l(t,u,e),l(t,ct,e),f(J,t,e),l(t,dt,e),f(Z,t,e),l(t,bt,e),l(t,j,e),l(t,yt,e),f(B,t,e),l(t,gt,e),f(X,t,e),l(t,ut,e),l(t,h,e),l(t,ht,e),l(t,k,e),l(t,Mt,e),l(t,L,e),l(t,wt,e),f(z,t,e),l(t,Tt,e),l(t,G,e),l(t,_t,e),f(W,t,e),l(t,Ut,e),l(t,R,e),l(t,Ct,e),f(x,t,e),l(t,$t,e),f(H,t,e),l(t,vt,e),l(t,M,e),l(t,Jt,e),l(t,Q,e),l(t,Zt,e),f(E,t,e),l(t,jt,e),f(F,t,e),l(t,Bt,e),l(t,A,e),l(t,Xt,e),l(t,V,e),l(t,kt,e),l(t,q,e),l(t,Lt,e),f(Y,t,e),l(t,zt,e),l(t,I,e),l(t,Gt,e),l(t,N,e),l(t,Wt,e),f(P,t,e),l(t,Rt,e),l(t,S,e),l(t,xt,e),l(t,D,e),l(t,Ht,e),f(K,t,e),l(t,Qt,e),l(t,nt,e),Et=!0},p:fe,i(t){Et||(c(T.$$.fragment,t),c(_.$$.fragment,t),c(C.$$.fragment,t),c(J.$$.fragment,t),c(Z.$$.fragment,t),c(B.$$.fragment,t),c(X.$$.fragment,t),c(z.$$.fragment,t),c(W.$$.fragment,t),c(x.$$.fragment,t),c(H.$$.fragment,t),c(E.$$.fragment,t),c(F.$$.fragment,t),c(Y.$$.fragment,t),c(P.$$.fragment,t),c(K.$$.fragment,t),Et=!0)},o(t){d(T.$$.fragment,t),d(_.$$.fragment,t),d(C.$$.fragment,t),d(J.$$.fragment,t),d(Z.$$.fragment,t),d(B.$$.fragment,t),d(X.$$.fragment,t),d(z.$$.fragment,t),d(W.$$.fragment,t),d(x.$$.fragment,t),d(H.$$.fragment,t),d(E.$$.fragment,t),d(F.$$.fragment,t),d(Y.$$.fragment,t),d(P.$$.fragment,t),d(K.$$.fragment,t),Et=!1},d(t){t&&(n(lt),n(et),n(at),n(it),n(st),n(U),n(ot),n(rt),n(g),n(pt),n($),n(mt),n(v),n(ft),n(u),n(ct),n(dt),n(bt),n(j),n(yt),n(gt),n(ut),n(h),n(ht),n(k),n(Mt),n(L),n(wt),n(Tt),n(G),n(_t),n(Ut),n(R),n(Ct),n($t),n(vt),n(M),n(Jt),n(Q),n(Zt),n(jt),n(Bt),n(A),n(Xt),n(V),n(kt),n(q),n(Lt),n(zt),n(I),n(Gt),n(N),n(Wt),n(Rt),n(S),n(xt),n(D),n(Ht),n(Qt),n(nt)),n(y),b(T,t),b(_,t),b(C,t),b(J,t),b(Z,t),b(B,t),b(X,t),b(z,t),b(W,t),b(x,t),b(H,t),b(E,t),b(F,t),b(Y,t),b(P,t),b(K,t)}}}const we='{"title":"Integrations","local":"integrations","sections":[{"title":"Transformers","local":"transformers","sections":[{"title":"8-bit optimizers","local":"8-bit-optimizers","sections":[],"depth":3}],"depth":2},{"title":"PEFT","local":"peft","sections":[],"depth":2},{"title":"Accelerate","local":"accelerate","sections":[],"depth":2},{"title":"PyTorch Lightning and Lightning Fabric","local":"pytorch-lightning-and-lightning-fabric","sections":[],"depth":2},{"title":"Lit-GPT","local":"lit-gpt","sections":[],"depth":2},{"title":"Blog posts","local":"blog-posts","sections":[],"depth":2}],"depth":1}';function Te(Ft){return ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ve extends de{constructor(y){super(),be(this,y,Te,Me,me,{})}}export{ve as component};
