import{s as kl,o as Cl}from"../chunks/scheduler.6062bdaf.js";import{S as Bl,i as Zl,g as p,s as a,r as o,A as vl,h as r,f as t,c as n,j as U,u as M,x as i,k as j,y as J,a as l,v as c,d as h,t as u,w as y,m as Bt,n as Zt}from"../chunks/index.4bca734e.js";import{T as Ct}from"../chunks/Tip.b9ac1f03.js";import{I as as}from"../chunks/IconCopyLink.68a13644.js";import{C as w}from"../chunks/CodeBlock.f213e6a5.js";function Gl(k){let m;return{c(){m=Bt(`From within your Space, secrets are available as environment variables (or
Streamlit Secrets Management if using Streamlit). No need to fetch them via the API!`)},l(d){m=Zt(d,`From within your Space, secrets are available as environment variables (or
Streamlit Secrets Management if using Streamlit). No need to fetch them via the API!`)},m(d,T){l(d,m,T)},d(d){d&&t(m)}}}function bl(k){let m;return{c(){m=Bt("Any change in your Space configuration (secrets or hardware) will trigger a restart of your app.")},l(d){m=Zt(d,"Any change in your Space configuration (secrets or hardware) will trigger a restart of your app.")},m(d,T){l(d,m,T)},d(d){d&&t(m)}}}function $l(k){let m;return{c(){m=Bt(`Such a workflow does not support concurrent access as normal demos.
In particular, the interface will be disabled when training occurs.
It is preferable to set your repo as private to ensure you are the only user.`)},l(d){m=Zt(d,`Such a workflow does not support concurrent access as normal demos.
In particular, the interface will be disabled when training occurs.
It is preferable to set your repo as private to ensure you are the only user.`)},m(d,T){l(d,m,T)},d(d){d&&t(m)}}}function Al(k){let m,d,T,C,Pe,X,ft,He,vt="Manage your Space",ns,E,Gt=`In this guide, we will see how to manage your Space runtime
(<a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">secrets</a>,
<a href="https://huggingface.co/docs/hub/spaces-gpus" rel="nofollow">hardware</a>, and <a href="https://huggingface.co/docs/hub/spaces-storage#persistent-storage" rel="nofollow">storage</a>) using <code>huggingface_hub</code>.`,ps,f,B,Ke,N,gt,xe,bt="A simple example: configure secrets and hardware.",rs,R,$t="Here is an end-to-end example to create and setup a Space on the Hub.",is,F,At="<strong>1. Create a Space on the Hub.</strong>",os,Y,Ms,V,St="<strong>1. (bis) Duplicate a Space.</strong>",cs,Q,Xt=`This can prove useful if you want to build up from an existing Space instead of starting from scratch.
It is also useful is you want control over the configuration/settings of a public Space. See <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.duplicate_space">duplicate_space()</a> for more details.`,hs,q,us,W,Et="<strong>2. Upload your code using your preferred solution.</strong>",ys,H,Nt="Here is an example to upload the local folder <code>src/</code> from your machine to your Space:",ms,x,js,z,Rt=`At this step, your app should already be running on the Hub for free !
However, you might want to configure it further with secrets and upgraded hardware.`,ds,L,Ft="<strong>3. Configure secrets and variables</strong>",ws,D,Yt=`Your Space might require some secret keys, token or variables to work.
See <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">docs</a> for more details.
For example, an HF token to upload an image dataset to the Hub once generated from your Space.`,Js,P,Ts,K,Vt="Secrets and variables can be deleted as well:",Us,O,fs,Z,gs,v,Is,ee,Qt="<strong>Bonus: set secrets and variables when creating or duplicating the Space!</strong>",_s,se,qt="Secrets and variables can be set when creating or duplicating a space:",ks,te,Cs,le,Bs,ae,Wt="<strong>4. Configure the hardware</strong>",Zs,ne,Ht=`By default, your Space will run on a CPU environment for free. You can upgrade the hardware
to run it on GPUs. A payment card or a community grant is required to access upgrade your
Space. See <a href="https://huggingface.co/docs/hub/spaces-gpus" rel="nofollow">docs</a> for more details.`,vs,pe,Gs,re,xt=`Hardware updates are not done immediately as your Space has to be reloaded on our servers.
At any time, you can check on which hardware your Space is running to see if your request
has been met.`,bs,ie,$s,oe,zt=`You now have a Space fully configured. Make sure to downgrade your Space back to “cpu-classic”
when you are done using it.`,As,Me,Lt="<strong>Bonus: request hardware when creating or duplicating the Space!</strong>",Ss,ce,Dt="Upgraded hardware will be automatically assigned to your Space once it’s built.",Xs,he,Es,ue,Ns,ye,Pt="<strong>5. Pause and restart your Space</strong>",Rs,me,Kt=`By default if your Space is running on an upgraded hardware, it will never be stopped. However to avoid getting billed,
you might want to pause it when you are not using it. This is possible using <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.pause_space">pause_space()</a>. A paused Space will be
inactive until the owner of the Space restarts it, either with the UI or via API using <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.restart_space">restart_space()</a>.
For more details about paused mode, please refer to <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">this section</a>`,Fs,je,Ys,de,Ot=`Another possibility is to set a timeout for your Space. If your Space is inactive for more than the timeout duration,
it will go to sleep. Any visitor landing on your Space will start it back up. You can set a timeout using
<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.set_space_sleep_time">set_space_sleep_time()</a>. For more details about sleeping mode, please refer to <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">this section</a>.`,Vs,we,Qs,Je,el=`Note: if you are using a ‘cpu-basic’ hardware, you cannot configure a custom sleep time. Your Space will automatically
be paused after 48h of inactivity.`,qs,Te,sl="<strong>Bonus: set a sleep time while requesting hardware</strong>",Ws,Ue,tl="Upgraded hardware will be automatically assigned to your Space once it’s built.",Hs,fe,xs,ge,ll="<strong>Bonus: set a sleep time when creating or duplicating the Space!</strong>",zs,Ie,Ls,_e,Ds,ke,al="<strong>6. Add persistent storage to your Space</strong>",Ps,Ce,nl='You can choose the storage tier of your choice to access disk space that persists across restarts of your Space. This means you can read and write from disk like you would with a traditional hard drive. See <a href="https://huggingface.co/docs/hub/spaces-storage#persistent-storage" rel="nofollow">docs</a> for more details.',Ks,Be,Os,Ze,pl="You can also delete your storage, losing all the data permanently.",et,ve,st,Ge,rl=`Note: You cannot decrease the storage tier of your space once it’s been granted. To do so,
you must delete the storage first then request the new desired tier.`,tt,be,il="<strong>Bonus: request storage when creating or duplicating the Space!</strong>",lt,$e,at,Ae,nt,g,G,Oe,Se,It,ze,ol="More advanced: temporarily upgrade your Space !",pt,Xe,Ml=`Spaces allow for a lot of different use cases. Sometimes, you might want
to temporarily run a Space on a specific hardware, do something and then shut it down. In
this section, we will explore how to benefit from Spaces to finetune a model on demand.
This is only one way of solving this particular problem. It has to be taken as a suggestion
and adapted to your use case.`,rt,Ee,cl=`Let’s assume we have a Space to finetune a model. It is a Gradio app that takes as input
a model id and a dataset id. The workflow is as follows:`,it,b,hl="<li>(Prompt the user for a model and a dataset)</li> <li>Load the model from the Hub.</li> <li>Load the dataset from the Hub.</li> <li>Finetune the model on the dataset.</li> <li>Upload the new model to the Hub.</li>",ot,Ne,ul=`Step 3. requires a custom hardware but you don’t want your Space to be running all the time on a paid
GPU. A solution is to dynamically request hardware for the training and shut it
down afterwards. Since requesting hardware restarts your Space, your app must somehow “remember”
the current task it is performing. There are multiple ways of doing this. In this guide
we will see one solution using a Dataset as “task scheduler”.`,Mt,I,$,es,Re,_t,Le,yl="App skeleton",ct,Fe,ml=`Here is what your app would look like. On startup, check if a task is scheduled and if yes,
run it on the correct hardware. Once done, set back hardware to the free-plan CPU and
prompt the user for a new task.`,ht,A,ut,Ye,yt,_,S,ss,Ve,kt,De,jl="Task scheduler",mt,Qe,dl=`Scheduling tasks can be done in many ways. Here is an example how it could be done using
a simple CSV stored as a Dataset.`,jt,qe,dt;return X=new as({}),N=new as({}),Y=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBcmVwb19pZCUyMCUzRCUyMCUyMldhdXBsaW4lMkZteS1jb29sLXRyYWluaW5nLXNwYWNlJTIyJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5jcmVhdGVfcmVwbyhyZXBvX2lkJTNEcmVwb19pZCUyQyUyMHJlcG9fdHlwZSUzRCUyMnNwYWNlJTIyJTJDJTIwc3BhY2Vfc2RrJTNEJTIyZ3JhZGlvJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;Wauplin/my-cool-training-space&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># For example with a Gradio SDK</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(repo_id=repo_id, repo_type=<span class="hljs-string">&quot;space&quot;</span>, space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>)`}}),q=new w({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>)'}}),x=new w({props:{code:"YXBpLnVwbG9hZF9mb2xkZXIocmVwb19pZCUzRHJlcG9faWQlMkMlMjByZXBvX3R5cGUlM0QlMjJzcGFjZSUyMiUyQyUyMGZvbGRlcl9wYXRoJTNEJTIyc3JjJTJGJTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(repo_id=repo_id, repo_type=<span class="hljs-string">&quot;space&quot;</span>, folder_path=<span class="hljs-string">&quot;src/&quot;</span>)'}}),P=new w({props:{code:"YXBpLmFkZF9zcGFjZV9zZWNyZXQocmVwb19pZCUzRHJlcG9faWQlMkMlMjBrZXklM0QlMjJIRl9UT0tFTiUyMiUyQyUyMHZhbHVlJTNEJTIyaGZfYXBpXyoqKiUyMiklMEFhcGkuYWRkX3NwYWNlX3ZhcmlhYmxlKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwa2V5JTNEJTIyTU9ERUxfUkVQT19JRCUyMiUyQyUyMHZhbHVlJTNEJTIydXNlciUyRnJlcG8lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.add_space_secret(repo_id=repo_id, key=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, value=<span class="hljs-string">&quot;hf_api_***&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.add_space_variable(repo_id=repo_id, key=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, value=<span class="hljs-string">&quot;user/repo&quot;</span>)`}}),O=new w({props:{code:"YXBpLmRlbGV0ZV9zcGFjZV9zZWNyZXQocmVwb19pZCUzRHJlcG9faWQlMkMlMjBrZXklM0QlMjJIRl9UT0tFTiUyMiklMEFhcGkuZGVsZXRlX3NwYWNlX3ZhcmlhYmxlKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwa2V5JTNEJTIyTU9ERUxfUkVQT19JRCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_secret(repo_id=repo_id, key=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_variable(repo_id=repo_id, key=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>)`}}),Z=new Ct({props:{$$slots:{default:[Gl]},$$scope:{ctx:k}}}),v=new Ct({props:{warning:!0,$$slots:{default:[bl]},$$scope:{ctx:k}}}),te=new w({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZWNyZXRzJTNEJTVCJTdCJTIya2V5JTIyJTNEJTIySEZfVE9LRU4lMjIlMkMlMjAlMjJ2YWx1ZSUyMiUzRCUyMmhmX2FwaV8qKiolMjIlN0QlMkMlMjAuLi4lNUQlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV92YXJpYWJsZXMlM0QlNUIlN0IlMjJrZXklMjIlM0QlMjJNT0RFTF9SRVBPX0lEJTIyJTJDJTIwJTIydmFsdWUlMjIlM0QlMjJ1c2VyJTJGcmVwbyUyMiU3RCUyQyUyMC4uLiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>,
<span class="hljs-meta">... </span>    space_secrets=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;hf_api_***&quot;</span>}, ...],
<span class="hljs-meta">... </span>    space_variables=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;user/repo&quot;</span>}, ...],
<span class="hljs-meta">... </span>)`}}),le=new w({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHNlY3JldHMlM0QlNUIlN0IlMjJrZXklMjIlM0QlMjJIRl9UT0tFTiUyMiUyQyUyMCUyMnZhbHVlJTIyJTNEJTIyaGZfYXBpXyoqKiUyMiU3RCUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhYmxlcyUzRCU1QiU3QiUyMmtleSUyMiUzRCUyMk1PREVMX1JFUE9fSUQlMjIlMkMlMjAlMjJ2YWx1ZSUyMiUzRCUyMnVzZXIlMkZyZXBvJTIyJTdEJTJDJTIwLi4uJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    secrets=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;hf_api_***&quot;</span>}, ...],
<span class="hljs-meta">... </span>    variables=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;user/repo&quot;</span>}, ...],
<span class="hljs-meta">... </span>)`}}),pe=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFNwYWNlSGFyZHdhcmUlMEFhcGkucmVxdWVzdF9zcGFjZV9oYXJkd2FyZShyZXBvX2lkJTNEcmVwb19pZCUyQyUyMGhhcmR3YXJlJTNEU3BhY2VIYXJkd2FyZS5UNF9NRURJVU0pJTBBJTBBYXBpLnJlcXVlc3Rfc3BhY2VfaGFyZHdhcmUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBoYXJkd2FyZSUzRCUyMnQ0LW1lZGl1bSUyMik=",highlighted:`<span class="hljs-comment"># Use \`SpaceHardware\` enum</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> SpaceHardware
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=SpaceHardware.T4_MEDIUM)

<span class="hljs-comment"># Or simply pass a string value</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>)`}}),ie=new w({props:{code:"cnVudGltZSUyMCUzRCUyMGFwaS5nZXRfc3BhY2VfcnVudGltZShyZXBvX2lkJTNEcmVwb19pZCklMEFydW50aW1lLnN0YWdlJTBBcnVudGltZS5oYXJkd2FyZSUwQXJ1bnRpbWUucmVxdWVzdGVkX2hhcmR3YXJl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>runtime = api.get_space_runtime(repo_id=repo_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.stage
<span class="hljs-string">&quot;RUNNING_BUILDING&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.hardware
<span class="hljs-string">&quot;cpu-basic&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.requested_hardware
<span class="hljs-string">&quot;t4-medium&quot;</span>`}}),he=new w({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9oYXJkd2FyZSUzRCUyMmNwdS11cGdyYWRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BhY2Vfc3RvcmFnZSUzRCUyMnNtYWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BhY2Vfc2xlZXBfdGltZSUzRCUyMjcyMDAlMjIlMkMlMjAlMjMlMjAyJTIwaG91cnMlMjBpbiUyMHNlY3MlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_hardware=<span class="hljs-string">&quot;cpu-upgrade&quot;</span>,
<span class="hljs-meta">... </span>    space_storage=<span class="hljs-string">&quot;small&quot;</span>,
<span class="hljs-meta">... </span>    space_sleep_time=<span class="hljs-string">&quot;7200&quot;</span>, <span class="hljs-comment"># 2 hours in secs</span>
<span class="hljs-meta">... </span>)`}}),ue=new w({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMGhhcmR3YXJlJTNEJTIyY3B1LXVwZ3JhZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBzdG9yYWdlJTNEJTIyc21hbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBzbGVlcF90aW1lJTNEJTIyNzIwMCUyMiUyQyUyMCUyMyUyMDIlMjBob3VycyUyMGluJTIwc2VjcyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    hardware=<span class="hljs-string">&quot;cpu-upgrade&quot;</span>,
<span class="hljs-meta">... </span>    storage=<span class="hljs-string">&quot;small&quot;</span>,
<span class="hljs-meta">... </span>    sleep_time=<span class="hljs-string">&quot;7200&quot;</span>, <span class="hljs-comment"># 2 hours in secs</span>
<span class="hljs-meta">... </span>)`}}),je=new w({props:{code:"YXBpLnBhdXNlX3NwYWNlKHJlcG9faWQlM0RyZXBvX2lkKSUwQWFwaS5yZXN0YXJ0X3NwYWNlKHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:`<span class="hljs-comment"># Pause your Space to avoid getting billed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.pause_space(repo_id=repo_id)
<span class="hljs-comment"># (...)</span>
<span class="hljs-comment"># Restart it when you need it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.restart_space(repo_id=repo_id)`}}),we=new w({props:{code:"YXBpLnNldF9zcGFjZV9zbGVlcF90aW1lKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwc2xlZXBfdGltZSUzRDM2MDAp",highlighted:`<span class="hljs-comment"># Put your Space to sleep after 1h of inactivity</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.set_space_sleep_time(repo_id=repo_id, sleep_time=<span class="hljs-number">3600</span>)`}}),fe=new w({props:{code:"YXBpLnJlcXVlc3Rfc3BhY2VfaGFyZHdhcmUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBoYXJkd2FyZSUzRFNwYWNlSGFyZHdhcmUuVDRfTUVESVVNJTJDJTIwc2xlZXBfdGltZSUzRDM2MDAp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=SpaceHardware.T4_MEDIUM, sleep_time=<span class="hljs-number">3600</span>)'}}),Ie=new w({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9oYXJkd2FyZSUzRCUyMnQ0LW1lZGl1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwYWNlX3NsZWVwX3RpbWUlM0QlMjIzNjAwJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>,
<span class="hljs-meta">... </span>    space_sleep_time=<span class="hljs-string">&quot;3600&quot;</span>,
<span class="hljs-meta">... </span>)`}}),_e=new w({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMGhhcmR3YXJlJTNEJTIydDQtbWVkaXVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2xlZXBfdGltZSUzRCUyMjM2MDAlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>,
<span class="hljs-meta">... </span>    sleep_time=<span class="hljs-string">&quot;3600&quot;</span>,
<span class="hljs-meta">... </span>)`}}),Be=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFNwYWNlU3RvcmFnZSUwQWFwaS5yZXF1ZXN0X3NwYWNlX3N0b3JhZ2UocmVwb19pZCUzRHJlcG9faWQlMkMlMjBzdG9yYWdlJTNEU3BhY2VTdG9yYWdlLkxBUkdFKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> SpaceStorage
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_storage(repo_id=repo_id, storage=SpaceStorage.LARGE)`}}),ve=new w({props:{code:"YXBpLmRlbGV0ZV9zcGFjZV9zdG9yYWdlKHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_storage(repo_id=repo_id)'}}),$e=new w({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9zdG9yYWdlJTNEJTIybGFyZ2UlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_storage=<span class="hljs-string">&quot;large&quot;</span>,
<span class="hljs-meta">... </span>)`}}),Ae=new w({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHN0b3JhZ2UlM0QlMjJsYXJnZSUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    storage=<span class="hljs-string">&quot;large&quot;</span>,
<span class="hljs-meta">... </span>)`}}),Se=new as({}),Re=new as({}),A=new Ct({props:{warning:!0,$$slots:{default:[$l]},$$scope:{ctx:k}}}),Ye=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Space will need your token to request hardware: set it as a Secret !</span>
HF_TOKEN = os.environ.get(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)

<span class="hljs-comment"># Space own repo_id</span>
TRAINING_SPACE_ID = <span class="hljs-string">&quot;Wauplin/dreambooth-training&quot;</span>

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, SpaceHardware
api = HfApi(token=HF_TOKEN)

<span class="hljs-comment"># On Space startup, check if a task is scheduled. If yes, finetune the model. If not,</span>
<span class="hljs-comment"># display an interface to request a new task.</span>
task = get_task()
<span class="hljs-keyword">if</span> task <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># Start Gradio app</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">gradio_fn</span>(<span class="hljs-params">task</span>):
        <span class="hljs-comment"># On user request, add task and request hardware</span>
        add_task(task)
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.T4_MEDIUM)

    gr.Interface(fn=gradio_fn, ...).launch()
<span class="hljs-keyword">else</span>:
    runtime = api.get_space_runtime(repo_id=TRAINING_SPACE_ID)
    <span class="hljs-comment"># Check if Space is loaded with a GPU.</span>
    <span class="hljs-keyword">if</span> runtime.hardware == SpaceHardware.T4_MEDIUM:
        <span class="hljs-comment"># If yes, finetune base model on dataset !</span>
        train_and_upload(task)

        <span class="hljs-comment"># Then, mark the task as &quot;DONE&quot;</span>
        mark_as_done(task)

        <span class="hljs-comment"># DO NOT FORGET: set back CPU hardware</span>
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.CPU_BASIC)
    <span class="hljs-keyword">else</span>:
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.T4_MEDIUM)`}}),Ve=new as({}),qe=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Dataset ID in which a \`tasks.csv\` file contains the tasks to perform.</span>
<span class="hljs-comment"># Here is a basic example for \`tasks.csv\` containing inputs (base model and dataset)</span>
<span class="hljs-comment"># and status (PENDING or DONE).</span>
<span class="hljs-comment">#     multimodalart/sd-fine-tunable,Wauplin/concept-1,DONE</span>
<span class="hljs-comment">#     multimodalart/sd-fine-tunable,Wauplin/concept-2,PENDING</span>
TASK_DATASET_ID = <span class="hljs-string">&quot;Wauplin/dreambooth-task-scheduler&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">_get_csv_file</span>():
    <span class="hljs-keyword">return</span> hf_hub_download(repo_id=TASK_DATASET_ID, filename=<span class="hljs-string">&quot;tasks.csv&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, token=HF_TOKEN)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_task</span>():
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        csv_reader = csv.reader(csv_file, delimiter=<span class="hljs-string">&#x27;,&#x27;</span>)
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> csv_reader:
            <span class="hljs-keyword">if</span> row[<span class="hljs-number">2</span>] == <span class="hljs-string">&quot;PENDING&quot;</span>:
                <span class="hljs-keyword">return</span> row[<span class="hljs-number">0</span>], row[<span class="hljs-number">1</span>] <span class="hljs-comment"># model_id, dataset_id</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_task</span>(<span class="hljs-params">task</span>):
    model_id, dataset_id = task
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(csv_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
            tasks = f.read()

    api.upload_file(
        repo_id=repo_id,
        repo_type=repo_type,
        path_in_repo=<span class="hljs-string">&quot;tasks.csv&quot;</span>,
        <span class="hljs-comment"># Quick and dirty way to add a task</span>
        path_or_fileobj=(tasks + <span class="hljs-string">f&quot;\\n<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,PENDING&quot;</span>).encode()
    )

<span class="hljs-keyword">def</span> <span class="hljs-title function_">mark_as_done</span>(<span class="hljs-params">task</span>):
    model_id, dataset_id = task
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(csv_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
            tasks = f.read()

    api.upload_file(
        repo_id=repo_id,
        repo_type=repo_type,
        path_in_repo=<span class="hljs-string">&quot;tasks.csv&quot;</span>,
        <span class="hljs-comment"># Quick and dirty way to set the task as DONE</span>
        path_or_fileobj=tasks.replace(
            <span class="hljs-string">f&quot;<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,PENDING&quot;</span>,
            <span class="hljs-string">f&quot;<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,DONE&quot;</span>
        ).encode()
    )`}}),{c(){m=p("meta"),d=a(),T=p("h1"),C=p("a"),Pe=p("span"),o(X.$$.fragment),ft=a(),He=p("span"),He.textContent=vt,ns=a(),E=p("p"),E.innerHTML=Gt,ps=a(),f=p("h2"),B=p("a"),Ke=p("span"),o(N.$$.fragment),gt=a(),xe=p("span"),xe.textContent=bt,rs=a(),R=p("p"),R.textContent=$t,is=a(),F=p("p"),F.innerHTML=At,os=a(),o(Y.$$.fragment),Ms=a(),V=p("p"),V.innerHTML=St,cs=a(),Q=p("p"),Q.innerHTML=Xt,hs=a(),o(q.$$.fragment),us=a(),W=p("p"),W.innerHTML=Et,ys=a(),H=p("p"),H.innerHTML=Nt,ms=a(),o(x.$$.fragment),js=a(),z=p("p"),z.textContent=Rt,ds=a(),L=p("p"),L.innerHTML=Ft,ws=a(),D=p("p"),D.innerHTML=Yt,Js=a(),o(P.$$.fragment),Ts=a(),K=p("p"),K.textContent=Vt,Us=a(),o(O.$$.fragment),fs=a(),o(Z.$$.fragment),gs=a(),o(v.$$.fragment),Is=a(),ee=p("p"),ee.innerHTML=Qt,_s=a(),se=p("p"),se.textContent=qt,ks=a(),o(te.$$.fragment),Cs=a(),o(le.$$.fragment),Bs=a(),ae=p("p"),ae.innerHTML=Wt,Zs=a(),ne=p("p"),ne.innerHTML=Ht,vs=a(),o(pe.$$.fragment),Gs=a(),re=p("p"),re.textContent=xt,bs=a(),o(ie.$$.fragment),$s=a(),oe=p("p"),oe.textContent=zt,As=a(),Me=p("p"),Me.innerHTML=Lt,Ss=a(),ce=p("p"),ce.textContent=Dt,Xs=a(),o(he.$$.fragment),Es=a(),o(ue.$$.fragment),Ns=a(),ye=p("p"),ye.innerHTML=Pt,Rs=a(),me=p("p"),me.innerHTML=Kt,Fs=a(),o(je.$$.fragment),Ys=a(),de=p("p"),de.innerHTML=Ot,Vs=a(),o(we.$$.fragment),Qs=a(),Je=p("p"),Je.textContent=el,qs=a(),Te=p("p"),Te.innerHTML=sl,Ws=a(),Ue=p("p"),Ue.textContent=tl,Hs=a(),o(fe.$$.fragment),xs=a(),ge=p("p"),ge.innerHTML=ll,zs=a(),o(Ie.$$.fragment),Ls=a(),o(_e.$$.fragment),Ds=a(),ke=p("p"),ke.innerHTML=al,Ps=a(),Ce=p("p"),Ce.innerHTML=nl,Ks=a(),o(Be.$$.fragment),Os=a(),Ze=p("p"),Ze.textContent=pl,et=a(),o(ve.$$.fragment),st=a(),Ge=p("p"),Ge.textContent=rl,tt=a(),be=p("p"),be.innerHTML=il,lt=a(),o($e.$$.fragment),at=a(),o(Ae.$$.fragment),nt=a(),g=p("h2"),G=p("a"),Oe=p("span"),o(Se.$$.fragment),It=a(),ze=p("span"),ze.textContent=ol,pt=a(),Xe=p("p"),Xe.textContent=Ml,rt=a(),Ee=p("p"),Ee.textContent=cl,it=a(),b=p("ol"),b.innerHTML=hl,ot=a(),Ne=p("p"),Ne.textContent=ul,Mt=a(),I=p("h3"),$=p("a"),es=p("span"),o(Re.$$.fragment),_t=a(),Le=p("span"),Le.textContent=yl,ct=a(),Fe=p("p"),Fe.textContent=ml,ht=a(),o(A.$$.fragment),ut=a(),o(Ye.$$.fragment),yt=a(),_=p("h3"),S=p("a"),ss=p("span"),o(Ve.$$.fragment),kt=a(),De=p("span"),De.textContent=jl,mt=a(),Qe=p("p"),Qe.textContent=dl,jt=a(),o(qe.$$.fragment),this.h()},l(e){const s=vl("svelte-1phssyn",document.head);m=r(s,"META",{name:!0,content:!0}),s.forEach(t),d=n(e),T=r(e,"H1",{class:!0});var We=U(T);C=r(We,"A",{id:!0,class:!0,href:!0});var ts=U(C);Pe=r(ts,"SPAN",{});var ls=U(Pe);M(X.$$.fragment,ls),ls.forEach(t),ts.forEach(t),ft=n(We),He=r(We,"SPAN",{"data-svelte-h":!0}),i(He)!=="svelte-138uqbj"&&(He.textContent=vt),We.forEach(t),ns=n(e),E=r(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1ppnonz"&&(E.innerHTML=Gt),ps=n(e),f=r(e,"H2",{class:!0});var wt=U(f);B=r(wt,"A",{id:!0,class:!0,href:!0});var wl=U(B);Ke=r(wl,"SPAN",{});var Jl=U(Ke);M(N.$$.fragment,Jl),Jl.forEach(t),wl.forEach(t),gt=n(wt),xe=r(wt,"SPAN",{"data-svelte-h":!0}),i(xe)!=="svelte-tz0ews"&&(xe.textContent=bt),wt.forEach(t),rs=n(e),R=r(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-16uv4iz"&&(R.textContent=$t),is=n(e),F=r(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-ntfke8"&&(F.innerHTML=At),os=n(e),M(Y.$$.fragment,e),Ms=n(e),V=r(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-18k6wu9"&&(V.innerHTML=St),cs=n(e),Q=r(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-6xgua9"&&(Q.innerHTML=Xt),hs=n(e),M(q.$$.fragment,e),us=n(e),W=r(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-hnqkcz"&&(W.innerHTML=Et),ys=n(e),H=r(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-8mheo9"&&(H.innerHTML=Nt),ms=n(e),M(x.$$.fragment,e),js=n(e),z=r(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1z3goh"&&(z.textContent=Rt),ds=n(e),L=r(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1sfgan5"&&(L.innerHTML=Ft),ws=n(e),D=r(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1704hn0"&&(D.innerHTML=Yt),Js=n(e),M(P.$$.fragment,e),Ts=n(e),K=r(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-65kjzl"&&(K.textContent=Vt),Us=n(e),M(O.$$.fragment,e),fs=n(e),M(Z.$$.fragment,e),gs=n(e),M(v.$$.fragment,e),Is=n(e),ee=r(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-poxyid"&&(ee.innerHTML=Qt),_s=n(e),se=r(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-1rmjpll"&&(se.textContent=qt),ks=n(e),M(te.$$.fragment,e),Cs=n(e),M(le.$$.fragment,e),Bs=n(e),ae=r(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-vobpqe"&&(ae.innerHTML=Wt),Zs=n(e),ne=r(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-1ctsnq4"&&(ne.innerHTML=Ht),vs=n(e),M(pe.$$.fragment,e),Gs=n(e),re=r(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-aczhvz"&&(re.textContent=xt),bs=n(e),M(ie.$$.fragment,e),$s=n(e),oe=r(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-c540cm"&&(oe.textContent=zt),As=n(e),Me=r(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-jbzoo9"&&(Me.innerHTML=Lt),Ss=n(e),ce=r(e,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-4tl7ie"&&(ce.textContent=Dt),Xs=n(e),M(he.$$.fragment,e),Es=n(e),M(ue.$$.fragment,e),Ns=n(e),ye=r(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-1i0f4op"&&(ye.innerHTML=Pt),Rs=n(e),me=r(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-p2hwvu"&&(me.innerHTML=Kt),Fs=n(e),M(je.$$.fragment,e),Ys=n(e),de=r(e,"P",{"data-svelte-h":!0}),i(de)!=="svelte-f0hr05"&&(de.innerHTML=Ot),Vs=n(e),M(we.$$.fragment,e),Qs=n(e),Je=r(e,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-97ry2r"&&(Je.textContent=el),qs=n(e),Te=r(e,"P",{"data-svelte-h":!0}),i(Te)!=="svelte-1lxv1bl"&&(Te.innerHTML=sl),Ws=n(e),Ue=r(e,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-4tl7ie"&&(Ue.textContent=tl),Hs=n(e),M(fe.$$.fragment,e),xs=n(e),ge=r(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-5hjx5j"&&(ge.innerHTML=ll),zs=n(e),M(Ie.$$.fragment,e),Ls=n(e),M(_e.$$.fragment,e),Ds=n(e),ke=r(e,"P",{"data-svelte-h":!0}),i(ke)!=="svelte-pvw90y"&&(ke.innerHTML=al),Ps=n(e),Ce=r(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-2qrjmq"&&(Ce.innerHTML=nl),Ks=n(e),M(Be.$$.fragment,e),Os=n(e),Ze=r(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-1u6d0ko"&&(Ze.textContent=pl),et=n(e),M(ve.$$.fragment,e),st=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),i(Ge)!=="svelte-m35g6d"&&(Ge.textContent=rl),tt=n(e),be=r(e,"P",{"data-svelte-h":!0}),i(be)!=="svelte-1mxuks2"&&(be.innerHTML=il),lt=n(e),M($e.$$.fragment,e),at=n(e),M(Ae.$$.fragment,e),nt=n(e),g=r(e,"H2",{class:!0});var Jt=U(g);G=r(Jt,"A",{id:!0,class:!0,href:!0});var Tl=U(G);Oe=r(Tl,"SPAN",{});var Ul=U(Oe);M(Se.$$.fragment,Ul),Ul.forEach(t),Tl.forEach(t),It=n(Jt),ze=r(Jt,"SPAN",{"data-svelte-h":!0}),i(ze)!=="svelte-129evhq"&&(ze.textContent=ol),Jt.forEach(t),pt=n(e),Xe=r(e,"P",{"data-svelte-h":!0}),i(Xe)!=="svelte-1gmpxen"&&(Xe.textContent=Ml),rt=n(e),Ee=r(e,"P",{"data-svelte-h":!0}),i(Ee)!=="svelte-10q1pgf"&&(Ee.textContent=cl),it=n(e),b=r(e,"OL",{start:!0,"data-svelte-h":!0}),i(b)!=="svelte-1guz9nt"&&(b.innerHTML=hl),ot=n(e),Ne=r(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-14y67eb"&&(Ne.textContent=ul),Mt=n(e),I=r(e,"H3",{class:!0});var Tt=U(I);$=r(Tt,"A",{id:!0,class:!0,href:!0});var fl=U($);es=r(fl,"SPAN",{});var gl=U(es);M(Re.$$.fragment,gl),gl.forEach(t),fl.forEach(t),_t=n(Tt),Le=r(Tt,"SPAN",{"data-svelte-h":!0}),i(Le)!=="svelte-ne7tf7"&&(Le.textContent=yl),Tt.forEach(t),ct=n(e),Fe=r(e,"P",{"data-svelte-h":!0}),i(Fe)!=="svelte-16rgffk"&&(Fe.textContent=ml),ht=n(e),M(A.$$.fragment,e),ut=n(e),M(Ye.$$.fragment,e),yt=n(e),_=r(e,"H3",{class:!0});var Ut=U(_);S=r(Ut,"A",{id:!0,class:!0,href:!0});var Il=U(S);ss=r(Il,"SPAN",{});var _l=U(ss);M(Ve.$$.fragment,_l),_l.forEach(t),Il.forEach(t),kt=n(Ut),De=r(Ut,"SPAN",{"data-svelte-h":!0}),i(De)!=="svelte-1ips3sh"&&(De.textContent=jl),Ut.forEach(t),mt=n(e),Qe=r(e,"P",{"data-svelte-h":!0}),i(Qe)!=="svelte-1fps41q"&&(Qe.textContent=dl),jt=n(e),M(qe.$$.fragment,e),this.h()},h(){j(m,"name","hf:doc:metadata"),j(m,"content",JSON.stringify(Sl)),j(C,"id","manage-your-space"),j(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(C,"href","#manage-your-space"),j(T,"class","relative group"),j(B,"id","a-simple-example-configure-secrets-and-hardware"),j(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(B,"href","#a-simple-example-configure-secrets-and-hardware"),j(f,"class","relative group"),j(G,"id","more-advanced-temporarily-upgrade-your-space"),j(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(G,"href","#more-advanced-temporarily-upgrade-your-space"),j(g,"class","relative group"),j(b,"start","0"),j($,"id","app-skeleton"),j($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j($,"href","#app-skeleton"),j(I,"class","relative group"),j(S,"id","task-scheduler"),j(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(S,"href","#task-scheduler"),j(_,"class","relative group")},m(e,s){J(document.head,m),l(e,d,s),l(e,T,s),J(T,C),J(C,Pe),c(X,Pe,null),J(T,ft),J(T,He),l(e,ns,s),l(e,E,s),l(e,ps,s),l(e,f,s),J(f,B),J(B,Ke),c(N,Ke,null),J(f,gt),J(f,xe),l(e,rs,s),l(e,R,s),l(e,is,s),l(e,F,s),l(e,os,s),c(Y,e,s),l(e,Ms,s),l(e,V,s),l(e,cs,s),l(e,Q,s),l(e,hs,s),c(q,e,s),l(e,us,s),l(e,W,s),l(e,ys,s),l(e,H,s),l(e,ms,s),c(x,e,s),l(e,js,s),l(e,z,s),l(e,ds,s),l(e,L,s),l(e,ws,s),l(e,D,s),l(e,Js,s),c(P,e,s),l(e,Ts,s),l(e,K,s),l(e,Us,s),c(O,e,s),l(e,fs,s),c(Z,e,s),l(e,gs,s),c(v,e,s),l(e,Is,s),l(e,ee,s),l(e,_s,s),l(e,se,s),l(e,ks,s),c(te,e,s),l(e,Cs,s),c(le,e,s),l(e,Bs,s),l(e,ae,s),l(e,Zs,s),l(e,ne,s),l(e,vs,s),c(pe,e,s),l(e,Gs,s),l(e,re,s),l(e,bs,s),c(ie,e,s),l(e,$s,s),l(e,oe,s),l(e,As,s),l(e,Me,s),l(e,Ss,s),l(e,ce,s),l(e,Xs,s),c(he,e,s),l(e,Es,s),c(ue,e,s),l(e,Ns,s),l(e,ye,s),l(e,Rs,s),l(e,me,s),l(e,Fs,s),c(je,e,s),l(e,Ys,s),l(e,de,s),l(e,Vs,s),c(we,e,s),l(e,Qs,s),l(e,Je,s),l(e,qs,s),l(e,Te,s),l(e,Ws,s),l(e,Ue,s),l(e,Hs,s),c(fe,e,s),l(e,xs,s),l(e,ge,s),l(e,zs,s),c(Ie,e,s),l(e,Ls,s),c(_e,e,s),l(e,Ds,s),l(e,ke,s),l(e,Ps,s),l(e,Ce,s),l(e,Ks,s),c(Be,e,s),l(e,Os,s),l(e,Ze,s),l(e,et,s),c(ve,e,s),l(e,st,s),l(e,Ge,s),l(e,tt,s),l(e,be,s),l(e,lt,s),c($e,e,s),l(e,at,s),c(Ae,e,s),l(e,nt,s),l(e,g,s),J(g,G),J(G,Oe),c(Se,Oe,null),J(g,It),J(g,ze),l(e,pt,s),l(e,Xe,s),l(e,rt,s),l(e,Ee,s),l(e,it,s),l(e,b,s),l(e,ot,s),l(e,Ne,s),l(e,Mt,s),l(e,I,s),J(I,$),J($,es),c(Re,es,null),J(I,_t),J(I,Le),l(e,ct,s),l(e,Fe,s),l(e,ht,s),c(A,e,s),l(e,ut,s),c(Ye,e,s),l(e,yt,s),l(e,_,s),J(_,S),J(S,ss),c(Ve,ss,null),J(_,kt),J(_,De),l(e,mt,s),l(e,Qe,s),l(e,jt,s),c(qe,e,s),dt=!0},p(e,[s]){const We={};s&2&&(We.$$scope={dirty:s,ctx:e}),Z.$set(We);const ts={};s&2&&(ts.$$scope={dirty:s,ctx:e}),v.$set(ts);const ls={};s&2&&(ls.$$scope={dirty:s,ctx:e}),A.$set(ls)},i(e){dt||(h(X.$$.fragment,e),h(N.$$.fragment,e),h(Y.$$.fragment,e),h(q.$$.fragment,e),h(x.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(Z.$$.fragment,e),h(v.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(pe.$$.fragment,e),h(ie.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(je.$$.fragment,e),h(we.$$.fragment,e),h(fe.$$.fragment,e),h(Ie.$$.fragment,e),h(_e.$$.fragment,e),h(Be.$$.fragment,e),h(ve.$$.fragment,e),h($e.$$.fragment,e),h(Ae.$$.fragment,e),h(Se.$$.fragment,e),h(Re.$$.fragment,e),h(A.$$.fragment,e),h(Ye.$$.fragment,e),h(Ve.$$.fragment,e),h(qe.$$.fragment,e),dt=!0)},o(e){u(X.$$.fragment,e),u(N.$$.fragment,e),u(Y.$$.fragment,e),u(q.$$.fragment,e),u(x.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(Z.$$.fragment,e),u(v.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(pe.$$.fragment,e),u(ie.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(je.$$.fragment,e),u(we.$$.fragment,e),u(fe.$$.fragment,e),u(Ie.$$.fragment,e),u(_e.$$.fragment,e),u(Be.$$.fragment,e),u(ve.$$.fragment,e),u($e.$$.fragment,e),u(Ae.$$.fragment,e),u(Se.$$.fragment,e),u(Re.$$.fragment,e),u(A.$$.fragment,e),u(Ye.$$.fragment,e),u(Ve.$$.fragment,e),u(qe.$$.fragment,e),dt=!1},d(e){e&&(t(d),t(T),t(ns),t(E),t(ps),t(f),t(rs),t(R),t(is),t(F),t(os),t(Ms),t(V),t(cs),t(Q),t(hs),t(us),t(W),t(ys),t(H),t(ms),t(js),t(z),t(ds),t(L),t(ws),t(D),t(Js),t(Ts),t(K),t(Us),t(fs),t(gs),t(Is),t(ee),t(_s),t(se),t(ks),t(Cs),t(Bs),t(ae),t(Zs),t(ne),t(vs),t(Gs),t(re),t(bs),t($s),t(oe),t(As),t(Me),t(Ss),t(ce),t(Xs),t(Es),t(Ns),t(ye),t(Rs),t(me),t(Fs),t(Ys),t(de),t(Vs),t(Qs),t(Je),t(qs),t(Te),t(Ws),t(Ue),t(Hs),t(xs),t(ge),t(zs),t(Ls),t(Ds),t(ke),t(Ps),t(Ce),t(Ks),t(Os),t(Ze),t(et),t(st),t(Ge),t(tt),t(be),t(lt),t(at),t(nt),t(g),t(pt),t(Xe),t(rt),t(Ee),t(it),t(b),t(ot),t(Ne),t(Mt),t(I),t(ct),t(Fe),t(ht),t(ut),t(yt),t(_),t(mt),t(Qe),t(jt)),t(m),y(X),y(N),y(Y,e),y(q,e),y(x,e),y(P,e),y(O,e),y(Z,e),y(v,e),y(te,e),y(le,e),y(pe,e),y(ie,e),y(he,e),y(ue,e),y(je,e),y(we,e),y(fe,e),y(Ie,e),y(_e,e),y(Be,e),y(ve,e),y($e,e),y(Ae,e),y(Se),y(Re),y(A,e),y(Ye,e),y(Ve),y(qe,e)}}}const Sl={local:"manage-your-space",sections:[{local:"a-simple-example-configure-secrets-and-hardware",title:"A simple example: configure secrets and hardware."},{local:"more-advanced-temporarily-upgrade-your-space",sections:[{local:"app-skeleton",title:"App skeleton"},{local:"task-scheduler",title:"Task scheduler"}],title:"More advanced: temporarily upgrade your Space !"}],title:"Manage your Space"};function Xl(k){return Cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vl extends Bl{constructor(m){super(),Zl(this,m,Xl,Al,kl,{})}}export{Vl as component};
