import{s as Pn,f as Ut,n as Hn,o as Sn}from"../chunks/scheduler.048ce5c2.js";import{S as wn,i as qn,g as i,s as n,r as p,A as dn,h as j,f as e,c as U,j as Mn,u as o,x as l,k as V,y as Wn,a,v as c,d as s,t as r,w as K}from"../chunks/index.2633050f.js";import{C as R}from"../chunks/CodeBlock.b34ffc90.js";import{D as mn}from"../chunks/DocNotebookDropdown.2a84b269.js";import{H as u}from"../chunks/Heading.bb054f8c.js";function Gn(ca){let F,Rt,rt,ut,k,Ft,y,Vt,x,sa="This notebook is going to cover the basics of how to use Stable Diffusion to create and modify images using existing pipelines. We’ll also take a brief look at the key components within the pipeline, while leaving further exploration of them to the deep dive notebook. Specifically, we will cover:",kt,M,ra="<li>Generating images from text using the <code>StableDiffusionPipeline</code> and experimenting with the available arguments</li> <li>Seeing some of the key pipeline components in action<ul><li>The VAE that makes this a ‘latent diffusion model’</li> <li>The tokenizer and text encoder that process the text prompt</li> <li>The UNet itself</li> <li>The scheduler, and exploring different schedulers</li></ul></li> <li>Replicating the sampling loop with the pipeline components</li> <li>Editing existing images with the Img2Img pipeline</li> <li>Using inpainting and Depth2Img pipelines</li>",yt,P,Ka='❓If you have any questions, please post them on the <code>#diffusion-models-class</code> channel on the Hugging Face Discord server. If you haven’t signed up yet, you can do so here: <a href="https://huggingface.co/join/discord" rel="nofollow">https://huggingface.co/join/discord</a>',xt,H,Mt,S,Pt,w,Ht,q,St,d,wt,W,qt,m,Ra='Let’s load a Stable Diffusion pipeline and see what it can do. There are multiple different versions of Stable Diffusion, with the latest at the time of writing being version 2.1. If you’d like to explore an older version, simply replace the model ID with the appropriate model (for example, you could try “CompVis/stable-diffusion-v1-4” or pick a model from the <a href="https://huggingface.co/sd-dreambooth-library" rel="nofollow">dreambooth concepts library</a>).',dt,G,Wt,T,ua="If you’re running out of GPU memory, there are some things you can do to reduce the RAM usage:",mt,g,Fa="<li><p>Load the FP16 version (not supported on all systems). With this you may also need to convert tensors to torch.float16 when experimenting with individual components of the pipeline:</p> <p><code>pipe = StableDiffusionPipeline.from_pretrained(model_id, revision=&quot;fp16&quot;, torch_dtype=torch.float16).to(device)</code></p></li> <li><p>Enable attention slicing. This reduces GPU memory usage at the cost of a small reduction in speed:</p> <p><code>pipe.enable_attention_slicing()</code></p></li> <li><p>Reduce the size of the images you’re generating</p></li>",Gt,O,Va="Once the pipeline is loaded, we can generate an image based on a prompt with the following code:",Tt,z,gt,it,ka,Ot,B,ya="<strong>Exercise:</strong> Spend some time playing with the cell above, using your own prompts and tweaking settings to see how they affect the output. Use a different random seed or remove the <code>generator</code> argument to get different results each time.",zt,J,xa="Key arguments to tweak:",Bt,I,Ma="<li>Width and height specify the size of the generated image. They must be divisible by <strong>8</strong> for the VAE to work (which we’ll see in a future section).</li> <li>The number of steps influences the generation quality. The default (50) works well, but in some cases you can get away with as few as 20 steps which is handy for experimentation.</li> <li>The negative prompt is used during the classifier-free guidance process, and can be a useful way to add additional control. You can leave it out, but many users find it useful to list some undesirable descriptions in the negative prompt as shown above.</li> <li>The <code>guidance_scale</code> argument determines how strong the classifier-free guidance (CFG) is. Higher scales push the generated images to better match the prompt, but if the scale is too high the results can become over-saturated and unpleasant.</li>",Jt,b,Pa='If you’re looking for prompt inspiration, the <a href="https://stability.ai/sdv2-prompt-book" rel="nofollow">Stable Diffusion Prompt Book</a> is a good place to start.',It,N,Ha="You can see the effect of increasing the guidance scale in the following cell:",bt,f,Nt,jt,Sa,ft,X,wa="Tweak the values above to try different scales and prompts. Interpretation is subjective of course, but to my eye anything in the 8-12 range produces better results than values below or above this range.",Xt,Z,Zt,D,qa="The <code>StableDiffusionPipeline</code> we’re using is a little more complex than the <code>DDPMPipeline</code> we’ve explored in the previous units. In addition to the UNet and the scheduler, there are a number of other components included in the pipeline:",Dt,Y,Yt,C,da=`['vae', 'text_encoder', 'tokenizer', 'unet', 'scheduler', 'safety_checker', 'feature_extractor']
`,Ct,h,Wa="To better understand how the pipeline works, let’s briefly see each component in action individually and then put them all together to replicate the functionality of the pipeline for ourselves.",ht,Q,Qt,v,ma='<img src="data:image/png;base64,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" alt="vae_diagram.png"/>',vt,L,Ga="The VAE (variational autoencoder) is a type of model that can encode its input into a compressed representation and then decode this ‘latent’ representation back into something close to the original input. When generating images with Stable Diffusion, we first <strong>generate the latents</strong> by applying the diffusion process in the ‘latent space’ of the VAE, and then <strong>decode them at the end</strong> to view the resulting image.",Lt,E,Ta="Here is some code that takes an input image, encodes it to a latent representation and then decodes it again using the VAE:",Et,$,$t,_,ga=`Input images shape: torch.Size([1, 3, 512, 512])
Encoded latents shape: torch.Size([1, 4, 64, 64])
Decoded images shape: torch.Size([1, 3, 512, 512])
`,_t,AA,Oa="As you can see, the 512x512 image is compressed to a 64x64 latent representation (with four channels). This 8x reduction in each spatial dimension is the reason the specified width and height need to be multiples of 8.",Ae,tA,za="Working with these information-rich 4x64x64 latents is more efficient than working with massive 512px images, allowing for faster diffusion models that take less resources to train and use. The VAE decoding process is not perfect, but it is good enough that the small quality tradeoff is generally worth it.",te,eA,Ba="NB: The code example above includes the scaling factor of 0.18215 required to match the processing used during SD’s training.",ee,aA,ae,nA,Ja='<img src="data:image/png;base64,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" alt="text_encoder.png"/>',ne,UA,Ia="The goal of the text encoder is to turn an input string (the prompt) into a numerical representation that can be fed to the UNet as conditioning. The text is first turned into a series of tokens using the pipeline’s tokenizer. The text encoder has a vocabulary of about 50k tokens - any word isn’t in this vocabulary is split into smaller sub-words. The tokens are then fed through the text encoder model itself - a transformer model that was originally trained as the text encoder for CLIP. The hope is that this pretrained transformer model has learnt rich representations of text that will be useful for the diffusion task too.",Ue,iA,ba="Let’s test out this process by encoding an example prompt, first manually tokenizing and feeding it through the text encoder and then using the pipelines <code>encode_prompt</code> method to show the full process including padding/truncating the length to the maximum length of 77 tokens:",ie,jA,je,lA,Na=`Input ID -> decoded token
49406 -> <|startoftext|>
320 -> a
3086 -> painting
539 -> of
320 -> a
4062 -> floo
1059 -> ble
49407 -> <|endoftext|>
Text embeddings shape: torch.Size([1, 8, 1024])
`,le,pA,pe,oA,fa="These text embeddings (the so-called ‘hidden states’ of the last transformer block in the text encoder model) will be fed to the UNet as an additional argument to the <code>forward</code> method, which we’ll see in the next section.",oe,cA,ce,sA,Xa='<img src="data:image/png;base64,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" alt="unet.png"/>',se,rA,Za="The UNet takes a noisy input and predicts the noise, just like the UNets we’ve seen in previous units. Unlike those previous examples, the input is not an image but is instead a latent representation of an image. And in addition to the timestep conditioning, this UNet also takes in the text embeddings of the prompt as an additional input. Here it is making predictions on some dummy data:",re,KA,Ke,RA,Da=`UNet output shape: torch.Size([1, 4, 64, 64])
`,Re,uA,ue,FA,Ya="The scheduler stores the noise schedule and manages updating the noisy sample based on the model predictions. The default scheduler is a <code>PNDMScheduler</code>, but you can use others (such as <code>LMSDiscreteScheduler</code>) as long as they are initialized with the same configuration.",Fe,VA,Ca="We can plot the noise schedule to see the noise level (based on $\\bar{\\alpha}$) over time:",Ve,kA,ke,lt,ha,ye,yA,Qa="If you want to try out a different scheduler, you can swap in a new one as follows:",xe,xA,Me,MA,va=`Scheduler config: LMSDiscreteScheduler &#123;
  "_class_name": "LMSDiscreteScheduler",
  "_diffusers_version": "0.11.1",
  "beta_end": 0.012,
  "beta_schedule": "scaled_linear",
  "beta_start": 0.00085,
  "clip_sample": false,
  "num_train_timesteps": 1000,
  "prediction_type": "epsilon",
  "set_alpha_to_one": false,
  "skip_prk_steps": true,
  "steps_offset": 1,
  "trained_betas": null
}
`,Pe,PA,La='You can read more on using different schedulers <a href="https://huggingface.co/docs/diffusers/using-diffusers/schedulers" rel="nofollow">here</a>.',He,HA,Se,SA,Ea="Now that we’ve seen all these components in action, we can put them together to replicate the functionality of the pipeline:",we,wA,qe,pt,$a,de,qA,_a='In most cases it will be easier to use the existing pipelines, but having this hackable sampling loop can be useful for understanding and modifying how each component works. If you’d like to see this code and all the different components explored and modified in depth, check out the ‘Stable Diffusion Deep Dive’ <a href="https://github.com/fastai/diffusion-nbs/blob/master/Stable%20Diffusion%20Deep%20Dive.ipynb" rel="nofollow">notebook</a> and <a href="https://m.youtube.com/watch?v=0_BBRNYInx8" rel="nofollow">video</a> for a more thorough exploration.',We,dA,me,WA,An="So what can we do besides just generating images from a prompt? Quite a lot! In this section we’ll demonstrate a few cool pipelines to give you a taste of some of the other tasks that Stable Diffusion can be used for. Several of these require downloading new models, so if you’re in a hurry you can skim through this section just looking at the existing outputs rather than downloading and running all of the models yourself.",Ge,mA,Te,GA,tn="In the examples so far we’ve generated images completely from scratch by starting from random latents and applying the full diffusion sampling loop. But we don’t have to start from scratch. The Img2Img pipeline first encodes an existing image into a set of latents, then adds some noise to the latents and uses that as the starting point. The amount of noise added and the number of denoising steps applied determine the ‘strength’ of the img2img process. Adding just a small amount of noise (low strength) will result in very little change, while adding the maximum amount of noise and running the full denoising process will give an image that hardly resembles the input apart from some similarities on overall structure.",ge,TA,en="This pipeline requires no special models, and so as long as the model ID is the same as our text-to-image example above no new files will need to be downloaded.",Oe,gA,ze,OA,an="In the ‘Setup’ section we loaded an example <code>init_image</code> to use for this demo, but you can replace it with your own image if you’d prefer. Here’s the pipeline in  action:",Be,zA,Je,ot,nn,Ie,BA,Un="<strong>Exercise:</strong> Experiment with this pipeline. Try your own images, or play with different strengths and prompts. You can use many of the same arguments as the text-to-image pipeline, so feel free to try different sizes, number of steps etc.",be,JA,Ne,IA,jn='<img src="inpaint_w_border.jpg" alt="inpainting unet"/>',fe,bA,ln="What if we wanted to keep some of the input image unchanged but generate something new in other parts? This is called ‘inpainting’. While it can be done with the same model as the previous demos (via the <code>StableDiffusionInpaintPipelineLegacy</code>) we can get better results by using a custom fine-tuned version of Stable Diffusion that takes a masked image and the mask itself as additional conditioning. The mask image should be the same shape as the input image, with white in the areas to be replaces and black in the areas to be kept unchanged. Here’s how we load such a pipeline and apply it to the example image and mask loaded in the ‘Setup’ section:",Xe,NA,Ze,fA,De,ct,pn,Ye,XA,on='This can be especially powerful when combined with another model to automatically generate masks. For example, <a href="https://huggingface.co/spaces/nielsr/text-based-inpainting" rel="nofollow">this demo space</a> uses a model called CLIPSeg to mask out an object to be replaced based on a text description.',Ce,ZA,he,DA,cn="Exploring different pipelines and model variants can fill up your disk space. You can see which models are currently downloaded with:",Qe,YA,ve,CA,sn=`models--CompVis--stable-diffusion-v1-4
models--ddpm-bedroom-256
models--google--ddpm-bedroom-256
models--google--ddpm-celebahq-256
models--runwayml--stable-diffusion-inpainting
models--stabilityai--stable-diffusion-2-1-base
`,Le,hA,rn='Check out <a href="https://huggingface.co/docs/huggingface_hub/main/en/how-to-cache" rel="nofollow">the docs on caching</a> to see how to view and manage your cache effectively.',Ee,QA,$e,vA,Kn='<img src="https://camo.githubusercontent.com/5a7cd804dff6283157144f1d54b99a637195fcd25f10c7e9ab7952322d746269/68747470733a2f2f68756767696e67666163652e636f2f73746162696c69747961692f737461626c652d646966667573696f6e2d322d64657074682f7265736f6c76652f6d61696e2f646570746832696d6167652e706e67" alt="depth to image examples"/> <em>Input image, depth image and generated examples (image source: StabilityAI)</em>',_e,LA,Rn="Img2Img is great, but sometimes we want to create a new image with the composition of the original but completely different colours or textures. It can be difficult to find an Img2Img strength that preserves what we’d like of the layout without also keeping the input colors.",Aa,EA,un="Time for another fine-tuned model! This one takes in depth information as additional conditioning when generating. The pipeline uses a depth estimation model to create a depth map, which is then fed to the fine-tuned UNet when generating images to (hopefully) preserve the depth and structure of the initial image while filling in completely new content.",ta,$A,ea,_A,aa,st,Fn,na,At,Vn='Note how the output compares to the img2img example - here there is much more color variation, but the overall structure is still faithful to the original. This is not ideal in this case since the man has been given some extremely weird anatomy to match the dog shape, but in some cases this is extraordinarily useful. For an example of the ‘killer app’ for this approach, check out <a href="https://twitter.com/CarsonKatri/status/1600248599254007810?s=20&amp;t=BlzSK26sfqi2336SN0gKpQ" rel="nofollow">this tweet</a> showing the depth model being used to texture a 3D scene!',Ua,tt,ia,et,kn="Hopefully, this has given you a taste of the many things that Stable Diffusion can do! Once you get tired of playing with the examples in this notebook, check out the <strong>DreamBooth hackathon</strong> notebook to see how to fine-tune your own version of Stable Diffusion which can be used with the text-to-image or img2img pipelines we’ve seen here.",ja,at,yn="If you’re curious to dig deeper into how the different components work, then check out the <strong>Stable Diffusion Deep Dive</strong> notebook which goes into much more detail and shows some additional tricks we can do.",la,nt,xn="Be sure to share your creations with us and the community!",pa,Kt,oa;return k=new mn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/diffusion-models-class/blob/main/unit3/01_stable_diffusion_introduction.ipynb"}]}}),y=new u({props:{title:"Introduction",local:"introduction",headingTag:"h1"}}),H=new u({props:{title:"Setup",local:"setup",headingTag:"h1"}}),S=new R({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1VcSUyMGRpZmZ1c2VycyUyMGZ0ZnklMjBhY2NlbGVyYXRl",highlighted:"%pip install -Uq diffusers ftfy accelerate",wrap:!1}}),w=new R({props:{code:"JTIzJTIwSW5zdGFsbGluZyUyMHRyYW5zZm9ybWVycyUyMGZyb20lMjBzb3VyY2UlMjBmb3IlMjBub3clMjBzaW5jZSUyMHdlJTIwbmVlZCUyMHRoZSUyMGxhdGVzdCUyMHZlcnNpb24lMjBmb3IlMjBEZXB0aDJJbWclMEElMjVwaXAlMjBpbnN0YWxsJTIwLVVxJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnM=",highlighted:`<span class="hljs-comment"># Installing transformers from source for now since we need the latest version for Depth2Img</span>
%pip install -Uq git+https://github.com/huggingface/transformers`,wrap:!1}}),q=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwbWF0cGxvdGxpYiUyMGltcG9ydCUyMHB5cGxvdCUyMGFzJTIwcGx0JTBBJTBBJTIzJTIwV2UnbGwlMjBiZSUyMGV4cGxvcmluZyUyMGElMjBudW1iZXIlMjBvZiUyMHBpcGVsaW5lcyUyMHRvZGF5ISUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25JbnBhaW50UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25EZXB0aDJJbWdQaXBlbGluZSUyQyUwQSklMEElMEElMEElMjMlMjBXZSdsbCUyMHVzZSUyMGElMjBjb3VwbGUlMjBvZiUyMGRlbW8lMjBpbWFnZXMlMjBsYXRlciUyMGluJTIwdGhlJTIwbm90ZWJvb2slMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMEltYWdlLm9wZW4oQnl0ZXNJTyhyZXNwb25zZS5jb250ZW50KSkuY29udmVydCglMjJSR0IlMjIpJTBBJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBpbWFnZXMlMjBmb3IlMjBpbnBhaW50aW5nJTIwZXhhbXBsZSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UobWFza191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> matplotlib <span class="hljs-keyword">import</span> pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-comment"># We&#x27;ll be exploring a number of pipelines today!</span>
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    StableDiffusionPipeline,
    StableDiffusionImg2ImgPipeline,
    StableDiffusionInpaintPipeline,
    StableDiffusionDepth2ImgPipeline,
)


<span class="hljs-comment"># We&#x27;ll use a couple of demo images later in the notebook</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-comment"># Download images for inpainting example</span>
img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))`,wrap:!1}}),d=new R({props:{code:"JTIzJTIwU2V0JTIwZGV2aWNlJTBBZGV2aWNlJTIwJTNEJTIwJTIybXBzJTIyJTIwaWYlMjB0b3JjaC5iYWNrZW5kcy5tcHMuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjI=",highlighted:`<span class="hljs-comment"># Set device</span>
device = <span class="hljs-string">&quot;mps&quot;</span> <span class="hljs-keyword">if</span> torch.backends.mps.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>`,wrap:!1}}),W=new u({props:{title:"Generating Images from Text",local:"generating-images-from-text",headingTag:"h1"}}),G=new R({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMHBpcGVsaW5lJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xLWJhc2UlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKS50byhkZXZpY2Up",highlighted:`<span class="hljs-comment"># Load the pipeline</span>
model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-base&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id).to(device)`,wrap:!1}}),z=new R({props:{code:"JTIzJTIwU2V0JTIwdXAlMjBhJTIwZ2VuZXJhdG9yJTIwZm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRGRldmljZSkubWFudWFsX3NlZWQoNDIpJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwcGlwZWxpbmUlMkMlMjBzaG93aW5nJTIwc29tZSUyMG9mJTIwdGhlJTIwYXZhaWxhYmxlJTIwYXJndW1lbnRzJTBBcGlwZV9vdXRwdXQlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMlBhbGV0dGUlMjBrbmlmZSUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMGF1dHVtbiUyMGNpdHlzY2FwZSUyMiUyQyUyMCUyMCUyMyUyMFdoYXQlMjB0byUyMGdlbmVyYXRlJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyT3ZlcnNhdHVyYXRlZCUyQyUyMGJsdXJyeSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMjAlMjAlMjMlMjBXaGF0JTIwTk9UJTIwdG8lMjBnZW5lcmF0ZSUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDQ4MCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENjQwJTJDJTIwJTIwJTIzJTIwU3BlY2lmeSUyMHRoZSUyMGltYWdlJTIwc2l6ZSUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOCUyQyUyMCUyMCUyMyUyMEhvdyUyMHN0cm9uZ2x5JTIwdG8lMjBmb2xsb3clMjB0aGUlMjBwcm9tcHQlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzUlMkMlMjAlMjAlMjMlMjBIb3clMjBtYW55JTIwc3RlcHMlMjB0byUyMHRha2UlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjAlMjAlMjMlMjBGaXhlZCUyMHJhbmRvbSUyMHNlZWQlMEEpJTBBJTBBJTIzJTIwVmlldyUyMHRoZSUyMHJlc3VsdGluZyUyMGltYWdlJTBBcGlwZV9vdXRwdXQuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set up a generator for reproducibility</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the pipeline, showing some of the available arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_output = pipe(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;Palette knife painting of an autumn cityscape&quot;</span>,  <span class="hljs-comment"># What to generate</span>
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;Oversaturated, blurry, low quality&quot;</span>,  <span class="hljs-comment"># What NOT to generate</span>
<span class="hljs-meta">... </span>    height=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">640</span>,  <span class="hljs-comment"># Specify the image size</span>
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">8</span>,  <span class="hljs-comment"># How strongly to follow the prompt</span>
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">35</span>,  <span class="hljs-comment"># How many steps to take</span>
<span class="hljs-meta">... </span>    generator=generator,  <span class="hljs-comment"># Fixed random seed</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View the resulting image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_output.images[<span class="hljs-number">0</span>]`,wrap:!1}}),f=new R({props:{code:"JTIzJTIwJTQwbWFya2Rvd24lMjBjb21wYXJpbmclMjBndWlkYW5jZSUyMHNjYWxlcyUzQSUwQWNmZ19zY2FsZXMlMjAlM0QlMjAlNUIxLjElMkMlMjA4JTJDJTIwMTIlNUQlMjAlMjAlMjMlMjAlNDBwYXJhbSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjb2xsaWUlMjB3aXRoJTIwYSUyMHBpbmslMjBoYXQlMjIlMjAlMjAlMjMlMjAlNDBwYXJhbSUwQWZpZyUyQyUyMGF4cyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwbGVuKGNmZ19zY2FsZXMpJTJDJTIwZmlnc2l6ZSUzRCgxNiUyQyUyMDUpKSUwQWZvciUyMGklMkMlMjBheCUyMGluJTIwZW51bWVyYXRlKGF4cyklM0ElMEElMjAlMjAlMjAlMjBpbSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGVpZ2h0JTNENDgwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2lkdGglM0Q0ODAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRGNmZ19zY2FsZXMlNUJpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDM1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRGRldmljZSkubWFudWFsX3NlZWQoNDIpJTJDJTBBJTIwJTIwJTIwJTIwKS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwYXguaW1zaG93KGltKSUwQSUyMCUyMCUyMCUyMGF4LnNldF90aXRsZShmJTIyQ0ZHJTIwU2NhbGUlMjAlN0JjZmdfc2NhbGVzJTVCaSU1RCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># @markdown comparing guidance scales:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cfg_scales = [<span class="hljs-number">1.1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">12</span>]  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A collie with a pink hat&quot;</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(cfg_scales), figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">5</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, ax <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(axs):
<span class="hljs-meta">... </span>    im = pipe(
<span class="hljs-meta">... </span>        prompt,
<span class="hljs-meta">... </span>        height=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>        width=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>        guidance_scale=cfg_scales[i],
<span class="hljs-meta">... </span>        num_inference_steps=<span class="hljs-number">35</span>,
<span class="hljs-meta">... </span>        generator=torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>),
<span class="hljs-meta">... </span>    ).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    ax.imshow(im)
<span class="hljs-meta">... </span>    ax.set_title(<span class="hljs-string">f&quot;CFG Scale <span class="hljs-subst">{cfg_scales[i]}</span>&quot;</span>)`,wrap:!1}}),Z=new u({props:{title:"Pipeline Components",local:"pipeline-components",headingTag:"h1"}}),Y=new R({props:{code:"cHJpbnQobGlzdChwaXBlLmNvbXBvbmVudHMua2V5cygpKSklMjAlMjAlMjMlMjBMaXN0JTIwY29tcG9uZW50cw==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(pipe.components.keys()))  <span class="hljs-comment"># List components</span>',wrap:!1}}),Q=new u({props:{title:"The VAE",local:"the-vae",headingTag:"h3"}}),$=new R({props:{code:"JTIzJTIwQ3JlYXRlJTIwc29tZSUyMGZha2UlMjBkYXRhJTIwKGElMjByYW5kb20lMjBpbWFnZSUyQyUyMHJhbmdlJTIwKC0xJTJDJTIwMSkpJTBBaW1hZ2VzJTIwJTNEJTIwdG9yY2gucmFuZCgxJTJDJTIwMyUyQyUyMDUxMiUyQyUyMDUxMikudG8oZGV2aWNlKSUyMColMjAyJTIwLSUyMDElMEFwcmludCglMjJJbnB1dCUyMGltYWdlcyUyMHNoYXBlJTNBJTIyJTJDJTIwaW1hZ2VzLnNoYXBlKSUwQSUwQSUyMyUyMEVuY29kZSUyMHRvJTIwbGF0ZW50JTIwc3BhY2UlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbGF0ZW50cyUyMCUzRCUyMDAuMTgyMTUlMjAqJTIwcGlwZS52YWUuZW5jb2RlKGltYWdlcykubGF0ZW50X2Rpc3QubWVhbiUwQXByaW50KCUyMkVuY29kZWQlMjBsYXRlbnRzJTIwc2hhcGUlM0ElMjIlMkMlMjBsYXRlbnRzLnNoYXBlKSUwQSUwQSUyMyUyMERlY29kZSUyMGFnYWluJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGRlY29kZWRfaW1hZ2VzJTIwJTNEJTIwcGlwZS52YWUuZGVjb2RlKGxhdGVudHMlMjAlMkYlMjAwLjE4MjE1KS5zYW1wbGUlMEFwcmludCglMjJEZWNvZGVkJTIwaW1hZ2VzJTIwc2hhcGUlM0ElMjIlMkMlMjBkZWNvZGVkX2ltYWdlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create some fake data (a random image, range (-1, 1))</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = torch.rand(<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>).to(device) * <span class="hljs-number">2</span> - <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input images shape:&quot;</span>, images.shape)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Encode to latent space</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    latents = <span class="hljs-number">0.18215</span> * pipe.vae.encode(images).latent_dist.mean
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Encoded latents shape:&quot;</span>, latents.shape)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Decode again</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    decoded_images = pipe.vae.decode(latents / <span class="hljs-number">0.18215</span>).sample
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Decoded images shape:&quot;</span>, decoded_images.shape)`,wrap:!1}}),aA=new u({props:{title:"The Tokenizer and Text Encoder",local:"the-tokenizer-and-text-encoder",headingTag:"h3"}}),jA=new R({props:{code:"JTIzJTIwVG9rZW5pemluZyUyMGFuZCUyMGVuY29kaW5nJTIwYW4lMjBleGFtcGxlJTIwcHJvbXB0JTIwbWFudWFsbHklMEElMEElMjMlMjBUb2tlbml6ZSUwQWlucHV0X2lkcyUyMCUzRCUyMHBpcGUudG9rZW5pemVyKCU1QiUyMkElMjBwYWludGluZyUyMG9mJTIwYSUyMGZsb29ibGUlMjIlNUQpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBcHJpbnQoJTIySW5wdXQlMjBJRCUyMC0lM0UlMjBkZWNvZGVkJTIwdG9rZW4lMjIpJTBBZm9yJTIwaW5wdXRfaWQlMjBpbiUyMGlucHV0X2lkcyU1QjAlNUQlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTdCaW5wdXRfaWQlN0QlMjAtJTNFJTIwJTdCcGlwZS50b2tlbml6ZXIuZGVjb2RlKGlucHV0X2lkKSU3RCUyMiklMEElMEElMjMlMjBGZWVkJTIwdGhyb3VnaCUyMENMSVAlMjB0ZXh0JTIwZW5jb2RlciUwQWlucHV0X2lkcyUyMCUzRCUyMHRvcmNoLnRlbnNvcihpbnB1dF9pZHMpLnRvKGRldmljZSklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwcGlwZS50ZXh0X2VuY29kZXIoaW5wdXRfaWRzKSU1QiUyMmxhc3RfaGlkZGVuX3N0YXRlJTIyJTVEJTBBcHJpbnQoJTIyVGV4dCUyMGVtYmVkZGluZ3MlMjBzaGFwZSUzQSUyMiUyQyUyMHRleHRfZW1iZWRkaW5ncy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tokenizing and encoding an example prompt manually</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tokenize</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = pipe.tokenizer([<span class="hljs-string">&quot;A painting of a flooble&quot;</span>])[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input ID -&gt; decoded token&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> input_id <span class="hljs-keyword">in</span> input_ids[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{input_id}</span> -&gt; <span class="hljs-subst">{pipe.tokenizer.decode(input_id)}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Feed through CLIP text encoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor(input_ids).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    text_embeddings = pipe.text_encoder(input_ids)[<span class="hljs-string">&quot;last_hidden_state&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Text embeddings shape:&quot;</span>, text_embeddings.shape)`,wrap:!1}}),pA=new R({props:{code:"JTIzJTIwR2V0JTIwdGhlJTIwZmluYWwlMjB0ZXh0JTIwZW1iZWRkaW5ncyUyMHVzaW5nJTIwdGhlJTIwcGlwZWxpbmUncyUyMGVuY29kZV9wcm9tcHQlMjBmdW5jdGlvbiUwQXRleHRfZW1iZWRkaW5ncyUyMCUzRCUyMHBpcGUuX2VuY29kZV9wcm9tcHQoJTIyQSUyMHBhaW50aW5nJTIwb2YlMjBhJTIwZmxvb2JsZSUyMiUyQyUyMGRldmljZSUyQyUyMDElMkMlMjBGYWxzZSUyQyUyMCUyMiUyMiklMEF0ZXh0X2VtYmVkZGluZ3Muc2hhcGU=",highlighted:`<span class="hljs-comment"># Get the final text embeddings using the pipeline&#x27;s encode_prompt function</span>
text_embeddings = pipe._encode_prompt(<span class="hljs-string">&quot;A painting of a flooble&quot;</span>, device, <span class="hljs-number">1</span>, <span class="hljs-literal">False</span>, <span class="hljs-string">&quot;&quot;</span>)
text_embeddings.shape`,wrap:!1}}),cA=new u({props:{title:"The UNet",local:"the-unet",headingTag:"h3"}}),KA=new R({props:{code:"JTIzJTIwRHVtbXklMjBpbnB1dHMlMEF0aW1lc3RlcCUyMCUzRCUyMHBpcGUuc2NoZWR1bGVyLnRpbWVzdGVwcyU1QjAlNUQlMEFsYXRlbnRzJTIwJTNEJTIwdG9yY2gucmFuZG4oMSUyQyUyMDQlMkMlMjA2NCUyQyUyMDY0KS50byhkZXZpY2UpJTBBdGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gucmFuZG4oMSUyQyUyMDc3JTJDJTIwMTAyNCkudG8oZGV2aWNlKSUwQSUwQSUyMyUyME1vZGVsJTIwcHJlZGljdGlvbiUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjB1bmV0X291dHB1dCUyMCUzRCUyMHBpcGUudW5ldChsYXRlbnRzJTJDJTIwdGltZXN0ZXAlMkMlMjB0ZXh0X2VtYmVkZGluZ3MpLnNhbXBsZSUwQXByaW50KCUyMlVOZXQlMjBvdXRwdXQlMjBzaGFwZSUzQSUyMiUyQyUyMHVuZXRfb3V0cHV0LnNoYXBlKSUyMCUyMCUyMyUyMFNhbWUlMjBzaGFwZSUyMGFzJTIwdGhlJTIwaW5wdXQlMjBsYXRlbnRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Dummy inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>timestep = pipe.scheduler.timesteps[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>latents = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_embeddings = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">77</span>, <span class="hljs-number">1024</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    unet_output = pipe.unet(latents, timestep, text_embeddings).sample
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;UNet output shape:&quot;</span>, unet_output.shape)  <span class="hljs-comment"># Same shape as the input latents</span>`,wrap:!1}}),uA=new u({props:{title:"The Scheduler",local:"the-scheduler",headingTag:"h3"}}),kA=new R({props:{code:"cGx0LnBsb3QocGlwZS5zY2hlZHVsZXIuYWxwaGFzX2N1bXByb2QlMkMlMjBsYWJlbCUzRHIlMjIlMjQlNUNiYXIlN0IlNUNhbHBoYSU3RCUyNCUyMiklMEFwbHQueGxhYmVsKCUyMlRpbWVzdGVwJTIwKGhpZ2glMjBub2lzZSUyMHRvJTIwbG93JTIwbm9pc2UlMjAtJTNFKSUyMiklMEFwbHQudGl0bGUoJTIyTm9pc2UlMjBzY2hlZHVsZSUyMiklMEFwbHQubGVnZW5kKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>plt.plot(pipe.scheduler.alphas_cumprod, label=<span class="hljs-string">r&quot;$\\bar{\\alpha}$&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.xlabel(<span class="hljs-string">&quot;Timestep (high noise to low noise -&gt;)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.title(<span class="hljs-string">&quot;Noise schedule&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.legend()`,wrap:!1}}),xA=new R({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyJTBBJTBBJTIzJTIwUmVwbGFjZSUyMHRoZSUyMHNjaGVkdWxlciUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTE1TRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQSUyMyUyMFByaW50JTIwdGhlJTIwY29uZmlnJTBBcHJpbnQoJTIyU2NoZWR1bGVyJTIwY29uZmlnJTNBJTIyJTJDJTIwcGlwZS5zY2hlZHVsZXIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwd2l0aCUyMHRoaXMlMjBuZXclMjBzY2hlZHVsZXIlMEFwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMlBhbGV0dGUlMjBrbmlmZSUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMHdpbnRlciUyMGNpdHlzY2FwZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDQ4MCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENDgwJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRGRldmljZSkubWFudWFsX3NlZWQoNDIpJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Replace the scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = LMSDiscreteScheduler.from_config(pipe.scheduler.config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print the config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Scheduler config:&quot;</span>, pipe.scheduler)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate an image with this new scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;Palette knife painting of an winter cityscape&quot;</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>    generator=torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>),
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),HA=new u({props:{title:"A DIY Sampling Loop",local:"a-diy-sampling-loop",headingTag:"h3"}}),wA=new R({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_scale = <span class="hljs-number">8</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">30</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Beautiful picture of a wave breaking&quot;</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;zoomed in, blurry, oversaturated, warped&quot;</span>  <span class="hljs-comment"># @param</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Encode the prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_embeddings = pipe._encode_prompt(prompt, device, <span class="hljs-number">1</span>, <span class="hljs-literal">True</span>, negative_prompt)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create our random starting point</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=device, generator=generator)
<span class="hljs-meta">&gt;&gt;&gt; </span>latents *= pipe.scheduler.init_noise_sigma

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare the scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler.set_timesteps(num_inference_steps, device=device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loop through the sampling timesteps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pipe.scheduler.timesteps):

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Expand the latents if we are doing classifier free guidance</span>
<span class="hljs-meta">... </span>    latent_model_input = torch.cat([latents] * <span class="hljs-number">2</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Apply any scaling required by the scheduler</span>
<span class="hljs-meta">... </span>    latent_model_input = pipe.scheduler.scale_model_input(latent_model_input, t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Predict the noise residual with the UNet</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = pipe.unet(latent_model_input, t, encoder_hidden_states=text_embeddings).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Perform guidance</span>
<span class="hljs-meta">... </span>    noise_pred_uncond, noise_pred_text = noise_pred.chunk(<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    noise_pred = noise_pred_uncond + guidance_scale * (noise_pred_text - noise_pred_uncond)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Compute the previous noisy sample x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    latents = pipe.scheduler.step(noise_pred, t, latents).prev_sample

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Decode the resulting latents into an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    image = pipe.decode_latents(latents.detach())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.numpy_to_pil(image)[<span class="hljs-number">0</span>]`,wrap:!1}}),dA=new u({props:{title:"Additonal Pipelines",local:"additonal-pipelines",headingTag:"h1"}}),mA=new u({props:{title:"Img2Img",local:"img2img",headingTag:"h2"}}),gA=new R({props:{code:"JTIzJTIwTG9hZGluZyUyMGFuJTIwSW1nMkltZyUyMHBpcGVsaW5lJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xLWJhc2UlMjIlMEFpbWcyaW1nX3BpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKS50byhkZXZpY2Up",highlighted:`<span class="hljs-comment"># Loading an Img2Img pipeline</span>
model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-base&quot;</span>
img2img_pipe = StableDiffusionImg2ImgPipeline.from_pretrained(model_id).to(device)`,wrap:!1}}),zA=new R({props:{code:"JTIzJTIwQXBwbHklMjBJbWcySW1nJTBBcmVzdWx0X2ltYWdlJTIwJTNEJTIwaW1nMmltZ19waXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkFuJTIwb2lsJTIwcGFpbnRpbmclMjBvZiUyMGElMjBtYW4lMjBvbiUyMGElMjBiZW5jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMCUyMCUyMyUyMFRoZSUyMHN0YXJ0aW5nJTIwaW1hZ2UlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuNiUyQyUyMCUyMCUyMyUyMDAlMjBmb3IlMjBubyUyMGNoYW5nZSUyQyUyMDEuMCUyMGZvciUyMG1heCUyMHN0cmVuZ3RoJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBJTIzJTIwVmlldyUyMHRoZSUyMHJlc3VsdCUwQWZpZyUyQyUyMGF4cyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwMiUyQyUyMGZpZ3NpemUlM0QoMTIlMkMlMjA1KSklMEFheHMlNUIwJTVELmltc2hvdyhpbml0X2ltYWdlKSUwQWF4cyU1QjAlNUQuc2V0X3RpdGxlKCUyMklucHV0JTIwSW1hZ2UlMjIpJTBBYXhzJTVCMSU1RC5pbXNob3cocmVzdWx0X2ltYWdlKSUwQWF4cyU1QjElNUQuc2V0X3RpdGxlKCUyMlJlc3VsdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply Img2Img</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result_image = img2img_pipe(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;An oil painting of a man on a bench&quot;</span>,
<span class="hljs-meta">... </span>    image=init_image,  <span class="hljs-comment"># The starting image</span>
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.6</span>,  <span class="hljs-comment"># 0 for no change, 1.0 for max strength</span>
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View the result</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">5</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].imshow(init_image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&quot;Input Image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].imshow(result_image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].set_title(<span class="hljs-string">&quot;Result&quot;</span>)`,wrap:!1}}),JA=new u({props:{title:"In-Painting",local:"in-painting",headingTag:"h2"}}),NA=new R({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMGlucGFpbnRpbmclMjBwaXBlbGluZSUyMChyZXF1aXJlcyUyMGElMjBzdWl0YWJsZSUyMGlucGFpbnRpbmclMjBtb2RlbCklMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byhkZXZpY2Up",highlighted:`<span class="hljs-comment"># Load the inpainting pipeline (requires a suitable inpainting model)</span>
pipe = StableDiffusionInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>)
pipe = pipe.to(device)`,wrap:!1}}),fA=new R({props:{code:"JTIzJTIwSW5wYWludCUyMHdpdGglMjBhJTIwcHJvbXB0JTIwZm9yJTIwd2hhdCUyMHdlJTIwd2FudCUyMHRoZSUyMHJlc3VsdCUyMHRvJTIwbG9vayUyMGxpa2UlMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwc21hbGwlMjByb2JvdCUyQyUyMGhpZ2glMjByZXNvbHV0aW9uJTJDJTIwc2l0dGluZyUyMG9uJTIwYSUyMHBhcmslMjBiZW5jaCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQSUwQSUyMyUyMFZpZXclMjB0aGUlMjByZXN1bHQlMEFmaWclMkMlMjBheHMlMjAlM0QlMjBwbHQuc3VicGxvdHMoMSUyQyUyMDMlMkMlMjBmaWdzaXplJTNEKDE2JTJDJTIwNSkpJTBBYXhzJTVCMCU1RC5pbXNob3coaW5pdF9pbWFnZSklMEFheHMlNUIwJTVELnNldF90aXRsZSglMjJJbnB1dCUyMEltYWdlJTIyKSUwQWF4cyU1QjElNUQuaW1zaG93KG1hc2tfaW1hZ2UpJTBBYXhzJTVCMSU1RC5zZXRfdGl0bGUoJTIyTWFzayUyMiklMEFheHMlNUIyJTVELmltc2hvdyhpbWFnZSklMEFheHMlNUIyJTVELnNldF90aXRsZSglMjJSZXN1bHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Inpaint with a prompt for what we want the result to look like</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A small robot, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View the result</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">5</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].imshow(init_image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&quot;Input Image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].imshow(mask_image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].set_title(<span class="hljs-string">&quot;Mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">2</span>].imshow(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">2</span>].set_title(<span class="hljs-string">&quot;Result&quot;</span>)`,wrap:!1}}),ZA=new u({props:{title:"Aside: Managing Your Model Cache",local:"aside-managing-your-model-cache",headingTag:"h3"}}),YA=new R({props:{code:"IWxzJTIwfiUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGaHViJTJGJTIwJTIzJTIwTGlzdCUyMHRoZSUyMGNvbnRlbnRzJTIwb2YlMjB0aGUlMjBjYWNoZSUyMGRpcmVjdG9yeQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!ls ~/.cache/huggingface/hub/ <span class="hljs-comment"># List the contents of the cache directory</span>',wrap:!1}}),QA=new u({props:{title:"Depth2Image",local:"depth2image",headingTag:"h2"}}),$A=new R({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMERlcHRoMkltZyUyMHBpcGVsaW5lJTIwKHJlcXVpcmVzJTIwYSUyMHN1aXRhYmxlJTIwbW9kZWwpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkRlcHRoMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi1kZXB0aCUyMiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byhkZXZpY2Up",highlighted:`<span class="hljs-comment"># Load the Depth2Img pipeline (requires a suitable model)</span>
pipe = StableDiffusionDepth2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-depth&quot;</span>)
pipe = pipe.to(device)`,wrap:!1}}),_A=new R({props:{code:"JTIzJTIwSW5wYWludCUyMHdpdGglMjBhJTIwcHJvbXB0JTIwZm9yJTIwd2hhdCUyMHdlJTIwd2FudCUyMHRoZSUyMHJlc3VsdCUyMHRvJTIwbG9vayUyMGxpa2UlMEFwcm9tcHQlMjAlM0QlMjAlMjJBbiUyMG9pbCUyMHBhaW50aW5nJTIwb2YlMjBhJTIwbWFuJTIwb24lMjBhJTIwYmVuY2glMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBJTBBJTIzJTIwVmlldyUyMHRoZSUyMHJlc3VsdCUwQWZpZyUyQyUyMGF4cyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwMiUyQyUyMGZpZ3NpemUlM0QoMTYlMkMlMjA1KSklMEFheHMlNUIwJTVELmltc2hvdyhpbml0X2ltYWdlKSUwQWF4cyU1QjAlNUQuc2V0X3RpdGxlKCUyMklucHV0JTIwSW1hZ2UlMjIpJTBBYXhzJTVCMSU1RC5pbXNob3coaW1hZ2UpJTBBYXhzJTVCMSU1RC5zZXRfdGl0bGUoJTIyUmVzdWx0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Inpaint with a prompt for what we want the result to look like</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;An oil painting of a man on a bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View the result</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">5</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].imshow(init_image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&quot;Input Image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].imshow(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].set_title(<span class="hljs-string">&quot;Result&quot;</span>)`,wrap:!1}}),tt=new u({props:{title:"Where Next?",local:"where-next",headingTag:"h1"}}),{c(){F=i("meta"),Rt=n(),rt=i("p"),ut=n(),p(k.$$.fragment),Ft=n(),p(y.$$.fragment),Vt=n(),x=i("p"),x.textContent=sa,kt=n(),M=i("ul"),M.innerHTML=ra,yt=n(),P=i("p"),P.innerHTML=Ka,xt=n(),p(H.$$.fragment),Mt=n(),p(S.$$.fragment),Pt=n(),p(w.$$.fragment),Ht=n(),p(q.$$.fragment),St=n(),p(d.$$.fragment),wt=n(),p(W.$$.fragment),qt=n(),m=i("p"),m.innerHTML=Ra,dt=n(),p(G.$$.fragment),Wt=n(),T=i("p"),T.textContent=ua,mt=n(),g=i("ul"),g.innerHTML=Fa,Gt=n(),O=i("p"),O.textContent=Va,Tt=n(),p(z.$$.fragment),gt=n(),it=i("img"),Ot=n(),B=i("p"),B.innerHTML=ya,zt=n(),J=i("p"),J.textContent=xa,Bt=n(),I=i("ul"),I.innerHTML=Ma,Jt=n(),b=i("p"),b.innerHTML=Pa,It=n(),N=i("p"),N.textContent=Ha,bt=n(),p(f.$$.fragment),Nt=n(),jt=i("img"),ft=n(),X=i("p"),X.textContent=wa,Xt=n(),p(Z.$$.fragment),Zt=n(),D=i("p"),D.innerHTML=qa,Dt=n(),p(Y.$$.fragment),Yt=n(),C=i("pre"),C.textContent=da,Ct=n(),h=i("p"),h.textContent=Wa,ht=n(),p(Q.$$.fragment),Qt=n(),v=i("p"),v.innerHTML=ma,vt=n(),L=i("p"),L.innerHTML=Ga,Lt=n(),E=i("p"),E.textContent=Ta,Et=n(),p($.$$.fragment),$t=n(),_=i("pre"),_.textContent=ga,_t=n(),AA=i("p"),AA.textContent=Oa,Ae=n(),tA=i("p"),tA.textContent=za,te=n(),eA=i("p"),eA.textContent=Ba,ee=n(),p(aA.$$.fragment),ae=n(),nA=i("p"),nA.innerHTML=Ja,ne=n(),UA=i("p"),UA.textContent=Ia,Ue=n(),iA=i("p"),iA.innerHTML=ba,ie=n(),p(jA.$$.fragment),je=n(),lA=i("pre"),lA.textContent=Na,le=n(),p(pA.$$.fragment),pe=n(),oA=i("p"),oA.innerHTML=fa,oe=n(),p(cA.$$.fragment),ce=n(),sA=i("p"),sA.innerHTML=Xa,se=n(),rA=i("p"),rA.textContent=Za,re=n(),p(KA.$$.fragment),Ke=n(),RA=i("pre"),RA.textContent=Da,Re=n(),p(uA.$$.fragment),ue=n(),FA=i("p"),FA.innerHTML=Ya,Fe=n(),VA=i("p"),VA.textContent=Ca,Ve=n(),p(kA.$$.fragment),ke=n(),lt=i("img"),ye=n(),yA=i("p"),yA.textContent=Qa,xe=n(),p(xA.$$.fragment),Me=n(),MA=i("pre"),MA.textContent=va,Pe=n(),PA=i("p"),PA.innerHTML=La,He=n(),p(HA.$$.fragment),Se=n(),SA=i("p"),SA.textContent=Ea,we=n(),p(wA.$$.fragment),qe=n(),pt=i("img"),de=n(),qA=i("p"),qA.innerHTML=_a,We=n(),p(dA.$$.fragment),me=n(),WA=i("p"),WA.textContent=An,Ge=n(),p(mA.$$.fragment),Te=n(),GA=i("p"),GA.textContent=tn,ge=n(),TA=i("p"),TA.textContent=en,Oe=n(),p(gA.$$.fragment),ze=n(),OA=i("p"),OA.innerHTML=an,Be=n(),p(zA.$$.fragment),Je=n(),ot=i("img"),Ie=n(),BA=i("p"),BA.innerHTML=Un,be=n(),p(JA.$$.fragment),Ne=n(),IA=i("p"),IA.innerHTML=jn,fe=n(),bA=i("p"),bA.innerHTML=ln,Xe=n(),p(NA.$$.fragment),Ze=n(),p(fA.$$.fragment),De=n(),ct=i("img"),Ye=n(),XA=i("p"),XA.innerHTML=on,Ce=n(),p(ZA.$$.fragment),he=n(),DA=i("p"),DA.textContent=cn,Qe=n(),p(YA.$$.fragment),ve=n(),CA=i("pre"),CA.textContent=sn,Le=n(),hA=i("p"),hA.innerHTML=rn,Ee=n(),p(QA.$$.fragment),$e=n(),vA=i("p"),vA.innerHTML=Kn,_e=n(),LA=i("p"),LA.textContent=Rn,Aa=n(),EA=i("p"),EA.textContent=un,ta=n(),p($A.$$.fragment),ea=n(),p(_A.$$.fragment),aa=n(),st=i("img"),na=n(),At=i("p"),At.innerHTML=Vn,Ua=n(),p(tt.$$.fragment),ia=n(),et=i("p"),et.innerHTML=kn,ja=n(),at=i("p"),at.innerHTML=yn,la=n(),nt=i("p"),nt.textContent=xn,pa=n(),Kt=i("p"),this.h()},l(A){const t=dn("svelte-u9bgzb",document.head);F=j(t,"META",{name:!0,content:!0}),t.forEach(e),Rt=U(A),rt=j(A,"P",{}),Mn(rt).forEach(e),ut=U(A),o(k.$$.fragment,A),Ft=U(A),o(y.$$.fragment,A),Vt=U(A),x=j(A,"P",{"data-svelte-h":!0}),l(x)!=="svelte-13zutmb"&&(x.textContent=sa),kt=U(A),M=j(A,"UL",{"data-svelte-h":!0}),l(M)!=="svelte-qxbwwf"&&(M.innerHTML=ra),yt=U(A),P=j(A,"P",{"data-svelte-h":!0}),l(P)!=="svelte-1hvsyk8"&&(P.innerHTML=Ka),xt=U(A),o(H.$$.fragment,A),Mt=U(A),o(S.$$.fragment,A),Pt=U(A),o(w.$$.fragment,A),Ht=U(A),o(q.$$.fragment,A),St=U(A),o(d.$$.fragment,A),wt=U(A),o(W.$$.fragment,A),qt=U(A),m=j(A,"P",{"data-svelte-h":!0}),l(m)!=="svelte-1ronjoi"&&(m.innerHTML=Ra),dt=U(A),o(G.$$.fragment,A),Wt=U(A),T=j(A,"P",{"data-svelte-h":!0}),l(T)!=="svelte-1az4jf5"&&(T.textContent=ua),mt=U(A),g=j(A,"UL",{"data-svelte-h":!0}),l(g)!=="svelte-17074yf"&&(g.innerHTML=Fa),Gt=U(A),O=j(A,"P",{"data-svelte-h":!0}),l(O)!=="svelte-mm99mw"&&(O.textContent=Va),Tt=U(A),o(z.$$.fragment,A),gt=U(A),it=j(A,"IMG",{src:!0}),Ot=U(A),B=j(A,"P",{"data-svelte-h":!0}),l(B)!=="svelte-o3byjt"&&(B.innerHTML=ya),zt=U(A),J=j(A,"P",{"data-svelte-h":!0}),l(J)!=="svelte-74qmfi"&&(J.textContent=xa),Bt=U(A),I=j(A,"UL",{"data-svelte-h":!0}),l(I)!=="svelte-mvb8f2"&&(I.innerHTML=Ma),Jt=U(A),b=j(A,"P",{"data-svelte-h":!0}),l(b)!=="svelte-1818j2u"&&(b.innerHTML=Pa),It=U(A),N=j(A,"P",{"data-svelte-h":!0}),l(N)!=="svelte-g3pzoo"&&(N.textContent=Ha),bt=U(A),o(f.$$.fragment,A),Nt=U(A),jt=j(A,"IMG",{src:!0}),ft=U(A),X=j(A,"P",{"data-svelte-h":!0}),l(X)!=="svelte-k1sql4"&&(X.textContent=wa),Xt=U(A),o(Z.$$.fragment,A),Zt=U(A),D=j(A,"P",{"data-svelte-h":!0}),l(D)!=="svelte-o1245q"&&(D.innerHTML=qa),Dt=U(A),o(Y.$$.fragment,A),Yt=U(A),C=j(A,"PRE",{"data-svelte-h":!0}),l(C)!=="svelte-15nn7g7"&&(C.textContent=da),Ct=U(A),h=j(A,"P",{"data-svelte-h":!0}),l(h)!=="svelte-5jj8bj"&&(h.textContent=Wa),ht=U(A),o(Q.$$.fragment,A),Qt=U(A),v=j(A,"P",{"data-svelte-h":!0}),l(v)!=="svelte-mzckjv"&&(v.innerHTML=ma),vt=U(A),L=j(A,"P",{"data-svelte-h":!0}),l(L)!=="svelte-12e2em"&&(L.innerHTML=Ga),Lt=U(A),E=j(A,"P",{"data-svelte-h":!0}),l(E)!=="svelte-17ucvne"&&(E.textContent=Ta),Et=U(A),o($.$$.fragment,A),$t=U(A),_=j(A,"PRE",{"data-svelte-h":!0}),l(_)!=="svelte-1fyixd1"&&(_.textContent=ga),_t=U(A),AA=j(A,"P",{"data-svelte-h":!0}),l(AA)!=="svelte-ug4iba"&&(AA.textContent=Oa),Ae=U(A),tA=j(A,"P",{"data-svelte-h":!0}),l(tA)!=="svelte-q06icw"&&(tA.textContent=za),te=U(A),eA=j(A,"P",{"data-svelte-h":!0}),l(eA)!=="svelte-170ov19"&&(eA.textContent=Ba),ee=U(A),o(aA.$$.fragment,A),ae=U(A),nA=j(A,"P",{"data-svelte-h":!0}),l(nA)!=="svelte-103o412"&&(nA.innerHTML=Ja),ne=U(A),UA=j(A,"P",{"data-svelte-h":!0}),l(UA)!=="svelte-1bma8kw"&&(UA.textContent=Ia),Ue=U(A),iA=j(A,"P",{"data-svelte-h":!0}),l(iA)!=="svelte-19bnu3h"&&(iA.innerHTML=ba),ie=U(A),o(jA.$$.fragment,A),je=U(A),lA=j(A,"PRE",{"data-svelte-h":!0}),l(lA)!=="svelte-is1nu0"&&(lA.textContent=Na),le=U(A),o(pA.$$.fragment,A),pe=U(A),oA=j(A,"P",{"data-svelte-h":!0}),l(oA)!=="svelte-1o6rzhm"&&(oA.innerHTML=fa),oe=U(A),o(cA.$$.fragment,A),ce=U(A),sA=j(A,"P",{"data-svelte-h":!0}),l(sA)!=="svelte-1486wvr"&&(sA.innerHTML=Xa),se=U(A),rA=j(A,"P",{"data-svelte-h":!0}),l(rA)!=="svelte-108wwl3"&&(rA.textContent=Za),re=U(A),o(KA.$$.fragment,A),Ke=U(A),RA=j(A,"PRE",{"data-svelte-h":!0}),l(RA)!=="svelte-miraq5"&&(RA.textContent=Da),Re=U(A),o(uA.$$.fragment,A),ue=U(A),FA=j(A,"P",{"data-svelte-h":!0}),l(FA)!=="svelte-7gn4yl"&&(FA.innerHTML=Ya),Fe=U(A),VA=j(A,"P",{"data-svelte-h":!0}),l(VA)!=="svelte-1j9dz3m"&&(VA.textContent=Ca),Ve=U(A),o(kA.$$.fragment,A),ke=U(A),lt=j(A,"IMG",{src:!0}),ye=U(A),yA=j(A,"P",{"data-svelte-h":!0}),l(yA)!=="svelte-1n6po81"&&(yA.textContent=Qa),xe=U(A),o(xA.$$.fragment,A),Me=U(A),MA=j(A,"PRE",{"data-svelte-h":!0}),l(MA)!=="svelte-1xmt5ic"&&(MA.textContent=va),Pe=U(A),PA=j(A,"P",{"data-svelte-h":!0}),l(PA)!=="svelte-jwef96"&&(PA.innerHTML=La),He=U(A),o(HA.$$.fragment,A),Se=U(A),SA=j(A,"P",{"data-svelte-h":!0}),l(SA)!=="svelte-arjt5a"&&(SA.textContent=Ea),we=U(A),o(wA.$$.fragment,A),qe=U(A),pt=j(A,"IMG",{src:!0}),de=U(A),qA=j(A,"P",{"data-svelte-h":!0}),l(qA)!=="svelte-1291a7h"&&(qA.innerHTML=_a),We=U(A),o(dA.$$.fragment,A),me=U(A),WA=j(A,"P",{"data-svelte-h":!0}),l(WA)!=="svelte-18tb424"&&(WA.textContent=An),Ge=U(A),o(mA.$$.fragment,A),Te=U(A),GA=j(A,"P",{"data-svelte-h":!0}),l(GA)!=="svelte-18ydo4n"&&(GA.textContent=tn),ge=U(A),TA=j(A,"P",{"data-svelte-h":!0}),l(TA)!=="svelte-f75cu4"&&(TA.textContent=en),Oe=U(A),o(gA.$$.fragment,A),ze=U(A),OA=j(A,"P",{"data-svelte-h":!0}),l(OA)!=="svelte-18usfgq"&&(OA.innerHTML=an),Be=U(A),o(zA.$$.fragment,A),Je=U(A),ot=j(A,"IMG",{src:!0}),Ie=U(A),BA=j(A,"P",{"data-svelte-h":!0}),l(BA)!=="svelte-firey3"&&(BA.innerHTML=Un),be=U(A),o(JA.$$.fragment,A),Ne=U(A),IA=j(A,"P",{"data-svelte-h":!0}),l(IA)!=="svelte-zk4qj4"&&(IA.innerHTML=jn),fe=U(A),bA=j(A,"P",{"data-svelte-h":!0}),l(bA)!=="svelte-1elhdzc"&&(bA.innerHTML=ln),Xe=U(A),o(NA.$$.fragment,A),Ze=U(A),o(fA.$$.fragment,A),De=U(A),ct=j(A,"IMG",{src:!0}),Ye=U(A),XA=j(A,"P",{"data-svelte-h":!0}),l(XA)!=="svelte-2jx9z8"&&(XA.innerHTML=on),Ce=U(A),o(ZA.$$.fragment,A),he=U(A),DA=j(A,"P",{"data-svelte-h":!0}),l(DA)!=="svelte-1jscwmi"&&(DA.textContent=cn),Qe=U(A),o(YA.$$.fragment,A),ve=U(A),CA=j(A,"PRE",{"data-svelte-h":!0}),l(CA)!=="svelte-13oplq7"&&(CA.textContent=sn),Le=U(A),hA=j(A,"P",{"data-svelte-h":!0}),l(hA)!=="svelte-4gkrqa"&&(hA.innerHTML=rn),Ee=U(A),o(QA.$$.fragment,A),$e=U(A),vA=j(A,"P",{"data-svelte-h":!0}),l(vA)!=="svelte-1tnyt09"&&(vA.innerHTML=Kn),_e=U(A),LA=j(A,"P",{"data-svelte-h":!0}),l(LA)!=="svelte-18gz04m"&&(LA.textContent=Rn),Aa=U(A),EA=j(A,"P",{"data-svelte-h":!0}),l(EA)!=="svelte-1aizwpt"&&(EA.textContent=un),ta=U(A),o($A.$$.fragment,A),ea=U(A),o(_A.$$.fragment,A),aa=U(A),st=j(A,"IMG",{src:!0}),na=U(A),At=j(A,"P",{"data-svelte-h":!0}),l(At)!=="svelte-16u5tgv"&&(At.innerHTML=Vn),Ua=U(A),o(tt.$$.fragment,A),ia=U(A),et=j(A,"P",{"data-svelte-h":!0}),l(et)!=="svelte-1buf019"&&(et.innerHTML=kn),ja=U(A),at=j(A,"P",{"data-svelte-h":!0}),l(at)!=="svelte-2u0326"&&(at.innerHTML=yn),la=U(A),nt=j(A,"P",{"data-svelte-h":!0}),l(nt)!=="svelte-1k7hq0r"&&(nt.textContent=xn),pa=U(A),Kt=j(A,"P",{}),Mn(Kt).forEach(e),this.h()},h(){V(F,"name","hf:doc:metadata"),V(F,"content",Tn),Ut(it.src,ka="data:image/jpeg;base64,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")||V(it,"src",ka),Ut(jt.src,Sa="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAGsBRADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD3+iiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAoorlvFeuaja6no2gaO0MWo6tJJi5mTetvFGoZ325G5uQADxk80AdTRWDpula9Y38clz4kfUbQgiWK5tIkYHHBRowuOexB471xXgnxDLrtnp8+ofEZU1Kadg+lj7ErNtkYBNvl7+VA7554oA9ToriLS/wBc8XazrC6dqx0jStMu2sVaG3jlmuJUA8wkyAqqgnAAGTg810ujWuq2cMsWqalHqBD5hmEAifbjo4U7Sc55AH0oA0qK4bxn4kuNL8R6Xpcusx6Bp11BJI+pyRK26RSoEQLgohwS2WB6Vq2eqRaH4butX1bxLHqmnx/vFvFiQYTgbf3fDkt0wB1AoA6SisPSfEb6pI6voOsWCiIyq95AqhwMcDaxIbnowB61Bb+MIX1G1s73SNV037W/lW815CgjkfBIXKuxUkA4DAZxQB0dFchZeKDaaj4xm1i8CabpNzEsZKD92hgjYjgZYlmOOpycCreneMra91S20650vVNMnu1ZrX7fAqCfaMkKVY4YDna2DjtQB0lFVdRhu7jT5orG7W0umXEc7RCUIfXaSM/nXN+Ab/VryHX7bV9ROoTWGry2kc5hSIlFjjYDagA6sfU89aAOuoqrqUF5c6fNDYXi2d0wAjuGhEoTnk7SRnjPeub8A6hqt7a63Bq+om/nsdWmtEnMKREoqoR8qADqTQB11FFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUVw9lf674w1XV20/Vzo+ladePYxmC3jlmuJExvYmQMqqCcAAZOCc0AdxRXAeLtR1zw34e0xbnxJHC8+rw20upC3ijK27g5LBwyAjH3sAcDgc05/FFtoPhTWddi8VjxStoiBY0a2ISRjtRcwqMbmYdc9OKAO9orkYtF8YvarcTeLliv2Xc1umnxG1Vv7vI8wgdM7wa6xN/lr5m3fgbtvTPfFADqK8w0jxHfeIru7im8bQaJqqXcsKaObaHMYVyqhhIN8hIAbKkD5q7HVvFNvo99baWLW91LVJojKLWxiDOIwcGRtzBVXPHJ68DNAG9RWLL4gkj0m3vU0PV5ZJmK/ZEhQTIQSPmy4UDjru5yMVk6t4v8/wR4kvtNW5sdT0u1lLw3USiWCQR71JXlSCMEEZBoA7CiuaufFsOnxabaNa3upapd2wnFrZRKz7MDc7ZKqq5OOSMngVo6Fr1n4gspLi1WaNoZWgngnTZJDIvVGHY8g8ZGCKANSiuF8Wa9eWPiu20+416Pw7pD2RmW/eKM+fPvIMW6QFFwuGxjJzx0rW8DarqOseG1u9SKyP58qQ3KxeWLqFWISbZ/DuGDj8RwaAOkooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiuMuNT1nxB4w1LQ9I1AaXZ6SkX2u6WFZZZZZF3KiBwVUBcEkgnJxQB2dFcJ4ruvEXhXwFrd8deFzPCImtbprWNJI8uqtuGNjcHg7R3qXStbsbWLUNRHj0eIILK0knmto2tG2KoyW/dIG7EcnHNAHbUVw+jW/izxFo1trU/iQ6W17EtxDZW1nFJHCjDKq7OCzHBGcFec4rsLFbtLGBb6WKW6CASyQoVRm7kAk4Htk0AWKK82m8TXN94t1jS7zxfD4be0nEVpaNDDuuIyikSlpQdwYkgBcYxXU6h4gi8N2OnW+oST6nqd1+7his7ceZdMoyzKmcKAOSSQB60AdBRWLH4gkfSJb5tD1eOSOTy/sbQp5zHjkYcqV567scH0pmmeJ4NUnu7JrO90/ULeITNbXsaq5Q5AdSrMrDII4JwRzQBu0Vw+g+NfK8B+HL/AFU3F/quqQr5cFrCpluHxliFGFAA5JOAK39D8SWuuSXdutvdWd7ZsouLS7jCyRhhlTwSCDg4IJHBoA2aK5/xfFrB0Sa50jWBpr20UkzsLVJjJhcgDdwvTrg0mhXOp618P9Iu1vli1O8063la6aEMBI0alm2DA7njgUAdDRXEx3utaH430fRbnWjrEGpRTvKstvHHJbeWuQ4MYA2Enbhh1IwetdtQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUVh+L9WudF8Nz3VkE+1vJDbwGQZVXlkWMMR3AL5x7UAblFcrpF1qmn+LpNA1HUm1OOWxF7DcSQpHIhV9joQgCkfMpHGeuc1Pq3jjRdDeZdQGpRLC4R5Rpdy0WSQBhxGVOSQBg8k0AdHRXF/wDC1fCX/P3ff+Cu5/8AjdB+K3hEdby9H/cMuf8A43RcDtKK4pvix4PX719eD66Zc/8Axum/8Lb8Gf8AQQu//Bbc/wDxugDt6K4j/hbfgz/oIXf/AILbn/43R/wtvwb/ANBC7/8ABbc//G6AO3oriP8Ahbfg3/oIXf8A4Lbn/wCN0f8AC2/Bn/QQu/8AwW3P/wAboA7eiuI/4W34N/6CF3/4Lbn/AON0o+LPg49L68P/AHDLn/43QB21FcSfi14OHW/vB9dNuf8A43QPi14OPS/vD/3Dbn/43QB21FcV/wALX8IH/l9vf/BZc/8Axul/4Wv4Q/5/L3/wWXP/AMbpXQWO0rlvFeh6hdano2v6OsUuo6TJJi2mfYtxFIoV03YO1uAQTxkc1T/4Wv4Q/wCf29/8Flz/APG6P+FseD/+f29/8Flz/wDG6Lga+m6rr19fxx3Pht9OtQCZZrm7idiccBFjLZ57kjjtVP4f6FcaJ4M0+y1KzSG+iaUuPlYjMrsPmGR0I71U/wCFs+D/APn+vP8AwWXP/wAbo/4Wx4P/AOf68/8ABZc//G6dwIotK1jwzqWtxWmijW9F1e5e8MUc8ccsMkgAkVhIQrI2MjnIyRipvAfhubQ73XrxtJt9ItdQnie3sInVjCqRhTnZ8oJOTwT1pv8Awtnwd/z/AF5/4LLn/wCN0o+K/hBjhb29J9tMuf8A43QBsa9dajG6wQ+Gv7ZspE/eBZ4lZWz02SEKR75/CuHg8Aapc6P4nMFla6L/AGjdW11YaYJA0cLwEMS+z5R5hUZC5xx1rpD8T/CyjLT6iB6nSrr/AON1Cfi54MU4OoXYPvptz/8AG6ANBb3xHrOmahZvok2iXMlnIsN1JdxSBZiMLt2EnAJzkgdOlcLb+CdQ+0+GJLfwXb6fc2F/bzahfvdRSTTBc7mVgSzKTydxDdMA846j/hb3gr/oJXP/AILrn/43R/wt7wV/0Ern/wAF1z/8boAqat4L1LWrXxvaEC3/ALTvLa4spWkwH8qOI87TuUboyueo6jtS6L4dnl17Tri/8P63E1o7SrcX3iBrqKJ9hGUTzGLZzjlV4P4VbHxc8GHpqN1/4Lbn/wCN0v8AwtvwZ/0ELv8A8Ftz/wDG6AOwvZpraymmt7V7uZFJSCNlVpD6AsQB+JFcX4GTX7HVdbTU/DV1ZQalqUt8k73UDrGrRooUhHJzlD0GOak/4W34N/6CF3/4Lbn/AON0v/C2vBv/AD/3n/gtuf8A43QB0EWo6qdNvbifQpEuYZpEt7WO5jZriMHCuGJCruHOCeO9c14ETX7HUNZi1Pw3c2UOoalNfJO9zA6oGCgKQjk5+U9Bipf+Fs+Dv+f68/8ABZc//G6P+Fs+Dv8An+vP/BZc/wDxugDtqK4n/hbPg7/n+vP/AAWXP/xuj/hbPg//AJ/rz/wWXP8A8boA7aiuK/4Wx4P/AOf68/8ABZc//G6P+FseD/8An+vP/BZc/wDxugDtaK4r/hbHg/8A5/rz/wAFlz/8bo/4Wx4P/wCf68/8Flz/APG6AO1oriv+FseD/wDn9vf/AAWXP/xuj/hbHg//AJ/b3/wWXP8A8boA7WiuK/4Wv4Q/5/b3/wAFlz/8bo/4Wv4Q/wCf29/8Flz/APG6AO1ori/+Fr+EP+fy9/8ABZc//G6T/ha/hD/n9vf/AAWXP/xugDtaK4r/AIWv4Q/5/b3/AMFlz/8AG6X/AIWv4Q/5/b3/AMFlz/8AG6AO0oriv+Fr+EP+f29/8Flz/wDG62PD/jDRfFEtzFpNxLK9sqNKsltJCVDbtp+dRnO1unpQBu0UUUAFFFFABRRRQAUVymqXOrap4vk0PTdUbTIbWwS7lmjgSR5Hkd1RcOCAo8ticDJyORV7wrrc2seErTVLxAtxsdZxCpILxsyMVHJwSpIHJ5oA3aK5G6+JXhuxljiu21S3eRWZFl0i6QsBjJAMfONw/MetR/8AC0vCn/PzqH/gquv/AI3Sckt2B2VFcZ/wtTwnnH2q/wA/9gu6/wDjdMf4teDU+/f3a/XTbkf+06OZdwO2orhv+Fv+Cf8AoJ3P/guuf/jdH/C4PBI/5idz/wCC65/+N0xXR3NFcL/wuDwT/wBBO5/8F1x/8bo/4XD4I/6Clx/4L7j/AON0BdHdUVwv/C4PBH/QUuP/AAXXH/xul/4W/wCCf+gnc/8Aguuf/jdAXO5oriR8WvBpGRf3ZHr/AGbc/wDxumn4veClODqV0D76dc//ABuldDO4oriB8XPBh6ahdn6abc//ABunf8LX8If8/t7/AOCy5/8AjdHMgO1orij8WPB46315/wCCy5/+N0n/AAtrwd/z/wB5/wCC25/+N0cyA7auHsrHXfB+q6uun6QdX0rUbx76MQXEcc1vI+N6kSFVZSRkEHIyRil/4W34N/6CF3/4Lbn/AON0H4ueDB11C7H/AHDbn/43RdALrthrviKw0N7jSI7eS31y3uZLcXCyGO3TOWY8Annoue3WtnxT4ag8R+FdR0VWW2+1RjbIi/cdSGRiO+GArE/4W74L/wCgjdf+C65/+N0n/C3/AAV/0E7n/wAF1z/8bp3C5n+JLDXvFPhyXSdX8E29xqX2eSGG/wDtULW8UrLt81Nx8xecHG3PGK77SrV7HR7KzkKtJBbxxMV6EqoBx+Vckvxd8Ft93Ubo/TTrn/43Tm+LPg5Bl768Ue+mXI/9p0roLlDxXZat4n0m90258BQTXc0bww3st3A0cROQsgb/AFgx1wFz2qxHomveG9csdWtbU65nSIdOvEWdY5t8RJEqmQhSG3NkEg9DzTz8YfBA66pcf+C+4/8AjdJ/wuPwN/0Fp/8AwX3H/wAbpiuhPFOmavr6aFeXOgPdWkEkxvtFN3GC+RiNiSQj7cE7ScfN3xWLYeDdXg0Xx9BDoFtpq6vaKmn2VtLHtz5LLtJBADZIyTgZJwSBmtv/AIXH4G/6Cs//AIL7j/43S/8AC4fBH/QUuP8AwX3H/wAboHco654R1H+3NP1qC2v7tRpkdjcWthqbWcyMjFgwYOquPmYEFh0BGa6Pwbo66VZ3sp0y7sJ7q48yRbu/N3LJhVAZn3Ng8Yxk9BWV/wALi8D/APQUuP8AwX3H/wAbo/4XF4H/AOgpcf8AgvuP/jdArkmsaXqlr45bXYtFXXLSWxW2SITRpJauGYsVEhC7WBGSDn5aveBdFvtF0e7S/hitmur6a7is4X3JaRuQRGCOOOTxxljis3/hcPgj/oKXH/gvuP8A43R/wuHwR/0FLj/wX3H/AMboC6O6orhf+Fw+CP8AoKXH/gvuP/jdH/C4fBH/AEFLj/wX3H/xugdzuqK4X/hcPgj/AKClx/4L7j/43R/wuHwR/wBBS4/8F9x/8boC53VFcL/wuHwR/wBBS4/8F9x/8bo/4XD4I/6Clx/4L7j/AON0Cud1RXC/8Lh8Ef8AQUuP/Bfcf/G6P+FweCP+gpcf+C64/wDjdAXO6orhv+Fv+Cf+gnc/+C65/wDjdL/wt3wX/wBBG6/8F1z/APG6LhdHcUVxA+Lngw9NQu//AAW3P/xug/FvwaOt/d/+C25/+N0rodzt6K4f/hbvgv8A6CN1/wCC25/+N0f8Ld8F/wDQRuv/AAXXP/xuncV0dxRXEf8AC2/Bv/P/AHf/AILbn/43S/8AC2fB3/P9ef8Agsuf/jdK6GdtRVDRdasfEGlx6lpsrS2sjOqs8bRnKsVYFWAIwQRyKv0wCiiigAooooAKKK85vPEGvLpereKYtSCWOnahJAum+QhSWGKXynLORvDnDMMEAcDBoA9GoqpqOowaXaG5uEuXjBC4traSd+f9mNS344rmJPij4VhuJbeW41COaJgskb6VdBlJAIBHl5HBB59RQ3YDsqK43/haXhT/AJ+b/wD8FV1/8bpp+K3hEdby9H10y5/+N0uZdwO0orhz8XfBa/e1G6H1065/+N03/hcPgj/oKXH/AIL7j/43RdAd1RXCf8Li8Dj/AJitx/4L7j/43R/wuPwN/wBBaf8A8F9x/wDG6YXO7org/wDhcngX/oLT/wDgBcf/ABulHxk8DHpq0/8A4L7j/wCN0Bc7uiuGHxf8FN01K5P0065/+N04/FzwYOuo3Q/7htz/APG6V0B29FcN/wALg8Ek4Gp3Of8AsHXH/wAbpw+Lfg09NQuz/wBw25/+N0XQHb0VxP8Awtnwf/z/AF5/4LLn/wCN0f8AC2vBo/5f7z/wW3P/AMbo5l3A7auMuNM1nw/4w1LXNI08apZ6skX2u1WZYpYpY12h0LkKwK4BBIORmo/+FteDf+f+7/8ABbc//G6P+FueDB/zELv/AMFtz/8AG6OZdwGeKbbxF4q8C6zZHQhaXE3lLa273UbyPiRWYsQdi8Dgbj0NdZf6Taahpd7p8kSpDdwPBIUUA7WUqf0Ncr/wt7wX/wBBK6/8F1z/APG6Q/F/wSOup3P/AILrn/43RdAVILDWoPDdr4a1zwdD4ggslWKG5S4h8mVUG1GZJCGVsdcBuc4ro/A2iXXhzwTpOkXrRtc2sGyQxElc5J4JA9axh8YPBJOBqdzn/sHXH/xup1+KnhJxlLu+Yeo0u6P/ALTouhXQ7X21C/a5srvwFHrFuCVgka5tyjKehYSEMh+gNYmm+EPEHhvTfCV5DHHql9o8E9tc2onCFo5SCBG78ZTCjnGQOorVk+Lfg2L/AFl/dp/vabcj/wBp1A3xp8BJ97WZR9bG4/8AiKLoLon8TWuu+JfDUA/sWWAxahHJcaY94ge7tlHzIXU7RkkHBbB28nms7wv4WvNP8cXmqQ+GLbQ9Mm0r7PHDDJGWMvmZy4Q43EemRgDnPFWP+F2fD/8A6Dj/APgFP/8AEUo+NXgFvu63IfpY3H/xFO4XMgeBtYXwv4Mla2uDfaLbPBc2VtqBtpWEiqDslRgMgqOM4IJ5rp/B2ifYr+/1CbR9SsbiaOOLzNR1Q3ksiqWOPvuFAzxzzuNUx8Y/Ax6atOf+4fcf/G6P+Fx+Bv8AoLT/APgvuP8A43Sugub3iyXURoVzbabpE+pTXUUkO2KaKPy9ykBiZGUEZ9OayfDc/iLS/h7BaN4amTVNMsIbeG3luocXLogXIZXIUZHfBqt/wuTwN/0Fp/8AwX3H/wAbpw+MXgc9NUuD/wBw+4/+N07hdEfgq21mz1B7rWvDmoHVr/m91Sae2KRgAlY0VJWZYweAAOpyfbvq4b/hcHgn/oJ3P/guuP8A43Sf8Lg8E/8AQTuf/Bdcf/G6V0FzuqK4b/hcHgn/AKCdz/4Lrj/43R/wt/wT/wBBO5/8F1z/APG6LodzuaK4b/hb/gn/AKCdz/4Lrn/43R/wt/wT/wBBO5/8F1z/APG6LoLnc0Vwv/C4fBH/AEFLj/wX3H/xuj/hcPgj/oKXH/gvuP8A43RdCud1RXC/8Lh8Ef8AQUuP/Bfcf/G6UfF7wUempXP/AILrn/43RdBdHc0VxA+Lfg09NQuz/wBw25/+N07/AIWz4PPS+vP/AAWXP/xui6Hc7WiuKPxY8HjrfXn/AILLn/43Tf8Ahbfg3/oIXf8A4Lbn/wCN0XQXO3oriP8Ahbngz/oIXf8A4Lbn/wCN0f8AC2/Bv/QQu/8AwW3P/wAbougudvRXG23xT8I3d3b2sN/cmW4lSGMNp9woLswVRkoAMkgc12VNO4BRRRQAVm69o0Ov6LcabNI8Ql2lZY8bo3VgyMM9wyg/hWlRQBgaP4fu7XWJ9X1bU11C/eBbaNo7fyI44gSxAXc3JJyTnsMAYrL+KnPgC5/6+7P/ANKYq7OuM+Khx4AuT/092f8A6UxUnsB5SWKN8p6U1/mO7Gaf5ZZs54p29U4PTHGK535GqKciK5yRzVOdQpGAB+FXLl1cjaMAfrVJhzVxJkRYpucHgVLj8qYV5qyBAN1OWPNA4qRCPWmIPLx1qZEGOM1LCIypDnHuaiSQoSuazbNEgaNWGDzUscQEYzwoPQCmZ5qzEMoeeO9S9ikRqADx096X2pHXa2M0oGcUrDuOAFNYA8EfiKevp3oIHegZVddrYFISKmaJh83brmoSVPY1SIY3k1esbi3tgXfmQetVowGzgcVG8eGPpWkdNTKSvoLe3t1qEx+fEY6L0FZkgIOKvqpXJ9qpOMsc0rtsLJLQrkc4pQtWYrdpTxgD1NSPZSqMqufoadhECnAqdMFeaiW3mLY2EfXir0VsAmC3zUFIYkZccDOKCm046VaiHk5zz60yYiRvlqrKxN3cjQ88ikY800ZBxTjzUlAGFPApir7VKFI6Uhhijge9ThS64wBURhcH2pDsRkijPpSGPB9aAPwqhDSxpQxpCwB4pVIIpXAcHxyelSB+OOlQlQe5xTwQUwM8UrhYmXB680d8YqMOo4zS+ZnoBRcLD8DvTSCDxxTgzMcBSR601yytwpH1p3C1hyqzHnpXdfCMY8Q+IR/062f/AKFPXBicdGHNd38IST4g8QkjGbWzx9N09OItT1miiirAKKKKACiiigDntX8PXtzrS6xpGqrp96bb7LMZLYTpJGGLL8u5cMpLYOcfMcg1o6HpEGg6JaaXbM7xW6bd8hyznOWY+5JJP1rQooA8u+KQB8S+H89rO8P/AI/b1yEU7BsBvlI5rrfio2PEvh8dM2l4P/H7euRihKtuYjA6V5eLtzu5SEcbf3gUY9ay7iFHYuUBJ9TWs91Gq/OQADggCufv5RLIzKGXtjpUUE2xVLGbcHbKQMYzjiq74AqR+Wpjn5SO9enFHKyHd6cUu3j3pMU4HHoasQ9I8mrMaYPzVHEQSP5VpyeQ1gcELKMEe9ZVJWKiriLHhAOcelRtCjMOhxTI7lmj8snvUkbDIHpWFmi9C35axqu8DgcbBihZM5y2R2yasMiPbgb1GfunNZjkhiM81lFcxbdiz5m44zxT+nIFVUzk9KsKwZOuMdabVgTGybJBkjZ/WqDE7vYVdkO9dmOe3NVJkMK5fIOehq4aaCkVpJOeKiJOeTTmdf7mDShC0eeproWhkyxFcpAm6MDzPU1XJmnLSOxIHViahINKZGWHZnrS5ewEMhGetQ4yTTyeeaVUJGavYRGBzT9/vSOrDtTFRieePeqsgJiwIBo6j2pCARwc4pVkCLg80JAxM81Irgg5AJquzZPFCuRQ0BNv55o8wHioC/40gftiiwyznjij6moBNtPFDSls8ilYLE5YD0ppYetVyxI5NG7H0p2CxYJpu4ioxIPUUeaM0ahYnWQjnNTxzBWAPOaqKwanAjqc8VLVwNdZCODn2qclfJyBkn9KzhJvUNjAHap1m3R9OPesGhj+W4FO2gAdM01WBYZ59qlUEqWZOnT3puQJDFZl5H5VLEzv944HvVZshuMgE+lPFxnAwM+tDjcLnu3woOfh7aH1urv/ANKZa7WuK+EyGP4d2aEglbm7Bx/18y12tdK2NwooopgFFFFABXHXPgeaeS8tF1cpod7efbbix+zguzlg7Ksu7hGYZI2k8nBGa7GigArwjxO23x/4lP8A09xf+k0Ne714L4r5+IHiVc/8vcX/AKTQ1hiPgEyssxdcE1WuOh4qRBsXNQXEo2n1rz4rUfQx7tVwelY8h+YitO7JOazHHNdsFoZyK0pxUO4nip5FzUO3aa3RAeXuPFXrazLc1WiYB+a3bJlwKmcrIOo+3ttvWp5YRtpZZVUZWojcbuM1wttu5ehGlt8+QKsqgQe9ETg9afKVx1qW2xojMuB1oDBjzVVmy1SI2Kdh3LBwKqzYqxv4qFwGoQMpliOaryOTVuVQtVW61rEzYluQswZulbMusmK38uI8mscgYpoXLVe5DVx9zI7oXkYkmuVvjukOK6e5UmPArEa0MkuMUoLW5LVmY4hJ7VNDmN63V04bOnNUbixZW4FbJ3C7ZbtbgEYqzwzVn2tuynmtJExg0mkUtgMPfFIjbD1qwWGzFUpSQciq6AXfMBWmebg1WWQ4xmkZuetZ8oy6jhqnC5rPjbFXYpRihxGPPy1A8uKklyRxVGXJNCQMeZMmmO5qEHFKW4qrCHCVgetWIrgjvVMHmp0FSwNOC7JOM1ow3GeM1hRnaatxzFe9YyQG0zgioSuaqLcZAqxG+73qVoMZIuOlQbmBwKuyLlelZ0jFDVLURp6W/wDxO9FBP/MUs/8A0ojr6fr5W0eXf4j0Qf8AUVs//R6V9U11UFaJrT2CiiitiwooooAK4v4rf8k+u/8Ar6s//SmKu0ri/ivz8Prv/r6s/wD0pioYHlkcny4xzTJVLr2B6UxRggsalJzkk1gkaXKckPA+YfSojGw9/p2qy5+b3pAPajULIpFQGxk0jDOQKdcr+9Hpik64wKski27aUE1KYHI+6cUzYQaZIqkk9TSlttAwKT5SRmpZWxIsm7rTlfqc4qLinohY45osHMSZz1NSJ60nlY6mpVC7eP1pWGpajl+5mmtz1pWztHHemlkAyCGPfB6VNi7jt6ldpGQKryoFXKjI9aPMU/7PPenLcRLuRnTBGDzzTSYm0QJLsJ4pu9myelOKKOc59KVYiBnPWq1Jsh8S7uCOO9OezikGRlfpSKSB1pVlI+lMl2HeWsa4XgCmlieATimM5zSbs0MSHgAmpVVQQ2Qe9QinhWPIHFCGxJZF3+1N4HPWlZMnkV0WieDbrU1WeZ/Itz0JHzN9BVJNi2OZbB5pygN0Fd9P4e8PaUP9IDykd2cn+VLDdaBbwl4Y4I3A+UFOafKurGk+xw8VncSnEcMjH2U1rWXhfUrk7mgMa+shxXQTeKLeKGB7SOKbdnzF6FaZd+L0liVba3ZJQcglhik3Bbs1hQqy2RJZ+ELNMi6u8t/dTirLeEdMcER3EqkepBrIj1g3Fw00igOe3ar39pyDPzAbvzqPbUzpWAqFDVPBU8MZls5ROBztIw1cpJbSROUdSrDqCMV6BFrLIVQne3RRRrOmx6mkriMLcx9GA+8PQ01OMvhM6uFqU9ZHnogJJGBSrYys2DwPWtFYAPvLz2FO5Gcilc5rFMWahdpJzSC1wMKcCrpUlc4pm3jv+NKwyCO1VMkjJPc08W0anIWpwuKkAHegSI1QbOBihow2AcflU6rkYpwiUkUJA2VDbRt1UE/Sux+FSCPxJ4gUDA+yWf8A6HcVgLbAYJrpvhqmzxVr4/6crP8A9DuK0UbEc12emUUUVQwooooAKKKKACiiigDyf4ttt8R+HD/07Xn/AKFBXKrcKY8KeRxxXS/GMka94c29fs15/wChQVw0M2xvvZbH1xXn4mHNO4KVia6RpCCCME5IPArKuLfB4lU8ZxzV64uAE+Y84rLeUu3TAopJoiTRXdDnkYFRoATycn3q0cYIIrPBAkOT3xXUrtGb0HyKD0qPG04qQtu4AppRjyRVRJYgYjofyqwn3TUCjmpgwVQO9KQ0O8zy2461L52Uz3qvlAaC2azcR3LSzkL9489AaTfluuTUKqfoPWhSqt8xPFHKugrl0HaoPNSPKEAHHPWoA27HbimzNs2s549qz5bs0voSGTDBvQ8U2eeOZfmB3eoNVpZeMq3y1B5ozn0q1DqLm6BO3l47g9DURuGEe1aWadZFCgYx0NVywHArVLTUgkDHjP5VOiq4+Y4qpvC9WpBc4B9xT5W9h6Ftrdd2c8elNY7e/FVTeEDBFQm655pqL6isXDIxGM8Uzgnr+dVDPnvSebmqUR2LoKrySKhMqkkE1HFDcXDBYYZJCegVSa6bSPhx4l1kqUsTbxH/AJaXB2j8utVyhY5sygdKjMwzXs2lfBGzjCvq2pPK3dIBtH5nmuw03wF4X0nDQ6TAzj/lpN+8P60WRapNnzrZ6ZqeonFnYXE//XOMkfnXQWfw18W3uD/ZrQqf4pXC19CNd2FhHjdBCo6BcAVSk8Rw5xBbzze6pgfrVqDeyOmngqk9Ujymy+Curyc3eoW0HsuXNblv8E7AJ/pGsTs3/TOMAV2Mmt3j8R2apz1kkA/lTBe6g+czW6/TJxV+yZ0rLZ2u2l8zmP8AhSukHn+1rv8A75Wqdz8EoCf9G1px7SRA/wAjXa/aNROR9qgH/AT/AI0wy6vJny7i3b8DR7PzD+zf7y/E89m+CV+P9Rq0D/7yEVlXfwe8SW6M0Jtp8dFV8E/nXqpn12PtE/0NPTWNWjz5liT/ALpzSdN+QPK5fZkn8z5/1Dwzr2jk/btMuYlHVymV/McVTHzCvpZNet5h5N7C0YbgiVeDXmvxG8DR2kba7o6KLfrPCnRf9oD09axqQaOOthalL4kebiQ7QvarsRDQhT0FZwJPX61at5MEgke1YyWhzF6DAZcrle5rQZ1C4A4FZiOQuAe/WpmnBXBPPtWMo8zKTshXYSSEkqAKj2qx4HGetNUhm46Z71OijcABWlrGdz3L4Tf8k7s/+vm7/wDSmWu2rifhN/yTuz/6+bv/ANKZa7at1sdIUUUUwCiiigAooooAK8A8WSBPiN4kH/TzD/6TQ17/AF87eNiR8SPEfP8Ay8Q/+k8NZV1eAmN8wMvFU5x1zRFL8vWobmbANcUY6hcoXA61nyrV2Ric1SuGwPeumJLIcDFQTLQJcGg5fpWhDKu8q1aFrcsOM1VNuSc1YhhKmpk9CTRMxK8mohOQ2KaeBUWea5mh3Lq3JHenNdEjrVIAmn7DSsg5iwr7jVhGxVOLg1aXpSaKiyTzKBJioWYA1E8mKLFXJZWBqjK+GqQyDuahkYNzVxRDImmNSwMS3NVyMmno4QjmtLCNdYldOajNqiEnFQJd7Vpkt9kVHLK4h0pC1UchjUUl3uJqLzSe9axiwSLSotSEhVqkJiKHlLDrV8rHYsGQEdaidgRV7Q/DWs+IrpYdNs5JcnBfoi+uT2r1XSPgvY2KLc+IdT80LtYwwfKvuCx5x9MVapMcYOTsjxZW+faMk9hXRWPgzxJqaJJa6NdvG5wHKbR+te4WFv4O8OS7NO0u1jlUkM5G5h36tk0tx4+tY3VEnQblJBVSQPTiuiOEnLoehSyvE1Nos8x0/wCEPii7AM8dvZgnBEsuTj1wM11Vn8FrWBA+oa42cnPlIFHt1p0nxD1IsrFYzgkDHRh/SsqXxTezPOrTjypP4M5259PSuuGWy6tHq0+GsQ/isjpx8KPC3llDf3ZcLywlXj3xis68+CthNGfsOsyiUL0lQEE/h0rNj1tgQ0E0uRhcu3B+tWY/ENyjM/2g/ezkNitf7Mvsy5cOT6M858S+Cdb8LzH7fakwE/LcR/Mjfj2/GueC5NfSGm62NY04wX8cVxZPmOVJOuDXkvj3wWfC+pJNanzNNucmFuu0/wB015uIw0qTszwsXgqmHlyyONWEnHFWY4SBSxjFWU5FcMjiICuDQpy1SSLioc7TWYMuoMgVftgAayo5hjrVqO5AxzUtMEaz428VmzxZJqQXakdacuJKUVYTZHpEW3xJohx/zFLP/wBHpX1TXzJYRBdd0VvTVbP/ANKI6+m67KPwmtPYKKKK2NAooooAK4v4q/8AJP7r/r6s/wD0pirtK4z4qc+Abn/r7s//AEpioA8mKYOcfjTnPFSEbRgc1GwOealQFzroNEWRnrTcc9akRtqkAnBp6RbuegpcrvYrmVrmdcRO8gOOPWnxQ7cYH4mr00W1Cc9ajQfIBihIlsBnPJqTyIZgQ/B9RUfTgUoPFULQadJUg7ZsntxUEulzpzgMvcirYJ6jtU8NwQcMSR3pWBtrYyfszRgs2CParEcYUA+35VcnRJEO0iqhBHAo5QUk0Mb5mwOlP+4uOc/SljUD61BfXC28IYnkHp7U1G6GnqVLvUmQvFF0HBY1Ukufs9sH3FcrgerGkliEtwrtnytu8471mGVrqZppiQF4VfQelNRRo5aiy3VxIpLOQp7VCZcnALe+aGDzvx07CrUFmjNhpQh9hmjYW4RmeTiMOfqasy2t3HGGZ+o6E1d023jgky0+70UHAJq7cxLt8xpSOwAp30Dl11OfhlvIX3ICVHbsa6a2MdzAsgXBI5Hoai06285yWLEAcVtJbqF4AX6VDbYSUYmb5C+lAgXP3a1DAtIYQpwaVmSmjN8tVBO2npHv4CnJ7DvWgIGkcJGhdycAAda2bRbPRRvl2TXxHC/wx/8A16VurNIRcnaKG6ZoFtp0S32r8nrHb9yfepL3xJc3D7EbyIB/BGecfWqtxqJuJzLM+5mH5VkSyhpWwep7VjOt0jselRwairy3LTo1wwQEvG/XPXFZEkJSR44juKnHP860IpXGVXPPH0rFvZmttSL7sgisFLmdkb1YRirsrLNJaytHyuDSmTc4k3cg0XJEuHU5P86hQ5PNW31Ji+hrLcHcDmrsdyzdTxWLHyRjk1fifHGM1yyTO+EjVim2OJGOMcit7R9VQZM+dh4z6VyuWI56itGyjZwCSdo7etb4fm5tDnxk4cj5y1qMUP2yUwgFCeMVT8of3RWk0W7JxzVd0wcHg16DgfOOZU2UFR0qx5eeaPLFLkFzsqmJW4KinfZuhzg1chtXlOI4yT7VYXTblmA8oj601AXOzN8jHepEj2jiteLRpXYb8AdzWjFpcEYHG4j1rSMCW2zI0+0NzJlvuDrXReDUEfjXXFUYA06y/wDRlzSRwpGMKAB9Kl8Jf8jzrv8A2DrL/wBGXNVJWQ4bncUUUVkaBRRRQAUUUUAFFFFAHkXxj/5D3h7/AK9rz/0KCvO1YI2CMdx716D8aeda8Pf9e15/6FBXmbyEjArnqQvK5nOVmPuJtz4Y9KYV2rnt2qq7FmO786kWX93gk8dKfJZKxCdx2TjrzVIxlX+ar6JkZ5qK5H3fWqi9bC3IU4+6MVMuTwc0zjb6YpPM4psRY+zpIPvBTTl0/wAz7kvIHPFQKw3dfwqYSMgznGfSspc3QasQy2U0P3xwe4ORTMCNlDDrWpFcDyWSTkEelZ15EFKupyp/SnBtuzBjmYRgkng9BVUksxJqNmPelDYFaxhYRdScbMnoOMVXkuDIwJ7dB6VD5ozyaY79Sg57ZpciTKux0j7T7+lQNIQcmmNJgZJyT1qB2Z2/pVqIEjS5zg/hTdzN0z9K6Tw14F1XxG3mRqILUH5p5eF/D1r1PQ/CPhzw2gcxrfXY6yyrkA+w6CtFHsb0sPUqv3UeN2PhvW9TIFlplzLnowQgfmeK6zTfhDrtzhr6WCzjPXc29vyFenz624wkKqi+gFFqby9YZdiPc1r7J2uz0VlMox5qjsc3afCHw/CALq+urh+4UhR+grWg+F3hJQP9Cd/d5TXVW2niMAucmryoq8AVm7LZnPOlRjpHU5eL4c+FIuV0iI/7xJq/D4P8O27BotHtQRyD5YNbRbHU1RvtUgtBh2yx6KvJNJXZMKPO7RRYitLS1A8m3hjwP4VAqO71e1sxiSQbuyr1P4VhXOqTyrmSUWsR6Dq5/wAKypNVtoN32eMs5/jfkn8a1jSvuepQy1y3V/T/ADN2bXL2UHyLYRL/AH5mwfyrMubqRl/0q/cgfww/L+tYU2oXEzH5zg1EWY8kkmtYwSPXpZfGHZGk9/FGcwQKW/vyfMf1qs2o3T5BmYc9uKqgnOM8U4qavY640YR6D/Ndm3FmJPUk1IkrZ4JqEL2qRIyTkUXKaiWo5X7k1fgupFwAaz4lJqwqn1qbnLUjF6G7b3xPDVcWdWPNYUJ6etX45MjHes5RR5VajFO6NBgkikOoZT2IqoIVg3W7/PZTgqyNyFz/AEqSGTnBPNTSJ5sbL6jj61ntozl+H3ZbM+f/ABVoo0DxDdWK5Matuj91PIrIQfODXovxXtAZtO1ADmRDE5x3HSvOkBK5A5rnaszxaseWTRYXdng08ZyRnPvUSZJ5qdIyTwKnYyeoBihzmrtm2+QFjwKr+WFHNT23yMKUrNCR7n8KOfh7aEdPtV5/6Uy12tcV8J/+Sd2f/Xzd/wDpTLXa1otjqCiiimAUUUUAFFFFABXzv43GfiN4j/6+If8A0mhr6Ir528bkD4jeI/8Ar4i/9JoayrfCJ7GMH2jHeoXbceaSR6g385rCMSbiyrgVnXKMwOK0twbikaAEdK0TsDMERndzVqJParEsQVqiZgg4qr3IaLMcanrU4gXqKzVusGrcVznvWU7iuiZrfIqBrfB6VOLgE9akLKy+9c92IqKoBxSsQBSyjaciq5YluatK4Eydc1Y3YFVlapNwIoZSYFs1BI1PkbA4qHPFNIZE7EVAZeetaWn6NqOtXIt9PtZJ3P8AdHA+pr0DSvhDHbRrc+ItTSBephj6/TNdFKlKeyKhTlN2ijy6NZp3CRRu7noFBJrcsPA3ijUyPs+kXAU/xSDYP1r1yDV/C3hqHyNF06N3HHmbQSfqTzWVd+N9YuZCIZBEh6BRXrUcqqz1at6ns4bh/FVleS5V5mTpnwc1Btr6vqFvaR9wh3N/hWyvwt8IQ8XGtXEpHUBgP6VFBHq+qkGSWZwf7xNb1j4TmIDTNzXQ8to0v4kzpnk+GoL97U18jL/4QD4fx9WuZD/11NSL4O8ARDAsJpP96Rq6WPwuij396tReHlKFdvOetR7PCx6sxdHAx6tnJx+G/AyvhdEck8csx/rWlF8N/CFyoupdLkt4lwSGlIB+tbU39laFG73EsTTgZCMcVxev+NZLsKkcsJjdCGiUEgfUnvU+zjPSmrLua0suWLklQg0u7/Q35/EGmeGrVrLRNPSGFBksqhQ3bIz1Nche+JLi9kDC4kkl2YGFwG56EVz99fG6cSj5T0wD/T0qukzgjaeR045+tdMKdODtE+pweTUaEU7alu5ufMmWSQOpP3wD1/wqlJLIYwNo2g5Bxz+dTsrvGpLcZwPanQRNKgiJBGcjjjNb8reh6keWC9CmZXcFS3y+9EbFC2TjK9xmrx0+UMAFxxnpUi2RdmDAnjqB3o9nLcp1oW0KcLOWAGW/GriRk4Yg5z26CpLfTpVTzNnyjjJ9a2bayZ7ZpGRBkdBWsFZXZzV8RGOqIbKd0KRxE4ByQO9dxGLDxZoM+jXqrv2/Ie6kdCK5GC2aGdcY4/uitywYWlys8SgsDk4FTiqMasLPfoeBmVKnXhbr0PGdSsJtJ1O4sbgYkhcoff3qJXAFek/FfRI5oIPEVoow2I5wP0NeVCQ18pWpuMrHw1WDhJxZcZwaruwzxUZc0KCxrCxk2OQZqYI2OtCRnHSrkUW6kxFMbxVmCdlYA1dWyDDpSGywelF0Kxoaa4bVdG/7Cll/6UR19MV8yaapXWtGH/UUs/8A0ojr6broo/Cb09gooorY0CiiigAri/isdvw+u29LqzP/AJMxV2lcR8W/+Sc33/Xxaf8ApTHQB5Utwjnhvzp24EVlJ06mpVlePGKPaK9g9i7XRePapY5VXg1n/aif4MfjSi5B/hqueHcn2U7bGjJMjj0xUB56Yqo05PQY96ZFMySZLZ9RUuUUxqnKxdJOaVSPxpUxMu5WGfT0pjlU6vz7U9CLMlLKF46miPO7pVNp1U8AmmfaZQ+5CVI6YqHJIuNNs1hFlcg5qCRCvUVQNzOeS5GPemC8lHylt360KqivYNl9ASeBmsO9D39xOEUpJGNjIeak1HUp4LF2tgRLwAwGcetYljrNxBcs8jEuwwXIzn6jvWkZJ7CcHHc09IdZIJYGfbKmQFPcVDfQMsKybB8zEE+tNt76GXU1muEjCE4Z48jPv61qX1lDPLEum3QuBI2PK3AkGmMbo3he/wBWj86GIiItt3eprqR8O5jaIQw88/Nt9PxrvtB0f+ytGsYmA3RjL7e5NbQVFYkDk9adkRzPoeU3ngmW0sRcFmeRfvjHH4VkTaZP5ioqFvevYNQhMkLByQmPup3ri5YQjsFGealwQ/atGVY2JtosNgsetWNnbFacOl3E65+VAem41pQaTaQgC4+YsOpOBVKJk23qzmdop0FpLeTiGFc92Y9FHqa6K60e1k+eOQQxL99+wH+NYF9qEcStaadujgJ+dyfml+vt7VnUnGCuzow+HnVlZE1ze2+nIbewIaXpJP6+wrGd+vqajL9gKjJ9TXnTqub1Pdo4eNJWQ/cXbGQBTsIW4yfSo1VANzHNK0xVflAxjtWDk3ojptbVlgLhfQ9hVV/KYbJY0bnnuaSUsF4Yk1EltLM6lUYlj6VtSpPc561aOxn3dv8AZH+QsVflT/Ss/wA9FJDhtx6Cum1XS7+JlEkRMYGQwHFczqFhPGvmMjDsK6lHpI8yc7O8Ni5ZsQ6knp1zWgGKjkj1rnbVpmALM2BWlDfx4VX4cnGfSplQu7m1LF2VmdDpdnPqMwSNCR1LHgCu4tNLgtYlU4dh3NUfDEaR2wO5drDOBit9lXtXXSpqKOHE15VJW6FQxRDpGo/CqsulwXD7iWU+1aZA60mAa20OUqR2cUChUUfUjk1GdOti+4p+VaG0UbR7UWQEMccca4VQB7VJkCgqPSgRDr2oANwPel3UnlqO1G0D2oAdkUeE/wDkedd/7B1l/wCjLmm4FL4S/wCR413/ALB1l/6Muamew47nc0UUVkaBRRRQAUUUUAFFFFAHjPxxfZrHhs8/6i7/AJwV5j5m4V6V8d/+Qr4b/wCuN3/OGvM4lBG70qJWSuZSV5CsBjrk+tQkkHHpUjvtJB5NRYZjnHWiL7mbXYnS4KLgjOKa8okbc1Qd8d+9KVbH+zVOMVqCuOJLdOlNBOetCHaakMYIyOlLYQIwzzUpcMwC9KgKrnAzz2p6nAwoyaiQ0XIASMEcZ5NJcxqIyAe3eoomZMkE5I5qtdTZAUNk9+azinzFWK7Hnim5bYfSmM+OtVp7kjAXHvXUhJE5bIyDzQGyuRxVZbjg/Lg0qOZHCl9gJ5PpTsOwshO7FeneAvhs19HFqusIVtmG6KA9ZPc+grG+H/g863rf2i7XdYWpDOe0h7L/AI17+iBVAAAUDAUdAKd7G9KnfVmbLp4eNIYVEUSjCogwAKoSaDKz/K2V610nbjFOxzVqq47HpU8ZOkrRMC28OqHDTPn2FbkNvHAgVFAAp44pQCfYVMpyluZVcRUq/EwzTJZUiQu5CqOpJqG8v7eyj3SNgnhVHUn2rltT1PzTuuz8vVbZT1/3j/SnCm3qaYbCTrPyNC71l5w/2dhHAODM3f6Vzs+pKjMLcEsfvSvyTVG6vZrpsucKOiDoKrlvWuhRSPpsNgIU1qv6/UlklaRizMST3NMGPWozIopPNA6UzvUdNCwozTgB9cVU84+tIZj60w9m2X1KmnDA+lZ4nOetPE59aLEOkzQG3pUqAA1mif8AOrEc/vRYynTaL4wKmQHiqaTBuM1ZjkHXNKxzTi7FuPAqyrgYNVA4I64NTIcVLOSauaEIDOGq/Gc5WsuFsrzWjCelZyR51ZHGfE21R/CAl2jdFcjB+oNePIflr274jlR4Jug2MGVMZ9c14b+lc0tzxsT/ABGTA4OatxzKVAHGKqRx7hyfpUiqAfQ1DVzmLYbcenFToQD1AqkrkH5c/WpEbGCefaocWM95+E3/ACTuz/6+bv8A9KZa7auI+Ev/ACTmy/6+Lv8A9KZK7etlsdAUUUUwCiiigAooooAK+bvH0uz4leIl/wCm8J/8l4q+ka+aPiGcfE/xD/12h/8ASeKpnsKWxjbtwqJzinBvlqvI5OQKxRFhyy4NWBc/Lis/kc0oftVpJgSzS5NUpSWHFSuM85pgA70aCZU+YGp4pcU50UVDkBqiWxDLsbkmr8QytZkRzV1JMLjNc0kCJpVBFVGQ5p7S+9NLiqiOwmdopd1NiinvLqO3tonllc4VEGSa9j8J/Ci3igju9eIklIB+zA4VfqfWtoU3IqMGzzjRfCmr+IXAsbRmjzzI3Cj8a9C0j4R2duVl1i7MpHJij4H516rb2lpbW6w28SRxqMBUGAKYNPj3MSzMW9T0rpp06cdzohGC+I5ceXpNqbXRbJIEA+8F5Nc/L4e1fV5nknZz6FjXpUVnHEMbd3uamEf0r0aeNVFWpxXqenRzL6sv3MVfueTw+BNQZzuUKM9c1vaX4CihcPctuI7Cu72Uuz0p1M0ryVloXWzzFVFa9vQoW+m29tGFjQACrSwgdBUwUDmqt5qNtYxs00iggZC55NcPNOb7s8vmnUl3bJH8uJC7kKoHJNcp4g8Z2+mxYgPzMCVLDhxj+E1zfi7xmJPMtoyzq4+VBlDEfc9/pXnE9zNcMPMkdwowu5s7R7V1QoqCvPfsfVZVw86qVXEbdjT1fXJtVvGmcjnjOMEj3rL3k88VFu9cU5SuTuz7Vsql2fZ06UKUVGCskWYgNmQVB7AnNTwwkANtOOc56VXQhcbD83TGKsxucncxBA45rrp2M536FtUCyb5A2CMgjvWutrDMhkjRicggKcflnvWEkjfIWDYGejdfpWjb3TpAT5ro4PXPNdS8jgrwm7NM1YYFwihCRnscj8qsrbJMh3IuQwz5YwTjvVO2ndkRmc4XqxHGKsW9wI5lETv6Nt6YNDTPOqKd3bcuQWUe14mUk7v4jz9aYluUnCiMEEdzzVuOXZtwNy5+Yr/9epS0cp3qwODjmo5mcftJpu5D9nZskq3B7HtVmMJgKeoNSQ/upMDBU9QTmnPGhkPlZAPqe9Zud9DCVRt2YXEMOq6VeaNOgVJ4yEPv2rwCexlsruW2mGJImKsPpX0BgpPESckGvI/Gln9n8WXgHRyHH415OYU0kpo8PNKSVqi6nMGPNPjTaeauJb5waJIdo6V4zZ441SoAqVJQpqqQc08LxRYRqxXS461P5qtWIH29DThcMO5qeULm9Zsp1rRsH/mK2f8A6UR19LV8taRMX8QaID/0FLP/ANHpX1LXTRVom1PYKy9c8Q6X4bs/teq3Dwwc/MsLyYAGScICcAc5rUrlPiRqdjp3w/11b28ht2utPuIIBK4XzJDE2FXPUn0rY0NfUvEOl6Ra29xeXLKtyQIEjieSSU4z8qICx454HFMfxRosehxayb9DYSsEjkRWYuxO3aFA3FsgjaBnIPHFcg2v6QuteF/EDahbyaNFY3Nk94rhooJ28kgMw4UkIw5+nes63cWqab4juEdNE/4SW7vN7oQEhkikjjmI7KXO7J7ODQB6TpWsWGt2hutPn82NXMbgoyMjjqrKwDKRxwQDzXL/ABaBb4dXoHU3NoP/ACZjqx4Pmj1HXfE2sWZ36beXUIt5gPlmKQqruvqM/LnodtYfxW0u8j8JX18dd1B4PtVqRYskHkjNxGAMiPfx1+929OKAPJ/KlU/dI+lSbTnMpP0FOErd+aR23p05pBdoeI4sA78e1QyhwSQRt9qiDHNSpJt7cHrSsPmY1ZiBik346nmnyxhTvHKnpSAKcZ4+tJ2TNI3krXGGZkIxn601nkc4DVZNs3BKnB5BqMREMQRge9LmT3FytbMiy68EnNLvY/xHNTEIvVhVZz83ynj1oSTE5SW5IFLdackTSyBEyWJAApgOOM811Pg/RG1S8MzA+TH146mhQu7F+0sh+n+CTehTLK6jHzEDIzW5d/DjSLmwt1WIq8XLOrYZwa7OGzWAYjQKABwBipgcMRtJHTrXSopbHPKcnueQ33wsnQvJY3XmIPuxv1I+tVIfhlqX2QzCVFnHIg7/AJ9K9saGNlyVX6mq8isCpjWMj1o5UCkzjPDEPiLRNO8m7/0iJs+XGzfMh9M+ldTpepfbUZZIwkqnBXOasgKWDE4HXOc81nQILfXWePb+9TLCk7oNGak21YyXcA+pGcVxurm7055Ggt0mQ/xhs4/CuzuHiKcsFbse1YV+xJcOqq55BPRqbEkctD4nnhx58KlAAML2raW8FzaC9ui0Nn/BH/FL/wDWrkobRDd3FzdkpZW7Zb/bPZRSzatNqcm9vlReEjHRV7VyzruC1O2hhVUl5Glf6tJeAIP3cK8LGPSsqVwO/wCFQXV0sEJJwGxxWdG1xGwuSpkU/fVeSBXG1KfvM9VOFK0UaIYtkjpUU0qRpyR7k1RuNYtoGOHyx/hFY1xqL3kny5256VMaM5vXRDqYqnTWmrN/7crOEQbiewrX0/TLm9I+QjPIBpuh6NFbGK5lkVyOSld1ZXFnLLthKhtvbiuqlh4I4KuNm9jKHhgMlv67sv7Cti10VICrbQNnQVorwFHGO9SbtwLdB2rrUUtjglUlLc8x8cahdPqa2pkMVtGOg7n1qvFf2uoaeLaNNxVcEv1NaPjvR55ZY5Y+TIcHPb0/rWHa6TaxW2Wk2yL1bNcteST1N6SbWhzkoexupIdx2Z4z3qKYgMHA688dDW1LCjIrMyTIz7QwqlJZr8yx5/3T2rSM0yZR6HXeCNTkuGZJbhtyfwKvJFegxyJKo2mvGfD94+l6osqMAc7WzXrNtdpdWyNE4EnUY710RaZhOL3L/I4pdpUZIoXOwGQbWPUVFK/lEYbINUZEvPoaCcdj+VVftWOTzjvUf9odc5ouhXLhkx3FV3vAhwMtVWS6LdCMe1Q+Zn0pXHcvi/Q8cj604XaN0YVls3503ccUuYLmx56+vNS+ECD421wjvp1l/wCjLmsQO+PvEVp+Bc/8JjruTk/YLLvn+O5pSd0OO56FRRRUGgUUUUAZMXibSZtfOhpcudRCs/lGCQAhcbsOV2nG5eAe9RSeL9Ci1j+ynvwLrzRAf3TmMSkZEZkxsDnI+UnPPSub17xPoVp8UdAiuNXsopLa1vYp1eZQY3c25RW54JwcDvisO6uoU8K6v4TYn/hIrjWZGittp8yTfd+akw/2AhDbug2+ooA9A1LxdoWk6gbG9vxFOoUyYidkiDHCmR1BWPPbcRW3Xl+rahZ6TF490rUs/wBoaq7PYwlCXvEktkjRYx/Fh1ZSB06nivQ9Ptp4dDtbWaVluEtkjeRcEhgoBIzkdaAPI/jqpbVfDYH/ADxu/wCcFeWL5i8816H8XtOu9N1bQftOtX2pb4Lrb9rSFfLwYc48uNOue+eg6V5/v6E80mYz3GKF3fMTmpwUQdfwqvN0DCog5PFS43JUrDm3ByfWnCb93txzQrBvlP51GylWxjmqaT0YIdn0OaVZOcc4qWMA4wOT2pzW4yQylW/Woc1sw5SudzdOBSh2HFWIYRyenvUdx5Ww4PzeopXTdg1ImmbbjJqAnjOaTJzzUUjg1oo2GM+eV9q5ya67wv8ADy/12ZZJgYbYkEt3Ye1X/h14Jk12b+0LlStnG2BkY3H2r3S0s4bGBIoUCqoxgCq2NYRueXah8GLN5Q1leSxIVwVbDbT6/SuT1H4X67Y3CC3VLqORgodOCv1B7e9fQgOD2pshXGSKdzT2dzm/Cnh9PDujwWAbc6/PK3q56/hXR5IH8qiHXPrUmfSm0dHLZWHr+tKajVvmxQ74BPT3pWFy3Y4nYMmsfUtdS2fyIF825b7qDoPc+gqjq+vEFrezO+XoWzwtcndX4t1dIW3TP/rJT1PsK3hS6s9nBZY6nvTXy/zNO81IxSMxkE1033pOyeyiseSYuxZmyT1Jqp5vcnmoJJ+2a3sfSUcKqasi20w7VC0ue9VDMeeajaekdapJFppsGm/aKomXcetJ5o9aC+VF7z/ekMxqiZx60huB60xWSL/nsKT7Sc9azjcZ6GmGUnvRcVka/wBrPanpelTgmsYTYGd1H2lR1YfnRzITjDqdHFfcjJrShuAwyD+Vccl0M/K1adpekEfNVaMwqYdSV4nWRTBuM/jVuNsmsCC4DAEHmti3mBUZPNTJHlV6XKa0TbcD1rRtzwPasaGTa2Ox6VrW7fLxWEjyMRGyOR+KtwIvC0EXea5HHsAa8ayMZr0T4s6oJtQs9OUjECGRvq1ecAmuWW58/Xd5skWRgakWXpkVEOelPC81LMSwsgYYqVevGRVdQcirEcbSMF3YqG0B9AfCoBfAFqAcgXd4B/4Ey12dcR8JMf8ACubHByPtF3g/9vMldvWq2OgKKKKYDZJFijaRzhEBZj6AVl6T4m0jXIbuawui8do2ycyxPF5Z2hud4HG0g56YNarMqKWYgKoySewryY6zpviIfEfTdF1S0ur7UY/9DigmVmnAso1O3B55BX60Aeg6R4r0XXbhrfTrwyyiPzVV4Xj3x5xvTeo3rnHzLkcjmm2Pi/QtS1MafaX4kuGLiP8AdOqSlPvCNyArkc52k4xXKpqdl4o8R+H/APhH5Q5sbG5+0sikfZd8aokb/wB1t2Dt6/ITis7R721v9H8CaBZgjV9LuIWvrYKQ9oIoXSUyf3QScDP3t3GaAPVq+ZviMD/ws7xDj/ntD/6TxV9HajZz31oYbfULmwkJB8+2WMuPb94rL+lfNXjW2ls/iBr0E97PeyJNFm4nCB3/AHER5CKq8dOAOlTPYmWxiAtjFJgd6cWqtNLsNY7kXJHYAVBvwah87cad94VolYLkjSZFQu5HSlAOelSCLcKV7DZVaRjSKrE5qybfmpVRVXms5SIZArFamEue9QTMB0qFJCDUctxIv54rT0PQ77xBqKWVjGXdjyeyj1NZNvvuJUhjBZ3IVQO5NfTHgPwlF4Y0SMMoN7MoaZ8dD6fhWlOnfVmkVcPB3gbT/CtqGVFlvmH7y4I5+g9BXSvCjZBX61NzRgHtXSnbY2TtsUvsGZM+YwX0BqdIHR/9Ydo7VPgDpigVTm2N1JPcTB9adRRUEBTWdY13MQAO5qlqOq22mwGWZuPQcn8q888R+NJrmMxW7+XDzkqwJZfX2ropYeVTXZHfg8urYqS5Vp3On1nxna2eYbUiWQ/8tMZROcZNeX674lkupnSO4eUhj+9zwQeoA9Kw77UnnYIjEqo2l/4n+tUS1dKnTpaQPvMuySjhUpNXY+WUyMWJJPuajJ4ppOTRmsHNy3Pd0WiHZoB65pm6gHrzU8wXROjkc1ZibDAqDk+lUlYKexqRHAPWuyhUtuyJK5dSR0PA9QKsx3skYbayHdkHK5rNS4KKQDg0M5I4+mRXWqytozF0lLdGxbaksUiuzMw3cr0FXnvGkQsr/Jn5TjB+lcwr7XzlhU6TqjYDnBOQxq4V11MamFi3dHU22rGSMhhlyMHAxn8KuWmoCOTazBkbnucVyy3gGUbAOfvjrVpJWx8r8ZGcDP510RlGWhw1MJF30tc7VJVOJPNJVup6jNW0KyLnG0g1y+mamwJidgVzit22kzKjxtlT97NROm0ePXoSptpmrbxh5grH5T0NeV+PBnxZMD/CqgV63DsaTAbn0rx7xtK3/CWXQbqMD9K8XMHeB87mUrwRlRjApJCDVd5ygqtLd5HWvEaueI2PmIXkVWNwV6003G7vTWUPTQrgbkE1Ikm6oPIOamjiIobQrmronPiPRP8AsKWf/o9K+rK+VdFjK+IdEJ/6Cln/AOj0r6qrei/dOil8IUUUVsaBRRRQAVxPxZ/5J1e/9fNp/wClMddtXE/Fo4+HV6f+nm0/9KY6APFTxSg/KRSZ3daY744FAkI688Uozikzk8mpMLtyDn2o5kPlYByFxnj0pxbjIPHpUQO0Hjk9KYSahN9SpJLYeZX6bj+dRkknLHJpN1Ay30pkiZ5pRg04iP1/KkBXPApcxSj3HJGCwyeK9f8ABWLbSUiSMKD82T1PvXlNjF511GhBIJ5Ar13RZ18hHTCxRjZjHU1rS11ZNRJbHRcEjPJprMoY5AwOPxpy9s96Pk3dutamRDJGJVAPJ/Ok8pIzlsD0FSyusSMw6/SqZLIN64kmboD2FAy0qRkYI6+tQSWSCQ3EaDzAMFh1IpgS54eSULjqqd6dJqEcKhZCU9zSYFeVDLD5arvXPO87fwrKu44xbzQOWQIu5C/8B9j3FWJ9asoXZpLtSDxhuPyrmtc1AbBDDKzrJzknPFY1aihG504ei6k1Ex72RbnZCP8AUR8gdmbuTVGWVIkJ6CpnKquCQBWTqMqLGXYsR0X0rzVepLU9ySjRp+6RhTf3OZD8q9cnoKqX17bWgkFoXDpwSp4FU5LtyvkRH5m+8RVeZUigkgRt0jrk/hXcqa6nlyru2hTeVrmXzJCXY9amt1O5tsZwcfhVW3OHVhjOelagYxu5JBTjirlpsc8dXdm1p9lqt1FhNwiPdjj8q1I7bU9PuI5fPztPUH+dYlh4qlskKjEiAnhhjHsK0bzxdZ3FvGipJG5Zd2egHeuV+1UtFobr2bW56jplxJf2kUzFQyj5gDWmnQDHB5rzbwdq5dmgEp3q5xzwynpXpSPuQDHI612Qd0ck1ZnI+Mrs2sDXUm4RxDoO5PFeQahqF3fR7pFYRKcgDgKD/jXrfxJt3n8PsUHAkUn6CvObOK4OjyLb26TJvSWdyuSu3OF+nOaTjHm5mUm+WyM+1LxyJEnzIzg4z3rtNS0Mi0huLdG5GJAvGxq5rSbCW41S2jwPNkmDH2FezW+ibrO5d1zuB+QdPY1xV58tRKJvBe7qeNW7Fr4rtCsPX1rrNM1FrSLDFhg5PoKyZre2h1PzEjOxycZ6A96tSOTasA2QcYxW8ZdUFtGmdIPFLMAF2qPU8mkfXI5eDL/47XKn5IQQDj+VWJIliALSqSRnCmtPaM53BG+NWgB/1px6AGo31aM8gMa5x76CPPBLDtUa6jIRyqgemKXOxciOhGr/AOyRUg1NTj5yP+A1zgvmbsn41Kty7dHhH1ouxcqOmGqw4AO4nvxS/wBqWw6s2PpXPAzuMh4PwFLsuGOC6D/gNO7FZG+dYtgQAGIPet74eXMd14u8QSR5wLKyHP8Av3FcF5U27HmJ/wB8V2HwqVk8S+IQzBj9ks+QMfx3FCbHZHqlFFFUAUUUUAFFFFABRRRQB4v8dP8AkK+HP+uF3/6FBXlRPavU/jscar4b94bv+cFeV8d6RjU3Fc5THtVcdfanO+SR2pVC5yaa0IsO5wMVM+AFJPTjNRNgAAc0sjjy1UfjUy1Y0KzBenNIZ3HRj+dQknpTCcUWAkLn1P51GTz1pwGTljgUrmOi9gsREZBNP0+wk1HUYbSIbpJXCj8ajduOBgV6X8JNDEt3caxMp2wjZFkdSetXEuMbuyPVtEsE0nSLWwiUKsMYU47nua0M1CpOee/tUlVY7lTUdBd3HWo5MnFPGOlV7mTy0yOvQU0tS4Ru9B3TqfpTwTxjrVBWlL4UbpB1JPAqwMQBnkfJxzzwKpxNpQsTEiNCS2O5Jrl9Y1lpt0Fu+yJeHl/pSazrazIyI+2DoW7t7CuOvL/zjtUbUHRR0ranTtqz2Muy1yfPNE95fBgIocqg6t3b61ms4HNRSTe9VZJ+uTWp9NTpRgrIsSTgDg1AZB1qlNdomSTVCXUsj5W4qXJImdenT3ZqyXAXvVV7teetY8uoJtyZBn61ENSh7uPwNQ5nJPMad7XSNg3TE8U3znPesc6vCvQ5po1mM+1RzHO8yoXs5mz5jHvRv9WrDbV1JwGpv28v/HRzkPNKHR3N03CxjJaqV5rC28ZPJY/dUd6y5LvaOTms+Rnnl3N17e1LmZ5+Nzpwjy0tyebVLy5PMhRSei8VasbS5upUG52PbmprLTA2xFG+c/M2OiL7+9dv4e01bdhIQuSBlsdPpXLXrqmvM8SnLEYmV5yZjyaNdWcKO4Klhnk+1WrOZioyea6i/sWNq8xhlmQDknnj2FcxEu1iCpX6ingq0qlz6bJozhKUea6Ne2uSpAzWxa3ZJHPFc2jHIrUtnIxXpntVqakjq7acFRzW3byokLM5wANxPoBXL2bbcH1qn431/wDsnwuYIm23V9+7XH8KfxH+n41z1NEfMZjanFyZ5r4m1U6v4ivb0fceQhP90cCstcmmA8c09TXIz5KTu7smRRnJJxVkMM8DiqyE+oqYFuoYfgKhiLCkAdORUkM5EoOPbpVRdxP3qmjVjyW6elQ4rqB7/wDCP/km9jj/AJ+Lv/0okrt64f4Rf8k2sP8Arvdf+lEldxWy2OhBRRRTAKKKKACiiigAr5n+Ixx8TPEX/XaH/wBJ4q+mK+ZPiOf+Ln+IR/02h/8ASeKonsTLY5vJNVrgZqweFqs+SaiJBXReasItCgCnggGqbBDlXBoMgQcVHJLVOWU+tTa4Nlp7j3qLzie9UvMYmpoyO5qZRIY4ksaXZmlytG6kCO7+E2iDUvGEVxKm6C0BkOf73avpNW3DpgV478HLdbbRbq7IG+WTaDjsK9Ut71W+Q4312qm+RM64UXyKSNCimCQEdaXeoGcjFRYmzHYoqhdatBbMELZOcE9h9a57UPFM+WjsYfMKvtMrHC1tTw9SeyOmjg6tV+6jrJbiOJSXcDAz1rkNY8YpaKYoXLShuTtyDn6Vyepa/cIZHluUaUMcq4z+Ax2rjNR1X7XIT5axnuFPGfYdq7I4aFL3qjufSZdw/wA0uarqjb1TXWS7WSVjJMCd8ZYnaecEN/hXLz3ElxJvkYsegJ9KhL7jknJpM1FSu5aLY+xw+Gp0FpuKaaTTS6jqaglvIYhlpFH1NczZtOpGOrZZ4ppNZcuuWcfWZfwNVJfE1mv3WLfQVLmjhqZphKfxVF95unmk5rn/APhKrXH3Xz9KT/hK7f8A55tUXRzvOsD/AM/EdFk96XPvXPr4ptCPmDA/SpY/ENnIf9Zg+9VzpGkc2wcvhqL7zb3d80vmnpzWfHfQyjKyA/Q1OJQRwaaq9jrjXjJXiyy02OKQOdxB5quDk07dzTdRvUpTuX4JHPyj+Lj61dhuGjzhiCOD3rLibj+VW4n6IRk9Qa7cPUdkVKPMjbs5mOGBPXk45resb3ZljkuDxXN2k44VhjB7VsWw3zlgARXt07ShqeViqad7o67T7gvOpY5Y815P48mX/hL7sg+mfyr0/SgGvVVsAAV5D48mB8XXu3oGArw80SSsj4nOYpJWMl7gEYzVCeQ54qNpSTTGYnrXhpHzzJInJPNaELLisxOtXIicUpCL4YU7zVWqnz+tJhzUWEbWjTh/Eehr66pZ/wDo9K+q6+S9BRh4p0Inp/alp/6PSvrSumirROilsFFFFamgUUUUAFcT8WlLfDq9VQSTc2gAHf8A0mOu2ri/isxT4fXbqcFbqzIP/bzFQB42mnai4+Sybj+8P8aQ6NqhPNqcfUf41a/ta67zye3zU3+2LnOPOfPuayfmWpPoVm0jUI1y1o/4EGqnlXCsR5TAjrkYrZ/tu5HVs/WqU9/NKSzNz7DFNcoNyKZWbpsbP0pNkp6oR+FWotTuMANgYHUmpv7QYY3Efgad0TqZhV++fypvI6/rWq92JVCtg/lVclCcFR+IqedIdmUhTlUY689qvBIzx5Y/CnAQYxtGfehSuFrbkmjP5c74Tc7DCnsPU16hoxCafAgxuLdq8yhKwfMgxyM16F4enSeBY0cbgMk+ldEHbQh6nWq55NO9Wx8x4AqqsmwlQAQo5qSSVtqY+UngCtDMkZUJ+Y5xzis/ULxbKPztwjU9TjJarRxjZ2Xr71554z1g3t2thA4PlnnnABpSdlcqKuy7c+J5ru5KwO0aA9VOc1U1DxHKLZreYq5P8Q6gVysFte2MvnxvuC8sg7ijVLqORVlTPzL0Nc7mzdQRTudRdsqWOM9TWkl8JWDl8qFAH5VzFwC8ZkJ2qDxk9aLW7ljTBUsnbFY1YOa0OvDVlTlqdU8yzHGDisTW3/fQqv3QOMUo1LbGQVYY5xjrVK+ulmVOCHXvWdCnKM7tHRiq8J07JkBG3Kw8t3JqNkWGGSRjukYEc02BwkjSEtvPARe/1ptws7snmIVDfdU8ZrtPMuVrdRuB5DE9hU8khMShTznkfpWloun+fqBhfAZVyxB7elalz4U4822csO6Hr+dYzrQUrMtU5ct0YlrcRaXC0jxQzzMhEYYZEZPcjufTtVOO1NzMzksV5JYjAyBmte50p9o3Rnft2kZ+YEd6rOb6K3is5GYwKxZYxxlj1/lWqaa3M2mJpeoT6ZfRyo5GxuR6ivd9B1EalZrcqRh0Brw+LS5XhywIOSWJ6CvWPAcJh0ZFf73T8KIyTegSi0tTpNSsI72z8mRQynI5rzLRNLmsrvUrW7XYI/lGe49foRXq/LgoDgA9a4PxrbXNnrFlfQOVjlPkyjHH+etZ4mDlTdiqErS1LvhnRdNN6ZI4VWTor57f0rsdUu49PsmAbDMMKK53SMWiJJGoYHgkdqr6zdSMpQn5WyN2ck140ar17nc6d5eR57fW01vflZA6RNJuXB4YHOTWjBIsjbEUbCeB3JqXxHAsVpE/mFmToCfX0qtowjJDTq7J2KnpXqUXzRuYVNHY09XFvZaasYVfNkIPXp9axLSa35MyLgdMmna5LCpHksQvTaTmueacluT8vpWj3Od9jpzdWHJ2R/pR9rshwIk/KuZE+D92gznsDTuRY6I6jaowIt0J9cU9dVtz/wAuyflXL+c2aPOOeh/Oi7CyOtTVbbH+pVT7AVeF1bhAzKo+tcL5repp/wBoYYySR70XYrI7T+1LXOBsJHoK6n4YzJP4o8QOmMfY7Mcf79xXlEV8YwQRwa9H+DMwn1zxEw/59rMf+PT003cdkj1+iiirEFFFFABRRRQAUUUUAeLfHVC+r+GgFLHybvgfWGvM/sk8iEIiqPUnmvTvjkxXV/DhH/PC77/7UFeYicr0Y1lPmvoZSauMGmXBz9wj1BqC4tpoOXQgdM9qvx3J6hufSppJt8JU4P1rNVJJ6hZMwwSBnrQGJp08flPxkAntQp3dsV0X6kDcMaNp96nQgHmnlVbmoc7AkUiccGk9qt+WpJ/rSGNVGSKOdDsVHHQCvobwNYLYeENPiCbS8fmv6knmvAoYxNewR9mcL+Zr6ZsoxDbRRKAFRFUD6Ct4bHRhleVyz/FT880z3przogOSOKs7rX2JBnNMcIfvfNjtURneXhBtHrVW+1K306EtI4Ldh3JoSdy4UpOVluTzzx2qO8rhIwM1yOp68bvcc7LUfdAODJ/9aqWr6pNdMZLo+XGD8sOfvfWuaubp5pCzNx29q6IwUdWfRYHLUvfnuWL2/e4cknC9l9KzJbpUB5qteXqxggHmuX1HWG3GOM5bv7USnY9LEYylhIXkb1zqsMQJZx9KybjXlYkICR61zrStI2WYsfrQMnrWLlJny+K4hrTdqasi3NqVxK+c4HpVZnd8lmJ9qUKT0GKnisppIzJGhYDrgZxRe254k69as/ek2VNtLt/KpWiIzkEYPpXVeB9Di1++uLKQDmPg9x7/AJ4pNpK5kk27HIbDnoaCmPrXrmo/CwaVps16JTL5KZ24+8cdfzry2aILOynoD1oi09hO6KoT8hTwKtxW008gjiiZm/ugdKdcafPaECZNpPQGjmV7ByytfoVQM1LEu1wQOabtx1pyll5BI+hpMSOz0GyeS0VbqQQQk5EaD55D6nvXoOkWcMUa+TEvHeR+a8c01JJbpEF00W70bk+1elaWnkRhWi3jHV3/APr14uLi1LVnu4X3qeiNLxbfFNMNsLgFpDgpGeQK4aAbRjkknrnrW5rFyGYBYoI0xjldxP41iL94k16GXpqB9DlkOVNlyLlxmtJCAAKzYMDk8mr9urSOMd69RM9idkrs27SRdheVwkUY3Mx6AV5l4m1v+3tae4QkW8Y8uFf9kd/xq/4r8RCVTpNk/wC6U/v5FP3z/dHtXLoAK5as7uyPgM4xqrVPZw2RIMAUqtjoKYTQDWB4hZV+nAqYNuIHrVMGnhiO9TYRfARepqe3ZWPSs0Pyc9atw3KhNrcVnKLsNH0D8I/+ScWP/Xxd/wDpTJXb1w/whO74a6eR0M90f/JiSu4rZbHQFFFFMAooooAKKKKACvmb4iLn4n+ITj/ltD/6TxV9M180fENsfE3xF/12h/8ASeKoqfCTLY5t4yRURgNStLjvSCUEVz3ZCZSlBQ1AZDVq5O7pWech61i7iJCxao2iLVPGmanCjHNJysIzGiIoUNV+RBUaxip5xESIT2pWUirOFApDtJpJiPcPhgwHhCPAxhzmura4ZZ/lOOK4r4Wzh/Drwg8pIa6642K2Swyozivew6TgvQ+gwiTpr0LbX8xQojgdOc1Xub+SNSpuBGoH3T1b3rGl1GRJ0RecegrAvtQ8wtO/ZiuSecn0FdkcMt2erQy/nlsbNzq0GCysxcjLSMeQR049a5C/8QTGLyVmZiC3+sUcZqnqOpN9yMbcDDEd65+aYsc569ayr1o0laJ9FhcBTpLmkrlqa6L8liWPXJqq0vqarmTHU1Su79LeMszAAV5VSs5as66uKjSjd6I0JLtI1JZgAPWsa88TQwkrFmRvbpXOX+pzXjkBisfYVQrLmbPkcdxLVk3DD6Lua1z4hvJwQpCA+lZrzyyZ3yM2fU1GBk4q9a6VdXj7Iky3UA96ltLVnztXE4jES9+TbKNFaN7ot9YqGmhYLjOcVn4NNNPVHPKLi7NAoywFbUOgXE0e8IcVv/D7wevia53dRE/zCvatQ8DwaXoU8wQZWI9u+K0hBN6ibsj5guEEczIP4Tioq1NUtFgvp0HO1j/9eo7fSLy6QvFA5UDriipDkeoRvLYpJLJGco5H0NaFpq9xGwVnyPeq1zp9xaY86MpnoDVYgis2rm9HEVaErwbR10Gqk43/AJ1qxXSOByK4COd043HFamm3cjHBckis3eJ9RgM8lKShPqdvFKhGc1N528gjt6VhQXJIFX4ZSepraFZ2sfV0cSpo3LObb611GjYcgnPPvXFQPlhzXXaTKnlgAHPrX0GAqucOUzx0b07o6a3cC7ZweFHWvFvEVytzr97JnOZDzXq19drpmiXd2xA2ocZPevC3uGlleRjyxLGvOzeSuoI+Azya5owRYwpprYFQ+bgVE8pJrxbHzxaRwDVyFxxWQsnNWEmI6UmibG5EA1WFRKxI7ph3qwl5jBJrNxYWOi0lFHiHRCP+gpZ/+j0r6mr5M0G8EvifQkz11S0/9HpX1nXRQTUdTopbBRRRWxoFFFFABXEfFs7fhzfH0uLQ/wDkzHXb1xHxc5+HF9/18Wn/AKUR0AeJy3AYYBxUKsScD+dEq/N0xURBxweajcNidi4/iFNMh6HBqA7s/eNHJOaVh3J9wIHGKXBYZxUPzYpd7qAM0ASHgZxTTIRyBTfOb1pDM1AiVZxn5v0p7PH/AM9D+NVi59aZt3HPP500kFy9HcsqmNiSrdD6V1vg+d3vAASAF5+tcVHGV7knsPSt3Q7x7PUFZARuGGrRaCW567boZeWPyg4+tOkmZrgbcEIP1qLTwTZo0kmMjoD0pRkDYihixzWpIy/nWz0+WaV9gwWJryS81MapqZSJAEBJG3rj6123xAvxDp0dqHIL5JNec6N+7uHYuOBxisas+hrTj1NATzRlldtwAwMjkVkXxDNv5AJ5+tal3cRlsN8pP8VY0zoysFOQDmsF3NmUZmH3nOfRagUM5zwO9JIdz47Cpl3SFUjTrwPetkjK9waRjhSxY0bDjDcLVjyY7dS0hBk9M9KotM00hCjOelNA/M09KtBJcJtUkFsFvarviOOGS4RYONo+bj+VS6WvkphWE10wxtHSMf0qvqcLxHdM4yTkjvUt6lpaFeKaSyvoLqIgsB8w7GvQbOSO8tUnhyocZIBrz+zhF2HjyOckEdq3tEmkWy8gu5EZI2iuKvG50U2dHLZwSjMhRmHY81z/APY5F9K0g6uAhB7VsW8hRWZlIQd8dau2fl3U27b7ZNYRlJaGlluJDpdvFZ+VImZG5U+npW74eVrW3KNgHPasoh5rwKhOOn0ArWhZ4pBxknA+lbYJtyb6GWJSsjoUJ6/pUF/p1tqUaR3SBwjb1GTwaW0lJG1m3N61Ow+YN6V6jV1Y4E7O5z8dtJaSlYwFXoyY4+tZGtTGS48pT9zoBxXaPEso5HPrWVqNgjhnKLlATuIryqmDaleJ3wxCe55d4hvTOgjLjCsF4GO1XfDlubq3ZQT1zkdRVXV9MlaOR0BfdKwC46Y9KZ4cuLu1MgjQsMfMp4P4V1042SMqjbbI/EUXkTgJLu9QeorBySea0tVuWubx2dicHoe1UNuRwD+VaJXMJMbSgUhYA4IIo3e1IQ7bQcCmjcxwFNIY5O6tRoGo7IpKTaR2OaQkjigBc16d8Dv+Qx4k/wCuFp/6FPXmA5Fen/A7/kMeI/8Arhaf+hT00B7NRRRVAFFFFABRRRQAUUUUAeLfHQgav4az08m7/wDQoK8od8nAr1f46/8AIX8Nf9cbv+cFeSMOelS9zGe5NG5zgDinNI4Iw31FVuR0NNyR3NTyq5NyZ33HBxTfpUYzS80wJCtN6UhkOaQyn2/KlqApkbPNKJC3BNRmTNJvNOwAz+XIro/zKcivobwxraa7odrdxHE3lhZo+4ccf/Xr54htpLq6jhiBaSRgqgepr6H8JeFo9C0aJZG3XTIPMfPQ+lbQ0R0UJOMrmwVnJHOPxpjRRxKXnkAHuajk+2FmCSrs/vGsfUr6xtc+fM1xKP4c1sk2e5SpSqNKP4Fu41aScmOxXCjgyvwB9K5nU9Wt7RmKv9oujwZG6D6VQ1LXJp1KBhHF2RO9c7LKXJPTNaqKifQYXLlDWWn9dWT3F5JcyF5G3Gs65uiqnnFEs6op5rC1HUFQH5qmUjrxFeFGHYp6pfOWKK3J/SsNmyTj86kuJjKxY96iQZYVmfn2OxUsRVcm9OhIinrUyLmmquSABWxYaNLcfMSEHqxxSbUVdnLGLk7JFW2tmldQq5zxjNepeFtIhg0797GDu7muK0tYYb+OCeMMjNjcD0r0m3ZVhCxMCgGOe9eLmmIfKoRPeyzC8t5vc8/8XaRFY6n5kSgQzA8L2NJ8O746b40smP3Jn8pvof8A6+K0fGtykhigXG7OeO1WPAfhaa/uY9RKsvlXKbOOuDk114OpKVBc5xY2nGFdqJ7R4mijbwzfh32KISc18uygPdNsGVB4zX094ut2ufC95bjPzx4OK+Z2Q2mpoky4AkGQfSuqLtFnHy80kj0bwvokVnpyTSoPPl+ZiRmo/FOiW8tm84wrqDk+tblhOj2SFSAoHFYOt3wncwrGZOuUX+tfN0q1WeJ5r9T6idCEcO4taWPNZU2Pjniox14q3qCulw25NnJwAMYqlnB9a+oWqufJPRl2xMa3ILxeYB+lej6Zfi3shIhPlcYJO5R/hXl8UpilV1OCPSu80C7Ese6P+LiRR398d64cXS5rM9TAVUk4sdq11NPcMHij9QUUEfnVFTzitK8sGkV5Fj2uScBSdpHsOx9qymj+zfNM21R1JNdOFSjCyPqcJNwjzX0NK1jaVwq8k9KzfEHiBbWNtP06QGUjE0y9v9kf41m6h4glaJrayykbcNIPvMPQelYYT6mtp1L6I8XN869r+5oPTqwRalApAtOB7EViz5gXFKFoGey0oV2HANSAcClBFJ5belKEwKLoBaUGm81IqZpCPor4O/8AJMNN/wCu11/6USV3dcL8HePhjpo/6bXX/pRJXdVR0IKKKKBhRRRQAUUUUAFfMXxJfb8TvEX/AF2h/wDSeKvp2vmH4lj/AIud4i/66w/+k8VRU2JnschJMSaRZiBTHU5qJgwHFYpXMiwZSetMADGq24ino9VawF2MYpz9KrLNimvce9TYBZJCDUYmINQvNk0zfTsSWjMMcmoWnOeDURy1CwsaaSA9X+EGo7pry1Y8kBhXo+oEqGOTzXjPw0m+x+KYQxwJVKmvXtUcysFGQO9e7gPeivI+iyl80Uuxh38yWlmxz+9bgc1yVxOe5+Uc8npW1rk6KFSMlivVuvNchdTHaSepPrXdiKqpxufc4Kko0+ZkNzcfMccZqi8nOaSZ8nrVaWYKvJr56pVcpXY61a24lzciNSSa5K+vHupjydg6Crmp3+8mJD9TWRWa11PiM4zB1peyg9EFFFWrOxlu5AqLVRi5OyPCbtuWNJsTeXIBQsueRXsXhzQbaKKNSobgFGPUe1eaQW1hYod2qrHOP7p6H8K7fwXrk7uftU6yRp8qyKeG/wDr152b06kKTcWerlUoSqcvU7vVdBtb/T2ieJemB7V4FrujNpmqTW2OAcr9K+iJb5Wh3qRjbXinjOdLnXpTHzsAU/WvO4eq1J1pQfwnVm1NKipy3udD8B9RFr40bT5f9XdxHbn+8vNe9fEC9h07wXf3EzhFCYGe57CvCvhX4duh4s0vUUUhUnZX+m3Nd78d/tVxpVhbxFhAjNJKOzHoK+udK1WKPm+e8Wzw7S9PfxBrKx4+WV8tj+6K9x0/w9ZWlmkSQqAF9OteU+B50sdfjglADeWeT65r2pZ1FsGOMYr43iXEVYYlQWiPosrppUOdbtnn/i3wvbyQvOI2LdlUjJ/wFeO39mYJ2UgDHZTnH419A6vrlpDBIskkCtjA8wV41q6Pd3UkrShgTwFUAAfSvUyKdWtRaqLY5M4jGlOLWjZyhGKs2hAbg4btUtxaMnY/Uiq8OQ2MV6lSm46HDhqi50zoLe4bADDmtGCfkVk2ZDAK3I9a1orZsZU5rn5Wj7nAznOKa1NS2ky4rtNDRpFXnNcJbK6uMqa73QX+z2TTy/KiDJzXs5XUtzXPXxFS2HcmY3xL1QwWdvpcZ5k+d8eleapzW3r16+s6xPdN90thB7VkyQsgzivMxNX2tRyPyzG4j29aUxuKQx5pgk5xUqnNcz0OQb5YApu4CpmQkVC0RzSTAcHoLmmbCOlKEY0aAa3hVyfGnh8f9RS1/wDRyV9lV8b+FYyPGXh8/wDUUtP/AEclfZFbU9jelsFFFFWaBRRRQAVxPxa/5Jze/wDXzaf+lMddtXE/Fr/knV7/ANfNp/6Ux0mCPE5lAkYdgaZ5anpU065lYj1pqhl5rC5rYjMGeQahZCtWJXXjANM20KTBxRXx74pCpP8AEKldcLwAag2HniqTuS0GxuxFG0+lIFI7GlUsp707ishwTNP8sgA0zee9KJPwpXY1FFiJfUjPXmpLeVo59xJGRVfbuXjn6U9InU5YHgd6FMfItz0rwrq7X6/v2zsA2rXTyGRtu4hFY8KO9ed+GLlIJrd34yQpxXovO7zVXd2HtXRTldETjZnn3xJmQzwREdEJGOvPSuI0+VIndZXC7hwTXT/EKNl1SJXOWaPdx169K52DTVSHfKu4t91azna7uXC9lYSWR23oXDY6MDnNUrgeTFnH3u9XbiM265cKg9DWXMzMwXsOlTFalSdkQxoZJAg4ya0ISsIZ1HspqvbQtKxIOB3NXJf3aKqqPl/nTk9bExXUy7p2lnKA5P8AEajX5CAOtWrpkhRYowGkIy7epNOsbb9+rOM7fmP1q1sS9zf8OW80ZKNGdzfN8vXHvWlqOhXN48blQiZxjqTVTSJ7u1uRIjglj8wbnIru7VnuNO8+SJUOOAD1oUE3cpyaVjy8QvA7DaUKjAH4111lHZtZQzwxhXKANt9e+axvEUSG6Ux4DEYbHRRVGyvmglUqDkEBvSuWvSb2N6U11O1WMtAwYjaegxUukAJdFF5VQevTFMWCRowFIUEZ4p0K/YImCEs79OK4qcZX1N5NWNGPaJXkHGSAK2rfY2/oduBWDb7AqxuTlSC2atwXKvcMkbEL6+uK9GklCyOSo3I2lQxcoSM9RV9XDLkEHHUGsVbvJ2kkL2PWsnW/F9toiiJCJJ3H3ewPqa6rnNY60t82Og6g0Xke61dj025PFedx65qGoZkuLgRxOBiJOK2tC1uCzuTaXFwVWX7nmPkZ9KGrj2KTtbx6tPZXTeWkpEsLuMDdj1qDVLH7HOs4kUburdM+9Hie6ijmlhXDqoJTeNwGeo+n8q5W41V5LE26SNxgBXOcDuAaz0SsW23qVNaKvebwQWPDYqisrIuAAailyHyTnPPWtSwng8sBoUZh1yKycmtQSTMxt8hzjNHlOR6VryNH0WNVFUpQueW49KnmuVy2IAPL6Nn6UoaZumB9aYxOcKMUKSi5wT6mgB4Vv43pT5Y/gLH2qLzsDjIp63bKOx+ooDQd5UkoDRxHb04r0r4KI0eteIw4wTb2Z/8AHp684GoMoO1VGe1ej/BSUy614jYnJ+z2n/oU9VC9yXY9iooorUkKKKKACiiigAooooA8Y+OQzrHhv/rhefzhrybgnmvWvjh/yGfDX/XC8/nDXk+05rOW5lPcPLGOtNaGpBletMY7jUpskhIIpuOOtSlc9KYyn0qrhYjKk9xSbW60FT6UmDiqEGDS4pASKNxoA6HwXEr+L9OD9BIDXveqanDZW5JbPtmvm3Tb99O1KC7j6xOGx616lcakusWyXcMgeGQZzn7p9D71vSSb1PYyjD069XlmyxqniW4nysbGKPpgdTXOy3Ttnnr3ombLH0qq7AcV2Ky2PvqGHp0o2grDJH5JJqhcXKrkA9KmuGbHyKTWBeW15dPt3bF9Kzk2cuNxcqUbU4tvyIL/AFQLlVYMfQViPI8zFnP0Fa50VYgSSWb0rLnCpIUGPl9Kyt3PkMzeKcVKvpfoVn64p8S9T6VH1JqxEhIB/h9aR4lixA6w/Ow3e1RzXl7ePhXZUX04AFTADb6ipd4CqqpxjacelS1dq5cW0nZ2KwivraSR4ZvOWEB3ZTkAEgd/cgV3Gk+KVXTA0jEyAYCgc1ySqiQsiBgH4cn+IA8D6Vq6Dp817ewwwKjkuBtYZzz7VjXw1OtujrwuMq0LqOtzp/Dvhi/8WX7XsybYc4BPT6V7bpWkW2lW0UECYWMcUui6amlabFbqiqQo3bR3rQ96FFJWRnKbk3J7sbcRrNC0bDINeFfFbw2umXcF9Ah2ONpAHAr3c81y/jrw7/wkOhvChAljyy59aezuSux4tp/ixLXQ2hmYi4jHAx1rDtvEs0MskzxhnkbIOcEVBqWn/Zrp7XDGRCTKW9aLWfT4Vi+02XmPGrBkJwHJ6En/AD0qaeEoxbdtzeeOrySinsa99PZ63ZfaY/kuF+8K5h8qce9OjzEgaNsFs5ANNZt2SetbU4cqtc5a1T2kua2oobGM1vaJefZrqPe5WJzgsP4T61zQbnGa0rGXDKpGQeDTmroKcnF3R6XezixtX2Qm6ATcyLjzIj1DgfxL7jiude9sNf0loZQtve4G0Z2o5Hce/qPyq/b6pBcaL9nuTI19aDfazxNtcJ3A+ncVyN9JHNMHCoG7vGNob6r2NRFJG1XE1ZLlctCBoTDI0brtZTggjpTNvNPYEsTu3/7VNXg81LOJi8+lARj2rQiEJjyEB96GQY4GKy9oOxSWM9zipB8o45p5AHU5NMwWOOg9qL3AMOw6gfQU4RjuaUfKMAGl3Bf/ANVK4CYQdFyakSKRiGC8HvTRMAeQD9akW5IUICAB3pO4H0D8IBj4aaePSe6/9KJK7muG+D5z8M9OPrPdf+lEldzWy2N0FFFFMAooooAKKKKACvmP4lD/AIuX4i/67Q/+k8VfTlfMfxJ/5KZ4i/67Q/8ApPFWdX4SZ7HIhQTTnhG2kT71Su2FrnvqZozZk2mq5JBqxKcsagYcVpcQxpCKhaQnvRJ1qMiqQ7ChjmrEYzVXkVMkm2hoGi+kYIqdI1FZwucVKt171NmSkbml3X2HVLe4Q4KODXsmsXe61jmQja6Ag/UV4EJzkHNeraBqI1nwskbMDLbjafp2r18qqJVOVnvZFNKvyS6mfqM52jYxz3rnLmUYOTWveP8AeQjkVzd9I4ztU1pmFS8tD9CrS9lSK09wEySeKwr/AFMtlIj9TVi4hluWI3HA646Vm3ECwqcHPv615ag92fGZjjK001HRdykTk5NFFFM+aHIAW56VaN7IsBihyoP3mHU1VRSxx2rUtjFbOshjEgwVdD/EpGDW1OMnF8pDauri6VpVvd4lvrs20LHCsF3En6Uswl0PVJUsrsXMMbgeZHkK3px60xIo5BtW4kEYzhSnIq8ln9pgjhizGqncvfJ9SfWqVJVIcvL8y1N05cyZ19t4rnbSEVQTKy4APam6N4UutVk+03CnazZOerZGareGoL+fUYYJLNZg4IEie3cjvXvmh6LEi28QjCSW65UAcnP9KrD4Sjg03Bas0xWLq4prn2RN4C0MaXbSkpg4BU/UZ/8ArVp+LNAj1yyjVlBMbbiMfeHpW5bQiCIKBjvj0qUqDyRWUqrc+dGKirWPkLxRYXHh7xKAq/PEQcjpn0rp5vHKDRFKMPNYBQue9elfEfwANZjbUrdx5kfzeWQAASME8deK+e7rRpXu57ayVpY7VCXfHJ+nvWeMwNHHctSe6OnC4yphk4x6m9Y+J/CsEcg1y2utRunblkxtj57Z61q32geGdZsP7R8O3WFA+ZG6qfRl7VH5nwlh8N+TLY6g2piLn7wffjv2615/pVtqltE+qWAYwxtscA9vcVtBqE1GOi7IxqOVSLc9X3Lt1bNFI0UgCsD0zkH6VkvCon2j+KtS+1FZ0DPwTz9DWJJcbmVh2NdVblscdFSTubmnw7n2Z2v9M5rooLaeCNZWjLR/3l5BrE0+cExTxnEqYIPrXoVlqNg0AnhzbyNxIoGUJ91rNU1ufXZRmPImpOzQadpEN1GsyOCvX6VX8T6tFa6e2nW7fO3DYqC+12O3llW2VYGcfMUb5W98dq467aWWZpXk3E980sRjEqfs4K3cyzfPZV4OjD5kttFk1LcWjMvAqKymAcA10EflyIOleLObTPlTkZLJlbJFKIgorfu7cHpWNOm04FNTuBXY9hShM9aasbE1LtIFMByxrT1iBPAqDzdpqZbkYpaiNfw9Bs8V6C3/AFFLT/0clfXNfInh64EnizQV/wCopaf+jkr67roo35dTopfCFc94nS9gtp9SXxM+kWVtAWYLbROCwzyxcEkdBtXB9+a6GuW8R+GtV1rWrC9ttYtIbWzG9LK6sWnjM2TiU7ZUyQMAA5AOT1xjU1KH9r6/qreGdLMx0i/v9Pe+v5I4lZ4tgjBRFcEAlpOcg4C496qxeJNbu7ay0RbyOLVZdZn0yW/WFf8AVwo8pkVDlQ7IqjBBAJPHaug1Lw/qF9JpmoRarDb61Yo8f2lbQtDKrgb1MRfOCVUj58gjrVT/AIQny9JtY4NTdNWt759RGoNCG3zvuD7kyBsKuy7QRgY54zQBa8MahfvqGtaNqV19sm02eMJdGNUaWOSMOu4KAu4EsOAAcDgVzXxS16xl8LXelGLURL9rtFZzp84i4uIycSlNnT/a5PFdfoGhyaQb65u7z7bqF/MJrmcReWpwoRVVMnaoVRxknqc81h/Ffn4e3eOv2q0/9KYqGB41MBw/UD04pu35cdhVgDOQRgemKRbZWfCkrXKbIqMnHSo2UAZJNXZYHUnIzioGXjp+VFx2K+C4JH603BU/dqYhQME9PWmgqOMkZouBCS2OFzTC5B+ZGH4VdAGOuaPLyMdfrSuOxSG1+cf407yTjIwfap/IOfl/I0CKTnCYxTv2FYq/Mp5BHsaeJm/iJq15qGMh49/pnjFLDY/a2bYhQAdScincDR0OTzb+2iGcCvWbbJsUKEhcV5Noe+y1eLgMclTmvVbIgW3lk5VOtdFLYzqHm3j4Sxa7BO2Cdnyj8axo7mUQGeVuOwHQVv8AxHiZr20df4lK5rBitVlt0LSBUXnHrUVfiLp7GReStKxmn3EfwqapIk91PsjUl26ACrtyVeR3Yny04QDvVjRgVlZvu8Z3f0oTshNXZettNcRpCEJlxgIg6nuazNRgls5/Kk+U4zjvzXVW0lzBayzIyoG58wjLY9FFVdJ0GTVJ5L25RzFyRnq5/wAKqC6ik+hy1tZNLKGI3O1bEFmVQkLznA9zWtpGjyPeyAoQxOB7DvWrcacp1WG2hBEcK5OPXvVkoxYbNomSJmO44Ln0rv8ATpYpLJIxjKjGD1NY0OlFizNwd2SasWYa3dpShODnOe1CdglqQalo8MzzSvFuOPlUDr71xV9p32eX922UyCwx0NeorJ5kGSPnJ6e1YurWcc8kUSoAGOWOKcopijKxi2epsj72bdGpAwPQ10SGKeGOcYKAg5rn57BobjYjeUrHLHtirWnSGKIwu3ySZ61lyJGrldXNFgWzIgJU8ZFMtXUzoiZDb/mq3bYeyEBCh4yBgUht4Q+8/K6HLYH60lDW4nPoaNyRHudBgkV49rss8WrTXDvHI6vkq4zke1errdGUtu+7jHIrmdS0G2vxIWjDE5PXBH0NaszRxA8RSlPnBWT0PSprK8mutVsxO5bzJk3D0XIqC60aKCUGOOXcD91z/wDWrqPCul20MguJ0DyseMjO36UXuPYs+Kpdt0sanEYPHqTiuQkkOWBPNbvil837gE7kx82e1c/I5dy3c9frUyExmc1LFkfMsgU+9QkUYqGJM14gPs+fPUyH36VWktpSchlY/WqOSKekzx/dYio5S+YsGCUHDbV+pqVlbGDPGM8cVVNy5+9g/hR54PVBmiwJlhrLKgmeM59OahNqy9wRTRKuTgEH60byQfnx9aNQ0A27L0INem/A9SuseIwf+eFp/wChT15h5r4Ar0/4IktrPiPPXyLT/wBCnqo3uJ26HstFFFakhRRRQBxmvT61ouo2M8OvPdS3uoJDDpTWsYR4mf58EDeCkeWLFsfLyOaranqev3tz4nutM1RbODQv3cNv9nR1uZFhWVvMLDcFO8KNpUjBPNXYfC+vQeKbzWhr1hM077UW40x2eC3zkQowmAA9Tt5PJzwA/VvB11eXmqtYa01jaawirfw/ZxIzEIIy0b7hsYoACSG6AjBoAqJq2r+KtXa20nU20m3g0y2vGZYElaSSfeVU7wRsUJzjBOeoxW54Y1uTWvCFhrFzGEllg3zJEpYBxkNtHUjIOB1qne+FbpNRW+0DVV0uVrNLKVWthOrRoSYyBuXDrubBORzyDWzo2lW+h6LZ6XabjBaxLEhc5ZsDqT6nqfrQB4v8WdbtNZ1jQTbRX0fkwXWftVjNb5y0PTzFXd0PTOOPWvPmjXeRnNeq/Gtd2teHB/073f8A6FBXm/2fcAcVhUlaRnLcpFOOlMaOr32U4yM0wwMOcZqOdE2KJQDuaQxMRnFXTD6g4ppRfrRzhYpbD/dppDf3DWhsB74pfKBo5x2Mwj1U/lSeUDWm0GelM+zN6A1SqILGaYTjg1b03VbzSJi0LZRvvxtyrCp/IYDO2jyix+4p+opqqVCUoPmi7M6C01W11MARHyp+8Tnr9D3pZY2DFSpBHrXPpYbsvtC47itqyvJUUR3H75B03dR9DXRDGJaSPpsFxBOKUK6v5kcoZV7/AI1nyyEKcYHPWuikgjlTMTckfdbqKwLuwuZbjaqFEHJduAB61v8AWKcldM9mWYUpw5qcrmHf3jKpjjJLt0GOlYkgKkqTzn5vrXQahHZWKOls5nuSSGl/hUf41z71Klzao+NzDETrVfeew+ztZLy6jgiUs7nAFeh3fhKJNHzEpVlTJ9ziuZ8HRb9aT1x+VepXJaS3MYzgjtXmYzEyhUjGJvgsLGpTcmeMENG5VuxwRTw3pzXV6p4TkUGWAZ9RVbQ/DMt5OxmUqicn3rsjiqbhzXOOWDqqfJYx7eF7l1VR1OK9l+GfhuONm1CRSQh2x57nua4zStCabVPKhUjL7Ex/OveNJ06PTtPito+FRQKFV59thyo+yWu5d7UlKfpSUzMTvUN6CbSTHUDPTNT96awyCP7wwaGCPAPHVpGmpx3sCqFuVKyYHBYVwLnD/OgYivV/Edn9pNzZ8mSKYuu7nv8A4Vj3nhe2vLZXUeXIBzjvWTxcKdlI6VgqlS7icbo9idT1SOIjEY6+gFa3ivRLfT4o5YUKseoHSul0bQYtLJkBJboTVDxm4ks1BO4qetcv1p1MQuR6HQ8IqeGlzLU85PD59KtWzANjPB6VXcfN0qWPrwcd69Y8hG/pjyXG63Eipdx/PCW6NjtVG42uzSxqEBPzID9w+n0q5DELyyEsZCXcPzKR/EB1H1qjcSMZzLjiQc+hNZlS2I9xxSg96YKcBUMxLEZKjh8Zq07DYAjgnuazxRk1m43C5ZKtnPBp6KQeSBVZXIHWnCU+lJpjLJG84MgFI0A/vg1B5g9KXzOOOKXKwH+VjqeKcIsHrUe48HcM05HYsBim7gfRHwfGPhnpw/6bXX/pRJXdVwvwf/5Jnp3/AF2uv/SiSu6rVG4UUUUAVtQgurmxkhs7w2c7Y2ziMSFORnCngnGRz0znmuLHiTUdEh8WvNfHWbXRbMTR3MkSI3n7XLQMYwFbGIySACN+DXW67ZX2o6JdWem6l/Zt3Mu2O7EXmGLkZIXI5xkA54Jz2rH0rwpcW3h250DUrqwuNMmt2txFaWTwMAwIcszSvuJyTnrnkk0AUbfUNb8P6zpcGsar/aUOo2szyA26RmCWNA52bQMoRuGGyeBzVPS9a8QRWvhjXb/UluLbXpY0lsBAipbCaNnj8tgNxK4UHcTnJPFbWmeFbyLUrS81nWBqf2G3e3tEFsItofAZ3+Y73IUDPA5PHNQaZ4JuLKXSre51lrrSdIcyWFobcK6kKVTzJNx3hFYgYC9ic4oA6TUdRg0u0NzcJcvGCFxbW0k78/7MalvxxXzN45vYdS+IGvXcKzpHJNFgTwPC4xBEOUcBh07j3r6kr5n+IsZb4meIj/02h/8ASeKsqztEiexyKL81PkXK1YEPehouK5eYyTMeVCDVZ/StaaD2qjLDg5rRSGUXWmbasulR4q0ykVmBFM5NWWAoSLd0FVcdyAITSlWFXFgPpTzB7VPOK5SVyK6PwjrraTqYEhP2eX5XH9ayBb5OMVaWxwobFVCtySUo7mtKrKnNTjujvNatSsvmx4MbjKkelcnfswyD0rpND1EXWn/YLk/MvEbH+VY2s2rQFuCfSu+rUjVjzx+Z+i4bHxxuE5lutzlri52qVOAvoO9Ys8zTuSeg6CtOW3LsWlO1fSs+6RYjtXqeaxWqufGZjUqcyUupWqa1t3u7mOCMZZzgVDXcfDzS/td482wErjBPauevVVKm5s4qFL2s1ETU/C/2DSxIgO4DB44+pNciGdGxnpxmvUPG4nVFinciED7icA/WvNboFpflUKvYCqwNSU6XNJixUYxquKRc0+Lz5AgG456Cu90bR41gM0vEaDnHduwrJ8H6OW06fUZEBROEB7mu88JaNPqG0sCIQ247h94mvR9poYxpO50Xgfw2ryi+uGRA33FJw1esW9ukKAKOnQn0rK0XTUhiU7QEXoMdT61uVz1Z8zsVawUUUViBWu32x84KtwcjNeJ+LdGOl6zctYoIlux5qEfKN/cV7fcR+ZC6ZIyOo7V574ng+3W6y8PLCSBu5GO9awnyRbHGHPJRPA7y/mS7ki1W1t7khsnzIwM/iOa3LLxBZNY/2fp+nW1qj8lVy2T688mq/jmLy7mOVNgO3HSud0RWa+jKRn5WBIWumFSMo86RnOnKMuRsPEuhz20Zu9pAJyeMZ/CuTzX0Readaap4eZWiO4R85HPSvny7h+z3ksPPyMRzXl0sU68pX3R11sOqSVtmW9PuZAGRT8wHy10WmasWg80HBHyyp6+9cnaSeVdRv6Gt3UIFsrmG9h5gn4dR2Nd9GT3ZyvyNy7CyxCeMh0PNY0kozwaba3TWcxikz9nk5U0XCAuSnSsMRCzujnluLFLhgc1s2l4QAC1c+EYGpBKU71wzhcmx0c1wHXANZ7xljWcL0g9alF9x1qVBoC6sQHpSPEp7iqJvh6037bk0crAkliAPFQEYp/nbqjc1aTGavhYn/hM/D/8A2FLX/wBHJX2RXxt4UOfGfh//ALClr/6OSvsmt6exvT2CiiitDQKKKKACuO+KK7/Ak6jveWQ5/wCvqKuxrjPiqwXwBdMTgC7szn/t5ipPYa3PLJYRuZejD9KqnIOD8pq7jftbr7jr/wDXqOdU2gkBvcdRXIjdkHmyYIZA49Qaj2q2cAqe2aXKjlTmlDeooYEX2RCMsx3Dt0qvJHDjO3gdcmr64bg9KJoMQnYm4dSetK4GOzKM+WCPxqa1t5rhgfm2jvnrTZoflO0BSO9RW7zodyEEZ9avdCL0kJRsE4NR7xGfmJx6mtK2niuIgLhdxB5PcVabTLeRcp8uehBzWd7blGNsyPlxg96el1JaKQBlT6jvVySxMCMmQQeh9KowFhI0b4P19aafUB9pdhdQWd+F3Zz25r0bTb3MKjs/U5615zejzIFAX7rc4rpNAvDJbwjI+Q7SfetqcjOSuO8dgyWImwPlfI9a4iKRYrPcBmRu/YV6F4kj+06dJEvLYyvPSvNgxJWHoRxWlRaig9CMfv5QgGVXlvetLRNOutTvTDCAIVOZH7D2qiEaJxDGCZJDjH8q9C0lRYva6VY24M7gPK7dFHcn3pxVwk7F+DRYmCW4QuF5c+vtW29mIoUhVFGR9xewq3DJboGYEfIdvTqfanCOaQM3KPJwW/uitrJGV7lCPTxCTP8AIJZOFUDAUUyPTcs7qBvbktWmkasm75lQHAJ6tTyfKVlYEgnhV7ClYOYy7q2McCqpAJ7etYupTy2UGWGSxAWujvRwMDoMisbxE0UukEnaJFwQPX1rOpdRdjeglKaUhlvOpCsDkFQasCESSb/zJ7Cud0fUBFYO8+BEj7AzHvW4l75wCx8r3xThPmimKtT5JuIy+s977gRt7k96zL3T8lSMZXp7muiG2SEZHU4ApksAbL9geKp7GSdjn3LBTsb95GAD/tVTbVJdzb8BmOCGroH00ZLLnPbisbULGBYSk+C54B7io1Re4tveCZvmG4+metWyOjE/ORjA6AVjWthewMWtmjkJ5CyDGBSyXN8HTfC6pnny1z0q09NSGrlbWPJiuctgnGR9TUuhRv5QmOdu7KDuMdao3Flc3LyXUzKig5Xc3LD2rUjlKWTFBsdVBKjsQP5VK1dyntY5vX/mvndCSc/Pn1rLaMbAyng889qs6lM81w07ggsaqmNwnIz7Cokx20JxBEoBedcHsKik8kZ2t/WojG3cUCJv7rHHtUi+Q0kUZBqREVT86nFTiO0ccMyt9OKLisVaUCrK26nP7xCBTTbuOqnHqOaLodmNWNDyWqRYYjjLfrUXk9Mc1ct9PWWEu7lSDgCpY0QvHCo+VufTNek/BA51jxH/ANcLT/0KevOZLYRDcGLfhivRvgh/yGPEfGP3Fp/6FPVQ3FI9looorUkKKKKACiiigAooooA8l+L6b9f8PDHS1vD/AOPW9eftEFGRXoXxcAPiLw6D/wA+t5/6FBXE7AOoIB/GvPxErVAsZ+1hwCDSFSeqn6irbKhPAH4GmFR0FZcxNiqYQR94j60xreMHoTV0qOhxS+Wp/hzRzsdjNaCIfw1EYxn5f51puijHyCoHj44VR9auMxNFZLduST+tOMeD1NWUjb+6Me1WEhjPVcH60nOwWM4KpOM80oU5yDmtI2UZ6EVFJCEXjNSpphYpiRh8uDjuKmRhxwfxpy4Azt6etI2d+SeKfMBOJCvTA+tVNQuJWhKRNtz1f0HepMgDnNZWpSloyoOIv4j61dKHNIbk0tDCvpEOI4+EHU/3jVAjn6VYlbexbsOlQkEcV6yVkQjpvA8Dyaq0gH7tBljXo6Nh8lTj3ri/BbeUjoseI15eQ+vpXWy3iFAI9zZ9v614WPblVPocuVqRcd/PyowAeMDpQUihiKR8bupFZwmdWUBccdu1Txl3+8GxmuFRa0uelodL4O0wPqDXBUbYgcfWu/8ApXMeC5UfTplVcMkmCx/irpxXv4ePLTR85i589VjSeaTNMuJkgQu7AD3qmNTgJwXAIrc5rF8deKXHPIqiNRhyMOOavoQ6hgcj2oFseYeKLL7H4lkkCgJIofNZhkVT8vT/AD1rtPHVmHgtroA5BKEj3rgJEZT1xivDxq/e2PosDJSpJj7i54K5Ncz4jAazJxk57dq2ZSjgAZDVn6xC7aZKqNyBnnoRVYVqM0LGRvSkkeeuOvtSxnGM9qVsbiKQetfQHzHU6TRkR0eKclV2ZyPQdx7j/Gs6WLyJikh3xt/GDx9RWhpWZbVlVts8Q3Ke/wDn/wCvVGeMtclSNr9SueB9Pas2aPYgaEpJtLKR2PY1JsVer5oMLehoELHis2zBjTt7GkzU62zkfcNSrbgfe4qeZIRTHJpwUmrv2ZCOGH40otTjgg0udDsVAlSCJanNo/cUCzcn/wCvS5l3AYsKZ5P61JsVTlf0qytgAATk08WpXotZua7jsz3b4P8A/JM9O/673X/pRJXc1w/wiG34bWA9Li6H/kxJXcV0rY2CiiimAUUUUAFFFFABXzt45hD/ABE8Rsf+fmIf+S0NfRNfPfjLDfEbxGv/AE8wn/yWhrDEfAJq+hy8kO0VWcEVryRDBzWbOApOK40YyjZlOTmqzwhzVh25pEwTVbCRTe1GOlZ9ygj7V0XlqetZeoQjnAq4T1LRhFyWxWraRbkBrGlyktbmlNuIDdK1qfDcZN5JHNKIga3YrSORRxSTaeq8iuP2upNjDwEPSpRNkbcUt1HsanxAFeB2q+bS40xbe5MTAjIINbIukv4Nk2NwGAa50KWnyQAKtTXcdrAT/EegFdFFTlJKB0YbGVcLPnpsw9SO27fP3FOFHqa5+d/MlZq0dSuHLFnP7xug9BWVXo1bRSgiZ1Z16jq1N2Fez/DDTHh0zznQIX5XuTXjcPEqtjIU5Ir3Lwrqv2Tw1b3U6hfN4VR2FeNmcmqKXdnfl0bzfexT8exLBH9oe3WQDplsDPvXnmjaRdeItWjhjT77fM+OFFeoeJVHiLTvJijBkzxx0rS8KeHrfRbZfkBdgNxPXNc+GxypUOVbnTUwTqVuaWxtaV4btLHSoLFVDKnXP8R9a6rRtOS2jCRIAM8DFURIEQNv4HUA9K6XRE85BNsYAdyeprqw8pzerDEctOF0jYgj8qJUz0FSUVDNdwwMqySBWboO9egeNuTUVVXULVuky/jUyTxOcK4J9M0WAeRmvPL9vI1a7gP3d3TNeiVwXim18rXDKOBKgbI9uKwxVRwoysdWCipVkmeW/ETQGa3W8gBdFzkAVwvhe1kbVRGVJwcEZwcV76lrHcx+XKoZW6g965aPwfHZeIGmhwImO4DHQ1wUMwcKTjL5HoV8Ep1VJfM1obLydDk3Kc7epPNfOOvII9bulUYG89a+mtdgKaLJsd8Bf4DzXzDq536ncOCSu8jJrTLm5c0jmx2iSKaf6xfrXUIRc6U9rIenKk9jXLx/6xfrW08hSDdz8vyP9D0Ne1R2bPMlubPheC01Qy6NqHySEHyZO6tUFzpk+nXL280gyhx9aytNuWGpQknEysBu9a7XxDaT3yxXKp+82gSY7n1qKjfI2hzSlTv1X5HMOyAVSmcdq0To94x/1bflSDQrs9Ym/KuDniupyXMYuc0oc1tf2BcHrG35Un/CPXOeEP5Ue1h3HzIxwSaevWtf/hHrrH3D+VH/AAj93n7h/Kj2ke4XKMeKsBFIq5D4euyeVNaCeG58cg1nKpFdRalXwwuPGfh//sKWn/o5K+xq+UdG0aa08T6FMynauqWeT/23QV9XV0UJKUbo3pfCFFFFbGoUUUUAFcZ8VAD4BuQeR9rs/wD0pirs6434p/8AIhXHf/S7P/0pipPYa3PLpAY+R+lV3HmAnODVwFJR8jBh0K1FJASCUHTqveuJOx0NGa8DqehP0oRZD6/jVvqMjmk8oHJBq7isNFWLeCTeH83CnsKrfdOM1dtJosbS+GzxmoYxZ7NJlY7fmxWTJaGAhSuAehHSujBHTPNRTQrKMOAR9aiM7DaOdRCrBlba1aFpLMz7WXHXkHj8qc1iA3Egx2+XmrcEMQUfKwI/iJ5NW5KwkK6lx835mqstkkvP3X9RV4g4POarv5iN0z7jrUJ9hlf7GoBVyST36Zp+ls6aqbdEbySNzc9KeJTM23ABHYinRSvaXAfAORgjHUVrB2epL2Nu7ZmRkDcnv6V59fWj2V+pYHh+Djrmu5ikE6+aAQpbBGeRVLVNPN1cwTgDy4z8wPet1JyZLSiifSNGEl1HcygHAB+mK6XRLFo769vGHzyPtTPZB/8AXqrYgJbIUU/Ock56CuothEBHGi8HnPrXRFGEmR29nOCQSijqDjmrMgWJQXkyw6D3qWSRYx8zAN/dzVF3Dbieo6MarYncIZFZy7OSg6Z4GaZM7BiZDgP0GeajCKkQGc5NEyGWUd+Bn6UiiKWVXXAYknFc7rEoaxnzztXFdBcptTzExjpXC+J7toLZ07A8n1J6fpmsqr0sdGHXvp9jkdQmlIEQkYxgltueCaksNUvrYhobpl45Vjx+VUZZDICwPYcVEjDIzyBzVRikrETm5SbZ69YXMipC8jK5dQWwe/tWvuUr8ozv9K5TwS0V7pYCzfvFYgqR930xXbC2VRkDBXj61SRmykCQmTwRxXN+Jg6W4cDa5PymuokT95kDhuox0rL1/T0vtNMY4ZDlTUTWg4vU4JNUu42JJLHuc1FJq2oOx/esFIxjFVpBsmZGIUgkGkjmwQCMiudSkauKEa7uHAEkjFR0B7VeTV2eBhLxKoAR1Hb3qrLKuRtAI75FR7UlIAQ57kVSqMnl7BOVnVmgHK+3U1BF0KyD8e9Wdi2ilomRieq5yaUSpICWU+4qXK+pSQ1QpGT8wqcSxyADAA6elVPNAbajYH+1R9rdCVKqT9KmwyzJCuCVwT2HaqUkTc5gH4Cp0vlTAMYyak+34B/d89qauJ2KiW4Zc4KijYw4V6si+flTbhu4pn2sbv8AjyGSemTRdiJ41UxFFUO4Gfm71EsK4HJQ+narUQXbu+y4f2anOgY7imPUVNyrFRmmjU85A4z1Feg/BVi2t+I84z9ntOg/2p64YLG3T5T3rvvg6gj8QeIwMYNtZkY/3p60pvUia0PXKKKK3MwooooAKKKKACiiigDyv4rDPiXw9x/y6Xn/AKFb1xbrz0rt/ikB/wAJN4fJ6CzvD/4/b1yflBhkcivKxcrVS0tDNkgZugH4VH9mb+7WmYiOSOKTy+lY+1Fymctu+c7af9mY98Gr/lYHXNKFA4qXUY+UpLbOB94n8KR7QnqM1pqqHoadsB/+vUe1Y+QxzARkYxigRNjhq1GgUjqB+FN+zjPX8hT9oLkKCwuR0H4Cg25OMitAQhRxkH3oMRx0FHtB8pmG07A4zUbWqheT+laZR+uKYYyxGcDNUqjJ5TEMTyuVjDFR1YisPVoZg+1+EH8I712Nw6wLn7zdlAzk1zOsKYoXnuSBO5xHGP4fc+9d2HqNyVkTyJas5dvv4PahEzICe1OdWVsN1PPNSRJudV9Tya9R7EJand+FrORNHG1C0krl2BrcFhdldzyRoo7ZyRU+gQQ2+nxpGCIgPvNxk1Yup4QGAcY/2Rn+dfP1XzTcmfR0G4QUUYtw0cHBuWLHrgUtheYmYKxYEcA1FeKj56KD3NVbZTbzxlWGC3rUJKx1Ju2p6j4CYiG5jf7/AAWX0zXV3d1FY2k11O4SKNCzE9gK5TwGpxeue7DFP+KDSx+A79oSQRtLY9Mivao6wR87X/is8+8R+JtR166ZoZHhtgf3aKf1PvXNS6lqsTcXswx/tGuXl12/jbaG25HQGqkmrXMv35Dn3rpUTOVRLY7GPWtaAJXUZcA8fNXbeDvG99p97DbavcCe0mYLvPWM+v0rxYX8wPDH8K0LC7uZ7iOJDkswA+buTTcUR7S59PeLkEnhueQc+XhwR9a8iub9XBA6V67qEbDwXNDISXWzwT7ha8GgmKyYbn1ryMZSTkpHsZdUtFxNFJmzlTmqup3jCwlUAL8vep/s2V8yFj7rmsrU5CLeU91HQ1zUY3qI7MS7U22coQSc/jTTnOfepR2puOua+gPlTU025EYU7gJYzuQnowHVTWzqFos6wXdtGBHISeRyB6e4HNc7ZxxysqzMyRZwzKMla6SwuJbZRp87B0HzQuDxz/Q1zV20ro1jtqQxwKUGRg9xUyW6qQSuauvGpAOO/agEkcEGuB1Gw5SuIFPpSNbegH4irPmYGNgp6zDnCVPMwsigbXJHyKaeLRe4/Sr4lOMBKUOzDmEHsaOeQcqKKWqlvu5qx9mBXIRcZxxViPLHHkAfjVhV9I8ColUY1FFIWq9QMGnGJxxV3YMnI4pyxqT0xmodQfKeo/Cfj4eWf/Xzd/8ApTLXa1xnwqGPAFqPS7vP/SmWuzr2I/CiQoooqgCiiigAooooAK8I8S2hn+IniV8dLqIf+S0Ne715FfwrJ428UMf+f6If+SsFc2Lny07jRylxpzEHArHuNGlc8A16KbRD2FRmxj9K8xYqxMkmeaHQJiehqaLw/KOxr0YafH/dFSCyiHYUniieQ89Xw/I3Y1JJ4YLpgrXoS2kQPQVMttH6CoeIY+Q8hn8Esz52mrNp4UeHHy16sbOI9hSfYYvQUfWZWs2L2ZwlvokiDGDVltCLr0rtBaRjsKeLdPQVm62pSgjzmfwoZTnBpY/B5A716QLaP0FV76eKziwsTSynhY0HJNaRqyloiXBI8r1zSrXRbQyykBzwo9aytP8ADV5f6XcazdZgs41JRnHMh9FHp716InhhdQ1D+1PEBRthzHar9xf971qj4lvb/wAQIdN0mHyrOMYluWXCIB2X1r16FZ048tPd7sSit2eFXZdrh2fOc1BWrrsdvBem2tnLpHwXPVj61mBeQK7HF3LT0HqNsbHueK9Usnd/C1iqfwqOK8rY4GOxr1HwxOkuiqkhA2LkFjXm5tH3I26Ho5bK05Gxpk04IJdUHTmtj+2oYyFExYjj0rmYrpGutgdm56KOKS8gl84PHEcA5xjJrwXTVz2ednqNrMbiyj8tcl+w7fU13+jReVpcPXLDdk15b4A8/UBdWz5/hXrnqeentXsCKEQKOijAr6DBRfs+ZnjY+peXIjC8UeJoPD1qmcPdzkiGPPX1J9hXn41e5vLhriacs7dcntXnXxo8TX8XxJu7dGKLaxJHGPYqGJ/EmuDh8YatExPnkg9q9enKnBWe55rv0PoVbmcuCsrZ9jVqG+vYMbZmFeAxePtSjx+8OPrWjF8Tr6Jl3Zatuaj3JvI+lNC8ULPcLY3rgStxHIf4vY+9J4ziIjtLkdAxjP48j+VeE2Pjq21SPmUxXK/MpzjkV9BSRNr/AIPiY482e2SVT/t4B/nXFjaMZU3ydTfC1XCqpM5OKXYgYmq1/f8AkwmVTyKreeIo/nUqeQeehrntbubm3gLZLRsODXx9WMtkfVxUXqSap4hkn0G6MbFXAOPrXgd4ZfNYydXO4/WvQbzUGi0G6IY/OSK4W9YSwxH+IDFe5k9Fxpzv3PEzWa54pFBThga2bW8h/tCAzruicqso9s1i1etbQ3Ywr4kx8in+I+n1r1YtqLR5TWqZ1ni/wNdaPKNR00NNp8gDoyclAea1PCXiCLU4VsblgtynTP8AEK6L4Y+KI7+0/wCEf1TBliG2Pf8AxL6Gqvjz4dNZO2s6IrLJGd7RJ/SuWnWcXyTL80dTp9lbXH7t4wkg7HvWp/wj0JHCD8q4Xwzrs95YQyMwEg+Xc38LD+Fq9C0rXY7ki3uEMFyOCjd/pXFiqDi7x2E4oqnw7Cf4B+VN/wCEdhB+4K6XcKaW9q4G7E8qOc/4R+H+4KUeH4f7groC3tSbvap5g5UYQ0CIfwCn/wBixAfdFbe4UzdUuQ7I5rUNMS3k0yUKAV1Wx/8ASmOvZ68q1psxaf8A9hWw/wDSqKvVa9jL3ek/X/IdrBRRRXcAUUUUAFcb8Ujt8B3BPa8sz/5MxV2Vcb8Us/8ACB3GOv2uz/8ASmKk9hrc83WziLtNzlxyO1RyJJAS2S8fr3FLFcCQKCxRz61dVXCjcQT3xXn3a3Omxni0Mz+YpChh+Zqu6tG5Rhhh2NbAUEYxxVe7tvNQEcsO/cimp6g0Zbxh+e9NS2YMCWKnqDVgABsDk+nSrahSuVxVNtCRGpdEy7bjjqBUsbl1G4UFcjsD7Vmma4t5irncPcdai1yrmk9n5gzHIVPtVRzd2v34xInqtWba5835l/HNWmYHk4wam7W4WK0UyyLuGRnsaeybvY1HKsayIFOWY8AVaRPlHajYCngqTvH4ipMhhggFastGCOOtV2Tb0/KqTuIgmVk2vGxVVYMRng4rUVzcxMgIBPf2rMd1GVbjPrS2V1sY4b7vysMdfet6crPUTjdHWW6qY4UAHofwraFxt2rjAA4A+lc/aTRyhWjIODxV22nMl9Lk8AYArrTOZo0JGZw8rZIA4Hqaq/vnSPzGw7HewHYdhVvPybO9Iiq0qdeoFU9RIhR2kk2KOE/nVyMfKwPB70xUClgoxzSyNklQcUIGNnRBEydRjjFeS+LZi7oQCUZ2bGPTgV6iwlSTcCCp6isnxJ4dTUtPVrWECeMFgq8bwev41nNXafY3pTSjKPVnizMwiY59MD0psch2E+2K6HVNGZCyx2syuw+5sPFZlr4fv5X2vEYl9X9PpVOcVuyVSm9kdp4CRorJpduA7E5/SvTCd1sjltuFyfesHwvo0VloMKvy5G4EjBArWkbzHGeFxgCnHa5E97EjKJIzsbkVl6mXtdOklyW2gnFaKARnBPJ7VkeIZZhptwsa5O0gY9KJ/CEPiPM5/wB9cySSfLvJPSq2MdKa7uzc9u3pSr6muRGz1YuCTgAmowzhyIyeeCKtJMQu3sacSACAMe1FxWES3Vz8zspI7DNOFukfLknP90U+LYWPUEjrThCU4aQ89qVyrEbWKT/6t8EetNe0EYJcZPcnvVuNVQ7w+SOoNRzmWQ8FOOxpXCxQZbZWVl3Pwdw/umpl+yuAFfB96hlJQk7SpPXHSolkjxnHNUI0kijJwrp0oe3mHzKQR9apQxxTDgsD3wKufuofl3k+xFS9B2Iv9KHJOKdbpO8x3NkYzg0eYQcKwI9hTrabZOfMXjtigCN2bJTGGzivQvgzu/t3xEGByLaz6/709cLKsckmVPzGu9+Du7+3/EW/Gfs1n/6FPWlN6kT2PXKKKK3MgooooAKKKKACiiigDzD4nAHxR4fB72d4P/H7euaEACgA/TFdP8SzjxT4fOP+XO8/9Dt655RuPyk5HrXiY+TVU1gtCBo2HDdPWk+zsFz39KuFSB60be+a4+dl8pR2Gm+T9atugzkimrjvT5gsQLEQfvGneWQOtWBj1oO7saV2FiuYTSGB+xqbc/c4pwY45NK7CyK22QHBGaULnqMVZIHrTdqk4HJo5hWICnGM801lIHIq5s9qY0eDVKQWKTqMZ28gVw2sOJtUdmwyxjn0rtNQmKRsqD5vWuD1NgjtEPvscsc5x/8AXr1MBF3uZzMtmMsjStySc1paLbCa+iQjO9sn6VnkA4B6DtW74eRjIzgYJ+UHHNenVdoMKUbzR2z3Ek5WC3QsQNoVegqC40XxC4HlWpdT6dh6mu28I6KlvYC4mXMjnIyOgrqhECOlcFPDJq7PQni3F2ieIXWianaBWuxIe+0c0trpmq3cq+RaykdmK4AFe3C1iBJZASfammNVHCgfSr+rRvqyfr8rWSKPhGzeysyk+0TtgsAa1tc0+PVdFu7GUZWaMqaxdQt5ZU3W8zQzIco69jWho2pXNzEYL+IR3KdWX7sg9R/hXTFWVkcTk3LmZ8m65pNxpGr3FpMpDRsRWbyBz619DfFDQNGniS5uI3S4PHmxf1HevEb3RjG/+jyrKhPGflNbpomdOW6WhlAF48Z5rsfAHh2fVPEtkpQ7FkV3z2UHJrN0vw2biZDc3Cxxn7wQbm/wr6H8H+GdO8PWSCyU4YB3lc5ZvqaTkhezlHVmn4ruoLLwxdGaYRK6eWp7knsK8SEKu+8fdbtXpHjbTbjxKUjjkeOKEkoOxPqa8+NpPYTvbXK7ZE4wT1HqDXnYpPRnqZe46odg2uVzlWHyn0rnNYcKHzg7xx7V0F8zm0d8H5eo9PeuO1G6NxMvQADHFZ4Sm3PmNswqqNPlKXpRjn60jdBTs5INeseAS2chjlKE/I/ymu2+wK1pbyFcSoMkdnX1HuO47jmuLgAD7GXIk6cdD6132mqdR0byWfy7u0bIU8McdR/UfjWFbY0ihkSxklRnHvUgtQOhJB7U+OIHDE89yKtYwML9a8aUrPQ2SKPlIowRSCOME/KdvY1aKnqcH2qMnAxg0uYLDQiHuKeIgRwwoBUcYP5VKkannFJsLEflMo4YUoR/WpSFHA/lTeeR/SpuOwJG3lnvzRgkgYNSRthDxQF5yOKVxWPTfhZ/yINt/wBfd5/6Uy12dcb8LP8AkQrf/r7vP/SmWuyr3ofCjFhRRRVAFFFFABRRRQAV5RdLu8Z+KP8Ar/j/APSWCvV68quP+Ry8U/8AX/H/AOksFcGYu1B+qAkEdGw1MgzTwvNeBzMdiDYQKYQaubeKYY+aNWKxXVTUqqakVRUm0UWYyLBowae4xTA3NDuAu1hSAsKmGCKCopCsRhmpBCSck8+wqwkeTU4jGK1hJoVjPe1jk4Zd49D0rA8ZXKaV4buHG1MqQqrxXWSMkSlieleQfErUprwiI/u4FJwD1b8K9PBQlUqK+wpOyPJ3G95Jn7nNRqp6nqalmkjLAD7i9B61E8hPOMHsK+i91E6jGGWPoK7fw5K8lkEHTHFcWq/uie5r0fwlZqlgsjcDHOa8nMmuTU9LL0+dmZPcXNlekg7Mnqe1TyXckaJdX88rxv8A6m33bfN/2m9FrroNPsLl3uJ0/cx9fVj6CoBoMd+X1DUF2KzgRxoMyS46ADoFrzqMlP7Ox6lRabnofwbinutMu9UmUKkj+XCgQKFAHavUqwPBlrHZ+FrKOOPywV3FT1BJ71uk4FezTVopHg1pc02z59+P/he3GrWviBjLGk8fkSOibgHX7u76jj8K8HeIoTyGHqDX2T4z06DXNLuLK7wYHTDZ42+h+tfJXiHQrjQ9Rkgk+eLcfLlA4Yf41vKLtcyTuZFFFSQxyyzJHArNKxwqqMkmsxlrSdMvNU1S1srSJzNPKsaYB6k19y6ZZrp2lWtkpyIIljB9cDFeP/B7wDNorDWNYdnv3TEMJbKwqe/oW/lXtQ4XFU1YR5h4os/sWt3IA2xyAzL35x/jXm2rauJ7ZojJnHGD2r1L4jXk1tdJ9lurdJfK3ssgzhQereinoT2rwDUvt8Wpk3Nq9u0h3rGxyGB7qehFeJXwnNUb6H0OHxP7lX3Ga5IItISPPLHNcxjzFA9K1tZmkn2jbgL2rGifZNg9DXqZfHkhZ9TyMfLmqadCs67Wq3pzM06xA4LEbT6GkmhyzAfUU2BDuDIDvU5wK63FqRx3uj0fSNOXU547m1P2bWbQ5kTp5wHf617Fomppq2nCOcYmUbXVuua8u0mEa5pdvqumybNVtFAkRTjzQP613Wh3UOqot0n7q9X5ZF6ZPvXDi4XXMi43KV54Pi07Up7myQLBcHMsQ6Z9RSpAsqrZ3TFJl5trkcfga7LcJotr/eFZ1xp8c8ZjcZXr7g+1cXt9LSKItJ1B5A1pdfLcxcN/te9ahrBksplZN+S8f3Jl649DWlaztIgVxhxXHVtuhNFo1GSRTqYzVzhyiFjQScUzdS7hikKxnaufk07/ALCth/6VRV61Xkmrn5dO/wCwrYf+lUVet17WXfwn6/5AFFFZWreI9N0SRY757kMy7/3NpNMFX1YopCj64r0ANWisO+8Y6Bp8FrNNqAdLqLz4fs8TzlouP3mEBITkfMePepr/AMTaPptlaXc94GivMG28iNpmmGN2UVAWYY5yB0oA1q474oDPgWcet5Zf+lUVdRp+o2mrWEN9YTpPbTDKSJ0POD9CCCCD0IrmPid/yI83/X7Zf+lUVKWzGtzzj7LHGARkkdCalRzj39qlZQTxwarMj5yhz7ZrzE77nU9CYMOtPGCOlU23qflUkVLHISBng+9NxC4sluknOMH1HWqnltA3LArnkitDcMVFNGJEKnkH9KcZ9GJoi4PIqC4hE6YYkEdCKZ89s4XOVJxU6yA9RkGqatsBVhgeHq2ffGKtGXCcrn1AFPCqw45FLswMjtSvcBbURMAVAJJ/Gpm4cjJx2qqqpvDbRkHNWWkDrmgQ3cVHFMZ0bvzQzEDkdapOV3Ha449e1FhodPvxlATj+71qFgxBljVlkHBVhww96mD4AJAz0JFNcfKzbsYHp1q07DLmkX48zKqcZ2snoa3wZLe4W4x8hHzAVzGjxs1mbpgA7Nya6qynMsOJCmcdTW9N30M5q2petbgzM0nReozVsyKEjCnknNUVkTASMjryahWY5yTnniuhPQxsbLSIxwCFcdc1Xkkw5zVTzi2W7kZqR5PMiBJ+fOKOYViUTjqTxT1cmNgxHHQHvVKT7uO9OVy21T06Gi4EoEUrBJdm/HRxn9aWexsLiILIiBV/u8H86Q/IeOR9KaDnoMDvxSaXUtTktmWN5BWNPliXgLUhTLDPT1FQrgHPepw5CA7c9iKuJmxlw67SCwVsYBrkvELvFAUmud0rA7EUdPcmuqmfCgeUWHXLdBXDeMbs+fBEijIBJIFZ1XoaU9Dk3gkUnPOe4qWO1dl2ngkZGaYbvaw3etWxL5iAqeMVyu5qQJbvE+CMHtg1b8m4SPeU3fXmovl64BNWIbkjA3ZA7GkxjoUadDutlwP414NROh5R+SM4OKtLcKTwQCakxkZJAqbjMhBOsg2x7hnnHOajYYkYHKnJ4rc3mLmNQpxzjrWfLIr3X7xBz3NUmJio0MUI+6zkckil3WsmAYUOeh20YiDkfL9DSeYj7SpUH+6e9IZMlvbqfMiQA4wRWZPdEsysmwg46VdSZlkCtGVGeopl9bpIm8g7sY3DvQt9RGO1423AiHB69Kb9slZtwAB9qWS3mQngkdsVCquScqRj2rSyJLUbtKcSP+OBXpvwaCrrniEKSR9ls+v+9PXlCl1bK8V6n8FXaTWvETMcn7PZ/wDoU9VBe8TPY9iooorcyCiiigAorEl8W6Lb6kLCe4mimMogDyWsqxGQnAXzSuzJPAG7rRJ4v0KLWP7Ke/AuvNEB/dOYxKRkRmTGwOcj5Sc89KANuisTUvF2haTqBsb2/EU6hTJiJ2SIMcKZHUFY89txFbdAHmnxIXf4s8PjOP8AQrz/ANDt6wMBc7a6H4ijPizQP+vG9/8AQ7esArz1rwcw/j/I2h8ImTzRkU0A+lJyD0risWSHBHvTGjH0pwNKTxii9gIQoHB/Clxildc85poJB9qu9wGsvuRQAR3p/Xgil2g9KVwGHGOcU9ccf0oI/GlXAOQOaBCdjkn86icjsetSsc1VnY7CAeT0qoq7Ax9YvlhQxphpiOPauHugY52Drvcg8Z+6fU+9dbqTRWitj5p39+RXKXICM2fvk8+1e7g4qMdDF3uVMHpnqea9A8BaQ2oXYG0+WnLN7VxEERYAoCXJ2rxXuHgfSRp2kwbhtZ1Ds397PSumproVD3dTrbaNo4vLGNo4GBjAq2qhVpqAKOtOJxzSQmBbnA7VG5zxRn3pjEflTEVZh8xqFZ/JcHGQetWZBkgd8VVkTmkMx/EVubmD99avfWmOsR/fRn6fxCuAfw9oNzcfJrJhOf8AVzwMGHPT616mE5yAQRzkUjRFsNtRmHcqM/nT5jaNVpWOO0TwVpG/zZb6S4XrsiiKhvxNd9E5MaoqiOIABUHYD1NV1Rj941aQYAA6Ci9yJ1HLcc0SuGBX2rlfEvhhdSWOSM7HjyCVGSR6V12Mn270ySPI5xxUyipKzFTm4S5keI6lDJbeZb+ZuYZG4cZ/CuGuAfPORjBwRXrPjvTWjuxOi4Eg4P8Atf8A168nu3P2kseDnn3ooU+RGmKrOpa5CR8p9jQvK09uWOe9NXkGug4yymY/Lzwp+YMO1ekxxNdaLZ65Guy4jAhudg4cDo31Fec2xM1uYDjK5Zf616T4H1DzdHk06TacZGwj7wx/P/CsaqujWG5FJteRnj43dRTwGMZyCCKleJElKgDKnFOZjsKmvDm7Oxsisq5I61LlRgDpSLhvQEUuQAcc9xWTGhRtY8rTjhVJUZpm7JOCPpTkY9D1pAROwx/SoTIc5C81PIoBwBjNVyrAYwatWEwV3PtUsYBYFutR7SF5HJp0RYHrjtTYj1P4W/8AIh2//X5ef+lMtdlXG/C3/kQrf/r7vP8A0plrsq92Hwoxe4UUUVQgoqC9vINPs5Lq5ZlhjGWKIzn8FUEn8BWXb+L9CubW9uRfeSligkuRcwvA8SnOGKSKGwcHBxzjigDborJ0zxNpGrxXMlpd4FqA06zxPA0SkEhmWQKQpAJBxg4NM0fxVo2vTtBp14ZJVjEoR4XiLxk4DrvUb1z/ABLke9AGzXlVwM+MfFJ/6f4//SWCvVa8snGfF/in/r/j/wDSWCvPzP8A3d+qAlV9tSeZVYqc0uDivnkF2WlkqQEGqSkg1MsmKq4XJ8Ugamb81GzHNUpATnkVFt5oV6kBBp3GCkipFOTTQBTgKLCLCYp/J+lRRkCllkCKSTgCtYICnql1DZ2kk0zhUQZJNfPfi/Wn1rUHkT93bAnbnv716L4r1CbW5JIYW22EB+eQ/dZvSvLtREbzMI13dskfyr6LL6KhHme5m9zAPfy0J9zTAp3fMavyKFzk5qHy3LjA2j3rtkupSLmm2b3cqqsLP9OK66O5vbSBbeOAAdMKao+HbKd5UxGzA/xNwPyr0zT/AA+04UInmSH+GJcfme1eTif3s+Xc9TD/ALuFzA0aaSNPOv8AAgjG50BwXycBfxNdvYX0CWM8+0O8mAuAFAb0DHoB0461DJ4Qu43QY+VfmYDoW/wA4FRXGkXMVj9nKnBJJzWbjOgvdibc9Oto5Hp3ha58/QbcsVLgENtJIz9TWpPKFQ81554O1ZtOu2srlm2TEbM9FI4Arp76+ZkcgHC8Fu1ehh5qrFSPLxNJ0puJk+JdQWOzlG4Ybgf/AFh614Tr99byzyWtyiysOdoOR14UH37n2NeheILm9vJJ8qPJUEKMYPr+Z4H4mvKtXsNQhV7uSAsxLMGVTjsB+pIH0rsUlYxV0Yy6Zps10Sk+2MdFI684z9Otdd4d06w010mii3TFsB+4+h7HuD3riBG/mhQuGDhMEegrc0VbvyDHk4KBkIPQgZH6r/Os+XW6LTPpbwtcGSxiwcjGc4x+OK7BGyvNeceELmZbGAXB2nA+YdAT0P0Nd5BOgjJZtu372T0qJaknkHxNQX/iydoZZ7C6s4EjS9xmI7udrjsDnrXPQaCbq1Xc486IhZ7WTlFP+yP4Qc5BFdd4hvXub69aSFDBcI4JVshwuOP++Rn8K42O/kslMpffsJtpGP8AGByj/ka8+Vbmm4nuU6fLSRS1zwrGYBLCvGSCD1BHUGvNdX06bTrv5lIQ8g16dbeKIWvns7lyBMNoJ6buxrmdftBcFwX3AH16UYVTp1HB7GGLUKlPnW5ykX79MdGHQ1NYzm11CKdVXejAlWHDD0qo0b2suR0B6GrZKzgOAA9ezF8y8zxmrM9Rt7RdB1Sx1WwBjsNSAO3tG/cfSunmgJuv7QsB5dx/y2h6BvcVheFdQg1vww+m3DZeJdy56jFdFpMn2y0TnbdQ/Ln+8K5MRG2pcDdtrz7RAkg4cfeHergcMM1lM5UrNjDDiQYq8jhlDKcg14eIhbVGpKSKYNvXApGYCmF643cCR2wKrvJipc7hUMqZ6UrARGagSk1GykGmnIpMRFqbZGnf9hWw/wDSqKvX68a1AknTf+wrY/8ApVFXstezl38J+v8AkJhXL+LtY0+2iFhP4r/sC7ZPMV1EZeRTkYAdTnkdFw3ArqKK9AR5R4V1O08MXdne69CukW1zoNtDa+arBQYpJd8Y3ZIZg6NtJLHPcil0EjwufCGo68DZWI0u6gDzjatrJJLHIiueiExqV57rivVqKAOV8BKzaNfXYjdLa91O6urUOpUmJ5CVbB5Ablh7NWL8TNLvI/DtxfHXdQkt/t1mRYMkHk/8fEYAyI9/HX73X24r0SuO+KH/ACIs+P8An8sv/SqKk9hrc4ESq44Iz6U0KM5A5PWkhRAzMAQzetTZHavMl7rsdW5FtINNZQRg8ehp8ib+R1qJXIOGpryAEbB2P17e9ONDjevy9e2e1CZ4DMp96TXUCOVN47VVKkSZUda0CvNMaIHkDmnGVtxNFIOwPTmlE7swUnBz+dTtBn296Qw/KcAZ96q6DUYwfJ2nn3quLm5ifayxn1+bFT5cKQx61ScRxn5lz+tWhEzvIJGba2fQHINQyFXIYnYx7MeDUF0yxxeYkkgUDlR3qlLOssRaI/MO+eRVJXC5pPK8ShokDr3KnOKhS7lJYPghhx61mx3DgcscjvmrsTb9xZuBznOKHGw4yudfp9qFsIIQMNjmrRsHDknt6Gl05sxxyg5X1rZmVfK3g5z6VcIp6ilJpmIt4sLeSWAcD5vpVpJFIBBByOMVw2vJKusSkSEEgFfoKnsdcaO38h3/AH2CAT3rZOy1MmjtlbB5p6n5uTWNaatDOY18xTJ0K984rVVwTkcjGKtEE5YE4HfvT1XDj0FQ5+Y5qQSZY+lAEiuQCGPU8URsM4B755qJnBJx2qvPP5Ue9cfLzRewWuaAlXeQ3BzU25wcryK5C88RQ2zLkFsnpVrTNZvbrDiJEtiT945aiM09huDW5vz3SLGzSdFHINebeJbtL+981BtAGAK7l4WmB3EgP79a5jxPpcUKxvEmxwPm96zq3aLgkchO6BeTnjt60lnIx3LuwO2auvaq6AlQO/FQiAxkrGFwfasbpqxdrEqSMGCs3ynqcVP9lcyb0ZSB1NU9smMYBIp32iWEdccdMUrdhmhEjK2SeR6VZEmRkjjvVG3ljvDly6OO6mlugojysin2IIqWrhc0A+QCpyKhnhR+owfasyDzJ4WRTJnttHAqzA9zCSksbOOoJ60crQXuLNZh03A4Prms+SFoTyD9a1Vl3gso2AdQ1PCrOeVHoaLtDsZMd1OnVty+/WrUV4rrh+DjoaLuGzQOAHSX0zxVEAk7CT7Gq0YrlwmJydpBNVpU2gngj0qusbfaAobbk4zmrLrIgAZO3Wi1hEUfzN0xXpXwaUprviIH/n2s/wD0KevO4eDnYM9q9H+DxZtf8RFsZ+zWfT/enq6fxEz2PW6KKK6DEKKKKAPN/GurWWoXUVtY699suoLyBH8PIqnz3SYZ3YAkXGN2d2z5BkEZzmXV1CnhXV/CbE/8JFcazI0VttPmSb7vzUmH+wEIbd0G31Fet0UAeX6tqFnpMXj3StSz/aGquz2MJQl7xJLZI0WMfxYdWUgdOp4r0PT7aeHQ7W1mlZbhLZI3kXBIYKASM5HWrtFAHknjDTrvTfFmi/atavtS32V3g3SQr5eHt848uNOue+eg6VSYhq3viP8A8jXoH/Xle/8AodvWGuAmK8LMf41zensNA44o9qfwajYY5FcCKAjPTrSdRShqCMnrTAaeuKaeO9S496TbzTuBFzzgUZP41Js7dqQp2/SndAMGSTQQccU9lwKay5HPNNMCMs2O1VZcgEgnPoozj86tHaMnFVbldy/611HtitIbiZzmoqBIyAKjkZJJyQPUnsK5e5cSSkxj92vAPr71u6zcR7RaW5HJzIy8njsTWBKWLBWOQoxXvYaLUbsxbWxu+E9N/tLWYI8fu1OW9h3/AM+9e82EYyFH3UGBivHvBE8djtkOfMnlEafj1P5V7Jpbb4z25yPetXqyuhoKMD3pGPanFh0qJck5oJFPAqM0rHJxTepoAYRyeOlQMuTirOKiI5NIZEU+9j0oK9sdqlA60mPbpSAao7YqWP0NN759aVTg4xQInxgfSkk+6aVenIpGGR71QHO+JdOTUtKeNl+bqCD0PavAdegNvqLqwwc4Yf7Xevpa9RTHg9COa8a8eaOP3l4uN2dsgA/i/wDrjp+NODs7DavE4AHKA96WP7xFNTIQrTh94GtTImt0YsrKD12n8elei+EoMwysuFuIMl0zy6HuPcV55CxRm2854Ir2Lwja297pcF5yky8CQDoejD3B4rOZpA52bU4Y9Xlh3hlY5BB71oKQ6g8H6Vxvi6H+z/E8/l7VQkOu08VqaTcy3CLNEHwB82TxmvNxeHt76KjPWzNxkw1NePB705JNy8jt1pTlTg9a87U1IPu8d6cGbIFSkDG7HHeomA4K0LUB+4EdeaZkMMimn5l9xTEB555zVWFce350qZJ9KTByeKmjBHQAGgD0v4W/8iHb/wDX3ef+lMtdlXG/C3/kQ7f/AK/Lz/0plrsq96Hwowe4UUUVQirqN/a6ZYS3l7cLb28eN8zdEyQAT+JFeR35N9caxd2moS+JLSJdPnn1BY1JEcV0HeBfLARwF3P8oz65yK9mooA8s19x4wuPE9z4bkF7B/wjrWfnQcrNMXZhGp/iYLnOOm8DvWvaavp3iXxt4fuNDkE0NhZXJumRSBAHEYSJvRsrnb1Gyu8ooAqajZz31oYbfULmwkJB8+2WMuPb94rL+leX29vLZ+JPEsE97PeyLfpm4nCB3zbQHkIqrx04A6V63Xl0oB8YeKc/9BCP/wBJYK4cxV6DBD9uTmnhKkwBSHFfODsR7RTStKxwaVXBp2ENwaQg1JjnrS7c0WHYhyRTgxqTy6XyqpC1GiQ5qZCTTBFzUqrtpoauKWYDisbVZprmMwK/lRdJHHXHoPeteQFkIzgVnvFuBK8f7RH8q7sPFXuwZw3iBFWxESARW6DAB4H5dzXm15syzMSEB/P2Feg+LGihdmnlJx0yegrzW9nM1x5gGEHCrX0OG1iZspOWkOfurmt3w/pH266WSRT5Sc465rEwXkAc9a9B8NFVultV6pGHf3PYUsXKUab5TpwsYuonI7nwp4WfU7gDAWFOw6V65YaTa6fbiOKMDjk461Q8I6eLHRoiR87jJrcdsKTWGHpKnFdy8VXdSdlsivKkYHIGayb2KBlO5RWoyZGT1rNugCWz0FdBzJnMXtnFuLoNpHeptN1qGxtktbpXnQMTvznANWJI/tBOPu5qlc2scYOF5rJR5XeJpKTkrMv3um2eo23nWjIw68f1rgtTk1bRykQ09bq1AwRjODya2hLPaTBoZCjE5OO9TLr2/wD4+Ilbk8j0oc+qdmRY4CPVdHuJl+16EUkGHYhMDPJrX0h9FWMeTpLhgilcj0BIH5Ma6o3mlSgM1uDltv3e9INXsrSUiGyBOR7fWmq81uxqPkaWj28l0QREYoiQUUjp6qa0Nc1MWFqlpiTzJQQzDso6jPr7Vgxa7f3OYoilvzjKDJx261t21kJYGMoLbiC27mlKTnG0RxjytNnmOuav5MwtRBthS6DZUcbWGD/OuP1ac25uYXJAMa4/4ASP5Yr6Bn8KWlyCxReR6VyuseEIA5JhDEdcjqK8qrGpQfO1dHt0KtOtH2admfNd1dNJOWRnG1sg5rSkupZY45i7HcuT9e9d/wCI/A9o8bS28QVvYYrgbvT57QhMttTgV6eExEK6vE8zFYadB2lqmRyos0e4ncMdabbWzibZgnuMd6SPepI6A8EVoafIYrqMMuVVgfwPWvRjucDOy8M2jxadJqEHDQfu7hfTPQiptC8RGLUZY2J4Y457V3dl4ftrXRjdRKNs0G2UH+NSMg/UV4kJDY67IgbOyQrz0IpzipRaFHRnvVjeQahCGVlJIwakjVoJGiJ+U8qa4DSHuLR1uLZiYmPzJ6Gu5t7xbyFTjbIvY14GJp8l10N07lps1HlgamjcSLz1pWVR1rymtShivSM4prHHSoXPvQIkJBqFutOXJFKEPpUgUtRH/INP/UVsP/SqKvY68f1MYGm/9hWw/wDSqKvYK9rLv4T9f8iWFFFFd4gooooAK474onHgSc+l5Zf+lMVdjXG/FIbvAdwPW8sx/wCTMVJ7DW55u0x3ZHapFmx159KpSZjYhuD0NLC6g4b8DXG4po6L2L5kytQygsMqfmHYd6a7qnysRz0qJVLOCSxU9s1nyNMdyaGUFDgN+IoVMsWdTjsKnCgYwBilbABH86TeoxQcj6Ubscmod5VsnpT9wPfg0mgFJVjkE0djzmoXQM24HmmwqyyAFjx+VLluMklUFeVBHpVCW3RsgKVPYitJxjr0qs5GDyM9qqLE0YF0JNpjY7RVGKJt5G7k9BWzeEcCRf8AgQrLdTuJU10RkZSRGUAchutTRTFEKEAgg4qJcvjaMk8ZPrW9ZaVHAiy3C7mXnOflFXa41c7Hw/bNFY26ycnYAfrW1Kpyy7Btx96ue0/XLfMSjLMw5C/w1ovrFlISqSbpegTBzWkbJEyTbOT8QW5D+cseSufyrj7gtuZiMHOQR2r0G9kh3MWbAAySe1cT5sP2mXJBjYnaaSegNDdHkD6gXkuPKbjPHX8a7S31RIcJIwzng+orjPMhjVljVDuPNI8hjf5dwI9aSlYGrnos16qBX4KscZqudXiikWNsk/xEdBXIJr8kkPlzQqUyPukiq91qU8rgRMI4xzs9T71TmJROyvdYjtiAOd3Ug9BWTe6nPZoUkkWSJx8rd652W9aWUNyO1RtJv5Ysx9KhyKUSWW4M0mSCc9zXa+Gn8yzTfEVXoPfHpXDWzKbmMOMpu5zXo+i826KMfT2qqYpGywTzVVBlRggetZPjOW3j0xFJ/eMwGAOQO9bUMWZVI7Gszx7brJoqzjAaNuT7GtJ/CyI7o85dpIl6Bo8896TdGSCuRn0OaiicIWA4z6UuEaRmTr6jiuSxuWAAW4OB7imyQluflIHbFN+ccgDAqRXI5K80gK0VrOszMBhcdBSy5bv0qyUdumQaiNs5zhsGgCrHO0LHacA9cVaM7SKGVgeMHNIbFfLBZvnPUDikhgWIlizc+vOaG0AjI0kewnCHqBTxI8X3SVOMZFWCwVFOAw65U4pnmROrEdAcc0rgUbnzpH3sc/Sqxd8bSDxWkZIw20nH1FVJ2XdlVx7ZzVJiaK+7LDIzitCG7jQddyjHyt1/CqIfBB25qUyLwSpU9+KbA0RKBDlFHPIPfBrufg2Sde8RE/8APtZ/+hT15zFIrrwenHFei/BrH9u+Isf8+1n/AOhT1VNe8TPY9eoooroMQooooAKKKKACiiigDzT4kHHivQP+vK9/9Dt654uea6D4k5/4Srw/j/nyvf8A0O3rmiefpzXi45fvjaGxKHOKduzUQIP1pSQfrXC4ljzxz2pc8cCmKTnnP41KPXNSwGgDuOad2oNNDY60DHZ46UHHXNJxzzSEdqQDjjimMATjFKg70N3zTQELAEdOlZWp+dLE0cfykjk1rN7HmqV0SAR0PrW9J2lcia0ORksktw4OZHPfHSsCRfnIzXXX6CO2mk/jbha5aZNrFe4HP1r3cNJyV2c8VY0tFuZDqNrtPyRHgZxya+gNIKpaZ9FA/LrXzzYzJay24yMiZSx7AA17D4X19NRtplGQqc5HpkitmjU7TfuQHGC3SlHQYqlb3Udy26NtyLwCO9W92MnPSkSN6nPtTU+6OetOU5X8KbkBQR0HFAAThsUxx81MkkCycngDJqUgOqsPrQBEp3MwpV+ZsHgYqpHchr0p0HIHvVqP74HvSGOPX6UvpQerUq9PXBoAlTnBIper9KF560o+/nNMRWvmEcRfIGPWvL/HMv2WVbho99rKvkzxgZweqsPcf/Wr0fXj5dmZCQFGQ3+6eteT+Jb9J7G4SRidg8skn05B/wA+poS1H0PPJY/KlK5yB0PqO1IPu0nUn07Uozj61sZFyyjBuAG+63B/GvX/AAZazaZ4emjuQQN3mKPYjBryzRI/PnSEKCWYfoc166hnsLG3Qs+xxtOSOAfX9R+VZyNI7HmHjZd2pm4X5l6bh3qn4fv/ACZxGzYjY1o6xbNDqs0DfNEcts9R3H171zKx/ZropuDAHgg9RUzipw5WS9HdHpKHKjnjsamwWYHuBgZrP0ubzrKNt+SBjmtANgEDr2rwJx5W0dKd0ICQKibIPHSpTyAex9abkYI6ketJARHrnFIuA3PFKTjOaFPJGM1QiUMPu9fSpXPHH6VXDADNSZDD2NRYZ6b8Lf8AkQrf/r7vP/SmWuyrjPhZ/wAiFbf9fd5/6Uy12dfQQ+FHO9woooqhBRRRQAUUUUAFeWTPt8YeKf8Ar/j/APSWCvU68ou8/wDCY+Kf+v8Aj/8ASWCuPHfwRonaY03zDUOealAGK8BxQxGbNIrEGg8nipY0FTyhYUEmpV4pdoxTWODRawWJRS5qNHFOJBFAIeGFPBBqtgk1aiXihbjGyYbg9B2qhqE/kWrv04rRYDOaw9Vbz5liAyB8zfQV2UN9RM8r8TxTXMpuJycE8L6VytxEvljHQHAruvEimW42NwFyTiuJvMCdUxgDOa+mw0vcRz9TNztkDDsa7PwG5l8QIj9XG5s/UVyIQG4QY4BySa1tG1H+ztc80MPliK8Vo482jNFJx1R9e2bBdPi29AoFWH5wK5Dwr4ih1DRrIOwWSRNvX+IdRXVo4YKaylGzBO4S9PpWRfqRbE92Na8vQ1QuVDQD60ugyiIViQLjoKzZovMZs1sycqx9qzmGQcd2pDMC+g2iR8dBxXPsv7xlH8K12WpQ4s2OOetcnEm64m/ACsKi1NI7E1lbbrfB/v7qrmMySE4/iNbttalEC47E1Ujgy3ToamSKTCyhInVuxFdvYDFqVPYVzFpHtCEjpmurslxagn0q4ImTNG3+aFciqt/bLKuSPY1dtxiMD2pJgCD71pKKkrMmMnF3R5/rWkiIs4TdG3Ue9eTeJ7CKGbcq9Rkehr6B1REaxk39MGvDPFpD3HykBW5B965sPhvZVeaOzO2tinVpcst0edyxgzlQOGGVrc0LS/t9zFAUy7Hb06g9DWJO7pPg8FGIIr074e6eL2eKQffQ4yP0r1keYzvNj2fge1juGxJEhiY9MY6ZrwDXkaPVJJwoAZsceor6L8QwGay1Gw5xNF5qZ+mCPzr5/aMzpc2l3xIgZcnsw6H+lUvhZK3Ok8K6yhjWCY53DGDXcWo2yKVPB6GvINGQpMI3JHPGO1eqaSZPsqndvUfmK8bGwtqjeLOgQMPm/OpHcsKihlDAY6GpTt+leG4tMqzICWphz3qwxXFQMwpWCw5CKnVhVUMPSnB8VDQWIdVbJ00f9RWx/wDSqKvX68a1E5fTf+wrY/8ApTFXste3l38J+v8AkKW4UUUV3khRRRQAVx3xQ/5EWf8A6/LL/wBKoq7GuN+KRx4DuD6Xdn/6UxUnsNbnm17GfLEirkr1quiFhu6e1XQ29c9jxVQJ5MhH8J6VxJ9Do8yVjBMoj3FZV4G4daWDdGTGSMjsR/Kq11DvAdThhTftLMijyyZh39RRfTQDRaQqCCDn0o3Aqc1HbyXJGJBGy4+6R/WpjHHnCZjkP8Dd/oazlqNaERIIw3SmHchA6oTwaApyVJPXvTpc7dvFCGHalidN2H61CJAO1QtKNx/LnrQkFy3M204B6+tVJGbdjIxTftKhiobdx1p0Ukcxdd27AqkrARXSA2+GB9RkVkMoDfeAB9a15UZ4Sm7OOgrMlhb/ABq4kMZZtBHclbkMYj/dNbclnDPAwtr1gnZCd3/1654wyEtsG4DqKZ5jocZZf0rVMRt2LPYt9qkeMRJw2GyamF8BdteBJdh6YGfxrnjdMUaNj8rdeKmiv54YhHHL8o6CncLmvem5vkDNLHFGTkLuzn61gT2zCfYShUfxLxTmuHJbJGTzwKlt3tzGfNkZSO2M5pc1g3KZ64U9KjZn3ZycVdnktPLKxRvu/vE1SL468ChMTHq0mzdtOPak88ucBT9TSJccjH4U24Do+5hx6imguaFp5fJkUH69AKW4UKBJFt5PIB7VnR3JC4xwRinghzkMRxxRysOZFhygUseD6V3ngtTJA87OXbpyc4FefHLR4YZzxXo3guHyNIEZzuPPPvVQ3FLY663hLHceAe1ZHjqxefw27Izb4iHwO471uWgLDDdR6Umrp52mzxHoyEE+1b2ujK+p4SrnoaFcq2fXrS3CrDdSxjBCsRxUW8da5Gbo0Yr5lXawBz6jNPVxkM4KhuR6Gs0MScA8dq0YYyYdrkMpHSpskM0DEwgD4yvYrzVRpl2n5hmq4nNq/wC5dh24binNP5xLSoGA5zjBpco7imSQpu3jB9qhM+T8xHHfFMlljRv3W8ex7U+OXzANyo4HXIotYBWmcxMq7WBHbiq6XAjjw68Y/Wrw+zFQGQqfXtUMtrbMwKXAy3brTTQncqyszssiHgDoe9MeTJ4ODjnNTvbvCm47WU/xA1UnMg5CZFUtRAkpMwPAANWncKhyeoqku4KC6gA9KlxGybicBT1zQ0NMljdIrZmXlj1r0f4HyNJq/iNmxnyLT/0KevMW+boRivTPgaANX8SAdPJtP5z1dPciex7PRRRWxkFFFFABRRRQAUUUUAeafEj/AJGvw/8A9eV7/wCh29cy+Q/HQ10nxLOPFXh//rzvP/Q7eueYZXH5V4uO0rG0NhFGOfT0oIDcr09KFxSEENuFcVyyRe1LuqPcS3yipOSOQDUsBTyKQnPegjIOOlCjnPpSGJzkA9qUnvSMcc00tximBICMe9MJJxTdw65/KkLZHXimkAhyTg96guVJHfip+Co/rUUwDIec+tWtxNaGHex705wBGcn8K5Z1HzySd2PTrXXXkbNC4HcY6VzF9CY4sKMhMBm9Sa9jBzVrHM3aRlzHaVI+prqfDmsxaTo7vI53XUghBB6DHJ/DI/OuQmJB29ec017hzDFFnhGJH44/wr0LXBysz3Lwxq8cWkqsz4KBQfUs1dcJi3XpjJr55t/Ec8FpJDuJLyrJn0xXb6d8QRClt5pGydmDknlAMYqXFlXTPVEOSfZelMd9qDPAzWbpWrW99aR3Ecisk3AIPeo9X1KHT7ZnldRgZUZ61IyrqmqiHVPs4P3lA/UV0UBLwk4IOK8c1PxnaG984Ru0gOQCteo+E9bTxBoMV4owSSjA+op2Eznhr8A1hEQ7t05RW+g5/Wuzh52nqSK8A8TahdaX4xuosbVtrgsqjjgnP8q9U8L+LLXWPs8MUg3+WzMmeR0xQ4tK4nJM6z/loeOtA4OPWo45BIwcdxT2+8COMVJRZThfalwdwpqnKLinL1piOc8cGSPw9M8bEOnI9/avCL29ae0YOcswCnPsa908cTrF4euA2MMACa+ebiTEkiAgjcauIpMhB+U1IrEgLTFPOPWhOmf7pqyEdBoB+w6/aiUfK5UqT0INeualIx0iQQR+fJApfGeq9wfevPZdFGoeH7eSJ9tzAm+Ns4yMZ2/1FNg8YzNYW8ZfDlfKkb37GotfU020MzxDfLcyQX8JOVbbk8E46ZHrXOyOFnIA+RvmX2Fa+qNGZ2CgeTcKJUAPCN6fnkVgliTgnOOKaREjrvDd9kmEt9M9q6diwKmuE0O42TgHFd5C8c8IwcNjvXj4uHLUubU3dArjkHPNM5Q8dBShVZuuD2oPZTwe1chYxz3zxQhOSOKRt2eMc0cggGmA98dM9Kc77EXH60w4BBwc0089SKVhnqnwr/5EC2/6+7z/ANKZa7OuL+FX/JP7X/r6vP8A0plrtK96Pwo5mFFFFUAUUUUAFFFFABXldwM+L/FP/X/H/wCksFeqV5Tctjxn4pH/AE/xf+ksFcWP/gsENOQ2KlBAHNRSnnIpu4la+f5hkwI3ZBqUNVBXZTUiSMT0o52gTLZkphfmgHjkVG33uKhyuFyYc9KcGOaanAoLgGq3GTK3PNWUYYrO8ypVl461cVYaZPNKVQkVkxjie4b6Crk8uIuvNVZh+7jiHfk1109EKRw/iCErK8jD73NcFq0XlugGNxGT+Neo63aG4mXA9TXBarYl9RVACRu6Yr38I7xRhLRmA6rHIcjqorPJxeE5I5rV1m3a2v3j7bVIrBZzzzz612NjWx6X4a8UPA8ljuKvbTrPF6kfxCvf9B1qHUEEYceYFDYPXB6V8ew3rxags4OGI/pXp3hjxnKs9iWl2TIvksxPB7rn+VVJc6J+E+ji278arSrmJh71g+GfF1rrcLRM4S6jOJI88g10JOcjNczTTszVFEnII9qopy+O4arkx2N/OqTSCO4VvXrUXKE1OI/2bIe9cfYx7tQ2DoXJNd3dxibT5VH92uN0xB/bMn+yDWU17yKi9Gb8UYBbj+Cs22i3M/s1asXLTDuExVSzQbWPqaclsCY2JT5yRD6murhTZCqVzekx+dfO56Bv5V08fzHPYVUBSLkX3agu5AiZzUobCgVheI9SjsrQs7AZrRK5FzF8Ua3HZaNO7MASNo5714BrGtmaKNWc5+dOvpV/xn41bU57m2t3/dJL8p9cVwk8zzZLHk/MPqa1SSFc1LU/2jqEcbDBlwp+vSvVvhJciDVbzTLjKTKvGf7wPavItEuBHq9q5OFZ1znsRXq+u2T6LqieJbQ7GgMbyqD95DwT71tBcyM5OzPTvE1ysNrBfqPkjfZLx/C3Br508RMbTxNPhiY5R17EHivXh4uttYjuLXephkVJE57ZAP8AOvHfEiH7RdwS8XNnIUB7shJ/lTtyxEtWVbK5kjn2kFipxkV6J4d1R9u3nPpXl1pckTxueuea9O8Pz27qhIH1rzsWvd2N4nVQ3fzkHgHkVf8AP8xcjrVcQ200QZGGRUkcIA3K2a8Ooky9R3mEDBqJpDmpHzjpUABLdK52FyZGyOaXdk01RTmAH1qeUqxUv5Mz6Wvrqtj/AOlMde1V4he/8fOl/wDYVsf/AEpjr2+vay9WpP1/yIluFFFFdxIUUUUAFcX8Vf8Akn91/wBfVn/6UxV2lcX8Vf8Akn91/wBfVn/6UxUnsCPMrafaCvY1ZCgt83PpmsvOD/StO2bzYc8ZHBrhqLqjpiwki3thRhaRYEizgc9asqo8k46+tU7q7a3hbZ948A46Vmm3oVsSNIVOMHPfFMuJjNDsAO4HI9aq21zPGd5IJPJDc1fV7e5+6PKl9D90/wCFO1hCQFpVG/iTtnvTZgcHHUdaQ7wQjjGD37VIzmRMHG8dx3o8xmfIV3cnBPYVFs81j2x61bby85YewNNKpnOMehquYLFb7KmMHJPbJptt5duz5j+XPUDpVssueeB60mwAnPKsKE+4rEygLkFgBjqBVabbIhRYwW/vHintnPrTS+D0FNSCxnyqYGBcdehqnO6thSQSOc1r3e2SA8Hd1ArJCMrFioPYcVad9RFNl5+UHIprq46jAqWTzUJH8PbFNSbawDgEZ59qsmxAQx5EhpmWB5rUe1t5l3xMVJ/KqjwEdDnHBouhWK+/HSk381b8iOM/vGBOM4BzURtyzEoMChNBZkcYVnGByKkuz8oUEktQLZkcbuBnqKSaUxsAmMdafUOhUdHjxuXGakEgCqW4zVwsksG4gEMMEVFLArwLGBgr0q+buTyiq6eYgdsLuGfpXo+gzrbclgyEDkHNeZPESVI4YDkVcs9WurAFMnyj1BPT6UeYLse0pdKV2bsZ5yDzUt5fJFYSscSFUPyk8151bao3kCaGfem35cdRTo72R3cySsQUI+Y4/A1oph7PqcpqsIjv5GTmN23Lx2NVACQME/StW7S5uNisUYLyG3VZ02K3txOl+qurptQIMkN6+1ZvUtpLYwgSBkHketWoZtqhc/L2z2qO4jWN+B15pbeMStsIIOOMVmwHyFgcg5B/ShJNo5Bw3Wny23llQsmc9jULSCM7SefpxSGTlUIz36GmmAqdy8H1FRrdBThyADwTVhJGZdy4KnuKNQK++RPvdKeJgRjAPtVjIKYMYz7GkFlHJkq4VvSjQNSNW2D5SRnselKVVgSQVyOo5FMlhmgXcy5T1HSiO5BGM7SaVh3QxoSynaAcelQAbRyAB0INXWaPdnoexFMkjDL82Gx+dCYrGbOxhYFB8p646CvUvgXJ5mreI2x/ywtP5z15q6AkgjHv616T8Cl26t4lGcjybTH5z1tDcznse00UUVqZhRRRQAUUUUAFFFFAHmHxO/5Gnw//ANed5/6Hb1zytkAV0PxO/wCRo8P/APXnef8AodvXMocNXjY5Xqm0NiwoGKNvPzGheQCOlPbA5FecaDRwOKTdg8CmSOThRQjEDBGRTsIeWJIIp46ZH5VHnPK/iKUHn39aBitmoyQakY5/rTDjv9aEA3Ge9IQMf407gEnvSEjHXBqriEXGACKHXIPOPwp3p601vpTuMo3C+Z8qDrwWrC1eEQwxxLjl8kH2FdI2A3IHSue8RtiJAgJc5FduFk+dIykktTi58GRiDwM1V6n1q3IpEZP941V55Fe7HYwY3PoadvJA5PHamDrinEAAEdfSmSadhr1/p8IiguHWMPvC571oaj4kuNQjBmkZ2xjk1z0aliFAyc9veuqOjWNvYLYtifV7j5mw3y2y+h/2vX0qXYtNnMy3LTN8w/OvbfhDcB/C8kRH3Lh8/iBiuE0z4b3l8xM11Hbxn7hYcsfYV6T4E8PnwzDcWz3HmmVhKOMYxxSk1YEnfU8++JGj3d58QpI7KBpZLiBJAq+gGCf0rH0NdR8K+KLFruB4C7qpB6MpOD/OvSPEDC38c6NcoejNaTH2YbgP1rT13Q4NTjizGvnLIjK+OmGB/lTUrKwct9UadtqdumoHTjIomA3hO5U55/nWgsyvK6A5Ix/KuU1fSnPiKx1aL78DBHHqhz/LNaarIdRklRyAp+bjrxWbsWjoYZMpg8U2SXaUGf4utYtzqptpLSMqf38u0N2+6T/SotW1A26RNuxmVd30NA7GH8StQC6Q0SvhQ6h/xzz+leJSxvHKyMPmHWvRfFVw09lqSyncEeJEb15bNcpqGkXYuYGMeTNHGQQep2gVpHRESWpj+Q5h8zb8p6H3FSxInmpvOI5l2k+h9fzwa62x0+G58OrA6HzijMD6OjkEf98t/KuYFu0Z8iRSCHwAfXoRTuKx1uiaiV0N4JEHnWp2kZ7bsj+o/GuPuxsvJ0UYTcSoHp2xXQ28TvatOWCzhAkn+0Ox/kDXOSkMxYnO3A/CgbElkMlsuSSV/rVRv9Zn+9zU6sNrKc+lVS3HPUHimiWWrdzG4YHBFdlpF+XVQxyelcTGeQRXReH5lNyFYDB6VyYqmnBsqm9TsCdwyBzQDzg8n3p6p0AP4U1/lOCOR2xXinSIVBHXFMZeMgZqXcCPemcY645pAM46Hv2qLcQ2OnvUzDnPAqNhlT2q0Sz1X4Vf8k/tf+vq8/8ASmWu0ri/hT/yT+1/6+rz/wBKZa7Svcj8KMGFFFFUAUUUUAFFFFABXkl623xt4o/6/ov/AElgr1uvHtT/AOR28UY/5/ov/SWCuLMP4LAtFg1LtGOnNV4Dk81eVPyr5xp3KWpCIvWlIC06RgvNUJblmfA6UmxNpF3ecYqNM7vamRTgjBqRnxyKNxFkD5arSAg09JTQ5Jp3sURAk9KmRSaau2pUwKakAkkeU6UrIC2MDJGPpUuVIxmlAAdm/CuinMDKvII4hI+BuxtUmuTs9MGoarPcbcRRLsQe9dXqjHBqHTDFbWflcBnbcxr38BO6Mpo8o8Zqq63e7BgRhEH4DmuIfjPucV3fixTJe3EpGfOnJBHpXGXcBjVRjHy7vzr0ZCiykGwwJ6Vct5zFLlmOOMn+tUnztGelWbF43cRy4HPyk9/Y1MJWdhtaHV6Zrt7p2qRalbS4YMBJjgH6/UV9AeG/F0Wr2qMWxIAMivmd0Gn3ig5a2lHH+6f6ivVfh1uaCQZzJDIE+qnkGnVWlwh2PX7mcEb+MVQlkWQDb17U6EM9sc9uKg8vKZHUdfauZs1Rr27b7LnnK1yOkjfr14R0A4rorOYrakN/CTmub0h/K19wekqH+ZqW9UNdTbtZM6hNCepj3Uy2dQJlGMoxBqAv5PiBW/haMrUSt5d9eDPEnzim5CsaWlN5cWf4mNb0cqrECTg1ydpOyHPqcAVcW/8ANu/KBOxB+dEGEjoXu0jheaRgqgZyewrwT4m+NjfTtZW0m1S4UEHoMZ/wrrPHnigxWrWsLnylGZCP4sdvzrwW/kluriKST5pZZGb684rojormbKMW6WXnncfzq3eWMtpLAsqkBl4q1Z6JctM2UKlOenoa7PxnYw3O144sNAUxj0ZR/XNaKPu6kt6nA2UDPK0C/wCtVgyY9fSvZtSvI73wRaSOhxNB5bEeo5/nXlFqhi1iMoPnOwqffNep6tBHa+DWgVtnls0iD0BwSPzNa0krEVDy221OW1cEOw2kr17GjxBeC41gXq523Chm9+xrPu+IkkHPmLn8QagmnMtsinqvT+tZuTtYuxLGm12Q87Twa6jR72a2UbckVyUcu7Ye+Np/pXS6RKysAVyKymk0Uj0LSdYDABxzXRwzKwBQ9e1cxpNrb3CgkbTXSQae0WNjbhXjYiEL6GqLg+ccil8vFNR9hwwxUjSKRxXmSjZlWImGO1RSPgVIze9V5OajmE2ULiUte6Wv/UVsf/SmOvdq8JuV/wBN0o4/5itl/wClMde7V7WX/wAJ+v8AkZsKKKxtf1Se1WDTtO2tqt8SluGGViUfflYf3VBH1JVe9d4GzRXnGi69r2u6f4X05dVa3u760uLu8vlgjMhWJ1QBVK7ASXGTt6L71LF4k1u7trLRFvI4tVl1mfTJb9YV/wBXCjymRUOVDsiqMEEAk8dqAPQq4r4r/wDJPbv/AK+rT/0pirS8MahfvqGtaNqV19sm02eMJdGNUaWOSMOu4KAu4EsOAAcDgVzXxS16zl8L3elLDqAuPtlou9tPnWHi4jP+tKbP/HuenWk9gR50rBxmrMDNG4YdB1qoEKPtwR6VfhJK4xxiuSR0IsySluRxVS4dflDc89BTnkKDaOO4NRJHubrk/SoSsVckRVddy4OaQx7Vz1H8qsx2siAZXANWv7PmkU8BSBn5jjikBTguAMJOnmR9M9x9KsvbKE8yBiyd/VaptFgMy8heo/rSPPIsDLDIVyPmAoAkeLzgDwGbPynv71CyEDGAKrRXDpIGUnd9M1ZSVQMsDn1Ip8oXIHbZg45HpTFl2j5T3+6eKtsEZck59xTEiDHnt3ApAQiZXyeh9KbvHrmpp7APhomAes2e3ngkUjd7gDOKEkFy9tVyQWA471TkByQMfjSZYAcnr3FOwT681aQiBlLHkcY5xzWZNtLFlGK2D8gyenU1muokyB9w9BVITIY52i75FK0iykc7T7VFJblOnIp6Q7SC2BVaCLSxKBlAjH3OKbOjYw+FxzgUseOAwOMZHoakIEg2kVN9SrFaQrs3OCQB2NQuY5lBRNp9zVowjvyPalW2UOOm30qk0TYhjChFDKAPQVIVDds/jUrQryVOAOxpq4xg5BpbjIzHl+nI701rd9p+XcDVkqSBtJJ9qlSGYIHaNgnqRgUrsLIy41ltdyhnRG7Z4zVmMv5Hm+afoH5ParVwqSoAMletVvsG074zuC84NWp9xNPoTpKxVVfAx3AzUUrSTMGDHBHcVKQ6jI49Rio5w4GEIJPPNSpDsRm3UqBv57E1IZ5IkwUUjH3sVBvlBBPUeoqQXbIGUqCGGKBFdrp2kHsT1prEFwzdjk1MbfbMGYZHenukBxxj+tMDNuQoZSucGn210YWCkAr6VM8UTfLtOAevpUH2ZQx+YnuKeltRGpHKOORz71MFUj7xFY6B5QHBG5TjBrWtnjmi/eDY9Q1YpO5IxxGVPIPPWq7WsT9cKT3FWvJZFyp3LTPk64IA9aSY7FMQsJAG5Ud+xp32c9A+PQVY3+YSEXPc02YSLDhFw/8AKne4irGQbhomXOO+K9M+DKLHrviMKMA29mcf8Cnrzuz8wkrIOeoNekfB8EeIPEeev2az/wDQp60h8REtj1uiiitzIKKKKACiuF1rxJqcniHSxpU4i0lNVjsLh/LVvtUhDb1UkHCptwSOSxI42nNO48Qa8NJv/FkepBbC01F4F0zyE2SQRz+SxL43hzhmGDjoMGgD0aiuB1PVvEF2fFGo6bqa2lvoLmKG0MCOty6QrK/mMRuAO/aNpGMZ5rtLS+S60qDUAriOWBZ9oUswBXdjA5J+lAHnPxPOPFHh4/8ATnef+h29cypzWr461q01rxPon2aK+j8qzu932qxmt85eDGPMVd3TtnHHrWSmeO1ePjf4prDYnRip9jSk00EkUhOSM1w2NA3Atk07FNUZqRVIpMBpGB/WnqQev50MnG4im8AjHI9aQD8Y6U0jqeDikdjwM8U3d19KEh3AnPpTSe1O3dsmg4piE3enNIxBWnhc89zTWj5x2NMZA3OfSsvUbYSQTOcZ27FJHQnvWnIhD98e1Zt8jSQlNvyjnnvXTQdpGc9jhrtAJDgfKOF+lUSm2Mt3zitvUIMzlFHTgEd6yrpNkSL3JJxXvQd0YWKXqaXPFOZeBTCCBWpFie1iea4SOI4diAOa9X8JeGoLVPOYLeXO8FsfdB92PX8K850S1jaVZ5ztjzgH1PpXtnh2MpEYz92EKo4wFJGf5YrObNYotppzSXa3l24kkhyIlHCJnrgf1qDWtYj0CS11C5ima3BaKVo13FQwBBx6ZGPxreCZ6fWmvEsv3lDKeMGs0+5TOK+xza3dx6nHFKiT38dyiOPmWNVCgkds4zXaeXkrke9SxxIj4CgDAFOYfNn2obuJKxXMYc8imLENzEdTyasqOPehV3SH3pDMnUNOF5Eig7SjKysOoIOazPEAMbWynndcIrV1BUI4BxwaztUtPtE0BI6Sq5oQzhtY0zzdPt4cKJby9y3HYZx/OtDUNHD3NkAvyRt83HOB0roLnS1kvbIqMpBKzdO5Bq9JbqXy/PP60+YDzmazWzmfIIIubh0GeCuRxWT4n0om9aZAVMw3r2+YD+tdlr9kWuvKTHmYZ0I65LiuV1m7ka0xIWyrBgc8jBwR/KtEyWjA1C/k+y28u0BmUq+3gN0rBjO4sOuatzXIkhlgbqkhdO3B6/0qlGCsuPxqyL6iqAWZe+OPrVNj85471o3EYQB1bBrPfBfI79qEKRLEenNaWlT+VqEfPespThQferELFLlW9xUTjdNCTseqR4CKR6Z60S43Z7kUyyfzLOJwRhlFTsuFHFfOPR2OzoVyuB2yKTHvk1Ix29qZgnBxxRcBjLgE88etEXzA5HTih9xJA4xUkQJ69aroSenfCsY8A2w/6e7z/wBKZa7OuN+Fv/IhW/8A193n/pTLXZV7sPhRgwoooqgCiorq6gsrSa6upVit4UMkkjnAVQMkn8K88k8Y63Yahreo3o22MWhtqdnp7xhWjwzBd7Y3bmCgkZ+XdjqMkA9IoribfUNb8P6zpcGsar/aUOo2szyA26RmCWNA52bQMoRuGGyeBzVPS9a8QRWvhjXb/UluLbXpY0lsBAipbCaNnj8tgNxK4UHcTnJPFAHoVeN6q4Xxz4nBP/L7F/6SwV6zqOowaXaG5uEuXjBC4traSd+f9mNS344rxu5uY9U8V+I7yBJ1je9jws8DwvxbQjlHAYdO4964sw/gMTLsb5xiriSnbiqMCMO1XACBmvAsVEinfANVFwT05qy6lmqSK3yahrUTRCsZxxTgWDYNaMcAximzW6rRyhyjYlDClZPypqHacYpkjkHvRcYpTAyKacjpT1OQKccdxVcoiASEHnilN0EznpQ4U9Kng0xrgHjg04Jt2QbGFqF2HU7eayxOcu2SMcCu2TwiJQzuSE61zd1pQtJ2VVOwHqe/vX02BpOEbsiWpyPiWyQXNtCfvRQiR+2Se1cReWcjh1KksByfSu/1GF5rqWWVfnkYE56gAcCmRaI01rNcuvJOB9elenozJHlmrWv2SSOMjBKBjWaMqQa6Txgo/t+WNfuxqqD8BXPvGd2PwrCcdbo2jsX4r0y24gm5wcxse3tXrvwnbzvPBPzIoRvcZyD+HSvF7WIyXMcYHJOK9f8Ag/Lu1G4hzhzHkZ70224u4krM9rt4h5BHqaqiPy7hlI4Zav2h3QIe5GMUy4iG8NisGjRGWr7Jp4ScFk3CsuG0Md7BMAfl4zW49tukZvbFPt7YNGMiotcq9jMnhJuQ/cCmPCTJv9QRWtJBktxTHhCp06CpcQuZUULBABnjvTUspGkZgSMjH4VsQW4KDjrUrRgEovXpTjEGzxvxlby3GprbxZ28t0646frXO2nh0XfjK2solJjto13HHU9TXrGoaMsviCJiBtVCxNQ+GdCCazfXpQgk8E+9dUZWRm1qY9t4dCvePswoicJ9T3rM1S0Cay0Jycxwq6n2H/169UNkixMmByv9a831yNrrW71YuGEyLx1wKuErkyR59cWZs9ZilxgxyDaD6g1u+NtXkh0vTwv/AC8WxLjPXJPWqetgNdQOwO7cxJ7cVharqA1jT7XA/eWy+Qfp1FaxdoshrVGGXMloFPOwkD6VWXmBhjlTmpoD8jIc5zUZGyQ+ncViaDIiQa6HSLnaygnv1rnwmG4PGa0bA4k29Dml0swPVtDdJFXnn1rr7UlQMNkYrzzwzdeU4SUZU969FtI0eNWRq8XF+7I2RIwDtkio2hx06VZK7eCKaTzgCvMcgK/lE1BKu2tDbgZNUpdxk6cVLjcUkVLpBv0xv+orY/8ApTHXtteM3o400/8AUVsf/SqKvZq9nLv4T9f8iWFZereG9E154n1bSbK+aIERm4hVyoPXGRx0rUorvEcNpvw6TQdM0pNEvobLUbAy5uRZgpcCTG8SRhgT9yPB3ZGwfSrn/CE+XpNrHBqbpq1vfPqI1BoQ2+d9wfcmQNhV2XaCMDHPGa62igDG0DQ5NIN9c3d59t1C/mE1zOIvLU4UIqqmTtUKo4yT1Oeaw/iy234d3jelzaH/AMmYq7WuI+Lf/JOb7/r4tP8A0pjpMEeXxFZdjEc9avwhdnoT6ismBz5cWzA7c1qxEjAI5rjZ0k84gS2IMJkfuScAVk3JlhMbx5xtyzDjnNa8kxaLY65U9WA5qi7gfK2Ch46UxEH9r3EsflyNxjHHersV00kAyB5meSTWOUAnIVvlzxVmOcK2CQMVLiO5fW4IYMCA44+tR3nlRwG5iwPmAaP0z3HtUeRuD4GO1QzyRmPYxzn05qUhlRp8zF1XYfarj6gvlAY5ZeTnGDVJ4U6l8elNJQEpsJ9zV2Qie3iDPwxI9Ca1EUKoxjFc+tybSZSF+U9Qa27eSOePfGeD2z0pSQ0TN8mWBx3qCaYtnnr1OKkkHq1Vn7bec1KKsQygN/FuH8qbHCGYBjhfWnnAPINO6Dk0XFYguUWMZU7hjnish98LHOdp9q1pZ0PGT9aqSShtw2gg+tWmxNFVZImGOR65oPllSNoxnjmoHhaM/L09KZtbbjlTV2EXYnjaPyyxyOQaQyKrBTjPYkcVVt1Ky/Ox4rRaJJUyCM/Wpeg0VckMc9fQdKnU7+FXJNU5AY3IJPHrU9tOFc7uMim1pcSHSM4baVwfQ0nIXO089jV47JMMAGx3qKSBTkq2zPalcdiC3n2S58pWI/hb1qW9u7mVgJiTwMDPH5VA8TAEr8x7U1SzYMoIIpoRKH3IAQB+FWImtggUo4f1U06KKOSPBOW7E1AY9rk+lICdnTBCk/iKjfDL8p+b34qKRyqHnA9apN58hISU4P4UJBctOD83BIPoaqtHuJw/4Gpkj2qRv+f1qJoZJAeeapCY9FaQdT5o7A9RR5itkODuHp1qqi3CSgLncOlXvIklO9kZXA5PY02IpuQTtB4+lMxmJhzj3q4wAbBChhwcnFSxxqEYuAMj+E5zSuBl5EUO0L9KmiuQVCtlePwqC5PmSnGQB0zVu1tkmiJYDeOtN2tqCvcniuXhUbDkGpDfwB8yRkMevcVVntpoFMkR3DuKgEyzAhl5AyfapsnqO5oG/txIViVslc+marR6lJIuxlAYH8DVF4EW6Vi3yEYyD0NXY4ZNyjcGXPQ/407JC3JPtUkbcp09DXpfwblWXXfELr0+zWec/wC9PXnghiljCSExydgeh/GvQfgzAbfXvEaNnP2ezPP+9PVU37xM9j1+iiiugyCiiigDjtZ+GfhnVri1nXSNOgkjvFuZ2FmrG4HzbkY8dSck89OlE3geaWS4s11croNze/bprD7OC5cuJGQS7uELjJG3PJGcV2NFAHI6r4Mur251ZbLWmsrDWMf2hbi3Dsx2CNjG+4bCyKAchumRg11cMMdvBHDEoWONQiKOwAwBT6KAPL/igceKPD3/AF6Xn/odvXNqOpxXR/FHH/CUeHc/8+l5/wCh29c0Cd5xXj47+KbQ2J1wcc0Pg7QAB701GxxQz5529PSuKxY3eysevtS+aTjrTGfIwTTFJ70coFoyDHApocH0weoqIOCfegkDPrS5QJHcIcDkH2qNXw3t3pCVY03C5PNNICRm3DH9aFFMyD2oV8HH86LAWcfSkPy//XpAR9BQevWkMjf2yBVK4jLdz+dXWBPAHFQugIwBnPetIOzE0Yp00Mrysm4nhFA61xupxlLto+y16VIAkLOTggYzXnmpriaR26uxPWvYwlRy3JnBKOhktxn2zTcDAqR8nnjmmgcg13nMbOnPAqJJMAViwET++3qf8+le36DItzp6yrgiXDHA9q8EtUM1zDEvJJ6fWve9BRYNOijT+BBGfbFZzNY7G2h+U4B470ADIHYU1RgY9BxTgfmNZjJE5Ymk6s35U5flWhfuk0CGHgHntSJkFRjmlccgZOKaxwARjNAxH/1nTvRNHuVCexpWHzeuakcbozmgRGhBYcc+tQ3HCYI71LGcNwOtVNUm8q1Z2IAA5NAzmvENyqXdvMONwKhh65H+Fef+I3EPmWy524EiBvvDP3q2tduZhq0aO260jds47hhwfzrltbu2u9Ptpy+9o3aOQ/lj9M/lWsUTI5+R8yhx361KkbOhkQEhOuO1QEc+xq1pxkFyoQjJ4weh9qpvQiK1HzorW5cNhxwQBwayn4aumurErGZlXaB95DXOyqA5xwPrShJMdSLT1GYO0U/f8647UEYQGmrktTZmelaFN52lw4OcDHNapfAIPIrJ8PRhNKhYD7wrUkynPavnq1vaOx2x2GeYMdOlRGX5DgdDTjzg44NQhBllyc+1QkhMeJC/Ix6VIjFW5H60xVOADzUyqHHuOxobA9N+Fv8AyIdv/wBfl5/6Uy12Vcb8LP8AkQrf/r7vP/SmWuyr3ofCjnYUUUVQEN3aW9/aS2l3BHPbzKUkikUMrqeoIPUVyDfC7w1/bNzeRabZW9vPp72RggtlQqX3BpFYdCVYr06d67WigDl9M8K3kWpWl5rOsDU/sNu9vaILYRbQ+Azv8x3uQoGeByeOag0zwTcWUulW9zrLXWk6Q5ksLQ24V1IUqnmSbjvCKxAwF7E5xXX0UAFeQ35H/CceKAf+f2L/ANJYK9erx7UTjx14o/6/Yv8A0lgrix7tRY0Wo1WrKopGazomYt1q9HJgcivBTKuhkick9Kri5MfarUjjriqUwDGlKNxFmK8yafJcA96pKoQZNODKx61PIBdSRWHIqtNMASKZ5ir3phAc5zTUbCJ4JhjmiV95wCahUBB1pQQR1qyki/YWZmkBPSuxsbGNEBIFclp13FE4DGuvsrjzlGOB6V6+X04NX6kSRYuQPKKgDHtXKataEo2FGepJrrmAbj0rNvLcSZyMgc16yJPK7zSne8hhXJdjub1zXR3GmR29gsKqNq4yfp1rXttPDai0xXJHAputqINKuX77Dj61fMJI+Y/EYafV7qXrvlfH4Vik9OOeDXV+IbbyrmNAv7w8/ia5i5Ty5cdlOKp9wJ7DaNShbjaDnmvQ/h7crp/i21YH5JGaMivN7Rtt0voDj9a7LQS0d4LjJzHdDp7nNPeI+p9LRDYhxjAOalfDJn0qhY3QlgVieCAKug/Ie3auZlkYUYc/WpYY9sQ+lRx4ZWH4VPKQkR+mKAIkTMe49+aq3AwAndjzWiq/uVHtVC4/159hSew0OgfKk44HAplsDJcEke9VxLi7iQfdIIq/aLiXA7CktQaKF/bhJ5Jcfw4qXTYV+zlkUDJ5p2vER2Mj98Cl0ds2n45NadCSLU5hDE7dO1eSm7SXWNXOTuE+5cHp8td940vfs0UYJAGS2c46DNeL2F26/b7uZjuZ8ZHfvWsCWO8WMbaSFM5Krux/vVw6z/Z7pv7jHB/xrpvGF6J7mznH3HtlOR39a5W5iO7jn0+lOUmhJFi6hMUqyp9x+R71E6hgHH41dsm+06a8UnJiO5fYU2W1MGGYZRuDT31GVIoy0m3HWrECFZsHqKkhi5BTqKt3UIRlcdx1osBvaLqPkOolGR616Hpl8rIrRv17Zrzjw+sU8gil79K7m20iWFd8D/hXl4tQ2ZpG51S3qlf3lMe9jXpWKlzKv7uZPxp0uGTIJryJx5WaXRpy3/yjAqJZjJyKpRoxUfNVuIEEDHFYuYm7jLuQl9NU/wDQVsf/AEpjr2yvFr6MB9MYf9BWx/8ASmOvaa9nLnek/X/IzYUUUV3iCiiigAriviv/AMk9u8/8/Vp/6UxV2tcR8W+Phzfc4/0i0/8ASmOk9hrc8lidVwvDAHPFbMHzxhwp2+tcxCzRyEY64Iq3DqRjJTBK9a5uU2Z0EkL7SCCKxruaQkrsZMHA5xSvqDTMpcMqLwuOBVKabzCSWNNLUCeLzBA0KtgNye5qoyuHJGasQyF4gVHIqwpE0e/A3D7wpsRVWR2QJvOBT0VuPl496lESqwPY1OqM6ZVfY1DZSIxECuc/N6+lRS7JOS2JV4IPerPKenPrUFzEHTeo5FSUZt8jbVbPA4plhdtDLyeDxg1f2iSPZIMZGPrWZLA0E20/8BPrVLsxM6GO4MxH3FBPJyDipJI+W5J29cVz8TkYI/GryXk2zGdwNS0NMtvIsZ2gkkikYjaCSDu7A8j61QEtyZDmIFCeDnkVMY8kHByeMGlYdxJVjPA4PeoXCxgsQSPSrMkOw4biq0srR8ABl7g00JkDXa8YjX8RUXmE8hR+AxTJioU9RmoY5CvVqtCJHLPk7NqjtzTMtG4ZM7f4gKvJOHjIyM1HhcEgflU3HYMozAMuc96c0Y/yKaMDOBxUgcbQG4PY0tRgmUPGeabITuDEnjmmCUrIMcrTpXxn5cp607CHreIq88nPpTmlSU4Udfas5iC/Q4NTRDDjJosFyyC8LEjJGe1OExYDzAFbtzTgyuuCPmxVZ5o0cKTnnnijcC06B16j6VRIMTFcY96uxTK8RBx7VWaQEAZBOcdKEBEZcsMjGOtD3Kq/y9DSlRyT2pvmAjjbge1VYm4FjJg/ripfNeMAbmOKt2UkRi2uAT70y8twSGhPHUrS8hlOWQyff5wfTmlSYqfl5HepjErpkDDd6qMDG3PWnuSSO0MjfMMN3IqxaRgBgpBBA5qthXQHoKtWMQAYE89QM0nsMu7DjHWqMtnHuZkHJ5NahZMAc5qpcSxowG4cnmpVxmLdQjaSUYMDmnwO0ygbmUjrWu8sLjadrAj1rLZYrdwVYj1A5q076CNOBowoRjux/eNegfB/Z/wkHiLyzlfs1n3zj5p68v8ANB+YDIPvXpHwSYNrPiMjP/Hvaf8AoU9VTVpXIm9D2OiiiugyCiiigAooooAKKKKAPL/ihj/hJ/D+f+fO8/8AQ7euXDfN0rpfipn/AISXw/j/AJ9Lz/0O3rlA3yivIxi/emsNi0Ov/wBekIIHAqBZcDOOfanbztJOea5bFjXJz0P50FmI6nApjNg5zmn5PB7VQhvP4ZpxyeetOGB24pcAVLYxBnpTunI7Uc8Uuf8A69SxiYHOOlRscNTyCG9qDhhjoaAFjfAzxxUiksev0quMgmpAcexoaGSEDHrn3qN2xkKeaXccUxWYk/Jj3zTihojvAFtiGccjJ5rgdS/e3LED5c8fSu8nt/OyZCT7Vz2u6ctmqjOGcZPsPSvSwk0nYurZwsjkZF24J9Kj+82MDAFWJgWmCn+EY59qrvwzfSvTRwvc1dAdI9Wimk/1ceWbHfAJ/nivWfDd3JNpsMsjN5krFxkYG3PJ/pXjenMEuPm4Uqelep6Xf+XoMEynqqRIO+M81My47Hb2FwbkyNkkb22/7o4q5HgyVn6UAIt3ovGPetCIc9OTWQ2SN05pyDgj0FRls56U+P7x9xkUwGsPmz7VGGH45qVqrj7wHvSYEmdynnpTycKSelQqfmIqZuYvwzQgKgmC7CeM84NU9dkVNNZmOAGGSe1Vbm+X7U8AYb1XAA/rVLxNdibwtcqHG542X/gQ/wD1U0B57qN8z2s8UjBZoG8vHsGyP0x+VcqZz5U8LZIbBH1H+TV29vRPP5w4M8S+Yvo68H+WfxrLlyJs+tbIzbGoc/Kfwq/YxEyg46GqPBbIGOa6fR44J4cSDJHUjqKirLljc0pR5pEszsEGORjBDciuTvEC3DYXaPTPSu3uLYxgkkPH6iuX1m0EUu+P7rVhh5q9jXFQdrmSx49qdAoaVQOuajPJrR06yeeePaON3NdU5JK7OJI9E0mIxafboRyqir0i5X0xTLWNYo1HXAAqY4xnpXzU5Xk2dq2KjjGBzn2qB/lYcEZ4qyWUyH0qNyGH4+tNCGKN2DkirKkbcdvrVbzFQkevtSF8DpxTtcR6p8Lf+RCt/wDr7vP/AEplrsq4z4Vf8iBa/wDX3ef+lMtdnXvQ+FGDCiiiqAKKKKACiiigArx3VCo8b+J8n/l9i/8ASWCvYq8T11mXx54mA6fbIv8A0lhrix6vRsBdhYMcAVdVOB0rES42Yq9FecDHWvFjEdrFqYEL0zVLBD5NTSXA2cnrVRZ8yY61RTViSbcw4qsA6nPNX0OTgjg09olI6VLJM4b2OcVZiBJ5qcRgHAFOMRHakUkMbAHPSoC3oamdSynAqptcNjGamV+g2xqSYnGTjmuw0vVFEaxRjLHiuS8kuc45Fa+iBo5d7cAV14CrKM+UzZ38QxEM9T1qOdQIzVS2vlaPLN1NWZG80ADua+hi09hFWGDZGWxy1ZGvxiWLyR2GTXRMu1enTpWZcW/mNKzDjGKoR8/+JLDdqpOMYIHNcPrlv9mvpEAHLZGK9m8RacPPkk2g/vAK878Q6b56TTKBvSR+R6CqT0Gzh9/z7u5zXZ+HrkG3n+Ukho5PfA61xLdB610/hO5CagiP91xswaEwPoDTrrdaGIP8xjVlGfaumsp/tFqr45ZOfrXn1pd+VfWWT8ksOPoe1d1phAt0K9P8awe5oW7U5aQd8067J2j60yMeXI59eafNiSEOORnFLoLqXEwYVPqKzrz5PNf2zV+ybzLRT3GQaq6jHm0m/wB2nLYFuc6l4uFk7jiujtTmQMO4riuVaROnANdZo83m28LdT0NZ05X0LmrFTxfKYNIkIB6oOPc1D4bvUuFmQNnHT6dKn8aALoM8x6Rjcfwrg/Aesb5EfcME7Sfqc/1rfoZEvxVnMbworYMsThR68V5C95u0gIpwxYbsewr0z40zPGNKuE5WNieO4NeU2uHkliTlC+9SfQ1pF6CKd9ctPpsCZJMOU/AnNN09Pti+TgGVeV9xUZPl3TxOuQflp2nSmx1OGTptYbvpQ9wRv6fpMsMxLIdkqlcEVPDZfabaS3KEnBxx3Fen2Wj22oaSkkagh1DqR2rnBpTabqJ3jMe7g+xoUug7HnEQMFxhhypINa5CNBtdQQeQRWv4r0AwSi8gGY3G48VQ0pUuR9nkwGP3c029BFjSbUeYHQ5xXpOlbjApPXHSuH02xa0vgpyFbvXoenRiOIZGfcV5OPaaLiPntlkGSozVNoMAjbmtWYqqnFV4pEOc14j5r2GzIyY2xzirtty2SeKLoR5J4qqt2qDaDSauyS5qLLu0wDr/AGrY/wDpTHXs1eCzXRlv9JXPH9q2X/pTHXvVe5lytSfr/kDdwooorvEFFFFABXEfFwZ+HF8P+ni0/wDSmOu3rifi1/yTm9/6+bT/ANKY6GCPFn4dOcnbg00cgdvT3qRRk5YZoCKvHVhXNsb7skkkbyApb7nQVnTTkEY5zwRVySeKEje2M9qoStHLKShyvvTiEvIu2c6rH8uRnk5qzFqMcU5+XK/xYNY4DRnarcH1qdYwRnP402kTc1/tMTAlSGU9h2ojvZImOzgHnBGazIFKvtLAAnvVzKovYkd6hpIpO5pxyGX5pFGfpTsAnGapWk4dCM9/WrccgIILH64rN7loDHhQDIAB2PaovstnNDJGzN5g5RugFErgH7xyPSqzOc5609QsZjZjbaRjHcVLDKSRjtU7IJTyDjHpmmJatGxdc8HIFVoSXEkOwZHNJvO7JzTwTtGevvTWHY9Kkoq3F6u8ruwccmqZbzSfnb86sS2Cu25W49DTFtmQnbgCqViXcqXMRVFJ+YfyqBMMQDxWp5DPGUdevcVmyRNE+CvI600wNCLT3eLzVkQ9sA00JLG/H4iq0EzRsdpIH1q6sjTAbZAD3yOopMYNFMFJZBgelV3K4GTkVOyzR/MtwzxHqDjNRGNXmRRyDzQguTi2jg8tsEhjg57VpCKMKQMYxTZY/Mtth6AVHE+2MI/OBwal6jRBcWkZJZV2sPSqDA7v0rYYVUmhLtkdDST7jYy3JI296r3MB84nHHsOtWo49nXr7U6QfNwfl96d7MW5QyYenp3pkbq75HU1eeEOuO4/Wsm4heCTIyBmqWpL0LxUFTg5qDG3oM4pIp964Jwaf1PansA5XwcoMe1WhudASSCeKqNjirkDjZ0pMBjI/r1qF7ff94c+tXjtaoygJyDj6UXArRW7K3t6VOqEfd61KBjp0o47mkMUSlFG7p71TuH81twWrLEYx1+tVm69MelCBkWwkDAqORSo5xzVq3AIcOf4uBmidU6ZzTEzLeUxtgAEnsa9V+CJVtX8QleM29nkHt809eZNbh2z0x0r0z4IIU1jxGCP+WFp/wChT1rDczlsey0UUVsZhRRRQAUUUUAFFFFAHlnxT/5Gfw7/ANet5/6Fb1yGc5A9a674q/8AIy+Hv+vS8/8AQreuSC5GO5rysX/ENYbDlHzD+VLITnOaQEDmmNKgyCwrk3ZYxpBkA8/Spg6gY7VVOCOKUbieWGKtxJuW1nXbjkehoMgIPGarBOMjvUij5jk1Lih3JxI3+RUin5ckVAGC5x2p4fKg54qGhkuM8ZpCMnBYUbgR979Kaz+hqRisAFyOtM3HrjiguMYPFJ+NUgHqxJp4b+VRqNmMZqQnigaBP9aruflU5Oelc54guPOld8e/4dhW/IMKRzWXcaYt1INxO3PK9zXVh5qLux9DjRaSbfNYH5j3qvdWTwy4YdVBrv20cyyRJtHlpktgd8cfhUGreH3aKGXaSfJcEHtgZH8zXqwqX1ObkfU4GEEOPpk16JpS+Zp9jbq4IKCQ/Ut0/CuGit2EudpwAF/Q/wCFdD4fufLMMcjnaJMVo3ccUeq6LcFoCinIZVI9uK21OM59K4vQL5/ts9uJFUCKMoRz2rsVP31brwRWZTHDmYKfWpfuzKO2KjTPnA9qlmzuVh2oEKQM+1V3XDnA/CrGQx6e9RsvJ+lDArqfnFWFIwVx2quBz9KkdtoB9waSBnCX8vk+KrkMP7v06Z/oKxNa1J4tOvoSSfJnDMD3U5BA/OtTxchi1iZlODJGGGfpXH6lL9slbnCzxYx/tY4/UCqQ+hyzn96y5zz8ponBwGx2qOQFWHYip8iSMH8PxrW5ktSOIZPIyK2tKd7adVB6ng+tZcC4kxjitazULIqv1rGq9LG1FanUNCXRSnAI/KuX1m3kjDK3C5yB6V2VmyNbKOuKy9chEkBUDnH5Vw0J2nY7MTG8DgEgd5QAOp4ruPDmlGCAySDknIzWPo9mZrxNwyE64rt41CjA4HarxtZ/Ajgpx6ki80sj7R70gbA6+1RO2eeteXa7NiI4yc80EduPemluoB59KfwVHPNUIibuM/lUW878dR3qRsU0Jzuq0SesfCv/AJEC1x/z93n/AKUy12dcX8KuPh/aj/p6vP8A0plrtK9uPwoxCiiiqAKKKKACiiigArxXXMf8Jz4nz/z+Rf8ApLDXtVeI68T/AMJ74mA/5/Iv/SaGuTG/whpkSjIz2q1bnHeqoAGCelO84Iue1eK2UvMW6m2k81Tt7pTP8x6VFc3iScDrUAXI3A80JaakylrodAb5FUGpk1BJE7Vz6I7/AHmq1FAUOQalpC52zY+0dCKmScvwaz48bRzR9pVJAMipbsO5sAAik8gE1VS7U45qwbhdnBpJ3K0YeSoPJH0qWW4S3h2qRk1lz3m04FVjdGU4J6VUZuDuhNaG5Z6m8lyiZ+UGu3syHjVvavPbCNRKp6knt2rvrBwFWPP3RzXtYCo5J3My5KOgqnKu2Fj61dblqr3I/dke1ekBwurWXno3HJOePrXIXWgq008RXhuT+PFenzWgZOnvWTc6dukLgclR+lJFHy/qWnvZXckLKQY3ZCPpT9IIjvrVmfYvmKS3pg816L8QPDnlXct5GmVkAkP1HB/SvP2smhgLY4GHB9jTQj11w6WkMxbDQN27gH/CvR9Bk83T2UNnDBh9CK8r8OXI1DQ/LlO51VQfX0ru/BFw8tuYpH+dAYnB45B4P5VmzQ61jjaf7wosf39pIh7EikTmNkP3kPH0pdM/dzSoeATml1ETaa+JZoT67gP51auIg8bKehFZ8hNtqKS4+U8H6VqnDD8Ka7CZwV9bmG6GMgHKmtfQm+Vl9GBFP1u0yHIHOdwqPSBiU47jNYRVpGrd4lnxbD9q8J6igGSYWrxLwdI8UDheGEisPoDzXvVzGLnTrm3IyHRh+YrxXTrL7DdlQMAOEIPoSRXRfQySuV/ide/btH08licO8TH0I5FeeaEc3ioeSmCR6jNej+KdPe7065hONyEToO/HBry+FzY6ok3QK2SPaqi9BNWZZ1qwNtqT4+6WxmnPYGWKKcAYkG047MK6rWNOF3BHMoDLNEGUjvUukaQ13o08e0GSP5h+FO47HX/CzUmutONlMfngO3nuK63VdESVvu9enH6V5v4KmOleJoyRtjuRg/WvbzGs0ODQxbHnVzpJkgazuFyp+4TXJf8ACKyW9ywTIZWypHavYbrT1nQgr8wqpHpyu/zr82MGk2wuchbaR9ot0Z1xIvX61pwI9soDdBXRfYVh5C8d6zb9AgPFeVjouxSZk3l2CpArOEpzwTTbk4kPpUKMRIuTwa8Z3uClqWG8xs1n3DGPJ7+1bf7sR81k3arISFFaRFJlS1uPN1LSlI6arZf+lEdfRdfOcFqYtV0ducf2rZf+lEdfRle1gf4bt3/yEFFFFdoBRRRQAVxPxa/5J1e/9fNp/wClMddtXLfEjTjqfw81uFGlEsVubmLygCxkiIkQYIOcsgGKAPDgcNj9KWTCsDjnpXp6/BrTMBv+Eg1vJHPNv/8AGqU/BrTT/wAzDrn52/8A8arH2bNedHjd88fmhWfD7dx44xVRZIY3UFuWHAxXtUnwR0aU5fXdbbgjlrfof+2VM/4UZoe5W/tvWsqcg7oOP/IVWoaEOR48t3Bj72VHfFWonjnQtExIU4PavV/+FGaHsKf25re0nON0H/xqnr8EtHRXVde1wBzlsNBz/wCQqTgNSPJZ7hIdgblm6KoyTTRqdsd2ZNuOoYEYNes/8KM0PaF/tzW8Dp88H/xqkPwL0MuXOt63uIwfmg5H/fqj2Y+c8oivoY5WXzB03HjtVhdUgWTY0vVQ/TtXp4+BWhKQRret5UED54O/X/llWVB8GNLk8U3+nvq2tC1hsbeSOUNFlmd5gy58vGAI06c8+4pOlcOc5NpFKg7gVPINMHK5wa9NX4M6Wiqo8Qa3hRgZNucf+Qqcfg7px6+Itc/O3/8AjNR7KRXtEeZIcZA6GpBnrz7V6T/wp3Ts5/4SHXPzt/8A4zR/wp3Tv+hi1z87f/4zR7Fh7RHmZJbOMdeKcSCue9ek/wDCnNNH/Mw63+dv/wDGaD8HNNIwfEOufnb/APxqj2Ug9ojzBWyxA7e9OB3cAfN7V6YPgzpg6eINc/O3/wDjVKvwc01RhfEOtj8bf/4zR7Jh7RHmuzA/zxVe5jiZSSBke1eg+I/hbBpfhnVdQs9d1qa6tbSWaGNhAwd1QlQQIsnJHbmry/BnTCAx8Qa3kjPW3/8AjVNUmJ1EeMXEckEmCpAxkH1pqSvgGvaZfgvpUy7ZNf1th9bf/wCNVEPgdoo6a7rf/fcH/wAap+zYc6PL7GYP8rAZ7VZFmjZCEqTyADnBr0kfBLR1II17XAR/tQf/ABqpl+DmnLjHiLXOPe3/APjVJ0mHtEeWmW6hGxlBH94HrUILhgWJK55Ar1k/B7TyMHxFrf52/wD8Zpn/AApnS8n/AIqDW+fe3/8AjVHsmP2iPPVjSaPfC+cfw96rtndg16Wnwb02Nsp4h1xT7Nb/APxqnH4O6cTk+Itc/O3/APjNL2LD2iPMtgcbcVBNaOR8jE+gzXoFv8LLeTxRf6c2ua0LSCzt545MQZZ3eYMM+Vg4Eace/uK1f+FP6f8A9DFrn52//wAZo9lIPaI8qWMquDmoZ4llHlt+Br1o/B3Tj18Q63+dv/8AGaa3wa0xhg+INb/O3/8AjNHspC9ojxcQGJzkYqQAg8V7C3wV0lhhtf1s/jb/APxqk/4UlpH/AEHtb/76g/8AjVXyMnmR5BkbSCPxFLAcS4BP0Ir17/hSekf9B7W/++rf/wCNUD4J6QDka9ref963/wDjVJ02NTR5YWwM56U1J1c4U5Ner/8ACl9KBz/b+t/nb/8Axqs3xF8J7TSvDOqahZa1rM11a2ks0MbCBg7qhKggRZOSO1Hs2PnR59vPckUhweSeleqL8GNLKgnX9byR62//AMapf+FL6XnP/CQa5/31b/8Axql7Jhzo8q3cdse4pjBW5Ix9K9YPwX0o9fEGt/nb/wDxqkPwW0o/8zBrn/fVv/8AGqfs2HOjyONAHf5wN350FAD8zjFetf8ACktH3bv7e1vPrut//jVB+CekHrr+uf8AfUH/AMao9mw50eVosZ43D869D+Dahde8Rgf8+1n/AOhT1o/8KS0fOf7e1zP+9B/8aro/CHgOx8G3F9NaX99dveLGjm6ZDtCFiMbVX++acINO5MpJo6qiiitSAooooAKKKKACiiigDyz4q/8AIy+Hv+vS8/8AQreuRHNej+MfDI8T+MtDt5Lu8tIY7C8czWoTO7fbgKS6sOck9M/L9arD4R2Q6eJNc/8AJb/4zXFXw0qk+ZFxkkjz9sAEetUWlikldFkUlDhhnoa9OPwjsiMHxHrn/kt/8ZqB/gxpbli2v62SxBPNvyR0/wCWVRDByW7ByR5st1bqTmdPl+983Sn/AGy1GCZ4wG6c16Gfglo7Fydd1rLjDc2/P/kKnH4LaUUCHX9b2gFcZt+h/wC2VX9T8xcxwe7jcOV9RUUt3FGxDOoKjJ74HvXob/BrTZIFhbxFrvlqMAB4Bx+EVNT4LaTFjZr+trjpg2//AMaqFgn1ZSkjz9LuCQfJMjHGeDmnJOhXiVThtvXofSu7HwQ0ZQQNc1oAnPW34Pt+64p3/Cl9LRXK+INcySGPzW/JHT/llQ8F2Yuc4WK6idtiyqSCVxnuOoqfd83vXQ+G/hJZ6l4e0nVLvWtagvbm3jupUXyVCSugLAAxEjqRg1tj4SWSnI8R65n1/wBG/wDjNRLAy+yxqZwnHfPNPV/eu5/4VNaf9DJrn/kt/wDGaP8AhU1p/wBDJrn/AJLf/Gan6jU7or2iOID8UZyR/Su3/wCFTWn/AEMuuf8Akt/8Zo/4VPaf9DLrn/kt/wDGaPqNTug9ojimI2daZaLuuCxH3R613B+E1oRg+Jdcx/27f/GaUfCi1VSo8S64Aev/AB7f/GaqOCmnuhqqjL0fThdo8pGFPf2rWn05Ftz8g27cAYq9F4CmgQJF4s1tVAwAI7T/AOMVnXPhfU18TWGmDxTrTWc9ncTSSGG1yro8KqM+TgZEj+/Hsa7oU+VWJlU5meeahoccWpRxxjh5AcjpwrE/zrk50l0+WXjDxSYA+hr3g/DRGlWU+KNbLrkKdlrxnr/yxrPufgzpd5NJNPr+tvJIcsc24z+UNXZi5kebaVqDx3cU7ctkAY7j0r1mFhJEsqHI2g1nL8F9LQgr4g1sEdObf/41WrB8PXtoVhi8Wa4sajAG21PH4w0WYnJE2zuvXrQ7eYuMYNKPA9yOni/XP+/dp/8AGKT/AIQe5Ix/wl+uf9+7T/4xRYVxik+aAT1HFTOPlyMcVGfAtwTk+Ltcz/uWn/xinf8ACEXWMf8ACX65j/rnaf8AxiiwcxW/iOadKA0WSO2Ke3gS4wW/4S3XMgf3LT/4xWf4d8KajqvhnStQvfFOtQ3V1aRTTRrFaqEdlBIAMORgk8GjlHzHK+MLKSTyLtcHny2+lcHJZyCzEWP3i5Zfzr3G4+HAuojHP4p1t0PbZaj/ANoVRf4Q2EhBbxFrZIGP+Xbp/wB+aTT6DUkeEXWn+cBLH1PzY/nVOODBKnof5176vwW0lAQuv63gnPW36/8Afqom+B2iOSW1zW8n/agH/tKqjzLciVnqjwxImDe49a04VVsZBH0r1/8A4UZon/Qc1v8A76g/+NVIvwS0dDlde1wH/eg/+NVNSLktC6UlF6nn2nEiHO7cO3GCKj1cnyQw7V6ZH8H9PiGE8Ra2Pxt//jND/B/T5GBfxDrbYORn7Nj8vJrlhhpqfM2dNXEwlHlSPJdFhKu0gGAOa6BWzjqK6V/hZb2viix06HW9ZFpcWlxPLJiDKujwhQD5WACJH49uOhrYHwksh08R65/5Lf8AxmlWws6kr3RyxkkcISFGBjJqN247V3//AAqSzxj/AISTXP8AyW/+M0n/AAqKxzn/AISPXPzt/wD4zWKwM+6K9ojz04yOB+dJjKAbq9C/4VDYf9DHrn52/wD8ZpP+FQWH/Qxa5+dv/wDGaf1KfdC50eeYG7lhmpVUEV3/APwqCwzn/hI9c/O3/wDjNA+EFgOniPXPzt//AIzT+pVO6DnRpfCvjwDbf9fd5/6Uy12dZPhrQIPDGhw6VbTzzxRvI/mTlS7F3ZznaAOrHtWtXoxVlYzCiiimAUUUUAFFFFABXiOvOF8e+Jif+fuL/wBJoa9urzR/AUfiPxZ4nvrjVNTsv9PjRFtxEFdRawfN88bE8kjg44+tY4im6kOVAcrnePaopv8AV9MCu5HwotVGB4l1z/yW/wDjNKfhTanr4l1z/wAlv/jNed/Z9S+6GeaNGoG7NAnUcDtXozfCGwbr4i1s/wDgN/8AGaQfB/Tx08Q63z/17f8Axmr+oT7oVkcPayq5wRWiUwmc11S/CSzT7viTWx/4Df8AxmpD8K7dhg+Jtcx/27f/ABmoeXz7oehwj3WwlT+dRtLvO4c13Z+ElmQQfEmt8/8AXt/8ZoX4SWSDC+JNcH/gN/8AGaTy6p3QnqcOLkoRV+G53pg9a1fEHw0TTtOintde1qWRry2gKstucJJOiOeIuysxz2xzxWsnwntU+74l1wf+A3/xmo/s2r3X4/5CjdM5B13v60qxBTk8V2I+FsA6eJ9c/K2/+M0f8KtgP/Mz65+Vt/8AGar+zqvdf18jVSRi6dIiONq8+tdVYXIQjJ5Y1Tj+GaRfc8Ua4Pwtf/jNTJ8P5I2DL4t10Ef7Nr/8Yrsw2HnS3aM5am7FJvY/WkuG4P5VmJ4NvYzlfGOuj/tnaf8AxilbwdfN18Y64f8Atnaf/GK7+YVi1KmE6VWa3z26Uh8HXzdfGOuf9+7T/wCMUn/CHX3/AEOOuf8Afu0/+MU+ZBY5/wASaSlzasrrlc+navKLjw67WVzCqZeDfEeOo+8pr1+w8Lalql9rVteeKNaWGzvFggIhtR5iGCJySfJ5+Z2GR6etTL8LoUlkkXxNrYaUAOdtrzj/ALY0rjR4b4UumtriNCcJIzRsD2PUV6L4cufsurhtuBKwDj/aH/1q3I/gjo0Tl013W1YvvJDW/X1/1VX1+FVsjh18Ta4GByCPs3/xmpY7m0o2zBh0bikdDDKsoHQ4NQDwXeAADxhrmB/0ztP/AIxTj4OvWGD4x1zH/XOz/wDjFAE92nnx7h9ansZ/MgAP3k4NUR4NvQu0eMNcx/1ztP8A4xTY/BV3E5ZPGGuAnr+7tP8A4xQFy9qEPmRZrKsU8u4HHfFW28I37Lg+MtcI/wCuVn/8YrF17wtqWl2MVzZ+Kdalme8toWDRWrYSSdEc4EPZWJ9sc8UmtbjT0sdKq7XPvXB6nonl6ncgKMOdy4/Ouw/4Q++/6HHXP+/dn/8AGKhl8C3Ezh5PF2uMw6Hy7T/4xT0EnY4bWLI+THdFARGcPx1U8GvN/EvhcwTPNEu5UbPA6qa97l+HJmiaKTxVrbI3BGy1/wDjFVZPhTazRLFJ4l1tkVdoBFt0/wC/NC0Hc8v8L2hv9A+yuP3lud0ZPJx6Vu6VpwtroOq/I42uK7Cy+Etnpzl7XxJrcbHj/l2P84atL8NlQkr4p1sZ/wBm1/8AjNO4rnnGqaO1vLJNCuHibzo8e3UV6lo9yLvTLedejoDVSX4bLN/rPFOtt2+7a/8Axmp7PwDLYW6W9r4t1yOJPurstDj84KEwZovHn5gPrURgydy9RUY8H34/5nHXP+/Vn/8AGKy9K8PaveajrUE/ivWo47O8WCBhDajehgick5g5+Z2HHp9afMTY1XA2nNc9qYAY7GAPdTW63gm7f73i/XD/ANs7T/4xVWb4c/aP9b4q1xv+A2o/9o1y4mk6sbRGjhrrDMcrg1VCrng4ruz8KrduvibXD/4Df/GaZ/wqe0/6GXXP/Jb/AOM15/8AZ1Tuv6+QLc45juXAao41RX5Ndt/wqe0/6GXXP/Jb/wCM03/hUlnn/kZNc/8AJb/4zR/Z1Tuim0zjZ1T7TpRXr/atj/6Ux17rXAQfCmxhu7Wd9f1mYW1xFcLHIYNrNG4dQcRA4yo6Gu/rvwtGVGHLLuSFFFFdIBRRRQAVn6vrmnaHDFLqE5j85/LiRI2keRsE4VEBZjgE8CtCuO8UXUGkeMvDusajIIdMihu7d7h+EhlcRlCx6KCEcZPrjvQB02m6nZ6vYR31hOs9tJna65HIOCCDyCCCCDyCKt1yngPMtlq9+istpfarPc2pZSu+I7RvAPZmVmHqDnvXV0AFFFFABRRRQAU2SRYo2kc4RAWY+gFOpGZUUsxAVRkk9hQBlaT4m0jXIbuawui8do2ycyxPF5Z2hud4HG0g56YNM0jxXouu3DW+nXhllEfmqrwvHvjzjem9RvXOPmXI5HNefHWdN8RD4j6bouqWl1fajH/ocUEys04FlGp24PPIK/WtVNTsvFHiPw//AMI/KHNjY3P2lkUj7LvjVEjf+627B29fkJxQB1Vj4v0LUtTGn2l+JLhi4j/dOqSlPvCNyArkc52k4xW3XlOj3trf6P4E0CzBGr6XcQtfWwUh7QRQukpk/ugk4GfvbuM16tQAUUUUAFFFFABWHqHi/Q9LvpLS9u3ikiKiV/s8piiLAEb5AuxeCOpHWtyvPfGvivR7y/uPBk2sWOnrJEBqdzdTpGY4XH+rjDH5ndT16KDnrgUAdXrHifSNBkij1C6ZJZUaRY4oXlbYOrkIpIUZ+8ePelv/ABNo+m2Vpdz3gaK8wbbyI2maYY3ZRUBZhjnIHSubudV03w349udQ1S4jt7C80m3js7h87CY3lLxqe7EOhA6ntnFYegkeFz4Q1HXgbKxGl3UAecbVtZJJY5EVz0QmNSvPdcUAem6fqNpq1hDfWE6T20wykidDzg/Qgggg9CKs1yvgJWbRr67EbpbXup3V1ah1KkxPISrYPIDcsPZq6qgAooooAKKKKAIL28g0+zkurlmWGMZYojOfwVQSfwFZdv4v0K5tb25F95KWKCS5FzC8DxKc4YpIobBwcHHOOK0dRv7XTLCW8vbhbe3jxvmbomSACfxIryO/JvrjWLu01CXxJaRLp88+oLGpIjiug7wL5YCOAu5/lGfXORQB6hpnibSNXiuZLS7wLUBp1nieBolIJDMsgUhSASDjBwaZo/irRtenaDTrwySrGJQjwvEXjJwHXeo3rn+Jcj3rhdfceMLjxPc+G5Bewf8ACOtZ+dBys0xdmEan+Jguc46bwO9a9pq+neJfG3h+40OQTQ2Flcm6ZFIEAcRhIm9GyudvUbKAO8ooooAKKKKACiiigClq+r2GhaZNqOp3C29pCAXkILdTgAAAknPYDNUdQ8XaHpkVrJdXjAXUPnxLHBJKxjwDvKopKryOSABXNfEGy12dL+7jsbK70u10yYxLLeNE0crI4eXaI2DkIcLyMZb14z9C1iLw/q1tqXiUw6fFeaDaxW0nmGSPMbSFkDbRlirxttxnnAzjNAHdX/ibR9NsrS7nvA0V5g23kRtM0wxuyioCzDHOQOlXdP1G01awhvrCdJ7aYZSROh5wfoQQQQehFeZaCR4XPhDUdeBsrEaXdQB5xtW1kkljkRXPRCY1K891xXWeAlZtGvrsRulte6ndXVqHUqTE8hKtg8gNyw9moA6qiiigAooooAKKKKACiiigAooooAKKKKACiiigDE1Txdoei3v2S/vvKmCCRwIndYlJwGkZQRGCQeWIHFbYIIBByD3rzXVNTsdE1Lxxa6qds+qIj2URQlrxDbLGI4x/EQ6sNo/vZ713Ph+2uLLw1pVrd/8AHzBZwxy5OfnVAD+oNAGjRRRQAUUUUAFFFFAFPU9UtNHsjd3sjpCCFykbSEk9AFUEn8BVQ+J9GXw/BrpvQNNuFRoZfLbMm7hQqY3EnsMZ9quajqdjo9k97qV5DaWqEBppnCKCTgZJ968p0DV9Ok8B+BLxLuGe10a4iOpCNt/2bdBKitIB90BmXOenXtQB6VB4o0W40a41ZL5FsrYss7yq0ZiYdVZWAZW5HBGeR61JpHiDTNdE/wDZ9wzvAQJY5YXikTIyMo4DAEdDjB7V53qLDVE8Ra/YI9zo/wDaumzl4kLC4jgaMzOo/iUADkdfLOM4rpNDvrXXfiDf6tpMy3OnR6ZDavcxcxyS+Y77Q3RiqnnHTdigDs6KKKACiiigAooooAw9P8YaHqd9FZ2t45mmDGES28sSzYGT5bOoV8Dn5SeKWTxfoUWsf2U9+BdeaID+6cxiUjIjMmNgc5Hyk556VyuneK9D8a+LrKWPWbBLPTp3Nha/aE8+8n2Mhk2ZyqBWfaMZbOTgAZybq6hTwrq/hNif+EiuNZkaK22nzJN935qTD/YCENu6Db6igD0DUvF2haTqBsb2/EU6hTJiJ2SIMcKZHUFY89txFbdeX6tqFnpMXj3StSz/AGhqrs9jCUJe8SS2SNFjH8WHVlIHTqeK9F0uCa20iyguDunigRJDnOWCgH9aALdFFFABRRRQAVn6rrVloyRteG4/ekhFgtZZ2OOvEasa0Kw/E2rWGnWSQXniBdEkuM+VdHywflIyB5ile4GCM88UAEvjDQYtMttR+3+Zb3TmOAQxPJJI4zuURqpfIwcjHGOcVK/ijRY9Di1k36GwlYJHIisxdidu0KBuLZBG0DOQeOK848P3cOjajo2sao3l6Ur6nAupzIyLNJJLG6zvu+75gVxngccYBAqe3cWqab4juEdNE/4SW7vN7oQEhkikjjmI7KXO7J7ODQB6TpWsWGt2hutPn82NXMbgoyMjjqrKwDKRxwQDzV6uR8HzR6jrvibWLM79NvLqEW8wHyzFIVV3X1Gflz0O2uuoAKKKKACiiigArN1DX9L0q/sLG9u1iur+Ty7aLazF2/AHA5HJwOa0q8m8RWvia01qwvrrStOuLi412HyJ/wC0WGY1EnlRbfKOxcEknLfMScc8AHfSeL9Ci1j+ynvwLrzRAf3TmMSkZEZkxsDnI+UnPPSjUvF2haTqBsb2/EU6hTJiJ2SIMcKZHUFY89txFef3V1CnhXV/CbE/8JFcazI0VttPmSb7vzUmH+wEIbd0G31FW9W1Cz0mLx7pWpZ/tDVXZ7GEoS94klskaLGP4sOrKQOnU8UAeoUVU0uCa20iyguDunigRJDnOWCgH9at0AFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAI7qiM7sFVRksTgAVjaR4s0TXbo22nXvmy+X5qq0Lx+Ymcb0LKA65I+ZcjketO8W2lzqHg3W7OyBN1PYTxQgdS7RkAfma5TT9V0/wAQ+JfCX9jMJP7NtpnvFVSPsqtEEEb/AN1i2PlPPyE9qAPQ6KKKACiiigAooooAKybrxNpNlrdto9xcul9csFiTyJCrMQWA3hdoOFY4J7VrVwXj7xFo2na34Wt73VLS3mg1VbiVJZQpSLyJ13kHouSBn1NAHRan4u0LR777Hf3wimVVeTETusSscKZGUFYwfViKfrHijR9Blji1C7ZJZEMoSOF5WCDq5CKSqj+8cD3rh9Q1fTtO/wCE4tb6QPPrCibT0CljfRvapGixY+/8ysMDpnPQ1Zsb638H+I5JPEtwsAn0SyhhnkBKu8XmCWMHu2XU7Ryc8ZoA9DgniubeO4gkSWGVQ8ciHKspGQQe4IqSuc8A2dzYeA9GtruJ4ZktgTE4w0YOSFI7EAgY9q6OgAooooAKKKKAK2oaha6XYyXt5IY4I8bmCljyQAAACSSSBgDvVPTPEelauly1pdHNrgzpPE8DxAjILLIFYAgHkjHBqXXdbsfDmiXWr6lL5VpbLukYDJ5IAAHqSQB7mvPkkj8W+GvFuoWWpWN3rmo6Y0CWNjcpKbWIK/lxkqeXJdsnpk4HAyQDuNI8V6Lrtw1vp14ZZRH5qq8Lx74843pvUb1zj5lyORzTbHxfoWpamNPtL8SXDFxH+6dUlKfeEbkBXI5ztJxiuVTU7LxR4j8P/wDCPyhzY2Nz9pZFI+y741RI3/utuwdvX5CcVnaPe2t/o/gTQLMEavpdxC19bBSHtBFC6SmT+6CTgZ+9u4zQB6tRRRQAUUUUAFFFFAGLqfizRtHumgv7iaEoAZJPssrRRg9C0gUov4kU3UvF+g6Re/ZL2/EcoVXcrE7rErHCtI6grGD2LEVznxF1XT59Nv8AS18S/ZL1Ld1fS0RWa93KCIyuPMIYHb+7YH5jzWRLqdrpFn4xsNYg+zX+qwpJZ2ZUs1wrWiRiKP8AvlXVlwOnXoaAO+1jxRo+gyxxahdsksiGUJHC8rBB1chFJVR/eOB71qQTxXNvHcQSJLDKoeORDlWUjIIPcEV55Y31v4P8RySeJbhYBPollDDPICVd4vMEsYPdsup2jk54zXSeAbO5sPAejW13E8MyWwJicYaMHJCkdiAQMe1AHR0UUUAFFFFABRRWR4mh1e40G4g0NolvZNqBpJTHtQkbyrBW2ttzg4ODg0AMh8W6FPHqkqalF5WlMUvZGDKsRH+0Rhuh6Z5461JpnibSNXiuZLS7wLUBp1nieBolIJDMsgUhSASDjBwa8rktdUhfxPbNoltbWVlcaXNNb2ly05EcJiYoo8tSw8tWYnrkYwc5rX19x4wuPE9z4bkF7B/wjrWfnQcrNMXZhGp/iYLnOOm8DvQB3Wj+KtG16doNOvDJKsYlCPC8ReMnAdd6jeuf4lyPetmuDtNX07xL428P3GhyCaGwsrk3TIpAgDiMJE3o2Vzt6jZXeUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAf/9k=")||V(jt,"src",Sa),Ut(lt.src,ha="data:image/jpeg;base64,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")||V(lt,"src",ha),Ut(pt.src,$a="data:image/jpeg;base64,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")||V(pt,"src",$a),Ut(ot.src,nn="data:image/jpeg;base64,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")||V(ot,"src",nn),Ut(ct.src,pn="data:image/jpeg;base64,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")||V(ct,"src",pn),Ut(st.src,Fn="data:image/jpeg;base64,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")||V(st,"src",Fn)},m(A,t){Wn(document.head,F),a(A,Rt,t),a(A,rt,t),a(A,ut,t),c(k,A,t),a(A,Ft,t),c(y,A,t),a(A,Vt,t),a(A,x,t),a(A,kt,t),a(A,M,t),a(A,yt,t),a(A,P,t),a(A,xt,t),c(H,A,t),a(A,Mt,t),c(S,A,t),a(A,Pt,t),c(w,A,t),a(A,Ht,t),c(q,A,t),a(A,St,t),c(d,A,t),a(A,wt,t),c(W,A,t),a(A,qt,t),a(A,m,t),a(A,dt,t),c(G,A,t),a(A,Wt,t),a(A,T,t),a(A,mt,t),a(A,g,t),a(A,Gt,t),a(A,O,t),a(A,Tt,t),c(z,A,t),a(A,gt,t),a(A,it,t),a(A,Ot,t),a(A,B,t),a(A,zt,t),a(A,J,t),a(A,Bt,t),a(A,I,t),a(A,Jt,t),a(A,b,t),a(A,It,t),a(A,N,t),a(A,bt,t),c(f,A,t),a(A,Nt,t),a(A,jt,t),a(A,ft,t),a(A,X,t),a(A,Xt,t),c(Z,A,t),a(A,Zt,t),a(A,D,t),a(A,Dt,t),c(Y,A,t),a(A,Yt,t),a(A,C,t),a(A,Ct,t),a(A,h,t),a(A,ht,t),c(Q,A,t),a(A,Qt,t),a(A,v,t),a(A,vt,t),a(A,L,t),a(A,Lt,t),a(A,E,t),a(A,Et,t),c($,A,t),a(A,$t,t),a(A,_,t),a(A,_t,t),a(A,AA,t),a(A,Ae,t),a(A,tA,t),a(A,te,t),a(A,eA,t),a(A,ee,t),c(aA,A,t),a(A,ae,t),a(A,nA,t),a(A,ne,t),a(A,UA,t),a(A,Ue,t),a(A,iA,t),a(A,ie,t),c(jA,A,t),a(A,je,t),a(A,lA,t),a(A,le,t),c(pA,A,t),a(A,pe,t),a(A,oA,t),a(A,oe,t),c(cA,A,t),a(A,ce,t),a(A,sA,t),a(A,se,t),a(A,rA,t),a(A,re,t),c(KA,A,t),a(A,Ke,t),a(A,RA,t),a(A,Re,t),c(uA,A,t),a(A,ue,t),a(A,FA,t),a(A,Fe,t),a(A,VA,t),a(A,Ve,t),c(kA,A,t),a(A,ke,t),a(A,lt,t),a(A,ye,t),a(A,yA,t),a(A,xe,t),c(xA,A,t),a(A,Me,t),a(A,MA,t),a(A,Pe,t),a(A,PA,t),a(A,He,t),c(HA,A,t),a(A,Se,t),a(A,SA,t),a(A,we,t),c(wA,A,t),a(A,qe,t),a(A,pt,t),a(A,de,t),a(A,qA,t),a(A,We,t),c(dA,A,t),a(A,me,t),a(A,WA,t),a(A,Ge,t),c(mA,A,t),a(A,Te,t),a(A,GA,t),a(A,ge,t),a(A,TA,t),a(A,Oe,t),c(gA,A,t),a(A,ze,t),a(A,OA,t),a(A,Be,t),c(zA,A,t),a(A,Je,t),a(A,ot,t),a(A,Ie,t),a(A,BA,t),a(A,be,t),c(JA,A,t),a(A,Ne,t),a(A,IA,t),a(A,fe,t),a(A,bA,t),a(A,Xe,t),c(NA,A,t),a(A,Ze,t),c(fA,A,t),a(A,De,t),a(A,ct,t),a(A,Ye,t),a(A,XA,t),a(A,Ce,t),c(ZA,A,t),a(A,he,t),a(A,DA,t),a(A,Qe,t),c(YA,A,t),a(A,ve,t),a(A,CA,t),a(A,Le,t),a(A,hA,t),a(A,Ee,t),c(QA,A,t),a(A,$e,t),a(A,vA,t),a(A,_e,t),a(A,LA,t),a(A,Aa,t),a(A,EA,t),a(A,ta,t),c($A,A,t),a(A,ea,t),c(_A,A,t),a(A,aa,t),a(A,st,t),a(A,na,t),a(A,At,t),a(A,Ua,t),c(tt,A,t),a(A,ia,t),a(A,et,t),a(A,ja,t),a(A,at,t),a(A,la,t),a(A,nt,t),a(A,pa,t),a(A,Kt,t),oa=!0},p:Hn,i(A){oa||(s(k.$$.fragment,A),s(y.$$.fragment,A),s(H.$$.fragment,A),s(S.$$.fragment,A),s(w.$$.fragment,A),s(q.$$.fragment,A),s(d.$$.fragment,A),s(W.$$.fragment,A),s(G.$$.fragment,A),s(z.$$.fragment,A),s(f.$$.fragment,A),s(Z.$$.fragment,A),s(Y.$$.fragment,A),s(Q.$$.fragment,A),s($.$$.fragment,A),s(aA.$$.fragment,A),s(jA.$$.fragment,A),s(pA.$$.fragment,A),s(cA.$$.fragment,A),s(KA.$$.fragment,A),s(uA.$$.fragment,A),s(kA.$$.fragment,A),s(xA.$$.fragment,A),s(HA.$$.fragment,A),s(wA.$$.fragment,A),s(dA.$$.fragment,A),s(mA.$$.fragment,A),s(gA.$$.fragment,A),s(zA.$$.fragment,A),s(JA.$$.fragment,A),s(NA.$$.fragment,A),s(fA.$$.fragment,A),s(ZA.$$.fragment,A),s(YA.$$.fragment,A),s(QA.$$.fragment,A),s($A.$$.fragment,A),s(_A.$$.fragment,A),s(tt.$$.fragment,A),oa=!0)},o(A){r(k.$$.fragment,A),r(y.$$.fragment,A),r(H.$$.fragment,A),r(S.$$.fragment,A),r(w.$$.fragment,A),r(q.$$.fragment,A),r(d.$$.fragment,A),r(W.$$.fragment,A),r(G.$$.fragment,A),r(z.$$.fragment,A),r(f.$$.fragment,A),r(Z.$$.fragment,A),r(Y.$$.fragment,A),r(Q.$$.fragment,A),r($.$$.fragment,A),r(aA.$$.fragment,A),r(jA.$$.fragment,A),r(pA.$$.fragment,A),r(cA.$$.fragment,A),r(KA.$$.fragment,A),r(uA.$$.fragment,A),r(kA.$$.fragment,A),r(xA.$$.fragment,A),r(HA.$$.fragment,A),r(wA.$$.fragment,A),r(dA.$$.fragment,A),r(mA.$$.fragment,A),r(gA.$$.fragment,A),r(zA.$$.fragment,A),r(JA.$$.fragment,A),r(NA.$$.fragment,A),r(fA.$$.fragment,A),r(ZA.$$.fragment,A),r(YA.$$.fragment,A),r(QA.$$.fragment,A),r($A.$$.fragment,A),r(_A.$$.fragment,A),r(tt.$$.fragment,A),oa=!1},d(A){A&&(e(Rt),e(rt),e(ut),e(Ft),e(Vt),e(x),e(kt),e(M),e(yt),e(P),e(xt),e(Mt),e(Pt),e(Ht),e(St),e(wt),e(qt),e(m),e(dt),e(Wt),e(T),e(mt),e(g),e(Gt),e(O),e(Tt),e(gt),e(it),e(Ot),e(B),e(zt),e(J),e(Bt),e(I),e(Jt),e(b),e(It),e(N),e(bt),e(Nt),e(jt),e(ft),e(X),e(Xt),e(Zt),e(D),e(Dt),e(Yt),e(C),e(Ct),e(h),e(ht),e(Qt),e(v),e(vt),e(L),e(Lt),e(E),e(Et),e($t),e(_),e(_t),e(AA),e(Ae),e(tA),e(te),e(eA),e(ee),e(ae),e(nA),e(ne),e(UA),e(Ue),e(iA),e(ie),e(je),e(lA),e(le),e(pe),e(oA),e(oe),e(ce),e(sA),e(se),e(rA),e(re),e(Ke),e(RA),e(Re),e(ue),e(FA),e(Fe),e(VA),e(Ve),e(ke),e(lt),e(ye),e(yA),e(xe),e(Me),e(MA),e(Pe),e(PA),e(He),e(Se),e(SA),e(we),e(qe),e(pt),e(de),e(qA),e(We),e(me),e(WA),e(Ge),e(Te),e(GA),e(ge),e(TA),e(Oe),e(ze),e(OA),e(Be),e(Je),e(ot),e(Ie),e(BA),e(be),e(Ne),e(IA),e(fe),e(bA),e(Xe),e(Ze),e(De),e(ct),e(Ye),e(XA),e(Ce),e(he),e(DA),e(Qe),e(ve),e(CA),e(Le),e(hA),e(Ee),e($e),e(vA),e(_e),e(LA),e(Aa),e(EA),e(ta),e(ea),e(aa),e(st),e(na),e(At),e(Ua),e(ia),e(et),e(ja),e(at),e(la),e(nt),e(pa),e(Kt)),e(F),K(k,A),K(y,A),K(H,A),K(S,A),K(w,A),K(q,A),K(d,A),K(W,A),K(G,A),K(z,A),K(f,A),K(Z,A),K(Y,A),K(Q,A),K($,A),K(aA,A),K(jA,A),K(pA,A),K(cA,A),K(KA,A),K(uA,A),K(kA,A),K(xA,A),K(HA,A),K(wA,A),K(dA,A),K(mA,A),K(gA,A),K(zA,A),K(JA,A),K(NA,A),K(fA,A),K(ZA,A),K(YA,A),K(QA,A),K($A,A),K(_A,A),K(tt,A)}}}const Tn='{"title":"Introduction","local":"introduction","sections":[],"depth":1}';function gn(ca){return Sn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bn extends wn{constructor(F){super(),qn(this,F,gn,Gn,Pn,{})}}export{bn as component};
