import{s as Ls,n as Ds,o as Ks}from"../chunks/scheduler.7bc62968.js";import{S as Ps,i as Os,g as r,s as t,r as p,A as sl,h as j,f as a,c as e,j as As,x as J,u as c,k as Ss,y as ll,a as n,v as i,d as M,t as o,w as h}from"../chunks/index.66556066.js";import{C as y}from"../chunks/CodeBlock.a759539a.js";import{H as m,E as al}from"../chunks/EditOnGithub.46ca76a5.js";function nl(Ys){let T,O,K,ss,u,$s='<br/> <picture><source media="(prefers-color-scheme: dark)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-dark.svg"/> <source media="(prefers-color-scheme: light)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg"/> <img alt="huggingface javascript library logo" src="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg" width="376" height="59" style="max-width: 100%;"/></picture> <br/> <br/>',ls,U,as,w,ns,d,Vs="This is a collection of JS libraries to interact with the Hugging Face API, with TS types included.",ts,g,Rs='<li><a href="inference/README">@huggingface/inference</a>: Use Inference Endpoints (dedicated) and Inference API (serverless) to make calls to 100,000+ Machine Learning models</li> <li><a href="hub/README">@huggingface/hub</a>: Interact with huggingface.co to create or delete repos and commit / download files</li> <li><a href="agents/README">@huggingface/agents</a>: Interact with HF models through a natural language interface</li> <li><a href="gguf/README">@huggingface/gguf</a>: A GGUF parser that works on remotely hosted files.</li> <li><a href="tasks/README">@huggingface/tasks</a>: The definition files and source-of-truth for the Hub’s main primitives like pipeline tasks, model libraries, etc.</li> <li><a href="space-header/README">@huggingface/space-header</a>: Use the Space <code>mini_header</code> outside Hugging Face</li>',es,b,vs="We use modern features to avoid polyfills and dependencies, so the libraries will only work on modern browsers / Node.js >= 18 / Bun / Deno.",ps,f,Fs="The libraries are still very young, please help us by opening issues!",cs,I,is,B,Ms,Z,Xs="To install via NPM, you can download the libraries as needed:",os,G,hs,C,xs="Then import the libraries in your code:",rs,k,js,E,Js,W,Hs='You can run our packages with vanilla JS, without any bundler, by using a CDN or static hosting. Using <a href="https://hacks.mozilla.org/2018/03/es-modules-a-cartoon-deep-dive/" rel="nofollow">ES modules</a>, i.e. <code>&lt;script type=&quot;module&quot;&gt;</code>, you can import the libraries in your code:',ms,Q,ys,N,Ts,S,us,Y,Us,$,_s='Get your HF access token in your <a href="https://huggingface.co/settings/tokens" rel="nofollow">account settings</a>.',ws,V,ds,R,gs,v,bs,F,fs,X,Is,x,Bs,H,qs="There are more features of course, check each library’s README!",Zs,_,Gs,q,Cs,z,ks,A,Es,L,zs="This will generate ESM and CJS javascript files in <code>packages/*/dist</code>, eg <code>packages/inference/dist/index.mjs</code>.",Ws,D,Qs,P,Ns;return U=new y({props:{code:"JTJGJTJGJTIwUHJvZ3JhbWF0aWNhbGx5JTIwaW50ZXJhY3QlMjB3aXRoJTIwdGhlJTIwSHViJTBBJTBBYXdhaXQlMjBjcmVhdGVSZXBvKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAlN0J0eXBlJTNBJTIwJTIybW9kZWwlMjIlMkMlMjBuYW1lJTNBJTIwJTIybXktdXNlciUyRm5scC1tb2RlbCUyMiU3RCUyQyUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMEElN0QpJTNCJTBBJTBBYXdhaXQlMjB1cGxvYWRGaWxlKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAlMjJteS11c2VyJTJGbmxwLW1vZGVsJTIyJTJDJTBBJTIwJTIwYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiUyQyUwQSUyMCUyMCUyRiUyRiUyMENhbiUyMHdvcmslMjB3aXRoJTIwbmF0aXZlJTIwRmlsZSUyMGluJTIwYnJvd3NlcnMlMEElMjAlMjBmaWxlJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwcGF0aCUzQSUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29udGVudCUzQSUyMG5ldyUyMEJsb2IoLi4uKSUyMCUwQSUyMCUyMCU3RCUwQSU3RCklM0IlMEElMEElMkYlMkYlMjBVc2UlMjBJbmZlcmVuY2UlMjBBUEklMEElMEFhd2FpdCUyMGluZmVyZW5jZS5jaGF0Q29tcGxldGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMHJvbGUlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwY29udGVudCUzQSUyMCUyMkhlbGxvJTJDJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNBJTIwNTEyJTJDJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAwLjUlMkMlMEElN0QpJTNCJTBBJTBBYXdhaXQlMjBpbmZlcmVuY2UudGV4dFRvSW1hZ2UoJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlMjJhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGdyZWVuJTIwYmlyZCUyMiUyQyUwQSU3RCklM0IlMEElMEElMkYlMkYlMjBhbmQlMjBtdWNoJTIwbW9yZSVFMiU4MCVBNg==",highlighted:`<span class="hljs-comment">// Programatically interact with the Hub</span>

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: {<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>},
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...) 
  }
});

<span class="hljs-comment">// Use Inference API</span>

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [
    {
      <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span>,
    },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.5</span>,
});

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;a picture of a green bird&quot;</span>,
});

<span class="hljs-comment">// and much more…</span>`,wrap:!1}}),w=new m({props:{title:"Hugging Face JS libraries",local:"hugging-face-js-libraries",headingTag:"h1"}}),I=new m({props:{title:"Installation",local:"installation",headingTag:"h2"}}),B=new m({props:{title:"From NPM",local:"from-npm",headingTag:"h3"}}),G=new y({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRz",highlighted:`npm install @huggingface/inference
npm install @huggingface/hub
npm install @huggingface/agents`,wrap:!1}}),k=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEFpbXBvcnQlMjAlN0IlMjBIZkFnZW50JTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJTIyJTNCJTBBaW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMGNvbW1pdCUyQyUyMGRlbGV0ZVJlcG8lMkMlMjBsaXN0RmlsZXMlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEFpbXBvcnQlMjB0eXBlJTIwJTdCJTIwUmVwb0lkJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNC",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;
<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoId</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;`,wrap:!1}}),E=new m({props:{title:"From CDN or Static hosting",local:"from-cdn-or-static-hosting",headingTag:"h3"}}),Q=new y({props:{code:"JTNDc2NyaXB0JTIwdHlwZSUzRCUyMm1vZHVsZSUyMiUzRSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMEhmSW5mZXJlbmNlJTIwJTdEJTIwZnJvbSUyMCdodHRwcyUzQSUyRiUyRmNkbi5qc2RlbGl2ci5uZXQlMkZucG0lMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSU0MDIuOC4xJTJGJTJCZXNtJyUzQiUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGY2RuLmpzZGVsaXZyLm5ldCUyRm5wbSUyRiU0MGh1Z2dpbmdmYWNlJTJGaHViJTQwMC4yMC4wJTJGJTJCZXNtJTIyJTNCJTBBJTNDJTJGc2NyaXB0JTNF",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;module&quot;</span>&gt;</span><span class="language-javascript">
    <span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;https://cdn.jsdelivr.net/npm/@huggingface/inference@2.8.1/+esm&#x27;</span>;
    <span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/@huggingface/hub@0.20.0/+esm&quot;</span>;
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),N=new m({props:{title:"Deno",local:"deno",headingTag:"h3"}}),S=new y({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUwQWltcG9ydCUyMCU3QiUyMEhmQWdlbnQlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMEhmSW5mZXJlbmNlJTIwJTdEJTIwZnJvbSUyMCUyMm5wbSUzQSU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTIyJTBBaW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMm5wbSUzQSU0MGh1Z2dpbmdmYWNlJTJGaHViJTIy",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),Y=new m({props:{title:"Usage examples",local:"usage-examples",headingTag:"h2"}}),V=new m({props:{title:"@huggingface/inference examples",local:"huggingfaceinference-examples",headingTag:"h3"}}),R=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> inference = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

<span class="hljs-comment">// Chat completion API</span>
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>
});
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>);

<span class="hljs-comment">// Streaming chat completion API</span>
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> inference.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>);
}

<span class="hljs-comment">// You can also omit &quot;model&quot; to use the recommended model for the task</span>
<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;My name is Wolfgang and I live in Amsterdam&quot;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&quot;en&quot;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&quot;fr&quot;</span>,
  },
});

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;black-forest-labs/FLUX.1-dev&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;a picture of a green bird&#x27;</span>,
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://picsum.photos/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>,  
})

<span class="hljs-comment">// Using your own dedicated inference endpoint: https://hf.co/docs/inference-endpoints/</span>
<span class="hljs-keyword">const</span> gpt2 = inference.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});

<span class="hljs-comment">//Chat Completion</span>
<span class="hljs-keyword">const</span> llamaEndpoint = inference.<span class="hljs-title function_">endpoint</span>(
 <span class="hljs-string">&quot;https://api-inference.huggingface.co/models/meta-llama/Llama-3.1-8B-Instruct&quot;</span>
);
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> llamaEndpoint.<span class="hljs-title function_">chatCompletion</span>({
 <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
 <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
 <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
});
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>);`,wrap:!1}}),v=new m({props:{title:"@huggingface/hub examples",local:"huggingfacehub-examples",headingTag:"h3"}}),F=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMHVwbG9hZEZpbGUlMkMlMjBkZWxldGVGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFhd2FpdCUyMGNyZWF0ZVJlcG8oJTdCJTBBJTIwJTIwcmVwbyUzQSUyMCUyMm15LXVzZXIlMkZubHAtbW9kZWwlMjIlMkMlMjAlMkYlMkYlMjBvciUyMCU3QnR5cGUlM0ElMjAlMjJtb2RlbCUyMiUyQyUyMG5hbWUlM0ElMjAlMjJteS11c2VyJTJGbmxwLXRlc3QlMjIlN0QlMkMlMEElMjAlMjBhY2Nlc3NUb2tlbiUzQSUyMEhGX1RPS0VOJTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwdXBsb2FkRmlsZSglN0IlMEElMjAlMjByZXBvJTNBJTIwJTIybXktdXNlciUyRm5scC1tb2RlbCUyMiUyQyUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjAlMkYlMkYlMjBDYW4lMjB3b3JrJTIwd2l0aCUyMG5hdGl2ZSUyMEZpbGUlMjBpbiUyMGJyb3dzZXJzJTBBJTIwJTIwZmlsZSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlM0ElMjBuZXclMjBCbG9iKC4uLiklMjAlMEElMjAlMjAlN0QlMEElN0QpJTNCJTBBJTBBYXdhaXQlMjBkZWxldGVGaWxlcyglN0IlMEElMjAlMjByZXBvJTNBJTIwJTdCdHlwZSUzQSUyMCUyMnNwYWNlJTIyJTJDJTIwbmFtZSUzQSUyMCUyMm15LXVzZXIlMkZteS1zcGFjZSUyMiU3RCUyQyUyMCUyRiUyRiUyMG9yJTIwJTIyc3BhY2VzJTJGbXktdXNlciUyRm15LXNwYWNlJTIyJTBBJTIwJTIwYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiUyQyUwQSUyMCUyMHBhdGhzJTNBJTIwJTVCJTIyUkVBRE1FLm1kJTIyJTJDJTIwJTIyLmdpdGF0dHJpYnV0ZXMlMjIlNUQlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFile, deleteFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>, <span class="hljs-comment">// or {type: &quot;model&quot;, name: &quot;my-user/nlp-test&quot;},</span>
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...) 
  }
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFiles</span>({
  <span class="hljs-attr">repo</span>: {<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;space&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/my-space&quot;</span>}, <span class="hljs-comment">// or &quot;spaces/my-user/my-space&quot;</span>
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-attr">paths</span>: [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;.gitattributes&quot;</span>]
});`,wrap:!1}}),X=new m({props:{title:"@huggingface/agents example",local:"huggingfaceagents-example",headingTag:"h3"}}),x=new y({props:{code:"aW1wb3J0JTIwJTdCSGZBZ2VudCUyQyUyMExMTUZyb21IdWIlMkMlMjBkZWZhdWx0VG9vbHMlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJyUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFjb25zdCUyMGFnZW50JTIwJTNEJTIwbmV3JTIwSGZBZ2VudCglMEElMjAlMjBIRl9UT0tFTiUyQyUwQSUyMCUyMExMTUZyb21IdWIoSEZfVE9LRU4pJTJDJTBBJTIwJTIwJTVCLi4uZGVmYXVsdFRvb2xzJTVEJTBBKSUzQiUwQSUwQSUwQSUyRiUyRiUyMHlvdSUyMGNhbiUyMGdlbmVyYXRlJTIwdGhlJTIwY29kZSUyQyUyMGluc3BlY3QlMjBpdCUyMGFuZCUyMHRoZW4lMjBydW4lMjBpdCUwQWNvbnN0JTIwY29kZSUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZ2VuZXJhdGVDb2RlKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUzQiUwQWNvbnNvbGUubG9nKGNvZGUpJTNCJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZXZhbHVhdGVDb2RlKGNvZGUpJTBBY29uc29sZS5sb2cobWVzc2FnZXMpJTNCJTIwJTJGJTJGJTIwY29udGFpbnMlMjB0aGUlMjBkYXRhJTBBJTBBJTJGJTJGJTIwb3IlMjB5b3UlMjBjYW4lMjBydW4lMjB0aGUlMjBjb2RlJTIwZGlyZWN0bHklMkMlMjBob3dldmVyJTIweW91JTIwY2FuJ3QlMjBjaGVjayUyMHRoYXQlMjB0aGUlMjBjb2RlJTIwaXMlMjBzYWZlJTIwdG8lMjBleGVjdXRlJTIwdGhpcyUyMHdheSUyQyUyMHVzZSUyMGF0JTIweW91ciUyMG93biUyMHJpc2suJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQucnVuKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUwQWNvbnNvbGUubG9nKG1lc3NhZ2VzKSUzQiUyMA==",highlighted:`<span class="hljs-keyword">import</span> {<span class="hljs-title class_">HfAgent</span>, <span class="hljs-title class_">LLMFromHub</span>, defaultTools} <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/agents&#x27;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(
  <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-title class_">LLMFromHub</span>(<span class="hljs-variable constant_">HF_TOKEN</span>),
  [...defaultTools]
);


<span class="hljs-comment">// you can generate the code, inspect it and then run it</span>
<span class="hljs-keyword">const</span> code = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">generateCode</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(code);
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.evaluateCode(code)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages); <span class="hljs-comment">// contains the data</span>

<span class="hljs-comment">// or you can run the code directly, however you can&#x27;t check that the code is safe to execute this way, use at your own risk.</span>
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">run</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages); `,wrap:!1}}),_=new m({props:{title:"Formatting & testing",local:"formatting--testing",headingTag:"h2"}}),q=new y({props:{code:"c3VkbyUyMGNvcmVwYWNrJTIwZW5hYmxlJTBBcG5wbSUyMGluc3RhbGwlMEElMEFwbnBtJTIwLXIlMjBmb3JtYXQlM0FjaGVjayUwQXBucG0lMjAtciUyMGxpbnQlM0FjaGVjayUwQXBucG0lMjAtciUyMHRlc3Q=",highlighted:`sudo corepack enable
pnpm install

pnpm -r format:check
pnpm -r lint:check
pnpm -r test`,wrap:!1}}),z=new m({props:{title:"Building",local:"building",headingTag:"h2"}}),A=new y({props:{code:"cG5wbSUyMC1yJTIwYnVpbGQ=",highlighted:'<span class="hljs-attribute">pnpm -r build</span>',wrap:!1}}),D=new al({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/index.md"}}),{c(){T=r("meta"),O=t(),K=r("p"),ss=t(),u=r("p"),u.innerHTML=$s,ls=t(),p(U.$$.fragment),as=t(),p(w.$$.fragment),ns=t(),d=r("p"),d.textContent=Vs,ts=t(),g=r("ul"),g.innerHTML=Rs,es=t(),b=r("p"),b.textContent=vs,ps=t(),f=r("p"),f.textContent=Fs,cs=t(),p(I.$$.fragment),is=t(),p(B.$$.fragment),Ms=t(),Z=r("p"),Z.textContent=Xs,os=t(),p(G.$$.fragment),hs=t(),C=r("p"),C.textContent=xs,rs=t(),p(k.$$.fragment),js=t(),p(E.$$.fragment),Js=t(),W=r("p"),W.innerHTML=Hs,ms=t(),p(Q.$$.fragment),ys=t(),p(N.$$.fragment),Ts=t(),p(S.$$.fragment),us=t(),p(Y.$$.fragment),Us=t(),$=r("p"),$.innerHTML=_s,ws=t(),p(V.$$.fragment),ds=t(),p(R.$$.fragment),gs=t(),p(v.$$.fragment),bs=t(),p(F.$$.fragment),fs=t(),p(X.$$.fragment),Is=t(),p(x.$$.fragment),Bs=t(),H=r("p"),H.textContent=qs,Zs=t(),p(_.$$.fragment),Gs=t(),p(q.$$.fragment),Cs=t(),p(z.$$.fragment),ks=t(),p(A.$$.fragment),Es=t(),L=r("p"),L.innerHTML=zs,Ws=t(),p(D.$$.fragment),Qs=t(),P=r("p"),this.h()},l(s){const l=sl("svelte-u9bgzb",document.head);T=j(l,"META",{name:!0,content:!0}),l.forEach(a),O=e(s),K=j(s,"P",{}),As(K).forEach(a),ss=e(s),u=j(s,"P",{align:!0,"data-svelte-h":!0}),J(u)!=="svelte-9rngw"&&(u.innerHTML=$s),ls=e(s),c(U.$$.fragment,s),as=e(s),c(w.$$.fragment,s),ns=e(s),d=j(s,"P",{"data-svelte-h":!0}),J(d)!=="svelte-1eufct4"&&(d.textContent=Vs),ts=e(s),g=j(s,"UL",{"data-svelte-h":!0}),J(g)!=="svelte-15r0c4s"&&(g.innerHTML=Rs),es=e(s),b=j(s,"P",{"data-svelte-h":!0}),J(b)!=="svelte-5pb56g"&&(b.textContent=vs),ps=e(s),f=j(s,"P",{"data-svelte-h":!0}),J(f)!=="svelte-1vx14v7"&&(f.textContent=Fs),cs=e(s),c(I.$$.fragment,s),is=e(s),c(B.$$.fragment,s),Ms=e(s),Z=j(s,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-18mxf19"&&(Z.textContent=Xs),os=e(s),c(G.$$.fragment,s),hs=e(s),C=j(s,"P",{"data-svelte-h":!0}),J(C)!=="svelte-1fdwpsr"&&(C.textContent=xs),rs=e(s),c(k.$$.fragment,s),js=e(s),c(E.$$.fragment,s),Js=e(s),W=j(s,"P",{"data-svelte-h":!0}),J(W)!=="svelte-1td2f08"&&(W.innerHTML=Hs),ms=e(s),c(Q.$$.fragment,s),ys=e(s),c(N.$$.fragment,s),Ts=e(s),c(S.$$.fragment,s),us=e(s),c(Y.$$.fragment,s),Us=e(s),$=j(s,"P",{"data-svelte-h":!0}),J($)!=="svelte-mx6w21"&&($.innerHTML=_s),ws=e(s),c(V.$$.fragment,s),ds=e(s),c(R.$$.fragment,s),gs=e(s),c(v.$$.fragment,s),bs=e(s),c(F.$$.fragment,s),fs=e(s),c(X.$$.fragment,s),Is=e(s),c(x.$$.fragment,s),Bs=e(s),H=j(s,"P",{"data-svelte-h":!0}),J(H)!=="svelte-16qnxzd"&&(H.textContent=qs),Zs=e(s),c(_.$$.fragment,s),Gs=e(s),c(q.$$.fragment,s),Cs=e(s),c(z.$$.fragment,s),ks=e(s),c(A.$$.fragment,s),Es=e(s),L=j(s,"P",{"data-svelte-h":!0}),J(L)!=="svelte-ymfi8c"&&(L.innerHTML=zs),Ws=e(s),c(D.$$.fragment,s),Qs=e(s),P=j(s,"P",{}),As(P).forEach(a),this.h()},h(){Ss(T,"name","hf:doc:metadata"),Ss(T,"content",tl),Ss(u,"align","center")},m(s,l){ll(document.head,T),n(s,O,l),n(s,K,l),n(s,ss,l),n(s,u,l),n(s,ls,l),i(U,s,l),n(s,as,l),i(w,s,l),n(s,ns,l),n(s,d,l),n(s,ts,l),n(s,g,l),n(s,es,l),n(s,b,l),n(s,ps,l),n(s,f,l),n(s,cs,l),i(I,s,l),n(s,is,l),i(B,s,l),n(s,Ms,l),n(s,Z,l),n(s,os,l),i(G,s,l),n(s,hs,l),n(s,C,l),n(s,rs,l),i(k,s,l),n(s,js,l),i(E,s,l),n(s,Js,l),n(s,W,l),n(s,ms,l),i(Q,s,l),n(s,ys,l),i(N,s,l),n(s,Ts,l),i(S,s,l),n(s,us,l),i(Y,s,l),n(s,Us,l),n(s,$,l),n(s,ws,l),i(V,s,l),n(s,ds,l),i(R,s,l),n(s,gs,l),i(v,s,l),n(s,bs,l),i(F,s,l),n(s,fs,l),i(X,s,l),n(s,Is,l),i(x,s,l),n(s,Bs,l),n(s,H,l),n(s,Zs,l),i(_,s,l),n(s,Gs,l),i(q,s,l),n(s,Cs,l),i(z,s,l),n(s,ks,l),i(A,s,l),n(s,Es,l),n(s,L,l),n(s,Ws,l),i(D,s,l),n(s,Qs,l),n(s,P,l),Ns=!0},p:Ds,i(s){Ns||(M(U.$$.fragment,s),M(w.$$.fragment,s),M(I.$$.fragment,s),M(B.$$.fragment,s),M(G.$$.fragment,s),M(k.$$.fragment,s),M(E.$$.fragment,s),M(Q.$$.fragment,s),M(N.$$.fragment,s),M(S.$$.fragment,s),M(Y.$$.fragment,s),M(V.$$.fragment,s),M(R.$$.fragment,s),M(v.$$.fragment,s),M(F.$$.fragment,s),M(X.$$.fragment,s),M(x.$$.fragment,s),M(_.$$.fragment,s),M(q.$$.fragment,s),M(z.$$.fragment,s),M(A.$$.fragment,s),M(D.$$.fragment,s),Ns=!0)},o(s){o(U.$$.fragment,s),o(w.$$.fragment,s),o(I.$$.fragment,s),o(B.$$.fragment,s),o(G.$$.fragment,s),o(k.$$.fragment,s),o(E.$$.fragment,s),o(Q.$$.fragment,s),o(N.$$.fragment,s),o(S.$$.fragment,s),o(Y.$$.fragment,s),o(V.$$.fragment,s),o(R.$$.fragment,s),o(v.$$.fragment,s),o(F.$$.fragment,s),o(X.$$.fragment,s),o(x.$$.fragment,s),o(_.$$.fragment,s),o(q.$$.fragment,s),o(z.$$.fragment,s),o(A.$$.fragment,s),o(D.$$.fragment,s),Ns=!1},d(s){s&&(a(O),a(K),a(ss),a(u),a(ls),a(as),a(ns),a(d),a(ts),a(g),a(es),a(b),a(ps),a(f),a(cs),a(is),a(Ms),a(Z),a(os),a(hs),a(C),a(rs),a(js),a(Js),a(W),a(ms),a(ys),a(Ts),a(us),a(Us),a($),a(ws),a(ds),a(gs),a(bs),a(fs),a(Is),a(Bs),a(H),a(Zs),a(Gs),a(Cs),a(ks),a(Es),a(L),a(Ws),a(Qs),a(P)),a(T),h(U,s),h(w,s),h(I,s),h(B,s),h(G,s),h(k,s),h(E,s),h(Q,s),h(N,s),h(S,s),h(Y,s),h(V,s),h(R,s),h(v,s),h(F,s),h(X,s),h(x,s),h(_,s),h(q,s),h(z,s),h(A,s),h(D,s)}}}const tl='{"title":"Hugging Face JS libraries","local":"hugging-face-js-libraries","sections":[{"title":"Installation","local":"installation","sections":[{"title":"From NPM","local":"from-npm","sections":[],"depth":3},{"title":"From CDN or Static hosting","local":"from-cdn-or-static-hosting","sections":[],"depth":3},{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage examples","local":"usage-examples","sections":[{"title":"@huggingface/inference examples","local":"huggingfaceinference-examples","sections":[],"depth":3},{"title":"@huggingface/hub examples","local":"huggingfacehub-examples","sections":[],"depth":3},{"title":"@huggingface/agents example","local":"huggingfaceagents-example","sections":[],"depth":3}],"depth":2},{"title":"Formatting & testing","local":"formatting--testing","sections":[],"depth":2},{"title":"Building","local":"building","sections":[],"depth":2}],"depth":1}';function el(Ys){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Ps{constructor(T){super(),Os(this,T,el,nl,Ls,{})}}export{ol as component};
