import{s as Ma,n as ia,o as ca}from"../chunks/scheduler.b108d059.js";import{S as oa,i as ja,g as p,s as t,r as c,m as ta,A as ra,h as M,f as e,c as n,j as Wl,u as o,x as i,n as na,k as pa,y as U,a,v as j,d as r,t as y,w as h}from"../chunks/index.008de539.js";import{C as w}from"../chunks/CodeBlock.3968c746.js";import{H as d}from"../chunks/Heading.88bfeb84.js";function ya(we){let m,Fl,Xl,Ll,f,_l,b,Je=`In this tutorial, we’ll build a simple Next.js application that performs sentiment analysis using Transformers.js!
Since Transformers.js can run in the browser or in Node.js, you can choose whether you want to perform inference <a href="#client-side-inference">client-side</a> or <a href="#server-side-inference">server-side</a> (we’ll show you how to do both). In either case, we will be developing with the new <a href="https://nextjs.org/docs/app" rel="nofollow">App Router</a> paradigm.
The final product will look something like this:`,Pl,I,de='<img src="https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/next-demo.gif" alt="Demo"/>',ql,g,Te="Useful links:",Kl,Z,me='<li>Demo site: <a href="https://huggingface.co/spaces/Xenova/next-example-app" rel="nofollow">client-side</a> or <a href="https://huggingface.co/spaces/Xenova/next-server-example-app" rel="nofollow">server-side</a></li> <li>Source code: <a href="https://github.com/xenova/transformers.js/tree/main/examples/next-client" rel="nofollow">client-side</a> or <a href="https://github.com/xenova/transformers.js/tree/main/examples/next-server" rel="nofollow">server-side</a></li>',Dl,B,Ol,G,ue='<li><a href="https://nodejs.org/en/" rel="nofollow">Node.js</a> version 18+</li> <li><a href="https://www.npmjs.com/" rel="nofollow">npm</a> version 9+</li>',ls,A,ss,k,es,N,Ce="Start by creating a new Next.js application using <code>create-next-app</code>:",as,x,ts,v,fe="On installation, you’ll see various prompts. For this demo, we’ll be selecting those shown below in bold:",ns,W,be=`√ What is your project named? ... next
√ Would you like to use TypeScript? ... <b>No</b> / Yes
√ Would you like to use ESLint? ... No / <b>Yes</b>
√ Would you like to use Tailwind CSS? ... No / <b>Yes</b>
√ Would you like to use \`src/\` directory? ... No / <b>Yes</b>
√ Would you like to use App Router? (recommended) ... No / <b>Yes</b>
√ Would you like to customize the default import alias? ... <b>No</b> / Yes
`,ps,R,Ms,S,Ie='You can install Transformers.js from <a href="https://www.npmjs.com/package/@xenova/transformers" rel="nofollow">NPM</a> with the following command:',is,E,cs,Q,ge="We also need to update the <code>next.config.js</code> file to ignore node-specific modules when bundling for the browser:",os,V,js,Y,Ze='Next, we’ll create a new <a href="https://developer.mozilla.org/en-US/docs/Web/API/Web_Workers_API/Using_web_workers" rel="nofollow">Web Worker</a> script where we’ll place all ML-related code. This is to ensure that the main thread is not blocked while the model is loading and performing inference. For this application, we’ll be using <a href="https://huggingface.co/Xenova/distilbert-base-uncased-finetuned-sst-2-english" rel="nofollow"><code>Xenova/distilbert-base-uncased-finetuned-sst-2-english</code></a>, a ~67M parameter model finetuned on the <a href="https://huggingface.co/datasets/sst" rel="nofollow">Stanford Sentiment Treebank</a> dataset. Add the following code to <code>./src/app/worker.js</code>:',rs,$,ys,X,hs,H,Be='We’ll now modify the default <code>./src/app/page.js</code> file so that it connects to our worker thread. Since we’ll only be performing in-browser inference, we can opt-in to Client components using the <a href="https://nextjs.org/docs/getting-started/react-essentials#the-use-client-directive" rel="nofollow"><code>&#39;use client&#39;</code> directive</a>.',Us,z,ws,F,Ge="Initialise the following state variables at the beginning of the <code>Home</code> component:",Js,L,ds,_,Ae="and fill in the <code>onMessageReceived</code> function to update these variables when the worker thread sends a message:",Ts,P,ms,q,ke="Finally, we can add a simple UI to the <code>Home</code> component, consisting of an input textbox and a preformatted text element to display the classification result:",us,K,Cs,D,Ne="You can now run your application using the following command:",fs,O,bs,ll,xe='Visit the URL shown in the terminal (e.g., <a href="http://localhost:3000/" rel="nofollow">http://localhost:3000/</a>) to see your application in action!',Is,sl,gs,el,ve="To build your application, simply run:",Zs,al,Bs,tl,We="This will bundle your application and output the static files to the <code>out</code> folder.",Gs,nl,Re='For this demo, we will deploy our application as a static <a href="https://huggingface.co/docs/hub/spaces" rel="nofollow">Hugging Face Space</a>, but you can deploy it anywhere you like! If you haven’t already, you can create a free Hugging Face account <a href="https://huggingface.co/join" rel="nofollow">here</a>.',As,pl,Se='<li>Visit <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a> and fill in the form. Remember to select “Static” as the space type.</li> <li>Click the “Create space” button at the bottom of the page.</li> <li>Go to “Files” → “Add file” → “Upload files”. Drag the files from the <code>out</code> folder into the upload box and click “Upload”. After they have uploaded, scroll down to the button and click “Commit changes to main”.</li>',ks,Ml,Ee="<strong>That’s it!</strong> Your application should now be live at <code>https://huggingface.co/spaces/&lt;your-username&gt;/&lt;your-space-name&gt;</code>!",Ns,il,xs,cl,Qe='While there are many different ways to perform server-side inference, the simplest (which we will discuss in this tutorial) is using the new <a href="https://nextjs.org/docs/app/building-your-application/routing/router-handlers" rel="nofollow">Route Handlers</a> feature.',vs,ol,Ws,jl,Ve="Start by creating a new Next.js application using <code>create-next-app</code>:",Rs,rl,Ss,yl,Ye="On installation, you’ll see various prompts. For this demo, we’ll be selecting those shown below in bold:",Es,hl,$e=`√ What is your project named? ... next
√ Would you like to use TypeScript? ... <b>No</b> / Yes
√ Would you like to use ESLint? ... No / <b>Yes</b>
√ Would you like to use Tailwind CSS? ... No / <b>Yes</b>
√ Would you like to use \`src/\` directory? ... No / <b>Yes</b>
√ Would you like to use App Router? (recommended) ... No / <b>Yes</b>
√ Would you like to customize the default import alias? ... <b>No</b> / Yes
`,Qs,Ul,Vs,wl,Xe='You can install Transformers.js from <a href="https://www.npmjs.com/package/@xenova/transformers" rel="nofollow">NPM</a> with the following command:',Ys,Jl,$s,dl,He="We also need to update the <code>next.config.js</code> file to prevent Webpack from bundling certain packages:",Xs,Tl,Hs,ml,ze="Next, let’s set up our Route Handler. We can do this by creating two files in a new <code>./src/app/classify/</code> directory:",zs,u,ul,Rl,Fe="<code>pipeline.js</code> - to handle the construction of our pipeline.",Me,Cl,ie,fl,Sl,Le="<code>route.js</code> - to process requests made to the <code>/classify</code> route.",ce,bl,Fs,Il,Ls,gl,_e="We’ll now modify the default <code>./src/app/page.js</code> file to make requests to our newly-created Route Handler.",_s,Zl,Ps,Bl,Pe="You can now run your application using the following command:",qs,Gl,Ks,Al,qe='Visit the URL shown in the terminal (e.g., <a href="http://localhost:3000/" rel="nofollow">http://localhost:3000/</a>) to see your application in action!',Ds,kl,Os,Nl,Ke='For this demo, we will build and deploy our application to <a href="https://huggingface.co/docs/hub/spaces" rel="nofollow">Hugging Face Spaces</a>. If you haven’t already, you can create a free Hugging Face account <a href="https://huggingface.co/join" rel="nofollow">here</a>.',le,J,El,De='Create a new <code>Dockerfile</code> in your project’s root folder. You can use our <a href="https://github.com/xenova/transformers.js/blob/main/examples/next-server/Dockerfile" rel="nofollow">example Dockerfile</a> as a template.',oe,Ql,Oe='Visit <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a> and fill in the form. Remember to select “Docker” as the space type (you can choose the “Blank” Docker template).',je,Vl,la="Click the “Create space” button at the bottom of the page.",re,Yl,sa="Go to “Files” → “Add file” → “Upload files”. Drag the files from your project folder (excluding <code>node_modules</code> and <code>.next</code>, if present) into the upload box and click “Upload”. After they have uploaded, scroll down to the button and click “Commit changes to main”.",ye,C,he,$l,ea="README.md",Ue,xl,se,vl,aa="<strong>That’s it!</strong> Your application should now be live at <code>https://huggingface.co/spaces/&lt;your-username&gt;/&lt;your-space-name&gt;</code>!",ee,Hl,ae;return f=new d({props:{title:"Building a Next.js application",local:"building-a-nextjs-application",headingTag:"h1"}}),B=new d({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),A=new d({props:{title:"Client-side inference",local:"client-side-inference",headingTag:"h2"}}),k=new d({props:{title:"Step 1: Initialise the project",local:"step-1-initialise-the-project",headingTag:"h3"}}),x=new w({props:{code:"bnB4JTIwY3JlYXRlLW5leHQtYXBwJTQwbGF0ZXN0",highlighted:"npx create-next-app@latest",wrap:!1}}),R=new d({props:{title:"Step 2: Install and configure Transformers.js",local:"step-2-install-and-configure-transformersjs",headingTag:"h3"}}),E=new w({props:{code:"bnBtJTIwaSUyMCU0MHhlbm92YSUyRnRyYW5zZm9ybWVycw==",highlighted:"npm i @xenova/transformers",wrap:!1}}),V=new w({props:{code:"JTJGKiolMjAlNDB0eXBlJTIwJTdCaW1wb3J0KCduZXh0JykuTmV4dENvbmZpZyU3RCUyMColMkYlMEFjb25zdCUyMG5leHRDb25maWclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjAoT3B0aW9uYWwpJTIwRXhwb3J0JTIwYXMlMjBhJTIwc3RhdGljJTIwc2l0ZSUwQSUyMCUyMCUyMCUyMCUyRiUyRiUyMFNlZSUyMGh0dHBzJTNBJTJGJTJGbmV4dGpzLm9yZyUyRmRvY3MlMkZwYWdlcyUyRmJ1aWxkaW5nLXlvdXItYXBwbGljYXRpb24lMkZkZXBsb3lpbmclMkZzdGF0aWMtZXhwb3J0cyUyM2NvbmZpZ3VyYXRpb24lMEElMjAlMjAlMjAlMjBvdXRwdXQlM0ElMjAnZXhwb3J0JyUyQyUyMCUyRiUyRiUyMEZlZWwlMjBmcmVlJTIwdG8lMjBtb2RpZnklMkZyZW1vdmUlMjB0aGlzJTIwb3B0aW9uJTBBJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwT3ZlcnJpZGUlMjB0aGUlMjBkZWZhdWx0JTIwd2VicGFjayUyMGNvbmZpZ3VyYXRpb24lMEElMjAlMjAlMjAlMjB3ZWJwYWNrJTNBJTIwKGNvbmZpZyklMjAlM0QlM0UlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjBTZWUlMjBodHRwcyUzQSUyRiUyRndlYnBhY2suanMub3JnJTJGY29uZmlndXJhdGlvbiUyRnJlc29sdmUlMkYlMjNyZXNvbHZlYWxpYXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcucmVzb2x2ZS5hbGlhcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLmNvbmZpZy5yZXNvbHZlLmFsaWFzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2hhcnAlMjQlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9ubnhydW50aW1lLW5vZGUlMjQlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGNvbmZpZyUzQiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSU3RCUwQSUwQW1vZHVsZS5leHBvcnRzJTIwJTNEJTIwbmV4dENvbmZpZw==",highlighted:`<span class="hljs-comment">/** <span class="hljs-doctag">@type</span> {<span class="hljs-type">import(&#x27;next&#x27;).NextConfig</span>} */</span>
<span class="hljs-keyword">const</span> nextConfig = {
    <span class="hljs-comment">// (Optional) Export as a static site</span>
    <span class="hljs-comment">// See https://nextjs.org/docs/pages/building-your-application/deploying/static-exports#configuration</span>
    <span class="hljs-attr">output</span>: <span class="hljs-string">&#x27;export&#x27;</span>, <span class="hljs-comment">// Feel free to modify/remove this option</span>

    <span class="hljs-comment">// Override the default webpack configuration</span>
    <span class="hljs-attr">webpack</span>: <span class="hljs-function">(<span class="hljs-params">config</span>) =&gt;</span> {
        <span class="hljs-comment">// See https://webpack.js.org/configuration/resolve/#resolvealias</span>
        config.<span class="hljs-property">resolve</span>.<span class="hljs-property">alias</span> = {
            ...config.<span class="hljs-property">resolve</span>.<span class="hljs-property">alias</span>,
            <span class="hljs-string">&quot;sharp$&quot;</span>: <span class="hljs-literal">false</span>,
            <span class="hljs-string">&quot;onnxruntime-node$&quot;</span>: <span class="hljs-literal">false</span>,
        }
        <span class="hljs-keyword">return</span> config;
    },
}

<span class="hljs-variable language_">module</span>.<span class="hljs-property">exports</span> = nextConfig`,wrap:!1}}),$=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { pipeline, env } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@xenova/transformers&quot;</span>;

<span class="hljs-comment">// Skip local model check</span>
env.<span class="hljs-property">allowLocalModels</span> = <span class="hljs-literal">false</span>;

<span class="hljs-comment">// Use the Singleton pattern to enable lazy construction of the pipeline.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">PipelineSingleton</span> {
    <span class="hljs-keyword">static</span> task = <span class="hljs-string">&#x27;text-classification&#x27;</span>;
    <span class="hljs-keyword">static</span> model = <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>;
    <span class="hljs-keyword">static</span> instance = <span class="hljs-literal">null</span>;

    <span class="hljs-keyword">static</span> <span class="hljs-keyword">async</span> <span class="hljs-title function_">getInstance</span>(<span class="hljs-params">progress_callback = <span class="hljs-literal">null</span></span>) {
        <span class="hljs-keyword">if</span> (<span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> === <span class="hljs-literal">null</span>) {
            <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> = <span class="hljs-title function_">pipeline</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">task</span>, <span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span>, { progress_callback });
        }
        <span class="hljs-keyword">return</span> <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span>;
    }
}

<span class="hljs-comment">// Listen for messages from the main thread</span>
self.<span class="hljs-title function_">addEventListener</span>(<span class="hljs-string">&#x27;message&#x27;</span>, <span class="hljs-keyword">async</span> (event) =&gt; {
    <span class="hljs-comment">// Retrieve the classification pipeline. When called for the first time,</span>
    <span class="hljs-comment">// this will load the pipeline and save it for future use.</span>
    <span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title class_">PipelineSingleton</span>.<span class="hljs-title function_">getInstance</span>(<span class="hljs-function"><span class="hljs-params">x</span> =&gt;</span> {
        <span class="hljs-comment">// We also add a progress callback to the pipeline so that we can</span>
        <span class="hljs-comment">// track model loading.</span>
        self.<span class="hljs-title function_">postMessage</span>(x);
    });

    <span class="hljs-comment">// Actually perform the classification</span>
    <span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(event.<span class="hljs-property">data</span>.<span class="hljs-property">text</span>);

    <span class="hljs-comment">// Send the output back to the main thread</span>
    self.<span class="hljs-title function_">postMessage</span>({
        <span class="hljs-attr">status</span>: <span class="hljs-string">&#x27;complete&#x27;</span>,
        <span class="hljs-attr">output</span>: output,
    });
});
`,wrap:!1}}),X=new d({props:{title:"Step 3: Design the user interface",local:"step-3-design-the-user-interface",headingTag:"h3"}}),z=new w({props:{code:"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",highlighted:`<span class="hljs-string">&#x27;use client&#x27;</span>

<span class="hljs-keyword">import</span> { useState, useEffect, useRef, useCallback } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;react&#x27;</span>

<span class="hljs-keyword">export</span> <span class="hljs-keyword">default</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">Home</span>(<span class="hljs-params"></span>) {
  <span class="hljs-comment">/* <span class="hljs-doctag">TODO:</span> Add state variables */</span>

  <span class="hljs-comment">// Create a reference to the worker object.</span>
  <span class="hljs-keyword">const</span> worker = <span class="hljs-title function_">useRef</span>(<span class="hljs-literal">null</span>);

  <span class="hljs-comment">// We use the \`useEffect\` hook to set up the worker as soon as the \`App\` component is mounted.</span>
  <span class="hljs-title function_">useEffect</span>(<span class="hljs-function">() =&gt;</span> {
    <span class="hljs-keyword">if</span> (!worker.<span class="hljs-property">current</span>) {
      <span class="hljs-comment">// Create the worker if it does not yet exist.</span>
      worker.<span class="hljs-property">current</span> = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Worker</span>(<span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&#x27;./worker.js&#x27;</span>, <span class="hljs-keyword">import</span>.<span class="hljs-property">meta</span>.<span class="hljs-property">url</span>), {
        <span class="hljs-attr">type</span>: <span class="hljs-string">&#x27;module&#x27;</span>
      });
    }

    <span class="hljs-comment">// Create a callback function for messages from the worker thread.</span>
    <span class="hljs-keyword">const</span> <span class="hljs-title function_">onMessageReceived</span> = (<span class="hljs-params">e</span>) =&gt; { <span class="hljs-comment">/* <span class="hljs-doctag">TODO:</span> See below */</span>};

    <span class="hljs-comment">// Attach the callback function as an event listener.</span>
    worker.<span class="hljs-property">current</span>.<span class="hljs-title function_">addEventListener</span>(<span class="hljs-string">&#x27;message&#x27;</span>, onMessageReceived);

    <span class="hljs-comment">// Define a cleanup function for when the component is unmounted.</span>
    <span class="hljs-keyword">return</span> <span class="hljs-function">() =&gt;</span> worker.<span class="hljs-property">current</span>.<span class="hljs-title function_">removeEventListener</span>(<span class="hljs-string">&#x27;message&#x27;</span>, onMessageReceived);
  });

  <span class="hljs-keyword">const</span> classify = <span class="hljs-title function_">useCallback</span>(<span class="hljs-function">(<span class="hljs-params">text</span>) =&gt;</span> {
    <span class="hljs-keyword">if</span> (worker.<span class="hljs-property">current</span>) {
      worker.<span class="hljs-property">current</span>.<span class="hljs-title function_">postMessage</span>({ text });
    }
  }, []);

  <span class="hljs-keyword">return</span> ( <span class="hljs-comment">/* <span class="hljs-doctag">TODO:</span> See below */</span> )
}`,wrap:!1}}),L=new w({props:{code:"JTJGJTJGJTIwS2VlcCUyMHRyYWNrJTIwb2YlMjB0aGUlMjBjbGFzc2lmaWNhdGlvbiUyMHJlc3VsdCUyMGFuZCUyMHRoZSUyMG1vZGVsJTIwbG9hZGluZyUyMHN0YXR1cy4lMEFjb25zdCUyMCU1QnJlc3VsdCUyQyUyMHNldFJlc3VsdCU1RCUyMCUzRCUyMHVzZVN0YXRlKG51bGwpJTNCJTBBY29uc3QlMjAlNUJyZWFkeSUyQyUyMHNldFJlYWR5JTVEJTIwJTNEJTIwdXNlU3RhdGUobnVsbCklM0I=",highlighted:`<span class="hljs-comment">// Keep track of the classification result and the model loading status.</span>
<span class="hljs-keyword">const</span> [result, setResult] = <span class="hljs-title function_">useState</span>(<span class="hljs-literal">null</span>);
<span class="hljs-keyword">const</span> [ready, setReady] = <span class="hljs-title function_">useState</span>(<span class="hljs-literal">null</span>);`,wrap:!1}}),P=new w({props:{code:"Y29uc3QlMjBvbk1lc3NhZ2VSZWNlaXZlZCUyMCUzRCUyMChlKSUyMCUzRCUzRSUyMCU3QiUwQSUyMCUyMHN3aXRjaCUyMChlLmRhdGEuc3RhdHVzKSUyMCU3QiUwQSUyMCUyMCUyMCUyMGNhc2UlMjAnaW5pdGlhdGUnJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwc2V0UmVhZHkoZmFsc2UpJTNCJTBBJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWslM0IlMEElMjAlMjAlMjAlMjBjYXNlJTIwJ3JlYWR5JyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHNldFJlYWR5KHRydWUpJTNCJTBBJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWslM0IlMEElMjAlMjAlMjAlMjBjYXNlJTIwJ2NvbXBsZXRlJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHNldFJlc3VsdChlLmRhdGEub3V0cHV0JTVCMCU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjBicmVhayUzQiUwQSUyMCUyMCU3RCUwQSU3RCUzQg==",highlighted:`<span class="hljs-keyword">const</span> <span class="hljs-title function_">onMessageReceived</span> = (<span class="hljs-params">e</span>) =&gt; {
  <span class="hljs-keyword">switch</span> (e.<span class="hljs-property">data</span>.<span class="hljs-property">status</span>) {
    <span class="hljs-keyword">case</span> <span class="hljs-string">&#x27;initiate&#x27;</span>:
      <span class="hljs-title function_">setReady</span>(<span class="hljs-literal">false</span>);
      <span class="hljs-keyword">break</span>;
    <span class="hljs-keyword">case</span> <span class="hljs-string">&#x27;ready&#x27;</span>:
      <span class="hljs-title function_">setReady</span>(<span class="hljs-literal">true</span>);
      <span class="hljs-keyword">break</span>;
    <span class="hljs-keyword">case</span> <span class="hljs-string">&#x27;complete&#x27;</span>:
      <span class="hljs-title function_">setResult</span>(e.<span class="hljs-property">data</span>.<span class="hljs-property">output</span>[<span class="hljs-number">0</span>])
      <span class="hljs-keyword">break</span>;
  }
};`,wrap:!1}}),K=new w({props:{code:"JTNDbWFpbiUyMGNsYXNzTmFtZSUzRCUyMmZsZXglMjBtaW4taC1zY3JlZW4lMjBmbGV4LWNvbCUyMGl0ZW1zLWNlbnRlciUyMGp1c3RpZnktY2VudGVyJTIwcC0xMiUyMiUzRSUwQSUyMCUyMCUzQ2gxJTIwY2xhc3NOYW1lJTNEJTIydGV4dC01eGwlMjBmb250LWJvbGQlMjBtYi0yJTIwdGV4dC1jZW50ZXIlMjIlM0VUcmFuc2Zvcm1lcnMuanMlM0MlMkZoMSUzRSUwQSUyMCUyMCUzQ2gyJTIwY2xhc3NOYW1lJTNEJTIydGV4dC0yeGwlMjBtYi00JTIwdGV4dC1jZW50ZXIlMjIlM0VOZXh0LmpzJTIwdGVtcGxhdGUlM0MlMkZoMiUzRSUwQSUwQSUyMCUyMCUzQ2lucHV0JTBBJTIwJTIwJTIwJTIwY2xhc3NOYW1lJTNEJTIydy1mdWxsJTIwbWF4LXcteHMlMjBwLTIlMjBib3JkZXIlMjBib3JkZXItZ3JheS0zMDAlMjByb3VuZGVkJTIwbWItNCUyMiUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJ0ZXh0JTIyJTBBJTIwJTIwJTIwJTIwcGxhY2Vob2xkZXIlM0QlMjJFbnRlciUyMHRleHQlMjBoZXJlJTIyJTBBJTIwJTIwJTIwJTIwb25JbnB1dCUzRCU3QmUlMjAlM0QlM0UlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjbGFzc2lmeShlLnRhcmdldC52YWx1ZSklM0IlMEElMjAlMjAlMjAlMjAlN0QlN0QlMEElMjAlMjAlMkYlM0UlMEElMEElMjAlMjAlN0JyZWFkeSUyMCElM0QlM0QlMjBudWxsJTIwJTI2JTI2JTIwKCUwQSUyMCUyMCUyMCUyMCUzQ3ByZSUyMGNsYXNzTmFtZSUzRCUyMmJnLWdyYXktMTAwJTIwcC0yJTIwcm91bmRlZCUyMiUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCghcmVhZHklMjAlN0MlN0MlMjAhcmVzdWx0KSUyMCUzRiUyMCdMb2FkaW5nLi4uJyUyMCUzQSUyMEpTT04uc3RyaW5naWZ5KHJlc3VsdCUyQyUyMG51bGwlMkMlMjAyKSUyMCU3RCUwQSUyMCUyMCUyMCUyMCUzQyUyRnByZSUzRSUwQSUyMCUyMCklN0QlMEElM0MlMkZtYWluJTNF",highlighted:`&lt;main className=<span class="hljs-string">&quot;flex min-h-screen flex-col items-center justify-center p-12&quot;</span>&gt;
  <span class="language-xml"><span class="hljs-tag">&lt;<span class="hljs-name">h1</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;text-5xl font-bold mb-2 text-center&quot;</span>&gt;</span>Transformers.js<span class="hljs-tag">&lt;/<span class="hljs-name">h1</span>&gt;</span></span>
  <span class="language-xml"><span class="hljs-tag">&lt;<span class="hljs-name">h2</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;text-2xl mb-4 text-center&quot;</span>&gt;</span>Next.js template<span class="hljs-tag">&lt;/<span class="hljs-name">h2</span>&gt;</span></span>

  <span class="language-xml"><span class="hljs-tag">&lt;<span class="hljs-name">input</span>
    <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;w-full max-w-xs p-2 border border-gray-300 rounded mb-4&quot;</span>
    <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;text&quot;</span>
    <span class="hljs-attr">placeholder</span>=<span class="hljs-string">&quot;Enter text here&quot;</span>
    <span class="hljs-attr">onInput</span>=<span class="hljs-string">{e</span> =&gt;</span> {
        classify(e.target.value);
    }}
  /&gt;</span>

  {ready !== <span class="hljs-literal">null</span> &amp;&amp; (
    <span class="language-xml"><span class="hljs-tag">&lt;<span class="hljs-name">pre</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;bg-gray-100 p-2 rounded&quot;</span>&gt;</span>
      { (!ready || !result) ? &#x27;Loading...&#x27; : JSON.stringify(result, null, 2) }
    <span class="hljs-tag">&lt;/<span class="hljs-name">pre</span>&gt;</span></span>
  )}
&lt;/main&gt;`,wrap:!1}}),O=new w({props:{code:"bnBtJTIwcnVuJTIwZGV2",highlighted:"npm run dev",wrap:!1}}),sl=new d({props:{title:"(Optional) Step 4: Build and deploy",local:"optional-step-4-build-and-deploy",headingTag:"h3"}}),al=new w({props:{code:"bnBtJTIwcnVuJTIwYnVpbGQ=",highlighted:"npm run build",wrap:!1}}),il=new d({props:{title:"Server-side inference",local:"server-side-inference",headingTag:"h2"}}),ol=new d({props:{title:"Step 1: Initialise the project",local:"step-1-initialise-the-project",headingTag:"h3"}}),rl=new w({props:{code:"bnB4JTIwY3JlYXRlLW5leHQtYXBwJTQwbGF0ZXN0",highlighted:"npx create-next-app@latest",wrap:!1}}),Ul=new d({props:{title:"Step 2: Install and configure Transformers.js",local:"step-2-install-and-configure-transformersjs",headingTag:"h3"}}),Jl=new w({props:{code:"bnBtJTIwaSUyMCU0MHhlbm92YSUyRnRyYW5zZm9ybWVycw==",highlighted:"npm i @xenova/transformers",wrap:!1}}),Tl=new w({props:{code:"JTJGKiolMjAlNDB0eXBlJTIwJTdCaW1wb3J0KCduZXh0JykuTmV4dENvbmZpZyU3RCUyMColMkYlMEFjb25zdCUyMG5leHRDb25maWclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjAoT3B0aW9uYWwpJTIwRXhwb3J0JTIwYXMlMjBhJTIwc3RhbmRhbG9uZSUyMHNpdGUlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBTZWUlMjBodHRwcyUzQSUyRiUyRm5leHRqcy5vcmclMkZkb2NzJTJGcGFnZXMlMkZhcGktcmVmZXJlbmNlJTJGbmV4dC1jb25maWctanMlMkZvdXRwdXQlMjNhdXRvbWF0aWNhbGx5LWNvcHlpbmctdHJhY2VkLWZpbGVzJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTNBJTIwJ3N0YW5kYWxvbmUnJTJDJTIwJTJGJTJGJTIwRmVlbCUyMGZyZWUlMjB0byUyMG1vZGlmeSUyRnJlbW92ZSUyMHRoaXMlMjBvcHRpb24lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBJbmRpY2F0ZSUyMHRoYXQlMjB0aGVzZSUyMHBhY2thZ2VzJTIwc2hvdWxkJTIwbm90JTIwYmUlMjBidW5kbGVkJTIwYnklMjB3ZWJwYWNrJTBBJTIwJTIwJTIwJTIwZXhwZXJpbWVudGFsJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VydmVyQ29tcG9uZW50c0V4dGVybmFsUGFja2FnZXMlM0ElMjAlNUInc2hhcnAnJTJDJTIwJ29ubnhydW50aW1lLW5vZGUnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTdEJTNCJTBBJTBBbW9kdWxlLmV4cG9ydHMlMjAlM0QlMjBuZXh0Q29uZmln",highlighted:`<span class="hljs-comment">/** <span class="hljs-doctag">@type</span> {<span class="hljs-type">import(&#x27;next&#x27;).NextConfig</span>} */</span>
<span class="hljs-keyword">const</span> nextConfig = {
    <span class="hljs-comment">// (Optional) Export as a standalone site</span>
    <span class="hljs-comment">// See https://nextjs.org/docs/pages/api-reference/next-config-js/output#automatically-copying-traced-files</span>
    <span class="hljs-attr">output</span>: <span class="hljs-string">&#x27;standalone&#x27;</span>, <span class="hljs-comment">// Feel free to modify/remove this option</span>
    
    <span class="hljs-comment">// Indicate that these packages should not be bundled by webpack</span>
    <span class="hljs-attr">experimental</span>: {
        <span class="hljs-attr">serverComponentsExternalPackages</span>: [<span class="hljs-string">&#x27;sharp&#x27;</span>, <span class="hljs-string">&#x27;onnxruntime-node&#x27;</span>],
    },
};

<span class="hljs-variable language_">module</span>.<span class="hljs-property">exports</span> = nextConfig`,wrap:!1}}),Cl=new w({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJTIyJTQweGVub3ZhJTJGdHJhbnNmb3JtZXJzJTIyJTNCJTBBJTBBJTJGJTJGJTIwVXNlJTIwdGhlJTIwU2luZ2xldG9uJTIwcGF0dGVybiUyMHRvJTIwZW5hYmxlJTIwbGF6eSUyMGNvbnN0cnVjdGlvbiUyMG9mJTIwdGhlJTIwcGlwZWxpbmUuJTBBJTJGJTJGJTIwTk9URSUzQSUyMFdlJTIwd3JhcCUyMHRoZSUyMGNsYXNzJTIwaW4lMjBhJTIwZnVuY3Rpb24lMjB0byUyMHByZXZlbnQlMjBjb2RlJTIwZHVwbGljYXRpb24lMjAoc2VlJTIwYmVsb3cpLiUwQWNvbnN0JTIwUCUyMCUzRCUyMCgpJTIwJTNEJTNFJTIwY2xhc3MlMjBQaXBlbGluZVNpbmdsZXRvbiUyMCU3QiUwQSUyMCUyMCUyMCUyMHN0YXRpYyUyMHRhc2slMjAlM0QlMjAndGV4dC1jbGFzc2lmaWNhdGlvbiclM0IlMEElMjAlMjAlMjAlMjBzdGF0aWMlMjBtb2RlbCUyMCUzRCUyMCdYZW5vdmElMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCclM0IlMEElMjAlMjAlMjAlMjBzdGF0aWMlMjBpbnN0YW5jZSUyMCUzRCUyMG51bGwlM0IlMEElMEElMjAlMjAlMjAlMjBzdGF0aWMlMjBhc3luYyUyMGdldEluc3RhbmNlKHByb2dyZXNzX2NhbGxiYWNrJTIwJTNEJTIwbnVsbCklMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMCh0aGlzLmluc3RhbmNlJTIwJTNEJTNEJTNEJTIwbnVsbCklMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aGlzLmluc3RhbmNlJTIwJTNEJTIwcGlwZWxpbmUodGhpcy50YXNrJTJDJTIwdGhpcy5tb2RlbCUyQyUyMCU3QiUyMHByb2dyZXNzX2NhbGxiYWNrJTIwJTdEKSUzQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHRoaXMuaW5zdGFuY2UlM0IlMEElMjAlMjAlMjAlMjAlN0QlMEElN0QlMEElMEFsZXQlMjBQaXBlbGluZVNpbmdsZXRvbiUzQiUwQWlmJTIwKHByb2Nlc3MuZW52Lk5PREVfRU5WJTIwISUzRCUzRCUyMCdwcm9kdWN0aW9uJyklMjAlN0IlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBXaGVuJTIwcnVubmluZyUyMGluJTIwZGV2ZWxvcG1lbnQlMjBtb2RlJTJDJTIwYXR0YWNoJTIwdGhlJTIwcGlwZWxpbmUlMjB0byUyMHRoZSUwQSUyMCUyMCUyMCUyMCUyRiUyRiUyMGdsb2JhbCUyMG9iamVjdCUyMHNvJTIwdGhhdCUyMGl0J3MlMjBwcmVzZXJ2ZWQlMjBiZXR3ZWVuJTIwaG90JTIwcmVsb2Fkcy4lMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBGb3IlMjBtb3JlJTIwaW5mb3JtYXRpb24lMkMlMjBzZWUlMjBodHRwcyUzQSUyRiUyRnZlcmNlbC5jb20lMkZndWlkZXMlMkZuZXh0anMtcHJpc21hLXBvc3RncmVzJTBBJTIwJTIwJTIwJTIwaWYlMjAoIWdsb2JhbC5QaXBlbGluZVNpbmdsZXRvbiklMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnbG9iYWwuUGlwZWxpbmVTaW5nbGV0b24lMjAlM0QlMjBQKCklM0IlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjBQaXBlbGluZVNpbmdsZXRvbiUyMCUzRCUyMGdsb2JhbC5QaXBlbGluZVNpbmdsZXRvbiUzQiUwQSU3RCUyMGVsc2UlMjAlN0IlMEElMjAlMjAlMjAlMjBQaXBlbGluZVNpbmdsZXRvbiUyMCUzRCUyMFAoKSUzQiUwQSU3RCUwQWV4cG9ydCUyMGRlZmF1bHQlMjBQaXBlbGluZVNpbmdsZXRvbiUzQg==",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@xenova/transformers&quot;</span>;

<span class="hljs-comment">// Use the Singleton pattern to enable lazy construction of the pipeline.</span>
<span class="hljs-comment">// <span class="hljs-doctag">NOTE:</span> We wrap the class in a function to prevent code duplication (see below).</span>
<span class="hljs-keyword">const</span> <span class="hljs-title function_">P</span> = (<span class="hljs-params"></span>) =&gt; <span class="hljs-keyword">class</span> <span class="hljs-title class_">PipelineSingleton</span> {
    <span class="hljs-keyword">static</span> task = <span class="hljs-string">&#x27;text-classification&#x27;</span>;
    <span class="hljs-keyword">static</span> model = <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>;
    <span class="hljs-keyword">static</span> instance = <span class="hljs-literal">null</span>;

    <span class="hljs-keyword">static</span> <span class="hljs-keyword">async</span> <span class="hljs-title function_">getInstance</span>(<span class="hljs-params">progress_callback = <span class="hljs-literal">null</span></span>) {
        <span class="hljs-keyword">if</span> (<span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> === <span class="hljs-literal">null</span>) {
            <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> = <span class="hljs-title function_">pipeline</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">task</span>, <span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span>, { progress_callback });
        }
        <span class="hljs-keyword">return</span> <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span>;
    }
}

<span class="hljs-keyword">let</span> <span class="hljs-title class_">PipelineSingleton</span>;
<span class="hljs-keyword">if</span> (process.<span class="hljs-property">env</span>.<span class="hljs-property">NODE_ENV</span> !== <span class="hljs-string">&#x27;production&#x27;</span>) {
    <span class="hljs-comment">// When running in development mode, attach the pipeline to the</span>
    <span class="hljs-comment">// global object so that it&#x27;s preserved between hot reloads.</span>
    <span class="hljs-comment">// For more information, see https://vercel.com/guides/nextjs-prisma-postgres</span>
    <span class="hljs-keyword">if</span> (!<span class="hljs-variable language_">global</span>.<span class="hljs-property">PipelineSingleton</span>) {
        <span class="hljs-variable language_">global</span>.<span class="hljs-property">PipelineSingleton</span> = <span class="hljs-title function_">P</span>();
    }
    <span class="hljs-title class_">PipelineSingleton</span> = <span class="hljs-variable language_">global</span>.<span class="hljs-property">PipelineSingleton</span>;
} <span class="hljs-keyword">else</span> {
    <span class="hljs-title class_">PipelineSingleton</span> = <span class="hljs-title function_">P</span>();
}
<span class="hljs-keyword">export</span> <span class="hljs-keyword">default</span> <span class="hljs-title class_">PipelineSingleton</span>;`,wrap:!1}}),bl=new w({props:{code:"aW1wb3J0JTIwJTdCJTIwTmV4dFJlc3BvbnNlJTIwJTdEJTIwZnJvbSUyMCduZXh0JTJGc2VydmVyJyUwQWltcG9ydCUyMFBpcGVsaW5lU2luZ2xldG9uJTIwZnJvbSUyMCcuJTJGcGlwZWxpbmUuanMnJTNCJTBBJTBBZXhwb3J0JTIwYXN5bmMlMjBmdW5jdGlvbiUyMEdFVChyZXF1ZXN0KSUyMCU3QiUwQSUyMCUyMCUyMCUyMGNvbnN0JTIwdGV4dCUyMCUzRCUyMHJlcXVlc3QubmV4dFVybC5zZWFyY2hQYXJhbXMuZ2V0KCd0ZXh0JyklM0IlMEElMjAlMjAlMjAlMjBpZiUyMCghdGV4dCklMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBOZXh0UmVzcG9uc2UuanNvbiglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlcnJvciUzQSUyMCdNaXNzaW5nJTIwdGV4dCUyMHBhcmFtZXRlciclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlN0IlMjBzdGF0dXMlM0ElMjA0MDAlMjAlN0QpJTNCJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwR2V0JTIwdGhlJTIwY2xhc3NpZmljYXRpb24lMjBwaXBlbGluZS4lMjBXaGVuJTIwY2FsbGVkJTIwZm9yJTIwdGhlJTIwZmlyc3QlMjB0aW1lJTJDJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwdGhpcyUyMHdpbGwlMjBsb2FkJTIwdGhlJTIwcGlwZWxpbmUlMjBhbmQlMjBjYWNoZSUyMGl0JTIwZm9yJTIwZnV0dXJlJTIwdXNlLiUwQSUyMCUyMCUyMCUyMGNvbnN0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwUGlwZWxpbmVTaW5nbGV0b24uZ2V0SW5zdGFuY2UoKSUzQiUwQSUwQSUyMCUyMCUyMCUyMCUyRiUyRiUyMEFjdHVhbGx5JTIwcGVyZm9ybSUyMHRoZSUyMGNsYXNzaWZpY2F0aW9uJTBBJTIwJTIwJTIwJTIwY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIodGV4dCklM0IlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBOZXh0UmVzcG9uc2UuanNvbihyZXN1bHQpJTNCJTBBJTdE",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">NextResponse</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;next/server&#x27;</span>
<span class="hljs-keyword">import</span> <span class="hljs-title class_">PipelineSingleton</span> <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;./pipeline.js&#x27;</span>;

<span class="hljs-keyword">export</span> <span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">GET</span>(<span class="hljs-params">request</span>) {
    <span class="hljs-keyword">const</span> text = request.<span class="hljs-property">nextUrl</span>.<span class="hljs-property">searchParams</span>.<span class="hljs-title function_">get</span>(<span class="hljs-string">&#x27;text&#x27;</span>);
    <span class="hljs-keyword">if</span> (!text) {
        <span class="hljs-keyword">return</span> <span class="hljs-title class_">NextResponse</span>.<span class="hljs-title function_">json</span>({
            <span class="hljs-attr">error</span>: <span class="hljs-string">&#x27;Missing text parameter&#x27;</span>,
        }, { <span class="hljs-attr">status</span>: <span class="hljs-number">400</span> });
    }
    <span class="hljs-comment">// Get the classification pipeline. When called for the first time,</span>
    <span class="hljs-comment">// this will load the pipeline and cache it for future use.</span>
    <span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title class_">PipelineSingleton</span>.<span class="hljs-title function_">getInstance</span>();

    <span class="hljs-comment">// Actually perform the classification</span>
    <span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text);

    <span class="hljs-keyword">return</span> <span class="hljs-title class_">NextResponse</span>.<span class="hljs-title function_">json</span>(result);
}`,wrap:!1}}),Il=new d({props:{title:"Step 3: Design the user interface",local:"step-3-design-the-user-interface",headingTag:"h3"}}),Zl=new w({props:{code:"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",highlighted:`<span class="hljs-string">&#x27;use client&#x27;</span>

<span class="hljs-keyword">import</span> { useState } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;react&#x27;</span>

<span class="hljs-keyword">export</span> <span class="hljs-keyword">default</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">Home</span>(<span class="hljs-params"></span>) {

  <span class="hljs-comment">// Keep track of the classification result and the model loading status.</span>
  <span class="hljs-keyword">const</span> [result, setResult] = <span class="hljs-title function_">useState</span>(<span class="hljs-literal">null</span>);
  <span class="hljs-keyword">const</span> [ready, setReady] = <span class="hljs-title function_">useState</span>(<span class="hljs-literal">null</span>);

  <span class="hljs-keyword">const</span> <span class="hljs-title function_">classify</span> = <span class="hljs-keyword">async</span> (<span class="hljs-params">text</span>) =&gt; {
    <span class="hljs-keyword">if</span> (!text) <span class="hljs-keyword">return</span>;
    <span class="hljs-keyword">if</span> (ready === <span class="hljs-literal">null</span>) <span class="hljs-title function_">setReady</span>(<span class="hljs-literal">false</span>);

    <span class="hljs-comment">// Make a request to the /classify route on the server.</span>
    <span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">\`/classify?text=<span class="hljs-subst">\${<span class="hljs-built_in">encodeURIComponent</span>(text)}</span>\`</span>);

    <span class="hljs-comment">// If this is the first time we&#x27;ve made a request, set the ready flag.</span>
    <span class="hljs-keyword">if</span> (!ready) <span class="hljs-title function_">setReady</span>(<span class="hljs-literal">true</span>);

    <span class="hljs-keyword">const</span> json = <span class="hljs-keyword">await</span> result.<span class="hljs-title function_">json</span>();
    <span class="hljs-title function_">setResult</span>(json);
  };
  <span class="hljs-keyword">return</span> (
    <span class="language-xml"><span class="hljs-tag">&lt;<span class="hljs-name">main</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;flex min-h-screen flex-col items-center justify-center p-12&quot;</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">h1</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;text-5xl font-bold mb-2 text-center&quot;</span>&gt;</span>Transformers.js<span class="hljs-tag">&lt;/<span class="hljs-name">h1</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">h2</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;text-2xl mb-4 text-center&quot;</span>&gt;</span>Next.js template (server-side)<span class="hljs-tag">&lt;/<span class="hljs-name">h2</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">input</span>
        <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;text&quot;</span>
        <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;w-full max-w-xs p-2 border border-gray-300 rounded mb-4&quot;</span>
        <span class="hljs-attr">placeholder</span>=<span class="hljs-string">&quot;Enter text here&quot;</span>
        <span class="hljs-attr">onInput</span>=<span class="hljs-string">{e</span> =&gt;</span> {
          classify(e.target.value);
        }}
      /&gt;

      {ready !== null &amp;&amp; (
        <span class="hljs-tag">&lt;<span class="hljs-name">pre</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;bg-gray-100 p-2 rounded&quot;</span>&gt;</span>
          {
            (!ready || !result) ? &#x27;Loading...&#x27; : JSON.stringify(result, null, 2)}
        <span class="hljs-tag">&lt;/<span class="hljs-name">pre</span>&gt;</span>
      )}
    <span class="hljs-tag">&lt;/<span class="hljs-name">main</span>&gt;</span></span>
  )
}`,wrap:!1}}),Gl=new w({props:{code:"bnBtJTIwcnVuJTIwZGV2",highlighted:"npm run dev",wrap:!1}}),kl=new d({props:{title:"(Optional) Step 4: Build and deploy",local:"optional-step-4-build-and-deploy",headingTag:"h3"}}),xl=new w({props:{code:"LS0tJTBBdGl0bGUlM0ElMjBOZXh0JTIwU2VydmVyJTIwRXhhbXBsZSUyMEFwcCUwQWVtb2ppJTNBJTIwJUYwJTlGJTk0JUE1JTBBY29sb3JGcm9tJTNBJTIweWVsbG93JTBBY29sb3JUbyUzQSUyMHJlZCUwQXNkayUzQSUyMGRvY2tlciUwQXBpbm5lZCUzQSUyMGZhbHNlJTBBYXBwX3BvcnQlM0ElMjAzMDAwJTBBLS0t",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">title:</span> <span class="hljs-string">Next</span> <span class="hljs-string">Server</span> <span class="hljs-string">Example</span> <span class="hljs-string">App</span>
<span class="hljs-attr">emoji:</span> <span class="hljs-string">🔥</span>
<span class="hljs-attr">colorFrom:</span> <span class="hljs-string">yellow</span>
<span class="hljs-attr">colorTo:</span> <span class="hljs-string">red</span>
<span class="hljs-attr">sdk:</span> <span class="hljs-string">docker</span>
<span class="hljs-attr">pinned:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">app_port:</span> <span class="hljs-number">3000</span>
<span class="hljs-meta">---</span>`,wrap:!1}}),{c(){m=p("meta"),Fl=t(),Xl=p("p"),Ll=t(),c(f.$$.fragment),_l=t(),b=p("p"),b.innerHTML=Je,Pl=t(),I=p("p"),I.innerHTML=de,ql=t(),g=p("p"),g.textContent=Te,Kl=t(),Z=p("ul"),Z.innerHTML=me,Dl=t(),c(B.$$.fragment),Ol=t(),G=p("ul"),G.innerHTML=ue,ls=t(),c(A.$$.fragment),ss=t(),c(k.$$.fragment),es=t(),N=p("p"),N.innerHTML=Ce,as=t(),c(x.$$.fragment),ts=t(),v=p("p"),v.textContent=fe,ns=t(),W=p("pre"),W.innerHTML=be,ps=t(),c(R.$$.fragment),Ms=t(),S=p("p"),S.innerHTML=Ie,is=t(),c(E.$$.fragment),cs=t(),Q=p("p"),Q.innerHTML=ge,os=t(),c(V.$$.fragment),js=t(),Y=p("p"),Y.innerHTML=Ze,rs=t(),c($.$$.fragment),ys=t(),c(X.$$.fragment),hs=t(),H=p("p"),H.innerHTML=Be,Us=t(),c(z.$$.fragment),ws=t(),F=p("p"),F.innerHTML=Ge,Js=t(),c(L.$$.fragment),ds=t(),_=p("p"),_.innerHTML=Ae,Ts=t(),c(P.$$.fragment),ms=t(),q=p("p"),q.innerHTML=ke,us=t(),c(K.$$.fragment),Cs=t(),D=p("p"),D.textContent=Ne,fs=t(),c(O.$$.fragment),bs=t(),ll=p("p"),ll.innerHTML=xe,Is=t(),c(sl.$$.fragment),gs=t(),el=p("p"),el.textContent=ve,Zs=t(),c(al.$$.fragment),Bs=t(),tl=p("p"),tl.innerHTML=We,Gs=t(),nl=p("p"),nl.innerHTML=Re,As=t(),pl=p("ol"),pl.innerHTML=Se,ks=t(),Ml=p("p"),Ml.innerHTML=Ee,Ns=t(),c(il.$$.fragment),xs=t(),cl=p("p"),cl.innerHTML=Qe,vs=t(),c(ol.$$.fragment),Ws=t(),jl=p("p"),jl.innerHTML=Ve,Rs=t(),c(rl.$$.fragment),Ss=t(),yl=p("p"),yl.textContent=Ye,Es=t(),hl=p("pre"),hl.innerHTML=$e,Qs=t(),c(Ul.$$.fragment),Vs=t(),wl=p("p"),wl.innerHTML=Xe,Ys=t(),c(Jl.$$.fragment),$s=t(),dl=p("p"),dl.innerHTML=He,Xs=t(),c(Tl.$$.fragment),Hs=t(),ml=p("p"),ml.innerHTML=ze,zs=t(),u=p("ol"),ul=p("li"),Rl=p("p"),Rl.innerHTML=Fe,Me=t(),c(Cl.$$.fragment),ie=t(),fl=p("li"),Sl=p("p"),Sl.innerHTML=Le,ce=t(),c(bl.$$.fragment),Fs=t(),c(Il.$$.fragment),Ls=t(),gl=p("p"),gl.innerHTML=_e,_s=t(),c(Zl.$$.fragment),Ps=t(),Bl=p("p"),Bl.textContent=Pe,qs=t(),c(Gl.$$.fragment),Ks=t(),Al=p("p"),Al.innerHTML=qe,Ds=t(),c(kl.$$.fragment),Os=t(),Nl=p("p"),Nl.innerHTML=Ke,le=t(),J=p("ol"),El=p("li"),El.innerHTML=De,oe=t(),Ql=p("li"),Ql.innerHTML=Oe,je=t(),Vl=p("li"),Vl.textContent=la,re=t(),Yl=p("li"),Yl.innerHTML=sa,ye=t(),C=p("li"),he=ta("Add the following lines to the top of your "),$l=p("code"),$l.textContent=ea,Ue=ta(`:
	`),c(xl.$$.fragment),se=t(),vl=p("p"),vl.innerHTML=aa,ee=t(),Hl=p("p"),this.h()},l(l){const s=ra("svelte-u9bgzb",document.head);m=M(s,"META",{name:!0,content:!0}),s.forEach(e),Fl=n(l),Xl=M(l,"P",{}),Wl(Xl).forEach(e),Ll=n(l),o(f.$$.fragment,l),_l=n(l),b=M(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1nylfgr"&&(b.innerHTML=Je),Pl=n(l),I=M(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-17tgu1r"&&(I.innerHTML=de),ql=n(l),g=M(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1tlxmzn"&&(g.textContent=Te),Kl=n(l),Z=M(l,"UL",{"data-svelte-h":!0}),i(Z)!=="svelte-10avis"&&(Z.innerHTML=me),Dl=n(l),o(B.$$.fragment,l),Ol=n(l),G=M(l,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-1qy4daj"&&(G.innerHTML=ue),ls=n(l),o(A.$$.fragment,l),ss=n(l),o(k.$$.fragment,l),es=n(l),N=M(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1czujs6"&&(N.innerHTML=Ce),as=n(l),o(x.$$.fragment,l),ts=n(l),v=M(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1e2sayh"&&(v.textContent=fe),ns=n(l),W=M(l,"PRE",{"data-svelte-h":!0}),i(W)!=="svelte-raz40n"&&(W.innerHTML=be),ps=n(l),o(R.$$.fragment,l),Ms=n(l),S=M(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-85b125"&&(S.innerHTML=Ie),is=n(l),o(E.$$.fragment,l),cs=n(l),Q=M(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-15lfmif"&&(Q.innerHTML=ge),os=n(l),o(V.$$.fragment,l),js=n(l),Y=M(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-u8iy0u"&&(Y.innerHTML=Ze),rs=n(l),o($.$$.fragment,l),ys=n(l),o(X.$$.fragment,l),hs=n(l),H=M(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1bw7883"&&(H.innerHTML=Be),Us=n(l),o(z.$$.fragment,l),ws=n(l),F=M(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-oz1fe5"&&(F.innerHTML=Ge),Js=n(l),o(L.$$.fragment,l),ds=n(l),_=M(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-g6jg3k"&&(_.innerHTML=Ae),Ts=n(l),o(P.$$.fragment,l),ms=n(l),q=M(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1dv45qm"&&(q.innerHTML=ke),us=n(l),o(K.$$.fragment,l),Cs=n(l),D=M(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-io8j5y"&&(D.textContent=Ne),fs=n(l),o(O.$$.fragment,l),bs=n(l),ll=M(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-1fua6wp"&&(ll.innerHTML=xe),Is=n(l),o(sl.$$.fragment,l),gs=n(l),el=M(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-1mj3vkj"&&(el.textContent=ve),Zs=n(l),o(al.$$.fragment,l),Bs=n(l),tl=M(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-7b0fyw"&&(tl.innerHTML=We),Gs=n(l),nl=M(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-1c1gg25"&&(nl.innerHTML=Re),As=n(l),pl=M(l,"OL",{"data-svelte-h":!0}),i(pl)!=="svelte-1qoae7i"&&(pl.innerHTML=Se),ks=n(l),Ml=M(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-181xlpv"&&(Ml.innerHTML=Ee),Ns=n(l),o(il.$$.fragment,l),xs=n(l),cl=M(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-1fep2js"&&(cl.innerHTML=Qe),vs=n(l),o(ol.$$.fragment,l),Ws=n(l),jl=M(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-1czujs6"&&(jl.innerHTML=Ve),Rs=n(l),o(rl.$$.fragment,l),Ss=n(l),yl=M(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-1e2sayh"&&(yl.textContent=Ye),Es=n(l),hl=M(l,"PRE",{"data-svelte-h":!0}),i(hl)!=="svelte-raz40n"&&(hl.innerHTML=$e),Qs=n(l),o(Ul.$$.fragment,l),Vs=n(l),wl=M(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-85b125"&&(wl.innerHTML=Xe),Ys=n(l),o(Jl.$$.fragment,l),$s=n(l),dl=M(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-e504gd"&&(dl.innerHTML=He),Xs=n(l),o(Tl.$$.fragment,l),Hs=n(l),ml=M(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-ln1yih"&&(ml.innerHTML=ze),zs=n(l),u=M(l,"OL",{});var te=Wl(u);ul=M(te,"LI",{});var ne=Wl(ul);Rl=M(ne,"P",{"data-svelte-h":!0}),i(Rl)!=="svelte-hhkldd"&&(Rl.innerHTML=Fe),Me=n(ne),o(Cl.$$.fragment,ne),ne.forEach(e),ie=n(te),fl=M(te,"LI",{});var pe=Wl(fl);Sl=M(pe,"P",{"data-svelte-h":!0}),i(Sl)!=="svelte-8ih7ic"&&(Sl.innerHTML=Le),ce=n(pe),o(bl.$$.fragment,pe),pe.forEach(e),te.forEach(e),Fs=n(l),o(Il.$$.fragment,l),Ls=n(l),gl=M(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-1gfy2af"&&(gl.innerHTML=_e),_s=n(l),o(Zl.$$.fragment,l),Ps=n(l),Bl=M(l,"P",{"data-svelte-h":!0}),i(Bl)!=="svelte-io8j5y"&&(Bl.textContent=Pe),qs=n(l),o(Gl.$$.fragment,l),Ks=n(l),Al=M(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-1fua6wp"&&(Al.innerHTML=qe),Ds=n(l),o(kl.$$.fragment,l),Os=n(l),Nl=M(l,"P",{"data-svelte-h":!0}),i(Nl)!=="svelte-1cz80l1"&&(Nl.innerHTML=Ke),le=n(l),J=M(l,"OL",{});var T=Wl(J);El=M(T,"LI",{"data-svelte-h":!0}),i(El)!=="svelte-1vfzf1x"&&(El.innerHTML=De),oe=n(T),Ql=M(T,"LI",{"data-svelte-h":!0}),i(Ql)!=="svelte-a197qz"&&(Ql.innerHTML=Oe),je=n(T),Vl=M(T,"LI",{"data-svelte-h":!0}),i(Vl)!=="svelte-1ne6ri6"&&(Vl.textContent=la),re=n(T),Yl=M(T,"LI",{"data-svelte-h":!0}),i(Yl)!=="svelte-1vsgr21"&&(Yl.innerHTML=sa),ye=n(T),C=M(T,"LI",{});var zl=Wl(C);he=na(zl,"Add the following lines to the top of your "),$l=M(zl,"CODE",{"data-svelte-h":!0}),i($l)!=="svelte-87wnd9"&&($l.textContent=ea),Ue=na(zl,`:
	`),o(xl.$$.fragment,zl),zl.forEach(e),T.forEach(e),se=n(l),vl=M(l,"P",{"data-svelte-h":!0}),i(vl)!=="svelte-181xlpv"&&(vl.innerHTML=aa),ee=n(l),Hl=M(l,"P",{}),Wl(Hl).forEach(e),this.h()},h(){pa(m,"name","hf:doc:metadata"),pa(m,"content",ha)},m(l,s){U(document.head,m),a(l,Fl,s),a(l,Xl,s),a(l,Ll,s),j(f,l,s),a(l,_l,s),a(l,b,s),a(l,Pl,s),a(l,I,s),a(l,ql,s),a(l,g,s),a(l,Kl,s),a(l,Z,s),a(l,Dl,s),j(B,l,s),a(l,Ol,s),a(l,G,s),a(l,ls,s),j(A,l,s),a(l,ss,s),j(k,l,s),a(l,es,s),a(l,N,s),a(l,as,s),j(x,l,s),a(l,ts,s),a(l,v,s),a(l,ns,s),a(l,W,s),a(l,ps,s),j(R,l,s),a(l,Ms,s),a(l,S,s),a(l,is,s),j(E,l,s),a(l,cs,s),a(l,Q,s),a(l,os,s),j(V,l,s),a(l,js,s),a(l,Y,s),a(l,rs,s),j($,l,s),a(l,ys,s),j(X,l,s),a(l,hs,s),a(l,H,s),a(l,Us,s),j(z,l,s),a(l,ws,s),a(l,F,s),a(l,Js,s),j(L,l,s),a(l,ds,s),a(l,_,s),a(l,Ts,s),j(P,l,s),a(l,ms,s),a(l,q,s),a(l,us,s),j(K,l,s),a(l,Cs,s),a(l,D,s),a(l,fs,s),j(O,l,s),a(l,bs,s),a(l,ll,s),a(l,Is,s),j(sl,l,s),a(l,gs,s),a(l,el,s),a(l,Zs,s),j(al,l,s),a(l,Bs,s),a(l,tl,s),a(l,Gs,s),a(l,nl,s),a(l,As,s),a(l,pl,s),a(l,ks,s),a(l,Ml,s),a(l,Ns,s),j(il,l,s),a(l,xs,s),a(l,cl,s),a(l,vs,s),j(ol,l,s),a(l,Ws,s),a(l,jl,s),a(l,Rs,s),j(rl,l,s),a(l,Ss,s),a(l,yl,s),a(l,Es,s),a(l,hl,s),a(l,Qs,s),j(Ul,l,s),a(l,Vs,s),a(l,wl,s),a(l,Ys,s),j(Jl,l,s),a(l,$s,s),a(l,dl,s),a(l,Xs,s),j(Tl,l,s),a(l,Hs,s),a(l,ml,s),a(l,zs,s),a(l,u,s),U(u,ul),U(ul,Rl),U(ul,Me),j(Cl,ul,null),U(u,ie),U(u,fl),U(fl,Sl),U(fl,ce),j(bl,fl,null),a(l,Fs,s),j(Il,l,s),a(l,Ls,s),a(l,gl,s),a(l,_s,s),j(Zl,l,s),a(l,Ps,s),a(l,Bl,s),a(l,qs,s),j(Gl,l,s),a(l,Ks,s),a(l,Al,s),a(l,Ds,s),j(kl,l,s),a(l,Os,s),a(l,Nl,s),a(l,le,s),a(l,J,s),U(J,El),U(J,oe),U(J,Ql),U(J,je),U(J,Vl),U(J,re),U(J,Yl),U(J,ye),U(J,C),U(C,he),U(C,$l),U(C,Ue),j(xl,C,null),a(l,se,s),a(l,vl,s),a(l,ee,s),a(l,Hl,s),ae=!0},p:ia,i(l){ae||(r(f.$$.fragment,l),r(B.$$.fragment,l),r(A.$$.fragment,l),r(k.$$.fragment,l),r(x.$$.fragment,l),r(R.$$.fragment,l),r(E.$$.fragment,l),r(V.$$.fragment,l),r($.$$.fragment,l),r(X.$$.fragment,l),r(z.$$.fragment,l),r(L.$$.fragment,l),r(P.$$.fragment,l),r(K.$$.fragment,l),r(O.$$.fragment,l),r(sl.$$.fragment,l),r(al.$$.fragment,l),r(il.$$.fragment,l),r(ol.$$.fragment,l),r(rl.$$.fragment,l),r(Ul.$$.fragment,l),r(Jl.$$.fragment,l),r(Tl.$$.fragment,l),r(Cl.$$.fragment,l),r(bl.$$.fragment,l),r(Il.$$.fragment,l),r(Zl.$$.fragment,l),r(Gl.$$.fragment,l),r(kl.$$.fragment,l),r(xl.$$.fragment,l),ae=!0)},o(l){y(f.$$.fragment,l),y(B.$$.fragment,l),y(A.$$.fragment,l),y(k.$$.fragment,l),y(x.$$.fragment,l),y(R.$$.fragment,l),y(E.$$.fragment,l),y(V.$$.fragment,l),y($.$$.fragment,l),y(X.$$.fragment,l),y(z.$$.fragment,l),y(L.$$.fragment,l),y(P.$$.fragment,l),y(K.$$.fragment,l),y(O.$$.fragment,l),y(sl.$$.fragment,l),y(al.$$.fragment,l),y(il.$$.fragment,l),y(ol.$$.fragment,l),y(rl.$$.fragment,l),y(Ul.$$.fragment,l),y(Jl.$$.fragment,l),y(Tl.$$.fragment,l),y(Cl.$$.fragment,l),y(bl.$$.fragment,l),y(Il.$$.fragment,l),y(Zl.$$.fragment,l),y(Gl.$$.fragment,l),y(kl.$$.fragment,l),y(xl.$$.fragment,l),ae=!1},d(l){l&&(e(Fl),e(Xl),e(Ll),e(_l),e(b),e(Pl),e(I),e(ql),e(g),e(Kl),e(Z),e(Dl),e(Ol),e(G),e(ls),e(ss),e(es),e(N),e(as),e(ts),e(v),e(ns),e(W),e(ps),e(Ms),e(S),e(is),e(cs),e(Q),e(os),e(js),e(Y),e(rs),e(ys),e(hs),e(H),e(Us),e(ws),e(F),e(Js),e(ds),e(_),e(Ts),e(ms),e(q),e(us),e(Cs),e(D),e(fs),e(bs),e(ll),e(Is),e(gs),e(el),e(Zs),e(Bs),e(tl),e(Gs),e(nl),e(As),e(pl),e(ks),e(Ml),e(Ns),e(xs),e(cl),e(vs),e(Ws),e(jl),e(Rs),e(Ss),e(yl),e(Es),e(hl),e(Qs),e(Vs),e(wl),e(Ys),e($s),e(dl),e(Xs),e(Hs),e(ml),e(zs),e(u),e(Fs),e(Ls),e(gl),e(_s),e(Ps),e(Bl),e(qs),e(Ks),e(Al),e(Ds),e(Os),e(Nl),e(le),e(J),e(se),e(vl),e(ee),e(Hl)),e(m),h(f,l),h(B,l),h(A,l),h(k,l),h(x,l),h(R,l),h(E,l),h(V,l),h($,l),h(X,l),h(z,l),h(L,l),h(P,l),h(K,l),h(O,l),h(sl,l),h(al,l),h(il,l),h(ol,l),h(rl,l),h(Ul,l),h(Jl,l),h(Tl,l),h(Cl),h(bl),h(Il,l),h(Zl,l),h(Gl,l),h(kl,l),h(xl)}}}const ha='{"title":"Building a Next.js application","local":"building-a-nextjs-application","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Client-side inference","local":"client-side-inference","sections":[{"title":"Step 1: Initialise the project","local":"step-1-initialise-the-project","sections":[],"depth":3},{"title":"Step 2: Install and configure Transformers.js","local":"step-2-install-and-configure-transformersjs","sections":[],"depth":3},{"title":"Step 3: Design the user interface","local":"step-3-design-the-user-interface","sections":[],"depth":3},{"title":"(Optional) Step 4: Build and deploy","local":"optional-step-4-build-and-deploy","sections":[],"depth":3}],"depth":2},{"title":"Server-side inference","local":"server-side-inference","sections":[{"title":"Step 1: Initialise the project","local":"step-1-initialise-the-project","sections":[],"depth":3},{"title":"Step 2: Install and configure Transformers.js","local":"step-2-install-and-configure-transformersjs","sections":[],"depth":3},{"title":"Step 3: Design the user interface","local":"step-3-design-the-user-interface","sections":[],"depth":3},{"title":"(Optional) Step 4: Build and deploy","local":"optional-step-4-build-and-deploy","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ua(we){return ca(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ma extends oa{constructor(m){super(),ja(this,m,Ua,ya,Ma,{})}}export{ma as component};
