import{s as $s,n as Ps,o as Cs}from"../chunks/scheduler.b108d059.js";import{S as As,i as Hs,g as o,s as r,r as m,A as Ls,h as i,f as e,c as a,j as n,u as f,x as s,k as u,y as Ms,a as d,v as p,d as h,t as c,w as T}from"../chunks/index.008de539.js";import{H as y}from"../chunks/Heading.88bfeb84.js";function ws(Ro){let v,Fl,vl,bl,_,xl,F,$l,b,zo="Helper module for mathematical processing.",Pl,x,ko=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,Cl,$,Ko='<li><a href="#module_utils/maths">utils/maths</a><ul><li><em>static</em><ul><li><a href="#module_utils/maths.interpolate_data"><code>.interpolate_data(input)</code></a></li> <li><a href="#module_utils/maths.permute_data"><code>.permute_data(array, dims, axes)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.softmax"><code>.softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.log_softmax"><code>.log_softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.dot"><code>.dot(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.getTopItems"><code>.getTopItems(items, [top_k])</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.cos_sim"><code>.cos_sim(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.magnitude"><code>.magnitude(arr)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.min"><code>.min(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.max"><code>.max(arr)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.medianFilter"><code>.medianFilter(data, windowSize)</code></a></li> <li><a href="#module_utils/maths.round"><code>.round(num, decimals)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.bankers_round"><code>.bankers_round(x)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+completeSpectrum"><code>.completeSpectrum(spectrum)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li> <li><a href="#module_utils/maths..NP2FFT">~NP2FFT</a><ul><li><a href="#new_module_utils/maths..NP2FFT_new"><code>new NP2FFT(fft_length)</code></a></li></ul></li> <li><a href="#module_utils/maths..AnyTypedArray"><code>~AnyTypedArray</code></a> : <code>Int8Array</code> | <code>Uint8Array</code> | <code>Uint8ClampedArray</code> | <code>Int16Array</code> | <code>Uint16Array</code> | <code>Int32Array</code> | <code>Uint32Array</code> | <code>Float32Array</code> | <code>Float64Array</code></li></ul></li></ul></li>',Al,Hl,Ll,P,Ml,C,wl,A,Bo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',gl,H,Oo="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>TypedArray</code></td></tr></tbody>",El,Rl,zl,L,kl,M,Kl,w,Do="Helper method to permute a <code>AnyTypedArray</code> directly",Bl,g,Io='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - The permuted array and the new shape.',Ol,E,jo="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>array</td><td><code>T</code></td> </tr><tr><td>dims</td><td><code>Array.&lt;number&gt;</code></td> </tr><tr><td>axes</td><td><code>Array.&lt;number&gt;</code></td></tr></tbody>",Dl,Il,jl,R,Ul,z,ql,k,Uo="Compute the softmax of an array of numbers.",Sl,K,qo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The softmax array.',Nl,B,So="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The array of numbers to compute the softmax of.</p></td></tr></tbody>",Gl,Jl,Ql,O,Vl,D,Wl,I,No="Calculates the logarithm of the softmax function for the input array.",Xl,j,Go='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The resulting log_softmax array.',Yl,U,Jo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The input array to calculate the log_softmax function for.</p></td></tr></tbody>",Zl,td,ed,q,ld,S,dd,N,Qo="Calculates the dot product of two arrays.",rd,G,Vo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The dot product of arr1 and arr2.',ad,J,Wo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",od,id,sd,Q,ud,V,nd,W,Xo="Get the top k items from an iterable, sorted by descending order",md,X,Yo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - The top k items, sorted by descending order',fd,Y,Zo="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>items</td><td><code>Array&lt;any&gt;</code> | <code>TypedArray</code></td><td></td><td><p>The items to be sorted</p></td> </tr><tr><td>[top_k]</td><td><code>number</code> | <code>null</code></td><td><code>0</code></td><td><p>The number of top items to return (default: 0 = return all)</p></td></tr></tbody>",pd,hd,cd,Z,Td,tt,yd,et,ti="Computes the cosine similarity between two arrays.",vd,lt,ei='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The cosine similarity between the two arrays.',_d,dt,li="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",Fd,bd,xd,rt,$d,at,Pd,ot,di="Calculates the magnitude of a given array.",Cd,it,ri='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The magnitude of the array.',Ad,st,ai="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The array to calculate the magnitude of.</p></td></tr></tbody>",Hd,Ld,Md,ut,wd,nt,gd,mt,oi="Returns the value and index of the minimum element in an array.",Ed,ft,ii='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - the value and index of the minimum element, of the form: [valueOfMin, indexOfMin]<br/> <strong>Throws</strong>:',Rd,pt,si="<li><code>Error</code> If array is empty.</li>",zd,ht,ui="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>TypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",kd,Kd,Bd,ct,Od,Tt,Dd,yt,ni="Returns the value and index of the maximum element in an array.",Id,vt,mi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - the value and index of the maximum element, of the form: [valueOfMax, indexOfMax]<br/> <strong>Throws</strong>:',jd,_t,fi="<li><code>Error</code> If array is empty.</li>",Ud,Ft,pi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>AnyTypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",qd,Sd,Nd,bt,Gd,xt,Jd,$t,hi="Performs median filter on the provided data. Padding is done by mirroring the data.",Qd,Pt,ci='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Vd,Ct,Ti="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>AnyTypedArray</code></td><td><p>The input array</p></td> </tr><tr><td>windowSize</td><td><code>number</code></td><td><p>The window size</p></td></tr></tbody>",Wd,Xd,Yd,At,Zd,Ht,tr,Lt,yi="Helper function to round a number to a given number of decimals",er,Mt,vi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',lr,wt,_i="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>num</td><td><code>number</code></td><td><p>The number to round</p></td> </tr><tr><td>decimals</td><td><code>number</code></td><td><p>The number of decimals</p></td></tr></tbody>",dr,rr,ar,gt,or,Et,ir,Rt,Fi=`Helper function to round a number to the nearest integer, with ties rounded to the nearest even number.
Also known as “bankers’ rounding”. This is the default rounding mode in python. For example:
1.5 rounds to 2 and 2.5 rounds to 2.`,sr,zt,bi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',ur,kt,xi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>number</code></td><td><p>The number to round</p></td></tr></tbody>",nr,mr,fr,Kt,pr,Bt,hr,Ot,$i="Implementation of Radix-4 FFT.",cr,Dt,Pi=`P2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are a power of two in length.
Code adapted from <a href="https://www.npmjs.com/package/fft.js" rel="nofollow">https://www.npmjs.com/package/fft.js</a>`,Tr,It,Ci='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',yr,jt,Ai='<li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+completeSpectrum"><code>.completeSpectrum(spectrum)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li>',vr,_r,Fr,Ut,br,qt,xr,St,Hi="<strong>Throws</strong>:",$r,Nt,Li="<li><code>Error</code> FFT size must be a power of two larger than 1.</li>",Pr,Gt,Mi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>number</code></td><td><p>The size of the input array. Must be a power of two larger than 1.</p></td></tr></tbody>",Cr,Ar,Hr,Jt,Lr,Qt,Mr,Vt,wi="Create a complex number array with size <code>2 * size</code>",wr,Wt,gi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - A complex number array with size <code>2 * size</code>',gr,Er,Rr,Xt,zr,Yt,kr,Zt,Ei="Converts a complex number representation stored in a Float64Array to an array of real numbers.",Kr,te,Ri='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - An array of real numbers representing the input complex number representation.',Br,ee,zi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>complex</td><td><code>Float64Array</code></td><td><p>The complex number representation to be converted.</p></td> </tr><tr><td>[storage]</td><td><code>Array.&lt;number&gt;</code></td><td><p>An optional array to store the result in.</p></td></tr></tbody>",Or,Dr,Ir,le,jr,de,Ur,re,ki="Convert a real-valued input array to a complex-valued output array.",qr,ae,Ki='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The complex-valued output array.',Sr,oe,Bi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Float64Array</code></td><td><p>The real-valued input array.</p></td> </tr><tr><td>[storage]</td><td><code>Float64Array</code></td><td><p>Optional buffer to store the output array.</p></td></tr></tbody>",Nr,Gr,Jr,ie,Qr,se,Vr,ue,Oi="Completes the spectrum by adding its mirrored negative frequency components.",Wr,ne,Di='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Xr,me,Ii="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>spectrum</td><td><code>Float64Array</code></td><td><p>The input spectrum.</p></td></tr></tbody>",Yr,Zr,ta,fe,ea,pe,la,he,ji="Performs a Fast Fourier Transform (FFT) on the given input data and stores the result in the output buffer.",da,ce,Ui='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',ra,Te,qi="<li><code>Error</code> Input and output buffers must be different.</li>",aa,ye,Si="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer to store the result.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",oa,ia,sa,ve,ua,_e,na,Fe,Ni=`Performs a real-valued forward FFT on the given input buffer and stores the result in the given output buffer.
The input buffer must contain real values only, while the output buffer will contain complex values. The input and
output buffers must be different.`,ma,be,Gi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',fa,xe,Ji="<li><code>Error</code> If the input and output buffers are the same.</li>",pa,$e,Qi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer containing real values.</p></td></tr></tbody>",ha,ca,Ta,Pe,ya,Ce,va,Ae,Vi=`Performs an inverse FFT transformation on the given <code>data</code> array, and stores the result in <code>out</code>.
The <code>out</code> array must be a different buffer than the <code>data</code> array. The <code>out</code> array will contain the
result of the transformation. The <code>data</code> array will not be modified.`,_a,He,Wi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',Fa,Le,Xi="<li><code>Error</code> If `out` and `data` refer to the same buffer.</li>",ba,Me,Yi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",xa,$a,Pa,we,Ca,ge,Aa,Ee,Zi="Performs a radix-4 implementation of a discrete Fourier transform on a given set of data.",Ha,Re,ts='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',La,ze,es="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>A scaling factor to apply to the transform.</p></td></tr></tbody>",Ma,wa,ga,ke,Ea,Ke,Ra,Be,ls="Performs a radix-2 implementation of a discrete Fourier transform on a given set of data.",za,Oe,ds='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',ka,De,rs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset at which to write the output data.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset at which to begin reading the input data.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for indexing the input data.</p></td></tr></tbody>",Ka,Ba,Oa,Ie,Da,je,Ia,Ue,as="Performs radix-4 transformation on input data of length 8",ja,qe,os='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Ua,Se,is="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input data array of length 8</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output data array of length 8</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>Index of output array to start writing from</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>Index of input array to start reading from</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>Step size between elements in input array</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>Scaling factor for inverse transform</p></td></tr></tbody>",qa,Sa,Na,Ne,Ga,Ge,Ja,Je,ss="Real input radix-4 implementation",Qa,Qe,us='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Va,Ve,ns="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output array for the transformed data</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input array of real data to be transformed</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The scale factor used to normalize the inverse transform</p></td></tr></tbody>",Wa,Xa,Ya,We,Za,Xe,to,Ye,ms="Performs a single real input radix-2 transformation on the provided data",eo,Ze,fs='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',lo,tl,ps="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The output offset</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The input offset</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step</p></td></tr></tbody>",ro,ao,oo,el,io,ll,so,dl,hs=`Computes a single real-valued transform using radix-4 algorithm.
This method is only called for len=8.`,uo,rl,cs='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',no,al,Ts="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset into the output array.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset into the input array.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for the input array.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The value of inverse.</p></td></tr></tbody>",mo,fo,po,ol,ho,il,co,sl,ys=`NP2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are not a power of two in length. In such cases, the chirp-z transform is used.`,To,ul,vs='For more information, see: <a href="https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156" rel="nofollow">https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156</a>',yo,nl,_s='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',vo,_o,Fo,ml,bo,fl,xo,pl,Fs="Constructs a new NP2FFT object.",$o,hl,bs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>fft_length</td><td><code>number</code></td><td><p>The length of the FFT</p></td></tr></tbody>",Po,Co,Ao,cl,Ho,Tl,Lo,yl,xs='<strong>Kind</strong>: inner typedef of <a href="#module_utils/maths"><code>utils/maths</code></a>',Mo,wo,go,_l,Eo;return F=new y({props:{title:"utils/maths",local:"utilsmaths",headingTag:"h1"}}),C=new y({props:{title:"utils/maths.interpolate_data(input)",local:"utilsmathsinterpolatedatainput",headingTag:"h2"}}),M=new y({props:{title:"utils/maths.permute_data(array, dims, axes) ⇒ <code> * </code>",local:"utilsmathspermutedataarray-dims-axes--code--code",headingTag:"h2"}}),z=new y({props:{title:"utils/maths.softmax(arr) ⇒ <code> T </code>",local:"utilsmathssoftmaxarr--code-t-code",headingTag:"h2"}}),D=new y({props:{title:"utils/maths.log_softmax(arr) ⇒ <code> T </code>",local:"utilsmathslogsoftmaxarr--code-t-code",headingTag:"h2"}}),S=new y({props:{title:"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathsdotarr1-arr2--code-number-code",headingTag:"h2"}}),V=new y({props:{title:"utils/maths.getTopItems(items, [top_k]) ⇒ <code> * </code>",local:"utilsmathsgettopitemsitems-topk--code--code",headingTag:"h2"}}),tt=new y({props:{title:"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathscossimarr1-arr2--code-number-code",headingTag:"h2"}}),at=new y({props:{title:"utils/maths.magnitude(arr) ⇒ <code> number </code>",local:"utilsmathsmagnitudearr--code-number-code",headingTag:"h2"}}),nt=new y({props:{title:"utils/maths.min(arr) ⇒ <code> Array. < number > </code>",local:"utilsmathsminarr--code-array--number--code",headingTag:"h2"}}),Tt=new y({props:{title:"utils/maths.max(arr) ⇒ <code> * </code>",local:"utilsmathsmaxarr--code--code",headingTag:"h2"}}),xt=new y({props:{title:"utils/maths.medianFilter(data, windowSize)",local:"utilsmathsmedianfilterdata-windowsize",headingTag:"h2"}}),Ht=new y({props:{title:"utils/maths.round(num, decimals) ⇒ <code> number </code>",local:"utilsmathsroundnum-decimals--code-number-code",headingTag:"h2"}}),Et=new y({props:{title:"utils/maths.bankers_round(x) ⇒ <code> number </code>",local:"utilsmathsbankersroundx--code-number-code",headingTag:"h2"}}),Bt=new y({props:{title:"utils/maths~P2FFT",local:"utilsmathsp2fft",headingTag:"h2"}}),qt=new y({props:{title:"new P2FFT(size)",local:"new-p2fftsize",headingTag:"h3"}}),Qt=new y({props:{title:"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>",local:"p2fftcreatecomplexarray--code-float64array-code",headingTag:"h3"}}),Yt=new y({props:{title:"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>",local:"p2fftfromcomplexarraycomplex-storage--code-array--number--code",headingTag:"h3"}}),de=new y({props:{title:"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>",local:"p2ffttocomplexarrayinput-storage--code-float64array-code",headingTag:"h3"}}),se=new y({props:{title:"p2FFT.completeSpectrum(spectrum) ⇒ <code> void </code>",local:"p2fftcompletespectrumspectrum--code-void-code",headingTag:"h3"}}),pe=new y({props:{title:"p2FFT.transform(out, data) ⇒ <code> void </code>",local:"p2ffttransformout-data--code-void-code",headingTag:"h3"}}),_e=new y({props:{title:"p2FFT.realTransform(out, data)",local:"p2fftrealtransformout-data",headingTag:"h3"}}),Ce=new y({props:{title:"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>",local:"p2fftinversetransformout-data--code-void-code",headingTag:"h3"}}),ge=new y({props:{title:"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>",local:"p2ffttransform4out-data-inv--code-void-code",headingTag:"h3"}}),Ke=new y({props:{title:"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsingletransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),je=new y({props:{title:"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>",local:"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code",headingTag:"h3"}}),Ge=new y({props:{title:"p2FFT._realTransform4(out, data, inv)",local:"p2fftrealtransform4out-data-inv",headingTag:"h3"}}),Xe=new y({props:{title:"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),ll=new y({props:{title:"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)",local:"p2fftsinglerealtransform4data-out-outoff-off-step-inv",headingTag:"h3"}}),il=new y({props:{title:"utils/maths~NP2FFT",local:"utilsmathsnp2fft",headingTag:"h2"}}),fl=new y({props:{title:"new NP2FFT(fft_length)",local:"new-np2fftfftlength",headingTag:"h3"}}),Tl=new y({props:{title:"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>",local:"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code",headingTag:"h2"}}),{c(){v=o("meta"),Fl=r(),vl=o("p"),bl=r(),_=o("a"),xl=r(),m(F.$$.fragment),$l=r(),b=o("p"),b.textContent=zo,Pl=r(),x=o("p"),x.textContent=ko,Cl=r(),$=o("ul"),$.innerHTML=Ko,Al=r(),Hl=o("hr"),Ll=r(),P=o("a"),Ml=r(),m(C.$$.fragment),wl=r(),A=o("p"),A.innerHTML=Bo,gl=r(),H=o("table"),H.innerHTML=Oo,El=r(),Rl=o("hr"),zl=r(),L=o("a"),kl=r(),m(M.$$.fragment),Kl=r(),w=o("p"),w.innerHTML=Do,Bl=r(),g=o("p"),g.innerHTML=Io,Ol=r(),E=o("table"),E.innerHTML=jo,Dl=r(),Il=o("hr"),jl=r(),R=o("a"),Ul=r(),m(z.$$.fragment),ql=r(),k=o("p"),k.textContent=Uo,Sl=r(),K=o("p"),K.innerHTML=qo,Nl=r(),B=o("table"),B.innerHTML=So,Gl=r(),Jl=o("hr"),Ql=r(),O=o("a"),Vl=r(),m(D.$$.fragment),Wl=r(),I=o("p"),I.textContent=No,Xl=r(),j=o("p"),j.innerHTML=Go,Yl=r(),U=o("table"),U.innerHTML=Jo,Zl=r(),td=o("hr"),ed=r(),q=o("a"),ld=r(),m(S.$$.fragment),dd=r(),N=o("p"),N.textContent=Qo,rd=r(),G=o("p"),G.innerHTML=Vo,ad=r(),J=o("table"),J.innerHTML=Wo,od=r(),id=o("hr"),sd=r(),Q=o("a"),ud=r(),m(V.$$.fragment),nd=r(),W=o("p"),W.textContent=Xo,md=r(),X=o("p"),X.innerHTML=Yo,fd=r(),Y=o("table"),Y.innerHTML=Zo,pd=r(),hd=o("hr"),cd=r(),Z=o("a"),Td=r(),m(tt.$$.fragment),yd=r(),et=o("p"),et.textContent=ti,vd=r(),lt=o("p"),lt.innerHTML=ei,_d=r(),dt=o("table"),dt.innerHTML=li,Fd=r(),bd=o("hr"),xd=r(),rt=o("a"),$d=r(),m(at.$$.fragment),Pd=r(),ot=o("p"),ot.textContent=di,Cd=r(),it=o("p"),it.innerHTML=ri,Ad=r(),st=o("table"),st.innerHTML=ai,Hd=r(),Ld=o("hr"),Md=r(),ut=o("a"),wd=r(),m(nt.$$.fragment),gd=r(),mt=o("p"),mt.textContent=oi,Ed=r(),ft=o("p"),ft.innerHTML=ii,Rd=r(),pt=o("ul"),pt.innerHTML=si,zd=r(),ht=o("table"),ht.innerHTML=ui,kd=r(),Kd=o("hr"),Bd=r(),ct=o("a"),Od=r(),m(Tt.$$.fragment),Dd=r(),yt=o("p"),yt.textContent=ni,Id=r(),vt=o("p"),vt.innerHTML=mi,jd=r(),_t=o("ul"),_t.innerHTML=fi,Ud=r(),Ft=o("table"),Ft.innerHTML=pi,qd=r(),Sd=o("hr"),Nd=r(),bt=o("a"),Gd=r(),m(xt.$$.fragment),Jd=r(),$t=o("p"),$t.textContent=hi,Qd=r(),Pt=o("p"),Pt.innerHTML=ci,Vd=r(),Ct=o("table"),Ct.innerHTML=Ti,Wd=r(),Xd=o("hr"),Yd=r(),At=o("a"),Zd=r(),m(Ht.$$.fragment),tr=r(),Lt=o("p"),Lt.textContent=yi,er=r(),Mt=o("p"),Mt.innerHTML=vi,lr=r(),wt=o("table"),wt.innerHTML=_i,dr=r(),rr=o("hr"),ar=r(),gt=o("a"),or=r(),m(Et.$$.fragment),ir=r(),Rt=o("p"),Rt.textContent=Fi,sr=r(),zt=o("p"),zt.innerHTML=bi,ur=r(),kt=o("table"),kt.innerHTML=xi,nr=r(),mr=o("hr"),fr=r(),Kt=o("a"),pr=r(),m(Bt.$$.fragment),hr=r(),Ot=o("p"),Ot.textContent=$i,cr=r(),Dt=o("p"),Dt.innerHTML=Pi,Tr=r(),It=o("p"),It.innerHTML=Ci,yr=r(),jt=o("ul"),jt.innerHTML=Ai,vr=r(),_r=o("hr"),Fr=r(),Ut=o("a"),br=r(),m(qt.$$.fragment),xr=r(),St=o("p"),St.innerHTML=Hi,$r=r(),Nt=o("ul"),Nt.innerHTML=Li,Pr=r(),Gt=o("table"),Gt.innerHTML=Mi,Cr=r(),Ar=o("hr"),Hr=r(),Jt=o("a"),Lr=r(),m(Qt.$$.fragment),Mr=r(),Vt=o("p"),Vt.innerHTML=wi,wr=r(),Wt=o("p"),Wt.innerHTML=gi,gr=r(),Er=o("hr"),Rr=r(),Xt=o("a"),zr=r(),m(Yt.$$.fragment),kr=r(),Zt=o("p"),Zt.textContent=Ei,Kr=r(),te=o("p"),te.innerHTML=Ri,Br=r(),ee=o("table"),ee.innerHTML=zi,Or=r(),Dr=o("hr"),Ir=r(),le=o("a"),jr=r(),m(de.$$.fragment),Ur=r(),re=o("p"),re.textContent=ki,qr=r(),ae=o("p"),ae.innerHTML=Ki,Sr=r(),oe=o("table"),oe.innerHTML=Bi,Nr=r(),Gr=o("hr"),Jr=r(),ie=o("a"),Qr=r(),m(se.$$.fragment),Vr=r(),ue=o("p"),ue.textContent=Oi,Wr=r(),ne=o("p"),ne.innerHTML=Di,Xr=r(),me=o("table"),me.innerHTML=Ii,Yr=r(),Zr=o("hr"),ta=r(),fe=o("a"),ea=r(),m(pe.$$.fragment),la=r(),he=o("p"),he.textContent=ji,da=r(),ce=o("p"),ce.innerHTML=Ui,ra=r(),Te=o("ul"),Te.innerHTML=qi,aa=r(),ye=o("table"),ye.innerHTML=Si,oa=r(),ia=o("hr"),sa=r(),ve=o("a"),ua=r(),m(_e.$$.fragment),na=r(),Fe=o("p"),Fe.textContent=Ni,ma=r(),be=o("p"),be.innerHTML=Gi,fa=r(),xe=o("ul"),xe.innerHTML=Ji,pa=r(),$e=o("table"),$e.innerHTML=Qi,ha=r(),ca=o("hr"),Ta=r(),Pe=o("a"),ya=r(),m(Ce.$$.fragment),va=r(),Ae=o("p"),Ae.innerHTML=Vi,_a=r(),He=o("p"),He.innerHTML=Wi,Fa=r(),Le=o("ul"),Le.innerHTML=Xi,ba=r(),Me=o("table"),Me.innerHTML=Yi,xa=r(),$a=o("hr"),Pa=r(),we=o("a"),Ca=r(),m(ge.$$.fragment),Aa=r(),Ee=o("p"),Ee.textContent=Zi,Ha=r(),Re=o("p"),Re.innerHTML=ts,La=r(),ze=o("table"),ze.innerHTML=es,Ma=r(),wa=o("hr"),ga=r(),ke=o("a"),Ea=r(),m(Ke.$$.fragment),Ra=r(),Be=o("p"),Be.textContent=ls,za=r(),Oe=o("p"),Oe.innerHTML=ds,ka=r(),De=o("table"),De.innerHTML=rs,Ka=r(),Ba=o("hr"),Oa=r(),Ie=o("a"),Da=r(),m(je.$$.fragment),Ia=r(),Ue=o("p"),Ue.textContent=as,ja=r(),qe=o("p"),qe.innerHTML=os,Ua=r(),Se=o("table"),Se.innerHTML=is,qa=r(),Sa=o("hr"),Na=r(),Ne=o("a"),Ga=r(),m(Ge.$$.fragment),Ja=r(),Je=o("p"),Je.textContent=ss,Qa=r(),Qe=o("p"),Qe.innerHTML=us,Va=r(),Ve=o("table"),Ve.innerHTML=ns,Wa=r(),Xa=o("hr"),Ya=r(),We=o("a"),Za=r(),m(Xe.$$.fragment),to=r(),Ye=o("p"),Ye.textContent=ms,eo=r(),Ze=o("p"),Ze.innerHTML=fs,lo=r(),tl=o("table"),tl.innerHTML=ps,ro=r(),ao=o("hr"),oo=r(),el=o("a"),io=r(),m(ll.$$.fragment),so=r(),dl=o("p"),dl.textContent=hs,uo=r(),rl=o("p"),rl.innerHTML=cs,no=r(),al=o("table"),al.innerHTML=Ts,mo=r(),fo=o("hr"),po=r(),ol=o("a"),ho=r(),m(il.$$.fragment),co=r(),sl=o("p"),sl.textContent=ys,To=r(),ul=o("p"),ul.innerHTML=vs,yo=r(),nl=o("p"),nl.innerHTML=_s,vo=r(),_o=o("hr"),Fo=r(),ml=o("a"),bo=r(),m(fl.$$.fragment),xo=r(),pl=o("p"),pl.textContent=Fs,$o=r(),hl=o("table"),hl.innerHTML=bs,Po=r(),Co=o("hr"),Ao=r(),cl=o("a"),Ho=r(),m(Tl.$$.fragment),Lo=r(),yl=o("p"),yl.innerHTML=xs,Mo=r(),wo=o("hr"),go=r(),_l=o("p"),this.h()},l(t){const l=Ls("svelte-u9bgzb",document.head);v=i(l,"META",{name:!0,content:!0}),l.forEach(e),Fl=a(t),vl=i(t,"P",{}),n(vl).forEach(e),bl=a(t),_=i(t,"A",{id:!0,class:!0}),n(_).forEach(e),xl=a(t),f(F.$$.fragment,t),$l=a(t),b=i(t,"P",{"data-svelte-h":!0}),s(b)!=="svelte-1d3zgi"&&(b.textContent=zo),Pl=a(t),x=i(t,"P",{"data-svelte-h":!0}),s(x)!=="svelte-il3kl8"&&(x.textContent=ko),Cl=a(t),$=i(t,"UL",{"data-svelte-h":!0}),s($)!=="svelte-1av3l9x"&&($.innerHTML=Ko),Al=a(t),Hl=i(t,"HR",{}),Ll=a(t),P=i(t,"A",{id:!0,class:!0}),n(P).forEach(e),Ml=a(t),f(C.$$.fragment,t),wl=a(t),A=i(t,"P",{"data-svelte-h":!0}),s(A)!=="svelte-z8esp"&&(A.innerHTML=Bo),gl=a(t),H=i(t,"TABLE",{"data-svelte-h":!0}),s(H)!=="svelte-13raiaj"&&(H.innerHTML=Oo),El=a(t),Rl=i(t,"HR",{}),zl=a(t),L=i(t,"A",{id:!0,class:!0}),n(L).forEach(e),kl=a(t),f(M.$$.fragment,t),Kl=a(t),w=i(t,"P",{"data-svelte-h":!0}),s(w)!=="svelte-1b1asvx"&&(w.innerHTML=Do),Bl=a(t),g=i(t,"P",{"data-svelte-h":!0}),s(g)!=="svelte-pth1sg"&&(g.innerHTML=Io),Ol=a(t),E=i(t,"TABLE",{"data-svelte-h":!0}),s(E)!=="svelte-18fxup5"&&(E.innerHTML=jo),Dl=a(t),Il=i(t,"HR",{}),jl=a(t),R=i(t,"A",{id:!0,class:!0}),n(R).forEach(e),Ul=a(t),f(z.$$.fragment,t),ql=a(t),k=i(t,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1liv70i"&&(k.textContent=Uo),Sl=a(t),K=i(t,"P",{"data-svelte-h":!0}),s(K)!=="svelte-xvvopf"&&(K.innerHTML=qo),Nl=a(t),B=i(t,"TABLE",{"data-svelte-h":!0}),s(B)!=="svelte-adoxzf"&&(B.innerHTML=So),Gl=a(t),Jl=i(t,"HR",{}),Ql=a(t),O=i(t,"A",{id:!0,class:!0}),n(O).forEach(e),Vl=a(t),f(D.$$.fragment,t),Wl=a(t),I=i(t,"P",{"data-svelte-h":!0}),s(I)!=="svelte-5479oq"&&(I.textContent=No),Xl=a(t),j=i(t,"P",{"data-svelte-h":!0}),s(j)!=="svelte-m9boyl"&&(j.innerHTML=Go),Yl=a(t),U=i(t,"TABLE",{"data-svelte-h":!0}),s(U)!=="svelte-5wetzk"&&(U.innerHTML=Jo),Zl=a(t),td=i(t,"HR",{}),ed=a(t),q=i(t,"A",{id:!0,class:!0}),n(q).forEach(e),ld=a(t),f(S.$$.fragment,t),dd=a(t),N=i(t,"P",{"data-svelte-h":!0}),s(N)!=="svelte-1kaf4lx"&&(N.textContent=Qo),rd=a(t),G=i(t,"P",{"data-svelte-h":!0}),s(G)!=="svelte-gudhvq"&&(G.innerHTML=Vo),ad=a(t),J=i(t,"TABLE",{"data-svelte-h":!0}),s(J)!=="svelte-nyqk4k"&&(J.innerHTML=Wo),od=a(t),id=i(t,"HR",{}),sd=a(t),Q=i(t,"A",{id:!0,class:!0}),n(Q).forEach(e),ud=a(t),f(V.$$.fragment,t),nd=a(t),W=i(t,"P",{"data-svelte-h":!0}),s(W)!=="svelte-s7mgi8"&&(W.textContent=Xo),md=a(t),X=i(t,"P",{"data-svelte-h":!0}),s(X)!=="svelte-5oll1y"&&(X.innerHTML=Yo),fd=a(t),Y=i(t,"TABLE",{"data-svelte-h":!0}),s(Y)!=="svelte-n1lt7"&&(Y.innerHTML=Zo),pd=a(t),hd=i(t,"HR",{}),cd=a(t),Z=i(t,"A",{id:!0,class:!0}),n(Z).forEach(e),Td=a(t),f(tt.$$.fragment,t),yd=a(t),et=i(t,"P",{"data-svelte-h":!0}),s(et)!=="svelte-6quqqj"&&(et.textContent=ti),vd=a(t),lt=i(t,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-1y45k06"&&(lt.innerHTML=ei),_d=a(t),dt=i(t,"TABLE",{"data-svelte-h":!0}),s(dt)!=="svelte-nyqk4k"&&(dt.innerHTML=li),Fd=a(t),bd=i(t,"HR",{}),xd=a(t),rt=i(t,"A",{id:!0,class:!0}),n(rt).forEach(e),$d=a(t),f(at.$$.fragment,t),Pd=a(t),ot=i(t,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-132v21g"&&(ot.textContent=di),Cd=a(t),it=i(t,"P",{"data-svelte-h":!0}),s(it)!=="svelte-odriss"&&(it.innerHTML=ri),Ad=a(t),st=i(t,"TABLE",{"data-svelte-h":!0}),s(st)!=="svelte-nbo00i"&&(st.innerHTML=ai),Hd=a(t),Ld=i(t,"HR",{}),Md=a(t),ut=i(t,"A",{id:!0,class:!0}),n(ut).forEach(e),wd=a(t),f(nt.$$.fragment,t),gd=a(t),mt=i(t,"P",{"data-svelte-h":!0}),s(mt)!=="svelte-67h0u1"&&(mt.textContent=oi),Ed=a(t),ft=i(t,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-cs0f6n"&&(ft.innerHTML=ii),Rd=a(t),pt=i(t,"UL",{"data-svelte-h":!0}),s(pt)!=="svelte-jusv8t"&&(pt.innerHTML=si),zd=a(t),ht=i(t,"TABLE",{"data-svelte-h":!0}),s(ht)!=="svelte-mtkj0x"&&(ht.innerHTML=ui),kd=a(t),Kd=i(t,"HR",{}),Bd=a(t),ct=i(t,"A",{id:!0,class:!0}),n(ct).forEach(e),Od=a(t),f(Tt.$$.fragment,t),Dd=a(t),yt=i(t,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-9vv4b"&&(yt.textContent=ni),Id=a(t),vt=i(t,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-1ixuuwb"&&(vt.innerHTML=mi),jd=a(t),_t=i(t,"UL",{"data-svelte-h":!0}),s(_t)!=="svelte-jusv8t"&&(_t.innerHTML=fi),Ud=a(t),Ft=i(t,"TABLE",{"data-svelte-h":!0}),s(Ft)!=="svelte-oriydz"&&(Ft.innerHTML=pi),qd=a(t),Sd=i(t,"HR",{}),Nd=a(t),bt=i(t,"A",{id:!0,class:!0}),n(bt).forEach(e),Gd=a(t),f(xt.$$.fragment,t),Jd=a(t),$t=i(t,"P",{"data-svelte-h":!0}),s($t)!=="svelte-xb1vdd"&&($t.textContent=hi),Qd=a(t),Pt=i(t,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-z8esp"&&(Pt.innerHTML=ci),Vd=a(t),Ct=i(t,"TABLE",{"data-svelte-h":!0}),s(Ct)!=="svelte-pk7ooi"&&(Ct.innerHTML=Ti),Wd=a(t),Xd=i(t,"HR",{}),Yd=a(t),At=i(t,"A",{id:!0,class:!0}),n(At).forEach(e),Zd=a(t),f(Ht.$$.fragment,t),tr=a(t),Lt=i(t,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-11aka64"&&(Lt.textContent=yi),er=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-jttckh"&&(Mt.innerHTML=vi),lr=a(t),wt=i(t,"TABLE",{"data-svelte-h":!0}),s(wt)!=="svelte-c6gnt1"&&(wt.innerHTML=_i),dr=a(t),rr=i(t,"HR",{}),ar=a(t),gt=i(t,"A",{id:!0,class:!0}),n(gt).forEach(e),or=a(t),f(Et.$$.fragment,t),ir=a(t),Rt=i(t,"P",{"data-svelte-h":!0}),s(Rt)!=="svelte-1xjiy33"&&(Rt.textContent=Fi),sr=a(t),zt=i(t,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-jttckh"&&(zt.innerHTML=bi),ur=a(t),kt=i(t,"TABLE",{"data-svelte-h":!0}),s(kt)!=="svelte-1uj9e15"&&(kt.innerHTML=xi),nr=a(t),mr=i(t,"HR",{}),fr=a(t),Kt=i(t,"A",{id:!0,class:!0}),n(Kt).forEach(e),pr=a(t),f(Bt.$$.fragment,t),hr=a(t),Ot=i(t,"P",{"data-svelte-h":!0}),s(Ot)!=="svelte-16m1u76"&&(Ot.textContent=$i),cr=a(t),Dt=i(t,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-698ey0"&&(Dt.innerHTML=Pi),Tr=a(t),It=i(t,"P",{"data-svelte-h":!0}),s(It)!=="svelte-tjke50"&&(It.innerHTML=Ci),yr=a(t),jt=i(t,"UL",{"data-svelte-h":!0}),s(jt)!=="svelte-1iua3xn"&&(jt.innerHTML=Ai),vr=a(t),_r=i(t,"HR",{}),Fr=a(t),Ut=i(t,"A",{id:!0,class:!0}),n(Ut).forEach(e),br=a(t),f(qt.$$.fragment,t),xr=a(t),St=i(t,"P",{"data-svelte-h":!0}),s(St)!=="svelte-1fz4yns"&&(St.innerHTML=Hi),$r=a(t),Nt=i(t,"UL",{"data-svelte-h":!0}),s(Nt)!=="svelte-ph0ovr"&&(Nt.innerHTML=Li),Pr=a(t),Gt=i(t,"TABLE",{"data-svelte-h":!0}),s(Gt)!=="svelte-a5vdxc"&&(Gt.innerHTML=Mi),Cr=a(t),Ar=i(t,"HR",{}),Hr=a(t),Jt=i(t,"A",{id:!0,class:!0}),n(Jt).forEach(e),Lr=a(t),f(Qt.$$.fragment,t),Mr=a(t),Vt=i(t,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-1rrw4ya"&&(Vt.innerHTML=wi),wr=a(t),Wt=i(t,"P",{"data-svelte-h":!0}),s(Wt)!=="svelte-1gdnoew"&&(Wt.innerHTML=gi),gr=a(t),Er=i(t,"HR",{}),Rr=a(t),Xt=i(t,"A",{id:!0,class:!0}),n(Xt).forEach(e),zr=a(t),f(Yt.$$.fragment,t),kr=a(t),Zt=i(t,"P",{"data-svelte-h":!0}),s(Zt)!=="svelte-1693r4v"&&(Zt.textContent=Ei),Kr=a(t),te=i(t,"P",{"data-svelte-h":!0}),s(te)!=="svelte-33y4ax"&&(te.innerHTML=Ri),Br=a(t),ee=i(t,"TABLE",{"data-svelte-h":!0}),s(ee)!=="svelte-1td0xj2"&&(ee.innerHTML=zi),Or=a(t),Dr=i(t,"HR",{}),Ir=a(t),le=i(t,"A",{id:!0,class:!0}),n(le).forEach(e),jr=a(t),f(de.$$.fragment,t),Ur=a(t),re=i(t,"P",{"data-svelte-h":!0}),s(re)!=="svelte-rsnsrd"&&(re.textContent=ki),qr=a(t),ae=i(t,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-1xayhm7"&&(ae.innerHTML=Ki),Sr=a(t),oe=i(t,"TABLE",{"data-svelte-h":!0}),s(oe)!=="svelte-1up5toh"&&(oe.innerHTML=Bi),Nr=a(t),Gr=i(t,"HR",{}),Jr=a(t),ie=i(t,"A",{id:!0,class:!0}),n(ie).forEach(e),Qr=a(t),f(se.$$.fragment,t),Vr=a(t),ue=i(t,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-id49q5"&&(ue.textContent=Oi),Wr=a(t),ne=i(t,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-1dkdszr"&&(ne.innerHTML=Di),Xr=a(t),me=i(t,"TABLE",{"data-svelte-h":!0}),s(me)!=="svelte-15tum1z"&&(me.innerHTML=Ii),Yr=a(t),Zr=i(t,"HR",{}),ta=a(t),fe=i(t,"A",{id:!0,class:!0}),n(fe).forEach(e),ea=a(t),f(pe.$$.fragment,t),la=a(t),he=i(t,"P",{"data-svelte-h":!0}),s(he)!=="svelte-846pp1"&&(he.textContent=ji),da=a(t),ce=i(t,"P",{"data-svelte-h":!0}),s(ce)!=="svelte-1t2xajz"&&(ce.innerHTML=Ui),ra=a(t),Te=i(t,"UL",{"data-svelte-h":!0}),s(Te)!=="svelte-173tqd8"&&(Te.innerHTML=qi),aa=a(t),ye=i(t,"TABLE",{"data-svelte-h":!0}),s(ye)!=="svelte-1buvx7j"&&(ye.innerHTML=Si),oa=a(t),ia=i(t,"HR",{}),sa=a(t),ve=i(t,"A",{id:!0,class:!0}),n(ve).forEach(e),ua=a(t),f(_e.$$.fragment,t),na=a(t),Fe=i(t,"P",{"data-svelte-h":!0}),s(Fe)!=="svelte-ozshoc"&&(Fe.textContent=Ni),ma=a(t),be=i(t,"P",{"data-svelte-h":!0}),s(be)!=="svelte-1t2xajz"&&(be.innerHTML=Gi),fa=a(t),xe=i(t,"UL",{"data-svelte-h":!0}),s(xe)!=="svelte-1ap3720"&&(xe.innerHTML=Ji),pa=a(t),$e=i(t,"TABLE",{"data-svelte-h":!0}),s($e)!=="svelte-lghmn6"&&($e.innerHTML=Qi),ha=a(t),ca=i(t,"HR",{}),Ta=a(t),Pe=i(t,"A",{id:!0,class:!0}),n(Pe).forEach(e),ya=a(t),f(Ce.$$.fragment,t),va=a(t),Ae=i(t,"P",{"data-svelte-h":!0}),s(Ae)!=="svelte-ijignt"&&(Ae.innerHTML=Vi),_a=a(t),He=i(t,"P",{"data-svelte-h":!0}),s(He)!=="svelte-1t2xajz"&&(He.innerHTML=Wi),Fa=a(t),Le=i(t,"UL",{"data-svelte-h":!0}),s(Le)!=="svelte-1bp21xg"&&(Le.innerHTML=Xi),ba=a(t),Me=i(t,"TABLE",{"data-svelte-h":!0}),s(Me)!=="svelte-edt5vq"&&(Me.innerHTML=Yi),xa=a(t),$a=i(t,"HR",{}),Pa=a(t),we=i(t,"A",{id:!0,class:!0}),n(we).forEach(e),Ca=a(t),f(ge.$$.fragment,t),Aa=a(t),Ee=i(t,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-3r4wxn"&&(Ee.textContent=Zi),Ha=a(t),Re=i(t,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-1dkdszr"&&(Re.innerHTML=ts),La=a(t),ze=i(t,"TABLE",{"data-svelte-h":!0}),s(ze)!=="svelte-15z8087"&&(ze.innerHTML=es),Ma=a(t),wa=i(t,"HR",{}),ga=a(t),ke=i(t,"A",{id:!0,class:!0}),n(ke).forEach(e),Ea=a(t),f(Ke.$$.fragment,t),Ra=a(t),Be=i(t,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-1jz5wqp"&&(Be.textContent=ls),za=a(t),Oe=i(t,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-1dkdszr"&&(Oe.innerHTML=ds),ka=a(t),De=i(t,"TABLE",{"data-svelte-h":!0}),s(De)!=="svelte-fx5ob"&&(De.innerHTML=rs),Ka=a(t),Ba=i(t,"HR",{}),Oa=a(t),Ie=i(t,"A",{id:!0,class:!0}),n(Ie).forEach(e),Da=a(t),f(je.$$.fragment,t),Ia=a(t),Ue=i(t,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-1baynqa"&&(Ue.textContent=as),ja=a(t),qe=i(t,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-1dkdszr"&&(qe.innerHTML=os),Ua=a(t),Se=i(t,"TABLE",{"data-svelte-h":!0}),s(Se)!=="svelte-szv30n"&&(Se.innerHTML=is),qa=a(t),Sa=i(t,"HR",{}),Na=a(t),Ne=i(t,"A",{id:!0,class:!0}),n(Ne).forEach(e),Ga=a(t),f(Ge.$$.fragment,t),Ja=a(t),Je=i(t,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-1gll44b"&&(Je.textContent=ss),Qa=a(t),Qe=i(t,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-1dkdszr"&&(Qe.innerHTML=us),Va=a(t),Ve=i(t,"TABLE",{"data-svelte-h":!0}),s(Ve)!=="svelte-159qhrx"&&(Ve.innerHTML=ns),Wa=a(t),Xa=i(t,"HR",{}),Ya=a(t),We=i(t,"A",{id:!0,class:!0}),n(We).forEach(e),Za=a(t),f(Xe.$$.fragment,t),to=a(t),Ye=i(t,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-1upf1p8"&&(Ye.textContent=ms),eo=a(t),Ze=i(t,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-1dkdszr"&&(Ze.innerHTML=fs),lo=a(t),tl=i(t,"TABLE",{"data-svelte-h":!0}),s(tl)!=="svelte-18nciet"&&(tl.innerHTML=ps),ro=a(t),ao=i(t,"HR",{}),oo=a(t),el=i(t,"A",{id:!0,class:!0}),n(el).forEach(e),io=a(t),f(ll.$$.fragment,t),so=a(t),dl=i(t,"P",{"data-svelte-h":!0}),s(dl)!=="svelte-8fqhv2"&&(dl.textContent=hs),uo=a(t),rl=i(t,"P",{"data-svelte-h":!0}),s(rl)!=="svelte-1dkdszr"&&(rl.innerHTML=cs),no=a(t),al=i(t,"TABLE",{"data-svelte-h":!0}),s(al)!=="svelte-pf887e"&&(al.innerHTML=Ts),mo=a(t),fo=i(t,"HR",{}),po=a(t),ol=i(t,"A",{id:!0,class:!0}),n(ol).forEach(e),ho=a(t),f(il.$$.fragment,t),co=a(t),sl=i(t,"P",{"data-svelte-h":!0}),s(sl)!=="svelte-yw51a0"&&(sl.textContent=ys),To=a(t),ul=i(t,"P",{"data-svelte-h":!0}),s(ul)!=="svelte-1gw6hta"&&(ul.innerHTML=vs),yo=a(t),nl=i(t,"P",{"data-svelte-h":!0}),s(nl)!=="svelte-tjke50"&&(nl.innerHTML=_s),vo=a(t),_o=i(t,"HR",{}),Fo=a(t),ml=i(t,"A",{id:!0,class:!0}),n(ml).forEach(e),bo=a(t),f(fl.$$.fragment,t),xo=a(t),pl=i(t,"P",{"data-svelte-h":!0}),s(pl)!=="svelte-lvoqsi"&&(pl.textContent=Fs),$o=a(t),hl=i(t,"TABLE",{"data-svelte-h":!0}),s(hl)!=="svelte-1gtay08"&&(hl.innerHTML=bs),Po=a(t),Co=i(t,"HR",{}),Ao=a(t),cl=i(t,"A",{id:!0,class:!0}),n(cl).forEach(e),Ho=a(t),f(Tl.$$.fragment,t),Lo=a(t),yl=i(t,"P",{"data-svelte-h":!0}),s(yl)!=="svelte-9rr3v5"&&(yl.innerHTML=xs),Mo=a(t),wo=i(t,"HR",{}),go=a(t),_l=i(t,"P",{}),n(_l).forEach(e),this.h()},h(){u(v,"name","hf:doc:metadata"),u(v,"content",gs),u(_,"id","module_utils/maths"),u(_,"class","group"),u(P,"id","module_utils/maths.interpolate_data"),u(P,"class","group"),u(L,"id","module_utils/maths.permute_data"),u(L,"class","group"),u(R,"id","module_utils/maths.softmax"),u(R,"class","group"),u(O,"id","module_utils/maths.log_softmax"),u(O,"class","group"),u(q,"id","module_utils/maths.dot"),u(q,"class","group"),u(Q,"id","module_utils/maths.getTopItems"),u(Q,"class","group"),u(Z,"id","module_utils/maths.cos_sim"),u(Z,"class","group"),u(rt,"id","module_utils/maths.magnitude"),u(rt,"class","group"),u(ut,"id","module_utils/maths.min"),u(ut,"class","group"),u(ct,"id","module_utils/maths.max"),u(ct,"class","group"),u(bt,"id","module_utils/maths.medianFilter"),u(bt,"class","group"),u(At,"id","module_utils/maths.round"),u(At,"class","group"),u(gt,"id","module_utils/maths.bankers_round"),u(gt,"class","group"),u(Kt,"id","module_utils/maths..P2FFT"),u(Kt,"class","group"),u(Ut,"id","new_module_utils/maths..P2FFT_new"),u(Ut,"class","group"),u(Jt,"id","module_utils/maths..P2FFT+createComplexArray"),u(Jt,"class","group"),u(Xt,"id","module_utils/maths..P2FFT+fromComplexArray"),u(Xt,"class","group"),u(le,"id","module_utils/maths..P2FFT+toComplexArray"),u(le,"class","group"),u(ie,"id","module_utils/maths..P2FFT+completeSpectrum"),u(ie,"class","group"),u(fe,"id","module_utils/maths..P2FFT+transform"),u(fe,"class","group"),u(ve,"id","module_utils/maths..P2FFT+realTransform"),u(ve,"class","group"),u(Pe,"id","module_utils/maths..P2FFT+inverseTransform"),u(Pe,"class","group"),u(we,"id","module_utils/maths..P2FFT+_transform4"),u(we,"class","group"),u(ke,"id","module_utils/maths..P2FFT+_singleTransform2"),u(ke,"class","group"),u(Ie,"id","module_utils/maths..P2FFT+_singleTransform4"),u(Ie,"class","group"),u(Ne,"id","module_utils/maths..P2FFT+_realTransform4"),u(Ne,"class","group"),u(We,"id","module_utils/maths..P2FFT+_singleRealTransform2"),u(We,"class","group"),u(el,"id","module_utils/maths..P2FFT+_singleRealTransform4"),u(el,"class","group"),u(ol,"id","module_utils/maths..NP2FFT"),u(ol,"class","group"),u(ml,"id","new_module_utils/maths..NP2FFT_new"),u(ml,"class","group"),u(cl,"id","module_utils/maths..AnyTypedArray"),u(cl,"class","group")},m(t,l){Ms(document.head,v),d(t,Fl,l),d(t,vl,l),d(t,bl,l),d(t,_,l),d(t,xl,l),p(F,t,l),d(t,$l,l),d(t,b,l),d(t,Pl,l),d(t,x,l),d(t,Cl,l),d(t,$,l),d(t,Al,l),d(t,Hl,l),d(t,Ll,l),d(t,P,l),d(t,Ml,l),p(C,t,l),d(t,wl,l),d(t,A,l),d(t,gl,l),d(t,H,l),d(t,El,l),d(t,Rl,l),d(t,zl,l),d(t,L,l),d(t,kl,l),p(M,t,l),d(t,Kl,l),d(t,w,l),d(t,Bl,l),d(t,g,l),d(t,Ol,l),d(t,E,l),d(t,Dl,l),d(t,Il,l),d(t,jl,l),d(t,R,l),d(t,Ul,l),p(z,t,l),d(t,ql,l),d(t,k,l),d(t,Sl,l),d(t,K,l),d(t,Nl,l),d(t,B,l),d(t,Gl,l),d(t,Jl,l),d(t,Ql,l),d(t,O,l),d(t,Vl,l),p(D,t,l),d(t,Wl,l),d(t,I,l),d(t,Xl,l),d(t,j,l),d(t,Yl,l),d(t,U,l),d(t,Zl,l),d(t,td,l),d(t,ed,l),d(t,q,l),d(t,ld,l),p(S,t,l),d(t,dd,l),d(t,N,l),d(t,rd,l),d(t,G,l),d(t,ad,l),d(t,J,l),d(t,od,l),d(t,id,l),d(t,sd,l),d(t,Q,l),d(t,ud,l),p(V,t,l),d(t,nd,l),d(t,W,l),d(t,md,l),d(t,X,l),d(t,fd,l),d(t,Y,l),d(t,pd,l),d(t,hd,l),d(t,cd,l),d(t,Z,l),d(t,Td,l),p(tt,t,l),d(t,yd,l),d(t,et,l),d(t,vd,l),d(t,lt,l),d(t,_d,l),d(t,dt,l),d(t,Fd,l),d(t,bd,l),d(t,xd,l),d(t,rt,l),d(t,$d,l),p(at,t,l),d(t,Pd,l),d(t,ot,l),d(t,Cd,l),d(t,it,l),d(t,Ad,l),d(t,st,l),d(t,Hd,l),d(t,Ld,l),d(t,Md,l),d(t,ut,l),d(t,wd,l),p(nt,t,l),d(t,gd,l),d(t,mt,l),d(t,Ed,l),d(t,ft,l),d(t,Rd,l),d(t,pt,l),d(t,zd,l),d(t,ht,l),d(t,kd,l),d(t,Kd,l),d(t,Bd,l),d(t,ct,l),d(t,Od,l),p(Tt,t,l),d(t,Dd,l),d(t,yt,l),d(t,Id,l),d(t,vt,l),d(t,jd,l),d(t,_t,l),d(t,Ud,l),d(t,Ft,l),d(t,qd,l),d(t,Sd,l),d(t,Nd,l),d(t,bt,l),d(t,Gd,l),p(xt,t,l),d(t,Jd,l),d(t,$t,l),d(t,Qd,l),d(t,Pt,l),d(t,Vd,l),d(t,Ct,l),d(t,Wd,l),d(t,Xd,l),d(t,Yd,l),d(t,At,l),d(t,Zd,l),p(Ht,t,l),d(t,tr,l),d(t,Lt,l),d(t,er,l),d(t,Mt,l),d(t,lr,l),d(t,wt,l),d(t,dr,l),d(t,rr,l),d(t,ar,l),d(t,gt,l),d(t,or,l),p(Et,t,l),d(t,ir,l),d(t,Rt,l),d(t,sr,l),d(t,zt,l),d(t,ur,l),d(t,kt,l),d(t,nr,l),d(t,mr,l),d(t,fr,l),d(t,Kt,l),d(t,pr,l),p(Bt,t,l),d(t,hr,l),d(t,Ot,l),d(t,cr,l),d(t,Dt,l),d(t,Tr,l),d(t,It,l),d(t,yr,l),d(t,jt,l),d(t,vr,l),d(t,_r,l),d(t,Fr,l),d(t,Ut,l),d(t,br,l),p(qt,t,l),d(t,xr,l),d(t,St,l),d(t,$r,l),d(t,Nt,l),d(t,Pr,l),d(t,Gt,l),d(t,Cr,l),d(t,Ar,l),d(t,Hr,l),d(t,Jt,l),d(t,Lr,l),p(Qt,t,l),d(t,Mr,l),d(t,Vt,l),d(t,wr,l),d(t,Wt,l),d(t,gr,l),d(t,Er,l),d(t,Rr,l),d(t,Xt,l),d(t,zr,l),p(Yt,t,l),d(t,kr,l),d(t,Zt,l),d(t,Kr,l),d(t,te,l),d(t,Br,l),d(t,ee,l),d(t,Or,l),d(t,Dr,l),d(t,Ir,l),d(t,le,l),d(t,jr,l),p(de,t,l),d(t,Ur,l),d(t,re,l),d(t,qr,l),d(t,ae,l),d(t,Sr,l),d(t,oe,l),d(t,Nr,l),d(t,Gr,l),d(t,Jr,l),d(t,ie,l),d(t,Qr,l),p(se,t,l),d(t,Vr,l),d(t,ue,l),d(t,Wr,l),d(t,ne,l),d(t,Xr,l),d(t,me,l),d(t,Yr,l),d(t,Zr,l),d(t,ta,l),d(t,fe,l),d(t,ea,l),p(pe,t,l),d(t,la,l),d(t,he,l),d(t,da,l),d(t,ce,l),d(t,ra,l),d(t,Te,l),d(t,aa,l),d(t,ye,l),d(t,oa,l),d(t,ia,l),d(t,sa,l),d(t,ve,l),d(t,ua,l),p(_e,t,l),d(t,na,l),d(t,Fe,l),d(t,ma,l),d(t,be,l),d(t,fa,l),d(t,xe,l),d(t,pa,l),d(t,$e,l),d(t,ha,l),d(t,ca,l),d(t,Ta,l),d(t,Pe,l),d(t,ya,l),p(Ce,t,l),d(t,va,l),d(t,Ae,l),d(t,_a,l),d(t,He,l),d(t,Fa,l),d(t,Le,l),d(t,ba,l),d(t,Me,l),d(t,xa,l),d(t,$a,l),d(t,Pa,l),d(t,we,l),d(t,Ca,l),p(ge,t,l),d(t,Aa,l),d(t,Ee,l),d(t,Ha,l),d(t,Re,l),d(t,La,l),d(t,ze,l),d(t,Ma,l),d(t,wa,l),d(t,ga,l),d(t,ke,l),d(t,Ea,l),p(Ke,t,l),d(t,Ra,l),d(t,Be,l),d(t,za,l),d(t,Oe,l),d(t,ka,l),d(t,De,l),d(t,Ka,l),d(t,Ba,l),d(t,Oa,l),d(t,Ie,l),d(t,Da,l),p(je,t,l),d(t,Ia,l),d(t,Ue,l),d(t,ja,l),d(t,qe,l),d(t,Ua,l),d(t,Se,l),d(t,qa,l),d(t,Sa,l),d(t,Na,l),d(t,Ne,l),d(t,Ga,l),p(Ge,t,l),d(t,Ja,l),d(t,Je,l),d(t,Qa,l),d(t,Qe,l),d(t,Va,l),d(t,Ve,l),d(t,Wa,l),d(t,Xa,l),d(t,Ya,l),d(t,We,l),d(t,Za,l),p(Xe,t,l),d(t,to,l),d(t,Ye,l),d(t,eo,l),d(t,Ze,l),d(t,lo,l),d(t,tl,l),d(t,ro,l),d(t,ao,l),d(t,oo,l),d(t,el,l),d(t,io,l),p(ll,t,l),d(t,so,l),d(t,dl,l),d(t,uo,l),d(t,rl,l),d(t,no,l),d(t,al,l),d(t,mo,l),d(t,fo,l),d(t,po,l),d(t,ol,l),d(t,ho,l),p(il,t,l),d(t,co,l),d(t,sl,l),d(t,To,l),d(t,ul,l),d(t,yo,l),d(t,nl,l),d(t,vo,l),d(t,_o,l),d(t,Fo,l),d(t,ml,l),d(t,bo,l),p(fl,t,l),d(t,xo,l),d(t,pl,l),d(t,$o,l),d(t,hl,l),d(t,Po,l),d(t,Co,l),d(t,Ao,l),d(t,cl,l),d(t,Ho,l),p(Tl,t,l),d(t,Lo,l),d(t,yl,l),d(t,Mo,l),d(t,wo,l),d(t,go,l),d(t,_l,l),Eo=!0},p:Ps,i(t){Eo||(h(F.$$.fragment,t),h(C.$$.fragment,t),h(M.$$.fragment,t),h(z.$$.fragment,t),h(D.$$.fragment,t),h(S.$$.fragment,t),h(V.$$.fragment,t),h(tt.$$.fragment,t),h(at.$$.fragment,t),h(nt.$$.fragment,t),h(Tt.$$.fragment,t),h(xt.$$.fragment,t),h(Ht.$$.fragment,t),h(Et.$$.fragment,t),h(Bt.$$.fragment,t),h(qt.$$.fragment,t),h(Qt.$$.fragment,t),h(Yt.$$.fragment,t),h(de.$$.fragment,t),h(se.$$.fragment,t),h(pe.$$.fragment,t),h(_e.$$.fragment,t),h(Ce.$$.fragment,t),h(ge.$$.fragment,t),h(Ke.$$.fragment,t),h(je.$$.fragment,t),h(Ge.$$.fragment,t),h(Xe.$$.fragment,t),h(ll.$$.fragment,t),h(il.$$.fragment,t),h(fl.$$.fragment,t),h(Tl.$$.fragment,t),Eo=!0)},o(t){c(F.$$.fragment,t),c(C.$$.fragment,t),c(M.$$.fragment,t),c(z.$$.fragment,t),c(D.$$.fragment,t),c(S.$$.fragment,t),c(V.$$.fragment,t),c(tt.$$.fragment,t),c(at.$$.fragment,t),c(nt.$$.fragment,t),c(Tt.$$.fragment,t),c(xt.$$.fragment,t),c(Ht.$$.fragment,t),c(Et.$$.fragment,t),c(Bt.$$.fragment,t),c(qt.$$.fragment,t),c(Qt.$$.fragment,t),c(Yt.$$.fragment,t),c(de.$$.fragment,t),c(se.$$.fragment,t),c(pe.$$.fragment,t),c(_e.$$.fragment,t),c(Ce.$$.fragment,t),c(ge.$$.fragment,t),c(Ke.$$.fragment,t),c(je.$$.fragment,t),c(Ge.$$.fragment,t),c(Xe.$$.fragment,t),c(ll.$$.fragment,t),c(il.$$.fragment,t),c(fl.$$.fragment,t),c(Tl.$$.fragment,t),Eo=!1},d(t){t&&(e(Fl),e(vl),e(bl),e(_),e(xl),e($l),e(b),e(Pl),e(x),e(Cl),e($),e(Al),e(Hl),e(Ll),e(P),e(Ml),e(wl),e(A),e(gl),e(H),e(El),e(Rl),e(zl),e(L),e(kl),e(Kl),e(w),e(Bl),e(g),e(Ol),e(E),e(Dl),e(Il),e(jl),e(R),e(Ul),e(ql),e(k),e(Sl),e(K),e(Nl),e(B),e(Gl),e(Jl),e(Ql),e(O),e(Vl),e(Wl),e(I),e(Xl),e(j),e(Yl),e(U),e(Zl),e(td),e(ed),e(q),e(ld),e(dd),e(N),e(rd),e(G),e(ad),e(J),e(od),e(id),e(sd),e(Q),e(ud),e(nd),e(W),e(md),e(X),e(fd),e(Y),e(pd),e(hd),e(cd),e(Z),e(Td),e(yd),e(et),e(vd),e(lt),e(_d),e(dt),e(Fd),e(bd),e(xd),e(rt),e($d),e(Pd),e(ot),e(Cd),e(it),e(Ad),e(st),e(Hd),e(Ld),e(Md),e(ut),e(wd),e(gd),e(mt),e(Ed),e(ft),e(Rd),e(pt),e(zd),e(ht),e(kd),e(Kd),e(Bd),e(ct),e(Od),e(Dd),e(yt),e(Id),e(vt),e(jd),e(_t),e(Ud),e(Ft),e(qd),e(Sd),e(Nd),e(bt),e(Gd),e(Jd),e($t),e(Qd),e(Pt),e(Vd),e(Ct),e(Wd),e(Xd),e(Yd),e(At),e(Zd),e(tr),e(Lt),e(er),e(Mt),e(lr),e(wt),e(dr),e(rr),e(ar),e(gt),e(or),e(ir),e(Rt),e(sr),e(zt),e(ur),e(kt),e(nr),e(mr),e(fr),e(Kt),e(pr),e(hr),e(Ot),e(cr),e(Dt),e(Tr),e(It),e(yr),e(jt),e(vr),e(_r),e(Fr),e(Ut),e(br),e(xr),e(St),e($r),e(Nt),e(Pr),e(Gt),e(Cr),e(Ar),e(Hr),e(Jt),e(Lr),e(Mr),e(Vt),e(wr),e(Wt),e(gr),e(Er),e(Rr),e(Xt),e(zr),e(kr),e(Zt),e(Kr),e(te),e(Br),e(ee),e(Or),e(Dr),e(Ir),e(le),e(jr),e(Ur),e(re),e(qr),e(ae),e(Sr),e(oe),e(Nr),e(Gr),e(Jr),e(ie),e(Qr),e(Vr),e(ue),e(Wr),e(ne),e(Xr),e(me),e(Yr),e(Zr),e(ta),e(fe),e(ea),e(la),e(he),e(da),e(ce),e(ra),e(Te),e(aa),e(ye),e(oa),e(ia),e(sa),e(ve),e(ua),e(na),e(Fe),e(ma),e(be),e(fa),e(xe),e(pa),e($e),e(ha),e(ca),e(Ta),e(Pe),e(ya),e(va),e(Ae),e(_a),e(He),e(Fa),e(Le),e(ba),e(Me),e(xa),e($a),e(Pa),e(we),e(Ca),e(Aa),e(Ee),e(Ha),e(Re),e(La),e(ze),e(Ma),e(wa),e(ga),e(ke),e(Ea),e(Ra),e(Be),e(za),e(Oe),e(ka),e(De),e(Ka),e(Ba),e(Oa),e(Ie),e(Da),e(Ia),e(Ue),e(ja),e(qe),e(Ua),e(Se),e(qa),e(Sa),e(Na),e(Ne),e(Ga),e(Ja),e(Je),e(Qa),e(Qe),e(Va),e(Ve),e(Wa),e(Xa),e(Ya),e(We),e(Za),e(to),e(Ye),e(eo),e(Ze),e(lo),e(tl),e(ro),e(ao),e(oo),e(el),e(io),e(so),e(dl),e(uo),e(rl),e(no),e(al),e(mo),e(fo),e(po),e(ol),e(ho),e(co),e(sl),e(To),e(ul),e(yo),e(nl),e(vo),e(_o),e(Fo),e(ml),e(bo),e(xo),e(pl),e($o),e(hl),e(Po),e(Co),e(Ao),e(cl),e(Ho),e(Lo),e(yl),e(Mo),e(wo),e(go),e(_l)),e(v),T(F,t),T(C,t),T(M,t),T(z,t),T(D,t),T(S,t),T(V,t),T(tt,t),T(at,t),T(nt,t),T(Tt,t),T(xt,t),T(Ht,t),T(Et,t),T(Bt,t),T(qt,t),T(Qt,t),T(Yt,t),T(de,t),T(se,t),T(pe,t),T(_e,t),T(Ce,t),T(ge,t),T(Ke,t),T(je,t),T(Ge,t),T(Xe,t),T(ll,t),T(il,t),T(fl,t),T(Tl,t)}}}const gs='{"title":"utils/maths","local":"utilsmaths","sections":[{"title":"utils/maths.interpolate_data(input)","local":"utilsmathsinterpolatedatainput","sections":[],"depth":2},{"title":"utils/maths.permute_data(array, dims, axes) ⇒ <code> * </code>","local":"utilsmathspermutedataarray-dims-axes--code--code","sections":[],"depth":2},{"title":"utils/maths.softmax(arr) ⇒ <code> T </code>","local":"utilsmathssoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.log_softmax(arr) ⇒ <code> T </code>","local":"utilsmathslogsoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathsdotarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.getTopItems(items, [top_k]) ⇒ <code> * </code>","local":"utilsmathsgettopitemsitems-topk--code--code","sections":[],"depth":2},{"title":"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathscossimarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.magnitude(arr) ⇒ <code> number </code>","local":"utilsmathsmagnitudearr--code-number-code","sections":[],"depth":2},{"title":"utils/maths.min(arr) ⇒ <code> Array. < number > </code>","local":"utilsmathsminarr--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.max(arr) ⇒ <code> * </code>","local":"utilsmathsmaxarr--code--code","sections":[],"depth":2},{"title":"utils/maths.medianFilter(data, windowSize)","local":"utilsmathsmedianfilterdata-windowsize","sections":[],"depth":2},{"title":"utils/maths.round(num, decimals) ⇒ <code> number </code>","local":"utilsmathsroundnum-decimals--code-number-code","sections":[],"depth":2},{"title":"utils/maths.bankers_round(x) ⇒ <code> number </code>","local":"utilsmathsbankersroundx--code-number-code","sections":[],"depth":2},{"title":"utils/maths~P2FFT","local":"utilsmathsp2fft","sections":[{"title":"new P2FFT(size)","local":"new-p2fftsize","sections":[],"depth":3},{"title":"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>","local":"p2fftcreatecomplexarray--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>","local":"p2fftfromcomplexarraycomplex-storage--code-array--number--code","sections":[],"depth":3},{"title":"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>","local":"p2ffttocomplexarrayinput-storage--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.completeSpectrum(spectrum) ⇒ <code> void </code>","local":"p2fftcompletespectrumspectrum--code-void-code","sections":[],"depth":3},{"title":"p2FFT.transform(out, data) ⇒ <code> void </code>","local":"p2ffttransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT.realTransform(out, data)","local":"p2fftrealtransformout-data","sections":[],"depth":3},{"title":"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>","local":"p2fftinversetransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>","local":"p2ffttransform4out-data-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsingletransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>","local":"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._realTransform4(out, data, inv)","local":"p2fftrealtransform4out-data-inv","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)","local":"p2fftsinglerealtransform4data-out-outoff-off-step-inv","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~NP2FFT","local":"utilsmathsnp2fft","sections":[{"title":"new NP2FFT(fft_length)","local":"new-np2fftfftlength","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>","local":"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code","sections":[],"depth":2}],"depth":1}';function Es(Ro){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ks extends As{constructor(v){super(),Hs(this,v,Es,ws,$s,{})}}export{Ks as component};
