import{s as Ko,n as So,o as Oo}from"../chunks/scheduler.b108d059.js";import{S as No,i as Uo,g as i,s as l,r as c,A as Go,h as a,f as t,c as r,j as s,u as m,x as n,k as u,y as Wo,a as o,v as p,d as f,t as h,w as _}from"../chunks/index.008de539.js";import{H as b}from"../chunks/Heading.88bfeb84.js";function Jo(Gd){let g,Ne,Se,Ue,v,Ge,T,We,y,Wd="Helper module for audio processing.",Je,w,Jd=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,Qe,$,Qd='<li><a href="#module_utils/audio">utils/audio</a><ul><li><em>static</em><ul><li><a href="#module_utils/audio.read_audio"><code>.read_audio(url, sampling_rate)</code></a> ⇒ <code>Promise.&lt;Float32Array&gt;</code><ul><li><a href="#module_utils/audio.read_audio..audio"><code>~audio</code></a> : <code>Float32Array</code></li></ul></li> <li><a href="#module_utils/audio.hanning"><code>.hanning(M)</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/audio.mel_filter_bank"><code>.mel_filter_bank(num_frequency_bins, num_mel_filters, min_frequency, max_frequency, sampling_rate, [norm], [mel_scale], [triangularize_in_mel_space])</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/audio.spectrogram"><code>.spectrogram(waveform, window, frame_length, hop_length, options)</code></a> ⇒ <code>Object</code></li> <li><a href="#module_utils/audio.window_function"><code>.window_function(window_length, name, options)</code></a> ⇒ <code>Float64Array</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/audio..hertz_to_mel"><code>~hertz_to_mel(freq, [mel_scale])</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio..mel_to_hertz"><code>~mel_to_hertz(mels, [mel_scale])</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio.._create_triangular_filter_bank"><code>~_create_triangular_filter_bank(fft_freqs, filter_freqs)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/audio..linspace"><code>~linspace(start, end, num)</code></a> ⇒</li> <li><a href="#module_utils/audio..padReflect"><code>~padReflect(array, left, right)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio.._db_conversion_helper"><code>~_db_conversion_helper(spectrogram, factor, reference, min_value, db_range)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio..amplitude_to_db"><code>~amplitude_to_db(spectrogram, [reference], [min_value], [db_range])</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio..power_to_db"><code>~power_to_db(spectrogram, [reference], [min_value], [db_range])</code></a> ⇒ <code>T</code></li></ul></li></ul></li>',Ve,Xe,Ye,x,Ze,H,et,q,Vd="Helper function to read audio from a path/URL.",tt,L,Xd='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Float32Array&gt;</code> - The decoded audio as a <code>Float32Array</code>.',dt,M,Yd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>url</td><td><code>string</code> | <code>URL</code></td><td><p>The path/URL to load the audio from.</p></td> </tr><tr><td>sampling_rate</td><td><code>number</code></td><td><p>The sampling rate to use when decoding the audio.</p></td></tr></tbody>",ot,lt,rt,C,it,A,at,P,Zd='<strong>Kind</strong>: inner property of <a href="#module_utils/audio.read_audio"><code>read_audio</code></a>',nt,ut,st,z,ct,k,mt,F,eo="Generates a Hanning window of length M.",pt,R,to='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The generated Hanning window.',ft,E,oo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>M</td><td><code>number</code></td><td><p>The length of the Hanning window to generate.</p></td></tr></tbody>",ht,_t,bt,B,gt,D,vt,I,lo=`Creates a frequency bin conversion matrix used to obtain a mel spectrogram. This is called a <em>mel filter bank</em>, and
various implementation exist, which differ in the number of filters, the shape of the filters, the way the filters
are spaced, the bandwidth of the filters, and the manner in which the spectrum is warped. The goal of these
features is to approximate the non-linear human perception of the variation in pitch with respect to the frequency.`,Tt,j,ro=`<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Array&lt;number&gt;&gt;</code> - Triangular filter bank matrix, which is a 2D array of shape (<code>num_frequency_bins</code>, <code>num_mel_filters</code>).
This is a projection matrix to go from a spectrogram to a mel spectrogram.`,yt,K,io=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>num_frequency_bins</td><td><code>number</code></td><td><p>Number of frequencies used to compute the spectrogram (should be the same as in <code>stft</code>).</p></td> </tr><tr><td>num_mel_filters</td><td><code>number</code></td><td><p>Number of mel filters to generate.</p></td> </tr><tr><td>min_frequency</td><td><code>number</code></td><td><p>Lowest frequency of interest in Hz.</p></td> </tr><tr><td>max_frequency</td><td><code>number</code></td><td><p>Highest frequency of interest in Hz. This should not exceed <code>sampling_rate / 2</code>.</p></td> </tr><tr><td>sampling_rate</td><td><code>number</code></td><td><p>Sample rate of the audio waveform.</p></td> </tr><tr><td>[norm]</td><td><code>string</code></td><td><p>If <code>&quot;slaney&quot;</code>, divide the triangular mel weights by the width of the mel band (area normalization).</p></td> </tr><tr><td>[mel_scale]</td><td><code>string</code></td><td><p>The mel frequency scale to use, <code>&quot;htk&quot;</code> or <code>&quot;slaney&quot;</code>.</p></td> </tr><tr><td>[triangularize_in_mel_space]</td><td><code>boolean</code></td><td><p>If this option is enabled, the triangular filter is applied in mel space rather than frequency space.
This should be set to <code>true</code> in order to get the same results as <code>torchaudio</code> when computing mel filters.</p></td></tr></tbody>`,wt,$t,xt,S,Ht,O,qt,N,ao="Calculates a spectrogram over one waveform using the Short-Time Fourier Transform.",Lt,U,no="This function can create the following kinds of spectrograms:",Mt,G,uo="<li>amplitude spectrogram (<code>power = 1.0</code>)</li> <li>power spectrogram (<code>power = 2.0</code>)</li> <li>complex-valued spectrogram (<code>power = None</code>)</li> <li>log spectrogram (use <code>log_mel</code> argument)</li> <li>mel spectrogram (provide <code>mel_filters</code>)</li> <li>log-mel spectrogram (provide <code>mel_filters</code> and <code>log_mel</code>)</li>",Ct,W,so=`In this implementation, the window is assumed to be zero-padded to have the same size as the analysis frame.
A padded window can be obtained from <code>window_function()</code>. The FFT input buffer may be larger than the analysis frame,
typically the next power of two.`,At,J,co='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Object</code> - Spectrogram of shape <code>(num_frequency_bins, length)</code> (regular spectrogram) or shape <code>(num_mel_filters, length)</code> (mel spectrogram).',Pt,Q,mo=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>waveform</td><td><code>Float32Array</code> | <code>Float64Array</code></td><td></td><td><p>The input waveform of shape <code>(length,)</code>. This must be a single real-valued, mono waveform.</p></td> </tr><tr><td>window</td><td><code>Float32Array</code> | <code>Float64Array</code></td><td></td><td><p>The windowing function to apply of shape <code>(frame_length,)</code>, including zero-padding if necessary. The actual window length may be
shorter than <code>frame_length</code>, but we&#39;re assuming the array has already been zero-padded.</p></td> </tr><tr><td>frame_length</td><td><code>number</code></td><td></td><td><p>The length of the analysis frames in samples (a.k.a., <code>fft_length</code>).</p></td> </tr><tr><td>hop_length</td><td><code>number</code></td><td></td><td><p>The stride between successive analysis frames in samples.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td></td> </tr><tr><td>[options.fft_length]</td><td><code>number</code></td><td><code></code></td><td><p>The size of the FFT buffer in samples. This determines how many frequency bins the spectrogram will have.
For optimal speed, this should be a power of two. If <code>null</code>, uses <code>frame_length</code>.</p></td> </tr><tr><td>[options.power]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>If 1.0, returns the amplitude spectrogram. If 2.0, returns the power spectrogram. If <code>null</code>, returns complex numbers.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to pad the waveform so that frame <code>t</code> is centered around time <code>t * hop_length</code>. If <code>false</code>, frame
<code>t</code> will start at time <code>t * hop_length</code>.</p></td> </tr><tr><td>[options.pad_mode]</td><td><code>string</code></td><td><code>&quot;&quot;reflect&quot;&quot;</code></td><td><p>Padding mode used when <code>center</code> is <code>true</code>. Possible values are: <code>&quot;constant&quot;</code> (pad with zeros),
<code>&quot;edge&quot;</code> (pad with edge values), <code>&quot;reflect&quot;</code> (pads with mirrored values).</p></td> </tr><tr><td>[options.onesided]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>If <code>true</code>, only computes the positive frequencies and returns a spectrogram containing <code>fft_length // 2 + 1</code>
frequency bins. If <code>false</code>, also computes the negative frequencies and returns <code>fft_length</code> frequency bins.</p></td> </tr><tr><td>[options.preemphasis]</td><td><code>number</code></td><td><code></code></td><td><p>Coefficient for a low-pass filter that applies pre-emphasis before the DFT.</p></td> </tr><tr><td>[options.mel_filters]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The mel filter bank of shape <code>(num_freq_bins, num_mel_filters)</code>.
If supplied, applies this filter bank to create a mel spectrogram.</p></td> </tr><tr><td>[options.mel_floor]</td><td><code>number</code></td><td><code>1e-10</code></td><td><p>Minimum value of mel frequency banks.</p></td> </tr><tr><td>[options.log_mel]</td><td><code>string</code></td><td><code>null</code></td><td><p>How to convert the spectrogram to log scale. Possible options are:
<code>null</code> (don&#39;t convert), <code>&quot;log&quot;</code> (take the natural logarithm) <code>&quot;log10&quot;</code> (take the base-10 logarithm), <code>&quot;dB&quot;</code> (convert to decibels).
Can only be used when <code>power</code> is not <code>null</code>.</p></td> </tr><tr><td>[options.reference]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Sets the input spectrogram value that corresponds to 0 dB. For example, use <code>max(spectrogram)[0]</code> to set
the loudest part to 0 dB. Must be greater than zero.</p></td> </tr><tr><td>[options.min_value]</td><td><code>number</code></td><td><code>1e-10</code></td><td><p>The spectrogram will be clipped to this minimum value before conversion to decibels, to avoid taking <code>log(0)</code>.
For a power spectrogram, the default of <code>1e-10</code> corresponds to a minimum of -100 dB. For an amplitude spectrogram, the value <code>1e-5</code> corresponds to -100 dB.
Must be greater than zero.</p></td> </tr><tr><td>[options.db_range]</td><td><code>number</code></td><td><code></code></td><td><p>Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the difference between the
peak value and the smallest value will never be more than 80 dB. Must be greater than zero.</p></td> </tr><tr><td>[options.remove_dc_offset]</td><td><code>boolean</code></td><td><code></code></td><td><p>Subtract mean from waveform on each frame, applied before pre-emphasis. This should be set to <code>true</code> in
order to get the same results as <code>torchaudio.compliance.kaldi.fbank</code> when computing mel filters.</p></td> </tr><tr><td>[options.max_num_frames]</td><td><code>number</code></td><td><code></code></td><td><p>If provided, limits the number of frames to compute to this value.</p></td> </tr><tr><td>[options.do_pad]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>If <code>true</code>, pads the output spectrogram to have <code>max_num_frames</code> frames.</p></td> </tr><tr><td>[options.transpose]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>If <code>true</code>, the returned spectrogram will have shape <code>(num_frames, num_frequency_bins/num_mel_filters)</code>. If <code>false</code>, the returned spectrogram will have shape <code>(num_frequency_bins/num_mel_filters, num_frames)</code>.</p></td></tr></tbody>`,zt,kt,Ft,V,Rt,X,Et,Y,po="Returns an array containing the specified window.",Bt,Z,fo='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The window of shape <code>(window_length,)</code> or <code>(frame_length,)</code>.',Dt,ee,ho=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>window_length</td><td><code>number</code></td><td></td><td><p>The length of the window in samples.</p></td> </tr><tr><td>name</td><td><code>string</code></td><td></td><td><p>The name of the window function.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options.</p></td> </tr><tr><td>[options.periodic]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether the window is periodic or symmetric.</p></td> </tr><tr><td>[options.frame_length]</td><td><code>number</code></td><td><code></code></td><td><p>The length of the analysis frames in samples.
Provide a value for <code>frame_length</code> if the window is smaller than the frame length, so that it will be zero-padded.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to center the window inside the FFT buffer. Only used when <code>frame_length</code> is provided.</p></td></tr></tbody>`,It,jt,Kt,te,St,de,Ot,oe,_o='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a>',Nt,le,bo="<thead><tr><th>Param</th><th>Type</th><th>Default</th></tr></thead> <tbody><tr><td>freq</td><td><code>T</code></td><td></td> </tr><tr><td>[mel_scale]</td><td><code>string</code></td><td><code>&quot;htk&quot;</code></td></tr></tbody>",Ut,Gt,Wt,re,Jt,ie,Qt,ae,go='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a>',Vt,ne,vo="<thead><tr><th>Param</th><th>Type</th><th>Default</th></tr></thead> <tbody><tr><td>mels</td><td><code>T</code></td><td></td> </tr><tr><td>[mel_scale]</td><td><code>string</code></td><td><code>&quot;htk&quot;</code></td></tr></tbody>",Xt,Yt,Zt,ue,ed,se,td,ce,To="Creates a triangular filter bank.",dd,me,yo="Adapted from torchaudio and librosa.",od,pe,wo='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Array&lt;number&gt;&gt;</code> - of shape <code>(num_frequency_bins, num_mel_filters)</code>.',ld,fe,$o="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>fft_freqs</td><td><code>Float64Array</code></td><td><p>Discrete frequencies of the FFT bins in Hz, of shape <code>(num_frequency_bins,)</code>.</p></td> </tr><tr><td>filter_freqs</td><td><code>Float64Array</code></td><td><p>Center frequencies of the triangular filters to create, in Hz, of shape <code>(num_mel_filters,)</code>.</p></td></tr></tbody>",rd,id,ad,he,nd,_e,ud,be,xo="Return evenly spaced numbers over a specified interval.",sd,ge,Ho='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>num</code> evenly spaced samples, calculated over the interval <code>[start, stop]</code>.',cd,ve,qo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>start</td><td><code>number</code></td><td><p>The starting value of the sequence.</p></td> </tr><tr><td>end</td><td><code>number</code></td><td><p>The end value of the sequence.</p></td> </tr><tr><td>num</td><td><code>number</code></td><td><p>Number of samples to generate.</p></td></tr></tbody>",md,pd,fd,Te,hd,ye,_d,we,Lo='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>T</code> - The padded array.',bd,$e,Mo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>array</td><td><code>T</code></td><td><p>The array to pad.</p></td> </tr><tr><td>left</td><td><code>number</code></td><td><p>The amount of padding to add to the left.</p></td> </tr><tr><td>right</td><td><code>number</code></td><td><p>The amount of padding to add to the right.</p></td></tr></tbody>",gd,vd,Td,xe,yd,He,wd,qe,Co="Helper function to compute <code>amplitude_to_db</code> and <code>power_to_db</code>.",$d,Le,Ao='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a>',xd,Me,Po="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>spectrogram</td><td><code>T</code></td> </tr><tr><td>factor</td><td><code>number</code></td> </tr><tr><td>reference</td><td><code>number</code></td> </tr><tr><td>min_value</td><td><code>number</code></td> </tr><tr><td>db_range</td><td><code>number</code></td></tr></tbody>",Hd,qd,Ld,Ce,Md,Ae,Cd,Pe,zo=`Converts an amplitude spectrogram to the decibel scale. This computes <code>20 * log10(spectrogram / reference)</code>,
using basic logarithm properties for numerical stability. NOTE: Operates in-place.`,Ad,ze,ko=`The motivation behind applying the log function on the (mel) spectrogram is that humans do not hear loudness on a
linear scale. Generally to double the perceived volume of a sound we need to put 8 times as much energy into it.
This means that large variations in energy may not sound all that different if the sound is loud to begin with.
This compression operation makes the (mel) spectrogram features match more closely what humans actually hear.`,Pd,ke,Fo='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>T</code> - The modified spectrogram in decibels.',zd,Fe,Ro=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>spectrogram</td><td><code>T</code></td><td></td><td><p>The input amplitude (mel) spectrogram.</p></td> </tr><tr><td>[reference]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Sets the input spectrogram value that corresponds to 0 dB.
For example, use <code>np.max(spectrogram)</code> to set the loudest part to 0 dB. Must be greater than zero.</p></td> </tr><tr><td>[min_value]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>The spectrogram will be clipped to this minimum value before conversion to decibels,
to avoid taking <code>log(0)</code>. The default of <code>1e-5</code> corresponds to a minimum of -100 dB. Must be greater than zero.</p></td> </tr><tr><td>[db_range]</td><td><code>number</code></td><td><code></code></td><td><p>Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the
difference between the peak value and the smallest value will never be more than 80 dB. Must be greater than zero.</p></td></tr></tbody>`,kd,Fd,Rd,Re,Ed,Ee,Bd,Be,Eo=`Converts a power spectrogram to the decibel scale. This computes <code>10 * log10(spectrogram / reference)</code>,
using basic logarithm properties for numerical stability. NOTE: Operates in-place.`,Dd,De,Bo=`The motivation behind applying the log function on the (mel) spectrogram is that humans do not hear loudness on a
linear scale. Generally to double the perceived volume of a sound we need to put 8 times as much energy into it.
This means that large variations in energy may not sound all that different if the sound is loud to begin with.
This compression operation makes the (mel) spectrogram features match more closely what humans actually hear.`,Id,Ie,Do="Based on the implementation of <code>librosa.power_to_db</code>.",jd,je,Io='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>T</code> - The modified spectrogram in decibels.',Kd,Ke,jo=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>spectrogram</td><td><code>T</code></td><td></td><td><p>The input power (mel) spectrogram. Note that a power spectrogram has the amplitudes squared!</p></td> </tr><tr><td>[reference]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Sets the input spectrogram value that corresponds to 0 dB.
For example, use <code>np.max(spectrogram)</code> to set the loudest part to 0 dB. Must be greater than zero.</p></td> </tr><tr><td>[min_value]</td><td><code>number</code></td><td><code>1e-10</code></td><td><p>The spectrogram will be clipped to this minimum value before conversion to decibels,
to avoid taking <code>log(0)</code>. The default of <code>1e-10</code> corresponds to a minimum of -100 dB. Must be greater than zero.</p></td> </tr><tr><td>[db_range]</td><td><code>number</code></td><td><code></code></td><td><p>Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the
difference between the peak value and the smallest value will never be more than 80 dB. Must be greater than zero.</p></td></tr></tbody>`,Sd,Od,Nd,Oe,Ud;return T=new b({props:{title:"utils/audio",local:"utilsaudio",headingTag:"h1"}}),H=new b({props:{title:"utils/audio.read_audio(url, sampling_rate) ⇒ <code> Promise. < Float32Array > </code>",local:"utilsaudioreadaudiourl-samplingrate--code-promise--float32array--code",headingTag:"h2"}}),A=new b({props:{title:"read_audio~audio : <code> Float32Array </code>",local:"readaudioaudio--code-float32array-code",headingTag:"h3"}}),k=new b({props:{title:"utils/audio.hanning(M) ⇒ <code> Float64Array </code>",local:"utilsaudiohanningm--code-float64array-code",headingTag:"h2"}}),D=new b({props:{title:"utils/audio.mel_filter_bank(num_frequency_bins, num_mel_filters, min_frequency, max_frequency, sampling_rate, [norm], [mel_scale], [triangularize_in_mel_space]) ⇒ <code> Array. < Array < number > > </code>",local:"utilsaudiomelfilterbanknumfrequencybins-nummelfilters-minfrequency-maxfrequency-samplingrate-norm-melscale-triangularizeinmelspace--code-array--array--number---code",headingTag:"h2"}}),O=new b({props:{title:"utils/audio.spectrogram(waveform, window, frame_length, hop_length, options) ⇒ <code> Object </code>",local:"utilsaudiospectrogramwaveform-window-framelength-hoplength-options--code-object-code",headingTag:"h2"}}),X=new b({props:{title:"utils/audio.window_function(window_length, name, options) ⇒ <code> Float64Array </code>",local:"utilsaudiowindowfunctionwindowlength-name-options--code-float64array-code",headingTag:"h2"}}),de=new b({props:{title:"utils/audio~hertz_to_mel(freq, [mel_scale]) ⇒ <code> T </code>",local:"utilsaudiohertztomelfreq-melscale--code-t-code",headingTag:"h2"}}),ie=new b({props:{title:"utils/audio~mel_to_hertz(mels, [mel_scale]) ⇒ <code> T </code>",local:"utilsaudiomeltohertzmels-melscale--code-t-code",headingTag:"h2"}}),se=new b({props:{title:"utils/audio~_create_triangular_filter_bank(fft_freqs, filter_freqs) ⇒ <code> Array. < Array < number > > </code>",local:"utilsaudiocreatetriangularfilterbankfftfreqs-filterfreqs--code-array--array--number---code",headingTag:"h2"}}),_e=new b({props:{title:"utils/audio~linspace(start, end, num) ⇒",local:"utilsaudiolinspacestart-end-num-",headingTag:"h2"}}),ye=new b({props:{title:"utils/audio~padReflect(array, left, right) ⇒ <code> T </code>",local:"utilsaudiopadreflectarray-left-right--code-t-code",headingTag:"h2"}}),He=new b({props:{title:"utils/audio~_db_conversion_helper(spectrogram, factor, reference, min_value, db_range) ⇒ <code> T </code>",local:"utilsaudiodbconversionhelperspectrogram-factor-reference-minvalue-dbrange--code-t-code",headingTag:"h2"}}),Ae=new b({props:{title:"utils/audio~amplitude_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>",local:"utilsaudioamplitudetodbspectrogram-reference-minvalue-dbrange--code-t-code",headingTag:"h2"}}),Ee=new b({props:{title:"utils/audio~power_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>",local:"utilsaudiopowertodbspectrogram-reference-minvalue-dbrange--code-t-code",headingTag:"h2"}}),{c(){g=i("meta"),Ne=l(),Se=i("p"),Ue=l(),v=i("a"),Ge=l(),c(T.$$.fragment),We=l(),y=i("p"),y.textContent=Wd,Je=l(),w=i("p"),w.textContent=Jd,Qe=l(),$=i("ul"),$.innerHTML=Qd,Ve=l(),Xe=i("hr"),Ye=l(),x=i("a"),Ze=l(),c(H.$$.fragment),et=l(),q=i("p"),q.textContent=Vd,tt=l(),L=i("p"),L.innerHTML=Xd,dt=l(),M=i("table"),M.innerHTML=Yd,ot=l(),lt=i("hr"),rt=l(),C=i("a"),it=l(),c(A.$$.fragment),at=l(),P=i("p"),P.innerHTML=Zd,nt=l(),ut=i("hr"),st=l(),z=i("a"),ct=l(),c(k.$$.fragment),mt=l(),F=i("p"),F.textContent=eo,pt=l(),R=i("p"),R.innerHTML=to,ft=l(),E=i("table"),E.innerHTML=oo,ht=l(),_t=i("hr"),bt=l(),B=i("a"),gt=l(),c(D.$$.fragment),vt=l(),I=i("p"),I.innerHTML=lo,Tt=l(),j=i("p"),j.innerHTML=ro,yt=l(),K=i("table"),K.innerHTML=io,wt=l(),$t=i("hr"),xt=l(),S=i("a"),Ht=l(),c(O.$$.fragment),qt=l(),N=i("p"),N.textContent=ao,Lt=l(),U=i("p"),U.textContent=no,Mt=l(),G=i("ul"),G.innerHTML=uo,Ct=l(),W=i("p"),W.innerHTML=so,At=l(),J=i("p"),J.innerHTML=co,Pt=l(),Q=i("table"),Q.innerHTML=mo,zt=l(),kt=i("hr"),Ft=l(),V=i("a"),Rt=l(),c(X.$$.fragment),Et=l(),Y=i("p"),Y.textContent=po,Bt=l(),Z=i("p"),Z.innerHTML=fo,Dt=l(),ee=i("table"),ee.innerHTML=ho,It=l(),jt=i("hr"),Kt=l(),te=i("a"),St=l(),c(de.$$.fragment),Ot=l(),oe=i("p"),oe.innerHTML=_o,Nt=l(),le=i("table"),le.innerHTML=bo,Ut=l(),Gt=i("hr"),Wt=l(),re=i("a"),Jt=l(),c(ie.$$.fragment),Qt=l(),ae=i("p"),ae.innerHTML=go,Vt=l(),ne=i("table"),ne.innerHTML=vo,Xt=l(),Yt=i("hr"),Zt=l(),ue=i("a"),ed=l(),c(se.$$.fragment),td=l(),ce=i("p"),ce.textContent=To,dd=l(),me=i("p"),me.textContent=yo,od=l(),pe=i("p"),pe.innerHTML=wo,ld=l(),fe=i("table"),fe.innerHTML=$o,rd=l(),id=i("hr"),ad=l(),he=i("a"),nd=l(),c(_e.$$.fragment),ud=l(),be=i("p"),be.textContent=xo,sd=l(),ge=i("p"),ge.innerHTML=Ho,cd=l(),ve=i("table"),ve.innerHTML=qo,md=l(),pd=i("hr"),fd=l(),Te=i("a"),hd=l(),c(ye.$$.fragment),_d=l(),we=i("p"),we.innerHTML=Lo,bd=l(),$e=i("table"),$e.innerHTML=Mo,gd=l(),vd=i("hr"),Td=l(),xe=i("a"),yd=l(),c(He.$$.fragment),wd=l(),qe=i("p"),qe.innerHTML=Co,$d=l(),Le=i("p"),Le.innerHTML=Ao,xd=l(),Me=i("table"),Me.innerHTML=Po,Hd=l(),qd=i("hr"),Ld=l(),Ce=i("a"),Md=l(),c(Ae.$$.fragment),Cd=l(),Pe=i("p"),Pe.innerHTML=zo,Ad=l(),ze=i("p"),ze.textContent=ko,Pd=l(),ke=i("p"),ke.innerHTML=Fo,zd=l(),Fe=i("table"),Fe.innerHTML=Ro,kd=l(),Fd=i("hr"),Rd=l(),Re=i("a"),Ed=l(),c(Ee.$$.fragment),Bd=l(),Be=i("p"),Be.innerHTML=Eo,Dd=l(),De=i("p"),De.textContent=Bo,Id=l(),Ie=i("p"),Ie.innerHTML=Do,jd=l(),je=i("p"),je.innerHTML=Io,Kd=l(),Ke=i("table"),Ke.innerHTML=jo,Sd=l(),Od=i("hr"),Nd=l(),Oe=i("p"),this.h()},l(e){const d=Go("svelte-u9bgzb",document.head);g=a(d,"META",{name:!0,content:!0}),d.forEach(t),Ne=r(e),Se=a(e,"P",{}),s(Se).forEach(t),Ue=r(e),v=a(e,"A",{id:!0,class:!0}),s(v).forEach(t),Ge=r(e),m(T.$$.fragment,e),We=r(e),y=a(e,"P",{"data-svelte-h":!0}),n(y)!=="svelte-12buzkq"&&(y.textContent=Wd),Je=r(e),w=a(e,"P",{"data-svelte-h":!0}),n(w)!=="svelte-il3kl8"&&(w.textContent=Jd),Qe=r(e),$=a(e,"UL",{"data-svelte-h":!0}),n($)!=="svelte-10lafhw"&&($.innerHTML=Qd),Ve=r(e),Xe=a(e,"HR",{}),Ye=r(e),x=a(e,"A",{id:!0,class:!0}),s(x).forEach(t),Ze=r(e),m(H.$$.fragment,e),et=r(e),q=a(e,"P",{"data-svelte-h":!0}),n(q)!=="svelte-wq5n0b"&&(q.textContent=Vd),tt=r(e),L=a(e,"P",{"data-svelte-h":!0}),n(L)!=="svelte-wzwr9x"&&(L.innerHTML=Xd),dt=r(e),M=a(e,"TABLE",{"data-svelte-h":!0}),n(M)!=="svelte-1u23bjg"&&(M.innerHTML=Yd),ot=r(e),lt=a(e,"HR",{}),rt=r(e),C=a(e,"A",{id:!0,class:!0}),s(C).forEach(t),it=r(e),m(A.$$.fragment,e),at=r(e),P=a(e,"P",{"data-svelte-h":!0}),n(P)!=="svelte-kcz1h5"&&(P.innerHTML=Zd),nt=r(e),ut=a(e,"HR",{}),st=r(e),z=a(e,"A",{id:!0,class:!0}),s(z).forEach(t),ct=r(e),m(k.$$.fragment,e),mt=r(e),F=a(e,"P",{"data-svelte-h":!0}),n(F)!=="svelte-7wy73k"&&(F.textContent=eo),pt=r(e),R=a(e,"P",{"data-svelte-h":!0}),n(R)!=="svelte-187ugov"&&(R.innerHTML=to),ft=r(e),E=a(e,"TABLE",{"data-svelte-h":!0}),n(E)!=="svelte-1x4zay3"&&(E.innerHTML=oo),ht=r(e),_t=a(e,"HR",{}),bt=r(e),B=a(e,"A",{id:!0,class:!0}),s(B).forEach(t),gt=r(e),m(D.$$.fragment,e),vt=r(e),I=a(e,"P",{"data-svelte-h":!0}),n(I)!=="svelte-ke4v6b"&&(I.innerHTML=lo),Tt=r(e),j=a(e,"P",{"data-svelte-h":!0}),n(j)!=="svelte-rtofow"&&(j.innerHTML=ro),yt=r(e),K=a(e,"TABLE",{"data-svelte-h":!0}),n(K)!=="svelte-t1r9o1"&&(K.innerHTML=io),wt=r(e),$t=a(e,"HR",{}),xt=r(e),S=a(e,"A",{id:!0,class:!0}),s(S).forEach(t),Ht=r(e),m(O.$$.fragment,e),qt=r(e),N=a(e,"P",{"data-svelte-h":!0}),n(N)!=="svelte-10mwufd"&&(N.textContent=ao),Lt=r(e),U=a(e,"P",{"data-svelte-h":!0}),n(U)!=="svelte-zfp2ya"&&(U.textContent=no),Mt=r(e),G=a(e,"UL",{"data-svelte-h":!0}),n(G)!=="svelte-14mziv8"&&(G.innerHTML=uo),Ct=r(e),W=a(e,"P",{"data-svelte-h":!0}),n(W)!=="svelte-iwx6w9"&&(W.innerHTML=so),At=r(e),J=a(e,"P",{"data-svelte-h":!0}),n(J)!=="svelte-1ib6mhu"&&(J.innerHTML=co),Pt=r(e),Q=a(e,"TABLE",{"data-svelte-h":!0}),n(Q)!=="svelte-1nkeya3"&&(Q.innerHTML=mo),zt=r(e),kt=a(e,"HR",{}),Ft=r(e),V=a(e,"A",{id:!0,class:!0}),s(V).forEach(t),Rt=r(e),m(X.$$.fragment,e),Et=r(e),Y=a(e,"P",{"data-svelte-h":!0}),n(Y)!=="svelte-13l1rbm"&&(Y.textContent=po),Bt=r(e),Z=a(e,"P",{"data-svelte-h":!0}),n(Z)!=="svelte-9ixqdv"&&(Z.innerHTML=fo),Dt=r(e),ee=a(e,"TABLE",{"data-svelte-h":!0}),n(ee)!=="svelte-h693em"&&(ee.innerHTML=ho),It=r(e),jt=a(e,"HR",{}),Kt=r(e),te=a(e,"A",{id:!0,class:!0}),s(te).forEach(t),St=r(e),m(de.$$.fragment,e),Ot=r(e),oe=a(e,"P",{"data-svelte-h":!0}),n(oe)!=="svelte-5cebk5"&&(oe.innerHTML=_o),Nt=r(e),le=a(e,"TABLE",{"data-svelte-h":!0}),n(le)!=="svelte-1w6ehfm"&&(le.innerHTML=bo),Ut=r(e),Gt=a(e,"HR",{}),Wt=r(e),re=a(e,"A",{id:!0,class:!0}),s(re).forEach(t),Jt=r(e),m(ie.$$.fragment,e),Qt=r(e),ae=a(e,"P",{"data-svelte-h":!0}),n(ae)!=="svelte-5cebk5"&&(ae.innerHTML=go),Vt=r(e),ne=a(e,"TABLE",{"data-svelte-h":!0}),n(ne)!=="svelte-io7ocd"&&(ne.innerHTML=vo),Xt=r(e),Yt=a(e,"HR",{}),Zt=r(e),ue=a(e,"A",{id:!0,class:!0}),s(ue).forEach(t),ed=r(e),m(se.$$.fragment,e),td=r(e),ce=a(e,"P",{"data-svelte-h":!0}),n(ce)!=="svelte-uj0il7"&&(ce.textContent=To),dd=r(e),me=a(e,"P",{"data-svelte-h":!0}),n(me)!=="svelte-srmfwi"&&(me.textContent=yo),od=r(e),pe=a(e,"P",{"data-svelte-h":!0}),n(pe)!=="svelte-aln42z"&&(pe.innerHTML=wo),ld=r(e),fe=a(e,"TABLE",{"data-svelte-h":!0}),n(fe)!=="svelte-2x9dyx"&&(fe.innerHTML=$o),rd=r(e),id=a(e,"HR",{}),ad=r(e),he=a(e,"A",{id:!0,class:!0}),s(he).forEach(t),nd=r(e),m(_e.$$.fragment,e),ud=r(e),be=a(e,"P",{"data-svelte-h":!0}),n(be)!=="svelte-osjtvn"&&(be.textContent=xo),sd=r(e),ge=a(e,"P",{"data-svelte-h":!0}),n(ge)!=="svelte-bfmjcl"&&(ge.innerHTML=Ho),cd=r(e),ve=a(e,"TABLE",{"data-svelte-h":!0}),n(ve)!=="svelte-c7ztlp"&&(ve.innerHTML=qo),md=r(e),pd=a(e,"HR",{}),fd=r(e),Te=a(e,"A",{id:!0,class:!0}),s(Te).forEach(t),hd=r(e),m(ye.$$.fragment,e),_d=r(e),we=a(e,"P",{"data-svelte-h":!0}),n(we)!=="svelte-115nnpl"&&(we.innerHTML=Lo),bd=r(e),$e=a(e,"TABLE",{"data-svelte-h":!0}),n($e)!=="svelte-6p81mk"&&($e.innerHTML=Mo),gd=r(e),vd=a(e,"HR",{}),Td=r(e),xe=a(e,"A",{id:!0,class:!0}),s(xe).forEach(t),yd=r(e),m(He.$$.fragment,e),wd=r(e),qe=a(e,"P",{"data-svelte-h":!0}),n(qe)!=="svelte-9t3wul"&&(qe.innerHTML=Co),$d=r(e),Le=a(e,"P",{"data-svelte-h":!0}),n(Le)!=="svelte-5cebk5"&&(Le.innerHTML=Ao),xd=r(e),Me=a(e,"TABLE",{"data-svelte-h":!0}),n(Me)!=="svelte-heeupf"&&(Me.innerHTML=Po),Hd=r(e),qd=a(e,"HR",{}),Ld=r(e),Ce=a(e,"A",{id:!0,class:!0}),s(Ce).forEach(t),Md=r(e),m(Ae.$$.fragment,e),Cd=r(e),Pe=a(e,"P",{"data-svelte-h":!0}),n(Pe)!=="svelte-93lmwr"&&(Pe.innerHTML=zo),Ad=r(e),ze=a(e,"P",{"data-svelte-h":!0}),n(ze)!=="svelte-12zo44d"&&(ze.textContent=ko),Pd=r(e),ke=a(e,"P",{"data-svelte-h":!0}),n(ke)!=="svelte-1d363v6"&&(ke.innerHTML=Fo),zd=r(e),Fe=a(e,"TABLE",{"data-svelte-h":!0}),n(Fe)!=="svelte-1wpe278"&&(Fe.innerHTML=Ro),kd=r(e),Fd=a(e,"HR",{}),Rd=r(e),Re=a(e,"A",{id:!0,class:!0}),s(Re).forEach(t),Ed=r(e),m(Ee.$$.fragment,e),Bd=r(e),Be=a(e,"P",{"data-svelte-h":!0}),n(Be)!=="svelte-1dxatci"&&(Be.innerHTML=Eo),Dd=r(e),De=a(e,"P",{"data-svelte-h":!0}),n(De)!=="svelte-12zo44d"&&(De.textContent=Bo),Id=r(e),Ie=a(e,"P",{"data-svelte-h":!0}),n(Ie)!=="svelte-1bxqqp"&&(Ie.innerHTML=Do),jd=r(e),je=a(e,"P",{"data-svelte-h":!0}),n(je)!=="svelte-1d363v6"&&(je.innerHTML=Io),Kd=r(e),Ke=a(e,"TABLE",{"data-svelte-h":!0}),n(Ke)!=="svelte-h9b3kb"&&(Ke.innerHTML=jo),Sd=r(e),Od=a(e,"HR",{}),Nd=r(e),Oe=a(e,"P",{}),s(Oe).forEach(t),this.h()},h(){u(g,"name","hf:doc:metadata"),u(g,"content",Qo),u(v,"id","module_utils/audio"),u(v,"class","group"),u(x,"id","module_utils/audio.read_audio"),u(x,"class","group"),u(C,"id","module_utils/audio.read_audio..audio"),u(C,"class","group"),u(z,"id","module_utils/audio.hanning"),u(z,"class","group"),u(B,"id","module_utils/audio.mel_filter_bank"),u(B,"class","group"),u(S,"id","module_utils/audio.spectrogram"),u(S,"class","group"),u(V,"id","module_utils/audio.window_function"),u(V,"class","group"),u(te,"id","module_utils/audio..hertz_to_mel"),u(te,"class","group"),u(re,"id","module_utils/audio..mel_to_hertz"),u(re,"class","group"),u(ue,"id","module_utils/audio.._create_triangular_filter_bank"),u(ue,"class","group"),u(he,"id","module_utils/audio..linspace"),u(he,"class","group"),u(Te,"id","module_utils/audio..padReflect"),u(Te,"class","group"),u(xe,"id","module_utils/audio.._db_conversion_helper"),u(xe,"class","group"),u(Ce,"id","module_utils/audio..amplitude_to_db"),u(Ce,"class","group"),u(Re,"id","module_utils/audio..power_to_db"),u(Re,"class","group")},m(e,d){Wo(document.head,g),o(e,Ne,d),o(e,Se,d),o(e,Ue,d),o(e,v,d),o(e,Ge,d),p(T,e,d),o(e,We,d),o(e,y,d),o(e,Je,d),o(e,w,d),o(e,Qe,d),o(e,$,d),o(e,Ve,d),o(e,Xe,d),o(e,Ye,d),o(e,x,d),o(e,Ze,d),p(H,e,d),o(e,et,d),o(e,q,d),o(e,tt,d),o(e,L,d),o(e,dt,d),o(e,M,d),o(e,ot,d),o(e,lt,d),o(e,rt,d),o(e,C,d),o(e,it,d),p(A,e,d),o(e,at,d),o(e,P,d),o(e,nt,d),o(e,ut,d),o(e,st,d),o(e,z,d),o(e,ct,d),p(k,e,d),o(e,mt,d),o(e,F,d),o(e,pt,d),o(e,R,d),o(e,ft,d),o(e,E,d),o(e,ht,d),o(e,_t,d),o(e,bt,d),o(e,B,d),o(e,gt,d),p(D,e,d),o(e,vt,d),o(e,I,d),o(e,Tt,d),o(e,j,d),o(e,yt,d),o(e,K,d),o(e,wt,d),o(e,$t,d),o(e,xt,d),o(e,S,d),o(e,Ht,d),p(O,e,d),o(e,qt,d),o(e,N,d),o(e,Lt,d),o(e,U,d),o(e,Mt,d),o(e,G,d),o(e,Ct,d),o(e,W,d),o(e,At,d),o(e,J,d),o(e,Pt,d),o(e,Q,d),o(e,zt,d),o(e,kt,d),o(e,Ft,d),o(e,V,d),o(e,Rt,d),p(X,e,d),o(e,Et,d),o(e,Y,d),o(e,Bt,d),o(e,Z,d),o(e,Dt,d),o(e,ee,d),o(e,It,d),o(e,jt,d),o(e,Kt,d),o(e,te,d),o(e,St,d),p(de,e,d),o(e,Ot,d),o(e,oe,d),o(e,Nt,d),o(e,le,d),o(e,Ut,d),o(e,Gt,d),o(e,Wt,d),o(e,re,d),o(e,Jt,d),p(ie,e,d),o(e,Qt,d),o(e,ae,d),o(e,Vt,d),o(e,ne,d),o(e,Xt,d),o(e,Yt,d),o(e,Zt,d),o(e,ue,d),o(e,ed,d),p(se,e,d),o(e,td,d),o(e,ce,d),o(e,dd,d),o(e,me,d),o(e,od,d),o(e,pe,d),o(e,ld,d),o(e,fe,d),o(e,rd,d),o(e,id,d),o(e,ad,d),o(e,he,d),o(e,nd,d),p(_e,e,d),o(e,ud,d),o(e,be,d),o(e,sd,d),o(e,ge,d),o(e,cd,d),o(e,ve,d),o(e,md,d),o(e,pd,d),o(e,fd,d),o(e,Te,d),o(e,hd,d),p(ye,e,d),o(e,_d,d),o(e,we,d),o(e,bd,d),o(e,$e,d),o(e,gd,d),o(e,vd,d),o(e,Td,d),o(e,xe,d),o(e,yd,d),p(He,e,d),o(e,wd,d),o(e,qe,d),o(e,$d,d),o(e,Le,d),o(e,xd,d),o(e,Me,d),o(e,Hd,d),o(e,qd,d),o(e,Ld,d),o(e,Ce,d),o(e,Md,d),p(Ae,e,d),o(e,Cd,d),o(e,Pe,d),o(e,Ad,d),o(e,ze,d),o(e,Pd,d),o(e,ke,d),o(e,zd,d),o(e,Fe,d),o(e,kd,d),o(e,Fd,d),o(e,Rd,d),o(e,Re,d),o(e,Ed,d),p(Ee,e,d),o(e,Bd,d),o(e,Be,d),o(e,Dd,d),o(e,De,d),o(e,Id,d),o(e,Ie,d),o(e,jd,d),o(e,je,d),o(e,Kd,d),o(e,Ke,d),o(e,Sd,d),o(e,Od,d),o(e,Nd,d),o(e,Oe,d),Ud=!0},p:So,i(e){Ud||(f(T.$$.fragment,e),f(H.$$.fragment,e),f(A.$$.fragment,e),f(k.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(X.$$.fragment,e),f(de.$$.fragment,e),f(ie.$$.fragment,e),f(se.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),f(He.$$.fragment,e),f(Ae.$$.fragment,e),f(Ee.$$.fragment,e),Ud=!0)},o(e){h(T.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(k.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(X.$$.fragment,e),h(de.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),h(He.$$.fragment,e),h(Ae.$$.fragment,e),h(Ee.$$.fragment,e),Ud=!1},d(e){e&&(t(Ne),t(Se),t(Ue),t(v),t(Ge),t(We),t(y),t(Je),t(w),t(Qe),t($),t(Ve),t(Xe),t(Ye),t(x),t(Ze),t(et),t(q),t(tt),t(L),t(dt),t(M),t(ot),t(lt),t(rt),t(C),t(it),t(at),t(P),t(nt),t(ut),t(st),t(z),t(ct),t(mt),t(F),t(pt),t(R),t(ft),t(E),t(ht),t(_t),t(bt),t(B),t(gt),t(vt),t(I),t(Tt),t(j),t(yt),t(K),t(wt),t($t),t(xt),t(S),t(Ht),t(qt),t(N),t(Lt),t(U),t(Mt),t(G),t(Ct),t(W),t(At),t(J),t(Pt),t(Q),t(zt),t(kt),t(Ft),t(V),t(Rt),t(Et),t(Y),t(Bt),t(Z),t(Dt),t(ee),t(It),t(jt),t(Kt),t(te),t(St),t(Ot),t(oe),t(Nt),t(le),t(Ut),t(Gt),t(Wt),t(re),t(Jt),t(Qt),t(ae),t(Vt),t(ne),t(Xt),t(Yt),t(Zt),t(ue),t(ed),t(td),t(ce),t(dd),t(me),t(od),t(pe),t(ld),t(fe),t(rd),t(id),t(ad),t(he),t(nd),t(ud),t(be),t(sd),t(ge),t(cd),t(ve),t(md),t(pd),t(fd),t(Te),t(hd),t(_d),t(we),t(bd),t($e),t(gd),t(vd),t(Td),t(xe),t(yd),t(wd),t(qe),t($d),t(Le),t(xd),t(Me),t(Hd),t(qd),t(Ld),t(Ce),t(Md),t(Cd),t(Pe),t(Ad),t(ze),t(Pd),t(ke),t(zd),t(Fe),t(kd),t(Fd),t(Rd),t(Re),t(Ed),t(Bd),t(Be),t(Dd),t(De),t(Id),t(Ie),t(jd),t(je),t(Kd),t(Ke),t(Sd),t(Od),t(Nd),t(Oe)),t(g),_(T,e),_(H,e),_(A,e),_(k,e),_(D,e),_(O,e),_(X,e),_(de,e),_(ie,e),_(se,e),_(_e,e),_(ye,e),_(He,e),_(Ae,e),_(Ee,e)}}}const Qo='{"title":"utils/audio","local":"utilsaudio","sections":[{"title":"utils/audio.read_audio(url, sampling_rate) ⇒ <code> Promise. < Float32Array > </code>","local":"utilsaudioreadaudiourl-samplingrate--code-promise--float32array--code","sections":[{"title":"read_audio~audio : <code> Float32Array </code>","local":"readaudioaudio--code-float32array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/audio.hanning(M) ⇒ <code> Float64Array </code>","local":"utilsaudiohanningm--code-float64array-code","sections":[],"depth":2},{"title":"utils/audio.mel_filter_bank(num_frequency_bins, num_mel_filters, min_frequency, max_frequency, sampling_rate, [norm], [mel_scale], [triangularize_in_mel_space]) ⇒ <code> Array. < Array < number > > </code>","local":"utilsaudiomelfilterbanknumfrequencybins-nummelfilters-minfrequency-maxfrequency-samplingrate-norm-melscale-triangularizeinmelspace--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/audio.spectrogram(waveform, window, frame_length, hop_length, options) ⇒ <code> Object </code>","local":"utilsaudiospectrogramwaveform-window-framelength-hoplength-options--code-object-code","sections":[],"depth":2},{"title":"utils/audio.window_function(window_length, name, options) ⇒ <code> Float64Array </code>","local":"utilsaudiowindowfunctionwindowlength-name-options--code-float64array-code","sections":[],"depth":2},{"title":"utils/audio~hertz_to_mel(freq, [mel_scale]) ⇒ <code> T </code>","local":"utilsaudiohertztomelfreq-melscale--code-t-code","sections":[],"depth":2},{"title":"utils/audio~mel_to_hertz(mels, [mel_scale]) ⇒ <code> T </code>","local":"utilsaudiomeltohertzmels-melscale--code-t-code","sections":[],"depth":2},{"title":"utils/audio~_create_triangular_filter_bank(fft_freqs, filter_freqs) ⇒ <code> Array. < Array < number > > </code>","local":"utilsaudiocreatetriangularfilterbankfftfreqs-filterfreqs--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/audio~linspace(start, end, num) ⇒","local":"utilsaudiolinspacestart-end-num-","sections":[],"depth":2},{"title":"utils/audio~padReflect(array, left, right) ⇒ <code> T </code>","local":"utilsaudiopadreflectarray-left-right--code-t-code","sections":[],"depth":2},{"title":"utils/audio~_db_conversion_helper(spectrogram, factor, reference, min_value, db_range) ⇒ <code> T </code>","local":"utilsaudiodbconversionhelperspectrogram-factor-reference-minvalue-dbrange--code-t-code","sections":[],"depth":2},{"title":"utils/audio~amplitude_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>","local":"utilsaudioamplitudetodbspectrogram-reference-minvalue-dbrange--code-t-code","sections":[],"depth":2},{"title":"utils/audio~power_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>","local":"utilsaudiopowertodbspectrogram-reference-minvalue-dbrange--code-t-code","sections":[],"depth":2}],"depth":1}';function Vo(Gd){return Oo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends No{constructor(g){super(),Uo(this,g,Vo,Jo,Ko,{})}}export{el as component};
