import{s as Ql,n as Vl,o as Fl}from"../chunks/scheduler.6062bdaf.js";import{S as Nl,i as Ll,g as i,s,r as p,A as zl,h as o,f as t,c as n,j as Rl,u as c,x as r,k as pl,y as ql,a,v as M,d,t as h,w as m}from"../chunks/index.4bca734e.js";import{C as ce}from"../chunks/CodeBlock.fa01571c.js";import{H as u}from"../chunks/Heading.723dceba.js";function Pl(cl){let y,he,Me,me,f,ue,b,Ml=`The Hugging Face Hub makes hosting and sharing models with the community easy. It supports
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">dozens of libraries</a> in the Open Source ecosystem. We are always
working on expanding this support to push collaborative Machine Learning forward. The <code>huggingface_hub</code> library plays a
key role in this process, allowing any Python script to easily push and load files.`,ye,j,dl="There are four main ways to integrate a library with the Hub:",we,J,hl=`<li><strong>Push to Hub:</strong> implement a method to upload a model to the Hub. This includes the model weights, as well as
<a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">the model card</a> and any other relevant information
or data necessary to run the model (for example, training logs). This method is often called <code>push_to_hub()</code>.</li> <li><strong>Download from Hub:</strong> implement a method to load a model from the Hub. The method should download the model
configuration/weights and load the model. This method is often called <code>from_pretrained</code> or <code>load_from_hub()</code>.</li> <li><strong>Inference API:</strong> use our servers to run inference on models supported by your library for free.</li> <li><strong>Widgets:</strong> display a widget on the landing page of your models on the Hub. It allows users to quickly try a model
from the browser.</li>`,Te,g,ml=`In this guide, we will focus on the first two topics. We will present the two main approaches you can use to integrate
a library, with their advantages and drawbacks. Everything is summarized at the end of the guide to help you choose
between the two. Please keep in mind that these are only guidelines that you are free to adapt to you requirements.`,fe,U,ul=`If you are interested in Inference and Widgets, you can follow <a href="https://huggingface.co/docs/hub/models-adding-libraries#set-up-the-inference-api" rel="nofollow">this guide</a>.
In both cases, you can reach out to us if you are integrating a library with the Hub and want to be listed
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">in our docs</a>.`,be,_,je,I,yl=`The first approach to integrate a library to the Hub is to actually implement the <code>push_to_hub</code> and <code>from_pretrained</code>
methods by yourself. This gives you full flexibility on which files you need to upload/download and how to handle inputs
specific to your framework. You can refer to the two <a href="./upload">upload files</a> and <a href="./download">download files</a> guides
to learn more about how to do that. This is, for example how the FastAI integration is implemented (see <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.push_to_hub_fastai">push_to_hub_fastai()</a>
and <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.from_pretrained_fastai">from_pretrained_fastai()</a>).`,Je,C,wl="Implementation can differ between libraries, but the workflow is often similar.",ge,v,Ue,k,Tl="This is how a <code>from_pretrained</code> method usually look like:",_e,A,Ie,x,Ce,B,fl=`The <code>push_to_hub</code> method often requires a bit more complexity to handle repo creation, generate the model card and save weights.
A common approach is to save all of these files in a temporary folder, upload it and then delete it.`,ve,Z,ke,H,bl=`This is of course only an example. If you are interested in more complex manipulations (delete remote files, upload
weights on the fly, persist weights locally, etc.) please refer to the <a href="./upload">upload files</a> guide.`,Ae,G,xe,E,jl=`While being flexible, this approach has some drawbacks, especially in terms of maintenance. Hugging Face users are often
used to additional features when working with <code>huggingface_hub</code>. For example, when loading files from the Hub, it is
common to offer parameters like:`,Be,W,Jl="<li><code>token</code>: to download from a private repo</li> <li><code>revision</code>: to download from a specific branch</li> <li><code>cache_dir</code>: to cache files in a specific directory</li> <li><code>force_download</code>/<code>resume_download</code>/<code>local_files_only</code>: to reuse the cache or not</li> <li><code>proxies</code>: configure HTTP session</li>",Ze,X,gl="When pushing models, similar parameters are supported:",He,$,Ul="<li><code>commit_message</code>: custom commit message</li> <li><code>private</code>: create a private repo if missing</li> <li><code>create_pr</code>: create a PR instead of pushing to <code>main</code></li> <li><code>branch</code>: push to a branch instead of the <code>main</code> branch</li> <li><code>allow_patterns</code>/<code>ignore_patterns</code>: filter which files to upload</li> <li><code>token</code></li> <li>…</li>",Ge,Y,_l=`All of these parameters can be added to the implementations we saw above and passed to the <code>huggingface_hub</code> methods.
However, if a parameter changes or a new feature is added, you will need to update your package. Supporting those
parameters also means more documentation to maintain on your side. To see how to mitigate these limitations, let’s jump
to our next section <strong>class inheritance</strong>.`,Ee,S,We,R,Il=`As we saw above, there are two main methods to include in your library to integrate it with the Hub: upload files
(<code>push_to_hub</code>) and download files (<code>from_pretrained</code>). You can implement those methods by yourself but it comes with
caveats. To tackle this, <code>huggingface_hub</code> provides a tool that uses class inheritance. Let’s see how it works!`,Xe,Q,Cl=`In a lot of cases, a library already implements its model using a Python class. The class contains the properties of
the model and methods to load, run, train, and evaluate it. Our approach is to extend this class to include upload and
download features using mixins. A <a href="https://stackoverflow.com/a/547714" rel="nofollow">Mixin</a> is a class that is meant to extend an
existing class with a set of specific features using multiple inheritance. <code>huggingface_hub</code> provides its own mixin,
the <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>. The key here is to understand its behavior and how to customize it.`,$e,V,vl=`The <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> class implements 3 <em>public</em> methods (<code>push_to_hub</code>, <code>save_pretrained</code> and <code>from_pretrained</code>). Those
are the methods that your users will call to load/save models with your library. <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> also defines 2
<em>private</em> methods (<code>_save_pretrained</code> and <code>_from_pretrained</code>). Those are the ones you must implement. So to integrate
your library, you should:`,Ye,F,kl=`<li>Make your Model class inherit from <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>.</li> <li>Implement the private methods:<ul><li><a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin._save_pretrained">_save_pretrained()</a>: method taking as input a path to a directory and saving the model to it.
You must write all the logic to dump your model in this method: model card, model weights, configuration files,
training logs, and figures. Any relevant information for this model must be handled by this method.
<a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">Model Cards</a> are particularly important to describe your model. Check
out <a href="./model-cards">our implementation guide</a> for more details.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin._from_pretrained">_from_pretrained()</a>: <strong>class method</strong> taking as input a <code>model_id</code> and returning an instantiated
model. The method must download the relevant files and load them.</li></ul></li> <li>You are done!</li>`,Se,N,Al='The advantage of using <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> is that once you take care of the serialization/loading of the files, you are ready to go. You don’t need to worry about stuff like repo creation, commits, PRs, or revisions. All of this is handled by the mixin and is available to your users. The Mixin also ensures that public methods are well documented and type annotated.',Re,L,xl='As a bonus, <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> handles the model configuration for you. If your <code>__init__</code> method expects a <code>config</code> input, it will be automatically saved in the repo when calling <code>save_pretrained</code> and reloaded correctly by <code>load_pretrained</code>. Moreover, if the <code>config</code> input parameter is annotated with dataclass type (e.g. <code>config: Optional[MyConfigClass] = None</code>), then the <code>config</code> value will be correctly deserialized for you. Finally, all jsonable values passed at initialization will be also stored in the config file. This means you don’t necessarily have to expect a <code>config</code> input to benefit from it. The big advantage of having a <code>config.json</code> file in your model repository is that it automatically enables the analytics on the Hub (e.g. the “downloads” count).',Qe,z,Bl='Finally, <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> handles generating a model card for you. When inheriting from <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>, you can define metadata such as <code>library_name</code>, <code>tags</code>, <code>repo_url</code> and <code>docs_url</code>. Those fields will be reused to populate the modelcard of any model that use your class. This is very practical to make all models using your library easily searchable on the Hub and to provide some resource links for users landing on the Hub. If you want to extend the modelcard template, you can override the <code>generate_model_card()</code> method.',Ve,q,Fe,P,Zl='A good example of what we saw above is <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin">PyTorchModelHubMixin</a>, our integration for the PyTorch framework. This is a ready-to-use integration.',Ne,K,Le,D,Hl="Here is how any user can load/save a PyTorch model from/to the Hub:",ze,O,qe,ee,Pe,le,Gl='The implementation is actually very straightforward, and the full implementation can be found <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py" rel="nofollow">here</a>.',Ke,te,El="<li>First, inherit your class from <code>ModelHubMixin</code>:</li>",De,ae,Oe,w,Wl="<li>Implement the <code>_save_pretrained</code> method:</li>",el,se,ll,T,Xl="<li>Implement the <code>_from_pretrained</code> method:</li>",tl,ne,al,ie,$l="And that’s it! Your library now enables users to upload and download files to and from the Hub.",sl,oe,nl,re,Yl=`Let’s quickly sum up the two approaches we saw with their advantages and drawbacks. The table below is only indicative.
Your framework might have some specificities that you need to address. This guide is only here to give guidelines and
ideas on how to handle integration. In any case, feel free to contact us if you have any questions!`,il,pe,Sl='<thead><tr><th align="center">Integration</th> <th align="center">Using helpers</th> <th align="center">Using <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a></th></tr></thead> <tbody><tr><td align="center">User experience</td> <td align="center"><code>model = load_from_hub(...)</code><br/><code>push_to_hub(model, ...)</code></td> <td align="center"><code>model = MyModel.from_pretrained(...)</code><br/><code>model.push_to_hub(...)</code></td></tr> <tr><td align="center">Flexibility</td> <td align="center">Very flexible.<br/>You fully control the implementation.</td> <td align="center">Less flexible.<br/>Your framework must have a model class.</td></tr> <tr><td align="center">Maintenance</td> <td align="center">More maintenance to add support for configuration, and new features. Might also require fixing issues reported by users.</td> <td align="center">Less maintenance as most of the interactions with the Hub are implemented in <code>huggingface_hub</code>.</td></tr> <tr><td align="center">Documentation / Type annotation</td> <td align="center">To be written manually.</td> <td align="center">Partially handled by <code>huggingface_hub</code>.</td></tr> <tr><td align="center">Download counter</td> <td align="center">To be handled manually.</td> <td align="center">Enabled by default if class has a <code>config</code> attribute.</td></tr> <tr><td align="center">Model card</td> <td align="center">To be handled manually</td> <td align="center">Generated by default with library_name, tags, etc.</td></tr></tbody>',ol,de,rl;return f=new u({props:{title:"Integrate any ML framework with the Hub",local:"integrate-any-ml-framework-with-the-hub",headingTag:"h1"}}),_=new u({props:{title:"A flexible approach: helpers",local:"a-flexible-approach-helpers",headingTag:"h2"}}),v=new u({props:{title:"from_pretrained",local:"frompretrained",headingTag:"h3"}}),A=new ce({props:{code:"ZGVmJTIwZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTNBJTIwc3RyKSUyMC0lM0UlMjBNeU1vZGVsQ2xhc3MlM0ElMEElMjAlMjAlMjAlMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwZnJvbSUyMEh1YiUwQSUyMCUyMCUyMGNhY2hlZF9tb2RlbCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGZpbGVuYW1lJTNEJTIybW9kZWwucGtsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIyZmFzdGFpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV92ZXJzaW9uJTNEZ2V0X2Zhc3RhaV92ZXJzaW9uKCklMkMlMEElMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIzJTIwTG9hZCUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9hZF9tb2RlbChjYWNoZWRfbW9kZWwp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span></span>) -&gt; MyModelClass:
   <span class="hljs-comment"># Download model from Hub</span>
   cached_model = hf_hub_download(
      repo_id=repo_id,
      filename=<span class="hljs-string">&quot;model.pkl&quot;</span>,
      library_name=<span class="hljs-string">&quot;fastai&quot;</span>,
      library_version=get_fastai_version(),
   )

   <span class="hljs-comment"># Load model</span>
    <span class="hljs-keyword">return</span> load_model(cached_model)`,wrap:!1}}),x=new u({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),Z=new ce({props:{code:"ZGVmJTIwcHVzaF90b19odWIobW9kZWwlM0ElMjBNeU1vZGVsQ2xhc3MlMkMlMjByZXBvX25hbWUlM0ElMjBzdHIpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBhcGklMjAlM0QlMjBIZkFwaSgpJTBBJTBBJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwcmVwbyUyMGlmJTIwbm90JTIwZXhpc3RpbmclMjB5ZXQlMjBhbmQlMjBnZXQlMjB0aGUlMjBhc3NvY2lhdGVkJTIwcmVwb19pZCUwQSUyMCUyMCUyMHJlcG9faWQlMjAlM0QlMjBhcGkuY3JlYXRlX3JlcG8ocmVwb19uYW1lJTJDJTIwZXhpc3Rfb2slM0RUcnVlKSUwQSUwQSUyMCUyMCUyMCUyMyUyMFNhdmUlMjBhbGwlMjBmaWxlcyUyMGluJTIwYSUyMHRlbXBvcmFyeSUyMGRpcmVjdG9yeSUyMGFuZCUyMHB1c2glMjB0aGVtJTIwaW4lMjBhJTIwc2luZ2xlJTIwY29tbWl0JTBBJTIwJTIwJTIwd2l0aCUyMFRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBkaXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjB0bXBkaXIlMjAlM0QlMjBQYXRoKHRtcGRpciklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwd2VpZ2h0cyUwQSUyMCUyMCUyMCUyMCUyMCUyMHNhdmVfbW9kZWwobW9kZWwlMkMlMjB0bXBkaXIlMjAlMkYlMjAlMjJtb2RlbC5zYWZldGVuc29ycyUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHZW5lcmF0ZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhcmQlMjAlM0QlMjBnZW5lcmF0ZV9tb2RlbF9jYXJkKG1vZGVsKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCh0bXBkaXIlMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoY2FyZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwbG9ncyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFNhdmUlMjBmaWd1cmVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU2F2ZSUyMGV2YWx1YXRpb24lMjBtZXRyaWNzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUHVzaCUyMHRvJTIwaHViJTBBJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYXBpLnVwbG9hZF9mb2xkZXIocmVwb19pZCUzRHJlcG9faWQlMkMlMjBmb2xkZXJfcGF0aCUzRHRtcGRpcik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">model: MyModelClass, repo_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-literal">None</span>:
   api = HfApi()

   <span class="hljs-comment"># Create repo if not existing yet and get the associated repo_id</span>
   repo_id = api.create_repo(repo_name, exist_ok=<span class="hljs-literal">True</span>)

   <span class="hljs-comment"># Save all files in a temporary directory and push them in a single commit</span>
   <span class="hljs-keyword">with</span> TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
      tmpdir = Path(tmpdir)

      <span class="hljs-comment"># Save weights</span>
      save_model(model, tmpdir / <span class="hljs-string">&quot;model.safetensors&quot;</span>)

      <span class="hljs-comment"># Generate model card</span>
      card = generate_model_card(model)
      (tmpdir / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(card)

      <span class="hljs-comment"># Save logs</span>
      <span class="hljs-comment"># Save figures</span>
      <span class="hljs-comment"># Save evaluation metrics</span>
      <span class="hljs-comment"># ...</span>

      <span class="hljs-comment"># Push to hub</span>
      <span class="hljs-keyword">return</span> api.upload_folder(repo_id=repo_id, folder_path=tmpdir)`,wrap:!1}}),G=new u({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),S=new u({props:{title:"A more complex approach: class inheritance",local:"a-more-complex-approach-class-inheritance",headingTag:"h2"}}),q=new u({props:{title:"A concrete example: PyTorch",local:"a-concrete-example-pytorch",headingTag:"h3"}}),K=new u({props:{title:"How to use it?",local:"how-to-use-it",headingTag:"h4"}}),O=new ce({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin


<span class="hljs-comment"># Define your Pytorch model exactly the same way you are used to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(
<span class="hljs-meta">... </span>        nn.Module,
<span class="hljs-meta">... </span>        PyTorchModelHubMixin, <span class="hljs-comment"># multiple inheritance</span>
<span class="hljs-meta">... </span>        library_name=<span class="hljs-string">&quot;keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        tags=[<span class="hljs-string">&quot;keras&quot;</span>],
<span class="hljs-meta">... </span>        repo_url=<span class="hljs-string">&quot;https://github.com/keras-team/keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        docs_url=<span class="hljs-string">&quot;https://keras.io/keras_nlp/&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># ^ optional metadata to generate model card</span>
<span class="hljs-meta">... </span>    ):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, hidden_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>, vocab_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">30000</span>, output_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">4</span></span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(hidden_size, vocab_size))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(output_size, vocab_size)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)

<span class="hljs-comment"># 1. Create model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel(hidden_size=<span class="hljs-number">128</span>)

<span class="hljs-comment"># Config is automatically created based on input + default values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.param.shape[<span class="hljs-number">0</span>]
<span class="hljs-number">128</span>

<span class="hljs-comment"># 2. (optional) Save model to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;path/to/my-awesome-model&quot;</span>)

<span class="hljs-comment"># 3. Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># 4. Initialize model from the Hub =&gt; config has been preserved</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.param.shape[<span class="hljs-number">0</span>]
<span class="hljs-number">128</span>

<span class="hljs-comment"># Model card has been correctly populated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard
<span class="hljs-meta">&gt;&gt;&gt; </span>card = ModelCard.load(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.tags
[<span class="hljs-string">&quot;keras&quot;</span>, <span class="hljs-string">&quot;pytorch_model_hub_mixin&quot;</span>, <span class="hljs-string">&quot;model_hub_mixin&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.library_name
<span class="hljs-string">&quot;keras-nlp&quot;</span>`,wrap:!1}}),ee=new u({props:{title:"Implementation",local:"implementation",headingTag:"h4"}}),ae=new ce({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)`,wrap:!1}}),se=new ce({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLiklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjJTYXZlJTIwd2VpZ2h0cyUyMGZyb20lMjBhJTIwUHl0b3JjaCUyMG1vZGVsJTIwdG8lMjBhJTIwbG9jYWwlMjBkaXJlY3RvcnkuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2F2ZV9tb2RlbF9hc19zYWZldGVuc29yKHNlbGYubW9kdWxlJTJDJTIwc3RyKHNhdmVfZGlyZWN0b3J5JTIwJTJGJTIwU0FGRVRFTlNPUlNfU0lOR0xFX0ZJTEUpKSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-string">&quot;&quot;&quot;Save weights from a Pytorch model to a local directory.&quot;&quot;&quot;</span>
        save_model_as_safetensor(self.module, <span class="hljs-built_in">str</span>(save_directory / SAFETENSORS_SINGLE_FILE))
`,wrap:!1}}),ne=new ce({props:{code:"Y2xhc3MlMjBQeVRvcmNoTW9kZWxIdWJNaXhpbihNb2RlbEh1Yk1peGluKSUzQSUwQSUyMCUyMCUyMCguLi4pJTBBJTBBJTIwJTIwJTIwJTQwY2xhc3NtZXRob2QlMjAlMjMlMjBNdXN0JTIwYmUlMjBhJTIwY2xhc3NtZXRob2QhJTBBJTIwJTIwJTIwZGVmJTIwX2Zyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjBjbHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAqJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0ElMjBzdHIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjByZXZpc2lvbiUzQSUyMHN0ciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhY2hlX2RpciUzQSUyMHN0ciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGZvcmNlX2Rvd25sb2FkJTNBJTIwYm9vbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByb3hpZXMlM0ElMjBPcHRpb25hbCU1QkRpY3QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjByZXN1bWVfZG93bmxvYWQlM0ElMjBib29sJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbG9jYWxfZmlsZXNfb25seSUzQSUyMGJvb2wlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0b2tlbiUzQSUyMFVuaW9uJTVCc3RyJTJDJTIwYm9vbCUyQyUyME5vbmUlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBtYXBfbG9jYXRpb24lM0ElMjBzdHIlMjAlM0QlMjAlMjJjcHUlMjIlMkMlMjAlMjMlMjBhZGRpdGlvbmFsJTIwYXJndW1lbnQlMEElMjAlMjAlMjAlMjAlMjAlMjBzdHJpY3QlM0ElMjBib29sJTIwJTNEJTIwRmFsc2UlMkMlMjAlMjMlMjBhZGRpdGlvbmFsJTIwYXJndW1lbnQlMEElMjAlMjAlMjAlMjAlMjAlMjAqKm1vZGVsX2t3YXJncyUyQyUwQSUyMCUyMCUyMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjJMb2FkJTIwUHl0b3JjaCUyMHByZXRyYWluZWQlMjB3ZWlnaHRzJTIwYW5kJTIwcmV0dXJuJTIwdGhlJTIwbG9hZGVkJTIwbW9kZWwuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBjbHMoKiptb2RlbF9rd2FyZ3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBvcy5wYXRoLmlzZGlyKG1vZGVsX2lkKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMkxvYWRpbmclMjB3ZWlnaHRzJTIwZnJvbSUyMGxvY2FsJTIwZGlyZWN0b3J5JTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX2ZpbGUlMjAlM0QlMjBvcy5wYXRoLmpvaW4obW9kZWxfaWQlMkMlMjBTQUZFVEVOU09SU19TSU5HTEVfRklMRSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBjbHMuX2xvYWRfYXNfc2FmZXRlbnNvcihtb2RlbCUyQyUyMG1vZGVsX2ZpbGUlMkMlMjBtYXBfbG9jYXRpb24lMkMlMjBzdHJpY3QpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfZmlsZSUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaWxlbmFtZSUzRFNBRkVURU5TT1JTX1NJTkdMRV9GSUxFJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV2aXNpb24lM0RyZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhY2hlX2RpciUzRGNhY2hlX2RpciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvcmNlX2Rvd25sb2FkJTNEZm9yY2VfZG93bmxvYWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm94aWVzJTNEcHJveGllcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3VtZV9kb3dubG9hZCUzRHJlc3VtZV9kb3dubG9hZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuJTNEdG9rZW4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2NhbF9maWxlc19vbmx5JTNEbG9jYWxfZmlsZXNfb25seSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBjbHMuX2xvYWRfYXNfc2FmZXRlbnNvcihtb2RlbCUyQyUyMG1vZGVsX2ZpbGUlMkMlMjBtYXBfbG9jYXRpb24lMkMlMjBzdHJpY3Qp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

<span class="hljs-meta">   @classmethod </span><span class="hljs-comment"># Must be a classmethod!</span>
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_from_pretrained</span>(<span class="hljs-params">
      cls,
      *,
      model_id: <span class="hljs-built_in">str</span>,
      revision: <span class="hljs-built_in">str</span>,
      cache_dir: <span class="hljs-built_in">str</span>,
      force_download: <span class="hljs-built_in">bool</span>,
      proxies: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>],
      resume_download: <span class="hljs-built_in">bool</span>,
      local_files_only: <span class="hljs-built_in">bool</span>,
      token: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>, <span class="hljs-literal">None</span>],
      map_location: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-comment"># additional argument</span>
      strict: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>, <span class="hljs-comment"># additional argument</span>
      **model_kwargs,
   </span>):
      <span class="hljs-string">&quot;&quot;&quot;Load Pytorch pretrained weights and return the loaded model.&quot;&quot;&quot;</span>
        model = cls(**model_kwargs)
        <span class="hljs-keyword">if</span> os.path.isdir(model_id):
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading weights from local directory&quot;</span>)
            model_file = os.path.join(model_id, SAFETENSORS_SINGLE_FILE)
            <span class="hljs-keyword">return</span> cls._load_as_safetensor(model, model_file, map_location, strict)

         model_file = hf_hub_download(
            repo_id=model_id,
            filename=SAFETENSORS_SINGLE_FILE,
            revision=revision,
            cache_dir=cache_dir,
            force_download=force_download,
            proxies=proxies,
            resume_download=resume_download,
            token=token,
            local_files_only=local_files_only,
            )
         <span class="hljs-keyword">return</span> cls._load_as_safetensor(model, model_file, map_location, strict)`,wrap:!1}}),oe=new u({props:{title:"Quick comparison",local:"quick-comparison",headingTag:"h2"}}),{c(){y=i("meta"),he=s(),Me=i("p"),me=s(),p(f.$$.fragment),ue=s(),b=i("p"),b.innerHTML=Ml,ye=s(),j=i("p"),j.textContent=dl,we=s(),J=i("ol"),J.innerHTML=hl,Te=s(),g=i("p"),g.textContent=ml,fe=s(),U=i("p"),U.innerHTML=ul,be=s(),p(_.$$.fragment),je=s(),I=i("p"),I.innerHTML=yl,Je=s(),C=i("p"),C.textContent=wl,ge=s(),p(v.$$.fragment),Ue=s(),k=i("p"),k.innerHTML=Tl,_e=s(),p(A.$$.fragment),Ie=s(),p(x.$$.fragment),Ce=s(),B=i("p"),B.innerHTML=fl,ve=s(),p(Z.$$.fragment),ke=s(),H=i("p"),H.innerHTML=bl,Ae=s(),p(G.$$.fragment),xe=s(),E=i("p"),E.innerHTML=jl,Be=s(),W=i("ul"),W.innerHTML=Jl,Ze=s(),X=i("p"),X.textContent=gl,He=s(),$=i("ul"),$.innerHTML=Ul,Ge=s(),Y=i("p"),Y.innerHTML=_l,Ee=s(),p(S.$$.fragment),We=s(),R=i("p"),R.innerHTML=Il,Xe=s(),Q=i("p"),Q.innerHTML=Cl,$e=s(),V=i("p"),V.innerHTML=vl,Ye=s(),F=i("ol"),F.innerHTML=kl,Se=s(),N=i("p"),N.innerHTML=Al,Re=s(),L=i("p"),L.innerHTML=xl,Qe=s(),z=i("p"),z.innerHTML=Bl,Ve=s(),p(q.$$.fragment),Fe=s(),P=i("p"),P.innerHTML=Zl,Ne=s(),p(K.$$.fragment),Le=s(),D=i("p"),D.textContent=Hl,ze=s(),p(O.$$.fragment),qe=s(),p(ee.$$.fragment),Pe=s(),le=i("p"),le.innerHTML=Gl,Ke=s(),te=i("ol"),te.innerHTML=El,De=s(),p(ae.$$.fragment),Oe=s(),w=i("ol"),w.innerHTML=Wl,el=s(),p(se.$$.fragment),ll=s(),T=i("ol"),T.innerHTML=Xl,tl=s(),p(ne.$$.fragment),al=s(),ie=i("p"),ie.textContent=$l,sl=s(),p(oe.$$.fragment),nl=s(),re=i("p"),re.textContent=Yl,il=s(),pe=i("table"),pe.innerHTML=Sl,ol=s(),de=i("p"),this.h()},l(e){const l=zl("svelte-u9bgzb",document.head);y=o(l,"META",{name:!0,content:!0}),l.forEach(t),he=n(e),Me=o(e,"P",{}),Rl(Me).forEach(t),me=n(e),c(f.$$.fragment,e),ue=n(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-uvt37o"&&(b.innerHTML=Ml),ye=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-14vdlq5"&&(j.textContent=dl),we=n(e),J=o(e,"OL",{"data-svelte-h":!0}),r(J)!=="svelte-14btp4x"&&(J.innerHTML=hl),Te=n(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1tx4sul"&&(g.textContent=ml),fe=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-10f3yyh"&&(U.innerHTML=ul),be=n(e),c(_.$$.fragment,e),je=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-r9ojoj"&&(I.innerHTML=yl),Je=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1g2giur"&&(C.textContent=wl),ge=n(e),c(v.$$.fragment,e),Ue=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-bozc1x"&&(k.innerHTML=Tl),_e=n(e),c(A.$$.fragment,e),Ie=n(e),c(x.$$.fragment,e),Ce=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-7bmo7d"&&(B.innerHTML=fl),ve=n(e),c(Z.$$.fragment,e),ke=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-15vgu12"&&(H.innerHTML=bl),Ae=n(e),c(G.$$.fragment,e),xe=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-tzwehq"&&(E.innerHTML=jl),Be=n(e),W=o(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-6gcvoy"&&(W.innerHTML=Jl),Ze=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-3m9y73"&&(X.textContent=gl),He=n(e),$=o(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-30swpt"&&($.innerHTML=Ul),Ge=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-p8rs76"&&(Y.innerHTML=_l),Ee=n(e),c(S.$$.fragment,e),We=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1uvlinw"&&(R.innerHTML=Il),Xe=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-qqd3b3"&&(Q.innerHTML=Cl),$e=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1e60xo5"&&(V.innerHTML=vl),Ye=n(e),F=o(e,"OL",{"data-svelte-h":!0}),r(F)!=="svelte-1czklek"&&(F.innerHTML=kl),Se=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-w3dr5e"&&(N.innerHTML=Al),Re=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-a35nta"&&(L.innerHTML=xl),Qe=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1c6qrpw"&&(z.innerHTML=Bl),Ve=n(e),c(q.$$.fragment,e),Fe=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-ua16f3"&&(P.innerHTML=Zl),Ne=n(e),c(K.$$.fragment,e),Le=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-l2ktl8"&&(D.textContent=Hl),ze=n(e),c(O.$$.fragment,e),qe=n(e),c(ee.$$.fragment,e),Pe=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-l2iz9k"&&(le.innerHTML=Gl),Ke=n(e),te=o(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-1a9vqht"&&(te.innerHTML=El),De=n(e),c(ae.$$.fragment,e),Oe=n(e),w=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(w)!=="svelte-mclxy5"&&(w.innerHTML=Wl),el=n(e),c(se.$$.fragment,e),ll=n(e),T=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(T)!=="svelte-1vfuaub"&&(T.innerHTML=Xl),tl=n(e),c(ne.$$.fragment,e),al=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-zuw9zy"&&(ie.textContent=$l),sl=n(e),c(oe.$$.fragment,e),nl=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1qi11kl"&&(re.textContent=Yl),il=n(e),pe=o(e,"TABLE",{"data-svelte-h":!0}),r(pe)!=="svelte-17o2ar3"&&(pe.innerHTML=Sl),ol=n(e),de=o(e,"P",{}),Rl(de).forEach(t),this.h()},h(){pl(y,"name","hf:doc:metadata"),pl(y,"content",Kl),pl(w,"start","2"),pl(T,"start","3")},m(e,l){ql(document.head,y),a(e,he,l),a(e,Me,l),a(e,me,l),M(f,e,l),a(e,ue,l),a(e,b,l),a(e,ye,l),a(e,j,l),a(e,we,l),a(e,J,l),a(e,Te,l),a(e,g,l),a(e,fe,l),a(e,U,l),a(e,be,l),M(_,e,l),a(e,je,l),a(e,I,l),a(e,Je,l),a(e,C,l),a(e,ge,l),M(v,e,l),a(e,Ue,l),a(e,k,l),a(e,_e,l),M(A,e,l),a(e,Ie,l),M(x,e,l),a(e,Ce,l),a(e,B,l),a(e,ve,l),M(Z,e,l),a(e,ke,l),a(e,H,l),a(e,Ae,l),M(G,e,l),a(e,xe,l),a(e,E,l),a(e,Be,l),a(e,W,l),a(e,Ze,l),a(e,X,l),a(e,He,l),a(e,$,l),a(e,Ge,l),a(e,Y,l),a(e,Ee,l),M(S,e,l),a(e,We,l),a(e,R,l),a(e,Xe,l),a(e,Q,l),a(e,$e,l),a(e,V,l),a(e,Ye,l),a(e,F,l),a(e,Se,l),a(e,N,l),a(e,Re,l),a(e,L,l),a(e,Qe,l),a(e,z,l),a(e,Ve,l),M(q,e,l),a(e,Fe,l),a(e,P,l),a(e,Ne,l),M(K,e,l),a(e,Le,l),a(e,D,l),a(e,ze,l),M(O,e,l),a(e,qe,l),M(ee,e,l),a(e,Pe,l),a(e,le,l),a(e,Ke,l),a(e,te,l),a(e,De,l),M(ae,e,l),a(e,Oe,l),a(e,w,l),a(e,el,l),M(se,e,l),a(e,ll,l),a(e,T,l),a(e,tl,l),M(ne,e,l),a(e,al,l),a(e,ie,l),a(e,sl,l),M(oe,e,l),a(e,nl,l),a(e,re,l),a(e,il,l),a(e,pe,l),a(e,ol,l),a(e,de,l),rl=!0},p:Vl,i(e){rl||(d(f.$$.fragment,e),d(_.$$.fragment,e),d(v.$$.fragment,e),d(A.$$.fragment,e),d(x.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(S.$$.fragment,e),d(q.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),rl=!0)},o(e){h(f.$$.fragment,e),h(_.$$.fragment,e),h(v.$$.fragment,e),h(A.$$.fragment,e),h(x.$$.fragment,e),h(Z.$$.fragment,e),h(G.$$.fragment,e),h(S.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),rl=!1},d(e){e&&(t(he),t(Me),t(me),t(ue),t(b),t(ye),t(j),t(we),t(J),t(Te),t(g),t(fe),t(U),t(be),t(je),t(I),t(Je),t(C),t(ge),t(Ue),t(k),t(_e),t(Ie),t(Ce),t(B),t(ve),t(ke),t(H),t(Ae),t(xe),t(E),t(Be),t(W),t(Ze),t(X),t(He),t($),t(Ge),t(Y),t(Ee),t(We),t(R),t(Xe),t(Q),t($e),t(V),t(Ye),t(F),t(Se),t(N),t(Re),t(L),t(Qe),t(z),t(Ve),t(Fe),t(P),t(Ne),t(Le),t(D),t(ze),t(qe),t(Pe),t(le),t(Ke),t(te),t(De),t(Oe),t(w),t(el),t(ll),t(T),t(tl),t(al),t(ie),t(sl),t(nl),t(re),t(il),t(pe),t(ol),t(de)),t(y),m(f,e),m(_,e),m(v,e),m(A,e),m(x,e),m(Z,e),m(G,e),m(S,e),m(q,e),m(K,e),m(O,e),m(ee,e),m(ae,e),m(se,e),m(ne,e),m(oe,e)}}}const Kl='{"title":"Integrate any ML framework with the Hub","local":"integrate-any-ml-framework-with-the-hub","sections":[{"title":"A flexible approach: helpers","local":"a-flexible-approach-helpers","sections":[{"title":"from_pretrained","local":"frompretrained","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"A more complex approach: class inheritance","local":"a-more-complex-approach-class-inheritance","sections":[{"title":"A concrete example: PyTorch","local":"a-concrete-example-pytorch","sections":[{"title":"How to use it?","local":"how-to-use-it","sections":[],"depth":4},{"title":"Implementation","local":"implementation","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Quick comparison","local":"quick-comparison","sections":[],"depth":2}],"depth":1}';function Dl(cl){return Fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class at extends Nl{constructor(y){super(),Ll(this,y,Dl,Pl,Ql,{})}}export{at as component};
