import{s as Wh,o as Gh,n as J}from"../chunks/scheduler.6062bdaf.js";import{S as Bh,i as Qh,g,s as r,r as h,A as Vh,h as m,f as u,c as i,j as v,u as d,x as I,k,y as l,a as _,v as f,d as y,t as M,w as b}from"../chunks/index.4bca734e.js";import{T as G}from"../chunks/Tip.b9ac1f03.js";import{D as A}from"../chunks/Docstring.81ba5e3c.js";import{C as x}from"../chunks/CodeBlock.fa01571c.js";import{E as $}from"../chunks/ExampleCodeBlock.30e7542f.js";import{H as _r,E as Sh}from"../chunks/EditOnGithub.74ab2baa.js";function Yh(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function zh(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBYXVkaW9fb3V0cHV0JTIwJTNEJTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBZm9yJTIwaSUyQyUyMGl0ZW0lMjBpbiUyMGVudW1lcmF0ZShhdWRpb19vdXRwdXQpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oZiUyMm91dHB1dF8lN0JpJTdELmZsYWMlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0E=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Rh(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Xh(T){let n,p=`The <code>client.chat_completion</code> method is aliased as <code>client.chat.completions.create</code> for compatibility with OpenAI’s client.
Inputs and outputs are strictly the same and using either syntax will yield the same results.
Check out the <a href="https://huggingface.co/docs/huggingface_hub/guides/inference#openai-compatibility" rel="nofollow">Inference guide</a>
for more details about OpenAI’s compatibility.`;return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-9iksi9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function Dh(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Fh(T){let n,p="Example using streaming:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBZm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBtYXhfdG9rZW5zJTNEMTAlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1mc18uw"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Hh(T){let n,p="Example using OpenAI’s syntax:",a,t,o;return t=new x({props:{code:"JTIzJTIwaW5zdGVhZCUyMG9mJTIwJTYwZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSU2MCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnQlMEElMEElMjMlMjBpbnN0ZWFkJTIwb2YlMjAlNjBjbGllbnQlMjAlM0QlMjBPcGVuQUkoLi4uKSU2MCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QuLi4lMkMlMEEpJTBBJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDb3VudCUyMHRvJTIwMTAlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEwMjQlMkMlMEEpJTBBJTBBZm9yJTIwY2h1bmslMjBpbiUyMG91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQp",highlighted:`<span class="hljs-comment"># instead of \`from openai import OpenAI\`</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># instead of \`client = OpenAI(...)\`</span>
client = InferenceClient(
    base_url=...,
    api_key=...,
)

output = client.chat.completions.create(
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-i0a0yp"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Oh(T){let n,p="Example using Image + Text as input:",a,t,o;return t=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># provide a remote URL</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url =<span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>
<span class="hljs-comment"># or a base64-encoded image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_path = <span class="hljs-string">&quot;/path/to/image.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(image_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    base64_image = base64.b64encode(f.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">f&quot;data:image/jpeg;base64,<span class="hljs-subst">{base64_image}</span>&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = client.chat.completions.create(
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: image_url},
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image in one sentence.&quot;</span>,
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>            ],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
The image depicts the iconic Statue of Liberty situated <span class="hljs-keyword">in</span> New York Harbor, New York, on a clear day.`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1e6ij9p"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Lh(T){let n,p="Example using tools:",a,t,o;return t=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1ksikbz"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Ph(T){let n,p="Example using response_format:",a,t,o;return t=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park. What did I saw and when?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response_format = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    response_format=response_format,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.content
<span class="hljs-string">&#x27;{

y&quot;: &quot;bike ride&quot;,
&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;],
_seen&quot;: 3,
n&quot;: &quot;park&quot;}&#x27;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1klcxsv"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Kh(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9999666213989258</span>, start=<span class="hljs-number">16</span>, words=<span class="hljs-literal">None</span>)]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function ed(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function nd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function td(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEFjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function sd(T){let n,p=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1igz3dx"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function ad(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_model_status(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function ld(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwcyUzQSUyRiUyRmp6Z3UwYnVlaTUudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMjIpJTBBY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function od(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>, score=<span class="hljs-number">0.9779096841812134</span>), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function rd(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function id(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function cd(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function pd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function ud(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFjbGllbnQuaW1hZ2VfdG9fdGV4dCglMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function gd(T){let n,p=`This endpoint method does not return a live list of all models available for the Serverless Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-jcsy1z"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function md(T){let n,p=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-ygzr4s"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function hd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBbW9kZWxzJTIwJTNEJTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFjbGllbnQubGlzdF9kZXBsb3llZF9tb2RlbHMoJTIydGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function dd(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function fd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>)
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function yd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;Clara&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9326565265655518</span>, start=<span class="hljs-number">11</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Md(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function bd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function jd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcXVlcnklMjAlM0QlMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMEF0YWJsZSUyMCUzRCUyMCU3QiUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlN0QlMEFjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function _d(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMkMlMEElN0QlMEFjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Td(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJIZWlnaHQlMjIlM0ElMjAlNUIlMjIxMS41MiUyMiUyQyUyMCUyMjEyLjQ4JTIyJTJDJTIwJTIyMTIuMzc3OCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDElMjIlM0ElMjAlNUIlMjIyMy4yJTIyJTJDJTIwJTIyMjQlMjIlMkMlMjAlMjIyMy45JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMiUyMiUzQSUyMCU1QiUyMjI1LjQlMjIlMkMlMjAlMjIyNi4zJTIyJTJDJTIwJTIyMjYuNSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDMlMjIlM0ElMjAlNUIlMjIzMCUyMiUyQyUyMCUyMjMxLjIlMjIlMkMlMjAlMjIzMS4xJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyU3BlY2llcyUyMiUzQSUyMCU1QiUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMldpZHRoJTIyJTNBJTIwJTVCJTIyNC4wMiUyMiUyQyUyMCUyMjQuMzA1NiUyMiUyQyUyMCUyMjQuNjk2MSUyMiU1RCUyQyUwQSU3RCUwQWNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Id(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Jd(T){let n,p=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-gq0ddh"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function wd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function xd(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function Cd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIybG93JTIwcmVzb2x1dGlvbiUyQyUyMGJsdXJyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmJldHRlcl9hc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Ud(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBYXVkaW8lMjAlM0QlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function $d(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function vd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWNsaWVudC50cmFuc2xhdGlvbiglMjJNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiUyMiUyQyUyMG1vZGVsJTNEJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1mciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function kd(T){let n,p="Specifying languages:",a,t,o;return t=new x({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-mhcj6c"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function qd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Ad(T){let n,p="Example with <code>multi_label=False</code>:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGV4dCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJBJTIwbmV3JTIwbW9kZWwlMjBvZmZlcnMlMjBhbiUyMGV4cGxhbmF0aW9uJTIwZm9yJTIwaG93JTIwdGhlJTIwR2FsaWxlYW4lMjBzYXRlbGxpdGVzJTIwZm9ybWVkJTIwYXJvdW5kJTIwdGhlJTIwc29sYXIlMjBzeXN0ZW0ncyUyMiUwQSUyMCUyMCUyMCUyMCUyMmxhcmdlc3QlMjB3b3JsZC4lMjBLb25zdGFudGluJTIwQmF0eWdpbiUyMGRpZCUyMG5vdCUyMHNldCUyMG91dCUyMHRvJTIwc29sdmUlMjBvbmUlMjBvZiUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjBtb3N0JTIwcHV6emxpbmclMjIlMEElMjAlMjAlMjAlMjAlMjIlMjBteXN0ZXJpZXMlMjB3aGVuJTIwaGUlMjB3ZW50JTIwZm9yJTIwYSUyMHJ1biUyMHVwJTIwYSUyMGhpbGwlMjBpbiUyME5pY2UlMkMlMjBGcmFuY2UuJTIyJTBBKSUwQWxhYmVscyUyMCUzRCUyMCU1QiUyMnNwYWNlJTIwJTI2JTIwY29zbW9zJTIyJTJDJTIwJTIyc2NpZW50aWZpYyUyMGRpc2NvdmVyeSUyMiUyQyUyMCUyMm1pY3JvYmlvbG9neSUyMiUyQyUyMCUyMnJvYm90cyUyMiUyQyUyMCUyMmFyY2hlb2xvZ3klMjIlNUQlMEFjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.innerHTML=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-90ztrp"&&(n.innerHTML=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Ed(T){let n,p="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=g("p"),n.innerHTML=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1qklg9x"&&(n.innerHTML=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Zd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Nd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Wd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF1ZGlvX291dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBYXN5bmMlMjBmb3IlMjBpJTJDJTIwaXRlbSUyMGluJTIwZW51bWVyYXRlKGF1ZGlvX291dHB1dCklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbihmJTIyb3V0cHV0XyU3QmklN0QuZmxhYyUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = <span class="hljs-keyword">await</span> client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Gd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Bd(T){let n,p=`The <code>client.chat_completion</code> method is aliased as <code>client.chat.completions.create</code> for compatibility with OpenAI’s client.
Inputs and outputs are strictly the same and using either syntax will yield the same results.
Check out the <a href="https://huggingface.co/docs/huggingface_hub/guides/inference#openai-compatibility" rel="nofollow">Inference guide</a>
for more details about OpenAI’s compatibility.`;return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-9iksi9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function Qd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlNUQlMEFjbGllbnQlMjAlM0QlMjBBc3luY0luZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyKSUwQWF3YWl0JTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Vd(T){let n,p="Example using streaming:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlNUQlMEFjbGllbnQlMjAlM0QlMjBBc3luY0luZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyKSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMCUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4p",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1mc18uw"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Sd(T){let n,p="Example using OpenAI’s syntax:",a,t,o;return t=new x({props:{code:"JTIzJTIwTXVzdCUyMGJlJTIwcnVuJTIwaW4lMjBhbiUyMGFzeW5jJTIwY29udGV4dCUwQSUyMyUyMGluc3RlYWQlMjBvZiUyMCU2MGZyb20lMjBvcGVuYWklMjBpbXBvcnQlMjBPcGVuQUklNjAlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwQXN5bmNJbmZlcmVuY2VDbGllbnQlMEElMEElMjMlMjBpbnN0ZWFkJTIwb2YlMjAlNjBjbGllbnQlMjAlM0QlMjBPcGVuQUkoLi4uKSU2MCUwQWNsaWVudCUyMCUzRCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNELi4uJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRC4uLiUyQyUwQSklMEElMEFvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-comment"># instead of \`from openai import OpenAI\`</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

<span class="hljs-comment"># instead of \`client = OpenAI(...)\`</span>
client = AsyncInferenceClient(
    base_url=...,
    api_key=...,
)

output = <span class="hljs-keyword">await</span> client.chat.completions.create(
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-i0a0yp"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Yd(T){let n,p="Example using Image + Text as input:",a,t,o;return t=new x({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

<span class="hljs-comment"># provide a remote URL</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url =<span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>
<span class="hljs-comment"># or a base64-encoded image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_path = <span class="hljs-string">&quot;/path/to/image.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(image_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    base64_image = base64.b64encode(f.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">f&quot;data:image/jpeg;base64,<span class="hljs-subst">{base64_image}</span>&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = <span class="hljs-keyword">await</span> client.chat.completions.create(
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: image_url},
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image in one sentence.&quot;</span>,
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>            ],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
The image depicts the iconic Statue of Liberty situated <span class="hljs-keyword">in</span> New York Harbor, New York, on a clear day.`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1e6ij9p"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function zd(T){let n,p="Example using tools:",a,t,o;return t=new x({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1ksikbz"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Rd(T){let n,p="Example using response_format:",a,t,o;return t=new x({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park. What did I saw and when?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response_format = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    response_format=response_format,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.content
<span class="hljs-string">&#x27;{

y&quot;: &quot;bike ride&quot;,
&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;],
_seen&quot;: 3,
n&quot;: &quot;park&quot;}&#x27;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1klcxsv"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Xd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9999666213989258</span>, start=<span class="hljs-number">16</span>, words=<span class="hljs-literal">None</span>)]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Dd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Fd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Hd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIpJTBBYXdhaXQlMjBjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Od(T){let n,p=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1igz3dx"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function Ld(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_model_status(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Pd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIyaHR0cHMlM0ElMkYlMkZqemd1MGJ1ZWk1LnVzLWVhc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTIyKSUwQWF3YWl0JTIwY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Kd(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>, score=<span class="hljs-number">0.9779096841812134</span>), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function ef(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function nf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function tf(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function sf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function af(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFhd2FpdCUyMGNsaWVudC5pbWFnZV90b190ZXh0KCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function lf(T){let n,p=`This endpoint method does not return a live list of all models available for the Serverless Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-jcsy1z"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function of(T){let n,p=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-ygzr4s"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function rf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQW1vZGVscyUyMCUzRCUyMGF3YWl0JTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFhd2FpdCUyMGNsaWVudC5saXN0X2RlcGxveWVkX21vZGVscyglMjJ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async contextthon</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = <span class="hljs-keyword">await</span> client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function cf(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function pf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>)
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function uf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;Clara&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9326565265655518</span>, start=<span class="hljs-number">11</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function gf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function mf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function hf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXF1ZXJ5JTIwJTNEJTIwJTIySG93JTIwbWFueSUyMHN0YXJzJTIwZG9lcyUyMHRoZSUyMHRyYW5zZm9ybWVycyUyMHJlcG9zaXRvcnklMjBoYXZlJTNGJTIyJTBBdGFibGUlMjAlM0QlMjAlN0IlMjJSZXBvc2l0b3J5JTIyJTNBJTIwJTVCJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyRGF0YXNldHMlMjIlMkMlMjAlMjJUb2tlbml6ZXJzJTIyJTVEJTJDJTIwJTIyU3RhcnMlMjIlM0ElMjAlNUIlMjIzNjU0MiUyMiUyQyUyMCUyMjQ1MTIlMjIlMkMlMjAlMjIzOTM0JTIyJTVEJTdEJTBBYXdhaXQlMjBjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function df(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZml4ZWRfYWNpZGl0eSUyMiUzQSUyMCU1QiUyMjcuNCUyMiUyQyUyMCUyMjcuOCUyMiUyQyUyMCUyMjEwLjMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ2b2xhdGlsZV9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyMC43JTIyJTJDJTIwJTIyMC44OCUyMiUyQyUyMCUyMjAuMzIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaXRyaWNfYWNpZCUyMiUzQSUyMCU1QiUyMjAlMjIlMkMlMjAlMjIwJTIyJTJDJTIwJTIyMC40NSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlc2lkdWFsX3N1Z2FyJTIyJTNBJTIwJTVCJTIyMS45JTIyJTJDJTIwJTIyMi42JTIyJTJDJTIwJTIyNi40JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hsb3JpZGVzJTIyJTNBJTIwJTVCJTIyMC4wNzYlMjIlMkMlMjAlMjIwLjA5OCUyMiUyQyUyMCUyMjAuMDczJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyZnJlZV9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjExJTIyJTJDJTIwJTIyMjUlMjIlMkMlMjAlMjI1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIydG90YWxfc3VsZnVyX2Rpb3hpZGUlMjIlM0ElMjAlNUIlMjIzNCUyMiUyQyUyMCUyMjY3JTIyJTJDJTIwJTIyMTMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZW5zaXR5JTIyJTNBJTIwJTVCJTIyMC45OTc4JTIyJTJDJTIwJTIyMC45OTY4JTIyJTJDJTIwJTIyMC45OTc2JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycEglMjIlM0ElMjAlNUIlMjIzLjUxJTIyJTJDJTIwJTIyMy4yJTIyJTJDJTIwJTIyMy4yMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnN1bHBoYXRlcyUyMiUzQSUyMCU1QiUyMjAuNTYlMjIlMkMlMjAlMjIwLjY4JTIyJTJDJTIwJTIyMC44MiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmFsY29ob2wlMjIlM0ElMjAlNUIlMjI5LjQlMjIlMkMlMjAlMjI5LjglMjIlMkMlMjAlMjIxMi42JTIyJTVEJTJDJTBBJTdEJTBBYXdhaXQlMjBjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function ff(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIySGVpZ2h0JTIyJTNBJTIwJTVCJTIyMTEuNTIlMjIlMkMlMjAlMjIxMi40OCUyMiUyQyUyMCUyMjEyLjM3NzglMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgxJTIyJTNBJTIwJTVCJTIyMjMuMiUyMiUyQyUyMCUyMjI0JTIyJTJDJTIwJTIyMjMuOSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDIlMjIlM0ElMjAlNUIlMjIyNS40JTIyJTJDJTIwJTIyMjYuMyUyMiUyQyUyMCUyMjI2LjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgzJTIyJTNBJTIwJTVCJTIyMzAlMjIlMkMlMjAlMjIzMS4yJTIyJTJDJTIwJTIyMzEuMSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMlNwZWNpZXMlMjIlM0ElMjAlNUIlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJXaWR0aCUyMiUzQSUyMCU1QiUyMjQuMDIlMjIlMkMlMjAlMjI0LjMwNTYlMjIlMkMlMjAlMjI0LjY5NjElMjIlNUQlMkMlMEElN0QlMEFhd2FpdCUyMGNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function yf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Mf(T){let n,p=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-gq0ddh"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function bf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function jf(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&u(n)}}}function _f(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJsb3clMjByZXNvbHV0aW9uJTJDJTIwYmx1cnJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYmV0dGVyX2FzdHJvbmF1dC5wbmclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Tf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF1ZGlvJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = <span class="hljs-keyword">await</span> client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function If(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Jf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyJTJDJTIwbW9kZWwlM0QlMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLWZyJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function wf(T){let n,p="Specifying languages:",a,t,o;return t=new x({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-mhcj6c"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function xf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Cf(T){let n,p="Example with <code>multi_label=False</code>:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRleHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMG5ldyUyMG1vZGVsJTIwb2ZmZXJzJTIwYW4lMjBleHBsYW5hdGlvbiUyMGZvciUyMGhvdyUyMHRoZSUyMEdhbGlsZWFuJTIwc2F0ZWxsaXRlcyUyMGZvcm1lZCUyMGFyb3VuZCUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjIlMEElMjAlMjAlMjAlMjAlMjJsYXJnZXN0JTIwd29ybGQuJTIwS29uc3RhbnRpbiUyMEJhdHlnaW4lMjBkaWQlMjBub3QlMjBzZXQlMjBvdXQlMjB0byUyMHNvbHZlJTIwb25lJTIwb2YlMjB0aGUlMjBzb2xhciUyMHN5c3RlbSdzJTIwbW9zdCUyMHB1enpsaW5nJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTIwbXlzdGVyaWVzJTIwd2hlbiUyMGhlJTIwd2VudCUyMGZvciUyMGElMjBydW4lMjB1cCUyMGElMjBoaWxsJTIwaW4lMjBOaWNlJTJDJTIwRnJhbmNlLiUyMiUwQSklMEFsYWJlbHMlMjAlM0QlMjAlNUIlMjJzcGFjZSUyMCUyNiUyMGNvc21vcyUyMiUyQyUyMCUyMnNjaWVudGlmaWMlMjBkaXNjb3ZlcnklMjIlMkMlMjAlMjJtaWNyb2Jpb2xvZ3klMjIlMkMlMjAlMjJyb2JvdHMlMjIlMkMlMjAlMjJhcmNoZW9sb2d5JTIyJTVEJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMlMkMlMjBtdWx0aV9sYWJlbCUzRFRydWUp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.innerHTML=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-90ztrp"&&(n.innerHTML=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function Uf(T){let n,p="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=g("p"),n.innerHTML=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1qklg9x"&&(n.innerHTML=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function $f(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function vf(T){let n,p="Example:",a,t,o;return t=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.inference_api <span class="hljs-keyword">import</span> InferenceApi

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask-fill example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Question Answering example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>,
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9326569437980652</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Clara&#x27;</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Zero-shot example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>: [<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Overriding configured task</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Text-to-image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(<span class="hljs-string">&quot;cat&quot;</span>)
&lt;PIL.PngImagePlugin.PngImageFile image (...)&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Return as raw response to parse the output yourself</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;mio/amadeus&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = inference(<span class="hljs-string">&quot;hello world&quot;</span>, raw_response=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.headers
{<span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;audio/flac&quot;</span>, ...}
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes from server</span>
<span class="hljs-string">b&#x27;(...)&#x27;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=p,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(u(n),u(a)),b(t,e)}}}function kf(T){let n,p,a,t,o,e,c,Cg=`Inference is the process of using a trained model to make predictions on new data. As this process can be compute-intensive,
running on a dedicated server can be an interesting option. The <code>huggingface_hub</code> library provides an easy way to call a
service that runs inference for hosted models. There are several services you can connect to:`,Ir,Ls,Ug=`<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>: a service that allows you to run accelerated inference
on Hugging Face’s infrastructure for free. This service is a fast way to get started, test different models, and
prototype AI products.</li> <li><a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production.
Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li>`,Jr,Ps,$g=`These services can be called with the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. Please refer to <a href="../guides/inference">this guide</a>
for more information on how to use it.`,wr,Ks,xr,C,ea,Vr,Nl,vg="Initialize a new Inference Client.",Sr,Wl,kg=`<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API or self-hosted Inference Endpoints.`,Yr,We,na,zr,Gl,qg="Perform audio classification on the provided audio content.",Rr,at,Xr,Ge,ta,Dr,Bl,Ag="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",Fr,lt,Hr,Be,sa,Or,Ql,Eg="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",Lr,ot,Pr,E,aa,Kr,Vl,Zg="A method for completing conversations using a specified language model.",ei,rt,ni,it,ti,ct,si,pt,ai,ut,li,gt,oi,mt,ri,Qe,la,ii,Sl,Ng="Answer questions on document images.",ci,ht,pi,Ve,oa,ui,Yl,Wg="Generate embeddings for a given text.",gi,dt,mi,Se,ra,hi,zl,Gg="Fill in a hole with a missing word (token to be precise).",di,ft,fi,K,ia,yi,Rl,Bg="Get information about the deployed endpoint.",Mi,Xl,Qg=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,bi,yt,ji,ee,ca,_i,Dl,Vg="Get the status of a model hosted on the Inference API.",Ti,Mt,Ii,bt,Ji,jt,pa,wi,Fl,Sg="Get the model Hugging Face recommends for the input task.",xi,ne,ua,Ci,Hl,Yg="Check the health of the deployed endpoint.",Ui,Ol,zg=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,$i,_t,vi,Ye,ga,ki,Ll,Rg="Perform image classification on the given image using the specified model.",qi,Tt,Ai,te,ma,Ei,Pl,Xg="Perform image segmentation on the given image using the specified model.",Zi,It,Ni,Jt,Wi,se,ha,Gi,Kl,Dg="Perform image-to-image translation using a specified model.",Bi,wt,Qi,xt,Vi,ae,da,Si,eo,Fg="Takes an input image and return text.",Yi,no,Hg=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,zi,Ct,Ri,B,fa,Xi,to,Og="List models deployed on the Serverless Inference API service.",Di,so,Lg=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,Fi,Ut,Hi,$t,Oi,vt,Li,le,ya,Pi,ao,Pg="Perform object detection on the given image using the specified model.",Ki,kt,ec,qt,nc,At,Ma,tc,lo,Kg="Make a POST request to the inference server.",sc,ze,ba,ac,oo,em="Retrieve the answer to a question from a given text.",lc,Et,oc,Re,ja,rc,ro,nm="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",ic,Zt,cc,Xe,_a,pc,io,tm="Generate a summary of a given text using a specified model.",uc,Nt,gc,De,Ta,mc,co,sm="Retrieve the answer to a question from information given in a table.",hc,Wt,dc,Fe,Ia,fc,po,am="Classifying a target category (a group) based on a set of attributes.",yc,Gt,Mc,He,Ja,bc,uo,lm="Predicting a numerical target value given a set of attributes/features in a table.",jc,Bt,_c,Oe,wa,Tc,go,om="Perform text classification (e.g. sentiment-analysis) on the given text.",Ic,Qt,Jc,Q,xa,wc,mo,rm="Given a prompt, generate the following text.",xc,ho,im=`API endpoint is supposed to run with the <code>text-generation-inference</code> backend (TGI). This backend is the
go-to solution to run large language models at scale. However, for some smaller models (e.g. “gpt2”) the
default <code>transformers</code> + <code>api-inference</code> solution is still in use. Both approaches have very similar APIs, but
not exactly the same. This method is compatible with both approaches but some parameters are only available for
<code>text-generation-inference</code>. If some parameters are ignored, a warning message is triggered but the process
continues correctly.`,Cc,fo,cm='To learn more about the TGI project, please refer to <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">https://github.com/huggingface/text-generation-inference</a>.',Uc,Vt,$c,St,vc,oe,Ca,kc,yo,pm="Generate an image based on a given text using a specified model.",qc,Yt,Ac,zt,Ec,Le,Ua,Zc,Mo,um="Synthesize an audio of a voice pronouncing a given text.",Nc,Rt,Wc,Pe,$a,Gc,bo,gm=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,Bc,Xt,Qc,F,va,Vc,jo,mm="Convert text from one language to another.",Sc,_o,hm=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.`,Yc,Dt,zc,Ft,Rc,Ke,ka,Xc,To,dm="Answering open-ended questions based on an image.",Dc,Ht,Fc,re,qa,Hc,Io,fm="Provide as input a text and a set of candidate labels to classify the input text.",Oc,Ot,Lc,Lt,Pc,en,Aa,Kc,Jo,ym="Provide input image and text labels to predict text labels for the image.",ep,Pt,Cr,Ea,Ur,Za,Mm=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>.
To use it, you can either install <code>aiohttp</code> directly or use the <code>[inference]</code> extra:`,$r,Na,vr,w,Wa,np,wo,bm="Initialize a new Inference Client.",tp,xo,jm=`<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API or self-hosted Inference Endpoints.`,sp,nn,Ga,ap,Co,_m="Perform audio classification on the provided audio content.",lp,Kt,op,tn,Ba,rp,Uo,Tm="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",ip,es,cp,sn,Qa,pp,$o,Im="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",up,ns,gp,Z,Va,mp,vo,Jm="A method for completing conversations using a specified language model.",hp,ts,dp,ss,fp,as,yp,ls,Mp,os,bp,rs,jp,is,_p,ie,Sa,Tp,ko,wm="Close all open sessions.",Ip,qo,xm=`By default, ‘aiohttp.ClientSession’ objects are closed automatically when a call is completed. However, if you
are streaming data from the server and you stop before the stream is complete, you must call this method to
close the session properly.`,Jp,Ao,Cm="Another possibility is to use an async context (e.g. <code>async with AsyncInferenceClient(): ...</code>).",wp,an,Ya,xp,Eo,Um="Answer questions on document images.",Cp,cs,Up,ln,za,$p,Zo,$m="Generate embeddings for a given text.",vp,ps,kp,on,Ra,qp,No,vm="Fill in a hole with a missing word (token to be precise).",Ap,us,Ep,ce,Xa,Zp,Wo,km="Get information about the deployed endpoint.",Np,Go,qm=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,Wp,gs,Gp,pe,Da,Bp,Bo,Am="Get the status of a model hosted on the Inference API.",Qp,ms,Vp,hs,Sp,ds,Fa,Yp,Qo,Em="Get the model Hugging Face recommends for the input task.",zp,ue,Ha,Rp,Vo,Zm="Check the health of the deployed endpoint.",Xp,So,Nm=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,Dp,fs,Fp,rn,Oa,Hp,Yo,Wm="Perform image classification on the given image using the specified model.",Op,ys,Lp,ge,La,Pp,zo,Gm="Perform image segmentation on the given image using the specified model.",Kp,Ms,eu,bs,nu,me,Pa,tu,Ro,Bm="Perform image-to-image translation using a specified model.",su,js,au,_s,lu,he,Ka,ou,Xo,Qm="Takes an input image and return text.",ru,Do,Vm=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,iu,Ts,cu,V,el,pu,Fo,Sm="List models deployed on the Serverless Inference API service.",uu,Ho,Ym=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,gu,Is,mu,Js,hu,ws,du,de,nl,fu,Oo,zm="Perform object detection on the given image using the specified model.",yu,xs,Mu,Cs,bu,Us,tl,ju,Lo,Rm="Make a POST request to the inference server.",_u,cn,sl,Tu,Po,Xm="Retrieve the answer to a question from a given text.",Iu,$s,Ju,pn,al,wu,Ko,Dm="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",xu,vs,Cu,un,ll,Uu,er,Fm="Generate a summary of a given text using a specified model.",$u,ks,vu,gn,ol,ku,nr,Hm="Retrieve the answer to a question from information given in a table.",qu,qs,Au,mn,rl,Eu,tr,Om="Classifying a target category (a group) based on a set of attributes.",Zu,As,Nu,hn,il,Wu,sr,Lm="Predicting a numerical target value given a set of attributes/features in a table.",Gu,Es,Bu,dn,cl,Qu,ar,Pm="Perform text classification (e.g. sentiment-analysis) on the given text.",Vu,Zs,Su,S,pl,Yu,lr,Km="Given a prompt, generate the following text.",zu,or,eh=`API endpoint is supposed to run with the <code>text-generation-inference</code> backend (TGI). This backend is the
go-to solution to run large language models at scale. However, for some smaller models (e.g. “gpt2”) the
default <code>transformers</code> + <code>api-inference</code> solution is still in use. Both approaches have very similar APIs, but
not exactly the same. This method is compatible with both approaches but some parameters are only available for
<code>text-generation-inference</code>. If some parameters are ignored, a warning message is triggered but the process
continues correctly.`,Ru,rr,nh='To learn more about the TGI project, please refer to <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">https://github.com/huggingface/text-generation-inference</a>.',Xu,Ns,Du,Ws,Fu,fe,ul,Hu,ir,th="Generate an image based on a given text using a specified model.",Ou,Gs,Lu,Bs,Pu,fn,gl,Ku,cr,sh="Synthesize an audio of a voice pronouncing a given text.",eg,Qs,ng,yn,ml,tg,pr,ah=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,sg,Vs,ag,H,hl,lg,ur,lh="Convert text from one language to another.",og,gr,oh=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.`,rg,Ss,ig,Ys,cg,Mn,dl,pg,mr,rh="Answering open-ended questions based on an image.",ug,zs,gg,ye,fl,mg,hr,ih="Provide as input a text and a set of candidate labels to classify the input text.",hg,Rs,dg,Xs,fg,bn,yl,yg,dr,ch="Provide input image and text labels to predict text labels for the image.",Mg,Ds,kr,Ml,qr,jn,bl,bg,fr,ph="Error raised when a model is unavailable or the request times out.",Ar,jl,Er,_n,_l,jg,yr,uh="This Dataclass represents the the model status in the Hugging Face Inference API.",Zr,Tl,Nr,Il,gh=`<code>InferenceAPI</code> is the legacy way to call the Inference API. The interface is more simplistic and requires knowing
the input parameters and output format for each task. It also lacks the ability to connect to other services like
Inference Endpoints or AWS SageMaker. <code>InferenceAPI</code> will soon be deprecated so we recommend using <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
whenever possible. Check out <a href="../guides/inference#legacy-inferenceapi-client">this guide</a> to learn how to switch from
<code>InferenceAPI</code> to <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> in your scripts.`,Wr,Y,Jl,_g,Mr,mh="Client to configure requests and make calls to the HuggingFace Inference API.",Tg,Fs,Ig,Hs,wl,Jg,br,hh="Inits headers and API call information.",wg,Os,xl,xg,jr,dh="Make a call to the Inference API.",Gr,Cl,Br,Tr,Qr;return o=new _r({props:{title:"Inference",local:"inference",headingTag:"h1"}}),Ks=new _r({props:{title:"Inference Client",local:"huggingface_hub.InferenceClient",headingTag:"h2"}}),ea=new A({props:{name:"class huggingface_hub.InferenceClient",anchor:"huggingface_hub.InferenceClient",parameters:[{name:"model",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"timeout",val:": Optional = None"},{name:"headers",val:": Optional = None"},{name:"cookies",val:": Optional = None"},{name:"proxies",val:": Optional = None"},{name:"base_url",val:": Optional = None"},{name:"api_key",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>meta-llama/Meta-Llama-3-8B-Instruct</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.
Note: for better compatibility with OpenAI&#x2019;s client, <code>model</code> has been aliased as <code>base_url</code>. Those 2
arguments are mutually exclusive. If using <code>base_url</code> for chat completion, the <code>/chat/completions</code> suffix
path will be appended to the base URL (see the <a href="https://huggingface.co/docs/text-generation-inference/en/messages_api" rel="nofollow">TGI Messages API</a>
documentation for details). When passing a URL as <code>model</code>, the client will not append any suffix path to it.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.
Note: for better compatibility with OpenAI&#x2019;s client, <code>token</code> has been aliased as <code>api_key</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"token"},{anchor:"huggingface_hub.InferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.InferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.InferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"},{anchor:"huggingface_hub.InferenceClient.proxies",description:`<strong>proxies</strong> (<code>Any</code>, <code>optional</code>) &#x2014;
Proxies to use for the request.`,name:"proxies"},{anchor:"huggingface_hub.InferenceClient.base_url",description:`<strong>base_url</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Base URL to run inference. This is a duplicated argument from <code>model</code> to make <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>model</code> is set. Defaults to None.`,name:"base_url"},{anchor:"huggingface_hub.InferenceClient.api_key",description:`<strong>api_key</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L113"}}),na=new A({props:{name:"audio_classification",anchor:"huggingface_hub.InferenceClient.audio_classification",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"function_to_apply",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.audio_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.audio_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;AudioClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the output.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L322",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),at=new $({props:{anchor:"huggingface_hub.InferenceClient.audio_classification.example",$$slots:{default:[Yh]},$$scope:{ctx:T}}}),ta=new A({props:{name:"audio_to_audio",anchor:"huggingface_hub.InferenceClient.audio_to_audio",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L372",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),lt=new $({props:{anchor:"huggingface_hub.InferenceClient.audio_to_audio.example",$$slots:{default:[zh]},$$scope:{ctx:T}}}),sa=new A({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L415",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ot=new $({props:{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.example",$$slots:{default:[Rh]},$$scope:{ctx:T}}}),aa=new A({props:{name:"chat_completion",anchor:"huggingface_hub.InferenceClient.chat_completion",parameters:[{name:"messages",val:": List"},{name:"model",val:": Optional = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"logit_bias",val:": Optional = None"},{name:"logprobs",val:": Optional = None"},{name:"max_tokens",val:": Optional = None"},{name:"n",val:": Optional = None"},{name:"presence_penalty",val:": Optional = None"},{name:"response_format",val:": Optional = None"},{name:"seed",val:": Optional = None"},{name:"stop",val:": Optional = None"},{name:"stream_options",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"tool_choice",val:": Union = None"},{name:"tool_prompt",val:": Optional = None"},{name:"tools",val:": Optional = None"},{name:"top_logprobs",val:": Optional = None"},{name:"top_p",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List of <a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputMessage">ChatCompletionInputMessage</a>) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.InferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.</p>
<p>If <code>model</code> is a model ID, it is passed to the server as the <code>model</code> parameter. If you want to define a
custom URL while setting <code>model</code> in the request payload, you must set <code>base_url</code> when initializing <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens
(specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically,
the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model,
but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should
result in a ban or exclusive selection of the relevant token. Defaults to None.`,name:"logit_bias"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 20.`,name:"max_tokens"},{anchor:"huggingface_hub.InferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
UNUSED.`,name:"n"},{anchor:"huggingface_hub.InferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.response_format",description:`<strong>response_format</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputGrammarType">ChatCompletionInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"response_format"},{anchor:"huggingface_hub.InferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stop",description:`<strong>stop</strong> (Optional<code>str</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream_options",description:`<strong>stream_options</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputStreamOptions">ChatCompletionInputStreamOptions</a>, <em>optional</em>) &#x2014;
Options for streaming completions.`,name:"stream_options"},{anchor:"huggingface_hub.InferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolType">ChatCompletionInputToolType</a> or <code>str</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ToolElement">ToolElement</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L526",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),rt=new G({props:{$$slots:{default:[Xh]},$$scope:{ctx:T}}}),it=new $({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example",$$slots:{default:[Dh]},$$scope:{ctx:T}}}),ct=new $({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-2",$$slots:{default:[Fh]},$$scope:{ctx:T}}}),pt=new $({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-3",$$slots:{default:[Hh]},$$scope:{ctx:T}}}),ut=new $({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-4",$$slots:{default:[Oh]},$$scope:{ctx:T}}}),gt=new $({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-5",$$slots:{default:[Lh]},$$scope:{ctx:T}}}),mt=new $({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-6",$$slots:{default:[Ph]},$$scope:{ctx:T}}}),la=new A({props:{name:"document_question_answering",anchor:"huggingface_hub.InferenceClient.document_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"},{name:"doc_stride",val:": Optional = None"},{name:"handle_impossible_answer",val:": Optional = None"},{name:"lang",val:": Optional = None"},{name:"max_answer_len",val:": Optional = None"},{name:"max_question_len",val:": Optional = None"},{name:"max_seq_len",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"word_boxes",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the words in the document are too long to fit with the question for the model, it will
be split in several chunks with some overlap. This argument controls the size of that
overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.lang",description:`<strong>lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language to use while running OCR.`,name:"lang"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are
considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk
passed to the model. The context will be split in several chunks (using doc_stride as
overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Can return less
than top_k answers if there are not enough options available within the context.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.word_boxes",description:`<strong>word_boxes</strong> (<code>List[Union[List[float], str]]</code>, <em>optional</em>) &#x2014;
A list of words and bounding boxes (normalized 0-&gt;1000). If provided, the inference will
skip the OCR step and use the provided bounding boxes instead.`,name:"word_boxes"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L914",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ht=new $({props:{anchor:"huggingface_hub.InferenceClient.document_question_answering.example",$$slots:{default:[Kh]},$$scope:{ctx:T}}}),oa=new A({props:{name:"feature_extraction",anchor:"huggingface_hub.InferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": Optional = None"},{name:"prompt_name",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"truncation_direction",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L997",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>HTTPError</code></p>
`}}),dt=new $({props:{anchor:"huggingface_hub.InferenceClient.feature_extraction.example",$$slots:{default:[ed]},$$scope:{ctx:T}}}),ra=new A({props:{name:"fill_mask",anchor:"huggingface_hub.InferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"targets",val:": Optional = None"},{name:"top_k",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.InferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.fill_mask.targets",description:`<strong>targets</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
When passed, the model will limit the scores to the passed targets instead of looking up
in the whole vocabulary. If the provided targets are not in the model vocab, they will be
tokenized and the first resulting token will be used (with a warning, and that might be
slower).`,name:"targets"},{anchor:"huggingface_hub.InferenceClient.fill_mask.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When passed, overrides the number of predictions to return.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1063",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ft=new $({props:{anchor:"huggingface_hub.InferenceClient.fill_mask.example",$$slots:{default:[nd]},$$scope:{ctx:T}}}),ia=new A({props:{name:"get_endpoint_info",anchor:"huggingface_hub.InferenceClient.get_endpoint_info",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2979",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),yt=new $({props:{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.example",$$slots:{default:[td]},$$scope:{ctx:T}}}),ca=new A({props:{name:"get_model_status",anchor:"huggingface_hub.InferenceClient.get_model_status",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3068",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),Mt=new G({props:{$$slots:{default:[sd]},$$scope:{ctx:T}}}),bt=new $({props:{anchor:"huggingface_hub.InferenceClient.get_model_status.example",$$slots:{default:[ad]},$$scope:{ctx:T}}}),pa=new A({props:{name:"get_recommended_model",anchor:"huggingface_hub.InferenceClient.get_recommended_model",parameters:[{name:"task",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_recommended_model.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The Hugging Face task to get which model Hugging Face recommends.
All available tasks can be found <a href="https://huggingface.co/tasks" rel="nofollow">here</a>.`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2955",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Name of the model recommended for the input task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If Hugging Face has no recommendation for the input task.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),ua=new A({props:{name:"health_check",anchor:"huggingface_hub.InferenceClient.health_check",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3034",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),_t=new $({props:{anchor:"huggingface_hub.InferenceClient.health_check.example",$$slots:{default:[ld]},$$scope:{ctx:T}}}),ga=new A({props:{name:"image_classification",anchor:"huggingface_hub.InferenceClient.image_classification",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"},{name:"function_to_apply",val:": Optional = None"},{name:"top_k",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>Literal[&quot;sigmoid&quot;, &quot;softmax&quot;, &quot;none&quot;]</code>, <em>optional</em>) &#x2014;
The function to apply to the output scores.`,name:"function_to_apply"},{anchor:"huggingface_hub.InferenceClient.image_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1113",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Tt=new $({props:{anchor:"huggingface_hub.InferenceClient.image_classification.example",$$slots:{default:[od]},$$scope:{ctx:T}}}),ma=new A({props:{name:"image_segmentation",anchor:"huggingface_hub.InferenceClient.image_segmentation",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"},{name:"mask_threshold",val:": Optional = None"},{name:"overlap_mask_area_threshold",val:": Optional = None"},{name:"subtask",val:": Optional = None"},{name:"threshold",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Mask overlap threshold to eliminate small, disconnected segments.`,name:"overlap_mask_area_threshold"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.subtask",description:`<strong>subtask</strong> (<code>Literal[&quot;instance&quot;, &quot;panoptic&quot;, &quot;semantic&quot;]</code>, <em>optional</em>) &#x2014;
Segmentation task to be performed, depending on model capabilities.`,name:"subtask"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Probability threshold to filter out predicted masks.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1156",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),It=new G({props:{warning:!0,$$slots:{default:[rd]},$$scope:{ctx:T}}}),Jt=new $({props:{anchor:"huggingface_hub.InferenceClient.image_segmentation.example",$$slots:{default:[id]},$$scope:{ctx:T}}}),ha=new A({props:{name:"image_to_image",anchor:"huggingface_hub.InferenceClient.image_to_image",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Optional = None"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A negative prompt to guide the translation process.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"huggingface_hub.InferenceClient.image_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"huggingface_hub.InferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1219",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),wt=new G({props:{warning:!0,$$slots:{default:[cd]},$$scope:{ctx:T}}}),xt=new $({props:{anchor:"huggingface_hub.InferenceClient.image_to_image.example",$$slots:{default:[pd]},$$scope:{ctx:T}}}),da=new A({props:{name:"image_to_text",anchor:"huggingface_hub.InferenceClient.image_to_text",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1292",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ct=new $({props:{anchor:"huggingface_hub.InferenceClient.image_to_text.example",$$slots:{default:[ud]},$$scope:{ctx:T}}}),fa=new A({props:{name:"list_deployed_models",anchor:"huggingface_hub.InferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1329",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),Ut=new G({props:{warning:!0,$$slots:{default:[gd]},$$scope:{ctx:T}}}),$t=new G({props:{$$slots:{default:[md]},$$scope:{ctx:T}}}),vt=new $({props:{anchor:"huggingface_hub.InferenceClient.list_deployed_models.example",$$slots:{default:[hd]},$$scope:{ctx:T}}}),ya=new A({props:{name:"object_detection",anchor:"huggingface_hub.InferenceClient.object_detection",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"},{name:"threshold",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The probability necessary to make a prediction.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1412",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),kt=new G({props:{warning:!0,$$slots:{default:[dd]},$$scope:{ctx:T}}}),qt=new $({props:{anchor:"huggingface_hub.InferenceClient.object_detection.example",$$slots:{default:[fd]},$$scope:{ctx:T}}}),Ma=new A({props:{name:"post",anchor:"huggingface_hub.InferenceClient.post",parameters:[{name:"json",val:": Union = None"},{name:"data",val:": Union = None"},{name:"model",val:": Optional = None"},{name:"task",val:": Optional = None"},{name:"stream",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.post.json",description:`<strong>json</strong> (<code>Union[str, Dict, List]</code>, <em>optional</em>) &#x2014;
The JSON data to send in the request body, specific to each task. Defaults to None.`,name:"json"},{anchor:"huggingface_hub.InferenceClient.post.data",description:`<strong>data</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>, <em>optional</em>) &#x2014;
The content to send in the request body, specific to each task.
It can be raw bytes, a pointer to an opened file, a local file path,
or a URL to an online resource (image, audio file,&#x2026;). If both <code>json</code> and <code>data</code> are passed,
<code>data</code> will take precedence. At least <code>json</code> or <code>data</code> must be provided. Defaults to None.`,name:"data"},{anchor:"huggingface_hub.InferenceClient.post.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. Will override the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.post.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task to perform on the inference. All available tasks can be found
<a href="https://huggingface.co/tasks" rel="nofollow">here</a>. Used only to default to a recommended model if <code>model</code> is not
provided. At least <code>model</code> or <code>task</code> must be provided. Defaults to None.`,name:"task"},{anchor:"huggingface_hub.InferenceClient.post.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to iterate over streaming APIs.`,name:"stream"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L227",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The raw bytes returned by the server.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bytes</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ba=new A({props:{name:"question_answering",anchor:"huggingface_hub.InferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": Optional = None"},{name:"align_to_words",val:": Optional = None"},{name:"doc_stride",val:": Optional = None"},{name:"handle_impossible_answer",val:": Optional = None"},{name:"max_answer_len",val:": Optional = None"},{name:"max_question_len",val:": Optional = None"},{name:"max_seq_len",val:": Optional = None"},{name:"top_k",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.InferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.question_answering.align_to_words",description:`<strong>align_to_words</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Attempts to align the answer to real words. Improves quality on space separated
languages. Might hurt on non-space-separated languages (like Japanese or Chinese).`,name:"align_to_words"},{anchor:"huggingface_hub.InferenceClient.question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the context is too long to fit with the question for the model, it will be split in
several chunks with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.InferenceClient.question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are
considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk
passed to the model. The context will be split in several chunks (using docStride as
overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we
return less than topk answers if there are not enough options available within the
context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1458",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>When top_k is 1 or not provided, it returns a single <code>QuestionAnsweringOutputElement</code>.
When top_k is greater than 1, it returns a list of <code>QuestionAnsweringOutputElement</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Union[<code>QuestionAnsweringOutputElement</code>, List<a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Et=new $({props:{anchor:"huggingface_hub.InferenceClient.question_answering.example",$$slots:{default:[yd]},$$scope:{ctx:T}}}),ja=new A({props:{name:"sentence_similarity",anchor:"huggingface_hub.InferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1542",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Zt=new $({props:{anchor:"huggingface_hub.InferenceClient.sentence_similarity.example",$$slots:{default:[Md]},$$scope:{ctx:T}}}),_a=new A({props:{name:"summarization",anchor:"huggingface_hub.InferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"clean_up_tokenization_spaces",val:": Optional = None"},{name:"generate_parameters",val:": Optional = None"},{name:"truncation",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.summarization.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for summarization. Check out this <a href="https://huggingface.co/docs/api-inference/detailed_parameters#summarization-task" rel="nofollow">page</a>
for more details.`,name:"parameters"},{anchor:"huggingface_hub.InferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for summarization will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.summarization.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.InferenceClient.summarization.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"},{anchor:"huggingface_hub.InferenceClient.summarization.truncation",description:`<strong>truncation</strong> (<code>Literal[&quot;do_not_truncate&quot;, &quot;longest_first&quot;, &quot;only_first&quot;, &quot;only_second&quot;]</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1589",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Nt=new $({props:{anchor:"huggingface_hub.InferenceClient.summarization.example",$$slots:{default:[bd]},$$scope:{ctx:T}}}),Ta=new A({props:{name:"table_question_answering",anchor:"huggingface_hub.InferenceClient.table_question_answering",parameters:[{name:"table",val:": Dict"},{name:"query",val:": str"},{name:"model",val:": Optional = None"},{name:"parameters",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional inference parameters. Defaults to None.`,name:"parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1652",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Wt=new $({props:{anchor:"huggingface_hub.InferenceClient.table_question_answering.example",$$slots:{default:[jd]},$$scope:{ctx:T}}}),Ia=new A({props:{name:"tabular_classification",anchor:"huggingface_hub.InferenceClient.tabular_classification",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1706",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Gt=new $({props:{anchor:"huggingface_hub.InferenceClient.tabular_classification.example",$$slots:{default:[_d]},$$scope:{ctx:T}}}),Ja=new A({props:{name:"tabular_regression",anchor:"huggingface_hub.InferenceClient.tabular_regression",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1755",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Bt=new $({props:{anchor:"huggingface_hub.InferenceClient.tabular_regression.example",$$slots:{default:[Td]},$$scope:{ctx:T}}}),wa=new A({props:{name:"text_classification",anchor:"huggingface_hub.InferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"function_to_apply",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;TextClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the output.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1795",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Qt=new $({props:{anchor:"huggingface_hub.InferenceClient.text_classification.example",$$slots:{default:[Id]},$$scope:{ctx:T}}}),xa=new A({props:{name:"text_generation",anchor:"huggingface_hub.InferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": Optional = None"},{name:"adapter_id",val:": Optional = None"},{name:"best_of",val:": Optional = None"},{name:"decoder_input_details",val:": Optional = None"},{name:"do_sample",val:": Optional = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"grammar",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"},{name:"repetition_penalty",val:": Optional = None"},{name:"return_full_text",val:": Optional = False"},{name:"seed",val:": Optional = None"},{name:"stop",val:": Optional = None"},{name:"stop_sequences",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"top_n_tokens",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"typical_p",val:": Optional = None"},{name:"watermark",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.InferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_generation.adapter_id",description:`<strong>adapter_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Lora adapter id.`,name:"adapter_id"},{anchor:"huggingface_hub.InferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.InferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.InferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.InferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.InferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop</code> is generated.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Deprecated argument. Use <code>stop</code> instead.`,name:"stop_sequences"},{anchor:"huggingface_hub.InferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.InferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2000",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Vt=new G({props:{$$slots:{default:[Jd]},$$scope:{ctx:T}}}),St=new $({props:{anchor:"huggingface_hub.InferenceClient.text_generation.example",$$slots:{default:[wd]},$$scope:{ctx:T}}}),Ca=new A({props:{name:"text_to_image",anchor:"huggingface_hub.InferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"scheduler",val:": Optional = None"},{name:"target_size",val:": Optional = None"},{name:"seed",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional negative prompt for the image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.InferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.InferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-image model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_to_image.scheduler",description:`<strong>scheduler</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Override the scheduler with a compatible one.`,name:"scheduler"},{anchor:"huggingface_hub.InferenceClient.text_to_image.target_size",description:`<strong>target_size</strong> (<code>TextToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image`,name:"target_size"},{anchor:"huggingface_hub.InferenceClient.text_to_image.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2346",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Yt=new G({props:{warning:!0,$$slots:{default:[xd]},$$scope:{ctx:T}}}),zt=new $({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example",$$slots:{default:[Cd]},$$scope:{ctx:T}}}),Ua=new A({props:{name:"text_to_speech",anchor:"huggingface_hub.InferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"do_sample",val:": Optional = None"},{name:"early_stopping",val:": Union = None"},{name:"epsilon_cutoff",val:": Optional = None"},{name:"eta_cutoff",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"},{name:"min_length",val:": Optional = None"},{name:"min_new_tokens",val:": Optional = None"},{name:"num_beam_groups",val:": Optional = None"},{name:"num_beams",val:": Optional = None"},{name:"penalty_alpha",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"typical_p",val:": Optional = None"},{name:"use_cache",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-speech model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use sampling instead of greedy decoding when generating new tokens.`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.early_stopping",description:`<strong>early_stopping</strong> (<code>Union[bool, &quot;TextToSpeechEarlyStoppingEnum&quot;</code>, <em>optional</em>) &#x2014;
Controls the stopping condition for beam-based methods.`,name:"early_stopping"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability
greater than epsilon_cutoff will be sampled. In the paper, suggested values range from
3e-4 to 9e-4, depending on the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language
Model Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to
float strictly between 0 and 1, a token is only considered if it is greater than either
eta_cutoff or sqrt(eta_cutoff) * exp(-entropy(softmax(next_token_logits))). The latter
term is intuitively the expected next token probability, scaled by sqrt(eta_cutoff). In
the paper, suggested values range from 3e-4 to 2e-3, depending on the size of the model.
See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model Desmoothing</a>
for more details.`,name:"eta_cutoff"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length (in tokens) of the generated text, including the input.`,name:"max_length"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of tokens to generate. Takes precedence over maxLength.`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum length (in tokens) of the generated text, including the input.`,name:"min_length"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of tokens to generate. Takes precedence over maxLength.`,name:"min_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of groups to divide num_beams into in order to ensure diversity among different
groups of beams. See <a href="https://hf.co/papers/1610.02424" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams to use for beam search.`,name:"num_beams"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value balances the model confidence and the degeneration penalty in contrastive
search decoding.`,name:"penalty_alpha"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities
that add up to top_p or higher are kept for generation.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is
to the expected conditional probability of predicting a random token next, given the partial text
already generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with
probabilities that add up to typical_p or higher are kept for generation. See <a href="https://hf.co/papers/2202.00666" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the model should use the past last key/values attentions to speed up decoding`,name:"use_cache"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2437",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Rt=new $({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example",$$slots:{default:[Ud]},$$scope:{ctx:T}}}),$a=new A({props:{name:"token_classification",anchor:"huggingface_hub.InferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"aggregation_strategy",val:": Optional = None"},{name:"ignore_labels",val:": Optional = None"},{name:"stride",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.token_classification.aggregation_strategy",description:`<strong>aggregation_strategy</strong> (<code>Literal[&quot;none&quot;, &quot;simple&quot;, &quot;first&quot;, &quot;average&quot;, &quot;max&quot;]</code>, <em>optional</em>) &#x2014;
The strategy used to fuse tokens based on model predictions.`,name:"aggregation_strategy"},{anchor:"huggingface_hub.InferenceClient.token_classification.ignore_labels",description:`<strong>ignore_labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of labels to ignore.`,name:"ignore_labels"},{anchor:"huggingface_hub.InferenceClient.token_classification.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of overlapping tokens between chunks when splitting the input text.`,name:"stride"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2559",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Xt=new $({props:{anchor:"huggingface_hub.InferenceClient.token_classification.example",$$slots:{default:[$d]},$$scope:{ctx:T}}}),va=new A({props:{name:"translation",anchor:"huggingface_hub.InferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"src_lang",val:": Optional = None"},{name:"tgt_lang",val:": Optional = None"},{name:"clean_up_tokenization_spaces",val:": Optional = None"},{name:"truncation",val:": Optional = None"},{name:"generate_parameters",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The source language of the text. Required for models that can translate from multiple languages.`,name:"src_lang"},{anchor:"huggingface_hub.InferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language to translate to. Required for models that can translate to multiple languages.`,name:"tgt_lang"},{anchor:"huggingface_hub.InferenceClient.translation.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.InferenceClient.translation.truncation",description:`<strong>truncation</strong> (<code>Literal[&quot;do_not_truncate&quot;, &quot;longest_first&quot;, &quot;only_first&quot;, &quot;only_second&quot;]</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"},{anchor:"huggingface_hub.InferenceClient.translation.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2632",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),Dt=new $({props:{anchor:"huggingface_hub.InferenceClient.translation.example",$$slots:{default:[vd]},$$scope:{ctx:T}}}),Ft=new $({props:{anchor:"huggingface_hub.InferenceClient.translation.example-2",$$slots:{default:[kd]},$$scope:{ctx:T}}}),ka=new A({props:{name:"visual_question_answering",anchor:"huggingface_hub.InferenceClient.visual_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"},{name:"top_k",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we
return less than topk answers if there are not enough options available within the
context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2713",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),Ht=new $({props:{anchor:"huggingface_hub.InferenceClient.visual_question_answering.example",$$slots:{default:[qd]},$$scope:{ctx:T}}}),qa=new A({props:{name:"zero_shot_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"labels",val:": List"},{name:"multi_label",val:": bool = False"},{name:"hypothesis_template",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>) &#x2014;
Boolean. If True, the probability for each label is evaluated independently and multiple labels can have a probability close to 1 simultaneously or all probabilities can be close to 0.
If False, the labels are considered mutually exclusive and the probability over all labels always sums to 1. Defaults to False.`,name:"multi_label"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A template sentence string with curly brackets to which the label strings are added. The label strings are added at the position of the curly brackets &#x201D;{}&#x201C;.
Zero-shot classifiers are based on NLI models, which evaluate if a hypothesis is entailed in another text or not.
For example, with hypothesis_template=&#x201C;This text is about {}.&#x201D; and labels=[&#x201C;economics&#x201D;, &#x201C;politics&#x201D;], the system internally creates the two hypotheses &#x201C;This text is about economics.&#x201D; and &#x201C;This text is about politics.&#x201D;.
The model then evaluates for both hypotheses if they are entailed in the provided <code>text</code> or not.`,name:"hypothesis_template"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot classification model will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2766",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ot=new $({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example",$$slots:{default:[Ad]},$$scope:{ctx:T}}}),Lt=new $({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example-2",$$slots:{default:[Ed]},$$scope:{ctx:T}}}),Aa=new A({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": Union"},{name:"labels",val:": List"},{name:"model",val:": Optional = None"},{name:"hypothesis_template",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot image classification model will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>labels</code> to attempt the text classification by replacing the
placeholder with the candidate labels.`,name:"hypothesis_template"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2868",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Pt=new $({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.example",$$slots:{default:[Zd]},$$scope:{ctx:T}}}),Ea=new _r({props:{title:"Async Inference Client",local:"huggingface_hub.AsyncInferenceClient",headingTag:"h2"}}),Na=new x({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),Wa=new A({props:{name:"class huggingface_hub.AsyncInferenceClient",anchor:"huggingface_hub.AsyncInferenceClient",parameters:[{name:"model",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"timeout",val:": Optional = None"},{name:"headers",val:": Optional = None"},{name:"cookies",val:": Optional = None"},{name:"trust_env",val:": bool = False"},{name:"proxies",val:": Optional = None"},{name:"base_url",val:": Optional = None"},{name:"api_key",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>meta-llama/Meta-Llama-3-8B-Instruct</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.
Note: for better compatibility with OpenAI&#x2019;s client, <code>model</code> has been aliased as <code>base_url</code>. Those 2
arguments are mutually exclusive. If using <code>base_url</code> for chat completion, the <code>/chat/completions</code> suffix
path will be appended to the base URL (see the <a href="https://huggingface.co/docs/text-generation-inference/en/messages_api" rel="nofollow">TGI Messages API</a>
documentation for details). When passing a URL as <code>model</code>, the client will not append any suffix path to it.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.
Note: for better compatibility with OpenAI&#x2019;s client, <code>token</code> has been aliased as <code>api_key</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"token"},{anchor:"huggingface_hub.AsyncInferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.AsyncInferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.AsyncInferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"},{anchor:"huggingface_hub.AsyncInferenceClient.trust_env",description:`<strong>trust_env</strong> (&#x2018;bool&#x2019;, &#x2018;optional&#x2019;) &#x2014;
Trust environment settings for proxy configuration if the parameter is <code>True</code> (<code>False</code> by default).`,name:"trust_env"},{anchor:"huggingface_hub.AsyncInferenceClient.proxies",description:`<strong>proxies</strong> (<code>Any</code>, <code>optional</code>) &#x2014;
Proxies to use for the request.`,name:"proxies"},{anchor:"huggingface_hub.AsyncInferenceClient.base_url",description:`<strong>base_url</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Base URL to run inference. This is a duplicated argument from <code>model</code> to make <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>model</code> is set. Defaults to None.`,name:"base_url"},{anchor:"huggingface_hub.AsyncInferenceClient.api_key",description:`<strong>api_key</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L102"}}),Ga=new A({props:{name:"audio_classification",anchor:"huggingface_hub.AsyncInferenceClient.audio_classification",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"function_to_apply",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;AudioClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the output.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L355",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Kt=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.example",$$slots:{default:[Nd]},$$scope:{ctx:T}}}),Ba=new A({props:{name:"audio_to_audio",anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L406",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),es=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.example",$$slots:{default:[Wd]},$$scope:{ctx:T}}}),Qa=new A({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L450",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ns=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.example",$$slots:{default:[Gd]},$$scope:{ctx:T}}}),Va=new A({props:{name:"chat_completion",anchor:"huggingface_hub.AsyncInferenceClient.chat_completion",parameters:[{name:"messages",val:": List"},{name:"model",val:": Optional = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"logit_bias",val:": Optional = None"},{name:"logprobs",val:": Optional = None"},{name:"max_tokens",val:": Optional = None"},{name:"n",val:": Optional = None"},{name:"presence_penalty",val:": Optional = None"},{name:"response_format",val:": Optional = None"},{name:"seed",val:": Optional = None"},{name:"stop",val:": Optional = None"},{name:"stream_options",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"tool_choice",val:": Union = None"},{name:"tool_prompt",val:": Optional = None"},{name:"tools",val:": Optional = None"},{name:"top_logprobs",val:": Optional = None"},{name:"top_p",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List of <a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputMessage">ChatCompletionInputMessage</a>) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.</p>
<p>If <code>model</code> is a model ID, it is passed to the server as the <code>model</code> parameter. If you want to define a
custom URL while setting <code>model</code> in the request payload, you must set <code>base_url</code> when initializing <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens
(specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically,
the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model,
but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should
result in a ban or exclusive selection of the relevant token. Defaults to None.`,name:"logit_bias"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 20.`,name:"max_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
UNUSED.`,name:"n"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.response_format",description:`<strong>response_format</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputGrammarType">ChatCompletionInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"response_format"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stop",description:`<strong>stop</strong> (Optional<code>str</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream_options",description:`<strong>stream_options</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputStreamOptions">ChatCompletionInputStreamOptions</a>, <em>optional</em>) &#x2014;
Options for streaming completions.`,name:"stream_options"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolType">ChatCompletionInputToolType</a> or <code>str</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ToolElement">ToolElement</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L562",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ts=new G({props:{$$slots:{default:[Bd]},$$scope:{ctx:T}}}),ss=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example",$$slots:{default:[Qd]},$$scope:{ctx:T}}}),as=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-2",$$slots:{default:[Vd]},$$scope:{ctx:T}}}),ls=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-3",$$slots:{default:[Sd]},$$scope:{ctx:T}}}),os=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-4",$$slots:{default:[Yd]},$$scope:{ctx:T}}}),rs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-5",$$slots:{default:[zd]},$$scope:{ctx:T}}}),is=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-6",$$slots:{default:[Rd]},$$scope:{ctx:T}}}),Sa=new A({props:{name:"close",anchor:"huggingface_hub.AsyncInferenceClient.close",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L344"}}),Ya=new A({props:{name:"document_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"},{name:"doc_stride",val:": Optional = None"},{name:"handle_impossible_answer",val:": Optional = None"},{name:"lang",val:": Optional = None"},{name:"max_answer_len",val:": Optional = None"},{name:"max_question_len",val:": Optional = None"},{name:"max_seq_len",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"word_boxes",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the words in the document are too long to fit with the question for the model, it will
be split in several chunks with some overlap. This argument controls the size of that
overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.lang",description:`<strong>lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language to use while running OCR.`,name:"lang"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are
considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk
passed to the model. The context will be split in several chunks (using doc_stride as
overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Can return less
than top_k answers if there are not enough options available within the context.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.word_boxes",description:`<strong>word_boxes</strong> (<code>List[Union[List[float], str]]</code>, <em>optional</em>) &#x2014;
A list of words and bounding boxes (normalized 0-&gt;1000). If provided, the inference will
skip the OCR step and use the provided bounding boxes instead.`,name:"word_boxes"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L956",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),cs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.example",$$slots:{default:[Xd]},$$scope:{ctx:T}}}),za=new A({props:{name:"feature_extraction",anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": Optional = None"},{name:"prompt_name",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"truncation_direction",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1040",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>aiohttp.ClientResponseError</code></p>
`}}),ps=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.example",$$slots:{default:[Dd]},$$scope:{ctx:T}}}),Ra=new A({props:{name:"fill_mask",anchor:"huggingface_hub.AsyncInferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"targets",val:": Optional = None"},{name:"top_k",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.targets",description:`<strong>targets</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
When passed, the model will limit the scores to the passed targets instead of looking up
in the whole vocabulary. If the provided targets are not in the model vocab, they will be
tokenized and the first resulting token will be used (with a warning, and that might be
slower).`,name:"targets"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When passed, overrides the number of predictions to return.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1107",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),us=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.example",$$slots:{default:[Fd]},$$scope:{ctx:T}}}),Xa=new A({props:{name:"get_endpoint_info",anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3092",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),gs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.example",$$slots:{default:[Hd]},$$scope:{ctx:T}}}),Da=new A({props:{name:"get_model_status",anchor:"huggingface_hub.AsyncInferenceClient.get_model_status",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3185",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),ms=new G({props:{$$slots:{default:[Od]},$$scope:{ctx:T}}}),hs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.example",$$slots:{default:[Ld]},$$scope:{ctx:T}}}),Fa=new A({props:{name:"get_recommended_model",anchor:"huggingface_hub.AsyncInferenceClient.get_recommended_model",parameters:[{name:"task",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_recommended_model.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The Hugging Face task to get which model Hugging Face recommends.
All available tasks can be found <a href="https://huggingface.co/tasks" rel="nofollow">here</a>.`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3068",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Name of the model recommended for the input task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If Hugging Face has no recommendation for the input task.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Ha=new A({props:{name:"health_check",anchor:"huggingface_hub.AsyncInferenceClient.health_check",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3149",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),fs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.health_check.example",$$slots:{default:[Pd]},$$scope:{ctx:T}}}),Oa=new A({props:{name:"image_classification",anchor:"huggingface_hub.AsyncInferenceClient.image_classification",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"},{name:"function_to_apply",val:": Optional = None"},{name:"top_k",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>Literal[&quot;sigmoid&quot;, &quot;softmax&quot;, &quot;none&quot;]</code>, <em>optional</em>) &#x2014;
The function to apply to the output scores.`,name:"function_to_apply"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1158",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ys=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.example",$$slots:{default:[Kd]},$$scope:{ctx:T}}}),La=new A({props:{name:"image_segmentation",anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"},{name:"mask_threshold",val:": Optional = None"},{name:"overlap_mask_area_threshold",val:": Optional = None"},{name:"subtask",val:": Optional = None"},{name:"threshold",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Mask overlap threshold to eliminate small, disconnected segments.`,name:"overlap_mask_area_threshold"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.subtask",description:`<strong>subtask</strong> (<code>Literal[&quot;instance&quot;, &quot;panoptic&quot;, &quot;semantic&quot;]</code>, <em>optional</em>) &#x2014;
Segmentation task to be performed, depending on model capabilities.`,name:"subtask"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Probability threshold to filter out predicted masks.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1202",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ms=new G({props:{warning:!0,$$slots:{default:[ef]},$$scope:{ctx:T}}}),bs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.example",$$slots:{default:[nf]},$$scope:{ctx:T}}}),Pa=new A({props:{name:"image_to_image",anchor:"huggingface_hub.AsyncInferenceClient.image_to_image",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Optional = None"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A negative prompt to guide the translation process.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1266",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),js=new G({props:{warning:!0,$$slots:{default:[tf]},$$scope:{ctx:T}}}),_s=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.example",$$slots:{default:[sf]},$$scope:{ctx:T}}}),Ka=new A({props:{name:"image_to_text",anchor:"huggingface_hub.AsyncInferenceClient.image_to_text",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1340",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ts=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.example",$$slots:{default:[af]},$$scope:{ctx:T}}}),el=new A({props:{name:"list_deployed_models",anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1378",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),Is=new G({props:{warning:!0,$$slots:{default:[lf]},$$scope:{ctx:T}}}),Js=new G({props:{$$slots:{default:[of]},$$scope:{ctx:T}}}),ws=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.example",$$slots:{default:[rf]},$$scope:{ctx:T}}}),nl=new A({props:{name:"object_detection",anchor:"huggingface_hub.AsyncInferenceClient.object_detection",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"},{name:"threshold",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The probability necessary to make a prediction.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1467",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),xs=new G({props:{warning:!0,$$slots:{default:[cf]},$$scope:{ctx:T}}}),Cs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.example",$$slots:{default:[pf]},$$scope:{ctx:T}}}),tl=new A({props:{name:"post",anchor:"huggingface_hub.AsyncInferenceClient.post",parameters:[{name:"json",val:": Union = None"},{name:"data",val:": Union = None"},{name:"model",val:": Optional = None"},{name:"task",val:": Optional = None"},{name:"stream",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.post.json",description:`<strong>json</strong> (<code>Union[str, Dict, List]</code>, <em>optional</em>) &#x2014;
The JSON data to send in the request body, specific to each task. Defaults to None.`,name:"json"},{anchor:"huggingface_hub.AsyncInferenceClient.post.data",description:`<strong>data</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>, <em>optional</em>) &#x2014;
The content to send in the request body, specific to each task.
It can be raw bytes, a pointer to an opened file, a local file path,
or a URL to an online resource (image, audio file,&#x2026;). If both <code>json</code> and <code>data</code> are passed,
<code>data</code> will take precedence. At least <code>json</code> or <code>data</code> must be provided. Defaults to None.`,name:"data"},{anchor:"huggingface_hub.AsyncInferenceClient.post.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. Will override the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.post.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task to perform on the inference. All available tasks can be found
<a href="https://huggingface.co/tasks" rel="nofollow">here</a>. Used only to default to a recommended model if <code>model</code> is not
provided. At least <code>model</code> or <code>task</code> must be provided. Defaults to None.`,name:"task"},{anchor:"huggingface_hub.AsyncInferenceClient.post.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to iterate over streaming APIs.`,name:"stream"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L223",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The raw bytes returned by the server.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bytes</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),sl=new A({props:{name:"question_answering",anchor:"huggingface_hub.AsyncInferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": Optional = None"},{name:"align_to_words",val:": Optional = None"},{name:"doc_stride",val:": Optional = None"},{name:"handle_impossible_answer",val:": Optional = None"},{name:"max_answer_len",val:": Optional = None"},{name:"max_question_len",val:": Optional = None"},{name:"max_seq_len",val:": Optional = None"},{name:"top_k",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.align_to_words",description:`<strong>align_to_words</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Attempts to align the answer to real words. Improves quality on space separated
languages. Might hurt on non-space-separated languages (like Japanese or Chinese).`,name:"align_to_words"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the context is too long to fit with the question for the model, it will be split in
several chunks with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are
considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk
passed to the model. The context will be split in several chunks (using docStride as
overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we
return less than topk answers if there are not enough options available within the
context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1514",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>When top_k is 1 or not provided, it returns a single <code>QuestionAnsweringOutputElement</code>.
When top_k is greater than 1, it returns a list of <code>QuestionAnsweringOutputElement</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Union[<code>QuestionAnsweringOutputElement</code>, List<a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),$s=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.example",$$slots:{default:[uf]},$$scope:{ctx:T}}}),al=new A({props:{name:"sentence_similarity",anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1599",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),vs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.example",$$slots:{default:[gf]},$$scope:{ctx:T}}}),ll=new A({props:{name:"summarization",anchor:"huggingface_hub.AsyncInferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"clean_up_tokenization_spaces",val:": Optional = None"},{name:"generate_parameters",val:": Optional = None"},{name:"truncation",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for summarization. Check out this <a href="https://huggingface.co/docs/api-inference/detailed_parameters#summarization-task" rel="nofollow">page</a>
for more details.`,name:"parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for summarization will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.truncation",description:`<strong>truncation</strong> (<code>Literal[&quot;do_not_truncate&quot;, &quot;longest_first&quot;, &quot;only_first&quot;, &quot;only_second&quot;]</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1647",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ks=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.summarization.example",$$slots:{default:[mf]},$$scope:{ctx:T}}}),ol=new A({props:{name:"table_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering",parameters:[{name:"table",val:": Dict"},{name:"query",val:": str"},{name:"model",val:": Optional = None"},{name:"parameters",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional inference parameters. Defaults to None.`,name:"parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1711",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),qs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.example",$$slots:{default:[hf]},$$scope:{ctx:T}}}),rl=new A({props:{name:"tabular_classification",anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1766",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),As=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.example",$$slots:{default:[df]},$$scope:{ctx:T}}}),il=new A({props:{name:"tabular_regression",anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1816",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Es=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.example",$$slots:{default:[ff]},$$scope:{ctx:T}}}),cl=new A({props:{name:"text_classification",anchor:"huggingface_hub.AsyncInferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"function_to_apply",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;TextClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the output.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1857",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Zs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.example",$$slots:{default:[yf]},$$scope:{ctx:T}}}),pl=new A({props:{name:"text_generation",anchor:"huggingface_hub.AsyncInferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": Optional = None"},{name:"adapter_id",val:": Optional = None"},{name:"best_of",val:": Optional = None"},{name:"decoder_input_details",val:": Optional = None"},{name:"do_sample",val:": Optional = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"grammar",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"},{name:"repetition_penalty",val:": Optional = None"},{name:"return_full_text",val:": Optional = False"},{name:"seed",val:": Optional = None"},{name:"stop",val:": Optional = None"},{name:"stop_sequences",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"top_n_tokens",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"typical_p",val:": Optional = None"},{name:"watermark",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.adapter_id",description:`<strong>adapter_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Lora adapter id.`,name:"adapter_id"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop</code> is generated.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Deprecated argument. Use <code>stop</code> instead.`,name:"stop_sequences"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2063",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ns=new G({props:{$$slots:{default:[Mf]},$$scope:{ctx:T}}}),Ws=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.example",$$slots:{default:[bf]},$$scope:{ctx:T}}}),ul=new A({props:{name:"text_to_image",anchor:"huggingface_hub.AsyncInferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"scheduler",val:": Optional = None"},{name:"target_size",val:": Optional = None"},{name:"seed",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional negative prompt for the image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-image model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.scheduler",description:`<strong>scheduler</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Override the scheduler with a compatible one.`,name:"scheduler"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.target_size",description:`<strong>target_size</strong> (<code>TextToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image`,name:"target_size"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2410",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Gs=new G({props:{warning:!0,$$slots:{default:[jf]},$$scope:{ctx:T}}}),Bs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example",$$slots:{default:[_f]},$$scope:{ctx:T}}}),gl=new A({props:{name:"text_to_speech",anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"do_sample",val:": Optional = None"},{name:"early_stopping",val:": Union = None"},{name:"epsilon_cutoff",val:": Optional = None"},{name:"eta_cutoff",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"},{name:"min_length",val:": Optional = None"},{name:"min_new_tokens",val:": Optional = None"},{name:"num_beam_groups",val:": Optional = None"},{name:"num_beams",val:": Optional = None"},{name:"penalty_alpha",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"typical_p",val:": Optional = None"},{name:"use_cache",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-speech model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use sampling instead of greedy decoding when generating new tokens.`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.early_stopping",description:`<strong>early_stopping</strong> (<code>Union[bool, &quot;TextToSpeechEarlyStoppingEnum&quot;</code>, <em>optional</em>) &#x2014;
Controls the stopping condition for beam-based methods.`,name:"early_stopping"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability
greater than epsilon_cutoff will be sampled. In the paper, suggested values range from
3e-4 to 9e-4, depending on the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language
Model Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to
float strictly between 0 and 1, a token is only considered if it is greater than either
eta_cutoff or sqrt(eta_cutoff) * exp(-entropy(softmax(next_token_logits))). The latter
term is intuitively the expected next token probability, scaled by sqrt(eta_cutoff). In
the paper, suggested values range from 3e-4 to 2e-3, depending on the size of the model.
See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model Desmoothing</a>
for more details.`,name:"eta_cutoff"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length (in tokens) of the generated text, including the input.`,name:"max_length"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of tokens to generate. Takes precedence over maxLength.`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum length (in tokens) of the generated text, including the input.`,name:"min_length"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of tokens to generate. Takes precedence over maxLength.`,name:"min_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of groups to divide num_beams into in order to ensure diversity among different
groups of beams. See <a href="https://hf.co/papers/1610.02424" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams to use for beam search.`,name:"num_beams"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value balances the model confidence and the degeneration penalty in contrastive
search decoding.`,name:"penalty_alpha"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities
that add up to top_p or higher are kept for generation.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is
to the expected conditional probability of predicting a random token next, given the partial text
already generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with
probabilities that add up to typical_p or higher are kept for generation. See <a href="https://hf.co/papers/2202.00666" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the model should use the past last key/values attentions to speed up decoding`,name:"use_cache"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2502",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Qs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example",$$slots:{default:[Tf]},$$scope:{ctx:T}}}),ml=new A({props:{name:"token_classification",anchor:"huggingface_hub.AsyncInferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"aggregation_strategy",val:": Optional = None"},{name:"ignore_labels",val:": Optional = None"},{name:"stride",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.aggregation_strategy",description:`<strong>aggregation_strategy</strong> (<code>Literal[&quot;none&quot;, &quot;simple&quot;, &quot;first&quot;, &quot;average&quot;, &quot;max&quot;]</code>, <em>optional</em>) &#x2014;
The strategy used to fuse tokens based on model predictions.`,name:"aggregation_strategy"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.ignore_labels",description:`<strong>ignore_labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of labels to ignore.`,name:"ignore_labels"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of overlapping tokens between chunks when splitting the input text.`,name:"stride"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2625",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Vs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.example",$$slots:{default:[If]},$$scope:{ctx:T}}}),hl=new A({props:{name:"translation",anchor:"huggingface_hub.AsyncInferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"src_lang",val:": Optional = None"},{name:"tgt_lang",val:": Optional = None"},{name:"clean_up_tokenization_spaces",val:": Optional = None"},{name:"truncation",val:": Optional = None"},{name:"generate_parameters",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The source language of the text. Required for models that can translate from multiple languages.`,name:"src_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language to translate to. Required for models that can translate to multiple languages.`,name:"tgt_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.truncation",description:`<strong>truncation</strong> (<code>Literal[&quot;do_not_truncate&quot;, &quot;longest_first&quot;, &quot;only_first&quot;, &quot;only_second&quot;]</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2699",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),Ss=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example",$$slots:{default:[Jf]},$$scope:{ctx:T}}}),Ys=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example-2",$$slots:{default:[wf]},$$scope:{ctx:T}}}),dl=new A({props:{name:"visual_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"},{name:"top_k",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we
return less than topk answers if there are not enough options available within the
context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2781",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),zs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.example",$$slots:{default:[xf]},$$scope:{ctx:T}}}),fl=new A({props:{name:"zero_shot_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"labels",val:": List"},{name:"multi_label",val:": bool = False"},{name:"hypothesis_template",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>) &#x2014;
Boolean. If True, the probability for each label is evaluated independently and multiple labels can have a probability close to 1 simultaneously or all probabilities can be close to 0.
If False, the labels are considered mutually exclusive and the probability over all labels always sums to 1. Defaults to False.`,name:"multi_label"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A template sentence string with curly brackets to which the label strings are added. The label strings are added at the position of the curly brackets &#x201D;{}&#x201C;.
Zero-shot classifiers are based on NLI models, which evaluate if a hypothesis is entailed in another text or not.
For example, with hypothesis_template=&#x201C;This text is about {}.&#x201D; and labels=[&#x201C;economics&#x201D;, &#x201C;politics&#x201D;], the system internally creates the two hypotheses &#x201C;This text is about economics.&#x201D; and &#x201C;This text is about politics.&#x201D;.
The model then evaluates for both hypotheses if they are entailed in the provided <code>text</code> or not.`,name:"hypothesis_template"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot classification model will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2835",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Rs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example",$$slots:{default:[Cf]},$$scope:{ctx:T}}}),Xs=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example-2",$$slots:{default:[Uf]},$$scope:{ctx:T}}}),yl=new A({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": Union"},{name:"labels",val:": List"},{name:"model",val:": Optional = None"},{name:"hypothesis_template",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot image classification model will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>labels</code> to attempt the text classification by replacing the
placeholder with the candidate labels.`,name:"hypothesis_template"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2939",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ds=new $({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.example",$$slots:{default:[$f]},$$scope:{ctx:T}}}),Ml=new _r({props:{title:"InferenceTimeoutError",local:"huggingface_hub.InferenceTimeoutError",headingTag:"h2"}}),bl=new A({props:{name:"class huggingface_hub.InferenceTimeoutError",anchor:"huggingface_hub.InferenceTimeoutError",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L92"}}),jl=new _r({props:{title:"ModelStatus",local:"huggingface_hub.inference._common.ModelStatus",headingTag:"h3"}}),_l=new A({props:{name:"class huggingface_hub.inference._common.ModelStatus",anchor:"huggingface_hub.inference._common.ModelStatus",parameters:[{name:"loaded",val:": bool"},{name:"state",val:": str"},{name:"compute_type",val:": Dict"},{name:"framework",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.inference._common.ModelStatus.loaded",description:`<strong>loaded</strong> (<code>bool</code>) &#x2014;
If the model is currently loaded into Hugging Face&#x2019;s InferenceAPI. Models
are loaded on-demand, leading to the user&#x2019;s first request taking longer.
If a model is loaded, you can be assured that it is in a healthy state.`,name:"loaded"},{anchor:"huggingface_hub.inference._common.ModelStatus.state",description:`<strong>state</strong> (<code>str</code>) &#x2014;
The current state of the model. This can be &#x2018;Loaded&#x2019;, &#x2018;Loadable&#x2019;, &#x2018;TooBig&#x2019;.
If a model&#x2019;s state is &#x2018;Loadable&#x2019;, it&#x2019;s not too big and has a supported
backend. Loadable models are automatically loaded when the user first
requests inference on the endpoint. This means it is transparent for the
user to load a model, except that the first call takes longer to complete.`,name:"state"},{anchor:"huggingface_hub.inference._common.ModelStatus.compute_type",description:`<strong>compute_type</strong> (<code>Dict</code>) &#x2014;
Information about the compute resource the model is using or will use, such as &#x2018;gpu&#x2019; type and number of
replicas.`,name:"compute_type"},{anchor:"huggingface_hub.inference._common.ModelStatus.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The name of the framework that the model was built with, such as &#x2018;transformers&#x2019;
or &#x2018;text-generation-inference&#x2019;.`,name:"framework"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_common.py#L81"}}),Tl=new _r({props:{title:"InferenceAPI",local:"huggingface_hub.InferenceApi",headingTag:"h2"}}),Jl=new A({props:{name:"class huggingface_hub.InferenceApi",anchor:"huggingface_hub.InferenceApi",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"gpu",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L46"}}),Fs=new $({props:{anchor:"huggingface_hub.InferenceApi.example",$$slots:{default:[vf]},$$scope:{ctx:T}}}),wl=new A({props:{name:"__init__",anchor:"huggingface_hub.InferenceApi.__init__",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"gpu",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__init__.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
Id of repository (e.g. <em>user/bert-base-uncased</em>).`,name:"repo_id"},{anchor:"huggingface_hub.InferenceApi.__init__.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>, defaults <code>None</code>) &#x2014;
Whether to force a task instead of using task specified in the
repository.`,name:"task"},{anchor:"huggingface_hub.InferenceApi.__init__.token",description:`<strong>token</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The API token to use as HTTP bearer authorization. This is not
the authentication token. You can find the token in
<a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>. Alternatively, you can
find both your organizations and personal API tokens using
<em>HfApi().whoami(token)</em>.`,name:"token"},{anchor:"huggingface_hub.InferenceApi.__init__.gpu",description:`<strong>gpu</strong> (<em>bool</em>, <em>optional</em>, defaults <em>False</em>) &#x2014;
Whether to use GPU instead of CPU for inference(requires Startup
plan at least).`,name:"gpu"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L93"}}),xl=new A({props:{name:"__call__",anchor:"huggingface_hub.InferenceApi.__call__",parameters:[{name:"inputs",val:": Union = None"},{name:"params",val:": Optional = None"},{name:"data",val:": Optional = None"},{name:"raw_response",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code> or <code>Dict</code> or <code>List[str]</code> or <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
Inputs for the prediction.`,name:"inputs"},{anchor:"huggingface_hub.InferenceApi.__call__.params",description:`<strong>params</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional parameters for the models. Will be sent as <code>parameters</code> in the
payload.`,name:"params"},{anchor:"huggingface_hub.InferenceApi.__call__.data",description:`<strong>data</strong> (<code>bytes</code>, <em>optional</em>) &#x2014;
Bytes content of the request. In this case, leave <code>inputs</code> and <code>params</code> empty.`,name:"data"},{anchor:"huggingface_hub.InferenceApi.__call__.raw_response",description:`<strong>raw_response</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the raw <code>Response</code> object is returned. You can parse its content
as preferred. By default, the content is parsed into a more practical format
(json dictionary or PIL Image for example).`,name:"raw_response"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L158"}}),Cl=new Sh({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/inference_client.md"}}),{c(){n=g("meta"),p=r(),a=g("p"),t=r(),h(o.$$.fragment),e=r(),c=g("p"),c.innerHTML=Cg,Ir=r(),Ls=g("ul"),Ls.innerHTML=Ug,Jr=r(),Ps=g("p"),Ps.innerHTML=$g,wr=r(),h(Ks.$$.fragment),xr=r(),C=g("div"),h(ea.$$.fragment),Vr=r(),Nl=g("p"),Nl.textContent=vg,Sr=r(),Wl=g("p"),Wl.innerHTML=kg,Yr=r(),We=g("div"),h(na.$$.fragment),zr=r(),Gl=g("p"),Gl.textContent=qg,Rr=r(),h(at.$$.fragment),Xr=r(),Ge=g("div"),h(ta.$$.fragment),Dr=r(),Bl=g("p"),Bl.textContent=Ag,Fr=r(),h(lt.$$.fragment),Hr=r(),Be=g("div"),h(sa.$$.fragment),Or=r(),Ql=g("p"),Ql.textContent=Eg,Lr=r(),h(ot.$$.fragment),Pr=r(),E=g("div"),h(aa.$$.fragment),Kr=r(),Vl=g("p"),Vl.textContent=Zg,ei=r(),h(rt.$$.fragment),ni=r(),h(it.$$.fragment),ti=r(),h(ct.$$.fragment),si=r(),h(pt.$$.fragment),ai=r(),h(ut.$$.fragment),li=r(),h(gt.$$.fragment),oi=r(),h(mt.$$.fragment),ri=r(),Qe=g("div"),h(la.$$.fragment),ii=r(),Sl=g("p"),Sl.textContent=Ng,ci=r(),h(ht.$$.fragment),pi=r(),Ve=g("div"),h(oa.$$.fragment),ui=r(),Yl=g("p"),Yl.textContent=Wg,gi=r(),h(dt.$$.fragment),mi=r(),Se=g("div"),h(ra.$$.fragment),hi=r(),zl=g("p"),zl.textContent=Gg,di=r(),h(ft.$$.fragment),fi=r(),K=g("div"),h(ia.$$.fragment),yi=r(),Rl=g("p"),Rl.textContent=Bg,Mi=r(),Xl=g("p"),Xl.innerHTML=Qg,bi=r(),h(yt.$$.fragment),ji=r(),ee=g("div"),h(ca.$$.fragment),_i=r(),Dl=g("p"),Dl.textContent=Vg,Ti=r(),h(Mt.$$.fragment),Ii=r(),h(bt.$$.fragment),Ji=r(),jt=g("div"),h(pa.$$.fragment),wi=r(),Fl=g("p"),Fl.textContent=Sg,xi=r(),ne=g("div"),h(ua.$$.fragment),Ci=r(),Hl=g("p"),Hl.textContent=Yg,Ui=r(),Ol=g("p"),Ol.innerHTML=zg,$i=r(),h(_t.$$.fragment),vi=r(),Ye=g("div"),h(ga.$$.fragment),ki=r(),Ll=g("p"),Ll.textContent=Rg,qi=r(),h(Tt.$$.fragment),Ai=r(),te=g("div"),h(ma.$$.fragment),Ei=r(),Pl=g("p"),Pl.textContent=Xg,Zi=r(),h(It.$$.fragment),Ni=r(),h(Jt.$$.fragment),Wi=r(),se=g("div"),h(ha.$$.fragment),Gi=r(),Kl=g("p"),Kl.textContent=Dg,Bi=r(),h(wt.$$.fragment),Qi=r(),h(xt.$$.fragment),Vi=r(),ae=g("div"),h(da.$$.fragment),Si=r(),eo=g("p"),eo.textContent=Fg,Yi=r(),no=g("p"),no.textContent=Hg,zi=r(),h(Ct.$$.fragment),Ri=r(),B=g("div"),h(fa.$$.fragment),Xi=r(),to=g("p"),to.textContent=Og,Di=r(),so=g("p"),so.innerHTML=Lg,Fi=r(),h(Ut.$$.fragment),Hi=r(),h($t.$$.fragment),Oi=r(),h(vt.$$.fragment),Li=r(),le=g("div"),h(ya.$$.fragment),Pi=r(),ao=g("p"),ao.textContent=Pg,Ki=r(),h(kt.$$.fragment),ec=r(),h(qt.$$.fragment),nc=r(),At=g("div"),h(Ma.$$.fragment),tc=r(),lo=g("p"),lo.textContent=Kg,sc=r(),ze=g("div"),h(ba.$$.fragment),ac=r(),oo=g("p"),oo.textContent=em,lc=r(),h(Et.$$.fragment),oc=r(),Re=g("div"),h(ja.$$.fragment),rc=r(),ro=g("p"),ro.textContent=nm,ic=r(),h(Zt.$$.fragment),cc=r(),Xe=g("div"),h(_a.$$.fragment),pc=r(),io=g("p"),io.textContent=tm,uc=r(),h(Nt.$$.fragment),gc=r(),De=g("div"),h(Ta.$$.fragment),mc=r(),co=g("p"),co.textContent=sm,hc=r(),h(Wt.$$.fragment),dc=r(),Fe=g("div"),h(Ia.$$.fragment),fc=r(),po=g("p"),po.textContent=am,yc=r(),h(Gt.$$.fragment),Mc=r(),He=g("div"),h(Ja.$$.fragment),bc=r(),uo=g("p"),uo.textContent=lm,jc=r(),h(Bt.$$.fragment),_c=r(),Oe=g("div"),h(wa.$$.fragment),Tc=r(),go=g("p"),go.textContent=om,Ic=r(),h(Qt.$$.fragment),Jc=r(),Q=g("div"),h(xa.$$.fragment),wc=r(),mo=g("p"),mo.textContent=rm,xc=r(),ho=g("p"),ho.innerHTML=im,Cc=r(),fo=g("p"),fo.innerHTML=cm,Uc=r(),h(Vt.$$.fragment),$c=r(),h(St.$$.fragment),vc=r(),oe=g("div"),h(Ca.$$.fragment),kc=r(),yo=g("p"),yo.textContent=pm,qc=r(),h(Yt.$$.fragment),Ac=r(),h(zt.$$.fragment),Ec=r(),Le=g("div"),h(Ua.$$.fragment),Zc=r(),Mo=g("p"),Mo.textContent=um,Nc=r(),h(Rt.$$.fragment),Wc=r(),Pe=g("div"),h($a.$$.fragment),Gc=r(),bo=g("p"),bo.textContent=gm,Bc=r(),h(Xt.$$.fragment),Qc=r(),F=g("div"),h(va.$$.fragment),Vc=r(),jo=g("p"),jo.textContent=mm,Sc=r(),_o=g("p"),_o.innerHTML=hm,Yc=r(),h(Dt.$$.fragment),zc=r(),h(Ft.$$.fragment),Rc=r(),Ke=g("div"),h(ka.$$.fragment),Xc=r(),To=g("p"),To.textContent=dm,Dc=r(),h(Ht.$$.fragment),Fc=r(),re=g("div"),h(qa.$$.fragment),Hc=r(),Io=g("p"),Io.textContent=fm,Oc=r(),h(Ot.$$.fragment),Lc=r(),h(Lt.$$.fragment),Pc=r(),en=g("div"),h(Aa.$$.fragment),Kc=r(),Jo=g("p"),Jo.textContent=ym,ep=r(),h(Pt.$$.fragment),Cr=r(),h(Ea.$$.fragment),Ur=r(),Za=g("p"),Za.innerHTML=Mm,$r=r(),h(Na.$$.fragment),vr=r(),w=g("div"),h(Wa.$$.fragment),np=r(),wo=g("p"),wo.textContent=bm,tp=r(),xo=g("p"),xo.innerHTML=jm,sp=r(),nn=g("div"),h(Ga.$$.fragment),ap=r(),Co=g("p"),Co.textContent=_m,lp=r(),h(Kt.$$.fragment),op=r(),tn=g("div"),h(Ba.$$.fragment),rp=r(),Uo=g("p"),Uo.textContent=Tm,ip=r(),h(es.$$.fragment),cp=r(),sn=g("div"),h(Qa.$$.fragment),pp=r(),$o=g("p"),$o.textContent=Im,up=r(),h(ns.$$.fragment),gp=r(),Z=g("div"),h(Va.$$.fragment),mp=r(),vo=g("p"),vo.textContent=Jm,hp=r(),h(ts.$$.fragment),dp=r(),h(ss.$$.fragment),fp=r(),h(as.$$.fragment),yp=r(),h(ls.$$.fragment),Mp=r(),h(os.$$.fragment),bp=r(),h(rs.$$.fragment),jp=r(),h(is.$$.fragment),_p=r(),ie=g("div"),h(Sa.$$.fragment),Tp=r(),ko=g("p"),ko.textContent=wm,Ip=r(),qo=g("p"),qo.textContent=xm,Jp=r(),Ao=g("p"),Ao.innerHTML=Cm,wp=r(),an=g("div"),h(Ya.$$.fragment),xp=r(),Eo=g("p"),Eo.textContent=Um,Cp=r(),h(cs.$$.fragment),Up=r(),ln=g("div"),h(za.$$.fragment),$p=r(),Zo=g("p"),Zo.textContent=$m,vp=r(),h(ps.$$.fragment),kp=r(),on=g("div"),h(Ra.$$.fragment),qp=r(),No=g("p"),No.textContent=vm,Ap=r(),h(us.$$.fragment),Ep=r(),ce=g("div"),h(Xa.$$.fragment),Zp=r(),Wo=g("p"),Wo.textContent=km,Np=r(),Go=g("p"),Go.innerHTML=qm,Wp=r(),h(gs.$$.fragment),Gp=r(),pe=g("div"),h(Da.$$.fragment),Bp=r(),Bo=g("p"),Bo.textContent=Am,Qp=r(),h(ms.$$.fragment),Vp=r(),h(hs.$$.fragment),Sp=r(),ds=g("div"),h(Fa.$$.fragment),Yp=r(),Qo=g("p"),Qo.textContent=Em,zp=r(),ue=g("div"),h(Ha.$$.fragment),Rp=r(),Vo=g("p"),Vo.textContent=Zm,Xp=r(),So=g("p"),So.innerHTML=Nm,Dp=r(),h(fs.$$.fragment),Fp=r(),rn=g("div"),h(Oa.$$.fragment),Hp=r(),Yo=g("p"),Yo.textContent=Wm,Op=r(),h(ys.$$.fragment),Lp=r(),ge=g("div"),h(La.$$.fragment),Pp=r(),zo=g("p"),zo.textContent=Gm,Kp=r(),h(Ms.$$.fragment),eu=r(),h(bs.$$.fragment),nu=r(),me=g("div"),h(Pa.$$.fragment),tu=r(),Ro=g("p"),Ro.textContent=Bm,su=r(),h(js.$$.fragment),au=r(),h(_s.$$.fragment),lu=r(),he=g("div"),h(Ka.$$.fragment),ou=r(),Xo=g("p"),Xo.textContent=Qm,ru=r(),Do=g("p"),Do.textContent=Vm,iu=r(),h(Ts.$$.fragment),cu=r(),V=g("div"),h(el.$$.fragment),pu=r(),Fo=g("p"),Fo.textContent=Sm,uu=r(),Ho=g("p"),Ho.innerHTML=Ym,gu=r(),h(Is.$$.fragment),mu=r(),h(Js.$$.fragment),hu=r(),h(ws.$$.fragment),du=r(),de=g("div"),h(nl.$$.fragment),fu=r(),Oo=g("p"),Oo.textContent=zm,yu=r(),h(xs.$$.fragment),Mu=r(),h(Cs.$$.fragment),bu=r(),Us=g("div"),h(tl.$$.fragment),ju=r(),Lo=g("p"),Lo.textContent=Rm,_u=r(),cn=g("div"),h(sl.$$.fragment),Tu=r(),Po=g("p"),Po.textContent=Xm,Iu=r(),h($s.$$.fragment),Ju=r(),pn=g("div"),h(al.$$.fragment),wu=r(),Ko=g("p"),Ko.textContent=Dm,xu=r(),h(vs.$$.fragment),Cu=r(),un=g("div"),h(ll.$$.fragment),Uu=r(),er=g("p"),er.textContent=Fm,$u=r(),h(ks.$$.fragment),vu=r(),gn=g("div"),h(ol.$$.fragment),ku=r(),nr=g("p"),nr.textContent=Hm,qu=r(),h(qs.$$.fragment),Au=r(),mn=g("div"),h(rl.$$.fragment),Eu=r(),tr=g("p"),tr.textContent=Om,Zu=r(),h(As.$$.fragment),Nu=r(),hn=g("div"),h(il.$$.fragment),Wu=r(),sr=g("p"),sr.textContent=Lm,Gu=r(),h(Es.$$.fragment),Bu=r(),dn=g("div"),h(cl.$$.fragment),Qu=r(),ar=g("p"),ar.textContent=Pm,Vu=r(),h(Zs.$$.fragment),Su=r(),S=g("div"),h(pl.$$.fragment),Yu=r(),lr=g("p"),lr.textContent=Km,zu=r(),or=g("p"),or.innerHTML=eh,Ru=r(),rr=g("p"),rr.innerHTML=nh,Xu=r(),h(Ns.$$.fragment),Du=r(),h(Ws.$$.fragment),Fu=r(),fe=g("div"),h(ul.$$.fragment),Hu=r(),ir=g("p"),ir.textContent=th,Ou=r(),h(Gs.$$.fragment),Lu=r(),h(Bs.$$.fragment),Pu=r(),fn=g("div"),h(gl.$$.fragment),Ku=r(),cr=g("p"),cr.textContent=sh,eg=r(),h(Qs.$$.fragment),ng=r(),yn=g("div"),h(ml.$$.fragment),tg=r(),pr=g("p"),pr.textContent=ah,sg=r(),h(Vs.$$.fragment),ag=r(),H=g("div"),h(hl.$$.fragment),lg=r(),ur=g("p"),ur.textContent=lh,og=r(),gr=g("p"),gr.innerHTML=oh,rg=r(),h(Ss.$$.fragment),ig=r(),h(Ys.$$.fragment),cg=r(),Mn=g("div"),h(dl.$$.fragment),pg=r(),mr=g("p"),mr.textContent=rh,ug=r(),h(zs.$$.fragment),gg=r(),ye=g("div"),h(fl.$$.fragment),mg=r(),hr=g("p"),hr.textContent=ih,hg=r(),h(Rs.$$.fragment),dg=r(),h(Xs.$$.fragment),fg=r(),bn=g("div"),h(yl.$$.fragment),yg=r(),dr=g("p"),dr.textContent=ch,Mg=r(),h(Ds.$$.fragment),kr=r(),h(Ml.$$.fragment),qr=r(),jn=g("div"),h(bl.$$.fragment),bg=r(),fr=g("p"),fr.textContent=ph,Ar=r(),h(jl.$$.fragment),Er=r(),_n=g("div"),h(_l.$$.fragment),jg=r(),yr=g("p"),yr.textContent=uh,Zr=r(),h(Tl.$$.fragment),Nr=r(),Il=g("p"),Il.innerHTML=gh,Wr=r(),Y=g("div"),h(Jl.$$.fragment),_g=r(),Mr=g("p"),Mr.textContent=mh,Tg=r(),h(Fs.$$.fragment),Ig=r(),Hs=g("div"),h(wl.$$.fragment),Jg=r(),br=g("p"),br.textContent=hh,wg=r(),Os=g("div"),h(xl.$$.fragment),xg=r(),jr=g("p"),jr.textContent=dh,Gr=r(),h(Cl.$$.fragment),Br=r(),Tr=g("p"),this.h()},l(s){const j=Vh("svelte-u9bgzb",document.head);n=m(j,"META",{name:!0,content:!0}),j.forEach(u),p=i(s),a=m(s,"P",{}),v(a).forEach(u),t=i(s),d(o.$$.fragment,s),e=i(s),c=m(s,"P",{"data-svelte-h":!0}),I(c)!=="svelte-411gzg"&&(c.innerHTML=Cg),Ir=i(s),Ls=m(s,"UL",{"data-svelte-h":!0}),I(Ls)!=="svelte-1qqordt"&&(Ls.innerHTML=Ug),Jr=i(s),Ps=m(s,"P",{"data-svelte-h":!0}),I(Ps)!=="svelte-s9duup"&&(Ps.innerHTML=$g),wr=i(s),d(Ks.$$.fragment,s),xr=i(s),C=m(s,"DIV",{class:!0});var q=v(C);d(ea.$$.fragment,q),Vr=i(q),Nl=m(q,"P",{"data-svelte-h":!0}),I(Nl)!=="svelte-1p4u01l"&&(Nl.textContent=vg),Sr=i(q),Wl=m(q,"P",{"data-svelte-h":!0}),I(Wl)!=="svelte-rlzjhe"&&(Wl.innerHTML=kg),Yr=i(q),We=m(q,"DIV",{class:!0});var Tn=v(We);d(na.$$.fragment,Tn),zr=i(Tn),Gl=m(Tn,"P",{"data-svelte-h":!0}),I(Gl)!=="svelte-1hs5qib"&&(Gl.textContent=qg),Rr=i(Tn),d(at.$$.fragment,Tn),Tn.forEach(u),Xr=i(q),Ge=m(q,"DIV",{class:!0});var In=v(Ge);d(ta.$$.fragment,In),Dr=i(In),Bl=m(In,"P",{"data-svelte-h":!0}),I(Bl)!=="svelte-z9e742"&&(Bl.textContent=Ag),Fr=i(In),d(lt.$$.fragment,In),In.forEach(u),Hr=i(q),Be=m(q,"DIV",{class:!0});var Jn=v(Be);d(sa.$$.fragment,Jn),Or=i(Jn),Ql=m(Jn,"P",{"data-svelte-h":!0}),I(Ql)!=="svelte-lahnll"&&(Ql.textContent=Eg),Lr=i(Jn),d(ot.$$.fragment,Jn),Jn.forEach(u),Pr=i(q),E=m(q,"DIV",{class:!0});var N=v(E);d(aa.$$.fragment,N),Kr=i(N),Vl=m(N,"P",{"data-svelte-h":!0}),I(Vl)!=="svelte-5o70yf"&&(Vl.textContent=Zg),ei=i(N),d(rt.$$.fragment,N),ni=i(N),d(it.$$.fragment,N),ti=i(N),d(ct.$$.fragment,N),si=i(N),d(pt.$$.fragment,N),ai=i(N),d(ut.$$.fragment,N),li=i(N),d(gt.$$.fragment,N),oi=i(N),d(mt.$$.fragment,N),N.forEach(u),ri=i(q),Qe=m(q,"DIV",{class:!0});var wn=v(Qe);d(la.$$.fragment,wn),ii=i(wn),Sl=m(wn,"P",{"data-svelte-h":!0}),I(Sl)!=="svelte-qs8cmr"&&(Sl.textContent=Ng),ci=i(wn),d(ht.$$.fragment,wn),wn.forEach(u),pi=i(q),Ve=m(q,"DIV",{class:!0});var xn=v(Ve);d(oa.$$.fragment,xn),ui=i(xn),Yl=m(xn,"P",{"data-svelte-h":!0}),I(Yl)!=="svelte-1axtrg9"&&(Yl.textContent=Wg),gi=i(xn),d(dt.$$.fragment,xn),xn.forEach(u),mi=i(q),Se=m(q,"DIV",{class:!0});var Cn=v(Se);d(ra.$$.fragment,Cn),hi=i(Cn),zl=m(Cn,"P",{"data-svelte-h":!0}),I(zl)!=="svelte-1lnjtsz"&&(zl.textContent=Gg),di=i(Cn),d(ft.$$.fragment,Cn),Cn.forEach(u),fi=i(q),K=m(q,"DIV",{class:!0});var Me=v(K);d(ia.$$.fragment,Me),yi=i(Me),Rl=m(Me,"P",{"data-svelte-h":!0}),I(Rl)!=="svelte-s2la9t"&&(Rl.textContent=Bg),Mi=i(Me),Xl=m(Me,"P",{"data-svelte-h":!0}),I(Xl)!=="svelte-1xhka28"&&(Xl.innerHTML=Qg),bi=i(Me),d(yt.$$.fragment,Me),Me.forEach(u),ji=i(q),ee=m(q,"DIV",{class:!0});var be=v(ee);d(ca.$$.fragment,be),_i=i(be),Dl=m(be,"P",{"data-svelte-h":!0}),I(Dl)!=="svelte-1htupoc"&&(Dl.textContent=Vg),Ti=i(be),d(Mt.$$.fragment,be),Ii=i(be),d(bt.$$.fragment,be),be.forEach(u),Ji=i(q),jt=m(q,"DIV",{class:!0});var Ul=v(jt);d(pa.$$.fragment,Ul),wi=i(Ul),Fl=m(Ul,"P",{"data-svelte-h":!0}),I(Fl)!=="svelte-1qi4mtg"&&(Fl.textContent=Sg),Ul.forEach(u),xi=i(q),ne=m(q,"DIV",{class:!0});var je=v(ne);d(ua.$$.fragment,je),Ci=i(je),Hl=m(je,"P",{"data-svelte-h":!0}),I(Hl)!=="svelte-1m9sgvu"&&(Hl.textContent=Yg),Ui=i(je),Ol=m(je,"P",{"data-svelte-h":!0}),I(Ol)!=="svelte-vl8nvd"&&(Ol.innerHTML=zg),$i=i(je),d(_t.$$.fragment,je),je.forEach(u),vi=i(q),Ye=m(q,"DIV",{class:!0});var Un=v(Ye);d(ga.$$.fragment,Un),ki=i(Un),Ll=m(Un,"P",{"data-svelte-h":!0}),I(Ll)!=="svelte-u63854"&&(Ll.textContent=Rg),qi=i(Un),d(Tt.$$.fragment,Un),Un.forEach(u),Ai=i(q),te=m(q,"DIV",{class:!0});var _e=v(te);d(ma.$$.fragment,_e),Ei=i(_e),Pl=m(_e,"P",{"data-svelte-h":!0}),I(Pl)!=="svelte-k6f11e"&&(Pl.textContent=Xg),Zi=i(_e),d(It.$$.fragment,_e),Ni=i(_e),d(Jt.$$.fragment,_e),_e.forEach(u),Wi=i(q),se=m(q,"DIV",{class:!0});var Te=v(se);d(ha.$$.fragment,Te),Gi=i(Te),Kl=m(Te,"P",{"data-svelte-h":!0}),I(Kl)!=="svelte-7cx5l1"&&(Kl.textContent=Dg),Bi=i(Te),d(wt.$$.fragment,Te),Qi=i(Te),d(xt.$$.fragment,Te),Te.forEach(u),Vi=i(q),ae=m(q,"DIV",{class:!0});var Ie=v(ae);d(da.$$.fragment,Ie),Si=i(Ie),eo=m(Ie,"P",{"data-svelte-h":!0}),I(eo)!=="svelte-1tnfouk"&&(eo.textContent=Fg),Yi=i(Ie),no=m(Ie,"P",{"data-svelte-h":!0}),I(no)!=="svelte-qrqo93"&&(no.textContent=Hg),zi=i(Ie),d(Ct.$$.fragment,Ie),Ie.forEach(u),Ri=i(q),B=m(q,"DIV",{class:!0});var z=v(B);d(fa.$$.fragment,z),Xi=i(z),to=m(z,"P",{"data-svelte-h":!0}),I(to)!=="svelte-71vo6e"&&(to.textContent=Og),Di=i(z),so=m(z,"P",{"data-svelte-h":!0}),I(so)!=="svelte-1k36r1q"&&(so.innerHTML=Lg),Fi=i(z),d(Ut.$$.fragment,z),Hi=i(z),d($t.$$.fragment,z),Oi=i(z),d(vt.$$.fragment,z),z.forEach(u),Li=i(q),le=m(q,"DIV",{class:!0});var Je=v(le);d(ya.$$.fragment,Je),Pi=i(Je),ao=m(Je,"P",{"data-svelte-h":!0}),I(ao)!=="svelte-fzfwfh"&&(ao.textContent=Pg),Ki=i(Je),d(kt.$$.fragment,Je),ec=i(Je),d(qt.$$.fragment,Je),Je.forEach(u),nc=i(q),At=m(q,"DIV",{class:!0});var $l=v(At);d(Ma.$$.fragment,$l),tc=i($l),lo=m($l,"P",{"data-svelte-h":!0}),I(lo)!=="svelte-14tnsya"&&(lo.textContent=Kg),$l.forEach(u),sc=i(q),ze=m(q,"DIV",{class:!0});var $n=v(ze);d(ba.$$.fragment,$n),ac=i($n),oo=m($n,"P",{"data-svelte-h":!0}),I(oo)!=="svelte-1mibg86"&&(oo.textContent=em),lc=i($n),d(Et.$$.fragment,$n),$n.forEach(u),oc=i(q),Re=m(q,"DIV",{class:!0});var vn=v(Re);d(ja.$$.fragment,vn),rc=i(vn),ro=m(vn,"P",{"data-svelte-h":!0}),I(ro)!=="svelte-1nuhgbh"&&(ro.textContent=nm),ic=i(vn),d(Zt.$$.fragment,vn),vn.forEach(u),cc=i(q),Xe=m(q,"DIV",{class:!0});var kn=v(Xe);d(_a.$$.fragment,kn),pc=i(kn),io=m(kn,"P",{"data-svelte-h":!0}),I(io)!=="svelte-1uepm2o"&&(io.textContent=tm),uc=i(kn),d(Nt.$$.fragment,kn),kn.forEach(u),gc=i(q),De=m(q,"DIV",{class:!0});var qn=v(De);d(Ta.$$.fragment,qn),mc=i(qn),co=m(qn,"P",{"data-svelte-h":!0}),I(co)!=="svelte-77a94i"&&(co.textContent=sm),hc=i(qn),d(Wt.$$.fragment,qn),qn.forEach(u),dc=i(q),Fe=m(q,"DIV",{class:!0});var An=v(Fe);d(Ia.$$.fragment,An),fc=i(An),po=m(An,"P",{"data-svelte-h":!0}),I(po)!=="svelte-61sxmo"&&(po.textContent=am),yc=i(An),d(Gt.$$.fragment,An),An.forEach(u),Mc=i(q),He=m(q,"DIV",{class:!0});var En=v(He);d(Ja.$$.fragment,En),bc=i(En),uo=m(En,"P",{"data-svelte-h":!0}),I(uo)!=="svelte-hzldyu"&&(uo.textContent=lm),jc=i(En),d(Bt.$$.fragment,En),En.forEach(u),_c=i(q),Oe=m(q,"DIV",{class:!0});var Zn=v(Oe);d(wa.$$.fragment,Zn),Tc=i(Zn),go=m(Zn,"P",{"data-svelte-h":!0}),I(go)!=="svelte-b4yzyj"&&(go.textContent=om),Ic=i(Zn),d(Qt.$$.fragment,Zn),Zn.forEach(u),Jc=i(q),Q=m(q,"DIV",{class:!0});var R=v(Q);d(xa.$$.fragment,R),wc=i(R),mo=m(R,"P",{"data-svelte-h":!0}),I(mo)!=="svelte-qakvx8"&&(mo.textContent=rm),xc=i(R),ho=m(R,"P",{"data-svelte-h":!0}),I(ho)!=="svelte-1irx2op"&&(ho.innerHTML=im),Cc=i(R),fo=m(R,"P",{"data-svelte-h":!0}),I(fo)!=="svelte-140zl9b"&&(fo.innerHTML=cm),Uc=i(R),d(Vt.$$.fragment,R),$c=i(R),d(St.$$.fragment,R),R.forEach(u),vc=i(q),oe=m(q,"DIV",{class:!0});var we=v(oe);d(Ca.$$.fragment,we),kc=i(we),yo=m(we,"P",{"data-svelte-h":!0}),I(yo)!=="svelte-9lmcnw"&&(yo.textContent=pm),qc=i(we),d(Yt.$$.fragment,we),Ac=i(we),d(zt.$$.fragment,we),we.forEach(u),Ec=i(q),Le=m(q,"DIV",{class:!0});var Nn=v(Le);d(Ua.$$.fragment,Nn),Zc=i(Nn),Mo=m(Nn,"P",{"data-svelte-h":!0}),I(Mo)!=="svelte-12mjzdy"&&(Mo.textContent=um),Nc=i(Nn),d(Rt.$$.fragment,Nn),Nn.forEach(u),Wc=i(q),Pe=m(q,"DIV",{class:!0});var Wn=v(Pe);d($a.$$.fragment,Wn),Gc=i(Wn),bo=m(Wn,"P",{"data-svelte-h":!0}),I(bo)!=="svelte-1araal"&&(bo.textContent=gm),Bc=i(Wn),d(Xt.$$.fragment,Wn),Wn.forEach(u),Qc=i(q),F=m(q,"DIV",{class:!0});var O=v(F);d(va.$$.fragment,O),Vc=i(O),jo=m(O,"P",{"data-svelte-h":!0}),I(jo)!=="svelte-1v3lqck"&&(jo.textContent=mm),Sc=i(O),_o=m(O,"P",{"data-svelte-h":!0}),I(_o)!=="svelte-jwmjgr"&&(_o.innerHTML=hm),Yc=i(O),d(Dt.$$.fragment,O),zc=i(O),d(Ft.$$.fragment,O),O.forEach(u),Rc=i(q),Ke=m(q,"DIV",{class:!0});var Gn=v(Ke);d(ka.$$.fragment,Gn),Xc=i(Gn),To=m(Gn,"P",{"data-svelte-h":!0}),I(To)!=="svelte-1jbp6ey"&&(To.textContent=dm),Dc=i(Gn),d(Ht.$$.fragment,Gn),Gn.forEach(u),Fc=i(q),re=m(q,"DIV",{class:!0});var xe=v(re);d(qa.$$.fragment,xe),Hc=i(xe),Io=m(xe,"P",{"data-svelte-h":!0}),I(Io)!=="svelte-1c9xuqj"&&(Io.textContent=fm),Oc=i(xe),d(Ot.$$.fragment,xe),Lc=i(xe),d(Lt.$$.fragment,xe),xe.forEach(u),Pc=i(q),en=m(q,"DIV",{class:!0});var Bn=v(en);d(Aa.$$.fragment,Bn),Kc=i(Bn),Jo=m(Bn,"P",{"data-svelte-h":!0}),I(Jo)!=="svelte-108ipf8"&&(Jo.textContent=ym),ep=i(Bn),d(Pt.$$.fragment,Bn),Bn.forEach(u),q.forEach(u),Cr=i(s),d(Ea.$$.fragment,s),Ur=i(s),Za=m(s,"P",{"data-svelte-h":!0}),I(Za)!=="svelte-nn0rvx"&&(Za.innerHTML=Mm),$r=i(s),d(Na.$$.fragment,s),vr=i(s),w=m(s,"DIV",{class:!0});var U=v(w);d(Wa.$$.fragment,U),np=i(U),wo=m(U,"P",{"data-svelte-h":!0}),I(wo)!=="svelte-1p4u01l"&&(wo.textContent=bm),tp=i(U),xo=m(U,"P",{"data-svelte-h":!0}),I(xo)!=="svelte-rlzjhe"&&(xo.innerHTML=jm),sp=i(U),nn=m(U,"DIV",{class:!0});var Qn=v(nn);d(Ga.$$.fragment,Qn),ap=i(Qn),Co=m(Qn,"P",{"data-svelte-h":!0}),I(Co)!=="svelte-1hs5qib"&&(Co.textContent=_m),lp=i(Qn),d(Kt.$$.fragment,Qn),Qn.forEach(u),op=i(U),tn=m(U,"DIV",{class:!0});var Vn=v(tn);d(Ba.$$.fragment,Vn),rp=i(Vn),Uo=m(Vn,"P",{"data-svelte-h":!0}),I(Uo)!=="svelte-z9e742"&&(Uo.textContent=Tm),ip=i(Vn),d(es.$$.fragment,Vn),Vn.forEach(u),cp=i(U),sn=m(U,"DIV",{class:!0});var Sn=v(sn);d(Qa.$$.fragment,Sn),pp=i(Sn),$o=m(Sn,"P",{"data-svelte-h":!0}),I($o)!=="svelte-lahnll"&&($o.textContent=Im),up=i(Sn),d(ns.$$.fragment,Sn),Sn.forEach(u),gp=i(U),Z=m(U,"DIV",{class:!0});var W=v(Z);d(Va.$$.fragment,W),mp=i(W),vo=m(W,"P",{"data-svelte-h":!0}),I(vo)!=="svelte-5o70yf"&&(vo.textContent=Jm),hp=i(W),d(ts.$$.fragment,W),dp=i(W),d(ss.$$.fragment,W),fp=i(W),d(as.$$.fragment,W),yp=i(W),d(ls.$$.fragment,W),Mp=i(W),d(os.$$.fragment,W),bp=i(W),d(rs.$$.fragment,W),jp=i(W),d(is.$$.fragment,W),W.forEach(u),_p=i(U),ie=m(U,"DIV",{class:!0});var Ce=v(ie);d(Sa.$$.fragment,Ce),Tp=i(Ce),ko=m(Ce,"P",{"data-svelte-h":!0}),I(ko)!=="svelte-vcr7iw"&&(ko.textContent=wm),Ip=i(Ce),qo=m(Ce,"P",{"data-svelte-h":!0}),I(qo)!=="svelte-1jtca0b"&&(qo.textContent=xm),Jp=i(Ce),Ao=m(Ce,"P",{"data-svelte-h":!0}),I(Ao)!=="svelte-1sz3ulv"&&(Ao.innerHTML=Cm),Ce.forEach(u),wp=i(U),an=m(U,"DIV",{class:!0});var Yn=v(an);d(Ya.$$.fragment,Yn),xp=i(Yn),Eo=m(Yn,"P",{"data-svelte-h":!0}),I(Eo)!=="svelte-qs8cmr"&&(Eo.textContent=Um),Cp=i(Yn),d(cs.$$.fragment,Yn),Yn.forEach(u),Up=i(U),ln=m(U,"DIV",{class:!0});var zn=v(ln);d(za.$$.fragment,zn),$p=i(zn),Zo=m(zn,"P",{"data-svelte-h":!0}),I(Zo)!=="svelte-1axtrg9"&&(Zo.textContent=$m),vp=i(zn),d(ps.$$.fragment,zn),zn.forEach(u),kp=i(U),on=m(U,"DIV",{class:!0});var Rn=v(on);d(Ra.$$.fragment,Rn),qp=i(Rn),No=m(Rn,"P",{"data-svelte-h":!0}),I(No)!=="svelte-1lnjtsz"&&(No.textContent=vm),Ap=i(Rn),d(us.$$.fragment,Rn),Rn.forEach(u),Ep=i(U),ce=m(U,"DIV",{class:!0});var Ue=v(ce);d(Xa.$$.fragment,Ue),Zp=i(Ue),Wo=m(Ue,"P",{"data-svelte-h":!0}),I(Wo)!=="svelte-s2la9t"&&(Wo.textContent=km),Np=i(Ue),Go=m(Ue,"P",{"data-svelte-h":!0}),I(Go)!=="svelte-1xhka28"&&(Go.innerHTML=qm),Wp=i(Ue),d(gs.$$.fragment,Ue),Ue.forEach(u),Gp=i(U),pe=m(U,"DIV",{class:!0});var $e=v(pe);d(Da.$$.fragment,$e),Bp=i($e),Bo=m($e,"P",{"data-svelte-h":!0}),I(Bo)!=="svelte-1htupoc"&&(Bo.textContent=Am),Qp=i($e),d(ms.$$.fragment,$e),Vp=i($e),d(hs.$$.fragment,$e),$e.forEach(u),Sp=i(U),ds=m(U,"DIV",{class:!0});var vl=v(ds);d(Fa.$$.fragment,vl),Yp=i(vl),Qo=m(vl,"P",{"data-svelte-h":!0}),I(Qo)!=="svelte-1qi4mtg"&&(Qo.textContent=Em),vl.forEach(u),zp=i(U),ue=m(U,"DIV",{class:!0});var ve=v(ue);d(Ha.$$.fragment,ve),Rp=i(ve),Vo=m(ve,"P",{"data-svelte-h":!0}),I(Vo)!=="svelte-1m9sgvu"&&(Vo.textContent=Zm),Xp=i(ve),So=m(ve,"P",{"data-svelte-h":!0}),I(So)!=="svelte-vl8nvd"&&(So.innerHTML=Nm),Dp=i(ve),d(fs.$$.fragment,ve),ve.forEach(u),Fp=i(U),rn=m(U,"DIV",{class:!0});var Xn=v(rn);d(Oa.$$.fragment,Xn),Hp=i(Xn),Yo=m(Xn,"P",{"data-svelte-h":!0}),I(Yo)!=="svelte-u63854"&&(Yo.textContent=Wm),Op=i(Xn),d(ys.$$.fragment,Xn),Xn.forEach(u),Lp=i(U),ge=m(U,"DIV",{class:!0});var ke=v(ge);d(La.$$.fragment,ke),Pp=i(ke),zo=m(ke,"P",{"data-svelte-h":!0}),I(zo)!=="svelte-k6f11e"&&(zo.textContent=Gm),Kp=i(ke),d(Ms.$$.fragment,ke),eu=i(ke),d(bs.$$.fragment,ke),ke.forEach(u),nu=i(U),me=m(U,"DIV",{class:!0});var qe=v(me);d(Pa.$$.fragment,qe),tu=i(qe),Ro=m(qe,"P",{"data-svelte-h":!0}),I(Ro)!=="svelte-7cx5l1"&&(Ro.textContent=Bm),su=i(qe),d(js.$$.fragment,qe),au=i(qe),d(_s.$$.fragment,qe),qe.forEach(u),lu=i(U),he=m(U,"DIV",{class:!0});var Ae=v(he);d(Ka.$$.fragment,Ae),ou=i(Ae),Xo=m(Ae,"P",{"data-svelte-h":!0}),I(Xo)!=="svelte-1tnfouk"&&(Xo.textContent=Qm),ru=i(Ae),Do=m(Ae,"P",{"data-svelte-h":!0}),I(Do)!=="svelte-qrqo93"&&(Do.textContent=Vm),iu=i(Ae),d(Ts.$$.fragment,Ae),Ae.forEach(u),cu=i(U),V=m(U,"DIV",{class:!0});var X=v(V);d(el.$$.fragment,X),pu=i(X),Fo=m(X,"P",{"data-svelte-h":!0}),I(Fo)!=="svelte-71vo6e"&&(Fo.textContent=Sm),uu=i(X),Ho=m(X,"P",{"data-svelte-h":!0}),I(Ho)!=="svelte-1k36r1q"&&(Ho.innerHTML=Ym),gu=i(X),d(Is.$$.fragment,X),mu=i(X),d(Js.$$.fragment,X),hu=i(X),d(ws.$$.fragment,X),X.forEach(u),du=i(U),de=m(U,"DIV",{class:!0});var Ee=v(de);d(nl.$$.fragment,Ee),fu=i(Ee),Oo=m(Ee,"P",{"data-svelte-h":!0}),I(Oo)!=="svelte-fzfwfh"&&(Oo.textContent=zm),yu=i(Ee),d(xs.$$.fragment,Ee),Mu=i(Ee),d(Cs.$$.fragment,Ee),Ee.forEach(u),bu=i(U),Us=m(U,"DIV",{class:!0});var kl=v(Us);d(tl.$$.fragment,kl),ju=i(kl),Lo=m(kl,"P",{"data-svelte-h":!0}),I(Lo)!=="svelte-14tnsya"&&(Lo.textContent=Rm),kl.forEach(u),_u=i(U),cn=m(U,"DIV",{class:!0});var Dn=v(cn);d(sl.$$.fragment,Dn),Tu=i(Dn),Po=m(Dn,"P",{"data-svelte-h":!0}),I(Po)!=="svelte-1mibg86"&&(Po.textContent=Xm),Iu=i(Dn),d($s.$$.fragment,Dn),Dn.forEach(u),Ju=i(U),pn=m(U,"DIV",{class:!0});var Fn=v(pn);d(al.$$.fragment,Fn),wu=i(Fn),Ko=m(Fn,"P",{"data-svelte-h":!0}),I(Ko)!=="svelte-1nuhgbh"&&(Ko.textContent=Dm),xu=i(Fn),d(vs.$$.fragment,Fn),Fn.forEach(u),Cu=i(U),un=m(U,"DIV",{class:!0});var Hn=v(un);d(ll.$$.fragment,Hn),Uu=i(Hn),er=m(Hn,"P",{"data-svelte-h":!0}),I(er)!=="svelte-1uepm2o"&&(er.textContent=Fm),$u=i(Hn),d(ks.$$.fragment,Hn),Hn.forEach(u),vu=i(U),gn=m(U,"DIV",{class:!0});var On=v(gn);d(ol.$$.fragment,On),ku=i(On),nr=m(On,"P",{"data-svelte-h":!0}),I(nr)!=="svelte-77a94i"&&(nr.textContent=Hm),qu=i(On),d(qs.$$.fragment,On),On.forEach(u),Au=i(U),mn=m(U,"DIV",{class:!0});var Ln=v(mn);d(rl.$$.fragment,Ln),Eu=i(Ln),tr=m(Ln,"P",{"data-svelte-h":!0}),I(tr)!=="svelte-61sxmo"&&(tr.textContent=Om),Zu=i(Ln),d(As.$$.fragment,Ln),Ln.forEach(u),Nu=i(U),hn=m(U,"DIV",{class:!0});var Pn=v(hn);d(il.$$.fragment,Pn),Wu=i(Pn),sr=m(Pn,"P",{"data-svelte-h":!0}),I(sr)!=="svelte-hzldyu"&&(sr.textContent=Lm),Gu=i(Pn),d(Es.$$.fragment,Pn),Pn.forEach(u),Bu=i(U),dn=m(U,"DIV",{class:!0});var Kn=v(dn);d(cl.$$.fragment,Kn),Qu=i(Kn),ar=m(Kn,"P",{"data-svelte-h":!0}),I(ar)!=="svelte-b4yzyj"&&(ar.textContent=Pm),Vu=i(Kn),d(Zs.$$.fragment,Kn),Kn.forEach(u),Su=i(U),S=m(U,"DIV",{class:!0});var D=v(S);d(pl.$$.fragment,D),Yu=i(D),lr=m(D,"P",{"data-svelte-h":!0}),I(lr)!=="svelte-qakvx8"&&(lr.textContent=Km),zu=i(D),or=m(D,"P",{"data-svelte-h":!0}),I(or)!=="svelte-1irx2op"&&(or.innerHTML=eh),Ru=i(D),rr=m(D,"P",{"data-svelte-h":!0}),I(rr)!=="svelte-140zl9b"&&(rr.innerHTML=nh),Xu=i(D),d(Ns.$$.fragment,D),Du=i(D),d(Ws.$$.fragment,D),D.forEach(u),Fu=i(U),fe=m(U,"DIV",{class:!0});var Ze=v(fe);d(ul.$$.fragment,Ze),Hu=i(Ze),ir=m(Ze,"P",{"data-svelte-h":!0}),I(ir)!=="svelte-9lmcnw"&&(ir.textContent=th),Ou=i(Ze),d(Gs.$$.fragment,Ze),Lu=i(Ze),d(Bs.$$.fragment,Ze),Ze.forEach(u),Pu=i(U),fn=m(U,"DIV",{class:!0});var et=v(fn);d(gl.$$.fragment,et),Ku=i(et),cr=m(et,"P",{"data-svelte-h":!0}),I(cr)!=="svelte-12mjzdy"&&(cr.textContent=sh),eg=i(et),d(Qs.$$.fragment,et),et.forEach(u),ng=i(U),yn=m(U,"DIV",{class:!0});var nt=v(yn);d(ml.$$.fragment,nt),tg=i(nt),pr=m(nt,"P",{"data-svelte-h":!0}),I(pr)!=="svelte-1araal"&&(pr.textContent=ah),sg=i(nt),d(Vs.$$.fragment,nt),nt.forEach(u),ag=i(U),H=m(U,"DIV",{class:!0});var L=v(H);d(hl.$$.fragment,L),lg=i(L),ur=m(L,"P",{"data-svelte-h":!0}),I(ur)!=="svelte-1v3lqck"&&(ur.textContent=lh),og=i(L),gr=m(L,"P",{"data-svelte-h":!0}),I(gr)!=="svelte-jwmjgr"&&(gr.innerHTML=oh),rg=i(L),d(Ss.$$.fragment,L),ig=i(L),d(Ys.$$.fragment,L),L.forEach(u),cg=i(U),Mn=m(U,"DIV",{class:!0});var tt=v(Mn);d(dl.$$.fragment,tt),pg=i(tt),mr=m(tt,"P",{"data-svelte-h":!0}),I(mr)!=="svelte-1jbp6ey"&&(mr.textContent=rh),ug=i(tt),d(zs.$$.fragment,tt),tt.forEach(u),gg=i(U),ye=m(U,"DIV",{class:!0});var Ne=v(ye);d(fl.$$.fragment,Ne),mg=i(Ne),hr=m(Ne,"P",{"data-svelte-h":!0}),I(hr)!=="svelte-1c9xuqj"&&(hr.textContent=ih),hg=i(Ne),d(Rs.$$.fragment,Ne),dg=i(Ne),d(Xs.$$.fragment,Ne),Ne.forEach(u),fg=i(U),bn=m(U,"DIV",{class:!0});var st=v(bn);d(yl.$$.fragment,st),yg=i(st),dr=m(st,"P",{"data-svelte-h":!0}),I(dr)!=="svelte-108ipf8"&&(dr.textContent=ch),Mg=i(st),d(Ds.$$.fragment,st),st.forEach(u),U.forEach(u),kr=i(s),d(Ml.$$.fragment,s),qr=i(s),jn=m(s,"DIV",{class:!0});var ql=v(jn);d(bl.$$.fragment,ql),bg=i(ql),fr=m(ql,"P",{"data-svelte-h":!0}),I(fr)!=="svelte-2793d9"&&(fr.textContent=ph),ql.forEach(u),Ar=i(s),d(jl.$$.fragment,s),Er=i(s),_n=m(s,"DIV",{class:!0});var Al=v(_n);d(_l.$$.fragment,Al),jg=i(Al),yr=m(Al,"P",{"data-svelte-h":!0}),I(yr)!=="svelte-18ffdgx"&&(yr.textContent=uh),Al.forEach(u),Zr=i(s),d(Tl.$$.fragment,s),Nr=i(s),Il=m(s,"P",{"data-svelte-h":!0}),I(Il)!=="svelte-t9bv3o"&&(Il.innerHTML=gh),Wr=i(s),Y=m(s,"DIV",{class:!0});var P=v(Y);d(Jl.$$.fragment,P),_g=i(P),Mr=m(P,"P",{"data-svelte-h":!0}),I(Mr)!=="svelte-xkrgz1"&&(Mr.textContent=mh),Tg=i(P),d(Fs.$$.fragment,P),Ig=i(P),Hs=m(P,"DIV",{class:!0});var El=v(Hs);d(wl.$$.fragment,El),Jg=i(El),br=m(El,"P",{"data-svelte-h":!0}),I(br)!=="svelte-1ruvvxs"&&(br.textContent=hh),El.forEach(u),wg=i(P),Os=m(P,"DIV",{class:!0});var Zl=v(Os);d(xl.$$.fragment,Zl),xg=i(Zl),jr=m(Zl,"P",{"data-svelte-h":!0}),I(jr)!=="svelte-ss15d2"&&(jr.textContent=dh),Zl.forEach(u),P.forEach(u),Gr=i(s),d(Cl.$$.fragment,s),Br=i(s),Tr=m(s,"P",{}),v(Tr).forEach(u),this.h()},h(){k(n,"name","hf:doc:metadata"),k(n,"content",qf),k(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(At,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ds,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Hs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Os,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,j){l(document.head,n),_(s,p,j),_(s,a,j),_(s,t,j),f(o,s,j),_(s,e,j),_(s,c,j),_(s,Ir,j),_(s,Ls,j),_(s,Jr,j),_(s,Ps,j),_(s,wr,j),f(Ks,s,j),_(s,xr,j),_(s,C,j),f(ea,C,null),l(C,Vr),l(C,Nl),l(C,Sr),l(C,Wl),l(C,Yr),l(C,We),f(na,We,null),l(We,zr),l(We,Gl),l(We,Rr),f(at,We,null),l(C,Xr),l(C,Ge),f(ta,Ge,null),l(Ge,Dr),l(Ge,Bl),l(Ge,Fr),f(lt,Ge,null),l(C,Hr),l(C,Be),f(sa,Be,null),l(Be,Or),l(Be,Ql),l(Be,Lr),f(ot,Be,null),l(C,Pr),l(C,E),f(aa,E,null),l(E,Kr),l(E,Vl),l(E,ei),f(rt,E,null),l(E,ni),f(it,E,null),l(E,ti),f(ct,E,null),l(E,si),f(pt,E,null),l(E,ai),f(ut,E,null),l(E,li),f(gt,E,null),l(E,oi),f(mt,E,null),l(C,ri),l(C,Qe),f(la,Qe,null),l(Qe,ii),l(Qe,Sl),l(Qe,ci),f(ht,Qe,null),l(C,pi),l(C,Ve),f(oa,Ve,null),l(Ve,ui),l(Ve,Yl),l(Ve,gi),f(dt,Ve,null),l(C,mi),l(C,Se),f(ra,Se,null),l(Se,hi),l(Se,zl),l(Se,di),f(ft,Se,null),l(C,fi),l(C,K),f(ia,K,null),l(K,yi),l(K,Rl),l(K,Mi),l(K,Xl),l(K,bi),f(yt,K,null),l(C,ji),l(C,ee),f(ca,ee,null),l(ee,_i),l(ee,Dl),l(ee,Ti),f(Mt,ee,null),l(ee,Ii),f(bt,ee,null),l(C,Ji),l(C,jt),f(pa,jt,null),l(jt,wi),l(jt,Fl),l(C,xi),l(C,ne),f(ua,ne,null),l(ne,Ci),l(ne,Hl),l(ne,Ui),l(ne,Ol),l(ne,$i),f(_t,ne,null),l(C,vi),l(C,Ye),f(ga,Ye,null),l(Ye,ki),l(Ye,Ll),l(Ye,qi),f(Tt,Ye,null),l(C,Ai),l(C,te),f(ma,te,null),l(te,Ei),l(te,Pl),l(te,Zi),f(It,te,null),l(te,Ni),f(Jt,te,null),l(C,Wi),l(C,se),f(ha,se,null),l(se,Gi),l(se,Kl),l(se,Bi),f(wt,se,null),l(se,Qi),f(xt,se,null),l(C,Vi),l(C,ae),f(da,ae,null),l(ae,Si),l(ae,eo),l(ae,Yi),l(ae,no),l(ae,zi),f(Ct,ae,null),l(C,Ri),l(C,B),f(fa,B,null),l(B,Xi),l(B,to),l(B,Di),l(B,so),l(B,Fi),f(Ut,B,null),l(B,Hi),f($t,B,null),l(B,Oi),f(vt,B,null),l(C,Li),l(C,le),f(ya,le,null),l(le,Pi),l(le,ao),l(le,Ki),f(kt,le,null),l(le,ec),f(qt,le,null),l(C,nc),l(C,At),f(Ma,At,null),l(At,tc),l(At,lo),l(C,sc),l(C,ze),f(ba,ze,null),l(ze,ac),l(ze,oo),l(ze,lc),f(Et,ze,null),l(C,oc),l(C,Re),f(ja,Re,null),l(Re,rc),l(Re,ro),l(Re,ic),f(Zt,Re,null),l(C,cc),l(C,Xe),f(_a,Xe,null),l(Xe,pc),l(Xe,io),l(Xe,uc),f(Nt,Xe,null),l(C,gc),l(C,De),f(Ta,De,null),l(De,mc),l(De,co),l(De,hc),f(Wt,De,null),l(C,dc),l(C,Fe),f(Ia,Fe,null),l(Fe,fc),l(Fe,po),l(Fe,yc),f(Gt,Fe,null),l(C,Mc),l(C,He),f(Ja,He,null),l(He,bc),l(He,uo),l(He,jc),f(Bt,He,null),l(C,_c),l(C,Oe),f(wa,Oe,null),l(Oe,Tc),l(Oe,go),l(Oe,Ic),f(Qt,Oe,null),l(C,Jc),l(C,Q),f(xa,Q,null),l(Q,wc),l(Q,mo),l(Q,xc),l(Q,ho),l(Q,Cc),l(Q,fo),l(Q,Uc),f(Vt,Q,null),l(Q,$c),f(St,Q,null),l(C,vc),l(C,oe),f(Ca,oe,null),l(oe,kc),l(oe,yo),l(oe,qc),f(Yt,oe,null),l(oe,Ac),f(zt,oe,null),l(C,Ec),l(C,Le),f(Ua,Le,null),l(Le,Zc),l(Le,Mo),l(Le,Nc),f(Rt,Le,null),l(C,Wc),l(C,Pe),f($a,Pe,null),l(Pe,Gc),l(Pe,bo),l(Pe,Bc),f(Xt,Pe,null),l(C,Qc),l(C,F),f(va,F,null),l(F,Vc),l(F,jo),l(F,Sc),l(F,_o),l(F,Yc),f(Dt,F,null),l(F,zc),f(Ft,F,null),l(C,Rc),l(C,Ke),f(ka,Ke,null),l(Ke,Xc),l(Ke,To),l(Ke,Dc),f(Ht,Ke,null),l(C,Fc),l(C,re),f(qa,re,null),l(re,Hc),l(re,Io),l(re,Oc),f(Ot,re,null),l(re,Lc),f(Lt,re,null),l(C,Pc),l(C,en),f(Aa,en,null),l(en,Kc),l(en,Jo),l(en,ep),f(Pt,en,null),_(s,Cr,j),f(Ea,s,j),_(s,Ur,j),_(s,Za,j),_(s,$r,j),f(Na,s,j),_(s,vr,j),_(s,w,j),f(Wa,w,null),l(w,np),l(w,wo),l(w,tp),l(w,xo),l(w,sp),l(w,nn),f(Ga,nn,null),l(nn,ap),l(nn,Co),l(nn,lp),f(Kt,nn,null),l(w,op),l(w,tn),f(Ba,tn,null),l(tn,rp),l(tn,Uo),l(tn,ip),f(es,tn,null),l(w,cp),l(w,sn),f(Qa,sn,null),l(sn,pp),l(sn,$o),l(sn,up),f(ns,sn,null),l(w,gp),l(w,Z),f(Va,Z,null),l(Z,mp),l(Z,vo),l(Z,hp),f(ts,Z,null),l(Z,dp),f(ss,Z,null),l(Z,fp),f(as,Z,null),l(Z,yp),f(ls,Z,null),l(Z,Mp),f(os,Z,null),l(Z,bp),f(rs,Z,null),l(Z,jp),f(is,Z,null),l(w,_p),l(w,ie),f(Sa,ie,null),l(ie,Tp),l(ie,ko),l(ie,Ip),l(ie,qo),l(ie,Jp),l(ie,Ao),l(w,wp),l(w,an),f(Ya,an,null),l(an,xp),l(an,Eo),l(an,Cp),f(cs,an,null),l(w,Up),l(w,ln),f(za,ln,null),l(ln,$p),l(ln,Zo),l(ln,vp),f(ps,ln,null),l(w,kp),l(w,on),f(Ra,on,null),l(on,qp),l(on,No),l(on,Ap),f(us,on,null),l(w,Ep),l(w,ce),f(Xa,ce,null),l(ce,Zp),l(ce,Wo),l(ce,Np),l(ce,Go),l(ce,Wp),f(gs,ce,null),l(w,Gp),l(w,pe),f(Da,pe,null),l(pe,Bp),l(pe,Bo),l(pe,Qp),f(ms,pe,null),l(pe,Vp),f(hs,pe,null),l(w,Sp),l(w,ds),f(Fa,ds,null),l(ds,Yp),l(ds,Qo),l(w,zp),l(w,ue),f(Ha,ue,null),l(ue,Rp),l(ue,Vo),l(ue,Xp),l(ue,So),l(ue,Dp),f(fs,ue,null),l(w,Fp),l(w,rn),f(Oa,rn,null),l(rn,Hp),l(rn,Yo),l(rn,Op),f(ys,rn,null),l(w,Lp),l(w,ge),f(La,ge,null),l(ge,Pp),l(ge,zo),l(ge,Kp),f(Ms,ge,null),l(ge,eu),f(bs,ge,null),l(w,nu),l(w,me),f(Pa,me,null),l(me,tu),l(me,Ro),l(me,su),f(js,me,null),l(me,au),f(_s,me,null),l(w,lu),l(w,he),f(Ka,he,null),l(he,ou),l(he,Xo),l(he,ru),l(he,Do),l(he,iu),f(Ts,he,null),l(w,cu),l(w,V),f(el,V,null),l(V,pu),l(V,Fo),l(V,uu),l(V,Ho),l(V,gu),f(Is,V,null),l(V,mu),f(Js,V,null),l(V,hu),f(ws,V,null),l(w,du),l(w,de),f(nl,de,null),l(de,fu),l(de,Oo),l(de,yu),f(xs,de,null),l(de,Mu),f(Cs,de,null),l(w,bu),l(w,Us),f(tl,Us,null),l(Us,ju),l(Us,Lo),l(w,_u),l(w,cn),f(sl,cn,null),l(cn,Tu),l(cn,Po),l(cn,Iu),f($s,cn,null),l(w,Ju),l(w,pn),f(al,pn,null),l(pn,wu),l(pn,Ko),l(pn,xu),f(vs,pn,null),l(w,Cu),l(w,un),f(ll,un,null),l(un,Uu),l(un,er),l(un,$u),f(ks,un,null),l(w,vu),l(w,gn),f(ol,gn,null),l(gn,ku),l(gn,nr),l(gn,qu),f(qs,gn,null),l(w,Au),l(w,mn),f(rl,mn,null),l(mn,Eu),l(mn,tr),l(mn,Zu),f(As,mn,null),l(w,Nu),l(w,hn),f(il,hn,null),l(hn,Wu),l(hn,sr),l(hn,Gu),f(Es,hn,null),l(w,Bu),l(w,dn),f(cl,dn,null),l(dn,Qu),l(dn,ar),l(dn,Vu),f(Zs,dn,null),l(w,Su),l(w,S),f(pl,S,null),l(S,Yu),l(S,lr),l(S,zu),l(S,or),l(S,Ru),l(S,rr),l(S,Xu),f(Ns,S,null),l(S,Du),f(Ws,S,null),l(w,Fu),l(w,fe),f(ul,fe,null),l(fe,Hu),l(fe,ir),l(fe,Ou),f(Gs,fe,null),l(fe,Lu),f(Bs,fe,null),l(w,Pu),l(w,fn),f(gl,fn,null),l(fn,Ku),l(fn,cr),l(fn,eg),f(Qs,fn,null),l(w,ng),l(w,yn),f(ml,yn,null),l(yn,tg),l(yn,pr),l(yn,sg),f(Vs,yn,null),l(w,ag),l(w,H),f(hl,H,null),l(H,lg),l(H,ur),l(H,og),l(H,gr),l(H,rg),f(Ss,H,null),l(H,ig),f(Ys,H,null),l(w,cg),l(w,Mn),f(dl,Mn,null),l(Mn,pg),l(Mn,mr),l(Mn,ug),f(zs,Mn,null),l(w,gg),l(w,ye),f(fl,ye,null),l(ye,mg),l(ye,hr),l(ye,hg),f(Rs,ye,null),l(ye,dg),f(Xs,ye,null),l(w,fg),l(w,bn),f(yl,bn,null),l(bn,yg),l(bn,dr),l(bn,Mg),f(Ds,bn,null),_(s,kr,j),f(Ml,s,j),_(s,qr,j),_(s,jn,j),f(bl,jn,null),l(jn,bg),l(jn,fr),_(s,Ar,j),f(jl,s,j),_(s,Er,j),_(s,_n,j),f(_l,_n,null),l(_n,jg),l(_n,yr),_(s,Zr,j),f(Tl,s,j),_(s,Nr,j),_(s,Il,j),_(s,Wr,j),_(s,Y,j),f(Jl,Y,null),l(Y,_g),l(Y,Mr),l(Y,Tg),f(Fs,Y,null),l(Y,Ig),l(Y,Hs),f(wl,Hs,null),l(Hs,Jg),l(Hs,br),l(Y,wg),l(Y,Os),f(xl,Os,null),l(Os,xg),l(Os,jr),_(s,Gr,j),f(Cl,s,j),_(s,Br,j),_(s,Tr,j),Qr=!0},p(s,[j]){const q={};j&2&&(q.$$scope={dirty:j,ctx:s}),at.$set(q);const Tn={};j&2&&(Tn.$$scope={dirty:j,ctx:s}),lt.$set(Tn);const In={};j&2&&(In.$$scope={dirty:j,ctx:s}),ot.$set(In);const Jn={};j&2&&(Jn.$$scope={dirty:j,ctx:s}),rt.$set(Jn);const N={};j&2&&(N.$$scope={dirty:j,ctx:s}),it.$set(N);const wn={};j&2&&(wn.$$scope={dirty:j,ctx:s}),ct.$set(wn);const xn={};j&2&&(xn.$$scope={dirty:j,ctx:s}),pt.$set(xn);const Cn={};j&2&&(Cn.$$scope={dirty:j,ctx:s}),ut.$set(Cn);const Me={};j&2&&(Me.$$scope={dirty:j,ctx:s}),gt.$set(Me);const be={};j&2&&(be.$$scope={dirty:j,ctx:s}),mt.$set(be);const Ul={};j&2&&(Ul.$$scope={dirty:j,ctx:s}),ht.$set(Ul);const je={};j&2&&(je.$$scope={dirty:j,ctx:s}),dt.$set(je);const Un={};j&2&&(Un.$$scope={dirty:j,ctx:s}),ft.$set(Un);const _e={};j&2&&(_e.$$scope={dirty:j,ctx:s}),yt.$set(_e);const Te={};j&2&&(Te.$$scope={dirty:j,ctx:s}),Mt.$set(Te);const Ie={};j&2&&(Ie.$$scope={dirty:j,ctx:s}),bt.$set(Ie);const z={};j&2&&(z.$$scope={dirty:j,ctx:s}),_t.$set(z);const Je={};j&2&&(Je.$$scope={dirty:j,ctx:s}),Tt.$set(Je);const $l={};j&2&&($l.$$scope={dirty:j,ctx:s}),It.$set($l);const $n={};j&2&&($n.$$scope={dirty:j,ctx:s}),Jt.$set($n);const vn={};j&2&&(vn.$$scope={dirty:j,ctx:s}),wt.$set(vn);const kn={};j&2&&(kn.$$scope={dirty:j,ctx:s}),xt.$set(kn);const qn={};j&2&&(qn.$$scope={dirty:j,ctx:s}),Ct.$set(qn);const An={};j&2&&(An.$$scope={dirty:j,ctx:s}),Ut.$set(An);const En={};j&2&&(En.$$scope={dirty:j,ctx:s}),$t.$set(En);const Zn={};j&2&&(Zn.$$scope={dirty:j,ctx:s}),vt.$set(Zn);const R={};j&2&&(R.$$scope={dirty:j,ctx:s}),kt.$set(R);const we={};j&2&&(we.$$scope={dirty:j,ctx:s}),qt.$set(we);const Nn={};j&2&&(Nn.$$scope={dirty:j,ctx:s}),Et.$set(Nn);const Wn={};j&2&&(Wn.$$scope={dirty:j,ctx:s}),Zt.$set(Wn);const O={};j&2&&(O.$$scope={dirty:j,ctx:s}),Nt.$set(O);const Gn={};j&2&&(Gn.$$scope={dirty:j,ctx:s}),Wt.$set(Gn);const xe={};j&2&&(xe.$$scope={dirty:j,ctx:s}),Gt.$set(xe);const Bn={};j&2&&(Bn.$$scope={dirty:j,ctx:s}),Bt.$set(Bn);const U={};j&2&&(U.$$scope={dirty:j,ctx:s}),Qt.$set(U);const Qn={};j&2&&(Qn.$$scope={dirty:j,ctx:s}),Vt.$set(Qn);const Vn={};j&2&&(Vn.$$scope={dirty:j,ctx:s}),St.$set(Vn);const Sn={};j&2&&(Sn.$$scope={dirty:j,ctx:s}),Yt.$set(Sn);const W={};j&2&&(W.$$scope={dirty:j,ctx:s}),zt.$set(W);const Ce={};j&2&&(Ce.$$scope={dirty:j,ctx:s}),Rt.$set(Ce);const Yn={};j&2&&(Yn.$$scope={dirty:j,ctx:s}),Xt.$set(Yn);const zn={};j&2&&(zn.$$scope={dirty:j,ctx:s}),Dt.$set(zn);const Rn={};j&2&&(Rn.$$scope={dirty:j,ctx:s}),Ft.$set(Rn);const Ue={};j&2&&(Ue.$$scope={dirty:j,ctx:s}),Ht.$set(Ue);const $e={};j&2&&($e.$$scope={dirty:j,ctx:s}),Ot.$set($e);const vl={};j&2&&(vl.$$scope={dirty:j,ctx:s}),Lt.$set(vl);const ve={};j&2&&(ve.$$scope={dirty:j,ctx:s}),Pt.$set(ve);const Xn={};j&2&&(Xn.$$scope={dirty:j,ctx:s}),Kt.$set(Xn);const ke={};j&2&&(ke.$$scope={dirty:j,ctx:s}),es.$set(ke);const qe={};j&2&&(qe.$$scope={dirty:j,ctx:s}),ns.$set(qe);const Ae={};j&2&&(Ae.$$scope={dirty:j,ctx:s}),ts.$set(Ae);const X={};j&2&&(X.$$scope={dirty:j,ctx:s}),ss.$set(X);const Ee={};j&2&&(Ee.$$scope={dirty:j,ctx:s}),as.$set(Ee);const kl={};j&2&&(kl.$$scope={dirty:j,ctx:s}),ls.$set(kl);const Dn={};j&2&&(Dn.$$scope={dirty:j,ctx:s}),os.$set(Dn);const Fn={};j&2&&(Fn.$$scope={dirty:j,ctx:s}),rs.$set(Fn);const Hn={};j&2&&(Hn.$$scope={dirty:j,ctx:s}),is.$set(Hn);const On={};j&2&&(On.$$scope={dirty:j,ctx:s}),cs.$set(On);const Ln={};j&2&&(Ln.$$scope={dirty:j,ctx:s}),ps.$set(Ln);const Pn={};j&2&&(Pn.$$scope={dirty:j,ctx:s}),us.$set(Pn);const Kn={};j&2&&(Kn.$$scope={dirty:j,ctx:s}),gs.$set(Kn);const D={};j&2&&(D.$$scope={dirty:j,ctx:s}),ms.$set(D);const Ze={};j&2&&(Ze.$$scope={dirty:j,ctx:s}),hs.$set(Ze);const et={};j&2&&(et.$$scope={dirty:j,ctx:s}),fs.$set(et);const nt={};j&2&&(nt.$$scope={dirty:j,ctx:s}),ys.$set(nt);const L={};j&2&&(L.$$scope={dirty:j,ctx:s}),Ms.$set(L);const tt={};j&2&&(tt.$$scope={dirty:j,ctx:s}),bs.$set(tt);const Ne={};j&2&&(Ne.$$scope={dirty:j,ctx:s}),js.$set(Ne);const st={};j&2&&(st.$$scope={dirty:j,ctx:s}),_s.$set(st);const ql={};j&2&&(ql.$$scope={dirty:j,ctx:s}),Ts.$set(ql);const Al={};j&2&&(Al.$$scope={dirty:j,ctx:s}),Is.$set(Al);const P={};j&2&&(P.$$scope={dirty:j,ctx:s}),Js.$set(P);const El={};j&2&&(El.$$scope={dirty:j,ctx:s}),ws.$set(El);const Zl={};j&2&&(Zl.$$scope={dirty:j,ctx:s}),xs.$set(Zl);const fh={};j&2&&(fh.$$scope={dirty:j,ctx:s}),Cs.$set(fh);const yh={};j&2&&(yh.$$scope={dirty:j,ctx:s}),$s.$set(yh);const Mh={};j&2&&(Mh.$$scope={dirty:j,ctx:s}),vs.$set(Mh);const bh={};j&2&&(bh.$$scope={dirty:j,ctx:s}),ks.$set(bh);const jh={};j&2&&(jh.$$scope={dirty:j,ctx:s}),qs.$set(jh);const _h={};j&2&&(_h.$$scope={dirty:j,ctx:s}),As.$set(_h);const Th={};j&2&&(Th.$$scope={dirty:j,ctx:s}),Es.$set(Th);const Ih={};j&2&&(Ih.$$scope={dirty:j,ctx:s}),Zs.$set(Ih);const Jh={};j&2&&(Jh.$$scope={dirty:j,ctx:s}),Ns.$set(Jh);const wh={};j&2&&(wh.$$scope={dirty:j,ctx:s}),Ws.$set(wh);const xh={};j&2&&(xh.$$scope={dirty:j,ctx:s}),Gs.$set(xh);const Ch={};j&2&&(Ch.$$scope={dirty:j,ctx:s}),Bs.$set(Ch);const Uh={};j&2&&(Uh.$$scope={dirty:j,ctx:s}),Qs.$set(Uh);const $h={};j&2&&($h.$$scope={dirty:j,ctx:s}),Vs.$set($h);const vh={};j&2&&(vh.$$scope={dirty:j,ctx:s}),Ss.$set(vh);const kh={};j&2&&(kh.$$scope={dirty:j,ctx:s}),Ys.$set(kh);const qh={};j&2&&(qh.$$scope={dirty:j,ctx:s}),zs.$set(qh);const Ah={};j&2&&(Ah.$$scope={dirty:j,ctx:s}),Rs.$set(Ah);const Eh={};j&2&&(Eh.$$scope={dirty:j,ctx:s}),Xs.$set(Eh);const Zh={};j&2&&(Zh.$$scope={dirty:j,ctx:s}),Ds.$set(Zh);const Nh={};j&2&&(Nh.$$scope={dirty:j,ctx:s}),Fs.$set(Nh)},i(s){Qr||(y(o.$$.fragment,s),y(Ks.$$.fragment,s),y(ea.$$.fragment,s),y(na.$$.fragment,s),y(at.$$.fragment,s),y(ta.$$.fragment,s),y(lt.$$.fragment,s),y(sa.$$.fragment,s),y(ot.$$.fragment,s),y(aa.$$.fragment,s),y(rt.$$.fragment,s),y(it.$$.fragment,s),y(ct.$$.fragment,s),y(pt.$$.fragment,s),y(ut.$$.fragment,s),y(gt.$$.fragment,s),y(mt.$$.fragment,s),y(la.$$.fragment,s),y(ht.$$.fragment,s),y(oa.$$.fragment,s),y(dt.$$.fragment,s),y(ra.$$.fragment,s),y(ft.$$.fragment,s),y(ia.$$.fragment,s),y(yt.$$.fragment,s),y(ca.$$.fragment,s),y(Mt.$$.fragment,s),y(bt.$$.fragment,s),y(pa.$$.fragment,s),y(ua.$$.fragment,s),y(_t.$$.fragment,s),y(ga.$$.fragment,s),y(Tt.$$.fragment,s),y(ma.$$.fragment,s),y(It.$$.fragment,s),y(Jt.$$.fragment,s),y(ha.$$.fragment,s),y(wt.$$.fragment,s),y(xt.$$.fragment,s),y(da.$$.fragment,s),y(Ct.$$.fragment,s),y(fa.$$.fragment,s),y(Ut.$$.fragment,s),y($t.$$.fragment,s),y(vt.$$.fragment,s),y(ya.$$.fragment,s),y(kt.$$.fragment,s),y(qt.$$.fragment,s),y(Ma.$$.fragment,s),y(ba.$$.fragment,s),y(Et.$$.fragment,s),y(ja.$$.fragment,s),y(Zt.$$.fragment,s),y(_a.$$.fragment,s),y(Nt.$$.fragment,s),y(Ta.$$.fragment,s),y(Wt.$$.fragment,s),y(Ia.$$.fragment,s),y(Gt.$$.fragment,s),y(Ja.$$.fragment,s),y(Bt.$$.fragment,s),y(wa.$$.fragment,s),y(Qt.$$.fragment,s),y(xa.$$.fragment,s),y(Vt.$$.fragment,s),y(St.$$.fragment,s),y(Ca.$$.fragment,s),y(Yt.$$.fragment,s),y(zt.$$.fragment,s),y(Ua.$$.fragment,s),y(Rt.$$.fragment,s),y($a.$$.fragment,s),y(Xt.$$.fragment,s),y(va.$$.fragment,s),y(Dt.$$.fragment,s),y(Ft.$$.fragment,s),y(ka.$$.fragment,s),y(Ht.$$.fragment,s),y(qa.$$.fragment,s),y(Ot.$$.fragment,s),y(Lt.$$.fragment,s),y(Aa.$$.fragment,s),y(Pt.$$.fragment,s),y(Ea.$$.fragment,s),y(Na.$$.fragment,s),y(Wa.$$.fragment,s),y(Ga.$$.fragment,s),y(Kt.$$.fragment,s),y(Ba.$$.fragment,s),y(es.$$.fragment,s),y(Qa.$$.fragment,s),y(ns.$$.fragment,s),y(Va.$$.fragment,s),y(ts.$$.fragment,s),y(ss.$$.fragment,s),y(as.$$.fragment,s),y(ls.$$.fragment,s),y(os.$$.fragment,s),y(rs.$$.fragment,s),y(is.$$.fragment,s),y(Sa.$$.fragment,s),y(Ya.$$.fragment,s),y(cs.$$.fragment,s),y(za.$$.fragment,s),y(ps.$$.fragment,s),y(Ra.$$.fragment,s),y(us.$$.fragment,s),y(Xa.$$.fragment,s),y(gs.$$.fragment,s),y(Da.$$.fragment,s),y(ms.$$.fragment,s),y(hs.$$.fragment,s),y(Fa.$$.fragment,s),y(Ha.$$.fragment,s),y(fs.$$.fragment,s),y(Oa.$$.fragment,s),y(ys.$$.fragment,s),y(La.$$.fragment,s),y(Ms.$$.fragment,s),y(bs.$$.fragment,s),y(Pa.$$.fragment,s),y(js.$$.fragment,s),y(_s.$$.fragment,s),y(Ka.$$.fragment,s),y(Ts.$$.fragment,s),y(el.$$.fragment,s),y(Is.$$.fragment,s),y(Js.$$.fragment,s),y(ws.$$.fragment,s),y(nl.$$.fragment,s),y(xs.$$.fragment,s),y(Cs.$$.fragment,s),y(tl.$$.fragment,s),y(sl.$$.fragment,s),y($s.$$.fragment,s),y(al.$$.fragment,s),y(vs.$$.fragment,s),y(ll.$$.fragment,s),y(ks.$$.fragment,s),y(ol.$$.fragment,s),y(qs.$$.fragment,s),y(rl.$$.fragment,s),y(As.$$.fragment,s),y(il.$$.fragment,s),y(Es.$$.fragment,s),y(cl.$$.fragment,s),y(Zs.$$.fragment,s),y(pl.$$.fragment,s),y(Ns.$$.fragment,s),y(Ws.$$.fragment,s),y(ul.$$.fragment,s),y(Gs.$$.fragment,s),y(Bs.$$.fragment,s),y(gl.$$.fragment,s),y(Qs.$$.fragment,s),y(ml.$$.fragment,s),y(Vs.$$.fragment,s),y(hl.$$.fragment,s),y(Ss.$$.fragment,s),y(Ys.$$.fragment,s),y(dl.$$.fragment,s),y(zs.$$.fragment,s),y(fl.$$.fragment,s),y(Rs.$$.fragment,s),y(Xs.$$.fragment,s),y(yl.$$.fragment,s),y(Ds.$$.fragment,s),y(Ml.$$.fragment,s),y(bl.$$.fragment,s),y(jl.$$.fragment,s),y(_l.$$.fragment,s),y(Tl.$$.fragment,s),y(Jl.$$.fragment,s),y(Fs.$$.fragment,s),y(wl.$$.fragment,s),y(xl.$$.fragment,s),y(Cl.$$.fragment,s),Qr=!0)},o(s){M(o.$$.fragment,s),M(Ks.$$.fragment,s),M(ea.$$.fragment,s),M(na.$$.fragment,s),M(at.$$.fragment,s),M(ta.$$.fragment,s),M(lt.$$.fragment,s),M(sa.$$.fragment,s),M(ot.$$.fragment,s),M(aa.$$.fragment,s),M(rt.$$.fragment,s),M(it.$$.fragment,s),M(ct.$$.fragment,s),M(pt.$$.fragment,s),M(ut.$$.fragment,s),M(gt.$$.fragment,s),M(mt.$$.fragment,s),M(la.$$.fragment,s),M(ht.$$.fragment,s),M(oa.$$.fragment,s),M(dt.$$.fragment,s),M(ra.$$.fragment,s),M(ft.$$.fragment,s),M(ia.$$.fragment,s),M(yt.$$.fragment,s),M(ca.$$.fragment,s),M(Mt.$$.fragment,s),M(bt.$$.fragment,s),M(pa.$$.fragment,s),M(ua.$$.fragment,s),M(_t.$$.fragment,s),M(ga.$$.fragment,s),M(Tt.$$.fragment,s),M(ma.$$.fragment,s),M(It.$$.fragment,s),M(Jt.$$.fragment,s),M(ha.$$.fragment,s),M(wt.$$.fragment,s),M(xt.$$.fragment,s),M(da.$$.fragment,s),M(Ct.$$.fragment,s),M(fa.$$.fragment,s),M(Ut.$$.fragment,s),M($t.$$.fragment,s),M(vt.$$.fragment,s),M(ya.$$.fragment,s),M(kt.$$.fragment,s),M(qt.$$.fragment,s),M(Ma.$$.fragment,s),M(ba.$$.fragment,s),M(Et.$$.fragment,s),M(ja.$$.fragment,s),M(Zt.$$.fragment,s),M(_a.$$.fragment,s),M(Nt.$$.fragment,s),M(Ta.$$.fragment,s),M(Wt.$$.fragment,s),M(Ia.$$.fragment,s),M(Gt.$$.fragment,s),M(Ja.$$.fragment,s),M(Bt.$$.fragment,s),M(wa.$$.fragment,s),M(Qt.$$.fragment,s),M(xa.$$.fragment,s),M(Vt.$$.fragment,s),M(St.$$.fragment,s),M(Ca.$$.fragment,s),M(Yt.$$.fragment,s),M(zt.$$.fragment,s),M(Ua.$$.fragment,s),M(Rt.$$.fragment,s),M($a.$$.fragment,s),M(Xt.$$.fragment,s),M(va.$$.fragment,s),M(Dt.$$.fragment,s),M(Ft.$$.fragment,s),M(ka.$$.fragment,s),M(Ht.$$.fragment,s),M(qa.$$.fragment,s),M(Ot.$$.fragment,s),M(Lt.$$.fragment,s),M(Aa.$$.fragment,s),M(Pt.$$.fragment,s),M(Ea.$$.fragment,s),M(Na.$$.fragment,s),M(Wa.$$.fragment,s),M(Ga.$$.fragment,s),M(Kt.$$.fragment,s),M(Ba.$$.fragment,s),M(es.$$.fragment,s),M(Qa.$$.fragment,s),M(ns.$$.fragment,s),M(Va.$$.fragment,s),M(ts.$$.fragment,s),M(ss.$$.fragment,s),M(as.$$.fragment,s),M(ls.$$.fragment,s),M(os.$$.fragment,s),M(rs.$$.fragment,s),M(is.$$.fragment,s),M(Sa.$$.fragment,s),M(Ya.$$.fragment,s),M(cs.$$.fragment,s),M(za.$$.fragment,s),M(ps.$$.fragment,s),M(Ra.$$.fragment,s),M(us.$$.fragment,s),M(Xa.$$.fragment,s),M(gs.$$.fragment,s),M(Da.$$.fragment,s),M(ms.$$.fragment,s),M(hs.$$.fragment,s),M(Fa.$$.fragment,s),M(Ha.$$.fragment,s),M(fs.$$.fragment,s),M(Oa.$$.fragment,s),M(ys.$$.fragment,s),M(La.$$.fragment,s),M(Ms.$$.fragment,s),M(bs.$$.fragment,s),M(Pa.$$.fragment,s),M(js.$$.fragment,s),M(_s.$$.fragment,s),M(Ka.$$.fragment,s),M(Ts.$$.fragment,s),M(el.$$.fragment,s),M(Is.$$.fragment,s),M(Js.$$.fragment,s),M(ws.$$.fragment,s),M(nl.$$.fragment,s),M(xs.$$.fragment,s),M(Cs.$$.fragment,s),M(tl.$$.fragment,s),M(sl.$$.fragment,s),M($s.$$.fragment,s),M(al.$$.fragment,s),M(vs.$$.fragment,s),M(ll.$$.fragment,s),M(ks.$$.fragment,s),M(ol.$$.fragment,s),M(qs.$$.fragment,s),M(rl.$$.fragment,s),M(As.$$.fragment,s),M(il.$$.fragment,s),M(Es.$$.fragment,s),M(cl.$$.fragment,s),M(Zs.$$.fragment,s),M(pl.$$.fragment,s),M(Ns.$$.fragment,s),M(Ws.$$.fragment,s),M(ul.$$.fragment,s),M(Gs.$$.fragment,s),M(Bs.$$.fragment,s),M(gl.$$.fragment,s),M(Qs.$$.fragment,s),M(ml.$$.fragment,s),M(Vs.$$.fragment,s),M(hl.$$.fragment,s),M(Ss.$$.fragment,s),M(Ys.$$.fragment,s),M(dl.$$.fragment,s),M(zs.$$.fragment,s),M(fl.$$.fragment,s),M(Rs.$$.fragment,s),M(Xs.$$.fragment,s),M(yl.$$.fragment,s),M(Ds.$$.fragment,s),M(Ml.$$.fragment,s),M(bl.$$.fragment,s),M(jl.$$.fragment,s),M(_l.$$.fragment,s),M(Tl.$$.fragment,s),M(Jl.$$.fragment,s),M(Fs.$$.fragment,s),M(wl.$$.fragment,s),M(xl.$$.fragment,s),M(Cl.$$.fragment,s),Qr=!1},d(s){s&&(u(p),u(a),u(t),u(e),u(c),u(Ir),u(Ls),u(Jr),u(Ps),u(wr),u(xr),u(C),u(Cr),u(Ur),u(Za),u($r),u(vr),u(w),u(kr),u(qr),u(jn),u(Ar),u(Er),u(_n),u(Zr),u(Nr),u(Il),u(Wr),u(Y),u(Gr),u(Br),u(Tr)),u(n),b(o,s),b(Ks,s),b(ea),b(na),b(at),b(ta),b(lt),b(sa),b(ot),b(aa),b(rt),b(it),b(ct),b(pt),b(ut),b(gt),b(mt),b(la),b(ht),b(oa),b(dt),b(ra),b(ft),b(ia),b(yt),b(ca),b(Mt),b(bt),b(pa),b(ua),b(_t),b(ga),b(Tt),b(ma),b(It),b(Jt),b(ha),b(wt),b(xt),b(da),b(Ct),b(fa),b(Ut),b($t),b(vt),b(ya),b(kt),b(qt),b(Ma),b(ba),b(Et),b(ja),b(Zt),b(_a),b(Nt),b(Ta),b(Wt),b(Ia),b(Gt),b(Ja),b(Bt),b(wa),b(Qt),b(xa),b(Vt),b(St),b(Ca),b(Yt),b(zt),b(Ua),b(Rt),b($a),b(Xt),b(va),b(Dt),b(Ft),b(ka),b(Ht),b(qa),b(Ot),b(Lt),b(Aa),b(Pt),b(Ea,s),b(Na,s),b(Wa),b(Ga),b(Kt),b(Ba),b(es),b(Qa),b(ns),b(Va),b(ts),b(ss),b(as),b(ls),b(os),b(rs),b(is),b(Sa),b(Ya),b(cs),b(za),b(ps),b(Ra),b(us),b(Xa),b(gs),b(Da),b(ms),b(hs),b(Fa),b(Ha),b(fs),b(Oa),b(ys),b(La),b(Ms),b(bs),b(Pa),b(js),b(_s),b(Ka),b(Ts),b(el),b(Is),b(Js),b(ws),b(nl),b(xs),b(Cs),b(tl),b(sl),b($s),b(al),b(vs),b(ll),b(ks),b(ol),b(qs),b(rl),b(As),b(il),b(Es),b(cl),b(Zs),b(pl),b(Ns),b(Ws),b(ul),b(Gs),b(Bs),b(gl),b(Qs),b(ml),b(Vs),b(hl),b(Ss),b(Ys),b(dl),b(zs),b(fl),b(Rs),b(Xs),b(yl),b(Ds),b(Ml,s),b(bl),b(jl,s),b(_l),b(Tl,s),b(Jl),b(Fs),b(wl),b(xl),b(Cl,s)}}}const qf='{"title":"Inference","local":"inference","sections":[{"title":"Inference Client","local":"huggingface_hub.InferenceClient","sections":[],"depth":2},{"title":"Async Inference Client","local":"huggingface_hub.AsyncInferenceClient","sections":[],"depth":2},{"title":"InferenceTimeoutError","local":"huggingface_hub.InferenceTimeoutError","sections":[{"title":"ModelStatus","local":"huggingface_hub.inference._common.ModelStatus","sections":[],"depth":3}],"depth":2},{"title":"InferenceAPI","local":"huggingface_hub.InferenceApi","sections":[],"depth":2}],"depth":1}';function Af(T){return Gh(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vf extends Bh{constructor(n){super(),Qh(this,n,Af,kf,Wh,{})}}export{Vf as component};
