import{s as Tl,n as hl,o as bl}from"../chunks/scheduler.65852ee5.js";import{S as dl,i as Il,g as M,s as n,r as o,A as Cl,h as p,f as s,c as a,j as wl,u as y,x as i,k as ml,y as gl,a as e,v as r,d as c,t as j,w as u}from"../chunks/index.aa74147d.js";import{D as fl,C as U}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as Yt,E as Bl}from"../chunks/EditOnGithub.4eda6a96.js";function ql(Ft){let J,nt,st,at,w,Mt,m,pt,T,Lt='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',it,h,zt="In this tutorial, we’ll see how to implement an agent that leverages SQL using <code>transformers.agents</code>.",ot,b,Dt="What’s the advantage over a standard text-to-SQL pipeline?",yt,d,Kt="A standard text-to-sql pipeline is brittle, since the generated SQL query can be incorrect. Even worse, the query could be incorrect, but not raise an error, instead giving some incorrect/useless outputs without raising an alarm.",rt,I,Pt="👉 Instead, <strong>an agent system is able to critically inspect outputs and decide if the query needs to be changed or not</strong>, thus giving it a huge performance boost.",ct,C,Ot="Let’s build this agent! 💪",jt,g,ut,f,Ut,B,Jt,q,tl="Let’s check that our system works with a basic query:",wt,A,mt,Q,ll=`(1, 'Alan Payne', 12.06, 1.2)
(2, 'Alex Mason', 23.86, 0.24)
(3, 'Woodrow Wilson', 53.43, 5.43)
(4, 'Margaret James', 21.11, 1.0)
`,Tt,W,ht,Z,sl="Now let’s make our SQL table retrievable by a tool.",bt,S,el="The tool’s <code>description</code> attribute will be embedded in the LLM’s prompt by the agent system: it gives the LLM information about how to use the tool. So that is where we want to describe the SQL table.",dt,R,It,E,nl=`Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT
`,Ct,v,al='Now let’s build our tool. It needs the following: (read <a href="https://huggingface.co/docs/transformers/en/agents#create-a-new-tool" rel="nofollow">the documentation</a> for more detail)',gt,N,Ml="<li>A docstring with an <code>Args:</code> part</li> <li>Type hints</li>",ft,k,Bt,V,pl="Now let us create an agent that leverages this tool.",qt,H,il="We use the <code>ReactCodeAgent</code>, which is <code>transformers.agents</code>’ main agent class: an agent that writes actions in code and can iterate on previous output according to the ReAct framework.",At,$,ol='The <code>llm_engine</code> is the LLM that powers the agent system. <code>HfEngine</code> allows you to call LLMs using HF’s Inference API, either via Serverless or Dedicated endpoint, but you could also use any proprietary API: check out <a href="agent_change_llm">this other cookbook</a> to learn how to adapt it.',Qt,G,Wt,_,Zt,x,St,X,yl="Now let’s make it more challenging! We want our agent to handle joins across multiple tables.",Rt,Y,rl="So let’s make a second table recording the names of waiters for each <code>receipt_id</code>!",Et,F,vt,L,cl="We need to update the <code>SQLExecutorTool</code> with this table’s description to let the LLM properly leverage information from this table.",Nt,z,kt,D,jl=`Allows you to perform SQL queries on the table. Beware that this tool's output is a string representation of the execution output.
It can use the following tables:

Table 'receipts':
Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT

Table 'waiters':
Columns:
  - receipt_id: INTEGER
  - waiter_name: VARCHAR(16)
`,Vt,K,ul='Since this request is a bit harder than the previous one, we’ll switch the llm engine to use the more powerful <a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">Qwen/Qwen2.5-72B-Instruct</a>!',Ht,P,$t,O,Ul="It directly works! The setup was surprisingly simple, wasn’t it?",Gt,tt,Jl="✅ Now you can go build this text-to-SQL system you’ve always dreamt of! ✨",_t,lt,xt,et,Xt;return w=new fl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agent_text_to_sql.ipynb"}]}}),m=new Yt({props:{title:"Agent for text-to-SQL with automatic error correction",local:"agent-for-text-to-sql-with-automatic-error-correction",headingTag:"h1"}}),g=new Yt({props:{title:"Setup SQL tables",local:"setup-sql-tables",headingTag:"h2"}}),f=new U({props:{code:"ZnJvbSUyMHNxbGFsY2hlbXklMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwY3JlYXRlX2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyME1ldGFEYXRhJTJDJTBBJTIwJTIwJTIwJTIwVGFibGUlMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4lMkMlMEElMjAlMjAlMjAlMjBTdHJpbmclMkMlMEElMjAlMjAlMjAlMjBJbnRlZ2VyJTJDJTBBJTIwJTIwJTIwJTIwRmxvYXQlMkMlMEElMjAlMjAlMjAlMjBpbnNlcnQlMkMlMEElMjAlMjAlMjAlMjBpbnNwZWN0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dCUyQyUwQSklMEElMEFlbmdpbmUlMjAlM0QlMjBjcmVhdGVfZW5naW5lKCUyMnNxbGl0ZSUzQSUyRiUyRiUyRiUzQW1lbW9yeSUzQSUyMiklMEFtZXRhZGF0YV9vYmolMjAlM0QlMjBNZXRhRGF0YSgpJTBBJTBBJTIzJTIwY3JlYXRlJTIwY2l0eSUyMFNRTCUyMHRhYmxlJTBBdGFibGVfbmFtZSUyMCUzRCUyMCUyMnJlY2VpcHRzJTIyJTBBcmVjZWlwdHMlMjAlM0QlMjBUYWJsZSglMEElMjAlMjAlMjAlMjB0YWJsZV9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGFfb2JqJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMnJlY2VpcHRfaWQlMjIlMkMlMjBJbnRlZ2VyJTJDJTIwcHJpbWFyeV9rZXklM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMENvbHVtbiglMjJjdXN0b21lcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycHJpY2UlMjIlMkMlMjBGbG9hdCklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIydGlwJTIyJTJDJTIwRmxvYXQpJTJDJTBBKSUwQW1ldGFkYXRhX29iai5jcmVhdGVfYWxsKGVuZ2luZSk=",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-comment"># create city SQL table</span>
table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)`,wrap:!1}}),B=new U({props:{code:"cm93cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAxJTJDJTIwJTIyY3VzdG9tZXJfbmFtZSUyMiUzQSUyMCUyMkFsYW4lMjBQYXluZSUyMiUyQyUyMCUyMnByaWNlJTIyJTNBJTIwMTIuMDYlMkMlMjAlMjJ0aXAlMjIlM0ElMjAxLjIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJjdXN0b21lcl9uYW1lJTIyJTNBJTIwJTIyQWxleCUyME1hc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMy44NiUyQyUyMCUyMnRpcCUyMiUzQSUyMDAuMjQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMyUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJXb29kcm93JTIwV2lsc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjA1My40MyUyQyUyMCUyMnRpcCUyMiUzQSUyMDUuNDMlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJNYXJnYXJldCUyMEphbWVzJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMS4xMSUyQyUyMCUyMnRpcCUyMiUzQSUyMDEuMDAlN0QlMkMlMEElNUQlMEFmb3IlMjByb3clMjBpbiUyMHJvd3MlM0ElMEElMjAlMjAlMjAlMjBzdG10JTIwJTNEJTIwaW5zZXJ0KHJlY2VpcHRzKS52YWx1ZXMoKipyb3cpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGVuZ2luZS5iZWdpbigpJTIwYXMlMjBjb25uZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3Vyc29yJTIwJTNEJTIwY29ubmVjdGlvbi5leGVjdXRlKHN0bXQp",highlighted:`rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),A=new U({props:{code:"d2l0aCUyMGVuZ2luZS5jb25uZWN0KCklMjBhcyUyMGNvbiUzQSUwQSUyMCUyMCUyMCUyMHJvd3MlMjAlM0QlMjBjb24uZXhlY3V0ZSh0ZXh0KCUyMiUyMiUyMlNFTEVDVCUyMColMjBmcm9tJTIwcmVjZWlwdHMlMjIlMjIlMjIpKSUwQSUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KHJvdyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
<span class="hljs-meta">... </span>    rows = con.execute(text(<span class="hljs-string">&quot;&quot;&quot;SELECT * from receipts&quot;&quot;&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(row)`,wrap:!1}}),W=new Yt({props:{title:"Build our agent",local:"build-our-agent",headingTag:"h2"}}),R=new U({props:{code:"aW5zcGVjdG9yJTIwJTNEJTIwaW5zcGVjdChlbmdpbmUpJTBBY29sdW1uc19pbmZvJTIwJTNEJTIwJTVCKGNvbCU1QiUyMm5hbWUlMjIlNUQlMkMlMjBjb2wlNUIlMjJ0eXBlJTIyJTVEKSUyMGZvciUyMGNvbCUyMGluJTIwaW5zcGVjdG9yLmdldF9jb2x1bW5zKCUyMnJlY2VpcHRzJTIyKSU1RCUwQSUwQXRhYmxlX2Rlc2NyaXB0aW9uJTIwJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEFwcmludCh0YWJsZV9kZXNjcmlwdGlvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>inspector = inspect(engine)
<span class="hljs-meta">&gt;&gt;&gt; </span>columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(<span class="hljs-string">&quot;receipts&quot;</span>)]

<span class="hljs-meta">&gt;&gt;&gt; </span>table_description = <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(table_description)`,wrap:!1}}),k=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHNxbF9lbmdpbmUocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMFJldHVybnMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHJlc3VsdC4lMEElMjAlMjAlMjAlMjBUaGUlMjB0YWJsZSUyMGlzJTIwbmFtZWQlMjAncmVjZWlwdHMnLiUyMEl0cyUyMGRlc2NyaXB0aW9uJTIwaXMlMjBhcyUyMGZvbGxvd3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb2x1bW5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHJlY2VpcHRfaWQlM0ElMjBJTlRFR0VSJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMGN1c3RvbWVyX25hbWUlM0ElMjBWQVJDSEFSKDE2KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0lMjBwcmljZSUzQSUyMEZMT0FUJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHRpcCUzQSUyMEZMT0FUJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNBJTIwVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwY29ycmVjdCUyMFNRTC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmNvbm5lY3QoKSUyMGFzJTIwY29uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93cyUyMCUzRCUyMGNvbi5leGVjdXRlKHRleHQocXVlcnkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUyQiUzRCUyMCUyMiU1Q24lMjIlMjAlMkIlMjBzdHIocm93KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sql_engine</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Allows you to perform SQL queries on the table. Returns a string representation of the result.
    The table is named &#x27;receipts&#x27;. Its description is as follows:
        Columns:
        - receipt_id: INTEGER
        - customer_name: VARCHAR(16)
        - price: FLOAT
        - tip: FLOAT

    Args:
        query: The query to perform. This should be correct SQL.
    &quot;&quot;&quot;</span>
    output = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
        rows = con.execute(text(query))
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
            output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
    <span class="hljs-keyword">return</span> output`,wrap:!1}}),G=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBSZWFjdENvZGVBZ2VudCUyQyUyMEhmQXBpRW5naW5lJTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNxbF9lbmdpbmUlNUQlMkMlMEElMjAlMjAlMjAlMjBsbG1fZW5naW5lJTNESGZBcGlFbmdpbmUoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiklMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> ReactCodeAgent, HfApiEngine

agent = ReactCodeAgent(
    tools=[sql_engine],
    llm_engine=HfApiEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>),
)`,wrap:!1}}),_=new U({props:{code:"YWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMGNsaWVudCUyMHdobyUyMGdvdCUyMHRoZSUyMG1vc3QlMjBleHBlbnNpdmUlMjByZWNlaXB0JTNGJTIyKQ==",highlighted:'agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)',wrap:!1}}),x=new Yt({props:{title:"Increasing difficulty: Table joins",local:"increasing-difficulty-table-joins",headingTag:"h2"}}),F=new U({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEFyZWNlaXB0cyUyMCUzRCUyMFRhYmxlKCUwQSUyMCUyMCUyMCUyMHRhYmxlX25hbWUlMkMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YV9vYmolMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycmVjZWlwdF9pZCUyMiUyQyUyMEludGVnZXIlMkMlMjBwcmltYXJ5X2tleSUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMndhaXRlcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEEpJTBBbWV0YWRhdGFfb2JqLmNyZWF0ZV9hbGwoZW5naW5lKSUwQSUwQXJvd3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMSUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyQ29yZXklMjBKb2huc29uJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAzJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNaWNoYWVsJTIwV2F0dHMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWFyZ2FyZXQlMjBKYW1lcyUyMiU3RCUyQyUwQSU1RCUwQWZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMHN0bXQlMjAlM0QlMjBpbnNlcnQocmVjZWlwdHMpLnZhbHVlcygqKnJvdyklMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmJlZ2luKCklMjBhcyUyMGNvbm5lY3Rpb24lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdXJzb3IlMjAlM0QlMjBjb25uZWN0aW9uLmV4ZWN1dGUoc3RtdCk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),z=new U({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
<span class="hljs-meta">... </span>It can use the following tables:&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inspector = inspect(engine)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
<span class="hljs-meta">... </span>    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

<span class="hljs-meta">... </span>    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

<span class="hljs-meta">... </span>    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-meta">... </span>    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),P=new U({props:{code:"c3FsX2VuZ2luZS5kZXNjcmlwdGlvbiUyMCUzRCUyMHVwZGF0ZWRfZGVzY3JpcHRpb24lMEElMEFhZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCc3FsX2VuZ2luZSU1RCUyQyUwQSUyMCUyMCUyMCUyMGxsbV9lbmdpbmUlM0RIZkFwaUVuZ2luZSglMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIpJTJDJTBBKSUwQSUwQWFnZW50LnJ1biglMjJXaGljaCUyMHdhaXRlciUyMGdvdCUyMG1vcmUlMjB0b3RhbCUyMG1vbmV5JTIwZnJvbSUyMHRpcHMlM0YlMjIp",highlighted:`sql_engine.description = updated_description

agent = ReactCodeAgent(
    tools=[sql_engine],
    llm_engine=HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>),
)

agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),lt=new Bl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agent_text_to_sql.md"}}),{c(){J=M("meta"),nt=n(),st=M("p"),at=n(),o(w.$$.fragment),Mt=n(),o(m.$$.fragment),pt=n(),T=M("p"),T.innerHTML=Lt,it=n(),h=M("p"),h.innerHTML=zt,ot=n(),b=M("p"),b.textContent=Dt,yt=n(),d=M("p"),d.textContent=Kt,rt=n(),I=M("p"),I.innerHTML=Pt,ct=n(),C=M("p"),C.textContent=Ot,jt=n(),o(g.$$.fragment),ut=n(),o(f.$$.fragment),Ut=n(),o(B.$$.fragment),Jt=n(),q=M("p"),q.textContent=tl,wt=n(),o(A.$$.fragment),mt=n(),Q=M("pre"),Q.textContent=ll,Tt=n(),o(W.$$.fragment),ht=n(),Z=M("p"),Z.textContent=sl,bt=n(),S=M("p"),S.innerHTML=el,dt=n(),o(R.$$.fragment),It=n(),E=M("pre"),E.textContent=nl,Ct=n(),v=M("p"),v.innerHTML=al,gt=n(),N=M("ul"),N.innerHTML=Ml,ft=n(),o(k.$$.fragment),Bt=n(),V=M("p"),V.textContent=pl,qt=n(),H=M("p"),H.innerHTML=il,At=n(),$=M("p"),$.innerHTML=ol,Qt=n(),o(G.$$.fragment),Wt=n(),o(_.$$.fragment),Zt=n(),o(x.$$.fragment),St=n(),X=M("p"),X.textContent=yl,Rt=n(),Y=M("p"),Y.innerHTML=rl,Et=n(),o(F.$$.fragment),vt=n(),L=M("p"),L.innerHTML=cl,Nt=n(),o(z.$$.fragment),kt=n(),D=M("pre"),D.textContent=jl,Vt=n(),K=M("p"),K.innerHTML=ul,Ht=n(),o(P.$$.fragment),$t=n(),O=M("p"),O.textContent=Ul,Gt=n(),tt=M("p"),tt.textContent=Jl,_t=n(),o(lt.$$.fragment),xt=n(),et=M("p"),this.h()},l(t){const l=Cl("svelte-u9bgzb",document.head);J=p(l,"META",{name:!0,content:!0}),l.forEach(s),nt=a(t),st=p(t,"P",{}),wl(st).forEach(s),at=a(t),y(w.$$.fragment,t),Mt=a(t),y(m.$$.fragment,t),pt=a(t),T=p(t,"P",{"data-svelte-h":!0}),i(T)!=="svelte-1xlqnsv"&&(T.innerHTML=Lt),it=a(t),h=p(t,"P",{"data-svelte-h":!0}),i(h)!=="svelte-wem15p"&&(h.innerHTML=zt),ot=a(t),b=p(t,"P",{"data-svelte-h":!0}),i(b)!=="svelte-3ojw25"&&(b.textContent=Dt),yt=a(t),d=p(t,"P",{"data-svelte-h":!0}),i(d)!=="svelte-1hw7g6s"&&(d.textContent=Kt),rt=a(t),I=p(t,"P",{"data-svelte-h":!0}),i(I)!=="svelte-q251yb"&&(I.innerHTML=Pt),ct=a(t),C=p(t,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1tzrwc8"&&(C.textContent=Ot),jt=a(t),y(g.$$.fragment,t),ut=a(t),y(f.$$.fragment,t),Ut=a(t),y(B.$$.fragment,t),Jt=a(t),q=p(t,"P",{"data-svelte-h":!0}),i(q)!=="svelte-ec23hm"&&(q.textContent=tl),wt=a(t),y(A.$$.fragment,t),mt=a(t),Q=p(t,"PRE",{"data-svelte-h":!0}),i(Q)!=="svelte-jbb28p"&&(Q.textContent=ll),Tt=a(t),y(W.$$.fragment,t),ht=a(t),Z=p(t,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-fdu5cw"&&(Z.textContent=sl),bt=a(t),S=p(t,"P",{"data-svelte-h":!0}),i(S)!=="svelte-jme9kq"&&(S.innerHTML=el),dt=a(t),y(R.$$.fragment,t),It=a(t),E=p(t,"PRE",{"data-svelte-h":!0}),i(E)!=="svelte-1pz02dc"&&(E.textContent=nl),Ct=a(t),v=p(t,"P",{"data-svelte-h":!0}),i(v)!=="svelte-hmqh57"&&(v.innerHTML=al),gt=a(t),N=p(t,"UL",{"data-svelte-h":!0}),i(N)!=="svelte-1awt4d8"&&(N.innerHTML=Ml),ft=a(t),y(k.$$.fragment,t),Bt=a(t),V=p(t,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1t4r7cu"&&(V.textContent=pl),qt=a(t),H=p(t,"P",{"data-svelte-h":!0}),i(H)!=="svelte-12rc58c"&&(H.innerHTML=il),At=a(t),$=p(t,"P",{"data-svelte-h":!0}),i($)!=="svelte-1efohjn"&&($.innerHTML=ol),Qt=a(t),y(G.$$.fragment,t),Wt=a(t),y(_.$$.fragment,t),Zt=a(t),y(x.$$.fragment,t),St=a(t),X=p(t,"P",{"data-svelte-h":!0}),i(X)!=="svelte-nr3fl7"&&(X.textContent=yl),Rt=a(t),Y=p(t,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-6lwjm6"&&(Y.innerHTML=rl),Et=a(t),y(F.$$.fragment,t),vt=a(t),L=p(t,"P",{"data-svelte-h":!0}),i(L)!=="svelte-frhx8p"&&(L.innerHTML=cl),Nt=a(t),y(z.$$.fragment,t),kt=a(t),D=p(t,"PRE",{"data-svelte-h":!0}),i(D)!=="svelte-d75mf2"&&(D.textContent=jl),Vt=a(t),K=p(t,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1rg01xj"&&(K.innerHTML=ul),Ht=a(t),y(P.$$.fragment,t),$t=a(t),O=p(t,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1umn140"&&(O.textContent=Ul),Gt=a(t),tt=p(t,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-bt1f1w"&&(tt.textContent=Jl),_t=a(t),y(lt.$$.fragment,t),xt=a(t),et=p(t,"P",{}),wl(et).forEach(s),this.h()},h(){ml(J,"name","hf:doc:metadata"),ml(J,"content",Al)},m(t,l){gl(document.head,J),e(t,nt,l),e(t,st,l),e(t,at,l),r(w,t,l),e(t,Mt,l),r(m,t,l),e(t,pt,l),e(t,T,l),e(t,it,l),e(t,h,l),e(t,ot,l),e(t,b,l),e(t,yt,l),e(t,d,l),e(t,rt,l),e(t,I,l),e(t,ct,l),e(t,C,l),e(t,jt,l),r(g,t,l),e(t,ut,l),r(f,t,l),e(t,Ut,l),r(B,t,l),e(t,Jt,l),e(t,q,l),e(t,wt,l),r(A,t,l),e(t,mt,l),e(t,Q,l),e(t,Tt,l),r(W,t,l),e(t,ht,l),e(t,Z,l),e(t,bt,l),e(t,S,l),e(t,dt,l),r(R,t,l),e(t,It,l),e(t,E,l),e(t,Ct,l),e(t,v,l),e(t,gt,l),e(t,N,l),e(t,ft,l),r(k,t,l),e(t,Bt,l),e(t,V,l),e(t,qt,l),e(t,H,l),e(t,At,l),e(t,$,l),e(t,Qt,l),r(G,t,l),e(t,Wt,l),r(_,t,l),e(t,Zt,l),r(x,t,l),e(t,St,l),e(t,X,l),e(t,Rt,l),e(t,Y,l),e(t,Et,l),r(F,t,l),e(t,vt,l),e(t,L,l),e(t,Nt,l),r(z,t,l),e(t,kt,l),e(t,D,l),e(t,Vt,l),e(t,K,l),e(t,Ht,l),r(P,t,l),e(t,$t,l),e(t,O,l),e(t,Gt,l),e(t,tt,l),e(t,_t,l),r(lt,t,l),e(t,xt,l),e(t,et,l),Xt=!0},p:hl,i(t){Xt||(c(w.$$.fragment,t),c(m.$$.fragment,t),c(g.$$.fragment,t),c(f.$$.fragment,t),c(B.$$.fragment,t),c(A.$$.fragment,t),c(W.$$.fragment,t),c(R.$$.fragment,t),c(k.$$.fragment,t),c(G.$$.fragment,t),c(_.$$.fragment,t),c(x.$$.fragment,t),c(F.$$.fragment,t),c(z.$$.fragment,t),c(P.$$.fragment,t),c(lt.$$.fragment,t),Xt=!0)},o(t){j(w.$$.fragment,t),j(m.$$.fragment,t),j(g.$$.fragment,t),j(f.$$.fragment,t),j(B.$$.fragment,t),j(A.$$.fragment,t),j(W.$$.fragment,t),j(R.$$.fragment,t),j(k.$$.fragment,t),j(G.$$.fragment,t),j(_.$$.fragment,t),j(x.$$.fragment,t),j(F.$$.fragment,t),j(z.$$.fragment,t),j(P.$$.fragment,t),j(lt.$$.fragment,t),Xt=!1},d(t){t&&(s(nt),s(st),s(at),s(Mt),s(pt),s(T),s(it),s(h),s(ot),s(b),s(yt),s(d),s(rt),s(I),s(ct),s(C),s(jt),s(ut),s(Ut),s(Jt),s(q),s(wt),s(mt),s(Q),s(Tt),s(ht),s(Z),s(bt),s(S),s(dt),s(It),s(E),s(Ct),s(v),s(gt),s(N),s(ft),s(Bt),s(V),s(qt),s(H),s(At),s($),s(Qt),s(Wt),s(Zt),s(St),s(X),s(Rt),s(Y),s(Et),s(vt),s(L),s(Nt),s(kt),s(D),s(Vt),s(K),s(Ht),s($t),s(O),s(Gt),s(tt),s(_t),s(xt),s(et)),s(J),u(w,t),u(m,t),u(g,t),u(f,t),u(B,t),u(A,t),u(W,t),u(R,t),u(k,t),u(G,t),u(_,t),u(x,t),u(F,t),u(z,t),u(P,t),u(lt,t)}}}const Al='{"title":"Agent for text-to-SQL with automatic error correction","local":"agent-for-text-to-sql-with-automatic-error-correction","sections":[{"title":"Setup SQL tables","local":"setup-sql-tables","sections":[],"depth":2},{"title":"Build our agent","local":"build-our-agent","sections":[],"depth":2},{"title":"Increasing difficulty: Table joins","local":"increasing-difficulty-table-joins","sections":[],"depth":2}],"depth":1}';function Ql(Ft){return bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class El extends dl{constructor(J){super(),Il(this,J,Ql,ql,Tl,{})}}export{El as component};
