import{s as xt,f as $t,o as jt,n as Ge}from"../chunks/scheduler.9bc65507.js";import{S as Mt,i as Yt,g as c,s,r as h,A as It,h as d,f as t,c as a,j,u as g,x as y,k as x,y as i,a as r,v as f,d as u,t as _,w as b}from"../chunks/index.707bf1b6.js";import{T as Ao}from"../chunks/Tip.c2ecdbf4.js";import{D as z}from"../chunks/Docstring.570ddb64.js";import{C as Ko}from"../chunks/CodeBlock.54a9f38d.js";import{E as Xo}from"../chunks/ExampleCodeBlock.bc2be6bc.js";import{P as Ct}from"../chunks/PipelineTag.44585822.js";import{H as K,E as Jt}from"../chunks/EditOnGithub.922df6ba.js";function zt(M){let n,v='Use <a href="/docs/transformers/v4.40.0/en/model_doc/yolos#transformers.YolosImageProcessor">YolosImageProcessor</a> for preparing images (and optional targets) for the model. Contrary to <a href="detr">DETR</a>, YOLOS doesn’t require a <code>pixel_mask</code> to be created.';return{c(){n=c("p"),n.innerHTML=v},l(m){n=d(m,"P",{"data-svelte-h":!0}),y(n)!=="svelte-7lfd0r"&&(n.innerHTML=v)},m(m,p){r(m,n,p)},p:Ge,d(m){m&&t(n)}}}function Ut(M){let n,v="Example:",m,p,T;return p=new Ko({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFlvbG9zQ29uZmlnJTJDJTIwWW9sb3NNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBZT0xPUyUyMGh1c3R2bCUyRnlvbG9zLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwWW9sb3NDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwaHVzdHZsJTJGeW9sb3MtYmFzZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwWW9sb3NNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> YolosConfig, YolosModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a YOLOS hustvl/yolos-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = YolosConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the hustvl/yolos-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = YolosModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=c("p"),n.textContent=v,m=s(),h(p.$$.fragment)},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=v),m=a(l),g(p.$$.fragment,l)},m(l,w){r(l,n,w),r(l,m,w),f(p,l,w),T=!0},p:Ge,i(l){T||(u(p.$$.fragment,l),T=!0)},o(l){_(p.$$.fragment,l),T=!1},d(l){l&&(t(n),t(m)),b(p,l)}}}function kt(M){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=v},l(m){n=d(m,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,p){r(m,n,p)},p:Ge,d(m){m&&t(n)}}}function Pt(M){let n,v="Example:",m,p,T;return p=new Ko({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFlvbG9zTW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnlvbG9zLXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwWW9sb3NNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyaHVzdHZsJTJGeW9sb3Mtc21hbGwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, YolosModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = YolosModel.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3401</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){n=c("p"),n.textContent=v,m=s(),h(p.$$.fragment)},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=v),m=a(l),g(p.$$.fragment,l)},m(l,w){r(l,n,w),r(l,m,w),f(p,l,w),T=!0},p:Ge,i(l){T||(u(p.$$.fragment,l),T=!0)},o(l){_(p.$$.fragment,l),T=!1},d(l){l&&(t(n),t(m)),b(p,l)}}}function Ft(M){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=v},l(m){n=d(m,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,p){r(m,n,p)},p:Ge,d(m){m&&t(n)}}}function Nt(M){let n,v="Examples:",m,p,T;return p=new Ko({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy10aW55JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy10aW55JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBvdXRwdXRzJTIwKGJvdW5kaW5nJTIwYm94ZXMlMjBhbmQlMjBjbGFzcyUyMGxvZ2l0cyklMjB0byUyMFBhc2NhbCUyMFZPQyUyMGZvcm1hdCUyMCh4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4KSUwQXRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlNUQpJTBBcmVzdWx0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfb2JqZWN0X2RldGVjdGlvbihvdXRwdXRzJTJDJTIwdGhyZXNob2xkJTNEMC45JTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzKSU1QiUwQSUyMCUyMCUyMCUyMDAlMEElNUQlMEElMEFmb3IlMjBzY29yZSUyQyUyMGxhYmVsJTJDJTIwYm94JTIwaW4lMjB6aXAocmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RCUyQyUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIyYm94ZXMlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwYm94JTIwJTNEJTIwJTVCcm91bmQoaSUyQyUyMDIpJTIwZm9yJTIwaSUyMGluJTIwYm94LnRvbGlzdCgpJTVEJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRldGVjdGVkJTIwJTdCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCbGFiZWwuaXRlbSgpJTVEJTdEJTIwd2l0aCUyMGNvbmZpZGVuY2UlMjAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyJTdCcm91bmQoc2NvcmUuaXRlbSgpJTJDJTIwMyklN0QlMjBhdCUyMGxvY2F0aW9uJTIwJTdCYm94JTdEJTIyJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.991</span> at location [<span class="hljs-number">46.48</span>, <span class="hljs-number">72.78</span>, <span class="hljs-number">178.98</span>, <span class="hljs-number">119.3</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.908</span> at location [<span class="hljs-number">336.48</span>, <span class="hljs-number">79.27</span>, <span class="hljs-number">368.23</span>, <span class="hljs-number">192.36</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.934</span> at location [<span class="hljs-number">337.18</span>, <span class="hljs-number">18.06</span>, <span class="hljs-number">638.14</span>, <span class="hljs-number">373.09</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.979</span> at location [<span class="hljs-number">10.93</span>, <span class="hljs-number">53.74</span>, <span class="hljs-number">313.41</span>, <span class="hljs-number">470.67</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.974</span> at location [<span class="hljs-number">41.63</span>, <span class="hljs-number">72.23</span>, <span class="hljs-number">178.09</span>, <span class="hljs-number">119.99</span>]`,wrap:!1}}),{c(){n=c("p"),n.textContent=v,m=s(),h(p.$$.fragment)},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=v),m=a(l),g(p.$$.fragment,l)},m(l,w){r(l,n,w),r(l,m,w),f(p,l,w),T=!0},p:Ge,i(l){T||(u(p.$$.fragment,l),T=!0)},o(l){_(p.$$.fragment,l),T=!1},d(l){l&&(t(n),t(m)),b(p,l)}}}function Ot(M){let n,v,m,p,T,l,w,Be,ee,et=`The YOLOS model was proposed in <a href="https://arxiv.org/abs/2106.00666" rel="nofollow">You Only Look at One Sequence: Rethinking Transformer in Vision through Object Detection</a> by Yuxin Fang, Bencheng Liao, Xinggang Wang, Jiemin Fang, Jiyang Qi, Rui Wu, Jianwei Niu, Wenyu Liu.
YOLOS proposes to just leverage the plain <a href="vit">Vision Transformer (ViT)</a> for object detection, inspired by DETR. It turns out that a base-sized encoder-only Transformer can also achieve 42 AP on COCO, similar to DETR and much more complex frameworks such as Faster R-CNN.`,Qe,oe,ot="The abstract from the paper is the following:",Ae,te,tt="<em>Can Transformer perform 2D object- and region-level recognition from a pure sequence-to-sequence perspective with minimal knowledge about the 2D spatial structure? To answer this question, we present You Only Look at One Sequence (YOLOS), a series of object detection models based on the vanilla Vision Transformer with the fewest possible modifications, region priors, as well as inductive biases of the target task. We find that YOLOS pre-trained on the mid-sized ImageNet-1k dataset only can already achieve quite competitive performance on the challenging COCO object detection benchmark, e.g., YOLOS-Base directly adopted from BERT-Base architecture can obtain 42.0 box AP on COCO val. We also discuss the impacts as well as limitations of current pre-train schemes and model scaling strategies for Transformer in vision through YOLOS.</em>",Xe,O,nt,Ke,ne,st='YOLOS architecture. Taken from the <a href="https://arxiv.org/abs/2106.00666">original paper</a>.',eo,se,at='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/hustvl/YOLOS" rel="nofollow">here</a>.',oo,ae,to,re,rt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with YOLOS.",no,ie,so,le,it='<li>All example notebooks illustrating inference + fine-tuning <a href="/docs/transformers/v4.40.0/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> on a custom dataset can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/YOLOS" rel="nofollow">here</a>.</li> <li>See also: <a href="../tasks/object_detection">Object detection task guide</a></li>',ao,ce,lt="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",ro,W,io,de,lo,Y,me,$o,Ue,ct=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.40.0/en/model_doc/yolos#transformers.YolosModel">YolosModel</a>. It is used to instantiate a YOLOS
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the YOLOS
<a href="https://huggingface.co/hustvl/yolos-base" rel="nofollow">hustvl/yolos-base</a> architecture.`,jo,ke,dt=`Configuration objects inherit from <a href="/docs/transformers/v4.40.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.40.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Mo,D,co,pe,mo,$,he,Yo,Pe,mt="Constructs a Detr image processor.",Io,L,ge,Co,Fe,pt="Preprocess an image or a batch of images so that it can be used by the model.",Jo,R,fe,zo,Ne,ht=`Pads a batch of images to the bottom and right of the image with zeros to the size of largest height and width
in the batch and optionally returns their corresponding pixel mask.`,Uo,E,ue,ko,Oe,gt=`Converts the raw output of <a href="/docs/transformers/v4.40.0/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,po,_e,ho,I,be,Po,Z,ye,Fo,We,ft="Preprocess an image or a batch of images.",No,q,ve,Oo,De,ut=`Pads a batch of images to the bottom and right of the image with zeros to the size of largest height and width
in the batch and optionally returns their corresponding pixel mask.`,Wo,V,Te,Do,Le,_t=`Converts the raw output of <a href="/docs/transformers/v4.40.0/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,go,we,fo,P,xe,Lo,Re,bt=`The bare YOLOS Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ro,U,$e,Eo,Ee,yt='The <a href="/docs/transformers/v4.40.0/en/model_doc/yolos#transformers.YolosModel">YolosModel</a> forward method, overrides the <code>__call__</code> special method.',Zo,S,qo,G,uo,je,_o,C,Me,Vo,Ze,vt="YOLOS Model (consisting of a ViT encoder) with object detection heads on top, for tasks such as COCO detection.",So,qe,Tt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Go,k,Ye,Ho,Ve,wt='The <a href="/docs/transformers/v4.40.0/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',Bo,H,Qo,B,bo,Ie,yo,He,vo;return T=new K({props:{title:"YOLOS",local:"yolos",headingTag:"h1"}}),w=new K({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ae=new K({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ie=new Ct({props:{pipeline:"object-detection"}}),W=new Ao({props:{$$slots:{default:[zt]},$$scope:{ctx:M}}}),de=new K({props:{title:"YolosConfig",local:"transformers.YolosConfig",headingTag:"h2"}}),me=new z({props:{name:"class transformers.YolosConfig",anchor:"transformers.YolosConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = [512, 864]"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"qkv_bias",val:" = True"},{name:"num_detection_tokens",val:" = 100"},{name:"use_mid_position_embeddings",val:" = True"},{name:"auxiliary_loss",val:" = False"},{name:"class_cost",val:" = 1"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"eos_coefficient",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.YolosConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.YolosConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.YolosConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.YolosConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.YolosConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.YolosConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.YolosConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.YolosConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.YolosConfig.image_size",description:`<strong>image_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[512, 864]</code>) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.YolosConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.YolosConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.YolosConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.YolosConfig.num_detection_tokens",description:`<strong>num_detection_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of detection tokens.`,name:"num_detection_tokens"},{anchor:"transformers.YolosConfig.use_mid_position_embeddings",description:`<strong>use_mid_position_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the mid-layer position encodings.`,name:"use_mid_position_embeddings"},{anchor:"transformers.YolosConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.YolosConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.YolosConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.YolosConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.YolosConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.YolosConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.YolosConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/yolos/configuration_yolos.py#L33"}}),D=new Xo({props:{anchor:"transformers.YolosConfig.example",$$slots:{default:[Ut]},$$scope:{ctx:M}}}),pe=new K({props:{title:"YolosImageProcessor",local:"transformers.YolosImageProcessor",headingTag:"h2"}}),he=new z({props:{name:"class transformers.YolosImageProcessor",anchor:"transformers.YolosImageProcessor",parameters:[{name:"format",val:": Union = <AnnotationFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_annotations",val:": Optional = None"},{name:"do_pad",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;coco_detection&quot;</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.YolosImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.YolosImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s (height, width) dimensions after resizing. Can be overridden by the <code>size</code> parameter in
the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.YolosImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.YolosImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.YolosImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.
do_normalize &#x2014;
Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.YolosImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.YolosImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.YolosImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code> will pad the images in the batch to the largest height and width in the batch.
Padding will be applied to the bottom and right of the image with zeros.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/yolos/image_processing_yolos.py#L670"}}),ge=new z({props:{name:"preprocess",anchor:"transformers.YolosImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"annotations",val:": Union = None"},{name:"return_segmentation_masks",val:": bool = None"},{name:"masks_path",val:": Union = None"},{name:"do_resize",val:": Optional = None"},{name:"size",val:": Optional = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": Optional = None"},{name:"rescale_factor",val:": Union = None"},{name:"do_normalize",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_annotations",val:": Optional = None"},{name:"do_pad",val:": Optional = None"},{name:"format",val:": Union = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Union = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.YolosImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.YolosImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.YolosImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.YolosImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.YolosImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.YolosImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.YolosImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.YolosImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.YolosImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.YolosImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.YolosImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.YolosImageProcessor.preprocess.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_convert_annotations) &#x2014;
Whether to convert the annotations to the format expected by the model. Converts the bounding
boxes from the format <code>(top_left_x, top_left_y, width, height)</code> to <code>(center_x, center_y, width, height)</code>
and in relative coordinates.`,name:"do_convert_annotations"},{anchor:"transformers.YolosImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image. If <code>True</code> will pad the images in the batch to the largest image in the batch
and create a pixel mask. Padding will be applied to the bottom and right of the image with zeros.`,name:"do_pad"},{anchor:"transformers.YolosImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotationFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.YolosImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.YolosImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>, defaults to self.data_format) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/yolos/image_processing_yolos.py#L1107"}}),fe=new z({props:{name:"pad",anchor:"transformers.YolosImageProcessor.pad",parameters:[{name:"images",val:": List"},{name:"annotations",val:": Optional = None"},{name:"constant_values",val:": Union = 0"},{name:"return_pixel_mask",val:": bool = False"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = None"},{name:"input_data_format",val:": Union = None"},{name:"update_bboxes",val:": bool = True"}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.pad.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to pad.`,name:"image"},{anchor:"transformers.YolosImageProcessor.pad.annotations",description:`<strong>annotations</strong> (<code>List[Dict[str, any]]</code>, <em>optional</em>) &#x2014;
Annotations to pad along with the images. If provided, the bounding boxes will be updated to match the
padded images.`,name:"annotations"},{anchor:"transformers.YolosImageProcessor.pad.constant_values",description:`<strong>constant_values</strong> (<code>float</code> or <code>Iterable[float]</code>, <em>optional</em>) &#x2014;
The value to use for the padding if <code>mode</code> is <code>&quot;constant&quot;</code>.`,name:"constant_values"},{anchor:"transformers.YolosImageProcessor.pad.return_pixel_mask",description:`<strong>return_pixel_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return a pixel mask.`,name:"return_pixel_mask"},{anchor:"transformers.YolosImageProcessor.pad.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.YolosImageProcessor.pad.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosImageProcessor.pad.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"},{anchor:"transformers.YolosImageProcessor.pad.update_bboxes",description:`<strong>update_bboxes</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to update the bounding boxes in the annotations to match the padded images. If the
bounding boxes have not been converted to relative coordinates and <code>(centre_x, centre_y, width, height)</code>
format, the bounding boxes will not be updated.`,name:"update_bboxes"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/yolos/image_processing_yolos.py#L1030"}}),ue=new z({props:{name:"post_process_object_detection",anchor:"transformers.YolosImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": Union = None"}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>YolosObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.YolosImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.YolosImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/yolos/image_processing_yolos.py#L1396",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),_e=new K({props:{title:"YolosFeatureExtractor",local:"transformers.YolosFeatureExtractor",headingTag:"h2"}}),be=new z({props:{name:"class transformers.YolosFeatureExtractor",anchor:"transformers.YolosFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/yolos/feature_extraction_yolos.py#L36"}}),ye=new z({props:{name:"__call__",anchor:"transformers.YolosFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/image_processing_utils.py#L549"}}),ve=new z({props:{name:"pad",anchor:"transformers.YolosFeatureExtractor.pad",parameters:[{name:"images",val:": List"},{name:"annotations",val:": Optional = None"},{name:"constant_values",val:": Union = 0"},{name:"return_pixel_mask",val:": bool = False"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = None"},{name:"input_data_format",val:": Union = None"},{name:"update_bboxes",val:": bool = True"}],parametersDescription:[{anchor:"transformers.YolosFeatureExtractor.pad.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to pad.`,name:"image"},{anchor:"transformers.YolosFeatureExtractor.pad.annotations",description:`<strong>annotations</strong> (<code>List[Dict[str, any]]</code>, <em>optional</em>) &#x2014;
Annotations to pad along with the images. If provided, the bounding boxes will be updated to match the
padded images.`,name:"annotations"},{anchor:"transformers.YolosFeatureExtractor.pad.constant_values",description:`<strong>constant_values</strong> (<code>float</code> or <code>Iterable[float]</code>, <em>optional</em>) &#x2014;
The value to use for the padding if <code>mode</code> is <code>&quot;constant&quot;</code>.`,name:"constant_values"},{anchor:"transformers.YolosFeatureExtractor.pad.return_pixel_mask",description:`<strong>return_pixel_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return a pixel mask.`,name:"return_pixel_mask"},{anchor:"transformers.YolosFeatureExtractor.pad.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.YolosFeatureExtractor.pad.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosFeatureExtractor.pad.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"},{anchor:"transformers.YolosFeatureExtractor.pad.update_bboxes",description:`<strong>update_bboxes</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to update the bounding boxes in the annotations to match the padded images. If the
bounding boxes have not been converted to relative coordinates and <code>(centre_x, centre_y, width, height)</code>
format, the bounding boxes will not be updated.`,name:"update_bboxes"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/yolos/image_processing_yolos.py#L1030"}}),Te=new z({props:{name:"post_process_object_detection",anchor:"transformers.YolosFeatureExtractor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": Union = None"}],parametersDescription:[{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>YolosObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/yolos/image_processing_yolos.py#L1396",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),we=new K({props:{title:"YolosModel",local:"transformers.YolosModel",headingTag:"h2"}}),xe=new z({props:{name:"class transformers.YolosModel",anchor:"transformers.YolosModel",parameters:[{name:"config",val:": YolosConfig"},{name:"add_pooling_layer",val:": bool = True"}],parametersDescription:[{anchor:"transformers.YolosModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.40.0/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.40.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/yolos/modeling_yolos.py#L584"}}),$e=new z({props:{name:"forward",anchor:"transformers.YolosModel.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.YolosModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.40.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.40.0/en/model_doc/fuyu#transformers.FuyuImageProcessor.__call__">YolosImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.YolosModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.YolosModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.YolosModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.YolosModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.40.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/yolos/modeling_yolos.py#L616",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.40.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.40.0/en/model_doc/yolos#transformers.YolosConfig"
>YolosConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.40.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),S=new Ao({props:{$$slots:{default:[kt]},$$scope:{ctx:M}}}),G=new Xo({props:{anchor:"transformers.YolosModel.forward.example",$$slots:{default:[Pt]},$$scope:{ctx:M}}}),je=new K({props:{title:"YolosForObjectDetection",local:"transformers.YolosForObjectDetection",headingTag:"h2"}}),Me=new z({props:{name:"class transformers.YolosForObjectDetection",anchor:"transformers.YolosForObjectDetection",parameters:[{name:"config",val:": YolosConfig"}],parametersDescription:[{anchor:"transformers.YolosForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.40.0/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.40.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/yolos/modeling_yolos.py#L690"}}),Ye=new z({props:{name:"forward",anchor:"transformers.YolosForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.YolosForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.40.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.40.0/en/model_doc/fuyu#transformers.FuyuImageProcessor.__call__">YolosImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.YolosForObjectDetection.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.YolosForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.YolosForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.YolosForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.40.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.YolosForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: <code>&apos;class_labels&apos;</code> and <code>&apos;boxes&apos;</code> (the class labels and bounding boxes of an image in the
batch respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/yolos/modeling_yolos.py#L723",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.yolos.modeling_yolos.YolosObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.40.0/en/model_doc/yolos#transformers.YolosConfig"
>YolosConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <code>post_process()</code> to retrieve the unnormalized bounding
boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of
the model at the output of each layer plus the optional initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.yolos.modeling_yolos.YolosObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),H=new Ao({props:{$$slots:{default:[Ft]},$$scope:{ctx:M}}}),B=new Xo({props:{anchor:"transformers.YolosForObjectDetection.forward.example",$$slots:{default:[Nt]},$$scope:{ctx:M}}}),Ie=new Jt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/yolos.md"}}),{c(){n=c("meta"),v=s(),m=c("p"),p=s(),h(T.$$.fragment),l=s(),h(w.$$.fragment),Be=s(),ee=c("p"),ee.innerHTML=et,Qe=s(),oe=c("p"),oe.textContent=ot,Ae=s(),te=c("p"),te.innerHTML=tt,Xe=s(),O=c("img"),Ke=s(),ne=c("small"),ne.innerHTML=st,eo=s(),se=c("p"),se.innerHTML=at,oo=s(),h(ae.$$.fragment),to=s(),re=c("p"),re.textContent=rt,no=s(),h(ie.$$.fragment),so=s(),le=c("ul"),le.innerHTML=it,ao=s(),ce=c("p"),ce.textContent=lt,ro=s(),h(W.$$.fragment),io=s(),h(de.$$.fragment),lo=s(),Y=c("div"),h(me.$$.fragment),$o=s(),Ue=c("p"),Ue.innerHTML=ct,jo=s(),ke=c("p"),ke.innerHTML=dt,Mo=s(),h(D.$$.fragment),co=s(),h(pe.$$.fragment),mo=s(),$=c("div"),h(he.$$.fragment),Yo=s(),Pe=c("p"),Pe.textContent=mt,Io=s(),L=c("div"),h(ge.$$.fragment),Co=s(),Fe=c("p"),Fe.textContent=pt,Jo=s(),R=c("div"),h(fe.$$.fragment),zo=s(),Ne=c("p"),Ne.textContent=ht,Uo=s(),E=c("div"),h(ue.$$.fragment),ko=s(),Oe=c("p"),Oe.innerHTML=gt,po=s(),h(_e.$$.fragment),ho=s(),I=c("div"),h(be.$$.fragment),Po=s(),Z=c("div"),h(ye.$$.fragment),Fo=s(),We=c("p"),We.textContent=ft,No=s(),q=c("div"),h(ve.$$.fragment),Oo=s(),De=c("p"),De.textContent=ut,Wo=s(),V=c("div"),h(Te.$$.fragment),Do=s(),Le=c("p"),Le.innerHTML=_t,go=s(),h(we.$$.fragment),fo=s(),P=c("div"),h(xe.$$.fragment),Lo=s(),Re=c("p"),Re.innerHTML=bt,Ro=s(),U=c("div"),h($e.$$.fragment),Eo=s(),Ee=c("p"),Ee.innerHTML=yt,Zo=s(),h(S.$$.fragment),qo=s(),h(G.$$.fragment),uo=s(),h(je.$$.fragment),_o=s(),C=c("div"),h(Me.$$.fragment),Vo=s(),Ze=c("p"),Ze.textContent=vt,So=s(),qe=c("p"),qe.innerHTML=Tt,Go=s(),k=c("div"),h(Ye.$$.fragment),Ho=s(),Ve=c("p"),Ve.innerHTML=wt,Bo=s(),h(H.$$.fragment),Qo=s(),h(B.$$.fragment),bo=s(),h(Ie.$$.fragment),yo=s(),He=c("p"),this.h()},l(e){const o=It("svelte-u9bgzb",document.head);n=d(o,"META",{name:!0,content:!0}),o.forEach(t),v=a(e),m=d(e,"P",{}),j(m).forEach(t),p=a(e),g(T.$$.fragment,e),l=a(e),g(w.$$.fragment,e),Be=a(e),ee=d(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-98a8ak"&&(ee.innerHTML=et),Qe=a(e),oe=d(e,"P",{"data-svelte-h":!0}),y(oe)!=="svelte-vfdo9a"&&(oe.textContent=ot),Ae=a(e),te=d(e,"P",{"data-svelte-h":!0}),y(te)!=="svelte-ng2z0l"&&(te.innerHTML=tt),Xe=a(e),O=d(e,"IMG",{src:!0,alt:!0,width:!0}),Ke=a(e),ne=d(e,"SMALL",{"data-svelte-h":!0}),y(ne)!=="svelte-vits75"&&(ne.innerHTML=st),eo=a(e),se=d(e,"P",{"data-svelte-h":!0}),y(se)!=="svelte-zgo631"&&(se.innerHTML=at),oo=a(e),g(ae.$$.fragment,e),to=a(e),re=d(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-93t6s9"&&(re.textContent=rt),no=a(e),g(ie.$$.fragment,e),so=a(e),le=d(e,"UL",{"data-svelte-h":!0}),y(le)!=="svelte-161g9pu"&&(le.innerHTML=it),ao=a(e),ce=d(e,"P",{"data-svelte-h":!0}),y(ce)!=="svelte-1xesile"&&(ce.textContent=lt),ro=a(e),g(W.$$.fragment,e),io=a(e),g(de.$$.fragment,e),lo=a(e),Y=d(e,"DIV",{class:!0});var F=j(Y);g(me.$$.fragment,F),$o=a(F),Ue=d(F,"P",{"data-svelte-h":!0}),y(Ue)!=="svelte-13lran6"&&(Ue.innerHTML=ct),jo=a(F),ke=d(F,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-1pfahiz"&&(ke.innerHTML=dt),Mo=a(F),g(D.$$.fragment,F),F.forEach(t),co=a(e),g(pe.$$.fragment,e),mo=a(e),$=d(e,"DIV",{class:!0});var J=j($);g(he.$$.fragment,J),Yo=a(J),Pe=d(J,"P",{"data-svelte-h":!0}),y(Pe)!=="svelte-19j0nu1"&&(Pe.textContent=mt),Io=a(J),L=d(J,"DIV",{class:!0});var Ce=j(L);g(ge.$$.fragment,Ce),Co=a(Ce),Fe=d(Ce,"P",{"data-svelte-h":!0}),y(Fe)!=="svelte-jgz2ra"&&(Fe.textContent=pt),Ce.forEach(t),Jo=a(J),R=d(J,"DIV",{class:!0});var Je=j(R);g(fe.$$.fragment,Je),zo=a(Je),Ne=d(Je,"P",{"data-svelte-h":!0}),y(Ne)!=="svelte-1f2f3d6"&&(Ne.textContent=ht),Je.forEach(t),Uo=a(J),E=d(J,"DIV",{class:!0});var ze=j(E);g(ue.$$.fragment,ze),ko=a(ze),Oe=d(ze,"P",{"data-svelte-h":!0}),y(Oe)!=="svelte-16qv47w"&&(Oe.innerHTML=gt),ze.forEach(t),J.forEach(t),po=a(e),g(_e.$$.fragment,e),ho=a(e),I=d(e,"DIV",{class:!0});var N=j(I);g(be.$$.fragment,N),Po=a(N),Z=d(N,"DIV",{class:!0});var To=j(Z);g(ye.$$.fragment,To),Fo=a(To),We=d(To,"P",{"data-svelte-h":!0}),y(We)!=="svelte-khengj"&&(We.textContent=ft),To.forEach(t),No=a(N),q=d(N,"DIV",{class:!0});var wo=j(q);g(ve.$$.fragment,wo),Oo=a(wo),De=d(wo,"P",{"data-svelte-h":!0}),y(De)!=="svelte-1f2f3d6"&&(De.textContent=ut),wo.forEach(t),Wo=a(N),V=d(N,"DIV",{class:!0});var xo=j(V);g(Te.$$.fragment,xo),Do=a(xo),Le=d(xo,"P",{"data-svelte-h":!0}),y(Le)!=="svelte-16qv47w"&&(Le.innerHTML=_t),xo.forEach(t),N.forEach(t),go=a(e),g(we.$$.fragment,e),fo=a(e),P=d(e,"DIV",{class:!0});var Se=j(P);g(xe.$$.fragment,Se),Lo=a(Se),Re=d(Se,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-19k5mgv"&&(Re.innerHTML=bt),Ro=a(Se),U=d(Se,"DIV",{class:!0});var Q=j(U);g($e.$$.fragment,Q),Eo=a(Q),Ee=d(Q,"P",{"data-svelte-h":!0}),y(Ee)!=="svelte-1jqu5vu"&&(Ee.innerHTML=yt),Zo=a(Q),g(S.$$.fragment,Q),qo=a(Q),g(G.$$.fragment,Q),Q.forEach(t),Se.forEach(t),uo=a(e),g(je.$$.fragment,e),_o=a(e),C=d(e,"DIV",{class:!0});var A=j(C);g(Me.$$.fragment,A),Vo=a(A),Ze=d(A,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-1yg9bo0"&&(Ze.textContent=vt),So=a(A),qe=d(A,"P",{"data-svelte-h":!0}),y(qe)!=="svelte-1gjh92c"&&(qe.innerHTML=Tt),Go=a(A),k=d(A,"DIV",{class:!0});var X=j(k);g(Ye.$$.fragment,X),Ho=a(X),Ve=d(X,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-1m5n5co"&&(Ve.innerHTML=wt),Bo=a(X),g(H.$$.fragment,X),Qo=a(X),g(B.$$.fragment,X),X.forEach(t),A.forEach(t),bo=a(e),g(Ie.$$.fragment,e),yo=a(e),He=d(e,"P",{}),j(He).forEach(t),this.h()},h(){x(n,"name","hf:doc:metadata"),x(n,"content",Wt),$t(O.src,nt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/yolos_architecture.png")||x(O,"src",nt),x(O,"alt","drawing"),x(O,"width","600"),x(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){i(document.head,n),r(e,v,o),r(e,m,o),r(e,p,o),f(T,e,o),r(e,l,o),f(w,e,o),r(e,Be,o),r(e,ee,o),r(e,Qe,o),r(e,oe,o),r(e,Ae,o),r(e,te,o),r(e,Xe,o),r(e,O,o),r(e,Ke,o),r(e,ne,o),r(e,eo,o),r(e,se,o),r(e,oo,o),f(ae,e,o),r(e,to,o),r(e,re,o),r(e,no,o),f(ie,e,o),r(e,so,o),r(e,le,o),r(e,ao,o),r(e,ce,o),r(e,ro,o),f(W,e,o),r(e,io,o),f(de,e,o),r(e,lo,o),r(e,Y,o),f(me,Y,null),i(Y,$o),i(Y,Ue),i(Y,jo),i(Y,ke),i(Y,Mo),f(D,Y,null),r(e,co,o),f(pe,e,o),r(e,mo,o),r(e,$,o),f(he,$,null),i($,Yo),i($,Pe),i($,Io),i($,L),f(ge,L,null),i(L,Co),i(L,Fe),i($,Jo),i($,R),f(fe,R,null),i(R,zo),i(R,Ne),i($,Uo),i($,E),f(ue,E,null),i(E,ko),i(E,Oe),r(e,po,o),f(_e,e,o),r(e,ho,o),r(e,I,o),f(be,I,null),i(I,Po),i(I,Z),f(ye,Z,null),i(Z,Fo),i(Z,We),i(I,No),i(I,q),f(ve,q,null),i(q,Oo),i(q,De),i(I,Wo),i(I,V),f(Te,V,null),i(V,Do),i(V,Le),r(e,go,o),f(we,e,o),r(e,fo,o),r(e,P,o),f(xe,P,null),i(P,Lo),i(P,Re),i(P,Ro),i(P,U),f($e,U,null),i(U,Eo),i(U,Ee),i(U,Zo),f(S,U,null),i(U,qo),f(G,U,null),r(e,uo,o),f(je,e,o),r(e,_o,o),r(e,C,o),f(Me,C,null),i(C,Vo),i(C,Ze),i(C,So),i(C,qe),i(C,Go),i(C,k),f(Ye,k,null),i(k,Ho),i(k,Ve),i(k,Bo),f(H,k,null),i(k,Qo),f(B,k,null),r(e,bo,o),f(Ie,e,o),r(e,yo,o),r(e,He,o),vo=!0},p(e,[o]){const F={};o&2&&(F.$$scope={dirty:o,ctx:e}),W.$set(F);const J={};o&2&&(J.$$scope={dirty:o,ctx:e}),D.$set(J);const Ce={};o&2&&(Ce.$$scope={dirty:o,ctx:e}),S.$set(Ce);const Je={};o&2&&(Je.$$scope={dirty:o,ctx:e}),G.$set(Je);const ze={};o&2&&(ze.$$scope={dirty:o,ctx:e}),H.$set(ze);const N={};o&2&&(N.$$scope={dirty:o,ctx:e}),B.$set(N)},i(e){vo||(u(T.$$.fragment,e),u(w.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(W.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(D.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(ve.$$.fragment,e),u(Te.$$.fragment,e),u(we.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(S.$$.fragment,e),u(G.$$.fragment,e),u(je.$$.fragment,e),u(Me.$$.fragment,e),u(Ye.$$.fragment,e),u(H.$$.fragment,e),u(B.$$.fragment,e),u(Ie.$$.fragment,e),vo=!0)},o(e){_(T.$$.fragment,e),_(w.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(W.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(D.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(ve.$$.fragment,e),_(Te.$$.fragment,e),_(we.$$.fragment,e),_(xe.$$.fragment,e),_($e.$$.fragment,e),_(S.$$.fragment,e),_(G.$$.fragment,e),_(je.$$.fragment,e),_(Me.$$.fragment,e),_(Ye.$$.fragment,e),_(H.$$.fragment,e),_(B.$$.fragment,e),_(Ie.$$.fragment,e),vo=!1},d(e){e&&(t(v),t(m),t(p),t(l),t(Be),t(ee),t(Qe),t(oe),t(Ae),t(te),t(Xe),t(O),t(Ke),t(ne),t(eo),t(se),t(oo),t(to),t(re),t(no),t(so),t(le),t(ao),t(ce),t(ro),t(io),t(lo),t(Y),t(co),t(mo),t($),t(po),t(ho),t(I),t(go),t(fo),t(P),t(uo),t(_o),t(C),t(bo),t(yo),t(He)),t(n),b(T,e),b(w,e),b(ae,e),b(ie,e),b(W,e),b(de,e),b(me),b(D),b(pe,e),b(he),b(ge),b(fe),b(ue),b(_e,e),b(be),b(ye),b(ve),b(Te),b(we,e),b(xe),b($e),b(S),b(G),b(je,e),b(Me),b(Ye),b(H),b(B),b(Ie,e)}}}const Wt='{"title":"YOLOS","local":"yolos","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"YolosConfig","local":"transformers.YolosConfig","sections":[],"depth":2},{"title":"YolosImageProcessor","local":"transformers.YolosImageProcessor","sections":[],"depth":2},{"title":"YolosFeatureExtractor","local":"transformers.YolosFeatureExtractor","sections":[],"depth":2},{"title":"YolosModel","local":"transformers.YolosModel","sections":[],"depth":2},{"title":"YolosForObjectDetection","local":"transformers.YolosForObjectDetection","sections":[],"depth":2}],"depth":1}';function Dt(M){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends Mt{constructor(n){super(),Yt(this,n,Dt,Ot,xt,{})}}export{Ht as component};
