import{s as Gt,o as Vt,n as Sl}from"../chunks/scheduler.9bc65507.js";import{S as Yt,i as xt,g as M,s as n,r as y,A as Qt,h as i,f as t,c as a,j as Rt,u as m,x as p,k as Xt,y as Et,a as s,v as r,d,t as c,w as J}from"../chunks/index.707bf1b6.js";import{T as Fl}from"../chunks/Tip.c2ecdbf4.js";import{C as T}from"../chunks/CodeBlock.54a9f38d.js";import{H as Be}from"../chunks/Heading.342b1fa6.js";function Ht(U){let o,j="モデルがライブラリ内のモデルと非常に似ている場合、このモデルと同じ構成を再利用できます。";return{c(){o=M("p"),o.textContent=j},l(w){o=i(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-ezhjpv"&&(o.textContent=j)},m(w,f){s(w,o,f)},p:Sl,d(w){w&&t(o)}}}function zt(U){let o,j="このAPIは実験的であり、次のリリースでわずかな変更があるかもしれません。";return{c(){o=M("p"),o.textContent=j},l(w){o=i(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-x2rm6d"&&(o.textContent=j)},m(w,f){s(w,o,f)},p:Sl,d(w){w&&t(o)}}}function Ft(U){let o,j="ライブラリからモデリングファイルをコピーする場合、ファイルの先頭にあるすべての相対インポートを<code>transformers</code>パッケージからインポートに置き換える必要があります。";return{c(){o=M("p"),o.innerHTML=j},l(w){o=i(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-18u9vuk"&&(o.innerHTML=j)},m(w,f){s(w,o,f)},p:Sl,d(w){w&&t(o)}}}function St(U){let o,j,w,f,I,Ne,_,Ll="🤗 Transformersライブラリは、簡単に拡張できるように設計されています。すべてのモデルはリポジトリの特定のサブフォルダに完全にコード化されており、抽象化はありません。したがって、モデリングファイルをコピーして調整することが簡単です。",We,Z,ql="新しいモデルを書いている場合、ゼロから始める方が簡単かもしれません。このチュートリアルでは、カスタムモデルとその設定をどのように書き、Transformers内で使用できるようにし、コードに依存する共同体と共有する方法を説明します。ライブラリに存在しない場合でも、誰でも使用できるようにします。",Re,h,Pl='これを実証するために、<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timmライブラリ</a>のResNetクラスを<a href="/docs/transformers/v4.39.2/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>にラップすることによって、ResNetモデルを使用します。',Xe,g,Ge,A,Dl="モデルに取り組む前に、まずその設定を書きましょう。モデルの設定は、モデルを構築するために必要なすべての情報を含むオブジェクトです。次のセクションで見るように、モデルは初期化するために<code>config</code>しか受け取ることができないため、そのオブジェクトができるだけ完全である必要があります。",Ve,$,Kl="この例では、ResNetクラスのいくつかの引数を取得し、調整したいかもしれないとします。異なる設定は、異なるタイプのResNetを提供します。その後、これらの引数を確認した後、それらの引数を単に格納します。",Ye,k,xe,B,Ol="重要なことを3つ覚えておくべきポイントは次のとおりです：",Qe,v,et="<li><code>PretrainedConfig</code> を継承する必要があります。</li> <li>あなたの <code>PretrainedConfig</code> の <code>__init__</code> は任意の kwargs を受け入れる必要があります。</li> <li>これらの <code>kwargs</code> は親クラスの <code>__init__</code> に渡す必要があります。</li>",Ee,N,lt=`継承は、🤗 Transformers ライブラリのすべての機能を取得できるようにするためです。他の2つの制約は、
<code>PretrainedConfig</code> が設定しているフィールド以外にも多くのフィールドを持っていることから来ています。
<code>from_pretrained</code> メソッドで設定を再ロードする場合、これらのフィールドはあなたの設定に受け入れられ、
その後、親クラスに送信される必要があります。`,He,W,tt=`設定の <code>model_type</code> を定義すること（ここでは <code>model_type=&quot;resnet&quot;</code>）は、
自動クラスにモデルを登録したい場合を除いては必須ではありません（最後のセクションを参照）。`,ze,R,st=`これで、ライブラリの他のモデル設定と同様に、設定を簡単に作成して保存できます。
以下は、resnet50d 設定を作成して保存する方法の例です：`,Fe,X,Se,G,nt="これにより、<code>custom-resnet</code> フォルダ内に <code>config.json</code> という名前のファイルが保存されます。その後、<code>from_pretrained</code> メソッドを使用して構成を再ロードできます。",Le,V,qe,Y,at='また、<a href="/docs/transformers/v4.39.2/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> クラスの他のメソッドを使用することもできます。たとえば、<a href="/docs/transformers/v4.39.2/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a> を使用して、設定を直接 Hub にアップロードできます。',Pe,x,De,Q,Mt='ResNet の設定ができたので、モデルを書き始めることができます。実際には2つのモデルを書きます。1つはバッチの画像から隠れた特徴を抽出するモデル（<a href="/docs/transformers/v4.39.2/ja/model_doc/bert#transformers.BertModel">BertModel</a> のようなもの）で、もう1つは画像分類に適したモデル（<a href="/docs/transformers/v4.39.2/ja/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a> のようなもの）です。',Ke,E,it="前述したように、この例をシンプルに保つために、モデルの緩いラッパーのみを書きます。このクラスを書く前に行う必要がある唯一のことは、ブロックタイプと実際のブロッククラスの間のマップです。その後、すべてを <code>ResNet</code> クラスに渡して設定からモデルを定義します：",Oe,H,el,z,pt="画像を分類するモデルの場合、forwardメソッドを変更するだけです：",ll,F,tl,S,ot=`両方の場合、<code>PreTrainedModel</code>から継承し、<code>config</code>を使用してスーパークラスの初期化を呼び出します（通常の<code>torch.nn.Module</code>を書くときのような感じです）。
<code>config_class</code>を設定する行は必須ではありませんが、（最後のセクションを参照）、モデルを自動クラスに登録したい場合に使用できます。`,sl,u,nl,L,yt=`モデルが返す内容は何でも構いませんが、ラベルが渡されるときに損失を含む辞書を返す（<code>ResnetModelForImageClassification</code>のように行ったもの）と、
モデルを<a href="/docs/transformers/v4.39.2/ja/main_classes/trainer#transformers.Trainer">Trainer</a>クラス内で直接使用できるようになります。独自のトレーニングループまたは他のライブラリを使用する予定である限り、
別の出力形式を使用することも問題ありません。`,al,q,mt="さて、モデルクラスができたので、1つ作成しましょう：",Ml,P,il,D,rt=`再度、<a href="/docs/transformers/v4.39.2/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>のいずれかのメソッド、例えば<a href="/docs/transformers/v4.39.2/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>や
<a href="/docs/transformers/v4.39.2/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a>などを使用できます。次のセクションでは、モデルの重みをコードと一緒に
Hugging Face Hub にプッシュする方法を見てみます。
しかし、まずはモデル内に事前学習済みの重みをロードしましょう。`,pl,K,dt=`独自のユースケースでは、おそらく独自のデータでカスタムモデルをトレーニングすることになるでしょう。
このチュートリアルではスピードアップのために、resnet50dの事前学習済みバージョンを使用します。
私たちのモデルはそれをラップするだけなので、これらの重みを転送するのは簡単です：`,ol,O,yl,ee,ct=`さて、<a href="/docs/transformers/v4.39.2/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>または<a href="/docs/transformers/v4.39.2/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a>を実行したときに、
モデルのコードが保存されるようにする方法を見てみましょう。`,ml,le,rl,C,dl,te,Jt=`まず、モデルが<code>.py</code>ファイルに完全に定義されていることを確認してください。
ファイルは相対インポートを他のファイルに依存できますが、すべてのファイルが同じディレクトリにある限り（まだこの機能ではサブモジュールはサポートしていません）、問題ありません。
この例では、現在の作業ディレクトリ内に名前が「resnet_model」のフォルダを作成し、その中に<code>modeling_resnet.py</code>ファイルと<code>configuration_resnet.py</code>ファイルを定義します。
構成ファイルには<code>ResnetConfig</code>のコードが含まれ、モデリングファイルには<code>ResnetModel</code>と<code>ResnetModelForImageClassification</code>のコードが含まれています。`,cl,se,Jl,ne,wt="<code>__init__.py</code>は空であっても問題ありません。Pythonが<code>resnet_model</code>をモジュールとして検出できるようにするために存在します。",wl,b,Tl,ae,Tt="既存の設定やモデルを再利用（またはサブクラス化）できることに注意してください。",jl,Me,jt="コミュニティとモデルを共有するために、次の手順に従ってください：まず、新しく作成したファイルからResNetモデルと設定をインポートします：",fl,ie,Ul,pe,ft="次に、<code>save_pretrained</code>メソッドを使用してこれらのオブジェクトのコードファイルをコピーし、特定のAutoクラス（特にモデルの場合）に正しく登録するようライブラリに指示する必要があります。次のように実行します：",ul,oe,Cl,ye,Ut=`注意: 設定については自動クラスを指定する必要はありません（設定用の自動クラスは1つしかなく、<a href="/docs/transformers/v4.39.2/ja/model_doc/auto#transformers.AutoConfig">AutoConfig</a>です）が、
モデルについては異なります。カスタムモデルは多くの異なるタスクに適している可能性があるため、
モデルが正確な自動クラスのうちどれに適しているかを指定する必要があります。`,bl,me,ut="次に、前述のように設定とモデルを作成しましょう：",Il,re,_l,de,Ct="モデルをHubに送信するには、ログインしていることを確認してください。ターミナルで次のコマンドを実行します：",Zl,ce,hl,Je,bt="またはノートブックから：",gl,we,Al,Te,It="次に、次のようにして、独自の名前空間にプッシュできます（または、メンバーである組織にプッシュできます）：",$l,je,kl,fe,_t='モデリングの重みとJSON形式の構成に加えて、このフォルダー「custom-resnet50d」内のモデリングおよび構成「.py」ファイルもコピーされ、結果はHubにアップロードされました。結果はこの<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>で確認できます。',Bl,Ue,Zt='詳細については、<a href="model_sharing">Hubへのプッシュ方法</a>を参照してください。',vl,ue,Nl,Ce,ht=`自動クラスと <code>from_pretrained</code> メソッドを使用して、リポジトリ内のカスタムコードファイルと共に任意の構成、モデル、またはトークナイザを使用できます。 Hubにアップロードされるすべてのファイルとコードはマルウェアのスキャンが実施されます（詳細は<a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hubセキュリティ</a>ドキュメンテーションを参照してください）、しかし、依然として悪意のあるコードを実行しないために、モデルコードと作者を確認する必要があります。
<code>trust_remote_code=True</code> を設定してカスタムコードを持つモデルを使用できます：`,Wl,be,Rl,Ie,gt="コミットハッシュを「revision」として渡すことも強く推奨されています。これにより、モデルの作者がコードを悪意のある新しい行で更新しなかったことを確認できます（モデルの作者を完全に信頼している場合を除きます）。",Xl,_e,Gl,Ze,At="モデルリポジトリのコミット履歴をブラウジングする際には、任意のコミットのコミットハッシュを簡単にコピーできるボタンがあります。",Vl,he,Yl,ge,$t=`🤗 Transformersを拡張するライブラリを作成している場合、独自のモデルを含めるために自動クラスを拡張したい場合があります。
これはコードをHubにプッシュすることとは異なり、ユーザーはカスタムモデルを取得するためにあなたのライブラリをインポートする必要があります
（Hubからモデルコードを自動的にダウンロードするのとは対照的です）。`,xl,Ae,kt=`構成に既存のモデルタイプと異なる <code>model_type</code> 属性がある限り、またあなたのモデルクラスが適切な <code>config_class</code> 属性を持っている限り、
次のようにそれらを自動クラスに追加できます：`,Ql,$e,El,ke,Bt=`注意: <code>AutoConfig</code> にカスタム設定を登録する際の最初の引数は、カスタム設定の <code>model_type</code> と一致する必要があります。
また、任意の自動モデルクラスにカスタムモデルを登録する際の最初の引数は、それらのモデルの <code>config_class</code> と一致する必要があります。`,Hl,ve,zl;return I=new Be({props:{title:"Sharing custom models",local:"sharing-custom-models",headingTag:"h1"}}),g=new Be({props:{title:"Writing a custom configuration",local:"writing-a-custom-configuration",headingTag:"h2"}}),k=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),X=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),V=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),x=new Be({props:{title:"Writing a custom model",local:"writing-a-custom-model",headingTag:"h2"}}),H=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),F=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),u=new Fl({props:{$$slots:{default:[Ht]},$$scope:{ctx:U}}}),P=new T({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new T({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),le=new Be({props:{title:"Sending the code to the Hub",local:"sending-the-code-to-the-hub",headingTag:"h2"}}),C=new Fl({props:{warning:!0,$$slots:{default:[zt]},$$scope:{ctx:U}}}),se=new T({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),b=new Fl({props:{warning:!0,$$slots:{default:[Ft]},$$scope:{ctx:U}}}),ie=new T({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),oe=new T({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),re=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),ce=new T({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),we=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),je=new T({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),ue=new Be({props:{title:"Using a model with custom code",local:"using-a-model-with-custom-code",headingTag:"h2"}}),be=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),_e=new T({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),he=new Be({props:{title:"Registering a model with custom code to the auto classes",local:"registering-a-model-with-custom-code-to-the-auto-classes",headingTag:"h2"}}),$e=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){o=M("meta"),j=n(),w=M("p"),f=n(),y(I.$$.fragment),Ne=n(),_=M("p"),_.textContent=Ll,We=n(),Z=M("p"),Z.textContent=ql,Re=n(),h=M("p"),h.innerHTML=Pl,Xe=n(),y(g.$$.fragment),Ge=n(),A=M("p"),A.innerHTML=Dl,Ve=n(),$=M("p"),$.textContent=Kl,Ye=n(),y(k.$$.fragment),xe=n(),B=M("p"),B.textContent=Ol,Qe=n(),v=M("ul"),v.innerHTML=et,Ee=n(),N=M("p"),N.innerHTML=lt,He=n(),W=M("p"),W.innerHTML=tt,ze=n(),R=M("p"),R.textContent=st,Fe=n(),y(X.$$.fragment),Se=n(),G=M("p"),G.innerHTML=nt,Le=n(),y(V.$$.fragment),qe=n(),Y=M("p"),Y.innerHTML=at,Pe=n(),y(x.$$.fragment),De=n(),Q=M("p"),Q.innerHTML=Mt,Ke=n(),E=M("p"),E.innerHTML=it,Oe=n(),y(H.$$.fragment),el=n(),z=M("p"),z.textContent=pt,ll=n(),y(F.$$.fragment),tl=n(),S=M("p"),S.innerHTML=ot,sl=n(),y(u.$$.fragment),nl=n(),L=M("p"),L.innerHTML=yt,al=n(),q=M("p"),q.textContent=mt,Ml=n(),y(P.$$.fragment),il=n(),D=M("p"),D.innerHTML=rt,pl=n(),K=M("p"),K.textContent=dt,ol=n(),y(O.$$.fragment),yl=n(),ee=M("p"),ee.innerHTML=ct,ml=n(),y(le.$$.fragment),rl=n(),y(C.$$.fragment),dl=n(),te=M("p"),te.innerHTML=Jt,cl=n(),y(se.$$.fragment),Jl=n(),ne=M("p"),ne.innerHTML=wt,wl=n(),y(b.$$.fragment),Tl=n(),ae=M("p"),ae.textContent=Tt,jl=n(),Me=M("p"),Me.textContent=jt,fl=n(),y(ie.$$.fragment),Ul=n(),pe=M("p"),pe.innerHTML=ft,ul=n(),y(oe.$$.fragment),Cl=n(),ye=M("p"),ye.innerHTML=Ut,bl=n(),me=M("p"),me.textContent=ut,Il=n(),y(re.$$.fragment),_l=n(),de=M("p"),de.textContent=Ct,Zl=n(),y(ce.$$.fragment),hl=n(),Je=M("p"),Je.textContent=bt,gl=n(),y(we.$$.fragment),Al=n(),Te=M("p"),Te.textContent=It,$l=n(),y(je.$$.fragment),kl=n(),fe=M("p"),fe.innerHTML=_t,Bl=n(),Ue=M("p"),Ue.innerHTML=Zt,vl=n(),y(ue.$$.fragment),Nl=n(),Ce=M("p"),Ce.innerHTML=ht,Wl=n(),y(be.$$.fragment),Rl=n(),Ie=M("p"),Ie.textContent=gt,Xl=n(),y(_e.$$.fragment),Gl=n(),Ze=M("p"),Ze.textContent=At,Vl=n(),y(he.$$.fragment),Yl=n(),ge=M("p"),ge.textContent=$t,xl=n(),Ae=M("p"),Ae.innerHTML=kt,Ql=n(),y($e.$$.fragment),El=n(),ke=M("p"),ke.innerHTML=Bt,Hl=n(),ve=M("p"),this.h()},l(e){const l=Qt("svelte-u9bgzb",document.head);o=i(l,"META",{name:!0,content:!0}),l.forEach(t),j=a(e),w=i(e,"P",{}),Rt(w).forEach(t),f=a(e),m(I.$$.fragment,e),Ne=a(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-gxna3m"&&(_.textContent=Ll),We=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1nn0sjo"&&(Z.textContent=ql),Re=a(e),h=i(e,"P",{"data-svelte-h":!0}),p(h)!=="svelte-2wqfoj"&&(h.innerHTML=Pl),Xe=a(e),m(g.$$.fragment,e),Ge=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-bwvin"&&(A.innerHTML=Dl),Ve=a(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1q4nzi3"&&($.textContent=Kl),Ye=a(e),m(k.$$.fragment,e),xe=a(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1xagbsn"&&(B.textContent=Ol),Qe=a(e),v=i(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-18ieeo"&&(v.innerHTML=et),Ee=a(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1hhagdn"&&(N.innerHTML=lt),He=a(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-u1g66p"&&(W.innerHTML=tt),ze=a(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1cqw2yw"&&(R.textContent=st),Fe=a(e),m(X.$$.fragment,e),Se=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-j8wp82"&&(G.innerHTML=nt),Le=a(e),m(V.$$.fragment,e),qe=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1u6b91j"&&(Y.innerHTML=at),Pe=a(e),m(x.$$.fragment,e),De=a(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1mmpvqo"&&(Q.innerHTML=Mt),Ke=a(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-rnqflg"&&(E.innerHTML=it),Oe=a(e),m(H.$$.fragment,e),el=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-xqb496"&&(z.textContent=pt),ll=a(e),m(F.$$.fragment,e),tl=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1gy8gfa"&&(S.innerHTML=ot),sl=a(e),m(u.$$.fragment,e),nl=a(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-4igelt"&&(L.innerHTML=yt),al=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-c12zx8"&&(q.textContent=mt),Ml=a(e),m(P.$$.fragment,e),il=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-55tpgf"&&(D.innerHTML=rt),pl=a(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1ysoenl"&&(K.textContent=dt),ol=a(e),m(O.$$.fragment,e),yl=a(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1pynphq"&&(ee.innerHTML=ct),ml=a(e),m(le.$$.fragment,e),rl=a(e),m(C.$$.fragment,e),dl=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-12w8qw2"&&(te.innerHTML=Jt),cl=a(e),m(se.$$.fragment,e),Jl=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-161l0tk"&&(ne.innerHTML=wt),wl=a(e),m(b.$$.fragment,e),Tl=a(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1sofoh7"&&(ae.textContent=Tt),jl=a(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-10ja7ra"&&(Me.textContent=jt),fl=a(e),m(ie.$$.fragment,e),Ul=a(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-14w73fp"&&(pe.innerHTML=ft),ul=a(e),m(oe.$$.fragment,e),Cl=a(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1icdx2f"&&(ye.innerHTML=Ut),bl=a(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-x4hehz"&&(me.textContent=ut),Il=a(e),m(re.$$.fragment,e),_l=a(e),de=i(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-4gjqmb"&&(de.textContent=Ct),Zl=a(e),m(ce.$$.fragment,e),hl=a(e),Je=i(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-170hls0"&&(Je.textContent=bt),gl=a(e),m(we.$$.fragment,e),Al=a(e),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-j85q6g"&&(Te.textContent=It),$l=a(e),m(je.$$.fragment,e),kl=a(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1v5wui"&&(fe.innerHTML=_t),Bl=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1r595oo"&&(Ue.innerHTML=Zt),vl=a(e),m(ue.$$.fragment,e),Nl=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1rhh9p5"&&(Ce.innerHTML=ht),Wl=a(e),m(be.$$.fragment,e),Rl=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-6ln3mo"&&(Ie.textContent=gt),Xl=a(e),m(_e.$$.fragment,e),Gl=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1mlo6re"&&(Ze.textContent=At),Vl=a(e),m(he.$$.fragment,e),Yl=a(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1dtzfm7"&&(ge.textContent=$t),xl=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1xrka00"&&(Ae.innerHTML=kt),Ql=a(e),m($e.$$.fragment,e),El=a(e),ke=i(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1eri869"&&(ke.innerHTML=Bt),Hl=a(e),ve=i(e,"P",{}),Rt(ve).forEach(t),this.h()},h(){Xt(o,"name","hf:doc:metadata"),Xt(o,"content",Lt)},m(e,l){Et(document.head,o),s(e,j,l),s(e,w,l),s(e,f,l),r(I,e,l),s(e,Ne,l),s(e,_,l),s(e,We,l),s(e,Z,l),s(e,Re,l),s(e,h,l),s(e,Xe,l),r(g,e,l),s(e,Ge,l),s(e,A,l),s(e,Ve,l),s(e,$,l),s(e,Ye,l),r(k,e,l),s(e,xe,l),s(e,B,l),s(e,Qe,l),s(e,v,l),s(e,Ee,l),s(e,N,l),s(e,He,l),s(e,W,l),s(e,ze,l),s(e,R,l),s(e,Fe,l),r(X,e,l),s(e,Se,l),s(e,G,l),s(e,Le,l),r(V,e,l),s(e,qe,l),s(e,Y,l),s(e,Pe,l),r(x,e,l),s(e,De,l),s(e,Q,l),s(e,Ke,l),s(e,E,l),s(e,Oe,l),r(H,e,l),s(e,el,l),s(e,z,l),s(e,ll,l),r(F,e,l),s(e,tl,l),s(e,S,l),s(e,sl,l),r(u,e,l),s(e,nl,l),s(e,L,l),s(e,al,l),s(e,q,l),s(e,Ml,l),r(P,e,l),s(e,il,l),s(e,D,l),s(e,pl,l),s(e,K,l),s(e,ol,l),r(O,e,l),s(e,yl,l),s(e,ee,l),s(e,ml,l),r(le,e,l),s(e,rl,l),r(C,e,l),s(e,dl,l),s(e,te,l),s(e,cl,l),r(se,e,l),s(e,Jl,l),s(e,ne,l),s(e,wl,l),r(b,e,l),s(e,Tl,l),s(e,ae,l),s(e,jl,l),s(e,Me,l),s(e,fl,l),r(ie,e,l),s(e,Ul,l),s(e,pe,l),s(e,ul,l),r(oe,e,l),s(e,Cl,l),s(e,ye,l),s(e,bl,l),s(e,me,l),s(e,Il,l),r(re,e,l),s(e,_l,l),s(e,de,l),s(e,Zl,l),r(ce,e,l),s(e,hl,l),s(e,Je,l),s(e,gl,l),r(we,e,l),s(e,Al,l),s(e,Te,l),s(e,$l,l),r(je,e,l),s(e,kl,l),s(e,fe,l),s(e,Bl,l),s(e,Ue,l),s(e,vl,l),r(ue,e,l),s(e,Nl,l),s(e,Ce,l),s(e,Wl,l),r(be,e,l),s(e,Rl,l),s(e,Ie,l),s(e,Xl,l),r(_e,e,l),s(e,Gl,l),s(e,Ze,l),s(e,Vl,l),r(he,e,l),s(e,Yl,l),s(e,ge,l),s(e,xl,l),s(e,Ae,l),s(e,Ql,l),r($e,e,l),s(e,El,l),s(e,ke,l),s(e,Hl,l),s(e,ve,l),zl=!0},p(e,[l]){const vt={};l&2&&(vt.$$scope={dirty:l,ctx:e}),u.$set(vt);const Nt={};l&2&&(Nt.$$scope={dirty:l,ctx:e}),C.$set(Nt);const Wt={};l&2&&(Wt.$$scope={dirty:l,ctx:e}),b.$set(Wt)},i(e){zl||(d(I.$$.fragment,e),d(g.$$.fragment,e),d(k.$$.fragment,e),d(X.$$.fragment,e),d(V.$$.fragment,e),d(x.$$.fragment,e),d(H.$$.fragment,e),d(F.$$.fragment,e),d(u.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(C.$$.fragment,e),d(se.$$.fragment,e),d(b.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(we.$$.fragment,e),d(je.$$.fragment,e),d(ue.$$.fragment,e),d(be.$$.fragment,e),d(_e.$$.fragment,e),d(he.$$.fragment,e),d($e.$$.fragment,e),zl=!0)},o(e){c(I.$$.fragment,e),c(g.$$.fragment,e),c(k.$$.fragment,e),c(X.$$.fragment,e),c(V.$$.fragment,e),c(x.$$.fragment,e),c(H.$$.fragment,e),c(F.$$.fragment,e),c(u.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(C.$$.fragment,e),c(se.$$.fragment,e),c(b.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(ce.$$.fragment,e),c(we.$$.fragment,e),c(je.$$.fragment,e),c(ue.$$.fragment,e),c(be.$$.fragment,e),c(_e.$$.fragment,e),c(he.$$.fragment,e),c($e.$$.fragment,e),zl=!1},d(e){e&&(t(j),t(w),t(f),t(Ne),t(_),t(We),t(Z),t(Re),t(h),t(Xe),t(Ge),t(A),t(Ve),t($),t(Ye),t(xe),t(B),t(Qe),t(v),t(Ee),t(N),t(He),t(W),t(ze),t(R),t(Fe),t(Se),t(G),t(Le),t(qe),t(Y),t(Pe),t(De),t(Q),t(Ke),t(E),t(Oe),t(el),t(z),t(ll),t(tl),t(S),t(sl),t(nl),t(L),t(al),t(q),t(Ml),t(il),t(D),t(pl),t(K),t(ol),t(yl),t(ee),t(ml),t(rl),t(dl),t(te),t(cl),t(Jl),t(ne),t(wl),t(Tl),t(ae),t(jl),t(Me),t(fl),t(Ul),t(pe),t(ul),t(Cl),t(ye),t(bl),t(me),t(Il),t(_l),t(de),t(Zl),t(hl),t(Je),t(gl),t(Al),t(Te),t($l),t(kl),t(fe),t(Bl),t(Ue),t(vl),t(Nl),t(Ce),t(Wl),t(Rl),t(Ie),t(Xl),t(Gl),t(Ze),t(Vl),t(Yl),t(ge),t(xl),t(Ae),t(Ql),t(El),t(ke),t(Hl),t(ve)),t(o),J(I,e),J(g,e),J(k,e),J(X,e),J(V,e),J(x,e),J(H,e),J(F,e),J(u,e),J(P,e),J(O,e),J(le,e),J(C,e),J(se,e),J(b,e),J(ie,e),J(oe,e),J(re,e),J(ce,e),J(we,e),J(je,e),J(ue,e),J(be,e),J(_e,e),J(he,e),J($e,e)}}}const Lt='{"title":"Sharing custom models","local":"sharing-custom-models","sections":[{"title":"Writing a custom configuration","local":"writing-a-custom-configuration","sections":[],"depth":2},{"title":"Writing a custom model","local":"writing-a-custom-model","sections":[],"depth":2},{"title":"Sending the code to the Hub","local":"sending-the-code-to-the-hub","sections":[],"depth":2},{"title":"Using a model with custom code","local":"using-a-model-with-custom-code","sections":[],"depth":2},{"title":"Registering a model with custom code to the auto classes","local":"registering-a-model-with-custom-code-to-the-auto-classes","sections":[],"depth":2}],"depth":1}';function qt(U){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ls extends Yt{constructor(o){super(),xt(this,o,qt,St,Gt,{})}}export{ls as component};
