import{s as Gi,f as Bs,o as Ii,n as U}from"../chunks/scheduler.9bc65507.js";import{S as Wi,i as Ci,g as o,s as a,r as m,A as Bi,h as i,f as l,c as s,j as vi,u as d,x as r,k as $,y as xi,a as n,v as h,d as M,t as u,w as y}from"../chunks/index.707bf1b6.js";import{T}from"../chunks/Tip.c2ecdbf4.js";import{C as c}from"../chunks/CodeBlock.54a9f38d.js";import{H as J}from"../chunks/Heading.342b1fa6.js";function Hi(g){let p,f=`If you are not aware of what tools and agents are in the context of transformers, we recommend you read the
<a href="transformers_agents">Transformers Agents</a> page first.`;return{c(){p=o("p"),p.innerHTML=f},l(w){p=i(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-3d92zh"&&(p.innerHTML=f)},m(w,b){n(w,p,b)},p:U,d(w){w&&l(p)}}}function Ri(g){let p,f=`Transformers Agents is an experimental API that is subject to change at any time. Results returned by the agents
can vary as the APIs or underlying models are prone to change.`;return{c(){p=o("p"),p.textContent=f},l(w){p=i(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1edi68n"&&(p.textContent=f)},m(w,b){n(w,p,b)},p:U,d(w){w&&l(p)}}}function ki(g){let p,f=`Check the naming and description of the curated Transformers tools to better understand what name and
description a tool is expected to have. You can see all tools with the <code>Agent.toolbox</code> property.`;return{c(){p=o("p"),p.innerHTML=f},l(w){p=i(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-g5vgrf"&&(p.innerHTML=f)},m(w,b){n(w,p,b)},p:U,d(w){w&&l(p)}}}function Yi(g){let p,f=`Agents are still brittle for many use cases, especially when it comes to
slightly more complex use cases like generating an image of multiple objects.
Both the agent itself and the underlying prompt will be further improved in the coming
months making sure that agents become more robust to a variety of user inputs.`;return{c(){p=o("p"),p.textContent=f},l(w){p=i(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-mlmd2c"&&(p.textContent=f)},m(w,b){n(w,p,b)},p:U,d(w){w&&l(p)}}}function _i(g){let p,f=`Please make sure to have the <code>&lt;&lt;all_tools&gt;&gt;</code> string and the <code>&lt;&lt;prompt&gt;&gt;</code> defined somewhere in the <code>template</code> so that the agent can be aware
of the tools, it has available to it as well as correctly insert the user’s prompt.`;return{c(){p=o("p"),p.innerHTML=f},l(w){p=i(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1rh8x5r"&&(p.innerHTML=f)},m(w,b){n(w,p,b)},p:U,d(w){w&&l(p)}}}function Ni(g){let p,f=`Please make sure to have the <code>&lt;&lt;all_tools&gt;&gt;</code> string defined somewhere in the <code>template</code> so that the agent can be aware
of the tools, it has available to it.`;return{c(){p=o("p"),p.innerHTML=f},l(w){p=i(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-35oor2"&&(p.innerHTML=f)},m(w,b){n(w,p,b)},p:U,d(w){w&&l(p)}}}function Xi(g){let p,f=`Overwriting existing tools can be beneficial if we want to use a custom tool exactly for the same task as an existing tool
because the agent is well-versed in using the specific task. Beware that the custom tool should follow the exact same API
as the overwritten tool in this case, or you should adapt the prompt template to make sure all examples using that
tool are updated.`;return{c(){p=o("p"),p.textContent=f},l(w){p=i(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-bxw4a"&&(p.textContent=f)},m(w,b){n(w,p,b)},p:U,d(w){w&&l(p)}}}function Qi(g){let p,f=`Depending on the LLM, some are quite brittle and require very exact prompts in order to work well. Having a well-defined
name and description of the tool is paramount to having it be leveraged by the agent.`;return{c(){p=o("p"),p.textContent=f},l(w){p=i(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-56y5g1"&&(p.textContent=f)},m(w,b){n(w,p,b)},p:U,d(w){w&&l(p)}}}function Vi(g){let p,f=`Beware when replacing tools with others! This will also adjust the agent’s prompt. This can be good if you have a better
prompt suited for the task, but it can also result in your tool being selected way more than others or for other
tools to be selected instead of the one you have defined.`;return{c(){p=o("p"),p.textContent=f},l(w){p=i(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-5sq1z0"&&(p.textContent=f)},m(w,b){n(w,p,b)},p:U,d(w){w&&l(p)}}}function Fi(g){let p,f=`gradio-tools requires <em>textual</em> inputs and outputs, even when working with different modalities. This implementation
works with image and audio objects. The two are currently incompatible, but will rapidly become compatible as we
work to improve the support.`;return{c(){p=o("p"),p.innerHTML=f},l(w){p=i(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-tx23fw"&&(p.innerHTML=f)},m(w,b){n(w,p,b)},p:U,d(w){w&&l(p)}}}function Ei(g){let p,f,w,b,R,Gl,j,Il,Z,Wl,k,xs=`Creating and using custom tools and prompts is paramount to empowering the agent and having it perform new tasks.
In this guide we’ll take a look at:`,Cl,Y,Hs="<li>How to customize the prompt</li> <li>How to use custom tools</li> <li>How to create custom tools</li>",Bl,_,xl,N,Rs=`As explained in <a href="transformers_agents">Transformers Agents</a> agents can run in <a href="/docs/transformers/v4.36.1/en/main_classes/agent#transformers.Agent.run">run()</a> and <a href="/docs/transformers/v4.36.1/en/main_classes/agent#transformers.Agent.chat">chat()</a> mode.
Both the <code>run</code> and <code>chat</code> modes underlie the same logic. The language model powering the agent is conditioned on a long
prompt and completes the prompt by generating the next tokens until the stop token is reached.
The only difference between the two modes is that during the <code>chat</code> mode the prompt is extended with
previous user inputs and model generations. This allows the agent to have access to past interactions,
seemingly giving the agent some kind of memory.`,Hl,X,Rl,Q,ks=`Let’s take a closer look at how the prompt is structured to understand how it can be best customized.
The prompt is structured broadly into four parts.`,kl,V,Ys='<li><ol><li>Introduction: how the agent should behave, explanation of the concept of tools.</li></ol></li> <li><ol start="2"><li>Description of all the tools. This is defined by a <code>&lt;&lt;all_tools&gt;&gt;</code> token that is dynamically replaced at runtime with the tools defined/chosen by the user.</li></ol></li> <li><ol start="3"><li>A set of examples of tasks and their solution</li></ol></li> <li><ol start="4"><li>Current example, and request for solution.</li></ol></li>',Yl,F,_s="To better understand each part, let’s look at a shortened version of how the <code>run</code> prompt can look like:",_l,E,Nl,S,Ns=`The introduction (the text before <em>“Tools:”</em>) explains precisely how the model shall behave and what it should do.
This part most likely does not need to be customized as the agent shall always behave the same way.`,Xl,z,Xs=`The second part (the bullet points below <em>“Tools”</em>) is dynamically added upon calling <code>run</code> or <code>chat</code>. There are
exactly as many bullet points as there are tools in <code>agent.toolbox</code> and each bullet point consists of the name
and description of the tool:`,Ql,q,Vl,L,Qs="Let’s verify this quickly by loading the document_qa tool and printing out the name and description.",Fl,A,El,P,Vs="which gives:",Sl,K,zl,D,Fs=`We can see that the tool name is short and precise. The description includes two parts, the first explaining
what the tool does and the second states what input arguments and return values are expected.`,ql,O,Es=`A good tool name and tool description are very important for the agent to correctly use it. Note that the only
information the agent has about the tool is its name and description, so one should make sure that both
are precisely written and match the style of the existing tools in the toolbox. In particular make sure the description
mentions all the arguments expected by name in code-style, along with the expected type and a description of what they
are.`,Ll,v,Al,tt,Ss=`The third part includes a set of curated examples that show the agent exactly what code it should produce
for what kind of user request. The large language models empowering the agent are extremely good at
recognizing patterns in a prompt and repeating the pattern with new data. Therefore, it is very important
that the examples are written in a way that maximizes the likelihood of the agent to generating correct,
executable code in practice.`,Pl,et,zs="Let’s have a look at one example:",Kl,lt,Dl,nt,qs=`The pattern the model is prompted to repeat has three parts: The task statement, the agent’s explanation of
what it intends to do, and finally the generated code. Every example that is part of the prompt has this exact
pattern, thus making sure that the agent will reproduce exactly the same pattern when generating new tokens.`,Ol,at,Ls=`The prompt examples are curated by the Transformers team and rigorously evaluated on a set of
<a href="https://github.com/huggingface/transformers/blob/main/src/transformers/tools/evaluate_agent.py" rel="nofollow">problem statements</a>
to ensure that the agent’s prompt is as good as possible to solve real use cases of the agent.`,tn,st,As="The final part of the prompt corresponds to:",en,ot,ln,it,Ps=`is a final and unfinished example that the agent is tasked to complete. The unfinished example
is dynamically created based on the actual user input. For the above example, the user ran:`,nn,rt,an,pt,Ks=`The user input - <em>a.k.a</em> the task: <em>“Draw me a picture of rivers and lakes”</em> is cast into the
prompt template: “Task: &lt;task&gt; \\n\\n I will use the following”. This sentence makes up the final lines of the
prompt the agent is conditioned on, therefore strongly influencing the agent to finish the example
exactly in the same way it was previously done in the examples.`,sn,mt,Ds=`Without going into too much detail, the chat template has the same prompt structure with the
examples having a slightly different style, <em>e.g.</em>:`,on,dt,rn,ht,Os=`Contrary, to the examples of the <code>run</code> prompt, each <code>chat</code> prompt example has one or more exchanges between the
<em>Human</em> and the <em>Assistant</em>. Every exchange is structured similarly to the example of the <code>run</code> prompt.
The user’s input is appended to behind <em>Human:</em> and the agent is prompted to first generate what needs to be done
before generating code. An exchange can be based on previous exchanges, therefore allowing the user to refer
to past exchanges as is done <em>e.g.</em> above by the user’s input of “I tried <strong>this</strong> code” refers to the
previously generated code of the agent.`,pn,Mt,to="Upon running <code>.chat</code>, the user’s input or <em>task</em> is cast into an unfinished example of the form:",mn,ut,dn,yt,eo=`which the agent completes. Contrary to the <code>run</code> command, the <code>chat</code> command then appends the completed example
to the prompt, thus giving the agent more context for the next <code>chat</code> turn.`,hn,wt,lo="Great now that we know how the prompt is structured, let’s see how we can customize it!",Mn,ct,un,ft,no=`While large language models are getting better and better at understanding users’ intentions, it helps
enormously to be as precise as possible to help the agent pick the correct task. What does it mean to be
as precise as possible?`,yn,bt,ao=`The agent sees a list of tool names and their description in its prompt. The more tools are added the
more difficult it becomes for the agent to choose the correct tool and it’s even more difficult to choose
the correct sequences of tools to run. Let’s look at a common failure case, here we will only return
the code to analyze it.`,wn,gt,cn,Jt,so="gives:",fn,Tt,bn,Ut,oo=`which is probably not what we wanted. Instead, it is more likely that we want an image of a tree to be generated.
To steer the agent more towards using a specific tool it can therefore be very helpful to use important keywords that
are present in the tool’s name and description. Let’s have a look.`,gn,$t,Jn,jt,Tn,Zt,io="The name and description make use of the keywords “image”, “prompt”, “create” and “generate”. Using these words will most likely work better here. Let’s refine our prompt a bit.",Un,vt,$n,Gt,ro="gives:",jn,It,Zn,Wt,po=`Much better! That looks more like what we want. In short, when you notice that the agent struggles to
correctly map your task to the correct tools, try looking up the most pertinent keywords of the tool’s name
and description and try refining your task request with it.`,vn,Ct,Gn,Bt,mo=`As we’ve seen before the agent has access to each of the tools’ names and descriptions. The base tools
should have very precise names and descriptions, however, you might find that it could help to change the
the description or name of a tool for your specific use case. This might become especially important
when you’ve added multiple tools that are very similar or if you want to use your agent only for a certain
domain, <em>e.g.</em> image generation and transformations.`,In,xt,ho=`A common problem is that the agent confuses image generation with image transformation/modification when
used a lot for image generation tasks, <em>e.g.</em>`,Wn,Ht,Cn,Rt,Mo="returns",Bn,kt,xn,Yt,uo=`which is probably not exactly what we want here. It seems like the agent has a difficult time
to understand the difference between <code>image_generator</code> and <code>image_transformer</code> and often uses the two together.`,Hn,_t,yo=`We can help the agent here by changing the tool name and description of <code>image_transformer</code>. Let’s instead call it <code>modifier</code>
to disassociate it a bit from “image” and “prompt”:`,Rn,Nt,kn,Xt,wo="Now “modify” is a strong cue to use the new image processor which should help with the above prompt. Let’s run it again.",Yn,Qt,_n,Vt,co="Now we’re getting:",Nn,Ft,Xn,Et,fo="which is definitely closer to what we had in mind! However, we want to have both the house and car in the same image. Steering the task more toward single image generation should help:",Qn,St,Vn,zt,Fn,G,En,qt,Sn,Lt,bo=`To give the user maximum flexibility, the whole prompt template as explained in <a href="#structure-of-the-prompt">above</a>
can be overwritten by the user. In this case make sure that your custom prompt includes an introduction section,
a tool section, an example section, and an unfinished example section. If you want to overwrite the <code>run</code> prompt template,
you can do as follows:`,zn,At,qn,I,Ln,Pt,go="Similarly, one can overwrite the <code>chat</code> prompt template. Note that the <code>chat</code> mode always uses the following format for the exchanges:",An,Kt,Pn,Dt,Jo=`Therefore it is important that the examples of the custom <code>chat</code> prompt template also make use of this format.
You can overwrite the <code>chat</code> template at instantiation as follows.`,Kn,Ot,Dn,W,On,te,To='In both cases, you can pass a repo ID instead of the prompt template if you would like to use a template hosted by someone in the community. The default prompts live in <a href="https://huggingface.co/datasets/huggingface-tools/default-prompts" rel="nofollow">this repo</a> as an example.',ta,ee,Uo="To upload your custom prompt on a repo on the Hub and share it with the community just make sure:",ea,le,$o="<li>to use a dataset repository</li> <li>to put the prompt template for the <code>run</code> command in a file named <code>run_prompt_template.txt</code></li> <li>to put the prompt template for the <code>chat</code> command in a file named <code>chat_prompt_template.txt</code></li>",la,ne,na,ae,jo="In this section, we’ll be leveraging two existing custom tools that are specific to image generation:",aa,se,Zo=`<li>We replace <a href="https://huggingface.co/spaces/huggingface-tools/image-transformation" rel="nofollow">huggingface-tools/image-transformation</a>,
with <a href="https://huggingface.co/spaces/diffusers/controlnet-canny-tool" rel="nofollow">diffusers/controlnet-canny-tool</a>
to allow for more image modifications.</li> <li>We add a new tool for image upscaling to the default toolbox:
<a href="https://huggingface.co/spaces/diffusers/latent-upscaler-tool" rel="nofollow">diffusers/latent-upscaler-tool</a> replace the existing image-transformation tool.</li>`,sa,oe,vo='We’ll start by loading the custom tools with the convenient <a href="/docs/transformers/v4.36.1/en/main_classes/agent#transformers.load_tool">load_tool()</a> function:',oa,ie,ia,re,Go=`Upon adding custom tools to an agent, the tools’ descriptions and names are automatically
included in the agents’ prompts. Thus, it is imperative that custom tools have
a well-written description and name in order for the agent to understand how to use them.
Let’s take a look at the description and name of <code>controlnet_transformer</code>:`,ra,pe,pa,me,Io="gives",ma,de,da,he,Wo=`The name and description are accurate and fit the style of the <a href="./transformers_agents#a-curated-set-of-tools">curated set of tools</a>.
Next, let’s instantiate an agent with <code>controlnet_transformer</code> and <code>upscaler</code>:`,ha,Me,Ma,ue,Co="This command should give you the following info:",ua,ye,ya,we,Bo="The set of curated tools already has an <code>image_transformer</code> tool which is hereby replaced with our custom tool.",wa,C,ca,ce,xo=`The upscaler tool was given the name <code>image_upscaler</code> which is not yet present in the default toolbox and is therefore simply added to the list of tools.
You can always have a look at the toolbox that is currently available to the agent via the <code>agent.toolbox</code> attribute:`,fa,fe,ba,be,ga,ge,Ho="Note how <code>image_upscaler</code> is now part of the agents’ toolbox.",Ja,Je,Ro='Let’s now try out the new tools! We will re-use the image we generated in <a href="./transformers_agents#single-execution-run">Transformers Agents Quickstart</a>.',Ta,Te,Ua,Ue,ko,$a,$e,Yo="Let’s transform the image into a beautiful winter landscape:",ja,je,Za,Ze,va,ve,_o,Ga,Ge,No=`The new image processing tool is based on ControlNet which can make very strong modifications to the image.
By default the image processing tool returns an image of size 512x512 pixels. Let’s see if we can upscale it.`,Ia,Ie,Wa,We,Ca,Ce,Xo,Ba,Be,Qo=`The agent automatically mapped our prompt “Upscale the image” to the just added upscaler tool purely based on the description and name of the upscaler tool
and was able to correctly run it.`,xa,xe,Vo="Next, let’s have a look at how you can create a new custom tool.",Ha,He,Ra,Re,Fo="In this section, we show how to create a new tool that can be added to the agent.",ka,ke,Ya,Ye,Eo=`We’ll first start by creating a tool. We’ll add the not-so-useful yet fun task of fetching the model on the Hugging Face
Hub with the most downloads for a given task.`,_a,_e,So="We can do that with the following code:",Na,Ne,Xa,Xe,zo="For the task <code>text-classification</code>, this returns <code>&#39;facebook/bart-large-mnli&#39;</code>, for <code>translation</code> it returns <code>&#39;t5-base</code>.",Qa,Qe,qo=`How do we convert this to a tool that the agent can leverage? All tools depend on the superclass <code>Tool</code> that holds the
main attributes necessary. We’ll create a class that inherits from it:`,Va,Ve,Fa,Fe,Lo="This class has a few needs:",Ea,Ee,Ao=`<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. To be in tune with other tools which have a
performative name, we’ll name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code>, which will be used to populate the prompt of the agent.</li> <li><code>inputs</code> and <code>outputs</code> attributes. Defining this will help the python interpreter make educated choices about types,
and will allow for a gradio-demo to be spawned when we push our tool to the Hub. They’re both a list of expected
values, which can be <code>text</code>, <code>image</code>, or <code>audio</code>.</li> <li>A <code>__call__</code> method which contains the inference code. This is the code we’ve played with above!</li>`,Sa,Se,Po="Here’s what our class looks like now:",za,ze,qa,qe,Ko=`We now have our tool handy. Save it in a file and import it from your main script. Let’s name this file
<code>model_downloads.py</code>, so the resulting import code looks like this:`,La,Le,Aa,Ae,Do=`In order to let others benefit from it and for simpler initialization, we recommend pushing it to the Hub under your
namespace. To do so, just call <code>push_to_hub</code> on the <code>tool</code> variable:`,Pa,Pe,Ka,Ke,Oo="You now have your code on the Hub! Let’s take a look at the final step, which is to have the agent use it.",Da,De,Oa,Oe,ti="We now have our tool that lives on the Hub which can be instantiated as such (change the user name for your tool):",ts,tl,es,el,ei="In order to use it in the agent, simply pass it in the <code>additional_tools</code> parameter of the agent initialization method:",ls,ll,ns,nl,li="which outputs the following:",as,al,ss,sl,ni="and generates the following audio.",os,ol,ai='<thead><tr><th><strong>Audio</strong></th></tr></thead> <tbody><tr><td><audio controls=""><source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/damo.wav" type="audio/wav"/></audio></td></tr></tbody>',is,B,rs,il,ps,rl,si="Replacing existing tools can be done simply by assigning a new item to the agent’s toolbox. Here’s how one would do so:",ms,pl,ds,x,hs,ml,Ms,dl,oi=`<a href="https://github.com/freddyaboulton/gradio-tools" rel="nofollow">gradio-tools</a> is a powerful library that allows using Hugging
Face Spaces as tools. It supports many existing Spaces as well as custom Spaces to be designed with it.`,us,hl,ii=`We offer support for <code>gradio_tools</code> by using the <code>Tool.from_gradio</code> method. For example, we want to take
advantage of the <code>StableDiffusionPromptGeneratorTool</code> tool offered in the <code>gradio-tools</code> toolkit so as to
improve our prompts and generate better images.`,ys,Ml,ri="We first import the tool from <code>gradio_tools</code> and instantiate it:",ws,ul,cs,yl,pi="We pass that instance to the <code>Tool.from_gradio</code> method:",fs,wl,bs,cl,mi=`Now we can manage it exactly as we would a usual custom tool. We leverage it to improve our prompt
<code>a rabbit wearing a space suit</code>:`,gs,fl,Js,bl,di="The model adequately leverages the tool:",Ts,gl,Us,Jl,hi="Before finally generating the image:",$s,Zl,Mi,js,H,Zs,Tl,vs,Ul,ui=`We love Langchain and think it has a very compelling suite of tools. In order to handle these tools,
Langchain requires <em>textual</em> inputs and outputs, even when working with different modalities.
This is often the serialized version (i.e., saved to disk) of the objects.`,Gs,$l,yi=`This difference means that multi-modality isn’t handled between transformers-agents and langchain.
We aim for this limitation to be resolved in future versions, and welcome any help from avid langchain
users to help us achieve this compatibility.`,Is,jl,wi=`We would love to have better support. If you would like to help, please
<a href="https://github.com/huggingface/transformers/issues/new" rel="nofollow">open an issue</a> and share what you have in mind.`,Ws,vl,Cs;return R=new J({props:{title:"Custom Tools and Prompts",local:"custom-tools-and-prompts",headingTag:"h1"}}),j=new T({props:{$$slots:{default:[Hi]},$$scope:{ctx:g}}}),Z=new T({props:{warning:!0,$$slots:{default:[Ri]},$$scope:{ctx:g}}}),_=new J({props:{title:"Customizing the prompt",local:"customizing-the-prompt",headingTag:"h2"}}),X=new J({props:{title:"Structure of the prompt",local:"structure-of-the-prompt",headingTag:"h3"}}),E=new c({props:{code:"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",highlighted:`I will ask you to perform a task, your job is to come up with a series of simple commands in Python that will perform the task.
[...]
You can print intermediate results if it makes sense to do so.

Tools:
- document_qa: This is a tool that answers a question about a document (pdf). It takes an input named \`document\` which should be the document containing the information, as well as a \`question\` that is the question about the document. It returns a text that contains the answer to the question.
- image_captioner: This is a tool that generates a description of an image. It takes an input named \`image\` which should be the image to the caption and returns a text that contains the description in English.
[...]

Task: &quot;Answer the question in the variable \`question\` about the image stored in the variable \`image\`. The question is in French.&quot;

I will use the following tools: \`translator\` to translate the question into English and then \`image_qa\` to answer the question on the input image.

Answer:
\`\`\`py
translated_question = translator(question=question, src_lang=&quot;French&quot;, tgt_lang=&quot;English&quot;)
print(f&quot;The translated question is {translated_question}.&quot;)
answer = image_qa(image=image, question=translated_question)
print(f&quot;The answer is {answer}&quot;)
\`\`\`

Task: &quot;Identify the oldest person in the \`document\` and create an image showcasing the result as a banner.&quot;

I will use the following tools: \`document_qa\` to find the oldest person in the document, then \`image_generator\` to generate an image according to the answer.

Answer:
\`\`\`py
answer = document_qa(document, question=&quot;What is the oldest person?&quot;)
print(f&quot;The answer is {answer}.&quot;)
image = image_generator(&quot;A banner showing &quot; + answer)
\`\`\`

[...]

Task: &quot;Draw me a picture of rivers and lakes&quot;

I will use the following`,wrap:!1}}),q=new c({props:{code:"LSUyMCUzQ3Rvb2wubmFtZSUzRSUzQSUyMCUzQ3Rvb2wuZGVzY3JpcHRpb24lM0U=",highlighted:"- &lt;tool.name&gt;: &lt;tool.description&gt;",wrap:!1}}),A=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUwQSUwQWRvY3VtZW50X3FhJTIwJTNEJTIwbG9hZF90b29sKCUyMmRvY3VtZW50LXF1ZXN0aW9uLWFuc3dlcmluZyUyMiklMEFwcmludChmJTIyLSUyMCU3QmRvY3VtZW50X3FhLm5hbWUlN0QlM0ElMjAlN0Jkb2N1bWVudF9xYS5kZXNjcmlwdGlvbiU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool

document_qa = load_tool(<span class="hljs-string">&quot;document-question-answering&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;- <span class="hljs-subst">{document_qa.name}</span>: <span class="hljs-subst">{document_qa.description}</span>&quot;</span>)`,wrap:!1}}),K=new c({props:{code:"LSUyMGRvY3VtZW50X3FhJTNBJTIwVGhpcyUyMGlzJTIwYSUyMHRvb2wlMjB0aGF0JTIwYW5zd2VycyUyMGElMjBxdWVzdGlvbiUyMGFib3V0JTIwYSUyMGRvY3VtZW50JTIwKHBkZikuJTIwSXQlMjB0YWtlcyUyMGFuJTIwaW5wdXQlMjBuYW1lZCUyMCU2MGRvY3VtZW50JTYwJTIwd2hpY2glMjBzaG91bGQlMjBiZSUyMHRoZSUyMGRvY3VtZW50JTIwY29udGFpbmluZyUyMHRoZSUyMGluZm9ybWF0aW9uJTJDJTIwYXMlMjB3ZWxsJTIwYXMlMjBhJTIwJTYwcXVlc3Rpb24lNjAlMjB0aGF0JTIwaXMlMjB0aGUlMjBxdWVzdGlvbiUyMGFib3V0JTIwdGhlJTIwZG9jdW1lbnQuJTIwSXQlMjByZXR1cm5zJTIwYSUyMHRleHQlMjB0aGF0JTIwY29udGFpbnMlMjB0aGUlMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHF1ZXN0aW9uLg==",highlighted:"- document_qa: This is a tool that answers a question about a document (pdf). It takes an input named `document` which should be the document containing the information, as well as a `question` that is the question about the document. It returns a text that contains the answer to the question.",wrap:!1}}),v=new T({props:{$$slots:{default:[ki]},$$scope:{ctx:g}}}),lt=new c({props:{code:"VGFzayUzQSUyMCUyMklkZW50aWZ5JTIwdGhlJTIwb2xkZXN0JTIwcGVyc29uJTIwaW4lMjB0aGUlMjAlNjBkb2N1bWVudCU2MCUyMGFuZCUyMGNyZWF0ZSUyMGFuJTIwaW1hZ2UlMjBzaG93Y2FzaW5nJTIwdGhlJTIwcmVzdWx0JTIwYXMlMjBhJTIwYmFubmVyLiUyMiUwQSUwQUklMjB3aWxsJTIwdXNlJTIwdGhlJTIwZm9sbG93aW5nJTIwdG9vbHMlM0ElMjAlNjBkb2N1bWVudF9xYSU2MCUyMHRvJTIwZmluZCUyMHRoZSUyMG9sZGVzdCUyMHBlcnNvbiUyMGluJTIwdGhlJTIwZG9jdW1lbnQlMkMlMjB0aGVuJTIwJTYwaW1hZ2VfZ2VuZXJhdG9yJTYwJTIwdG8lMjBnZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBhY2NvcmRpbmclMjB0byUyMHRoZSUyMGFuc3dlci4lMEElMEFBbnN3ZXIlM0ElMEElNjAlNjAlNjBweSUwQWFuc3dlciUyMCUzRCUyMGRvY3VtZW50X3FhKGRvY3VtZW50JTJDJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBvbGRlc3QlMjBwZXJzb24lM0YlMjIpJTBBcHJpbnQoZiUyMlRoZSUyMGFuc3dlciUyMGlzJTIwJTdCYW5zd2VyJTdELiUyMiklMEFpbWFnZSUyMCUzRCUyMGltYWdlX2dlbmVyYXRvciglMjJBJTIwYmFubmVyJTIwc2hvd2luZyUyMCUyMiUyMCUyQiUyMGFuc3dlciklMEElNjAlNjAlNjAlMEE=",highlighted:"Task: &quot;Identify the oldest person in the `document` and create an image showcasing the result as a banner.&quot;\n\nI will use the following tools: `document_qa` to find the oldest person in the document, then `image_generator` to generate an image according to the answer.\n\nAnswer:\n```py\nanswer = document_qa(document, question=&quot;What is the oldest person?&quot;)\nprint(f&quot;The answer is {answer}.&quot;)\nimage = image_generator(&quot;A banner showing &quot; + answer)\n```\n",wrap:!1}}),ot=new c({props:{code:"VGFzayUzQSUyMCUyMkRyYXclMjBtZSUyMGElMjBwaWN0dXJlJTIwb2YlMjByaXZlcnMlMjBhbmQlMjBsYWtlcyUyMiUwQSUwQUklMjB3aWxsJTIwdXNlJTIwdGhlJTIwZm9sbG93aW5n",highlighted:`Task: &quot;Draw me a picture of rivers and lakes&quot;

I will use the following`,wrap:!1}}),rt=new c({props:{code:"YWdlbnQucnVuKCUyMkRyYXclMjBtZSUyMGElMjBwaWN0dXJlJTIwb2YlMjByaXZlcnMlMjBhbmQlMjBsYWtlcyUyMik=",highlighted:'agent.run(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes&quot;</span>)',wrap:!1}}),dt=new c({props:{code:"JTVCLi4uJTVEJTBBJTBBJTNEJTNEJTNEJTNEJTNEJTBBJTBBSHVtYW4lM0ElMjBBbnN3ZXIlMjB0aGUlMjBxdWVzdGlvbiUyMGluJTIwdGhlJTIwdmFyaWFibGUlMjAlNjBxdWVzdGlvbiU2MCUyMGFib3V0JTIwdGhlJTIwaW1hZ2UlMjBzdG9yZWQlMjBpbiUyMHRoZSUyMHZhcmlhYmxlJTIwJTYwaW1hZ2UlNjAuJTBBJTBBQXNzaXN0YW50JTNBJTIwSSUyMHdpbGwlMjB1c2UlMjB0aGUlMjB0b29sJTIwJTYwaW1hZ2VfcWElNjAlMjB0byUyMGFuc3dlciUyMHRoZSUyMHF1ZXN0aW9uJTIwb24lMjB0aGUlMjBpbnB1dCUyMGltYWdlLiUwQSUwQSU2MCU2MCU2MHB5JTBBYW5zd2VyJTIwJTNEJTIwaW1hZ2VfcWEodGV4dCUzRHF1ZXN0aW9uJTJDJTIwaW1hZ2UlM0RpbWFnZSklMEFwcmludChmJTIyVGhlJTIwYW5zd2VyJTIwaXMlMjAlN0JhbnN3ZXIlN0QlMjIpJTBBJTYwJTYwJTYwJTBBJTBBSHVtYW4lM0ElMjBJJTIwdHJpZWQlMjB0aGlzJTIwY29kZSUyQyUyMGl0JTIwd29ya2VkJTIwYnV0JTIwZGlkbid0JTIwZ2l2ZSUyMG1lJTIwYSUyMGdvb2QlMjByZXN1bHQuJTIwVGhlJTIwcXVlc3Rpb24lMjBpcyUyMGluJTIwRnJlbmNoJTBBJTBBQXNzaXN0YW50JTNBJTIwSW4lMjB0aGlzJTIwY2FzZSUyQyUyMHRoZSUyMHF1ZXN0aW9uJTIwbmVlZHMlMjB0byUyMGJlJTIwdHJhbnNsYXRlZCUyMGZpcnN0LiUyMEklMjB3aWxsJTIwdXNlJTIwdGhlJTIwdG9vbCUyMCU2MHRyYW5zbGF0b3IlNjAlMjB0byUyMGRvJTIwdGhpcy4lMEElMEElNjAlNjAlNjBweSUwQXRyYW5zbGF0ZWRfcXVlc3Rpb24lMjAlM0QlMjB0cmFuc2xhdG9yKHF1ZXN0aW9uJTNEcXVlc3Rpb24lMkMlMjBzcmNfbGFuZyUzRCUyMkZyZW5jaCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyRW5nbGlzaCUyMiklMEFwcmludChmJTIyVGhlJTIwdHJhbnNsYXRlZCUyMHF1ZXN0aW9uJTIwaXMlMjAlN0J0cmFuc2xhdGVkX3F1ZXN0aW9uJTdELiUyMiklMEFhbnN3ZXIlMjAlM0QlMjBpbWFnZV9xYSh0ZXh0JTNEdHJhbnNsYXRlZF9xdWVzdGlvbiUyQyUyMGltYWdlJTNEaW1hZ2UpJTBBcHJpbnQoZiUyMlRoZSUyMGFuc3dlciUyMGlzJTIwJTdCYW5zd2VyJTdEJTIyKSUwQSU2MCU2MCU2MCUwQSUwQSUzRCUzRCUzRCUzRCUzRCUwQSUwQSU1Qi4uLiU1RA==",highlighted:`[...]

=====

Human: Answer the question in the variable \`question\` about the image stored in the variable \`image\`.

Assistant: I will use the tool \`image_qa\` to answer the question on the input image.

\`\`\`py
answer = image_qa(text=question, image=image)
print(f&quot;The answer is {answer}&quot;)
\`\`\`

Human: I tried this code, it worked but didn&#x27;t give me a good result. The question is in French

Assistant: In this case, the question needs to be translated first. I will use the tool \`translator\` to do this.

\`\`\`py
translated_question = translator(question=question, src_lang=&quot;French&quot;, tgt_lang=&quot;English&quot;)
print(f&quot;The translated question is {translated_question}.&quot;)
answer = image_qa(text=translated_question, image=image)
print(f&quot;The answer is {answer}&quot;)
\`\`\`

=====

[...]`,wrap:!1}}),ut=new c({props:{code:"SHVtYW4lM0ElMjAlM0N1c2VyLWlucHV0JTNFJTVDbiU1Q25Bc3Npc3RhbnQlM0E=",highlighted:"Human: &lt;user-input&gt;\\n\\nAssistant:",wrap:!1}}),ct=new J({props:{title:"Writing good user inputs",local:"writing-good-user-inputs",headingTag:"h3"}}),gt=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEElMEFhZ2VudC5ydW4oJTIyU2hvdyUyMG1lJTIwYSUyMHRyZWUlMjIlMkMlMjByZXR1cm5fY29kZSUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)

agent.run(<span class="hljs-string">&quot;Show me a tree&quot;</span>, return_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),Tt=new c({props:{code:"JTNEJTNERXhwbGFuYXRpb24lMjBmcm9tJTIwdGhlJTIwYWdlbnQlM0QlM0QlMEFJJTIwd2lsbCUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRvb2wlM0ElMjAlNjBpbWFnZV9zZWdtZW50ZXIlNjAlMjB0byUyMGNyZWF0ZSUyMGElMjBzZWdtZW50YXRpb24lMjBtYXNrJTIwZm9yJTIwdGhlJTIwaW1hZ2UuJTBBJTBBJTBBJTNEJTNEQ29kZSUyMGdlbmVyYXRlZCUyMGJ5JTIwdGhlJTIwYWdlbnQlM0QlM0QlMEFtYXNrJTIwJTNEJTIwaW1hZ2Vfc2VnbWVudGVyKGltYWdlJTJDJTIwcHJvbXB0JTNEJTIydHJlZSUyMik=",highlighted:`==Explanation from the agent==
I will use the following tool: \`image_segmenter\` to create a segmentation mask for the image.


==Code generated by the agent==
mask = image_segmenter(image, prompt=&quot;tree&quot;)`,wrap:!1}}),$t=new c({props:{code:"YWdlbnQudG9vbGJveCU1QiUyMmltYWdlX2dlbmVyYXRvciUyMiU1RC5kZXNjcmlwdGlvbg==",highlighted:'agent.toolbox[<span class="hljs-string">&quot;image_generator&quot;</span>].description',wrap:!1}}),jt=new c({props:{code:"J1RoaXMlMjBpcyUyMGElMjB0b29sJTIwdGhhdCUyMGNyZWF0ZXMlMjBhbiUyMGltYWdlJTIwYWNjb3JkaW5nJTIwdG8lMjBhJTIwcHJvbXB0JTJDJTIwd2hpY2glMjBpcyUyMGElMjB0ZXh0JTIwZGVzY3JpcHRpb24uJTIwSXQlMjB0YWtlcyUyMGFuJTIwaW5wdXQlMjBuYW1lZCUyMCU2MHByb21wdCU2MCUyMHdoaWNoJTIwY29udGFpbnMlMjB0aGUlMjBpbWFnZSUyMGRlc2NyaXB0aW9uJTIwYW5kJTIwb3V0cHV0cyUyMGFuJTIwaW1hZ2Uu",highlighted:"&#x27;This is a tool that creates an image according to a prompt, which is a text description. It takes an input named `prompt` which contains the image description and outputs an image.",wrap:!1}}),vt=new c({props:{code:"YWdlbnQucnVuKCUyMkNyZWF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGElMjB0cmVlJTIyJTJDJTIwcmV0dXJuX2NvZGUlM0RUcnVlKQ==",highlighted:'agent.run(<span class="hljs-string">&quot;Create an image of a tree&quot;</span>, return_code=<span class="hljs-literal">True</span>)',wrap:!1}}),It=new c({props:{code:"JTNEJTNERXhwbGFuYXRpb24lMjBmcm9tJTIwdGhlJTIwYWdlbnQlM0QlM0QlMEFJJTIwd2lsbCUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRvb2wlMjAlNjBpbWFnZV9nZW5lcmF0b3IlNjAlMjB0byUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwYSUyMHRyZWUuJTBBJTBBJTBBJTNEJTNEQ29kZSUyMGdlbmVyYXRlZCUyMGJ5JTIwdGhlJTIwYWdlbnQlM0QlM0QlMEFpbWFnZSUyMCUzRCUyMGltYWdlX2dlbmVyYXRvcihwcm9tcHQlM0QlMjJ0cmVlJTIyKQ==",highlighted:`==Explanation from the agent==
I will use the following tool \`image_generator\` to generate an image of a tree.


==Code generated by the agent==
image = image_generator(prompt=&quot;tree&quot;)`,wrap:!1}}),Ct=new J({props:{title:"Customizing the tool descriptions",local:"customizing-the-tool-descriptions",headingTag:"h3"}}),Ht=new c({props:{code:"YWdlbnQucnVuKCUyMk1ha2UlMjBhbiUyMGltYWdlJTIwb2YlMjBhJTIwaG91c2UlMjBhbmQlMjBhJTIwY2FyJTIyJTJDJTIwcmV0dXJuX2NvZGUlM0RUcnVlKQ==",highlighted:'agent.run(<span class="hljs-string">&quot;Make an image of a house and a car&quot;</span>, return_code=<span class="hljs-literal">True</span>)',wrap:!1}}),kt=new c({props:{code:"JTNEJTNERXhwbGFuYXRpb24lMjBmcm9tJTIwdGhlJTIwYWdlbnQlM0QlM0QlMjAlMEFJJTIwd2lsbCUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRvb2xzJTIwJTYwaW1hZ2VfZ2VuZXJhdG9yJTYwJTIwdG8lMjBnZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGElMjBob3VzZSUyMGFuZCUyMCU2MGltYWdlX3RyYW5zZm9ybWVyJTYwJTIwdG8lMjB0cmFuc2Zvcm0lMjB0aGUlMjBpbWFnZSUyMG9mJTIwYSUyMGNhciUyMGludG8lMjB0aGUlMjBpbWFnZSUyMG9mJTIwYSUyMGhvdXNlLiUwQSUwQSUzRCUzRENvZGUlMjBnZW5lcmF0ZWQlMjBieSUyMHRoZSUyMGFnZW50JTNEJTNEJTBBaG91c2VfaW1hZ2UlMjAlM0QlMjBpbWFnZV9nZW5lcmF0b3IocHJvbXB0JTNEJTIyQSUyMGhvdXNlJTIyKSUwQWNhcl9pbWFnZSUyMCUzRCUyMGltYWdlX2dlbmVyYXRvcihwcm9tcHQlM0QlMjJBJTIwY2FyJTIyKSUwQWhvdXNlX2Nhcl9pbWFnZSUyMCUzRCUyMGltYWdlX3RyYW5zZm9ybWVyKGltYWdlJTNEY2FyX2ltYWdlJTJDJTIwcHJvbXB0JTNEJTIyQSUyMGhvdXNlJTIyKQ==",highlighted:`==Explanation from the agent== 
I will use the following tools \`image_generator\` to generate an image of a house and \`image_transformer\` to transform the image of a car into the image of a house.

==Code generated by the agent==
house_image = image_generator(prompt=&quot;A house&quot;)
car_image = image_generator(prompt=&quot;A car&quot;)
house_car_image = image_transformer(image=car_image, prompt=&quot;A house&quot;)`,wrap:!1}}),Nt=new c({props:{code:"YWdlbnQudG9vbGJveCU1QiUyMm1vZGlmaWVyJTIyJTVEJTIwJTNEJTIwYWdlbnQudG9vbGJveC5wb3AoJTIyaW1hZ2VfdHJhbnNmb3JtZXIlMjIpJTBBYWdlbnQudG9vbGJveCU1QiUyMm1vZGlmaWVyJTIyJTVELmRlc2NyaXB0aW9uJTIwJTNEJTIwYWdlbnQudG9vbGJveCU1QiUyMm1vZGlmaWVyJTIyJTVELmRlc2NyaXB0aW9uLnJlcGxhY2UoJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtcyUyMGFuJTIwaW1hZ2UlMjBhY2NvcmRpbmclMjB0byUyMGElMjBwcm9tcHQlMjIlMkMlMjAlMjJtb2RpZmllcyUyMGFuJTIwaW1hZ2UlMjIlMEEp",highlighted:`agent.toolbox[<span class="hljs-string">&quot;modifier&quot;</span>] = agent.toolbox.pop(<span class="hljs-string">&quot;image_transformer&quot;</span>)
agent.toolbox[<span class="hljs-string">&quot;modifier&quot;</span>].description = agent.toolbox[<span class="hljs-string">&quot;modifier&quot;</span>].description.replace(
    <span class="hljs-string">&quot;transforms an image according to a prompt&quot;</span>, <span class="hljs-string">&quot;modifies an image&quot;</span>
)`,wrap:!1}}),Qt=new c({props:{code:"YWdlbnQucnVuKCUyMk1ha2UlMjBhbiUyMGltYWdlJTIwb2YlMjBhJTIwaG91c2UlMjBhbmQlMjBhJTIwY2FyJTIyJTJDJTIwcmV0dXJuX2NvZGUlM0RUcnVlKQ==",highlighted:'agent.run(<span class="hljs-string">&quot;Make an image of a house and a car&quot;</span>, return_code=<span class="hljs-literal">True</span>)',wrap:!1}}),Ft=new c({props:{code:"JTNEJTNERXhwbGFuYXRpb24lMjBmcm9tJTIwdGhlJTIwYWdlbnQlM0QlM0QlMEFJJTIwd2lsbCUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRvb2xzJTNBJTIwJTYwaW1hZ2VfZ2VuZXJhdG9yJTYwJTIwdG8lMjBnZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGElMjBob3VzZSUyQyUyMHRoZW4lMjAlNjBpbWFnZV9nZW5lcmF0b3IlNjAlMjB0byUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwYSUyMGNhci4lMEElMEElMEElM0QlM0RDb2RlJTIwZ2VuZXJhdGVkJTIwYnklMjB0aGUlMjBhZ2VudCUzRCUzRCUwQWhvdXNlX2ltYWdlJTIwJTNEJTIwaW1hZ2VfZ2VuZXJhdG9yKHByb21wdCUzRCUyMkElMjBob3VzZSUyMiklMEFjYXJfaW1hZ2UlMjAlM0QlMjBpbWFnZV9nZW5lcmF0b3IocHJvbXB0JTNEJTIyQSUyMGNhciUyMik=",highlighted:`==Explanation from the agent==
I will use the following tools: \`image_generator\` to generate an image of a house, then \`image_generator\` to generate an image of a car.


==Code generated by the agent==
house_image = image_generator(prompt=&quot;A house&quot;)
car_image = image_generator(prompt=&quot;A car&quot;)`,wrap:!1}}),St=new c({props:{code:"YWdlbnQucnVuKCUyMkNyZWF0ZSUyMGltYWdlJTNBJTIwJ0ElMjBob3VzZSUyMGFuZCUyMGNhciclMjIlMkMlMjByZXR1cm5fY29kZSUzRFRydWUp",highlighted:'agent.run(<span class="hljs-string">&quot;Create image: &#x27;A house and car&#x27;&quot;</span>, return_code=<span class="hljs-literal">True</span>)',wrap:!1}}),zt=new c({props:{code:"JTNEJTNERXhwbGFuYXRpb24lMjBmcm9tJTIwdGhlJTIwYWdlbnQlM0QlM0QlMEFJJTIwd2lsbCUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRvb2wlM0ElMjAlNjBpbWFnZV9nZW5lcmF0b3IlNjAlMjB0byUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZS4lMEElMEElMEElM0QlM0RDb2RlJTIwZ2VuZXJhdGVkJTIwYnklMjB0aGUlMjBhZ2VudCUzRCUzRCUwQWltYWdlJTIwJTNEJTIwaW1hZ2VfZ2VuZXJhdG9yKHByb21wdCUzRCUyMkElMjBob3VzZSUyMGFuZCUyMGNhciUyMik=",highlighted:`==Explanation from the agent==
I will use the following tool: \`image_generator\` to generate an image.


==Code generated by the agent==
image = image_generator(prompt=&quot;A house and car&quot;)`,wrap:!1}}),G=new T({props:{warning:!0,$$slots:{default:[Yi]},$$scope:{ctx:g}}}),qt=new J({props:{title:"Customizing the whole prompt",local:"customizing-the-whole-prompt",headingTag:"h3"}}),At=new c({props:{code:"dGVtcGxhdGUlMjAlM0QlMjAlMjIlMjIlMjIlMjAlNUIuLi4lNUQlMjAlMjIlMjIlMjIlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoeW91cl9lbmRwb2ludCUyQyUyMHJ1bl9wcm9tcHRfdGVtcGxhdGUlM0R0ZW1wbGF0ZSk=",highlighted:`template = <span class="hljs-string">&quot;&quot;&quot; [...] &quot;&quot;&quot;</span>

agent = HfAgent(your_endpoint, run_prompt_template=template)`,wrap:!1}}),I=new T({props:{warning:!0,$$slots:{default:[_i]},$$scope:{ctx:g}}}),Kt=new c({props:{code:"SHVtYW4lM0ElMjAlM0MlM0N0YXNrJTNFJTNFJTBBJTBBQXNzaXN0YW50JTNB",highlighted:`Human: &lt;&lt;task&gt;&gt;

Assistant:`,wrap:!1}}),Ot=new c({props:{code:"dGVtcGxhdGUlMjAlM0QlMjAlMjIlMjIlMjIlMjAlNUIuLi4lNUQlMjAlMjIlMjIlMjIlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQodXJsX2VuZHBvaW50JTNEeW91cl9lbmRwb2ludCUyQyUyMGNoYXRfcHJvbXB0X3RlbXBsYXRlJTNEdGVtcGxhdGUp",highlighted:`<span class="hljs-attr">template</span> = <span class="hljs-string">&quot;&quot;&quot; [...] &quot;&quot;&quot;</span>

<span class="hljs-attr">agent</span> = HfAgent(url_endpoint=your_endpoint, chat_prompt_template=template)`,wrap:!1}}),W=new T({props:{warning:!0,$$slots:{default:[Ni]},$$scope:{ctx:g}}}),ne=new J({props:{title:"Using custom tools",local:"using-custom-tools",headingTag:"h2"}}),ie=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUwQSUwQWNvbnRyb2xuZXRfdHJhbnNmb3JtZXIlMjAlM0QlMjBsb2FkX3Rvb2woJTIyZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS10b29sJTIyKSUwQXVwc2NhbGVyJTIwJTNEJTIwbG9hZF90b29sKCUyMmRpZmZ1c2VycyUyRmxhdGVudC11cHNjYWxlci10b29sJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool

controlnet_transformer = load_tool(<span class="hljs-string">&quot;diffusers/controlnet-canny-tool&quot;</span>)
upscaler = load_tool(<span class="hljs-string">&quot;diffusers/latent-upscaler-tool&quot;</span>)`,wrap:!1}}),pe=new c({props:{code:"cHJpbnQoZiUyMkRlc2NyaXB0aW9uJTNBJTIwJyU3QmNvbnRyb2xuZXRfdHJhbnNmb3JtZXIuZGVzY3JpcHRpb24lN0QnJTIyKSUwQXByaW50KGYlMjJOYW1lJTNBJTIwJyU3QmNvbnRyb2xuZXRfdHJhbnNmb3JtZXIubmFtZSU3RCclMjIp",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Description: &#x27;<span class="hljs-subst">{controlnet_transformer.description}</span>&#x27;&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Name: &#x27;<span class="hljs-subst">{controlnet_transformer.name}</span>&#x27;&quot;</span>)`,wrap:!1}}),de=new c({props:{code:"RGVzY3JpcHRpb24lM0ElMjAnVGhpcyUyMGlzJTIwYSUyMHRvb2wlMjB0aGF0JTIwdHJhbnNmb3JtcyUyMGFuJTIwaW1hZ2UlMjB3aXRoJTIwQ29udHJvbE5ldCUyMGFjY29yZGluZyUyMHRvJTIwYSUyMHByb21wdC4lMjAlMEFJdCUyMHRha2VzJTIwdHdvJTIwaW5wdXRzJTNBJTIwJTYwaW1hZ2UlNjAlMkMlMjB3aGljaCUyMHNob3VsZCUyMGJlJTIwdGhlJTIwaW1hZ2UlMjB0byUyMHRyYW5zZm9ybSUyQyUyMGFuZCUyMCU2MHByb21wdCU2MCUyQyUyMHdoaWNoJTIwc2hvdWxkJTIwYmUlMjB0aGUlMjBwcm9tcHQlMjB0byUyMHVzZSUyMHRvJTIwY2hhbmdlJTIwaXQuJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbW9kaWZpZWQlMjBpbWFnZS4nJTBBTmFtZSUzQSUyMCdpbWFnZV90cmFuc2Zvcm1lcic=",highlighted:"Description: &#x27;This is a tool that transforms an image with ControlNet according to a prompt. \nIt takes two inputs: `image`, which should be the image to transform, and `prompt`, which should be the prompt to use to change it. It returns the modified image.&#x27;\nName: &#x27;image_transformer&#x27;",wrap:!1}}),Me=new c({props:{code:"dG9vbHMlMjAlM0QlMjAlNUJjb250cm9sbmV0X3RyYW5zZm9ybWVyJTJDJTIwdXBzY2FsZXIlNUQlMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiUyQyUyMGFkZGl0aW9uYWxfdG9vbHMlM0R0b29scyk=",highlighted:`tools = [controlnet_transformer, upscaler]
agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>, additional_tools=tools)`,wrap:!1}}),ye=new c({props:{code:"aW1hZ2VfdHJhbnNmb3JtZXIlMjBoYXMlMjBiZWVuJTIwcmVwbGFjZWQlMjBieSUyMCUzQ3RyYW5zZm9ybWVyc19tb2R1bGVzLmRpZmZ1c2Vycy5jb250cm9sbmV0LWNhbm55LXRvb2wuYmQ3NjE4MmM3Nzc3ZWJhOTYxMmZjMDNjMCUwQTg3MThhNjBjMGFhNjMxMi5pbWFnZV90cmFuc2Zvcm1hdGlvbi5Db250cm9sTmV0VHJhbnNmb3JtYXRpb25Ub29sJTIwb2JqZWN0JTIwYXQlMjAweDdmMWQzYmZhM2EwMCUzRSUyMGFzJTIwcHJvdmlkZWQlMjBpbiUyMCU2MGFkZGl0aW9uYWxfdG9vbHMlNjA=",highlighted:"image_transformer has been replaced by &lt;transformers_modules.diffusers.controlnet-canny-tool.bd76182c7777eba9612fc03c0\n8718a60c0aa6312.image_transformation.ControlNetTransformationTool object at 0x7f1d3bfa3a00&gt; as provided in `additional_tools`",wrap:!1}}),C=new T({props:{$$slots:{default:[Xi]},$$scope:{ctx:g}}}),fe=new c({props:{code:"cHJpbnQoJTIyJTVDbiUyMi5qb2luKCU1QmYlMjItJTIwJTdCYSU3RCUyMiUyMGZvciUyMGElMjBpbiUyMGFnZW50LnRvb2xib3gua2V5cygpJTVEKSk=",highlighted:'<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;- <span class="hljs-subst">{a}</span>&quot;</span> <span class="hljs-keyword">for</span> a <span class="hljs-keyword">in</span> agent.toolbox.keys()]))',wrap:!1}}),be=new c({props:{code:"LSUyMGRvY3VtZW50X3FhJTBBLSUyMGltYWdlX2NhcHRpb25lciUwQS0lMjBpbWFnZV9xYSUwQS0lMjBpbWFnZV9zZWdtZW50ZXIlMEEtJTIwdHJhbnNjcmliZXIlMEEtJTIwc3VtbWFyaXplciUwQS0lMjB0ZXh0X2NsYXNzaWZpZXIlMEEtJTIwdGV4dF9xYSUwQS0lMjB0ZXh0X3JlYWRlciUwQS0lMjB0cmFuc2xhdG9yJTBBLSUyMGltYWdlX3RyYW5zZm9ybWVyJTBBLSUyMHRleHRfZG93bmxvYWRlciUwQS0lMjBpbWFnZV9nZW5lcmF0b3IlMEEtJTIwdmlkZW9fZ2VuZXJhdG9yJTBBLSUyMGltYWdlX3Vwc2NhbGVy",highlighted:`- document_qa
- image_captioner
- image_qa
- image_segmenter
- transcriber
- summarizer
- text_classifier
- text_qa
- text_reader
- translator
- image_transformer
- text_downloader
- image_generator
- video_generator
- image_upscaler`,wrap:!1}}),Te=new c({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcml2ZXJzX2FuZF9sYWtlcy5wbmclMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rivers_and_lakes.png&quot;</span>
)`,wrap:!1}}),je=new c({props:{code:"aW1hZ2UlMjAlM0QlMjBhZ2VudC5ydW4oJTIyVHJhbnNmb3JtJTIwdGhlJTIwaW1hZ2UlM0ElMjAnQSUyMGZyb3plbiUyMGxha2UlMjBhbmQlMjBzbm93eSUyMGZvcmVzdCclMjIlMkMlMjBpbWFnZSUzRGltYWdlKQ==",highlighted:'image = agent.run(<span class="hljs-string">&quot;Transform the image: &#x27;A frozen lake and snowy forest&#x27;&quot;</span>, image=image)',wrap:!1}}),Ze=new c({props:{code:"JTNEJTNERXhwbGFuYXRpb24lMjBmcm9tJTIwdGhlJTIwYWdlbnQlM0QlM0QlMEFJJTIwd2lsbCUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRvb2wlM0ElMjAlNjBpbWFnZV90cmFuc2Zvcm1lciU2MCUyMHRvJTIwdHJhbnNmb3JtJTIwdGhlJTIwaW1hZ2UuJTBBJTBBJTBBJTNEJTNEQ29kZSUyMGdlbmVyYXRlZCUyMGJ5JTIwdGhlJTIwYWdlbnQlM0QlM0QlMEFpbWFnZSUyMCUzRCUyMGltYWdlX3RyYW5zZm9ybWVyKGltYWdlJTJDJTIwcHJvbXB0JTNEJTIyQSUyMGZyb3plbiUyMGxha2UlMjBhbmQlMjBzbm93eSUyMGZvcmVzdCUyMik=",highlighted:`==Explanation from the agent==
I will use the following tool: \`image_transformer\` to transform the image.


==Code generated by the agent==
image = image_transformer(image, prompt=&quot;A frozen lake and snowy forest&quot;)`,wrap:!1}}),Ie=new c({props:{code:"aW1hZ2UlMjAlM0QlMjBhZ2VudC5ydW4oJTIyVXBzY2FsZSUyMHRoZSUyMGltYWdlJTIyJTJDJTIwaW1hZ2Up",highlighted:'image = agent.run(<span class="hljs-string">&quot;Upscale the image&quot;</span>, image)',wrap:!1}}),We=new c({props:{code:"JTNEJTNERXhwbGFuYXRpb24lMjBmcm9tJTIwdGhlJTIwYWdlbnQlM0QlM0QlMEFJJTIwd2lsbCUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRvb2wlM0ElMjAlNjBpbWFnZV91cHNjYWxlciU2MCUyMHRvJTIwdXBzY2FsZSUyMHRoZSUyMGltYWdlLiUwQSUwQSUwQSUzRCUzRENvZGUlMjBnZW5lcmF0ZWQlMjBieSUyMHRoZSUyMGFnZW50JTNEJTNEJTBBdXBzY2FsZWRfaW1hZ2UlMjAlM0QlMjBpbWFnZV91cHNjYWxlcihpbWFnZSk=",highlighted:`==Explanation from the agent==
I will use the following tool: \`image_upscaler\` to upscale the image.


==Code generated by the agent==
upscaled_image = image_upscaler(image)`,wrap:!1}}),He=new J({props:{title:"Adding new tools",local:"adding-new-tools",headingTag:"h3"}}),ke=new J({props:{title:"Creating a new tool",local:"creating-a-new-tool",headingTag:"h4"}}),Ne=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbW9kZWxzJTBBJTBBdGFzayUyMCUzRCUyMCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMEElMEFtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBcHJpbnQobW9kZWwuaWQp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

task = <span class="hljs-string">&quot;text-classification&quot;</span>

model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
<span class="hljs-built_in">print</span>(model.<span class="hljs-built_in">id</span>)`,wrap:!1}}),Ve=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMEElMEElMEFjbGFzcyUyMEhGTW9kZWxEb3dubG9hZHNUb29sKFRvb2wpJTNBJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool


<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),ze=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMEFjbGFzcyUyMEhGTW9kZWxEb3dubG9hZHNUb29sKFRvb2wpJTNBJTBBJTIwJTIwJTIwJTIwbmFtZSUyMCUzRCUyMCUyMm1vZGVsX2Rvd25sb2FkX2NvdW50ZXIlMjIlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySXQlMjB0YWtlcyUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyQyUyMGFuZCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJldHVybnMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBjaGVja3BvaW50LiUyMiUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMCU1QiUyMnRleHQlMjIlNUQlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models


<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = (
        <span class="hljs-string">&quot;This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub. &quot;</span>
        <span class="hljs-string">&quot;It takes the name of the category (such as text-classification, depth-estimation, etc), and &quot;</span>
        <span class="hljs-string">&quot;returns the name of the checkpoint.&quot;</span>
    )

    inputs = [<span class="hljs-string">&quot;text&quot;</span>]
    outputs = [<span class="hljs-string">&quot;text&quot;</span>]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>`,wrap:!1}}),Le=new c({props:{code:"ZnJvbSUyMG1vZGVsX2Rvd25sb2FkcyUyMGltcG9ydCUyMEhGTW9kZWxEb3dubG9hZHNUb29sJTBBJTBBdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> model_downloads <span class="hljs-keyword">import</span> HFModelDownloadsTool

tool = HFModelDownloadsTool()`,wrap:!1}}),Pe=new c({props:{code:"dG9vbC5wdXNoX3RvX2h1YiglMjJoZi1tb2RlbC1kb3dubG9hZHMlMjIp",highlighted:'tool.push_to_hub(<span class="hljs-string">&quot;hf-model-downloads&quot;</span>)',wrap:!1}}),De=new J({props:{title:"Having the agent use the tool",local:"having-the-agent-use-the-tool",headingTag:"h4"}}),tl=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUwQSUwQXRvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybHlzYW5kcmUlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool

tool = load_tool(<span class="hljs-string">&quot;lysandre/hf-model-downloads&quot;</span>)`,wrap:!1}}),ll=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiUyQyUyMGFkZGl0aW9uYWxfdG9vbHMlM0QlNUJ0b29sJTVEKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJDYW4lMjB5b3UlMjByZWFkJTIwb3V0JTIwbG91ZCUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>, additional_tools=[tool])

agent.run(
    <span class="hljs-string">&quot;Can you read out loud the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub?&quot;</span>
)`,wrap:!1}}),al=new c({props:{code:"JTNEJTNEQ29kZSUyMGdlbmVyYXRlZCUyMGJ5JTIwdGhlJTIwYWdlbnQlM0QlM0QlMEFtb2RlbCUyMCUzRCUyMG1vZGVsX2Rvd25sb2FkX2NvdW50ZXIodGFzayUzRCUyMnRleHQtdG8tdmlkZW8lMjIpJTBBcHJpbnQoZiUyMlRoZSUyMG1vZGVsJTIwd2l0aCUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpcyUyMCU3Qm1vZGVsJTdELiUyMiklMEFhdWRpb19tb2RlbCUyMCUzRCUyMHRleHRfcmVhZGVyKG1vZGVsKSUwQSUwQSUwQSUzRCUzRFJlc3VsdCUzRCUzRCUwQVRoZSUyMG1vZGVsJTIwd2l0aCUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpcyUyMGRhbW8tdmlsYWIlMkZ0ZXh0LXRvLXZpZGVvLW1zLTEuN2Iu",highlighted:`==Code generated by the agent==
model = model_download_counter(task=&quot;text-to-video&quot;)
print(f&quot;The model with the most downloads is {model}.&quot;)
audio_model = text_reader(model)


==Result==
The model with the most downloads is damo-vilab/text-to-video-ms-1.7b.`,wrap:!1}}),B=new T({props:{$$slots:{default:[Qi]},$$scope:{ctx:g}}}),il=new J({props:{title:"Replacing existing tools",local:"replacing-existing-tools",headingTag:"h3"}}),pl=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMkMlMjBsb2FkX3Rvb2wlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEFhZ2VudC50b29sYm94JTVCJTIyaW1hZ2UtdHJhbnNmb3JtYXRpb24lMjIlNUQlMjAlM0QlMjBsb2FkX3Rvb2woJTIyZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS10b29sJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent, load_tool

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)
agent.toolbox[<span class="hljs-string">&quot;image-transformation&quot;</span>] = load_tool(<span class="hljs-string">&quot;diffusers/controlnet-canny-tool&quot;</span>)`,wrap:!1}}),x=new T({props:{$$slots:{default:[Vi]},$$scope:{ctx:g}}}),ml=new J({props:{title:"Leveraging gradio-tools",local:"leveraging-gradio-tools",headingTag:"h2"}}),ul=new c({props:{code:"ZnJvbSUyMGdyYWRpb190b29scyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblByb21wdEdlbmVyYXRvclRvb2wlMEElMEFncmFkaW9fdG9vbCUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblByb21wdEdlbmVyYXRvclRvb2woKQ==",highlighted:`<span class="hljs-keyword">from</span> gradio_tools <span class="hljs-keyword">import</span> StableDiffusionPromptGeneratorTool

gradio_tool = StableDiffusionPromptGeneratorTool()`,wrap:!1}}),wl=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMEElMEF0b29sJTIwJTNEJTIwVG9vbC5mcm9tX2dyYWRpbyhncmFkaW9fdG9vbCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool

tool = Tool.from_gradio(gradio_tool)`,wrap:!1}}),fl=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiUyQyUyMGFkZGl0aW9uYWxfdG9vbHMlM0QlNUJ0b29sJTVEKSUwQSUwQWFnZW50LnJ1biglMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMHRoZSUyMCU2MHByb21wdCU2MCUyMGFmdGVyJTIwaW1wcm92aW5nJTIwaXQuJTIyJTJDJTIwcHJvbXB0JTNEJTIyQSUyMHJhYmJpdCUyMHdlYXJpbmclMjBhJTIwc3BhY2UlMjBzdWl0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>, additional_tools=[tool])

agent.run(<span class="hljs-string">&quot;Generate an image of the \`prompt\` after improving it.&quot;</span>, prompt=<span class="hljs-string">&quot;A rabbit wearing a space suit&quot;</span>)`,wrap:!1}}),gl=new c({props:{code:"JTNEJTNERXhwbGFuYXRpb24lMjBmcm9tJTIwdGhlJTIwYWdlbnQlM0QlM0QlMEFJJTIwd2lsbCUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMCUyMHRvb2xzJTNBJTIwJTYwU3RhYmxlRGlmZnVzaW9uUHJvbXB0R2VuZXJhdG9yJTYwJTIwdG8lMjBpbXByb3ZlJTIwdGhlJTIwcHJvbXB0JTJDJTIwdGhlbiUyMCU2MGltYWdlX2dlbmVyYXRvciU2MCUyMHRvJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBpbXByb3ZlZCUyMHByb21wdC4lMEElMEElMEElM0QlM0RDb2RlJTIwZ2VuZXJhdGVkJTIwYnklMjB0aGUlMjBhZ2VudCUzRCUzRCUwQWltcHJvdmVkX3Byb21wdCUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblByb21wdEdlbmVyYXRvcihwcm9tcHQpJTBBcHJpbnQoZiUyMlRoZSUyMGltcHJvdmVkJTIwcHJvbXB0JTIwaXMlMjAlN0JpbXByb3ZlZF9wcm9tcHQlN0QuJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2VfZ2VuZXJhdG9yKGltcHJvdmVkX3Byb21wdCk=",highlighted:`==Explanation from the agent==
I will use the following  tools: \`StableDiffusionPromptGenerator\` to improve the prompt, then \`image_generator\` to generate an image according to the improved prompt.


==Code generated by the agent==
improved_prompt = StableDiffusionPromptGenerator(prompt)
print(f&quot;The improved prompt is {improved_prompt}.&quot;)
image = image_generator(improved_prompt)`,wrap:!1}}),H=new T({props:{warning:!0,$$slots:{default:[Fi]},$$scope:{ctx:g}}}),Tl=new J({props:{title:"Future compatibility with Langchain",local:"future-compatibility-with-langchain",headingTag:"h2"}}),{c(){p=o("meta"),f=a(),w=o("p"),b=a(),m(R.$$.fragment),Gl=a(),m(j.$$.fragment),Il=a(),m(Z.$$.fragment),Wl=a(),k=o("p"),k.textContent=xs,Cl=a(),Y=o("ul"),Y.innerHTML=Hs,Bl=a(),m(_.$$.fragment),xl=a(),N=o("p"),N.innerHTML=Rs,Hl=a(),m(X.$$.fragment),Rl=a(),Q=o("p"),Q.textContent=ks,kl=a(),V=o("ul"),V.innerHTML=Ys,Yl=a(),F=o("p"),F.innerHTML=_s,_l=a(),m(E.$$.fragment),Nl=a(),S=o("p"),S.innerHTML=Ns,Xl=a(),z=o("p"),z.innerHTML=Xs,Ql=a(),m(q.$$.fragment),Vl=a(),L=o("p"),L.textContent=Qs,Fl=a(),m(A.$$.fragment),El=a(),P=o("p"),P.textContent=Vs,Sl=a(),m(K.$$.fragment),zl=a(),D=o("p"),D.textContent=Fs,ql=a(),O=o("p"),O.textContent=Es,Ll=a(),m(v.$$.fragment),Al=a(),tt=o("p"),tt.textContent=Ss,Pl=a(),et=o("p"),et.textContent=zs,Kl=a(),m(lt.$$.fragment),Dl=a(),nt=o("p"),nt.textContent=qs,Ol=a(),at=o("p"),at.innerHTML=Ls,tn=a(),st=o("p"),st.textContent=As,en=a(),m(ot.$$.fragment),ln=a(),it=o("p"),it.textContent=Ps,nn=a(),m(rt.$$.fragment),an=a(),pt=o("p"),pt.innerHTML=Ks,sn=a(),mt=o("p"),mt.innerHTML=Ds,on=a(),m(dt.$$.fragment),rn=a(),ht=o("p"),ht.innerHTML=Os,pn=a(),Mt=o("p"),Mt.innerHTML=to,mn=a(),m(ut.$$.fragment),dn=a(),yt=o("p"),yt.innerHTML=eo,hn=a(),wt=o("p"),wt.textContent=lo,Mn=a(),m(ct.$$.fragment),un=a(),ft=o("p"),ft.textContent=no,yn=a(),bt=o("p"),bt.textContent=ao,wn=a(),m(gt.$$.fragment),cn=a(),Jt=o("p"),Jt.textContent=so,fn=a(),m(Tt.$$.fragment),bn=a(),Ut=o("p"),Ut.textContent=oo,gn=a(),m($t.$$.fragment),Jn=a(),m(jt.$$.fragment),Tn=a(),Zt=o("p"),Zt.textContent=io,Un=a(),m(vt.$$.fragment),$n=a(),Gt=o("p"),Gt.textContent=ro,jn=a(),m(It.$$.fragment),Zn=a(),Wt=o("p"),Wt.textContent=po,vn=a(),m(Ct.$$.fragment),Gn=a(),Bt=o("p"),Bt.innerHTML=mo,In=a(),xt=o("p"),xt.innerHTML=ho,Wn=a(),m(Ht.$$.fragment),Cn=a(),Rt=o("p"),Rt.textContent=Mo,Bn=a(),m(kt.$$.fragment),xn=a(),Yt=o("p"),Yt.innerHTML=uo,Hn=a(),_t=o("p"),_t.innerHTML=yo,Rn=a(),m(Nt.$$.fragment),kn=a(),Xt=o("p"),Xt.textContent=wo,Yn=a(),m(Qt.$$.fragment),_n=a(),Vt=o("p"),Vt.textContent=co,Nn=a(),m(Ft.$$.fragment),Xn=a(),Et=o("p"),Et.textContent=fo,Qn=a(),m(St.$$.fragment),Vn=a(),m(zt.$$.fragment),Fn=a(),m(G.$$.fragment),En=a(),m(qt.$$.fragment),Sn=a(),Lt=o("p"),Lt.innerHTML=bo,zn=a(),m(At.$$.fragment),qn=a(),m(I.$$.fragment),Ln=a(),Pt=o("p"),Pt.innerHTML=go,An=a(),m(Kt.$$.fragment),Pn=a(),Dt=o("p"),Dt.innerHTML=Jo,Kn=a(),m(Ot.$$.fragment),Dn=a(),m(W.$$.fragment),On=a(),te=o("p"),te.innerHTML=To,ta=a(),ee=o("p"),ee.textContent=Uo,ea=a(),le=o("ul"),le.innerHTML=$o,la=a(),m(ne.$$.fragment),na=a(),ae=o("p"),ae.textContent=jo,aa=a(),se=o("ul"),se.innerHTML=Zo,sa=a(),oe=o("p"),oe.innerHTML=vo,oa=a(),m(ie.$$.fragment),ia=a(),re=o("p"),re.innerHTML=Go,ra=a(),m(pe.$$.fragment),pa=a(),me=o("p"),me.textContent=Io,ma=a(),m(de.$$.fragment),da=a(),he=o("p"),he.innerHTML=Wo,ha=a(),m(Me.$$.fragment),Ma=a(),ue=o("p"),ue.textContent=Co,ua=a(),m(ye.$$.fragment),ya=a(),we=o("p"),we.innerHTML=Bo,wa=a(),m(C.$$.fragment),ca=a(),ce=o("p"),ce.innerHTML=xo,fa=a(),m(fe.$$.fragment),ba=a(),m(be.$$.fragment),ga=a(),ge=o("p"),ge.innerHTML=Ho,Ja=a(),Je=o("p"),Je.innerHTML=Ro,Ta=a(),m(Te.$$.fragment),Ua=a(),Ue=o("img"),$a=a(),$e=o("p"),$e.textContent=Yo,ja=a(),m(je.$$.fragment),Za=a(),m(Ze.$$.fragment),va=a(),ve=o("img"),Ga=a(),Ge=o("p"),Ge.textContent=No,Ia=a(),m(Ie.$$.fragment),Wa=a(),m(We.$$.fragment),Ca=a(),Ce=o("img"),Ba=a(),Be=o("p"),Be.textContent=Qo,xa=a(),xe=o("p"),xe.textContent=Vo,Ha=a(),m(He.$$.fragment),Ra=a(),Re=o("p"),Re.textContent=Fo,ka=a(),m(ke.$$.fragment),Ya=a(),Ye=o("p"),Ye.textContent=Eo,_a=a(),_e=o("p"),_e.textContent=So,Na=a(),m(Ne.$$.fragment),Xa=a(),Xe=o("p"),Xe.innerHTML=zo,Qa=a(),Qe=o("p"),Qe.innerHTML=qo,Va=a(),m(Ve.$$.fragment),Fa=a(),Fe=o("p"),Fe.textContent=Lo,Ea=a(),Ee=o("ul"),Ee.innerHTML=Ao,Sa=a(),Se=o("p"),Se.textContent=Po,za=a(),m(ze.$$.fragment),qa=a(),qe=o("p"),qe.innerHTML=Ko,La=a(),m(Le.$$.fragment),Aa=a(),Ae=o("p"),Ae.innerHTML=Do,Pa=a(),m(Pe.$$.fragment),Ka=a(),Ke=o("p"),Ke.textContent=Oo,Da=a(),m(De.$$.fragment),Oa=a(),Oe=o("p"),Oe.textContent=ti,ts=a(),m(tl.$$.fragment),es=a(),el=o("p"),el.innerHTML=ei,ls=a(),m(ll.$$.fragment),ns=a(),nl=o("p"),nl.textContent=li,as=a(),m(al.$$.fragment),ss=a(),sl=o("p"),sl.textContent=ni,os=a(),ol=o("table"),ol.innerHTML=ai,is=a(),m(B.$$.fragment),rs=a(),m(il.$$.fragment),ps=a(),rl=o("p"),rl.textContent=si,ms=a(),m(pl.$$.fragment),ds=a(),m(x.$$.fragment),hs=a(),m(ml.$$.fragment),Ms=a(),dl=o("p"),dl.innerHTML=oi,us=a(),hl=o("p"),hl.innerHTML=ii,ys=a(),Ml=o("p"),Ml.innerHTML=ri,ws=a(),m(ul.$$.fragment),cs=a(),yl=o("p"),yl.innerHTML=pi,fs=a(),m(wl.$$.fragment),bs=a(),cl=o("p"),cl.innerHTML=mi,gs=a(),m(fl.$$.fragment),Js=a(),bl=o("p"),bl.textContent=di,Ts=a(),m(gl.$$.fragment),Us=a(),Jl=o("p"),Jl.textContent=hi,$s=a(),Zl=o("img"),js=a(),m(H.$$.fragment),Zs=a(),m(Tl.$$.fragment),vs=a(),Ul=o("p"),Ul.innerHTML=ui,Gs=a(),$l=o("p"),$l.textContent=yi,Is=a(),jl=o("p"),jl.innerHTML=wi,Ws=a(),vl=o("p"),this.h()},l(t){const e=Bi("svelte-u9bgzb",document.head);p=i(e,"META",{name:!0,content:!0}),e.forEach(l),f=s(t),w=i(t,"P",{}),vi(w).forEach(l),b=s(t),d(R.$$.fragment,t),Gl=s(t),d(j.$$.fragment,t),Il=s(t),d(Z.$$.fragment,t),Wl=s(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1qhojy7"&&(k.textContent=xs),Cl=s(t),Y=i(t,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-1e2yd7f"&&(Y.innerHTML=Hs),Bl=s(t),d(_.$$.fragment,t),xl=s(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-9r5tzk"&&(N.innerHTML=Rs),Hl=s(t),d(X.$$.fragment,t),Rl=s(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-rii2rm"&&(Q.textContent=ks),kl=s(t),V=i(t,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-1s06fus"&&(V.innerHTML=Ys),Yl=s(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1fvzc7b"&&(F.innerHTML=_s),_l=s(t),d(E.$$.fragment,t),Nl=s(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1wu3o2u"&&(S.innerHTML=Ns),Xl=s(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-w2lme7"&&(z.innerHTML=Xs),Ql=s(t),d(q.$$.fragment,t),Vl=s(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1aanlkj"&&(L.textContent=Qs),Fl=s(t),d(A.$$.fragment,t),El=s(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1h8i6v1"&&(P.textContent=Vs),Sl=s(t),d(K.$$.fragment,t),zl=s(t),D=i(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-gnycp5"&&(D.textContent=Fs),ql=s(t),O=i(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1l25cn1"&&(O.textContent=Es),Ll=s(t),d(v.$$.fragment,t),Al=s(t),tt=i(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-pd6qvf"&&(tt.textContent=Ss),Pl=s(t),et=i(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-19wuaq2"&&(et.textContent=zs),Kl=s(t),d(lt.$$.fragment,t),Dl=s(t),nt=i(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-137b6p5"&&(nt.textContent=qs),Ol=s(t),at=i(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-15tb3lk"&&(at.innerHTML=Ls),tn=s(t),st=i(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1wj8rg1"&&(st.textContent=As),en=s(t),d(ot.$$.fragment,t),ln=s(t),it=i(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1utp6i7"&&(it.textContent=Ps),nn=s(t),d(rt.$$.fragment,t),an=s(t),pt=i(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1ff76an"&&(pt.innerHTML=Ks),sn=s(t),mt=i(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-b48t6"&&(mt.innerHTML=Ds),on=s(t),d(dt.$$.fragment,t),rn=s(t),ht=i(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1dwkh6"&&(ht.innerHTML=Os),pn=s(t),Mt=i(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-reah3c"&&(Mt.innerHTML=to),mn=s(t),d(ut.$$.fragment,t),dn=s(t),yt=i(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-e0mebg"&&(yt.innerHTML=eo),hn=s(t),wt=i(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-3wcpkg"&&(wt.textContent=lo),Mn=s(t),d(ct.$$.fragment,t),un=s(t),ft=i(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1dybovb"&&(ft.textContent=no),yn=s(t),bt=i(t,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-z3kpmt"&&(bt.textContent=ao),wn=s(t),d(gt.$$.fragment,t),cn=s(t),Jt=i(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1b883kw"&&(Jt.textContent=so),fn=s(t),d(Tt.$$.fragment,t),bn=s(t),Ut=i(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-1bazuf7"&&(Ut.textContent=oo),gn=s(t),d($t.$$.fragment,t),Jn=s(t),d(jt.$$.fragment,t),Tn=s(t),Zt=i(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-b01ut5"&&(Zt.textContent=io),Un=s(t),d(vt.$$.fragment,t),$n=s(t),Gt=i(t,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-1b883kw"&&(Gt.textContent=ro),jn=s(t),d(It.$$.fragment,t),Zn=s(t),Wt=i(t,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-4ez52l"&&(Wt.textContent=po),vn=s(t),d(Ct.$$.fragment,t),Gn=s(t),Bt=i(t,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-8ifc9z"&&(Bt.innerHTML=mo),In=s(t),xt=i(t,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1oywuvq"&&(xt.innerHTML=ho),Wn=s(t),d(Ht.$$.fragment,t),Cn=s(t),Rt=i(t,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-vjj76b"&&(Rt.textContent=Mo),Bn=s(t),d(kt.$$.fragment,t),xn=s(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-bjnte8"&&(Yt.innerHTML=uo),Hn=s(t),_t=i(t,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-btfpkp"&&(_t.innerHTML=yo),Rn=s(t),d(Nt.$$.fragment,t),kn=s(t),Xt=i(t,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-11yz1xk"&&(Xt.textContent=wo),Yn=s(t),d(Qt.$$.fragment,t),_n=s(t),Vt=i(t,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-10q5qmo"&&(Vt.textContent=co),Nn=s(t),d(Ft.$$.fragment,t),Xn=s(t),Et=i(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-1xs09vd"&&(Et.textContent=fo),Qn=s(t),d(St.$$.fragment,t),Vn=s(t),d(zt.$$.fragment,t),Fn=s(t),d(G.$$.fragment,t),En=s(t),d(qt.$$.fragment,t),Sn=s(t),Lt=i(t,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-knehpf"&&(Lt.innerHTML=bo),zn=s(t),d(At.$$.fragment,t),qn=s(t),d(I.$$.fragment,t),Ln=s(t),Pt=i(t,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-15jgvnr"&&(Pt.innerHTML=go),An=s(t),d(Kt.$$.fragment,t),Pn=s(t),Dt=i(t,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-kxexhm"&&(Dt.innerHTML=Jo),Kn=s(t),d(Ot.$$.fragment,t),Dn=s(t),d(W.$$.fragment,t),On=s(t),te=i(t,"P",{"data-svelte-h":!0}),r(te)!=="svelte-6yllxv"&&(te.innerHTML=To),ta=s(t),ee=i(t,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1pz2hir"&&(ee.textContent=Uo),ea=s(t),le=i(t,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-10jdtg2"&&(le.innerHTML=$o),la=s(t),d(ne.$$.fragment,t),na=s(t),ae=i(t,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1c5tlua"&&(ae.textContent=jo),aa=s(t),se=i(t,"UL",{"data-svelte-h":!0}),r(se)!=="svelte-3ndjxi"&&(se.innerHTML=Zo),sa=s(t),oe=i(t,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-hewexx"&&(oe.innerHTML=vo),oa=s(t),d(ie.$$.fragment,t),ia=s(t),re=i(t,"P",{"data-svelte-h":!0}),r(re)!=="svelte-p0dnmg"&&(re.innerHTML=Go),ra=s(t),d(pe.$$.fragment,t),pa=s(t),me=i(t,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1i27rne"&&(me.textContent=Io),ma=s(t),d(de.$$.fragment,t),da=s(t),he=i(t,"P",{"data-svelte-h":!0}),r(he)!=="svelte-6618iq"&&(he.innerHTML=Wo),ha=s(t),d(Me.$$.fragment,t),Ma=s(t),ue=i(t,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-gbcquo"&&(ue.textContent=Co),ua=s(t),d(ye.$$.fragment,t),ya=s(t),we=i(t,"P",{"data-svelte-h":!0}),r(we)!=="svelte-gos6jv"&&(we.innerHTML=Bo),wa=s(t),d(C.$$.fragment,t),ca=s(t),ce=i(t,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-l1h4uq"&&(ce.innerHTML=xo),fa=s(t),d(fe.$$.fragment,t),ba=s(t),d(be.$$.fragment,t),ga=s(t),ge=i(t,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1342gb7"&&(ge.innerHTML=Ho),Ja=s(t),Je=i(t,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1ku572g"&&(Je.innerHTML=Ro),Ta=s(t),d(Te.$$.fragment,t),Ua=s(t),Ue=i(t,"IMG",{src:!0,width:!0}),$a=s(t),$e=i(t,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1ghiycr"&&($e.textContent=Yo),ja=s(t),d(je.$$.fragment,t),Za=s(t),d(Ze.$$.fragment,t),va=s(t),ve=i(t,"IMG",{src:!0,width:!0}),Ga=s(t),Ge=i(t,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-18tz5k9"&&(Ge.textContent=No),Ia=s(t),d(Ie.$$.fragment,t),Wa=s(t),d(We.$$.fragment,t),Ca=s(t),Ce=i(t,"IMG",{src:!0,width:!0}),Ba=s(t),Be=i(t,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1tkj4wc"&&(Be.textContent=Qo),xa=s(t),xe=i(t,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-dd7bew"&&(xe.textContent=Vo),Ha=s(t),d(He.$$.fragment,t),Ra=s(t),Re=i(t,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1otb4ya"&&(Re.textContent=Fo),ka=s(t),d(ke.$$.fragment,t),Ya=s(t),Ye=i(t,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-sol241"&&(Ye.textContent=Eo),_a=s(t),_e=i(t,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1t55phh"&&(_e.textContent=So),Na=s(t),d(Ne.$$.fragment,t),Xa=s(t),Xe=i(t,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-ktokvd"&&(Xe.innerHTML=zo),Qa=s(t),Qe=i(t,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1gypcaq"&&(Qe.innerHTML=qo),Va=s(t),d(Ve.$$.fragment,t),Fa=s(t),Fe=i(t,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-113o02m"&&(Fe.textContent=Lo),Ea=s(t),Ee=i(t,"UL",{"data-svelte-h":!0}),r(Ee)!=="svelte-1yllho7"&&(Ee.innerHTML=Ao),Sa=s(t),Se=i(t,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1d2t961"&&(Se.textContent=Po),za=s(t),d(ze.$$.fragment,t),qa=s(t),qe=i(t,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1pgmicw"&&(qe.innerHTML=Ko),La=s(t),d(Le.$$.fragment,t),Aa=s(t),Ae=i(t,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-sz7owm"&&(Ae.innerHTML=Do),Pa=s(t),d(Pe.$$.fragment,t),Ka=s(t),Ke=i(t,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1eaq3qx"&&(Ke.textContent=Oo),Da=s(t),d(De.$$.fragment,t),Oa=s(t),Oe=i(t,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1g0yncs"&&(Oe.textContent=ti),ts=s(t),d(tl.$$.fragment,t),es=s(t),el=i(t,"P",{"data-svelte-h":!0}),r(el)!=="svelte-xkoq76"&&(el.innerHTML=ei),ls=s(t),d(ll.$$.fragment,t),ns=s(t),nl=i(t,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-pjyxhx"&&(nl.textContent=li),as=s(t),d(al.$$.fragment,t),ss=s(t),sl=i(t,"P",{"data-svelte-h":!0}),r(sl)!=="svelte-406qkd"&&(sl.textContent=ni),os=s(t),ol=i(t,"TABLE",{"data-svelte-h":!0}),r(ol)!=="svelte-1tqzmpy"&&(ol.innerHTML=ai),is=s(t),d(B.$$.fragment,t),rs=s(t),d(il.$$.fragment,t),ps=s(t),rl=i(t,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-efrp9a"&&(rl.textContent=si),ms=s(t),d(pl.$$.fragment,t),ds=s(t),d(x.$$.fragment,t),hs=s(t),d(ml.$$.fragment,t),Ms=s(t),dl=i(t,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-k79zul"&&(dl.innerHTML=oi),us=s(t),hl=i(t,"P",{"data-svelte-h":!0}),r(hl)!=="svelte-1g50g90"&&(hl.innerHTML=ii),ys=s(t),Ml=i(t,"P",{"data-svelte-h":!0}),r(Ml)!=="svelte-13sspw7"&&(Ml.innerHTML=ri),ws=s(t),d(ul.$$.fragment,t),cs=s(t),yl=i(t,"P",{"data-svelte-h":!0}),r(yl)!=="svelte-fosp2q"&&(yl.innerHTML=pi),fs=s(t),d(wl.$$.fragment,t),bs=s(t),cl=i(t,"P",{"data-svelte-h":!0}),r(cl)!=="svelte-upt5q1"&&(cl.innerHTML=mi),gs=s(t),d(fl.$$.fragment,t),Js=s(t),bl=i(t,"P",{"data-svelte-h":!0}),r(bl)!=="svelte-1ss743w"&&(bl.textContent=di),Ts=s(t),d(gl.$$.fragment,t),Us=s(t),Jl=i(t,"P",{"data-svelte-h":!0}),r(Jl)!=="svelte-euaib0"&&(Jl.textContent=hi),$s=s(t),Zl=i(t,"IMG",{src:!0}),js=s(t),d(H.$$.fragment,t),Zs=s(t),d(Tl.$$.fragment,t),vs=s(t),Ul=i(t,"P",{"data-svelte-h":!0}),r(Ul)!=="svelte-ez7x57"&&(Ul.innerHTML=ui),Gs=s(t),$l=i(t,"P",{"data-svelte-h":!0}),r($l)!=="svelte-1aa89ge"&&($l.textContent=yi),Is=s(t),jl=i(t,"P",{"data-svelte-h":!0}),r(jl)!=="svelte-pg0m6x"&&(jl.innerHTML=wi),Ws=s(t),vl=i(t,"P",{}),vi(vl).forEach(l),this.h()},h(){$(p,"name","hf:doc:metadata"),$(p,"content",Si),Bs(Ue.src,ko="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rivers_and_lakes.png")||$(Ue,"src",ko),$(Ue,"width","200"),Bs(ve.src,_o="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rivers_and_lakes_winter.png")||$(ve,"src",_o),$(ve,"width","200"),Bs(Ce.src,Xo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rivers_and_lakes_winter_upscale.png")||$(Ce,"src",Xo),$(Ce,"width","400"),Bs(Zl.src,Mi="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png")||$(Zl,"src",Mi)},m(t,e){xi(document.head,p),n(t,f,e),n(t,w,e),n(t,b,e),h(R,t,e),n(t,Gl,e),h(j,t,e),n(t,Il,e),h(Z,t,e),n(t,Wl,e),n(t,k,e),n(t,Cl,e),n(t,Y,e),n(t,Bl,e),h(_,t,e),n(t,xl,e),n(t,N,e),n(t,Hl,e),h(X,t,e),n(t,Rl,e),n(t,Q,e),n(t,kl,e),n(t,V,e),n(t,Yl,e),n(t,F,e),n(t,_l,e),h(E,t,e),n(t,Nl,e),n(t,S,e),n(t,Xl,e),n(t,z,e),n(t,Ql,e),h(q,t,e),n(t,Vl,e),n(t,L,e),n(t,Fl,e),h(A,t,e),n(t,El,e),n(t,P,e),n(t,Sl,e),h(K,t,e),n(t,zl,e),n(t,D,e),n(t,ql,e),n(t,O,e),n(t,Ll,e),h(v,t,e),n(t,Al,e),n(t,tt,e),n(t,Pl,e),n(t,et,e),n(t,Kl,e),h(lt,t,e),n(t,Dl,e),n(t,nt,e),n(t,Ol,e),n(t,at,e),n(t,tn,e),n(t,st,e),n(t,en,e),h(ot,t,e),n(t,ln,e),n(t,it,e),n(t,nn,e),h(rt,t,e),n(t,an,e),n(t,pt,e),n(t,sn,e),n(t,mt,e),n(t,on,e),h(dt,t,e),n(t,rn,e),n(t,ht,e),n(t,pn,e),n(t,Mt,e),n(t,mn,e),h(ut,t,e),n(t,dn,e),n(t,yt,e),n(t,hn,e),n(t,wt,e),n(t,Mn,e),h(ct,t,e),n(t,un,e),n(t,ft,e),n(t,yn,e),n(t,bt,e),n(t,wn,e),h(gt,t,e),n(t,cn,e),n(t,Jt,e),n(t,fn,e),h(Tt,t,e),n(t,bn,e),n(t,Ut,e),n(t,gn,e),h($t,t,e),n(t,Jn,e),h(jt,t,e),n(t,Tn,e),n(t,Zt,e),n(t,Un,e),h(vt,t,e),n(t,$n,e),n(t,Gt,e),n(t,jn,e),h(It,t,e),n(t,Zn,e),n(t,Wt,e),n(t,vn,e),h(Ct,t,e),n(t,Gn,e),n(t,Bt,e),n(t,In,e),n(t,xt,e),n(t,Wn,e),h(Ht,t,e),n(t,Cn,e),n(t,Rt,e),n(t,Bn,e),h(kt,t,e),n(t,xn,e),n(t,Yt,e),n(t,Hn,e),n(t,_t,e),n(t,Rn,e),h(Nt,t,e),n(t,kn,e),n(t,Xt,e),n(t,Yn,e),h(Qt,t,e),n(t,_n,e),n(t,Vt,e),n(t,Nn,e),h(Ft,t,e),n(t,Xn,e),n(t,Et,e),n(t,Qn,e),h(St,t,e),n(t,Vn,e),h(zt,t,e),n(t,Fn,e),h(G,t,e),n(t,En,e),h(qt,t,e),n(t,Sn,e),n(t,Lt,e),n(t,zn,e),h(At,t,e),n(t,qn,e),h(I,t,e),n(t,Ln,e),n(t,Pt,e),n(t,An,e),h(Kt,t,e),n(t,Pn,e),n(t,Dt,e),n(t,Kn,e),h(Ot,t,e),n(t,Dn,e),h(W,t,e),n(t,On,e),n(t,te,e),n(t,ta,e),n(t,ee,e),n(t,ea,e),n(t,le,e),n(t,la,e),h(ne,t,e),n(t,na,e),n(t,ae,e),n(t,aa,e),n(t,se,e),n(t,sa,e),n(t,oe,e),n(t,oa,e),h(ie,t,e),n(t,ia,e),n(t,re,e),n(t,ra,e),h(pe,t,e),n(t,pa,e),n(t,me,e),n(t,ma,e),h(de,t,e),n(t,da,e),n(t,he,e),n(t,ha,e),h(Me,t,e),n(t,Ma,e),n(t,ue,e),n(t,ua,e),h(ye,t,e),n(t,ya,e),n(t,we,e),n(t,wa,e),h(C,t,e),n(t,ca,e),n(t,ce,e),n(t,fa,e),h(fe,t,e),n(t,ba,e),h(be,t,e),n(t,ga,e),n(t,ge,e),n(t,Ja,e),n(t,Je,e),n(t,Ta,e),h(Te,t,e),n(t,Ua,e),n(t,Ue,e),n(t,$a,e),n(t,$e,e),n(t,ja,e),h(je,t,e),n(t,Za,e),h(Ze,t,e),n(t,va,e),n(t,ve,e),n(t,Ga,e),n(t,Ge,e),n(t,Ia,e),h(Ie,t,e),n(t,Wa,e),h(We,t,e),n(t,Ca,e),n(t,Ce,e),n(t,Ba,e),n(t,Be,e),n(t,xa,e),n(t,xe,e),n(t,Ha,e),h(He,t,e),n(t,Ra,e),n(t,Re,e),n(t,ka,e),h(ke,t,e),n(t,Ya,e),n(t,Ye,e),n(t,_a,e),n(t,_e,e),n(t,Na,e),h(Ne,t,e),n(t,Xa,e),n(t,Xe,e),n(t,Qa,e),n(t,Qe,e),n(t,Va,e),h(Ve,t,e),n(t,Fa,e),n(t,Fe,e),n(t,Ea,e),n(t,Ee,e),n(t,Sa,e),n(t,Se,e),n(t,za,e),h(ze,t,e),n(t,qa,e),n(t,qe,e),n(t,La,e),h(Le,t,e),n(t,Aa,e),n(t,Ae,e),n(t,Pa,e),h(Pe,t,e),n(t,Ka,e),n(t,Ke,e),n(t,Da,e),h(De,t,e),n(t,Oa,e),n(t,Oe,e),n(t,ts,e),h(tl,t,e),n(t,es,e),n(t,el,e),n(t,ls,e),h(ll,t,e),n(t,ns,e),n(t,nl,e),n(t,as,e),h(al,t,e),n(t,ss,e),n(t,sl,e),n(t,os,e),n(t,ol,e),n(t,is,e),h(B,t,e),n(t,rs,e),h(il,t,e),n(t,ps,e),n(t,rl,e),n(t,ms,e),h(pl,t,e),n(t,ds,e),h(x,t,e),n(t,hs,e),h(ml,t,e),n(t,Ms,e),n(t,dl,e),n(t,us,e),n(t,hl,e),n(t,ys,e),n(t,Ml,e),n(t,ws,e),h(ul,t,e),n(t,cs,e),n(t,yl,e),n(t,fs,e),h(wl,t,e),n(t,bs,e),n(t,cl,e),n(t,gs,e),h(fl,t,e),n(t,Js,e),n(t,bl,e),n(t,Ts,e),h(gl,t,e),n(t,Us,e),n(t,Jl,e),n(t,$s,e),n(t,Zl,e),n(t,js,e),h(H,t,e),n(t,Zs,e),h(Tl,t,e),n(t,vs,e),n(t,Ul,e),n(t,Gs,e),n(t,$l,e),n(t,Is,e),n(t,jl,e),n(t,Ws,e),n(t,vl,e),Cs=!0},p(t,[e]){const ci={};e&2&&(ci.$$scope={dirty:e,ctx:t}),j.$set(ci);const fi={};e&2&&(fi.$$scope={dirty:e,ctx:t}),Z.$set(fi);const bi={};e&2&&(bi.$$scope={dirty:e,ctx:t}),v.$set(bi);const gi={};e&2&&(gi.$$scope={dirty:e,ctx:t}),G.$set(gi);const Ji={};e&2&&(Ji.$$scope={dirty:e,ctx:t}),I.$set(Ji);const Ti={};e&2&&(Ti.$$scope={dirty:e,ctx:t}),W.$set(Ti);const Ui={};e&2&&(Ui.$$scope={dirty:e,ctx:t}),C.$set(Ui);const $i={};e&2&&($i.$$scope={dirty:e,ctx:t}),B.$set($i);const ji={};e&2&&(ji.$$scope={dirty:e,ctx:t}),x.$set(ji);const Zi={};e&2&&(Zi.$$scope={dirty:e,ctx:t}),H.$set(Zi)},i(t){Cs||(M(R.$$.fragment,t),M(j.$$.fragment,t),M(Z.$$.fragment,t),M(_.$$.fragment,t),M(X.$$.fragment,t),M(E.$$.fragment,t),M(q.$$.fragment,t),M(A.$$.fragment,t),M(K.$$.fragment,t),M(v.$$.fragment,t),M(lt.$$.fragment,t),M(ot.$$.fragment,t),M(rt.$$.fragment,t),M(dt.$$.fragment,t),M(ut.$$.fragment,t),M(ct.$$.fragment,t),M(gt.$$.fragment,t),M(Tt.$$.fragment,t),M($t.$$.fragment,t),M(jt.$$.fragment,t),M(vt.$$.fragment,t),M(It.$$.fragment,t),M(Ct.$$.fragment,t),M(Ht.$$.fragment,t),M(kt.$$.fragment,t),M(Nt.$$.fragment,t),M(Qt.$$.fragment,t),M(Ft.$$.fragment,t),M(St.$$.fragment,t),M(zt.$$.fragment,t),M(G.$$.fragment,t),M(qt.$$.fragment,t),M(At.$$.fragment,t),M(I.$$.fragment,t),M(Kt.$$.fragment,t),M(Ot.$$.fragment,t),M(W.$$.fragment,t),M(ne.$$.fragment,t),M(ie.$$.fragment,t),M(pe.$$.fragment,t),M(de.$$.fragment,t),M(Me.$$.fragment,t),M(ye.$$.fragment,t),M(C.$$.fragment,t),M(fe.$$.fragment,t),M(be.$$.fragment,t),M(Te.$$.fragment,t),M(je.$$.fragment,t),M(Ze.$$.fragment,t),M(Ie.$$.fragment,t),M(We.$$.fragment,t),M(He.$$.fragment,t),M(ke.$$.fragment,t),M(Ne.$$.fragment,t),M(Ve.$$.fragment,t),M(ze.$$.fragment,t),M(Le.$$.fragment,t),M(Pe.$$.fragment,t),M(De.$$.fragment,t),M(tl.$$.fragment,t),M(ll.$$.fragment,t),M(al.$$.fragment,t),M(B.$$.fragment,t),M(il.$$.fragment,t),M(pl.$$.fragment,t),M(x.$$.fragment,t),M(ml.$$.fragment,t),M(ul.$$.fragment,t),M(wl.$$.fragment,t),M(fl.$$.fragment,t),M(gl.$$.fragment,t),M(H.$$.fragment,t),M(Tl.$$.fragment,t),Cs=!0)},o(t){u(R.$$.fragment,t),u(j.$$.fragment,t),u(Z.$$.fragment,t),u(_.$$.fragment,t),u(X.$$.fragment,t),u(E.$$.fragment,t),u(q.$$.fragment,t),u(A.$$.fragment,t),u(K.$$.fragment,t),u(v.$$.fragment,t),u(lt.$$.fragment,t),u(ot.$$.fragment,t),u(rt.$$.fragment,t),u(dt.$$.fragment,t),u(ut.$$.fragment,t),u(ct.$$.fragment,t),u(gt.$$.fragment,t),u(Tt.$$.fragment,t),u($t.$$.fragment,t),u(jt.$$.fragment,t),u(vt.$$.fragment,t),u(It.$$.fragment,t),u(Ct.$$.fragment,t),u(Ht.$$.fragment,t),u(kt.$$.fragment,t),u(Nt.$$.fragment,t),u(Qt.$$.fragment,t),u(Ft.$$.fragment,t),u(St.$$.fragment,t),u(zt.$$.fragment,t),u(G.$$.fragment,t),u(qt.$$.fragment,t),u(At.$$.fragment,t),u(I.$$.fragment,t),u(Kt.$$.fragment,t),u(Ot.$$.fragment,t),u(W.$$.fragment,t),u(ne.$$.fragment,t),u(ie.$$.fragment,t),u(pe.$$.fragment,t),u(de.$$.fragment,t),u(Me.$$.fragment,t),u(ye.$$.fragment,t),u(C.$$.fragment,t),u(fe.$$.fragment,t),u(be.$$.fragment,t),u(Te.$$.fragment,t),u(je.$$.fragment,t),u(Ze.$$.fragment,t),u(Ie.$$.fragment,t),u(We.$$.fragment,t),u(He.$$.fragment,t),u(ke.$$.fragment,t),u(Ne.$$.fragment,t),u(Ve.$$.fragment,t),u(ze.$$.fragment,t),u(Le.$$.fragment,t),u(Pe.$$.fragment,t),u(De.$$.fragment,t),u(tl.$$.fragment,t),u(ll.$$.fragment,t),u(al.$$.fragment,t),u(B.$$.fragment,t),u(il.$$.fragment,t),u(pl.$$.fragment,t),u(x.$$.fragment,t),u(ml.$$.fragment,t),u(ul.$$.fragment,t),u(wl.$$.fragment,t),u(fl.$$.fragment,t),u(gl.$$.fragment,t),u(H.$$.fragment,t),u(Tl.$$.fragment,t),Cs=!1},d(t){t&&(l(f),l(w),l(b),l(Gl),l(Il),l(Wl),l(k),l(Cl),l(Y),l(Bl),l(xl),l(N),l(Hl),l(Rl),l(Q),l(kl),l(V),l(Yl),l(F),l(_l),l(Nl),l(S),l(Xl),l(z),l(Ql),l(Vl),l(L),l(Fl),l(El),l(P),l(Sl),l(zl),l(D),l(ql),l(O),l(Ll),l(Al),l(tt),l(Pl),l(et),l(Kl),l(Dl),l(nt),l(Ol),l(at),l(tn),l(st),l(en),l(ln),l(it),l(nn),l(an),l(pt),l(sn),l(mt),l(on),l(rn),l(ht),l(pn),l(Mt),l(mn),l(dn),l(yt),l(hn),l(wt),l(Mn),l(un),l(ft),l(yn),l(bt),l(wn),l(cn),l(Jt),l(fn),l(bn),l(Ut),l(gn),l(Jn),l(Tn),l(Zt),l(Un),l($n),l(Gt),l(jn),l(Zn),l(Wt),l(vn),l(Gn),l(Bt),l(In),l(xt),l(Wn),l(Cn),l(Rt),l(Bn),l(xn),l(Yt),l(Hn),l(_t),l(Rn),l(kn),l(Xt),l(Yn),l(_n),l(Vt),l(Nn),l(Xn),l(Et),l(Qn),l(Vn),l(Fn),l(En),l(Sn),l(Lt),l(zn),l(qn),l(Ln),l(Pt),l(An),l(Pn),l(Dt),l(Kn),l(Dn),l(On),l(te),l(ta),l(ee),l(ea),l(le),l(la),l(na),l(ae),l(aa),l(se),l(sa),l(oe),l(oa),l(ia),l(re),l(ra),l(pa),l(me),l(ma),l(da),l(he),l(ha),l(Ma),l(ue),l(ua),l(ya),l(we),l(wa),l(ca),l(ce),l(fa),l(ba),l(ga),l(ge),l(Ja),l(Je),l(Ta),l(Ua),l(Ue),l($a),l($e),l(ja),l(Za),l(va),l(ve),l(Ga),l(Ge),l(Ia),l(Wa),l(Ca),l(Ce),l(Ba),l(Be),l(xa),l(xe),l(Ha),l(Ra),l(Re),l(ka),l(Ya),l(Ye),l(_a),l(_e),l(Na),l(Xa),l(Xe),l(Qa),l(Qe),l(Va),l(Fa),l(Fe),l(Ea),l(Ee),l(Sa),l(Se),l(za),l(qa),l(qe),l(La),l(Aa),l(Ae),l(Pa),l(Ka),l(Ke),l(Da),l(Oa),l(Oe),l(ts),l(es),l(el),l(ls),l(ns),l(nl),l(as),l(ss),l(sl),l(os),l(ol),l(is),l(rs),l(ps),l(rl),l(ms),l(ds),l(hs),l(Ms),l(dl),l(us),l(hl),l(ys),l(Ml),l(ws),l(cs),l(yl),l(fs),l(bs),l(cl),l(gs),l(Js),l(bl),l(Ts),l(Us),l(Jl),l($s),l(Zl),l(js),l(Zs),l(vs),l(Ul),l(Gs),l($l),l(Is),l(jl),l(Ws),l(vl)),l(p),y(R,t),y(j,t),y(Z,t),y(_,t),y(X,t),y(E,t),y(q,t),y(A,t),y(K,t),y(v,t),y(lt,t),y(ot,t),y(rt,t),y(dt,t),y(ut,t),y(ct,t),y(gt,t),y(Tt,t),y($t,t),y(jt,t),y(vt,t),y(It,t),y(Ct,t),y(Ht,t),y(kt,t),y(Nt,t),y(Qt,t),y(Ft,t),y(St,t),y(zt,t),y(G,t),y(qt,t),y(At,t),y(I,t),y(Kt,t),y(Ot,t),y(W,t),y(ne,t),y(ie,t),y(pe,t),y(de,t),y(Me,t),y(ye,t),y(C,t),y(fe,t),y(be,t),y(Te,t),y(je,t),y(Ze,t),y(Ie,t),y(We,t),y(He,t),y(ke,t),y(Ne,t),y(Ve,t),y(ze,t),y(Le,t),y(Pe,t),y(De,t),y(tl,t),y(ll,t),y(al,t),y(B,t),y(il,t),y(pl,t),y(x,t),y(ml,t),y(ul,t),y(wl,t),y(fl,t),y(gl,t),y(H,t),y(Tl,t)}}}const Si='{"title":"Custom Tools and Prompts","local":"custom-tools-and-prompts","sections":[{"title":"Customizing the prompt","local":"customizing-the-prompt","sections":[{"title":"Structure of the prompt","local":"structure-of-the-prompt","sections":[],"depth":3},{"title":"Writing good user inputs","local":"writing-good-user-inputs","sections":[],"depth":3},{"title":"Customizing the tool descriptions","local":"customizing-the-tool-descriptions","sections":[],"depth":3},{"title":"Customizing the whole prompt","local":"customizing-the-whole-prompt","sections":[],"depth":3}],"depth":2},{"title":"Using custom tools","local":"using-custom-tools","sections":[{"title":"Adding new tools","local":"adding-new-tools","sections":[{"title":"Creating a new tool","local":"creating-a-new-tool","sections":[],"depth":4},{"title":"Having the agent use the tool","local":"having-the-agent-use-the-tool","sections":[],"depth":4}],"depth":3},{"title":"Replacing existing tools","local":"replacing-existing-tools","sections":[],"depth":3}],"depth":2},{"title":"Leveraging gradio-tools","local":"leveraging-gradio-tools","sections":[],"depth":2},{"title":"Future compatibility with Langchain","local":"future-compatibility-with-langchain","sections":[],"depth":2}],"depth":1}';function zi(g){return Ii(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Di extends Wi{constructor(p){super(),Ci(this,p,zi,Ei,Gi,{})}}export{Di as component};
