import{s as Hs,o as Vs,n as ss}from"../chunks/scheduler.d586627e.js";import{S as Es,i as Ns,g as o,s as l,r as p,A as As,h as r,f as a,c as n,j as T,u as i,x as f,k as ot,y,a as s,v as m,d,t as c,w as u}from"../chunks/index.8589a59c.js";import{H as b,g as qs}from"../chunks/Heading.73928447.js";import{T as as}from"../chunks/Tip.84e2336e.js";import{Y as Pa}from"../chunks/Youtube.49101e7b.js";import{C as g}from"../chunks/CodeBlock.47c46d2c.js";import{D as Qs}from"../chunks/DocNotebookDropdown.35d6cac5.js";function Ls(v){let h,j=`Você verá um alerta sobre alguns pesos pré-treinados que não estão sendo utilizados e que alguns pesos estão
sendo inicializados aleatoriamente. Não se preocupe, essa mensagem é completamente normal.
O header/cabeçário pré-treinado do modelo BERT é descartado e substitui-se por um header de classificação
inicializado aleatoriamente. Assim, pode aplicar o fine-tuning a este novo header do modelo em sua tarefa
de classificação de sequências fazendo um transfer learning do modelo pré-treinado.`;return{c(){h=o("p"),h.textContent=j},l(M){h=r(M,"P",{"data-svelte-h":!0}),f(h)!=="svelte-ejxvym"&&(h.textContent=j)},m(M,$){s(M,h,$)},p:ss,d(M){M&&a(h)}}}function Ss(v){let h,j=`O <code>Trainer</code> utiliza <code>DataCollatorWithPadding</code> por padrão, então você não precisa especificar explicitamente um
colador de dados (data collator).`;return{c(){h=o("p"),h.innerHTML=j},l(M){h=r(M,"P",{"data-svelte-h":!0}),f(h)!=="svelte-hfa5bk"&&(h.innerHTML=j)},m(M,$){s(M,h,$)},p:ss,d(M){M&&a(h)}}}function Ps(v){let h,j=`Se necessário, você pode obter o acesso gratuito a uma GPU na núvem por meio de um notebook no
<a href="https://colab.research.google.com/" rel="nofollow">Colaboratory</a> ou <a href="https://studiolab.sagemaker.aws/" rel="nofollow">SageMaker StudioLab</a>
se não tiver esse recurso de forma local.`;return{c(){h=o("p"),h.innerHTML=j},l(M){h=r(M,"P",{"data-svelte-h":!0}),f(h)!=="svelte-ivn2a7"&&(h.innerHTML=j)},m(M,$){s(M,h,$)},p:ss,d(M){M&&a(h)}}}function Ds(v){let h,j,M,$,U,gt,C,Mt,I,ls=`O uso de um modelo pré-treinado tem importantes vantagens. Redução do custo computacional, a pegada de carbono, e te
permite utilizar modelos de última geração sem ter que treinar um novo desde o início.
O 🤗 Transformers proporciona acesso a milhares de modelos pré-treinados numa ampla gama de tarefas.
Quando utilizar um modelo pré-treinado, treine-o com um dataset específico para a sua tarefa.
Isto é chamado de fine-tuning, uma técnica de treinamento incrivelmente poderosa. Neste tutorial faremos o fine-tuning
de um modelo pré-treinado com um framework de Deep Learning da sua escolha:`,bt,R,ns="<li>Fine-tuning de um modelo pré-treinado com o 🤗 Transformers <code>Trainer</code>.</li> <li>Fine-tuning de um modelo pré-treinado no TensorFlow com o Keras.</li> <li>Fine-tuning de um modelo pré-treinado em PyTorch nativo.</li>",jt,rt,yt,G,Tt,W,$t,z,os=`Antes de aplicar o fine-tuning a um modelo pré-treinado, baixe um dataset e prepare-o para o treinamento.
O tutorial anterior ensinará a processar os dados para o treinamento, e então poderá ter a oportunidade de testar
esse novo conhecimento em algo prático.`,wt,X,rs='Comece carregando o dataset <a href="https://huggingface.co/datasets/yelp_review_full" rel="nofollow">Yelp Reviews</a>:',Jt,B,vt,F,ps=`Como já sabe, é necessário ter um tokenizador para processar o texto e incluir uma estratégia de padding e truncamento,
para manejar qualquer tamanho varíavel de sequência. Para processar o seu dataset em apenas um passo, utilize o método de
🤗 Datasets <a href="https://huggingface.co/docs/datasets/process.html#map" rel="nofollow"><code>map</code></a> para aplicar uma função de preprocessamento sobre
todo o dataset.`,Zt,x,kt,Y,is="Se desejar, é possível criar um subconjunto menor do dataset completo para aplicar o fine-tuning e assim reduzir o tempo necessário.",_t,H,Ut,pt,Ct,V,It,E,Rt,N,ms=`O 🤗 Transformers proporciona uma classe <code>Trainer</code> otimizada para o treinamento de modelos de 🤗 Transformers,
facilitando os primeiros passos do treinamento sem a necessidade de escrever manualmente o seu próprio ciclo.
A API do <code>Trainer</code> suporta um grande conjunto de opções de treinamento e funcionalidades, como o logging,
o gradient accumulation e o mixed precision.`,Gt,A,ds=`Comece carregando seu modelo e especifique o número de labels de previsão.
A partir do <a href="https://huggingface.co/datasets/yelp_review_full#data-fields" rel="nofollow">Card Dataset</a> do Yelp Reveiw, que ja
sabemos ter 5 labels usamos o seguinte código:`,Wt,q,zt,Z,Xt,Q,Bt,L,cs=`Em seguida, crie uma classe <code>TrainingArguments</code> que contenha todos os hiperparâmetros que possam ser ajustados, assim
como os indicadores para ativar as diferentes opções de treinamento. Para este tutorial, você pode começar o treinamento
usando os <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">hiperparámetros</a> padrão,
porém, sinta-se livre para experimentar com eles e encontrar uma configuração ótima.`,Ft,S,us="Especifique onde salvar os checkpoints do treinamento:",xt,P,Yt,D,Ht,K,fs=`O <code>Trainer</code> não avalia automaticamente o rendimento do modelo durante o treinamento. Será necessário passar ao
<code>Trainer</code> uma função para calcular e fazer um diagnóstico sobre as métricas. A biblioteca 🤗 Datasets proporciona
uma função de <a href="https://huggingface.co/metrics/accuracy" rel="nofollow"><code>accuracy</code></a> simples que pode ser carregada com a função
<code>load_metric</code> (ver este <a href="https://huggingface.co/docs/datasets/metrics.html" rel="nofollow">tutorial</a> para mais informações):`,Vt,O,Et,ee,hs=`Defina a função <code>compute</code> dentro de <code>metric</code> para calcular a precisão das suas predições.
Antes de passar as suas predições ao <code>compute</code>, é necessário converter as predições à logits (lembre-se que
todos os modelos de 🤗 Transformers retornam logits).`,Nt,te,At,ae,gs=`Se quiser controlar as suas métricas de avaliação durante o fine-tuning, especifique o parâmetro <code>evaluation_strategy</code>
nos seus argumentos de treinamento para que o modelo considere a métrica de avaliação ao final de cada época:`,qt,se,Qt,le,Lt,ne,Ms="Crie um objeto <code>Trainer</code> com o seu modelo, argumentos de treinamento, conjuntos de dados de treinamento e de teste, e a sua função de avaliação:",St,oe,Pt,re,bs="Em seguida, aplique o fine-tuning a seu modelo chamado <code>train()</code>:",Dt,pe,Kt,it,Ot,ie,ea,me,ta,de,js=`Os modelos de 🤗 Transformers também permitem realizar o treinamento com o TensorFlow com a API do Keras.
Contudo, será necessário fazer algumas mudanças antes de realizar o fine-tuning.`,aa,ce,sa,ue,ys=`O <code>DefaultDataCollator</code> junta os tensores em um batch para que o modelo possa ser treinado em cima deles.
Assegure-se de especificar os <code>return_tensors</code> para retornar os tensores do TensorFlow:`,la,fe,na,k,oa,he,Ts=`Em seguida, converta os datasets tokenizados em datasets do TensorFlow com o método
<a href="https://huggingface.co/docs/datasets/package_reference/main_classes.html#datasets.Dataset.to_tf_dataset" rel="nofollow"><code>to_tf_dataset</code></a>.
Especifique suas entradas em <code>columns</code> e seu rótulo em <code>label_cols</code>:`,ra,ge,pa,Me,ia,be,$s="Carregue um modelo do TensorFlow com o número esperado de rótulos:",ma,je,da,ye,ws=`A seguir, compile e ajuste o fine-tuning a seu modelo com <a href="https://keras.io/api/models/model_training_apis/" rel="nofollow"><code>fit</code></a> como
faria com qualquer outro modelo do Keras:`,ca,Te,ua,mt,fa,$e,ha,we,ga,Je,Js=`O <code>Trainer</code> se encarrega do ciclo de treinamento e permite aplicar o fine-tuning a um modelo em uma linha de código apenas.
Para os usuários que preferirem escrever o seu próprio ciclo de treinamento, também é possível aplicar o fine-tuning a um
modelo de 🤗 Transformers em PyTorch nativo.`,Ma,ve,vs=`Neste momento, talvez ocorra a necessidade de reinicar seu notebook ou executar a seguinte linha de código para liberar
memória:`,ba,Ze,ja,ke,Zs="Em sequência, faremos um post-processing manual do <code>tokenized_dataset</code> e assim prepará-lo para o treinamento.",ya,w,_e,dt,ks="Apague a coluna de <code>text</code> porque o modelo não aceita texto cru como entrada:",Da,Ue,Ka,Ce,ct,_s="Troque o nome da coluna <code>label</code> para <code>labels</code>, pois o modelo espera um argumento de mesmo nome:",Oa,Ie,es,Re,ut,Us="Defina o formato do dataset para retornar tensores do PyTorch no lugar de listas:",ts,Ge,Ta,We,Cs="Em sequência, crie um subconjunto menor do dataset, como foi mostrado anteriormente, para acelerá-lo o fine-tuning.",$a,ze,wa,Xe,Ja,Be,Is="Crie um <code>DataLoader</code> para os seus datasets de treinamento e de teste para poder iterar sobre batches de dados:",va,Fe,Za,xe,Rs="Carregue seu modelo com o número de labels esperados:",ka,Ye,_a,He,Ua,Ve,Gs=`Crie um otimizador e um learning rate para aplicar o fine-tuning ao modelo.
Iremos utilizar o otimizador <a href="https://pytorch.org/docs/stable/generated/torch.optim.AdamW.html" rel="nofollow"><code>AdamW</code></a> do PyTorch:`,Ca,Ee,Ia,Ne,Ws="Defina o learning rate do <code>Trainer</code>:",Ra,Ae,Ga,qe,zs=`Por último, especifique o <code>device</code> do ambiente para utilizar uma GPU se tiver acesso à alguma. Caso contrário, o treinamento
em uma CPU pode acabar levando várias horas em vez de minutos.`,Wa,Qe,za,_,Xa,Le,Xs="Perfeito, agora estamos prontos para começar o treinamento! 🥳",Ba,Se,Fa,Pe,Bs=`Para visualizar melhor o processo de treinamento, utilize a biblioteca <a href="https://tqdm.github.io/" rel="nofollow">tqdm</a> para adicionar
uma barra de progresso sobre o número de passos percorridos no treinamento atual:`,xa,De,Ya,Ke,Ha,Oe,Fs=`Da mesma forma que é necessário adicionar uma função de avaliação ao <code>Trainer</code>, é necessário fazer o mesmo quando
escrevendo o próprio ciclo de treinamento. Contudo, em vez de calcular e retornar a métrica final de cada época,
você deverá adicionar todos os batches com <a href="https://huggingface.co/docs/datasets/package_reference/main_classes.html?highlight=add_batch#datasets.Metric.add_batch" rel="nofollow"><code>add_batch</code></a>
e calcular a métrica apenas no final.`,Va,et,Ea,ft,Na,tt,Aa,at,xs="Para mais exemplos de fine-tuning acesse:",qa,st,Ys=`<li><p><a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">🤗 Transformers Examples</a> inclui scripts
para treinas tarefas comuns de NLP em PyTorch e TensorFlow.</p></li> <li><p><a href="notebooks">🤗 Transformers Notebooks</a> contém vários notebooks sobre como aplicar o fine-tuning a um modelo
para tarefas específicas no PyTorch e TensorFlow.</p></li>`,Qa,ht,La;return U=new b({props:{title:"Fine-tuning de um modelo pré-treinado",local:"fine-tuning-de-um-modelo-pré-treinado",headingTag:"h1"}}),C=new Qs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/training.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/training.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/training.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/training.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/training.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/training.ipynb"}]}}),G=new b({props:{title:"Preparando um dataset",local:"preparando-um-dataset",headingTag:"h2"}}),W=new Pa({props:{id:"_BZearw7f0w"}}),B=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ5ZWxwX3Jldmlld19mdWxsJTIyKSUwQWRhdGFzZXQlNUIxMDAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;yelp_review_full&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">100</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My expectations for McDonalds are t rarely high. But for one to still fail so spectacularly...that takes something special!\\\\nThe cashier took my friends\\&#x27;s order, then promptly ignored me. I had to force myself in front of a cashier who opened his register to wait on the person BEHIND me. I waited over five minutes for a gigantic order that included precisely one kid\\&#x27;s meal. After watching two people who ordered after me be handed their food, I asked where mine was. The manager started yelling at the cashiers for \\\\&quot;serving off their orders\\\\&quot; when they didn\\&#x27;t have their food. But neither cashier was anywhere near those controls, and the manager was the one serving food to customers and clearing the boards.\\\\nThe manager was rude when giving me my order. She didn\\&#x27;t make sure that I had everything ON MY RECEIPT, and never even had the decency to apologize that I felt I was getting poor service.\\\\nI\\&#x27;ve eaten at various McDonalds restaurants for over 30 years. I\\&#x27;ve worked at more than one location. I expect bad days, bad moods, and the occasional mistake. But I have yet to have a decent experience at this store. It will remain a place I avoid unless someone in my party needs to avoid illness from low blood sugar. Perhaps I should go back to the racially biased service of Steak n Shake instead!&#x27;</span>}`,wrap:!1}}),x=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTBBZGVmJTIwdG9rZW5pemVfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJTIydGV4dCUyMiU1RCUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldC5tYXAodG9rZW5pemVfZnVuY3Rpb24lMkMlMjBiYXRjaGVkJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = dataset.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)`,wrap:!1}}),H=new g({props:{code:"c21hbGxfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVELnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBc21hbGxfZXZhbF9kYXRhc2V0JTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDEwMDApKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>small_eval_dataset = tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))`,wrap:!1}}),V=new b({props:{title:"Fine-tuning com o Trainer",local:"fine-tuning-com-o-trainer",headingTag:"h2"}}),E=new Pa({props:{id:"nvBXf7s7vTI"}}),q=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0Q1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),Z=new as({props:{$$slots:{default:[Ls]},$$scope:{ctx:v}}}),Q=new b({props:{title:"Hiperparâmetros de treinamento",local:"hiperparâmetros-de-treinamento",headingTag:"h3"}}),P=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKG91dHB1dF9kaXIlM0QlMjJ0ZXN0X3RyYWluZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;test_trainer&quot;</span>)`,wrap:!1}}),D=new b({props:{title:"Métricas",local:"métricas",headingTag:"h3"}}),O=new g({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9tZXRyaWMlMEElMEFtZXRyaWMlMjAlM0QlMjBsb2FkX21ldHJpYyglMjJhY2N1cmFjeSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_metric

<span class="hljs-meta">&gt;&gt;&gt; </span>metric = load_metric(<span class="hljs-string">&quot;accuracy&quot;</span>)`,wrap:!1}}),te=new g({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG5wLmFyZ21heChsb2dpdHMlMkMlMjBheGlzJTNELTEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    logits, labels = eval_pred
<span class="hljs-meta">... </span>    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),se=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKG91dHB1dF9kaXIlM0QlMjJ0ZXN0X3RyYWluZXIlMjIlMkMlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;test_trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)`,wrap:!1}}),le=new b({props:{title:"Trainer",local:"trainer",headingTag:"h3"}}),oe=new g({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHNtYWxsX3RyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RzbWFsbF9ldmFsX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=small_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=small_eval_dataset,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)`,wrap:!1}}),pe=new g({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()',wrap:!1}}),ie=new b({props:{title:"Fine-tuning com Keras",local:"fine-tuning-com-keras",headingTag:"h2"}}),me=new Pa({props:{id:"rnTGBy2ax1c"}}),ce=new b({props:{title:"Conversão do dataset ao formato do TensorFlow",local:"conversão-do-dataset-ao-formato-do-tensorflow",headingTag:"h3"}}),fe=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcihyZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator(return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)`,wrap:!1}}),k=new as({props:{$$slots:{default:[Ss]},$$scope:{ctx:v}}}),ge=new g({props:{code:"dGZfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHNtYWxsX3RyYWluX2RhdGFzZXQudG9fdGZfZGF0YXNldCglMEElMjAlMjAlMjAlMjBjb2x1bW5zJTNEJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX2NvbHMlM0QlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGNvbGxhdGVfZm4lM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMEEpJTBBJTBBdGZfdmFsaWRhdGlvbl9kYXRhc2V0JTIwJTNEJTIwc21hbGxfZXZhbF9kYXRhc2V0LnRvX3RmX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwY29sdW1ucyUzRCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTJDJTIwJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIydG9rZW5fdHlwZV9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9jb2xzJTNEJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2h1ZmZsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tf_train_dataset = small_train_dataset.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>    label_cols=<span class="hljs-string">&quot;labels&quot;</span>,
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_validation_dataset = small_eval_dataset.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>    label_cols=<span class="hljs-string">&quot;labels&quot;</span>,
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Me=new b({props:{title:"Compilação e ajustes",local:"compilação-e-ajustes",headingTag:"h3"}}),je=new g({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0Q1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),Te=new g({props:{code:"bW9kZWwuY29tcGlsZSglMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0R0Zi5rZXJhcy5vcHRpbWl6ZXJzLkFkYW0obGVhcm5pbmdfcmF0ZSUzRDVlLTUpJTJDJTBBJTIwJTIwJTIwJTIwbG9zcyUzRHRmLmtlcmFzLmxvc3Nlcy5TcGFyc2VDYXRlZ29yaWNhbENyb3NzZW50cm9weShmcm9tX2xvZ2l0cyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljcyUzRHRmLm1ldHJpY3MuU3BhcnNlQ2F0ZWdvcmljYWxBY2N1cmFjeSgpJTJDJTBBKSUwQSUwQW1vZGVsLmZpdCh0Zl90cmFpbl9kYXRhc2V0JTJDJTIwdmFsaWRhdGlvbl9kYXRhJTNEdGZfdmFsaWRhdGlvbl9kYXRhc2V0JTJDJTIwZXBvY2hzJTNEMyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(
<span class="hljs-meta">... </span>    optimizer=tf.keras.optimizers.Adam(learning_rate=<span class="hljs-number">5e-5</span>),
<span class="hljs-meta">... </span>    loss=tf.keras.losses.SparseCategoricalCrossentropy(from_logits=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>    metrics=tf.metrics.SparseCategoricalAccuracy(),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(tf_train_dataset, validation_data=tf_validation_dataset, epochs=<span class="hljs-number">3</span>)`,wrap:!1}}),$e=new b({props:{title:"Fine-tune em PyTorch nativo",local:"fine-tune-em-pytorch-nativo",headingTag:"h2"}}),we=new Pa({props:{id:"Dh9CL8fyG80"}}),Ze=new g({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBweXRvcmNoX21vZGVsJTBBZGVsJTIwdHJhaW5lciUwQXRvcmNoLmN1ZGEuZW1wdHlfY2FjaGUoKQ==",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pytorch_model
<span class="hljs-keyword">del</span> trainer
torch.cuda.empty_cache()`,wrap:!1}}),Ue=new g({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnRleHQlMjIlNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;text&quot;</span>])',wrap:!1}}),Ie=new g({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbmFtZV9jb2x1bW4oJTIybGFiZWwlMjIlMkMlMjAlMjJsYWJlbHMlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)',wrap:!1}}),Ge=new g({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzLnNldF9mb3JtYXQoJTIydG9yY2glMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)',wrap:!1}}),ze=new g({props:{code:"c21hbGxfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVELnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBc21hbGxfZXZhbF9kYXRhc2V0JTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDEwMDApKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>small_eval_dataset = tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))`,wrap:!1}}),Xe=new b({props:{title:"DataLoader",local:"dataloader",headingTag:"h3"}}),Fe=new g({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoc21hbGxfdHJhaW5fZGF0YXNldCUyQyUyMHNodWZmbGUlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRDgpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihzbWFsbF9ldmFsX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEOCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = DataLoader(small_train_dataset, shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_dataloader = DataLoader(small_eval_dataset, batch_size=<span class="hljs-number">8</span>)`,wrap:!1}}),Ye=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0Q1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),He=new b({props:{title:"Otimização e configuração do Learning Rate",local:"otimização-e-configuração-do-learning-rate",headingTag:"h3"}}),Ee=new g({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),Ae=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIybGluZWFyJTIyJTJDJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTIwbnVtX3dhcm11cF9zdGVwcyUzRDAlMkMlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0RudW1fdHJhaW5pbmdfc3RlcHMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
<span class="hljs-meta">&gt;&gt;&gt; </span>lr_scheduler = get_scheduler(
<span class="hljs-meta">... </span>    name=<span class="hljs-string">&quot;linear&quot;</span>, optimizer=optimizer, num_warmup_steps=<span class="hljs-number">0</span>, num_training_steps=num_training_steps
<span class="hljs-meta">... </span>)`,wrap:!1}}),Qe=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)`,wrap:!1}}),_=new as({props:{$$slots:{default:[Ps]},$$scope:{ctx:v}}}),Se=new b({props:{title:"Ciclo de treinamento",local:"ciclo-de-treinamento",headingTag:"h3"}}),De=new g({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

<span class="hljs-meta">&gt;&gt;&gt; </span>model.train()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        loss.backward()

<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        lr_scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),Ke=new b({props:{title:"Métricas",local:"métricas",headingTag:"h3"}}),et=new g({props:{code:"bWV0cmljJTIwJTNEJTIwbG9hZF9tZXRyaWMoJTIyYWNjdXJhY3klMjIpJTBBbW9kZWwuZXZhbCgpJTBBZm9yJTIwYmF0Y2glMjBpbiUyMGV2YWxfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBiYXRjaC5pdGVtcygpJTdEJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTIwJTIwJTIwJTIwbWV0cmljLmFkZF9iYXRjaChwcmVkaWN0aW9ucyUzRHByZWRpY3Rpb25zJTJDJTIwcmVmZXJlbmNlcyUzRGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEKSUwQSUwQW1ldHJpYy5jb21wdXRlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>metric = load_metric(<span class="hljs-string">&quot;accuracy&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
<span class="hljs-meta">... </span>    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        outputs = model(**batch)

<span class="hljs-meta">... </span>    logits = outputs.logits
<span class="hljs-meta">... </span>    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>metric.compute()`,wrap:!1}}),tt=new b({props:{title:"Recursos adicionais",local:"recursos-adicionais",headingTag:"h2"}}),{c(){h=o("meta"),j=l(),M=o("p"),$=l(),p(U.$$.fragment),gt=l(),p(C.$$.fragment),Mt=l(),I=o("p"),I.textContent=ls,bt=l(),R=o("ul"),R.innerHTML=ns,jt=l(),rt=o("a"),yt=l(),p(G.$$.fragment),Tt=l(),p(W.$$.fragment),$t=l(),z=o("p"),z.textContent=os,wt=l(),X=o("p"),X.innerHTML=rs,Jt=l(),p(B.$$.fragment),vt=l(),F=o("p"),F.innerHTML=ps,Zt=l(),p(x.$$.fragment),kt=l(),Y=o("p"),Y.textContent=is,_t=l(),p(H.$$.fragment),Ut=l(),pt=o("a"),Ct=l(),p(V.$$.fragment),It=l(),p(E.$$.fragment),Rt=l(),N=o("p"),N.innerHTML=ms,Gt=l(),A=o("p"),A.innerHTML=ds,Wt=l(),p(q.$$.fragment),zt=l(),p(Z.$$.fragment),Xt=l(),p(Q.$$.fragment),Bt=l(),L=o("p"),L.innerHTML=cs,Ft=l(),S=o("p"),S.textContent=us,xt=l(),p(P.$$.fragment),Yt=l(),p(D.$$.fragment),Ht=l(),K=o("p"),K.innerHTML=fs,Vt=l(),p(O.$$.fragment),Et=l(),ee=o("p"),ee.innerHTML=hs,Nt=l(),p(te.$$.fragment),At=l(),ae=o("p"),ae.innerHTML=gs,qt=l(),p(se.$$.fragment),Qt=l(),p(le.$$.fragment),Lt=l(),ne=o("p"),ne.innerHTML=Ms,St=l(),p(oe.$$.fragment),Pt=l(),re=o("p"),re.innerHTML=bs,Dt=l(),p(pe.$$.fragment),Kt=l(),it=o("a"),Ot=l(),p(ie.$$.fragment),ea=l(),p(me.$$.fragment),ta=l(),de=o("p"),de.textContent=js,aa=l(),p(ce.$$.fragment),sa=l(),ue=o("p"),ue.innerHTML=ys,la=l(),p(fe.$$.fragment),na=l(),p(k.$$.fragment),oa=l(),he=o("p"),he.innerHTML=Ts,ra=l(),p(ge.$$.fragment),pa=l(),p(Me.$$.fragment),ia=l(),be=o("p"),be.textContent=$s,ma=l(),p(je.$$.fragment),da=l(),ye=o("p"),ye.innerHTML=ws,ca=l(),p(Te.$$.fragment),ua=l(),mt=o("a"),fa=l(),p($e.$$.fragment),ha=l(),p(we.$$.fragment),ga=l(),Je=o("p"),Je.innerHTML=Js,Ma=l(),ve=o("p"),ve.textContent=vs,ba=l(),p(Ze.$$.fragment),ja=l(),ke=o("p"),ke.innerHTML=Zs,ya=l(),w=o("ol"),_e=o("li"),dt=o("p"),dt.innerHTML=ks,Da=l(),p(Ue.$$.fragment),Ka=l(),Ce=o("li"),ct=o("p"),ct.innerHTML=_s,Oa=l(),p(Ie.$$.fragment),es=l(),Re=o("li"),ut=o("p"),ut.textContent=Us,ts=l(),p(Ge.$$.fragment),Ta=l(),We=o("p"),We.textContent=Cs,$a=l(),p(ze.$$.fragment),wa=l(),p(Xe.$$.fragment),Ja=l(),Be=o("p"),Be.innerHTML=Is,va=l(),p(Fe.$$.fragment),Za=l(),xe=o("p"),xe.textContent=Rs,ka=l(),p(Ye.$$.fragment),_a=l(),p(He.$$.fragment),Ua=l(),Ve=o("p"),Ve.innerHTML=Gs,Ca=l(),p(Ee.$$.fragment),Ia=l(),Ne=o("p"),Ne.innerHTML=Ws,Ra=l(),p(Ae.$$.fragment),Ga=l(),qe=o("p"),qe.innerHTML=zs,Wa=l(),p(Qe.$$.fragment),za=l(),p(_.$$.fragment),Xa=l(),Le=o("p"),Le.textContent=Xs,Ba=l(),p(Se.$$.fragment),Fa=l(),Pe=o("p"),Pe.innerHTML=Bs,xa=l(),p(De.$$.fragment),Ya=l(),p(Ke.$$.fragment),Ha=l(),Oe=o("p"),Oe.innerHTML=Fs,Va=l(),p(et.$$.fragment),Ea=l(),ft=o("a"),Na=l(),p(tt.$$.fragment),Aa=l(),at=o("p"),at.textContent=xs,qa=l(),st=o("ul"),st.innerHTML=Ys,Qa=l(),ht=o("p"),this.h()},l(e){const t=As("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(a),j=n(e),M=r(e,"P",{}),T(M).forEach(a),$=n(e),i(U.$$.fragment,e),gt=n(e),i(C.$$.fragment,e),Mt=n(e),I=r(e,"P",{"data-svelte-h":!0}),f(I)!=="svelte-fhi5po"&&(I.textContent=ls),bt=n(e),R=r(e,"UL",{"data-svelte-h":!0}),f(R)!=="svelte-1uar1qx"&&(R.innerHTML=ns),jt=n(e),rt=r(e,"A",{id:!0}),T(rt).forEach(a),yt=n(e),i(G.$$.fragment,e),Tt=n(e),i(W.$$.fragment,e),$t=n(e),z=r(e,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1opso33"&&(z.textContent=os),wt=n(e),X=r(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-14tknsg"&&(X.innerHTML=rs),Jt=n(e),i(B.$$.fragment,e),vt=n(e),F=r(e,"P",{"data-svelte-h":!0}),f(F)!=="svelte-1yz72ym"&&(F.innerHTML=ps),Zt=n(e),i(x.$$.fragment,e),kt=n(e),Y=r(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-1cg4wp0"&&(Y.textContent=is),_t=n(e),i(H.$$.fragment,e),Ut=n(e),pt=r(e,"A",{id:!0}),T(pt).forEach(a),Ct=n(e),i(V.$$.fragment,e),It=n(e),i(E.$$.fragment,e),Rt=n(e),N=r(e,"P",{"data-svelte-h":!0}),f(N)!=="svelte-1j0gwk8"&&(N.innerHTML=ms),Gt=n(e),A=r(e,"P",{"data-svelte-h":!0}),f(A)!=="svelte-56udk6"&&(A.innerHTML=ds),Wt=n(e),i(q.$$.fragment,e),zt=n(e),i(Z.$$.fragment,e),Xt=n(e),i(Q.$$.fragment,e),Bt=n(e),L=r(e,"P",{"data-svelte-h":!0}),f(L)!=="svelte-1vu82s5"&&(L.innerHTML=cs),Ft=n(e),S=r(e,"P",{"data-svelte-h":!0}),f(S)!=="svelte-fjh0nm"&&(S.textContent=us),xt=n(e),i(P.$$.fragment,e),Yt=n(e),i(D.$$.fragment,e),Ht=n(e),K=r(e,"P",{"data-svelte-h":!0}),f(K)!=="svelte-1fpd7i5"&&(K.innerHTML=fs),Vt=n(e),i(O.$$.fragment,e),Et=n(e),ee=r(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-1oopkat"&&(ee.innerHTML=hs),Nt=n(e),i(te.$$.fragment,e),At=n(e),ae=r(e,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-k3gxyo"&&(ae.innerHTML=gs),qt=n(e),i(se.$$.fragment,e),Qt=n(e),i(le.$$.fragment,e),Lt=n(e),ne=r(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-1r3j7rx"&&(ne.innerHTML=Ms),St=n(e),i(oe.$$.fragment,e),Pt=n(e),re=r(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-a3f13l"&&(re.innerHTML=bs),Dt=n(e),i(pe.$$.fragment,e),Kt=n(e),it=r(e,"A",{id:!0}),T(it).forEach(a),Ot=n(e),i(ie.$$.fragment,e),ea=n(e),i(me.$$.fragment,e),ta=n(e),de=r(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-j16adj"&&(de.textContent=js),aa=n(e),i(ce.$$.fragment,e),sa=n(e),ue=r(e,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-1gyci2m"&&(ue.innerHTML=ys),la=n(e),i(fe.$$.fragment,e),na=n(e),i(k.$$.fragment,e),oa=n(e),he=r(e,"P",{"data-svelte-h":!0}),f(he)!=="svelte-9k3v0o"&&(he.innerHTML=Ts),ra=n(e),i(ge.$$.fragment,e),pa=n(e),i(Me.$$.fragment,e),ia=n(e),be=r(e,"P",{"data-svelte-h":!0}),f(be)!=="svelte-rgss8z"&&(be.textContent=$s),ma=n(e),i(je.$$.fragment,e),da=n(e),ye=r(e,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-qjchcy"&&(ye.innerHTML=ws),ca=n(e),i(Te.$$.fragment,e),ua=n(e),mt=r(e,"A",{id:!0}),T(mt).forEach(a),fa=n(e),i($e.$$.fragment,e),ha=n(e),i(we.$$.fragment,e),ga=n(e),Je=r(e,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-1q1pzl3"&&(Je.innerHTML=Js),Ma=n(e),ve=r(e,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-1abyi5e"&&(ve.textContent=vs),ba=n(e),i(Ze.$$.fragment,e),ja=n(e),ke=r(e,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-1a8dyp8"&&(ke.innerHTML=Zs),ya=n(e),w=r(e,"OL",{});var J=T(w);_e=r(J,"LI",{});var lt=T(_e);dt=r(lt,"P",{"data-svelte-h":!0}),f(dt)!=="svelte-n1mzi4"&&(dt.innerHTML=ks),Da=n(lt),i(Ue.$$.fragment,lt),lt.forEach(a),Ka=n(J),Ce=r(J,"LI",{});var nt=T(Ce);ct=r(nt,"P",{"data-svelte-h":!0}),f(ct)!=="svelte-dx24cp"&&(ct.innerHTML=_s),Oa=n(nt),i(Ie.$$.fragment,nt),nt.forEach(a),es=n(J),Re=r(J,"LI",{});var Sa=T(Re);ut=r(Sa,"P",{"data-svelte-h":!0}),f(ut)!=="svelte-15zkuau"&&(ut.textContent=Us),ts=n(Sa),i(Ge.$$.fragment,Sa),Sa.forEach(a),J.forEach(a),Ta=n(e),We=r(e,"P",{"data-svelte-h":!0}),f(We)!=="svelte-x0bqu0"&&(We.textContent=Cs),$a=n(e),i(ze.$$.fragment,e),wa=n(e),i(Xe.$$.fragment,e),Ja=n(e),Be=r(e,"P",{"data-svelte-h":!0}),f(Be)!=="svelte-lg4as"&&(Be.innerHTML=Is),va=n(e),i(Fe.$$.fragment,e),Za=n(e),xe=r(e,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-1y9asxq"&&(xe.textContent=Rs),ka=n(e),i(Ye.$$.fragment,e),_a=n(e),i(He.$$.fragment,e),Ua=n(e),Ve=r(e,"P",{"data-svelte-h":!0}),f(Ve)!=="svelte-1355v62"&&(Ve.innerHTML=Gs),Ca=n(e),i(Ee.$$.fragment,e),Ia=n(e),Ne=r(e,"P",{"data-svelte-h":!0}),f(Ne)!=="svelte-61qbj5"&&(Ne.innerHTML=Ws),Ra=n(e),i(Ae.$$.fragment,e),Ga=n(e),qe=r(e,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-794g8f"&&(qe.innerHTML=zs),Wa=n(e),i(Qe.$$.fragment,e),za=n(e),i(_.$$.fragment,e),Xa=n(e),Le=r(e,"P",{"data-svelte-h":!0}),f(Le)!=="svelte-10cun9s"&&(Le.textContent=Xs),Ba=n(e),i(Se.$$.fragment,e),Fa=n(e),Pe=r(e,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-ibqtt9"&&(Pe.innerHTML=Bs),xa=n(e),i(De.$$.fragment,e),Ya=n(e),i(Ke.$$.fragment,e),Ha=n(e),Oe=r(e,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-1wjbnz3"&&(Oe.innerHTML=Fs),Va=n(e),i(et.$$.fragment,e),Ea=n(e),ft=r(e,"A",{id:!0}),T(ft).forEach(a),Na=n(e),i(tt.$$.fragment,e),Aa=n(e),at=r(e,"P",{"data-svelte-h":!0}),f(at)!=="svelte-vbn27k"&&(at.textContent=xs),qa=n(e),st=r(e,"UL",{"data-svelte-h":!0}),f(st)!=="svelte-1n639bw"&&(st.innerHTML=Ys),Qa=n(e),ht=r(e,"P",{}),T(ht).forEach(a),this.h()},h(){ot(h,"name","hf:doc:metadata"),ot(h,"content",Ks),ot(rt,"id","data-processing"),ot(pt,"id","trainer"),ot(it,"id","keras"),ot(mt,"id","pytorch_native"),ot(ft,"id","additional-resources")},m(e,t){y(document.head,h),s(e,j,t),s(e,M,t),s(e,$,t),m(U,e,t),s(e,gt,t),m(C,e,t),s(e,Mt,t),s(e,I,t),s(e,bt,t),s(e,R,t),s(e,jt,t),s(e,rt,t),s(e,yt,t),m(G,e,t),s(e,Tt,t),m(W,e,t),s(e,$t,t),s(e,z,t),s(e,wt,t),s(e,X,t),s(e,Jt,t),m(B,e,t),s(e,vt,t),s(e,F,t),s(e,Zt,t),m(x,e,t),s(e,kt,t),s(e,Y,t),s(e,_t,t),m(H,e,t),s(e,Ut,t),s(e,pt,t),s(e,Ct,t),m(V,e,t),s(e,It,t),m(E,e,t),s(e,Rt,t),s(e,N,t),s(e,Gt,t),s(e,A,t),s(e,Wt,t),m(q,e,t),s(e,zt,t),m(Z,e,t),s(e,Xt,t),m(Q,e,t),s(e,Bt,t),s(e,L,t),s(e,Ft,t),s(e,S,t),s(e,xt,t),m(P,e,t),s(e,Yt,t),m(D,e,t),s(e,Ht,t),s(e,K,t),s(e,Vt,t),m(O,e,t),s(e,Et,t),s(e,ee,t),s(e,Nt,t),m(te,e,t),s(e,At,t),s(e,ae,t),s(e,qt,t),m(se,e,t),s(e,Qt,t),m(le,e,t),s(e,Lt,t),s(e,ne,t),s(e,St,t),m(oe,e,t),s(e,Pt,t),s(e,re,t),s(e,Dt,t),m(pe,e,t),s(e,Kt,t),s(e,it,t),s(e,Ot,t),m(ie,e,t),s(e,ea,t),m(me,e,t),s(e,ta,t),s(e,de,t),s(e,aa,t),m(ce,e,t),s(e,sa,t),s(e,ue,t),s(e,la,t),m(fe,e,t),s(e,na,t),m(k,e,t),s(e,oa,t),s(e,he,t),s(e,ra,t),m(ge,e,t),s(e,pa,t),m(Me,e,t),s(e,ia,t),s(e,be,t),s(e,ma,t),m(je,e,t),s(e,da,t),s(e,ye,t),s(e,ca,t),m(Te,e,t),s(e,ua,t),s(e,mt,t),s(e,fa,t),m($e,e,t),s(e,ha,t),m(we,e,t),s(e,ga,t),s(e,Je,t),s(e,Ma,t),s(e,ve,t),s(e,ba,t),m(Ze,e,t),s(e,ja,t),s(e,ke,t),s(e,ya,t),s(e,w,t),y(w,_e),y(_e,dt),y(_e,Da),m(Ue,_e,null),y(w,Ka),y(w,Ce),y(Ce,ct),y(Ce,Oa),m(Ie,Ce,null),y(w,es),y(w,Re),y(Re,ut),y(Re,ts),m(Ge,Re,null),s(e,Ta,t),s(e,We,t),s(e,$a,t),m(ze,e,t),s(e,wa,t),m(Xe,e,t),s(e,Ja,t),s(e,Be,t),s(e,va,t),m(Fe,e,t),s(e,Za,t),s(e,xe,t),s(e,ka,t),m(Ye,e,t),s(e,_a,t),m(He,e,t),s(e,Ua,t),s(e,Ve,t),s(e,Ca,t),m(Ee,e,t),s(e,Ia,t),s(e,Ne,t),s(e,Ra,t),m(Ae,e,t),s(e,Ga,t),s(e,qe,t),s(e,Wa,t),m(Qe,e,t),s(e,za,t),m(_,e,t),s(e,Xa,t),s(e,Le,t),s(e,Ba,t),m(Se,e,t),s(e,Fa,t),s(e,Pe,t),s(e,xa,t),m(De,e,t),s(e,Ya,t),m(Ke,e,t),s(e,Ha,t),s(e,Oe,t),s(e,Va,t),m(et,e,t),s(e,Ea,t),s(e,ft,t),s(e,Na,t),m(tt,e,t),s(e,Aa,t),s(e,at,t),s(e,qa,t),s(e,st,t),s(e,Qa,t),s(e,ht,t),La=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),Z.$set(J);const lt={};t&2&&(lt.$$scope={dirty:t,ctx:e}),k.$set(lt);const nt={};t&2&&(nt.$$scope={dirty:t,ctx:e}),_.$set(nt)},i(e){La||(d(U.$$.fragment,e),d(C.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(B.$$.fragment,e),d(x.$$.fragment,e),d(H.$$.fragment,e),d(V.$$.fragment,e),d(E.$$.fragment,e),d(q.$$.fragment,e),d(Z.$$.fragment,e),d(Q.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(ie.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),d(fe.$$.fragment,e),d(k.$$.fragment,e),d(ge.$$.fragment,e),d(Me.$$.fragment,e),d(je.$$.fragment,e),d(Te.$$.fragment,e),d($e.$$.fragment,e),d(we.$$.fragment,e),d(Ze.$$.fragment,e),d(Ue.$$.fragment,e),d(Ie.$$.fragment,e),d(Ge.$$.fragment,e),d(ze.$$.fragment,e),d(Xe.$$.fragment,e),d(Fe.$$.fragment,e),d(Ye.$$.fragment,e),d(He.$$.fragment,e),d(Ee.$$.fragment,e),d(Ae.$$.fragment,e),d(Qe.$$.fragment,e),d(_.$$.fragment,e),d(Se.$$.fragment,e),d(De.$$.fragment,e),d(Ke.$$.fragment,e),d(et.$$.fragment,e),d(tt.$$.fragment,e),La=!0)},o(e){c(U.$$.fragment,e),c(C.$$.fragment,e),c(G.$$.fragment,e),c(W.$$.fragment,e),c(B.$$.fragment,e),c(x.$$.fragment,e),c(H.$$.fragment,e),c(V.$$.fragment,e),c(E.$$.fragment,e),c(q.$$.fragment,e),c(Z.$$.fragment,e),c(Q.$$.fragment,e),c(P.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(le.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(ie.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(fe.$$.fragment,e),c(k.$$.fragment,e),c(ge.$$.fragment,e),c(Me.$$.fragment,e),c(je.$$.fragment,e),c(Te.$$.fragment,e),c($e.$$.fragment,e),c(we.$$.fragment,e),c(Ze.$$.fragment,e),c(Ue.$$.fragment,e),c(Ie.$$.fragment,e),c(Ge.$$.fragment,e),c(ze.$$.fragment,e),c(Xe.$$.fragment,e),c(Fe.$$.fragment,e),c(Ye.$$.fragment,e),c(He.$$.fragment,e),c(Ee.$$.fragment,e),c(Ae.$$.fragment,e),c(Qe.$$.fragment,e),c(_.$$.fragment,e),c(Se.$$.fragment,e),c(De.$$.fragment,e),c(Ke.$$.fragment,e),c(et.$$.fragment,e),c(tt.$$.fragment,e),La=!1},d(e){e&&(a(j),a(M),a($),a(gt),a(Mt),a(I),a(bt),a(R),a(jt),a(rt),a(yt),a(Tt),a($t),a(z),a(wt),a(X),a(Jt),a(vt),a(F),a(Zt),a(kt),a(Y),a(_t),a(Ut),a(pt),a(Ct),a(It),a(Rt),a(N),a(Gt),a(A),a(Wt),a(zt),a(Xt),a(Bt),a(L),a(Ft),a(S),a(xt),a(Yt),a(Ht),a(K),a(Vt),a(Et),a(ee),a(Nt),a(At),a(ae),a(qt),a(Qt),a(Lt),a(ne),a(St),a(Pt),a(re),a(Dt),a(Kt),a(it),a(Ot),a(ea),a(ta),a(de),a(aa),a(sa),a(ue),a(la),a(na),a(oa),a(he),a(ra),a(pa),a(ia),a(be),a(ma),a(da),a(ye),a(ca),a(ua),a(mt),a(fa),a(ha),a(ga),a(Je),a(Ma),a(ve),a(ba),a(ja),a(ke),a(ya),a(w),a(Ta),a(We),a($a),a(wa),a(Ja),a(Be),a(va),a(Za),a(xe),a(ka),a(_a),a(Ua),a(Ve),a(Ca),a(Ia),a(Ne),a(Ra),a(Ga),a(qe),a(Wa),a(za),a(Xa),a(Le),a(Ba),a(Fa),a(Pe),a(xa),a(Ya),a(Ha),a(Oe),a(Va),a(Ea),a(ft),a(Na),a(Aa),a(at),a(qa),a(st),a(Qa),a(ht)),a(h),u(U,e),u(C,e),u(G,e),u(W,e),u(B,e),u(x,e),u(H,e),u(V,e),u(E,e),u(q,e),u(Z,e),u(Q,e),u(P,e),u(D,e),u(O,e),u(te,e),u(se,e),u(le,e),u(oe,e),u(pe,e),u(ie,e),u(me,e),u(ce,e),u(fe,e),u(k,e),u(ge,e),u(Me,e),u(je,e),u(Te,e),u($e,e),u(we,e),u(Ze,e),u(Ue),u(Ie),u(Ge),u(ze,e),u(Xe,e),u(Fe,e),u(Ye,e),u(He,e),u(Ee,e),u(Ae,e),u(Qe,e),u(_,e),u(Se,e),u(De,e),u(Ke,e),u(et,e),u(tt,e)}}}const Ks='{"title":"Fine-tuning de um modelo pré-treinado","local":"fine-tuning-de-um-modelo-pré-treinado","sections":[{"title":"Preparando um dataset","local":"preparando-um-dataset","sections":[],"depth":2},{"title":"Fine-tuning com o Trainer","local":"fine-tuning-com-o-trainer","sections":[{"title":"Hiperparâmetros de treinamento","local":"hiperparâmetros-de-treinamento","sections":[],"depth":3},{"title":"Métricas","local":"métricas","sections":[],"depth":3},{"title":"Trainer","local":"trainer","sections":[],"depth":3}],"depth":2},{"title":"Fine-tuning com Keras","local":"fine-tuning-com-keras","sections":[{"title":"Conversão do dataset ao formato do TensorFlow","local":"conversão-do-dataset-ao-formato-do-tensorflow","sections":[],"depth":3},{"title":"Compilação e ajustes","local":"compilação-e-ajustes","sections":[],"depth":3}],"depth":2},{"title":"Fine-tune em PyTorch nativo","local":"fine-tune-em-pytorch-nativo","sections":[{"title":"DataLoader","local":"dataloader","sections":[],"depth":3},{"title":"Otimização e configuração do Learning Rate","local":"otimização-e-configuração-do-learning-rate","sections":[],"depth":3},{"title":"Ciclo de treinamento","local":"ciclo-de-treinamento","sections":[],"depth":3},{"title":"Métricas","local":"métricas","sections":[],"depth":3}],"depth":2},{"title":"Recursos adicionais","local":"recursos-adicionais","sections":[],"depth":2}],"depth":1}';function Os(v){return Vs(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=qs}),[]}class rl extends Es{constructor(h){super(),Ns(this,h,Os,Ds,Hs,{})}}export{rl as component};
