import{s as Fe,o as Be,n as he}from"../chunks/scheduler.9bc65507.js";import{S as Ge,i as Re,g as m,s as l,r as b,A as De,h as p,f as u,c as i,j as K,u as v,x as f,k as ee,y as a,a as _,v as x,d as w,t as j,w as J}from"../chunks/index.707bf1b6.js";import{T as Ee}from"../chunks/Tip.c2ecdbf4.js";import{D as ae}from"../chunks/Docstring.17db21ae.js";import{C as je}from"../chunks/CodeBlock.54a9f38d.js";import{F as He,M as Ce}from"../chunks/Markdown.fef84341.js";import{E as Je}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as ue}from"../chunks/Heading.342b1fa6.js";function Xe(W){let t,d="Examples:",e,n,h;return n=new je({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpVENvbmZpZyUyQyUyMEJlcnRDb25maWclMkMlMjBWaXNpb25UZXh0RHVhbEVuY29kZXJDb25maWclMkMlMjBWaXNpb25UZXh0RHVhbEVuY29kZXJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBCRVJUJTIwYW5kJTIwVmlUJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ192aXNpb24lMjAlM0QlMjBWaVRDb25maWcoKSUwQWNvbmZpZ190ZXh0JTIwJTNEJTIwQmVydENvbmZpZygpJTBBJTBBY29uZmlnJTIwJTNEJTIwVmlzaW9uVGV4dER1YWxFbmNvZGVyQ29uZmlnLmZyb21fdmlzaW9uX3RleHRfY29uZmlncyhjb25maWdfdmlzaW9uJTJDJTIwY29uZmlnX3RleHQlMkMlMjBwcm9qZWN0aW9uX2RpbSUzRDUxMiklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQkVSVCUyMGFuZCUyMFZpVCUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUwQW1vZGVsJTIwJTNEJTIwVmlzaW9uVGV4dER1YWxFbmNvZGVyTW9kZWwoY29uZmlnJTNEY29uZmlnKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ192aXNpb24lMjAlM0QlMjBtb2RlbC5jb25maWcudmlzaW9uX2NvbmZpZyUwQWNvbmZpZ190ZXh0JTIwJTNEJTIwbW9kZWwuY29uZmlnLnRleHRfY29uZmlnJTBBJTBBJTIzJTIwU2F2aW5nJTIwdGhlJTIwbW9kZWwlMkMlMjBpbmNsdWRpbmclMjBpdHMlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnZpdC1iZXJ0JTIyKSUwQSUwQSUyMyUyMGxvYWRpbmclMjBtb2RlbCUyMGFuZCUyMGNvbmZpZyUyMGZyb20lMjBwcmV0cmFpbmVkJTIwZm9sZGVyJTBBdmlzaW9uX3RleHRfY29uZmlnJTIwJTNEJTIwVmlzaW9uVGV4dER1YWxFbmNvZGVyQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJ2aXQtYmVydCUyMiklMEFtb2RlbCUyMCUzRCUyMFZpc2lvblRleHREdWFsRW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ2aXQtYmVydCUyMiUyQyUyMGNvbmZpZyUzRHZpc2lvbl90ZXh0X2NvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViTConfig, BertConfig, VisionTextDualEncoderConfig, VisionTextDualEncoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BERT and ViT configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_vision = ViTConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text = BertConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>config = VisionTextDualEncoderConfig.from_vision_text_configs(config_vision, config_text, projection_dim=<span class="hljs-number">512</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BERT and ViT model (with random weights)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionTextDualEncoderModel(config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_vision = model.config.vision_config
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text = model.config.text_config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_text_config = VisionTextDualEncoderConfig.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionTextDualEncoderModel.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>, config=vision_text_config)`,wrap:!1}}),{c(){t=m("p"),t.textContent=d,e=l(),b(n.$$.fragment)},l(s){t=p(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=d),e=i(s),v(n.$$.fragment,s)},m(s,U){_(s,t,U),_(s,e,U),x(n,s,U),h=!0},p:he,i(s){h||(w(n.$$.fragment,s),h=!0)},o(s){j(n.$$.fragment,s),h=!1},d(s){s&&(u(t),u(e)),J(n,s)}}}function Ne(W){let t,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=d},l(e){t=p(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-fincs2"&&(t.innerHTML=d)},m(e,n){_(e,t,n)},p:he,d(e){e&&u(t)}}}function Pe(W){let t,d="Examples:",e,n,h;return n=new je({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    VisionTextDualEncoderModel,
<span class="hljs-meta">... </span>    VisionTextDualEncoderProcessor,
<span class="hljs-meta">... </span>    AutoImageProcessor,
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VisionTextDualEncoderProcessor(image_processor, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionTextDualEncoderModel.from_vision_text_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># contrastive training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>urls = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://farm3.staticflickr.com/2674/5850229113_4fe05d5265_z.jpg&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw) <span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> urls]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    input_ids=inputs.input_ids,
<span class="hljs-meta">... </span>    attention_mask=inputs.attention_mask,
<span class="hljs-meta">... </span>    pixel_values=inputs.pixel_values,
<span class="hljs-meta">... </span>    return_loss=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, logits_per_image = outputs.loss, outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save and load from pretrained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionTextDualEncoderModel.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){t=m("p"),t.textContent=d,e=l(),b(n.$$.fragment)},l(s){t=p(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=d),e=i(s),v(n.$$.fragment,s)},m(s,U){_(s,t,U),_(s,e,U),x(n,s,U),h=!0},p:he,i(s){h||(w(n.$$.fragment,s),h=!0)},o(s){j(n.$$.fragment,s),h=!1},d(s){s&&(u(t),u(e)),J(n,s)}}}function Ye(W){let t,d,e,n,h,s,U=`This class can be used to initialize a vision-text dual encoder model with any pretrained vision autoencoding model
as the vision encoder and any pretrained text model as the text encoder. The vision and text encoders are loaded
via the <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> method. The projection layers are automatically added to the model and
should be fine-tuned on a downstream task, like contrastive image-text modeling.`,L,k,ne=`In <a href="https://arxiv.org/abs/2111.07991" rel="nofollow">LiT: Zero-Shot Transfer with Locked-image Text Tuning</a> it is shown how
leveraging pre-trained (locked/frozen) image and text model for contrastive learning yields significant improvment
on new zero-shot vision tasks such as image classification or retrieval.`,Q,E,oe=`After such a Vision-Text-Dual-Encoder model has been trained/fine-tuned, it can be saved/loaded just like any other
models (see the examples for more information).`,S,C,q=`This model inherits from <a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,z,Z,te=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,X,M,G,N,B,se='The <a href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> forward method, overrides the <code>__call__</code> special method.',R,T,F,I,D;return t=new ue({props:{title:"VisionTextDualEncoderModel",local:"transformers.VisionTextDualEncoderModel",headingTag:"h2"}}),n=new ae({props:{name:"class transformers.VisionTextDualEncoderModel",anchor:"transformers.VisionTextDualEncoderModel",parameters:[{name:"config",val:": Optional = None"},{name:"vision_model",val:": Optional = None"},{name:"text_model",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.VisionTextDualEncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.3/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderConfig">VisionEncoderDecoderConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/vision_text_dual_encoder/modeling_vision_text_dual_encoder.py#L161"}}),G=new ae({props:{name:"forward",anchor:"transformers.VisionTextDualEncoderModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"return_loss",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.VisionTextDualEncoderModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.VisionTextDualEncoderModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.VisionTextDualEncoderModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.VisionTextDualEncoderModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
an image processor (e.g. if you use ViT as the encoder, you should use <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>). See
<a href="/docs/transformers/v4.39.3/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VisionTextDualEncoderModel.forward.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.VisionTextDualEncoderModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VisionTextDualEncoderModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VisionTextDualEncoderModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.39.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/vision_text_dual_encoder/modeling_vision_text_dual_encoder.py#L293",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.clip.modeling_clip.CLIPOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig"
>VisionTextDualEncoderConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image:(<code>torch.FloatTensor</code></strong> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text:(<code>torch.FloatTensor</code></strong> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds(<code>torch.FloatTensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/v4.39.3/en/model_doc/clip#transformers.CLIPTextModel"
>CLIPTextModel</a>.</li>
<li><strong>image_embeds(<code>torch.FloatTensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/v4.39.3/en/model_doc/clip#transformers.CLIPVisionModel"
>CLIPVisionModel</a>.</li>
<li><strong>text_model_output(<code>BaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/v4.39.3/en/model_doc/clip#transformers.CLIPTextModel"
>CLIPTextModel</a>.</li>
<li><strong>vision_model_output(<code>BaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/v4.39.3/en/model_doc/clip#transformers.CLIPVisionModel"
>CLIPVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.clip.modeling_clip.CLIPOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),T=new Ee({props:{$$slots:{default:[Ne]},$$scope:{ctx:W}}}),I=new Je({props:{anchor:"transformers.VisionTextDualEncoderModel.forward.example",$$slots:{default:[Pe]},$$scope:{ctx:W}}}),{c(){b(t.$$.fragment),d=l(),e=m("div"),b(n.$$.fragment),h=l(),s=m("p"),s.innerHTML=U,L=l(),k=m("p"),k.innerHTML=ne,Q=l(),E=m("p"),E.textContent=oe,S=l(),C=m("p"),C.innerHTML=q,z=l(),Z=m("p"),Z.innerHTML=te,X=l(),M=m("div"),b(G.$$.fragment),N=l(),B=m("p"),B.innerHTML=se,R=l(),b(T.$$.fragment),F=l(),b(I.$$.fragment),this.h()},l(r){v(t.$$.fragment,r),d=i(r),e=p(r,"DIV",{class:!0});var c=K(e);v(n.$$.fragment,c),h=i(c),s=p(c,"P",{"data-svelte-h":!0}),f(s)!=="svelte-1rlmd0d"&&(s.innerHTML=U),L=i(c),k=p(c,"P",{"data-svelte-h":!0}),f(k)!=="svelte-98iof6"&&(k.innerHTML=ne),Q=i(c),E=p(c,"P",{"data-svelte-h":!0}),f(E)!=="svelte-c2j1l6"&&(E.textContent=oe),S=i(c),C=p(c,"P",{"data-svelte-h":!0}),f(C)!=="svelte-8in0zq"&&(C.innerHTML=q),z=i(c),Z=p(c,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-hswkmf"&&(Z.innerHTML=te),X=i(c),M=p(c,"DIV",{class:!0});var g=K(M);v(G.$$.fragment,g),N=i(g),B=p(g,"P",{"data-svelte-h":!0}),f(B)!=="svelte-118oj7v"&&(B.innerHTML=se),R=i(g),v(T.$$.fragment,g),F=i(g),v(I.$$.fragment,g),g.forEach(u),c.forEach(u),this.h()},h(){ee(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(r,c){x(t,r,c),_(r,d,c),_(r,e,c),x(n,e,null),a(e,h),a(e,s),a(e,L),a(e,k),a(e,Q),a(e,E),a(e,S),a(e,C),a(e,z),a(e,Z),a(e,X),a(e,M),x(G,M,null),a(M,N),a(M,B),a(M,R),x(T,M,null),a(M,F),x(I,M,null),D=!0},p(r,c){const g={};c&2&&(g.$$scope={dirty:c,ctx:r}),T.$set(g);const Y={};c&2&&(Y.$$scope={dirty:c,ctx:r}),I.$set(Y)},i(r){D||(w(t.$$.fragment,r),w(n.$$.fragment,r),w(G.$$.fragment,r),w(T.$$.fragment,r),w(I.$$.fragment,r),D=!0)},o(r){j(t.$$.fragment,r),j(n.$$.fragment,r),j(G.$$.fragment,r),j(T.$$.fragment,r),j(I.$$.fragment,r),D=!1},d(r){r&&(u(d),u(e)),J(t,r),J(n),J(G),J(T),J(I)}}}function Le(W){let t,d;return t=new Ce({props:{$$slots:{default:[Ye]},$$scope:{ctx:W}}}),{c(){b(t.$$.fragment)},l(e){v(t.$$.fragment,e)},m(e,n){x(t,e,n),d=!0},p(e,n){const h={};n&2&&(h.$$scope={dirty:n,ctx:e}),t.$set(h)},i(e){d||(w(t.$$.fragment,e),d=!0)},o(e){j(t.$$.fragment,e),d=!1},d(e){J(t,e)}}}function Qe(W){let t,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=d},l(e){t=p(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-fincs2"&&(t.innerHTML=d)},m(e,n){_(e,t,n)},p:he,d(e){e&&u(t)}}}function Se(W){let t,d="Examples:",e,n,h;return n=new je({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    FlaxVisionTextDualEncoderModel,
<span class="hljs-meta">... </span>    VisionTextDualEncoderProcessor,
<span class="hljs-meta">... </span>    AutoImageProcessor,
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcesor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VisionTextDualEncoderProcessor(image_processor, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxVisionTextDualEncoderModel.from_vision_text_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># contrastive training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>urls = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://farm3.staticflickr.com/2674/5850229113_4fe05d5265_z.jpg&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw) <span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> urls]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=images, return_tensors=<span class="hljs-string">&quot;np&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    input_ids=inputs.input_ids,
<span class="hljs-meta">... </span>    attention_mask=inputs.attention_mask,
<span class="hljs-meta">... </span>    pixel_values=inputs.pixel_values,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save and load from pretrained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxVisionTextDualEncoderModel.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = jax.nn.softmax(logits_per_image, axis=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){t=m("p"),t.textContent=d,e=l(),b(n.$$.fragment)},l(s){t=p(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=d),e=i(s),v(n.$$.fragment,s)},m(s,U){_(s,t,U),_(s,e,U),x(n,s,U),h=!0},p:he,i(s){h||(w(n.$$.fragment,s),h=!0)},o(s){j(n.$$.fragment,s),h=!1},d(s){s&&(u(t),u(e)),J(n,s)}}}function qe(W){let t,d,e,n,h,s,U=`This class can be used to initialize a vision-text dual encoder model with any pretrained vision autoencoding model
as the vision encoder and any pretrained text model as the text encoder. The vision and text encoders are loaded
via the <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> method. The projection layers are automatically added to the model and
should be fine-tuned on a downstream task, like contrastive image-text modeling.`,L,k,ne=`In <a href="https://arxiv.org/abs/2111.07991" rel="nofollow">LiT: Zero-Shot Transfer with Locked-image Text Tuning</a> it is shown how
leveraging pre-trained (locked/frozen) image and text model for contrastive learning yields significant improvment
on new zero-shot vision tasks such as image classification or retrieval.`,Q,E,oe=`After such a Vision-Text-Dual-Encoder model has been trained/fine-tuned, it can be saved/loaded just like any other
models (see the examples for more information).`,S,C,q=`This model inherits from <a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,z,Z,te=`This model is also a
<a href="https://flax.readthedocs.io/en/latest/api_reference/flax.linen/module.html" rel="nofollow">flax.linen.Module</a> subclass. Use it
as a regular Flax linen Module and refer to the Flax documentation for all matter related to general usage and
behavior.`,X,M,G="Finally, this model supports inherent JAX features such as:",N,B,se='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',R,T,F,I,D,r='The <a href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.FlaxVisionTextDualEncoderModel">FlaxVisionTextDualEncoderModel</a> forward method, overrides the <code>__call__</code> special method.',c,g,Y,A,H;return t=new ue({props:{title:"FlaxVisionTextDualEncoderModel",local:"transformers.FlaxVisionTextDualEncoderModel",headingTag:"h2"}}),n=new ae({props:{name:"class transformers.FlaxVisionTextDualEncoderModel",anchor:"transformers.FlaxVisionTextDualEncoderModel",parameters:[{name:"config",val:": VisionTextDualEncoderConfig"},{name:"input_shape",val:": Optional = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxVisionTextDualEncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/vision_text_dual_encoder/modeling_flax_vision_text_dual_encoder.py#L219"}}),F=new ae({props:{name:"__call__",anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__",parameters:[{name:"input_ids",val:""},{name:"pixel_values",val:""},{name:"attention_mask",val:" = None"},{name:"position_ids",val:" = None"},{name:"token_type_ids",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.input_ids",description:`<strong>input_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.position_ids",description:`<strong>position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
an image processor (e.g. if you use ViT as the encoder, you should use <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>). See
<a href="/docs/transformers/v4.39.3/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.39.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/vision_text_dual_encoder/modeling_flax_vision_text_dual_encoder.py#L270",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.clip.modeling_flax_clip.FlaxCLIPOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig"
>VisionTextDualEncoderConfig</a>) and inputs.</p>
<ul>
<li><strong>logits_per_image:(<code>jnp.ndarray</code></strong> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text:(<code>jnp.ndarray</code></strong> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds(<code>jnp.ndarray</code></strong> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of
<a
  href="/docs/transformers/v4.39.3/en/model_doc/clip#transformers.FlaxCLIPTextModel"
>FlaxCLIPTextModel</a>.</li>
<li><strong>image_embeds(<code>jnp.ndarray</code></strong> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of
<a
  href="/docs/transformers/v4.39.3/en/model_doc/clip#transformers.FlaxCLIPVisionModel"
>FlaxCLIPVisionModel</a>.</li>
<li><strong>text_model_output(<code>FlaxBaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/v4.39.3/en/model_doc/clip#transformers.FlaxCLIPTextModel"
>FlaxCLIPTextModel</a>.</li>
<li><strong>vision_model_output(<code>FlaxBaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/v4.39.3/en/model_doc/clip#transformers.FlaxCLIPVisionModel"
>FlaxCLIPVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.clip.modeling_flax_clip.FlaxCLIPOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),g=new Ee({props:{$$slots:{default:[Qe]},$$scope:{ctx:W}}}),A=new Je({props:{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.example",$$slots:{default:[Se]},$$scope:{ctx:W}}}),{c(){b(t.$$.fragment),d=l(),e=m("div"),b(n.$$.fragment),h=l(),s=m("p"),s.innerHTML=U,L=l(),k=m("p"),k.innerHTML=ne,Q=l(),E=m("p"),E.textContent=oe,S=l(),C=m("p"),C.innerHTML=q,z=l(),Z=m("p"),Z.innerHTML=te,X=l(),M=m("p"),M.textContent=G,N=l(),B=m("ul"),B.innerHTML=se,R=l(),T=m("div"),b(F.$$.fragment),I=l(),D=m("p"),D.innerHTML=r,c=l(),b(g.$$.fragment),Y=l(),b(A.$$.fragment),this.h()},l(y){v(t.$$.fragment,y),d=i(y),e=p(y,"DIV",{class:!0});var V=K(e);v(n.$$.fragment,V),h=i(V),s=p(V,"P",{"data-svelte-h":!0}),f(s)!=="svelte-1rlmd0d"&&(s.innerHTML=U),L=i(V),k=p(V,"P",{"data-svelte-h":!0}),f(k)!=="svelte-98iof6"&&(k.innerHTML=ne),Q=i(V),E=p(V,"P",{"data-svelte-h":!0}),f(E)!=="svelte-c2j1l6"&&(E.textContent=oe),S=i(V),C=p(V,"P",{"data-svelte-h":!0}),f(C)!=="svelte-8in0zq"&&(C.innerHTML=q),z=i(V),Z=p(V,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1c8n49f"&&(Z.innerHTML=te),X=i(V),M=p(V,"P",{"data-svelte-h":!0}),f(M)!=="svelte-1pplc4a"&&(M.textContent=G),N=i(V),B=p(V,"UL",{"data-svelte-h":!0}),f(B)!=="svelte-1w7z84m"&&(B.innerHTML=se),R=i(V),T=p(V,"DIV",{class:!0});var P=K(T);v(F.$$.fragment,P),I=i(P),D=p(P,"P",{"data-svelte-h":!0}),f(D)!=="svelte-n06krl"&&(D.innerHTML=r),c=i(P),v(g.$$.fragment,P),Y=i(P),v(A.$$.fragment,P),P.forEach(u),V.forEach(u),this.h()},h(){ee(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(y,V){x(t,y,V),_(y,d,V),_(y,e,V),x(n,e,null),a(e,h),a(e,s),a(e,L),a(e,k),a(e,Q),a(e,E),a(e,S),a(e,C),a(e,z),a(e,Z),a(e,X),a(e,M),a(e,N),a(e,B),a(e,R),a(e,T),x(F,T,null),a(T,I),a(T,D),a(T,c),x(g,T,null),a(T,Y),x(A,T,null),H=!0},p(y,V){const P={};V&2&&(P.$$scope={dirty:V,ctx:y}),g.$set(P);const Te={};V&2&&(Te.$$scope={dirty:V,ctx:y}),A.$set(Te)},i(y){H||(w(t.$$.fragment,y),w(n.$$.fragment,y),w(F.$$.fragment,y),w(g.$$.fragment,y),w(A.$$.fragment,y),H=!0)},o(y){j(t.$$.fragment,y),j(n.$$.fragment,y),j(F.$$.fragment,y),j(g.$$.fragment,y),j(A.$$.fragment,y),H=!1},d(y){y&&(u(d),u(e)),J(t,y),J(n),J(F),J(g),J(A)}}}function Ae(W){let t,d;return t=new Ce({props:{$$slots:{default:[qe]},$$scope:{ctx:W}}}),{c(){b(t.$$.fragment)},l(e){v(t.$$.fragment,e)},m(e,n){x(t,e,n),d=!0},p(e,n){const h={};n&2&&(h.$$scope={dirty:n,ctx:e}),t.$set(h)},i(e){d||(w(t.$$.fragment,e),d=!0)},o(e){j(t.$$.fragment,e),d=!1},d(e){J(t,e)}}}function Oe(W){let t,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=d},l(e){t=p(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-fincs2"&&(t.innerHTML=d)},m(e,n){_(e,t,n)},p:he,d(e){e&&u(t)}}}function Ke(W){let t,d="Examples:",e,n,h;return n=new je({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    TFVisionTextDualEncoderModel,
<span class="hljs-meta">... </span>    VisionTextDualEncoderProcessor,
<span class="hljs-meta">... </span>    AutoImageProcessor,
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VisionTextDualEncoderProcessor(image_processor, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFVisionTextDualEncoderModel.from_vision_text_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># contrastive training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>urls = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://farm3.staticflickr.com/2674/5850229113_4fe05d5265_z.jpg&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw) <span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> urls]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=images, return_tensors=<span class="hljs-string">&quot;np&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    input_ids=inputs.input_ids,
<span class="hljs-meta">... </span>    attention_mask=inputs.attention_mask,
<span class="hljs-meta">... </span>    pixel_values=inputs.pixel_values,
<span class="hljs-meta">... </span>    return_loss=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, logits_per_image = outputs.loss, outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save and load from pretrained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFVisionTextDualEncoderModel.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = tf.nn.softmax(logits_per_image, axis=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){t=m("p"),t.textContent=d,e=l(),b(n.$$.fragment)},l(s){t=p(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=d),e=i(s),v(n.$$.fragment,s)},m(s,U){_(s,t,U),_(s,e,U),x(n,s,U),h=!0},p:he,i(s){h||(w(n.$$.fragment,s),h=!0)},o(s){j(n.$$.fragment,s),h=!1},d(s){s&&(u(t),u(e)),J(n,s)}}}function et(W){let t,d,e,n,h,s,U=`This class can be used to initialize a vision-text dual encoder model with any pretrained vision autoencoding model
as the vision encoder and any pretrained text model as the text encoder. The vision and text encoders are loaded
via the <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> method. The projection layers are automatically added to the model and
should be fine-tuned on a downstream task, like contrastive image-text modeling.`,L,k,ne=`In <a href="https://arxiv.org/abs/2111.07991" rel="nofollow">LiT: Zero-Shot Transfer with Locked-image Text Tuning</a> it is shown how
leveraging pre-trained (locked/frozen) image and text model for contrastive learning yields significant improvment
on new zero-shot vision tasks such as image classification or retrieval.`,Q,E,oe=`After such a Vision-Text-Dual-Encoder model has been trained/fine-tuned, it can be saved/loaded just like any other
models (see the examples for more information).`,S,C,q=`This model inherits from <a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,z,Z,te=`This model is also a Keras <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">Model</a> subclass. Use it as a
regular Keras Model and refer to the TF documentation for all matter related to general usage and behavior.`,X,M,G,N,B,se='The <a href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.TFVisionTextDualEncoderModel">TFVisionTextDualEncoderModel</a> forward method, overrides the <code>__call__</code> special method.',R,T,F,I,D;return t=new ue({props:{title:"TFVisionTextDualEncoderModel",local:"transformers.TFVisionTextDualEncoderModel",headingTag:"h2"}}),n=new ae({props:{name:"class transformers.TFVisionTextDualEncoderModel",anchor:"transformers.TFVisionTextDualEncoderModel",parameters:[{name:"config",val:": Optional[VisionTextDualEncoderConfig] = None"},{name:"vision_model",val:": Optional[TFPreTrainedModel] = None"},{name:"text_model",val:": Optional[TFPreTrainedModel] = None"}],parametersDescription:[{anchor:"transformers.TFVisionTextDualEncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.3/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderConfig">VisionEncoderDecoderConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/vision_text_dual_encoder/modeling_tf_vision_text_dual_encoder.py#L174"}}),G=new ae({props:{name:"call",anchor:"transformers.TFVisionTextDualEncoderModel.call",parameters:[{name:"input_ids",val:": tf.Tensor | None = None"},{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"attention_mask",val:": tf.Tensor | None = None"},{name:"position_ids",val:": tf.Tensor | None = None"},{name:"return_loss",val:": Optional[bool] = None"},{name:"token_type_ids",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFVisionTextDualEncoderModel.call.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
an image processor (e.g. if you use ViT as the encoder, you should use <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>). See
<a href="/docs/transformers/v4.39.3/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.39.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/vision_text_dual_encoder/modeling_tf_vision_text_dual_encoder.py#L346",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.clip.modeling_tf_clip.TFCLIPOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig"
>VisionTextDualEncoderConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image:(<code>tf.Tensor</code></strong> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text:(<code>tf.Tensor</code></strong> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds(<code>tf.Tensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/v4.39.3/en/model_doc/clip#transformers.TFCLIPTextModel"
>TFCLIPTextModel</a>.</li>
<li><strong>image_embeds(<code>tf.Tensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of
<a
  href="/docs/transformers/v4.39.3/en/model_doc/clip#transformers.TFCLIPVisionModel"
>TFCLIPVisionModel</a>.</li>
<li><strong>text_model_output(<code>~modeling_tf_utils.TFBaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/v4.39.3/en/model_doc/clip#transformers.TFCLIPTextModel"
>TFCLIPTextModel</a>.</li>
<li><strong>vision_model_output(<code>~modeling_tf_utils.TFBaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/v4.39.3/en/model_doc/clip#transformers.TFCLIPVisionModel"
>TFCLIPVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.clip.modeling_tf_clip.TFCLIPOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),T=new Ee({props:{$$slots:{default:[Oe]},$$scope:{ctx:W}}}),I=new Je({props:{anchor:"transformers.TFVisionTextDualEncoderModel.call.example",$$slots:{default:[Ke]},$$scope:{ctx:W}}}),{c(){b(t.$$.fragment),d=l(),e=m("div"),b(n.$$.fragment),h=l(),s=m("p"),s.innerHTML=U,L=l(),k=m("p"),k.innerHTML=ne,Q=l(),E=m("p"),E.textContent=oe,S=l(),C=m("p"),C.innerHTML=q,z=l(),Z=m("p"),Z.innerHTML=te,X=l(),M=m("div"),b(G.$$.fragment),N=l(),B=m("p"),B.innerHTML=se,R=l(),b(T.$$.fragment),F=l(),b(I.$$.fragment),this.h()},l(r){v(t.$$.fragment,r),d=i(r),e=p(r,"DIV",{class:!0});var c=K(e);v(n.$$.fragment,c),h=i(c),s=p(c,"P",{"data-svelte-h":!0}),f(s)!=="svelte-1rlmd0d"&&(s.innerHTML=U),L=i(c),k=p(c,"P",{"data-svelte-h":!0}),f(k)!=="svelte-98iof6"&&(k.innerHTML=ne),Q=i(c),E=p(c,"P",{"data-svelte-h":!0}),f(E)!=="svelte-c2j1l6"&&(E.textContent=oe),S=i(c),C=p(c,"P",{"data-svelte-h":!0}),f(C)!=="svelte-1bxyo9y"&&(C.innerHTML=q),z=i(c),Z=p(c,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-y4ylu0"&&(Z.innerHTML=te),X=i(c),M=p(c,"DIV",{class:!0});var g=K(M);v(G.$$.fragment,g),N=i(g),B=p(g,"P",{"data-svelte-h":!0}),f(B)!=="svelte-a0u20v"&&(B.innerHTML=se),R=i(g),v(T.$$.fragment,g),F=i(g),v(I.$$.fragment,g),g.forEach(u),c.forEach(u),this.h()},h(){ee(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(r,c){x(t,r,c),_(r,d,c),_(r,e,c),x(n,e,null),a(e,h),a(e,s),a(e,L),a(e,k),a(e,Q),a(e,E),a(e,S),a(e,C),a(e,z),a(e,Z),a(e,X),a(e,M),x(G,M,null),a(M,N),a(M,B),a(M,R),x(T,M,null),a(M,F),x(I,M,null),D=!0},p(r,c){const g={};c&2&&(g.$$scope={dirty:c,ctx:r}),T.$set(g);const Y={};c&2&&(Y.$$scope={dirty:c,ctx:r}),I.$set(Y)},i(r){D||(w(t.$$.fragment,r),w(n.$$.fragment,r),w(G.$$.fragment,r),w(T.$$.fragment,r),w(I.$$.fragment,r),D=!0)},o(r){j(t.$$.fragment,r),j(n.$$.fragment,r),j(G.$$.fragment,r),j(T.$$.fragment,r),j(I.$$.fragment,r),D=!1},d(r){r&&(u(d),u(e)),J(t,r),J(n),J(G),J(T),J(I)}}}function tt(W){let t,d;return t=new Ce({props:{$$slots:{default:[et]},$$scope:{ctx:W}}}),{c(){b(t.$$.fragment)},l(e){v(t.$$.fragment,e)},m(e,n){x(t,e,n),d=!0},p(e,n){const h={};n&2&&(h.$$scope={dirty:n,ctx:e}),t.$set(h)},i(e){d||(w(t.$$.fragment,e),d=!0)},o(e){j(t.$$.fragment,e),d=!1},d(e){J(t,e)}}}function st(W){let t,d,e,n,h,s,U,L,k,ne=`The <a href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> can be used to initialize a vision-text dual encoder model with
any pretrained vision autoencoding model as the vision encoder (<em>e.g.</em> <a href="vit">ViT</a>, <a href="beit">BEiT</a>, <a href="deit">DeiT</a>) and any pretrained text autoencoding model as the text encoder (<em>e.g.</em> <a href="roberta">RoBERTa</a>, <a href="bert">BERT</a>). Two projection layers are added on top of both the vision and text encoder to project the output embeddings
to a shared latent space. The projection layers are randomly initialized so the model should be fine-tuned on a
downstream task. This model can be used to align the vision-text embeddings using CLIP like contrastive image-text
training and then can be used for zero-shot vision tasks such image-classification or retrieval.`,Q,E,oe=`In <a href="https://arxiv.org/abs/2111.07991" rel="nofollow">LiT: Zero-Shot Transfer with Locked-image Text Tuning</a> it is shown how
leveraging pre-trained (locked/frozen) image and text model for contrastive learning yields significant improvement on
new zero-shot vision tasks such as image classification or retrieval.`,S,C,q,z,Z,te,X,M=`<a href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> is the configuration class to store the configuration of a
<a href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a>. It is used to instantiate <a href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> model according to the
specified arguments, defining the text model and vision model configs.`,G,N,B=`Configuration objects inherit from <a href="/docs/transformers/v4.39.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.39.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,se,R,T,F,I,D,r,c=`Instantiate a <a href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> (or a derived class) from text model configuration and vision
model configuration.`,g,Y,A,H,y,V,P,Te=`Constructs a VisionTextDualEncoder processor which wraps an image processor and a tokenizer into a single
processor.`,Ue,ge,Ze=`<a href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderProcessor">VisionTextDualEncoderProcessor</a> offers all the functionalities of <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> and <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>.
See the <code>__call__()</code> and <a href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderProcessor.decode">decode()</a> for more
information.`,Ve,le,ce,$e,fe,ze=`This method forwards all its arguments to VisionTextDualEncoderTokenizer’s
<a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please refer to the docstring of this method for more information.`,Ie,ie,me,ke,Me,We=`This method forwards all its arguments to VisionTextDualEncoderTokenizer’s <a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>.
Please refer to the docstring of this method for more information.`,ye,de,be,_e,ve;return h=new ue({props:{title:"VisionTextDualEncoder",local:"visiontextdualencoder",headingTag:"h1"}}),U=new ue({props:{title:"Overview",local:"overview",headingTag:"h2"}}),C=new ue({props:{title:"VisionTextDualEncoderConfig",local:"transformers.VisionTextDualEncoderConfig",headingTag:"h2"}}),Z=new ae({props:{name:"class transformers.VisionTextDualEncoderConfig",anchor:"transformers.VisionTextDualEncoderConfig",parameters:[{name:"projection_dim",val:" = 512"},{name:"logit_scale_init_value",val:" = 2.6592"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VisionTextDualEncoderConfig.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimentionality of text and vision projection layers.`,name:"projection_dim"},{anchor:"transformers.VisionTextDualEncoderConfig.logit_scale_init_value",description:`<strong>logit_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 2.6592) &#x2014;
The inital value of the <em>logit_scale</em> paramter. Default is used as per the original CLIP implementation.`,name:"logit_scale_init_value"},{anchor:"transformers.VisionTextDualEncoderConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/vision_text_dual_encoder/configuration_vision_text_dual_encoder.py#L35"}}),R=new Je({props:{anchor:"transformers.VisionTextDualEncoderConfig.example",$$slots:{default:[Xe]},$$scope:{ctx:W}}}),I=new ae({props:{name:"from_vision_text_configs",anchor:"transformers.VisionTextDualEncoderConfig.from_vision_text_configs",parameters:[{name:"vision_config",val:": PretrainedConfig"},{name:"text_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/vision_text_dual_encoder/configuration_vision_text_dual_encoder.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.39.3/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig"
>VisionTextDualEncoderConfig</a></p>
`}}),Y=new ue({props:{title:"VisionTextDualEncoderProcessor",local:"transformers.VisionTextDualEncoderProcessor",headingTag:"h2"}}),y=new ae({props:{name:"class transformers.VisionTextDualEncoderProcessor",anchor:"transformers.VisionTextDualEncoderProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VisionTextDualEncoderProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.VisionTextDualEncoderProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/v4.39.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/vision_text_dual_encoder/processing_vision_text_dual_encoder.py#L25"}}),ce=new ae({props:{name:"batch_decode",anchor:"transformers.VisionTextDualEncoderProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/vision_text_dual_encoder/processing_vision_text_dual_encoder.py#L117"}}),me=new ae({props:{name:"decode",anchor:"transformers.VisionTextDualEncoderProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/vision_text_dual_encoder/processing_vision_text_dual_encoder.py#L124"}}),de=new He({props:{pytorch:!0,tensorflow:!0,jax:!0,$$slots:{jax:[tt],tensorflow:[Ae],pytorch:[Le]},$$scope:{ctx:W}}}),{c(){t=m("meta"),d=l(),e=m("p"),n=l(),b(h.$$.fragment),s=l(),b(U.$$.fragment),L=l(),k=m("p"),k.innerHTML=ne,Q=l(),E=m("p"),E.innerHTML=oe,S=l(),b(C.$$.fragment),q=l(),z=m("div"),b(Z.$$.fragment),te=l(),X=m("p"),X.innerHTML=M,G=l(),N=m("p"),N.innerHTML=B,se=l(),b(R.$$.fragment),T=l(),F=m("div"),b(I.$$.fragment),D=l(),r=m("p"),r.innerHTML=c,g=l(),b(Y.$$.fragment),A=l(),H=m("div"),b(y.$$.fragment),V=l(),P=m("p"),P.textContent=Te,Ue=l(),ge=m("p"),ge.innerHTML=Ze,Ve=l(),le=m("div"),b(ce.$$.fragment),$e=l(),fe=m("p"),fe.innerHTML=ze,Ie=l(),ie=m("div"),b(me.$$.fragment),ke=l(),Me=m("p"),Me.innerHTML=We,ye=l(),b(de.$$.fragment),be=l(),_e=m("p"),this.h()},l(o){const $=De("svelte-u9bgzb",document.head);t=p($,"META",{name:!0,content:!0}),$.forEach(u),d=i(o),e=p(o,"P",{}),K(e).forEach(u),n=i(o),v(h.$$.fragment,o),s=i(o),v(U.$$.fragment,o),L=i(o),k=p(o,"P",{"data-svelte-h":!0}),f(k)!=="svelte-l5d0q4"&&(k.innerHTML=ne),Q=i(o),E=p(o,"P",{"data-svelte-h":!0}),f(E)!=="svelte-8axln3"&&(E.innerHTML=oe),S=i(o),v(C.$$.fragment,o),q=i(o),z=p(o,"DIV",{class:!0});var O=K(z);v(Z.$$.fragment,O),te=i(O),X=p(O,"P",{"data-svelte-h":!0}),f(X)!=="svelte-y10odj"&&(X.innerHTML=M),G=i(O),N=p(O,"P",{"data-svelte-h":!0}),f(N)!=="svelte-fgm5f9"&&(N.innerHTML=B),se=i(O),v(R.$$.fragment,O),T=i(O),F=p(O,"DIV",{class:!0});var pe=K(F);v(I.$$.fragment,pe),D=i(pe),r=p(pe,"P",{"data-svelte-h":!0}),f(r)!=="svelte-fvust4"&&(r.innerHTML=c),pe.forEach(u),O.forEach(u),g=i(o),v(Y.$$.fragment,o),A=i(o),H=p(o,"DIV",{class:!0});var re=K(H);v(y.$$.fragment,re),V=i(re),P=p(re,"P",{"data-svelte-h":!0}),f(P)!=="svelte-c5g5w0"&&(P.textContent=Te),Ue=i(re),ge=p(re,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-3amwav"&&(ge.innerHTML=Ze),Ve=i(re),le=p(re,"DIV",{class:!0});var xe=K(le);v(ce.$$.fragment,xe),$e=i(xe),fe=p(xe,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-uwhevs"&&(fe.innerHTML=ze),xe.forEach(u),Ie=i(re),ie=p(re,"DIV",{class:!0});var we=K(ie);v(me.$$.fragment,we),ke=i(we),Me=p(we,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-9a1pre"&&(Me.innerHTML=We),we.forEach(u),re.forEach(u),ye=i(o),v(de.$$.fragment,o),be=i(o),_e=p(o,"P",{}),K(_e).forEach(u),this.h()},h(){ee(t,"name","hf:doc:metadata"),ee(t,"content",nt),ee(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(o,$){a(document.head,t),_(o,d,$),_(o,e,$),_(o,n,$),x(h,o,$),_(o,s,$),x(U,o,$),_(o,L,$),_(o,k,$),_(o,Q,$),_(o,E,$),_(o,S,$),x(C,o,$),_(o,q,$),_(o,z,$),x(Z,z,null),a(z,te),a(z,X),a(z,G),a(z,N),a(z,se),x(R,z,null),a(z,T),a(z,F),x(I,F,null),a(F,D),a(F,r),_(o,g,$),x(Y,o,$),_(o,A,$),_(o,H,$),x(y,H,null),a(H,V),a(H,P),a(H,Ue),a(H,ge),a(H,Ve),a(H,le),x(ce,le,null),a(le,$e),a(le,fe),a(H,Ie),a(H,ie),x(me,ie,null),a(ie,ke),a(ie,Me),_(o,ye,$),x(de,o,$),_(o,be,$),_(o,_e,$),ve=!0},p(o,[$]){const O={};$&2&&(O.$$scope={dirty:$,ctx:o}),R.$set(O);const pe={};$&2&&(pe.$$scope={dirty:$,ctx:o}),de.$set(pe)},i(o){ve||(w(h.$$.fragment,o),w(U.$$.fragment,o),w(C.$$.fragment,o),w(Z.$$.fragment,o),w(R.$$.fragment,o),w(I.$$.fragment,o),w(Y.$$.fragment,o),w(y.$$.fragment,o),w(ce.$$.fragment,o),w(me.$$.fragment,o),w(de.$$.fragment,o),ve=!0)},o(o){j(h.$$.fragment,o),j(U.$$.fragment,o),j(C.$$.fragment,o),j(Z.$$.fragment,o),j(R.$$.fragment,o),j(I.$$.fragment,o),j(Y.$$.fragment,o),j(y.$$.fragment,o),j(ce.$$.fragment,o),j(me.$$.fragment,o),j(de.$$.fragment,o),ve=!1},d(o){o&&(u(d),u(e),u(n),u(s),u(L),u(k),u(Q),u(E),u(S),u(q),u(z),u(g),u(A),u(H),u(ye),u(be),u(_e)),u(t),J(h,o),J(U,o),J(C,o),J(Z),J(R),J(I),J(Y,o),J(y),J(ce),J(me),J(de,o)}}}const nt='{"title":"VisionTextDualEncoder","local":"visiontextdualencoder","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"VisionTextDualEncoderConfig","local":"transformers.VisionTextDualEncoderConfig","sections":[],"depth":2},{"title":"VisionTextDualEncoderProcessor","local":"transformers.VisionTextDualEncoderProcessor","sections":[],"depth":2},{"title":"VisionTextDualEncoderModel","local":"transformers.VisionTextDualEncoderModel","sections":[],"depth":2},{"title":"FlaxVisionTextDualEncoderModel","local":"transformers.FlaxVisionTextDualEncoderModel","sections":[],"depth":2},{"title":"TFVisionTextDualEncoderModel","local":"transformers.TFVisionTextDualEncoderModel","sections":[],"depth":2}],"depth":1}';function ot(W){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ut extends Ge{constructor(t){super(),Re(this,t,ot,st,Fe,{})}}export{ut as component};
