import{s as Ss,n as Ps,o as As}from"../chunks/scheduler.9bc65507.js";import{S as Ds,i as Ls,g as i,s as l,r,A as Ks,h as o,f as e,c as n,j as Xs,u as c,x as p,k as $s,y as Os,a,v as m,d as g,t as h,w as f}from"../chunks/index.707bf1b6.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";import{D as st}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as Cs}from"../chunks/Heading.342b1fa6.js";function tt(vs){let u,P,X,A,j,D,M,L,x,ks=`Zero-shot image classification is a task that involves classifying images into different categories using a model that was
not explicitly trained on data containing labeled examples from those specific categories.`,K,w,Zs=`Traditionally, image classification requires training a model on a specific set of labeled images, and this model learns to
“map” certain image features to labels. When there’s a need to use such model for a classification task that introduces a
new set of labels, fine-tuning is required to “recalibrate” the model.`,O,J,_s=`In contrast, zero-shot or open vocabulary image classification models are typically multi-modal models that have been trained on a large
dataset of images and associated descriptions. These models learn aligned vision-language representations that can be used for many downstream tasks including zero-shot image classification.`,ss,T,Rs=`This is a more flexible approach to image classification that allows models to generalize to new and unseen categories
without the need for additional training data and enables users to query images with free-form text descriptions of their target objects .`,ts,U,zs="In this guide you’ll learn how to:",es,$,Gs="<li>create a zero-shot image classification pipeline</li> <li>run zero-shot image classification inference by hand</li>",as,C,Is="Before you begin, make sure you have all the necessary libraries installed:",ls,v,ns,k,is,Z,Ws=`The simplest way to try out inference with a model supporting zero-shot image classification is to use the corresponding <a href="/docs/transformers/v4.37.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>.
Instantiate a pipeline from a <a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>:`,os,_,ps,R,Es="Next, choose an image you’d like to classify.",rs,z,cs,d,Bs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/owl.jpg" alt="Photo of an owl"/>',ms,G,Hs=`Pass the image and the candidate object labels to the pipeline. Here we pass the image directly; other suitable options
include a local path to an image or an image url.
The candidate labels can be simple words like in this example, or more descriptive.`,gs,I,hs,W,fs,E,Ns=`Now that you’ve seen how to use the zero-shot image classification pipeline, let’s take a look how you can run zero-shot
image classification manually.`,us,B,Ys=`Start by loading the model and associated processor from a <a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>.
Here we’ll use the same checkpoint as before:`,ds,H,bs,N,qs="Let’s take a different image to switch things up.",ys,Y,js,b,Fs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/car.jpg" alt="Photo of a car"/>',Ms,q,Qs=`Use the processor to prepare the inputs for the model. The processor combines an image processor that prepares the
image for the model by resizing and normalizing it, and a tokenizer that takes care of the text inputs.`,xs,F,ws,Q,Vs="Pass the inputs through the model, and post-process the results:",Js,V,Ts,S,Us;return j=new Cs({props:{title:"Zero-shot image classification",local:"zero-shot-image-classification",headingTag:"h1"}}),M=new st({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/zero_shot_image_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/zero_shot_image_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/zero_shot_image_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/zero_shot_image_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/zero_shot_image_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/zero_shot_image_classification.ipynb"}]}}),v=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),k=new Cs({props:{title:"Zero-shot image classification pipeline",local:"zero-shot-image-classification-pipeline",headingTag:"h2"}}),_=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm9wZW5haSUyRmNsaXAtdml0LWxhcmdlLXBhdGNoMTQlMjIlMEFkZXRlY3RvciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEY2hlY2twb2ludCUyQyUyMHRhc2slM0QlMjJ6ZXJvLXNob3QtaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;zero-shot-image-classification&quot;</span>)`,wrap:!1}}),z=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRmc4b1M4LTgyRHhJJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4MGIzQnBZM3g4U25Cbk5rdHBaR3d0U0d0OGZIeDhmREo4ZkRFMk56Z3hNRFl3T0RjJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/g8oS8-82DxI/download?ixid=MnwxMjA3fDB8MXx0b3BpY3x8SnBnNktpZGwtSGt8fHx8fDJ8fDE2NzgxMDYwODc&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),I=new y({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXRlY3RvcihpbWFnZSUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJmb3glMjIlMkMlMjAlMjJiZWFyJTIyJTJDJTIwJTIyc2VhZ3VsbCUyMiUyQyUyMCUyMm93bCUyMiU1RCklMEFwcmVkaWN0aW9ucw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = detector(image, candidate_labels=[<span class="hljs-string">&quot;fox&quot;</span>, <span class="hljs-string">&quot;bear&quot;</span>, <span class="hljs-string">&quot;seagull&quot;</span>, <span class="hljs-string">&quot;owl&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>predictions
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9996670484542847</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;owl&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.000199399160919711</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;seagull&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">7.392891711788252e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fox&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">5.96074532950297e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bear&#x27;</span>}]`,wrap:!1}}),W=new Cs({props:{title:"Zero-shot image classification by hand",local:"zero-shot-image-classification-by-hand",headingTag:"h2"}}),H=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),Y=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRnhCUlFmUjJicU5JJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4aGJHeDhmSHg4Zkh4OGZId3hOamM0TXpnNE9ERXglMjZmb3JjZSUzRHRydWUlMjZ3JTNENjQwJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/xBRQfR2bqNI/download?ixid=MnwxMjA3fDB8MXxhbGx8fHx8fHx8fHwxNjc4Mzg4ODEx&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),F=new y({props:{code:"Y2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMnRyZWUlMjIlMkMlMjAlMjJjYXIlMjIlMkMlMjAlMjJiaWtlJTIyJTJDJTIwJTIyY2F0JTIyJTVEJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdGV4dCUzRGNhbmRpZGF0ZV9sYWJlbHMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;tree&quot;</span>, <span class="hljs-string">&quot;car&quot;</span>, <span class="hljs-string">&quot;bike&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=candidate_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)`,wrap:!1}}),V=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzX3Blcl9pbWFnZSU1QjAlNUQlMEFwcm9icyUyMCUzRCUyMGxvZ2l0cy5zb2Z0bWF4KGRpbSUzRC0xKS5udW1weSgpJTBBc2NvcmVzJTIwJTNEJTIwcHJvYnMudG9saXN0KCklMEElMEFyZXN1bHQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMHNjb3JlJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBjYW5kaWRhdGVfbGFiZWwlN0QlMEElMjAlMjAlMjAlMjBmb3IlMjBzY29yZSUyQyUyMGNhbmRpZGF0ZV9sYWJlbCUyMGluJTIwc29ydGVkKHppcChwcm9icyUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMpJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMC14JTVCMCU1RCklMEElNUQlMEElMEFyZXN1bHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits_per_image[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits.softmax(dim=-<span class="hljs-number">1</span>).numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>scores = probs.tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span>result = [
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;label&quot;</span>: candidate_label}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> score, candidate_label <span class="hljs-keyword">in</span> <span class="hljs-built_in">sorted</span>(<span class="hljs-built_in">zip</span>(probs, candidate_labels), key=<span class="hljs-keyword">lambda</span> x: -x[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>result
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.998572</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;car&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0010570387</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bike&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0003393686</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tree&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">3.1572064e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>}]`,wrap:!1}}),{c(){u=i("meta"),P=l(),X=i("p"),A=l(),r(j.$$.fragment),D=l(),r(M.$$.fragment),L=l(),x=i("p"),x.textContent=ks,K=l(),w=i("p"),w.textContent=Zs,O=l(),J=i("p"),J.textContent=_s,ss=l(),T=i("p"),T.textContent=Rs,ts=l(),U=i("p"),U.textContent=zs,es=l(),$=i("ul"),$.innerHTML=Gs,as=l(),C=i("p"),C.textContent=Is,ls=l(),r(v.$$.fragment),ns=l(),r(k.$$.fragment),is=l(),Z=i("p"),Z.innerHTML=Ws,os=l(),r(_.$$.fragment),ps=l(),R=i("p"),R.textContent=Es,rs=l(),r(z.$$.fragment),cs=l(),d=i("div"),d.innerHTML=Bs,ms=l(),G=i("p"),G.textContent=Hs,gs=l(),r(I.$$.fragment),hs=l(),r(W.$$.fragment),fs=l(),E=i("p"),E.textContent=Ns,us=l(),B=i("p"),B.innerHTML=Ys,ds=l(),r(H.$$.fragment),bs=l(),N=i("p"),N.textContent=qs,ys=l(),r(Y.$$.fragment),js=l(),b=i("div"),b.innerHTML=Fs,Ms=l(),q=i("p"),q.textContent=Qs,xs=l(),r(F.$$.fragment),ws=l(),Q=i("p"),Q.textContent=Vs,Js=l(),r(V.$$.fragment),Ts=l(),S=i("p"),this.h()},l(s){const t=Ks("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(e),P=n(s),X=o(s,"P",{}),Xs(X).forEach(e),A=n(s),c(j.$$.fragment,s),D=n(s),c(M.$$.fragment,s),L=n(s),x=o(s,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1epp0bd"&&(x.textContent=ks),K=n(s),w=o(s,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1cxdsqr"&&(w.textContent=Zs),O=n(s),J=o(s,"P",{"data-svelte-h":!0}),p(J)!=="svelte-162gw8s"&&(J.textContent=_s),ss=n(s),T=o(s,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1e19xpt"&&(T.textContent=Rs),ts=n(s),U=o(s,"P",{"data-svelte-h":!0}),p(U)!=="svelte-jr2b5g"&&(U.textContent=zs),es=n(s),$=o(s,"UL",{"data-svelte-h":!0}),p($)!=="svelte-d1jtl1"&&($.innerHTML=Gs),as=n(s),C=o(s,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1c9nexd"&&(C.textContent=Is),ls=n(s),c(v.$$.fragment,s),ns=n(s),c(k.$$.fragment,s),is=n(s),Z=o(s,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-ik964u"&&(Z.innerHTML=Ws),os=n(s),c(_.$$.fragment,s),ps=n(s),R=o(s,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1de5ng0"&&(R.textContent=Es),rs=n(s),c(z.$$.fragment,s),cs=n(s),d=o(s,"DIV",{class:!0,"data-svelte-h":!0}),p(d)!=="svelte-10yxso1"&&(d.innerHTML=Bs),ms=n(s),G=o(s,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1ufa490"&&(G.textContent=Hs),gs=n(s),c(I.$$.fragment,s),hs=n(s),c(W.$$.fragment,s),fs=n(s),E=o(s,"P",{"data-svelte-h":!0}),p(E)!=="svelte-8eyj4j"&&(E.textContent=Ns),us=n(s),B=o(s,"P",{"data-svelte-h":!0}),p(B)!=="svelte-2afjdk"&&(B.innerHTML=Ys),ds=n(s),c(H.$$.fragment,s),bs=n(s),N=o(s,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1g7c1zc"&&(N.textContent=qs),ys=n(s),c(Y.$$.fragment,s),js=n(s),b=o(s,"DIV",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-1kfxibh"&&(b.innerHTML=Fs),Ms=n(s),q=o(s,"P",{"data-svelte-h":!0}),p(q)!=="svelte-17gc4h7"&&(q.textContent=Qs),xs=n(s),c(F.$$.fragment,s),ws=n(s),Q=o(s,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-n1saee"&&(Q.textContent=Vs),Js=n(s),c(V.$$.fragment,s),Ts=n(s),S=o(s,"P",{}),Xs(S).forEach(e),this.h()},h(){$s(u,"name","hf:doc:metadata"),$s(u,"content",et),$s(d,"class","flex justify-center"),$s(b,"class","flex justify-center")},m(s,t){Os(document.head,u),a(s,P,t),a(s,X,t),a(s,A,t),m(j,s,t),a(s,D,t),m(M,s,t),a(s,L,t),a(s,x,t),a(s,K,t),a(s,w,t),a(s,O,t),a(s,J,t),a(s,ss,t),a(s,T,t),a(s,ts,t),a(s,U,t),a(s,es,t),a(s,$,t),a(s,as,t),a(s,C,t),a(s,ls,t),m(v,s,t),a(s,ns,t),m(k,s,t),a(s,is,t),a(s,Z,t),a(s,os,t),m(_,s,t),a(s,ps,t),a(s,R,t),a(s,rs,t),m(z,s,t),a(s,cs,t),a(s,d,t),a(s,ms,t),a(s,G,t),a(s,gs,t),m(I,s,t),a(s,hs,t),m(W,s,t),a(s,fs,t),a(s,E,t),a(s,us,t),a(s,B,t),a(s,ds,t),m(H,s,t),a(s,bs,t),a(s,N,t),a(s,ys,t),m(Y,s,t),a(s,js,t),a(s,b,t),a(s,Ms,t),a(s,q,t),a(s,xs,t),m(F,s,t),a(s,ws,t),a(s,Q,t),a(s,Js,t),m(V,s,t),a(s,Ts,t),a(s,S,t),Us=!0},p:Ps,i(s){Us||(g(j.$$.fragment,s),g(M.$$.fragment,s),g(v.$$.fragment,s),g(k.$$.fragment,s),g(_.$$.fragment,s),g(z.$$.fragment,s),g(I.$$.fragment,s),g(W.$$.fragment,s),g(H.$$.fragment,s),g(Y.$$.fragment,s),g(F.$$.fragment,s),g(V.$$.fragment,s),Us=!0)},o(s){h(j.$$.fragment,s),h(M.$$.fragment,s),h(v.$$.fragment,s),h(k.$$.fragment,s),h(_.$$.fragment,s),h(z.$$.fragment,s),h(I.$$.fragment,s),h(W.$$.fragment,s),h(H.$$.fragment,s),h(Y.$$.fragment,s),h(F.$$.fragment,s),h(V.$$.fragment,s),Us=!1},d(s){s&&(e(P),e(X),e(A),e(D),e(L),e(x),e(K),e(w),e(O),e(J),e(ss),e(T),e(ts),e(U),e(es),e($),e(as),e(C),e(ls),e(ns),e(is),e(Z),e(os),e(ps),e(R),e(rs),e(cs),e(d),e(ms),e(G),e(gs),e(hs),e(fs),e(E),e(us),e(B),e(ds),e(bs),e(N),e(ys),e(js),e(b),e(Ms),e(q),e(xs),e(ws),e(Q),e(Js),e(Ts),e(S)),e(u),f(j,s),f(M,s),f(v,s),f(k,s),f(_,s),f(z,s),f(I,s),f(W,s),f(H,s),f(Y,s),f(F,s),f(V,s)}}}const et='{"title":"Zero-shot image classification","local":"zero-shot-image-classification","sections":[{"title":"Zero-shot image classification pipeline","local":"zero-shot-image-classification-pipeline","sections":[],"depth":2},{"title":"Zero-shot image classification by hand","local":"zero-shot-image-classification-by-hand","sections":[],"depth":2}],"depth":1}';function at(vs){return As(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rt extends Ds{constructor(u){super(),Ls(this,u,at,tt,Ss,{})}}export{rt as component};
