import{s as Cl,n as _l,o as $l}from"../chunks/scheduler.9bc65507.js";import{S as Zl,i as kl,g as i,s as l,u as o,A as Vl,h as p,f as t,c as n,j as b,v as h,y as r,k as c,o as f,a,w as m,d,t as u,x as g}from"../chunks/index.78c82d43.js";import{I as is}from"../chunks/IconCopyLink.bedaa44d.js";import{C as y}from"../chunks/CodeBlock.48618ec2.js";import{D as Il}from"../chunks/DocNotebookDropdown.40f7599b.js";function Gl(ma){let M,Js,us,xs,j,C,gs,X,na,ps,da="Visual Question Answering",Ts,Q,Us,H,ua=`Visual Question Answering (VQA) is the task of answering open-ended questions based on an image.
The input to models supporting this task is typically a combination of an image and a question, and the output is an
answer expressed in natural language.`,Cs,R,ga="Some noteworthy use case examples for VQA include:",_s,N,fa="<li>Accessibility applications for visually impaired individuals.</li> <li>Education: posing questions about visual materials presented in lectures or textbooks. VQA can also be utilized in interactive museum exhibits or historical sites.</li> <li>Customer service and e-commerce: VQA can enhance user experience by letting users ask questions about products.</li> <li>Image retrieval: VQA models can be used to retrieve images with specific characteristics. For example, the user can ask “Is there a dog?” to find all images with dogs from a set of images.</li>",$s,F,ya="In this guide you’ll learn how to:",Zs,A,ba='<li>Fine-tune a classification VQA model, specifically <a href="../model_doc/vilt">ViLT</a>, on the <a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow"><code>Graphcore/vqa</code> dataset</a>.</li> <li>Use your fine-tuned ViLT for inference.</li> <li>Run zero-shot VQA inference with a generative model, like BLIP-2.</li>',ks,w,_,fs,E,ia,rs,Ma="Fine-tuning ViLT",Vs,z,ja=`ViLT model incorporates text embeddings into a Vision Transformer (ViT), allowing it to have a minimal design for
Vision-and-Language Pre-training (VLP). This model can be used for several downstream tasks. For the VQA task, a classifier
head is placed on top (a linear layer on top of the final hidden state of the <code>[CLS]</code> token) and randomly initialized.
Visual Question Answering is thus treated as a <strong>classification problem</strong>.`,Is,q,wa=`More recent models, such as BLIP, BLIP-2, and InstructBLIP, treat VQA as a generative task. Later in this guide we
illustrate how to use them for zero-shot VQA inference.`,Gs,Y,va="Before you begin, make sure you have all the necessary libraries installed.",Ws,L,Bs,S,Ja=`We encourage you to share your model with the community. Log in to your Hugging Face account to upload it to the 🤗 Hub.
When prompted, enter your token to log in:`,Xs,P,Qs,D,xa="Let’s define the model checkpoint as a global variable.",Hs,K,Rs,v,$,ys,O,pa,os,Ta="Load the data",Ns,ee,Ua=`For illustration purposes, in this guide we use a very small sample of the annotated visual question answering <code>Graphcore/vqa</code> dataset.
You can find the full dataset on <a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow">🤗 Hub</a>.`,Fs,se,Ca=`As an alternative to the <a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow"><code>Graphcore/vqa</code> dataset</a>, you can download the
same data manually from the official <a href="https://visualqa.org/download.html" rel="nofollow">VQA dataset page</a>. If you prefer to follow the
tutorial with your custom data, check out how to <a href="https://huggingface.co/docs/datasets/image_dataset#loading-script" rel="nofollow">Create an image dataset</a>
guide in the 🤗 Datasets documentation.`,As,te,_a="Let’s load the first 200 examples from the validation split and explore the dataset’s features:",Es,ae,zs,le,$a="Let’s take a look at an example to understand the dataset’s features:",qs,ne,Ys,ie,Za="The features relevant to the task include:",Ls,pe,ka="<li><code>question</code>: the question to be answered from the image</li> <li><code>image_id</code>: the path to the image the question refers to</li> <li><code>label</code>: the annotations</li>",Ss,re,Va="We can remove the rest of the features as they won’t be necessary:",Ps,oe,Ds,he,Ia=`As you can see, the <code>label</code> feature contains several answers to the same question (called <code>ids</code> here) collected by different human annotators.
This is because the answer to a question can be subjective. In this case, the question is “where is he looking?“. Some people
annotated this with “down”, others with “at table”, another one with “skateboard”, etc.`,Ks,ce,Ga="Take a look at the image and consider which answer would you give:",Os,me,et,Z,Wa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/vqa-example.png" alt="VQA Image Example"/>',st,de,Ba=`Due to the questions’ and answers’ ambiguity, datasets like this are treated as a multi-label classification problem (as
multiple answers are possibly valid). Moreover, rather than just creating a one-hot encoded vector, one creates a
soft encoding, based on the number of times a certain answer appeared in the annotations.`,tt,ue,Xa=`For instance, in the example above, because the answer “down” is selected way more often than other answers, it has a
score (called <code>weight</code> in the dataset) of 1.0, and the rest of the answers have scores &lt; 1.0.`,at,ge,Qa=`To later instantiate the model with an appropriate classification head, let’s create two dictionaries: one that maps
the label name to an integer and vice versa:`,lt,fe,nt,ye,Ha="Now that we have the mappings, we can replace the string answers with their ids, and flatten the dataset for a more convenient further preprocessing.",it,be,pt,J,k,bs,Me,ra,hs,Ra="Preprocessing data",rt,je,Na=`The next step is to load a ViLT processor to prepare the image and text data for the model.
<a href="/docs/transformers/v4.33.3/en/model_doc/vilt#transformers.ViltProcessor">ViltProcessor</a> wraps a BERT tokenizer and ViLT image processor into a convenient single processor:`,ot,we,ht,ve,Fa=`To preprocess the data we need to encode the images and questions using the <a href="/docs/transformers/v4.33.3/en/model_doc/vilt#transformers.ViltProcessor">ViltProcessor</a>. The processor will use
the <a href="/docs/transformers/v4.33.3/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> to tokenize the text and create <code>input_ids</code>, <code>attention_mask</code> and <code>token_type_ids</code> for the text data.
As for images, the processor will leverage <a href="/docs/transformers/v4.33.3/en/model_doc/vilt#transformers.ViltImageProcessor">ViltImageProcessor</a> to resize and normalize the image, and create <code>pixel_values</code> and <code>pixel_mask</code>.`,ct,Je,Aa=`All these preprocessing steps are done under the hood, we only need to call the <code>processor</code>. However, we still need to
prepare the target labels. In this representation, each element corresponds to a possible answer (label). For correct answers, the element holds
their respective score (weight), while the remaining elements are set to zero.`,mt,xe,Ea="The following function applies the <code>processor</code> to the images and questions and formats the labels as described above:",dt,Te,ut,Ue,za=`To apply the preprocessing function over the entire dataset, use 🤗 Datasets <code>map</code> function. You can speed up <code>map</code> by
setting <code>batched=True</code> to process multiple elements of the dataset at once. At this point, feel free to remove the columns you don’t need.`,gt,Ce,ft,_e,qa='As a final step, create a batch of examples using <a href="/docs/transformers/v4.33.3/en/main_classes/data_collator#transformers.DefaultDataCollator">DefaultDataCollator</a>:',yt,$e,bt,x,V,Ms,Ze,oa,cs,Ya="Train the model",Mt,ke,La=`You’re ready to start training your model now! Load ViLT with <a href="/docs/transformers/v4.33.3/en/model_doc/vilt#transformers.ViltForQuestionAnswering">ViltForQuestionAnswering</a>. Specify the number of labels
along with the label mappings:`,jt,Ve,wt,Ie,Sa="At this point, only three steps remain:",vt,Ge,Pa='<li>Define your training hyperparameters in <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:</li>',Jt,We,xt,I,Da='<li>Pass the training arguments to <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> along with the model, dataset, processor, and data collator.</li>',Tt,Be,Ut,G,Ka='<li>Call <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer.train">train()</a> to finetune your model.</li>',Ct,Xe,_t,Qe,Oa='Once training is completed, share your model to the Hub with the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method to share your final model on the 🤗 Hub:',$t,He,Zt,T,W,js,Re,ha,ms,el="Inference",kt,Ne,sl=`Now that you have fine-tuned a ViLT model, and uploaded it to the 🤗 Hub, you can use it for inference. The simplest
way to try out your fine-tuned model for inference is to use it in a <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a>.`,Vt,Fe,It,Ae,tl=`The model in this guide has only been trained on 200 examples, so don’t expect a lot from it. Let’s see if it at least
learned something from the data and take the first example from the dataset to illustrate inference:`,Gt,Ee,Wt,ze,al="Even though not very confident, the model indeed has learned something. With more examples and longer training, you’ll get far better results!",Bt,qe,ll="You can also manually replicate the results of the pipeline if you’d like:",Xt,Ye,nl="<li>Take an image and a question, prepare them for the model using the processor from your model.</li> <li>Forward the result or preprocessing through the model.</li> <li>From the logits, get the most likely answer’s id, and find the actual answer in the <code>id2label</code>.</li>",Qt,Le,Ht,U,B,ws,Se,ca,ds,il="Zero-shot VQA",Rt,Pe,pl=`The previous model treated VQA as a classification task. Some recent models, such as BLIP, BLIP-2, and InstructBLIP approach
VQA as a generative task. Let’s take <a href="../model_doc/blip-2">BLIP-2</a> as an example. It introduced a new visual-language pre-training
paradigm in which any combination of pre-trained vision encoder and LLM can be used (learn more in the <a href="https://huggingface.co/blog/blip-2" rel="nofollow">BLIP-2 blog post</a>).
This enables achieving state-of-the-art results on multiple visual-language tasks including visual question answering.`,Nt,De,rl=`Let’s illustrate how you can use this model for VQA. First, let’s load the model. Here we’ll explicitly send the model to a
GPU, if available, which we didn’t need to do earlier when training, as <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> handles this automatically:`,Ft,Ke,At,Oe,ol="The model takes image and text as input, so let’s use the exact same image/question pair from the first example in the VQA dataset:",Et,es,zt,ss,hl="To use BLIP-2 for visual question answering task, the textual prompt has to follow a specific format: <code>Question: {} Answer:</code>.",qt,ts,Yt,as,cl="Now we need to preprocess the image/prompt with the model’s processor, pass the processed input through the model, and decode the output:",Lt,ls,St,ns,ml=`As you can see, the model recognized the crowd, and the direction of the face (looking down), however, it seems to miss
the fact the crowd is behind the skater. Still, in cases where acquiring human-annotated datasets is not feasible, this
approach can quickly produce useful results.`,Pt,vs,Dt;return X=new is({}),Q=new Il({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/visual_question_answering.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/visual_question_answering.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/visual_question_answering.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/visual_question_answering.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/visual_question_answering.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/visual_question_answering.ipynb"}]}}),E=new is({}),L=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwZGF0YXNldHM=",highlighted:"pip install -q transformers datasets"}}),P=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`}}),K=new y({props:{code:"bW9kZWxfY2hlY2twb2ludCUyMCUzRCUyMCUyMmRhbmRlbGluJTJGdmlsdC1iMzItbWxtJTIy",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;dandelin/vilt-b32-mlm&quot;</span>'}}),O=new is({}),ae=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJHcmFwaGNvcmUlMkZ2cWElMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lNUIlM0EyMDAlNUQlMjIpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;Graphcore/vqa&quot;</span>, split=<span class="hljs-string">&quot;validation[:200]&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;question&#x27;</span>, <span class="hljs-string">&#x27;question_type&#x27;</span>, <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">200</span>
})`}}),ne=new y({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;question&#x27;</span>: <span class="hljs-string">&#x27;Where is he looking?&#x27;</span>,
 <span class="hljs-string">&#x27;question_type&#x27;</span>: <span class="hljs-string">&#x27;none of the above&#x27;</span>,
 <span class="hljs-string">&#x27;question_id&#x27;</span>: <span class="hljs-number">262148000</span>,
 <span class="hljs-string">&#x27;image_id&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/ca733e0e000fb2d7a09fbcc94dbfe7b5a30750681d0e965f8e0a23b1c2f98c75/val2014/COCO_val2014_000000262148.jpg&#x27;</span>,
 <span class="hljs-string">&#x27;answer_type&#x27;</span>: <span class="hljs-string">&#x27;other&#x27;</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: {<span class="hljs-string">&#x27;ids&#x27;</span>: [<span class="hljs-string">&#x27;at table&#x27;</span>, <span class="hljs-string">&#x27;down&#x27;</span>, <span class="hljs-string">&#x27;skateboard&#x27;</span>, <span class="hljs-string">&#x27;table&#x27;</span>],
  <span class="hljs-string">&#x27;weights&#x27;</span>: [<span class="hljs-number">0.30000001192092896</span>,
   <span class="hljs-number">1.0</span>,
   <span class="hljs-number">0.30000001192092896</span>,
   <span class="hljs-number">0.30000001192092896</span>]}}`}}),oe=new y({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVtb3ZlX2NvbHVtbnMoJTVCJ3F1ZXN0aW9uX3R5cGUnJTJDJTIwJ3F1ZXN0aW9uX2lkJyUyQyUyMCdhbnN3ZXJfdHlwZSclNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns([<span class="hljs-string">&#x27;question_type&#x27;</span>, <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>])'}}),me=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGRhdGFzZXQlNUIwJTVEJTVCJ2ltYWdlX2lkJyU1RCklMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>image`}}),fe=new y({props:{code:"aW1wb3J0JTIwaXRlcnRvb2xzJTBBJTBBbGFiZWxzJTIwJTNEJTIwJTVCaXRlbSU1QidpZHMnJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwZGF0YXNldCU1QidsYWJlbCclNUQlNUQlMEFmbGF0dGVuZWRfbGFiZWxzJTIwJTNEJTIwbGlzdChpdGVydG9vbHMuY2hhaW4oKmxhYmVscykpJTBBdW5pcXVlX2xhYmVscyUyMCUzRCUyMGxpc3Qoc2V0KGZsYXR0ZW5lZF9sYWJlbHMpKSUwQSUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCbGFiZWwlM0ElMjBpZHglMjBmb3IlMjBpZHglMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKHVuaXF1ZV9sYWJlbHMpJTdEJTBBaWQybGFiZWwlMjAlM0QlMjAlN0JpZHglM0ElMjBsYWJlbCUyMGZvciUyMGxhYmVsJTJDJTIwaWR4JTIwaW4lMjBsYWJlbDJpZC5pdGVtcygpJTdEJTIw",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> itertools

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [item[<span class="hljs-string">&#x27;ids&#x27;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&#x27;label&#x27;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>flattened_labels = <span class="hljs-built_in">list</span>(itertools.chain(*labels))
<span class="hljs-meta">&gt;&gt;&gt; </span>unique_labels = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(flattened_labels))

<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {label: idx <span class="hljs-keyword">for</span> idx, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(unique_labels)}
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {idx: label <span class="hljs-keyword">for</span> label, idx <span class="hljs-keyword">in</span> label2id.items()} `}}),be=new y({props:{code:"ZGVmJTIwcmVwbGFjZV9pZHMoaW5wdXRzKSUzQSUwQSUyMCUyMGlucHV0cyU1QiUyMmxhYmVsJTIyJTVEJTVCJTIyaWRzJTIyJTVEJTIwJTNEJTIwJTVCbGFiZWwyaWQlNUJ4JTVEJTIwZm9yJTIweCUyMGluJTIwaW5wdXRzJTVCJTIybGFiZWwlMjIlNUQlNUIlMjJpZHMlMjIlNUQlNUQlMEElMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAocmVwbGFjZV9pZHMpJTBBZmxhdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5mbGF0dGVuKCklMEFmbGF0X2RhdGFzZXQuZmVhdHVyZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">replace_ids</span>(<span class="hljs-params">inputs</span>):
<span class="hljs-meta">... </span>  inputs[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-string">&quot;ids&quot;</span>] = [label2id[x] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> inputs[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-string">&quot;ids&quot;</span>]]
<span class="hljs-meta">... </span>  <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(replace_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset = dataset.flatten()
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset.features
{<span class="hljs-string">&#x27;question&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;image_id&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label.ids&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label.weights&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;float64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`}}),Me=new is({}),we=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpbHRQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBWaWx0UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViltProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ViltProcessor.from_pretrained(model_checkpoint)`}}),Te=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBwcmVwcm9jZXNzX2RhdGEoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfcGF0aHMlMjAlM0QlMjBleGFtcGxlcyU1QidpbWFnZV9pZCclNUQlMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJJbWFnZS5vcGVuKGltYWdlX3BhdGgpJTIwZm9yJTIwaW1hZ2VfcGF0aCUyMGluJTIwaW1hZ2VfcGF0aHMlNUQlMEElMjAlMjAlMjAlMjB0ZXh0cyUyMCUzRCUyMGV4YW1wbGVzJTVCJ3F1ZXN0aW9uJyU1RCUyMCUyMCUyMCUyMCUwQSUwQSUyMCUyMCUyMCUyMGVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHRleHRzJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIwJTIwJTIwJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGVuY29kaW5nLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmNvZGluZyU1QmslNUQlMjAlM0QlMjB2LnNxdWVlemUoKSUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjAlNUIlNUQlMEElMEElMjAlMjAlMjAlMjBmb3IlMjBsYWJlbHMlMkMlMjBzY29yZXMlMjBpbiUyMHppcChleGFtcGxlcyU1QidsYWJlbC5pZHMnJTVEJTJDJTIwZXhhbXBsZXMlNUInbGFiZWwud2VpZ2h0cyclNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFyZ2V0JTIwJTNEJTIwdG9yY2guemVyb3MobGVuKGlkMmxhYmVsKSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBsYWJlbCUyQyUyMHNjb3JlJTIwaW4lMjB6aXAobGFiZWxzJTJDJTIwc2NvcmVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldCU1QmxhYmVsJTVEJTIwJTNEJTIwc2NvcmUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXJnZXRzLmFwcGVuZCh0YXJnZXQpJTBBJTBBJTIwJTIwJTIwJTIwZW5jb2RpbmclNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjB0YXJnZXRzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZW5jb2Rpbmc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_data</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    image_paths = examples[<span class="hljs-string">&#x27;image_id&#x27;</span>]
<span class="hljs-meta">... </span>    images = [Image.<span class="hljs-built_in">open</span>(image_path) <span class="hljs-keyword">for</span> image_path <span class="hljs-keyword">in</span> image_paths]
<span class="hljs-meta">... </span>    texts = examples[<span class="hljs-string">&#x27;question&#x27;</span>]    

<span class="hljs-meta">... </span>    encoding = processor(images, texts, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items():
<span class="hljs-meta">... </span>          encoding[k] = v.squeeze()
    
<span class="hljs-meta">... </span>    targets = []

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> labels, scores <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&#x27;label.ids&#x27;</span>], examples[<span class="hljs-string">&#x27;label.weights&#x27;</span>]):
<span class="hljs-meta">... </span>        target = torch.zeros(<span class="hljs-built_in">len</span>(id2label))

<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> label, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(labels, scores):
<span class="hljs-meta">... </span>            target[label] = score
      
<span class="hljs-meta">... </span>        targets.append(target)

<span class="hljs-meta">... </span>    encoding[<span class="hljs-string">&quot;labels&quot;</span>] = targets
    
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> encoding`}}),Ce=new y({props:{code:"cHJvY2Vzc2VkX2RhdGFzZXQlMjAlM0QlMjBmbGF0X2RhdGFzZXQubWFwKHByZXByb2Nlc3NfZGF0YSUyQyUyMGJhdGNoZWQlM0RUcnVlJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0QlNUIncXVlc3Rpb24nJTJDJ3F1ZXN0aW9uX3R5cGUnJTJDJTIwJTIwJ3F1ZXN0aW9uX2lkJyUyQyUyMCdpbWFnZV9pZCclMkMlMjAnYW5zd2VyX3R5cGUnJTJDJTIwJ2xhYmVsLmlkcyclMkMlMjAnbGFiZWwud2VpZ2h0cyclNUQpJTBBcHJvY2Vzc2VkX2RhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_dataset = flat_dataset.<span class="hljs-built_in">map</span>(preprocess_data, batched=<span class="hljs-literal">True</span>, remove_columns=[<span class="hljs-string">&#x27;question&#x27;</span>,<span class="hljs-string">&#x27;question_type&#x27;</span>,  <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>, <span class="hljs-string">&#x27;label.ids&#x27;</span>, <span class="hljs-string">&#x27;label.weights&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;pixel_values&#x27;</span>, <span class="hljs-string">&#x27;pixel_mask&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>],
    num_rows: <span class="hljs-number">200</span>
})`}}),$e=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator()`}}),Ze=new is({}),Ve=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpbHRGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQW1vZGVsJTIwJTNEJTIwVmlsdEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRGxlbihpZDJsYWJlbCklMkMlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViltForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ViltForQuestionAnswering.from_pretrained(model_checkpoint, num_labels=<span class="hljs-built_in">len</span>(id2label), id2label=id2label, label2id=label2id)`}}),We=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMk1hcmlhSyUyRnZpbHRfZmluZXR1bmVkXzIwMCUyMiUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3RvdGFsX2xpbWl0JTNEMiUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=repo_id,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`}}),Be=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0Rwcm9jZXNzZWRfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    train_dataset=processed_dataset,
<span class="hljs-meta">... </span>    tokenizer=processor,
<span class="hljs-meta">... </span>)`}}),Xe=new y({props:{code:"dHJhaW5lci50cmFpbigpJTIw",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train() '}}),He=new y({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()'}}),Re=new is({}),Fe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnZpc3VhbC1xdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMk1hcmlhSyUyRnZpbHRfZmluZXR1bmVkXzIwMCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;visual-question-answering&quot;</span>, model=<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)`}}),Ee=new y({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGV4YW1wbGUlNUInaW1hZ2VfaWQnJTVEKSUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QidxdWVzdGlvbiclNUQlMEFwcmludChxdWVzdGlvbiklMEFwaXBlKGltYWdlJTJDJTIwcXVlc3Rpb24lMkMlMjB0b3BfayUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(question)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(image, question, top_k=<span class="hljs-number">1</span>)
<span class="hljs-string">&quot;Where is he looking?&quot;</span>
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.5498199462890625</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;down&#x27;</span>}]`}}),Le=new y({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwVmlsdFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGdmlsdF9maW5ldHVuZWRfMjAwJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihleGFtcGxlJTVCJ2ltYWdlX2lkJyU1RCklMEFxdWVzdGlvbiUyMCUzRCUyMGV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGlucHV0cyUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZSUyQyUyMHF1ZXN0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMFZpbHRGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGdmlsdF9maW5ldHVuZWRfMjAwJTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWlkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGFuc3dlciUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmlkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ViltProcessor.from_pretrained(<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ViltForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer:&quot;</span>, model.config.id2label[idx])
Predicted answer: down`}}),Se=new is({}),Ke=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBCbGlwMkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmJsaXAyLW9wdC0yLjdiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQmxpcDJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZibGlwMi1vcHQtMi43YiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsLnRvKGRldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Blip2ForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Blip2ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)`}}),es=new y({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGV4YW1wbGUlNUInaW1hZ2VfaWQnJTVEKSUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QidxdWVzdGlvbiclNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]`}}),ts=new y({props:{code:"cHJvbXB0JTIwJTNEJTIwZiUyMlF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb24lN0QlMjBBbnN3ZXIlM0ElMjIlMjA=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span> Answer:&quot;</span> '}}),ls=new y({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwdGV4dCUzRHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSUyQyUyMHRvcmNoLmZsb2F0MTYpJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFnZW5lcmF0ZWRfdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQuc3RyaXAoKSUwQXByaW50KGdlbmVyYXRlZF90ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device, torch.float16)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>].strip()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text)
<span class="hljs-string">&quot;He is looking at the crowd&quot;</span> `}}),{c(){M=i("meta"),Js=l(),us=i("p"),xs=l(),j=i("h1"),C=i("a"),gs=i("span"),o(X.$$.fragment),na=l(),ps=i("span"),ps.textContent=da,Ts=l(),o(Q.$$.fragment),Us=l(),H=i("p"),H.textContent=ua,Cs=l(),R=i("p"),R.textContent=ga,_s=l(),N=i("ul"),N.innerHTML=fa,$s=l(),F=i("p"),F.textContent=ya,Zs=l(),A=i("ul"),A.innerHTML=ba,ks=l(),w=i("h2"),_=i("a"),fs=i("span"),o(E.$$.fragment),ia=l(),rs=i("span"),rs.textContent=Ma,Vs=l(),z=i("p"),z.innerHTML=ja,Is=l(),q=i("p"),q.textContent=wa,Gs=l(),Y=i("p"),Y.textContent=va,Ws=l(),o(L.$$.fragment),Bs=l(),S=i("p"),S.textContent=Ja,Xs=l(),o(P.$$.fragment),Qs=l(),D=i("p"),D.textContent=xa,Hs=l(),o(K.$$.fragment),Rs=l(),v=i("h2"),$=i("a"),ys=i("span"),o(O.$$.fragment),pa=l(),os=i("span"),os.textContent=Ta,Ns=l(),ee=i("p"),ee.innerHTML=Ua,Fs=l(),se=i("p"),se.innerHTML=Ca,As=l(),te=i("p"),te.textContent=_a,Es=l(),o(ae.$$.fragment),zs=l(),le=i("p"),le.textContent=$a,qs=l(),o(ne.$$.fragment),Ys=l(),ie=i("p"),ie.textContent=Za,Ls=l(),pe=i("ul"),pe.innerHTML=ka,Ss=l(),re=i("p"),re.textContent=Va,Ps=l(),o(oe.$$.fragment),Ds=l(),he=i("p"),he.innerHTML=Ia,Ks=l(),ce=i("p"),ce.textContent=Ga,Os=l(),o(me.$$.fragment),et=l(),Z=i("div"),Z.innerHTML=Wa,st=l(),de=i("p"),de.textContent=Ba,tt=l(),ue=i("p"),ue.innerHTML=Xa,at=l(),ge=i("p"),ge.textContent=Qa,lt=l(),o(fe.$$.fragment),nt=l(),ye=i("p"),ye.textContent=Ha,it=l(),o(be.$$.fragment),pt=l(),J=i("h2"),k=i("a"),bs=i("span"),o(Me.$$.fragment),ra=l(),hs=i("span"),hs.textContent=Ra,rt=l(),je=i("p"),je.innerHTML=Na,ot=l(),o(we.$$.fragment),ht=l(),ve=i("p"),ve.innerHTML=Fa,ct=l(),Je=i("p"),Je.innerHTML=Aa,mt=l(),xe=i("p"),xe.innerHTML=Ea,dt=l(),o(Te.$$.fragment),ut=l(),Ue=i("p"),Ue.innerHTML=za,gt=l(),o(Ce.$$.fragment),ft=l(),_e=i("p"),_e.innerHTML=qa,yt=l(),o($e.$$.fragment),bt=l(),x=i("h2"),V=i("a"),Ms=i("span"),o(Ze.$$.fragment),oa=l(),cs=i("span"),cs.textContent=Ya,Mt=l(),ke=i("p"),ke.innerHTML=La,jt=l(),o(Ve.$$.fragment),wt=l(),Ie=i("p"),Ie.textContent=Sa,vt=l(),Ge=i("ol"),Ge.innerHTML=Pa,Jt=l(),o(We.$$.fragment),xt=l(),I=i("ol"),I.innerHTML=Da,Tt=l(),o(Be.$$.fragment),Ut=l(),G=i("ol"),G.innerHTML=Ka,Ct=l(),o(Xe.$$.fragment),_t=l(),Qe=i("p"),Qe.innerHTML=Oa,$t=l(),o(He.$$.fragment),Zt=l(),T=i("h2"),W=i("a"),js=i("span"),o(Re.$$.fragment),ha=l(),ms=i("span"),ms.textContent=el,kt=l(),Ne=i("p"),Ne.innerHTML=sl,Vt=l(),o(Fe.$$.fragment),It=l(),Ae=i("p"),Ae.textContent=tl,Gt=l(),o(Ee.$$.fragment),Wt=l(),ze=i("p"),ze.textContent=al,Bt=l(),qe=i("p"),qe.textContent=ll,Xt=l(),Ye=i("ol"),Ye.innerHTML=nl,Qt=l(),o(Le.$$.fragment),Ht=l(),U=i("h2"),B=i("a"),ws=i("span"),o(Se.$$.fragment),ca=l(),ds=i("span"),ds.textContent=il,Rt=l(),Pe=i("p"),Pe.innerHTML=pl,Nt=l(),De=i("p"),De.innerHTML=rl,Ft=l(),o(Ke.$$.fragment),At=l(),Oe=i("p"),Oe.textContent=ol,Et=l(),o(es.$$.fragment),zt=l(),ss=i("p"),ss.innerHTML=hl,qt=l(),o(ts.$$.fragment),Yt=l(),as=i("p"),as.textContent=cl,Lt=l(),o(ls.$$.fragment),St=l(),ns=i("p"),ns.textContent=ml,Pt=l(),vs=i("p"),this.h()},l(e){const s=Vl("svelte-1phssyn",document.head);M=p(s,"META",{name:!0,content:!0}),s.forEach(t),Js=n(e),us=p(e,"P",{}),b(us).forEach(t),xs=n(e),j=p(e,"H1",{class:!0});var Kt=b(j);C=p(Kt,"A",{id:!0,class:!0,href:!0});var dl=b(C);gs=p(dl,"SPAN",{});var ul=b(gs);h(X.$$.fragment,ul),ul.forEach(t),dl.forEach(t),na=n(Kt),ps=p(Kt,"SPAN",{"data-svelte-h":!0}),r(ps)!=="svelte-yqvvm9"&&(ps.textContent=da),Kt.forEach(t),Ts=n(e),h(Q.$$.fragment,e),Us=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-vljp1h"&&(H.textContent=ua),Cs=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1r09kty"&&(R.textContent=ga),_s=n(e),N=p(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-geftd8"&&(N.innerHTML=fa),$s=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-jr2b5g"&&(F.textContent=ya),Zs=n(e),A=p(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-168wjvr"&&(A.innerHTML=ba),ks=n(e),w=p(e,"H2",{class:!0});var Ot=b(w);_=p(Ot,"A",{id:!0,class:!0,href:!0});var gl=b(_);fs=p(gl,"SPAN",{});var fl=b(fs);h(E.$$.fragment,fl),fl.forEach(t),gl.forEach(t),ia=n(Ot),rs=p(Ot,"SPAN",{"data-svelte-h":!0}),r(rs)!=="svelte-470qhg"&&(rs.textContent=Ma),Ot.forEach(t),Vs=n(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-132kvya"&&(z.innerHTML=ja),Is=n(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-x085ix"&&(q.textContent=wa),Gs=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-qn4ey1"&&(Y.textContent=va),Ws=n(e),h(L.$$.fragment,e),Bs=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1yqpblu"&&(S.textContent=Ja),Xs=n(e),h(P.$$.fragment,e),Qs=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-hhk89w"&&(D.textContent=xa),Hs=n(e),h(K.$$.fragment,e),Rs=n(e),v=p(e,"H2",{class:!0});var ea=b(v);$=p(ea,"A",{id:!0,class:!0,href:!0});var yl=b($);ys=p(yl,"SPAN",{});var bl=b(ys);h(O.$$.fragment,bl),bl.forEach(t),yl.forEach(t),pa=n(ea),os=p(ea,"SPAN",{"data-svelte-h":!0}),r(os)!=="svelte-1sbjexa"&&(os.textContent=Ta),ea.forEach(t),Ns=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-n8sxxt"&&(ee.innerHTML=Ua),Fs=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-b7b4c0"&&(se.innerHTML=Ca),As=n(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-16i329z"&&(te.textContent=_a),Es=n(e),h(ae.$$.fragment,e),zs=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-10yp249"&&(le.textContent=$a),qs=n(e),h(ne.$$.fragment,e),Ys=n(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1g3cog6"&&(ie.textContent=Za),Ls=n(e),pe=p(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-o5tqko"&&(pe.innerHTML=ka),Ss=n(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-73ooet"&&(re.textContent=Va),Ps=n(e),h(oe.$$.fragment,e),Ds=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-ozbkx3"&&(he.innerHTML=Ia),Ks=n(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1iqjyc4"&&(ce.textContent=Ga),Os=n(e),h(me.$$.fragment,e),et=n(e),Z=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-1tjg4st"&&(Z.innerHTML=Wa),st=n(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-7dyn3e"&&(de.textContent=Ba),tt=n(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1g9udhi"&&(ue.innerHTML=Xa),at=n(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-11t4fgj"&&(ge.textContent=Qa),lt=n(e),h(fe.$$.fragment,e),nt=n(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1p4inua"&&(ye.textContent=Ha),it=n(e),h(be.$$.fragment,e),pt=n(e),J=p(e,"H2",{class:!0});var sa=b(J);k=p(sa,"A",{id:!0,class:!0,href:!0});var Ml=b(k);bs=p(Ml,"SPAN",{});var jl=b(bs);h(Me.$$.fragment,jl),jl.forEach(t),Ml.forEach(t),ra=n(sa),hs=p(sa,"SPAN",{"data-svelte-h":!0}),r(hs)!=="svelte-jtsjlz"&&(hs.textContent=Ra),sa.forEach(t),rt=n(e),je=p(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1wh2buf"&&(je.innerHTML=Na),ot=n(e),h(we.$$.fragment,e),ht=n(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-148jfq3"&&(ve.innerHTML=Fa),ct=n(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-kuuiuf"&&(Je.innerHTML=Aa),mt=n(e),xe=p(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-cgn1al"&&(xe.innerHTML=Ea),dt=n(e),h(Te.$$.fragment,e),ut=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1og8o1g"&&(Ue.innerHTML=za),gt=n(e),h(Ce.$$.fragment,e),ft=n(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1x7z7sq"&&(_e.innerHTML=qa),yt=n(e),h($e.$$.fragment,e),bt=n(e),x=p(e,"H2",{class:!0});var ta=b(x);V=p(ta,"A",{id:!0,class:!0,href:!0});var wl=b(V);Ms=p(wl,"SPAN",{});var vl=b(Ms);h(Ze.$$.fragment,vl),vl.forEach(t),wl.forEach(t),oa=n(ta),cs=p(ta,"SPAN",{"data-svelte-h":!0}),r(cs)!=="svelte-n13n3f"&&(cs.textContent=Ya),ta.forEach(t),Mt=n(e),ke=p(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1mlr7c7"&&(ke.innerHTML=La),jt=n(e),h(Ve.$$.fragment,e),wt=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-l42k0i"&&(Ie.textContent=Sa),vt=n(e),Ge=p(e,"OL",{"data-svelte-h":!0}),r(Ge)!=="svelte-11ugfr8"&&(Ge.innerHTML=Pa),Jt=n(e),h(We.$$.fragment,e),xt=n(e),I=p(e,"OL",{start:!0,"data-svelte-h":!0}),r(I)!=="svelte-1791fql"&&(I.innerHTML=Da),Tt=n(e),h(Be.$$.fragment,e),Ut=n(e),G=p(e,"OL",{start:!0,"data-svelte-h":!0}),r(G)!=="svelte-88zrmc"&&(G.innerHTML=Ka),Ct=n(e),h(Xe.$$.fragment,e),_t=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1uxmema"&&(Qe.innerHTML=Oa),$t=n(e),h(He.$$.fragment,e),Zt=n(e),T=p(e,"H2",{class:!0});var aa=b(T);W=p(aa,"A",{id:!0,class:!0,href:!0});var Jl=b(W);js=p(Jl,"SPAN",{});var xl=b(js);h(Re.$$.fragment,xl),xl.forEach(t),Jl.forEach(t),ha=n(aa),ms=p(aa,"SPAN",{"data-svelte-h":!0}),r(ms)!=="svelte-199uz7g"&&(ms.textContent=el),aa.forEach(t),kt=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1exw8su"&&(Ne.innerHTML=sl),Vt=n(e),h(Fe.$$.fragment,e),It=n(e),Ae=p(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1lvulzt"&&(Ae.textContent=tl),Gt=n(e),h(Ee.$$.fragment,e),Wt=n(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-mc0cvg"&&(ze.textContent=al),Bt=n(e),qe=p(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-o6117l"&&(qe.textContent=ll),Xt=n(e),Ye=p(e,"OL",{"data-svelte-h":!0}),r(Ye)!=="svelte-346f3f"&&(Ye.innerHTML=nl),Qt=n(e),h(Le.$$.fragment,e),Ht=n(e),U=p(e,"H2",{class:!0});var la=b(U);B=p(la,"A",{id:!0,class:!0,href:!0});var Tl=b(B);ws=p(Tl,"SPAN",{});var Ul=b(ws);h(Se.$$.fragment,Ul),Ul.forEach(t),Tl.forEach(t),ca=n(la),ds=p(la,"SPAN",{"data-svelte-h":!0}),r(ds)!=="svelte-x8ffr6"&&(ds.textContent=il),la.forEach(t),Rt=n(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-4nhby3"&&(Pe.innerHTML=pl),Nt=n(e),De=p(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-j8ol52"&&(De.innerHTML=rl),Ft=n(e),h(Ke.$$.fragment,e),At=n(e),Oe=p(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-w113ee"&&(Oe.textContent=ol),Et=n(e),h(es.$$.fragment,e),zt=n(e),ss=p(e,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-n2zykh"&&(ss.innerHTML=hl),qt=n(e),h(ts.$$.fragment,e),Yt=n(e),as=p(e,"P",{"data-svelte-h":!0}),r(as)!=="svelte-10l7d2y"&&(as.textContent=cl),Lt=n(e),h(ls.$$.fragment,e),St=n(e),ns=p(e,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-1wjg6co"&&(ns.textContent=ml),Pt=n(e),vs=p(e,"P",{}),b(vs).forEach(t),this.h()},h(){c(M,"name","hf:doc:metadata"),c(M,"content",JSON.stringify(Wl)),c(C,"id","visual-question-answering"),c(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(C,"href","#visual-question-answering"),c(j,"class","relative group"),c(_,"id","finetuning-vilt"),c(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(_,"href","#finetuning-vilt"),c(w,"class","relative group"),c($,"id","load-the-data"),c($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c($,"href","#load-the-data"),c(v,"class","relative group"),c(Z,"class","flex justify-center"),c(k,"id","preprocessing-data"),c(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(k,"href","#preprocessing-data"),c(J,"class","relative group"),c(V,"id","train-the-model"),c(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(V,"href","#train-the-model"),c(x,"class","relative group"),c(I,"start","2"),c(G,"start","3"),c(W,"id","inference"),c(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(W,"href","#inference"),c(T,"class","relative group"),c(B,"id","zeroshot-vqa"),c(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(B,"href","#zeroshot-vqa"),c(U,"class","relative group")},m(e,s){f(document.head,M),a(e,Js,s),a(e,us,s),a(e,xs,s),a(e,j,s),f(j,C),f(C,gs),m(X,gs,null),f(j,na),f(j,ps),a(e,Ts,s),m(Q,e,s),a(e,Us,s),a(e,H,s),a(e,Cs,s),a(e,R,s),a(e,_s,s),a(e,N,s),a(e,$s,s),a(e,F,s),a(e,Zs,s),a(e,A,s),a(e,ks,s),a(e,w,s),f(w,_),f(_,fs),m(E,fs,null),f(w,ia),f(w,rs),a(e,Vs,s),a(e,z,s),a(e,Is,s),a(e,q,s),a(e,Gs,s),a(e,Y,s),a(e,Ws,s),m(L,e,s),a(e,Bs,s),a(e,S,s),a(e,Xs,s),m(P,e,s),a(e,Qs,s),a(e,D,s),a(e,Hs,s),m(K,e,s),a(e,Rs,s),a(e,v,s),f(v,$),f($,ys),m(O,ys,null),f(v,pa),f(v,os),a(e,Ns,s),a(e,ee,s),a(e,Fs,s),a(e,se,s),a(e,As,s),a(e,te,s),a(e,Es,s),m(ae,e,s),a(e,zs,s),a(e,le,s),a(e,qs,s),m(ne,e,s),a(e,Ys,s),a(e,ie,s),a(e,Ls,s),a(e,pe,s),a(e,Ss,s),a(e,re,s),a(e,Ps,s),m(oe,e,s),a(e,Ds,s),a(e,he,s),a(e,Ks,s),a(e,ce,s),a(e,Os,s),m(me,e,s),a(e,et,s),a(e,Z,s),a(e,st,s),a(e,de,s),a(e,tt,s),a(e,ue,s),a(e,at,s),a(e,ge,s),a(e,lt,s),m(fe,e,s),a(e,nt,s),a(e,ye,s),a(e,it,s),m(be,e,s),a(e,pt,s),a(e,J,s),f(J,k),f(k,bs),m(Me,bs,null),f(J,ra),f(J,hs),a(e,rt,s),a(e,je,s),a(e,ot,s),m(we,e,s),a(e,ht,s),a(e,ve,s),a(e,ct,s),a(e,Je,s),a(e,mt,s),a(e,xe,s),a(e,dt,s),m(Te,e,s),a(e,ut,s),a(e,Ue,s),a(e,gt,s),m(Ce,e,s),a(e,ft,s),a(e,_e,s),a(e,yt,s),m($e,e,s),a(e,bt,s),a(e,x,s),f(x,V),f(V,Ms),m(Ze,Ms,null),f(x,oa),f(x,cs),a(e,Mt,s),a(e,ke,s),a(e,jt,s),m(Ve,e,s),a(e,wt,s),a(e,Ie,s),a(e,vt,s),a(e,Ge,s),a(e,Jt,s),m(We,e,s),a(e,xt,s),a(e,I,s),a(e,Tt,s),m(Be,e,s),a(e,Ut,s),a(e,G,s),a(e,Ct,s),m(Xe,e,s),a(e,_t,s),a(e,Qe,s),a(e,$t,s),m(He,e,s),a(e,Zt,s),a(e,T,s),f(T,W),f(W,js),m(Re,js,null),f(T,ha),f(T,ms),a(e,kt,s),a(e,Ne,s),a(e,Vt,s),m(Fe,e,s),a(e,It,s),a(e,Ae,s),a(e,Gt,s),m(Ee,e,s),a(e,Wt,s),a(e,ze,s),a(e,Bt,s),a(e,qe,s),a(e,Xt,s),a(e,Ye,s),a(e,Qt,s),m(Le,e,s),a(e,Ht,s),a(e,U,s),f(U,B),f(B,ws),m(Se,ws,null),f(U,ca),f(U,ds),a(e,Rt,s),a(e,Pe,s),a(e,Nt,s),a(e,De,s),a(e,Ft,s),m(Ke,e,s),a(e,At,s),a(e,Oe,s),a(e,Et,s),m(es,e,s),a(e,zt,s),a(e,ss,s),a(e,qt,s),m(ts,e,s),a(e,Yt,s),a(e,as,s),a(e,Lt,s),m(ls,e,s),a(e,St,s),a(e,ns,s),a(e,Pt,s),a(e,vs,s),Dt=!0},p:_l,i(e){Dt||(d(X.$$.fragment,e),d(Q.$$.fragment,e),d(E.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(me.$$.fragment,e),d(fe.$$.fragment,e),d(be.$$.fragment,e),d(Me.$$.fragment,e),d(we.$$.fragment,e),d(Te.$$.fragment,e),d(Ce.$$.fragment,e),d($e.$$.fragment,e),d(Ze.$$.fragment,e),d(Ve.$$.fragment,e),d(We.$$.fragment,e),d(Be.$$.fragment,e),d(Xe.$$.fragment,e),d(He.$$.fragment,e),d(Re.$$.fragment,e),d(Fe.$$.fragment,e),d(Ee.$$.fragment,e),d(Le.$$.fragment,e),d(Se.$$.fragment,e),d(Ke.$$.fragment,e),d(es.$$.fragment,e),d(ts.$$.fragment,e),d(ls.$$.fragment,e),Dt=!0)},o(e){u(X.$$.fragment,e),u(Q.$$.fragment,e),u(E.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(me.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),u(Me.$$.fragment,e),u(we.$$.fragment,e),u(Te.$$.fragment,e),u(Ce.$$.fragment,e),u($e.$$.fragment,e),u(Ze.$$.fragment,e),u(Ve.$$.fragment,e),u(We.$$.fragment,e),u(Be.$$.fragment,e),u(Xe.$$.fragment,e),u(He.$$.fragment,e),u(Re.$$.fragment,e),u(Fe.$$.fragment,e),u(Ee.$$.fragment,e),u(Le.$$.fragment,e),u(Se.$$.fragment,e),u(Ke.$$.fragment,e),u(es.$$.fragment,e),u(ts.$$.fragment,e),u(ls.$$.fragment,e),Dt=!1},d(e){e&&(t(Js),t(us),t(xs),t(j),t(Ts),t(Us),t(H),t(Cs),t(R),t(_s),t(N),t($s),t(F),t(Zs),t(A),t(ks),t(w),t(Vs),t(z),t(Is),t(q),t(Gs),t(Y),t(Ws),t(Bs),t(S),t(Xs),t(Qs),t(D),t(Hs),t(Rs),t(v),t(Ns),t(ee),t(Fs),t(se),t(As),t(te),t(Es),t(zs),t(le),t(qs),t(Ys),t(ie),t(Ls),t(pe),t(Ss),t(re),t(Ps),t(Ds),t(he),t(Ks),t(ce),t(Os),t(et),t(Z),t(st),t(de),t(tt),t(ue),t(at),t(ge),t(lt),t(nt),t(ye),t(it),t(pt),t(J),t(rt),t(je),t(ot),t(ht),t(ve),t(ct),t(Je),t(mt),t(xe),t(dt),t(ut),t(Ue),t(gt),t(ft),t(_e),t(yt),t(bt),t(x),t(Mt),t(ke),t(jt),t(wt),t(Ie),t(vt),t(Ge),t(Jt),t(xt),t(I),t(Tt),t(Ut),t(G),t(Ct),t(_t),t(Qe),t($t),t(Zt),t(T),t(kt),t(Ne),t(Vt),t(It),t(Ae),t(Gt),t(Wt),t(ze),t(Bt),t(qe),t(Xt),t(Ye),t(Qt),t(Ht),t(U),t(Rt),t(Pe),t(Nt),t(De),t(Ft),t(At),t(Oe),t(Et),t(zt),t(ss),t(qt),t(Yt),t(as),t(Lt),t(St),t(ns),t(Pt),t(vs)),t(M),g(X),g(Q,e),g(E),g(L,e),g(P,e),g(K,e),g(O),g(ae,e),g(ne,e),g(oe,e),g(me,e),g(fe,e),g(be,e),g(Me),g(we,e),g(Te,e),g(Ce,e),g($e,e),g(Ze),g(Ve,e),g(We,e),g(Be,e),g(Xe,e),g(He,e),g(Re),g(Fe,e),g(Ee,e),g(Le,e),g(Se),g(Ke,e),g(es,e),g(ts,e),g(ls,e)}}}const Wl={local:"visual-question-answering",sections:[{local:"finetuning-vilt",title:"Fine-tuning ViLT"},{local:"load-the-data",title:"Load the data"},{local:"preprocessing-data",title:"Preprocessing data"},{local:"train-the-model",title:"Train the model"},{local:"inference",title:"Inference"},{local:"zeroshot-vqa",title:"Zero-shot VQA"}],title:"Visual Question Answering"};function Bl(ma){return $l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fl extends Zl{constructor(M){super(),kl(this,M,Bl,Gl,Cl,{})}}export{Fl as component};
