import{S as hw,i as uw,s as fw,e as t,k as l,w as _,t as a,M as gw,c as s,d as o,m as d,a as n,x as P,h as i,b as c,N as vw,F as e,g as h,y as b,q as w,o as y,B as $,v as _w,L as $r}from"../../chunks/vendor-6b77c823.js";import{T as wr}from"../../chunks/Tip-39098574.js";import{D as x}from"../../chunks/Docstring-1088f2fb.js";import{C as kr}from"../../chunks/CodeBlock-3a8b25a8.js";import{I as C}from"../../chunks/IconCopyLink-7a11ce68.js";import{E as yr}from"../../chunks/ExampleCodeBlock-5212b321.js";function Pw(E){let u,T,v,g,k;return g=new kr({props:{code:`from transformers import PerceiverModel, PerceiverConfig

# Initializing a Perceiver deepmind/language-perceiver style configuration
configuration = PerceiverConfig()

# Initializing a model from the deepmind/language-perceiver style configuration
model = PerceiverModel(configuration)

# Accessing the model configuration
configuration = model.config`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverModel, PerceiverConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Perceiver deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PerceiverConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){u=t("p"),T=a("Example:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Example:"),f.forEach(o),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$r,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&o(u),p&&o(v),$(g,p)}}}function bw(E){let u,T;return{c(){u=t("p"),T=a(`NumPy arrays and PyTorch tensors are converted to PIL images when resizing, so the most efficient is to pass
PIL images.`)},l(v){u=s(v,"P",{});var g=n(u);T=i(g,`NumPy arrays and PyTorch tensors are converted to PIL images when resizing, so the most efficient is to pass
PIL images.`),g.forEach(o)},m(v,g){h(v,u,g),e(u,T)},d(v){v&&o(u)}}}function ww(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(o),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(o)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&o(u)}}}function yw(E){let u,T,v,g,k;return g=new kr({props:{code:`from transformers import PerceiverConfig, PerceiverTokenizer, PerceiverFeatureExtractor, PerceiverModel
from transformers.models.perceiver.modeling_perceiver import (
    PerceiverTextPreprocessor,
    PerceiverImagePreprocessor,
    PerceiverClassificationDecoder,
)
import torch
import requests
from PIL import Image

# EXAMPLE 1: using the Perceiver to classify texts
# - we define a TextPreprocessor, which can be used to embed tokens
# - we define a ClassificationDecoder, which can be used to decode the
# final hidden states of the latents to classification logits
# using trainable position embeddings
config = PerceiverConfig()
preprocessor = PerceiverTextPreprocessor(config)
decoder = PerceiverClassificationDecoder(
    config,
    num_channels=config.d_latents,
    trainable_position_encoding_kwargs=dict(num_channels=config.d_latents, index_dims=1),
    use_query_residual=True,
)
model = PerceiverModel(config, input_preprocessor=preprocessor, decoder=decoder)

# you can then do a forward pass as follows:
tokenizer = PerceiverTokenizer()
text = "hello world"
inputs = tokenizer(text, return_tensors="pt").input_ids

with torch.no_grad():
    outputs = model(inputs=inputs)
logits = outputs.logits

# to train, one can train the model using standard cross-entropy:
criterion = torch.nn.CrossEntropyLoss()

labels = torch.tensor([1])
loss = criterion(logits, labels)

# EXAMPLE 2: using the Perceiver to classify images
# - we define an ImagePreprocessor, which can be used to embed images
preprocessor = PerceiverImagePreprocessor(
    config,
    prep_type="conv1x1",
    spatial_downsample=1,
    out_channels=256,
    position_encoding_type="trainable",
    concat_or_add_pos="concat",
    project_pos_dim=256,
    trainable_position_encoding_kwargs=dict(
        num_channels=256,
        index_dims=config.image_size**2,
    ),
)

model = PerceiverModel(
    config,
    input_preprocessor=preprocessor,
    decoder=PerceiverClassificationDecoder(
        config,
        num_channels=config.d_latents,
        trainable_position_encoding_kwargs=dict(num_channels=config.d_latents, index_dims=1),
        use_query_residual=True,
    ),
)

# you can then do a forward pass as follows:
feature_extractor = PerceiverFeatureExtractor()
url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)
inputs = feature_extractor(image, return_tensors="pt").pixel_values

with torch.no_grad():
    outputs = model(inputs=inputs)
logits = outputs.logits

# to train, one can train the model using standard cross-entropy:
criterion = torch.nn.CrossEntropyLoss()

labels = torch.tensor([1])
loss = criterion(logits, labels)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverConfig, PerceiverTokenizer, PerceiverFeatureExtractor, PerceiverModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.models.perceiver.modeling_perceiver <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    PerceiverTextPreprocessor,
<span class="hljs-meta">... </span>    PerceiverImagePreprocessor,
<span class="hljs-meta">... </span>    PerceiverClassificationDecoder,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 1: using the Perceiver to classify texts</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a TextPreprocessor, which can be used to embed tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a ClassificationDecoder, which can be used to decode the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># final hidden states of the latents to classification logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># using trainable position embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverTextPreprocessor(config)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    num_channels=config.d_latents,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(config, input_preprocessor=preprocessor, decoder=decoder)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 2: using the Perceiver to classify images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define an ImagePreprocessor, which can be used to embed images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverImagePreprocessor(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    prep_type=<span class="hljs-string">&quot;conv1x1&quot;</span>,
<span class="hljs-meta">... </span>    spatial_downsample=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    position_encoding_type=<span class="hljs-string">&quot;trainable&quot;</span>,
<span class="hljs-meta">... </span>    concat_or_add_pos=<span class="hljs-string">&quot;concat&quot;</span>,
<span class="hljs-meta">... </span>    project_pos_dim=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(
<span class="hljs-meta">... </span>        num_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>        index_dims=config.image_size**<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    input_preprocessor=preprocessor,
<span class="hljs-meta">... </span>    decoder=PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>        config,
<span class="hljs-meta">... </span>        num_channels=config.d_latents,
<span class="hljs-meta">... </span>        trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>        use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = PerceiverFeatureExtractor()
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(o),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$r,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&o(u),p&&o(v),$(g,p)}}}function $w(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(o),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(o)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&o(u)}}}function kw(E){let u,T,v,g,k;return g=new kr({props:{code:`from transformers import PerceiverTokenizer, PerceiverForMaskedLM
import torch

tokenizer = PerceiverTokenizer.from_pretrained("deepmind/language-perceiver")
model = PerceiverForMaskedLM.from_pretrained("deepmind/language-perceiver")

# training
text = "This is an incomplete sentence where some words are missing."
inputs = tokenizer(text, padding="max_length", return_tensors="pt")
# mask " missing."
inputs["input_ids"][0, 52:61] = tokenizer.mask_token_id
labels = tokenizer(text, padding="max_length", return_tensors="pt").input_ids

outputs = model(**inputs, labels=labels)
loss = outputs.loss
logits = outputs.logits

# inference
text = "This is an incomplete sentence where some words are missing."
encoding = tokenizer(text, padding="max_length", return_tensors="pt")

# mask bytes corresponding to " missing.". Note that the model performs much better if the masked span starts with a space.
encoding["input_ids"][0, 52:61] = tokenizer.mask_token_id

# forward pass
with torch.no_grad():
    outputs = model(**encoding)
logits = outputs.logits

masked_tokens_predictions = logits[0, 52:61].argmax(dim=-1).tolist()
tokenizer.decode(masked_tokens_predictions)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverTokenizer, PerceiverForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMaskedLM.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask &quot; missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask bytes corresponding to &quot; missing.&quot;. Note that the model performs much better if the masked span starts with a space.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span>masked_tokens_predictions = logits[<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>].argmax(dim=-<span class="hljs-number">1</span>).tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(masked_tokens_predictions)
<span class="hljs-string">&#x27; missing.&#x27;</span>`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(o),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$r,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&o(u),p&&o(v),$(g,p)}}}function Tw(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(o),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(o)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&o(u)}}}function xw(E){let u,T,v,g,k;return g=new kr({props:{code:`from transformers import PerceiverTokenizer, PerceiverForSequenceClassification

tokenizer = PerceiverTokenizer.from_pretrained("deepmind/language-perceiver")
model = PerceiverForSequenceClassification.from_pretrained("deepmind/language-perceiver")

text = "hello world"
inputs = tokenizer(text, return_tensors="pt").input_ids
outputs = model(inputs=inputs)
logits = outputs.logits`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverTokenizer, PerceiverForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(o),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$r,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&o(u),p&&o(v),$(g,p)}}}function Ew(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(o),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(o)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&o(u)}}}function Fw(E){let u,T,v,g,k;return g=new kr({props:{code:`from transformers import PerceiverFeatureExtractor, PerceiverForImageClassificationLearned
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

feature_extractor = PerceiverFeatureExtractor.from_pretrained("deepmind/vision-perceiver-learned")
model = PerceiverForImageClassificationLearned.from_pretrained("deepmind/vision-perceiver-learned")

inputs = feature_extractor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverFeatureExtractor, PerceiverForImageClassificationLearned
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = PerceiverFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationLearned.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(o),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$r,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&o(u),p&&o(v),$(g,p)}}}function Cw(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(o),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(o)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&o(u)}}}function jw(E){let u,T,v,g,k;return g=new kr({props:{code:`from transformers import PerceiverFeatureExtractor, PerceiverForImageClassificationFourier
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

feature_extractor = PerceiverFeatureExtractor.from_pretrained("deepmind/vision-perceiver-fourier")
model = PerceiverForImageClassificationFourier.from_pretrained("deepmind/vision-perceiver-fourier")

inputs = feature_extractor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverFeatureExtractor, PerceiverForImageClassificationFourier
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = PerceiverFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationFourier.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(o),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$r,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&o(u),p&&o(v),$(g,p)}}}function Mw(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(o),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(o)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&o(u)}}}function Iw(E){let u,T,v,g,k;return g=new kr({props:{code:`from transformers import PerceiverFeatureExtractor, PerceiverForImageClassificationConvProcessing
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

feature_extractor = PerceiverFeatureExtractor.from_pretrained("deepmind/vision-perceiver-conv")
model = PerceiverForImageClassificationConvProcessing.from_pretrained("deepmind/vision-perceiver-conv")

inputs = feature_extractor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverFeatureExtractor, PerceiverForImageClassificationConvProcessing
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = PerceiverFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationConvProcessing.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(o),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$r,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&o(u),p&&o(v),$(g,p)}}}function qw(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(o),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(o)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&o(u)}}}function zw(E){let u,T,v,g,k;return g=new kr({props:{code:`from transformers import PerceiverForOpticalFlow
import torch

model = PerceiverForOpticalFlow.from_pretrained("deepmind/optical-flow-perceiver")

# in the Perceiver IO paper, the authors extract a 3 x 3 patch around each pixel,
# leading to 3 x 3 x 3 = 27 values for each pixel (as each pixel also has 3 color channels)
# patches have shape (batch_size, num_frames, num_channels, height, width)
# the authors train on resolutions of 368 x 496
patches = torch.randn(1, 2, 27, 368, 496)
outputs = model(inputs=patches)
logits = outputs.logits`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForOpticalFlow
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForOpticalFlow.from_pretrained(<span class="hljs-string">&quot;deepmind/optical-flow-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, the authors extract a 3 x 3 patch around each pixel,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># leading to 3 x 3 x 3 = 27 values for each pixel (as each pixel also has 3 color channels)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># patches have shape (batch_size, num_frames, num_channels, height, width)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the authors train on resolutions of 368 x 496</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>patches = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">27</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=patches)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(o),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$r,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&o(u),p&&o(v),$(g,p)}}}function Aw(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(o),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(o)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&o(u)}}}function Dw(E){let u,T,v,g,k;return g=new kr({props:{code:`from transformers import PerceiverForMultimodalAutoencoding
import torch
import numpy as np

# create multimodal inputs
images = torch.randn((1, 16, 3, 224, 224))
audio = torch.randn((1, 30720, 1))
inputs = dict(image=images, audio=audio, label=torch.zeros((images.shape[0], 700)))

model = PerceiverForMultimodalAutoencoding.from_pretrained("deepmind/multimodal-perceiver")

# in the Perceiver IO paper, videos are auto-encoded in chunks
# each chunk subsamples different index dimensions of the image and audio modality decoder queries
nchunks = 128
image_chunk_size = np.prod((16, 224, 224)) // nchunks
audio_chunk_size = audio.shape[1] // model.config.samples_per_patch // nchunks
# process the first chunk
chunk_idx = 0
subsampling = {
    "image": torch.arange(image_chunk_size * chunk_idx, image_chunk_size * (chunk_idx + 1)),
    "audio": torch.arange(audio_chunk_size * chunk_idx, audio_chunk_size * (chunk_idx + 1)),
    "label": None,
}

outputs = model(inputs=inputs, subsampled_output_points=subsampling)
logits = outputs.logits`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForMultimodalAutoencoding
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create multimodal inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">16</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">30720</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(image=images, audio=audio, label=torch.zeros((images.shape[<span class="hljs-number">0</span>], <span class="hljs-number">700</span>)))

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMultimodalAutoencoding.from_pretrained(<span class="hljs-string">&quot;deepmind/multimodal-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, videos are auto-encoded in chunks</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># each chunk subsamples different index dimensions of the image and audio modality decoder queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>nchunks = <span class="hljs-number">128</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_chunk_size = np.prod((<span class="hljs-number">16</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)) // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_chunk_size = audio.shape[<span class="hljs-number">1</span>] // model.config.samples_per_patch // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># process the first chunk</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chunk_idx = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>subsampling = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;image&quot;</span>: torch.arange(image_chunk_size * chunk_idx, image_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;audio&quot;</span>: torch.arange(audio_chunk_size * chunk_idx, audio_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs, subsampled_output_points=subsampling)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(o),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$r,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&o(u),p&&o(v),$(g,p)}}}function Ow(E){let u,T,v,g,k,p,f,F,ep,xc,$e,Tr,Xn,Do,rp,Zn,op,Ec,xr,tp,Oo,sp,np,Fc,Er,ap,No,ip,cp,Cc,Ns,lp,jc,Ls,Qn,dp,Mc,Ss,pp,Ic,Bs,mp,qc,D,hp,Hs,up,fp,Yn,gp,vp,ea,_p,Pp,ra,bp,wp,oa,yp,$p,zc,Ws,kp,Ac,M,Tp,ta,xp,Ep,sa,Fp,Cp,na,jp,Mp,aa,Ip,qp,ia,zp,Ap,ca,Dp,Op,Dc,Fr,x_,Oc,Lo,Np,Vs,Lp,Nc,ve,Sp,So,Bp,Hp,Bo,Wp,Vp,Lc,Us,Up,Sc,Cr,Ho,Rp,Wo,Kp,Jp,Gp,Vo,Xp,Uo,Zp,Qp,Bc,Ro,la,Yp,em,Hc,Rs,_e,rm,da,om,tm,pa,sm,nm,Ko,am,Wc,ke,jr,ma,Jo,im,ha,cm,Vc,Te,Go,lm,ua,dm,Uc,xe,Xo,pm,fa,mm,Rc,Ee,Zo,hm,ga,um,Kc,Fe,Qo,fm,va,gm,Jc,Ce,Mr,_a,Yo,vm,Pa,_m,Gc,V,et,Pm,je,bm,Ks,wm,ym,rt,$m,km,Tm,Me,xm,Js,Em,Fm,Gs,Cm,jm,Mm,Ir,Xc,Ie,qr,ba,ot,Im,wa,qm,Zc,U,tt,zm,ya,Am,Dm,st,Om,Xs,Nm,Lm,Sm,zr,nt,Bm,$a,Hm,Qc,qe,Ar,ka,at,Wm,Ta,Vm,Yc,R,it,Um,xa,Rm,Km,ct,Jm,Zs,Gm,Xm,Zm,Pe,lt,Qm,Ea,Ym,eh,Dr,el,ze,Or,Fa,dt,rh,Ca,oh,rl,ae,pt,th,mt,sh,ja,nh,ah,ih,ht,ch,Ma,lh,dh,ol,Ae,Nr,Ia,ut,ph,qa,mh,tl,ie,ft,hh,za,uh,fh,K,gh,Aa,vh,_h,Da,Ph,bh,Oa,wh,yh,Na,$h,kh,sl,De,Lr,La,gt,Th,Sa,xh,nl,Oe,vt,Eh,Ba,Fh,al,Ne,Sr,Ha,_t,Ch,Wa,jh,il,Le,Pt,Mh,Va,Ih,cl,Se,Br,Ua,bt,qh,Ra,zh,ll,ce,wt,Ah,Ka,Dh,Oh,Ja,Nh,dl,Be,Hr,Ga,yt,Lh,Xa,Sh,pl,He,$t,Bh,Za,Hh,ml,We,Wr,Qa,kt,Wh,Ya,Vh,hl,le,Tt,Uh,ei,Rh,Kh,ri,Jh,ul,Ve,Vr,oi,xt,Gh,ti,Xh,fl,Ue,Et,Zh,Ft,Qh,si,Yh,eu,gl,Re,Ur,ni,Ct,ru,ai,ou,vl,Ke,jt,tu,ii,su,_l,Je,Rr,ci,Mt,nu,li,au,Pl,Ge,It,iu,qt,cu,di,lu,du,bl,Xe,Kr,pi,zt,pu,mi,mu,wl,de,At,hu,Dt,uu,hi,fu,gu,vu,ui,_u,yl,Ze,Jr,fi,Ot,Pu,gi,bu,$l,Qe,Nt,wu,vi,yu,kl,Ye,Gr,_i,Lt,$u,Pi,ku,Tl,er,St,Tu,bi,xu,xl,rr,Xr,wi,Bt,Eu,yi,Fu,El,or,Ht,Cu,$i,ju,Fl,tr,Zr,ki,Wt,Mu,Ti,Iu,Cl,sr,Vt,qu,xi,zu,jl,nr,Qr,Ei,Ut,Au,Fi,Du,Ml,pe,Rt,Ou,Kt,Nu,Jt,Lu,Su,Bu,J,Gt,Hu,ar,Wu,Qs,Vu,Uu,Ci,Ru,Ku,Ju,Yr,Gu,eo,Il,ir,ro,ji,Xt,Xu,Mi,Zu,ql,me,Zt,Qu,Qt,Yu,Yt,ef,rf,of,G,es,tf,cr,sf,Ys,nf,af,Ii,cf,lf,df,oo,pf,to,zl,lr,so,qi,rs,mf,zi,hf,Al,he,os,uf,ts,ff,ss,gf,vf,_f,X,ns,Pf,dr,bf,en,wf,yf,Ai,$f,kf,Tf,no,xf,ao,Dl,pr,io,Di,as,Ef,Oi,Ff,Ol,q,is,Cf,Ni,jf,Mf,Li,If,qf,S,rn,zf,Af,on,Df,Of,Si,Nf,Lf,tn,Sf,Bf,sn,Hf,Wf,Vf,cs,Uf,ls,Rf,Kf,Jf,Z,ds,Gf,mr,Xf,nn,Zf,Qf,Bi,Yf,eg,rg,co,og,lo,Nl,hr,po,Hi,ps,tg,Wi,sg,Ll,z,ms,ng,Vi,ag,ig,Ui,cg,lg,B,an,dg,pg,cn,mg,hg,Ri,ug,fg,ln,gg,vg,dn,_g,Pg,bg,hs,wg,us,yg,$g,kg,Q,fs,Tg,ur,xg,pn,Eg,Fg,Ki,Cg,jg,Mg,mo,Ig,ho,Sl,fr,uo,Ji,gs,qg,Gi,zg,Bl,A,vs,Ag,Xi,Dg,Og,Zi,Ng,Lg,H,mn,Sg,Bg,hn,Hg,Wg,Qi,Vg,Ug,un,Rg,Kg,fn,Jg,Gg,Xg,_s,Zg,Ps,Qg,Yg,ev,Y,bs,rv,gr,ov,gn,tv,sv,Yi,nv,av,iv,fo,cv,go,Hl,vr,vo,ec,ws,lv,rc,dv,Wl,O,ys,pv,N,mv,vn,hv,uv,_n,fv,gv,oc,vv,_v,Pn,Pv,bv,bn,wv,yv,$v,tc,kv,Tv,$s,xv,ks,Ev,Fv,Cv,ee,Ts,jv,_r,Mv,wn,Iv,qv,sc,zv,Av,Dv,_o,Ov,Po,Vl,Pr,bo,nc,xs,Nv,ac,Lv,Ul,j,Es,Sv,ic,Bv,Hv,wo,yn,Wv,Vv,$n,Uv,Rv,Kv,be,kn,Jv,Gv,Tn,Xv,Zv,xn,Qv,Yv,e_,yo,En,r_,o_,Fn,t_,s_,n_,Fs,a_,cc,i_,c_,l_,lc,d_,p_,Cs,m_,js,h_,u_,f_,re,Ms,g_,br,v_,Cn,__,P_,dc,b_,w_,y_,$o,$_,ko,Rl;return p=new C({}),Do=new C({}),Jo=new C({}),Go=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"last_hidden_state",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L62"}}),Xo=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Output of the basic decoder.`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L93"}}),Zo=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L111"}}),Qo=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L142"}}),Yo=new C({}),et=new x({props:{name:"class transformers.PerceiverConfig",anchor:"transformers.PerceiverConfig",parameters:[{name:"num_latents",val:" = 256"},{name:"d_latents",val:" = 1280"},{name:"d_model",val:" = 768"},{name:"num_blocks",val:" = 1"},{name:"num_self_attends_per_block",val:" = 26"},{name:"num_self_attention_heads",val:" = 8"},{name:"num_cross_attention_heads",val:" = 8"},{name:"qk_channels",val:" = None"},{name:"v_channels",val:" = None"},{name:"cross_attention_shape_for_attention",val:" = 'kv'"},{name:"self_attention_widening_factor",val:" = 1"},{name:"cross_attention_widening_factor",val:" = 1"},{name:"hidden_act",val:" = 'gelu'"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"position_embedding_init_scale",val:" = 0.02"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"is_encoder_decoder",val:" = False"},{name:"use_query_residual",val:" = True"},{name:"vocab_size",val:" = 262"},{name:"max_position_embeddings",val:" = 2048"},{name:"image_size",val:" = 56"},{name:"train_size",val:" = [368, 496]"},{name:"num_frames",val:" = 16"},{name:"audio_samples_per_frame",val:" = 1920"},{name:"samples_per_patch",val:" = 16"},{name:"output_shape",val:" = [1, 16, 224, 224]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverConfig.num_latents",description:`<strong>num_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of latents.`,name:"num_latents"},{anchor:"transformers.PerceiverConfig.d_latents",description:`<strong>d_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
Dimension of the latent embeddings.`,name:"d_latents"},{anchor:"transformers.PerceiverConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the inputs. Should only be provided in case [<em>PerceiverTextPreprocessor</em>] is used or no
preprocessor is provided.`,name:"d_model"},{anchor:"transformers.PerceiverConfig.num_blocks",description:`<strong>num_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of blocks in the Transformer encoder.`,name:"num_blocks"},{anchor:"transformers.PerceiverConfig.num_self_attends_per_block",description:`<strong>num_self_attends_per_block</strong> (<code>int</code>, <em>optional</em>, defaults to 26) &#x2014;
The number of self-attention layers per block.`,name:"num_self_attends_per_block"},{anchor:"transformers.PerceiverConfig.num_self_attention_heads",description:`<strong>num_self_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each self-attention layer in the Transformer encoder.`,name:"num_self_attention_heads"},{anchor:"transformers.PerceiverConfig.num_cross_attention_heads",description:`<strong>num_cross_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each cross-attention layer in the Transformer encoder.`,name:"num_cross_attention_heads"},{anchor:"transformers.PerceiverConfig.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the queries + keys before applying attention in the cross-attention and self-attention
layers of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"qk_channels"},{anchor:"transformers.PerceiverConfig.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the values before applying attention in the cross-attention and self-attention layers
of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"v_channels"},{anchor:"transformers.PerceiverConfig.cross_attention_shape_for_attention",description:`<strong>cross_attention_shape_for_attention</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&apos;kv&apos;</code>) &#x2014;
Dimension to use when downsampling the queries and keys in the cross-attention layer of the encoder.`,name:"cross_attention_shape_for_attention"},{anchor:"transformers.PerceiverConfig.self_attention_widening_factor",description:`<strong>self_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the cross-attention layer of the Transformer encoder.`,name:"self_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.cross_attention_widening_factor",description:`<strong>cross_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the self-attention layers of the Transformer encoder.`,name:"cross_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.PerceiverConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.PerceiverConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PerceiverConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.PerceiverConfig.use_query_residual",description:`<strong>use_query_residual</strong> (<code>float</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a query residual in the cross-attention layer of the encoder.`,name:"use_query_residual"},{anchor:"transformers.PerceiverConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 262) &#x2014;
Vocabulary size for the masked language modeling model.`,name:"vocab_size"},{anchor:"transformers.PerceiverConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that the masked language modeling model might ever be used with. Typically set
this to something large just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.PerceiverConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 56) &#x2014;
Size of the images after preprocessing, for <a href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a>.`,name:"image_size"},{anchor:"transformers.PerceiverConfig.train_size",description:`<strong>train_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to [368, 496]) &#x2014;
Training size of the images for the optical flow model.`,name:"train_size"},{anchor:"transformers.PerceiverConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of video frames used for the multimodal autoencoding model.`,name:"num_frames"},{anchor:"transformers.PerceiverConfig.audio_samples_per_frame",description:`<strong>audio_samples_per_frame</strong> (<code>int</code>, <em>optional</em>, defaults to 1920) &#x2014;
Number of audio samples per frame for the multimodal autoencoding model.`,name:"audio_samples_per_frame"},{anchor:"transformers.PerceiverConfig.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of audio samples per patch when preprocessing the audio for the multimodal autoencoding model.`,name:"samples_per_patch"},{anchor:"transformers.PerceiverConfig.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 16, 224, 224]</code>) &#x2014;
Shape of the output (batch_size, num_frames, height, width) for the video decoder queries of the multimodal
autoencoding model. This excludes the channel dimension.`,name:"output_shape"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/configuration_perceiver.py#L29"}}),Ir=new yr({props:{anchor:"transformers.PerceiverConfig.example",$$slots:{default:[Pw]},$$scope:{ctx:E}}}),ot=new C({}),tt=new x({props:{name:"class transformers.PerceiverTokenizer",anchor:"transformers.PerceiverTokenizer",parameters:[{name:"pad_token",val:" = '[PAD]'"},{name:"bos_token",val:" = '[BOS]'"},{name:"eos_token",val:" = '[EOS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"model_max_length",val:" = 2048"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.PerceiverTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[BOS]&quot;</code>) &#x2014;
The BOS token (reserved in the vocab, but not actually used).`,name:"bos_token"},{anchor:"transformers.PerceiverTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[EOS]&quot;</code>) &#x2014;
The end of sequence token (reserved in the vocab, but not actually used).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.PerceiverTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The MASK token, useful for masked language modeling.`,name:"mask_token"},{anchor:"transformers.PerceiverTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The CLS token (reserved in the vocab, but not actually used).`,name:"cls_token"},{anchor:"transformers.PerceiverTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from two sequences.`,name:"sep_token"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/tokenization_perceiver.py#L27"}}),nt=new x({props:{name:"__call__",anchor:"transformers.PerceiverTokenizer.__call__",parameters:[{name:"text",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]]]"},{name:"text_pair",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.tokenization_utils_base.TruncationStrategy] = False"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"stride",val:": int = 0"},{name:"is_split_into_words",val:": bool = False"},{name:"pad_to_multiple_of",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"return_token_type_ids",val:": typing.Optional[bool] = None"},{name:"return_attention_mask",val:": typing.Optional[bool] = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair",description:`<strong>text_pair</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair"},{anchor:"transformers.PerceiverTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to encode the sequences with the special tokens relative to their model.`,name:"add_special_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.19.1/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.PerceiverTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.19.1/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.PerceiverTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.PerceiverTokenizer.__call__.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.PerceiverTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.PerceiverTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability &gt;= 7.5 (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.PerceiverTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.19.1/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverTokenizer.__call__.return_token_type_ids",description:`<strong>return_token_type_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return token type IDs. If left to the default, will return the token type IDs according to
the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"return_token_type_ids"},{anchor:"transformers.PerceiverTokenizer.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"return_attention_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_overflowing_tokens",description:`<strong>return_overflowing_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return overflowing token sequences. If a pair of sequences of input ids (or a batch
of pairs) is provided with <code>truncation_strategy = longest_first</code> or <code>True</code>, an error is raised instead
of returning overflowing tokens.`,name:"return_overflowing_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.return_special_tokens_mask",description:`<strong>return_special_tokens_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return special tokens mask information.`,name:"return_special_tokens_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_offsets_mapping",description:`<strong>return_offsets_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return <code>(char_start, char_end)</code> for each token.</p>
<p>This is only available on fast tokenizers inheriting from <a href="/docs/transformers/v4.19.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a>, if using
Python&#x2019;s tokenizer, this method will raise <code>NotImplementedError</code>.`,name:"return_offsets_mapping"},{anchor:"transformers.PerceiverTokenizer.__call__.return_length",description:`<strong>return_length</strong>  (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the lengths of the encoded inputs.`,name:"return_length"},{anchor:"transformers.PerceiverTokenizer.__call__.verbose",description:`<strong>verbose</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to print more information and warnings.
**kwargs &#x2014; passed to the <code>self.tokenize()</code> method`,name:"verbose"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/tokenization_utils_base.py#L2393",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.19.1/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a> with the following fields:</p>
<ul>
<li>
<p><strong>input_ids</strong> \u2014 List of token ids to be fed to a model.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
</li>
<li>
<p><strong>token_type_ids</strong> \u2014 List of token type ids to be fed to a model (when <code>return_token_type_ids=True</code> or
if <em>\u201Ctoken_type_ids\u201D</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a></p>
</li>
<li>
<p><strong>attention_mask</strong> \u2014 List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>\u201Cattention_mask\u201D</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
</li>
<li>
<p><strong>overflowing_tokens</strong> \u2014 List of overflowing tokens sequences (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>num_truncated_tokens</strong> \u2014 Number of tokens truncated (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>special_tokens_mask</strong> \u2014 List of 0s and 1s, with 1 specifying added special tokens and 0 specifying
regular sequence tokens (when <code>add_special_tokens=True</code> and <code>return_special_tokens_mask=True</code>).</p>
</li>
<li>
<p><strong>length</strong> \u2014 The length of the inputs (when <code>return_length=True</code>)</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.19.1/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),at=new C({}),it=new x({props:{name:"class transformers.PerceiverFeatureExtractor",anchor:"transformers.PerceiverFeatureExtractor",parameters:[{name:"do_center_crop",val:" = True"},{name:"crop_size",val:" = 256"},{name:"do_resize",val:" = True"},{name:"size",val:" = 224"},{name:"resample",val:" = <Resampling.BICUBIC: 3>"},{name:"do_normalize",val:" = True"},{name:"image_mean",val:" = None"},{name:"image_std",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverFeatureExtractor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to crop the input at the center. If the input size is smaller than <code>crop_size</code> along any edge, the
image is padded with 0&#x2019;s and then center cropped.`,name:"do_center_crop"},{anchor:"transformers.PerceiverFeatureExtractor.crop_size",description:`<strong>crop_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Desired output size when applying center-cropping. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.PerceiverFeatureExtractor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.PerceiverFeatureExtractor.size",description:`<strong>size</strong> (<code>int</code> or <code>Tuple(int)</code>, <em>optional</em>, defaults to 224) &#x2014;
Resize the input to the given size. If a tuple is provided, it should be (width, height). If only an
integer is provided, then the input will be resized to (size, size). Only has an effect if <code>do_resize</code> is
set to <code>True</code>.`,name:"size"},{anchor:"transformers.PerceiverFeatureExtractor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>PIL.Image.BICUBIC</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.NEAREST</code>, <code>PIL.Image.BOX</code>,
<code>PIL.Image.BILINEAR</code>, <code>PIL.Image.HAMMING</code>, <code>PIL.Image.BICUBIC</code> or <code>PIL.Image.LANCZOS</code>. Only has an effect
if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.PerceiverFeatureExtractor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with <code>image_mean</code> and <code>image_std</code>.`,name:"do_normalize"},{anchor:"transformers.PerceiverFeatureExtractor.image_mean",description:`<strong>image_mean</strong> (<code>List[int]</code>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images.`,name:"image_mean"},{anchor:"transformers.PerceiverFeatureExtractor.image_std",description:`<strong>image_std</strong> (<code>List[int]</code>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/feature_extraction_perceiver.py#L36"}}),lt=new x({props:{name:"__call__",anchor:"transformers.PerceiverFeatureExtractor.__call__",parameters:[{name:"images",val:": typing.Union[PIL.Image.Image, numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverFeatureExtractor.__call__.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. In case of a NumPy array/PyTorch tensor, each image should be of shape (C, H, W), where C is a
number of channels, H and W are image height and width.`,name:"images"},{anchor:"transformers.PerceiverFeatureExtractor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.19.1/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>, defaults to <code>&apos;np&apos;</code>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/feature_extraction_perceiver.py#L120",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.19.1/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> \u2014 Pixel values to be fed to a model, of shape (batch_size, num_channels, height,
width).</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.19.1/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Dr=new wr({props:{warning:!0,$$slots:{default:[bw]},$$scope:{ctx:E}}}),dt=new C({}),pt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L2795"}}),ut=new C({}),ft=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:" = 'conv'"},{name:"spatial_downsample",val:": int = 4"},{name:"temporal_downsample",val:": int = 1"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 64"},{name:"conv_after_patching",val:": bool = False"},{name:"conv_after_patching_in_channels",val:": int = 54"},{name:"conv2d_use_batchnorm",val:": bool = True"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"project_pos_dim",val:": int = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;conv&quot;</code>) &#x2014;
Preprocessing type. Can be &#x201C;conv1x1&#x201D;, &#x201C;conv&#x201D;, &#x201C;patches&#x201D;, &#x201C;pixels&#x201D;.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.spatial_downsample",description:`<strong>spatial_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Spatial downsampling factor.`,name:"spatial_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.temporal_downsample",description:`<strong>temporal_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Temporal downsampling factor (only relevant in case a time dimension is present).`,name:"temporal_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Position encoding type. Can be &#x201C;fourier&#x201D; or &#x201C;trainable&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching",description:`<strong>conv_after_patching</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply a convolutional layer after patching.`,name:"conv_after_patching"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching_in_channels",description:`<strong>conv_after_patching_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 54) &#x2014;
Number of channels in the input of the convolutional layer after patching.`,name:"conv_after_patching_in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv2d_use_batchnorm",description:`<strong>conv2d_use_batchnorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use batch normalization in the convolutional layer.`,name:"conv2d_use_batchnorm"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L2952"}}),gt=new C({}),vt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L3181"}}),_t=new C({}),Pt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:": str = 'patches'"},{name:"samples_per_patch",val:": int = 96"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"out_channels",val:" = 64"},{name:"project_pos_dim",val:" = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Preprocessor type to use. Only &#x201C;patches&#x201D; is supported.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Number of samples per patch.`,name:"samples_per_patch"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Type of position encoding to use. Can be &#x201C;trainable&#x201D; or &#x201C;fourier&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L3207"}}),bt=new C({}),wt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",parameters:[{name:"modalities",val:": typing.Mapping[str, typing.Callable[..., typing.Tuple[torch.Tensor, typing.Optional[torch.Tensor], torch.Tensor]]]"},{name:"mask_probs",val:": typing.Union[typing.Mapping[str, float], NoneType] = None"},{name:"min_padding_size",val:": int = 2"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PreprocessorType]</code>) &#x2014;
Dict mapping modality name to preprocessor.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.mask_probs",description:`<strong>mask_probs</strong> (<code>Dict[str, float]</code>) &#x2014;
Dict mapping modality name to masking probability of that modality.`,name:"mask_probs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L3304"}}),yt=new C({}),$t=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L2007"}}),kt=new C({}),Tt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_num_channels",val:": int"},{name:"position_encoding_type",val:": typing.Optional[str] = 'trainable'"},{name:"output_index_dims",val:": typing.Optional[int] = None"},{name:"num_channels",val:": typing.Optional[int] = 128"},{name:"subsampled_index_dims",val:": typing.Optional[int] = None"},{name:"qk_channels",val:": typing.Optional[int] = None"},{name:"v_channels",val:": typing.Optional[int] = None"},{name:"num_heads",val:": typing.Optional[int] = 1"},{name:"widening_factor",val:": typing.Optional[int] = 1"},{name:"use_query_residual",val:": typing.Optional[bool] = False"},{name:"concat_preprocessed_input",val:": typing.Optional[bool] = False"},{name:"final_project",val:": typing.Optional[bool] = True"},{name:"position_encoding_only",val:": typing.Optional[bool] = False"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels in the output. Will only be used in case <em>final_project</em> is set to <code>True</code>.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;trainable&#x201D;) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_index_dims",description:`<strong>output_index_dims</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of dimensions of the output queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"output_index_dims"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The number of channels of the decoder queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the queries and keys in the cross-attention layer.`,name:"qk_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the values in the cross-attention layer.`,name:"v_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of attention heads in the cross-attention layer.`,name:"num_heads"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.widening_factor",description:`<strong>widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The widening factor of the cross-attention layer.`,name:"widening_factor"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.use_query_residual",description:`<strong>use_query_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a residual connection between the query and the output of the cross-attention layer.`,name:"use_query_residual"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.concat_preprocessed_input",description:`<strong>concat_preprocessed_input</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the preprocessed input to the query.`,name:"concat_preprocessed_input"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.final_project",description:`<strong>final_project</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to project the output of the cross-attention layer to a target dimension.`,name:"final_project"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_only",description:`<strong>position_encoding_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only use this class to define output queries.`,name:"position_encoding_only"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L2033"}}),xt=new C({}),Et=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",parameters:[{name:"config",val:""},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L2219"}}),Ct=new C({}),jt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",parameters:[{name:"config",val:""},{name:"output_image_shape",val:""},{name:"output_num_channels",val:" = 2"},{name:"rescale_factor",val:" = 100.0"},{name:"**decoder_kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L2265"}}),Mt=new C({}),It=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_shape",val:": typing.List[int]"},{name:"position_encoding_type",val:": str"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>) &#x2014;
Shape of the output as (batch_size, num_frames, height, width), excluding the channel dimension.`,name:"output_shape"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L2300"}}),zt=new C({}),At=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"modalities",val:": typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder]"},{name:"num_outputs",val:": int"},{name:"output_num_channels",val:": int"},{name:"min_padding_size",val:": typing.Optional[int] = 2"},{name:"subsampled_index_dims",val:": typing.Union[typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder], NoneType] = None"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>) &#x2014;
Dictionary mapping modality name to the decoder of that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.num_outputs",description:`<strong>num_outputs</strong> (<code>int</code>) &#x2014;
The number of outputs of the decoder.`,name:"num_outputs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>) &#x2014;
The number of channels in the output.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.subsampled_index_dims",description:`<strong>subsampled_index_dims</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>, <em>optional</em>) &#x2014;
Dictionary mapping modality name to the subsampled index dimensions to use for the decoder query of that
modality.`,name:"subsampled_index_dims"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L2377"}}),Ot=new C({}),Nt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",parameters:[{name:"in_channels",val:": int"},{name:"out_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the output.`,name:"out_channels"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L2931"}}),Lt=new C({}),St=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"},{name:"postproc_type",val:": str = 'patches'"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.postproc_type",description:`<strong>postproc_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Postprocessor type to use. Currently, only &#x201C;patches&#x201D; is supported.`,name:"postproc_type"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L2903"}}),Bt=new C({}),Ht=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L2883"}}),Wt=new C({}),Vt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",parameters:[{name:"modalities",val:": typing.Mapping[str, typing.Callable[..., typing.Any]]"},{name:"input_is_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PostprocessorType]</code>) &#x2014;
Dictionary mapping modality name to postprocessor class for that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.input_is_dict",description:`<strong>input_is_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, input is assumed to be dictionary structured, and outputs keep the same dictionary shape. If
False, input is a tensor which is sliced up during postprocessing by <em>modality_sizes</em>.`,name:"input_is_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L2849"}}),Ut=new C({}),Rt=new x({props:{name:"class transformers.PerceiverModel",anchor:"transformers.PerceiverModel",parameters:[{name:"config",val:""},{name:"decoder",val:" = None"},{name:"input_preprocessor",val:": typing.Callable[..., typing.Tuple[torch.Tensor, typing.Optional[torch.Tensor], torch.Tensor]] = None"},{name:"output_postprocessor",val:": typing.Callable[..., typing.Any] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.19.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.PerceiverModel.decoder",description:`<strong>decoder</strong> (<em>DecoderType</em>, <em>optional</em>) &#x2014;
Optional decoder to use to decode the latent representation of the encoder. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder</em>.`,name:"decoder"},{anchor:"transformers.PerceiverModel.input_preprocessor",description:`<strong>input_preprocessor</strong> (<em>PreprocessorType</em>, <em>optional</em>) &#x2014;
Optional input preprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor</em>.`,name:"input_preprocessor"},{anchor:"transformers.PerceiverModel.output_postprocessor",description:`<strong>output_postprocessor</strong> (<em>PostprocessorType</em>, <em>optional</em>) &#x2014;
Optional output postprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor</em>.`,name:"output_postprocessor"},{anchor:"transformers.PerceiverModel.Note",description:"<strong>Note</strong> that you can define your own decoders, preprocessors and/or postprocessors to fit your use-case. &#x2014;",name:"Note"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L717"}}),Gt=new x({props:{name:"forward",anchor:"transformers.PerceiverModel.forward",parameters:[{name:"inputs",val:": FloatTensor"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"subsampled_output_points",val:": typing.Union[typing.Dict[str, torch.Tensor], NoneType] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.19.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L753",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) \u2014 Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Yr=new wr({props:{$$slots:{default:[ww]},$$scope:{ctx:E}}}),eo=new yr({props:{anchor:"transformers.PerceiverModel.forward.example",$$slots:{default:[yw]},$$scope:{ctx:E}}}),Xt=new C({}),Zt=new x({props:{name:"class transformers.PerceiverForMaskedLM",anchor:"transformers.PerceiverForMaskedLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.19.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L950"}}),es=new x({props:{name:"forward",anchor:"transformers.PerceiverForMaskedLM.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.19.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L981",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Masked language modeling (MLM) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) \u2014 Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oo=new wr({props:{$$slots:{default:[$w]},$$scope:{ctx:E}}}),to=new yr({props:{anchor:"transformers.PerceiverForMaskedLM.forward.example",$$slots:{default:[kw]},$$scope:{ctx:E}}}),rs=new C({}),os=new x({props:{name:"class transformers.PerceiverForSequenceClassification",anchor:"transformers.PerceiverForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.19.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L1077"}}),ns=new x({props:{name:"forward",anchor:"transformers.PerceiverForSequenceClassification.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.19.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L1098",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),no=new wr({props:{$$slots:{default:[Tw]},$$scope:{ctx:E}}}),ao=new yr({props:{anchor:"transformers.PerceiverForSequenceClassification.forward.example",$$slots:{default:[xw]},$$scope:{ctx:E}}}),as=new C({}),is=new x({props:{name:"class transformers.PerceiverForImageClassificationLearned",anchor:"transformers.PerceiverForImageClassificationLearned",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.19.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L1200"}}),ds=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationLearned.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.19.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L1231",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),co=new wr({props:{$$slots:{default:[Ew]},$$scope:{ctx:E}}}),lo=new yr({props:{anchor:"transformers.PerceiverForImageClassificationLearned.forward.example",$$slots:{default:[Fw]},$$scope:{ctx:E}}}),ps=new C({}),ms=new x({props:{name:"class transformers.PerceiverForImageClassificationFourier",anchor:"transformers.PerceiverForImageClassificationFourier",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.19.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L1339"}}),fs=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationFourier.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.19.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L1368",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),mo=new wr({props:{$$slots:{default:[Cw]},$$scope:{ctx:E}}}),ho=new yr({props:{anchor:"transformers.PerceiverForImageClassificationFourier.forward.example",$$slots:{default:[jw]},$$scope:{ctx:E}}}),gs=new C({}),vs=new x({props:{name:"class transformers.PerceiverForImageClassificationConvProcessing",anchor:"transformers.PerceiverForImageClassificationConvProcessing",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.19.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L1475"}}),bs=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.19.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L1505",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fo=new wr({props:{$$slots:{default:[Mw]},$$scope:{ctx:E}}}),go=new yr({props:{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.example",$$slots:{default:[Iw]},$$scope:{ctx:E}}}),ws=new C({}),ys=new x({props:{name:"class transformers.PerceiverForOpticalFlow",anchor:"transformers.PerceiverForOpticalFlow",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.19.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L1612"}}),Ts=new x({props:{name:"forward",anchor:"transformers.PerceiverForOpticalFlow.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForOpticalFlow.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForOpticalFlow.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.19.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForOpticalFlow.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the optical flow loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L1659",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),_o=new wr({props:{$$slots:{default:[qw]},$$scope:{ctx:E}}}),Po=new yr({props:{anchor:"transformers.PerceiverForOpticalFlow.forward.example",$$slots:{default:[zw]},$$scope:{ctx:E}}}),xs=new C({}),Es=new x({props:{name:"class transformers.PerceiverForMultimodalAutoencoding",anchor:"transformers.PerceiverForMultimodalAutoencoding",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.19.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L1752"}}),Ms=new x({props:{name:"forward",anchor:"transformers.PerceiverForMultimodalAutoencoding.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"subsampled_output_points",val:": typing.Union[typing.Dict[str, torch.Tensor], NoneType] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.19.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.19.1/src/transformers/models/perceiver/modeling_perceiver.py#L1868",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$o=new wr({props:{$$slots:{default:[Aw]},$$scope:{ctx:E}}}),ko=new yr({props:{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.example",$$slots:{default:[Dw]},$$scope:{ctx:E}}}),{c(){u=t("meta"),T=l(),v=t("h1"),g=t("a"),k=t("span"),_(p.$$.fragment),f=l(),F=t("span"),ep=a("Perceiver"),xc=l(),$e=t("h2"),Tr=t("a"),Xn=t("span"),_(Do.$$.fragment),rp=l(),Zn=t("span"),op=a("Overview"),Ec=l(),xr=t("p"),tp=a("The Perceiver IO model was proposed in "),Oo=t("a"),sp=a(`Perceiver IO: A General Architecture for Structured Inputs &
Outputs`),np=a(` by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch,
Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier H\xE9naff, Matthew M.
Botvinick, Andrew Zisserman, Oriol Vinyals, Jo\xE3o Carreira.`),Fc=l(),Er=t("p"),ap=a("Perceiver IO is a generalization of "),No=t("a"),ip=a("Perceiver"),cp=a(` to handle arbitrary outputs in
addition to arbitrary inputs. The original Perceiver only produced a single classification label. In addition to
classification labels, Perceiver IO can produce (for example) language, optical flow, and multimodal videos with audio.
This is done using the same building blocks as the original Perceiver. The computational complexity of Perceiver IO is
linear in the input and output size and the bulk of the processing occurs in the latent space, allowing us to process
inputs and outputs that are much larger than can be handled by standard Transformers. This means, for example,
Perceiver IO can do BERT-style masked language modeling directly using bytes instead of tokenized inputs.`),Cc=l(),Ns=t("p"),lp=a("The abstract from the paper is the following:"),jc=l(),Ls=t("p"),Qn=t("em"),dp=a(`The recently-proposed Perceiver model obtains good results on several domains (images, audio, multimodal, point
clouds) while scaling linearly in compute and memory with the input size. While the Perceiver supports many kinds of
inputs, it can only produce very simple outputs such as class scores. Perceiver IO overcomes this limitation without
sacrificing the original\u2019s appealing properties by learning to flexibly query the model\u2019s latent space to produce
outputs of arbitrary size and semantics. Perceiver IO still decouples model depth from data size and still scales
linearly with data size, but now with respect to both input and output sizes. The full Perceiver IO model achieves
strong results on tasks with highly structured output spaces, such as natural language and visual understanding,
StarCraft II, and multi-task and multi-modal domains. As highlights, Perceiver IO matches a Transformer-based BERT
baseline on the GLUE language benchmark without the need for input tokenization and achieves state-of-the-art
performance on Sintel optical flow estimation.`),Mc=l(),Ss=t("p"),pp=a("Here\u2019s a TLDR explaining how Perceiver works:"),Ic=l(),Bs=t("p"),mp=a(`The main problem with the self-attention mechanism of the Transformer is that the time and memory requirements scale
quadratically with the sequence length. Hence, models like BERT and RoBERTa are limited to a max sequence length of 512
tokens. Perceiver aims to solve this issue by, instead of performing self-attention on the inputs, perform it on a set
of latent variables, and only use the inputs for cross-attention. In this way, the time and memory requirements don\u2019t
depend on the length of the inputs anymore, as one uses a fixed amount of latent variables, like 256 or 512. These are
randomly initialized, after which they are trained end-to-end using backpropagation.`),qc=l(),D=t("p"),hp=a("Internally, "),Hs=t("a"),up=a("PerceiverModel"),fp=a(" will create the latents, which is a tensor of shape "),Yn=t("code"),gp=a("(batch_size, num_latents, d_latents)"),vp=a(". One must provide "),ea=t("code"),_p=a("inputs"),Pp=a(` (which could be text, images, audio, you name it!) to the model, which it will
use to perform cross-attention with the latents. The output of the Perceiver encoder is a tensor of the same shape. One
can then, similar to BERT, convert the last hidden states of the latents to classification logits by averaging along
the sequence dimension, and placing a linear layer on top of that to project the `),ra=t("code"),bp=a("d_latents"),wp=a(" to "),oa=t("code"),yp=a("num_labels"),$p=a("."),zc=l(),Ws=t("p"),kp=a(`This was the idea of the original Perceiver paper. However, it could only output classification logits. In a follow-up
work, PerceiverIO, they generalized it to let the model also produce outputs of arbitrary size. How, you might ask? The
idea is actually relatively simple: one defines outputs of an arbitrary size, and then applies cross-attention with the
last hidden states of the latents, using the outputs as queries, and the latents as keys and values.`),Ac=l(),M=t("p"),Tp=a(`So let\u2019s say one wants to perform masked language modeling (BERT-style) with the Perceiver. As the Perceiver\u2019s input
length will not have an impact on the computation time of the self-attention layers, one can provide raw bytes,
providing `),ta=t("code"),xp=a("inputs"),Ep=a(` of length 2048 to the model. If one now masks out certain of these 2048 tokens, one can define the
`),sa=t("code"),Fp=a("outputs"),Cp=a(" as being of shape: "),na=t("code"),jp=a("(batch_size, 2048, 768)"),Mp=a(`. Next, one performs cross-attention with the final hidden states
of the latents to update the `),aa=t("code"),Ip=a("outputs"),qp=a(" tensor. After cross-attention, one still has a tensor of shape "),ia=t("code"),zp=a("(batch_size, 2048, 768)"),Ap=a(`. One can then place a regular language modeling head on top, to project the last dimension to the
vocabulary size of the model, i.e. creating logits of shape `),ca=t("code"),Dp=a("(batch_size, 2048, 262)"),Op=a(` (as Perceiver uses a vocabulary
size of 262 byte IDs).`),Dc=l(),Fr=t("img"),Oc=l(),Lo=t("small"),Np=a("Perceiver IO architecture. Taken from the "),Vs=t("a"),Lp=a("original paper"),Nc=l(),ve=t("p"),Sp=a("This model was contributed by "),So=t("a"),Bp=a("nielsr"),Hp=a(`. The original code can be found
`),Bo=t("a"),Wp=a("here"),Vp=a("."),Lc=l(),Us=t("p"),Up=a("Tips:"),Sc=l(),Cr=t("ul"),Ho=t("li"),Rp=a("The quickest way to get started with the Perceiver is by checking the "),Wo=t("a"),Kp=a(`tutorial
notebooks`),Jp=a("."),Gp=l(),Vo=t("li"),Xp=a("Refer to the "),Uo=t("a"),Zp=a("blog post"),Qp=a(` if you want to fully understand how the model works and
is implemented in the library. Note that the models available in the library only showcase some examples of what you can do
with the Perceiver. There are many more use cases, including question answering, named-entity recognition, object detection,
audio classification, video classification, etc.`),Bc=l(),Ro=t("p"),la=t("strong"),Yp=a("Note"),em=a(":"),Hc=l(),Rs=t("ul"),_e=t("li"),rm=a("Perceiver does "),da=t("strong"),om=a("not"),tm=a(" work with "),pa=t("code"),sm=a("torch.nn.DataParallel"),nm=a(" due to a bug in PyTorch, see "),Ko=t("a"),am=a("issue #36035"),Wc=l(),ke=t("h2"),jr=t("a"),ma=t("span"),_(Jo.$$.fragment),im=l(),ha=t("span"),cm=a("Perceiver specific outputs"),Vc=l(),Te=t("div"),_(Go.$$.fragment),lm=l(),ua=t("p"),dm=a("Base class for Perceiver base model\u2019s outputs, with potential hidden states, attentions and cross-attentions."),Uc=l(),xe=t("div"),_(Xo.$$.fragment),pm=l(),fa=t("p"),mm=a("Base class for Perceiver decoder outputs, with potential cross-attentions."),Rc=l(),Ee=t("div"),_(Zo.$$.fragment),hm=l(),ga=t("p"),um=a("Base class for Perceiver\u2019s masked language model outputs."),Kc=l(),Fe=t("div"),_(Qo.$$.fragment),fm=l(),va=t("p"),gm=a(`Base class for Perceiver\u2019s outputs of sequence/image classification models, optical flow and multimodal
autoencoding.`),Jc=l(),Ce=t("h2"),Mr=t("a"),_a=t("span"),_(Yo.$$.fragment),vm=l(),Pa=t("span"),_m=a("PerceiverConfig"),Gc=l(),V=t("div"),_(et.$$.fragment),Pm=l(),je=t("p"),bm=a("This is the configuration class to store the configuration of a "),Ks=t("a"),wm=a("PerceiverModel"),ym=a(`. It is used to instantiate an
Perceiver model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Perceiver
`),rt=t("a"),$m=a("deepmind/language-perceiver"),km=a(" architecture."),Tm=l(),Me=t("p"),xm=a("Configuration objects inherit from "),Js=t("a"),Em=a("PretrainedConfig"),Fm=a(` and can be used to control the model outputs. Read the
documentation from `),Gs=t("a"),Cm=a("PretrainedConfig"),jm=a(" for more information."),Mm=l(),_(Ir.$$.fragment),Xc=l(),Ie=t("h2"),qr=t("a"),ba=t("span"),_(ot.$$.fragment),Im=l(),wa=t("span"),qm=a("PerceiverTokenizer"),Zc=l(),U=t("div"),_(tt.$$.fragment),zm=l(),ya=t("p"),Am=a("Construct a Perceiver tokenizer. The Perceiver simply uses raw bytes utf-8 encoding."),Dm=l(),st=t("p"),Om=a("This tokenizer inherits from "),Xs=t("a"),Nm=a("PreTrainedTokenizer"),Lm=a(` which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`),Sm=l(),zr=t("div"),_(nt.$$.fragment),Bm=l(),$a=t("p"),Hm=a(`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`),Qc=l(),qe=t("h2"),Ar=t("a"),ka=t("span"),_(at.$$.fragment),Wm=l(),Ta=t("span"),Vm=a("PerceiverFeatureExtractor"),Yc=l(),R=t("div"),_(it.$$.fragment),Um=l(),xa=t("p"),Rm=a("Constructs a Perceiver feature extractor."),Km=l(),ct=t("p"),Jm=a("This feature extractor inherits from "),Zs=t("a"),Gm=a("ImageFeatureExtractionMixin"),Xm=a(` which contains most of the main methods. Users
should refer to this superclass for more information regarding those methods.`),Zm=l(),Pe=t("div"),_(lt.$$.fragment),Qm=l(),Ea=t("p"),Ym=a("Main method to prepare for the model one or several image(s)."),eh=l(),_(Dr.$$.fragment),el=l(),ze=t("h2"),Or=t("a"),Fa=t("span"),_(dt.$$.fragment),rh=l(),Ca=t("span"),oh=a("PerceiverTextPreprocessor"),rl=l(),ae=t("div"),_(pt.$$.fragment),th=l(),mt=t("p"),sh=a("Text preprocessing for Perceiver Encoder. Can be used to embed "),ja=t("code"),nh=a("inputs"),ah=a(" and add positional encodings."),ih=l(),ht=t("p"),ch=a("The dimensionality of the embeddings is determined by the "),Ma=t("code"),lh=a("d_model"),dh=a(" attribute of the configuration."),ol=l(),Ae=t("h2"),Nr=t("a"),Ia=t("span"),_(ut.$$.fragment),ph=l(),qa=t("span"),mh=a("PerceiverImagePreprocessor"),tl=l(),ie=t("div"),_(ft.$$.fragment),hh=l(),za=t("p"),uh=a("Image preprocessing for Perceiver Encoder."),fh=l(),K=t("p"),gh=a("Note: the "),Aa=t("em"),vh=a("out_channels"),_h=a(" argument refers to the output channels of a convolutional layer, if "),Da=t("em"),Ph=a("prep_type"),bh=a(` is set to
\u201Cconv1x1\u201D or \u201Cconv\u201D. If one adds absolute position embeddings, one must make sure the `),Oa=t("em"),wh=a("num_channels"),yh=a(` of the
position encoding kwargs are set equal to the `),Na=t("em"),$h=a("out_channels"),kh=a("."),sl=l(),De=t("h2"),Lr=t("a"),La=t("span"),_(gt.$$.fragment),Th=l(),Sa=t("span"),xh=a("PerceiverOneHotPreprocessor"),nl=l(),Oe=t("div"),_(vt.$$.fragment),Eh=l(),Ba=t("p"),Fh=a("One-hot preprocessor for Perceiver Encoder. Can be used to add a dummy index dimension to the input."),al=l(),Ne=t("h2"),Sr=t("a"),Ha=t("span"),_(_t.$$.fragment),Ch=l(),Wa=t("span"),jh=a("PerceiverAudioPreprocessor"),il=l(),Le=t("div"),_(Pt.$$.fragment),Mh=l(),Va=t("p"),Ih=a("Audio preprocessing for Perceiver Encoder."),cl=l(),Se=t("h2"),Br=t("a"),Ua=t("span"),_(bt.$$.fragment),qh=l(),Ra=t("span"),zh=a("PerceiverMultimodalPreprocessor"),ll=l(),ce=t("div"),_(wt.$$.fragment),Ah=l(),Ka=t("p"),Dh=a("Multimodal preprocessing for Perceiver Encoder."),Oh=l(),Ja=t("p"),Nh=a(`Inputs for each modality are preprocessed, then padded with trainable position embeddings to have the same number
of channels.`),dl=l(),Be=t("h2"),Hr=t("a"),Ga=t("span"),_(yt.$$.fragment),Lh=l(),Xa=t("span"),Sh=a("PerceiverProjectionDecoder"),pl=l(),He=t("div"),_($t.$$.fragment),Bh=l(),Za=t("p"),Hh=a("Baseline projection decoder (no cross-attention)."),ml=l(),We=t("h2"),Wr=t("a"),Qa=t("span"),_(kt.$$.fragment),Wh=l(),Ya=t("span"),Vh=a("PerceiverBasicDecoder"),hl=l(),le=t("div"),_(Tt.$$.fragment),Uh=l(),ei=t("p"),Rh=a(`Cross-attention-based decoder. This class can be used to decode the final hidden states of the latents using a
cross-attention operation, in which the latents produce keys and values.`),Kh=l(),ri=t("p"),Jh=a("The shape of the output of this class depends on how one defines the output queries (also called decoder queries)."),ul=l(),Ve=t("h2"),Vr=t("a"),oi=t("span"),_(xt.$$.fragment),Gh=l(),ti=t("span"),Xh=a("PerceiverClassificationDecoder"),fl=l(),Ue=t("div"),_(Et.$$.fragment),Zh=l(),Ft=t("p"),Qh=a("Cross-attention based classification decoder. Light-weight wrapper of "),si=t("code"),Yh=a("PerceiverBasicDecoder"),eu=a(` for logit output.
Will turn the output of the Perceiver encoder which is of shape (batch_size, num_latents, d_latents) to a tensor of
shape (batch_size, num_labels). The queries are of shape (batch_size, 1, num_labels).`),gl=l(),Re=t("h2"),Ur=t("a"),ni=t("span"),_(Ct.$$.fragment),ru=l(),ai=t("span"),ou=a("PerceiverOpticalFlowDecoder"),vl=l(),Ke=t("div"),_(jt.$$.fragment),tu=l(),ii=t("p"),su=a("Cross-attention based optical flow decoder."),_l=l(),Je=t("h2"),Rr=t("a"),ci=t("span"),_(Mt.$$.fragment),nu=l(),li=t("span"),au=a("PerceiverBasicVideoAutoencodingDecoder"),Pl=l(),Ge=t("div"),_(It.$$.fragment),iu=l(),qt=t("p"),cu=a("Cross-attention based video-autoencoding decoder. Light-weight wrapper of ["),di=t("em"),lu=a("PerceiverBasicDecoder"),du=a(`] with video
reshaping logic.`),bl=l(),Xe=t("h2"),Kr=t("a"),pi=t("span"),_(zt.$$.fragment),pu=l(),mi=t("span"),mu=a("PerceiverMultimodalDecoder"),wl=l(),de=t("div"),_(At.$$.fragment),hu=l(),Dt=t("p"),uu=a("Multimodal decoding by composing uni-modal decoders. The "),hi=t("em"),fu=a("modalities"),gu=a(` argument of the constructor is a dictionary
mapping modality name to the decoder of that modality. That decoder will be used to construct queries for that
modality. Modality-specific queries are padded with trainable modality-specific parameters, after which they are
concatenated along the time dimension.`),vu=l(),ui=t("p"),_u=a("Next, there is a shared cross attention operation across all modalities."),yl=l(),Ze=t("h2"),Jr=t("a"),fi=t("span"),_(Ot.$$.fragment),Pu=l(),gi=t("span"),bu=a("PerceiverProjectionPostprocessor"),$l=l(),Qe=t("div"),_(Nt.$$.fragment),wu=l(),vi=t("p"),yu=a(`Projection postprocessing for Perceiver. Can be used to project the channels of the decoder output to a lower
dimension.`),kl=l(),Ye=t("h2"),Gr=t("a"),_i=t("span"),_(Lt.$$.fragment),$u=l(),Pi=t("span"),ku=a("PerceiverAudioPostprocessor"),Tl=l(),er=t("div"),_(St.$$.fragment),Tu=l(),bi=t("p"),xu=a("Audio postprocessing for Perceiver. Can be used to convert the decoder output to audio features."),xl=l(),rr=t("h2"),Xr=t("a"),wi=t("span"),_(Bt.$$.fragment),Eu=l(),yi=t("span"),Fu=a("PerceiverClassificationPostprocessor"),El=l(),or=t("div"),_(Ht.$$.fragment),Cu=l(),$i=t("p"),ju=a("Classification postprocessing for Perceiver. Can be used to convert the decoder output to classification logits."),Fl=l(),tr=t("h2"),Zr=t("a"),ki=t("span"),_(Wt.$$.fragment),Mu=l(),Ti=t("span"),Iu=a("PerceiverMultimodalPostprocessor"),Cl=l(),sr=t("div"),_(Vt.$$.fragment),qu=l(),xi=t("p"),zu=a(`Multimodal postprocessing for Perceiver. Can be used to combine modality-specific postprocessors into a single
postprocessor.`),jl=l(),nr=t("h2"),Qr=t("a"),Ei=t("span"),_(Ut.$$.fragment),Au=l(),Fi=t("span"),Du=a("PerceiverModel"),Ml=l(),pe=t("div"),_(Rt.$$.fragment),Ou=l(),Kt=t("p"),Nu=a(`The Perceiver: a scalable, fully attentional architecture.
This model is a PyTorch `),Jt=t("a"),Lu=a("torch.nn.Module"),Su=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Bu=l(),J=t("div"),_(Gt.$$.fragment),Hu=l(),ar=t("p"),Wu=a("The "),Qs=t("a"),Vu=a("PerceiverModel"),Uu=a(" forward method, overrides the "),Ci=t("code"),Ru=a("__call__"),Ku=a(" special method."),Ju=l(),_(Yr.$$.fragment),Gu=l(),_(eo.$$.fragment),Il=l(),ir=t("h2"),ro=t("a"),ji=t("span"),_(Xt.$$.fragment),Xu=l(),Mi=t("span"),Zu=a("PerceiverForMaskedLM"),ql=l(),me=t("div"),_(Zt.$$.fragment),Qu=l(),Qt=t("p"),Yu=a(`Example use of Perceiver for masked language modeling.
This model is a PyTorch `),Yt=t("a"),ef=a("torch.nn.Module"),rf=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),of=l(),G=t("div"),_(es.$$.fragment),tf=l(),cr=t("p"),sf=a("The "),Ys=t("a"),nf=a("PerceiverForMaskedLM"),af=a(" forward method, overrides the "),Ii=t("code"),cf=a("__call__"),lf=a(" special method."),df=l(),_(oo.$$.fragment),pf=l(),_(to.$$.fragment),zl=l(),lr=t("h2"),so=t("a"),qi=t("span"),_(rs.$$.fragment),mf=l(),zi=t("span"),hf=a("PerceiverForSequenceClassification"),Al=l(),he=t("div"),_(os.$$.fragment),uf=l(),ts=t("p"),ff=a(`Example use of Perceiver for text classification.
This model is a PyTorch `),ss=t("a"),gf=a("torch.nn.Module"),vf=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),_f=l(),X=t("div"),_(ns.$$.fragment),Pf=l(),dr=t("p"),bf=a("The "),en=t("a"),wf=a("PerceiverForSequenceClassification"),yf=a(" forward method, overrides the "),Ai=t("code"),$f=a("__call__"),kf=a(" special method."),Tf=l(),_(no.$$.fragment),xf=l(),_(ao.$$.fragment),Dl=l(),pr=t("h2"),io=t("a"),Di=t("span"),_(as.$$.fragment),Ef=l(),Oi=t("span"),Ff=a("PerceiverForImageClassificationLearned"),Ol=l(),q=t("div"),_(is.$$.fragment),Cf=l(),Ni=t("p"),jf=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),Mf=l(),Li=t("p"),If=a(`This model uses learned position embeddings. In other words, this model is not given any privileged information about
the structure of images. As shown in the paper, this model can achieve a top-1 accuracy of 72.7 on ImageNet.`),qf=l(),S=t("p"),rn=t("a"),zf=a("PerceiverForImageClassificationLearned"),Af=a(" uses "),on=t("a"),Df=a("PerceiverImagePreprocessor"),Of=a(`
(with `),Si=t("code"),Nf=a('prep_type="conv1x1"'),Lf=a(`) to preprocess the input images, and
`),tn=t("a"),Sf=a("PerceiverClassificationDecoder"),Bf=a(` to decode the latent representation of
`),sn=t("a"),Hf=a("PerceiverModel"),Wf=a(" into classification logits."),Vf=l(),cs=t("p"),Uf=a("This model is a PyTorch "),ls=t("a"),Rf=a("torch.nn.Module"),Kf=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Jf=l(),Z=t("div"),_(ds.$$.fragment),Gf=l(),mr=t("p"),Xf=a("The "),nn=t("a"),Zf=a("PerceiverForImageClassificationLearned"),Qf=a(" forward method, overrides the "),Bi=t("code"),Yf=a("__call__"),eg=a(" special method."),rg=l(),_(co.$$.fragment),og=l(),_(lo.$$.fragment),Nl=l(),hr=t("h2"),po=t("a"),Hi=t("span"),_(ps.$$.fragment),tg=l(),Wi=t("span"),sg=a("PerceiverForImageClassificationFourier"),Ll=l(),z=t("div"),_(ms.$$.fragment),ng=l(),Vi=t("p"),ag=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),ig=l(),Ui=t("p"),cg=a(`This model uses fixed 2D Fourier position embeddings. As shown in the paper, this model can achieve a top-1 accuracy of
79.0 on ImageNet, and 84.5 when pre-trained on a large-scale dataset (i.e. JFT).`),lg=l(),B=t("p"),an=t("a"),dg=a("PerceiverForImageClassificationLearned"),pg=a(" uses "),cn=t("a"),mg=a("PerceiverImagePreprocessor"),hg=a(`
(with `),Ri=t("code"),ug=a('prep_type="pixels"'),fg=a(`) to preprocess the input images, and
`),ln=t("a"),gg=a("PerceiverClassificationDecoder"),vg=a(` to decode the latent representation of
`),dn=t("a"),_g=a("PerceiverModel"),Pg=a(" into classification logits."),bg=l(),hs=t("p"),wg=a("This model is a PyTorch "),us=t("a"),yg=a("torch.nn.Module"),$g=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),kg=l(),Q=t("div"),_(fs.$$.fragment),Tg=l(),ur=t("p"),xg=a("The "),pn=t("a"),Eg=a("PerceiverForImageClassificationFourier"),Fg=a(" forward method, overrides the "),Ki=t("code"),Cg=a("__call__"),jg=a(" special method."),Mg=l(),_(mo.$$.fragment),Ig=l(),_(ho.$$.fragment),Sl=l(),fr=t("h2"),uo=t("a"),Ji=t("span"),_(gs.$$.fragment),qg=l(),Gi=t("span"),zg=a("PerceiverForImageClassificationConvProcessing"),Bl=l(),A=t("div"),_(vs.$$.fragment),Ag=l(),Xi=t("p"),Dg=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),Og=l(),Zi=t("p"),Ng=a(`This model uses a 2D conv+maxpool preprocessing network. As shown in the paper, this model can achieve a top-1 accuracy
of 82.1 on ImageNet.`),Lg=l(),H=t("p"),mn=t("a"),Sg=a("PerceiverForImageClassificationLearned"),Bg=a(" uses "),hn=t("a"),Hg=a("PerceiverImagePreprocessor"),Wg=a(`
(with `),Qi=t("code"),Vg=a('prep_type="conv"'),Ug=a(`) to preprocess the input images, and
`),un=t("a"),Rg=a("PerceiverClassificationDecoder"),Kg=a(` to decode the latent representation of
`),fn=t("a"),Jg=a("PerceiverModel"),Gg=a(" into classification logits."),Xg=l(),_s=t("p"),Zg=a("This model is a PyTorch "),Ps=t("a"),Qg=a("torch.nn.Module"),Yg=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),ev=l(),Y=t("div"),_(bs.$$.fragment),rv=l(),gr=t("p"),ov=a("The "),gn=t("a"),tv=a("PerceiverForImageClassificationConvProcessing"),sv=a(" forward method, overrides the "),Yi=t("code"),nv=a("__call__"),av=a(" special method."),iv=l(),_(fo.$$.fragment),cv=l(),_(go.$$.fragment),Hl=l(),vr=t("h2"),vo=t("a"),ec=t("span"),_(ws.$$.fragment),lv=l(),rc=t("span"),dv=a("PerceiverForOpticalFlow"),Wl=l(),O=t("div"),_(ys.$$.fragment),pv=l(),N=t("p"),mv=a("Example use of Perceiver for optical flow, for tasks such as Sintel and KITTI. "),vn=t("a"),hv=a("PerceiverForOpticalFlow"),uv=a(` uses
`),_n=t("a"),fv=a("PerceiverImagePreprocessor"),gv=a(" (with "),oc=t("em"),vv=a("prep_type=\u201Cpatches\u201D"),_v=a(`) to preprocess the
input images, and `),Pn=t("a"),Pv=a("PerceiverOpticalFlowDecoder"),bv=a(` to decode the latent
representation of `),bn=t("a"),wv=a("PerceiverModel"),yv=a("."),$v=l(),tc=t("p"),kv=a(`As input, one concatenates 2 subsequent frames along the channel dimension and extract a 3 x 3 patch around each pixel
(leading to 3 x 3 x 3 x 2 = 54 values for each pixel). Fixed Fourier position encodings are used to encode the position
of each pixel in the patch. Next, one applies the Perceiver encoder. To decode, one queries the latent representation
using the same encoding used for the input.`),Tv=l(),$s=t("p"),xv=a("This model is a PyTorch "),ks=t("a"),Ev=a("torch.nn.Module"),Fv=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Cv=l(),ee=t("div"),_(Ts.$$.fragment),jv=l(),_r=t("p"),Mv=a("The "),wn=t("a"),Iv=a("PerceiverForOpticalFlow"),qv=a(" forward method, overrides the "),sc=t("code"),zv=a("__call__"),Av=a(" special method."),Dv=l(),_(_o.$$.fragment),Ov=l(),_(Po.$$.fragment),Vl=l(),Pr=t("h2"),bo=t("a"),nc=t("span"),_(xs.$$.fragment),Nv=l(),ac=t("span"),Lv=a("PerceiverForMultimodalAutoencoding"),Ul=l(),j=t("div"),_(Es.$$.fragment),Sv=l(),ic=t("p"),Bv=a("Example use of Perceiver for multimodal (video) autoencoding, for tasks such as Kinetics-700."),Hv=l(),wo=t("p"),yn=t("a"),Wv=a("PerceiverForMultimodalAutoencoding"),Vv=a(" uses "),$n=t("a"),Uv=a("PerceiverMultimodalPreprocessor"),Rv=a(` to
preprocess the 3 modalities: images, audio and class labels. This preprocessor uses modality-specific preprocessors to
preprocess every modality separately, after which they are concatenated. Trainable position embeddings are used to pad
each modality to the same number of channels to make concatenation along the time dimension possible. Next, one applies
the Perceiver encoder.`),Kv=l(),be=t("p"),kn=t("a"),Jv=a("PerceiverMultimodalDecoder"),Gv=a(` is used to decode the latent representation of
`),Tn=t("a"),Xv=a("PerceiverModel"),Zv=a(`. This decoder uses each modality-specific decoder to construct queries. The decoder queries are
created based on the inputs after preprocessing. However, autoencoding an entire video in a single forward pass is
computationally infeasible, hence one only uses parts of the decoder queries to do cross-attention with the latent
representation. This is determined by the subsampled indices for each modality, which can be provided as additional
input to the forward pass of `),xn=t("a"),Qv=a("PerceiverForMultimodalAutoencoding"),Yv=a("."),e_=l(),yo=t("p"),En=t("a"),r_=a("PerceiverMultimodalDecoder"),o_=a(` also pads the decoder queries of the different
modalities to the same number of channels, in order to concatenate them along the time dimension. Next, cross-attention
is performed with the latent representation of `),Fn=t("a"),t_=a("PerceiverModel"),s_=a("."),n_=l(),Fs=t("p"),a_=a("Finally, "),cc=t("code"),i_=a("PerceiverMultiModalPostprocessor"),c_=a(` is used to turn this tensor into an
actual video. It first splits up the output into the different modalities, and then applies the respective
postprocessor for each modality.`),l_=l(),lc=t("p"),d_=a(`Note that, by masking the classification label during evaluation (i.e. simply providing a tensor of zeros for the
\u201Clabel\u201D modality), this auto-encoding model becomes a Kinetics 700 video classifier.`),p_=l(),Cs=t("p"),m_=a("This model is a PyTorch "),js=t("a"),h_=a("torch.nn.Module"),u_=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),f_=l(),re=t("div"),_(Ms.$$.fragment),g_=l(),br=t("p"),v_=a("The "),Cn=t("a"),__=a("PerceiverForMultimodalAutoencoding"),P_=a(" forward method, overrides the "),dc=t("code"),b_=a("__call__"),w_=a(" special method."),y_=l(),_($o.$$.fragment),$_=l(),_(ko.$$.fragment),this.h()},l(r){const m=gw('[data-svelte="svelte-1phssyn"]',document.head);u=s(m,"META",{name:!0,content:!0}),m.forEach(o),T=d(r),v=s(r,"H1",{class:!0});var Is=n(v);g=s(Is,"A",{id:!0,class:!0,href:!0});var pc=n(g);k=s(pc,"SPAN",{});var mc=n(k);P(p.$$.fragment,mc),mc.forEach(o),pc.forEach(o),f=d(Is),F=s(Is,"SPAN",{});var hc=n(F);ep=i(hc,"Perceiver"),hc.forEach(o),Is.forEach(o),xc=d(r),$e=s(r,"H2",{class:!0});var qs=n($e);Tr=s(qs,"A",{id:!0,class:!0,href:!0});var uc=n(Tr);Xn=s(uc,"SPAN",{});var fc=n(Xn);P(Do.$$.fragment,fc),fc.forEach(o),uc.forEach(o),rp=d(qs),Zn=s(qs,"SPAN",{});var gc=n(Zn);op=i(gc,"Overview"),gc.forEach(o),qs.forEach(o),Ec=d(r),xr=s(r,"P",{});var zs=n(xr);tp=i(zs,"The Perceiver IO model was proposed in "),Oo=s(zs,"A",{href:!0,rel:!0});var vc=n(Oo);sp=i(vc,`Perceiver IO: A General Architecture for Structured Inputs &
Outputs`),vc.forEach(o),np=i(zs,` by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch,
Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier H\xE9naff, Matthew M.
Botvinick, Andrew Zisserman, Oriol Vinyals, Jo\xE3o Carreira.`),zs.forEach(o),Fc=d(r),Er=s(r,"P",{});var As=n(Er);ap=i(As,"Perceiver IO is a generalization of "),No=s(As,"A",{href:!0,rel:!0});var _c=n(No);ip=i(_c,"Perceiver"),_c.forEach(o),cp=i(As,` to handle arbitrary outputs in
addition to arbitrary inputs. The original Perceiver only produced a single classification label. In addition to
classification labels, Perceiver IO can produce (for example) language, optical flow, and multimodal videos with audio.
This is done using the same building blocks as the original Perceiver. The computational complexity of Perceiver IO is
linear in the input and output size and the bulk of the processing occurs in the latent space, allowing us to process
inputs and outputs that are much larger than can be handled by standard Transformers. This means, for example,
Perceiver IO can do BERT-style masked language modeling directly using bytes instead of tokenized inputs.`),As.forEach(o),Cc=d(r),Ns=s(r,"P",{});var Pc=n(Ns);lp=i(Pc,"The abstract from the paper is the following:"),Pc.forEach(o),jc=d(r),Ls=s(r,"P",{});var bc=n(Ls);Qn=s(bc,"EM",{});var wc=n(Qn);dp=i(wc,`The recently-proposed Perceiver model obtains good results on several domains (images, audio, multimodal, point
clouds) while scaling linearly in compute and memory with the input size. While the Perceiver supports many kinds of
inputs, it can only produce very simple outputs such as class scores. Perceiver IO overcomes this limitation without
sacrificing the original\u2019s appealing properties by learning to flexibly query the model\u2019s latent space to produce
outputs of arbitrary size and semantics. Perceiver IO still decouples model depth from data size and still scales
linearly with data size, but now with respect to both input and output sizes. The full Perceiver IO model achieves
strong results on tasks with highly structured output spaces, such as natural language and visual understanding,
StarCraft II, and multi-task and multi-modal domains. As highlights, Perceiver IO matches a Transformer-based BERT
baseline on the GLUE language benchmark without the need for input tokenization and achieves state-of-the-art
performance on Sintel optical flow estimation.`),wc.forEach(o),bc.forEach(o),Mc=d(r),Ss=s(r,"P",{});var yc=n(Ss);pp=i(yc,"Here\u2019s a TLDR explaining how Perceiver works:"),yc.forEach(o),Ic=d(r),Bs=s(r,"P",{});var $c=n(Bs);mp=i($c,`The main problem with the self-attention mechanism of the Transformer is that the time and memory requirements scale
quadratically with the sequence length. Hence, models like BERT and RoBERTa are limited to a max sequence length of 512
tokens. Perceiver aims to solve this issue by, instead of performing self-attention on the inputs, perform it on a set
of latent variables, and only use the inputs for cross-attention. In this way, the time and memory requirements don\u2019t
depend on the length of the inputs anymore, as one uses a fixed amount of latent variables, like 256 or 512. These are
randomly initialized, after which they are trained end-to-end using backpropagation.`),$c.forEach(o),qc=d(r),D=s(r,"P",{});var L=n(D);hp=i(L,"Internally, "),Hs=s(L,"A",{href:!0});var E_=n(Hs);up=i(E_,"PerceiverModel"),E_.forEach(o),fp=i(L," will create the latents, which is a tensor of shape "),Yn=s(L,"CODE",{});var F_=n(Yn);gp=i(F_,"(batch_size, num_latents, d_latents)"),F_.forEach(o),vp=i(L,". One must provide "),ea=s(L,"CODE",{});var C_=n(ea);_p=i(C_,"inputs"),C_.forEach(o),Pp=i(L,` (which could be text, images, audio, you name it!) to the model, which it will
use to perform cross-attention with the latents. The output of the Perceiver encoder is a tensor of the same shape. One
can then, similar to BERT, convert the last hidden states of the latents to classification logits by averaging along
the sequence dimension, and placing a linear layer on top of that to project the `),ra=s(L,"CODE",{});var j_=n(ra);bp=i(j_,"d_latents"),j_.forEach(o),wp=i(L," to "),oa=s(L,"CODE",{});var M_=n(oa);yp=i(M_,"num_labels"),M_.forEach(o),$p=i(L,"."),L.forEach(o),zc=d(r),Ws=s(r,"P",{});var I_=n(Ws);kp=i(I_,`This was the idea of the original Perceiver paper. However, it could only output classification logits. In a follow-up
work, PerceiverIO, they generalized it to let the model also produce outputs of arbitrary size. How, you might ask? The
idea is actually relatively simple: one defines outputs of an arbitrary size, and then applies cross-attention with the
last hidden states of the latents, using the outputs as queries, and the latents as keys and values.`),I_.forEach(o),Ac=d(r),M=s(r,"P",{});var W=n(M);Tp=i(W,`So let\u2019s say one wants to perform masked language modeling (BERT-style) with the Perceiver. As the Perceiver\u2019s input
length will not have an impact on the computation time of the self-attention layers, one can provide raw bytes,
providing `),ta=s(W,"CODE",{});var q_=n(ta);xp=i(q_,"inputs"),q_.forEach(o),Ep=i(W,` of length 2048 to the model. If one now masks out certain of these 2048 tokens, one can define the
`),sa=s(W,"CODE",{});var z_=n(sa);Fp=i(z_,"outputs"),z_.forEach(o),Cp=i(W," as being of shape: "),na=s(W,"CODE",{});var A_=n(na);jp=i(A_,"(batch_size, 2048, 768)"),A_.forEach(o),Mp=i(W,`. Next, one performs cross-attention with the final hidden states
of the latents to update the `),aa=s(W,"CODE",{});var D_=n(aa);Ip=i(D_,"outputs"),D_.forEach(o),qp=i(W," tensor. After cross-attention, one still has a tensor of shape "),ia=s(W,"CODE",{});var O_=n(ia);zp=i(O_,"(batch_size, 2048, 768)"),O_.forEach(o),Ap=i(W,`. One can then place a regular language modeling head on top, to project the last dimension to the
vocabulary size of the model, i.e. creating logits of shape `),ca=s(W,"CODE",{});var N_=n(ca);Dp=i(N_,"(batch_size, 2048, 262)"),N_.forEach(o),Op=i(W,` (as Perceiver uses a vocabulary
size of 262 byte IDs).`),W.forEach(o),Dc=d(r),Fr=s(r,"IMG",{src:!0,alt:!0,width:!0}),Oc=d(r),Lo=s(r,"SMALL",{});var k_=n(Lo);Np=i(k_,"Perceiver IO architecture. Taken from the "),Vs=s(k_,"A",{href:!0});var L_=n(Vs);Lp=i(L_,"original paper"),L_.forEach(o),k_.forEach(o),Nc=d(r),ve=s(r,"P",{});var jn=n(ve);Sp=i(jn,"This model was contributed by "),So=s(jn,"A",{href:!0,rel:!0});var S_=n(So);Bp=i(S_,"nielsr"),S_.forEach(o),Hp=i(jn,`. The original code can be found
`),Bo=s(jn,"A",{href:!0,rel:!0});var B_=n(Bo);Wp=i(B_,"here"),B_.forEach(o),Vp=i(jn,"."),jn.forEach(o),Lc=d(r),Us=s(r,"P",{});var H_=n(Us);Up=i(H_,"Tips:"),H_.forEach(o),Sc=d(r),Cr=s(r,"UL",{});var Kl=n(Cr);Ho=s(Kl,"LI",{});var Jl=n(Ho);Rp=i(Jl,"The quickest way to get started with the Perceiver is by checking the "),Wo=s(Jl,"A",{href:!0,rel:!0});var W_=n(Wo);Kp=i(W_,`tutorial
notebooks`),W_.forEach(o),Jp=i(Jl,"."),Jl.forEach(o),Gp=d(Kl),Vo=s(Kl,"LI",{});var Gl=n(Vo);Xp=i(Gl,"Refer to the "),Uo=s(Gl,"A",{href:!0,rel:!0});var V_=n(Uo);Zp=i(V_,"blog post"),V_.forEach(o),Qp=i(Gl,` if you want to fully understand how the model works and
is implemented in the library. Note that the models available in the library only showcase some examples of what you can do
with the Perceiver. There are many more use cases, including question answering, named-entity recognition, object detection,
audio classification, video classification, etc.`),Gl.forEach(o),Kl.forEach(o),Bc=d(r),Ro=s(r,"P",{});var T_=n(Ro);la=s(T_,"STRONG",{});var U_=n(la);Yp=i(U_,"Note"),U_.forEach(o),em=i(T_,":"),T_.forEach(o),Hc=d(r),Rs=s(r,"UL",{});var R_=n(Rs);_e=s(R_,"LI",{});var Ds=n(_e);rm=i(Ds,"Perceiver does "),da=s(Ds,"STRONG",{});var K_=n(da);om=i(K_,"not"),K_.forEach(o),tm=i(Ds," work with "),pa=s(Ds,"CODE",{});var J_=n(pa);sm=i(J_,"torch.nn.DataParallel"),J_.forEach(o),nm=i(Ds," due to a bug in PyTorch, see "),Ko=s(Ds,"A",{href:!0,rel:!0});var G_=n(Ko);am=i(G_,"issue #36035"),G_.forEach(o),Ds.forEach(o),R_.forEach(o),Wc=d(r),ke=s(r,"H2",{class:!0});var Xl=n(ke);jr=s(Xl,"A",{id:!0,class:!0,href:!0});var X_=n(jr);ma=s(X_,"SPAN",{});var Z_=n(ma);P(Jo.$$.fragment,Z_),Z_.forEach(o),X_.forEach(o),im=d(Xl),ha=s(Xl,"SPAN",{});var Q_=n(ha);cm=i(Q_,"Perceiver specific outputs"),Q_.forEach(o),Xl.forEach(o),Vc=d(r),Te=s(r,"DIV",{class:!0});var Zl=n(Te);P(Go.$$.fragment,Zl),lm=d(Zl),ua=s(Zl,"P",{});var Y_=n(ua);dm=i(Y_,"Base class for Perceiver base model\u2019s outputs, with potential hidden states, attentions and cross-attentions."),Y_.forEach(o),Zl.forEach(o),Uc=d(r),xe=s(r,"DIV",{class:!0});var Ql=n(xe);P(Xo.$$.fragment,Ql),pm=d(Ql),fa=s(Ql,"P",{});var e1=n(fa);mm=i(e1,"Base class for Perceiver decoder outputs, with potential cross-attentions."),e1.forEach(o),Ql.forEach(o),Rc=d(r),Ee=s(r,"DIV",{class:!0});var Yl=n(Ee);P(Zo.$$.fragment,Yl),hm=d(Yl),ga=s(Yl,"P",{});var r1=n(ga);um=i(r1,"Base class for Perceiver\u2019s masked language model outputs."),r1.forEach(o),Yl.forEach(o),Kc=d(r),Fe=s(r,"DIV",{class:!0});var ed=n(Fe);P(Qo.$$.fragment,ed),fm=d(ed),va=s(ed,"P",{});var o1=n(va);gm=i(o1,`Base class for Perceiver\u2019s outputs of sequence/image classification models, optical flow and multimodal
autoencoding.`),o1.forEach(o),ed.forEach(o),Jc=d(r),Ce=s(r,"H2",{class:!0});var rd=n(Ce);Mr=s(rd,"A",{id:!0,class:!0,href:!0});var t1=n(Mr);_a=s(t1,"SPAN",{});var s1=n(_a);P(Yo.$$.fragment,s1),s1.forEach(o),t1.forEach(o),vm=d(rd),Pa=s(rd,"SPAN",{});var n1=n(Pa);_m=i(n1,"PerceiverConfig"),n1.forEach(o),rd.forEach(o),Gc=d(r),V=s(r,"DIV",{class:!0});var To=n(V);P(et.$$.fragment,To),Pm=d(To),je=s(To,"P",{});var Mn=n(je);bm=i(Mn,"This is the configuration class to store the configuration of a "),Ks=s(Mn,"A",{href:!0});var a1=n(Ks);wm=i(a1,"PerceiverModel"),a1.forEach(o),ym=i(Mn,`. It is used to instantiate an
Perceiver model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Perceiver
`),rt=s(Mn,"A",{href:!0,rel:!0});var i1=n(rt);$m=i(i1,"deepmind/language-perceiver"),i1.forEach(o),km=i(Mn," architecture."),Mn.forEach(o),Tm=d(To),Me=s(To,"P",{});var In=n(Me);xm=i(In,"Configuration objects inherit from "),Js=s(In,"A",{href:!0});var c1=n(Js);Em=i(c1,"PretrainedConfig"),c1.forEach(o),Fm=i(In,` and can be used to control the model outputs. Read the
documentation from `),Gs=s(In,"A",{href:!0});var l1=n(Gs);Cm=i(l1,"PretrainedConfig"),l1.forEach(o),jm=i(In," for more information."),In.forEach(o),Mm=d(To),P(Ir.$$.fragment,To),To.forEach(o),Xc=d(r),Ie=s(r,"H2",{class:!0});var od=n(Ie);qr=s(od,"A",{id:!0,class:!0,href:!0});var d1=n(qr);ba=s(d1,"SPAN",{});var p1=n(ba);P(ot.$$.fragment,p1),p1.forEach(o),d1.forEach(o),Im=d(od),wa=s(od,"SPAN",{});var m1=n(wa);qm=i(m1,"PerceiverTokenizer"),m1.forEach(o),od.forEach(o),Zc=d(r),U=s(r,"DIV",{class:!0});var xo=n(U);P(tt.$$.fragment,xo),zm=d(xo),ya=s(xo,"P",{});var h1=n(ya);Am=i(h1,"Construct a Perceiver tokenizer. The Perceiver simply uses raw bytes utf-8 encoding."),h1.forEach(o),Dm=d(xo),st=s(xo,"P",{});var td=n(st);Om=i(td,"This tokenizer inherits from "),Xs=s(td,"A",{href:!0});var u1=n(Xs);Nm=i(u1,"PreTrainedTokenizer"),u1.forEach(o),Lm=i(td,` which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`),td.forEach(o),Sm=d(xo),zr=s(xo,"DIV",{class:!0});var sd=n(zr);P(nt.$$.fragment,sd),Bm=d(sd),$a=s(sd,"P",{});var f1=n($a);Hm=i(f1,`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`),f1.forEach(o),sd.forEach(o),xo.forEach(o),Qc=d(r),qe=s(r,"H2",{class:!0});var nd=n(qe);Ar=s(nd,"A",{id:!0,class:!0,href:!0});var g1=n(Ar);ka=s(g1,"SPAN",{});var v1=n(ka);P(at.$$.fragment,v1),v1.forEach(o),g1.forEach(o),Wm=d(nd),Ta=s(nd,"SPAN",{});var _1=n(Ta);Vm=i(_1,"PerceiverFeatureExtractor"),_1.forEach(o),nd.forEach(o),Yc=d(r),R=s(r,"DIV",{class:!0});var Eo=n(R);P(it.$$.fragment,Eo),Um=d(Eo),xa=s(Eo,"P",{});var P1=n(xa);Rm=i(P1,"Constructs a Perceiver feature extractor."),P1.forEach(o),Km=d(Eo),ct=s(Eo,"P",{});var ad=n(ct);Jm=i(ad,"This feature extractor inherits from "),Zs=s(ad,"A",{href:!0});var b1=n(Zs);Gm=i(b1,"ImageFeatureExtractionMixin"),b1.forEach(o),Xm=i(ad,` which contains most of the main methods. Users
should refer to this superclass for more information regarding those methods.`),ad.forEach(o),Zm=d(Eo),Pe=s(Eo,"DIV",{class:!0});var qn=n(Pe);P(lt.$$.fragment,qn),Qm=d(qn),Ea=s(qn,"P",{});var w1=n(Ea);Ym=i(w1,"Main method to prepare for the model one or several image(s)."),w1.forEach(o),eh=d(qn),P(Dr.$$.fragment,qn),qn.forEach(o),Eo.forEach(o),el=d(r),ze=s(r,"H2",{class:!0});var id=n(ze);Or=s(id,"A",{id:!0,class:!0,href:!0});var y1=n(Or);Fa=s(y1,"SPAN",{});var $1=n(Fa);P(dt.$$.fragment,$1),$1.forEach(o),y1.forEach(o),rh=d(id),Ca=s(id,"SPAN",{});var k1=n(Ca);oh=i(k1,"PerceiverTextPreprocessor"),k1.forEach(o),id.forEach(o),rl=d(r),ae=s(r,"DIV",{class:!0});var zn=n(ae);P(pt.$$.fragment,zn),th=d(zn),mt=s(zn,"P",{});var cd=n(mt);sh=i(cd,"Text preprocessing for Perceiver Encoder. Can be used to embed "),ja=s(cd,"CODE",{});var T1=n(ja);nh=i(T1,"inputs"),T1.forEach(o),ah=i(cd," and add positional encodings."),cd.forEach(o),ih=d(zn),ht=s(zn,"P",{});var ld=n(ht);ch=i(ld,"The dimensionality of the embeddings is determined by the "),Ma=s(ld,"CODE",{});var x1=n(Ma);lh=i(x1,"d_model"),x1.forEach(o),dh=i(ld," attribute of the configuration."),ld.forEach(o),zn.forEach(o),ol=d(r),Ae=s(r,"H2",{class:!0});var dd=n(Ae);Nr=s(dd,"A",{id:!0,class:!0,href:!0});var E1=n(Nr);Ia=s(E1,"SPAN",{});var F1=n(Ia);P(ut.$$.fragment,F1),F1.forEach(o),E1.forEach(o),ph=d(dd),qa=s(dd,"SPAN",{});var C1=n(qa);mh=i(C1,"PerceiverImagePreprocessor"),C1.forEach(o),dd.forEach(o),tl=d(r),ie=s(r,"DIV",{class:!0});var An=n(ie);P(ft.$$.fragment,An),hh=d(An),za=s(An,"P",{});var j1=n(za);uh=i(j1,"Image preprocessing for Perceiver Encoder."),j1.forEach(o),fh=d(An),K=s(An,"P",{});var we=n(K);gh=i(we,"Note: the "),Aa=s(we,"EM",{});var M1=n(Aa);vh=i(M1,"out_channels"),M1.forEach(o),_h=i(we," argument refers to the output channels of a convolutional layer, if "),Da=s(we,"EM",{});var I1=n(Da);Ph=i(I1,"prep_type"),I1.forEach(o),bh=i(we,` is set to
\u201Cconv1x1\u201D or \u201Cconv\u201D. If one adds absolute position embeddings, one must make sure the `),Oa=s(we,"EM",{});var q1=n(Oa);wh=i(q1,"num_channels"),q1.forEach(o),yh=i(we,` of the
position encoding kwargs are set equal to the `),Na=s(we,"EM",{});var z1=n(Na);$h=i(z1,"out_channels"),z1.forEach(o),kh=i(we,"."),we.forEach(o),An.forEach(o),sl=d(r),De=s(r,"H2",{class:!0});var pd=n(De);Lr=s(pd,"A",{id:!0,class:!0,href:!0});var A1=n(Lr);La=s(A1,"SPAN",{});var D1=n(La);P(gt.$$.fragment,D1),D1.forEach(o),A1.forEach(o),Th=d(pd),Sa=s(pd,"SPAN",{});var O1=n(Sa);xh=i(O1,"PerceiverOneHotPreprocessor"),O1.forEach(o),pd.forEach(o),nl=d(r),Oe=s(r,"DIV",{class:!0});var md=n(Oe);P(vt.$$.fragment,md),Eh=d(md),Ba=s(md,"P",{});var N1=n(Ba);Fh=i(N1,"One-hot preprocessor for Perceiver Encoder. Can be used to add a dummy index dimension to the input."),N1.forEach(o),md.forEach(o),al=d(r),Ne=s(r,"H2",{class:!0});var hd=n(Ne);Sr=s(hd,"A",{id:!0,class:!0,href:!0});var L1=n(Sr);Ha=s(L1,"SPAN",{});var S1=n(Ha);P(_t.$$.fragment,S1),S1.forEach(o),L1.forEach(o),Ch=d(hd),Wa=s(hd,"SPAN",{});var B1=n(Wa);jh=i(B1,"PerceiverAudioPreprocessor"),B1.forEach(o),hd.forEach(o),il=d(r),Le=s(r,"DIV",{class:!0});var ud=n(Le);P(Pt.$$.fragment,ud),Mh=d(ud),Va=s(ud,"P",{});var H1=n(Va);Ih=i(H1,"Audio preprocessing for Perceiver Encoder."),H1.forEach(o),ud.forEach(o),cl=d(r),Se=s(r,"H2",{class:!0});var fd=n(Se);Br=s(fd,"A",{id:!0,class:!0,href:!0});var W1=n(Br);Ua=s(W1,"SPAN",{});var V1=n(Ua);P(bt.$$.fragment,V1),V1.forEach(o),W1.forEach(o),qh=d(fd),Ra=s(fd,"SPAN",{});var U1=n(Ra);zh=i(U1,"PerceiverMultimodalPreprocessor"),U1.forEach(o),fd.forEach(o),ll=d(r),ce=s(r,"DIV",{class:!0});var Dn=n(ce);P(wt.$$.fragment,Dn),Ah=d(Dn),Ka=s(Dn,"P",{});var R1=n(Ka);Dh=i(R1,"Multimodal preprocessing for Perceiver Encoder."),R1.forEach(o),Oh=d(Dn),Ja=s(Dn,"P",{});var K1=n(Ja);Nh=i(K1,`Inputs for each modality are preprocessed, then padded with trainable position embeddings to have the same number
of channels.`),K1.forEach(o),Dn.forEach(o),dl=d(r),Be=s(r,"H2",{class:!0});var gd=n(Be);Hr=s(gd,"A",{id:!0,class:!0,href:!0});var J1=n(Hr);Ga=s(J1,"SPAN",{});var G1=n(Ga);P(yt.$$.fragment,G1),G1.forEach(o),J1.forEach(o),Lh=d(gd),Xa=s(gd,"SPAN",{});var X1=n(Xa);Sh=i(X1,"PerceiverProjectionDecoder"),X1.forEach(o),gd.forEach(o),pl=d(r),He=s(r,"DIV",{class:!0});var vd=n(He);P($t.$$.fragment,vd),Bh=d(vd),Za=s(vd,"P",{});var Z1=n(Za);Hh=i(Z1,"Baseline projection decoder (no cross-attention)."),Z1.forEach(o),vd.forEach(o),ml=d(r),We=s(r,"H2",{class:!0});var _d=n(We);Wr=s(_d,"A",{id:!0,class:!0,href:!0});var Q1=n(Wr);Qa=s(Q1,"SPAN",{});var Y1=n(Qa);P(kt.$$.fragment,Y1),Y1.forEach(o),Q1.forEach(o),Wh=d(_d),Ya=s(_d,"SPAN",{});var eP=n(Ya);Vh=i(eP,"PerceiverBasicDecoder"),eP.forEach(o),_d.forEach(o),hl=d(r),le=s(r,"DIV",{class:!0});var On=n(le);P(Tt.$$.fragment,On),Uh=d(On),ei=s(On,"P",{});var rP=n(ei);Rh=i(rP,`Cross-attention-based decoder. This class can be used to decode the final hidden states of the latents using a
cross-attention operation, in which the latents produce keys and values.`),rP.forEach(o),Kh=d(On),ri=s(On,"P",{});var oP=n(ri);Jh=i(oP,"The shape of the output of this class depends on how one defines the output queries (also called decoder queries)."),oP.forEach(o),On.forEach(o),ul=d(r),Ve=s(r,"H2",{class:!0});var Pd=n(Ve);Vr=s(Pd,"A",{id:!0,class:!0,href:!0});var tP=n(Vr);oi=s(tP,"SPAN",{});var sP=n(oi);P(xt.$$.fragment,sP),sP.forEach(o),tP.forEach(o),Gh=d(Pd),ti=s(Pd,"SPAN",{});var nP=n(ti);Xh=i(nP,"PerceiverClassificationDecoder"),nP.forEach(o),Pd.forEach(o),fl=d(r),Ue=s(r,"DIV",{class:!0});var bd=n(Ue);P(Et.$$.fragment,bd),Zh=d(bd),Ft=s(bd,"P",{});var wd=n(Ft);Qh=i(wd,"Cross-attention based classification decoder. Light-weight wrapper of "),si=s(wd,"CODE",{});var aP=n(si);Yh=i(aP,"PerceiverBasicDecoder"),aP.forEach(o),eu=i(wd,` for logit output.
Will turn the output of the Perceiver encoder which is of shape (batch_size, num_latents, d_latents) to a tensor of
shape (batch_size, num_labels). The queries are of shape (batch_size, 1, num_labels).`),wd.forEach(o),bd.forEach(o),gl=d(r),Re=s(r,"H2",{class:!0});var yd=n(Re);Ur=s(yd,"A",{id:!0,class:!0,href:!0});var iP=n(Ur);ni=s(iP,"SPAN",{});var cP=n(ni);P(Ct.$$.fragment,cP),cP.forEach(o),iP.forEach(o),ru=d(yd),ai=s(yd,"SPAN",{});var lP=n(ai);ou=i(lP,"PerceiverOpticalFlowDecoder"),lP.forEach(o),yd.forEach(o),vl=d(r),Ke=s(r,"DIV",{class:!0});var $d=n(Ke);P(jt.$$.fragment,$d),tu=d($d),ii=s($d,"P",{});var dP=n(ii);su=i(dP,"Cross-attention based optical flow decoder."),dP.forEach(o),$d.forEach(o),_l=d(r),Je=s(r,"H2",{class:!0});var kd=n(Je);Rr=s(kd,"A",{id:!0,class:!0,href:!0});var pP=n(Rr);ci=s(pP,"SPAN",{});var mP=n(ci);P(Mt.$$.fragment,mP),mP.forEach(o),pP.forEach(o),nu=d(kd),li=s(kd,"SPAN",{});var hP=n(li);au=i(hP,"PerceiverBasicVideoAutoencodingDecoder"),hP.forEach(o),kd.forEach(o),Pl=d(r),Ge=s(r,"DIV",{class:!0});var Td=n(Ge);P(It.$$.fragment,Td),iu=d(Td),qt=s(Td,"P",{});var xd=n(qt);cu=i(xd,"Cross-attention based video-autoencoding decoder. Light-weight wrapper of ["),di=s(xd,"EM",{});var uP=n(di);lu=i(uP,"PerceiverBasicDecoder"),uP.forEach(o),du=i(xd,`] with video
reshaping logic.`),xd.forEach(o),Td.forEach(o),bl=d(r),Xe=s(r,"H2",{class:!0});var Ed=n(Xe);Kr=s(Ed,"A",{id:!0,class:!0,href:!0});var fP=n(Kr);pi=s(fP,"SPAN",{});var gP=n(pi);P(zt.$$.fragment,gP),gP.forEach(o),fP.forEach(o),pu=d(Ed),mi=s(Ed,"SPAN",{});var vP=n(mi);mu=i(vP,"PerceiverMultimodalDecoder"),vP.forEach(o),Ed.forEach(o),wl=d(r),de=s(r,"DIV",{class:!0});var Nn=n(de);P(At.$$.fragment,Nn),hu=d(Nn),Dt=s(Nn,"P",{});var Fd=n(Dt);uu=i(Fd,"Multimodal decoding by composing uni-modal decoders. The "),hi=s(Fd,"EM",{});var _P=n(hi);fu=i(_P,"modalities"),_P.forEach(o),gu=i(Fd,` argument of the constructor is a dictionary
mapping modality name to the decoder of that modality. That decoder will be used to construct queries for that
modality. Modality-specific queries are padded with trainable modality-specific parameters, after which they are
concatenated along the time dimension.`),Fd.forEach(o),vu=d(Nn),ui=s(Nn,"P",{});var PP=n(ui);_u=i(PP,"Next, there is a shared cross attention operation across all modalities."),PP.forEach(o),Nn.forEach(o),yl=d(r),Ze=s(r,"H2",{class:!0});var Cd=n(Ze);Jr=s(Cd,"A",{id:!0,class:!0,href:!0});var bP=n(Jr);fi=s(bP,"SPAN",{});var wP=n(fi);P(Ot.$$.fragment,wP),wP.forEach(o),bP.forEach(o),Pu=d(Cd),gi=s(Cd,"SPAN",{});var yP=n(gi);bu=i(yP,"PerceiverProjectionPostprocessor"),yP.forEach(o),Cd.forEach(o),$l=d(r),Qe=s(r,"DIV",{class:!0});var jd=n(Qe);P(Nt.$$.fragment,jd),wu=d(jd),vi=s(jd,"P",{});var $P=n(vi);yu=i($P,`Projection postprocessing for Perceiver. Can be used to project the channels of the decoder output to a lower
dimension.`),$P.forEach(o),jd.forEach(o),kl=d(r),Ye=s(r,"H2",{class:!0});var Md=n(Ye);Gr=s(Md,"A",{id:!0,class:!0,href:!0});var kP=n(Gr);_i=s(kP,"SPAN",{});var TP=n(_i);P(Lt.$$.fragment,TP),TP.forEach(o),kP.forEach(o),$u=d(Md),Pi=s(Md,"SPAN",{});var xP=n(Pi);ku=i(xP,"PerceiverAudioPostprocessor"),xP.forEach(o),Md.forEach(o),Tl=d(r),er=s(r,"DIV",{class:!0});var Id=n(er);P(St.$$.fragment,Id),Tu=d(Id),bi=s(Id,"P",{});var EP=n(bi);xu=i(EP,"Audio postprocessing for Perceiver. Can be used to convert the decoder output to audio features."),EP.forEach(o),Id.forEach(o),xl=d(r),rr=s(r,"H2",{class:!0});var qd=n(rr);Xr=s(qd,"A",{id:!0,class:!0,href:!0});var FP=n(Xr);wi=s(FP,"SPAN",{});var CP=n(wi);P(Bt.$$.fragment,CP),CP.forEach(o),FP.forEach(o),Eu=d(qd),yi=s(qd,"SPAN",{});var jP=n(yi);Fu=i(jP,"PerceiverClassificationPostprocessor"),jP.forEach(o),qd.forEach(o),El=d(r),or=s(r,"DIV",{class:!0});var zd=n(or);P(Ht.$$.fragment,zd),Cu=d(zd),$i=s(zd,"P",{});var MP=n($i);ju=i(MP,"Classification postprocessing for Perceiver. Can be used to convert the decoder output to classification logits."),MP.forEach(o),zd.forEach(o),Fl=d(r),tr=s(r,"H2",{class:!0});var Ad=n(tr);Zr=s(Ad,"A",{id:!0,class:!0,href:!0});var IP=n(Zr);ki=s(IP,"SPAN",{});var qP=n(ki);P(Wt.$$.fragment,qP),qP.forEach(o),IP.forEach(o),Mu=d(Ad),Ti=s(Ad,"SPAN",{});var zP=n(Ti);Iu=i(zP,"PerceiverMultimodalPostprocessor"),zP.forEach(o),Ad.forEach(o),Cl=d(r),sr=s(r,"DIV",{class:!0});var Dd=n(sr);P(Vt.$$.fragment,Dd),qu=d(Dd),xi=s(Dd,"P",{});var AP=n(xi);zu=i(AP,`Multimodal postprocessing for Perceiver. Can be used to combine modality-specific postprocessors into a single
postprocessor.`),AP.forEach(o),Dd.forEach(o),jl=d(r),nr=s(r,"H2",{class:!0});var Od=n(nr);Qr=s(Od,"A",{id:!0,class:!0,href:!0});var DP=n(Qr);Ei=s(DP,"SPAN",{});var OP=n(Ei);P(Ut.$$.fragment,OP),OP.forEach(o),DP.forEach(o),Au=d(Od),Fi=s(Od,"SPAN",{});var NP=n(Fi);Du=i(NP,"PerceiverModel"),NP.forEach(o),Od.forEach(o),Ml=d(r),pe=s(r,"DIV",{class:!0});var Ln=n(pe);P(Rt.$$.fragment,Ln),Ou=d(Ln),Kt=s(Ln,"P",{});var Nd=n(Kt);Nu=i(Nd,`The Perceiver: a scalable, fully attentional architecture.
This model is a PyTorch `),Jt=s(Nd,"A",{href:!0,rel:!0});var LP=n(Jt);Lu=i(LP,"torch.nn.Module"),LP.forEach(o),Su=i(Nd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Nd.forEach(o),Bu=d(Ln),J=s(Ln,"DIV",{class:!0});var Fo=n(J);P(Gt.$$.fragment,Fo),Hu=d(Fo),ar=s(Fo,"P",{});var Sn=n(ar);Wu=i(Sn,"The "),Qs=s(Sn,"A",{href:!0});var SP=n(Qs);Vu=i(SP,"PerceiverModel"),SP.forEach(o),Uu=i(Sn," forward method, overrides the "),Ci=s(Sn,"CODE",{});var BP=n(Ci);Ru=i(BP,"__call__"),BP.forEach(o),Ku=i(Sn," special method."),Sn.forEach(o),Ju=d(Fo),P(Yr.$$.fragment,Fo),Gu=d(Fo),P(eo.$$.fragment,Fo),Fo.forEach(o),Ln.forEach(o),Il=d(r),ir=s(r,"H2",{class:!0});var Ld=n(ir);ro=s(Ld,"A",{id:!0,class:!0,href:!0});var HP=n(ro);ji=s(HP,"SPAN",{});var WP=n(ji);P(Xt.$$.fragment,WP),WP.forEach(o),HP.forEach(o),Xu=d(Ld),Mi=s(Ld,"SPAN",{});var VP=n(Mi);Zu=i(VP,"PerceiverForMaskedLM"),VP.forEach(o),Ld.forEach(o),ql=d(r),me=s(r,"DIV",{class:!0});var Bn=n(me);P(Zt.$$.fragment,Bn),Qu=d(Bn),Qt=s(Bn,"P",{});var Sd=n(Qt);Yu=i(Sd,`Example use of Perceiver for masked language modeling.
This model is a PyTorch `),Yt=s(Sd,"A",{href:!0,rel:!0});var UP=n(Yt);ef=i(UP,"torch.nn.Module"),UP.forEach(o),rf=i(Sd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Sd.forEach(o),of=d(Bn),G=s(Bn,"DIV",{class:!0});var Co=n(G);P(es.$$.fragment,Co),tf=d(Co),cr=s(Co,"P",{});var Hn=n(cr);sf=i(Hn,"The "),Ys=s(Hn,"A",{href:!0});var RP=n(Ys);nf=i(RP,"PerceiverForMaskedLM"),RP.forEach(o),af=i(Hn," forward method, overrides the "),Ii=s(Hn,"CODE",{});var KP=n(Ii);cf=i(KP,"__call__"),KP.forEach(o),lf=i(Hn," special method."),Hn.forEach(o),df=d(Co),P(oo.$$.fragment,Co),pf=d(Co),P(to.$$.fragment,Co),Co.forEach(o),Bn.forEach(o),zl=d(r),lr=s(r,"H2",{class:!0});var Bd=n(lr);so=s(Bd,"A",{id:!0,class:!0,href:!0});var JP=n(so);qi=s(JP,"SPAN",{});var GP=n(qi);P(rs.$$.fragment,GP),GP.forEach(o),JP.forEach(o),mf=d(Bd),zi=s(Bd,"SPAN",{});var XP=n(zi);hf=i(XP,"PerceiverForSequenceClassification"),XP.forEach(o),Bd.forEach(o),Al=d(r),he=s(r,"DIV",{class:!0});var Wn=n(he);P(os.$$.fragment,Wn),uf=d(Wn),ts=s(Wn,"P",{});var Hd=n(ts);ff=i(Hd,`Example use of Perceiver for text classification.
This model is a PyTorch `),ss=s(Hd,"A",{href:!0,rel:!0});var ZP=n(ss);gf=i(ZP,"torch.nn.Module"),ZP.forEach(o),vf=i(Hd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Hd.forEach(o),_f=d(Wn),X=s(Wn,"DIV",{class:!0});var jo=n(X);P(ns.$$.fragment,jo),Pf=d(jo),dr=s(jo,"P",{});var Vn=n(dr);bf=i(Vn,"The "),en=s(Vn,"A",{href:!0});var QP=n(en);wf=i(QP,"PerceiverForSequenceClassification"),QP.forEach(o),yf=i(Vn," forward method, overrides the "),Ai=s(Vn,"CODE",{});var YP=n(Ai);$f=i(YP,"__call__"),YP.forEach(o),kf=i(Vn," special method."),Vn.forEach(o),Tf=d(jo),P(no.$$.fragment,jo),xf=d(jo),P(ao.$$.fragment,jo),jo.forEach(o),Wn.forEach(o),Dl=d(r),pr=s(r,"H2",{class:!0});var Wd=n(pr);io=s(Wd,"A",{id:!0,class:!0,href:!0});var eb=n(io);Di=s(eb,"SPAN",{});var rb=n(Di);P(as.$$.fragment,rb),rb.forEach(o),eb.forEach(o),Ef=d(Wd),Oi=s(Wd,"SPAN",{});var ob=n(Oi);Ff=i(ob,"PerceiverForImageClassificationLearned"),ob.forEach(o),Wd.forEach(o),Ol=d(r),q=s(r,"DIV",{class:!0});var oe=n(q);P(is.$$.fragment,oe),Cf=d(oe),Ni=s(oe,"P",{});var tb=n(Ni);jf=i(tb,"Example use of Perceiver for image classification, for tasks such as ImageNet."),tb.forEach(o),Mf=d(oe),Li=s(oe,"P",{});var sb=n(Li);If=i(sb,`This model uses learned position embeddings. In other words, this model is not given any privileged information about
the structure of images. As shown in the paper, this model can achieve a top-1 accuracy of 72.7 on ImageNet.`),sb.forEach(o),qf=d(oe),S=s(oe,"P",{});var ue=n(S);rn=s(ue,"A",{href:!0});var nb=n(rn);zf=i(nb,"PerceiverForImageClassificationLearned"),nb.forEach(o),Af=i(ue," uses "),on=s(ue,"A",{href:!0});var ab=n(on);Df=i(ab,"PerceiverImagePreprocessor"),ab.forEach(o),Of=i(ue,`
(with `),Si=s(ue,"CODE",{});var ib=n(Si);Nf=i(ib,'prep_type="conv1x1"'),ib.forEach(o),Lf=i(ue,`) to preprocess the input images, and
`),tn=s(ue,"A",{href:!0});var cb=n(tn);Sf=i(cb,"PerceiverClassificationDecoder"),cb.forEach(o),Bf=i(ue,` to decode the latent representation of
`),sn=s(ue,"A",{href:!0});var lb=n(sn);Hf=i(lb,"PerceiverModel"),lb.forEach(o),Wf=i(ue," into classification logits."),ue.forEach(o),Vf=d(oe),cs=s(oe,"P",{});var Vd=n(cs);Uf=i(Vd,"This model is a PyTorch "),ls=s(Vd,"A",{href:!0,rel:!0});var db=n(ls);Rf=i(db,"torch.nn.Module"),db.forEach(o),Kf=i(Vd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Vd.forEach(o),Jf=d(oe),Z=s(oe,"DIV",{class:!0});var Mo=n(Z);P(ds.$$.fragment,Mo),Gf=d(Mo),mr=s(Mo,"P",{});var Un=n(mr);Xf=i(Un,"The "),nn=s(Un,"A",{href:!0});var pb=n(nn);Zf=i(pb,"PerceiverForImageClassificationLearned"),pb.forEach(o),Qf=i(Un," forward method, overrides the "),Bi=s(Un,"CODE",{});var mb=n(Bi);Yf=i(mb,"__call__"),mb.forEach(o),eg=i(Un," special method."),Un.forEach(o),rg=d(Mo),P(co.$$.fragment,Mo),og=d(Mo),P(lo.$$.fragment,Mo),Mo.forEach(o),oe.forEach(o),Nl=d(r),hr=s(r,"H2",{class:!0});var Ud=n(hr);po=s(Ud,"A",{id:!0,class:!0,href:!0});var hb=n(po);Hi=s(hb,"SPAN",{});var ub=n(Hi);P(ps.$$.fragment,ub),ub.forEach(o),hb.forEach(o),tg=d(Ud),Wi=s(Ud,"SPAN",{});var fb=n(Wi);sg=i(fb,"PerceiverForImageClassificationFourier"),fb.forEach(o),Ud.forEach(o),Ll=d(r),z=s(r,"DIV",{class:!0});var te=n(z);P(ms.$$.fragment,te),ng=d(te),Vi=s(te,"P",{});var gb=n(Vi);ag=i(gb,"Example use of Perceiver for image classification, for tasks such as ImageNet."),gb.forEach(o),ig=d(te),Ui=s(te,"P",{});var vb=n(Ui);cg=i(vb,`This model uses fixed 2D Fourier position embeddings. As shown in the paper, this model can achieve a top-1 accuracy of
79.0 on ImageNet, and 84.5 when pre-trained on a large-scale dataset (i.e. JFT).`),vb.forEach(o),lg=d(te),B=s(te,"P",{});var fe=n(B);an=s(fe,"A",{href:!0});var _b=n(an);dg=i(_b,"PerceiverForImageClassificationLearned"),_b.forEach(o),pg=i(fe," uses "),cn=s(fe,"A",{href:!0});var Pb=n(cn);mg=i(Pb,"PerceiverImagePreprocessor"),Pb.forEach(o),hg=i(fe,`
(with `),Ri=s(fe,"CODE",{});var bb=n(Ri);ug=i(bb,'prep_type="pixels"'),bb.forEach(o),fg=i(fe,`) to preprocess the input images, and
`),ln=s(fe,"A",{href:!0});var wb=n(ln);gg=i(wb,"PerceiverClassificationDecoder"),wb.forEach(o),vg=i(fe,` to decode the latent representation of
`),dn=s(fe,"A",{href:!0});var yb=n(dn);_g=i(yb,"PerceiverModel"),yb.forEach(o),Pg=i(fe," into classification logits."),fe.forEach(o),bg=d(te),hs=s(te,"P",{});var Rd=n(hs);wg=i(Rd,"This model is a PyTorch "),us=s(Rd,"A",{href:!0,rel:!0});var $b=n(us);yg=i($b,"torch.nn.Module"),$b.forEach(o),$g=i(Rd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Rd.forEach(o),kg=d(te),Q=s(te,"DIV",{class:!0});var Io=n(Q);P(fs.$$.fragment,Io),Tg=d(Io),ur=s(Io,"P",{});var Rn=n(ur);xg=i(Rn,"The "),pn=s(Rn,"A",{href:!0});var kb=n(pn);Eg=i(kb,"PerceiverForImageClassificationFourier"),kb.forEach(o),Fg=i(Rn," forward method, overrides the "),Ki=s(Rn,"CODE",{});var Tb=n(Ki);Cg=i(Tb,"__call__"),Tb.forEach(o),jg=i(Rn," special method."),Rn.forEach(o),Mg=d(Io),P(mo.$$.fragment,Io),Ig=d(Io),P(ho.$$.fragment,Io),Io.forEach(o),te.forEach(o),Sl=d(r),fr=s(r,"H2",{class:!0});var Kd=n(fr);uo=s(Kd,"A",{id:!0,class:!0,href:!0});var xb=n(uo);Ji=s(xb,"SPAN",{});var Eb=n(Ji);P(gs.$$.fragment,Eb),Eb.forEach(o),xb.forEach(o),qg=d(Kd),Gi=s(Kd,"SPAN",{});var Fb=n(Gi);zg=i(Fb,"PerceiverForImageClassificationConvProcessing"),Fb.forEach(o),Kd.forEach(o),Bl=d(r),A=s(r,"DIV",{class:!0});var se=n(A);P(vs.$$.fragment,se),Ag=d(se),Xi=s(se,"P",{});var Cb=n(Xi);Dg=i(Cb,"Example use of Perceiver for image classification, for tasks such as ImageNet."),Cb.forEach(o),Og=d(se),Zi=s(se,"P",{});var jb=n(Zi);Ng=i(jb,`This model uses a 2D conv+maxpool preprocessing network. As shown in the paper, this model can achieve a top-1 accuracy
of 82.1 on ImageNet.`),jb.forEach(o),Lg=d(se),H=s(se,"P",{});var ge=n(H);mn=s(ge,"A",{href:!0});var Mb=n(mn);Sg=i(Mb,"PerceiverForImageClassificationLearned"),Mb.forEach(o),Bg=i(ge," uses "),hn=s(ge,"A",{href:!0});var Ib=n(hn);Hg=i(Ib,"PerceiverImagePreprocessor"),Ib.forEach(o),Wg=i(ge,`
(with `),Qi=s(ge,"CODE",{});var qb=n(Qi);Vg=i(qb,'prep_type="conv"'),qb.forEach(o),Ug=i(ge,`) to preprocess the input images, and
`),un=s(ge,"A",{href:!0});var zb=n(un);Rg=i(zb,"PerceiverClassificationDecoder"),zb.forEach(o),Kg=i(ge,` to decode the latent representation of
`),fn=s(ge,"A",{href:!0});var Ab=n(fn);Jg=i(Ab,"PerceiverModel"),Ab.forEach(o),Gg=i(ge," into classification logits."),ge.forEach(o),Xg=d(se),_s=s(se,"P",{});var Jd=n(_s);Zg=i(Jd,"This model is a PyTorch "),Ps=s(Jd,"A",{href:!0,rel:!0});var Db=n(Ps);Qg=i(Db,"torch.nn.Module"),Db.forEach(o),Yg=i(Jd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Jd.forEach(o),ev=d(se),Y=s(se,"DIV",{class:!0});var qo=n(Y);P(bs.$$.fragment,qo),rv=d(qo),gr=s(qo,"P",{});var Kn=n(gr);ov=i(Kn,"The "),gn=s(Kn,"A",{href:!0});var Ob=n(gn);tv=i(Ob,"PerceiverForImageClassificationConvProcessing"),Ob.forEach(o),sv=i(Kn," forward method, overrides the "),Yi=s(Kn,"CODE",{});var Nb=n(Yi);nv=i(Nb,"__call__"),Nb.forEach(o),av=i(Kn," special method."),Kn.forEach(o),iv=d(qo),P(fo.$$.fragment,qo),cv=d(qo),P(go.$$.fragment,qo),qo.forEach(o),se.forEach(o),Hl=d(r),vr=s(r,"H2",{class:!0});var Gd=n(vr);vo=s(Gd,"A",{id:!0,class:!0,href:!0});var Lb=n(vo);ec=s(Lb,"SPAN",{});var Sb=n(ec);P(ws.$$.fragment,Sb),Sb.forEach(o),Lb.forEach(o),lv=d(Gd),rc=s(Gd,"SPAN",{});var Bb=n(rc);dv=i(Bb,"PerceiverForOpticalFlow"),Bb.forEach(o),Gd.forEach(o),Wl=d(r),O=s(r,"DIV",{class:!0});var ye=n(O);P(ys.$$.fragment,ye),pv=d(ye),N=s(ye,"P",{});var ne=n(N);mv=i(ne,"Example use of Perceiver for optical flow, for tasks such as Sintel and KITTI. "),vn=s(ne,"A",{href:!0});var Hb=n(vn);hv=i(Hb,"PerceiverForOpticalFlow"),Hb.forEach(o),uv=i(ne,` uses
`),_n=s(ne,"A",{href:!0});var Wb=n(_n);fv=i(Wb,"PerceiverImagePreprocessor"),Wb.forEach(o),gv=i(ne," (with "),oc=s(ne,"EM",{});var Vb=n(oc);vv=i(Vb,"prep_type=\u201Cpatches\u201D"),Vb.forEach(o),_v=i(ne,`) to preprocess the
input images, and `),Pn=s(ne,"A",{href:!0});var Ub=n(Pn);Pv=i(Ub,"PerceiverOpticalFlowDecoder"),Ub.forEach(o),bv=i(ne,` to decode the latent
representation of `),bn=s(ne,"A",{href:!0});var Rb=n(bn);wv=i(Rb,"PerceiverModel"),Rb.forEach(o),yv=i(ne,"."),ne.forEach(o),$v=d(ye),tc=s(ye,"P",{});var Kb=n(tc);kv=i(Kb,`As input, one concatenates 2 subsequent frames along the channel dimension and extract a 3 x 3 patch around each pixel
(leading to 3 x 3 x 3 x 2 = 54 values for each pixel). Fixed Fourier position encodings are used to encode the position
of each pixel in the patch. Next, one applies the Perceiver encoder. To decode, one queries the latent representation
using the same encoding used for the input.`),Kb.forEach(o),Tv=d(ye),$s=s(ye,"P",{});var Xd=n($s);xv=i(Xd,"This model is a PyTorch "),ks=s(Xd,"A",{href:!0,rel:!0});var Jb=n(ks);Ev=i(Jb,"torch.nn.Module"),Jb.forEach(o),Fv=i(Xd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Xd.forEach(o),Cv=d(ye),ee=s(ye,"DIV",{class:!0});var zo=n(ee);P(Ts.$$.fragment,zo),jv=d(zo),_r=s(zo,"P",{});var Jn=n(_r);Mv=i(Jn,"The "),wn=s(Jn,"A",{href:!0});var Gb=n(wn);Iv=i(Gb,"PerceiverForOpticalFlow"),Gb.forEach(o),qv=i(Jn," forward method, overrides the "),sc=s(Jn,"CODE",{});var Xb=n(sc);zv=i(Xb,"__call__"),Xb.forEach(o),Av=i(Jn," special method."),Jn.forEach(o),Dv=d(zo),P(_o.$$.fragment,zo),Ov=d(zo),P(Po.$$.fragment,zo),zo.forEach(o),ye.forEach(o),Vl=d(r),Pr=s(r,"H2",{class:!0});var Zd=n(Pr);bo=s(Zd,"A",{id:!0,class:!0,href:!0});var Zb=n(bo);nc=s(Zb,"SPAN",{});var Qb=n(nc);P(xs.$$.fragment,Qb),Qb.forEach(o),Zb.forEach(o),Nv=d(Zd),ac=s(Zd,"SPAN",{});var Yb=n(ac);Lv=i(Yb,"PerceiverForMultimodalAutoencoding"),Yb.forEach(o),Zd.forEach(o),Ul=d(r),j=s(r,"DIV",{class:!0});var I=n(j);P(Es.$$.fragment,I),Sv=d(I),ic=s(I,"P",{});var ew=n(ic);Bv=i(ew,"Example use of Perceiver for multimodal (video) autoencoding, for tasks such as Kinetics-700."),ew.forEach(o),Hv=d(I),wo=s(I,"P",{});var kc=n(wo);yn=s(kc,"A",{href:!0});var rw=n(yn);Wv=i(rw,"PerceiverForMultimodalAutoencoding"),rw.forEach(o),Vv=i(kc," uses "),$n=s(kc,"A",{href:!0});var ow=n($n);Uv=i(ow,"PerceiverMultimodalPreprocessor"),ow.forEach(o),Rv=i(kc,` to
preprocess the 3 modalities: images, audio and class labels. This preprocessor uses modality-specific preprocessors to
preprocess every modality separately, after which they are concatenated. Trainable position embeddings are used to pad
each modality to the same number of channels to make concatenation along the time dimension possible. Next, one applies
the Perceiver encoder.`),kc.forEach(o),Kv=d(I),be=s(I,"P",{});var Os=n(be);kn=s(Os,"A",{href:!0});var tw=n(kn);Jv=i(tw,"PerceiverMultimodalDecoder"),tw.forEach(o),Gv=i(Os,` is used to decode the latent representation of
`),Tn=s(Os,"A",{href:!0});var sw=n(Tn);Xv=i(sw,"PerceiverModel"),sw.forEach(o),Zv=i(Os,`. This decoder uses each modality-specific decoder to construct queries. The decoder queries are
created based on the inputs after preprocessing. However, autoencoding an entire video in a single forward pass is
computationally infeasible, hence one only uses parts of the decoder queries to do cross-attention with the latent
representation. This is determined by the subsampled indices for each modality, which can be provided as additional
input to the forward pass of `),xn=s(Os,"A",{href:!0});var nw=n(xn);Qv=i(nw,"PerceiverForMultimodalAutoencoding"),nw.forEach(o),Yv=i(Os,"."),Os.forEach(o),e_=d(I),yo=s(I,"P",{});var Tc=n(yo);En=s(Tc,"A",{href:!0});var aw=n(En);r_=i(aw,"PerceiverMultimodalDecoder"),aw.forEach(o),o_=i(Tc,` also pads the decoder queries of the different
modalities to the same number of channels, in order to concatenate them along the time dimension. Next, cross-attention
is performed with the latent representation of `),Fn=s(Tc,"A",{href:!0});var iw=n(Fn);t_=i(iw,"PerceiverModel"),iw.forEach(o),s_=i(Tc,"."),Tc.forEach(o),n_=d(I),Fs=s(I,"P",{});var Qd=n(Fs);a_=i(Qd,"Finally, "),cc=s(Qd,"CODE",{});var cw=n(cc);i_=i(cw,"PerceiverMultiModalPostprocessor"),cw.forEach(o),c_=i(Qd,` is used to turn this tensor into an
actual video. It first splits up the output into the different modalities, and then applies the respective
postprocessor for each modality.`),Qd.forEach(o),l_=d(I),lc=s(I,"P",{});var lw=n(lc);d_=i(lw,`Note that, by masking the classification label during evaluation (i.e. simply providing a tensor of zeros for the
\u201Clabel\u201D modality), this auto-encoding model becomes a Kinetics 700 video classifier.`),lw.forEach(o),p_=d(I),Cs=s(I,"P",{});var Yd=n(Cs);m_=i(Yd,"This model is a PyTorch "),js=s(Yd,"A",{href:!0,rel:!0});var dw=n(js);h_=i(dw,"torch.nn.Module"),dw.forEach(o),u_=i(Yd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Yd.forEach(o),f_=d(I),re=s(I,"DIV",{class:!0});var Ao=n(re);P(Ms.$$.fragment,Ao),g_=d(Ao),br=s(Ao,"P",{});var Gn=n(br);v_=i(Gn,"The "),Cn=s(Gn,"A",{href:!0});var pw=n(Cn);__=i(pw,"PerceiverForMultimodalAutoencoding"),pw.forEach(o),P_=i(Gn," forward method, overrides the "),dc=s(Gn,"CODE",{});var mw=n(dc);b_=i(mw,"__call__"),mw.forEach(o),w_=i(Gn," special method."),Gn.forEach(o),y_=d(Ao),P($o.$$.fragment,Ao),$_=d(Ao),P(ko.$$.fragment,Ao),Ao.forEach(o),I.forEach(o),this.h()},h(){c(u,"name","hf:doc:metadata"),c(u,"content",JSON.stringify(Nw)),c(g,"id","perceiver"),c(g,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(g,"href","#perceiver"),c(v,"class","relative group"),c(Tr,"id","overview"),c(Tr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Tr,"href","#overview"),c($e,"class","relative group"),c(Oo,"href","https://arxiv.org/abs/2107.14795"),c(Oo,"rel","nofollow"),c(No,"href","https://arxiv.org/abs/2103.03206"),c(No,"rel","nofollow"),c(Hs,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverModel"),vw(Fr.src,x_="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/perceiver_architecture.jpg")||c(Fr,"src",x_),c(Fr,"alt","drawing"),c(Fr,"width","600"),c(Vs,"href","https://arxiv.org/abs/2105.15203"),c(So,"href","https://huggingface.co/nielsr"),c(So,"rel","nofollow"),c(Bo,"href","https://github.com/deepmind/deepmind-research/tree/master/perceiver"),c(Bo,"rel","nofollow"),c(Wo,"href","https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Perceiver"),c(Wo,"rel","nofollow"),c(Uo,"href","https://huggingface.co/blog/perceiver"),c(Uo,"rel","nofollow"),c(Ko,"href","https://github.com/pytorch/pytorch/issues/36035"),c(Ko,"rel","nofollow"),c(jr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"),c(jr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(jr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"),c(ke,"class","relative group"),c(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Mr,"id","transformers.PerceiverConfig"),c(Mr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Mr,"href","#transformers.PerceiverConfig"),c(Ce,"class","relative group"),c(Ks,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(rt,"href","https://huggingface.co/deepmind/language-perceiver"),c(rt,"rel","nofollow"),c(Js,"href","/docs/transformers/v4.19.1/en/main_classes/configuration#transformers.PretrainedConfig"),c(Gs,"href","/docs/transformers/v4.19.1/en/main_classes/configuration#transformers.PretrainedConfig"),c(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(qr,"id","transformers.PerceiverTokenizer"),c(qr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(qr,"href","#transformers.PerceiverTokenizer"),c(Ie,"class","relative group"),c(Xs,"href","/docs/transformers/v4.19.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer"),c(zr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ar,"id","transformers.PerceiverFeatureExtractor"),c(Ar,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ar,"href","#transformers.PerceiverFeatureExtractor"),c(qe,"class","relative group"),c(Zs,"href","/docs/transformers/v4.19.1/en/main_classes/feature_extractor#transformers.ImageFeatureExtractionMixin"),c(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Or,"id","transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor"),c(Or,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Or,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor"),c(ze,"class","relative group"),c(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Nr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(Nr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Nr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(Ae,"class","relative group"),c(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Lr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor"),c(Lr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Lr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor"),c(De,"class","relative group"),c(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Sr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor"),c(Sr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Sr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor"),c(Ne,"class","relative group"),c(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Br,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(Br,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Br,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(Se,"class","relative group"),c(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Hr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder"),c(Hr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Hr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder"),c(Be,"class","relative group"),c(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Wr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder"),c(Wr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Wr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder"),c(We,"class","relative group"),c(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Vr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(Vr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Vr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(Ve,"class","relative group"),c(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ur,"id","transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c(Ur,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ur,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c(Re,"class","relative group"),c(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Rr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder"),c(Rr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Rr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder"),c(Je,"class","relative group"),c(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Kr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Kr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Kr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Xe,"class","relative group"),c(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Jr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor"),c(Jr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Jr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor"),c(Ze,"class","relative group"),c(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Gr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor"),c(Gr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Gr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor"),c(Ye,"class","relative group"),c(er,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Xr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor"),c(Xr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Xr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor"),c(rr,"class","relative group"),c(or,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Zr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor"),c(Zr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Zr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor"),c(tr,"class","relative group"),c(sr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Qr,"id","transformers.PerceiverModel"),c(Qr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Qr,"href","#transformers.PerceiverModel"),c(nr,"class","relative group"),c(Jt,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(Jt,"rel","nofollow"),c(Qs,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ro,"id","transformers.PerceiverForMaskedLM"),c(ro,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(ro,"href","#transformers.PerceiverForMaskedLM"),c(ir,"class","relative group"),c(Yt,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(Yt,"rel","nofollow"),c(Ys,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForMaskedLM"),c(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(so,"id","transformers.PerceiverForSequenceClassification"),c(so,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(so,"href","#transformers.PerceiverForSequenceClassification"),c(lr,"class","relative group"),c(ss,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(ss,"rel","nofollow"),c(en,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForSequenceClassification"),c(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(io,"id","transformers.PerceiverForImageClassificationLearned"),c(io,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(io,"href","#transformers.PerceiverForImageClassificationLearned"),c(pr,"class","relative group"),c(rn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(on,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(tn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(sn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(ls,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(ls,"rel","nofollow"),c(nn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(po,"id","transformers.PerceiverForImageClassificationFourier"),c(po,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(po,"href","#transformers.PerceiverForImageClassificationFourier"),c(hr,"class","relative group"),c(an,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(cn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(ln,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(dn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(us,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(us,"rel","nofollow"),c(pn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationFourier"),c(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(uo,"id","transformers.PerceiverForImageClassificationConvProcessing"),c(uo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(uo,"href","#transformers.PerceiverForImageClassificationConvProcessing"),c(fr,"class","relative group"),c(mn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(hn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(un,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(fn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(Ps,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(Ps,"rel","nofollow"),c(gn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationConvProcessing"),c(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(vo,"id","transformers.PerceiverForOpticalFlow"),c(vo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(vo,"href","#transformers.PerceiverForOpticalFlow"),c(vr,"class","relative group"),c(vn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow"),c(_n,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(Pn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c(bn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(ks,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(ks,"rel","nofollow"),c(wn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow"),c(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(bo,"id","transformers.PerceiverForMultimodalAutoencoding"),c(bo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(bo,"href","#transformers.PerceiverForMultimodalAutoencoding"),c(Pr,"class","relative group"),c(yn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c($n,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(kn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Tn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(xn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c(En,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Fn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(js,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(js,"rel","nofollow"),c(Cn,"href","/docs/transformers/v4.19.1/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(r,m){e(document.head,u),h(r,T,m),h(r,v,m),e(v,g),e(g,k),b(p,k,null),e(v,f),e(v,F),e(F,ep),h(r,xc,m),h(r,$e,m),e($e,Tr),e(Tr,Xn),b(Do,Xn,null),e($e,rp),e($e,Zn),e(Zn,op),h(r,Ec,m),h(r,xr,m),e(xr,tp),e(xr,Oo),e(Oo,sp),e(xr,np),h(r,Fc,m),h(r,Er,m),e(Er,ap),e(Er,No),e(No,ip),e(Er,cp),h(r,Cc,m),h(r,Ns,m),e(Ns,lp),h(r,jc,m),h(r,Ls,m),e(Ls,Qn),e(Qn,dp),h(r,Mc,m),h(r,Ss,m),e(Ss,pp),h(r,Ic,m),h(r,Bs,m),e(Bs,mp),h(r,qc,m),h(r,D,m),e(D,hp),e(D,Hs),e(Hs,up),e(D,fp),e(D,Yn),e(Yn,gp),e(D,vp),e(D,ea),e(ea,_p),e(D,Pp),e(D,ra),e(ra,bp),e(D,wp),e(D,oa),e(oa,yp),e(D,$p),h(r,zc,m),h(r,Ws,m),e(Ws,kp),h(r,Ac,m),h(r,M,m),e(M,Tp),e(M,ta),e(ta,xp),e(M,Ep),e(M,sa),e(sa,Fp),e(M,Cp),e(M,na),e(na,jp),e(M,Mp),e(M,aa),e(aa,Ip),e(M,qp),e(M,ia),e(ia,zp),e(M,Ap),e(M,ca),e(ca,Dp),e(M,Op),h(r,Dc,m),h(r,Fr,m),h(r,Oc,m),h(r,Lo,m),e(Lo,Np),e(Lo,Vs),e(Vs,Lp),h(r,Nc,m),h(r,ve,m),e(ve,Sp),e(ve,So),e(So,Bp),e(ve,Hp),e(ve,Bo),e(Bo,Wp),e(ve,Vp),h(r,Lc,m),h(r,Us,m),e(Us,Up),h(r,Sc,m),h(r,Cr,m),e(Cr,Ho),e(Ho,Rp),e(Ho,Wo),e(Wo,Kp),e(Ho,Jp),e(Cr,Gp),e(Cr,Vo),e(Vo,Xp),e(Vo,Uo),e(Uo,Zp),e(Vo,Qp),h(r,Bc,m),h(r,Ro,m),e(Ro,la),e(la,Yp),e(Ro,em),h(r,Hc,m),h(r,Rs,m),e(Rs,_e),e(_e,rm),e(_e,da),e(da,om),e(_e,tm),e(_e,pa),e(pa,sm),e(_e,nm),e(_e,Ko),e(Ko,am),h(r,Wc,m),h(r,ke,m),e(ke,jr),e(jr,ma),b(Jo,ma,null),e(ke,im),e(ke,ha),e(ha,cm),h(r,Vc,m),h(r,Te,m),b(Go,Te,null),e(Te,lm),e(Te,ua),e(ua,dm),h(r,Uc,m),h(r,xe,m),b(Xo,xe,null),e(xe,pm),e(xe,fa),e(fa,mm),h(r,Rc,m),h(r,Ee,m),b(Zo,Ee,null),e(Ee,hm),e(Ee,ga),e(ga,um),h(r,Kc,m),h(r,Fe,m),b(Qo,Fe,null),e(Fe,fm),e(Fe,va),e(va,gm),h(r,Jc,m),h(r,Ce,m),e(Ce,Mr),e(Mr,_a),b(Yo,_a,null),e(Ce,vm),e(Ce,Pa),e(Pa,_m),h(r,Gc,m),h(r,V,m),b(et,V,null),e(V,Pm),e(V,je),e(je,bm),e(je,Ks),e(Ks,wm),e(je,ym),e(je,rt),e(rt,$m),e(je,km),e(V,Tm),e(V,Me),e(Me,xm),e(Me,Js),e(Js,Em),e(Me,Fm),e(Me,Gs),e(Gs,Cm),e(Me,jm),e(V,Mm),b(Ir,V,null),h(r,Xc,m),h(r,Ie,m),e(Ie,qr),e(qr,ba),b(ot,ba,null),e(Ie,Im),e(Ie,wa),e(wa,qm),h(r,Zc,m),h(r,U,m),b(tt,U,null),e(U,zm),e(U,ya),e(ya,Am),e(U,Dm),e(U,st),e(st,Om),e(st,Xs),e(Xs,Nm),e(st,Lm),e(U,Sm),e(U,zr),b(nt,zr,null),e(zr,Bm),e(zr,$a),e($a,Hm),h(r,Qc,m),h(r,qe,m),e(qe,Ar),e(Ar,ka),b(at,ka,null),e(qe,Wm),e(qe,Ta),e(Ta,Vm),h(r,Yc,m),h(r,R,m),b(it,R,null),e(R,Um),e(R,xa),e(xa,Rm),e(R,Km),e(R,ct),e(ct,Jm),e(ct,Zs),e(Zs,Gm),e(ct,Xm),e(R,Zm),e(R,Pe),b(lt,Pe,null),e(Pe,Qm),e(Pe,Ea),e(Ea,Ym),e(Pe,eh),b(Dr,Pe,null),h(r,el,m),h(r,ze,m),e(ze,Or),e(Or,Fa),b(dt,Fa,null),e(ze,rh),e(ze,Ca),e(Ca,oh),h(r,rl,m),h(r,ae,m),b(pt,ae,null),e(ae,th),e(ae,mt),e(mt,sh),e(mt,ja),e(ja,nh),e(mt,ah),e(ae,ih),e(ae,ht),e(ht,ch),e(ht,Ma),e(Ma,lh),e(ht,dh),h(r,ol,m),h(r,Ae,m),e(Ae,Nr),e(Nr,Ia),b(ut,Ia,null),e(Ae,ph),e(Ae,qa),e(qa,mh),h(r,tl,m),h(r,ie,m),b(ft,ie,null),e(ie,hh),e(ie,za),e(za,uh),e(ie,fh),e(ie,K),e(K,gh),e(K,Aa),e(Aa,vh),e(K,_h),e(K,Da),e(Da,Ph),e(K,bh),e(K,Oa),e(Oa,wh),e(K,yh),e(K,Na),e(Na,$h),e(K,kh),h(r,sl,m),h(r,De,m),e(De,Lr),e(Lr,La),b(gt,La,null),e(De,Th),e(De,Sa),e(Sa,xh),h(r,nl,m),h(r,Oe,m),b(vt,Oe,null),e(Oe,Eh),e(Oe,Ba),e(Ba,Fh),h(r,al,m),h(r,Ne,m),e(Ne,Sr),e(Sr,Ha),b(_t,Ha,null),e(Ne,Ch),e(Ne,Wa),e(Wa,jh),h(r,il,m),h(r,Le,m),b(Pt,Le,null),e(Le,Mh),e(Le,Va),e(Va,Ih),h(r,cl,m),h(r,Se,m),e(Se,Br),e(Br,Ua),b(bt,Ua,null),e(Se,qh),e(Se,Ra),e(Ra,zh),h(r,ll,m),h(r,ce,m),b(wt,ce,null),e(ce,Ah),e(ce,Ka),e(Ka,Dh),e(ce,Oh),e(ce,Ja),e(Ja,Nh),h(r,dl,m),h(r,Be,m),e(Be,Hr),e(Hr,Ga),b(yt,Ga,null),e(Be,Lh),e(Be,Xa),e(Xa,Sh),h(r,pl,m),h(r,He,m),b($t,He,null),e(He,Bh),e(He,Za),e(Za,Hh),h(r,ml,m),h(r,We,m),e(We,Wr),e(Wr,Qa),b(kt,Qa,null),e(We,Wh),e(We,Ya),e(Ya,Vh),h(r,hl,m),h(r,le,m),b(Tt,le,null),e(le,Uh),e(le,ei),e(ei,Rh),e(le,Kh),e(le,ri),e(ri,Jh),h(r,ul,m),h(r,Ve,m),e(Ve,Vr),e(Vr,oi),b(xt,oi,null),e(Ve,Gh),e(Ve,ti),e(ti,Xh),h(r,fl,m),h(r,Ue,m),b(Et,Ue,null),e(Ue,Zh),e(Ue,Ft),e(Ft,Qh),e(Ft,si),e(si,Yh),e(Ft,eu),h(r,gl,m),h(r,Re,m),e(Re,Ur),e(Ur,ni),b(Ct,ni,null),e(Re,ru),e(Re,ai),e(ai,ou),h(r,vl,m),h(r,Ke,m),b(jt,Ke,null),e(Ke,tu),e(Ke,ii),e(ii,su),h(r,_l,m),h(r,Je,m),e(Je,Rr),e(Rr,ci),b(Mt,ci,null),e(Je,nu),e(Je,li),e(li,au),h(r,Pl,m),h(r,Ge,m),b(It,Ge,null),e(Ge,iu),e(Ge,qt),e(qt,cu),e(qt,di),e(di,lu),e(qt,du),h(r,bl,m),h(r,Xe,m),e(Xe,Kr),e(Kr,pi),b(zt,pi,null),e(Xe,pu),e(Xe,mi),e(mi,mu),h(r,wl,m),h(r,de,m),b(At,de,null),e(de,hu),e(de,Dt),e(Dt,uu),e(Dt,hi),e(hi,fu),e(Dt,gu),e(de,vu),e(de,ui),e(ui,_u),h(r,yl,m),h(r,Ze,m),e(Ze,Jr),e(Jr,fi),b(Ot,fi,null),e(Ze,Pu),e(Ze,gi),e(gi,bu),h(r,$l,m),h(r,Qe,m),b(Nt,Qe,null),e(Qe,wu),e(Qe,vi),e(vi,yu),h(r,kl,m),h(r,Ye,m),e(Ye,Gr),e(Gr,_i),b(Lt,_i,null),e(Ye,$u),e(Ye,Pi),e(Pi,ku),h(r,Tl,m),h(r,er,m),b(St,er,null),e(er,Tu),e(er,bi),e(bi,xu),h(r,xl,m),h(r,rr,m),e(rr,Xr),e(Xr,wi),b(Bt,wi,null),e(rr,Eu),e(rr,yi),e(yi,Fu),h(r,El,m),h(r,or,m),b(Ht,or,null),e(or,Cu),e(or,$i),e($i,ju),h(r,Fl,m),h(r,tr,m),e(tr,Zr),e(Zr,ki),b(Wt,ki,null),e(tr,Mu),e(tr,Ti),e(Ti,Iu),h(r,Cl,m),h(r,sr,m),b(Vt,sr,null),e(sr,qu),e(sr,xi),e(xi,zu),h(r,jl,m),h(r,nr,m),e(nr,Qr),e(Qr,Ei),b(Ut,Ei,null),e(nr,Au),e(nr,Fi),e(Fi,Du),h(r,Ml,m),h(r,pe,m),b(Rt,pe,null),e(pe,Ou),e(pe,Kt),e(Kt,Nu),e(Kt,Jt),e(Jt,Lu),e(Kt,Su),e(pe,Bu),e(pe,J),b(Gt,J,null),e(J,Hu),e(J,ar),e(ar,Wu),e(ar,Qs),e(Qs,Vu),e(ar,Uu),e(ar,Ci),e(Ci,Ru),e(ar,Ku),e(J,Ju),b(Yr,J,null),e(J,Gu),b(eo,J,null),h(r,Il,m),h(r,ir,m),e(ir,ro),e(ro,ji),b(Xt,ji,null),e(ir,Xu),e(ir,Mi),e(Mi,Zu),h(r,ql,m),h(r,me,m),b(Zt,me,null),e(me,Qu),e(me,Qt),e(Qt,Yu),e(Qt,Yt),e(Yt,ef),e(Qt,rf),e(me,of),e(me,G),b(es,G,null),e(G,tf),e(G,cr),e(cr,sf),e(cr,Ys),e(Ys,nf),e(cr,af),e(cr,Ii),e(Ii,cf),e(cr,lf),e(G,df),b(oo,G,null),e(G,pf),b(to,G,null),h(r,zl,m),h(r,lr,m),e(lr,so),e(so,qi),b(rs,qi,null),e(lr,mf),e(lr,zi),e(zi,hf),h(r,Al,m),h(r,he,m),b(os,he,null),e(he,uf),e(he,ts),e(ts,ff),e(ts,ss),e(ss,gf),e(ts,vf),e(he,_f),e(he,X),b(ns,X,null),e(X,Pf),e(X,dr),e(dr,bf),e(dr,en),e(en,wf),e(dr,yf),e(dr,Ai),e(Ai,$f),e(dr,kf),e(X,Tf),b(no,X,null),e(X,xf),b(ao,X,null),h(r,Dl,m),h(r,pr,m),e(pr,io),e(io,Di),b(as,Di,null),e(pr,Ef),e(pr,Oi),e(Oi,Ff),h(r,Ol,m),h(r,q,m),b(is,q,null),e(q,Cf),e(q,Ni),e(Ni,jf),e(q,Mf),e(q,Li),e(Li,If),e(q,qf),e(q,S),e(S,rn),e(rn,zf),e(S,Af),e(S,on),e(on,Df),e(S,Of),e(S,Si),e(Si,Nf),e(S,Lf),e(S,tn),e(tn,Sf),e(S,Bf),e(S,sn),e(sn,Hf),e(S,Wf),e(q,Vf),e(q,cs),e(cs,Uf),e(cs,ls),e(ls,Rf),e(cs,Kf),e(q,Jf),e(q,Z),b(ds,Z,null),e(Z,Gf),e(Z,mr),e(mr,Xf),e(mr,nn),e(nn,Zf),e(mr,Qf),e(mr,Bi),e(Bi,Yf),e(mr,eg),e(Z,rg),b(co,Z,null),e(Z,og),b(lo,Z,null),h(r,Nl,m),h(r,hr,m),e(hr,po),e(po,Hi),b(ps,Hi,null),e(hr,tg),e(hr,Wi),e(Wi,sg),h(r,Ll,m),h(r,z,m),b(ms,z,null),e(z,ng),e(z,Vi),e(Vi,ag),e(z,ig),e(z,Ui),e(Ui,cg),e(z,lg),e(z,B),e(B,an),e(an,dg),e(B,pg),e(B,cn),e(cn,mg),e(B,hg),e(B,Ri),e(Ri,ug),e(B,fg),e(B,ln),e(ln,gg),e(B,vg),e(B,dn),e(dn,_g),e(B,Pg),e(z,bg),e(z,hs),e(hs,wg),e(hs,us),e(us,yg),e(hs,$g),e(z,kg),e(z,Q),b(fs,Q,null),e(Q,Tg),e(Q,ur),e(ur,xg),e(ur,pn),e(pn,Eg),e(ur,Fg),e(ur,Ki),e(Ki,Cg),e(ur,jg),e(Q,Mg),b(mo,Q,null),e(Q,Ig),b(ho,Q,null),h(r,Sl,m),h(r,fr,m),e(fr,uo),e(uo,Ji),b(gs,Ji,null),e(fr,qg),e(fr,Gi),e(Gi,zg),h(r,Bl,m),h(r,A,m),b(vs,A,null),e(A,Ag),e(A,Xi),e(Xi,Dg),e(A,Og),e(A,Zi),e(Zi,Ng),e(A,Lg),e(A,H),e(H,mn),e(mn,Sg),e(H,Bg),e(H,hn),e(hn,Hg),e(H,Wg),e(H,Qi),e(Qi,Vg),e(H,Ug),e(H,un),e(un,Rg),e(H,Kg),e(H,fn),e(fn,Jg),e(H,Gg),e(A,Xg),e(A,_s),e(_s,Zg),e(_s,Ps),e(Ps,Qg),e(_s,Yg),e(A,ev),e(A,Y),b(bs,Y,null),e(Y,rv),e(Y,gr),e(gr,ov),e(gr,gn),e(gn,tv),e(gr,sv),e(gr,Yi),e(Yi,nv),e(gr,av),e(Y,iv),b(fo,Y,null),e(Y,cv),b(go,Y,null),h(r,Hl,m),h(r,vr,m),e(vr,vo),e(vo,ec),b(ws,ec,null),e(vr,lv),e(vr,rc),e(rc,dv),h(r,Wl,m),h(r,O,m),b(ys,O,null),e(O,pv),e(O,N),e(N,mv),e(N,vn),e(vn,hv),e(N,uv),e(N,_n),e(_n,fv),e(N,gv),e(N,oc),e(oc,vv),e(N,_v),e(N,Pn),e(Pn,Pv),e(N,bv),e(N,bn),e(bn,wv),e(N,yv),e(O,$v),e(O,tc),e(tc,kv),e(O,Tv),e(O,$s),e($s,xv),e($s,ks),e(ks,Ev),e($s,Fv),e(O,Cv),e(O,ee),b(Ts,ee,null),e(ee,jv),e(ee,_r),e(_r,Mv),e(_r,wn),e(wn,Iv),e(_r,qv),e(_r,sc),e(sc,zv),e(_r,Av),e(ee,Dv),b(_o,ee,null),e(ee,Ov),b(Po,ee,null),h(r,Vl,m),h(r,Pr,m),e(Pr,bo),e(bo,nc),b(xs,nc,null),e(Pr,Nv),e(Pr,ac),e(ac,Lv),h(r,Ul,m),h(r,j,m),b(Es,j,null),e(j,Sv),e(j,ic),e(ic,Bv),e(j,Hv),e(j,wo),e(wo,yn),e(yn,Wv),e(wo,Vv),e(wo,$n),e($n,Uv),e(wo,Rv),e(j,Kv),e(j,be),e(be,kn),e(kn,Jv),e(be,Gv),e(be,Tn),e(Tn,Xv),e(be,Zv),e(be,xn),e(xn,Qv),e(be,Yv),e(j,e_),e(j,yo),e(yo,En),e(En,r_),e(yo,o_),e(yo,Fn),e(Fn,t_),e(yo,s_),e(j,n_),e(j,Fs),e(Fs,a_),e(Fs,cc),e(cc,i_),e(Fs,c_),e(j,l_),e(j,lc),e(lc,d_),e(j,p_),e(j,Cs),e(Cs,m_),e(Cs,js),e(js,h_),e(Cs,u_),e(j,f_),e(j,re),b(Ms,re,null),e(re,g_),e(re,br),e(br,v_),e(br,Cn),e(Cn,__),e(br,P_),e(br,dc),e(dc,b_),e(br,w_),e(re,y_),b($o,re,null),e(re,$_),b(ko,re,null),Rl=!0},p(r,[m]){const Is={};m&2&&(Is.$$scope={dirty:m,ctx:r}),Ir.$set(Is);const pc={};m&2&&(pc.$$scope={dirty:m,ctx:r}),Dr.$set(pc);const mc={};m&2&&(mc.$$scope={dirty:m,ctx:r}),Yr.$set(mc);const hc={};m&2&&(hc.$$scope={dirty:m,ctx:r}),eo.$set(hc);const qs={};m&2&&(qs.$$scope={dirty:m,ctx:r}),oo.$set(qs);const uc={};m&2&&(uc.$$scope={dirty:m,ctx:r}),to.$set(uc);const fc={};m&2&&(fc.$$scope={dirty:m,ctx:r}),no.$set(fc);const gc={};m&2&&(gc.$$scope={dirty:m,ctx:r}),ao.$set(gc);const zs={};m&2&&(zs.$$scope={dirty:m,ctx:r}),co.$set(zs);const vc={};m&2&&(vc.$$scope={dirty:m,ctx:r}),lo.$set(vc);const As={};m&2&&(As.$$scope={dirty:m,ctx:r}),mo.$set(As);const _c={};m&2&&(_c.$$scope={dirty:m,ctx:r}),ho.$set(_c);const Pc={};m&2&&(Pc.$$scope={dirty:m,ctx:r}),fo.$set(Pc);const bc={};m&2&&(bc.$$scope={dirty:m,ctx:r}),go.$set(bc);const wc={};m&2&&(wc.$$scope={dirty:m,ctx:r}),_o.$set(wc);const yc={};m&2&&(yc.$$scope={dirty:m,ctx:r}),Po.$set(yc);const $c={};m&2&&($c.$$scope={dirty:m,ctx:r}),$o.$set($c);const L={};m&2&&(L.$$scope={dirty:m,ctx:r}),ko.$set(L)},i(r){Rl||(w(p.$$.fragment,r),w(Do.$$.fragment,r),w(Jo.$$.fragment,r),w(Go.$$.fragment,r),w(Xo.$$.fragment,r),w(Zo.$$.fragment,r),w(Qo.$$.fragment,r),w(Yo.$$.fragment,r),w(et.$$.fragment,r),w(Ir.$$.fragment,r),w(ot.$$.fragment,r),w(tt.$$.fragment,r),w(nt.$$.fragment,r),w(at.$$.fragment,r),w(it.$$.fragment,r),w(lt.$$.fragment,r),w(Dr.$$.fragment,r),w(dt.$$.fragment,r),w(pt.$$.fragment,r),w(ut.$$.fragment,r),w(ft.$$.fragment,r),w(gt.$$.fragment,r),w(vt.$$.fragment,r),w(_t.$$.fragment,r),w(Pt.$$.fragment,r),w(bt.$$.fragment,r),w(wt.$$.fragment,r),w(yt.$$.fragment,r),w($t.$$.fragment,r),w(kt.$$.fragment,r),w(Tt.$$.fragment,r),w(xt.$$.fragment,r),w(Et.$$.fragment,r),w(Ct.$$.fragment,r),w(jt.$$.fragment,r),w(Mt.$$.fragment,r),w(It.$$.fragment,r),w(zt.$$.fragment,r),w(At.$$.fragment,r),w(Ot.$$.fragment,r),w(Nt.$$.fragment,r),w(Lt.$$.fragment,r),w(St.$$.fragment,r),w(Bt.$$.fragment,r),w(Ht.$$.fragment,r),w(Wt.$$.fragment,r),w(Vt.$$.fragment,r),w(Ut.$$.fragment,r),w(Rt.$$.fragment,r),w(Gt.$$.fragment,r),w(Yr.$$.fragment,r),w(eo.$$.fragment,r),w(Xt.$$.fragment,r),w(Zt.$$.fragment,r),w(es.$$.fragment,r),w(oo.$$.fragment,r),w(to.$$.fragment,r),w(rs.$$.fragment,r),w(os.$$.fragment,r),w(ns.$$.fragment,r),w(no.$$.fragment,r),w(ao.$$.fragment,r),w(as.$$.fragment,r),w(is.$$.fragment,r),w(ds.$$.fragment,r),w(co.$$.fragment,r),w(lo.$$.fragment,r),w(ps.$$.fragment,r),w(ms.$$.fragment,r),w(fs.$$.fragment,r),w(mo.$$.fragment,r),w(ho.$$.fragment,r),w(gs.$$.fragment,r),w(vs.$$.fragment,r),w(bs.$$.fragment,r),w(fo.$$.fragment,r),w(go.$$.fragment,r),w(ws.$$.fragment,r),w(ys.$$.fragment,r),w(Ts.$$.fragment,r),w(_o.$$.fragment,r),w(Po.$$.fragment,r),w(xs.$$.fragment,r),w(Es.$$.fragment,r),w(Ms.$$.fragment,r),w($o.$$.fragment,r),w(ko.$$.fragment,r),Rl=!0)},o(r){y(p.$$.fragment,r),y(Do.$$.fragment,r),y(Jo.$$.fragment,r),y(Go.$$.fragment,r),y(Xo.$$.fragment,r),y(Zo.$$.fragment,r),y(Qo.$$.fragment,r),y(Yo.$$.fragment,r),y(et.$$.fragment,r),y(Ir.$$.fragment,r),y(ot.$$.fragment,r),y(tt.$$.fragment,r),y(nt.$$.fragment,r),y(at.$$.fragment,r),y(it.$$.fragment,r),y(lt.$$.fragment,r),y(Dr.$$.fragment,r),y(dt.$$.fragment,r),y(pt.$$.fragment,r),y(ut.$$.fragment,r),y(ft.$$.fragment,r),y(gt.$$.fragment,r),y(vt.$$.fragment,r),y(_t.$$.fragment,r),y(Pt.$$.fragment,r),y(bt.$$.fragment,r),y(wt.$$.fragment,r),y(yt.$$.fragment,r),y($t.$$.fragment,r),y(kt.$$.fragment,r),y(Tt.$$.fragment,r),y(xt.$$.fragment,r),y(Et.$$.fragment,r),y(Ct.$$.fragment,r),y(jt.$$.fragment,r),y(Mt.$$.fragment,r),y(It.$$.fragment,r),y(zt.$$.fragment,r),y(At.$$.fragment,r),y(Ot.$$.fragment,r),y(Nt.$$.fragment,r),y(Lt.$$.fragment,r),y(St.$$.fragment,r),y(Bt.$$.fragment,r),y(Ht.$$.fragment,r),y(Wt.$$.fragment,r),y(Vt.$$.fragment,r),y(Ut.$$.fragment,r),y(Rt.$$.fragment,r),y(Gt.$$.fragment,r),y(Yr.$$.fragment,r),y(eo.$$.fragment,r),y(Xt.$$.fragment,r),y(Zt.$$.fragment,r),y(es.$$.fragment,r),y(oo.$$.fragment,r),y(to.$$.fragment,r),y(rs.$$.fragment,r),y(os.$$.fragment,r),y(ns.$$.fragment,r),y(no.$$.fragment,r),y(ao.$$.fragment,r),y(as.$$.fragment,r),y(is.$$.fragment,r),y(ds.$$.fragment,r),y(co.$$.fragment,r),y(lo.$$.fragment,r),y(ps.$$.fragment,r),y(ms.$$.fragment,r),y(fs.$$.fragment,r),y(mo.$$.fragment,r),y(ho.$$.fragment,r),y(gs.$$.fragment,r),y(vs.$$.fragment,r),y(bs.$$.fragment,r),y(fo.$$.fragment,r),y(go.$$.fragment,r),y(ws.$$.fragment,r),y(ys.$$.fragment,r),y(Ts.$$.fragment,r),y(_o.$$.fragment,r),y(Po.$$.fragment,r),y(xs.$$.fragment,r),y(Es.$$.fragment,r),y(Ms.$$.fragment,r),y($o.$$.fragment,r),y(ko.$$.fragment,r),Rl=!1},d(r){o(u),r&&o(T),r&&o(v),$(p),r&&o(xc),r&&o($e),$(Do),r&&o(Ec),r&&o(xr),r&&o(Fc),r&&o(Er),r&&o(Cc),r&&o(Ns),r&&o(jc),r&&o(Ls),r&&o(Mc),r&&o(Ss),r&&o(Ic),r&&o(Bs),r&&o(qc),r&&o(D),r&&o(zc),r&&o(Ws),r&&o(Ac),r&&o(M),r&&o(Dc),r&&o(Fr),r&&o(Oc),r&&o(Lo),r&&o(Nc),r&&o(ve),r&&o(Lc),r&&o(Us),r&&o(Sc),r&&o(Cr),r&&o(Bc),r&&o(Ro),r&&o(Hc),r&&o(Rs),r&&o(Wc),r&&o(ke),$(Jo),r&&o(Vc),r&&o(Te),$(Go),r&&o(Uc),r&&o(xe),$(Xo),r&&o(Rc),r&&o(Ee),$(Zo),r&&o(Kc),r&&o(Fe),$(Qo),r&&o(Jc),r&&o(Ce),$(Yo),r&&o(Gc),r&&o(V),$(et),$(Ir),r&&o(Xc),r&&o(Ie),$(ot),r&&o(Zc),r&&o(U),$(tt),$(nt),r&&o(Qc),r&&o(qe),$(at),r&&o(Yc),r&&o(R),$(it),$(lt),$(Dr),r&&o(el),r&&o(ze),$(dt),r&&o(rl),r&&o(ae),$(pt),r&&o(ol),r&&o(Ae),$(ut),r&&o(tl),r&&o(ie),$(ft),r&&o(sl),r&&o(De),$(gt),r&&o(nl),r&&o(Oe),$(vt),r&&o(al),r&&o(Ne),$(_t),r&&o(il),r&&o(Le),$(Pt),r&&o(cl),r&&o(Se),$(bt),r&&o(ll),r&&o(ce),$(wt),r&&o(dl),r&&o(Be),$(yt),r&&o(pl),r&&o(He),$($t),r&&o(ml),r&&o(We),$(kt),r&&o(hl),r&&o(le),$(Tt),r&&o(ul),r&&o(Ve),$(xt),r&&o(fl),r&&o(Ue),$(Et),r&&o(gl),r&&o(Re),$(Ct),r&&o(vl),r&&o(Ke),$(jt),r&&o(_l),r&&o(Je),$(Mt),r&&o(Pl),r&&o(Ge),$(It),r&&o(bl),r&&o(Xe),$(zt),r&&o(wl),r&&o(de),$(At),r&&o(yl),r&&o(Ze),$(Ot),r&&o($l),r&&o(Qe),$(Nt),r&&o(kl),r&&o(Ye),$(Lt),r&&o(Tl),r&&o(er),$(St),r&&o(xl),r&&o(rr),$(Bt),r&&o(El),r&&o(or),$(Ht),r&&o(Fl),r&&o(tr),$(Wt),r&&o(Cl),r&&o(sr),$(Vt),r&&o(jl),r&&o(nr),$(Ut),r&&o(Ml),r&&o(pe),$(Rt),$(Gt),$(Yr),$(eo),r&&o(Il),r&&o(ir),$(Xt),r&&o(ql),r&&o(me),$(Zt),$(es),$(oo),$(to),r&&o(zl),r&&o(lr),$(rs),r&&o(Al),r&&o(he),$(os),$(ns),$(no),$(ao),r&&o(Dl),r&&o(pr),$(as),r&&o(Ol),r&&o(q),$(is),$(ds),$(co),$(lo),r&&o(Nl),r&&o(hr),$(ps),r&&o(Ll),r&&o(z),$(ms),$(fs),$(mo),$(ho),r&&o(Sl),r&&o(fr),$(gs),r&&o(Bl),r&&o(A),$(vs),$(bs),$(fo),$(go),r&&o(Hl),r&&o(vr),$(ws),r&&o(Wl),r&&o(O),$(ys),$(Ts),$(_o),$(Po),r&&o(Vl),r&&o(Pr),$(xs),r&&o(Ul),r&&o(j),$(Es),$(Ms),$($o),$(ko)}}}const Nw={local:"perceiver",sections:[{local:"overview",title:"Overview"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",title:"Perceiver specific outputs"},{local:"transformers.PerceiverConfig",title:"PerceiverConfig"},{local:"transformers.PerceiverTokenizer",title:"PerceiverTokenizer"},{local:"transformers.PerceiverFeatureExtractor",title:"PerceiverFeatureExtractor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",title:"PerceiverTextPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",title:"PerceiverImagePreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",title:"PerceiverOneHotPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",title:"PerceiverAudioPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",title:"PerceiverMultimodalPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",title:"PerceiverProjectionDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",title:"PerceiverBasicDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",title:"PerceiverClassificationDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",title:"PerceiverOpticalFlowDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",title:"PerceiverBasicVideoAutoencodingDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",title:"PerceiverMultimodalDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",title:"PerceiverProjectionPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",title:"PerceiverAudioPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",title:"PerceiverClassificationPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",title:"PerceiverMultimodalPostprocessor"},{local:"transformers.PerceiverModel",title:"PerceiverModel"},{local:"transformers.PerceiverForMaskedLM",title:"PerceiverForMaskedLM"},{local:"transformers.PerceiverForSequenceClassification",title:"PerceiverForSequenceClassification"},{local:"transformers.PerceiverForImageClassificationLearned",title:"PerceiverForImageClassificationLearned"},{local:"transformers.PerceiverForImageClassificationFourier",title:"PerceiverForImageClassificationFourier"},{local:"transformers.PerceiverForImageClassificationConvProcessing",title:"PerceiverForImageClassificationConvProcessing"},{local:"transformers.PerceiverForOpticalFlow",title:"PerceiverForOpticalFlow"},{local:"transformers.PerceiverForMultimodalAutoencoding",title:"PerceiverForMultimodalAutoencoding"}],title:"Perceiver"};function Lw(E){return _w(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rw extends hw{constructor(u){super();uw(this,u,Lw,Ow,fw,{})}}export{Rw as default,Nw as metadata};
