import{s as ol,o as pl,n as il}from"../chunks/scheduler.182ea377.js";import{S as rl,i as ml,g as i,s as a,r as m,A as cl,h as o,f as l,c as n,j as sl,u as c,x as p,k as al,y as ul,a as s,v as u,d,t as h,w as f}from"../chunks/index.abf12888.js";import{T as nl}from"../chunks/Tip.230e2334.js";import{C as y}from"../chunks/CodeBlock.57fe6e13.js";import{D as dl}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as Je}from"../chunks/Heading.16916d63.js";function hl(be){let r,w='Learn more details in the <a href="#how-does-parallelization-work">How does parallelization work?</a> section.';return{c(){r=i("p"),r.innerHTML=w},l(M){r=o(M,"P",{"data-svelte-h":!0}),p(r)!=="svelte-5pbnhk"&&(r.innerHTML=w)},m(M,T){s(M,r,T)},p:il,d(M){M&&l(r)}}}function fl(be){let r,w="You need to ensure all your inputs have the same shape in subsequent calls, otherwise JAX will need to recompile the code which is slower.";return{c(){r=i("p"),r.textContent=w},l(M){r=o(M,"P",{"data-svelte-h":!0}),p(r)!=="svelte-jgm5rf"&&(r.textContent=w)},m(M,T){s(M,r,T)},p:il,d(M){M&&l(r)}}}function Ml(be){let r,w,M,T,j,Ue,U,ge,g,gt="🤗 Diffusers supports Flax for super fast inference on Google TPUs, such as those available in Colab, Kaggle or Google Cloud Platform. This guide shows you how to run inference with Stable Diffusion using JAX/Flax.",$e,$,$t="Before you begin, make sure you have the necessary libraries installed:",ve,v,Be,B,vt="You should also make sure you’re using a TPU backend. While JAX does not run exclusively on TPUs, you’ll get the best performance on a TPU because each server has 8 TPU accelerators working in parallel.",_e,_,Bt="If you are running this guide in Colab, select <em>Runtime</em> in the menu above, select the option <em>Change runtime type</em>, and then select <em>TPU</em> under the <em>Hardware accelerator</em> setting. Import JAX and quickly check whether you’re using a TPU:",Ce,C,xe,x,_t="Great, now you can import the rest of the dependencies you’ll need:",Ie,I,ke,k,We,W,Ct="Flax is a functional framework, so models are stateless and parameters are stored outside of them. Loading a pretrained Flax pipeline returns <em>both</em> the pipeline and the model weights (or parameters). In this guide, you’ll use <code>bfloat16</code>, a more efficient half-float type that is supported by TPUs (you can also use <code>float32</code> for full precision if you want).",Xe,X,Ge,G,Ze,Z,xt="TPUs usually have 8 devices working in parallel, so let’s use the same prompt for each device. This means you can perform inference on 8 devices at once, with each device generating one image. As a result, you’ll get 8 images in the same amount of time it takes for one chip to generate a single image!",He,b,Fe,H,It="After replicating the prompt, get the tokenized text ids by calling the <code>prepare_inputs</code> function on the pipeline. The length of the tokenized text is set to 77 tokens as required by the configuration of the underlying CLIP text model.",Ye,F,Qe,Y,kt='Model parameters and inputs have to be replicated across the 8 parallel devices. The parameters dictionary is replicated with <a href="https://flax.readthedocs.io/en/latest/api_reference/flax.jax_utils.html#flax.jax_utils.replicate" rel="nofollow"><code>flax.jax_utils.replicate</code></a> which traverses the dictionary and changes the shape of the weights so they are repeated 8 times. Arrays are replicated using <code>shard</code>.',ze,Q,Ee,z,Wt="This shape means each one of the 8 devices receives as an input a <code>jnp</code> array with shape <code>(1, 77)</code>, where <code>1</code> is the batch size per device. On TPUs with sufficient memory, you could have a batch size larger than <code>1</code> if you want to generate multiple images (per chip) at once.",Re,E,Xt="Next, create a random number generator to pass to the generation function. This is standard procedure in Flax, which is very serious and opinionated about random numbers. All functions that deal with random numbers are expected to receive a generator to ensure reproducibility, even when you’re training across multiple distributed devices.",Le,R,Gt="The helper function below uses a seed to initialize a random number generator. As long as you use the same seed, you’ll get the exact same results. Feel free to use different seeds when exploring results later in the guide.",Ne,L,Se,N,Zt="The helper function, or <code>rng</code>, is split 8 times so each device receives a different generator and generates a different image.",Ve,S,Ae,V,Ht="To take advantage of JAX’s optimized speed on a TPU, pass <code>jit=True</code> to the pipeline to compile the JAX code into an efficient representation and to ensure the model runs in parallel across the 8 devices.",Pe,J,qe,A,Ft="The first inference run takes more time because it needs to compile the code, but subsequent calls (even with different inputs) are much faster. For example, it took more than a minute to compile on a TPU v2-8, but then it takes about <strong>7s</strong> on a future inference run!",De,P,Ke,q,Yt='The returned array has shape <code>(8, 1, 512, 512, 3)</code> which should be reshaped to remove the second dimension and get 8 images of <code>512 × 512 × 3</code>. Then you can use the <a href="/docs/diffusers/v0.27.1/en/api/utilities#diffusers.utils.numpy_to_pil">numpy_to_pil()</a> function to convert the arrays into images.',Oe,D,et,K,Qt='<img src="https://huggingface.co/datasets/YiYiXu/test-doc-assets/resolve/main/stable_diffusion_jax_how_to_cell_38_output_0.jpeg" alt="img"/>',tt,O,lt,ee,zt="You don’t necessarily have to use the same prompt on all devices. For example, to generate 8 different prompts:",st,te,at,le,Et='<img src="https://huggingface.co/datasets/YiYiXu/test-doc-assets/resolve/main/stable_diffusion_jax_how_to_cell_43_output_0.jpeg" alt="img"/>',nt,se,it,ae,Rt="The Flax pipeline in 🤗 Diffusers automatically compiles the model and runs it in parallel on all available devices. Let’s take a closer look at how that process works.",ot,ne,Lt='JAX parallelization can be done in multiple ways. The easiest one revolves around using the <a href="https://jax.readthedocs.io/en/latest/_autosummary/jax.pmap.html" rel="nofollow"><code>jax.pmap</code></a> function to achieve single-program multiple-data (SPMD) parallelization. It means running several copies of the same code, each on different data inputs. More sophisticated approaches are possible, and you can go over to the JAX <a href="https://jax.readthedocs.io/en/latest/index.html" rel="nofollow">documentation</a> to explore this topic in more detail if you are interested!',pt,ie,Nt="<code>jax.pmap</code> does two things:",rt,oe,St="<li>Compiles (or ”<code>jit</code>s”) the code which is similar to <code>jax.jit()</code>. This does not happen when you call <code>pmap</code>, and only the first time the <code>pmap</code>ped function is called.</li> <li>Ensures the compiled code runs in parallel on all available devices.</li>",mt,pe,Vt="To demonstrate, call <code>pmap</code> on the pipeline’s <code>_generate</code> method (this is a private method that generates images and may be renamed or removed in future releases of 🤗 Diffusers):",ct,re,ut,me,At="After calling <code>pmap</code>, the prepared function <code>p_generate</code> will:",dt,ce,Pt="<li>Make a copy of the underlying function, <code>pipeline._generate</code>, on each device.</li> <li>Send each device a different portion of the input arguments (this is why it’s necessary to call the <em>shard</em> function). In this case, <code>prompt_ids</code> has shape <code>(8, 1, 77, 768)</code> so the array is split into 8 and each copy of <code>_generate</code> receives an input with shape <code>(1, 77, 768)</code>.</li>",ht,ue,qt="The most important thing to pay attention to here is the batch size (1 in this example), and the input dimensions that make sense for your code. You don’t have to change anything else to make the code work in parallel.",ft,de,Dt="The first time you call the pipeline takes more time, but the calls afterward are much faster. The <code>block_until_ready</code> function is used to correctly measure inference time because JAX uses asynchronous dispatch and returns control to the Python loop as soon as it can. You don’t need to use that in your code; blocking occurs automatically when you want to use the result of a computation that has not yet been materialized.",Mt,he,yt,fe,Kt="Check your image dimensions to see if they’re correct:",wt,Me,Tt,ye,bt,we,Ot="To learn more about how JAX works with Stable Diffusion, you may be interested in reading:",Jt,Te,el='<li><a href="https://hf.co/blog/sdxl_jax" rel="nofollow">Accelerating Stable Diffusion XL Inference with JAX on Cloud TPU v5e</a></li>',jt,je,Ut;return j=new Je({props:{title:"JAX/Flax",local:"jaxflax",headingTag:"h1"}}),U=new dl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion_jax_how_to.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion_jax_how_to.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion_jax_how_to.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion_jax_how_to.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion_jax_how_to.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion_jax_how_to.ipynb"}]}}),v=new y({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBqYXglM0QlM0QwLjMuMjUlMjBqYXhsaWIlM0QlM0QwLjMuMjUlMjBmbGF4JTIwdHJhbnNmb3JtZXJzJTIwZnRmeSUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnM=",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q jax==0.3.25 jaxlib==0.3.25 flax transformers ftfy</span>
<span class="hljs-comment">#!pip install -q diffusers</span>`,wrap:!1}}),C=new y({props:{code:"aW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwamF4LnRvb2xzLmNvbGFiX3RwdSUwQWpheC50b29scy5jb2xhYl90cHUuc2V0dXBfdHB1KCklMEElMEFudW1fZGV2aWNlcyUyMCUzRCUyMGpheC5kZXZpY2VfY291bnQoKSUwQWRldmljZV90eXBlJTIwJTNEJTIwamF4LmRldmljZXMoKSU1QjAlNUQuZGV2aWNlX2tpbmQlMEElMEFwcmludChmJTIyRm91bmQlMjAlN0JudW1fZGV2aWNlcyU3RCUyMEpBWCUyMGRldmljZXMlMjBvZiUyMHR5cGUlMjAlN0JkZXZpY2VfdHlwZSU3RC4lMjIpJTBBYXNzZXJ0JTIwKCUwQSUyMCUyMCUyMCUyMCUyMlRQVSUyMiUyMGluJTIwZGV2aWNlX3R5cGUlMkMlMEElMjAlMjAlMjAlMjAlMjJBdmFpbGFibGUlMjBkZXZpY2UlMjBpcyUyMG5vdCUyMGElMjBUUFUlMkMlMjBwbGVhc2UlMjBzZWxlY3QlMjBUUFUlMjBmcm9tJTIwUnVudGltZSUyMCUzRSUyMENoYW5nZSUyMHJ1bnRpbWUlMjB0eXBlJTIwJTNFJTIwSGFyZHdhcmUlMjBhY2NlbGVyYXRvciUyMiUwQSklMEElMjMlMjBGb3VuZCUyMDglMjBKQVglMjBkZXZpY2VzJTIwb2YlMjB0eXBlJTIwQ2xvdWQlMjBUUFUu",highlighted:`<span class="hljs-keyword">import</span> jax
<span class="hljs-keyword">import</span> jax.tools.colab_tpu
jax.tools.colab_tpu.setup_tpu()

num_devices = jax.device_count()
device_type = jax.devices()[<span class="hljs-number">0</span>].device_kind

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Found <span class="hljs-subst">{num_devices}</span> JAX devices of type <span class="hljs-subst">{device_type}</span>.&quot;</span>)
<span class="hljs-keyword">assert</span> (
    <span class="hljs-string">&quot;TPU&quot;</span> <span class="hljs-keyword">in</span> device_type,
    <span class="hljs-string">&quot;Available device is not a TPU, please select TPU from Runtime &gt; Change runtime type &gt; Hardware accelerator&quot;</span>
)
<span class="hljs-comment"># Found 8 JAX devices of type Cloud TPU.</span>`,wrap:!1}}),I=new y({props:{code:"aW1wb3J0JTIwamF4Lm51bXB5JTIwYXMlMjBqbnAlMEFmcm9tJTIwamF4JTIwaW1wb3J0JTIwcG1hcCUwQWZyb20lMjBmbGF4LmpheF91dGlscyUyMGltcG9ydCUyMHJlcGxpY2F0ZSUwQWZyb20lMjBmbGF4LnRyYWluaW5nLmNvbW1vbl91dGlscyUyMGltcG9ydCUyMHNoYXJkJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhTdGFibGVEaWZmdXNpb25QaXBlbGluZQ==",highlighted:`<span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp
<span class="hljs-keyword">from</span> jax <span class="hljs-keyword">import</span> pmap
<span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline`,wrap:!1}}),k=new Je({props:{title:"Load a model",local:"load-a-model",headingTag:"h2"}}),X=new y({props:{code:"ZHR5cGUlMjAlM0QlMjBqbnAuYmZsb2F0MTYlMEFwaXBlbGluZSUyQyUyMHBhcmFtcyUyMCUzRCUyMEZsYXhTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNEJTIyYmYxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGR0eXBlJTNEZHR5cGUlMkMlMEEp",highlighted:`dtype = jnp.bfloat16
pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    revision=<span class="hljs-string">&quot;bf16&quot;</span>,
    dtype=dtype,
)`,wrap:!1}}),G=new Je({props:{title:"Inference",local:"inference",headingTag:"h2"}}),b=new nl({props:{$$slots:{default:[hl]},$$scope:{ctx:be}}}),F=new y({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNpbmVtYXRpYyUyMGZpbG0lMjBzdGlsbCUyMG9mJTIwTW9yZ2FuJTIwRnJlZW1hbiUyMHN0YXJyaW5nJTIwYXMlMjBKaW1pJTIwSGVuZHJpeCUyQyUyMHBvcnRyYWl0JTJDJTIwNDBtbSUyMGxlbnMlMkMlMjBzaGFsbG93JTIwZGVwdGglMjBvZiUyMGZpZWxkJTJDJTIwY2xvc2UlMjB1cCUyQyUyMHNwbGl0JTIwbGlnaHRpbmclMkMlMjBjaW5lbWF0aWMlMjIlMEFwcm9tcHQlMjAlM0QlMjAlNUJwcm9tcHQlNUQlMjAqJTIwamF4LmRldmljZV9jb3VudCgpJTBBcHJvbXB0X2lkcyUyMCUzRCUyMHBpcGVsaW5lLnByZXBhcmVfaW5wdXRzKHByb21wdCklMEFwcm9tcHRfaWRzLnNoYXBlJTBBJTIzJTIwKDglMkMlMjA3Nyk=",highlighted:`prompt = <span class="hljs-string">&quot;A cinematic film still of Morgan Freeman starring as Jimi Hendrix, portrait, 40mm lens, shallow depth of field, close up, split lighting, cinematic&quot;</span>
prompt = [prompt] * jax.device_count()
prompt_ids = pipeline.prepare_inputs(prompt)
prompt_ids.shape
<span class="hljs-comment"># (8, 77)</span>`,wrap:!1}}),Q=new y({props:{code:"JTIzJTIwcGFyYW1ldGVycyUwQXBfcGFyYW1zJTIwJTNEJTIwcmVwbGljYXRlKHBhcmFtcyklMEElMEElMjMlMjBhcnJheXMlMEFwcm9tcHRfaWRzJTIwJTNEJTIwc2hhcmQocHJvbXB0X2lkcyklMEFwcm9tcHRfaWRzLnNoYXBlJTBBJTIzJTIwKDglMkMlMjAxJTJDJTIwNzcp",highlighted:`<span class="hljs-comment"># parameters</span>
p_params = replicate(params)

<span class="hljs-comment"># arrays</span>
prompt_ids = shard(prompt_ids)
prompt_ids.shape
<span class="hljs-comment"># (8, 1, 77)</span>`,wrap:!1}}),L=new y({props:{code:"ZGVmJTIwY3JlYXRlX2tleShzZWVkJTNEMCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBqYXgucmFuZG9tLlBSTkdLZXkoc2VlZCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_key</span>(<span class="hljs-params">seed=<span class="hljs-number">0</span></span>):
    <span class="hljs-keyword">return</span> jax.random.PRNGKey(seed)`,wrap:!1}}),S=new y({props:{code:"cm5nJTIwJTNEJTIwY3JlYXRlX2tleSgwKSUwQXJuZyUyMCUzRCUyMGpheC5yYW5kb20uc3BsaXQocm5nJTJDJTIwamF4LmRldmljZV9jb3VudCgpKQ==",highlighted:`rng = create_key(<span class="hljs-number">0</span>)
rng = jax.random.split(rng, jax.device_count())`,wrap:!1}}),J=new nl({props:{warning:!0,$$slots:{default:[fl]},$$scope:{ctx:be}}}),P=new y({props:{code:"JTI1JTI1dGltZSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdF9pZHMlMkMlMjBwX3BhcmFtcyUyQyUyMHJuZyUyQyUyMGppdCUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMENQVSUyMHRpbWVzJTNBJTIwdXNlciUyMDU2LjIlMjBzJTJDJTIwc3lzJTNBJTIwNDIuNSUyMHMlMkMlMjB0b3RhbCUzQSUyMDFtaW4lMjAzOHMlMEElMjMlMjBXYWxsJTIwdGltZSUzQSUyMDFtaW4lMjAyOXM=",highlighted:`%%time
images = pipeline(prompt_ids, p_params, rng, jit=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]

<span class="hljs-comment"># CPU times: user 56.2 s, sys: 42.5 s, total: 1min 38s</span>
<span class="hljs-comment"># Wall time: 1min 29s</span>`,wrap:!1}}),D=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQWltYWdlcyUyMCUzRCUyMGltYWdlcy5yZXNoYXBlKChpbWFnZXMuc2hhcGUlNUIwJTVEJTIwKiUyMGltYWdlcy5zaGFwZSU1QjElNUQlMkMpJTIwJTJCJTIwaW1hZ2VzLnNoYXBlJTVCLTMlM0ElNUQpJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUubnVtcHlfdG9fcGlsKGltYWdlcyklMEFtYWtlX2ltYWdlX2dyaWQoaW1hZ2VzJTJDJTIwcm93cyUzRDIlMkMlMjBjb2xzJTNENCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

images = images.reshape((images.shape[<span class="hljs-number">0</span>] * images.shape[<span class="hljs-number">1</span>],) + images.shape[-<span class="hljs-number">3</span>:])
images = pipeline.numpy_to_pil(images)
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),O=new Je({props:{title:"Using different prompts",local:"using-different-prompts",headingTag:"h2"}}),te=new y({props:{code:"cHJvbXB0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkxhYnJhZG9yJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwSG9rdXNhaSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlBhaW50aW5nJTIwb2YlMjBhJTIwc3F1aXJyZWwlMjBza2F0aW5nJTIwaW4lMjBOZXclMjBZb3JrJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySEFMLTkwMDAlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBWYW4lMjBHb2doJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGltZXMlMjBTcXVhcmUlMjB1bmRlciUyMHdhdGVyJTJDJTIwd2l0aCUyMGZpc2glMjBhbmQlMjBhJTIwZG9scGhpbiUyMHN3aW1taW5nJTIwYXJvdW5kJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQW5jaWVudCUyMFJvbWFuJTIwZnJlc2NvJTIwc2hvd2luZyUyMGElMjBtYW4lMjB3b3JraW5nJTIwb24lMjBoaXMlMjBsYXB0b3AlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDbG9zZS11cCUyMHBob3RvZ3JhcGglMjBvZiUyMHlvdW5nJTIwYmxhY2slMjB3b21hbiUyMGFnYWluc3QlMjB1cmJhbiUyMGJhY2tncm91bmQlMkMlMjBoaWdoJTIwcXVhbGl0eSUyQyUyMGJva2VoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXJtY2hhaXIlMjBpbiUyMHRoZSUyMHNoYXBlJTIwb2YlMjBhbiUyMGF2b2NhZG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDbG93biUyMGFzdHJvbmF1dCUyMGluJTIwc3BhY2UlMkMlMjB3aXRoJTIwRWFydGglMjBpbiUyMHRoZSUyMGJhY2tncm91bmQlMjIlMkMlMEElNUQlMEElMEFwcm9tcHRfaWRzJTIwJTNEJTIwcGlwZWxpbmUucHJlcGFyZV9pbnB1dHMocHJvbXB0cyklMEFwcm9tcHRfaWRzJTIwJTNEJTIwc2hhcmQocHJvbXB0X2lkcyklMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHRfaWRzJTJDJTIwcF9wYXJhbXMlMkMlMjBybmclMkMlMjBqaXQlM0RUcnVlKS5pbWFnZXMlMEFpbWFnZXMlMjAlM0QlMjBpbWFnZXMucmVzaGFwZSgoaW1hZ2VzLnNoYXBlJTVCMCU1RCUyMColMjBpbWFnZXMuc2hhcGUlNUIxJTVEJTJDKSUyMCUyQiUyMGltYWdlcy5zaGFwZSU1Qi0zJTNBJTVEKSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lLm51bXB5X3RvX3BpbChpbWFnZXMpJTBBJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMDIlMkMlMjA0KQ==",highlighted:`prompts = [
    <span class="hljs-string">&quot;Labrador in the style of Hokusai&quot;</span>,
    <span class="hljs-string">&quot;Painting of a squirrel skating in New York&quot;</span>,
    <span class="hljs-string">&quot;HAL-9000 in the style of Van Gogh&quot;</span>,
    <span class="hljs-string">&quot;Times Square under water, with fish and a dolphin swimming around&quot;</span>,
    <span class="hljs-string">&quot;Ancient Roman fresco showing a man working on his laptop&quot;</span>,
    <span class="hljs-string">&quot;Close-up photograph of young black woman against urban background, high quality, bokeh&quot;</span>,
    <span class="hljs-string">&quot;Armchair in the shape of an avocado&quot;</span>,
    <span class="hljs-string">&quot;Clown astronaut in space, with Earth in the background&quot;</span>,
]

prompt_ids = pipeline.prepare_inputs(prompts)
prompt_ids = shard(prompt_ids)

images = pipeline(prompt_ids, p_params, rng, jit=<span class="hljs-literal">True</span>).images
images = images.reshape((images.shape[<span class="hljs-number">0</span>] * images.shape[<span class="hljs-number">1</span>],) + images.shape[-<span class="hljs-number">3</span>:])
images = pipeline.numpy_to_pil(images)

make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">4</span>)`,wrap:!1}}),se=new Je({props:{title:"How does parallelization work?",local:"how-does-parallelization-work",headingTag:"h2"}}),re=new y({props:{code:"cF9nZW5lcmF0ZSUyMCUzRCUyMHBtYXAocGlwZWxpbmUuX2dlbmVyYXRlKQ==",highlighted:"p_generate = pmap(pipeline._generate)",wrap:!1}}),he=new y({props:{code:"JTI1JTI1dGltZSUwQWltYWdlcyUyMCUzRCUyMHBfZ2VuZXJhdGUocHJvbXB0X2lkcyUyQyUyMHBfcGFyYW1zJTJDJTIwcm5nKSUwQWltYWdlcyUyMCUzRCUyMGltYWdlcy5ibG9ja191bnRpbF9yZWFkeSgpJTBBJTBBJTIzJTIwQ1BVJTIwdGltZXMlM0ElMjB1c2VyJTIwMW1pbiUyMDE1cyUyQyUyMHN5cyUzQSUyMDE4LjIlMjBzJTJDJTIwdG90YWwlM0ElMjAxbWluJTIwMzRzJTBBJTIzJTIwV2FsbCUyMHRpbWUlM0ElMjAxbWluJTIwMTVz",highlighted:`%%time
images = p_generate(prompt_ids, p_params, rng)
images = images.block_until_ready()

<span class="hljs-comment"># CPU times: user 1min 15s, sys: 18.2 s, total: 1min 34s</span>
<span class="hljs-comment"># Wall time: 1min 15s</span>`,wrap:!1}}),Me=new y({props:{code:"aW1hZ2VzLnNoYXBlJTBBJTIzJTIwKDglMkMlMjAxJTJDJTIwNTEyJTJDJTIwNTEyJTJDJTIwMyk=",highlighted:`images.shape
<span class="hljs-comment"># (8, 1, 512, 512, 3)</span>`,wrap:!1}}),ye=new Je({props:{title:"Resources",local:"resources",headingTag:"h2"}}),{c(){r=i("meta"),w=a(),M=i("p"),T=a(),m(j.$$.fragment),Ue=a(),m(U.$$.fragment),ge=a(),g=i("p"),g.textContent=gt,$e=a(),$=i("p"),$.textContent=$t,ve=a(),m(v.$$.fragment),Be=a(),B=i("p"),B.textContent=vt,_e=a(),_=i("p"),_.innerHTML=Bt,Ce=a(),m(C.$$.fragment),xe=a(),x=i("p"),x.textContent=_t,Ie=a(),m(I.$$.fragment),ke=a(),m(k.$$.fragment),We=a(),W=i("p"),W.innerHTML=Ct,Xe=a(),m(X.$$.fragment),Ge=a(),m(G.$$.fragment),Ze=a(),Z=i("p"),Z.textContent=xt,He=a(),m(b.$$.fragment),Fe=a(),H=i("p"),H.innerHTML=It,Ye=a(),m(F.$$.fragment),Qe=a(),Y=i("p"),Y.innerHTML=kt,ze=a(),m(Q.$$.fragment),Ee=a(),z=i("p"),z.innerHTML=Wt,Re=a(),E=i("p"),E.textContent=Xt,Le=a(),R=i("p"),R.textContent=Gt,Ne=a(),m(L.$$.fragment),Se=a(),N=i("p"),N.innerHTML=Zt,Ve=a(),m(S.$$.fragment),Ae=a(),V=i("p"),V.innerHTML=Ht,Pe=a(),m(J.$$.fragment),qe=a(),A=i("p"),A.innerHTML=Ft,De=a(),m(P.$$.fragment),Ke=a(),q=i("p"),q.innerHTML=Yt,Oe=a(),m(D.$$.fragment),et=a(),K=i("p"),K.innerHTML=Qt,tt=a(),m(O.$$.fragment),lt=a(),ee=i("p"),ee.textContent=zt,st=a(),m(te.$$.fragment),at=a(),le=i("p"),le.innerHTML=Et,nt=a(),m(se.$$.fragment),it=a(),ae=i("p"),ae.textContent=Rt,ot=a(),ne=i("p"),ne.innerHTML=Lt,pt=a(),ie=i("p"),ie.innerHTML=Nt,rt=a(),oe=i("ol"),oe.innerHTML=St,mt=a(),pe=i("p"),pe.innerHTML=Vt,ct=a(),m(re.$$.fragment),ut=a(),me=i("p"),me.innerHTML=At,dt=a(),ce=i("ol"),ce.innerHTML=Pt,ht=a(),ue=i("p"),ue.textContent=qt,ft=a(),de=i("p"),de.innerHTML=Dt,Mt=a(),m(he.$$.fragment),yt=a(),fe=i("p"),fe.textContent=Kt,wt=a(),m(Me.$$.fragment),Tt=a(),m(ye.$$.fragment),bt=a(),we=i("p"),we.textContent=Ot,Jt=a(),Te=i("ul"),Te.innerHTML=el,jt=a(),je=i("p"),this.h()},l(e){const t=cl("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(l),w=n(e),M=o(e,"P",{}),sl(M).forEach(l),T=n(e),c(j.$$.fragment,e),Ue=n(e),c(U.$$.fragment,e),ge=n(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-12svr29"&&(g.textContent=gt),$e=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-vd07ss"&&($.textContent=$t),ve=n(e),c(v.$$.fragment,e),Be=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-15famve"&&(B.textContent=vt),_e=n(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1jp1nmd"&&(_.innerHTML=Bt),Ce=n(e),c(C.$$.fragment,e),xe=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-5ufrkr"&&(x.textContent=_t),Ie=n(e),c(I.$$.fragment,e),ke=n(e),c(k.$$.fragment,e),We=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-349jsc"&&(W.innerHTML=Ct),Xe=n(e),c(X.$$.fragment,e),Ge=n(e),c(G.$$.fragment,e),Ze=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-19grb2g"&&(Z.textContent=xt),He=n(e),c(b.$$.fragment,e),Fe=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-ih3iqi"&&(H.innerHTML=It),Ye=n(e),c(F.$$.fragment,e),Qe=n(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-b3wqu4"&&(Y.innerHTML=kt),ze=n(e),c(Q.$$.fragment,e),Ee=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-18q6dmb"&&(z.innerHTML=Wt),Re=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-j1l5pg"&&(E.textContent=Xt),Le=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1kfts0e"&&(R.textContent=Gt),Ne=n(e),c(L.$$.fragment,e),Se=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-bsl0kg"&&(N.innerHTML=Zt),Ve=n(e),c(S.$$.fragment,e),Ae=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1sp1ijt"&&(V.innerHTML=Ht),Pe=n(e),c(J.$$.fragment,e),qe=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1xv75ai"&&(A.innerHTML=Ft),De=n(e),c(P.$$.fragment,e),Ke=n(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-d259yk"&&(q.innerHTML=Yt),Oe=n(e),c(D.$$.fragment,e),et=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-e1s2k"&&(K.innerHTML=Qt),tt=n(e),c(O.$$.fragment,e),lt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-9e9hdw"&&(ee.textContent=zt),st=n(e),c(te.$$.fragment,e),at=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1nea4f2"&&(le.innerHTML=Et),nt=n(e),c(se.$$.fragment,e),it=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1217ir9"&&(ae.textContent=Rt),ot=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1toapy0"&&(ne.innerHTML=Lt),pt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1pwzekg"&&(ie.innerHTML=Nt),rt=n(e),oe=o(e,"OL",{"data-svelte-h":!0}),p(oe)!=="svelte-12i8xv7"&&(oe.innerHTML=St),mt=n(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1gtj740"&&(pe.innerHTML=Vt),ct=n(e),c(re.$$.fragment,e),ut=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1774hdu"&&(me.innerHTML=At),dt=n(e),ce=o(e,"OL",{"data-svelte-h":!0}),p(ce)!=="svelte-12ig0qf"&&(ce.innerHTML=Pt),ht=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-w1m4t9"&&(ue.textContent=qt),ft=n(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1ue3hjw"&&(de.innerHTML=Dt),Mt=n(e),c(he.$$.fragment,e),yt=n(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-735q12"&&(fe.textContent=Kt),wt=n(e),c(Me.$$.fragment,e),Tt=n(e),c(ye.$$.fragment,e),bt=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1rrs38l"&&(we.textContent=Ot),Jt=n(e),Te=o(e,"UL",{"data-svelte-h":!0}),p(Te)!=="svelte-16herqb"&&(Te.innerHTML=el),jt=n(e),je=o(e,"P",{}),sl(je).forEach(l),this.h()},h(){al(r,"name","hf:doc:metadata"),al(r,"content",yl)},m(e,t){ul(document.head,r),s(e,w,t),s(e,M,t),s(e,T,t),u(j,e,t),s(e,Ue,t),u(U,e,t),s(e,ge,t),s(e,g,t),s(e,$e,t),s(e,$,t),s(e,ve,t),u(v,e,t),s(e,Be,t),s(e,B,t),s(e,_e,t),s(e,_,t),s(e,Ce,t),u(C,e,t),s(e,xe,t),s(e,x,t),s(e,Ie,t),u(I,e,t),s(e,ke,t),u(k,e,t),s(e,We,t),s(e,W,t),s(e,Xe,t),u(X,e,t),s(e,Ge,t),u(G,e,t),s(e,Ze,t),s(e,Z,t),s(e,He,t),u(b,e,t),s(e,Fe,t),s(e,H,t),s(e,Ye,t),u(F,e,t),s(e,Qe,t),s(e,Y,t),s(e,ze,t),u(Q,e,t),s(e,Ee,t),s(e,z,t),s(e,Re,t),s(e,E,t),s(e,Le,t),s(e,R,t),s(e,Ne,t),u(L,e,t),s(e,Se,t),s(e,N,t),s(e,Ve,t),u(S,e,t),s(e,Ae,t),s(e,V,t),s(e,Pe,t),u(J,e,t),s(e,qe,t),s(e,A,t),s(e,De,t),u(P,e,t),s(e,Ke,t),s(e,q,t),s(e,Oe,t),u(D,e,t),s(e,et,t),s(e,K,t),s(e,tt,t),u(O,e,t),s(e,lt,t),s(e,ee,t),s(e,st,t),u(te,e,t),s(e,at,t),s(e,le,t),s(e,nt,t),u(se,e,t),s(e,it,t),s(e,ae,t),s(e,ot,t),s(e,ne,t),s(e,pt,t),s(e,ie,t),s(e,rt,t),s(e,oe,t),s(e,mt,t),s(e,pe,t),s(e,ct,t),u(re,e,t),s(e,ut,t),s(e,me,t),s(e,dt,t),s(e,ce,t),s(e,ht,t),s(e,ue,t),s(e,ft,t),s(e,de,t),s(e,Mt,t),u(he,e,t),s(e,yt,t),s(e,fe,t),s(e,wt,t),u(Me,e,t),s(e,Tt,t),u(ye,e,t),s(e,bt,t),s(e,we,t),s(e,Jt,t),s(e,Te,t),s(e,jt,t),s(e,je,t),Ut=!0},p(e,[t]){const tl={};t&2&&(tl.$$scope={dirty:t,ctx:e}),b.$set(tl);const ll={};t&2&&(ll.$$scope={dirty:t,ctx:e}),J.$set(ll)},i(e){Ut||(d(j.$$.fragment,e),d(U.$$.fragment,e),d(v.$$.fragment,e),d(C.$$.fragment,e),d(I.$$.fragment,e),d(k.$$.fragment,e),d(X.$$.fragment,e),d(G.$$.fragment,e),d(b.$$.fragment,e),d(F.$$.fragment,e),d(Q.$$.fragment,e),d(L.$$.fragment,e),d(S.$$.fragment,e),d(J.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),d(he.$$.fragment,e),d(Me.$$.fragment,e),d(ye.$$.fragment,e),Ut=!0)},o(e){h(j.$$.fragment,e),h(U.$$.fragment,e),h(v.$$.fragment,e),h(C.$$.fragment,e),h(I.$$.fragment,e),h(k.$$.fragment,e),h(X.$$.fragment,e),h(G.$$.fragment,e),h(b.$$.fragment,e),h(F.$$.fragment,e),h(Q.$$.fragment,e),h(L.$$.fragment,e),h(S.$$.fragment,e),h(J.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(he.$$.fragment,e),h(Me.$$.fragment,e),h(ye.$$.fragment,e),Ut=!1},d(e){e&&(l(w),l(M),l(T),l(Ue),l(ge),l(g),l($e),l($),l(ve),l(Be),l(B),l(_e),l(_),l(Ce),l(xe),l(x),l(Ie),l(ke),l(We),l(W),l(Xe),l(Ge),l(Ze),l(Z),l(He),l(Fe),l(H),l(Ye),l(Qe),l(Y),l(ze),l(Ee),l(z),l(Re),l(E),l(Le),l(R),l(Ne),l(Se),l(N),l(Ve),l(Ae),l(V),l(Pe),l(qe),l(A),l(De),l(Ke),l(q),l(Oe),l(et),l(K),l(tt),l(lt),l(ee),l(st),l(at),l(le),l(nt),l(it),l(ae),l(ot),l(ne),l(pt),l(ie),l(rt),l(oe),l(mt),l(pe),l(ct),l(ut),l(me),l(dt),l(ce),l(ht),l(ue),l(ft),l(de),l(Mt),l(yt),l(fe),l(wt),l(Tt),l(bt),l(we),l(Jt),l(Te),l(jt),l(je)),l(r),f(j,e),f(U,e),f(v,e),f(C,e),f(I,e),f(k,e),f(X,e),f(G,e),f(b,e),f(F,e),f(Q,e),f(L,e),f(S,e),f(J,e),f(P,e),f(D,e),f(O,e),f(te,e),f(se,e),f(re,e),f(he,e),f(Me,e),f(ye,e)}}}const yl='{"title":"JAX/Flax","local":"jaxflax","sections":[{"title":"Load a model","local":"load-a-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Using different prompts","local":"using-different-prompts","sections":[],"depth":2},{"title":"How does parallelization work?","local":"how-does-parallelization-work","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function wl(be){return pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $l extends rl{constructor(r){super(),ml(this,r,wl,Ml,ol,{})}}export{$l as component};
