import{s as Et,f as lt,n as Lt,o as Wt}from"../chunks/scheduler.37c15a92.js";import{S as Rt,i as St,g as o,s as a,r as m,A as Qt,h as i,f as l,c as n,j as re,u as h,x as p,k as r,y as Vt,a as s,v as M,d as y,t as w,w as f}from"../chunks/index.2bf4358c.js";import{C as st}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Nt}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{H as oe}from"../chunks/Heading.8ada512a.js";function Xt(at){let T,ue,ie,ce,j,de,J,me,b,nt=`In this section, we will take a closer look at the <code>Interface</code> class, and understand the
main parameters used to create one.`,he,U,Me,I,ot="You’ll notice that the <code>Interface</code> class has 3 required parameters:",ye,v,it="<code>Interface(fn, inputs, outputs, ...)</code>",we,g,pt="These parameters are:",fe,C,rt="<li><code>fn</code>: the prediction function that is wrapped by the Gradio interface. This function can take one or more parameters and return one or more values</li> <li><code>inputs</code>: the input component type(s). Gradio provides many pre-built components such as<code>&quot;image&quot;</code> or <code>&quot;mic&quot;</code>.</li> <li><code>outputs</code>: the output component type(s). Again, Gradio provides many pre-built components e.g. <code>&quot;image&quot;</code> or <code>&quot;label&quot;</code>.</li>",Te,k,ut='For a complete list of components, <a href="https://gradio.app/docs" rel="nofollow">see the Gradio docs </a>. Each pre-built component can be customized by instantiating the class corresponding to the component.',je,x,ct=`For example, as we saw in the <a href="/course/chapter9/2">previous section</a>,
instead of passing in <code>&quot;textbox&quot;</code> to the <code>inputs</code> parameter, you can pass in a <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> component to create a textbox with 7 lines and a label.`,Je,A,dt="Let’s take a look at another example, this time with an <code>Audio</code> component.",be,q,Ue,G,mt=`As mentioned earlier, Gradio provides many different inputs and outputs.
So let’s build an <code>Interface</code> that works with audio.`,Ie,B,ht=`In this example, we’ll build an audio-to-audio function that takes an
audio file and simply reverses it.`,ve,H,Mt=`We will use for the input the <code>Audio</code> component. When using the <code>Audio</code> component,
you can specify whether you want the <code>source</code> of the audio to be a file that the user
uploads or a microphone that the user records their voice with. In this case, let’s
set it to a <code>&quot;microphone&quot;</code>. Just for fun, we’ll add a label to our <code>Audio</code> that says
“Speak here…“.`,ge,_,yt=`In addition, we’d like to receive the audio as a numpy array so that we can easily
“reverse” it. So we’ll set the <code>&quot;type&quot;</code> to be <code>&quot;numpy&quot;</code>, which passes the input
data as a tuple of (<code>sample_rate</code>, <code>data</code>) into our function.`,Ce,$,wt=`We will also use the <code>Audio</code> output component which can automatically
render a tuple with a sample rate and numpy array of data as a playable audio file.
In this case, we do not need to do any customization, so we will use the string
shortcut <code>&quot;audio&quot;</code>.`,ke,Z,xe,E,ft=`The code above will produce an interface like the one below (if your browser doesn’t
ask you for microphone permissions, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in  a separate tab</a>.)`,Ae,u,Tt,qe,L,jt="You should now be able to record your voice and hear yourself speaking in reverse - spooky 👻!",Ge,W,Be,R,Jt=`Let’s say we had a more complicated function, with multiple inputs and outputs.
In the example below, we have a function that takes a dropdown index, a slider value, and number,
and returns an audio sample of a musical tone.`,He,S,bt=`Take a look how we pass a list of input and output components,
and see if you can follow along what’s happening.`,_e,Q,Ut="The key here is that when you pass:",$e,V,It="<li>a list of input components, each component corresponds to a parameter in order.</li> <li>a list of output coponents, each component corresponds to a returned value.</li>",Ze,N,vt="The code snippet below shows how three input components line up with the three arguments of the <code>generate_tone()</code> function:",Ee,X,Le,c,gt,We,Y,Re,z,Ct=`So far, we have used the <code>launch()</code> method to launch the interface, but we
haven’t really discussed what it does.`,Se,P,kt=`By default, the <code>launch()</code> method will launch the demo in a web server that
is running locally. If you are running your code in a Jupyter or Colab notebook, then
Gradio will embed the demo GUI in the notebook so you can easily use it.`,Qe,F,xt="You can customize the behavior of <code>launch()</code> through different parameters:",Ve,K,At="<li><code>inline</code> - whether to display the interface inline on Python notebooks.</li> <li><code>inbrowser</code> - whether to automatically launch the interface in a new tab on the default browser.</li> <li><code>share</code> - whether to create a publicly shareable link from your computer for the interface. Kind of like a Google Drive link!</li>",Ne,D,qt="We’ll cover the <code>share</code> parameter in a lot more detail in the next section!",Xe,O,Ye,ee,Gt=`Let’s build an interface that allows you to demo a <strong>speech-recognition</strong> model.
To make it interesting, we will accept <em>either</em> a mic input or an uploaded file.`,ze,te,Bt=`As usual, we’ll load our speech recognition model using the <code>pipeline()</code> function from 🤗 Transformers.
If you need a quick refresher, you can go back to <a href="/course/chapter1/3">that section in Chapter 1</a>.   Next, we’ll implement a <code>transcribe_audio()</code> function that processes the audio and returns the transcription. Finally, we’ll wrap this function in an <code>Interface</code> with the <code>Audio</code> components for the inputs and just text for the output. Altogether, the code for this application is the following:`,Pe,le,Fe,se,Ht='If your browser doesn’t ask you for microphone permissions, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in a separate tab</a>.',Ke,d,_t,De,ae,$t=`That’s it! You can now use this interface to transcribe audio. Notice here that
by passing in the <code>optional</code> parameter as <code>True</code>, we allow the user to either
provide a microphone or an audio file (or neither, but that will return an error message).`,Oe,ne,Zt="Keep going to see how to share your interface with others!",et,pe,tt;return j=new oe({props:{title:"Understanding the Interface class",local:"understanding-the-interface-class",headingTag:"h1"}}),J=new Nt({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"}]}}),U=new oe({props:{title:"How to create an Interface",local:"how-to-create-an-interface",headingTag:"h2"}}),q=new oe({props:{title:"A simple example with audio",local:"a-simple-example-with-audio",headingTag:"h2"}}),Z=new st({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),W=new oe({props:{title:"Handling multiple inputs and outputs",local:"handling-multiple-inputs-and-outputs",headingTag:"h2"}}),X=new st({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),Y=new oe({props:{title:"The launch() method",local:"the-launch-method",headingTag:"h3"}}),O=new oe({props:{title:"✏️ Let’s apply it!",local:"lets-apply-it",headingTag:"h2"}}),le=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),{c(){T=o("meta"),ue=a(),ie=o("p"),ce=a(),m(j.$$.fragment),de=a(),m(J.$$.fragment),me=a(),b=o("p"),b.innerHTML=nt,he=a(),m(U.$$.fragment),Me=a(),I=o("p"),I.innerHTML=ot,ye=a(),v=o("p"),v.innerHTML=it,we=a(),g=o("p"),g.textContent=pt,fe=a(),C=o("ul"),C.innerHTML=rt,Te=a(),k=o("p"),k.innerHTML=ut,je=a(),x=o("p"),x.innerHTML=ct,Je=a(),A=o("p"),A.innerHTML=dt,be=a(),m(q.$$.fragment),Ue=a(),G=o("p"),G.innerHTML=mt,Ie=a(),B=o("p"),B.textContent=ht,ve=a(),H=o("p"),H.innerHTML=Mt,ge=a(),_=o("p"),_.innerHTML=yt,Ce=a(),$=o("p"),$.innerHTML=wt,ke=a(),m(Z.$$.fragment),xe=a(),E=o("p"),E.innerHTML=ft,Ae=a(),u=o("iframe"),qe=a(),L=o("p"),L.textContent=jt,Ge=a(),m(W.$$.fragment),Be=a(),R=o("p"),R.textContent=Jt,He=a(),S=o("p"),S.textContent=bt,_e=a(),Q=o("p"),Q.textContent=Ut,$e=a(),V=o("ul"),V.innerHTML=It,Ze=a(),N=o("p"),N.innerHTML=vt,Ee=a(),m(X.$$.fragment),Le=a(),c=o("iframe"),We=a(),m(Y.$$.fragment),Re=a(),z=o("p"),z.innerHTML=Ct,Se=a(),P=o("p"),P.innerHTML=kt,Qe=a(),F=o("p"),F.innerHTML=xt,Ve=a(),K=o("ul"),K.innerHTML=At,Ne=a(),D=o("p"),D.innerHTML=qt,Xe=a(),m(O.$$.fragment),Ye=a(),ee=o("p"),ee.innerHTML=Gt,ze=a(),te=o("p"),te.innerHTML=Bt,Pe=a(),m(le.$$.fragment),Fe=a(),se=o("p"),se.innerHTML=Ht,Ke=a(),d=o("iframe"),De=a(),ae=o("p"),ae.innerHTML=$t,Oe=a(),ne=o("p"),ne.textContent=Zt,et=a(),pe=o("p"),this.h()},l(e){const t=Qt("svelte-u9bgzb",document.head);T=i(t,"META",{name:!0,content:!0}),t.forEach(l),ue=n(e),ie=i(e,"P",{}),re(ie).forEach(l),ce=n(e),h(j.$$.fragment,e),de=n(e),h(J.$$.fragment,e),me=n(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-lkknik"&&(b.innerHTML=nt),he=n(e),h(U.$$.fragment,e),Me=n(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1gqpygy"&&(I.innerHTML=ot),ye=n(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-5xxju6"&&(v.innerHTML=it),we=n(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1srf6cz"&&(g.textContent=pt),fe=n(e),C=i(e,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-1cwo97x"&&(C.innerHTML=rt),Te=n(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-a2tvbr"&&(k.innerHTML=ut),je=n(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-fgatqp"&&(x.innerHTML=ct),Je=n(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1lphv0c"&&(A.innerHTML=dt),be=n(e),h(q.$$.fragment,e),Ue=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-ul4i2u"&&(G.innerHTML=mt),Ie=n(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1i37re5"&&(B.textContent=ht),ve=n(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-172zvxz"&&(H.innerHTML=Mt),ge=n(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-4wa24d"&&(_.innerHTML=yt),Ce=n(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-13zmab1"&&($.innerHTML=wt),ke=n(e),h(Z.$$.fragment,e),xe=n(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-221tzw"&&(E.innerHTML=ft),Ae=n(e),u=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(u).forEach(l),qe=n(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-12uox4i"&&(L.textContent=jt),Ge=n(e),h(W.$$.fragment,e),Be=n(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-185l475"&&(R.textContent=Jt),He=n(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-wn7sdm"&&(S.textContent=bt),_e=n(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-15txj5f"&&(Q.textContent=Ut),$e=n(e),V=i(e,"UL",{"data-svelte-h":!0}),p(V)!=="svelte-1yoqjoi"&&(V.innerHTML=It),Ze=n(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-rsacrc"&&(N.innerHTML=vt),Ee=n(e),h(X.$$.fragment,e),Le=n(e),c=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(c).forEach(l),We=n(e),h(Y.$$.fragment,e),Re=n(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1drgann"&&(z.innerHTML=Ct),Se=n(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-j2w7rs"&&(P.innerHTML=kt),Qe=n(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-yl79n1"&&(F.innerHTML=xt),Ve=n(e),K=i(e,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-f1qyss"&&(K.innerHTML=At),Ne=n(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-fugi8a"&&(D.innerHTML=qt),Xe=n(e),h(O.$$.fragment,e),Ye=n(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-433a1m"&&(ee.innerHTML=Gt),ze=n(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1cy2oyt"&&(te.innerHTML=Bt),Pe=n(e),h(le.$$.fragment,e),Fe=n(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-16m1pd5"&&(se.innerHTML=Ht),Ke=n(e),d=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(d).forEach(l),De=n(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1hnmjbo"&&(ae.innerHTML=$t),Oe=n(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1egous1"&&(ne.textContent=Zt),et=n(e),pe=i(e,"P",{}),re(pe).forEach(l),this.h()},h(){r(T,"name","hf:doc:metadata"),r(T,"content",Yt),lt(u.src,Tt="https://course-demos-audio-reverse.hf.space")||r(u,"src",Tt),r(u,"frameborder","0"),r(u,"height","250"),r(u,"title","Gradio app"),r(u,"class","container p-0 flex-grow space-iframe"),r(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),lt(c.src,gt="https://course-demos-generate-tone.hf.space")||r(c,"src",gt),r(c,"frameborder","0"),r(c,"height","450"),r(c,"title","Gradio app"),r(c,"class","container p-0 flex-grow space-iframe"),r(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),lt(d.src,_t="https://course-demos-asr.hf.space")||r(d,"src",_t),r(d,"frameborder","0"),r(d,"height","550"),r(d,"title","Gradio app"),r(d,"class","container p-0 flex-grow space-iframe"),r(d,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(d,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Vt(document.head,T),s(e,ue,t),s(e,ie,t),s(e,ce,t),M(j,e,t),s(e,de,t),M(J,e,t),s(e,me,t),s(e,b,t),s(e,he,t),M(U,e,t),s(e,Me,t),s(e,I,t),s(e,ye,t),s(e,v,t),s(e,we,t),s(e,g,t),s(e,fe,t),s(e,C,t),s(e,Te,t),s(e,k,t),s(e,je,t),s(e,x,t),s(e,Je,t),s(e,A,t),s(e,be,t),M(q,e,t),s(e,Ue,t),s(e,G,t),s(e,Ie,t),s(e,B,t),s(e,ve,t),s(e,H,t),s(e,ge,t),s(e,_,t),s(e,Ce,t),s(e,$,t),s(e,ke,t),M(Z,e,t),s(e,xe,t),s(e,E,t),s(e,Ae,t),s(e,u,t),s(e,qe,t),s(e,L,t),s(e,Ge,t),M(W,e,t),s(e,Be,t),s(e,R,t),s(e,He,t),s(e,S,t),s(e,_e,t),s(e,Q,t),s(e,$e,t),s(e,V,t),s(e,Ze,t),s(e,N,t),s(e,Ee,t),M(X,e,t),s(e,Le,t),s(e,c,t),s(e,We,t),M(Y,e,t),s(e,Re,t),s(e,z,t),s(e,Se,t),s(e,P,t),s(e,Qe,t),s(e,F,t),s(e,Ve,t),s(e,K,t),s(e,Ne,t),s(e,D,t),s(e,Xe,t),M(O,e,t),s(e,Ye,t),s(e,ee,t),s(e,ze,t),s(e,te,t),s(e,Pe,t),M(le,e,t),s(e,Fe,t),s(e,se,t),s(e,Ke,t),s(e,d,t),s(e,De,t),s(e,ae,t),s(e,Oe,t),s(e,ne,t),s(e,et,t),s(e,pe,t),tt=!0},p:Lt,i(e){tt||(y(j.$$.fragment,e),y(J.$$.fragment,e),y(U.$$.fragment,e),y(q.$$.fragment,e),y(Z.$$.fragment,e),y(W.$$.fragment,e),y(X.$$.fragment,e),y(Y.$$.fragment,e),y(O.$$.fragment,e),y(le.$$.fragment,e),tt=!0)},o(e){w(j.$$.fragment,e),w(J.$$.fragment,e),w(U.$$.fragment,e),w(q.$$.fragment,e),w(Z.$$.fragment,e),w(W.$$.fragment,e),w(X.$$.fragment,e),w(Y.$$.fragment,e),w(O.$$.fragment,e),w(le.$$.fragment,e),tt=!1},d(e){e&&(l(ue),l(ie),l(ce),l(de),l(me),l(b),l(he),l(Me),l(I),l(ye),l(v),l(we),l(g),l(fe),l(C),l(Te),l(k),l(je),l(x),l(Je),l(A),l(be),l(Ue),l(G),l(Ie),l(B),l(ve),l(H),l(ge),l(_),l(Ce),l($),l(ke),l(xe),l(E),l(Ae),l(u),l(qe),l(L),l(Ge),l(Be),l(R),l(He),l(S),l(_e),l(Q),l($e),l(V),l(Ze),l(N),l(Ee),l(Le),l(c),l(We),l(Re),l(z),l(Se),l(P),l(Qe),l(F),l(Ve),l(K),l(Ne),l(D),l(Xe),l(Ye),l(ee),l(ze),l(te),l(Pe),l(Fe),l(se),l(Ke),l(d),l(De),l(ae),l(Oe),l(ne),l(et),l(pe)),l(T),f(j,e),f(J,e),f(U,e),f(q,e),f(Z,e),f(W,e),f(X,e),f(Y,e),f(O,e),f(le,e)}}}const Yt='{"title":"Understanding the Interface class","local":"understanding-the-interface-class","sections":[{"title":"How to create an Interface","local":"how-to-create-an-interface","sections":[],"depth":2},{"title":"A simple example with audio","local":"a-simple-example-with-audio","sections":[],"depth":2},{"title":"Handling multiple inputs and outputs","local":"handling-multiple-inputs-and-outputs","sections":[{"title":"The launch() method","local":"the-launch-method","sections":[],"depth":3}],"depth":2},{"title":"✏️ Let’s apply it!","local":"lets-apply-it","sections":[],"depth":2}],"depth":1}';function zt(at){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends Rt{constructor(T){super(),St(this,T,zt,Xt,Et,{})}}export{el as component};
