import{s as ee,f as ae,n as le,o as ne}from"../chunks/scheduler.9bc65507.js";import{S as pe,i as ie,g as p,s as l,r as c,A as oe,h as i,f as e,c as n,j as wt,u as r,x as o,k as j,y as ce,a,v as m,d as h,t as g,w as M}from"../chunks/index.707bf1b6.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";import{D as re}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as bs}from"../chunks/Heading.342b1fa6.js";function me(xt){let d,Js,us,Us,C,ws,v,xs,W,ft=`Traditionally, models used for <a href="object_detection">object detection</a> require labeled image datasets for training,
and are limited to detecting the set of classes from the training data.`,fs,I,Tt=`Zero-shot object detection is supported by the <a href="../model_doc/owlvit">OWL-ViT</a> model which uses a different approach. OWL-ViT
is an open-vocabulary object detector. It means that it can detect objects in images based on free-text queries without
the need to fine-tune the model on labeled datasets.`,Ts,k,Ct=`OWL-ViT leverages multi-modal representations to perform open-vocabulary detection. It combines <a href="../model_doc/clip">CLIP</a> with
lightweight object classification and localization heads. Open-vocabulary detection is achieved by embedding free-text queries with the text encoder of CLIP and using them as input to the object classification and localization heads.
associate images and their corresponding textual descriptions, and ViT processes image patches as inputs. The authors
of OWL-ViT first trained CLIP from scratch and then fine-tuned OWL-ViT end to end on standard object detection datasets using
a bipartite matching loss.`,Cs,z,vt="With this approach, the model can detect objects based on textual descriptions without prior training on labeled datasets.",vs,$,Wt="In this guide, you will learn how to use OWL-ViT:",Ws,Z,It="<li>to detect objects based on text prompts</li> <li>for batch object detection</li> <li>for image-guided object detection</li>",Is,R,kt="Before you begin, make sure you have all the necessary libraries installed:",ks,Q,zs,_,$s,V,zt=`The simplest way to try out inference with OWL-ViT is to use it in a <a href="/docs/transformers/v4.34.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>. Instantiate a pipeline
for zero-shot object detection from a <a href="https://huggingface.co/models?other=owlvit" rel="nofollow">checkpoint on the Hugging Face Hub</a>:`,Zs,B,Rs,H,$t=`Next, choose an image you’d like to detect objects in. Here we’ll use the image of astronaut Eileen Collins that is
a part of the <a href="https://www.nasa.gov/multimedia/imagegallery/index.html" rel="nofollow">NASA</a> Great Images dataset.`,Qs,N,_s,b,Zt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_1.png" alt="Astronaut Eileen Collins"/>',Vs,q,Rt=`Pass the image and the candidate object labels to look for to the pipeline.
Here we pass the image directly; other suitable options include a local path to an image or an image url. We also pass text descriptions for all items we want to query the image for.`,Bs,X,Hs,G,Qt="Let’s visualize the predictions:",Ns,Y,qs,J,_t='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_2.png" alt="Visualized predictions on NASA image"/>',Xs,E,Gs,S,Vt=`Now that you’ve seen how to use the zero-shot object detection pipeline, let’s replicate the same
result manually.`,Ys,F,Bt=`Start by loading the model and associated processor from a <a href="https://huggingface.co/models?other=owlvit" rel="nofollow">checkpoint on the Hugging Face Hub</a>.
Here we’ll use the same checkpoint as before:`,Es,L,Ss,A,Ht="Let’s take a different image to switch things up.",Fs,D,Ls,U,Nt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_3.png" alt="Beach photo"/>',As,P,qt=`Use the processor to prepare the inputs for the model. The processor combines an image processor that prepares the
image for the model by resizing and normalizing it, and a <a href="/docs/transformers/v4.34.1/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> that takes care of the text inputs.`,Ds,K,Ps,O,Xt=`Pass the inputs through the model, post-process, and visualize the results. Since the image processor resized images before
feeding them to the model, you need to use the <a href="/docs/transformers/v4.34.1/en/model_doc/owlvit#transformers.OwlViTImageProcessor.post_process_object_detection">post_process_object_detection()</a> method to make sure the predicted bounding
boxes have the correct coordinates relative to the original image:`,Ks,ss,Os,w,Gt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',st,ts,tt,es,Yt=`You can pass multiple sets of images and text queries to search for different (or same) objects in several images.
Let’s use both an astronaut image and the beach image together.
For batch processing, you should pass text queries as a nested list to the processor and images as lists of PIL images,
PyTorch tensors, or NumPy arrays.`,et,as,at,ls,Et=`Previously for post-processing you passed the single image’s size as a tensor, but you can also pass a tuple, or, in case
of several images, a list of tuples. Let’s create predictions for the two examples, and visualize the second one (<code>image_idx = 1</code>).`,lt,ns,nt,x,St='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',pt,ps,it,is,Ft=`In addition to zero-shot object detection with text queries, OWL-ViT offers image-guided object detection. This means
you can use an image query to find similar objects in the target image.
Unlike text queries, only a single example image is allowed.`,ot,os,Lt=`Let’s take an image with two cats on a couch as a target image, and an image of a single cat
as a query:`,ct,cs,rt,rs,At="Let’s take a quick look at the images:",mt,ms,ht,f,Dt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_5.png" alt="Cats"/>',gt,hs,Pt="In the preprocessing step, instead of text queries, you now need to use <code>query_images</code>:",Mt,gs,yt,Ms,Kt=`For predictions, instead of passing the inputs to the model, pass them to <a href="/docs/transformers/v4.34.1/en/model_doc/owlvit#transformers.OwlViTForObjectDetection.image_guided_detection">image_guided_detection()</a>. Draw the predictions
as before except now there are no labels.`,jt,ys,ut,T,Ot='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_6.png" alt="Cats with bounding boxes"/>',dt,js,se="If you’d like to interactively try out inference with OWL-ViT, check out this demo:",bt,u,te,Jt,ds,Ut;return C=new bs({props:{title:"Zero-shot object detection",local:"zero-shot-object-detection",headingTag:"h1"}}),v=new re({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/zero_shot_object_detection.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/zero_shot_object_detection.ipynb"}]}}),Q=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),_=new bs({props:{title:"Zero-shot object detection pipeline",local:"zero-shot-object-detection-pipeline",headingTag:"h2"}}),B=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmdvb2dsZSUyRm93bHZpdC1iYXNlLXBhdGNoMzIlMjIlMEFkZXRlY3RvciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEY2hlY2twb2ludCUyQyUyMHRhc2slM0QlMjJ6ZXJvLXNob3Qtb2JqZWN0LWRldGVjdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google/owlvit-base-patch32&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;zero-shot-object-detection&quot;</span>)`,wrap:!1}}),N=new y({props:{code:"aW1wb3J0JTIwc2tpbWFnZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWltYWdlJTIwJTNEJTIwc2tpbWFnZS5kYXRhLmFzdHJvbmF1dCgpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkobnAudWludDgoaW1hZ2UpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> skimage
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = skimage.data.astronaut()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(np.uint8(image)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),X=new y({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXRlY3RvciglMEElMjAlMjAlMjAlMjBpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJodW1hbiUyMGZhY2UlMjIlMkMlMjAlMjJyb2NrZXQlMjIlMkMlMjAlMjJuYXNhJTIwYmFkZ2UlMjIlMkMlMjAlMjJzdGFyLXNwYW5nbGVkJTIwYmFubmVyJTIyJTVEJTJDJTBBKSUwQXByZWRpY3Rpb25z",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = detector(
<span class="hljs-meta">... </span>    image,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>predictions
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3571370542049408</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;human face&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">180</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">71</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">271</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">178</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.28099656105041504</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">129</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">348</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">206</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">427</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2110239565372467</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">350</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: -<span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">468</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">288</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13790413737297058</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;star-spangled banner&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">105</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">509</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.11950037628412247</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">277</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">338</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">327</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">380</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10649408400058746</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">358</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">64</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">424</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">280</span>}}]`,wrap:!1}}),Y=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlRHJhdyUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZSklMEElMEFmb3IlMjBwcmVkaWN0aW9uJTIwaW4lMjBwcmVkaWN0aW9ucyUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJib3glMjIlNUQlMEElMjAlMjAlMjAlMjBsYWJlbCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJsYWJlbCUyMiU1RCUwQSUyMCUyMCUyMCUyMHNjb3JlJTIwJTNEJTIwcHJlZGljdGlvbiU1QiUyMnNjb3JlJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIweG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCUyMCUzRCUyMGJveC52YWx1ZXMoKSUwQSUyMCUyMCUyMCUyMGRyYXcucmVjdGFuZ2xlKCh4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4KSUyQyUyMG91dGxpbmUlM0QlMjJyZWQlMjIlMkMlMjB3aWR0aCUzRDEpJTBBJTIwJTIwJTIwJTIwZHJhdy50ZXh0KCh4bWluJTJDJTIweW1pbiklMkMlMjBmJTIyJTdCbGFiZWwlN0QlM0ElMjAlN0Jyb3VuZChzY29yZSUyQzIpJTdEJTIyJTJDJTIwZmlsbCUzRCUyMndoaXRlJTIyKSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> ImageDraw

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> prediction <span class="hljs-keyword">in</span> predictions:
<span class="hljs-meta">... </span>    box = prediction[<span class="hljs-string">&quot;box&quot;</span>]
<span class="hljs-meta">... </span>    label = prediction[<span class="hljs-string">&quot;label&quot;</span>]
<span class="hljs-meta">... </span>    score = prediction[<span class="hljs-string">&quot;score&quot;</span>]

<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box.values()
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{label}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),E=new bs({props:{title:"Text-prompted zero-shot object detection by hand",local:"text-prompted-zero-shot-object-detection-by-hand",headingTag:"h2"}}),L=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),D=new y({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRm9qMHplWTJMdGs0JTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4elpXRnlZMmg4TVRSOGZIQnBZMjVwWTN4bGJud3dmSHg4ZkRFMk56YzBPVEUxTkRrJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlt",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/oj0zeY2Ltk4/download?ixid=MnwxMjA3fDB8MXxzZWFyY2h8MTR8fHBpY25pY3xlbnwwfHx8fDE2Nzc0OTE1NDk&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>im = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>im`,wrap:!1}}),K=new y({props:{code:"dGV4dF9xdWVyaWVzJTIwJTNEJTIwJTVCJTIyaGF0JTIyJTJDJTIwJTIyYm9vayUyMiUyQyUyMCUyMnN1bmdsYXNzZXMlMjIlMkMlMjAlMjJjYW1lcmElMjIlNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRfcXVlcmllcyUyQyUyMGltYWdlcyUzRGltJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=im, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),ss=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbS5zaXplJTVCJTNBJTNBLTElNUQlNUQpJTBBJTIwJTIwJTIwJTIwcmVzdWx0cyUyMCUzRCUyMHByb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfb2JqZWN0X2RldGVjdGlvbihvdXRwdXRzJTJDJTIwdGhyZXNob2xkJTNEMC4xJTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzKSU1QjAlNUQlMEElMEFkcmF3JTIwJTNEJTIwSW1hZ2VEcmF3LkRyYXcoaW0pJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWxhYmVscyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQudG9saXN0KCklMEFib3hlcyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJib3hlcyUyMiU1RC50b2xpc3QoKSUwQSUwQWZvciUyMGJveCUyQyUyMHNjb3JlJTJDJTIwbGFiZWwlMjBpbiUyMHppcChib3hlcyUyQyUyMHNjb3JlcyUyQyUyMGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjB4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4JTIwJTNEJTIwYm94JTBBJTIwJTIwJTIwJTIwZHJhdy5yZWN0YW5nbGUoKHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXgpJTJDJTIwb3V0bGluZSUzRCUyMnJlZCUyMiUyQyUyMHdpZHRoJTNEMSklMEElMjAlMjAlMjAlMjBkcmF3LnRleHQoKHhtaW4lMkMlMjB5bWluKSUyQyUyMGYlMjIlN0J0ZXh0X3F1ZXJpZXMlNUJsYWJlbCU1RCU3RCUzQSUyMCU3QnJvdW5kKHNjb3JlJTJDMiklN0QlMjIlMkMlMjBmaWxsJTNEJTIyd2hpdGUlMjIpJTBBJTBBaW0=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([im.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(im)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>im`,wrap:!1}}),ts=new bs({props:{title:"Batch processing",local:"batch-processing",headingTag:"h2"}}),as=new y({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCaW1hZ2UlMkMlMjBpbSU1RCUwQXRleHRfcXVlcmllcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU1QiUyMmh1bWFuJTIwZmFjZSUyMiUyQyUyMCUyMnJvY2tldCUyMiUyQyUyMCUyMm5hc2ElMjBiYWRnZSUyMiUyQyUyMCUyMnN0YXItc3BhbmdsZWQlMjBiYW5uZXIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJoYXQlMjIlMkMlMjAlMjJib29rJTIyJTJDJTIwJTIyc3VuZ2xhc3NlcyUyMiUyQyUyMCUyMmNhbWVyYSUyMiU1RCUyQyUwQSU1RCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dF9xdWVyaWVzJTJDJTIwaW1hZ2VzJTNEaW1hZ2VzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>images = [image, im]
<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>],
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),ns=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlMjAlM0QlMjAlNUJ4LnNpemUlNUIlM0ElM0EtMSU1RCUyMGZvciUyMHglMjBpbiUyMGltYWdlcyU1RCUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuMSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklMEElMEFpbWFnZV9pZHglMjAlM0QlMjAxJTBBZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlcyU1QmltYWdlX2lkeCU1RCklMEElMEFzY29yZXMlMjAlM0QlMjByZXN1bHRzJTVCaW1hZ2VfaWR4JTVEJTVCJTIyc2NvcmVzJTIyJTVELnRvbGlzdCgpJTBBbGFiZWxzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmxhYmVscyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIycmVkJTIyJTJDJTIwd2lkdGglM0QxKSUwQSUyMCUyMCUyMCUyMGRyYXcudGV4dCgoeG1pbiUyQyUyMHltaW4pJTJDJTIwZiUyMiU3QnRleHRfcXVlcmllcyU1QmltYWdlX2lkeCU1RCU1QmxhYmVsJTVEJTdEJTNBJTIwJTdCcm91bmQoc2NvcmUlMkMyKSU3RCUyMiUyQyUyMGZpbGwlM0QlMjJ3aGl0ZSUyMiklMEElMEFpbWFnZXMlNUJpbWFnZV9pZHglNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = [x.size[::-<span class="hljs-number">1</span>] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> images]
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_idx = <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(images[image_idx])

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[image_idx][<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[image_idx][<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[image_idx][<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[image_idx][label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images[image_idx]`,wrap:!1}}),ps=new bs({props:{title:"Image-guided object detection",local:"image-guided-object-detection",headingTag:"h2"}}),cs=new y({props:{code:"dXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlX3RhcmdldCUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFxdWVyeV91cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDA1MjQyODAuanBnJTIyJTBBcXVlcnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChxdWVyeV91cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_target = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>query_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000524280.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query_image = Image.<span class="hljs-built_in">open</span>(requests.get(query_url, stream=<span class="hljs-literal">True</span>).raw)`,wrap:!1}}),ms=new y({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4JTIwJTNEJTIwcGx0LnN1YnBsb3RzKDElMkMlMjAyKSUwQWF4JTVCMCU1RC5pbXNob3coaW1hZ2VfdGFyZ2V0KSUwQWF4JTVCMSU1RC5pbXNob3cocXVlcnlfaW1hZ2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, ax = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">0</span>].imshow(image_target)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">1</span>].imshow(query_image)`,wrap:!1}}),gs=new y({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlX3RhcmdldCUyQyUyMHF1ZXJ5X2ltYWdlcyUzRHF1ZXJ5X2ltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image_target, query_images=query_image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ys=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5pbWFnZV9ndWlkZWRfZGV0ZWN0aW9uKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbWFnZV90YXJnZXQuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2ltYWdlX2d1aWRlZF9kZXRlY3Rpb24ob3V0cHV0cyUzRG91dHB1dHMlMkMlMjB0YXJnZXRfc2l6ZXMlM0R0YXJnZXRfc2l6ZXMpJTVCMCU1RCUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZV90YXJnZXQpJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIyd2hpdGUlMjIlMkMlMjB3aWR0aCUzRDQpJTBBJTBBaW1hZ2VfdGFyZ2V0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model.image_guided_detection(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([image_target.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_image_guided_detection(outputs=outputs, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image_target)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;white&quot;</span>, width=<span class="hljs-number">4</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_target`,wrap:!1}}),{c(){d=p("meta"),Js=l(),us=p("p"),Us=l(),c(C.$$.fragment),ws=l(),c(v.$$.fragment),xs=l(),W=p("p"),W.innerHTML=ft,fs=l(),I=p("p"),I.innerHTML=Tt,Ts=l(),k=p("p"),k.innerHTML=Ct,Cs=l(),z=p("p"),z.textContent=vt,vs=l(),$=p("p"),$.textContent=Wt,Ws=l(),Z=p("ul"),Z.innerHTML=It,Is=l(),R=p("p"),R.textContent=kt,ks=l(),c(Q.$$.fragment),zs=l(),c(_.$$.fragment),$s=l(),V=p("p"),V.innerHTML=zt,Zs=l(),c(B.$$.fragment),Rs=l(),H=p("p"),H.innerHTML=$t,Qs=l(),c(N.$$.fragment),_s=l(),b=p("div"),b.innerHTML=Zt,Vs=l(),q=p("p"),q.textContent=Rt,Bs=l(),c(X.$$.fragment),Hs=l(),G=p("p"),G.textContent=Qt,Ns=l(),c(Y.$$.fragment),qs=l(),J=p("div"),J.innerHTML=_t,Xs=l(),c(E.$$.fragment),Gs=l(),S=p("p"),S.textContent=Vt,Ys=l(),F=p("p"),F.innerHTML=Bt,Es=l(),c(L.$$.fragment),Ss=l(),A=p("p"),A.textContent=Ht,Fs=l(),c(D.$$.fragment),Ls=l(),U=p("div"),U.innerHTML=Nt,As=l(),P=p("p"),P.innerHTML=qt,Ds=l(),c(K.$$.fragment),Ps=l(),O=p("p"),O.innerHTML=Xt,Ks=l(),c(ss.$$.fragment),Os=l(),w=p("div"),w.innerHTML=Gt,st=l(),c(ts.$$.fragment),tt=l(),es=p("p"),es.textContent=Yt,et=l(),c(as.$$.fragment),at=l(),ls=p("p"),ls.innerHTML=Et,lt=l(),c(ns.$$.fragment),nt=l(),x=p("div"),x.innerHTML=St,pt=l(),c(ps.$$.fragment),it=l(),is=p("p"),is.textContent=Ft,ot=l(),os=p("p"),os.textContent=Lt,ct=l(),c(cs.$$.fragment),rt=l(),rs=p("p"),rs.textContent=At,mt=l(),c(ms.$$.fragment),ht=l(),f=p("div"),f.innerHTML=Dt,gt=l(),hs=p("p"),hs.innerHTML=Pt,Mt=l(),c(gs.$$.fragment),yt=l(),Ms=p("p"),Ms.innerHTML=Kt,jt=l(),c(ys.$$.fragment),ut=l(),T=p("div"),T.innerHTML=Ot,dt=l(),js=p("p"),js.textContent=se,bt=l(),u=p("iframe"),Jt=l(),ds=p("p"),this.h()},l(s){const t=oe("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(e),Js=n(s),us=i(s,"P",{}),wt(us).forEach(e),Us=n(s),r(C.$$.fragment,s),ws=n(s),r(v.$$.fragment,s),xs=n(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1g13my9"&&(W.innerHTML=ft),fs=n(s),I=i(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1l6ldib"&&(I.innerHTML=Tt),Ts=n(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1r22rri"&&(k.innerHTML=Ct),Cs=n(s),z=i(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-c41x80"&&(z.textContent=vt),vs=n(s),$=i(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-leihjc"&&($.textContent=Wt),Ws=n(s),Z=i(s,"UL",{"data-svelte-h":!0}),o(Z)!=="svelte-v8ep8v"&&(Z.innerHTML=It),Is=n(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1c9nexd"&&(R.textContent=kt),ks=n(s),r(Q.$$.fragment,s),zs=n(s),r(_.$$.fragment,s),$s=n(s),V=i(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-dcpsn6"&&(V.innerHTML=zt),Zs=n(s),r(B.$$.fragment,s),Rs=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-henpll"&&(H.innerHTML=$t),Qs=n(s),r(N.$$.fragment,s),_s=n(s),b=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-17qmfee"&&(b.innerHTML=Zt),Vs=n(s),q=i(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-baa5my"&&(q.textContent=Rt),Bs=n(s),r(X.$$.fragment,s),Hs=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-af5rkc"&&(G.textContent=Qt),Ns=n(s),r(Y.$$.fragment,s),qs=n(s),J=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-1fwpqdn"&&(J.innerHTML=_t),Xs=n(s),r(E.$$.fragment,s),Gs=n(s),S=i(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-xqdy1u"&&(S.textContent=Vt),Ys=n(s),F=i(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-x1kygm"&&(F.innerHTML=Bt),Es=n(s),r(L.$$.fragment,s),Ss=n(s),A=i(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1g7c1zc"&&(A.textContent=Ht),Fs=n(s),r(D.$$.fragment,s),Ls=n(s),U=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-owux8y"&&(U.innerHTML=Nt),As=n(s),P=i(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-llfncq"&&(P.innerHTML=qt),Ds=n(s),r(K.$$.fragment,s),Ps=n(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1qyitqb"&&(O.innerHTML=Xt),Ks=n(s),r(ss.$$.fragment,s),Os=n(s),w=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1m863ar"&&(w.innerHTML=Gt),st=n(s),r(ts.$$.fragment,s),tt=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-16j89af"&&(es.textContent=Yt),et=n(s),r(as.$$.fragment,s),at=n(s),ls=i(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-1si811t"&&(ls.innerHTML=Et),lt=n(s),r(ns.$$.fragment,s),nt=n(s),x=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(x)!=="svelte-1m863ar"&&(x.innerHTML=St),pt=n(s),r(ps.$$.fragment,s),it=n(s),is=i(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-c78gkh"&&(is.textContent=Ft),ot=n(s),os=i(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-1kqxako"&&(os.textContent=Lt),ct=n(s),r(cs.$$.fragment,s),rt=n(s),rs=i(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-1yw5ubp"&&(rs.textContent=At),mt=n(s),r(ms.$$.fragment,s),ht=n(s),f=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-y78yu"&&(f.innerHTML=Dt),gt=n(s),hs=i(s,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-34zysh"&&(hs.innerHTML=Pt),Mt=n(s),r(gs.$$.fragment,s),yt=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-zgsjkh"&&(Ms.innerHTML=Kt),jt=n(s),r(ys.$$.fragment,s),ut=n(s),T=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-1f4dev0"&&(T.innerHTML=Ot),dt=n(s),js=i(s,"P",{"data-svelte-h":!0}),o(js)!=="svelte-14mrmrz"&&(js.textContent=se),bt=n(s),u=i(s,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),wt(u).forEach(e),Jt=n(s),ds=i(s,"P",{}),wt(ds).forEach(e),this.h()},h(){j(d,"name","hf:doc:metadata"),j(d,"content",he),j(b,"class","flex justify-center"),j(J,"class","flex justify-center"),j(U,"class","flex justify-center"),j(w,"class","flex justify-center"),j(x,"class","flex justify-center"),j(f,"class","flex justify-center"),j(T,"class","flex justify-center"),ae(u.src,te="https://adirik-owl-vit.hf.space")||j(u,"src",te),j(u,"frameborder","0"),j(u,"width","850"),j(u,"height","450")},m(s,t){ce(document.head,d),a(s,Js,t),a(s,us,t),a(s,Us,t),m(C,s,t),a(s,ws,t),m(v,s,t),a(s,xs,t),a(s,W,t),a(s,fs,t),a(s,I,t),a(s,Ts,t),a(s,k,t),a(s,Cs,t),a(s,z,t),a(s,vs,t),a(s,$,t),a(s,Ws,t),a(s,Z,t),a(s,Is,t),a(s,R,t),a(s,ks,t),m(Q,s,t),a(s,zs,t),m(_,s,t),a(s,$s,t),a(s,V,t),a(s,Zs,t),m(B,s,t),a(s,Rs,t),a(s,H,t),a(s,Qs,t),m(N,s,t),a(s,_s,t),a(s,b,t),a(s,Vs,t),a(s,q,t),a(s,Bs,t),m(X,s,t),a(s,Hs,t),a(s,G,t),a(s,Ns,t),m(Y,s,t),a(s,qs,t),a(s,J,t),a(s,Xs,t),m(E,s,t),a(s,Gs,t),a(s,S,t),a(s,Ys,t),a(s,F,t),a(s,Es,t),m(L,s,t),a(s,Ss,t),a(s,A,t),a(s,Fs,t),m(D,s,t),a(s,Ls,t),a(s,U,t),a(s,As,t),a(s,P,t),a(s,Ds,t),m(K,s,t),a(s,Ps,t),a(s,O,t),a(s,Ks,t),m(ss,s,t),a(s,Os,t),a(s,w,t),a(s,st,t),m(ts,s,t),a(s,tt,t),a(s,es,t),a(s,et,t),m(as,s,t),a(s,at,t),a(s,ls,t),a(s,lt,t),m(ns,s,t),a(s,nt,t),a(s,x,t),a(s,pt,t),m(ps,s,t),a(s,it,t),a(s,is,t),a(s,ot,t),a(s,os,t),a(s,ct,t),m(cs,s,t),a(s,rt,t),a(s,rs,t),a(s,mt,t),m(ms,s,t),a(s,ht,t),a(s,f,t),a(s,gt,t),a(s,hs,t),a(s,Mt,t),m(gs,s,t),a(s,yt,t),a(s,Ms,t),a(s,jt,t),m(ys,s,t),a(s,ut,t),a(s,T,t),a(s,dt,t),a(s,js,t),a(s,bt,t),a(s,u,t),a(s,Jt,t),a(s,ds,t),Ut=!0},p:le,i(s){Ut||(h(C.$$.fragment,s),h(v.$$.fragment,s),h(Q.$$.fragment,s),h(_.$$.fragment,s),h(B.$$.fragment,s),h(N.$$.fragment,s),h(X.$$.fragment,s),h(Y.$$.fragment,s),h(E.$$.fragment,s),h(L.$$.fragment,s),h(D.$$.fragment,s),h(K.$$.fragment,s),h(ss.$$.fragment,s),h(ts.$$.fragment,s),h(as.$$.fragment,s),h(ns.$$.fragment,s),h(ps.$$.fragment,s),h(cs.$$.fragment,s),h(ms.$$.fragment,s),h(gs.$$.fragment,s),h(ys.$$.fragment,s),Ut=!0)},o(s){g(C.$$.fragment,s),g(v.$$.fragment,s),g(Q.$$.fragment,s),g(_.$$.fragment,s),g(B.$$.fragment,s),g(N.$$.fragment,s),g(X.$$.fragment,s),g(Y.$$.fragment,s),g(E.$$.fragment,s),g(L.$$.fragment,s),g(D.$$.fragment,s),g(K.$$.fragment,s),g(ss.$$.fragment,s),g(ts.$$.fragment,s),g(as.$$.fragment,s),g(ns.$$.fragment,s),g(ps.$$.fragment,s),g(cs.$$.fragment,s),g(ms.$$.fragment,s),g(gs.$$.fragment,s),g(ys.$$.fragment,s),Ut=!1},d(s){s&&(e(Js),e(us),e(Us),e(ws),e(xs),e(W),e(fs),e(I),e(Ts),e(k),e(Cs),e(z),e(vs),e($),e(Ws),e(Z),e(Is),e(R),e(ks),e(zs),e($s),e(V),e(Zs),e(Rs),e(H),e(Qs),e(_s),e(b),e(Vs),e(q),e(Bs),e(Hs),e(G),e(Ns),e(qs),e(J),e(Xs),e(Gs),e(S),e(Ys),e(F),e(Es),e(Ss),e(A),e(Fs),e(Ls),e(U),e(As),e(P),e(Ds),e(Ps),e(O),e(Ks),e(Os),e(w),e(st),e(tt),e(es),e(et),e(at),e(ls),e(lt),e(nt),e(x),e(pt),e(it),e(is),e(ot),e(os),e(ct),e(rt),e(rs),e(mt),e(ht),e(f),e(gt),e(hs),e(Mt),e(yt),e(Ms),e(jt),e(ut),e(T),e(dt),e(js),e(bt),e(u),e(Jt),e(ds)),e(d),M(C,s),M(v,s),M(Q,s),M(_,s),M(B,s),M(N,s),M(X,s),M(Y,s),M(E,s),M(L,s),M(D,s),M(K,s),M(ss,s),M(ts,s),M(as,s),M(ns,s),M(ps,s),M(cs,s),M(ms,s),M(gs,s),M(ys,s)}}}const he='{"title":"Zero-shot object detection","local":"zero-shot-object-detection","sections":[{"title":"Zero-shot object detection pipeline","local":"zero-shot-object-detection-pipeline","sections":[],"depth":2},{"title":"Text-prompted zero-shot object detection by hand","local":"text-prompted-zero-shot-object-detection-by-hand","sections":[],"depth":2},{"title":"Batch processing","local":"batch-processing","sections":[],"depth":2},{"title":"Image-guided object detection","local":"image-guided-object-detection","sections":[],"depth":2}],"depth":1}';function ge(xt){return ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class be extends pe{constructor(d){super(),ie(this,d,ge,me,ee,{})}}export{be as component};
