import{s as Oo,n as No,o as Uo}from"../chunks/scheduler.b108d059.js";import{S as Go,i as Wo,g as i,s as l,r as c,A as Jo,h as a,f as d,c as r,j as s,u as m,x as n,k as u,y as Qo,a as o,v as p,d as f,t as h,w as _}from"../chunks/index.008de539.js";import{H as b,E as Vo}from"../chunks/EditOnGithub.d1c48e3d.js";function Xo(Jd){let g,Ue,Oe,Ge,v,We,T,Je,y,Qd="Helper module for audio processing.",Qe,w,Vd=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,Ve,$,Xd='<li><a href="#module_utils/audio">utils/audio</a><ul><li><em>static</em><ul><li><a href="#module_utils/audio.read_audio"><code>.read_audio(url, sampling_rate)</code></a> ⇒ <code>Promise.&lt;Float32Array&gt;</code><ul><li><a href="#module_utils/audio.read_audio..audio"><code>~audio</code></a> : <code>Float32Array</code></li></ul></li> <li><a href="#module_utils/audio.hanning"><code>.hanning(M)</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/audio.mel_filter_bank"><code>.mel_filter_bank(num_frequency_bins, num_mel_filters, min_frequency, max_frequency, sampling_rate, [norm], [mel_scale], [triangularize_in_mel_space])</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/audio.spectrogram"><code>.spectrogram(waveform, window, frame_length, hop_length, options)</code></a> ⇒ <code>Object</code></li> <li><a href="#module_utils/audio.window_function"><code>.window_function(window_length, name, options)</code></a> ⇒ <code>Float64Array</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/audio..hertz_to_mel"><code>~hertz_to_mel(freq, [mel_scale])</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio..mel_to_hertz"><code>~mel_to_hertz(mels, [mel_scale])</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio.._create_triangular_filter_bank"><code>~_create_triangular_filter_bank(fft_freqs, filter_freqs)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/audio..linspace"><code>~linspace(start, end, num)</code></a> ⇒</li> <li><a href="#module_utils/audio..padReflect"><code>~padReflect(array, left, right)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio.._db_conversion_helper"><code>~_db_conversion_helper(spectrogram, factor, reference, min_value, db_range)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio..amplitude_to_db"><code>~amplitude_to_db(spectrogram, [reference], [min_value], [db_range])</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio..power_to_db"><code>~power_to_db(spectrogram, [reference], [min_value], [db_range])</code></a> ⇒ <code>T</code></li></ul></li></ul></li>',Xe,Ye,Ze,x,et,H,tt,q,Yd="Helper function to read audio from a path/URL.",dt,L,Zd='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Float32Array&gt;</code> - The decoded audio as a <code>Float32Array</code>.',ot,M,eo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>url</td><td><code>string</code> | <code>URL</code></td><td><p>The path/URL to load the audio from.</p></td> </tr><tr><td>sampling_rate</td><td><code>number</code></td><td><p>The sampling rate to use when decoding the audio.</p></td></tr></tbody>",lt,rt,it,C,at,A,nt,P,to='<strong>Kind</strong>: inner property of <a href="#module_utils/audio.read_audio"><code>read_audio</code></a>',ut,st,ct,z,mt,k,pt,F,oo="Generates a Hanning window of length M.",ft,E,lo='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The generated Hanning window.',ht,R,ro="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>M</td><td><code>number</code></td><td><p>The length of the Hanning window to generate.</p></td></tr></tbody>",_t,bt,gt,B,vt,D,Tt,j,io=`Creates a frequency bin conversion matrix used to obtain a mel spectrogram. This is called a <em>mel filter bank</em>, and
various implementation exist, which differ in the number of filters, the shape of the filters, the way the filters
are spaced, the bandwidth of the filters, and the manner in which the spectrum is warped. The goal of these
features is to approximate the non-linear human perception of the variation in pitch with respect to the frequency.`,yt,I,ao=`<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Array&lt;number&gt;&gt;</code> - Triangular filter bank matrix, which is a 2D array of shape (<code>num_frequency_bins</code>, <code>num_mel_filters</code>).
This is a projection matrix to go from a spectrogram to a mel spectrogram.`,wt,K,no=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>num_frequency_bins</td><td><code>number</code></td><td><p>Number of frequencies used to compute the spectrogram (should be the same as in <code>stft</code>).</p></td> </tr><tr><td>num_mel_filters</td><td><code>number</code></td><td><p>Number of mel filters to generate.</p></td> </tr><tr><td>min_frequency</td><td><code>number</code></td><td><p>Lowest frequency of interest in Hz.</p></td> </tr><tr><td>max_frequency</td><td><code>number</code></td><td><p>Highest frequency of interest in Hz. This should not exceed <code>sampling_rate / 2</code>.</p></td> </tr><tr><td>sampling_rate</td><td><code>number</code></td><td><p>Sample rate of the audio waveform.</p></td> </tr><tr><td>[norm]</td><td><code>string</code></td><td><p>If <code>&quot;slaney&quot;</code>, divide the triangular mel weights by the width of the mel band (area normalization).</p></td> </tr><tr><td>[mel_scale]</td><td><code>string</code></td><td><p>The mel frequency scale to use, <code>&quot;htk&quot;</code> or <code>&quot;slaney&quot;</code>.</p></td> </tr><tr><td>[triangularize_in_mel_space]</td><td><code>boolean</code></td><td><p>If this option is enabled, the triangular filter is applied in mel space rather than frequency space.
This should be set to <code>true</code> in order to get the same results as <code>torchaudio</code> when computing mel filters.</p></td></tr></tbody>`,$t,xt,Ht,S,qt,O,Lt,N,uo="Calculates a spectrogram over one waveform using the Short-Time Fourier Transform.",Mt,U,so="This function can create the following kinds of spectrograms:",Ct,G,co="<li>amplitude spectrogram (<code>power = 1.0</code>)</li> <li>power spectrogram (<code>power = 2.0</code>)</li> <li>complex-valued spectrogram (<code>power = None</code>)</li> <li>log spectrogram (use <code>log_mel</code> argument)</li> <li>mel spectrogram (provide <code>mel_filters</code>)</li> <li>log-mel spectrogram (provide <code>mel_filters</code> and <code>log_mel</code>)</li>",At,W,mo=`In this implementation, the window is assumed to be zero-padded to have the same size as the analysis frame.
A padded window can be obtained from <code>window_function()</code>. The FFT input buffer may be larger than the analysis frame,
typically the next power of two.`,Pt,J,po='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Object</code> - Spectrogram of shape <code>(num_frequency_bins, length)</code> (regular spectrogram) or shape <code>(num_mel_filters, length)</code> (mel spectrogram).',zt,Q,fo=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>waveform</td><td><code>Float32Array</code> | <code>Float64Array</code></td><td></td><td><p>The input waveform of shape <code>(length,)</code>. This must be a single real-valued, mono waveform.</p></td> </tr><tr><td>window</td><td><code>Float32Array</code> | <code>Float64Array</code></td><td></td><td><p>The windowing function to apply of shape <code>(frame_length,)</code>, including zero-padding if necessary. The actual window length may be
shorter than <code>frame_length</code>, but we&#39;re assuming the array has already been zero-padded.</p></td> </tr><tr><td>frame_length</td><td><code>number</code></td><td></td><td><p>The length of the analysis frames in samples (a.k.a., <code>fft_length</code>).</p></td> </tr><tr><td>hop_length</td><td><code>number</code></td><td></td><td><p>The stride between successive analysis frames in samples.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td></td> </tr><tr><td>[options.fft_length]</td><td><code>number</code></td><td><code></code></td><td><p>The size of the FFT buffer in samples. This determines how many frequency bins the spectrogram will have.
For optimal speed, this should be a power of two. If <code>null</code>, uses <code>frame_length</code>.</p></td> </tr><tr><td>[options.power]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>If 1.0, returns the amplitude spectrogram. If 2.0, returns the power spectrogram. If <code>null</code>, returns complex numbers.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to pad the waveform so that frame <code>t</code> is centered around time <code>t * hop_length</code>. If <code>false</code>, frame
<code>t</code> will start at time <code>t * hop_length</code>.</p></td> </tr><tr><td>[options.pad_mode]</td><td><code>string</code></td><td><code>&quot;&quot;reflect&quot;&quot;</code></td><td><p>Padding mode used when <code>center</code> is <code>true</code>. Possible values are: <code>&quot;constant&quot;</code> (pad with zeros),
<code>&quot;edge&quot;</code> (pad with edge values), <code>&quot;reflect&quot;</code> (pads with mirrored values).</p></td> </tr><tr><td>[options.onesided]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>If <code>true</code>, only computes the positive frequencies and returns a spectrogram containing <code>fft_length // 2 + 1</code>
frequency bins. If <code>false</code>, also computes the negative frequencies and returns <code>fft_length</code> frequency bins.</p></td> </tr><tr><td>[options.preemphasis]</td><td><code>number</code></td><td><code></code></td><td><p>Coefficient for a low-pass filter that applies pre-emphasis before the DFT.</p></td> </tr><tr><td>[options.mel_filters]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The mel filter bank of shape <code>(num_freq_bins, num_mel_filters)</code>.
If supplied, applies this filter bank to create a mel spectrogram.</p></td> </tr><tr><td>[options.mel_floor]</td><td><code>number</code></td><td><code>1e-10</code></td><td><p>Minimum value of mel frequency banks.</p></td> </tr><tr><td>[options.log_mel]</td><td><code>string</code></td><td><code>null</code></td><td><p>How to convert the spectrogram to log scale. Possible options are:
<code>null</code> (don&#39;t convert), <code>&quot;log&quot;</code> (take the natural logarithm) <code>&quot;log10&quot;</code> (take the base-10 logarithm), <code>&quot;dB&quot;</code> (convert to decibels).
Can only be used when <code>power</code> is not <code>null</code>.</p></td> </tr><tr><td>[options.reference]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Sets the input spectrogram value that corresponds to 0 dB. For example, use <code>max(spectrogram)[0]</code> to set
the loudest part to 0 dB. Must be greater than zero.</p></td> </tr><tr><td>[options.min_value]</td><td><code>number</code></td><td><code>1e-10</code></td><td><p>The spectrogram will be clipped to this minimum value before conversion to decibels, to avoid taking <code>log(0)</code>.
For a power spectrogram, the default of <code>1e-10</code> corresponds to a minimum of -100 dB. For an amplitude spectrogram, the value <code>1e-5</code> corresponds to -100 dB.
Must be greater than zero.</p></td> </tr><tr><td>[options.db_range]</td><td><code>number</code></td><td><code></code></td><td><p>Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the difference between the
peak value and the smallest value will never be more than 80 dB. Must be greater than zero.</p></td> </tr><tr><td>[options.remove_dc_offset]</td><td><code>boolean</code></td><td><code></code></td><td><p>Subtract mean from waveform on each frame, applied before pre-emphasis. This should be set to <code>true</code> in
order to get the same results as <code>torchaudio.compliance.kaldi.fbank</code> when computing mel filters.</p></td> </tr><tr><td>[options.max_num_frames]</td><td><code>number</code></td><td><code></code></td><td><p>If provided, limits the number of frames to compute to this value.</p></td> </tr><tr><td>[options.do_pad]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>If <code>true</code>, pads the output spectrogram to have <code>max_num_frames</code> frames.</p></td> </tr><tr><td>[options.transpose]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>If <code>true</code>, the returned spectrogram will have shape <code>(num_frames, num_frequency_bins/num_mel_filters)</code>. If <code>false</code>, the returned spectrogram will have shape <code>(num_frequency_bins/num_mel_filters, num_frames)</code>.</p></td></tr></tbody>`,kt,Ft,Et,V,Rt,X,Bt,Y,ho="Returns an array containing the specified window.",Dt,Z,_o='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The window of shape <code>(window_length,)</code> or <code>(frame_length,)</code>.',jt,ee,bo=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>window_length</td><td><code>number</code></td><td></td><td><p>The length of the window in samples.</p></td> </tr><tr><td>name</td><td><code>string</code></td><td></td><td><p>The name of the window function.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options.</p></td> </tr><tr><td>[options.periodic]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether the window is periodic or symmetric.</p></td> </tr><tr><td>[options.frame_length]</td><td><code>number</code></td><td><code></code></td><td><p>The length of the analysis frames in samples.
Provide a value for <code>frame_length</code> if the window is smaller than the frame length, so that it will be zero-padded.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to center the window inside the FFT buffer. Only used when <code>frame_length</code> is provided.</p></td></tr></tbody>`,It,Kt,St,te,Ot,de,Nt,oe,go='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a>',Ut,le,vo="<thead><tr><th>Param</th><th>Type</th><th>Default</th></tr></thead> <tbody><tr><td>freq</td><td><code>T</code></td><td></td> </tr><tr><td>[mel_scale]</td><td><code>string</code></td><td><code>&quot;htk&quot;</code></td></tr></tbody>",Gt,Wt,Jt,re,Qt,ie,Vt,ae,To='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a>',Xt,ne,yo="<thead><tr><th>Param</th><th>Type</th><th>Default</th></tr></thead> <tbody><tr><td>mels</td><td><code>T</code></td><td></td> </tr><tr><td>[mel_scale]</td><td><code>string</code></td><td><code>&quot;htk&quot;</code></td></tr></tbody>",Yt,Zt,ed,ue,td,se,dd,ce,wo="Creates a triangular filter bank.",od,me,$o="Adapted from torchaudio and librosa.",ld,pe,xo='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Array&lt;number&gt;&gt;</code> - of shape <code>(num_frequency_bins, num_mel_filters)</code>.',rd,fe,Ho="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>fft_freqs</td><td><code>Float64Array</code></td><td><p>Discrete frequencies of the FFT bins in Hz, of shape <code>(num_frequency_bins,)</code>.</p></td> </tr><tr><td>filter_freqs</td><td><code>Float64Array</code></td><td><p>Center frequencies of the triangular filters to create, in Hz, of shape <code>(num_mel_filters,)</code>.</p></td></tr></tbody>",id,ad,nd,he,ud,_e,sd,be,qo="Return evenly spaced numbers over a specified interval.",cd,ge,Lo='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>num</code> evenly spaced samples, calculated over the interval <code>[start, stop]</code>.',md,ve,Mo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>start</td><td><code>number</code></td><td><p>The starting value of the sequence.</p></td> </tr><tr><td>end</td><td><code>number</code></td><td><p>The end value of the sequence.</p></td> </tr><tr><td>num</td><td><code>number</code></td><td><p>Number of samples to generate.</p></td></tr></tbody>",pd,fd,hd,Te,_d,ye,bd,we,Co='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>T</code> - The padded array.',gd,$e,Ao="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>array</td><td><code>T</code></td><td><p>The array to pad.</p></td> </tr><tr><td>left</td><td><code>number</code></td><td><p>The amount of padding to add to the left.</p></td> </tr><tr><td>right</td><td><code>number</code></td><td><p>The amount of padding to add to the right.</p></td></tr></tbody>",vd,Td,yd,xe,wd,He,$d,qe,Po="Helper function to compute <code>amplitude_to_db</code> and <code>power_to_db</code>.",xd,Le,zo='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a>',Hd,Me,ko="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>spectrogram</td><td><code>T</code></td> </tr><tr><td>factor</td><td><code>number</code></td> </tr><tr><td>reference</td><td><code>number</code></td> </tr><tr><td>min_value</td><td><code>number</code></td> </tr><tr><td>db_range</td><td><code>number</code></td></tr></tbody>",qd,Ld,Md,Ce,Cd,Ae,Ad,Pe,Fo=`Converts an amplitude spectrogram to the decibel scale. This computes <code>20 * log10(spectrogram / reference)</code>,
using basic logarithm properties for numerical stability. NOTE: Operates in-place.`,Pd,ze,Eo=`The motivation behind applying the log function on the (mel) spectrogram is that humans do not hear loudness on a
linear scale. Generally to double the perceived volume of a sound we need to put 8 times as much energy into it.
This means that large variations in energy may not sound all that different if the sound is loud to begin with.
This compression operation makes the (mel) spectrogram features match more closely what humans actually hear.`,zd,ke,Ro='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>T</code> - The modified spectrogram in decibels.',kd,Fe,Bo=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>spectrogram</td><td><code>T</code></td><td></td><td><p>The input amplitude (mel) spectrogram.</p></td> </tr><tr><td>[reference]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Sets the input spectrogram value that corresponds to 0 dB.
For example, use <code>np.max(spectrogram)</code> to set the loudest part to 0 dB. Must be greater than zero.</p></td> </tr><tr><td>[min_value]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>The spectrogram will be clipped to this minimum value before conversion to decibels,
to avoid taking <code>log(0)</code>. The default of <code>1e-5</code> corresponds to a minimum of -100 dB. Must be greater than zero.</p></td> </tr><tr><td>[db_range]</td><td><code>number</code></td><td><code></code></td><td><p>Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the
difference between the peak value and the smallest value will never be more than 80 dB. Must be greater than zero.</p></td></tr></tbody>`,Fd,Ed,Rd,Ee,Bd,Re,Dd,Be,Do=`Converts a power spectrogram to the decibel scale. This computes <code>10 * log10(spectrogram / reference)</code>,
using basic logarithm properties for numerical stability. NOTE: Operates in-place.`,jd,De,jo=`The motivation behind applying the log function on the (mel) spectrogram is that humans do not hear loudness on a
linear scale. Generally to double the perceived volume of a sound we need to put 8 times as much energy into it.
This means that large variations in energy may not sound all that different if the sound is loud to begin with.
This compression operation makes the (mel) spectrogram features match more closely what humans actually hear.`,Id,je,Io="Based on the implementation of <code>librosa.power_to_db</code>.",Kd,Ie,Ko='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>T</code> - The modified spectrogram in decibels.',Sd,Ke,So=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>spectrogram</td><td><code>T</code></td><td></td><td><p>The input power (mel) spectrogram. Note that a power spectrogram has the amplitudes squared!</p></td> </tr><tr><td>[reference]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Sets the input spectrogram value that corresponds to 0 dB.
For example, use <code>np.max(spectrogram)</code> to set the loudest part to 0 dB. Must be greater than zero.</p></td> </tr><tr><td>[min_value]</td><td><code>number</code></td><td><code>1e-10</code></td><td><p>The spectrogram will be clipped to this minimum value before conversion to decibels,
to avoid taking <code>log(0)</code>. The default of <code>1e-10</code> corresponds to a minimum of -100 dB. Must be greater than zero.</p></td> </tr><tr><td>[db_range]</td><td><code>number</code></td><td><code></code></td><td><p>Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the
difference between the peak value and the smallest value will never be more than 80 dB. Must be greater than zero.</p></td></tr></tbody>`,Od,Nd,Ud,Se,Gd,Ne,Wd;return T=new b({props:{title:"utils/audio",local:"utilsaudio",headingTag:"h1"}}),H=new b({props:{title:"utils/audio.read_audio(url, sampling_rate) ⇒ <code> Promise. < Float32Array > </code>",local:"utilsaudioreadaudiourl-samplingrate--code-promise--float32array--code",headingTag:"h2"}}),A=new b({props:{title:"read_audio~audio : <code> Float32Array </code>",local:"readaudioaudio--code-float32array-code",headingTag:"h3"}}),k=new b({props:{title:"utils/audio.hanning(M) ⇒ <code> Float64Array </code>",local:"utilsaudiohanningm--code-float64array-code",headingTag:"h2"}}),D=new b({props:{title:"utils/audio.mel_filter_bank(num_frequency_bins, num_mel_filters, min_frequency, max_frequency, sampling_rate, [norm], [mel_scale], [triangularize_in_mel_space]) ⇒ <code> Array. < Array < number > > </code>",local:"utilsaudiomelfilterbanknumfrequencybins-nummelfilters-minfrequency-maxfrequency-samplingrate-norm-melscale-triangularizeinmelspace--code-array--array--number---code",headingTag:"h2"}}),O=new b({props:{title:"utils/audio.spectrogram(waveform, window, frame_length, hop_length, options) ⇒ <code> Object </code>",local:"utilsaudiospectrogramwaveform-window-framelength-hoplength-options--code-object-code",headingTag:"h2"}}),X=new b({props:{title:"utils/audio.window_function(window_length, name, options) ⇒ <code> Float64Array </code>",local:"utilsaudiowindowfunctionwindowlength-name-options--code-float64array-code",headingTag:"h2"}}),de=new b({props:{title:"utils/audio~hertz_to_mel(freq, [mel_scale]) ⇒ <code> T </code>",local:"utilsaudiohertztomelfreq-melscale--code-t-code",headingTag:"h2"}}),ie=new b({props:{title:"utils/audio~mel_to_hertz(mels, [mel_scale]) ⇒ <code> T </code>",local:"utilsaudiomeltohertzmels-melscale--code-t-code",headingTag:"h2"}}),se=new b({props:{title:"utils/audio~_create_triangular_filter_bank(fft_freqs, filter_freqs) ⇒ <code> Array. < Array < number > > </code>",local:"utilsaudiocreatetriangularfilterbankfftfreqs-filterfreqs--code-array--array--number---code",headingTag:"h2"}}),_e=new b({props:{title:"utils/audio~linspace(start, end, num) ⇒",local:"utilsaudiolinspacestart-end-num-",headingTag:"h2"}}),ye=new b({props:{title:"utils/audio~padReflect(array, left, right) ⇒ <code> T </code>",local:"utilsaudiopadreflectarray-left-right--code-t-code",headingTag:"h2"}}),He=new b({props:{title:"utils/audio~_db_conversion_helper(spectrogram, factor, reference, min_value, db_range) ⇒ <code> T </code>",local:"utilsaudiodbconversionhelperspectrogram-factor-reference-minvalue-dbrange--code-t-code",headingTag:"h2"}}),Ae=new b({props:{title:"utils/audio~amplitude_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>",local:"utilsaudioamplitudetodbspectrogram-reference-minvalue-dbrange--code-t-code",headingTag:"h2"}}),Re=new b({props:{title:"utils/audio~power_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>",local:"utilsaudiopowertodbspectrogram-reference-minvalue-dbrange--code-t-code",headingTag:"h2"}}),Se=new Vo({props:{source:"https://github.com/xenova/transformers.js/blob/v2.17.2/docs/source/api/utils/audio.md"}}),{c(){g=i("meta"),Ue=l(),Oe=i("p"),Ge=l(),v=i("a"),We=l(),c(T.$$.fragment),Je=l(),y=i("p"),y.textContent=Qd,Qe=l(),w=i("p"),w.textContent=Vd,Ve=l(),$=i("ul"),$.innerHTML=Xd,Xe=l(),Ye=i("hr"),Ze=l(),x=i("a"),et=l(),c(H.$$.fragment),tt=l(),q=i("p"),q.textContent=Yd,dt=l(),L=i("p"),L.innerHTML=Zd,ot=l(),M=i("table"),M.innerHTML=eo,lt=l(),rt=i("hr"),it=l(),C=i("a"),at=l(),c(A.$$.fragment),nt=l(),P=i("p"),P.innerHTML=to,ut=l(),st=i("hr"),ct=l(),z=i("a"),mt=l(),c(k.$$.fragment),pt=l(),F=i("p"),F.textContent=oo,ft=l(),E=i("p"),E.innerHTML=lo,ht=l(),R=i("table"),R.innerHTML=ro,_t=l(),bt=i("hr"),gt=l(),B=i("a"),vt=l(),c(D.$$.fragment),Tt=l(),j=i("p"),j.innerHTML=io,yt=l(),I=i("p"),I.innerHTML=ao,wt=l(),K=i("table"),K.innerHTML=no,$t=l(),xt=i("hr"),Ht=l(),S=i("a"),qt=l(),c(O.$$.fragment),Lt=l(),N=i("p"),N.textContent=uo,Mt=l(),U=i("p"),U.textContent=so,Ct=l(),G=i("ul"),G.innerHTML=co,At=l(),W=i("p"),W.innerHTML=mo,Pt=l(),J=i("p"),J.innerHTML=po,zt=l(),Q=i("table"),Q.innerHTML=fo,kt=l(),Ft=i("hr"),Et=l(),V=i("a"),Rt=l(),c(X.$$.fragment),Bt=l(),Y=i("p"),Y.textContent=ho,Dt=l(),Z=i("p"),Z.innerHTML=_o,jt=l(),ee=i("table"),ee.innerHTML=bo,It=l(),Kt=i("hr"),St=l(),te=i("a"),Ot=l(),c(de.$$.fragment),Nt=l(),oe=i("p"),oe.innerHTML=go,Ut=l(),le=i("table"),le.innerHTML=vo,Gt=l(),Wt=i("hr"),Jt=l(),re=i("a"),Qt=l(),c(ie.$$.fragment),Vt=l(),ae=i("p"),ae.innerHTML=To,Xt=l(),ne=i("table"),ne.innerHTML=yo,Yt=l(),Zt=i("hr"),ed=l(),ue=i("a"),td=l(),c(se.$$.fragment),dd=l(),ce=i("p"),ce.textContent=wo,od=l(),me=i("p"),me.textContent=$o,ld=l(),pe=i("p"),pe.innerHTML=xo,rd=l(),fe=i("table"),fe.innerHTML=Ho,id=l(),ad=i("hr"),nd=l(),he=i("a"),ud=l(),c(_e.$$.fragment),sd=l(),be=i("p"),be.textContent=qo,cd=l(),ge=i("p"),ge.innerHTML=Lo,md=l(),ve=i("table"),ve.innerHTML=Mo,pd=l(),fd=i("hr"),hd=l(),Te=i("a"),_d=l(),c(ye.$$.fragment),bd=l(),we=i("p"),we.innerHTML=Co,gd=l(),$e=i("table"),$e.innerHTML=Ao,vd=l(),Td=i("hr"),yd=l(),xe=i("a"),wd=l(),c(He.$$.fragment),$d=l(),qe=i("p"),qe.innerHTML=Po,xd=l(),Le=i("p"),Le.innerHTML=zo,Hd=l(),Me=i("table"),Me.innerHTML=ko,qd=l(),Ld=i("hr"),Md=l(),Ce=i("a"),Cd=l(),c(Ae.$$.fragment),Ad=l(),Pe=i("p"),Pe.innerHTML=Fo,Pd=l(),ze=i("p"),ze.textContent=Eo,zd=l(),ke=i("p"),ke.innerHTML=Ro,kd=l(),Fe=i("table"),Fe.innerHTML=Bo,Fd=l(),Ed=i("hr"),Rd=l(),Ee=i("a"),Bd=l(),c(Re.$$.fragment),Dd=l(),Be=i("p"),Be.innerHTML=Do,jd=l(),De=i("p"),De.textContent=jo,Id=l(),je=i("p"),je.innerHTML=Io,Kd=l(),Ie=i("p"),Ie.innerHTML=Ko,Sd=l(),Ke=i("table"),Ke.innerHTML=So,Od=l(),Nd=i("hr"),Ud=l(),c(Se.$$.fragment),Gd=l(),Ne=i("p"),this.h()},l(e){const t=Jo("svelte-u9bgzb",document.head);g=a(t,"META",{name:!0,content:!0}),t.forEach(d),Ue=r(e),Oe=a(e,"P",{}),s(Oe).forEach(d),Ge=r(e),v=a(e,"A",{id:!0,class:!0}),s(v).forEach(d),We=r(e),m(T.$$.fragment,e),Je=r(e),y=a(e,"P",{"data-svelte-h":!0}),n(y)!=="svelte-12buzkq"&&(y.textContent=Qd),Qe=r(e),w=a(e,"P",{"data-svelte-h":!0}),n(w)!=="svelte-il3kl8"&&(w.textContent=Vd),Ve=r(e),$=a(e,"UL",{"data-svelte-h":!0}),n($)!=="svelte-10lafhw"&&($.innerHTML=Xd),Xe=r(e),Ye=a(e,"HR",{}),Ze=r(e),x=a(e,"A",{id:!0,class:!0}),s(x).forEach(d),et=r(e),m(H.$$.fragment,e),tt=r(e),q=a(e,"P",{"data-svelte-h":!0}),n(q)!=="svelte-wq5n0b"&&(q.textContent=Yd),dt=r(e),L=a(e,"P",{"data-svelte-h":!0}),n(L)!=="svelte-wzwr9x"&&(L.innerHTML=Zd),ot=r(e),M=a(e,"TABLE",{"data-svelte-h":!0}),n(M)!=="svelte-1u23bjg"&&(M.innerHTML=eo),lt=r(e),rt=a(e,"HR",{}),it=r(e),C=a(e,"A",{id:!0,class:!0}),s(C).forEach(d),at=r(e),m(A.$$.fragment,e),nt=r(e),P=a(e,"P",{"data-svelte-h":!0}),n(P)!=="svelte-kcz1h5"&&(P.innerHTML=to),ut=r(e),st=a(e,"HR",{}),ct=r(e),z=a(e,"A",{id:!0,class:!0}),s(z).forEach(d),mt=r(e),m(k.$$.fragment,e),pt=r(e),F=a(e,"P",{"data-svelte-h":!0}),n(F)!=="svelte-7wy73k"&&(F.textContent=oo),ft=r(e),E=a(e,"P",{"data-svelte-h":!0}),n(E)!=="svelte-187ugov"&&(E.innerHTML=lo),ht=r(e),R=a(e,"TABLE",{"data-svelte-h":!0}),n(R)!=="svelte-1x4zay3"&&(R.innerHTML=ro),_t=r(e),bt=a(e,"HR",{}),gt=r(e),B=a(e,"A",{id:!0,class:!0}),s(B).forEach(d),vt=r(e),m(D.$$.fragment,e),Tt=r(e),j=a(e,"P",{"data-svelte-h":!0}),n(j)!=="svelte-ke4v6b"&&(j.innerHTML=io),yt=r(e),I=a(e,"P",{"data-svelte-h":!0}),n(I)!=="svelte-rtofow"&&(I.innerHTML=ao),wt=r(e),K=a(e,"TABLE",{"data-svelte-h":!0}),n(K)!=="svelte-t1r9o1"&&(K.innerHTML=no),$t=r(e),xt=a(e,"HR",{}),Ht=r(e),S=a(e,"A",{id:!0,class:!0}),s(S).forEach(d),qt=r(e),m(O.$$.fragment,e),Lt=r(e),N=a(e,"P",{"data-svelte-h":!0}),n(N)!=="svelte-10mwufd"&&(N.textContent=uo),Mt=r(e),U=a(e,"P",{"data-svelte-h":!0}),n(U)!=="svelte-zfp2ya"&&(U.textContent=so),Ct=r(e),G=a(e,"UL",{"data-svelte-h":!0}),n(G)!=="svelte-14mziv8"&&(G.innerHTML=co),At=r(e),W=a(e,"P",{"data-svelte-h":!0}),n(W)!=="svelte-iwx6w9"&&(W.innerHTML=mo),Pt=r(e),J=a(e,"P",{"data-svelte-h":!0}),n(J)!=="svelte-1ib6mhu"&&(J.innerHTML=po),zt=r(e),Q=a(e,"TABLE",{"data-svelte-h":!0}),n(Q)!=="svelte-1nkeya3"&&(Q.innerHTML=fo),kt=r(e),Ft=a(e,"HR",{}),Et=r(e),V=a(e,"A",{id:!0,class:!0}),s(V).forEach(d),Rt=r(e),m(X.$$.fragment,e),Bt=r(e),Y=a(e,"P",{"data-svelte-h":!0}),n(Y)!=="svelte-13l1rbm"&&(Y.textContent=ho),Dt=r(e),Z=a(e,"P",{"data-svelte-h":!0}),n(Z)!=="svelte-9ixqdv"&&(Z.innerHTML=_o),jt=r(e),ee=a(e,"TABLE",{"data-svelte-h":!0}),n(ee)!=="svelte-h693em"&&(ee.innerHTML=bo),It=r(e),Kt=a(e,"HR",{}),St=r(e),te=a(e,"A",{id:!0,class:!0}),s(te).forEach(d),Ot=r(e),m(de.$$.fragment,e),Nt=r(e),oe=a(e,"P",{"data-svelte-h":!0}),n(oe)!=="svelte-5cebk5"&&(oe.innerHTML=go),Ut=r(e),le=a(e,"TABLE",{"data-svelte-h":!0}),n(le)!=="svelte-1w6ehfm"&&(le.innerHTML=vo),Gt=r(e),Wt=a(e,"HR",{}),Jt=r(e),re=a(e,"A",{id:!0,class:!0}),s(re).forEach(d),Qt=r(e),m(ie.$$.fragment,e),Vt=r(e),ae=a(e,"P",{"data-svelte-h":!0}),n(ae)!=="svelte-5cebk5"&&(ae.innerHTML=To),Xt=r(e),ne=a(e,"TABLE",{"data-svelte-h":!0}),n(ne)!=="svelte-io7ocd"&&(ne.innerHTML=yo),Yt=r(e),Zt=a(e,"HR",{}),ed=r(e),ue=a(e,"A",{id:!0,class:!0}),s(ue).forEach(d),td=r(e),m(se.$$.fragment,e),dd=r(e),ce=a(e,"P",{"data-svelte-h":!0}),n(ce)!=="svelte-uj0il7"&&(ce.textContent=wo),od=r(e),me=a(e,"P",{"data-svelte-h":!0}),n(me)!=="svelte-srmfwi"&&(me.textContent=$o),ld=r(e),pe=a(e,"P",{"data-svelte-h":!0}),n(pe)!=="svelte-aln42z"&&(pe.innerHTML=xo),rd=r(e),fe=a(e,"TABLE",{"data-svelte-h":!0}),n(fe)!=="svelte-2x9dyx"&&(fe.innerHTML=Ho),id=r(e),ad=a(e,"HR",{}),nd=r(e),he=a(e,"A",{id:!0,class:!0}),s(he).forEach(d),ud=r(e),m(_e.$$.fragment,e),sd=r(e),be=a(e,"P",{"data-svelte-h":!0}),n(be)!=="svelte-osjtvn"&&(be.textContent=qo),cd=r(e),ge=a(e,"P",{"data-svelte-h":!0}),n(ge)!=="svelte-bfmjcl"&&(ge.innerHTML=Lo),md=r(e),ve=a(e,"TABLE",{"data-svelte-h":!0}),n(ve)!=="svelte-c7ztlp"&&(ve.innerHTML=Mo),pd=r(e),fd=a(e,"HR",{}),hd=r(e),Te=a(e,"A",{id:!0,class:!0}),s(Te).forEach(d),_d=r(e),m(ye.$$.fragment,e),bd=r(e),we=a(e,"P",{"data-svelte-h":!0}),n(we)!=="svelte-115nnpl"&&(we.innerHTML=Co),gd=r(e),$e=a(e,"TABLE",{"data-svelte-h":!0}),n($e)!=="svelte-6p81mk"&&($e.innerHTML=Ao),vd=r(e),Td=a(e,"HR",{}),yd=r(e),xe=a(e,"A",{id:!0,class:!0}),s(xe).forEach(d),wd=r(e),m(He.$$.fragment,e),$d=r(e),qe=a(e,"P",{"data-svelte-h":!0}),n(qe)!=="svelte-9t3wul"&&(qe.innerHTML=Po),xd=r(e),Le=a(e,"P",{"data-svelte-h":!0}),n(Le)!=="svelte-5cebk5"&&(Le.innerHTML=zo),Hd=r(e),Me=a(e,"TABLE",{"data-svelte-h":!0}),n(Me)!=="svelte-heeupf"&&(Me.innerHTML=ko),qd=r(e),Ld=a(e,"HR",{}),Md=r(e),Ce=a(e,"A",{id:!0,class:!0}),s(Ce).forEach(d),Cd=r(e),m(Ae.$$.fragment,e),Ad=r(e),Pe=a(e,"P",{"data-svelte-h":!0}),n(Pe)!=="svelte-93lmwr"&&(Pe.innerHTML=Fo),Pd=r(e),ze=a(e,"P",{"data-svelte-h":!0}),n(ze)!=="svelte-12zo44d"&&(ze.textContent=Eo),zd=r(e),ke=a(e,"P",{"data-svelte-h":!0}),n(ke)!=="svelte-1d363v6"&&(ke.innerHTML=Ro),kd=r(e),Fe=a(e,"TABLE",{"data-svelte-h":!0}),n(Fe)!=="svelte-1wpe278"&&(Fe.innerHTML=Bo),Fd=r(e),Ed=a(e,"HR",{}),Rd=r(e),Ee=a(e,"A",{id:!0,class:!0}),s(Ee).forEach(d),Bd=r(e),m(Re.$$.fragment,e),Dd=r(e),Be=a(e,"P",{"data-svelte-h":!0}),n(Be)!=="svelte-1dxatci"&&(Be.innerHTML=Do),jd=r(e),De=a(e,"P",{"data-svelte-h":!0}),n(De)!=="svelte-12zo44d"&&(De.textContent=jo),Id=r(e),je=a(e,"P",{"data-svelte-h":!0}),n(je)!=="svelte-1bxqqp"&&(je.innerHTML=Io),Kd=r(e),Ie=a(e,"P",{"data-svelte-h":!0}),n(Ie)!=="svelte-1d363v6"&&(Ie.innerHTML=Ko),Sd=r(e),Ke=a(e,"TABLE",{"data-svelte-h":!0}),n(Ke)!=="svelte-h9b3kb"&&(Ke.innerHTML=So),Od=r(e),Nd=a(e,"HR",{}),Ud=r(e),m(Se.$$.fragment,e),Gd=r(e),Ne=a(e,"P",{}),s(Ne).forEach(d),this.h()},h(){u(g,"name","hf:doc:metadata"),u(g,"content",Yo),u(v,"id","module_utils/audio"),u(v,"class","group"),u(x,"id","module_utils/audio.read_audio"),u(x,"class","group"),u(C,"id","module_utils/audio.read_audio..audio"),u(C,"class","group"),u(z,"id","module_utils/audio.hanning"),u(z,"class","group"),u(B,"id","module_utils/audio.mel_filter_bank"),u(B,"class","group"),u(S,"id","module_utils/audio.spectrogram"),u(S,"class","group"),u(V,"id","module_utils/audio.window_function"),u(V,"class","group"),u(te,"id","module_utils/audio..hertz_to_mel"),u(te,"class","group"),u(re,"id","module_utils/audio..mel_to_hertz"),u(re,"class","group"),u(ue,"id","module_utils/audio.._create_triangular_filter_bank"),u(ue,"class","group"),u(he,"id","module_utils/audio..linspace"),u(he,"class","group"),u(Te,"id","module_utils/audio..padReflect"),u(Te,"class","group"),u(xe,"id","module_utils/audio.._db_conversion_helper"),u(xe,"class","group"),u(Ce,"id","module_utils/audio..amplitude_to_db"),u(Ce,"class","group"),u(Ee,"id","module_utils/audio..power_to_db"),u(Ee,"class","group")},m(e,t){Qo(document.head,g),o(e,Ue,t),o(e,Oe,t),o(e,Ge,t),o(e,v,t),o(e,We,t),p(T,e,t),o(e,Je,t),o(e,y,t),o(e,Qe,t),o(e,w,t),o(e,Ve,t),o(e,$,t),o(e,Xe,t),o(e,Ye,t),o(e,Ze,t),o(e,x,t),o(e,et,t),p(H,e,t),o(e,tt,t),o(e,q,t),o(e,dt,t),o(e,L,t),o(e,ot,t),o(e,M,t),o(e,lt,t),o(e,rt,t),o(e,it,t),o(e,C,t),o(e,at,t),p(A,e,t),o(e,nt,t),o(e,P,t),o(e,ut,t),o(e,st,t),o(e,ct,t),o(e,z,t),o(e,mt,t),p(k,e,t),o(e,pt,t),o(e,F,t),o(e,ft,t),o(e,E,t),o(e,ht,t),o(e,R,t),o(e,_t,t),o(e,bt,t),o(e,gt,t),o(e,B,t),o(e,vt,t),p(D,e,t),o(e,Tt,t),o(e,j,t),o(e,yt,t),o(e,I,t),o(e,wt,t),o(e,K,t),o(e,$t,t),o(e,xt,t),o(e,Ht,t),o(e,S,t),o(e,qt,t),p(O,e,t),o(e,Lt,t),o(e,N,t),o(e,Mt,t),o(e,U,t),o(e,Ct,t),o(e,G,t),o(e,At,t),o(e,W,t),o(e,Pt,t),o(e,J,t),o(e,zt,t),o(e,Q,t),o(e,kt,t),o(e,Ft,t),o(e,Et,t),o(e,V,t),o(e,Rt,t),p(X,e,t),o(e,Bt,t),o(e,Y,t),o(e,Dt,t),o(e,Z,t),o(e,jt,t),o(e,ee,t),o(e,It,t),o(e,Kt,t),o(e,St,t),o(e,te,t),o(e,Ot,t),p(de,e,t),o(e,Nt,t),o(e,oe,t),o(e,Ut,t),o(e,le,t),o(e,Gt,t),o(e,Wt,t),o(e,Jt,t),o(e,re,t),o(e,Qt,t),p(ie,e,t),o(e,Vt,t),o(e,ae,t),o(e,Xt,t),o(e,ne,t),o(e,Yt,t),o(e,Zt,t),o(e,ed,t),o(e,ue,t),o(e,td,t),p(se,e,t),o(e,dd,t),o(e,ce,t),o(e,od,t),o(e,me,t),o(e,ld,t),o(e,pe,t),o(e,rd,t),o(e,fe,t),o(e,id,t),o(e,ad,t),o(e,nd,t),o(e,he,t),o(e,ud,t),p(_e,e,t),o(e,sd,t),o(e,be,t),o(e,cd,t),o(e,ge,t),o(e,md,t),o(e,ve,t),o(e,pd,t),o(e,fd,t),o(e,hd,t),o(e,Te,t),o(e,_d,t),p(ye,e,t),o(e,bd,t),o(e,we,t),o(e,gd,t),o(e,$e,t),o(e,vd,t),o(e,Td,t),o(e,yd,t),o(e,xe,t),o(e,wd,t),p(He,e,t),o(e,$d,t),o(e,qe,t),o(e,xd,t),o(e,Le,t),o(e,Hd,t),o(e,Me,t),o(e,qd,t),o(e,Ld,t),o(e,Md,t),o(e,Ce,t),o(e,Cd,t),p(Ae,e,t),o(e,Ad,t),o(e,Pe,t),o(e,Pd,t),o(e,ze,t),o(e,zd,t),o(e,ke,t),o(e,kd,t),o(e,Fe,t),o(e,Fd,t),o(e,Ed,t),o(e,Rd,t),o(e,Ee,t),o(e,Bd,t),p(Re,e,t),o(e,Dd,t),o(e,Be,t),o(e,jd,t),o(e,De,t),o(e,Id,t),o(e,je,t),o(e,Kd,t),o(e,Ie,t),o(e,Sd,t),o(e,Ke,t),o(e,Od,t),o(e,Nd,t),o(e,Ud,t),p(Se,e,t),o(e,Gd,t),o(e,Ne,t),Wd=!0},p:No,i(e){Wd||(f(T.$$.fragment,e),f(H.$$.fragment,e),f(A.$$.fragment,e),f(k.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(X.$$.fragment,e),f(de.$$.fragment,e),f(ie.$$.fragment,e),f(se.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),f(He.$$.fragment,e),f(Ae.$$.fragment,e),f(Re.$$.fragment,e),f(Se.$$.fragment,e),Wd=!0)},o(e){h(T.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(k.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(X.$$.fragment,e),h(de.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),h(He.$$.fragment,e),h(Ae.$$.fragment,e),h(Re.$$.fragment,e),h(Se.$$.fragment,e),Wd=!1},d(e){e&&(d(Ue),d(Oe),d(Ge),d(v),d(We),d(Je),d(y),d(Qe),d(w),d(Ve),d($),d(Xe),d(Ye),d(Ze),d(x),d(et),d(tt),d(q),d(dt),d(L),d(ot),d(M),d(lt),d(rt),d(it),d(C),d(at),d(nt),d(P),d(ut),d(st),d(ct),d(z),d(mt),d(pt),d(F),d(ft),d(E),d(ht),d(R),d(_t),d(bt),d(gt),d(B),d(vt),d(Tt),d(j),d(yt),d(I),d(wt),d(K),d($t),d(xt),d(Ht),d(S),d(qt),d(Lt),d(N),d(Mt),d(U),d(Ct),d(G),d(At),d(W),d(Pt),d(J),d(zt),d(Q),d(kt),d(Ft),d(Et),d(V),d(Rt),d(Bt),d(Y),d(Dt),d(Z),d(jt),d(ee),d(It),d(Kt),d(St),d(te),d(Ot),d(Nt),d(oe),d(Ut),d(le),d(Gt),d(Wt),d(Jt),d(re),d(Qt),d(Vt),d(ae),d(Xt),d(ne),d(Yt),d(Zt),d(ed),d(ue),d(td),d(dd),d(ce),d(od),d(me),d(ld),d(pe),d(rd),d(fe),d(id),d(ad),d(nd),d(he),d(ud),d(sd),d(be),d(cd),d(ge),d(md),d(ve),d(pd),d(fd),d(hd),d(Te),d(_d),d(bd),d(we),d(gd),d($e),d(vd),d(Td),d(yd),d(xe),d(wd),d($d),d(qe),d(xd),d(Le),d(Hd),d(Me),d(qd),d(Ld),d(Md),d(Ce),d(Cd),d(Ad),d(Pe),d(Pd),d(ze),d(zd),d(ke),d(kd),d(Fe),d(Fd),d(Ed),d(Rd),d(Ee),d(Bd),d(Dd),d(Be),d(jd),d(De),d(Id),d(je),d(Kd),d(Ie),d(Sd),d(Ke),d(Od),d(Nd),d(Ud),d(Gd),d(Ne)),d(g),_(T,e),_(H,e),_(A,e),_(k,e),_(D,e),_(O,e),_(X,e),_(de,e),_(ie,e),_(se,e),_(_e,e),_(ye,e),_(He,e),_(Ae,e),_(Re,e),_(Se,e)}}}const Yo='{"title":"utils/audio","local":"utilsaudio","sections":[{"title":"utils/audio.read_audio(url, sampling_rate) ⇒ <code> Promise. < Float32Array > </code>","local":"utilsaudioreadaudiourl-samplingrate--code-promise--float32array--code","sections":[{"title":"read_audio~audio : <code> Float32Array </code>","local":"readaudioaudio--code-float32array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/audio.hanning(M) ⇒ <code> Float64Array </code>","local":"utilsaudiohanningm--code-float64array-code","sections":[],"depth":2},{"title":"utils/audio.mel_filter_bank(num_frequency_bins, num_mel_filters, min_frequency, max_frequency, sampling_rate, [norm], [mel_scale], [triangularize_in_mel_space]) ⇒ <code> Array. < Array < number > > </code>","local":"utilsaudiomelfilterbanknumfrequencybins-nummelfilters-minfrequency-maxfrequency-samplingrate-norm-melscale-triangularizeinmelspace--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/audio.spectrogram(waveform, window, frame_length, hop_length, options) ⇒ <code> Object </code>","local":"utilsaudiospectrogramwaveform-window-framelength-hoplength-options--code-object-code","sections":[],"depth":2},{"title":"utils/audio.window_function(window_length, name, options) ⇒ <code> Float64Array </code>","local":"utilsaudiowindowfunctionwindowlength-name-options--code-float64array-code","sections":[],"depth":2},{"title":"utils/audio~hertz_to_mel(freq, [mel_scale]) ⇒ <code> T </code>","local":"utilsaudiohertztomelfreq-melscale--code-t-code","sections":[],"depth":2},{"title":"utils/audio~mel_to_hertz(mels, [mel_scale]) ⇒ <code> T </code>","local":"utilsaudiomeltohertzmels-melscale--code-t-code","sections":[],"depth":2},{"title":"utils/audio~_create_triangular_filter_bank(fft_freqs, filter_freqs) ⇒ <code> Array. < Array < number > > </code>","local":"utilsaudiocreatetriangularfilterbankfftfreqs-filterfreqs--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/audio~linspace(start, end, num) ⇒","local":"utilsaudiolinspacestart-end-num-","sections":[],"depth":2},{"title":"utils/audio~padReflect(array, left, right) ⇒ <code> T </code>","local":"utilsaudiopadreflectarray-left-right--code-t-code","sections":[],"depth":2},{"title":"utils/audio~_db_conversion_helper(spectrogram, factor, reference, min_value, db_range) ⇒ <code> T </code>","local":"utilsaudiodbconversionhelperspectrogram-factor-reference-minvalue-dbrange--code-t-code","sections":[],"depth":2},{"title":"utils/audio~amplitude_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>","local":"utilsaudioamplitudetodbspectrogram-reference-minvalue-dbrange--code-t-code","sections":[],"depth":2},{"title":"utils/audio~power_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>","local":"utilsaudiopowertodbspectrogram-reference-minvalue-dbrange--code-t-code","sections":[],"depth":2}],"depth":1}';function Zo(Jd){return Uo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Go{constructor(g){super(),Wo(this,g,Zo,Xo,Oo,{})}}export{ol as component};
