import{s as At,n as Ft,o as Pt}from"../chunks/scheduler.defa9a21.js";import{S as Xt,i as Nt,g as i,s,r as c,A as Yt,h as r,f as a,c as n,j as xt,u as p,x as o,k as kt,y as Ht,a as l,v as h,d as m,t as d,w as f}from"../chunks/index.fe795e71.js";import{C as M}from"../chunks/CodeBlock.204b6c34.js";import{H as g,E as It}from"../chunks/getInferenceSnippets.5aa7956d.js";function Wt(lt){let u,pe,oe,he,y,me,w,st='Accelerate provides integrations to train on lower precision methods using specified supported hardware through the <code>TransformersEngine</code>, <code>MS-AMP</code>, and <code>torchao</code> packages. This documentation will help guide you through what hardware is supported, how to configure your <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> to leverage the low precision methods, and what you can expect when training.',de,T,fe,b,nt='To explore more of the nitty-gritty in training in FP8 with PyTorch and Accelerate, check out the <a href="../concept_guides/low_precision_training">concept_guide</a> on why this can be difficult. But essentially rather than training in BF16, some (or all) aspects of training a model can be performed using 8 bits instead of 16. The challenge is doing so without degrading final performance.',ue,j,it="This is only enabled on specific NVIDIA hardware, namely:",Me,U,rt="<li>Anything after the 3000 series consumer graphics cards (such as the 4090)</li> <li>Hopper-based GPU architectures (such as the <code>H100</code> and <code>H200</code>)</li>",ge,J,ot="What this will result in is some reduction in the memory used (as we’ve cut the needed memory in half for some parts of training) and an increase in throughput <em>should</em> be seen as well for larger models that can replace certain layers with FP8-enabled ones.",ye,$,we,v,ct="Currently three different backends for FP8 are supported (<code>TransformersEngine</code>, <code>torchao</code>, and <code>MS-AMP</code>), each with different capabilities and configurations.",Te,_,pt='To use either, the same core API is used. Just pass <code>mixed_precision=&quot;fp8&quot;</code> to either the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, during <code>accelerate config</code> when prompted about mixed precision, or as part of your <code>config.yaml</code> file in the <code>mixed_precision</code> key:',be,C,je,B,ht="By default, if <code>MS-AMP</code> is available in your environment, Accelerate will automatically utilize it as a backend. To specify it yourself (and customize other parts of the FP8 mixed precision setup), you can utilize one of the <code>RecipeKwargs</code> dataclasses such as <code>utils.AORecipeKwargs</code>, <code>utils.TERecipeKwargs</code>, or <code>utils.MSAMPRecipeKwargs</code>; you can also clarify it in your config <code>yaml</code>/during <code>accelerate launch</code>:",Ue,Z,Je,x,$e,k,ve,A,mt="Of the two, <code>MS-AMP</code> is traditionally the easier one to configure as there is only a single argument: the optimization level.",_e,F,dt="Currently two levels of optimization are supported in the Accelerate integration, <code>&quot;O1&quot;</code> and <code>&quot;O2&quot;</code> (using the letter ‘o’, not zero).",Ce,P,ft="<li><code>&quot;O1&quot;</code> will cast the weight gradients and <code>all_reduce</code> communications to happen in 8-bit, while the rest are done in 16 bit. This reduces the general GPU memory usage and speeds up communication bandwidths.</li> <li><code>&quot;O2&quot;</code> will also cast first-order optimizer states into 8 bit, while the second order states are in FP16. (Currently just the <code>Adam</code> optimizer is supported). This tries its best to minimize final accuracy degradation and will save the highest potential memory.</li>",Be,X,ut="To specify an optimization level, pass it to the <code>FP8KwargsHandler</code> by setting the <code>optimization_level</code> argument:",Ze,N,xe,Y,Mt="Or during <code>accelerate launch</code> via <code>--fp8_backend=msamp --fp8_opt_level=O2</code>",ke,H,gt="Similarly this can be set in your <code>config.yaml</code>:",Ae,I,Fe,W,Pe,G,yt='TransformersEngine has many options for customizing how and what FP8 calculations are performed. A full list of supported arguments and what they mean are available in <a href="https://docs.nvidia.com/deeplearning/transformer-engine/user-guide/api/common.html" rel="nofollow">NVIDIA’s documentation</a>, however they are restated as part of <code>FP8KwargsHandler</code>’s docstring for your convenience.',Xe,z,wt="Accelerate tries to set sensible defaults, but exploring and tweaking the various parameters yourself can lead to better performance potentially.",Ne,L,Tt="To use it, specify <code>backend=&quot;te&quot;</code> and modify any of the arguments you want as part of your kwarg handler:",Ye,S,He,V,bt="Or during <code>accelerate launch</code> via <code>--fp8_backend=te ...</code>. Use <code>accelerate launch --fp8_backend=te -h</code> to see relevent arguments.",Ie,R,jt="Similarly this can be set in your <code>config.yaml</code>:",We,E,Ge,Q,ze,q,Ut='<code>torchao</code> is a <a href="https://github.com/pytorch/ao/tree/main/torchao/float8" rel="nofollow">PyTorch-driven</a> hackable FP8 backend, aiming to be more approchable than the prior two engines. One of the core differences with <code>ao</code> compared to the prior two is that for numerical stability, it’s found to be generally better off keeping the first <em>and</em> last layers in the model at the regular precision (be it FP32 or BF16), and then the other layers quantized down to FP8. As a result, a config for <code>ao</code> looks a bit differently:',Le,K,Jt="<p>Note: this API is experimental and is subject to change</p>",Se,O,Ve,D,$t="To learn more about the specific parameters to be used, please see the official <code>torchao</code> repo.",Re,ee,Ee,te,vt=`We have examples showcasing training with FP8 both with accelerate and its underlying implementation available in the accelerate repo.
Currently we support scripts showcasing:`,Qe,ae,_t="<li>Single GPU</li> <li>Distributed Data Parallelism (Multi-GPU)</li> <li>Fully Sharded Data Parallelism</li> <li>DeepSpeed ZeRO 1 through 3</li>",qe,le,Ct='Find out more <a href="https://github.com/huggingface/accelerate/tree/main/benchmarks/fp8" rel="nofollow">here</a>',Ke,se,Oe,ne,Bt="To learn more about training in FP8 please check out the following resources:",De,ie,Zt='<li><a href="../concept_guides/low_precision_training">Our concept guide</a> detailing into more about both TransformersEngine and MS-AMP</li> <li><a href="https://docs.nvidia.com/deeplearning/transformer-engine/user-guide/api/common.html" rel="nofollow">The <code>transformers-engine</code> documentation</a></li> <li><a href="https://azure.github.io/MS-AMP/docs/" rel="nofollow">The <code>MS-AMP</code> documentation</a></li> <li><a href="https://github.com/pytorch/ao/tree/main/torchao/float8" rel="nofollow">The <code>torchao</code> documentation</a></li>',et,re,tt,ce,at;return y=new g({props:{title:"Low Precision Training Methods",local:"low-precision-training-methods",headingTag:"h1"}}),T=new g({props:{title:"What training on FP8 means",local:"what-training-on-fp8-means",headingTag:"h2"}}),$=new g({props:{title:"Configuring the Accelerator",local:"configuring-the-accelerator",headingTag:"h2"}}),C=new M({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnA4JTIyKQ==",highlighted:`from accelerate import Accelerator
<span class="hljs-attribute">accelerator</span> <span class="hljs-operator">=</span> Accelerator(mixed_precision<span class="hljs-operator">=</span><span class="hljs-string">&quot;fp8&quot;</span>)`,wrap:!1}}),Z=new M({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwTVNBTVBSZWNpcGVLd2FyZ3MlMEFrd2FyZ3MlMjAlM0QlMjAlNUJNU0FNUFJlY2lwZUt3YXJncygpJTVEJTBBJTIzJTIwT3IlMjB0byUyMHNwZWNpZnklMjB0aGUlMjBiYWNrZW5kJTIwYXMlMjAlNjBUcmFuc2Zvcm1lcnNFbmdpbmUlNjAlMjBldmVuJTIwaWYlMjBNUy1BTVAlMjBpcyUyMGluc3RhbGxlZCUwQSUyMyUyMGt3YXJncyUyMCUzRCUyMCU1QlRFUmVjaXBlS3dhcmdzKCklNUQlMEElMjMlMjBPciUyMHRvJTIwdXNlJTIwdG9yY2hhbyUwQSUyMyUyMGt3YXJncyUyMCUzRCUyMCU1QkFPUmVjaXBlS3dhcmdzKCklNUQlMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKG1peGVkX3ByZWNpc2lvbiUzRCUyMmZwOCUyMiUyQyUyMGt3YXJnX2hhbmRsZXJzJTNEa3dhcmdzKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import MSAMPRecipeKwargs
kwargs = [MSAMPRecipeKwargs()]
<span class="hljs-comment"># Or to specify the backend as \`TransformersEngine\` even if MS-AMP is installed</span>
<span class="hljs-comment"># kwargs = [TERecipeKwargs()]</span>
<span class="hljs-comment"># Or to use torchao</span>
<span class="hljs-comment"># kwargs = [AORecipeKwargs()]</span>
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),x=new M({props:{code:"bWl4ZWRfcHJlY2lzaW9uJTNBJTIwZnA4JTBBZnA4X2NvbmZpZyUzQSUwQSUyMCUyMGFtYXhfY29tcHV0ZV9hbGdvJTNBJTIwbWF4JTBBJTIwJTIwYW1heF9oaXN0b3J5X2xlbiUzQSUyMDEwMjQlMEElMjAlMjBiYWNrZW5kJTNBJTIwVEUlMEElMjAlMjBmcDhfZm9ybWF0JTNBJTIwSFlCUklEJTBBJTIwJTIwaW50ZXJ2YWwlM0ElMjAxJTBBJTIwJTIwbWFyZ2luJTNBJTIwMCUwQSUyMCUyMG92ZXJyaWRlX2xpbmVhcl9wcmVjaXNpb24lM0ElMjAoZmFsc2UlMkMlMjBmYWxzZSUyQyUyMGZhbHNlKSUwQSUyMCUyMHVzZV9hdXRvY2FzdF9kdXJpbmdfZXZhbCUzQSUyMGZhbHNl",highlighted:`<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">fp8</span>
<span class="hljs-attr">fp8_config:</span>
  <span class="hljs-attr">amax_compute_algo:</span> <span class="hljs-string">max</span>
  <span class="hljs-attr">amax_history_len:</span> <span class="hljs-number">1024</span>
  <span class="hljs-attr">backend:</span> <span class="hljs-string">TE</span>
  <span class="hljs-attr">fp8_format:</span> <span class="hljs-string">HYBRID</span>
  <span class="hljs-attr">interval:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">margin:</span> <span class="hljs-number">0</span>
  <span class="hljs-attr">override_linear_precision:</span> <span class="hljs-string">(false,</span> <span class="hljs-literal">false</span><span class="hljs-string">,</span> <span class="hljs-literal">false</span><span class="hljs-string">)</span>
  <span class="hljs-attr">use_autocast_during_eval:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),k=new g({props:{title:"Configuring MS-AMP",local:"configuring-ms-amp",headingTag:"h2"}}),N=new M({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwRlA4UmVjaXBlS3dhcmdzJTBBa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJtc2FtcCUyMiUyQyUyMG9wdGltaXphdGlvbl9sZXZlbCUzRCUyMk8yJTIyKSU1RCUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnA4JTIyJTJDJTIwa3dhcmdfaGFuZGxlcnMlM0Rrd2FyZ3Mp",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import FP8RecipeKwargs
kwargs = [FP8RecipeKwargs(<span class="hljs-attribute">backend</span>=<span class="hljs-string">&quot;msamp&quot;</span>, <span class="hljs-attribute">optimization_level</span>=<span class="hljs-string">&quot;O2&quot;</span>)]
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),I=new M({props:{code:"bWl4ZWRfcHJlY2lzaW9uJTNBJTIwZnA4JTBBZnA4X2NvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGJhY2tlbmQlM0ElMjBNU0FNUCUwQSUyMCUyMCUyMCUyMG9wdF9sZXZlbCUzQSUyME8y",highlighted:`<span class="hljs-symbol">mixed_precision:</span> fp8
<span class="hljs-symbol">fp8_config:</span>
<span class="hljs-symbol">    backend:</span> MSAMP
<span class="hljs-symbol">    opt_level:</span> O2`,wrap:!1}}),W=new g({props:{title:"Configuring TransformersEngine",local:"configuring-transformersengine",headingTag:"h2"}}),S=new M({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwRlA4UmVjaXBlS3dhcmdzJTBBa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJ0ZSUyMiUyQyUyMC4uLiklNUQlMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKG1peGVkX3ByZWNpc2lvbiUzRCUyMmZwOCUyMiUyQyUyMGt3YXJnX2hhbmRsZXJzJTNEa3dhcmdzKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import FP8RecipeKwargs
kwargs = [FP8RecipeKwargs(<span class="hljs-attribute">backend</span>=<span class="hljs-string">&quot;te&quot;</span>, <span class="hljs-built_in">..</span>.)]
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),E=new M({props:{code:"bWl4ZWRfcHJlY2lzaW9uJTNBJTIwZnA4JTBBZnA4X2NvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGFtYXhfY29tcHV0ZV9hbGdvJTNBJTIwbWF4JTBBJTIwJTIwJTIwJTIwYW1heF9oaXN0b3J5X2xlbiUzQSUyMDEwMjQlMEElMjAlMjAlMjAlMjBiYWNrZW5kJTNBJTIwVEUlMEElMjAlMjAlMjAlMjBmcDhfZm9ybWF0JTNBJTIwSFlCUklEJTBBJTIwJTIwJTIwJTIwaW50ZXJ2YWwlM0ElMjAxJTBBJTIwJTIwJTIwJTIwbWFyZ2luJTNBJTIwMCUwQSUyMCUyMCUyMCUyMG92ZXJyaWRlX2xpbmVhcl9wcmVjaXNpb24lM0ElMjAoZmFsc2UlMkMlMjBmYWxzZSUyQyUyMGZhbHNlKSUwQSUyMCUyMCUyMCUyMHVzZV9hdXRvY2FzdF9kdXJpbmdfZXZhbCUzQSUyMGZhbHNl",highlighted:`<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">fp8</span>
<span class="hljs-attr">fp8_config:</span>
    <span class="hljs-attr">amax_compute_algo:</span> <span class="hljs-string">max</span>
    <span class="hljs-attr">amax_history_len:</span> <span class="hljs-number">1024</span>
    <span class="hljs-attr">backend:</span> <span class="hljs-string">TE</span>
    <span class="hljs-attr">fp8_format:</span> <span class="hljs-string">HYBRID</span>
    <span class="hljs-attr">interval:</span> <span class="hljs-number">1</span>
    <span class="hljs-attr">margin:</span> <span class="hljs-number">0</span>
    <span class="hljs-attr">override_linear_precision:</span> <span class="hljs-string">(false,</span> <span class="hljs-literal">false</span><span class="hljs-string">,</span> <span class="hljs-literal">false</span><span class="hljs-string">)</span>
    <span class="hljs-attr">use_autocast_during_eval:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),Q=new g({props:{title:"Configuring torchao",local:"configuring-torchao",headingTag:"h2"}}),O=new M({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwQU9SZWNpcGVLd2FyZ3MlMEFrd2FyZ3MlMjAlM0QlMjAlNUJBT1JlY2lwZUt3YXJncygpJTVEJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDglMjIlMkMlMjBrd2FyZ19oYW5kbGVycyUzRGt3YXJncyk=",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import AORecipeKwargs
kwargs = [AORecipeKwargs()]
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),ee=new g({props:{title:"Example Zoo",local:"example-zoo",headingTag:"h2"}}),se=new g({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),re=new It({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/low_precision_training.md"}}),{c(){u=i("meta"),pe=s(),oe=i("p"),he=s(),c(y.$$.fragment),me=s(),w=i("p"),w.innerHTML=st,de=s(),c(T.$$.fragment),fe=s(),b=i("p"),b.innerHTML=nt,ue=s(),j=i("p"),j.textContent=it,Me=s(),U=i("ul"),U.innerHTML=rt,ge=s(),J=i("p"),J.innerHTML=ot,ye=s(),c($.$$.fragment),we=s(),v=i("p"),v.innerHTML=ct,Te=s(),_=i("p"),_.innerHTML=pt,be=s(),c(C.$$.fragment),je=s(),B=i("p"),B.innerHTML=ht,Ue=s(),c(Z.$$.fragment),Je=s(),c(x.$$.fragment),$e=s(),c(k.$$.fragment),ve=s(),A=i("p"),A.innerHTML=mt,_e=s(),F=i("p"),F.innerHTML=dt,Ce=s(),P=i("ul"),P.innerHTML=ft,Be=s(),X=i("p"),X.innerHTML=ut,Ze=s(),c(N.$$.fragment),xe=s(),Y=i("p"),Y.innerHTML=Mt,ke=s(),H=i("p"),H.innerHTML=gt,Ae=s(),c(I.$$.fragment),Fe=s(),c(W.$$.fragment),Pe=s(),G=i("p"),G.innerHTML=yt,Xe=s(),z=i("p"),z.textContent=wt,Ne=s(),L=i("p"),L.innerHTML=Tt,Ye=s(),c(S.$$.fragment),He=s(),V=i("p"),V.innerHTML=bt,Ie=s(),R=i("p"),R.innerHTML=jt,We=s(),c(E.$$.fragment),Ge=s(),c(Q.$$.fragment),ze=s(),q=i("p"),q.innerHTML=Ut,Le=s(),K=i("blockquote"),K.innerHTML=Jt,Se=s(),c(O.$$.fragment),Ve=s(),D=i("p"),D.innerHTML=$t,Re=s(),c(ee.$$.fragment),Ee=s(),te=i("p"),te.textContent=vt,Qe=s(),ae=i("ul"),ae.innerHTML=_t,qe=s(),le=i("p"),le.innerHTML=Ct,Ke=s(),c(se.$$.fragment),Oe=s(),ne=i("p"),ne.textContent=Bt,De=s(),ie=i("ul"),ie.innerHTML=Zt,et=s(),c(re.$$.fragment),tt=s(),ce=i("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);u=r(t,"META",{name:!0,content:!0}),t.forEach(a),pe=n(e),oe=r(e,"P",{}),xt(oe).forEach(a),he=n(e),p(y.$$.fragment,e),me=n(e),w=r(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-90ua6e"&&(w.innerHTML=st),de=n(e),p(T.$$.fragment,e),fe=n(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-wuhpuo"&&(b.innerHTML=nt),ue=n(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-10cwb11"&&(j.textContent=it),Me=n(e),U=r(e,"UL",{"data-svelte-h":!0}),o(U)!=="svelte-5d1df8"&&(U.innerHTML=rt),ge=n(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-149dy0g"&&(J.innerHTML=ot),ye=n(e),p($.$$.fragment,e),we=n(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1ytxd1j"&&(v.innerHTML=ct),Te=n(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-md67pg"&&(_.innerHTML=pt),be=n(e),p(C.$$.fragment,e),je=n(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-hoblda"&&(B.innerHTML=ht),Ue=n(e),p(Z.$$.fragment,e),Je=n(e),p(x.$$.fragment,e),$e=n(e),p(k.$$.fragment,e),ve=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-13jlsqr"&&(A.innerHTML=mt),_e=n(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-11bftkh"&&(F.innerHTML=dt),Ce=n(e),P=r(e,"UL",{"data-svelte-h":!0}),o(P)!=="svelte-ha185h"&&(P.innerHTML=ft),Be=n(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-wx6vs8"&&(X.innerHTML=ut),Ze=n(e),p(N.$$.fragment,e),xe=n(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-vo4vij"&&(Y.innerHTML=Mt),ke=n(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1n0fir7"&&(H.innerHTML=gt),Ae=n(e),p(I.$$.fragment,e),Fe=n(e),p(W.$$.fragment,e),Pe=n(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1tlihxp"&&(G.innerHTML=yt),Xe=n(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-wvn4fr"&&(z.textContent=wt),Ne=n(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-8khoko"&&(L.innerHTML=Tt),Ye=n(e),p(S.$$.fragment,e),He=n(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-99qxte"&&(V.innerHTML=bt),Ie=n(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1n0fir7"&&(R.innerHTML=jt),We=n(e),p(E.$$.fragment,e),Ge=n(e),p(Q.$$.fragment,e),ze=n(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-13u4x7b"&&(q.innerHTML=Ut),Le=n(e),K=r(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(K)!=="svelte-rg03zf"&&(K.innerHTML=Jt),Se=n(e),p(O.$$.fragment,e),Ve=n(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1qqyqot"&&(D.innerHTML=$t),Re=n(e),p(ee.$$.fragment,e),Ee=n(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1ay0trc"&&(te.textContent=vt),Qe=n(e),ae=r(e,"UL",{"data-svelte-h":!0}),o(ae)!=="svelte-1affbo7"&&(ae.innerHTML=_t),qe=n(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-sau342"&&(le.innerHTML=Ct),Ke=n(e),p(se.$$.fragment,e),Oe=n(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-t5s4ol"&&(ne.textContent=Bt),De=n(e),ie=r(e,"UL",{"data-svelte-h":!0}),o(ie)!=="svelte-1gt16sy"&&(ie.innerHTML=Zt),et=n(e),p(re.$$.fragment,e),tt=n(e),ce=r(e,"P",{}),xt(ce).forEach(a),this.h()},h(){kt(u,"name","hf:doc:metadata"),kt(u,"content",Gt)},m(e,t){Ht(document.head,u),l(e,pe,t),l(e,oe,t),l(e,he,t),h(y,e,t),l(e,me,t),l(e,w,t),l(e,de,t),h(T,e,t),l(e,fe,t),l(e,b,t),l(e,ue,t),l(e,j,t),l(e,Me,t),l(e,U,t),l(e,ge,t),l(e,J,t),l(e,ye,t),h($,e,t),l(e,we,t),l(e,v,t),l(e,Te,t),l(e,_,t),l(e,be,t),h(C,e,t),l(e,je,t),l(e,B,t),l(e,Ue,t),h(Z,e,t),l(e,Je,t),h(x,e,t),l(e,$e,t),h(k,e,t),l(e,ve,t),l(e,A,t),l(e,_e,t),l(e,F,t),l(e,Ce,t),l(e,P,t),l(e,Be,t),l(e,X,t),l(e,Ze,t),h(N,e,t),l(e,xe,t),l(e,Y,t),l(e,ke,t),l(e,H,t),l(e,Ae,t),h(I,e,t),l(e,Fe,t),h(W,e,t),l(e,Pe,t),l(e,G,t),l(e,Xe,t),l(e,z,t),l(e,Ne,t),l(e,L,t),l(e,Ye,t),h(S,e,t),l(e,He,t),l(e,V,t),l(e,Ie,t),l(e,R,t),l(e,We,t),h(E,e,t),l(e,Ge,t),h(Q,e,t),l(e,ze,t),l(e,q,t),l(e,Le,t),l(e,K,t),l(e,Se,t),h(O,e,t),l(e,Ve,t),l(e,D,t),l(e,Re,t),h(ee,e,t),l(e,Ee,t),l(e,te,t),l(e,Qe,t),l(e,ae,t),l(e,qe,t),l(e,le,t),l(e,Ke,t),h(se,e,t),l(e,Oe,t),l(e,ne,t),l(e,De,t),l(e,ie,t),l(e,et,t),h(re,e,t),l(e,tt,t),l(e,ce,t),at=!0},p:Ft,i(e){at||(m(y.$$.fragment,e),m(T.$$.fragment,e),m($.$$.fragment,e),m(C.$$.fragment,e),m(Z.$$.fragment,e),m(x.$$.fragment,e),m(k.$$.fragment,e),m(N.$$.fragment,e),m(I.$$.fragment,e),m(W.$$.fragment,e),m(S.$$.fragment,e),m(E.$$.fragment,e),m(Q.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(re.$$.fragment,e),at=!0)},o(e){d(y.$$.fragment,e),d(T.$$.fragment,e),d($.$$.fragment,e),d(C.$$.fragment,e),d(Z.$$.fragment,e),d(x.$$.fragment,e),d(k.$$.fragment,e),d(N.$$.fragment,e),d(I.$$.fragment,e),d(W.$$.fragment,e),d(S.$$.fragment,e),d(E.$$.fragment,e),d(Q.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),at=!1},d(e){e&&(a(pe),a(oe),a(he),a(me),a(w),a(de),a(fe),a(b),a(ue),a(j),a(Me),a(U),a(ge),a(J),a(ye),a(we),a(v),a(Te),a(_),a(be),a(je),a(B),a(Ue),a(Je),a($e),a(ve),a(A),a(_e),a(F),a(Ce),a(P),a(Be),a(X),a(Ze),a(xe),a(Y),a(ke),a(H),a(Ae),a(Fe),a(Pe),a(G),a(Xe),a(z),a(Ne),a(L),a(Ye),a(He),a(V),a(Ie),a(R),a(We),a(Ge),a(ze),a(q),a(Le),a(K),a(Se),a(Ve),a(D),a(Re),a(Ee),a(te),a(Qe),a(ae),a(qe),a(le),a(Ke),a(Oe),a(ne),a(De),a(ie),a(et),a(tt),a(ce)),a(u),f(y,e),f(T,e),f($,e),f(C,e),f(Z,e),f(x,e),f(k,e),f(N,e),f(I,e),f(W,e),f(S,e),f(E,e),f(Q,e),f(O,e),f(ee,e),f(se,e),f(re,e)}}}const Gt='{"title":"Low Precision Training Methods","local":"low-precision-training-methods","sections":[{"title":"What training on FP8 means","local":"what-training-on-fp8-means","sections":[],"depth":2},{"title":"Configuring the Accelerator","local":"configuring-the-accelerator","sections":[],"depth":2},{"title":"Configuring MS-AMP","local":"configuring-ms-amp","sections":[],"depth":2},{"title":"Configuring TransformersEngine","local":"configuring-transformersengine","sections":[],"depth":2},{"title":"Configuring torchao","local":"configuring-torchao","sections":[],"depth":2},{"title":"Example Zoo","local":"example-zoo","sections":[],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function zt(lt){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Et extends Xt{constructor(u){super(),Nt(this,u,zt,Wt,At,{})}}export{Et as component};
