import{s as Gs,n as Qs,o as Xs}from"../chunks/scheduler.b108d059.js";import{S as Zs,i as ed,g as d,s as o,r as p,A as td,h as n,f as t,c as s,j as a,u as c,x as r,k as u,y as ld,a as i,v as h,d as f,t as m,w as b}from"../chunks/index.008de539.js";import{H as _}from"../chunks/Heading.88bfeb84.js";function id(Bo){let T,Ft,Lt,xt,$,wt,v,At,g,Ko='Utility functions to interact with the Hugging Face Hub (<a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>)',jt,P,No='<li><a href="#module_utils/hub">utils/hub</a><ul><li><em>static</em><ul><li><a href="#module_utils/hub.getFile"><code>.getFile(urlOrPath)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response)&gt;</code></li> <li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options])</code></a> ⇒ <code>Promise</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li></ul></li> <li><a href="#module_utils/hub.getModelJSON"><code>.getModelJSON(modelPath, fileName, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+_CONTENT_TYPE_MAP"><code>._CONTENT_TYPE_MAP</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response)</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li> <li><a href="#module_utils/hub..isValidHttpUrl"><code>~isValidHttpUrl(string, [validHosts])</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/hub..handleError"><code>~handleError(status, remoteURL, fatal)</code></a> ⇒ <code>null</code></li> <li><a href="#module_utils/hub..tryCache"><code>~tryCache(cache, ...names)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code></li> <li><a href="#module_utils/hub..readResponse"><code>~readResponse(response, progress_callback)</code></a> ⇒ <code>Promise.&lt;Uint8Array&gt;</code></li> <li><a href="#module_utils/hub..pathJoin"><code>~pathJoin(...parts)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/hub..PretrainedOptions"><code>~PretrainedOptions</code></a> : <code>Object</code></li></ul></li></ul></li>',Et,Ot,Ut,R,Bt,y,Kt,C,qo="Helper function to get a file, using either the Fetch API or FileSystem API.",Nt,H,ko='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response)&gt;</code> - A promise that resolves to a FileResponse object (if the file is retrieved using the FileSystem API), or a Response object (if the file is retrieved using the Fetch API).',qt,L,So="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>urlOrPath</td><td><code>URL</code> | <code>string</code></td><td><p>The URL/path of the file to get.</p></td></tr></tbody>",kt,St,It,M,Jt,F,zt,x,Io=`Retrieves a file from either a remote URL using the Fetch API or from the local file system using the FileSystem API.
If the filesystem is available and <code>env.useCache = true</code>, the file will be downloaded and cached.`,Dt,w,Jo='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise</code> - A Promise that resolves with the file content as a buffer.<br/> <strong>Throws</strong>:',Wt,A,zo="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",Yt,j,Do="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>path_or_repo_id</td><td><code>string</code></td><td></td><td><p>This can be either:</p> <ul><li>a string, the <em>model id</em> of a model repo on huggingface.co.</li> <li>a path to a <em>directory</em> potentially containing the file.</li></ul></td> </tr><tr><td>filename</td><td><code>string</code></td><td></td><td><p>The name of the file to locate in <code>path_or_repo</code>.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",Vt,E,Wo='<li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options])</code></a> ⇒ <code>Promise</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li></ul></li>',Gt,Qt,Xt,O,Zt,U,el,B,Yo='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',tl,ll,il,K,ol,N,sl,q,Vo='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',dl,nl,rl,k,ul,S,al,I,Go="Fetches a JSON file from a given path and file name.",pl,J,Qo='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - The JSON data parsed into a JavaScript object.<br/> <strong>Throws</strong>:',cl,z,Xo="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",hl,D,Zo="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>modelPath</td><td><code>string</code></td><td></td><td><p>The path to the directory containing the file.</p></td> </tr><tr><td>fileName</td><td><code>string</code></td><td></td><td><p>The name of the file to fetch.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",fl,ml,bl,W,_l,Y,Tl,V,es='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',$l,G,ts='<li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+_CONTENT_TYPE_MAP"><code>._CONTENT_TYPE_MAP</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',vl,gl,Pl,Q,Rl,X,yl,Z,ls="Creates a new <code>FileResponse</code> object.",Cl,ee,is="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>filePath</td><td><code>string</code> | <code>URL</code></td></tr></tbody>",Hl,Ll,Ml,te,Fl,le,xl,ie,os="Mapping from file extensions to MIME types.",wl,oe,ss='<strong>Kind</strong>: instance property of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a>',Al,jl,El,se,Ol,de,Ul,ne,ds=`Updates the ‘content-type’ header property of the response based on the extension of
the file specified by the filePath property of the current object.`,Bl,re,ns='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a>',Kl,Nl,ql,ue,kl,ae,Sl,pe,rs="Clone the current FileResponse object.",Il,ce,us='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>FileResponse</code> - A new FileResponse object with the same properties as the current object.',Jl,zl,Dl,he,Wl,fe,Yl,me,as=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with an ArrayBuffer containing the file’s contents.`,Vl,be,ps='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ArrayBuffer&gt;</code> - A Promise that resolves with an ArrayBuffer containing the file’s contents.<br/> <strong>Throws</strong>:',Gl,_e,cs="<li><code>Error</code> If the file cannot be read.</li>",Ql,Xl,Zl,Te,ei,$e,ti,ve,hs=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a Blob containing the file’s contents.`,li,ge,fs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Blob&gt;</code> - A Promise that resolves with a Blob containing the file’s contents.<br/> <strong>Throws</strong>:',ii,Pe,ms="<li><code>Error</code> If the file cannot be read.</li>",oi,si,di,Re,ni,ye,ri,Ce,bs=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a string containing the file’s contents.`,ui,He,_s='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;string&gt;</code> - A Promise that resolves with a string containing the file’s contents.<br/> <strong>Throws</strong>:',ai,Le,Ts="<li><code>Error</code> If the file cannot be read.</li>",pi,ci,hi,Me,fi,Fe,mi,xe,$s=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a parsed JavaScript object containing the file’s contents.`,bi,we,vs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves with a parsed JavaScript object containing the file’s contents.<br/> <strong>Throws</strong>:',_i,Ae,gs="<li><code>Error</code> If the file cannot be read.</li>",Ti,$i,vi,je,gi,Ee,Pi,Oe,Ps='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',Ri,Ue,Rs='<li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response)</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li>',yi,Ci,Hi,Be,Li,Ke,Mi,Ne,ys="Instantiate a <code>FileCache</code> object.",Fi,qe,Cs="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td></tr></tbody>",xi,wi,Ai,ke,ji,Se,Ei,Ie,Hs="Checks whether the given request is in the cache.",Oi,Je,Ls='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',Ui,ze,Ms="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td></tr></tbody>",Bi,Ki,Ni,De,qi,We,ki,Ye,Fs="Adds the given response to the cache.",Si,Ve,xs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',Ii,Ge,ws="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td> </tr><tr><td>response</td><td><code>Response</code> | <code>FileResponse</code></td></tr></tbody>",Ji,zi,Di,Qe,Wi,Xe,Yi,Ze,As="Determines whether the given string is a valid HTTP or HTTPS URL.",Vi,et,js='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - True if the string is a valid HTTP or HTTPS URL, false otherwise.',Gi,tt,Es="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>string</td><td><code>string</code> | <code>URL</code></td><td></td><td><p>The string to test for validity as an HTTP or HTTPS URL.</p></td> </tr><tr><td>[validHosts]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid hostnames. If specified, the URL&#39;s hostname must be in this list.</p></td></tr></tbody>",Qi,Xi,Zi,lt,eo,it,to,ot,Os="Helper method to handle fatal errors that occur while trying to load a file from the Hugging Face Hub.",lo,st,Us='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>null</code> - Returns <code>null</code> if <code>fatal = true</code>.<br/> <strong>Throws</strong>:',io,dt,Bs="<li><code>Error</code> If `fatal = false`.</li>",oo,nt,Ks="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>status</td><td><code>number</code></td><td><p>The HTTP status code of the error.</p></td> </tr><tr><td>remoteURL</td><td><code>string</code></td><td><p>The URL of the file that could not be loaded.</p></td> </tr><tr><td>fatal</td><td><code>boolean</code></td><td><p>Whether to raise an error if the file could not be loaded.</p></td></tr></tbody>",so,no,ro,rt,uo,ut,ao,at,Ns='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code> - The item from the cache, or undefined if not found.',po,pt,qs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>cache</td><td><code>FileCache</code> | <code>Cache</code></td><td><p>The cache to search</p></td> </tr><tr><td>...names</td><td><code>Array.&lt;string&gt;</code></td><td><p>The names of the item to search for</p></td></tr></tbody>",co,ho,fo,ct,mo,ht,bo,ft,ks="Read and track progress when reading a Response object",_o,mt,Ss='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Uint8Array&gt;</code> - A Promise that resolves with the Uint8Array buffer',To,bt,Is="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>response</td><td><code>any</code></td><td><p>The Response object to read</p></td> </tr><tr><td>progress_callback</td><td><code>function</code></td><td><p>The function to call with progress updates</p></td></tr></tbody>",$o,vo,go,_t,Po,Tt,Ro,$t,Js="Joins multiple parts of a path into a single path, while handling leading and trailing slashes.",yo,vt,zs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>string</code> - A string representing the joined path.',Co,gt,Ds="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...parts</td><td><code>string</code></td><td><p>Multiple parts of a path.</p></td></tr></tbody>",Ho,Lo,Mo,Pt,Fo,Rt,xo,yt,Ws="Options for loading a pretrained model.",wo,Ct,Ys='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',Ao,Ht,Vs=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[quantized]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to load the 8-bit quantized version of the model (only applicable when loading model files).</p></td> </tr><tr><td>[progress_callback]</td><td><code>function</code></td><td><code></code></td><td><p>If specified, this function will be called during model construction, to provide the user with progress updates.</p></td> </tr><tr><td>[config]</td><td><code>Object</code></td><td><code></code></td><td><p>Configuration for the model to use instead of an automatically loaded configuration. Configuration can be automatically loaded when:</p> <ul><li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained model).</li> <li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a configuration JSON file named <em>config.json</em> is found in the directory.</li></ul></td> </tr><tr><td>[cache_dir]</td><td><code>string</code></td><td><code>null</code></td><td><p>Path to a directory in which a downloaded pretrained model configuration should be cached if the standard cache should not be used.</p></td> </tr><tr><td>[local_files_only]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to only look at local files (e.g., not try downloading the model).</p></td> </tr><tr><td>[revision]</td><td><code>string</code></td><td><code>&quot;&#39;main&#39;&quot;</code></td><td><p>The specific model version to use. It can be a branch name, a tag name, or a commit id,
since we use a git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier allowed by git.
NOTE: This setting is ignored for local requests.</p></td> </tr><tr><td>[model_file_name]</td><td><code>string</code></td><td><code>null</code></td><td><p>If specified, load the model with this name (excluding the .onnx suffix). Currently only valid for encoder- or decoder-only models.</p></td></tr></tbody>`,jo,Eo,Oo,Mt,Uo;return v=new _({props:{title:"utils/hub",local:"utilshub",headingTag:"h1"}}),y=new _({props:{title:"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>",local:"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code",headingTag:"h2"}}),F=new _({props:{title:"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options]) ⇒ <code> Promise </code>",local:"utilshubgetmodelfilepathorrepoid-filename-fatal-options--code-promise-code",headingTag:"h2"}}),U=new _({props:{title:"getModelFile~cacheKey : <code> string </code>",local:"getmodelfilecachekey--code-string-code",headingTag:"h3"}}),N=new _({props:{title:"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>",local:"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code",headingTag:"h3"}}),S=new _({props:{title:"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>",local:"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code",headingTag:"h2"}}),Y=new _({props:{title:"utils/hub~FileResponse",local:"utilshubfileresponse",headingTag:"h2"}}),X=new _({props:{title:"new FileResponse(filePath)",local:"new-fileresponsefilepath",headingTag:"h3"}}),le=new _({props:{title:"fileResponse._CONTENT_TYPE_MAP",local:"fileresponsecontenttypemap",headingTag:"h3"}}),de=new _({props:{title:"fileResponse.updateContentType() ⇒ <code> void </code>",local:"fileresponseupdatecontenttype--code-void-code",headingTag:"h3"}}),ae=new _({props:{title:"fileResponse.clone() ⇒ <code> FileResponse </code>",local:"fileresponseclone--code-fileresponse-code",headingTag:"h3"}}),fe=new _({props:{title:"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>",local:"fileresponsearraybuffer--code-promise--arraybuffer--code",headingTag:"h3"}}),$e=new _({props:{title:"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>",local:"fileresponseblob--code-promise--blob--code",headingTag:"h3"}}),ye=new _({props:{title:"fileResponse.text() ⇒ <code> Promise. < string > </code>",local:"fileresponsetext--code-promise--string--code",headingTag:"h3"}}),Fe=new _({props:{title:"fileResponse.json() ⇒ <code> Promise. < Object > </code>",local:"fileresponsejson--code-promise--object--code",headingTag:"h3"}}),Ee=new _({props:{title:"utils/hub~FileCache",local:"utilshubfilecache",headingTag:"h2"}}),Ke=new _({props:{title:"new FileCache(path)",local:"new-filecachepath",headingTag:"h3"}}),Se=new _({props:{title:"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>",local:"filecachematchrequest--code-promise--fileresponseundefined--code",headingTag:"h3"}}),We=new _({props:{title:"fileCache.put(request, response) ⇒ <code> Promise. < void > </code>",local:"filecacheputrequest-response--code-promise--void--code",headingTag:"h3"}}),Xe=new _({props:{title:"utils/hub~isValidHttpUrl(string, [validHosts]) ⇒ <code> boolean </code>",local:"utilshubisvalidhttpurlstring-validhosts--code-boolean-code",headingTag:"h2"}}),it=new _({props:{title:"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>",local:"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code",headingTag:"h2"}}),ut=new _({props:{title:"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>",local:"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code",headingTag:"h2"}}),ht=new _({props:{title:"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>",local:"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code",headingTag:"h2"}}),Tt=new _({props:{title:"utils/hub~pathJoin(...parts) ⇒ <code> string </code>",local:"utilshubpathjoinparts--code-string-code",headingTag:"h2"}}),Rt=new _({props:{title:"utils/hub~PretrainedOptions : <code> Object </code>",local:"utilshubpretrainedoptions--code-object-code",headingTag:"h2"}}),{c(){T=d("meta"),Ft=o(),Lt=d("p"),xt=o(),$=d("a"),wt=o(),p(v.$$.fragment),At=o(),g=d("p"),g.innerHTML=Ko,jt=o(),P=d("ul"),P.innerHTML=No,Et=o(),Ot=d("hr"),Ut=o(),R=d("a"),Bt=o(),p(y.$$.fragment),Kt=o(),C=d("p"),C.textContent=qo,Nt=o(),H=d("p"),H.innerHTML=ko,qt=o(),L=d("table"),L.innerHTML=So,kt=o(),St=d("hr"),It=o(),M=d("a"),Jt=o(),p(F.$$.fragment),zt=o(),x=d("p"),x.innerHTML=Io,Dt=o(),w=d("p"),w.innerHTML=Jo,Wt=o(),A=d("ul"),A.innerHTML=zo,Yt=o(),j=d("table"),j.innerHTML=Do,Vt=o(),E=d("ul"),E.innerHTML=Wo,Gt=o(),Qt=d("hr"),Xt=o(),O=d("a"),Zt=o(),p(U.$$.fragment),el=o(),B=d("p"),B.innerHTML=Yo,tl=o(),ll=d("hr"),il=o(),K=d("a"),ol=o(),p(N.$$.fragment),sl=o(),q=d("p"),q.innerHTML=Vo,dl=o(),nl=d("hr"),rl=o(),k=d("a"),ul=o(),p(S.$$.fragment),al=o(),I=d("p"),I.textContent=Go,pl=o(),J=d("p"),J.innerHTML=Qo,cl=o(),z=d("ul"),z.innerHTML=Xo,hl=o(),D=d("table"),D.innerHTML=Zo,fl=o(),ml=d("hr"),bl=o(),W=d("a"),_l=o(),p(Y.$$.fragment),Tl=o(),V=d("p"),V.innerHTML=es,$l=o(),G=d("ul"),G.innerHTML=ts,vl=o(),gl=d("hr"),Pl=o(),Q=d("a"),Rl=o(),p(X.$$.fragment),yl=o(),Z=d("p"),Z.innerHTML=ls,Cl=o(),ee=d("table"),ee.innerHTML=is,Hl=o(),Ll=d("hr"),Ml=o(),te=d("a"),Fl=o(),p(le.$$.fragment),xl=o(),ie=d("p"),ie.textContent=os,wl=o(),oe=d("p"),oe.innerHTML=ss,Al=o(),jl=d("hr"),El=o(),se=d("a"),Ol=o(),p(de.$$.fragment),Ul=o(),ne=d("p"),ne.textContent=ds,Bl=o(),re=d("p"),re.innerHTML=ns,Kl=o(),Nl=d("hr"),ql=o(),ue=d("a"),kl=o(),p(ae.$$.fragment),Sl=o(),pe=d("p"),pe.textContent=rs,Il=o(),ce=d("p"),ce.innerHTML=us,Jl=o(),zl=d("hr"),Dl=o(),he=d("a"),Wl=o(),p(fe.$$.fragment),Yl=o(),me=d("p"),me.textContent=as,Vl=o(),be=d("p"),be.innerHTML=ps,Gl=o(),_e=d("ul"),_e.innerHTML=cs,Ql=o(),Xl=d("hr"),Zl=o(),Te=d("a"),ei=o(),p($e.$$.fragment),ti=o(),ve=d("p"),ve.textContent=hs,li=o(),ge=d("p"),ge.innerHTML=fs,ii=o(),Pe=d("ul"),Pe.innerHTML=ms,oi=o(),si=d("hr"),di=o(),Re=d("a"),ni=o(),p(ye.$$.fragment),ri=o(),Ce=d("p"),Ce.textContent=bs,ui=o(),He=d("p"),He.innerHTML=_s,ai=o(),Le=d("ul"),Le.innerHTML=Ts,pi=o(),ci=d("hr"),hi=o(),Me=d("a"),fi=o(),p(Fe.$$.fragment),mi=o(),xe=d("p"),xe.textContent=$s,bi=o(),we=d("p"),we.innerHTML=vs,_i=o(),Ae=d("ul"),Ae.innerHTML=gs,Ti=o(),$i=d("hr"),vi=o(),je=d("a"),gi=o(),p(Ee.$$.fragment),Pi=o(),Oe=d("p"),Oe.innerHTML=Ps,Ri=o(),Ue=d("ul"),Ue.innerHTML=Rs,yi=o(),Ci=d("hr"),Hi=o(),Be=d("a"),Li=o(),p(Ke.$$.fragment),Mi=o(),Ne=d("p"),Ne.innerHTML=ys,Fi=o(),qe=d("table"),qe.innerHTML=Cs,xi=o(),wi=d("hr"),Ai=o(),ke=d("a"),ji=o(),p(Se.$$.fragment),Ei=o(),Ie=d("p"),Ie.textContent=Hs,Oi=o(),Je=d("p"),Je.innerHTML=Ls,Ui=o(),ze=d("table"),ze.innerHTML=Ms,Bi=o(),Ki=d("hr"),Ni=o(),De=d("a"),qi=o(),p(We.$$.fragment),ki=o(),Ye=d("p"),Ye.textContent=Fs,Si=o(),Ve=d("p"),Ve.innerHTML=xs,Ii=o(),Ge=d("table"),Ge.innerHTML=ws,Ji=o(),zi=d("hr"),Di=o(),Qe=d("a"),Wi=o(),p(Xe.$$.fragment),Yi=o(),Ze=d("p"),Ze.textContent=As,Vi=o(),et=d("p"),et.innerHTML=js,Gi=o(),tt=d("table"),tt.innerHTML=Es,Qi=o(),Xi=d("hr"),Zi=o(),lt=d("a"),eo=o(),p(it.$$.fragment),to=o(),ot=d("p"),ot.textContent=Os,lo=o(),st=d("p"),st.innerHTML=Us,io=o(),dt=d("ul"),dt.innerHTML=Bs,oo=o(),nt=d("table"),nt.innerHTML=Ks,so=o(),no=d("hr"),ro=o(),rt=d("a"),uo=o(),p(ut.$$.fragment),ao=o(),at=d("p"),at.innerHTML=Ns,po=o(),pt=d("table"),pt.innerHTML=qs,co=o(),ho=d("hr"),fo=o(),ct=d("a"),mo=o(),p(ht.$$.fragment),bo=o(),ft=d("p"),ft.textContent=ks,_o=o(),mt=d("p"),mt.innerHTML=Ss,To=o(),bt=d("table"),bt.innerHTML=Is,$o=o(),vo=d("hr"),go=o(),_t=d("a"),Po=o(),p(Tt.$$.fragment),Ro=o(),$t=d("p"),$t.textContent=Js,yo=o(),vt=d("p"),vt.innerHTML=zs,Co=o(),gt=d("table"),gt.innerHTML=Ds,Ho=o(),Lo=d("hr"),Mo=o(),Pt=d("a"),Fo=o(),p(Rt.$$.fragment),xo=o(),yt=d("p"),yt.textContent=Ws,wo=o(),Ct=d("p"),Ct.innerHTML=Ys,Ao=o(),Ht=d("table"),Ht.innerHTML=Vs,jo=o(),Eo=d("hr"),Oo=o(),Mt=d("p"),this.h()},l(e){const l=td("svelte-u9bgzb",document.head);T=n(l,"META",{name:!0,content:!0}),l.forEach(t),Ft=s(e),Lt=n(e,"P",{}),a(Lt).forEach(t),xt=s(e),$=n(e,"A",{id:!0,class:!0}),a($).forEach(t),wt=s(e),c(v.$$.fragment,e),At=s(e),g=n(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1jxl61c"&&(g.innerHTML=Ko),jt=s(e),P=n(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-1tgln14"&&(P.innerHTML=No),Et=s(e),Ot=n(e,"HR",{}),Ut=s(e),R=n(e,"A",{id:!0,class:!0}),a(R).forEach(t),Bt=s(e),c(y.$$.fragment,e),Kt=s(e),C=n(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-10mshiw"&&(C.textContent=qo),Nt=s(e),H=n(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1jj7eze"&&(H.innerHTML=ko),qt=s(e),L=n(e,"TABLE",{"data-svelte-h":!0}),r(L)!=="svelte-pbwhgs"&&(L.innerHTML=So),kt=s(e),St=n(e,"HR",{}),It=s(e),M=n(e,"A",{id:!0,class:!0}),a(M).forEach(t),Jt=s(e),c(F.$$.fragment,e),zt=s(e),x=n(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1l3bjq3"&&(x.innerHTML=Io),Dt=s(e),w=n(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1rwfklh"&&(w.innerHTML=Jo),Wt=s(e),A=n(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-jl6z4b"&&(A.innerHTML=zo),Yt=s(e),j=n(e,"TABLE",{"data-svelte-h":!0}),r(j)!=="svelte-1o6u9nv"&&(j.innerHTML=Do),Vt=s(e),E=n(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-4lalsu"&&(E.innerHTML=Wo),Gt=s(e),Qt=n(e,"HR",{}),Xt=s(e),O=n(e,"A",{id:!0,class:!0}),a(O).forEach(t),Zt=s(e),c(U.$$.fragment,e),el=s(e),B=n(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ys3w38"&&(B.innerHTML=Yo),tl=s(e),ll=n(e,"HR",{}),il=s(e),K=n(e,"A",{id:!0,class:!0}),a(K).forEach(t),ol=s(e),c(N.$$.fragment,e),sl=s(e),q=n(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1ys3w38"&&(q.innerHTML=Vo),dl=s(e),nl=n(e,"HR",{}),rl=s(e),k=n(e,"A",{id:!0,class:!0}),a(k).forEach(t),ul=s(e),c(S.$$.fragment,e),al=s(e),I=n(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1en2wh4"&&(I.textContent=Go),pl=s(e),J=n(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1l5qo0i"&&(J.innerHTML=Qo),cl=s(e),z=n(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-jl6z4b"&&(z.innerHTML=Xo),hl=s(e),D=n(e,"TABLE",{"data-svelte-h":!0}),r(D)!=="svelte-1iel3tk"&&(D.innerHTML=Zo),fl=s(e),ml=n(e,"HR",{}),bl=s(e),W=n(e,"A",{id:!0,class:!0}),a(W).forEach(t),_l=s(e),c(Y.$$.fragment,e),Tl=s(e),V=n(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-16uuos4"&&(V.innerHTML=es),$l=s(e),G=n(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-165ijwb"&&(G.innerHTML=ts),vl=s(e),gl=n(e,"HR",{}),Pl=s(e),Q=n(e,"A",{id:!0,class:!0}),a(Q).forEach(t),Rl=s(e),c(X.$$.fragment,e),yl=s(e),Z=n(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-zzl0lp"&&(Z.innerHTML=ls),Cl=s(e),ee=n(e,"TABLE",{"data-svelte-h":!0}),r(ee)!=="svelte-1y2k5ta"&&(ee.innerHTML=is),Hl=s(e),Ll=n(e,"HR",{}),Ml=s(e),te=n(e,"A",{id:!0,class:!0}),a(te).forEach(t),Fl=s(e),c(le.$$.fragment,e),xl=s(e),ie=n(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-15u13r6"&&(ie.textContent=os),wl=s(e),oe=n(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-g2qxul"&&(oe.innerHTML=ss),Al=s(e),jl=n(e,"HR",{}),El=s(e),se=n(e,"A",{id:!0,class:!0}),a(se).forEach(t),Ol=s(e),c(de.$$.fragment,e),Ul=s(e),ne=n(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1u1tjx3"&&(ne.textContent=ds),Bl=s(e),re=n(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1sowe6d"&&(re.innerHTML=ns),Kl=s(e),Nl=n(e,"HR",{}),ql=s(e),ue=n(e,"A",{id:!0,class:!0}),a(ue).forEach(t),kl=s(e),c(ae.$$.fragment,e),Sl=s(e),pe=n(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-d8j2xp"&&(pe.textContent=rs),Il=s(e),ce=n(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-8jlahc"&&(ce.innerHTML=us),Jl=s(e),zl=n(e,"HR",{}),Dl=s(e),he=n(e,"A",{id:!0,class:!0}),a(he).forEach(t),Wl=s(e),c(fe.$$.fragment,e),Yl=s(e),me=n(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1a8fecx"&&(me.textContent=as),Vl=s(e),be=n(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-v2f2ae"&&(be.innerHTML=ps),Gl=s(e),_e=n(e,"UL",{"data-svelte-h":!0}),r(_e)!=="svelte-1f4f3jw"&&(_e.innerHTML=cs),Ql=s(e),Xl=n(e,"HR",{}),Zl=s(e),Te=n(e,"A",{id:!0,class:!0}),a(Te).forEach(t),ei=s(e),c($e.$$.fragment,e),ti=s(e),ve=n(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-h3zv97"&&(ve.textContent=hs),li=s(e),ge=n(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1e723py"&&(ge.innerHTML=fs),ii=s(e),Pe=n(e,"UL",{"data-svelte-h":!0}),r(Pe)!=="svelte-1f4f3jw"&&(Pe.innerHTML=ms),oi=s(e),si=n(e,"HR",{}),di=s(e),Re=n(e,"A",{id:!0,class:!0}),a(Re).forEach(t),ni=s(e),c(ye.$$.fragment,e),ri=s(e),Ce=n(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-jd4zuh"&&(Ce.textContent=bs),ui=s(e),He=n(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1ozy582"&&(He.innerHTML=_s),ai=s(e),Le=n(e,"UL",{"data-svelte-h":!0}),r(Le)!=="svelte-1f4f3jw"&&(Le.innerHTML=Ts),pi=s(e),ci=n(e,"HR",{}),hi=s(e),Me=n(e,"A",{id:!0,class:!0}),a(Me).forEach(t),fi=s(e),c(Fe.$$.fragment,e),mi=s(e),xe=n(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-cd4397"&&(xe.textContent=$s),bi=s(e),we=n(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-j83voe"&&(we.innerHTML=vs),_i=s(e),Ae=n(e,"UL",{"data-svelte-h":!0}),r(Ae)!=="svelte-1f4f3jw"&&(Ae.innerHTML=gs),Ti=s(e),$i=n(e,"HR",{}),vi=s(e),je=n(e,"A",{id:!0,class:!0}),a(je).forEach(t),gi=s(e),c(Ee.$$.fragment,e),Pi=s(e),Oe=n(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-16uuos4"&&(Oe.innerHTML=Ps),Ri=s(e),Ue=n(e,"UL",{"data-svelte-h":!0}),r(Ue)!=="svelte-136j1yr"&&(Ue.innerHTML=Rs),yi=s(e),Ci=n(e,"HR",{}),Hi=s(e),Be=n(e,"A",{id:!0,class:!0}),a(Be).forEach(t),Li=s(e),c(Ke.$$.fragment,e),Mi=s(e),Ne=n(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-pake4r"&&(Ne.innerHTML=ys),Fi=s(e),qe=n(e,"TABLE",{"data-svelte-h":!0}),r(qe)!=="svelte-f03x1m"&&(qe.innerHTML=Cs),xi=s(e),wi=n(e,"HR",{}),Ai=s(e),ke=n(e,"A",{id:!0,class:!0}),a(ke).forEach(t),ji=s(e),c(Se.$$.fragment,e),Ei=s(e),Ie=n(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-13oc2rp"&&(Ie.textContent=Hs),Oi=s(e),Je=n(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1wxlxpn"&&(Je.innerHTML=Ls),Ui=s(e),ze=n(e,"TABLE",{"data-svelte-h":!0}),r(ze)!=="svelte-2kmk06"&&(ze.innerHTML=Ms),Bi=s(e),Ki=n(e,"HR",{}),Ni=s(e),De=n(e,"A",{id:!0,class:!0}),a(De).forEach(t),qi=s(e),c(We.$$.fragment,e),ki=s(e),Ye=n(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-bwoz3v"&&(Ye.textContent=Fs),Si=s(e),Ve=n(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1wxlxpn"&&(Ve.innerHTML=xs),Ii=s(e),Ge=n(e,"TABLE",{"data-svelte-h":!0}),r(Ge)!=="svelte-yj5tj6"&&(Ge.innerHTML=ws),Ji=s(e),zi=n(e,"HR",{}),Di=s(e),Qe=n(e,"A",{id:!0,class:!0}),a(Qe).forEach(t),Wi=s(e),c(Xe.$$.fragment,e),Yi=s(e),Ze=n(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-19yu0hw"&&(Ze.textContent=As),Vi=s(e),et=n(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1ifo88t"&&(et.innerHTML=js),Gi=s(e),tt=n(e,"TABLE",{"data-svelte-h":!0}),r(tt)!=="svelte-msmjch"&&(tt.innerHTML=Es),Qi=s(e),Xi=n(e,"HR",{}),Zi=s(e),lt=n(e,"A",{id:!0,class:!0}),a(lt).forEach(t),eo=s(e),c(it.$$.fragment,e),to=s(e),ot=n(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-112gzs0"&&(ot.textContent=Os),lo=s(e),st=n(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-9i72aw"&&(st.innerHTML=Us),io=s(e),dt=n(e,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-w7pu3"&&(dt.innerHTML=Bs),oo=s(e),nt=n(e,"TABLE",{"data-svelte-h":!0}),r(nt)!=="svelte-bpbhxc"&&(nt.innerHTML=Ks),so=s(e),no=n(e,"HR",{}),ro=s(e),rt=n(e,"A",{id:!0,class:!0}),a(rt).forEach(t),uo=s(e),c(ut.$$.fragment,e),ao=s(e),at=n(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1h1o1yf"&&(at.innerHTML=Ns),po=s(e),pt=n(e,"TABLE",{"data-svelte-h":!0}),r(pt)!=="svelte-17sk6uf"&&(pt.innerHTML=qs),co=s(e),ho=n(e,"HR",{}),fo=s(e),ct=n(e,"A",{id:!0,class:!0}),a(ct).forEach(t),mo=s(e),c(ht.$$.fragment,e),bo=s(e),ft=n(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1tqccie"&&(ft.textContent=ks),_o=s(e),mt=n(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-dyyw29"&&(mt.innerHTML=Ss),To=s(e),bt=n(e,"TABLE",{"data-svelte-h":!0}),r(bt)!=="svelte-13fau3m"&&(bt.innerHTML=Is),$o=s(e),vo=n(e,"HR",{}),go=s(e),_t=n(e,"A",{id:!0,class:!0}),a(_t).forEach(t),Po=s(e),c(Tt.$$.fragment,e),Ro=s(e),$t=n(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-7vbcne"&&($t.textContent=Js),yo=s(e),vt=n(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-wjfx67"&&(vt.innerHTML=zs),Co=s(e),gt=n(e,"TABLE",{"data-svelte-h":!0}),r(gt)!=="svelte-61qi9d"&&(gt.innerHTML=Ds),Ho=s(e),Lo=n(e,"HR",{}),Mo=s(e),Pt=n(e,"A",{id:!0,class:!0}),a(Pt).forEach(t),Fo=s(e),c(Rt.$$.fragment,e),xo=s(e),yt=n(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1oi15lr"&&(yt.textContent=Ws),wo=s(e),Ct=n(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-121rdz"&&(Ct.innerHTML=Ys),Ao=s(e),Ht=n(e,"TABLE",{"data-svelte-h":!0}),r(Ht)!=="svelte-1kbnzqd"&&(Ht.innerHTML=Vs),jo=s(e),Eo=n(e,"HR",{}),Oo=s(e),Mt=n(e,"P",{}),a(Mt).forEach(t),this.h()},h(){u(T,"name","hf:doc:metadata"),u(T,"content",od),u($,"id","module_utils/hub"),u($,"class","group"),u(R,"id","module_utils/hub.getFile"),u(R,"class","group"),u(M,"id","module_utils/hub.getModelFile"),u(M,"class","group"),u(O,"id","module_utils/hub.getModelFile..cacheKey"),u(O,"class","group"),u(K,"id","module_utils/hub.getModelFile..response"),u(K,"class","group"),u(k,"id","module_utils/hub.getModelJSON"),u(k,"class","group"),u(W,"id","module_utils/hub..FileResponse"),u(W,"class","group"),u(Q,"id","new_module_utils/hub..FileResponse_new"),u(Q,"class","group"),u(te,"id","module_utils/hub..FileResponse+_CONTENT_TYPE_MAP"),u(te,"class","group"),u(se,"id","module_utils/hub..FileResponse+updateContentType"),u(se,"class","group"),u(ue,"id","module_utils/hub..FileResponse+clone"),u(ue,"class","group"),u(he,"id","module_utils/hub..FileResponse+arrayBuffer"),u(he,"class","group"),u(Te,"id","module_utils/hub..FileResponse+blob"),u(Te,"class","group"),u(Re,"id","module_utils/hub..FileResponse+text"),u(Re,"class","group"),u(Me,"id","module_utils/hub..FileResponse+json"),u(Me,"class","group"),u(je,"id","module_utils/hub..FileCache"),u(je,"class","group"),u(Be,"id","new_module_utils/hub..FileCache_new"),u(Be,"class","group"),u(ke,"id","module_utils/hub..FileCache+match"),u(ke,"class","group"),u(De,"id","module_utils/hub..FileCache+put"),u(De,"class","group"),u(Qe,"id","module_utils/hub..isValidHttpUrl"),u(Qe,"class","group"),u(lt,"id","module_utils/hub..handleError"),u(lt,"class","group"),u(rt,"id","module_utils/hub..tryCache"),u(rt,"class","group"),u(ct,"id","module_utils/hub..readResponse"),u(ct,"class","group"),u(_t,"id","module_utils/hub..pathJoin"),u(_t,"class","group"),u(Pt,"id","module_utils/hub..PretrainedOptions"),u(Pt,"class","group")},m(e,l){ld(document.head,T),i(e,Ft,l),i(e,Lt,l),i(e,xt,l),i(e,$,l),i(e,wt,l),h(v,e,l),i(e,At,l),i(e,g,l),i(e,jt,l),i(e,P,l),i(e,Et,l),i(e,Ot,l),i(e,Ut,l),i(e,R,l),i(e,Bt,l),h(y,e,l),i(e,Kt,l),i(e,C,l),i(e,Nt,l),i(e,H,l),i(e,qt,l),i(e,L,l),i(e,kt,l),i(e,St,l),i(e,It,l),i(e,M,l),i(e,Jt,l),h(F,e,l),i(e,zt,l),i(e,x,l),i(e,Dt,l),i(e,w,l),i(e,Wt,l),i(e,A,l),i(e,Yt,l),i(e,j,l),i(e,Vt,l),i(e,E,l),i(e,Gt,l),i(e,Qt,l),i(e,Xt,l),i(e,O,l),i(e,Zt,l),h(U,e,l),i(e,el,l),i(e,B,l),i(e,tl,l),i(e,ll,l),i(e,il,l),i(e,K,l),i(e,ol,l),h(N,e,l),i(e,sl,l),i(e,q,l),i(e,dl,l),i(e,nl,l),i(e,rl,l),i(e,k,l),i(e,ul,l),h(S,e,l),i(e,al,l),i(e,I,l),i(e,pl,l),i(e,J,l),i(e,cl,l),i(e,z,l),i(e,hl,l),i(e,D,l),i(e,fl,l),i(e,ml,l),i(e,bl,l),i(e,W,l),i(e,_l,l),h(Y,e,l),i(e,Tl,l),i(e,V,l),i(e,$l,l),i(e,G,l),i(e,vl,l),i(e,gl,l),i(e,Pl,l),i(e,Q,l),i(e,Rl,l),h(X,e,l),i(e,yl,l),i(e,Z,l),i(e,Cl,l),i(e,ee,l),i(e,Hl,l),i(e,Ll,l),i(e,Ml,l),i(e,te,l),i(e,Fl,l),h(le,e,l),i(e,xl,l),i(e,ie,l),i(e,wl,l),i(e,oe,l),i(e,Al,l),i(e,jl,l),i(e,El,l),i(e,se,l),i(e,Ol,l),h(de,e,l),i(e,Ul,l),i(e,ne,l),i(e,Bl,l),i(e,re,l),i(e,Kl,l),i(e,Nl,l),i(e,ql,l),i(e,ue,l),i(e,kl,l),h(ae,e,l),i(e,Sl,l),i(e,pe,l),i(e,Il,l),i(e,ce,l),i(e,Jl,l),i(e,zl,l),i(e,Dl,l),i(e,he,l),i(e,Wl,l),h(fe,e,l),i(e,Yl,l),i(e,me,l),i(e,Vl,l),i(e,be,l),i(e,Gl,l),i(e,_e,l),i(e,Ql,l),i(e,Xl,l),i(e,Zl,l),i(e,Te,l),i(e,ei,l),h($e,e,l),i(e,ti,l),i(e,ve,l),i(e,li,l),i(e,ge,l),i(e,ii,l),i(e,Pe,l),i(e,oi,l),i(e,si,l),i(e,di,l),i(e,Re,l),i(e,ni,l),h(ye,e,l),i(e,ri,l),i(e,Ce,l),i(e,ui,l),i(e,He,l),i(e,ai,l),i(e,Le,l),i(e,pi,l),i(e,ci,l),i(e,hi,l),i(e,Me,l),i(e,fi,l),h(Fe,e,l),i(e,mi,l),i(e,xe,l),i(e,bi,l),i(e,we,l),i(e,_i,l),i(e,Ae,l),i(e,Ti,l),i(e,$i,l),i(e,vi,l),i(e,je,l),i(e,gi,l),h(Ee,e,l),i(e,Pi,l),i(e,Oe,l),i(e,Ri,l),i(e,Ue,l),i(e,yi,l),i(e,Ci,l),i(e,Hi,l),i(e,Be,l),i(e,Li,l),h(Ke,e,l),i(e,Mi,l),i(e,Ne,l),i(e,Fi,l),i(e,qe,l),i(e,xi,l),i(e,wi,l),i(e,Ai,l),i(e,ke,l),i(e,ji,l),h(Se,e,l),i(e,Ei,l),i(e,Ie,l),i(e,Oi,l),i(e,Je,l),i(e,Ui,l),i(e,ze,l),i(e,Bi,l),i(e,Ki,l),i(e,Ni,l),i(e,De,l),i(e,qi,l),h(We,e,l),i(e,ki,l),i(e,Ye,l),i(e,Si,l),i(e,Ve,l),i(e,Ii,l),i(e,Ge,l),i(e,Ji,l),i(e,zi,l),i(e,Di,l),i(e,Qe,l),i(e,Wi,l),h(Xe,e,l),i(e,Yi,l),i(e,Ze,l),i(e,Vi,l),i(e,et,l),i(e,Gi,l),i(e,tt,l),i(e,Qi,l),i(e,Xi,l),i(e,Zi,l),i(e,lt,l),i(e,eo,l),h(it,e,l),i(e,to,l),i(e,ot,l),i(e,lo,l),i(e,st,l),i(e,io,l),i(e,dt,l),i(e,oo,l),i(e,nt,l),i(e,so,l),i(e,no,l),i(e,ro,l),i(e,rt,l),i(e,uo,l),h(ut,e,l),i(e,ao,l),i(e,at,l),i(e,po,l),i(e,pt,l),i(e,co,l),i(e,ho,l),i(e,fo,l),i(e,ct,l),i(e,mo,l),h(ht,e,l),i(e,bo,l),i(e,ft,l),i(e,_o,l),i(e,mt,l),i(e,To,l),i(e,bt,l),i(e,$o,l),i(e,vo,l),i(e,go,l),i(e,_t,l),i(e,Po,l),h(Tt,e,l),i(e,Ro,l),i(e,$t,l),i(e,yo,l),i(e,vt,l),i(e,Co,l),i(e,gt,l),i(e,Ho,l),i(e,Lo,l),i(e,Mo,l),i(e,Pt,l),i(e,Fo,l),h(Rt,e,l),i(e,xo,l),i(e,yt,l),i(e,wo,l),i(e,Ct,l),i(e,Ao,l),i(e,Ht,l),i(e,jo,l),i(e,Eo,l),i(e,Oo,l),i(e,Mt,l),Uo=!0},p:Qs,i(e){Uo||(f(v.$$.fragment,e),f(y.$$.fragment,e),f(F.$$.fragment,e),f(U.$$.fragment,e),f(N.$$.fragment,e),f(S.$$.fragment,e),f(Y.$$.fragment,e),f(X.$$.fragment,e),f(le.$$.fragment,e),f(de.$$.fragment,e),f(ae.$$.fragment,e),f(fe.$$.fragment,e),f($e.$$.fragment,e),f(ye.$$.fragment,e),f(Fe.$$.fragment,e),f(Ee.$$.fragment,e),f(Ke.$$.fragment,e),f(Se.$$.fragment,e),f(We.$$.fragment,e),f(Xe.$$.fragment,e),f(it.$$.fragment,e),f(ut.$$.fragment,e),f(ht.$$.fragment,e),f(Tt.$$.fragment,e),f(Rt.$$.fragment,e),Uo=!0)},o(e){m(v.$$.fragment,e),m(y.$$.fragment,e),m(F.$$.fragment,e),m(U.$$.fragment,e),m(N.$$.fragment,e),m(S.$$.fragment,e),m(Y.$$.fragment,e),m(X.$$.fragment,e),m(le.$$.fragment,e),m(de.$$.fragment,e),m(ae.$$.fragment,e),m(fe.$$.fragment,e),m($e.$$.fragment,e),m(ye.$$.fragment,e),m(Fe.$$.fragment,e),m(Ee.$$.fragment,e),m(Ke.$$.fragment,e),m(Se.$$.fragment,e),m(We.$$.fragment,e),m(Xe.$$.fragment,e),m(it.$$.fragment,e),m(ut.$$.fragment,e),m(ht.$$.fragment,e),m(Tt.$$.fragment,e),m(Rt.$$.fragment,e),Uo=!1},d(e){e&&(t(Ft),t(Lt),t(xt),t($),t(wt),t(At),t(g),t(jt),t(P),t(Et),t(Ot),t(Ut),t(R),t(Bt),t(Kt),t(C),t(Nt),t(H),t(qt),t(L),t(kt),t(St),t(It),t(M),t(Jt),t(zt),t(x),t(Dt),t(w),t(Wt),t(A),t(Yt),t(j),t(Vt),t(E),t(Gt),t(Qt),t(Xt),t(O),t(Zt),t(el),t(B),t(tl),t(ll),t(il),t(K),t(ol),t(sl),t(q),t(dl),t(nl),t(rl),t(k),t(ul),t(al),t(I),t(pl),t(J),t(cl),t(z),t(hl),t(D),t(fl),t(ml),t(bl),t(W),t(_l),t(Tl),t(V),t($l),t(G),t(vl),t(gl),t(Pl),t(Q),t(Rl),t(yl),t(Z),t(Cl),t(ee),t(Hl),t(Ll),t(Ml),t(te),t(Fl),t(xl),t(ie),t(wl),t(oe),t(Al),t(jl),t(El),t(se),t(Ol),t(Ul),t(ne),t(Bl),t(re),t(Kl),t(Nl),t(ql),t(ue),t(kl),t(Sl),t(pe),t(Il),t(ce),t(Jl),t(zl),t(Dl),t(he),t(Wl),t(Yl),t(me),t(Vl),t(be),t(Gl),t(_e),t(Ql),t(Xl),t(Zl),t(Te),t(ei),t(ti),t(ve),t(li),t(ge),t(ii),t(Pe),t(oi),t(si),t(di),t(Re),t(ni),t(ri),t(Ce),t(ui),t(He),t(ai),t(Le),t(pi),t(ci),t(hi),t(Me),t(fi),t(mi),t(xe),t(bi),t(we),t(_i),t(Ae),t(Ti),t($i),t(vi),t(je),t(gi),t(Pi),t(Oe),t(Ri),t(Ue),t(yi),t(Ci),t(Hi),t(Be),t(Li),t(Mi),t(Ne),t(Fi),t(qe),t(xi),t(wi),t(Ai),t(ke),t(ji),t(Ei),t(Ie),t(Oi),t(Je),t(Ui),t(ze),t(Bi),t(Ki),t(Ni),t(De),t(qi),t(ki),t(Ye),t(Si),t(Ve),t(Ii),t(Ge),t(Ji),t(zi),t(Di),t(Qe),t(Wi),t(Yi),t(Ze),t(Vi),t(et),t(Gi),t(tt),t(Qi),t(Xi),t(Zi),t(lt),t(eo),t(to),t(ot),t(lo),t(st),t(io),t(dt),t(oo),t(nt),t(so),t(no),t(ro),t(rt),t(uo),t(ao),t(at),t(po),t(pt),t(co),t(ho),t(fo),t(ct),t(mo),t(bo),t(ft),t(_o),t(mt),t(To),t(bt),t($o),t(vo),t(go),t(_t),t(Po),t(Ro),t($t),t(yo),t(vt),t(Co),t(gt),t(Ho),t(Lo),t(Mo),t(Pt),t(Fo),t(xo),t(yt),t(wo),t(Ct),t(Ao),t(Ht),t(jo),t(Eo),t(Oo),t(Mt)),t(T),b(v,e),b(y,e),b(F,e),b(U,e),b(N,e),b(S,e),b(Y,e),b(X,e),b(le,e),b(de,e),b(ae,e),b(fe,e),b($e,e),b(ye,e),b(Fe,e),b(Ee,e),b(Ke,e),b(Se,e),b(We,e),b(Xe,e),b(it,e),b(ut,e),b(ht,e),b(Tt,e),b(Rt,e)}}}const od='{"title":"utils/hub","local":"utilshub","sections":[{"title":"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>","local":"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code","sections":[],"depth":2},{"title":"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options]) ⇒ <code> Promise </code>","local":"utilshubgetmodelfilepathorrepoid-filename-fatal-options--code-promise-code","sections":[{"title":"getModelFile~cacheKey : <code> string </code>","local":"getmodelfilecachekey--code-string-code","sections":[],"depth":3},{"title":"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>","local":"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>","local":"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code","sections":[],"depth":2},{"title":"utils/hub~FileResponse","local":"utilshubfileresponse","sections":[{"title":"new FileResponse(filePath)","local":"new-fileresponsefilepath","sections":[],"depth":3},{"title":"fileResponse._CONTENT_TYPE_MAP","local":"fileresponsecontenttypemap","sections":[],"depth":3},{"title":"fileResponse.updateContentType() ⇒ <code> void </code>","local":"fileresponseupdatecontenttype--code-void-code","sections":[],"depth":3},{"title":"fileResponse.clone() ⇒ <code> FileResponse </code>","local":"fileresponseclone--code-fileresponse-code","sections":[],"depth":3},{"title":"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>","local":"fileresponsearraybuffer--code-promise--arraybuffer--code","sections":[],"depth":3},{"title":"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>","local":"fileresponseblob--code-promise--blob--code","sections":[],"depth":3},{"title":"fileResponse.text() ⇒ <code> Promise. < string > </code>","local":"fileresponsetext--code-promise--string--code","sections":[],"depth":3},{"title":"fileResponse.json() ⇒ <code> Promise. < Object > </code>","local":"fileresponsejson--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~FileCache","local":"utilshubfilecache","sections":[{"title":"new FileCache(path)","local":"new-filecachepath","sections":[],"depth":3},{"title":"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>","local":"filecachematchrequest--code-promise--fileresponseundefined--code","sections":[],"depth":3},{"title":"fileCache.put(request, response) ⇒ <code> Promise. < void > </code>","local":"filecacheputrequest-response--code-promise--void--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~isValidHttpUrl(string, [validHosts]) ⇒ <code> boolean </code>","local":"utilshubisvalidhttpurlstring-validhosts--code-boolean-code","sections":[],"depth":2},{"title":"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>","local":"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code","sections":[],"depth":2},{"title":"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>","local":"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code","sections":[],"depth":2},{"title":"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>","local":"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code","sections":[],"depth":2},{"title":"utils/hub~pathJoin(...parts) ⇒ <code> string </code>","local":"utilshubpathjoinparts--code-string-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedOptions : <code> Object </code>","local":"utilshubpretrainedoptions--code-object-code","sections":[],"depth":2}],"depth":1}';function sd(Bo){return Xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ud extends Zs{constructor(T){super(),ed(this,T,sd,id,Gs,{})}}export{ud as component};
