import{s as cs,f as Ee,n as hs,o as fs}from"../chunks/scheduler.85c25b89.js";import{S as ys,i as ws,g as i,s as l,r as p,A as gs,h as o,f as n,c as a,j as ms,u,x as r,k as y,y as ds,a as s,v as m,d as c,t as h,w as f}from"../chunks/index.c9bcf812.js";import{C as g}from"../chunks/CodeBlock.c004bd26.js";import{H as w}from"../chunks/getInferenceSnippets.0fb0b8ca.js";function Ms(fn){let d,ze,He,Ge,M,Re,T,yn="This guide will help you get Optimum Neuron up and running. There are two main approaches:",Xe,J,wn="<li><strong>🚀 Recommended: AWS EC2 with Deep Learning AMI</strong> - The simplest way to get started with pre-configured environment</li> <li><strong>⚙️ Manual Installation</strong> - Install Optimum Neuron on existing infrastructure</li>",Pe,C,Ye,v,gn='The simplest way to work with AWS Trainium or Inferentia and Optimum Neuron on Amazon EC2 is the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a> (DLAMI). The DLAMI comes with all required libraries pre-packaged for you, including the Optimum Neuron, Neuron Drivers, Transformers, Datasets, and Accelerate. The HF DLAMI is provided at no additional charge to Amazon EC2 users.',Fe,I,dn='Optimum Neuron supports Inf1, Inf2, Trn1 and Trn2, all accessible on Amazon EC2. You can find all the specifications of the Trn and Inf instances <a href="https://aws.amazon.com/ec2/instance-types/" rel="nofollow">here</a>, in the “Accelerated Computing” section.',De,x,Mn="In this section, we will show you:",qe,b,Tn='<li><a href="#create-an-aws-trainium-or-inferentia-instance-on-amazon-ec2-with-the-hf-dlami">How to create an AWS Trainium or Inferentia instance on Amazon EC2 with the HF DLAMI</a><ol><li><a href="#find-a-supported-region">Find a supported region</a></li> <li><a href="#increase-service-quota">Increase service quota</a></li> <li><a href="#launch-the-amazon-ec2-instance-with-the-hf-dlami">Launch the Amazon EC2 instance with the HF DLAMI</a></li> <li><a href="#connect-through-ssh">Connect through SSH</a></li></ol></li> <li><a href="#set-up-your-remote-development-environment">How to set up your remote development environment</a><ol><li><a href="#access-through-jupyter-notebook">Access through Jupyter Notebook</a></li> <li><a href="#access-through-vs-code-remote-server">Access through VS Code remote server</a></li></ol></li>',Oe,$,Ke,j,Jn="Before creating the EC2 instance, make sure you are in a supported region for the instance you selected and that you have quota in your AWS account.",et,U,tt,S,Cn="Here is the list of regions that support at least one type of Trainium or Inferentia2 instance, as of February 2025:",nt,k,vn="<li>us-east-1: US East (N. Virginia)</li> <li>us-east-2: US East (Ohio)</li> <li>us-west-2: US West (Oregon)</li> <li>ap-south-1: Asia Pacific (Mumbai)</li> <li>ap-northeast-1: Asia Pacific (Tokyo)</li> <li>ap-southeast-1: Asia Pacific (Singapore)</li> <li>ap-southeast-2: Asia Pacific (Sydney)</li> <li>ap-southeast-4: Asia Pacific (Melbourne)</li> <li>eu-north-1: Europe (Stockholm)</li> <li>eu-west-3: Europe (Paris)</li> <li>eu-west-2: Europe (London)</li> <li>eu-west-1: Europe (Ireland)</li> <li>eu-central-1: Europe (Frankfurt)</li> <li>sa-east-1: South America (Sao Paulo)</li>",st,A,In="Here is a Python script that lets you pull the latest supported instance type in each region you have enabled:",lt,_,at,L,it,N,xn="Now that you selected your region and that you switched to it, you can request a Service Quota increase through the AWS Console by navigating to Service Quota, AWS services in the left panel, search for Amazon EC2, then “trn” or “inf”. You are able to request quota increase for On-Demand and Spot instances separately.",ot,W,bn="By default, all quotas are 0 for Inferentia and Trainium. There is no charge for increased quotas. There are separate quotas for Inferentia and Trainium, and separate quotas for spot and on-demand. Quotas refer to the maximum TOTAL number of vCPUs assigned to each instance type.",rt,B,$n="For example, a quota of 192 will let you run a single inf2.48xlarge, two inf2.24xlarges, six inf2.8xlarges, or forty-eight of the inf2.xlarges. It will also let you run inf1 instance types. Similarly for Trainium, a quota of 128 will let you run a single trn1n.32xlarge or trn1.32xlarge, but it will also let you run sixteen trn1.2xlarge.",pt,V,ut,Z,jn="Let’s deploy a trn1.2xlarge instance in the us-east-1 region (North Virginia) through the EC2 console.",mt,E,Un="First, click on <strong>Launch instance</strong> and define a name for the instance (<code>trainium-huggingface-demo</code>).",ct,H,Sn,ht,Q,kn="Next, you search the Amazon Marketplace for Hugging Face AMIs. Entering “Hugging Face” in the search bar for “Application and OS Images” and hitting “enter”.",ft,z,An,yt,G,_n='This should now open the “Choose an Amazon Machine Image” view with the search. You can now navigate to “AWS Marketplace AMIs” and find the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a> and click select.',wt,R,Ln,gt,X,Nn="<em>You will be asked to subscribe if you aren’t. The AMI is completely free of charge, and you will only pay for the EC2 compute.</em>",dt,P,Wn="Then you need to define a key pair, which will be used to connect to the instance via <code>ssh</code>. You can create one in place if you don’t have a key pair.",Mt,Y,Bn,Tt,F,Vn='After that, create or select a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html" rel="nofollow">security group</a> which allows <code>ssh</code> traffic.',Jt,D,Zn,Ct,q,En="You are ready to launch the instance. Therefore click on “Launch Instance” on the right side.",vt,O,Hn,It,K,Qn='AWS will now provision the instance using the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a>.',xt,ee,bt,te,zn="Once the instance is ready, you can view and copy the public IPv4 address to <code>ssh</code> into the machine.",$t,ne,Gn,jt,se,Rn="Replace the empty strings <code>&quot;&quot;</code> in the snippet below with the IP address of your instances and the path to the key pair you created/selected when launching the instance.",Ut,le,St,ae,Xn="Once you are connected, you can run <code>neuron-ls</code> to ensure you have access to the Trainium accelerators. You should see a similar output than below.",kt,ie,At,oe,_t,re,Pn="We will walk through setting up Jupyter Notebooks or VS Code remote server on the Amazon EC2 instance.",Lt,pe,Yn="These two methods require an SSH connection of some kind. These instructions were written for a Mac, but should work on a Linux system as well. A PC may require using Putty.",Nt,ue,Fn="You should have a .pem file that you created when you deployed your instance or had from previous deployments. You can connect to your system using:",Wt,me,Bt,ce,Vt,he,Dn="This method involves running the Jupyter notebook server on the Neuron instance, mapping a port locally, then using the browser on your desktop to access the notebook server.",Zt,fe,qn="Start by mapping a port on your local machine to the Neuron instance. From a terminal on your system, run",Et,ye,Ht,we,On="Then connect to your Amazon EC2 instance using SSH from your computer. Once connected, from the command prompt, run",Qt,ge,zt,de,Kn="After a few seconds, check the nohup.out file to find your server’s token:",Gt,Me,Rt,Te,es="Copy the connection string and paste it into your browser. After a few seconds, you should eventually see the Jupyter Notebook browser. It should look like http://localhost:8888/tree?token=337fc8de2aenot_a_real_tokene952c43946e4fb57131",Xt,Je,ts="This process works because you have mapped the 8888 port on your local machine to the 8888 port on the Neuron instance, so when you connect to localhost:8888, you end up accessing the Jupyter server on the Neuron instance.",Pt,Ce,ns="If you have problems, make sure the initial port mapping was successful. If you already have something running on port 8888 on your machine, this may give you an error. You can always change the port (e.g. 8885) in all the instructions if you need to.",Yt,ve,Ft,Ie,ss="With Visual Studio Code installed on your local machine, you can use the Remote-SSH command to edit and run files that are stored on a Neuron instance. See the VS Code article for additional details.",Dt,xe,ls="<li>Select Remote-SSH: Connect to Host… from the Command Palette (F1, ⇧⌘P)</li> <li>Enter in the full connection string from the ssh section above: ssh -i “/path/to/sshkey.pem” ubuntu@instance_ip_address</li> <li>VS Code should connect and automatically set up the VS Code server.</li> <li>Eventually, you should be prompted for a base directory. You can browse to a directory on the Neuron instance.</li> <li>In case you find that some commands seem greyed out in the menus, but the keyboard commands still work (⌘S to save or ^⇧` for terminal), you may need to restart VS Code.</li>",qt,be,Ot,$e,as="Manual installation is useful in several scenarios:",Kt,je,is="<li><strong>Using a newer version</strong>: Install the latest Optimum Neuron version that may not yet be available in the DLAMI</li> <li><strong>Custom AMI requirements</strong>: Working with your organization’s standard AMI or security-hardened images</li> <li><strong>Existing infrastructure</strong>: Adding Neuron support to pre-configured environments or Docker containers</li> <li><strong>Development setup</strong>: Installing pre-release or development versions for testing</li> <li><strong>Minimal installations</strong>: Creating lightweight environments with only required dependencies</li>",en,Ue,os="If you choose manual installation, you will need to ensure the Neuron drivers and tools are properly installed first.",tn,Se,rs='Before installing <code>optimum-neuron</code> make sure that you have installed the Neuron driver and tools, check out <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/setup/torch-neuronx.html#setup-torch-neuronx" rel="nofollow">more detailed guide here</a>.',nn,ke,sn,Ae,ps="Pointing to the AWS Neuron repository:",ln,_e,an,Le,on,Ne,rn,We,pn,Be,un,Ve,mn,Ze,us='Now that you have Optimum Neuron set up, check out the <strong><a href="./quickstart">Quickstart Guide</a></strong> to learn the basics of training and inference with Optimum Neuron.',cn,Qe,hn;return M=new w({props:{title:"EC2 Setup",local:"ec2-setup",headingTag:"h1"}}),C=new w({props:{title:"Recommended: AWS EC2 with Deep Learning AMI",local:"recommended-aws-ec2-with-deep-learning-ami",headingTag:"h2"}}),$=new w({props:{title:"Create an AWS Trainium or Inferentia instance on Amazon EC2 with the HF DLAMI",local:"create-an-aws-trainium-or-inferentia-instance-on-amazon-ec2-with-the-hf-dlami",headingTag:"h3"}}),U=new w({props:{title:"Find a supported region",local:"find-a-supported-region",headingTag:"h4"}}),_=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> boto3
<span class="hljs-keyword">from</span> datetime <span class="hljs-keyword">import</span> datetime

ec2 = boto3.client(<span class="hljs-string">&#x27;ec2&#x27;</span>)

regions = [region[<span class="hljs-string">&#x27;RegionName&#x27;</span>] <span class="hljs-keyword">for</span> region <span class="hljs-keyword">in</span> ec2.describe_regions()[<span class="hljs-string">&#x27;Regions&#x27;</span>]]


<span class="hljs-comment">#Edit this line to change the instance types displayed</span>
instance_types = [<span class="hljs-string">&#x27;trn1.32xlarge&#x27;</span>, <span class="hljs-string">&#x27;trn1.2xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.48xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.24xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.8xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.xlarge&#x27;</span>, <span class="hljs-string">&#x27;trn2.48xlarge&#x27;</span>]

supported_regions = {}

<span class="hljs-keyword">for</span> region <span class="hljs-keyword">in</span> regions:
   ec2_region = boto3.client(<span class="hljs-string">&#x27;ec2&#x27;</span>, region_name=region)
   response = ec2_region.describe_instance_type_offerings(
      <span class="hljs-comment">#LocationType=&#x27;availability-zone&#x27;,</span>
      Filters=[
        {<span class="hljs-string">&#x27;Name&#x27;</span>: <span class="hljs-string">&#x27;instance-type&#x27;</span>, <span class="hljs-string">&#x27;Values&#x27;</span>: instance_types},
      ]
   )
   <span class="hljs-keyword">if</span> response[<span class="hljs-string">&#x27;InstanceTypeOfferings&#x27;</span>]:
      supported_regions[region] = [offer[<span class="hljs-string">&#x27;InstanceType&#x27;</span>] <span class="hljs-keyword">for</span> offer <span class="hljs-keyword">in</span> response[<span class="hljs-string">&#x27;InstanceTypeOfferings&#x27;</span>]]

<span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;# Supported Regions as of&#x27;</span>,datetime.now().strftime(<span class="hljs-string">&#x27;%B %d, %Y&#x27;</span>))
<span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;================&#x27;</span>)


client = boto3.client(<span class="hljs-string">&#x27;ssm&#x27;</span>)

<span class="hljs-keyword">for</span> region, instance_types <span class="hljs-keyword">in</span> supported_regions.items():
    <span class="hljs-keyword">try</span>:
        response = client.get_parameter(Name=<span class="hljs-string">f&#x27;/aws/service/global-infrastructure/regions/<span class="hljs-subst">{region}</span>/longName&#x27;</span>)
        region_long_name = response[<span class="hljs-string">&#x27;Parameter&#x27;</span>][<span class="hljs-string">&#x27;Value&#x27;</span>]
    <span class="hljs-keyword">except</span> (client.exceptions.ParameterNotFound, KeyError):
        region_long_name = region
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27; * <span class="hljs-subst">{region}</span>: <span class="hljs-subst">{region_long_name}</span>&#x27;</span>)
    <span class="hljs-keyword">for</span> instance_type <span class="hljs-keyword">in</span> instance_types:
      <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;  - <span class="hljs-subst">{instance_type}</span>&#x27;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;\\n&#x27;</span>)`,wrap:!1}}),L=new w({props:{title:"Increase service quota",local:"increase-service-quota",headingTag:"h4"}}),V=new w({props:{title:"Launch the Amazon EC2 instance with the HF DLAMI",local:"launch-the-amazon-ec2-instance-with-the-hf-dlami",headingTag:"h4"}}),ee=new w({props:{title:"Connect through SSH",local:"connect-through-ssh",headingTag:"h4"}}),le=new g({props:{code:"UFVCTElDX0ROUyUzRCUyMiUyMiUyMCUyMyUyMElQJTIwYWRkcmVzcyUwQUtFWV9QQVRIJTNEJTIyJTIyJTIwJTIzJTIwbG9jYWwlMjBwYXRoJTIwdG8lMjBrZXklMjBwYWlyJTBBJTBBc3NoJTIwLWklMjAlMjRLRVlfUEFUSCUyMHVidW50dSU0MCUyNFBVQkxJQ19ETlM=",highlighted:`PUBLIC_DNS=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># IP address</span>
KEY_PATH=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># local path to key pair</span>

ssh -i <span class="hljs-variable">$KEY_PATH</span> ubuntu@<span class="hljs-variable">$PUBLIC_DNS</span>`,wrap:!1}}),ie=new g({props:{code:"dWJ1bnR1JTQwaXAtMTcyLTMxLTc5LTE2NCUzQX4lMjQlMjBuZXVyb24tbHMlMEFpbnN0YW5jZS10eXBlJTNBJTIwdHJuMS4yeGxhcmdlJTBBaW5zdGFuY2UtaWQlM0ElMjBpLTA1NzA2MTVlNDE3MDBhNDgxJTBBJTJCLS0tLS0tLS0lMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0tJTJCJTBBJTdDJTIwTkVVUk9OJTIwJTdDJTIwTkVVUk9OJTIwJTdDJTIwTkVVUk9OJTIwJTdDJTIwJTIwJTIwUENJJTIwJTIwJTIwJTdDJTBBJTdDJTIwREVWSUNFJTIwJTdDJTIwQ09SRVMlMjAlMjAlN0MlMjBNRU1PUlklMjAlN0MlMjAlMjAlMjBCREYlMjAlMjAlMjAlN0MlMEElMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0lMkItLS0tLS0tLS0lMkIlMEElN0MlMjAwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMiUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDMyJTIwR0IlMjAlMjAlN0MlMjAwMCUzQTFlLjAlMjAlN0MlMEElMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0lMkItLS0tLS0tLS0lMkI=",highlighted:`ubuntu@ip<span class="hljs-number">-172</span><span class="hljs-number">-31</span><span class="hljs-number">-79</span><span class="hljs-number">-164</span><span class="hljs-punctuation">:</span>~$ neuron-ls
instance-type<span class="hljs-punctuation">:</span> trn1<span class="hljs-number">.2</span>xlarge
instance-id<span class="hljs-punctuation">:</span> i<span class="hljs-number">-0570615e41700</span>a481
+--------+--------+--------+---------+
| NEURON | NEURON | NEURON |   PCI   |
| DEVICE | CORES  | MEMORY |   BDF   |
+--------+--------+--------+---------+
| <span class="hljs-number">0</span>      | <span class="hljs-number">2</span>      | <span class="hljs-number">32</span> GB  | <span class="hljs-number">00</span><span class="hljs-punctuation">:</span><span class="hljs-number">1</span>e<span class="hljs-number">.0</span> |
+--------+--------+--------+---------+`,wrap:!1}}),oe=new w({props:{title:"Set up your remote development environment",local:"set-up-your-remote-development-environment",headingTag:"h3"}}),me=new g({props:{code:"c3NoJTIwLWklMjAlMjIlMkZwYXRoJTJGdG8lMkZzc2hrZXkucGVtJTIyJTIwdWJ1bnR1JTQwaW5zdGFuY2VfaXBfYWRkcmVzcw==",highlighted:'ssh -i <span class="hljs-string">&quot;/path/to/sshkey.pem&quot;</span> ubuntu@instance_ip_address',wrap:!1}}),ce=new w({props:{title:"Access through Jupyter Notebook",local:"access-through-jupyter-notebook",headingTag:"h4"}}),ye=new g({props:{code:"c3NoJTIwLWklMjAlMjIlMkZwYXRoJTJGdG8lMkZzc2hrZXkucGVtJTIyJTIwLU4lMjAtZiUyMC1MJTIwbG9jYWxob3N0JTNBODg4OCUzQWxvY2FsaG9zdCUzQTg4ODglMjB1YnVudHUlNDBpbnN0YW5jZV9pcF9hZGRyZXNz",highlighted:'ssh -i <span class="hljs-string">&quot;/path/to/sshkey.pem&quot;</span> -N -f -L localhost:8888:localhost:8888 ubuntu@instance_ip_address',wrap:!1}}),ge=new g({props:{code:"bm9odXAlMjBqdXB5dGVyJTIwbm90ZWJvb2slMjAtLW5vLWJyb3dzZXIlMjAtLXBvcnQlM0Q4ODg4",highlighted:'<span class="hljs-built_in">nohup</span> jupyter notebook --no-browser --port=8888',wrap:!1}}),Me=new g({props:{code:"Y2F0JTIwbm9odXAub3V0JTIwJTdDJTIwZ3JlcCUyMGxvY2FsaG9zdA==",highlighted:'<span class="hljs-built_in">cat</span> nohup.out | grep localhost',wrap:!1}}),ve=new w({props:{title:"Access through VS Code remote server",local:"access-through-vs-code-remote-server",headingTag:"h4"}}),be=new w({props:{title:"Alternative: Manual Installation",local:"alternative-manual-installation",headingTag:"h2"}}),ke=new w({props:{title:"Adding pip packages URL",local:"adding-pip-packages-url",headingTag:"h3"}}),_e=new g({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBjb25maWclMjBzZXQlMjBnbG9iYWwuZXh0cmEtaW5kZXgtdXJsJTIwaHR0cHMlM0ElMkYlMkZwaXAucmVwb3MubmV1cm9uLmFtYXpvbmF3cy5jb20=",highlighted:'python -m pip config <span class="hljs-built_in">set</span> global.extra-index-url https://pip.repos.neuron.amazonaws.com',wrap:!1}}),Le=new w({props:{title:"Installing optimum-neuron for AWS Trainium ( trn1 ) or AWS inferentia2 ( inf2 )",local:"installing-optimum-neuron-for-aws-trainium--trn1--or-aws-inferentia2--inf2-",headingTag:"h3"}}),Ne=new g({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwb3B0aW11bS1uZXVyb24lNUJuZXVyb254JTVE",highlighted:"python -m pip install optimum-neuron[neuronx]",wrap:!1}}),We=new w({props:{title:"Installing optimum-neuron for AWS inferentia ( inf1 )",local:"installing-optimum-neuron-for-aws-inferentia--inf1-",headingTag:"h3"}}),Be=new g({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwb3B0aW11bS1uZXVyb24lNUJuZXVyb24lNUQ=",highlighted:"python -m pip install optimum-neuron[neuron]",wrap:!1}}),Ve=new w({props:{title:"What’s Next?",local:"whats-next",headingTag:"h2"}}),{c(){d=i("meta"),ze=l(),He=i("p"),Ge=l(),p(M.$$.fragment),Re=l(),T=i("p"),T.textContent=yn,Xe=l(),J=i("ol"),J.innerHTML=wn,Pe=l(),p(C.$$.fragment),Ye=l(),v=i("p"),v.innerHTML=gn,Fe=l(),I=i("p"),I.innerHTML=dn,De=l(),x=i("p"),x.textContent=Mn,qe=l(),b=i("ol"),b.innerHTML=Tn,Oe=l(),p($.$$.fragment),Ke=l(),j=i("p"),j.textContent=Jn,et=l(),p(U.$$.fragment),tt=l(),S=i("p"),S.textContent=Cn,nt=l(),k=i("ul"),k.innerHTML=vn,st=l(),A=i("p"),A.textContent=In,lt=l(),p(_.$$.fragment),at=l(),p(L.$$.fragment),it=l(),N=i("p"),N.textContent=xn,ot=l(),W=i("p"),W.textContent=bn,rt=l(),B=i("p"),B.textContent=$n,pt=l(),p(V.$$.fragment),ut=l(),Z=i("p"),Z.textContent=jn,mt=l(),E=i("p"),E.innerHTML=Un,ct=l(),H=i("img"),ht=l(),Q=i("p"),Q.textContent=kn,ft=l(),z=i("img"),yt=l(),G=i("p"),G.innerHTML=_n,wt=l(),R=i("img"),gt=l(),X=i("p"),X.innerHTML=Nn,dt=l(),P=i("p"),P.innerHTML=Wn,Mt=l(),Y=i("img"),Tt=l(),F=i("p"),F.innerHTML=Vn,Jt=l(),D=i("img"),Ct=l(),q=i("p"),q.textContent=En,vt=l(),O=i("img"),It=l(),K=i("p"),K.innerHTML=Qn,xt=l(),p(ee.$$.fragment),bt=l(),te=i("p"),te.innerHTML=zn,$t=l(),ne=i("img"),jt=l(),se=i("p"),se.innerHTML=Rn,Ut=l(),p(le.$$.fragment),St=l(),ae=i("p"),ae.innerHTML=Xn,kt=l(),p(ie.$$.fragment),At=l(),p(oe.$$.fragment),_t=l(),re=i("p"),re.textContent=Pn,Lt=l(),pe=i("p"),pe.textContent=Yn,Nt=l(),ue=i("p"),ue.textContent=Fn,Wt=l(),p(me.$$.fragment),Bt=l(),p(ce.$$.fragment),Vt=l(),he=i("p"),he.textContent=Dn,Zt=l(),fe=i("p"),fe.textContent=qn,Et=l(),p(ye.$$.fragment),Ht=l(),we=i("p"),we.textContent=On,Qt=l(),p(ge.$$.fragment),zt=l(),de=i("p"),de.textContent=Kn,Gt=l(),p(Me.$$.fragment),Rt=l(),Te=i("p"),Te.textContent=es,Xt=l(),Je=i("p"),Je.textContent=ts,Pt=l(),Ce=i("p"),Ce.textContent=ns,Yt=l(),p(ve.$$.fragment),Ft=l(),Ie=i("p"),Ie.textContent=ss,Dt=l(),xe=i("ol"),xe.innerHTML=ls,qt=l(),p(be.$$.fragment),Ot=l(),$e=i("p"),$e.textContent=as,Kt=l(),je=i("ul"),je.innerHTML=is,en=l(),Ue=i("p"),Ue.textContent=os,tn=l(),Se=i("p"),Se.innerHTML=rs,nn=l(),p(ke.$$.fragment),sn=l(),Ae=i("p"),Ae.textContent=ps,ln=l(),p(_e.$$.fragment),an=l(),p(Le.$$.fragment),on=l(),p(Ne.$$.fragment),rn=l(),p(We.$$.fragment),pn=l(),p(Be.$$.fragment),un=l(),p(Ve.$$.fragment),mn=l(),Ze=i("p"),Ze.innerHTML=us,cn=l(),Qe=i("p"),this.h()},l(e){const t=gs("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(n),ze=a(e),He=o(e,"P",{}),ms(He).forEach(n),Ge=a(e),u(M.$$.fragment,e),Re=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-ppiuvg"&&(T.textContent=yn),Xe=a(e),J=o(e,"OL",{"data-svelte-h":!0}),r(J)!=="svelte-bfl7te"&&(J.innerHTML=wn),Pe=a(e),u(C.$$.fragment,e),Ye=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1gnzyei"&&(v.innerHTML=gn),Fe=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1g253ra"&&(I.innerHTML=dn),De=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-zcjb5i"&&(x.textContent=Mn),qe=a(e),b=o(e,"OL",{"data-svelte-h":!0}),r(b)!=="svelte-aa5c1n"&&(b.innerHTML=Tn),Oe=a(e),u($.$$.fragment,e),Ke=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1y0w0e0"&&(j.textContent=Jn),et=a(e),u(U.$$.fragment,e),tt=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-19mf0fu"&&(S.textContent=Cn),nt=a(e),k=o(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-1ur9ox2"&&(k.innerHTML=vn),st=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-cd8ooq"&&(A.textContent=In),lt=a(e),u(_.$$.fragment,e),at=a(e),u(L.$$.fragment,e),it=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-mu91xn"&&(N.textContent=xn),ot=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1oqd42e"&&(W.textContent=bn),rt=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-tmf6ga"&&(B.textContent=$n),pt=a(e),u(V.$$.fragment,e),ut=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-r3bcy6"&&(Z.textContent=jn),mt=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-50wzvt"&&(E.innerHTML=Un),ct=a(e),H=o(e,"IMG",{src:!0,alt:!0}),ht=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-7wwfcf"&&(Q.textContent=kn),ft=a(e),z=o(e,"IMG",{src:!0,alt:!0}),yt=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-cgjl8t"&&(G.innerHTML=_n),wt=a(e),R=o(e,"IMG",{src:!0,alt:!0}),gt=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-11azj2p"&&(X.innerHTML=Nn),dt=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1j7ptbp"&&(P.innerHTML=Wn),Mt=a(e),Y=o(e,"IMG",{src:!0,alt:!0}),Tt=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-jwe09q"&&(F.innerHTML=Vn),Jt=a(e),D=o(e,"IMG",{src:!0,alt:!0}),Ct=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1hnrw8h"&&(q.textContent=En),vt=a(e),O=o(e,"IMG",{src:!0,alt:!0}),It=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-yyg7kn"&&(K.innerHTML=Qn),xt=a(e),u(ee.$$.fragment,e),bt=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-dpbyx7"&&(te.innerHTML=zn),$t=a(e),ne=o(e,"IMG",{src:!0,alt:!0}),jt=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-pmoe5"&&(se.innerHTML=Rn),Ut=a(e),u(le.$$.fragment,e),St=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1jd2fkg"&&(ae.innerHTML=Xn),kt=a(e),u(ie.$$.fragment,e),At=a(e),u(oe.$$.fragment,e),_t=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-va0ciz"&&(re.textContent=Pn),Lt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-20tg3z"&&(pe.textContent=Yn),Nt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-14ylm5t"&&(ue.textContent=Fn),Wt=a(e),u(me.$$.fragment,e),Bt=a(e),u(ce.$$.fragment,e),Vt=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-16s9nvc"&&(he.textContent=Dn),Zt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-kl6qgs"&&(fe.textContent=qn),Et=a(e),u(ye.$$.fragment,e),Ht=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-l0sx97"&&(we.textContent=On),Qt=a(e),u(ge.$$.fragment,e),zt=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1fn6l5y"&&(de.textContent=Kn),Gt=a(e),u(Me.$$.fragment,e),Rt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-ou1jyu"&&(Te.textContent=es),Xt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1965vx"&&(Je.textContent=ts),Pt=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-165fa3p"&&(Ce.textContent=ns),Yt=a(e),u(ve.$$.fragment,e),Ft=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-bzwe4m"&&(Ie.textContent=ss),Dt=a(e),xe=o(e,"OL",{"data-svelte-h":!0}),r(xe)!=="svelte-c41b6w"&&(xe.innerHTML=ls),qt=a(e),u(be.$$.fragment,e),Ot=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1qjg0mm"&&($e.textContent=as),Kt=a(e),je=o(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-204tif"&&(je.innerHTML=is),en=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-134n78l"&&(Ue.textContent=os),tn=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1xl7fn1"&&(Se.innerHTML=rs),nn=a(e),u(ke.$$.fragment,e),sn=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1fuys5u"&&(Ae.textContent=ps),ln=a(e),u(_e.$$.fragment,e),an=a(e),u(Le.$$.fragment,e),on=a(e),u(Ne.$$.fragment,e),rn=a(e),u(We.$$.fragment,e),pn=a(e),u(Be.$$.fragment,e),un=a(e),u(Ve.$$.fragment,e),mn=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1yywgqb"&&(Ze.innerHTML=us),cn=a(e),Qe=o(e,"P",{}),ms(Qe).forEach(n),this.h()},h(){y(d,"name","hf:doc:metadata"),y(d,"content",Ts),Ee(H.src,Sn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/01-name-instance.png")||y(H,"src",Sn),y(H,"alt","name instance"),Ee(z.src,An="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/02-search-ami.png")||y(z,"src",An),y(z,"alt","search ami"),Ee(R.src,Ln="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/03-select-ami.png")||y(R,"src",Ln),y(R,"alt","select ami"),Ee(Y.src,Bn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/04-select-key.png")||y(Y,"src",Bn),y(Y,"alt","select ssh key"),Ee(D.src,Zn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/05-select-sg.png")||y(D,"src",Zn),y(D,"alt","select security group"),Ee(O.src,Hn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/06-launch-instance.png")||y(O,"src",Hn),y(O,"alt","select ssh key"),Ee(ne.src,Gn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/07-copy-dns.png")||y(ne,"src",Gn),y(ne,"alt","select public dns")},m(e,t){ds(document.head,d),s(e,ze,t),s(e,He,t),s(e,Ge,t),m(M,e,t),s(e,Re,t),s(e,T,t),s(e,Xe,t),s(e,J,t),s(e,Pe,t),m(C,e,t),s(e,Ye,t),s(e,v,t),s(e,Fe,t),s(e,I,t),s(e,De,t),s(e,x,t),s(e,qe,t),s(e,b,t),s(e,Oe,t),m($,e,t),s(e,Ke,t),s(e,j,t),s(e,et,t),m(U,e,t),s(e,tt,t),s(e,S,t),s(e,nt,t),s(e,k,t),s(e,st,t),s(e,A,t),s(e,lt,t),m(_,e,t),s(e,at,t),m(L,e,t),s(e,it,t),s(e,N,t),s(e,ot,t),s(e,W,t),s(e,rt,t),s(e,B,t),s(e,pt,t),m(V,e,t),s(e,ut,t),s(e,Z,t),s(e,mt,t),s(e,E,t),s(e,ct,t),s(e,H,t),s(e,ht,t),s(e,Q,t),s(e,ft,t),s(e,z,t),s(e,yt,t),s(e,G,t),s(e,wt,t),s(e,R,t),s(e,gt,t),s(e,X,t),s(e,dt,t),s(e,P,t),s(e,Mt,t),s(e,Y,t),s(e,Tt,t),s(e,F,t),s(e,Jt,t),s(e,D,t),s(e,Ct,t),s(e,q,t),s(e,vt,t),s(e,O,t),s(e,It,t),s(e,K,t),s(e,xt,t),m(ee,e,t),s(e,bt,t),s(e,te,t),s(e,$t,t),s(e,ne,t),s(e,jt,t),s(e,se,t),s(e,Ut,t),m(le,e,t),s(e,St,t),s(e,ae,t),s(e,kt,t),m(ie,e,t),s(e,At,t),m(oe,e,t),s(e,_t,t),s(e,re,t),s(e,Lt,t),s(e,pe,t),s(e,Nt,t),s(e,ue,t),s(e,Wt,t),m(me,e,t),s(e,Bt,t),m(ce,e,t),s(e,Vt,t),s(e,he,t),s(e,Zt,t),s(e,fe,t),s(e,Et,t),m(ye,e,t),s(e,Ht,t),s(e,we,t),s(e,Qt,t),m(ge,e,t),s(e,zt,t),s(e,de,t),s(e,Gt,t),m(Me,e,t),s(e,Rt,t),s(e,Te,t),s(e,Xt,t),s(e,Je,t),s(e,Pt,t),s(e,Ce,t),s(e,Yt,t),m(ve,e,t),s(e,Ft,t),s(e,Ie,t),s(e,Dt,t),s(e,xe,t),s(e,qt,t),m(be,e,t),s(e,Ot,t),s(e,$e,t),s(e,Kt,t),s(e,je,t),s(e,en,t),s(e,Ue,t),s(e,tn,t),s(e,Se,t),s(e,nn,t),m(ke,e,t),s(e,sn,t),s(e,Ae,t),s(e,ln,t),m(_e,e,t),s(e,an,t),m(Le,e,t),s(e,on,t),m(Ne,e,t),s(e,rn,t),m(We,e,t),s(e,pn,t),m(Be,e,t),s(e,un,t),m(Ve,e,t),s(e,mn,t),s(e,Ze,t),s(e,cn,t),s(e,Qe,t),hn=!0},p:hs,i(e){hn||(c(M.$$.fragment,e),c(C.$$.fragment,e),c($.$$.fragment,e),c(U.$$.fragment,e),c(_.$$.fragment,e),c(L.$$.fragment,e),c(V.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),c(ge.$$.fragment,e),c(Me.$$.fragment,e),c(ve.$$.fragment,e),c(be.$$.fragment,e),c(ke.$$.fragment,e),c(_e.$$.fragment,e),c(Le.$$.fragment,e),c(Ne.$$.fragment,e),c(We.$$.fragment,e),c(Be.$$.fragment,e),c(Ve.$$.fragment,e),hn=!0)},o(e){h(M.$$.fragment,e),h(C.$$.fragment,e),h($.$$.fragment,e),h(U.$$.fragment,e),h(_.$$.fragment,e),h(L.$$.fragment,e),h(V.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(ye.$$.fragment,e),h(ge.$$.fragment,e),h(Me.$$.fragment,e),h(ve.$$.fragment,e),h(be.$$.fragment,e),h(ke.$$.fragment,e),h(_e.$$.fragment,e),h(Le.$$.fragment,e),h(Ne.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),hn=!1},d(e){e&&(n(ze),n(He),n(Ge),n(Re),n(T),n(Xe),n(J),n(Pe),n(Ye),n(v),n(Fe),n(I),n(De),n(x),n(qe),n(b),n(Oe),n(Ke),n(j),n(et),n(tt),n(S),n(nt),n(k),n(st),n(A),n(lt),n(at),n(it),n(N),n(ot),n(W),n(rt),n(B),n(pt),n(ut),n(Z),n(mt),n(E),n(ct),n(H),n(ht),n(Q),n(ft),n(z),n(yt),n(G),n(wt),n(R),n(gt),n(X),n(dt),n(P),n(Mt),n(Y),n(Tt),n(F),n(Jt),n(D),n(Ct),n(q),n(vt),n(O),n(It),n(K),n(xt),n(bt),n(te),n($t),n(ne),n(jt),n(se),n(Ut),n(St),n(ae),n(kt),n(At),n(_t),n(re),n(Lt),n(pe),n(Nt),n(ue),n(Wt),n(Bt),n(Vt),n(he),n(Zt),n(fe),n(Et),n(Ht),n(we),n(Qt),n(zt),n(de),n(Gt),n(Rt),n(Te),n(Xt),n(Je),n(Pt),n(Ce),n(Yt),n(Ft),n(Ie),n(Dt),n(xe),n(qt),n(Ot),n($e),n(Kt),n(je),n(en),n(Ue),n(tn),n(Se),n(nn),n(sn),n(Ae),n(ln),n(an),n(on),n(rn),n(pn),n(un),n(mn),n(Ze),n(cn),n(Qe)),n(d),f(M,e),f(C,e),f($,e),f(U,e),f(_,e),f(L,e),f(V,e),f(ee,e),f(le,e),f(ie,e),f(oe,e),f(me,e),f(ce,e),f(ye,e),f(ge,e),f(Me,e),f(ve,e),f(be,e),f(ke,e),f(_e,e),f(Le,e),f(Ne,e),f(We,e),f(Be,e),f(Ve,e)}}}const Ts='{"title":"EC2 Setup","local":"ec2-setup","sections":[{"title":"Recommended: AWS EC2 with Deep Learning AMI","local":"recommended-aws-ec2-with-deep-learning-ami","sections":[{"title":"Create an AWS Trainium or Inferentia instance on Amazon EC2 with the HF DLAMI","local":"create-an-aws-trainium-or-inferentia-instance-on-amazon-ec2-with-the-hf-dlami","sections":[{"title":"Find a supported region","local":"find-a-supported-region","sections":[],"depth":4},{"title":"Increase service quota","local":"increase-service-quota","sections":[],"depth":4},{"title":"Launch the Amazon EC2 instance with the HF DLAMI","local":"launch-the-amazon-ec2-instance-with-the-hf-dlami","sections":[],"depth":4},{"title":"Connect through SSH","local":"connect-through-ssh","sections":[],"depth":4}],"depth":3},{"title":"Set up your remote development environment","local":"set-up-your-remote-development-environment","sections":[{"title":"Access through Jupyter Notebook","local":"access-through-jupyter-notebook","sections":[],"depth":4},{"title":"Access through VS Code remote server","local":"access-through-vs-code-remote-server","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Alternative: Manual Installation","local":"alternative-manual-installation","sections":[{"title":"Adding pip packages URL","local":"adding-pip-packages-url","sections":[],"depth":3},{"title":"Installing optimum-neuron for AWS Trainium ( trn1 ) or AWS inferentia2 ( inf2 )","local":"installing-optimum-neuron-for-aws-trainium--trn1--or-aws-inferentia2--inf2-","sections":[],"depth":3},{"title":"Installing optimum-neuron for AWS inferentia ( inf1 )","local":"installing-optimum-neuron-for-aws-inferentia--inf1-","sections":[],"depth":3}],"depth":2},{"title":"What’s Next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function Js(fn){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends ys{constructor(d){super(),ws(this,d,Js,Ms,cs,{})}}export{bs as component};
