import{s as H,f as F,n as L,o as z}from"../chunks/scheduler.85c25b89.js";import{S as P,i as D,g as p,s as a,r as C,A as O,h as r,f as s,c as n,j as S,u as E,x as G,k as y,y as K,a as l,v,d as N,t as R,w as x}from"../chunks/index.c9bcf812.js";import{C as ee}from"../chunks/CodeBlock.c004bd26.js";import{H as $}from"../chunks/getInferenceSnippets.0fb0b8ca.js";function te(V){let i,w,J,T,c,g,m,k="There are several training techniques for personalizing diffusion models to generate images of a specific subject or images in certain styles. Each of these training methods produces a different type of adapter. Some of the adapters generate an entirely new model, while other adapters only modify a smaller set of embeddings or weights. This means the loading process for each adapter is also different.",b,u,A="This guide will show you how to load LoRA weights.",U,M,_,h,q="Low-Rank Adaptation is the fastest way for Stable Diffusion to adapt the styles of the generated images. In Optimum Neuron, we support using one or multiple LoRA adapters by fusing their parameters into the original parameters of the text encoder(s) and the unet during the compilation. Here below is an example of compiling stable diffusion models with LoRA adapters of your choice and using the compiled artifacts to generate styled images:",Z,d,B,o,Q,I,f,Y='Are there any other diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',W,j,X;return c=new $({props:{title:"Load adapters",local:"load-adapters",headingTag:"h1"}}),M=new $({props:{title:"LoRA",local:"lora",headingTag:"h2"}}),d=new ee({props:{code:"JTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExDTVNjaGVkdWxlciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJMeWtvbiUyRmRyZWFtc2hhcGVyLTclMjIlMEFhZGFwdGVyX2lkJTIwJTNEJTIwJTIybGF0ZW50LWNvbnNpc3RlbmN5JTJGbGNtLWxvcmEtc2R2MS01JTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMDElN0QlMEFjb21waWxlcl9hcmdzJTIwJTNEJTIwJTdCJTIyYXV0b19jYXN0JTIyJTNBJTIwJTIybWF0bXVsJTIyJTJDJTIwJTIyYXV0b19jYXN0X3R5cGUlMjIlM0ElMjAlMjJiZjE2JTIyJTdEJTBBJTBBJTIzJTIwQ29tcGlsZSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwaW5saW5lX3dlaWdodHNfdG9fbmVmZiUzRFRydWUlMkMlMjAlMjAlMjMlMjBjYXZlYXQlM0ElMjBwZXJmb3JtYW5jZSUyMGRyb3AlMjBpZiUyMG5lZmYlMkZ3ZWlnaHRzJTIwc2VwYXJhdGVkJTJDJTIwd2lsbCUyMGJlJTIwaW1wcm92ZWQlMjBieSUyMGElMjBmdXR1cmUlMjBOZXVyb24lMjBzZGslMjByZWxlYXNlLiUwQSUyMCUyMCUyMCUyMGxvcmFfbW9kZWxfaWRzJTNEYWRhcHRlcl9pZCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfd2VpZ2h0X25hbWVzJTNEJTIycHl0b3JjaF9sb3JhX3dlaWdodHMuc2FmZXRlbnNvcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FkYXB0ZXJfbmFtZXMlM0QlMjJsY20lMjIlMkMlMEElMjAlMjAlMjAlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSUyMCUyMCUyMCUyMCoqY29tcGlsZXJfYXJncyUyQyUwQSklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBJTIzJTIwU2F2ZSUyMGxvY2FsbHklMjBvciUyMHVwbG9hZCUyMHRvJTIwdGhlJTIwSHVnZ2luZ0ZhY2UlMjBIdWIlMEFwaXBlLnNhdmVfcHJldHJhaW5lZCglMjJkcmVhbXNoYXBlcl83X2xjbV9sb3JhX25ldXJvbiUyRiUyMiklMEElMEElMEElMjMlMjBJbmZlcmVuY2UlMEFwcm9tcHQlMjAlM0QlMjAlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LCMScheduler
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline


model_id = <span class="hljs-string">&quot;Lykon/dreamshaper-7&quot;</span>
adapter_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: <span class="hljs-number">1</span>}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

<span class="hljs-comment"># Compile</span>
pipe = NeuronStableDiffusionPipeline.from_pretrained(
    model_id,
    export=<span class="hljs-literal">True</span>,
    inline_weights_to_neff=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># caveat: performance drop if neff/weights separated, will be improved by a future Neuron sdk release.</span>
    lora_model_ids=adapter_id,
    lora_weight_names=<span class="hljs-string">&quot;pytorch_lora_weights.safetensors&quot;</span>,
    lora_adapter_names=<span class="hljs-string">&quot;lcm&quot;</span>,
    **input_shapes,
    **compiler_args,
)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
pipe.save_pretrained(<span class="hljs-string">&quot;dreamshaper_7_lcm_lora_neuron/&quot;</span>)


<span class="hljs-comment"># Inference</span>
prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">0</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=p("meta"),w=a(),J=p("p"),T=a(),C(c.$$.fragment),g=a(),m=p("p"),m.textContent=k,b=a(),u=p("p"),u.textContent=A,U=a(),C(M.$$.fragment),_=a(),h=p("p"),h.textContent=q,Z=a(),C(d.$$.fragment),B=a(),o=p("img"),I=a(),f=p("p"),f.innerHTML=Y,W=a(),j=p("p"),this.h()},l(e){const t=O("svelte-u9bgzb",document.head);i=r(t,"META",{name:!0,content:!0}),t.forEach(s),w=n(e),J=r(e,"P",{}),S(J).forEach(s),T=n(e),E(c.$$.fragment,e),g=n(e),m=r(e,"P",{"data-svelte-h":!0}),G(m)!=="svelte-1p7c5ip"&&(m.textContent=k),b=n(e),u=r(e,"P",{"data-svelte-h":!0}),G(u)!=="svelte-3y0v6y"&&(u.textContent=A),U=n(e),E(M.$$.fragment,e),_=n(e),h=r(e,"P",{"data-svelte-h":!0}),G(h)!=="svelte-w90myx"&&(h.textContent=q),Z=n(e),E(d.$$.fragment,e),B=n(e),o=r(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),I=n(e),f=r(e,"P",{"data-svelte-h":!0}),G(f)!=="svelte-1wos5lv"&&(f.innerHTML=Y),W=n(e),j=r(e,"P",{}),S(j).forEach(s),this.h()},h(){y(i,"name","hf:doc:metadata"),y(i,"content",se),F(o.src,Q="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/03-sd-lora.png")||y(o,"src",Q),y(o,"width","256"),y(o,"height","256"),y(o,"alt","stable diffusion generated image with LoRA adapter.")},m(e,t){K(document.head,i),l(e,w,t),l(e,J,t),l(e,T,t),v(c,e,t),l(e,g,t),l(e,m,t),l(e,b,t),l(e,u,t),l(e,U,t),v(M,e,t),l(e,_,t),l(e,h,t),l(e,Z,t),v(d,e,t),l(e,B,t),l(e,o,t),l(e,I,t),l(e,f,t),l(e,W,t),l(e,j,t),X=!0},p:L,i(e){X||(N(c.$$.fragment,e),N(M.$$.fragment,e),N(d.$$.fragment,e),X=!0)},o(e){R(c.$$.fragment,e),R(M.$$.fragment,e),R(d.$$.fragment,e),X=!1},d(e){e&&(s(w),s(J),s(T),s(g),s(m),s(b),s(u),s(U),s(_),s(h),s(Z),s(B),s(o),s(I),s(f),s(W),s(j)),s(i),x(c,e),x(M,e),x(d,e)}}}const se='{"title":"Load adapters","local":"load-adapters","sections":[{"title":"LoRA","local":"lora","sections":[],"depth":2}],"depth":1}';function le(V){return z(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pe extends P{constructor(i){super(),D(this,i,le,te,H,{})}}export{pe as component};
