import{s as ft,f as Ke,n as _t,o as ht}from"../chunks/scheduler.85c25b89.js";import{S as bt,i as Nt,g as m,s as i,r as s,A as yt,h as u,f as n,c as a,j as le,u as l,x as f,k as g,y as _,a as o,v as r,d as c,t as p,w as d}from"../chunks/index.c9bcf812.js";import{D as Ye}from"../chunks/Docstring.053648e3.js";import{C as ne}from"../chunks/CodeBlock.c004bd26.js";import{H as h}from"../chunks/getInferenceSnippets.0fb0b8ca.js";function Mt(et){let N,pe,re,de,C,me,U,tt="ControlNet conditions the stable diffusion model with an additional input image. In Optimum Neuron, we support the compilation of one or multiple ControlNet(s) along with the stable diffusion checkpoint. Then you can use the compiled artifacts to generate styled images.",ue,j,ge,x,nt="We can either compile one or multiple ControlNet via the Optimum CLI or programmatically via the <code>NeuronStableDiffusionControlNetPipeline</code> class by passing the <code>controlnet_ids</code>.",fe,I,_e,Z,he,k,be,W,Ne,S,ye,G,ot="For text-to-image, we can specify an additional conditioning input.",Me,X,it="Here is an example with a canny image, a white outline of an image on a black background. The ControlNet will use the canny image as a control to guide the model to generate an image with the same outline.",we,B,Te,y,at,ve,P,Je,$,st="With Optimum Neuron, you can also compose multiple ControlNet conditionings from different image inputs:",Ce,D,lt="<li>Compile multiple ControlNet for SD1.5</li>",Ue,V,je,E,rt="<li>Run SD1.5 with OpenPose and Depth conditionings:</li>",xe,L,Ie,M,ct,Ze,z,ke,F,We,R,Se,Y,Ge,Q,Xe,w,pt,Be,A,Pe,T,H,Qe,J,q,Ae,oe,dt="The call function to the pipeline for generation.",$e,O,De,v,K,He,b,ee,qe,ie,mt="The call function to the pipeline for generation.",Oe,ae,ut="Examples:",Ve,te,gt='Are there any other diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',Ee,ce,Le;return C=new h({props:{title:"ControlNet",local:"controlnet",headingTag:"h1"}}),j=new h({props:{title:"Export to Neuron",local:"export-to-neuron",headingTag:"h2"}}),I=new h({props:{title:"Option 1: CLI",local:"option-1-cli",headingTag:"h3"}}),Z=new ne({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAtLWhlaWdodCUyMDUxMiUyMC0td2lkdGglMjA1MTIlMjAtLWNvbnRyb2xuZXRfaWRzJTIwbGxseWFzdmllbCUyRnNkLWNvbnRyb2xuZXQtY2FubnklMjAtLW51bV9pbWFnZXNfcGVyX3Byb21wdCUyMDElMjBzZF9uZXVyb25fY29udHJvbG5ldCUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m stable-diffusion-v1-5/stable-diffusion-v1-5 --batch_size 1 --height 512 --width 512 --controlnet_ids lllyasviel/sd-controlnet-canny --num_images_per_prompt 1 sd_neuron_controlnet/',wrap:!1}}),k=new h({props:{title:"Option 2: Python API",local:"option-2-python-api",headingTag:"h3"}}),W=new ne({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFjb250cm9sbmV0X2lkJTIwJTNEJTIwJTIybGxseWFzdmllbCUyRnNkLWNvbnRyb2xuZXQtY2FubnklMjIlMEElMEElMjMlMjAlNUJOZXVyb24lNUQlMjBwaXBlbGluZSUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlMkMlMjAlMjJudW1faW1hZ2VzX3Blcl9wcm9tcHQlMjIlM0ElMjAxJTdEJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9pZHMlM0Rjb250cm9sbmV0X2lkJTJDJTBBJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCoqaW5wdXRfc2hhcGVzJTJDJTBBJTIwJTIwJTIwJTIwKipjb21waWxlcl9hcmdzJTJDJTBBKSUwQXBpcGUuc2F2ZV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl9jb250cm9sbmV0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
controlnet_id = <span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>

<span class="hljs-comment"># [Neuron] pipeline</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: <span class="hljs-number">1</span>}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(
    model_id,
    controlnet_ids=controlnet_id,
    export=<span class="hljs-literal">True</span>,
    **input_shapes,
    **compiler_args,
)
pipe.save_pretrained(<span class="hljs-string">&quot;sd_neuron_controlnet&quot;</span>)`,wrap:!1}}),S=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h2"}}),B=new ne({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25TdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUlMEElMEElMEElMjMlMjBwcmVwYXJlJTIwY2FubnklMjBpbWFnZSUwQW9yaWdpbmFsX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnB1dF9pbWFnZV92ZXJtZWVyLnBuZyUyMiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEFjYW5ueV9pbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEElMEElMjMlMjBsb2FkJTIwcHJlLWNvbXBpbGVkJTIwbmV1cm9uJTIwbW9kZWwlMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25fY29udHJvbG5ldCUyMiklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEElMjMlMjBpbmZlcmVuY2UlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKCUyMnRoZSUyMG1vbmElMjBsaXNhJTIyJTJDJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWNvbXBhcmUlMjAlM0QlMjBtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMpJTBBY29tcGFyZS5zYXZlKCUyMmNvbXBhcmUucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline


<span class="hljs-comment"># prepare canny image</span>
original_image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

<span class="hljs-comment"># load pre-compiled neuron model</span>
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_controlnet&quot;</span>)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># inference</span>
output = pipe(<span class="hljs-string">&quot;the mona lisa&quot;</span>, image=canny_image).images[<span class="hljs-number">0</span>]
compare = make_image_grid([original_image, canny_image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)
compare.save(<span class="hljs-string">&quot;compare.png&quot;</span>)`,wrap:!1}}),P=new h({props:{title:"MultiControlNet",local:"multicontrolnet",headingTag:"h2"}}),V=new ne({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLWlubGluZS13ZWlnaHRzLW5lZmYlMjAtLW1vZGVsJTIwanlvdW5nMTA1JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbiUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwLS1hdXRvX2Nhc3RfdHlwZSUyMGJmMTYlMjAtLWJhdGNoX3NpemUlMjAxJTIwLS1udW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAxJTIwLS1jb250cm9sbmV0X2lkcyUyMGxsbHlhc3ZpZWwlMkZjb250cm9sX3YxMXBfc2QxNV9vcGVucG9zZSUyMGxsbHlhc3ZpZWwlMkZjb250cm9sX3YxMWYxcF9zZDE1X2RlcHRoJTIwLS1oZWlnaHQlMjA1MTIlMjAtLXdpZHRoJTIwNTEyJTIwc2QxNS01MTJ4NTEyLWJmMTYtb3BlbnBvc2UtZGVwdGg=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --inline-weights-neff --model jyoung105/stable-diffusion-v1-5 --task stable-diffusion --auto_cast matmul --auto_cast_type bf16 --batch_size 1 --num_images_per_prompt 1 --controlnet_ids lllyasviel/control_v11p_sd15_openpose lllyasviel/control_v11f1p_sd15_depth --height 512 --width 512 sd15-512x512-bf16-openpose-depth',wrap:!1}}),L=new ne({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> OpenposeDetector
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline


<span class="hljs-comment"># OpenPose+Depth ControlNet</span>
model_id = <span class="hljs-string">&quot;sd15-512x512-bf16-openpose-depth&quot;</span>

<span class="hljs-comment"># Load ControlNet images</span>

<span class="hljs-comment"># 1. openpose</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/control_v11p_sd15_openpose/resolve/main/images/input.png&quot;</span>)
processor = OpenposeDetector.from_pretrained(<span class="hljs-string">&#x27;lllyasviel/ControlNet&#x27;</span>)
openpose_image = processor(image)

<span class="hljs-comment"># 2. depth</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/control_v11p_sd15_depth/resolve/main/images/input.png&quot;</span>)
depth_estimator = pipeline(<span class="hljs-string">&#x27;depth-estimation&#x27;</span>)
image = depth_estimator(image)[<span class="hljs-string">&#x27;depth&#x27;</span>]
image = np.array(image)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
depth_image = Image.fromarray(image)

images = [openpose_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>)), depth_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))]

<span class="hljs-comment"># 3. inference</span>
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(model_id)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
prompt = <span class="hljs-string">&quot;a giant in a fantasy landscape, best quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>

image = pipe(prompt=prompt, image=images).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;out.png&#x27;</span>)`,wrap:!1}}),z=new h({props:{title:"ControlNet with Stable Diffusion XL",local:"controlnet-with-stable-diffusion-xl",headingTag:"h2"}}),F=new h({props:{title:"Export to Neuron",local:"export-to-neuron",headingTag:"h3"}}),R=new ne({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMC0tdGFzayUyMHN0YWJsZS1kaWZmdXNpb24teGwlMjAtLWJhdGNoX3NpemUlMjAxJTIwLS1oZWlnaHQlMjAxMDI0JTIwLS13aWR0aCUyMDEwMjQlMjAtLWNvbnRyb2xuZXRfaWRzJTIwZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS1zZHhsLTEuMC1zbWFsbCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwMSUyMHNkeGxfbmV1cm9uX2NvbnRyb2xuZXQlMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m stabilityai/stable-diffusion-xl-base-1.0 --task stable-diffusion-xl --batch_size 1 --height 1024 --width 1024 --controlnet_ids diffusers/controlnet-canny-sdxl-1.0-small --num_images_per_prompt 1 sdxl_neuron_controlnet/',wrap:!1}}),Y=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Q=new ne({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTENvbnRyb2xOZXRQaXBlbGluZSUwQSUwQSUyMyUyMElucHV0cyUwQXByb21wdCUyMCUzRCUyMCUyMmFlcmlhbCUyMHZpZXclMkMlMjBhJTIwZnV0dXJpc3RpYyUyMHJlc2VhcmNoJTIwY29tcGxleCUyMGluJTIwYSUyMGJyaWdodCUyMGZvZ2d5JTIwanVuZ2xlJTJDJTIwaGFyZCUyMGxpZ2h0aW5nJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIybG93JTIwcXVhbGl0eSUyQyUyMGJhZCUyMHF1YWxpdHklMkMlMjBza2V0Y2hlcyUyMiUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc2RfY29udHJvbG5ldCUyRmhmLWxvZ28ucG5nJTIyJTBBKSUwQWltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpJTBBaW1hZ2UlMjAlM0QlMjBjdjIuQ2FubnkoaW1hZ2UlMkMlMjAxMDAlMkMlMjAyMDApJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEFpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQSUwQWNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTIwJTNEJTIwMC41JTIwJTIwJTIzJTIwcmVjb21tZW5kZWQlMjBmb3IlMjBnb29kJTIwZ2VuZXJhbGl6YXRpb24lMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkeGxfbmV1cm9uX2NvbnRyb2xuZXQlMjIpJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0Rjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMmh1Z19sYWIucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLControlNetPipeline

<span class="hljs-comment"># Inputs</span>
prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
)
image = np.array(image)
image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
image = Image.fromarray(image)

controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>

pipe = NeuronStableDiffusionXLControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;sdxl_neuron_controlnet&quot;</span>)

images = pipe(
    prompt,
    negative_prompt=negative_prompt,
    image=image,
    controlnet_conditioning_scale=controlnet_conditioning_scale,
).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;hug_lab.png&quot;</span>)`,wrap:!1}}),A=new h({props:{title:"NeuronStableDiffusionControlNetPipeline",local:"optimum.neuron.NeuronStableDiffusionControlNetPipeline",headingTag:"h2"}}),H=new Ye({props:{name:"class optimum.neuron.NeuronStableDiffusionControlNetPipeline",anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1559"}}),q=new Ye({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__",parameters:[{name:"prompt",val:": str | list[str] | None = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": list[int] | None = None"},{name:"sigmas",val:": list[float] | None = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": str | list[str] | None = None"},{name:"num_images_per_prompt",val:": int | None = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": torch._C.Generator | list[torch._C.Generator] | None = None"},{name:"latents",val:": torch.Tensor | None = None"},{name:"prompt_embeds",val:": torch.Tensor | None = None"},{name:"negative_prompt_embeds",val:": torch.Tensor | None = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": list[torch.Tensor] | None = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"controlnet_conditioning_scale",val:": float | list[float] = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": float | list[float] = 0.0"},{name:"control_guidance_end",val:": float | list[float] = 1.0"},{name:"clip_skip",val:": int | None = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": list[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str | list[str] | None</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>&quot;PipelineImageInput&quot; | None</code>, defaults to <code>None</code>) &#x2014;
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet. When <code>prompt</code> is a list, and if a list of images is passed for a single
ControlNet, each will be paired with each prompt in the <code>prompt</code> list. This also applies to multiple
ControlNets, where a list of image lists can be passed to batch for each prompt and each ControlNet.`,name:"image"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>list[int] | None</code>, defaults to <code>None</code>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>list[int] | None</code>, defaults to <code>None</code>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str | list[str] | None</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt. If it is different from the batch size used for the compiltaion,
it will be overridden by the static batch size of neuron (except for dynamic batching).`,name:"num_images_per_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <code>diffusers.schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator | list[torch.Generator] | None</code>, defaults to <code>None</code>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput | None</code>, defaults to <code>None</code>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>list[torch.Tensor] | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict[str, Any] | None</code>, defaults to <code>None</code>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float | list[float]</code>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float | list[float]</code>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float | list[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int | None</code>, defaults to <code>None</code>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable[[int, int, dict], None] | PipelineCallback | MultiPipelineCallbacks | None</code>, defaults to <code>None</code>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>list[str]</code>, defaults to <code>[&quot;latents&quot;]</code>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/pipelines/diffusers/pipeline_controlnet.py#L33",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),O=new h({props:{title:"NeuronStableDiffusionXLControlNetPipeline",local:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline",headingTag:"h2"}}),K=new Ye({props:{name:"class optimum.neuron.NeuronStableDiffusionXLControlNetPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1611"}}),ee=new Ye({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__",parameters:[{name:"prompt",val:": str | list[str] | None = None"},{name:"prompt_2",val:": str | list[str] | None = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": list[int] | None = None"},{name:"sigmas",val:": list[float] | None = None"},{name:"denoising_end",val:": float | None = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": str | list[str] | None = None"},{name:"negative_prompt_2",val:": str | list[str] | None = None"},{name:"num_images_per_prompt",val:": int | None = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": torch._C.Generator | list[torch._C.Generator] | None = None"},{name:"latents",val:": torch.Tensor | None = None"},{name:"prompt_embeds",val:": torch.Tensor | None = None"},{name:"negative_prompt_embeds",val:": torch.Tensor | None = None"},{name:"pooled_prompt_embeds",val:": torch.Tensor | None = None"},{name:"negative_pooled_prompt_embeds",val:": torch.Tensor | None = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": list[torch.Tensor] | None = None"},{name:"output_type",val:": str | None = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"controlnet_conditioning_scale",val:": float | list[float] = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": float | list[float] = 0.0"},{name:"control_guidance_end",val:": float | list[float] = 1.0"},{name:"original_size",val:": tuple[int, int] | None = None"},{name:"crops_coords_top_left",val:": tuple[int, int] = (0, 0)"},{name:"target_size",val:": tuple[int, int] | None = None"},{name:"negative_original_size",val:": tuple[int, int] | None = None"},{name:"negative_crops_coords_top_left",val:": tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": tuple[int, int] | None = None"},{name:"clip_skip",val:": int | None = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": list[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str | list[str]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str | list[str]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders.`,name:"prompt_2"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput | None</code>, defaults to <code>None</code>) &#x2014;
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image default to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"image"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>list[int] | None</code>, defaults to <code>None</code>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>list[float] | None</code>, defaults to <code>None</code>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float | None</code>, defaults to <code>None</code>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 5.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str | list[str] | None</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str | list[str] | None</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide what to not include in image generation. This is sent to <code>tokenizer_2</code>
and <code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <code>diffusers.schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator | list[torch.Generator] | None</code>, defaults to <code>None</code>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, pooled text embeddings are generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs (prompt
weighting). If not provided, pooled <code>negative_prompt_embeds</code> are generated from <code>negative_prompt</code> input
argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput | None</code>, defaults to <code>None</code>) &#x2014;
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>list[torch.Tensor] | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length the same as the number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str | None</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict[str, Any] | None</code>, defaults to <code>None</code>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float | list[float]</code>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float | list[float]</code>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float | list[float]</code>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>tuple[int, int] | None</code>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code>, the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>tuple[int, int]</code>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>tuple[int, int] | None</code>, defaults to <code>None</code>) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified, it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>tuple[int, int] | None</code>, defaults to <code>None</code>) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>tuple[int, int]</code>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>tuple[int, int] | None</code>, defaults to <code>None</code>) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be the same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int | None</code>, defaults to <code>None</code>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable[[int, int, dict], None] | PipelineCallback | MultiPipelineCallbacks | None</code>, defaults to <code>None</code>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>list[str]</code>, defaults to <code>[&quot;latents&quot;]</code>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/pipelines/diffusers/pipeline_controlnet_sd_xl.py#L37",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned containing the output images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),{c(){N=m("meta"),pe=i(),re=m("p"),de=i(),s(C.$$.fragment),me=i(),U=m("p"),U.textContent=tt,ue=i(),s(j.$$.fragment),ge=i(),x=m("p"),x.innerHTML=nt,fe=i(),s(I.$$.fragment),_e=i(),s(Z.$$.fragment),he=i(),s(k.$$.fragment),be=i(),s(W.$$.fragment),Ne=i(),s(S.$$.fragment),ye=i(),G=m("p"),G.textContent=ot,Me=i(),X=m("p"),X.textContent=it,we=i(),s(B.$$.fragment),Te=i(),y=m("img"),ve=i(),s(P.$$.fragment),Je=i(),$=m("p"),$.textContent=st,Ce=i(),D=m("ul"),D.innerHTML=lt,Ue=i(),s(V.$$.fragment),je=i(),E=m("ul"),E.innerHTML=rt,xe=i(),s(L.$$.fragment),Ie=i(),M=m("img"),Ze=i(),s(z.$$.fragment),ke=i(),s(F.$$.fragment),We=i(),s(R.$$.fragment),Se=i(),s(Y.$$.fragment),Ge=i(),s(Q.$$.fragment),Xe=i(),w=m("img"),Be=i(),s(A.$$.fragment),Pe=i(),T=m("div"),s(H.$$.fragment),Qe=i(),J=m("div"),s(q.$$.fragment),Ae=i(),oe=m("p"),oe.textContent=dt,$e=i(),s(O.$$.fragment),De=i(),v=m("div"),s(K.$$.fragment),He=i(),b=m("div"),s(ee.$$.fragment),qe=i(),ie=m("p"),ie.textContent=mt,Oe=i(),ae=m("p"),ae.textContent=ut,Ve=i(),te=m("p"),te.innerHTML=gt,Ee=i(),ce=m("p"),this.h()},l(e){const t=yt("svelte-u9bgzb",document.head);N=u(t,"META",{name:!0,content:!0}),t.forEach(n),pe=a(e),re=u(e,"P",{}),le(re).forEach(n),de=a(e),l(C.$$.fragment,e),me=a(e),U=u(e,"P",{"data-svelte-h":!0}),f(U)!=="svelte-13p02iy"&&(U.textContent=tt),ue=a(e),l(j.$$.fragment,e),ge=a(e),x=u(e,"P",{"data-svelte-h":!0}),f(x)!=="svelte-sp0xt6"&&(x.innerHTML=nt),fe=a(e),l(I.$$.fragment,e),_e=a(e),l(Z.$$.fragment,e),he=a(e),l(k.$$.fragment,e),be=a(e),l(W.$$.fragment,e),Ne=a(e),l(S.$$.fragment,e),ye=a(e),G=u(e,"P",{"data-svelte-h":!0}),f(G)!=="svelte-s2jfwm"&&(G.textContent=ot),Me=a(e),X=u(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-e5xot3"&&(X.textContent=it),we=a(e),l(B.$$.fragment,e),Te=a(e),y=u(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),ve=a(e),l(P.$$.fragment,e),Je=a(e),$=u(e,"P",{"data-svelte-h":!0}),f($)!=="svelte-ve8s8f"&&($.textContent=st),Ce=a(e),D=u(e,"UL",{"data-svelte-h":!0}),f(D)!=="svelte-16kkb80"&&(D.innerHTML=lt),Ue=a(e),l(V.$$.fragment,e),je=a(e),E=u(e,"UL",{"data-svelte-h":!0}),f(E)!=="svelte-1pbmybe"&&(E.innerHTML=rt),xe=a(e),l(L.$$.fragment,e),Ie=a(e),M=u(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Ze=a(e),l(z.$$.fragment,e),ke=a(e),l(F.$$.fragment,e),We=a(e),l(R.$$.fragment,e),Se=a(e),l(Y.$$.fragment,e),Ge=a(e),l(Q.$$.fragment,e),Xe=a(e),w=u(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Be=a(e),l(A.$$.fragment,e),Pe=a(e),T=u(e,"DIV",{class:!0});var ze=le(T);l(H.$$.fragment,ze),Qe=a(ze),J=u(ze,"DIV",{class:!0});var Fe=le(J);l(q.$$.fragment,Fe),Ae=a(Fe),oe=u(Fe,"P",{"data-svelte-h":!0}),f(oe)!=="svelte-50j04k"&&(oe.textContent=dt),Fe.forEach(n),ze.forEach(n),$e=a(e),l(O.$$.fragment,e),De=a(e),v=u(e,"DIV",{class:!0});var Re=le(v);l(K.$$.fragment,Re),He=a(Re),b=u(Re,"DIV",{class:!0});var se=le(b);l(ee.$$.fragment,se),qe=a(se),ie=u(se,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-50j04k"&&(ie.textContent=mt),Oe=a(se),ae=u(se,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-kvfsh7"&&(ae.textContent=ut),se.forEach(n),Re.forEach(n),Ve=a(e),te=u(e,"P",{"data-svelte-h":!0}),f(te)!=="svelte-1wos5lv"&&(te.innerHTML=gt),Ee=a(e),ce=u(e,"P",{}),le(ce).forEach(n),this.h()},h(){g(N,"name","hf:doc:metadata"),g(N,"content",wt),Ke(y.src,at="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/10-sd-text2img-controlnet.png?download=true")||g(y,"src",at),g(y,"width","768"),g(y,"height","256"),g(y,"alt","stable diffusion 1.5 generated image with controlnet."),Ke(M.src,ct="https://huggingface.co/datasets/Jingya/document_images/resolve/main/optimum/neuron/multicontrolnet.png")||g(M,"src",ct),g(M,"width","768"),g(M,"height","256"),g(M,"alt","stable diffusion 1.5 generated image with OpenPose and Depth controlnet."),Ke(w.src,pt="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/12-sdxl-text2img-controlnet.png?download=true")||g(w,"src",pt),g(w,"width","768"),g(w,"height","256"),g(w,"alt","stable diffusion xl generated image with controlnet."),g(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){_(document.head,N),o(e,pe,t),o(e,re,t),o(e,de,t),r(C,e,t),o(e,me,t),o(e,U,t),o(e,ue,t),r(j,e,t),o(e,ge,t),o(e,x,t),o(e,fe,t),r(I,e,t),o(e,_e,t),r(Z,e,t),o(e,he,t),r(k,e,t),o(e,be,t),r(W,e,t),o(e,Ne,t),r(S,e,t),o(e,ye,t),o(e,G,t),o(e,Me,t),o(e,X,t),o(e,we,t),r(B,e,t),o(e,Te,t),o(e,y,t),o(e,ve,t),r(P,e,t),o(e,Je,t),o(e,$,t),o(e,Ce,t),o(e,D,t),o(e,Ue,t),r(V,e,t),o(e,je,t),o(e,E,t),o(e,xe,t),r(L,e,t),o(e,Ie,t),o(e,M,t),o(e,Ze,t),r(z,e,t),o(e,ke,t),r(F,e,t),o(e,We,t),r(R,e,t),o(e,Se,t),r(Y,e,t),o(e,Ge,t),r(Q,e,t),o(e,Xe,t),o(e,w,t),o(e,Be,t),r(A,e,t),o(e,Pe,t),o(e,T,t),r(H,T,null),_(T,Qe),_(T,J),r(q,J,null),_(J,Ae),_(J,oe),o(e,$e,t),r(O,e,t),o(e,De,t),o(e,v,t),r(K,v,null),_(v,He),_(v,b),r(ee,b,null),_(b,qe),_(b,ie),_(b,Oe),_(b,ae),o(e,Ve,t),o(e,te,t),o(e,Ee,t),o(e,ce,t),Le=!0},p:_t,i(e){Le||(c(C.$$.fragment,e),c(j.$$.fragment,e),c(I.$$.fragment,e),c(Z.$$.fragment,e),c(k.$$.fragment,e),c(W.$$.fragment,e),c(S.$$.fragment,e),c(B.$$.fragment,e),c(P.$$.fragment,e),c(V.$$.fragment,e),c(L.$$.fragment,e),c(z.$$.fragment,e),c(F.$$.fragment,e),c(R.$$.fragment,e),c(Y.$$.fragment,e),c(Q.$$.fragment,e),c(A.$$.fragment,e),c(H.$$.fragment,e),c(q.$$.fragment,e),c(O.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),Le=!0)},o(e){p(C.$$.fragment,e),p(j.$$.fragment,e),p(I.$$.fragment,e),p(Z.$$.fragment,e),p(k.$$.fragment,e),p(W.$$.fragment,e),p(S.$$.fragment,e),p(B.$$.fragment,e),p(P.$$.fragment,e),p(V.$$.fragment,e),p(L.$$.fragment,e),p(z.$$.fragment,e),p(F.$$.fragment,e),p(R.$$.fragment,e),p(Y.$$.fragment,e),p(Q.$$.fragment,e),p(A.$$.fragment,e),p(H.$$.fragment,e),p(q.$$.fragment,e),p(O.$$.fragment,e),p(K.$$.fragment,e),p(ee.$$.fragment,e),Le=!1},d(e){e&&(n(pe),n(re),n(de),n(me),n(U),n(ue),n(ge),n(x),n(fe),n(_e),n(he),n(be),n(Ne),n(ye),n(G),n(Me),n(X),n(we),n(Te),n(y),n(ve),n(Je),n($),n(Ce),n(D),n(Ue),n(je),n(E),n(xe),n(Ie),n(M),n(Ze),n(ke),n(We),n(Se),n(Ge),n(Xe),n(w),n(Be),n(Pe),n(T),n($e),n(De),n(v),n(Ve),n(te),n(Ee),n(ce)),n(N),d(C,e),d(j,e),d(I,e),d(Z,e),d(k,e),d(W,e),d(S,e),d(B,e),d(P,e),d(V,e),d(L,e),d(z,e),d(F,e),d(R,e),d(Y,e),d(Q,e),d(A,e),d(H),d(q),d(O,e),d(K),d(ee)}}}const wt='{"title":"ControlNet","local":"controlnet","sections":[{"title":"Export to Neuron","local":"export-to-neuron","sections":[{"title":"Option 1: CLI","local":"option-1-cli","sections":[],"depth":3},{"title":"Option 2: Python API","local":"option-2-python-api","sections":[],"depth":3}],"depth":2},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":2},{"title":"MultiControlNet","local":"multicontrolnet","sections":[],"depth":2},{"title":"ControlNet with Stable Diffusion XL","local":"controlnet-with-stable-diffusion-xl","sections":[{"title":"Export to Neuron","local":"export-to-neuron","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"NeuronStableDiffusionControlNetPipeline","local":"optimum.neuron.NeuronStableDiffusionControlNetPipeline","sections":[],"depth":2},{"title":"NeuronStableDiffusionXLControlNetPipeline","local":"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline","sections":[],"depth":2}],"depth":1}';function Tt(et){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends bt{constructor(N){super(),Nt(this,N,Tt,Mt,ft,{})}}export{xt as component};
