import{s as ke,o as ze,n as Xe}from"../chunks/scheduler.85c25b89.js";import{S as Re,i as Ge,g as M,s as l,r as i,A as Ne,h as y,f as n,c as a,j as Se,u as m,x as h,k as ve,y as Qe,a as s,v as c,d as p,t as d,w as u}from"../chunks/index.c9bcf812.js";import{T as xe}from"../chunks/Tip.d8f753fa.js";import{C as A}from"../chunks/CodeBlock.c004bd26.js";import{H as j}from"../chunks/getInferenceSnippets.0fb0b8ca.js";function He(D){let r,Z="<strong>Caveat</strong>",T,b,J="Since compiled models with dynamic batching enabled only accept input tensors with the same batch size, we cannot set <code>dynamic_batch_size=True</code> if the input texts and images have different batch sizes. And as <code>NeuronModelForSentenceTransformers</code> class pads the inputs to the batch sizes (<code>text_batch_size</code> and <code>image_batch_size</code>) used during the compilation, you could use relatively larger batch sizes during the compilation for flexibility with the trade-off of compute.",w,f,g="eg. if you want to encode 3 or 4 or 5 texts and 1 image, you could set <code>text_batch_size = 5 = max(3, 4, 5)</code> and <code>image_batch_size = 1</code> during the compilation.";return{c(){r=M("p"),r.innerHTML=Z,T=l(),b=M("p"),b.innerHTML=J,w=l(),f=M("p"),f.innerHTML=g},l(o){r=y(o,"P",{"data-svelte-h":!0}),h(r)!=="svelte-6rj1id"&&(r.innerHTML=Z),T=a(o),b=y(o,"P",{"data-svelte-h":!0}),h(b)!=="svelte-1nmpr7n"&&(b.innerHTML=J),w=a(o),f=y(o,"P",{"data-svelte-h":!0}),h(f)!=="svelte-7gdj48"&&(f.innerHTML=g)},m(o,U){s(o,r,U),s(o,T,U),s(o,b,U),s(o,w,U),s(o,f,U)},p:Xe,d(o){o&&(n(r),n(T),n(b),n(w),n(f))}}}function Ye(D){let r,Z,T,b,J,w,f,g,o,U='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/sentence-transformers/getting-started.ipynb" rel="nofollow">here</a>.</em>',K,B,We='This guide explains how to compile, load, and use <a href="https://www.sbert.net/" rel="nofollow">Sentence Transformers (SBERT)</a> models on AWS Inferentia2 with Optimum Neuron, enabling efficient calculation of embeddings. Sentence Transformers are powerful models for generating sentence embeddings. You can use this Sentence Transformers to compute sentence / text embeddings for more than 100 languages. These embeddings can then be compared e.g. with cosine-similarity to find sentences with a similar meaning. This can be useful for semantic textual similarity, semantic search, or paraphrase mining.',O,$,ee,_,je="First, you need to convert your Sentence Transformers model to a format compatible with AWS Inferentia2. You can compile Sentence Transformers models with Optimum Neuron using the <code>optimum-cli</code> or <code>NeuronModelForSentenceTransformers</code> class. Below you will find an example for both approaches. We have to make sure <code>sentence-transformers</code> is installed. That’s only needed for exporting the model.",te,I,ne,V,Ze="Here we will use the <code>NeuronModelForSentenceTransformers</code>, which can be used to convert any Sentence Transformers model to a format compatible with AWS Inferentia2 or load already converted models. When exporting models with the <code>NeuronModelForSentenceTransformers</code> you need to set <code>export=True</code> and define the input shape and batch size. The input shape is defined by the <code>sequence_length</code> and the batch size by <code>batch_size</code>.",se,C,le,S,ge="Here we will use the <code>optimum-cli</code> to convert the model. Similar to the <code>NeuronModelForSentenceTransformers</code> we need to define our input shape and batch size. The input shape is defined by the <code>sequence_length</code> and the batch size by <code>batch_size</code>. The <code>optimum-cli</code> will automatically convert the model to a format compatible with AWS Inferentia2 and save it to the specified output directory.",ae,v,oe,k,re,z,Be="Once we have a compiled Sentence Transformers model, which we either exported ourselves or is available on the Hugging Face Hub, we can load it and run inference. For loading the model we can use the <code>NeuronModelForSentenceTransformers</code> class, which is an abstraction layer for the <code>SentenceTransformer</code> class. The <code>NeuronModelForSentenceTransformers</code> class will automatically pad the input to the specified <code>sequence_length</code> and run inference on AWS Inferentia2.",ie,X,me,R,ce,G,$e='For deploying these models in a production environment, refer to the <a href="https://www.philschmid.de/inferentia2-embeddings" rel="nofollow">Amazon SageMaker Blog</a>.',pe,N,de,Q,ue,x,_e="You can compile CLIP models with Optimum Neuron either by using the <code>optimum-cli</code> or <code>NeuronModelForSentenceTransformers</code> class. Adopt one approach that you prefer:",Me,H,Ie="<li>With the Optimum CLI</li>",ye,Y,fe,F,Ve="<li>With the <code>NeuronModelForSentenceTransformers</code> class</li>",he,E,be,L,Te,q,Je,W,we,P,Ue;return J=new j({props:{title:"Sentence Transformers on AWS Inferentia with Optimum Neuron",local:"sentence-transformers-on-aws-inferentia-with-optimum-neuron",headingTag:"h1"}}),f=new j({props:{title:"Text Models",local:"text-models",headingTag:"h2"}}),$=new j({props:{title:"Convert Sentence Transformers model to AWS Inferentia2",local:"convert-sentence-transformers-model-to-aws-inferentia2",headingTag:"h3"}}),I=new A({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycw==",highlighted:"pip install sentence-transformers",wrap:!1}}),C=new A({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycyUwQSUwQSUyMyUyMFNlbnRlbmNlJTIwVHJhbnNmb3JtZXJzJTIwbW9kZWwlMjBmcm9tJTIwSHVnZ2luZ0ZhY2UlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwMzg0JTdEJTIwJTIwJTIzJTIwbWFuZGF0b3J5JTIwc2hhcGVzJTBBJTBBJTIzJTIwTG9hZCUyMFRyYW5zZm9ybWVycyUyMG1vZGVsJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMEFXUyUyMEluZmVyZW50aWEyJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlbnRlbmNlVHJhbnNmb3JtZXJzLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyklMEElMEElMjMlMjBTYXZlJTIwbW9kZWwlMjB0byUyMGRpc2slMEFtb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIyYmdlX2VtYl9pbmYyJTJGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

<span class="hljs-comment"># Sentence Transformers model from HuggingFace</span>
model_id = <span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">384</span>}  <span class="hljs-comment"># mandatory shapes</span>

<span class="hljs-comment"># Load Transformers model and export it to AWS Inferentia2</span>
model = NeuronModelForSentenceTransformers.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)

<span class="hljs-comment"># Save model to disk</span>
model.save_pretrained(<span class="hljs-string">&quot;bge_emb_inf2/&quot;</span>)`,wrap:!1}}),v=new A({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMEJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMC0tc2VxdWVuY2VfbGVuZ3RoJTIwMzg0JTIwLS1iYXRjaF9zaXplJTIwMSUyMC0tdGFzayUyMGZlYXR1cmUtZXh0cmFjdGlvbiUyMGJnZV9lbWJfaW5mMiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m BAAI/bge-small-en-v1.5 --sequence_length 384 --batch_size 1 --task feature-extraction bge_emb_inf2/',wrap:!1}}),k=new j({props:{title:"Load compiled Sentence Transformers model and run inference",local:"load-compiled-sentence-transformers-model-and-run-inference",headingTag:"h3"}}),X=new A({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWxfaWRfb3JfcGF0aCUyMCUzRCUyMCUyMmJnZV9lbWJfaW5mMiUyRiUyMiUwQXRva2VuaXplcl9pZCUyMCUzRCUyMCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycy5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCh0b2tlbml6ZXJfaWQpJTBBJTBBJTIzJTIwUnVuJTIwaW5mZXJlbmNlJTBBcHJvbXB0JTIwJTNEJTIwJTIySSUyMGxpa2UlMjB0byUyMGVhdCUyMGFwcGxlcyUyMiUwQWVuY29kZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QncHQnKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kZWRfaW5wdXQpJTBBJTBBdG9rZW5fZW1iZWRkaW5ncyUyMCUzRCUyMG91dHB1dHMudG9rZW5fZW1iZWRkaW5ncyUwQXNlbnRlbmNlX2VtYmVkZGluZyUyMCUzRCUyMG91dHB1dHMuc2VudGVuY2VfZW1iZWRkaW5nJTBBJTBBcHJpbnQoZiUyMnRva2VuJTIwZW1iZWRkaW5ncyUzQSUyMCU3QnRva2VuX2VtYmVkZGluZ3Muc2hhcGUlN0QlMjIpJTIwJTIzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwNyUyQyUyMDM4NCU1RCklMEFwcmludChmJTIyc2VudGVuY2VfZW1iZWRkaW5nJTNBJTIwJTdCc2VudGVuY2VfZW1iZWRkaW5nLnNoYXBlJTdEJTIyKSUyMCUyMyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDM4NCU1RCk=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

model_id_or_path = <span class="hljs-string">&quot;bge_emb_inf2/&quot;</span>
tokenizer_id = <span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>

<span class="hljs-comment"># Load model and tokenizer</span>
model = NeuronModelForSentenceTransformers.from_pretrained(model_id_or_path)
tokenizer = AutoTokenizer.from_pretrained(tokenizer_id)

<span class="hljs-comment"># Run inference</span>
prompt = <span class="hljs-string">&quot;I like to eat apples&quot;</span>
encoded_input = tokenizer(prompt, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>)
outputs = model(**encoded_input)

token_embeddings = outputs.token_embeddings
sentence_embedding = outputs.sentence_embedding

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;token embeddings: <span class="hljs-subst">{token_embeddings.shape}</span>&quot;</span>) <span class="hljs-comment"># torch.Size([1, 7, 384])</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sentence_embedding: <span class="hljs-subst">{sentence_embedding.shape}</span>&quot;</span>) <span class="hljs-comment"># torch.Size([1, 384])</span>`,wrap:!1}}),R=new j({props:{title:"Production Usage",local:"production-usage",headingTag:"h3"}}),N=new j({props:{title:"CLIP",local:"clip",headingTag:"h2"}}),Q=new j({props:{title:"Compile CLIP for AWS Inferentia2",local:"compile-clip-for-aws-inferentia2",headingTag:"h3"}}),Y=new A({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmNsaXAtVmlULUItMzIlMjAtLXNlcXVlbmNlX2xlbmd0aCUyMDY0JTIwLS10ZXh0X2JhdGNoX3NpemUlMjAzJTIwLS1pbWFnZV9iYXRjaF9zaXplJTIwMSUyMC0tbnVtX2NoYW5uZWxzJTIwMyUyMC0taGVpZ2h0JTIwMjI0JTIwLS13aWR0aCUyMDIyNCUyMC0tdGFzayUyMGZlYXR1cmUtZXh0cmFjdGlvbiUyMC0tc3ViZm9sZGVyJTIwMF9DTElQTW9kZWwlMjBjbGlwX2VtYiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m sentence-transformers/clip-ViT-B-32 --sequence_length 64 --text_batch_size 3 --image_batch_size 1 --num_channels 3 --height 224 --width 224 --task feature-extraction --subfolder 0_CLIPModel clip_emb/',wrap:!1}}),E=new A({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGY2xpcC1WaVQtQi0zMiUyMiUwQSUwQSUyMyUyMGNvbmZpZ3MlMjBmb3IlMjBjb21waWxpbmclMjBtb2RlbCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm51bV9jaGFubmVscyUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjJoZWlnaHQlMjIlM0ElMjAyMjQlMkMlMEElMjAlMjAlMjAlMjAlMjJ3aWR0aCUyMiUzQSUyMDIyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRleHRfYmF0Y2hfc2l6ZSUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjJpbWFnZV9iYXRjaF9zaXplJTIyJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMnNlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDY0JTJDJTBBJTdEJTBBJTBBZW1iX21vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjIwX0NMSVBNb2RlbCUyMiUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjBsaWJyYXJ5X25hbWUlM0QlMjJzZW50ZW5jZV90cmFuc2Zvcm1lcnMlMjIlMkMlMjBkeW5hbWljX2JhdGNoX3NpemUlM0RGYWxzZSUyQyUyMCoqaW5wdXRfc2hhcGVzJTBBKSUwQSUwQSUyMyUyMFNhdmUlMjBsb2NhbGx5JTIwb3IlMjB1cGxvYWQlMjB0byUyMHRoZSUyMEh1Z2dpbmdGYWNlJTIwSHViJTBBc2F2ZV9kaXJlY3RvcnklMjAlM0QlMjAlMjJjbGlwX2VtYiUyRiUyMiUwQWVtYl9tb2RlbC5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3Rvcnkp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

model_id = <span class="hljs-string">&quot;sentence-transformers/clip-ViT-B-32&quot;</span>

<span class="hljs-comment"># configs for compiling model</span>
input_shapes = {
    <span class="hljs-string">&quot;num_channels&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">224</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">224</span>,
    <span class="hljs-string">&quot;text_batch_size&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;image_batch_size&quot;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">64</span>,
}

emb_model = NeuronModelForSentenceTransformers.from_pretrained(
    model_id, subfolder=<span class="hljs-string">&quot;0_CLIPModel&quot;</span>, export=<span class="hljs-literal">True</span>, library_name=<span class="hljs-string">&quot;sentence_transformers&quot;</span>, dynamic_batch_size=<span class="hljs-literal">False</span>, **input_shapes
)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
save_directory = <span class="hljs-string">&quot;clip_emb/&quot;</span>
emb_model.save_pretrained(save_directory)`,wrap:!1}}),L=new j({props:{title:"Load compiled Sentence Transformers model and run inference",local:"load-compiled-sentence-transformers-model-and-run-inference",headingTag:"h3"}}),q=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMHV0aWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFByb2Nlc3NvciUwQSUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvbk1vZGVsRm9yU2VudGVuY2VUcmFuc2Zvcm1lcnMlMEElMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmNsaXBfZW1iJTIyJTBBZW1iX21vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycy5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQ0xJUFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlMjJUd28lMjBkb2dzJTIwaW4lMjB0aGUlMjBzbm93JTIyJTJDJTIwJ0ElMjBjYXQlMjBvbiUyMGElMjB0YWJsZSclMkMlMjAnQSUyMHBpY3R1cmUlMjBvZiUyMExvbmRvbiUyMGF0JTIwbmlnaHQnJTVEJTJDJTIwaW1hZ2VzJTNESW1hZ2Uub3BlbiglMjJ0d29fZG9nc19pbl9zbm93LmpwZyUyMiklMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMGVtYl9tb2RlbCgqKmlucHV0cyklMEElMEElMEElMjMlMjBDb21wdXRlJTIwY29zaW5lJTIwc2ltaWxhcml0aWVzJTBBY29zX3Njb3JlcyUyMCUzRCUyMHV0aWwuY29zX3NpbShvdXRwdXRzLmltYWdlX2VtYmVkcyUyQyUyMG91dHB1dHMudGV4dF9lbWJlZHMpJTBBcHJpbnQoY29zX3Njb3JlcyklMEElMEElMjMlMjB0ZW5zb3IoJTVCJTVCMC4zMDcyJTJDJTIwMC4xMDE2JTJDJTIwMC4xMDk1JTVEJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> util
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPProcessor

<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

save_directory = <span class="hljs-string">&quot;clip_emb&quot;</span>
emb_model = NeuronModelForSentenceTransformers.from_pretrained(save_directory)

processor = CLIPProcessor.from_pretrained(save_directory)
inputs = processor(
    text=[<span class="hljs-string">&quot;Two dogs in the snow&quot;</span>, <span class="hljs-string">&#x27;A cat on a table&#x27;</span>, <span class="hljs-string">&#x27;A picture of London at night&#x27;</span>], images=Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;two_dogs_in_snow.jpg&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
)

outputs = emb_model(**inputs)


<span class="hljs-comment"># Compute cosine similarities</span>
cos_scores = util.cos_sim(outputs.image_embeds, outputs.text_embeds)
<span class="hljs-built_in">print</span>(cos_scores)

<span class="hljs-comment"># tensor([[0.3072, 0.1016, 0.1095]])</span>`,wrap:!1}}),W=new xe({props:{$$slots:{default:[He]},$$scope:{ctx:D}}}),{c(){r=M("meta"),Z=l(),T=M("p"),b=l(),i(J.$$.fragment),w=l(),i(f.$$.fragment),g=l(),o=M("p"),o.innerHTML=U,K=l(),B=M("p"),B.innerHTML=We,O=l(),i($.$$.fragment),ee=l(),_=M("p"),_.innerHTML=je,te=l(),i(I.$$.fragment),ne=l(),V=M("p"),V.innerHTML=Ze,se=l(),i(C.$$.fragment),le=l(),S=M("p"),S.innerHTML=ge,ae=l(),i(v.$$.fragment),oe=l(),i(k.$$.fragment),re=l(),z=M("p"),z.innerHTML=Be,ie=l(),i(X.$$.fragment),me=l(),i(R.$$.fragment),ce=l(),G=M("p"),G.innerHTML=$e,pe=l(),i(N.$$.fragment),de=l(),i(Q.$$.fragment),ue=l(),x=M("p"),x.innerHTML=_e,Me=l(),H=M("ul"),H.innerHTML=Ie,ye=l(),i(Y.$$.fragment),fe=l(),F=M("ul"),F.innerHTML=Ve,he=l(),i(E.$$.fragment),be=l(),i(L.$$.fragment),Te=l(),i(q.$$.fragment),Je=l(),i(W.$$.fragment),we=l(),P=M("p"),this.h()},l(e){const t=Ne("svelte-u9bgzb",document.head);r=y(t,"META",{name:!0,content:!0}),t.forEach(n),Z=a(e),T=y(e,"P",{}),Se(T).forEach(n),b=a(e),m(J.$$.fragment,e),w=a(e),m(f.$$.fragment,e),g=a(e),o=y(e,"P",{"data-svelte-h":!0}),h(o)!=="svelte-z9n49l"&&(o.innerHTML=U),K=a(e),B=y(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-12xwboz"&&(B.innerHTML=We),O=a(e),m($.$$.fragment,e),ee=a(e),_=y(e,"P",{"data-svelte-h":!0}),h(_)!=="svelte-120k6s"&&(_.innerHTML=je),te=a(e),m(I.$$.fragment,e),ne=a(e),V=y(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-1q2dvn9"&&(V.innerHTML=Ze),se=a(e),m(C.$$.fragment,e),le=a(e),S=y(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-reiugv"&&(S.innerHTML=ge),ae=a(e),m(v.$$.fragment,e),oe=a(e),m(k.$$.fragment,e),re=a(e),z=y(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-4dcngh"&&(z.innerHTML=Be),ie=a(e),m(X.$$.fragment,e),me=a(e),m(R.$$.fragment,e),ce=a(e),G=y(e,"P",{"data-svelte-h":!0}),h(G)!=="svelte-qum7z"&&(G.innerHTML=$e),pe=a(e),m(N.$$.fragment,e),de=a(e),m(Q.$$.fragment,e),ue=a(e),x=y(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-1op5j1e"&&(x.innerHTML=_e),Me=a(e),H=y(e,"UL",{"data-svelte-h":!0}),h(H)!=="svelte-1f07ihj"&&(H.innerHTML=Ie),ye=a(e),m(Y.$$.fragment,e),fe=a(e),F=y(e,"UL",{"data-svelte-h":!0}),h(F)!=="svelte-676unf"&&(F.innerHTML=Ve),he=a(e),m(E.$$.fragment,e),be=a(e),m(L.$$.fragment,e),Te=a(e),m(q.$$.fragment,e),Je=a(e),m(W.$$.fragment,e),we=a(e),P=y(e,"P",{}),Se(P).forEach(n),this.h()},h(){ve(r,"name","hf:doc:metadata"),ve(r,"content",Fe)},m(e,t){Qe(document.head,r),s(e,Z,t),s(e,T,t),s(e,b,t),c(J,e,t),s(e,w,t),c(f,e,t),s(e,g,t),s(e,o,t),s(e,K,t),s(e,B,t),s(e,O,t),c($,e,t),s(e,ee,t),s(e,_,t),s(e,te,t),c(I,e,t),s(e,ne,t),s(e,V,t),s(e,se,t),c(C,e,t),s(e,le,t),s(e,S,t),s(e,ae,t),c(v,e,t),s(e,oe,t),c(k,e,t),s(e,re,t),s(e,z,t),s(e,ie,t),c(X,e,t),s(e,me,t),c(R,e,t),s(e,ce,t),s(e,G,t),s(e,pe,t),c(N,e,t),s(e,de,t),c(Q,e,t),s(e,ue,t),s(e,x,t),s(e,Me,t),s(e,H,t),s(e,ye,t),c(Y,e,t),s(e,fe,t),s(e,F,t),s(e,he,t),c(E,e,t),s(e,be,t),c(L,e,t),s(e,Te,t),c(q,e,t),s(e,Je,t),c(W,e,t),s(e,we,t),s(e,P,t),Ue=!0},p(e,[t]){const Ce={};t&2&&(Ce.$$scope={dirty:t,ctx:e}),W.$set(Ce)},i(e){Ue||(p(J.$$.fragment,e),p(f.$$.fragment,e),p($.$$.fragment,e),p(I.$$.fragment,e),p(C.$$.fragment,e),p(v.$$.fragment,e),p(k.$$.fragment,e),p(X.$$.fragment,e),p(R.$$.fragment,e),p(N.$$.fragment,e),p(Q.$$.fragment,e),p(Y.$$.fragment,e),p(E.$$.fragment,e),p(L.$$.fragment,e),p(q.$$.fragment,e),p(W.$$.fragment,e),Ue=!0)},o(e){d(J.$$.fragment,e),d(f.$$.fragment,e),d($.$$.fragment,e),d(I.$$.fragment,e),d(C.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(N.$$.fragment,e),d(Q.$$.fragment,e),d(Y.$$.fragment,e),d(E.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(W.$$.fragment,e),Ue=!1},d(e){e&&(n(Z),n(T),n(b),n(w),n(g),n(o),n(K),n(B),n(O),n(ee),n(_),n(te),n(ne),n(V),n(se),n(le),n(S),n(ae),n(oe),n(re),n(z),n(ie),n(me),n(ce),n(G),n(pe),n(de),n(ue),n(x),n(Me),n(H),n(ye),n(fe),n(F),n(he),n(be),n(Te),n(Je),n(we),n(P)),n(r),u(J,e),u(f,e),u($,e),u(I,e),u(C,e),u(v,e),u(k,e),u(X,e),u(R,e),u(N,e),u(Q,e),u(Y,e),u(E,e),u(L,e),u(q,e),u(W,e)}}}const Fe='{"title":"Sentence Transformers on AWS Inferentia with Optimum Neuron","local":"sentence-transformers-on-aws-inferentia-with-optimum-neuron","sections":[{"title":"Text Models","local":"text-models","sections":[{"title":"Convert Sentence Transformers model to AWS Inferentia2","local":"convert-sentence-transformers-model-to-aws-inferentia2","sections":[],"depth":3},{"title":"Load compiled Sentence Transformers model and run inference","local":"load-compiled-sentence-transformers-model-and-run-inference","sections":[],"depth":3},{"title":"Production Usage","local":"production-usage","sections":[],"depth":3}],"depth":2},{"title":"CLIP","local":"clip","sections":[{"title":"Compile CLIP for AWS Inferentia2","local":"compile-clip-for-aws-inferentia2","sections":[],"depth":3},{"title":"Load compiled Sentence Transformers model and run inference","local":"load-compiled-sentence-transformers-model-and-run-inference","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ee(D){return ze(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ke extends Re{constructor(r){super(),Ge(this,r,Ee,Ye,ke,{})}}export{Ke as component};
