import{s as Os,f as Hl,n as en,o as tn}from"../chunks/scheduler.37c15a92.js";import{S as ln,i as sn,g as u,s as n,r as M,A as nn,h as a,f as l,c as i,j as $l,u as p,x as o,k as y,y as Rl,a as s,v as r,d as c,t as T,w as m}from"../chunks/index.2bf4358c.js";import{C as U}from"../chunks/CodeBlock.4e987730.js";import{H as Ee}from"../chunks/Heading.8ada512a.js";import{E as un}from"../chunks/getInferenceSnippets.1151e4d7.js";function an(Ql){let J,Ke,Fe,Oe,d,et,I,Zl,tt,j,Xl="Un aspect crucial des agents est leur capacité à prendre des <strong>actions</strong>. Comme nous l’avons vu, cela se fait par l’utilisation d’<strong>outils</strong>.",lt,C,zl="Dans cette section, nous verrons ce que sont les outils, comment les concevoir efficacement, et comment les intégrer à votre agent via le message système.",st,f,Vl="En fournissant à votre agent les bons outils — et en décrivant clairement le fonctionnement de ces outils — vous pouvez augmenter de manière spectaculaire ce que votre IA peut accomplir. Plongeons-nous dedans !",nt,b,it,v,Yl="Un <strong>outil est une fonction fournie au LLM</strong>. Cette fonction doit remplir un <strong>objectif clair</strong>.",ut,x,Wl="Voici quelques outils couramment utilisés dans les agents :",at,B,kl="<thead><tr><th>Outil</th> <th>Description</th></tr></thead> <tbody><tr><td>Recherche Web</td> <td>Permet à l’agent de récupérer des informations à jour depuis Internet.</td></tr> <tr><td>Génération d’images</td> <td>Crée des images à partir de descriptions textuelles.</td></tr> <tr><td>Recherche</td> <td>Récupère des informations à partir d’une source externe.</td></tr> <tr><td>Interface API</td> <td>Interagit avec une API externe (GitHub, YouTube, Spotify, etc.).</td></tr></tbody>",ot,h,Nl="Ce ne sont que des exemples, car en réalité, vous pouvez créer un outil pour n’importe quel cas d’utilisation !",Mt,A,El="Un bon outil doit être quelque chose qui <strong>complémente la puissance d’un LLM</strong>.",pt,_,Pl="Par exemple, si vous devez effectuer des opérations arithmétiques, fournir une <strong>calculatrice</strong> à votre LLM donnera de meilleurs résultats que de se fier aux capacités natives du modèle.",rt,q,Fl="De plus, <strong>les LLM prédisent la complétion du <em>prompt</em> en se basant sur leurs données d’entraînement</strong>, ce qui signifie que leur connaissance interne n’inclut que les événements antérieurs à leur entraînement. Par conséquent, si votre agent a besoin de données à jour, vous devez les fournir via un outil.",ct,g,Dl="Par exemple, si vous demandez directement à un LLM (sans outil de recherche) la météo d’aujourd’hui, le LLM pourrait inventer une météo aléatoire.",Tt,G,Kl,mt,L,Ol="<li><p>Un outil doit contenir :</p> <ul><li>Une <strong>description textuelle de ce que fait la fonction</strong>.</li> <li>Un <em>appeleur</em> (quelque chose pour effectuer une action).</li> <li>Des <em>arguments</em> avec typage.</li> <li>(Optionnel) Des sorties avec typage.</li></ul></li>",yt,H,Jt,S,es=`Comme nous l’avons vu, les LLM ne peuvent recevoir que des entrées textuelles et générer des sorties textuelles. Ils ne peuvent pas appeler des outils par eux-mêmes.
Lorsque nous parlons de fournir des outils à un agent, nous entendons enseigner au LLM l’existence de ces outils et lui demander de générer des invocations textuelles en cas de besoin.`,Ut,$,ts="Par exemple, si nous fournissons un outil pour vérifier le temps qu’il fait à un endroit donné à partir d’internet et que nous demandons ensuite au LLM le temps qu’il fait à Paris, le LLM reconnaîtra qu’il s’agit d’une occasion d’utiliser l’outil « météo ». Au lieu de récupérer les données météorologiques elles-mêmes, le LLM générera un texte pour appeller l’outil, tel que `<code>call weather_tool(&quot;Paris&quot;)</code>.",wt,R,ls="L’agent lit alors cette réponse, identifie qu’un appel d’outil est nécessaire, exécute l’outil au nom du LLM et récupère les données météorologiques réelles.",dt,Q,ss="Les étapes de l’appel d’outil ne sont généralement pas montrées à l’utilisateur : l’agent les ajoute à un nouveau message avant de transmettre à nouveau la conversation mise à jour au LLM. Le LLM traite alors ce contexte supplémentaire et génère une réponse naturelle pour l’utilisateur. Du point de vue de l’utilisateur, il semble que le LLM interagisse directement avec l’outil, mais en réalité, c’est l’agent qui gère l’ensemble du processus d’exécution en arrière-plan.",It,Z,ns="Nous reviendrons plus en détail sur ce processus dans les prochaines sessions.",jt,X,Ct,z,is="La réponse complète peut sembler complexe, mais nous utilisons essentiellement le <em>prompt</em> système pour fournir au modèle des descriptions textuelles des outils disponibles :",ft,V,us,bt,Y,as="Pour que cela fonctionne, nous devons être très précis et rigoureux concernant :",vt,W,os="<li><strong>Ce que fait l’outil</strong></li> <li><strong>Les entrées exactes qu’il attend</strong></li>",xt,k,Ms="C’est la raison pour laquelle les descriptions d’outils sont généralement fournies en utilisant des structures expressives mais précises, telles que des langages informatiques ou du JSON. Il n’est pas <em>nécessaire</em> de procéder ainsi, tout format précis et cohérent fonctionnerait.",Bt,N,ps="Si cela semble trop théorique, voyons cela à travers un exemple concret.",ht,E,rs="Nous allons implémenter un outil simplifié <strong>calculatrice</strong> qui se contentera de multiplier deux entiers. Voici une implémentation en Python :",At,P,_t,F,cs="Ainsi, notre outil s’appelle <code>calculator</code>, il <strong>multiplie deux entiers</strong>, et il requiert les entrées suivantes :",qt,D,Ts="<li><strong><code>a</code></strong> (<em>int</em>): Un entier.</li> <li><strong><code>b</code></strong> (<em>int</em>): Un entier.</li>",gt,K,ms="La sortie de l’outil est un autre nombre entier que nous pouvons décrire ainsi :",Gt,O,ys="<li>(<em>int</em>): Le produit de <code>a</code> et <code>b</code>.</li>",Lt,ee,Js="Tous ces détails sont importants. Rassemblons-les dans une chaîne de texte qui décrit notre outil pour que le LLM puisse le comprendre.",Ht,te,St,le,Us="<p><strong>Rappel :</strong> Cette description textuelle est <em>ce que nous voulons que le LLM sache à propos de l’outil</em>.</p>",$t,se,ws="Lorsque nous passons la chaîne précédente dans l’entrée du LLM, le modèle la reconnaîtra comme un outil et saura quelles entrées fournir et ce qu’il doit attendre en sortie.",Rt,ne,ds="Si nous souhaitons fournir des outils supplémentaires, nous devons rester cohérents et utiliser toujours le même format. Ce processus peut être fragile, et nous pourrions accidentellement négliger certains détails.",Qt,ie,Is="Existe-t-il une meilleure méthode ?",Zt,ue,Xt,ae,js="Notre outil a été écrit en Python, et l’implémentation fournit déjà tout ce dont nous avons besoin :",zt,oe,Cs="<li>Un nom descriptif de ce qu’il fait : <code>calculator</code></li> <li>Une description plus détaillée, fournie par le commentaire docstring de la fonction : <code>Multiplie deux entiers.</code></li> <li>Les entrées et leur type : la fonction attend clairement deux <code>int</code>.</li> <li>Le type de la sortie.</li>",Vt,Me,fs="Il y a une raison pour laquelle on utilise des langages de programmation : ils sont expressifs, concis et précis.",Yt,pe,bs="Nous pourrions fournir le code source Python comme <em>spécification</em> de l’outil pour le LLM, mais la manière dont l’outil est implémenté n’a pas d’importance. Tout ce qui compte, c’est son nom, ce qu’il fait, les entrées qu’il attend et la sortie qu’il fournit.",Wt,re,vs="Nous tirerons parti des fonctionnalités d’introspection de Python pour exploiter le code source et construire automatiquement une description de l’outil. Tout ce dont nous avons besoin, c’est que l’implémentation de l’outil utilise des annotations de types, des docstrings et des noms de fonction pertinents. Nous écrirons un peu de code pour extraire les parties pertinentes du code source.",kt,ce,xs="Une fois cela fait, il nous suffira d’utiliser un décorateur Python pour indiquer que la fonction <code>calculator</code> est un outil :",Nt,Te,Et,me,Bs="Notez le décorateur <code>@tool</code> avant la définition de la fonction.",Pt,ye,hs="Avec l’implémentation que nous verrons ensuite, nous serons capables d’extraire automatiquement le texte suivant à partir du code source :",Ft,Je,Dt,Ue,As="Comme vous pouvez le constater, c’est la même chose que nous avons écrit manuellement précédemment !",Kt,we,Ot,de,_s="Nous créons une classe générique <code>Tool</code> que nous pouvons réutiliser chaque fois que nous avons besoin d’utiliser un outil.",el,Ie,qs="<p><strong>Avertissement :</strong> Cette implémentation à titre d’exemple est fictive mais ressemble de près aux implémentations réelles dans la plupart des bibliothèques.</p>",tl,je,ll,Ce,gs="Cela peut sembler compliqué, mais en y allant pas à pas, nous pouvons voir ce qu’elle fait. Nous définissons une classe <strong><code>Tool</code></strong> qui inclut :",sl,fe,Gs="<li><strong><code>name</code></strong> (<em>str</em>): Le nom de l’outil.</li> <li><strong><code>description</code></strong> (<em>str</em>): Une brève description de ce que fait l’outil.</li> <li><strong><code>function</code></strong> (<em>callable</em>): La fonction que l’outil exécute.</li> <li><strong><code>arguments</code></strong> (<em>list</em>): Les paramètres d’entrée attendus.</li> <li><strong><code>outputs</code></strong> (<em>str</em> ou <em>list</em>): Les sorties attendues de l’outil.</li> <li><strong><code>__call__()</code></strong> : Appelle la fonction lorsque l’instance de l’outil est invoquée.</li> <li><strong><code>to_string()</code></strong> : Convertit les attributs de l’outil en une représentation textuelle.</li>",nl,be,Ls="Nous pourrions créer un outil avec cette classe en utilisant le code suivant :",il,ve,ul,xe,Hs="Mais nous pouvons également utiliser le module <code>inspect</code> de Python pour récupérer toutes les informations pour nous ! C’est ce que fait le décorateur <code>@tool</code>.",al,Be,Ss="<p>Si cela vous intéresse, vous pouvez afficher la section suivante pour voir l’implémentation du décorateur.</p>",ol,w,Pe,$s="code du décorateur",Sl,he,Ml,Ae,Rs="Pour réitérer, avec ce décorateur en place, nous pouvons implémenter notre outil comme ceci :",pl,_e,rl,qe,Qs="Et nous pouvons utiliser la méthode <code>to_string</code> de <code>Tool</code> pour récupérer automatiquement un texte adapté à être utilisé comme description d’un outil pour un LLM :",cl,ge,Tl,Ge,Zs="La description est <strong>injectée</strong> dans le <em>prompt</em> système. En reprenant l’exemple avec lequel nous avons commencé cette section, voici à quoi cela ressemblerait après avoir remplacé le <code>tools_description</code> :",ml,Le,Xs,yl,He,zs='Dans la section sur les <a href="actions">actions</a>, nous en apprendrons davantage sur la façon dont un agent peut <strong>appeler</strong> cet outil que nous venons de créer.',Jl,Ul,wl,Se,Vs="Les outils jouent un rôle crucial dans l’amélioration des capacités des agents.",dl,$e,Il,Re,Ys=`<em>Model Context Protocol</em> (MCP) est un <strong>protocole ouvert</strong> qui standardise la manière dont les applications <strong>fournissent des outils aux LLM</strong>.
MCP offre :`,jl,Qe,Ws="<li>Une liste croissante d’intégrations pré-construites que votre LLM peut directement utiliser</li> <li>La flexibilité de changer entre fournisseurs et vendeurs de LLM</li> <li>Les meilleures pratiques pour sécuriser vos données dans votre infrastructure</li>",Cl,Ze,ks="Cela signifie que <strong>tout <em>framework</em> intégrant MCP peut utiliser les outils définis dans le protocole</strong>, éliminant le besoin de réimplémenter la même interface d’outils pour chaque <em>framework</em>.",fl,Xe,Ns='Si vous voulez approfondir MCP, vous pouvez consulter notre <a href="https://huggingface.co/learn/mcp-course/" rel="nofollow">cours gratuit sur MCP</a>.',bl,vl,xl,ze,Es="Les outils jouent un rôle crucial dans l’amélioration des capacités des agents.",Bl,Ve,Ps="Pour résumer, nous avons appris :",hl,Ye,Fs="<li><p><em>Ce que sont les outils</em> : des fonctions qui offrent des capacités supplémentaires aux LLM, comme effectuer des calculs ou accéder à des données externes.</p></li> <li><p><em>Comment définir un outil</em> : en fournissant une description textuelle claire, des entrées, des sorties, et une fonction exécutable.</p></li> <li><p><em>Pourquoi les outils sont essentiels</em> : ils permettent aux agents de surmonter les limites de l’entraînement statique des modèles, de gérer des tâches en temps réel, et d’effectuer des actions spécialisées.</p></li>",Al,We,Ds='Maintenant, nous pouvons passer au <a href="agent-steps-and-structure"><em>workflow</em> de l’agent</a> où vous verrez comment un agent observe, réfléchit et agit. Cela <strong>rassemble tout ce que nous avons vu jusqu’à présent</strong> et prépare le terrain pour créer votre propre agent entièrement fonctionnel.',_l,ke,Ks="Mais d’abord, il est temps pour un autre court quiz !",ql,Ne,gl,De,Gl;return d=new Ee({props:{title:"Que sont les outils ?",local:"que-sont-les-outils-",headingTag:"h1"}}),b=new Ee({props:{title:"Que sont les outils d’IA ?",local:"que-sont-les-outils-dia-",headingTag:"h2"}}),H=new Ee({props:{title:"Comment fonctionnent les outils ?",local:"comment-fonctionnent-les-outils-",headingTag:"h2"}}),X=new Ee({props:{title:"Comment fournir des outils à un LLM ?",local:"comment-fournir-des-outils-à-un-llm-",headingTag:"h2"}}),P=new U({props:{code:"ZGVmJTIwY2FsY3VsYXRvcihhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplie deux entiers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),te=new U({props:{code:"Tm9tJTIwZGUlMjBsJ291dGlsJTNBJTIwY2FsY3VsYXRvciUyQyUyMERlc2NyaXB0aW9uJTNBJTIwTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTJDJTIwQXJndW1lbnRzJTNBJTIwYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQlMkMlMjBTb3J0aWVzJTNBJTIwaW50",highlighted:'<span class="hljs-type">Nom</span> de l&#x27;outil: calculator, <span class="hljs-type">Description</span>: <span class="hljs-type">Multiplie</span> deux entiers., <span class="hljs-type">Arguments</span>: a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span>, <span class="hljs-type">Sorties</span>: <span class="hljs-built_in">int</span>',wrap:!1}}),ue=new Ee({props:{title:"Sections d’auto-formatage des outils",local:"sections-dauto-formatage-des-outils",headingTag:"h3"}}),Te=new U({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGxpZSUyMGRldXglMjBlbnRpZXJzLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGElMjAqJTIwYiUwQSUwQXByaW50KGNhbGN1bGF0b3IudG9fc3RyaW5nKCkp",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplie deux entiers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),Je=new U({props:{code:"Tm9tJTIwZGUlMjBsJ291dGlsJTNBJTIwY2FsY3VsYXRvciUyQyUyMERlc2NyaXB0aW9uJTNBJTIwTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTJDJTIwQXJndW1lbnRzJTNBJTIwYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQlMkMlMjBTb3J0aWVzJTNBJTIwaW50",highlighted:'<span class="hljs-type">Nom</span> de l&#x27;outil: calculator, <span class="hljs-type">Description</span>: <span class="hljs-type">Multiplie</span> deux entiers., <span class="hljs-type">Arguments</span>: a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span>, <span class="hljs-type">Sorties</span>: <span class="hljs-built_in">int</span>',wrap:!1}}),we=new Ee({props:{title:"Implémentation générique d’un outil",local:"implémentation-générique-dun-outil",headingTag:"h3"}}),je=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Une classe représentant un morceau de code réutilisable (Outil).
    
    Attributs:
        name (str): Nom de l&#x27;outil.
        description (str): Une description textuelle de ce que fait l&#x27;outil.
        func (callable): La fonction que cet outil encapsule.
        arguments (list): Une liste d&#x27;arguments.
        outputs (str ou list): Le(s) type(s) de retour de la fonction encapsulée.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, 
                 name: <span class="hljs-built_in">str</span>, 
                 description: <span class="hljs-built_in">str</span>, 
                 func: <span class="hljs-built_in">callable</span>, 
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Retourne une représentation sous forme de chaîne de l&#x27;outil, 
        incluant son nom, sa description, ses arguments, et ses sorties.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])
        
        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Tool Name: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Description: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Arguments: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Outputs: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoque la fonction sous-jacente (callable) avec les arguments fournis.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),ve=new U({props:{code:"Y2FsY3VsYXRvcl90b29sJTIwJTNEJTIwVG9vbCglMEElMjAlMjAlMjAlMjAlMjJjYWxjdWxhdG9yJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbm9tJTBBJTIwJTIwJTIwJTIwJTIyTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVzY3JpcHRpb24lMEElMjAlMjAlMjAlMjBjYWxjdWxhdG9yJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZm9uY3Rpb24lMjAlQzMlQTAlMjBhcHBlbGVyJTBBJTIwJTIwJTIwJTIwJTVCKCUyMmElMjIlMkMlMjAlMjJpbnQlMjIpJTJDJTIwKCUyMmIlMjIlMkMlMjAlMjJpbnQlMjIpJTVEJTJDJTIwJTIwJTIwJTIzJTIwZW50ciVDMyVBOWVzJTIwKG5vbXMlMjBldCUyMHR5cGVzKSUwQSUyMCUyMCUyMCUyMCUyMmludCUyMiUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHNvcnRpZSUwQSk=",highlighted:`calculator_tool = Tool(
    <span class="hljs-string">&quot;calculator&quot;</span>,                   <span class="hljs-comment"># nom</span>
    <span class="hljs-string">&quot;Multiplie deux entiers.&quot;</span>,      <span class="hljs-comment"># description</span>
    calculator,                     <span class="hljs-comment"># fonction à appeler</span>
    [(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># entrées (noms et types)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># sortie</span>
)`,wrap:!1}}),he=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Un décorateur qui crée une instance de Tool à partir de la fonction donnée.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Récupérer la signature de la fonction</span>
    signature = inspect.signature(func)
    
    <span class="hljs-comment"># Extraire les paires (nom_param, annotation_param) pour les entrées</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))
    
    <span class="hljs-comment"># Déterminer l&#x27;annotation de retour</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;Pas d&#x27;annotation de retour&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )
    
    <span class="hljs-comment"># Utiliser la docstring de la fonction comme description (par défaut si vide)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No description provided.&quot;</span>
    
    <span class="hljs-comment"># Le nom de la fonction devient le nom de l&#x27;outil</span>
    name = func.__name__
    
    <span class="hljs-comment"># Retourner une nouvelle instance de Tool</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name, 
        description=description, 
        func=func, 
        arguments=arguments, 
        outputs=outputs
    )`,wrap:!1}}),_e=new U({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGxpZSUyMGRldXglMjBlbnRpZXJzLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGElMjAqJTIwYiUwQSUwQXByaW50KGNhbGN1bGF0b3IudG9fc3RyaW5nKCkp",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplie deux entiers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),ge=new U({props:{code:"Tm9tJTIwZGUlMjBsJ291dGlsJTNBJTIwY2FsY3VsYXRvciUyQyUyMERlc2NyaXB0aW9uJTNBJTIwTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTJDJTIwQXJndW1lbnRzJTNBJTIwYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQlMkMlMjBTb3J0aWVzJTNBJTIwaW50",highlighted:'<span class="hljs-type">Nom</span> de l&#x27;outil: calculator, <span class="hljs-type">Description</span>: <span class="hljs-type">Multiplie</span> deux entiers., <span class="hljs-type">Arguments</span>: a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span>, <span class="hljs-type">Sorties</span>: <span class="hljs-built_in">int</span>',wrap:!1}}),$e=new Ee({props:{title:"Model Context Protocol (MCP) : une interface d’outils unifiée",local:"model-context-protocol-mcp--une-interface-doutils-unifiée",headingTag:"h3"}}),Ne=new un({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit1/tools.mdx"}}),{c(){J=u("meta"),Ke=n(),Fe=u("p"),Oe=n(),M(d.$$.fragment),et=n(),I=u("img"),tt=n(),j=u("p"),j.innerHTML=Xl,lt=n(),C=u("p"),C.textContent=zl,st=n(),f=u("p"),f.textContent=Vl,nt=n(),M(b.$$.fragment),it=n(),v=u("p"),v.innerHTML=Yl,ut=n(),x=u("p"),x.textContent=Wl,at=n(),B=u("table"),B.innerHTML=kl,ot=n(),h=u("p"),h.textContent=Nl,Mt=n(),A=u("p"),A.innerHTML=El,pt=n(),_=u("p"),_.innerHTML=Pl,rt=n(),q=u("p"),q.innerHTML=Fl,ct=n(),g=u("p"),g.textContent=Dl,Tt=n(),G=u("img"),mt=n(),L=u("ul"),L.innerHTML=Ol,yt=n(),M(H.$$.fragment),Jt=n(),S=u("p"),S.textContent=es,Ut=n(),$=u("p"),$.innerHTML=ts,wt=n(),R=u("p"),R.textContent=ls,dt=n(),Q=u("p"),Q.textContent=ss,It=n(),Z=u("p"),Z.textContent=ns,jt=n(),M(X.$$.fragment),Ct=n(),z=u("p"),z.innerHTML=is,ft=n(),V=u("img"),bt=n(),Y=u("p"),Y.textContent=as,vt=n(),W=u("ol"),W.innerHTML=os,xt=n(),k=u("p"),k.innerHTML=Ms,Bt=n(),N=u("p"),N.textContent=ps,ht=n(),E=u("p"),E.innerHTML=rs,At=n(),M(P.$$.fragment),_t=n(),F=u("p"),F.innerHTML=cs,qt=n(),D=u("ul"),D.innerHTML=Ts,gt=n(),K=u("p"),K.textContent=ms,Gt=n(),O=u("ul"),O.innerHTML=ys,Lt=n(),ee=u("p"),ee.textContent=Js,Ht=n(),M(te.$$.fragment),St=n(),le=u("blockquote"),le.innerHTML=Us,$t=n(),se=u("p"),se.textContent=ws,Rt=n(),ne=u("p"),ne.textContent=ds,Qt=n(),ie=u("p"),ie.textContent=Is,Zt=n(),M(ue.$$.fragment),Xt=n(),ae=u("p"),ae.textContent=js,zt=n(),oe=u("ul"),oe.innerHTML=Cs,Vt=n(),Me=u("p"),Me.textContent=fs,Yt=n(),pe=u("p"),pe.innerHTML=bs,Wt=n(),re=u("p"),re.textContent=vs,kt=n(),ce=u("p"),ce.innerHTML=xs,Nt=n(),M(Te.$$.fragment),Et=n(),me=u("p"),me.innerHTML=Bs,Pt=n(),ye=u("p"),ye.textContent=hs,Ft=n(),M(Je.$$.fragment),Dt=n(),Ue=u("p"),Ue.textContent=As,Kt=n(),M(we.$$.fragment),Ot=n(),de=u("p"),de.innerHTML=_s,el=n(),Ie=u("blockquote"),Ie.innerHTML=qs,tl=n(),M(je.$$.fragment),ll=n(),Ce=u("p"),Ce.innerHTML=gs,sl=n(),fe=u("ul"),fe.innerHTML=Gs,nl=n(),be=u("p"),be.textContent=Ls,il=n(),M(ve.$$.fragment),ul=n(),xe=u("p"),xe.innerHTML=Hs,al=n(),Be=u("blockquote"),Be.innerHTML=Ss,ol=n(),w=u("details"),Pe=u("summary"),Pe.textContent=$s,Sl=n(),M(he.$$.fragment),Ml=n(),Ae=u("p"),Ae.textContent=Rs,pl=n(),M(_e.$$.fragment),rl=n(),qe=u("p"),qe.innerHTML=Qs,cl=n(),M(ge.$$.fragment),Tl=n(),Ge=u("p"),Ge.innerHTML=Zs,ml=n(),Le=u("img"),yl=n(),He=u("p"),He.innerHTML=zs,Jl=n(),Ul=u("hr"),wl=n(),Se=u("p"),Se.textContent=Vs,dl=n(),M($e.$$.fragment),Il=n(),Re=u("p"),Re.innerHTML=Ys,jl=n(),Qe=u("ul"),Qe.innerHTML=Ws,Cl=n(),Ze=u("p"),Ze.innerHTML=ks,fl=n(),Xe=u("p"),Xe.innerHTML=Ns,bl=n(),vl=u("hr"),xl=n(),ze=u("p"),ze.textContent=Es,Bl=n(),Ve=u("p"),Ve.textContent=Ps,hl=n(),Ye=u("ul"),Ye.innerHTML=Fs,Al=n(),We=u("p"),We.innerHTML=Ds,_l=n(),ke=u("p"),ke.textContent=Ks,ql=n(),M(Ne.$$.fragment),gl=n(),De=u("p"),this.h()},l(e){const t=nn("svelte-u9bgzb",document.head);J=a(t,"META",{name:!0,content:!0}),t.forEach(l),Ke=i(e),Fe=a(e,"P",{}),$l(Fe).forEach(l),Oe=i(e),p(d.$$.fragment,e),et=i(e),I=a(e,"IMG",{src:!0,alt:!0}),tt=i(e),j=a(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1g8bkuz"&&(j.innerHTML=Xl),lt=i(e),C=a(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-oqbuss"&&(C.textContent=zl),st=i(e),f=a(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1lpseza"&&(f.textContent=Vl),nt=i(e),p(b.$$.fragment,e),it=i(e),v=a(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-cvxsx9"&&(v.innerHTML=Yl),ut=i(e),x=a(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1ldwtbu"&&(x.textContent=Wl),at=i(e),B=a(e,"TABLE",{"data-svelte-h":!0}),o(B)!=="svelte-1d3jabr"&&(B.innerHTML=kl),ot=i(e),h=a(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1578lad"&&(h.textContent=Nl),Mt=i(e),A=a(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-zavgkk"&&(A.innerHTML=El),pt=i(e),_=a(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-x4kr7z"&&(_.innerHTML=Pl),rt=i(e),q=a(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1avsaye"&&(q.innerHTML=Fl),ct=i(e),g=a(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1doz4nr"&&(g.textContent=Dl),Tt=i(e),G=a(e,"IMG",{src:!0,alt:!0}),mt=i(e),L=a(e,"UL",{"data-svelte-h":!0}),o(L)!=="svelte-134oyeu"&&(L.innerHTML=Ol),yt=i(e),p(H.$$.fragment,e),Jt=i(e),S=a(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-2xnaw2"&&(S.textContent=es),Ut=i(e),$=a(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1vubwmk"&&($.innerHTML=ts),wt=i(e),R=a(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-t3ocl8"&&(R.textContent=ls),dt=i(e),Q=a(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-10bnu1v"&&(Q.textContent=ss),It=i(e),Z=a(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1imfon4"&&(Z.textContent=ns),jt=i(e),p(X.$$.fragment,e),Ct=i(e),z=a(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1diipdl"&&(z.innerHTML=is),ft=i(e),V=a(e,"IMG",{src:!0,alt:!0}),bt=i(e),Y=a(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1l232mj"&&(Y.textContent=as),vt=i(e),W=a(e,"OL",{"data-svelte-h":!0}),o(W)!=="svelte-mo4qti"&&(W.innerHTML=os),xt=i(e),k=a(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-geocds"&&(k.innerHTML=Ms),Bt=i(e),N=a(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-12f7933"&&(N.textContent=ps),ht=i(e),E=a(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1b444o6"&&(E.innerHTML=rs),At=i(e),p(P.$$.fragment,e),_t=i(e),F=a(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-b5enmt"&&(F.innerHTML=cs),qt=i(e),D=a(e,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-ym5xkp"&&(D.innerHTML=Ts),gt=i(e),K=a(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-i6tzj8"&&(K.textContent=ms),Gt=i(e),O=a(e,"UL",{"data-svelte-h":!0}),o(O)!=="svelte-eem86h"&&(O.innerHTML=ys),Lt=i(e),ee=a(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1bsj63c"&&(ee.textContent=Js),Ht=i(e),p(te.$$.fragment,e),St=i(e),le=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(le)!=="svelte-xgy7yp"&&(le.innerHTML=Us),$t=i(e),se=a(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-t0nt59"&&(se.textContent=ws),Rt=i(e),ne=a(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1kxkz2u"&&(ne.textContent=ds),Qt=i(e),ie=a(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-ojbeji"&&(ie.textContent=Is),Zt=i(e),p(ue.$$.fragment,e),Xt=i(e),ae=a(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-f16tzr"&&(ae.textContent=js),zt=i(e),oe=a(e,"UL",{"data-svelte-h":!0}),o(oe)!=="svelte-m90lk1"&&(oe.innerHTML=Cs),Vt=i(e),Me=a(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1etx7od"&&(Me.textContent=fs),Yt=i(e),pe=a(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-fvbzuf"&&(pe.innerHTML=bs),Wt=i(e),re=a(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-dbo8tr"&&(re.textContent=vs),kt=i(e),ce=a(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-gayksv"&&(ce.innerHTML=xs),Nt=i(e),p(Te.$$.fragment,e),Et=i(e),me=a(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-fc7lom"&&(me.innerHTML=Bs),Pt=i(e),ye=a(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-15dwiii"&&(ye.textContent=hs),Ft=i(e),p(Je.$$.fragment,e),Dt=i(e),Ue=a(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-41gbqm"&&(Ue.textContent=As),Kt=i(e),p(we.$$.fragment,e),Ot=i(e),de=a(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1ux3i79"&&(de.innerHTML=_s),el=i(e),Ie=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Ie)!=="svelte-pi7ybl"&&(Ie.innerHTML=qs),tl=i(e),p(je.$$.fragment,e),ll=i(e),Ce=a(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-v6nit1"&&(Ce.innerHTML=gs),sl=i(e),fe=a(e,"UL",{"data-svelte-h":!0}),o(fe)!=="svelte-19ugnw6"&&(fe.innerHTML=Gs),nl=i(e),be=a(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-59sgl4"&&(be.textContent=Ls),il=i(e),p(ve.$$.fragment,e),ul=i(e),xe=a(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1glbf26"&&(xe.innerHTML=Hs),al=i(e),Be=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Be)!=="svelte-1xl9l5i"&&(Be.innerHTML=Ss),ol=i(e),w=a(e,"DETAILS",{});var Ll=$l(w);Pe=a(Ll,"SUMMARY",{"data-svelte-h":!0}),o(Pe)!=="svelte-14dl2fo"&&(Pe.textContent=$s),Sl=i(Ll),p(he.$$.fragment,Ll),Ll.forEach(l),Ml=i(e),Ae=a(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1p3ayi2"&&(Ae.textContent=Rs),pl=i(e),p(_e.$$.fragment,e),rl=i(e),qe=a(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-bs59s"&&(qe.innerHTML=Qs),cl=i(e),p(ge.$$.fragment,e),Tl=i(e),Ge=a(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-4itkv6"&&(Ge.innerHTML=Zs),ml=i(e),Le=a(e,"IMG",{src:!0,alt:!0}),yl=i(e),He=a(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-g2c2f3"&&(He.innerHTML=zs),Jl=i(e),Ul=a(e,"HR",{}),wl=i(e),Se=a(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-1cut2me"&&(Se.textContent=Vs),dl=i(e),p($e.$$.fragment,e),Il=i(e),Re=a(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-jag5v6"&&(Re.innerHTML=Ys),jl=i(e),Qe=a(e,"UL",{"data-svelte-h":!0}),o(Qe)!=="svelte-cvddem"&&(Qe.innerHTML=Ws),Cl=i(e),Ze=a(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1qj01zj"&&(Ze.innerHTML=ks),fl=i(e),Xe=a(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-183ro16"&&(Xe.innerHTML=Ns),bl=i(e),vl=a(e,"HR",{}),xl=i(e),ze=a(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1cut2me"&&(ze.textContent=Es),Bl=i(e),Ve=a(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-13rq5ja"&&(Ve.textContent=Ps),hl=i(e),Ye=a(e,"UL",{"data-svelte-h":!0}),o(Ye)!=="svelte-1i82t9i"&&(Ye.innerHTML=Fs),Al=i(e),We=a(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-k59nnb"&&(We.innerHTML=Ds),_l=i(e),ke=a(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-gu9wbg"&&(ke.textContent=Ks),ql=i(e),p(Ne.$$.fragment,e),gl=i(e),De=a(e,"P",{}),$l(De).forEach(l),this.h()},h(){y(J,"name","hf:doc:metadata"),y(J,"content",on),Hl(I.src,Zl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||y(I,"src",Zl),y(I,"alt","Planification de l'Unité 1"),Hl(G.src,Kl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||y(G,"src",Kl),y(G,"alt","Météo"),Hl(V.src,us="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||y(V,"src",us),y(V,"alt","Prompt système pour les outils"),Hl(Le.src,Xs="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||y(Le,"src",Xs),y(Le,"alt","Prompt système pour les outils")},m(e,t){Rl(document.head,J),s(e,Ke,t),s(e,Fe,t),s(e,Oe,t),r(d,e,t),s(e,et,t),s(e,I,t),s(e,tt,t),s(e,j,t),s(e,lt,t),s(e,C,t),s(e,st,t),s(e,f,t),s(e,nt,t),r(b,e,t),s(e,it,t),s(e,v,t),s(e,ut,t),s(e,x,t),s(e,at,t),s(e,B,t),s(e,ot,t),s(e,h,t),s(e,Mt,t),s(e,A,t),s(e,pt,t),s(e,_,t),s(e,rt,t),s(e,q,t),s(e,ct,t),s(e,g,t),s(e,Tt,t),s(e,G,t),s(e,mt,t),s(e,L,t),s(e,yt,t),r(H,e,t),s(e,Jt,t),s(e,S,t),s(e,Ut,t),s(e,$,t),s(e,wt,t),s(e,R,t),s(e,dt,t),s(e,Q,t),s(e,It,t),s(e,Z,t),s(e,jt,t),r(X,e,t),s(e,Ct,t),s(e,z,t),s(e,ft,t),s(e,V,t),s(e,bt,t),s(e,Y,t),s(e,vt,t),s(e,W,t),s(e,xt,t),s(e,k,t),s(e,Bt,t),s(e,N,t),s(e,ht,t),s(e,E,t),s(e,At,t),r(P,e,t),s(e,_t,t),s(e,F,t),s(e,qt,t),s(e,D,t),s(e,gt,t),s(e,K,t),s(e,Gt,t),s(e,O,t),s(e,Lt,t),s(e,ee,t),s(e,Ht,t),r(te,e,t),s(e,St,t),s(e,le,t),s(e,$t,t),s(e,se,t),s(e,Rt,t),s(e,ne,t),s(e,Qt,t),s(e,ie,t),s(e,Zt,t),r(ue,e,t),s(e,Xt,t),s(e,ae,t),s(e,zt,t),s(e,oe,t),s(e,Vt,t),s(e,Me,t),s(e,Yt,t),s(e,pe,t),s(e,Wt,t),s(e,re,t),s(e,kt,t),s(e,ce,t),s(e,Nt,t),r(Te,e,t),s(e,Et,t),s(e,me,t),s(e,Pt,t),s(e,ye,t),s(e,Ft,t),r(Je,e,t),s(e,Dt,t),s(e,Ue,t),s(e,Kt,t),r(we,e,t),s(e,Ot,t),s(e,de,t),s(e,el,t),s(e,Ie,t),s(e,tl,t),r(je,e,t),s(e,ll,t),s(e,Ce,t),s(e,sl,t),s(e,fe,t),s(e,nl,t),s(e,be,t),s(e,il,t),r(ve,e,t),s(e,ul,t),s(e,xe,t),s(e,al,t),s(e,Be,t),s(e,ol,t),s(e,w,t),Rl(w,Pe),Rl(w,Sl),r(he,w,null),s(e,Ml,t),s(e,Ae,t),s(e,pl,t),r(_e,e,t),s(e,rl,t),s(e,qe,t),s(e,cl,t),r(ge,e,t),s(e,Tl,t),s(e,Ge,t),s(e,ml,t),s(e,Le,t),s(e,yl,t),s(e,He,t),s(e,Jl,t),s(e,Ul,t),s(e,wl,t),s(e,Se,t),s(e,dl,t),r($e,e,t),s(e,Il,t),s(e,Re,t),s(e,jl,t),s(e,Qe,t),s(e,Cl,t),s(e,Ze,t),s(e,fl,t),s(e,Xe,t),s(e,bl,t),s(e,vl,t),s(e,xl,t),s(e,ze,t),s(e,Bl,t),s(e,Ve,t),s(e,hl,t),s(e,Ye,t),s(e,Al,t),s(e,We,t),s(e,_l,t),s(e,ke,t),s(e,ql,t),r(Ne,e,t),s(e,gl,t),s(e,De,t),Gl=!0},p:en,i(e){Gl||(c(d.$$.fragment,e),c(b.$$.fragment,e),c(H.$$.fragment,e),c(X.$$.fragment,e),c(P.$$.fragment,e),c(te.$$.fragment,e),c(ue.$$.fragment,e),c(Te.$$.fragment,e),c(Je.$$.fragment,e),c(we.$$.fragment,e),c(je.$$.fragment,e),c(ve.$$.fragment,e),c(he.$$.fragment,e),c(_e.$$.fragment,e),c(ge.$$.fragment,e),c($e.$$.fragment,e),c(Ne.$$.fragment,e),Gl=!0)},o(e){T(d.$$.fragment,e),T(b.$$.fragment,e),T(H.$$.fragment,e),T(X.$$.fragment,e),T(P.$$.fragment,e),T(te.$$.fragment,e),T(ue.$$.fragment,e),T(Te.$$.fragment,e),T(Je.$$.fragment,e),T(we.$$.fragment,e),T(je.$$.fragment,e),T(ve.$$.fragment,e),T(he.$$.fragment,e),T(_e.$$.fragment,e),T(ge.$$.fragment,e),T($e.$$.fragment,e),T(Ne.$$.fragment,e),Gl=!1},d(e){e&&(l(Ke),l(Fe),l(Oe),l(et),l(I),l(tt),l(j),l(lt),l(C),l(st),l(f),l(nt),l(it),l(v),l(ut),l(x),l(at),l(B),l(ot),l(h),l(Mt),l(A),l(pt),l(_),l(rt),l(q),l(ct),l(g),l(Tt),l(G),l(mt),l(L),l(yt),l(Jt),l(S),l(Ut),l($),l(wt),l(R),l(dt),l(Q),l(It),l(Z),l(jt),l(Ct),l(z),l(ft),l(V),l(bt),l(Y),l(vt),l(W),l(xt),l(k),l(Bt),l(N),l(ht),l(E),l(At),l(_t),l(F),l(qt),l(D),l(gt),l(K),l(Gt),l(O),l(Lt),l(ee),l(Ht),l(St),l(le),l($t),l(se),l(Rt),l(ne),l(Qt),l(ie),l(Zt),l(Xt),l(ae),l(zt),l(oe),l(Vt),l(Me),l(Yt),l(pe),l(Wt),l(re),l(kt),l(ce),l(Nt),l(Et),l(me),l(Pt),l(ye),l(Ft),l(Dt),l(Ue),l(Kt),l(Ot),l(de),l(el),l(Ie),l(tl),l(ll),l(Ce),l(sl),l(fe),l(nl),l(be),l(il),l(ul),l(xe),l(al),l(Be),l(ol),l(w),l(Ml),l(Ae),l(pl),l(rl),l(qe),l(cl),l(Tl),l(Ge),l(ml),l(Le),l(yl),l(He),l(Jl),l(Ul),l(wl),l(Se),l(dl),l(Il),l(Re),l(jl),l(Qe),l(Cl),l(Ze),l(fl),l(Xe),l(bl),l(vl),l(xl),l(ze),l(Bl),l(Ve),l(hl),l(Ye),l(Al),l(We),l(_l),l(ke),l(ql),l(gl),l(De)),l(J),m(d,e),m(b,e),m(H,e),m(X,e),m(P,e),m(te,e),m(ue,e),m(Te,e),m(Je,e),m(we,e),m(je,e),m(ve,e),m(he),m(_e,e),m(ge,e),m($e,e),m(Ne,e)}}}const on='{"title":"Que sont les outils ?","local":"que-sont-les-outils-","sections":[{"title":"Que sont les outils d’IA ?","local":"que-sont-les-outils-dia-","sections":[],"depth":2},{"title":"Comment fonctionnent les outils ?","local":"comment-fonctionnent-les-outils-","sections":[],"depth":2},{"title":"Comment fournir des outils à un LLM ?","local":"comment-fournir-des-outils-à-un-llm-","sections":[{"title":"Sections d’auto-formatage des outils","local":"sections-dauto-formatage-des-outils","sections":[],"depth":3},{"title":"Implémentation générique d’un outil","local":"implémentation-générique-dun-outil","sections":[],"depth":3},{"title":"Model Context Protocol (MCP) : une interface d’outils unifiée","local":"model-context-protocol-mcp--une-interface-doutils-unifiée","sections":[],"depth":3}],"depth":2}],"depth":1}';function Mn(Ql){return tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yn extends ln{constructor(J){super(),sn(this,J,Mn,an,Os,{})}}export{yn as component};
