import{s as fn,o as Cn,n as In}from"../chunks/scheduler.37c15a92.js";import{S as vn,i as Zn,g as i,s as n,r as p,A as Bn,h as o,f as l,c as a,j as Un,u as r,x as M,k as Ms,y as kn,a as s,v as u,d as c,t as m,w as y,m as bn,n as gn}from"../chunks/index.2bf4358c.js";import{T as Gn}from"../chunks/Tip.d39f0823.js";import{C as h}from"../chunks/CodeBlock.4e987730.js";import{C as $n}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as w}from"../chunks/Heading.8ada512a.js";import{E as Wn}from"../chunks/getInferenceSnippets.1151e4d7.js";function An(wt){let j,d,U="this notebook",J;return{c(){j=bn("You can follow the code in "),d=i("a"),d.textContent=U,J=bn(" that you can run using Google Colab."),this.h()},l(T){j=gn(T,"You can follow the code in "),d=o(T,"A",{href:!0,target:!0,"data-svelte-h":!0}),M(d)!=="svelte-1y53sk7"&&(d.textContent=U),J=gn(T," that you can run using Google Colab."),this.h()},h(){Ms(d,"href","https://colab.research.google.com/#fileId=https%3A//huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents.ipynb"),Ms(d,"target","_blank")},m(T,b){s(T,j,b),s(T,d,b),s(T,J,b)},p:In,d(T){T&&(l(j),l(d),l(J))}}}function xn(wt){let j,d,U,J,T,b,f,Tt,g,jt,C,ps="In this notebook, we will learn how to <strong>monitor the internal steps (traces) of our AI agent</strong> and <strong>evaluate its performance</strong> using open-source observability tools.",dt,I,rs="The ability to observe and evaluate an agent’s behavior is essential for:",ht,v,us="<li>Debugging issues when tasks fail or produce suboptimal results</li> <li>Monitoring costs and performance in real-time</li> <li>Improving reliability and safety through continuous feedback</li>",Jt,Z,Ut,B,cs="Before running this notebook, please be sure you have:",bt,k,ms='🔲 📚  <strong>Studied</strong> <a href="https://huggingface.co/learn/agents-course/unit1/introduction" rel="nofollow">Introduction to Agents</a>',gt,G,ys='🔲 📚  <strong>Studied</strong> <a href="https://huggingface.co/learn/agents-course/unit2/smolagents/introduction" rel="nofollow">The smolagents framework</a>',ft,$,Ct,W,ws="We will need a few libraries that allow us to run, monitor, and evaluate our agents:",It,A,vt,x,Zt,R,Ts='In this notebook, we will use <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> as our observability tool, but you can use <strong>any other OpenTelemetry-compatible service</strong>. The code below shows how to set environment variables for Langfuse (or any OTel endpoint) and how to instrument your smolagent.',Bt,E,js='<strong>Note:</strong> If you are using LlamaIndex or LangGraph, you can find documentation on instrumenting them <a href="https://langfuse.com/docs/integrations/llama-index/workflows" rel="nofollow">here</a> and <a href="https://langfuse.com/docs/integrations/langchain/example-python-langgraph" rel="nofollow">here</a>.',kt,V,ds='First, let’s set up the Langfuse credentials as environment variables. Get your Langfuse API keys by signing up for <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> or <a href="https://langfuse.com/self-hosting" rel="nofollow">self-hosting Langfuse</a>.',Gt,H,$t,Y,hs="We also need to configure our Hugging Face token for inference calls.",Wt,Q,At,L,Js="With the environment variables set, we can now initialize the Langfuse client. <code>get_client()</code> initializes the Langfuse client using the credentials provided in the environment variables.",xt,N,Rt,S,Us="Next, we can set up the <code>SmolagentsInstrumentor()</code> to instrument our smolagent and send traces to Langfuse.",Et,_,Vt,X,Ht,z,bs="Here is a simple CodeAgent from smolagents that calculates <code>1+1</code>. We run it to confirm that the instrumentation is working correctly. If everything is set up correctly, you will see logs/spans in your observability dashboard.",Yt,F,Qt,q,gs='Check your <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Traces Dashboard</a> (or your chosen observability tool) to confirm that the spans and logs have been recorded.',Lt,D,fs="Example screenshot from Langfuse:",Nt,P,Cs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/first-example-trace.png" alt="Example trace in Langfuse"/>',St,K,Is='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1b94d6888258e0998329cdb72a371155?timestamp=2025-03-10T11%3A59%3A41.743Z" rel="nofollow">Link to the trace</a></em>',_t,O,Xt,ee,vs="Now that you have confirmed your instrumentation works, let’s try a more complex query so we can see how advanced metrics (token usage, latency, costs, etc.) are tracked.",zt,te,Ft,le,qt,se,Zs="Most observability tools record a <strong>trace</strong> that contains <strong>spans</strong>, which represent each step of your agent’s logic. Here, the trace contains the overall agent run and sub-spans for:",Dt,ne,Bs="<li>The tool calls (DuckDuckGoSearchTool)</li> <li>The LLM calls (InferenceClientModel)</li>",Pt,ae,ks="You can inspect these to see precisely where time is spent, how many tokens are used, and so on:",Kt,ie,Gs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/trace-tree.png" alt="Trace tree in Langfuse"/>',Ot,oe,$s='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',el,Me,tl,pe,Ws="In the previous section, we learned about the difference between online and offline evaluation. Now, we will see how to monitor your agent in production and evaluate it live.",ll,re,sl,ue,As="<li><strong>Costs</strong> — The smolagents instrumentation captures token usage, which you can transform into approximate costs by assigning a price per token.</li> <li><strong>Latency</strong> — Observe the time it takes to complete each step, or the entire run.</li> <li><strong>User Feedback</strong> — Users can provide direct feedback (thumbs up/down) to help refine or correct the agent.</li> <li><strong>LLM-as-a-Judge</strong> — Use a separate LLM to evaluate your agent’s output in near real-time (e.g., checking for toxicity or correctness).</li>",nl,ce,xs="Below, we show examples of these metrics.",al,me,il,ye,Rs="Below is a screenshot showing usage for <code>Qwen2.5-Coder-32B-Instruct</code> calls. This is useful to see costly steps and optimize your agent.",ol,we,Es='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-costs.png" alt="Costs"/>',Ml,Te,Vs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',pl,je,rl,de,Hs="We can also see how long it took to complete each step. In the example below, the entire conversation took 32 seconds, which you can break down by step. This helps you identify bottlenecks and optimize your agent.",ul,he,Ys='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-latency.png" alt="Latency"/>',cl,Je,Qs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',ml,Ue,yl,be,Ls="You may also pass additional attributes to your spans. These can include <code>user_id</code>, <code>tags</code>, <code>session_id</code>, and custom metadata. Enriching traces with these details is important for analysis, debugging, and monitoring of your application’s behavior across different users or sessions.",wl,ge,Tl,fe,Ns='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-attributes.png" alt="Enhancing agent runs with additional metrics"/>',jl,Ce,dl,Ie,Ss='If your agent is embedded into a user interface, you can record direct user feedback (like a thumbs-up/down in a chat UI). Below is an example using <a href="https://gradio.app/" rel="nofollow">Gradio</a> to embed a chat with a simple feedback mechanism.',hl,ve,_s="In the code snippet below, when a user sends a chat message, we capture the trace in Langfuse. If the user likes/dislikes the last answer, we attach a score to the trace.",Jl,Ze,Ul,Be,Xs="User feedback is then captured in your observability tool:",bl,ke,zs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/user-feedback-gradio.png" alt="User feedback is being captured in Langfuse"/>',gl,Ge,fl,$e,Fs="LLM-as-a-Judge is another way to automatically evaluate your agent’s output. You can set up a separate LLM call to gauge the output’s correctness, toxicity, style, or any other criteria you care about.",Cl,We,qs="<strong>Workflow</strong>:",Il,Ae,Ds="<li>You define an <strong>Evaluation Template</strong>, e.g., “Check if the text is toxic.”</li> <li>Each time your agent generates output, you pass that output to your “judge” LLM with the template.</li> <li>The judge LLM responds with a rating or label that you log to your observability tool.</li>",vl,xe,Ps="Example from Langfuse:",Zl,Re,Ks='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator-template.png" alt="LLM-as-a-Judge Evaluation Template"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator.png" alt="LLM-as-a-Judge Evaluator"/>',Bl,Ee,kl,Ve,Os="You can see that the answer of this example is judged as “not toxic”.",Gl,He,en='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/llm-as-a-judge-score.png" alt="LLM-as-a-Judge Evaluation Score"/>',$l,Ye,Wl,Qe,tn="All of these metrics can be visualized together in dashboards. This enables you to quickly see how your agent performs across many sessions and helps you to track quality metrics over time.",Al,Le,ln='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/langfuse-dashboard.png" alt="Observability metrics overview"/>',xl,Ne,Rl,Se,sn="Online evaluation is essential for live feedback, but you also need <strong>offline evaluation</strong>—systematic checks before or during development. This helps maintain quality and reliability before rolling changes into production.",El,_e,Vl,Xe,nn="In offline evaluation, you typically:",Hl,ze,an="<li>Have a benchmark dataset (with prompt and expected output pairs)</li> <li>Run your agent on that dataset</li> <li>Compare outputs to the expected results or use an additional scoring mechanism</li>",Yl,Fe,on='Below, we demonstrate this approach with the <a href="https://huggingface.co/datasets/openai/gsm8k" rel="nofollow">GSM8K dataset</a>, which contains math questions and solutions.',Ql,qe,Ll,De,Mn="Next, we create a dataset entity in Langfuse to track the runs. Then, we add each item from the dataset to the system. (If you’re not using Langfuse, you might simply store these in your own database or local file for analysis.)",Nl,Pe,Sl,Ke,_l,Oe,pn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/example-dataset.png" alt="Dataset items in Langfuse"/>',Xl,et,zl,tt,rn="We define a helper function <code>run_smolagent()</code> that:",Fl,lt,un="<li>Starts a Langfuse span</li> <li>Runs our agent on the prompt</li> <li>Records the trace ID in Langfuse</li>",ql,st,cn="Then, we loop over each dataset item, run the agent, and link the trace to the dataset item. We can also attach a quick evaluation score if desired.",Dl,nt,Pl,at,mn="You can repeat this process with different:",Kl,it,yn="<li>Models (OpenAI GPT, local LLM, etc.)</li> <li>Tools (search vs. no search)</li> <li>Prompts (different system messages)</li>",Ol,ot,wn="Then compare them side-by-side in your observability tool:",es,Mt,Tn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset_runs.png" alt="Dataset run overview"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset-run-comparison.png" alt="Dataset run comparison"/>',ts,pt,ls,rt,jn="In this notebook, we covered how to:",ss,ut,dn="<li><strong>Set up Observability</strong> using smolagents + OpenTelemetry exporters</li> <li><strong>Check Instrumentation</strong> by running a simple agent</li> <li><strong>Capture Detailed Metrics</strong> (cost, latency, etc.) through an observability tools</li> <li><strong>Collect User Feedback</strong> via a Gradio interface</li> <li><strong>Use LLM-as-a-Judge</strong> to automatically evaluate outputs</li> <li><strong>Perform Offline Evaluation</strong> with a benchmark dataset</li>",ns,ct,hn="🤗 Happy coding!",as,mt,is,yt,os;return T=new $n({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https%3A//huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents.ipynb"}]}}),f=new w({props:{title:"Bonus Unit 2: Observability and Evaluation of Agents",local:"bonus-unit-2-observability-and-evaluation-of-agents",headingTag:"h1"}}),g=new Gn({props:{$$slots:{default:[An]},$$scope:{ctx:wt}}}),Z=new w({props:{title:"Exercise Prerequisites 🏗️",local:"exercise-prerequisites-",headingTag:"h2"}}),$=new w({props:{title:"Step 0: Install the Required Libraries",local:"step-0-install-the-required-libraries",headingTag:"h2"}}),A=new h({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdmdXNlJTIwJ3Ntb2xhZ2VudHMlNUJ0ZWxlbWV0cnklNUQnJTIwb3BlbmluZmVyZW5jZS1pbnN0cnVtZW50YXRpb24tc21vbGFnZW50cyUyMGRhdGFzZXRzJTIwJ3Ntb2xhZ2VudHMlNUJncmFkaW8lNUQnJTIwZ3JhZGlvJTIwLS11cGdyYWRl",highlighted:'%pip install langfuse <span class="hljs-string">&#x27;smolagents[telemetry]&#x27;</span> openinference-instrumentation-smolagents datasets <span class="hljs-string">&#x27;smolagents[gradio]&#x27;</span> gradio --upgrade',wrap:!1}}),x=new w({props:{title:"Step 1: Instrument Your Agent",local:"step-1-instrument-your-agent",headingTag:"h2"}}),H=new h({props:{code:"aW1wb3J0JTIwb3MlMEElMjMlMjBHZXQlMjBrZXlzJTIwZm9yJTIweW91ciUyMHByb2plY3QlMjBmcm9tJTIwdGhlJTIwcHJvamVjdCUyMHNldHRpbmdzJTIwcGFnZSUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUyMCUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBFVSUyMHJlZ2lvbiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbg==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-comment"># Get keys for your project from the project settings page: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 EU region</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 US region</span>`,wrap:!1}}),Q=new h({props:{code:"JTIzJTIwU2V0JTIweW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYW5kJTIwb3RoZXIlMjB0b2tlbnMlMkZzZWNyZXRzJTIwYXMlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTBBb3MuZW52aXJvbiU1QiUyMkhGX1RPS0VOJTIyJTVEJTIwJTNEJTIwJTIyaGZfLi4uJTIyJTIw",highlighted:`<span class="hljs-comment"># Set your Hugging Face and other tokens/secrets as environment variable</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span> `,wrap:!1}}),N=new h({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQSUyMCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTIwJTBBJTIzJTIwVmVyaWZ5JTIwY29ubmVjdGlvbiUwQWlmJTIwbGFuZ2Z1c2UuYXV0aF9jaGVjaygpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTGFuZ2Z1c2UlMjBjbGllbnQlMjBpcyUyMGF1dGhlbnRpY2F0ZWQlMjBhbmQlMjByZWFkeSElMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkF1dGhlbnRpY2F0aW9uJTIwZmFpbGVkLiUyMFBsZWFzZSUyMGNoZWNrJTIweW91ciUyMGNyZWRlbnRpYWxzJTIwYW5kJTIwaG9zdC4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()
 
<span class="hljs-comment"># Verify connection</span>
<span class="hljs-keyword">if</span> langfuse.auth_check():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Langfuse client is authenticated and ready!&quot;</span>)
<span class="hljs-keyword">else</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Authentication failed. Please check your credentials and host.&quot;</span>)`,wrap:!1}}),_=new h({props:{code:"ZnJvbSUyMG9wZW5pbmZlcmVuY2UuaW5zdHJ1bWVudGF0aW9uLnNtb2xhZ2VudHMlMjBpbXBvcnQlMjBTbW9sYWdlbnRzSW5zdHJ1bWVudG9yJTBBJTIwJTBBU21vbGFnZW50c0luc3RydW1lbnRvcigpLmluc3RydW1lbnQoKQ==",highlighted:`<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
 
SmolagentsInstrumentor().instrument()`,wrap:!1}}),X=new w({props:{title:"Step 2: Test Your Instrumentation",local:"step-2-test-your-instrumentation",headingTag:"h2"}}),F=new h({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjBzaW1wbGUlMjBhZ2VudCUyMHRvJTIwdGVzdCUyMGluc3RydW1lbnRhdGlvbiUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQWFnZW50LnJ1biglMjIxJTJCMSUzRCUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># Create a simple agent to test instrumentation</span>
agent = CodeAgent(
    tools=[],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;1+1=&quot;</span>)`,wrap:!1}}),O=new w({props:{title:"Step 3: Observe and Evaluate a More Complex Agent",local:"step-3-observe-and-evaluate-a-more-complex-agent",headingTag:"h2"}}),te=new h({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwUnViaWsncyUyMEN1YmVzJTIwY291bGQlMjB5b3UlMjBmaXQlMjBpbnNpZGUlMjB0aGUlMjBOb3RyZSUyMERhbWUlMjBDYXRoZWRyYWwlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;How many Rubik&#x27;s Cubes could you fit inside the Notre Dame Cathedral?&quot;</span>)`,wrap:!1}}),le=new w({props:{title:"Trace Structure",local:"trace-structure",headingTag:"h3"}}),Me=new w({props:{title:"Online Evaluation",local:"online-evaluation",headingTag:"h2"}}),re=new w({props:{title:"Common Metrics to Track in Production",local:"common-metrics-to-track-in-production",headingTag:"h3"}}),me=new w({props:{title:"1. Costs",local:"1-costs",headingTag:"h4"}}),je=new w({props:{title:"2. Latency",local:"2-latency",headingTag:"h4"}}),Ue=new w({props:{title:"3. Additional Attributes",local:"3-additional-attributes",headingTag:"h4"}}),ge=new h({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQXdpdGglMjBsYW5nZnVzZS5zdGFydF9hc19jdXJyZW50X3NwYW4oJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMlNtb2xhZ2VudC1UcmFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMjBhcyUyMHNwYW4lM0ElMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBSdW4lMjB5b3VyJTIwYXBwbGljYXRpb24lMjBoZXJlJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBhZ2VudC5ydW4oJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwR2VybWFueSUzRiUyMiklMEElMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBQYXNzJTIwYWRkaXRpb25hbCUyMGF0dHJpYnV0ZXMlMjB0byUyMHRoZSUyMHNwYW4lMEElMjAlMjAlMjAlMjBzcGFuLnVwZGF0ZV90cmFjZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEdlcm1hbnklM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXQlM0RyZXNwb25zZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHVzZXJfaWQlM0QlMjJzbW9sYWdlbnQtdXNlci0xMjMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZXNzaW9uX2lkJTNEJTIyc21vbGFnZW50LXNlc3Npb24tMTIzNDU2Nzg5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFncyUzRCU1QiUyMmNpdHktcXVlc3Rpb24lMjIlMkMlMjAlMjJ0ZXN0aW5nLWFnZW50cyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIyZW1haWwlMjIlM0ElMjAlMjJ1c2VyJTQwbGFuZ2Z1c2UuY29tJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUwQSUyMyUyMEZsdXNoJTIwZXZlbnRzJTIwaW4lMjBzaG9ydC1saXZlZCUyMGFwcGxpY2F0aW9ucyUwQWxhbmdmdXNlLmZsdXNoKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(
    tools=[search_tool],
    model=InferenceClientModel()
)

<span class="hljs-keyword">with</span> langfuse.start_as_current_span(
    name=<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>,
    ) <span class="hljs-keyword">as</span> span:
    
    <span class="hljs-comment"># Run your application here</span>
    response = agent.run(<span class="hljs-string">&quot;What is the capital of Germany?&quot;</span>)
 
    <span class="hljs-comment"># Pass additional attributes to the span</span>
    span.update_trace(
        <span class="hljs-built_in">input</span>=<span class="hljs-string">&quot;What is the capital of Germany?&quot;</span>,
        output=response,
        user_id=<span class="hljs-string">&quot;smolagent-user-123&quot;</span>,
        session_id=<span class="hljs-string">&quot;smolagent-session-123456789&quot;</span>,
        tags=[<span class="hljs-string">&quot;city-question&quot;</span>, <span class="hljs-string">&quot;testing-agents&quot;</span>],
        metadata={<span class="hljs-string">&quot;email&quot;</span>: <span class="hljs-string">&quot;user@langfuse.com&quot;</span>},
        )
 
<span class="hljs-comment"># Flush events in short-lived applications</span>
langfuse.flush()`,wrap:!1}}),Ce=new w({props:{title:"4. User Feedback",local:"4-user-feedback",headingTag:"h4"}}),Ze=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client

langfuse = get_client()

model = InferenceClientModel()
agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)

trace_id = <span class="hljs-literal">None</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">respond</span>(<span class="hljs-params">prompt, history</span>):
    <span class="hljs-keyword">with</span> langfuse.start_as_current_span(
        name=<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>):
        
        <span class="hljs-comment"># Run your application here</span>
        output = agent.run(prompt)

        <span class="hljs-keyword">global</span> trace_id
        trace_id = langfuse.get_current_trace_id()

    history.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-built_in">str</span>(output)})
    <span class="hljs-keyword">return</span> history

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_like</span>(<span class="hljs-params">data: gr.LikeData</span>):
    <span class="hljs-comment"># For demonstration, we map user feedback to a 1 (like) or 0 (dislike)</span>
    <span class="hljs-keyword">if</span> data.liked:
        langfuse.create_score(
            value=<span class="hljs-number">1</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=trace_id
        )
    <span class="hljs-keyword">else</span>:
        langfuse.create_score(
            value=<span class="hljs-number">0</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=trace_id
        )

<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    chatbot = gr.Chatbot(label=<span class="hljs-string">&quot;Chat&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>)
    prompt_box = gr.Textbox(placeholder=<span class="hljs-string">&quot;Type your message...&quot;</span>, label=<span class="hljs-string">&quot;Your message&quot;</span>)

    <span class="hljs-comment"># When the user presses &#x27;Enter&#x27; on the prompt, we run &#x27;respond&#x27;</span>
    prompt_box.submit(
        fn=respond,
        inputs=[prompt_box, chatbot],
        outputs=chatbot
    )

    <span class="hljs-comment"># When the user clicks a &#x27;like&#x27; button on a message, we run &#x27;handle_like&#x27;</span>
    chatbot.like(handle_like, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>)

demo.launch()`,wrap:!1}}),Ge=new w({props:{title:"5. LLM-as-a-Judge",local:"5-llm-as-a-judge",headingTag:"h4"}}),Ee=new h({props:{code:"JTIzJTIwRXhhbXBsZSUzQSUyMENoZWNraW5nJTIwaWYlMjB0aGUlMjBhZ2VudCVFMiU4MCU5OXMlMjBvdXRwdXQlMjBpcyUyMHRveGljJTIwb3IlMjBub3QuJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJDYW4lMjBlYXRpbmclMjBjYXJyb3RzJTIwaW1wcm92ZSUyMHlvdXIlMjB2aXNpb24lM0YlMjIp",highlighted:`<span class="hljs-comment"># Example: Checking if the agent’s output is toxic or not.</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Can eating carrots improve your vision?&quot;</span>)`,wrap:!1}}),Ye=new w({props:{title:"6. Observability Metrics Overview",local:"6-observability-metrics-overview",headingTag:"h4"}}),Ne=new w({props:{title:"Offline Evaluation",local:"offline-evaluation",headingTag:"h2"}}),_e=new w({props:{title:"Dataset Evaluation",local:"dataset-evaluation",headingTag:"h3"}}),qe=new h({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMEZldGNoJTIwR1NNOEslMjBmcm9tJTIwSHVnZ2luZyUyMEZhY2UlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm9wZW5haSUyRmdzbThrJTIyJTJDJTIwJ21haW4nJTJDJTIwc3BsaXQlM0QndHJhaW4nKSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGRhdGFzZXQpJTBBcHJpbnQoJTIyRmlyc3QlMjBmZXclMjByb3dzJTIwb2YlMjBHU004SyUyMGRhdGFzZXQlM0ElMjIpJTBBcHJpbnQoZGYuaGVhZCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Fetch GSM8K from Hugging Face</span>
dataset = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&#x27;main&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)
df = pd.DataFrame(dataset)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;First few rows of GSM8K dataset:&quot;</span>)
<span class="hljs-built_in">print</span>(df.head())`,wrap:!1}}),Pe=new h({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTBBbGFuZ2Z1c2VfZGF0YXNldF9uYW1lJTIwJTNEJTIwJTIyZ3NtOGtfZGF0YXNldF9odWdnaW5nZmFjZSUyMiUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjBkYXRhc2V0JTIwaW4lMjBMYW5nZnVzZSUwQWxhbmdmdXNlLmNyZWF0ZV9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMG5hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkdTTThLJTIwYmVuY2htYXJrJTIwZGF0YXNldCUyMHVwbG9hZGVkJTIwZnJvbSUyMEh1Z2dpbmdmYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkYXRlJTIyJTNBJTIwJTIyMjAyNS0wMy0xMCUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJiZW5jaG1hcmslMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
langfuse = get_client()

langfuse_dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>

<span class="hljs-comment"># Create a dataset in Langfuse</span>
langfuse.create_dataset(
    name=langfuse_dataset_name,
    description=<span class="hljs-string">&quot;GSM8K benchmark dataset uploaded from Huggingface&quot;</span>,
    metadata={
        <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2025-03-10&quot;</span>, 
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;benchmark&quot;</span>
    }
)`,wrap:!1}}),Ke=new h({props:{code:"Zm9yJTIwaWR4JTJDJTIwcm93JTIwaW4lMjBkZi5pdGVycm93cygpJTNBJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXRfaXRlbSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X25hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJxdWVzdGlvbiUyMiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cGVjdGVkX291dHB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJhbnN3ZXIlMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZV9pbmRleCUyMiUzQSUyMGlkeCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpZiUyMGlkeCUyMCUzRSUzRCUyMDklM0ElMjAlMjMlMjBVcGxvYWQlMjBvbmx5JTIwdGhlJTIwZmlyc3QlMjAxMCUyMGl0ZW1zJTIwZm9yJTIwZGVtb25zdHJhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> idx, row <span class="hljs-keyword">in</span> df.iterrows():
    langfuse.create_dataset_item(
        dataset_name=langfuse_dataset_name,
        <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;question&quot;</span>]},
        expected_output={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;answer&quot;</span>]},
        metadata={<span class="hljs-string">&quot;source_index&quot;</span>: idx}
    )
    <span class="hljs-keyword">if</span> idx &gt;= <span class="hljs-number">9</span>: <span class="hljs-comment"># Upload only the first 10 items for demonstration</span>
        <span class="hljs-keyword">break</span>`,wrap:!1}}),et=new w({props:{title:"Running the Agent on the Dataset",local:"running-the-agent-on-the-dataset",headingTag:"h4"}}),nt=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel, LiteLLMModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()


<span class="hljs-comment"># Example: using InferenceClientModel or LiteLLMModel to access openai, anthropic, gemini, etc. models:</span>
model = InferenceClientModel()

agent = CodeAgent(
    tools=[],
    model=model,
    add_base_tools=<span class="hljs-literal">True</span>
)

dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>
current_run_name = <span class="hljs-string">&quot;smolagent-notebook-run-01&quot;</span> <span class="hljs-comment"># Identifies this specific evaluation run</span>
 
<span class="hljs-comment"># Assume &#x27;run_smolagent&#x27; is your instrumented application function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_smolagent</span>(<span class="hljs-params">question</span>):
    <span class="hljs-keyword">with</span> langfuse.start_as_current_generation(name=<span class="hljs-string">&quot;qna-llm-call&quot;</span>) <span class="hljs-keyword">as</span> generation:
        <span class="hljs-comment"># Simulate LLM call</span>
        result = agent.run(question)
 
        <span class="hljs-comment"># Update the trace with the input and output</span>
        generation.update_trace(
            <span class="hljs-built_in">input</span>= question,
            output=result,
        )
 
        <span class="hljs-keyword">return</span> result
 
dataset = langfuse.get_dataset(name=dataset_name) <span class="hljs-comment"># Fetch your pre-populated dataset</span>
 
<span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset.items:
 
    <span class="hljs-comment"># Use the item.run() context manager</span>
    <span class="hljs-keyword">with</span> item.run(
        run_name=current_run_name,
        run_metadata={<span class="hljs-string">&quot;model_provider&quot;</span>: <span class="hljs-string">&quot;Hugging Face&quot;</span>, <span class="hljs-string">&quot;temperature_setting&quot;</span>: <span class="hljs-number">0.7</span>},
        run_description=<span class="hljs-string">&quot;Evaluation run for GSM8K dataset&quot;</span>
    ) <span class="hljs-keyword">as</span> root_span: <span class="hljs-comment"># root_span is the root span of the new trace for this item and run.</span>
        <span class="hljs-comment"># All subsequent langfuse operations within this block are part of this trace.</span>
 
        <span class="hljs-comment"># Call your application logic</span>
        generated_answer = run_smolagent(question=item.<span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;text&quot;</span>])
 
        <span class="hljs-built_in">print</span>(item.<span class="hljs-built_in">input</span>)`,wrap:!1}}),pt=new w({props:{title:"Final Thoughts",local:"final-thoughts",headingTag:"h2"}}),mt=new Wn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/bonus-unit2/monitoring-and-evaluating-agents-notebook.mdx"}}),{c(){j=i("meta"),d=n(),U=i("p"),J=n(),p(T.$$.fragment),b=n(),p(f.$$.fragment),Tt=n(),p(g.$$.fragment),jt=n(),C=i("p"),C.innerHTML=ps,dt=n(),I=i("p"),I.textContent=rs,ht=n(),v=i("ul"),v.innerHTML=us,Jt=n(),p(Z.$$.fragment),Ut=n(),B=i("p"),B.textContent=cs,bt=n(),k=i("p"),k.innerHTML=ms,gt=n(),G=i("p"),G.innerHTML=ys,ft=n(),p($.$$.fragment),Ct=n(),W=i("p"),W.textContent=ws,It=n(),p(A.$$.fragment),vt=n(),p(x.$$.fragment),Zt=n(),R=i("p"),R.innerHTML=Ts,Bt=n(),E=i("p"),E.innerHTML=js,kt=n(),V=i("p"),V.innerHTML=ds,Gt=n(),p(H.$$.fragment),$t=n(),Y=i("p"),Y.textContent=hs,Wt=n(),p(Q.$$.fragment),At=n(),L=i("p"),L.innerHTML=Js,xt=n(),p(N.$$.fragment),Rt=n(),S=i("p"),S.innerHTML=Us,Et=n(),p(_.$$.fragment),Vt=n(),p(X.$$.fragment),Ht=n(),z=i("p"),z.innerHTML=bs,Yt=n(),p(F.$$.fragment),Qt=n(),q=i("p"),q.innerHTML=gs,Lt=n(),D=i("p"),D.textContent=fs,Nt=n(),P=i("p"),P.innerHTML=Cs,St=n(),K=i("p"),K.innerHTML=Is,_t=n(),p(O.$$.fragment),Xt=n(),ee=i("p"),ee.textContent=vs,zt=n(),p(te.$$.fragment),Ft=n(),p(le.$$.fragment),qt=n(),se=i("p"),se.innerHTML=Zs,Dt=n(),ne=i("ul"),ne.innerHTML=Bs,Pt=n(),ae=i("p"),ae.textContent=ks,Kt=n(),ie=i("p"),ie.innerHTML=Gs,Ot=n(),oe=i("p"),oe.innerHTML=$s,el=n(),p(Me.$$.fragment),tl=n(),pe=i("p"),pe.textContent=Ws,ll=n(),p(re.$$.fragment),sl=n(),ue=i("ol"),ue.innerHTML=As,nl=n(),ce=i("p"),ce.textContent=xs,al=n(),p(me.$$.fragment),il=n(),ye=i("p"),ye.innerHTML=Rs,ol=n(),we=i("p"),we.innerHTML=Es,Ml=n(),Te=i("p"),Te.innerHTML=Vs,pl=n(),p(je.$$.fragment),rl=n(),de=i("p"),de.textContent=Hs,ul=n(),he=i("p"),he.innerHTML=Ys,cl=n(),Je=i("p"),Je.innerHTML=Qs,ml=n(),p(Ue.$$.fragment),yl=n(),be=i("p"),be.innerHTML=Ls,wl=n(),p(ge.$$.fragment),Tl=n(),fe=i("p"),fe.innerHTML=Ns,jl=n(),p(Ce.$$.fragment),dl=n(),Ie=i("p"),Ie.innerHTML=Ss,hl=n(),ve=i("p"),ve.textContent=_s,Jl=n(),p(Ze.$$.fragment),Ul=n(),Be=i("p"),Be.textContent=Xs,bl=n(),ke=i("p"),ke.innerHTML=zs,gl=n(),p(Ge.$$.fragment),fl=n(),$e=i("p"),$e.textContent=Fs,Cl=n(),We=i("p"),We.innerHTML=qs,Il=n(),Ae=i("ol"),Ae.innerHTML=Ds,vl=n(),xe=i("p"),xe.textContent=Ps,Zl=n(),Re=i("p"),Re.innerHTML=Ks,Bl=n(),p(Ee.$$.fragment),kl=n(),Ve=i("p"),Ve.textContent=Os,Gl=n(),He=i("p"),He.innerHTML=en,$l=n(),p(Ye.$$.fragment),Wl=n(),Qe=i("p"),Qe.textContent=tn,Al=n(),Le=i("p"),Le.innerHTML=ln,xl=n(),p(Ne.$$.fragment),Rl=n(),Se=i("p"),Se.innerHTML=sn,El=n(),p(_e.$$.fragment),Vl=n(),Xe=i("p"),Xe.textContent=nn,Hl=n(),ze=i("ol"),ze.innerHTML=an,Yl=n(),Fe=i("p"),Fe.innerHTML=on,Ql=n(),p(qe.$$.fragment),Ll=n(),De=i("p"),De.textContent=Mn,Nl=n(),p(Pe.$$.fragment),Sl=n(),p(Ke.$$.fragment),_l=n(),Oe=i("p"),Oe.innerHTML=pn,Xl=n(),p(et.$$.fragment),zl=n(),tt=i("p"),tt.innerHTML=rn,Fl=n(),lt=i("ol"),lt.innerHTML=un,ql=n(),st=i("p"),st.textContent=cn,Dl=n(),p(nt.$$.fragment),Pl=n(),at=i("p"),at.textContent=mn,Kl=n(),it=i("ul"),it.innerHTML=yn,Ol=n(),ot=i("p"),ot.textContent=wn,es=n(),Mt=i("p"),Mt.innerHTML=Tn,ts=n(),p(pt.$$.fragment),ls=n(),rt=i("p"),rt.textContent=jn,ss=n(),ut=i("ol"),ut.innerHTML=dn,ns=n(),ct=i("p"),ct.textContent=hn,as=n(),p(mt.$$.fragment),is=n(),yt=i("p"),this.h()},l(e){const t=Bn("svelte-u9bgzb",document.head);j=o(t,"META",{name:!0,content:!0}),t.forEach(l),d=a(e),U=o(e,"P",{}),Un(U).forEach(l),J=a(e),r(T.$$.fragment,e),b=a(e),r(f.$$.fragment,e),Tt=a(e),r(g.$$.fragment,e),jt=a(e),C=o(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1hjcrzt"&&(C.innerHTML=ps),dt=a(e),I=o(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-foopw1"&&(I.textContent=rs),ht=a(e),v=o(e,"UL",{"data-svelte-h":!0}),M(v)!=="svelte-owrpod"&&(v.innerHTML=us),Jt=a(e),r(Z.$$.fragment,e),Ut=a(e),B=o(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-5cu48y"&&(B.textContent=cs),bt=a(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-tid2rn"&&(k.innerHTML=ms),gt=a(e),G=o(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-11ima5v"&&(G.innerHTML=ys),ft=a(e),r($.$$.fragment,e),Ct=a(e),W=o(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-13k1zsa"&&(W.textContent=ws),It=a(e),r(A.$$.fragment,e),vt=a(e),r(x.$$.fragment,e),Zt=a(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1om0xhg"&&(R.innerHTML=Ts),Bt=a(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-10zlua1"&&(E.innerHTML=js),kt=a(e),V=o(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1kbyizu"&&(V.innerHTML=ds),Gt=a(e),r(H.$$.fragment,e),$t=a(e),Y=o(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-188d5j6"&&(Y.textContent=hs),Wt=a(e),r(Q.$$.fragment,e),At=a(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-wfv4z0"&&(L.innerHTML=Js),xt=a(e),r(N.$$.fragment,e),Rt=a(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1uenr7t"&&(S.innerHTML=Us),Et=a(e),r(_.$$.fragment,e),Vt=a(e),r(X.$$.fragment,e),Ht=a(e),z=o(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-18gebex"&&(z.innerHTML=bs),Yt=a(e),r(F.$$.fragment,e),Qt=a(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-vzfgml"&&(q.innerHTML=gs),Lt=a(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-17kovw7"&&(D.textContent=fs),Nt=a(e),P=o(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1cb993n"&&(P.innerHTML=Cs),St=a(e),K=o(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-3d3s8c"&&(K.innerHTML=Is),_t=a(e),r(O.$$.fragment,e),Xt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-vj8duz"&&(ee.textContent=vs),zt=a(e),r(te.$$.fragment,e),Ft=a(e),r(le.$$.fragment,e),qt=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-11qm5kf"&&(se.innerHTML=Zs),Dt=a(e),ne=o(e,"UL",{"data-svelte-h":!0}),M(ne)!=="svelte-1pzu7di"&&(ne.innerHTML=Bs),Pt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-5g8r1i"&&(ae.textContent=ks),Kt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-yhkq5w"&&(ie.innerHTML=Gs),Ot=a(e),oe=o(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-19v4344"&&(oe.innerHTML=$s),el=a(e),r(Me.$$.fragment,e),tl=a(e),pe=o(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-1m3q9s4"&&(pe.textContent=Ws),ll=a(e),r(re.$$.fragment,e),sl=a(e),ue=o(e,"OL",{"data-svelte-h":!0}),M(ue)!=="svelte-it9cbz"&&(ue.innerHTML=As),nl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-1gkbldi"&&(ce.textContent=xs),al=a(e),r(me.$$.fragment,e),il=a(e),ye=o(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-zy3zhh"&&(ye.innerHTML=Rs),ol=a(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-dard47"&&(we.innerHTML=Es),Ml=a(e),Te=o(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-19v4344"&&(Te.innerHTML=Vs),pl=a(e),r(je.$$.fragment,e),rl=a(e),de=o(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-v1au4h"&&(de.textContent=Hs),ul=a(e),he=o(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-1org4pj"&&(he.innerHTML=Ys),cl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-19v4344"&&(Je.innerHTML=Qs),ml=a(e),r(Ue.$$.fragment,e),yl=a(e),be=o(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-ut7yv4"&&(be.innerHTML=Ls),wl=a(e),r(ge.$$.fragment,e),Tl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-1gx91hu"&&(fe.innerHTML=Ns),jl=a(e),r(Ce.$$.fragment,e),dl=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-1t6vqwk"&&(Ie.innerHTML=Ss),hl=a(e),ve=o(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-1rxqxjo"&&(ve.textContent=_s),Jl=a(e),r(Ze.$$.fragment,e),Ul=a(e),Be=o(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-qczj9m"&&(Be.textContent=Xs),bl=a(e),ke=o(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-e6ive4"&&(ke.innerHTML=zs),gl=a(e),r(Ge.$$.fragment,e),fl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-1guzmu1"&&($e.textContent=Fs),Cl=a(e),We=o(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-13jor3c"&&(We.innerHTML=qs),Il=a(e),Ae=o(e,"OL",{"data-svelte-h":!0}),M(Ae)!=="svelte-8y9f4i"&&(Ae.innerHTML=Ds),vl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-6rieqh"&&(xe.textContent=Ps),Zl=a(e),Re=o(e,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-1uar592"&&(Re.innerHTML=Ks),Bl=a(e),r(Ee.$$.fragment,e),kl=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-3xsjjj"&&(Ve.textContent=Os),Gl=a(e),He=o(e,"P",{"data-svelte-h":!0}),M(He)!=="svelte-zj9pt2"&&(He.innerHTML=en),$l=a(e),r(Ye.$$.fragment,e),Wl=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-1053it2"&&(Qe.textContent=tn),Al=a(e),Le=o(e,"P",{"data-svelte-h":!0}),M(Le)!=="svelte-1jemoxg"&&(Le.innerHTML=ln),xl=a(e),r(Ne.$$.fragment,e),Rl=a(e),Se=o(e,"P",{"data-svelte-h":!0}),M(Se)!=="svelte-12emzh2"&&(Se.innerHTML=sn),El=a(e),r(_e.$$.fragment,e),Vl=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),M(Xe)!=="svelte-nxef74"&&(Xe.textContent=nn),Hl=a(e),ze=o(e,"OL",{"data-svelte-h":!0}),M(ze)!=="svelte-1ys56q5"&&(ze.innerHTML=an),Yl=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-ijt5m6"&&(Fe.innerHTML=on),Ql=a(e),r(qe.$$.fragment,e),Ll=a(e),De=o(e,"P",{"data-svelte-h":!0}),M(De)!=="svelte-14neeab"&&(De.textContent=Mn),Nl=a(e),r(Pe.$$.fragment,e),Sl=a(e),r(Ke.$$.fragment,e),_l=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),M(Oe)!=="svelte-giwu4e"&&(Oe.innerHTML=pn),Xl=a(e),r(et.$$.fragment,e),zl=a(e),tt=o(e,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-y12uij"&&(tt.innerHTML=rn),Fl=a(e),lt=o(e,"OL",{"data-svelte-h":!0}),M(lt)!=="svelte-1lfvsus"&&(lt.innerHTML=un),ql=a(e),st=o(e,"P",{"data-svelte-h":!0}),M(st)!=="svelte-1ew78oh"&&(st.textContent=cn),Dl=a(e),r(nt.$$.fragment,e),Pl=a(e),at=o(e,"P",{"data-svelte-h":!0}),M(at)!=="svelte-1ebq4ig"&&(at.textContent=mn),Kl=a(e),it=o(e,"UL",{"data-svelte-h":!0}),M(it)!=="svelte-1lunl6l"&&(it.innerHTML=yn),Ol=a(e),ot=o(e,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-gt2dc"&&(ot.textContent=wn),es=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-ukc2vx"&&(Mt.innerHTML=Tn),ts=a(e),r(pt.$$.fragment,e),ls=a(e),rt=o(e,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-1xbvrw5"&&(rt.textContent=jn),ss=a(e),ut=o(e,"OL",{"data-svelte-h":!0}),M(ut)!=="svelte-1u9pd9c"&&(ut.innerHTML=dn),ns=a(e),ct=o(e,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-3bxv5s"&&(ct.textContent=hn),as=a(e),r(mt.$$.fragment,e),is=a(e),yt=o(e,"P",{}),Un(yt).forEach(l),this.h()},h(){Ms(j,"name","hf:doc:metadata"),Ms(j,"content",Rn)},m(e,t){kn(document.head,j),s(e,d,t),s(e,U,t),s(e,J,t),u(T,e,t),s(e,b,t),u(f,e,t),s(e,Tt,t),u(g,e,t),s(e,jt,t),s(e,C,t),s(e,dt,t),s(e,I,t),s(e,ht,t),s(e,v,t),s(e,Jt,t),u(Z,e,t),s(e,Ut,t),s(e,B,t),s(e,bt,t),s(e,k,t),s(e,gt,t),s(e,G,t),s(e,ft,t),u($,e,t),s(e,Ct,t),s(e,W,t),s(e,It,t),u(A,e,t),s(e,vt,t),u(x,e,t),s(e,Zt,t),s(e,R,t),s(e,Bt,t),s(e,E,t),s(e,kt,t),s(e,V,t),s(e,Gt,t),u(H,e,t),s(e,$t,t),s(e,Y,t),s(e,Wt,t),u(Q,e,t),s(e,At,t),s(e,L,t),s(e,xt,t),u(N,e,t),s(e,Rt,t),s(e,S,t),s(e,Et,t),u(_,e,t),s(e,Vt,t),u(X,e,t),s(e,Ht,t),s(e,z,t),s(e,Yt,t),u(F,e,t),s(e,Qt,t),s(e,q,t),s(e,Lt,t),s(e,D,t),s(e,Nt,t),s(e,P,t),s(e,St,t),s(e,K,t),s(e,_t,t),u(O,e,t),s(e,Xt,t),s(e,ee,t),s(e,zt,t),u(te,e,t),s(e,Ft,t),u(le,e,t),s(e,qt,t),s(e,se,t),s(e,Dt,t),s(e,ne,t),s(e,Pt,t),s(e,ae,t),s(e,Kt,t),s(e,ie,t),s(e,Ot,t),s(e,oe,t),s(e,el,t),u(Me,e,t),s(e,tl,t),s(e,pe,t),s(e,ll,t),u(re,e,t),s(e,sl,t),s(e,ue,t),s(e,nl,t),s(e,ce,t),s(e,al,t),u(me,e,t),s(e,il,t),s(e,ye,t),s(e,ol,t),s(e,we,t),s(e,Ml,t),s(e,Te,t),s(e,pl,t),u(je,e,t),s(e,rl,t),s(e,de,t),s(e,ul,t),s(e,he,t),s(e,cl,t),s(e,Je,t),s(e,ml,t),u(Ue,e,t),s(e,yl,t),s(e,be,t),s(e,wl,t),u(ge,e,t),s(e,Tl,t),s(e,fe,t),s(e,jl,t),u(Ce,e,t),s(e,dl,t),s(e,Ie,t),s(e,hl,t),s(e,ve,t),s(e,Jl,t),u(Ze,e,t),s(e,Ul,t),s(e,Be,t),s(e,bl,t),s(e,ke,t),s(e,gl,t),u(Ge,e,t),s(e,fl,t),s(e,$e,t),s(e,Cl,t),s(e,We,t),s(e,Il,t),s(e,Ae,t),s(e,vl,t),s(e,xe,t),s(e,Zl,t),s(e,Re,t),s(e,Bl,t),u(Ee,e,t),s(e,kl,t),s(e,Ve,t),s(e,Gl,t),s(e,He,t),s(e,$l,t),u(Ye,e,t),s(e,Wl,t),s(e,Qe,t),s(e,Al,t),s(e,Le,t),s(e,xl,t),u(Ne,e,t),s(e,Rl,t),s(e,Se,t),s(e,El,t),u(_e,e,t),s(e,Vl,t),s(e,Xe,t),s(e,Hl,t),s(e,ze,t),s(e,Yl,t),s(e,Fe,t),s(e,Ql,t),u(qe,e,t),s(e,Ll,t),s(e,De,t),s(e,Nl,t),u(Pe,e,t),s(e,Sl,t),u(Ke,e,t),s(e,_l,t),s(e,Oe,t),s(e,Xl,t),u(et,e,t),s(e,zl,t),s(e,tt,t),s(e,Fl,t),s(e,lt,t),s(e,ql,t),s(e,st,t),s(e,Dl,t),u(nt,e,t),s(e,Pl,t),s(e,at,t),s(e,Kl,t),s(e,it,t),s(e,Ol,t),s(e,ot,t),s(e,es,t),s(e,Mt,t),s(e,ts,t),u(pt,e,t),s(e,ls,t),s(e,rt,t),s(e,ss,t),s(e,ut,t),s(e,ns,t),s(e,ct,t),s(e,as,t),u(mt,e,t),s(e,is,t),s(e,yt,t),os=!0},p(e,[t]){const Jn={};t&2&&(Jn.$$scope={dirty:t,ctx:e}),g.$set(Jn)},i(e){os||(c(T.$$.fragment,e),c(f.$$.fragment,e),c(g.$$.fragment,e),c(Z.$$.fragment,e),c($.$$.fragment,e),c(A.$$.fragment,e),c(x.$$.fragment,e),c(H.$$.fragment,e),c(Q.$$.fragment,e),c(N.$$.fragment,e),c(_.$$.fragment,e),c(X.$$.fragment,e),c(F.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(Me.$$.fragment,e),c(re.$$.fragment,e),c(me.$$.fragment,e),c(je.$$.fragment,e),c(Ue.$$.fragment,e),c(ge.$$.fragment,e),c(Ce.$$.fragment,e),c(Ze.$$.fragment,e),c(Ge.$$.fragment,e),c(Ee.$$.fragment,e),c(Ye.$$.fragment,e),c(Ne.$$.fragment,e),c(_e.$$.fragment,e),c(qe.$$.fragment,e),c(Pe.$$.fragment,e),c(Ke.$$.fragment,e),c(et.$$.fragment,e),c(nt.$$.fragment,e),c(pt.$$.fragment,e),c(mt.$$.fragment,e),os=!0)},o(e){m(T.$$.fragment,e),m(f.$$.fragment,e),m(g.$$.fragment,e),m(Z.$$.fragment,e),m($.$$.fragment,e),m(A.$$.fragment,e),m(x.$$.fragment,e),m(H.$$.fragment,e),m(Q.$$.fragment,e),m(N.$$.fragment,e),m(_.$$.fragment,e),m(X.$$.fragment,e),m(F.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(Me.$$.fragment,e),m(re.$$.fragment,e),m(me.$$.fragment,e),m(je.$$.fragment,e),m(Ue.$$.fragment,e),m(ge.$$.fragment,e),m(Ce.$$.fragment,e),m(Ze.$$.fragment,e),m(Ge.$$.fragment,e),m(Ee.$$.fragment,e),m(Ye.$$.fragment,e),m(Ne.$$.fragment,e),m(_e.$$.fragment,e),m(qe.$$.fragment,e),m(Pe.$$.fragment,e),m(Ke.$$.fragment,e),m(et.$$.fragment,e),m(nt.$$.fragment,e),m(pt.$$.fragment,e),m(mt.$$.fragment,e),os=!1},d(e){e&&(l(d),l(U),l(J),l(b),l(Tt),l(jt),l(C),l(dt),l(I),l(ht),l(v),l(Jt),l(Ut),l(B),l(bt),l(k),l(gt),l(G),l(ft),l(Ct),l(W),l(It),l(vt),l(Zt),l(R),l(Bt),l(E),l(kt),l(V),l(Gt),l($t),l(Y),l(Wt),l(At),l(L),l(xt),l(Rt),l(S),l(Et),l(Vt),l(Ht),l(z),l(Yt),l(Qt),l(q),l(Lt),l(D),l(Nt),l(P),l(St),l(K),l(_t),l(Xt),l(ee),l(zt),l(Ft),l(qt),l(se),l(Dt),l(ne),l(Pt),l(ae),l(Kt),l(ie),l(Ot),l(oe),l(el),l(tl),l(pe),l(ll),l(sl),l(ue),l(nl),l(ce),l(al),l(il),l(ye),l(ol),l(we),l(Ml),l(Te),l(pl),l(rl),l(de),l(ul),l(he),l(cl),l(Je),l(ml),l(yl),l(be),l(wl),l(Tl),l(fe),l(jl),l(dl),l(Ie),l(hl),l(ve),l(Jl),l(Ul),l(Be),l(bl),l(ke),l(gl),l(fl),l($e),l(Cl),l(We),l(Il),l(Ae),l(vl),l(xe),l(Zl),l(Re),l(Bl),l(kl),l(Ve),l(Gl),l(He),l($l),l(Wl),l(Qe),l(Al),l(Le),l(xl),l(Rl),l(Se),l(El),l(Vl),l(Xe),l(Hl),l(ze),l(Yl),l(Fe),l(Ql),l(Ll),l(De),l(Nl),l(Sl),l(_l),l(Oe),l(Xl),l(zl),l(tt),l(Fl),l(lt),l(ql),l(st),l(Dl),l(Pl),l(at),l(Kl),l(it),l(Ol),l(ot),l(es),l(Mt),l(ts),l(ls),l(rt),l(ss),l(ut),l(ns),l(ct),l(as),l(is),l(yt)),l(j),y(T,e),y(f,e),y(g,e),y(Z,e),y($,e),y(A,e),y(x,e),y(H,e),y(Q,e),y(N,e),y(_,e),y(X,e),y(F,e),y(O,e),y(te,e),y(le,e),y(Me,e),y(re,e),y(me,e),y(je,e),y(Ue,e),y(ge,e),y(Ce,e),y(Ze,e),y(Ge,e),y(Ee,e),y(Ye,e),y(Ne,e),y(_e,e),y(qe,e),y(Pe,e),y(Ke,e),y(et,e),y(nt,e),y(pt,e),y(mt,e)}}}const Rn='{"title":"Bonus Unit 2: Observability and Evaluation of Agents","local":"bonus-unit-2-observability-and-evaluation-of-agents","sections":[{"title":"Exercise Prerequisites 🏗️","local":"exercise-prerequisites-","sections":[],"depth":2},{"title":"Step 0: Install the Required Libraries","local":"step-0-install-the-required-libraries","sections":[],"depth":2},{"title":"Step 1: Instrument Your Agent","local":"step-1-instrument-your-agent","sections":[],"depth":2},{"title":"Step 2: Test Your Instrumentation","local":"step-2-test-your-instrumentation","sections":[],"depth":2},{"title":"Step 3: Observe and Evaluate a More Complex Agent","local":"step-3-observe-and-evaluate-a-more-complex-agent","sections":[{"title":"Trace Structure","local":"trace-structure","sections":[],"depth":3}],"depth":2},{"title":"Online Evaluation","local":"online-evaluation","sections":[{"title":"Common Metrics to Track in Production","local":"common-metrics-to-track-in-production","sections":[{"title":"1. Costs","local":"1-costs","sections":[],"depth":4},{"title":"2. Latency","local":"2-latency","sections":[],"depth":4},{"title":"3. Additional Attributes","local":"3-additional-attributes","sections":[],"depth":4},{"title":"4. User Feedback","local":"4-user-feedback","sections":[],"depth":4},{"title":"5. LLM-as-a-Judge","local":"5-llm-as-a-judge","sections":[],"depth":4},{"title":"6. Observability Metrics Overview","local":"6-observability-metrics-overview","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Offline Evaluation","local":"offline-evaluation","sections":[{"title":"Dataset Evaluation","local":"dataset-evaluation","sections":[{"title":"Running the Agent on the Dataset","local":"running-the-agent-on-the-dataset","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Final Thoughts","local":"final-thoughts","sections":[],"depth":2}],"depth":1}';function En(wt){return Cn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _n extends vn{constructor(j){super(),Zn(this,j,En,xn,fn,{})}}export{_n as component};
