import{s as ue,f as Ht,n as Me,o as me}from"../chunks/scheduler.37c15a92.js";import{S as de,i as ce,g as i,s as n,r as o,A as ye,h as p,f as s,c as a,j as oe,u,x as r,k as h,y as he,a as l,v as M,d as m,t as d,w as c}from"../chunks/index.2bf4358c.js";import{C as D}from"../chunks/CodeBlock.4e987730.js";import{H as O}from"../chunks/Heading.8ada512a.js";import{E as Ue}from"../chunks/getInferenceSnippets.22f21b45.js";function ge(Rt){let y,st,tt,lt,g,nt,T,At="Pour créer des applications avec LangGraph, vous devez comprendre ses composants principaux. Explorons les blocs fondamentaux qui constituent une application LangGraph.",at,U,Qt,it,f,Ft="Une application dans LangGraph commence à partir d’un <strong>point d’entrée</strong>, et selon l’exécution, le flux peut aller vers une fonction ou une autre jusqu’à ce qu’il atteigne la FIN.",pt,J,Nt,rt,j,ot,w,Xt="L’<strong>état</strong> est le concept central dans LangGraph. Il représente toutes les informations qui circulent à travers votre application.",ut,G,Mt,$,zt="L’état est <strong>défini par l’utilisateur</strong>, donc les champs doivent être soigneusement conçus pour contenir toutes les données nécessaires au processus de prise de décision !",mt,C,Wt="<p>💡 <strong>Astuce :</strong> Réfléchissez soigneusement aux informations que votre application doit suivre entre les étapes.</p>",dt,I,ct,b,Yt="Les <strong>nœuds</strong> sont des fonctions Python. Chaque nœud :",yt,_,Kt="<li>Prend l’état en entrée</li> <li>Effectue une opération</li> <li>Retourne des mises à jour de l’état</li>",ht,v,Ut,k,Pt="Par exemple, les nœuds peuvent contenir :",gt,B,Dt="<li><strong>Appels de LLM</strong> : Générer du texte ou prendre des décisions</li> <li><strong>Appels d’outils</strong> : Interagir avec des systèmes externes</li> <li><strong>Logique conditionnelle</strong> : Déterminer les prochaines étapes</li> <li><strong>Intervention humaine</strong> : Obtenir des contributions des utilisateurs</li>",Tt,Z,Ot="<p>💡 <strong>Info :</strong> Certains nœuds nécessaires pour l’ensemble du <em>workflow</em> comme <em>START</em> et <em>END</em> existent directement dans <em>LangGraph</em>.</p>",ft,S,Jt,x,te="Les <strong>arêtes</strong> connectent les nœuds et définissent les chemins possibles à travers votre graphe :",jt,L,wt,E,ee="Les arêtes peuvent être :",Gt,V,se="<li><strong>Directes</strong> : Toujours aller du nœud A au nœud B</li> <li><strong>Conditionnelles</strong> : Choisir le prochain nœud basé sur l’état actuel</li>",$t,q,Ct,H,le="Le <strong>StateGraph</strong> est le conteneur qui détient l’ensemble du <em>workflow</em> de votre agent :",It,R,bt,A,ne="Qui peut ensuite être visualisé !",_t,Q,vt,F,ae,kt,N,ie="Mais plus important encore, l’invocation :",Bt,X,Zt,z,pe="ressort :",St,W,xt,Y,Lt,K,re="Dans la prochaine section, nous mettrons ces concepts en pratique en construisant notre premier graphe. Ce graphe permet à Alfred de prendre vos emails, les classifier, et rédiger une réponse préliminaire s’ils sont authentiques.",Et,P,Vt,et,qt;return g=new O({props:{title:"Les composants de base de LangGraph",local:"les-composants-de-base-de-langgraph",headingTag:"h1"}}),j=new O({props:{title:"1. État",local:"1-état",headingTag:"h2"}}),G=new D({props:{code:"ZnJvbSUyMHR5cGluZ19leHRlbnNpb25zJTIwaW1wb3J0JTIwVHlwZWREaWN0JTBBJTBBY2xhc3MlMjBTdGF0ZShUeXBlZERpY3QpJTNBJTBBJTIwJTIwJTIwJTIwZ3JhcGhfc3RhdGUlM0ElMjBzdHI=",highlighted:`<span class="hljs-keyword">from</span> typing_extensions <span class="hljs-keyword">import</span> TypedDict

<span class="hljs-keyword">class</span> <span class="hljs-title class_">State</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    graph_state: <span class="hljs-built_in">str</span>`,wrap:!1}}),I=new O({props:{title:"2. Nœuds",local:"2-nœuds",headingTag:"h2"}}),v=new D({props:{code:"ZGVmJTIwbm9kZV8xKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAxLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwSSUyMGFtJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8yKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAyLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwaGFwcHkhJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8zKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAzLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwc2FkISUyMiU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_1</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 1---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; I am&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_2</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 2---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; happy!&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_3</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 3---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; sad!&quot;</span>}`,wrap:!1}}),S=new O({props:{title:"3. Arêtes",local:"3-arêtes",headingTag:"h2"}}),L=new D({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpdGVyYWwlMEElMEFkZWYlMjBkZWNpZGVfbW9vZChzdGF0ZSklMjAtJTNFJTIwTGl0ZXJhbCU1QiUyMm5vZGVfMiUyMiUyQyUyMCUyMm5vZGVfMyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFNvdXZlbnQlMkMlMjBub3VzJTIwdXRpbGlzZXJvbnMlMjBsJyVDMyVBOXRhdCUyMHBvdXIlMjBkJUMzJUE5Y2lkZXIlMjBkdSUyMHByb2NoYWluJTIwbiVDNSU5M3VkJTIwJUMzJUEwJTIwdmlzaXRlciUwQSUyMCUyMCUyMCUyMHVzZXJfaW5wdXQlMjAlM0QlMjBzdGF0ZSU1QidncmFwaF9zdGF0ZSclNUQlMjAlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBJY2klMkMlMjBmYWlzb25zJTIwanVzdGUlMjB1bmUlMjByJUMzJUE5cGFydGl0aW9uJTIwNTAlMkY1MCUyMGVudHJlJTIwbGVzJTIwbiVDNSU5M3VkcyUyMDIlMkMlMjAzJTBBJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZG9tKCklMjAlM0MlMjAwLjUlM0ElMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjA1MCUyNSUyMGR1JTIwdGVtcHMlMkMlMjBub3VzJTIwcmV0b3Vybm9ucyUyME5vZGUlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybm9kZV8yJTIyJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwNTAlMjUlMjBkdSUyMHRlbXBzJTJDJTIwbm91cyUyMHJldG91cm5vbnMlMjBOb2RlJTIwMyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCUyMm5vZGVfMyUyMg==",highlighted:`<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Literal</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decide_mood</span>(<span class="hljs-params">state</span>) -&gt; <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;node_2&quot;</span>, <span class="hljs-string">&quot;node_3&quot;</span>]:
    
    <span class="hljs-comment"># Souvent, nous utiliserons l&#x27;état pour décider du prochain nœud à visiter</span>
    user_input = state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] 
    
    <span class="hljs-comment"># Ici, faisons juste une répartition 50/50 entre les nœuds 2, 3</span>
    <span class="hljs-keyword">if</span> random.random() &lt; <span class="hljs-number">0.5</span>:

        <span class="hljs-comment"># 50% du temps, nous retournons Node 2</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_2&quot;</span>
    
    <span class="hljs-comment"># 50% du temps, nous retournons Node 3</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_3&quot;</span>`,wrap:!1}}),q=new O({props:{title:"4. StateGraph",local:"4-stategraph",headingTag:"h2"}}),R=new D({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEltYWdlJTJDJTIwZGlzcGxheSUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwU1RBUlQlMkMlMjBFTkQlMEElMEElMjMlMjBDb25zdHJ1aXJlJTIwbGUlMjBncmFwaGUlMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChTdGF0ZSklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMSUyMiUyQyUyMG5vZGVfMSklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMiUyMiUyQyUyMG5vZGVfMiklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMyUyMiUyQyUyMG5vZGVfMyklMEElMEElMjMlMjBMb2dpcXVlJTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMm5vZGVfMSUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMjJub2RlXzElMjIlMkMlMjBkZWNpZGVfbW9vZCklMEFidWlsZGVyLmFkZF9lZGdlKCUyMm5vZGVfMiUyMiUyQyUyMEVORCklMEFidWlsZGVyLmFkZF9lZGdlKCUyMm5vZGVfMyUyMiUyQyUyMEVORCklMEElMEElMjMlMjBBam91dGVyJTBBZ3JhcGglMjAlM0QlMjBidWlsZGVyLmNvbXBpbGUoKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, START, END

<span class="hljs-comment"># Construire le graphe</span>
builder = StateGraph(State)
builder.add_node(<span class="hljs-string">&quot;node_1&quot;</span>, node_1)
builder.add_node(<span class="hljs-string">&quot;node_2&quot;</span>, node_2)
builder.add_node(<span class="hljs-string">&quot;node_3&quot;</span>, node_3)

<span class="hljs-comment"># Logique</span>
builder.add_edge(START, <span class="hljs-string">&quot;node_1&quot;</span>)
builder.add_conditional_edges(<span class="hljs-string">&quot;node_1&quot;</span>, decide_mood)
builder.add_edge(<span class="hljs-string">&quot;node_2&quot;</span>, END)
builder.add_edge(<span class="hljs-string">&quot;node_3&quot;</span>, END)

<span class="hljs-comment"># Ajouter</span>
graph = builder.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),Q=new D({props:{code:"JTIzJTIwVmlzdWFsaXNlciUwQWRpc3BsYXkoSW1hZ2UoZ3JhcGguZ2V0X2dyYXBoKCkuZHJhd19tZXJtYWlkX3BuZygpKSk=",highlighted:`<span class="hljs-comment"># Visualiser</span>
display(Image(graph.get_graph().draw_mermaid_png()))`,wrap:!1}}),X=new D({props:{code:"Z3JhcGguaW52b2tlKCU3QiUyMmdyYXBoX3N0YXRlJTIyJTIwJTNBJTIwJTIySGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjIlN0Qp",highlighted:'graph.invoke({<span class="hljs-string">&quot;graph_state&quot;</span> : <span class="hljs-string">&quot;Hi, this is Lance.&quot;</span>})',wrap:!1}}),W=new D({props:{code:"LS0tTm9kZSUyMDEtLS0lMEEtLS1Ob2RlJTIwMy0tLSUwQSU3QidncmFwaF9zdGF0ZSclM0ElMjAnSGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjBJJTIwYW0lMjBzYWQhJyU3RA==",highlighted:`---<span class="hljs-keyword">Node</span> <span class="hljs-title">1---</span>
---<span class="hljs-keyword">Node</span> <span class="hljs-title">3---</span>
{&#x27;graph_state&#x27;: &#x27;Hi, this is Lance. I am sad!&#x27;}`,wrap:!1}}),Y=new O({props:{title:"Et maintenant ?",local:"et-maintenant-",headingTag:"h2"}}),P=new Ue({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/langgraph/building_blocks.mdx"}}),{c(){y=i("meta"),st=n(),tt=i("p"),lt=n(),o(g.$$.fragment),nt=n(),T=i("p"),T.textContent=At,at=n(),U=i("img"),it=n(),f=i("p"),f.innerHTML=Ft,pt=n(),J=i("img"),rt=n(),o(j.$$.fragment),ot=n(),w=i("p"),w.innerHTML=Xt,ut=n(),o(G.$$.fragment),Mt=n(),$=i("p"),$.innerHTML=zt,mt=n(),C=i("blockquote"),C.innerHTML=Wt,dt=n(),o(I.$$.fragment),ct=n(),b=i("p"),b.innerHTML=Yt,yt=n(),_=i("ul"),_.innerHTML=Kt,ht=n(),o(v.$$.fragment),Ut=n(),k=i("p"),k.textContent=Pt,gt=n(),B=i("ul"),B.innerHTML=Dt,Tt=n(),Z=i("blockquote"),Z.innerHTML=Ot,ft=n(),o(S.$$.fragment),Jt=n(),x=i("p"),x.innerHTML=te,jt=n(),o(L.$$.fragment),wt=n(),E=i("p"),E.textContent=ee,Gt=n(),V=i("ul"),V.innerHTML=se,$t=n(),o(q.$$.fragment),Ct=n(),H=i("p"),H.innerHTML=le,It=n(),o(R.$$.fragment),bt=n(),A=i("p"),A.textContent=ne,_t=n(),o(Q.$$.fragment),vt=n(),F=i("img"),kt=n(),N=i("p"),N.textContent=ie,Bt=n(),o(X.$$.fragment),Zt=n(),z=i("p"),z.textContent=pe,St=n(),o(W.$$.fragment),xt=n(),o(Y.$$.fragment),Lt=n(),K=i("p"),K.textContent=re,Et=n(),o(P.$$.fragment),Vt=n(),et=i("p"),this.h()},l(t){const e=ye("svelte-u9bgzb",document.head);y=p(e,"META",{name:!0,content:!0}),e.forEach(s),st=a(t),tt=p(t,"P",{}),oe(tt).forEach(s),lt=a(t),u(g.$$.fragment,t),nt=a(t),T=p(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-18x2c8u"&&(T.textContent=At),at=a(t),U=p(t,"IMG",{src:!0,alt:!0,width:!0}),it=a(t),f=p(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-zhtr0u"&&(f.innerHTML=Ft),pt=a(t),J=p(t,"IMG",{src:!0,alt:!0}),rt=a(t),u(j.$$.fragment,t),ot=a(t),w=p(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1bnapx2"&&(w.innerHTML=Xt),ut=a(t),u(G.$$.fragment,t),Mt=a(t),$=p(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1wufid7"&&($.innerHTML=zt),mt=a(t),C=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(C)!=="svelte-awafok"&&(C.innerHTML=Wt),dt=a(t),u(I.$$.fragment,t),ct=a(t),b=p(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-pinv1k"&&(b.innerHTML=Yt),yt=a(t),_=p(t,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-1f7e4tg"&&(_.innerHTML=Kt),ht=a(t),u(v.$$.fragment,t),Ut=a(t),k=p(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-idcot5"&&(k.textContent=Pt),gt=a(t),B=p(t,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-15s4yix"&&(B.innerHTML=Dt),Tt=a(t),Z=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Z)!=="svelte-1is4zni"&&(Z.innerHTML=Ot),ft=a(t),u(S.$$.fragment,t),Jt=a(t),x=p(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-rsvnlm"&&(x.innerHTML=te),jt=a(t),u(L.$$.fragment,t),wt=a(t),E=p(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-e31ekt"&&(E.textContent=ee),Gt=a(t),V=p(t,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-8qlrxe"&&(V.innerHTML=se),$t=a(t),u(q.$$.fragment,t),Ct=a(t),H=p(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-u4ohlg"&&(H.innerHTML=le),It=a(t),u(R.$$.fragment,t),bt=a(t),A=p(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1gx08rj"&&(A.textContent=ne),_t=a(t),u(Q.$$.fragment,t),vt=a(t),F=p(t,"IMG",{src:!0,alt:!0}),kt=a(t),N=p(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1wsm38p"&&(N.textContent=ie),Bt=a(t),u(X.$$.fragment,t),Zt=a(t),z=p(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1sclt0g"&&(z.textContent=pe),St=a(t),u(W.$$.fragment,t),xt=a(t),u(Y.$$.fragment,t),Lt=a(t),K=p(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-z0kfq8"&&(K.textContent=re),Et=a(t),u(P.$$.fragment,t),Vt=a(t),et=p(t,"P",{}),oe(et).forEach(s),this.h()},h(){h(y,"name","hf:doc:metadata"),h(y,"content",Te),Ht(U.src,Qt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Building_blocks.png")||h(U,"src",Qt),h(U,"alt","Building Blocks"),h(U,"width","70%"),Ht(J.src,Nt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/application.png")||h(J,"src",Nt),h(J,"alt","Application"),Ht(F.src,ae="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/basic_graph.jpeg")||h(F,"src",ae),h(F,"alt","Graph Visualization")},m(t,e){he(document.head,y),l(t,st,e),l(t,tt,e),l(t,lt,e),M(g,t,e),l(t,nt,e),l(t,T,e),l(t,at,e),l(t,U,e),l(t,it,e),l(t,f,e),l(t,pt,e),l(t,J,e),l(t,rt,e),M(j,t,e),l(t,ot,e),l(t,w,e),l(t,ut,e),M(G,t,e),l(t,Mt,e),l(t,$,e),l(t,mt,e),l(t,C,e),l(t,dt,e),M(I,t,e),l(t,ct,e),l(t,b,e),l(t,yt,e),l(t,_,e),l(t,ht,e),M(v,t,e),l(t,Ut,e),l(t,k,e),l(t,gt,e),l(t,B,e),l(t,Tt,e),l(t,Z,e),l(t,ft,e),M(S,t,e),l(t,Jt,e),l(t,x,e),l(t,jt,e),M(L,t,e),l(t,wt,e),l(t,E,e),l(t,Gt,e),l(t,V,e),l(t,$t,e),M(q,t,e),l(t,Ct,e),l(t,H,e),l(t,It,e),M(R,t,e),l(t,bt,e),l(t,A,e),l(t,_t,e),M(Q,t,e),l(t,vt,e),l(t,F,e),l(t,kt,e),l(t,N,e),l(t,Bt,e),M(X,t,e),l(t,Zt,e),l(t,z,e),l(t,St,e),M(W,t,e),l(t,xt,e),M(Y,t,e),l(t,Lt,e),l(t,K,e),l(t,Et,e),M(P,t,e),l(t,Vt,e),l(t,et,e),qt=!0},p:Me,i(t){qt||(m(g.$$.fragment,t),m(j.$$.fragment,t),m(G.$$.fragment,t),m(I.$$.fragment,t),m(v.$$.fragment,t),m(S.$$.fragment,t),m(L.$$.fragment,t),m(q.$$.fragment,t),m(R.$$.fragment,t),m(Q.$$.fragment,t),m(X.$$.fragment,t),m(W.$$.fragment,t),m(Y.$$.fragment,t),m(P.$$.fragment,t),qt=!0)},o(t){d(g.$$.fragment,t),d(j.$$.fragment,t),d(G.$$.fragment,t),d(I.$$.fragment,t),d(v.$$.fragment,t),d(S.$$.fragment,t),d(L.$$.fragment,t),d(q.$$.fragment,t),d(R.$$.fragment,t),d(Q.$$.fragment,t),d(X.$$.fragment,t),d(W.$$.fragment,t),d(Y.$$.fragment,t),d(P.$$.fragment,t),qt=!1},d(t){t&&(s(st),s(tt),s(lt),s(nt),s(T),s(at),s(U),s(it),s(f),s(pt),s(J),s(rt),s(ot),s(w),s(ut),s(Mt),s($),s(mt),s(C),s(dt),s(ct),s(b),s(yt),s(_),s(ht),s(Ut),s(k),s(gt),s(B),s(Tt),s(Z),s(ft),s(Jt),s(x),s(jt),s(wt),s(E),s(Gt),s(V),s($t),s(Ct),s(H),s(It),s(bt),s(A),s(_t),s(vt),s(F),s(kt),s(N),s(Bt),s(Zt),s(z),s(St),s(xt),s(Lt),s(K),s(Et),s(Vt),s(et)),s(y),c(g,t),c(j,t),c(G,t),c(I,t),c(v,t),c(S,t),c(L,t),c(q,t),c(R,t),c(Q,t),c(X,t),c(W,t),c(Y,t),c(P,t)}}}const Te='{"title":"Les composants de base de LangGraph","local":"les-composants-de-base-de-langgraph","sections":[{"title":"1. État","local":"1-état","sections":[],"depth":2},{"title":"2. Nœuds","local":"2-nœuds","sections":[],"depth":2},{"title":"3. Arêtes","local":"3-arêtes","sections":[],"depth":2},{"title":"4. StateGraph","local":"4-stategraph","sections":[],"depth":2},{"title":"Et maintenant ?","local":"et-maintenant-","sections":[],"depth":2}],"depth":1}';function fe(Rt){return me(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ce extends de{constructor(y){super(),ce(this,y,fe,ge,ue,{})}}export{Ce as component};
