import{s as Ns,f as _l,n as Ps,o as Fs}from"../chunks/scheduler.37c15a92.js";import{S as Ds,i as Ks,g as a,s as n,r as p,A as Os,h as o,f as l,c as i,j as Gl,u as r,x as M,k as c,y as Ll,a as s,v as u,d as y,t as w,w as T}from"../chunks/index.2bf4358c.js";import{C as J}from"../chunks/CodeBlock.4e987730.js";import{H as Xt}from"../chunks/Heading.8ada512a.js";import{E as tn}from"../chunks/getInferenceSnippets.22f21b45.js";function en($l){let m,Dt,Pt,Kt,h,Ot,U,kl,te,d,El="One crucial aspect of AI Agents is their ability to take <strong>actions</strong>. As we saw, this happens through the use of <strong>Tools</strong>.",ee,I,Wl="In this section, we’ll learn what Tools are, how to design them effectively, and how to integrate them into your Agent via the System Message.",le,C,Zl="By giving your Agent the right Tools—and clearly describing how those Tools work—you can dramatically increase what your AI can accomplish. Let’s dive in!",se,f,ne,b,Rl="A <strong>Tool is a function given to the LLM</strong>. This function should fulfill a <strong>clear objective</strong>.",ie,A,Sl="Here are some commonly used tools in AI agents:",ae,v,Ql="<thead><tr><th>Tool</th> <th>Description</th></tr></thead> <tbody><tr><td>Web Search</td> <td>Allows the agent to fetch up-to-date information from the internet.</td></tr> <tr><td>Image Generation</td> <td>Creates images based on text descriptions.</td></tr> <tr><td>Retrieval</td> <td>Retrieves information from an external source.</td></tr> <tr><td>API Interface</td> <td>Interacts with an external API (GitHub, YouTube, Spotify, etc.).</td></tr></tbody>",oe,g,Yl="Those are only examples, as you can in fact create a tool for any use case!",Me,x,Vl="A good tool should be something that <strong>complements the power of an LLM</strong>.",pe,B,zl="For instance, if you need to perform arithmetic, giving a <strong>calculator tool</strong> to your LLM will provide better results than relying on the native capabilities of the model.",re,_,ql="Furthermore, <strong>LLMs predict the completion of a prompt based on their training data</strong>, which means that their internal knowledge only includes events prior to their training. Therefore, if your agent needs up-to-date data you must provide it through some tool.",ue,H,Xl="For instance, if you ask an LLM directly (without a search tool) for today’s weather, the LLM will potentially hallucinate random weather.",ye,G,Nl,we,L,Pl="<li><p>A Tool should contain:</p> <ul><li>A <strong>textual description of what the function does</strong>.</li> <li>A <em>Callable</em> (something to perform an action).</li> <li><em>Arguments</em> with typings.</li> <li>(Optional) Outputs with typings.</li></ul></li>",Te,$,ce,k,Fl="LLMs, as we saw, can only receive text inputs and generate text outputs. They have no way to call tools on their own. When we talk about providing tools to an Agent, we mean teaching the LLM about the existence of these tools and instructing it to generate text-based invocations when needed.",me,E,Dl="For example, if we provide a tool to check the weather at a location from the internet and then ask the LLM about the weather in Paris, the LLM will recognize that this is an opportunity to use the “weather” tool. Instead of retrieving the weather data itself, the LLM will generate text that represents a tool call, such as call weather_tool(‘Paris’).",Je,W,Kl="The <strong>Agent</strong> then reads this response, identifies that a tool call is required, executes the tool on the LLM’s behalf, and retrieves the actual weather data.",je,Z,Ol="The Tool-calling steps are typically not shown to the user: the Agent appends them as a new message before passing the updated conversation to the LLM again. The LLM then processes this additional context and generates a natural-sounding response for the user. From the user’s perspective, it appears as if the LLM directly interacted with the tool, but in reality, it was the Agent that handled the entire execution process in the background.",he,R,ts="We’ll talk a lot more about this process in future sessions.",Ue,S,de,Q,es="The complete answer may seem overwhelming, but we essentially use the system prompt to provide textual descriptions of available tools to the model:",Ie,Y,ls,Ce,V,ss="For this to work, we have to be very precise and accurate about:",fe,z,ns="<li><strong>What the tool does</strong></li> <li><strong>What exact inputs it expects</strong></li>",be,q,is="This is the reason why tool descriptions are usually provided using expressive but precise structures, such as computer languages or JSON. It’s not <em>necessary</em> to do it like that, any precise and coherent format would work.",Ae,X,as="If this seems too theoretical, let’s understand it through a concrete example.",ve,N,os="We will implement a simplified <strong>calculator</strong> tool that will just multiply two integers. This could be our Python implementation:",ge,P,xe,F,Ms="So our tool is called <code>calculator</code>, it <strong>multiplies two integers</strong>, and it requires the following inputs:",Be,D,ps="<li><strong><code>a</code></strong> (<em>int</em>): An integer.</li> <li><strong><code>b</code></strong> (<em>int</em>): An integer.</li>",_e,K,rs="The output of the tool is another integer number that we can describe like this:",He,O,us="<li>(<em>int</em>): The product of <code>a</code> and <code>b</code>.</li>",Ge,tt,ys="All of these details are important. Let’s put them together in a text string that describes our tool for the LLM to understand.",Le,et,$e,lt,ws="<p><strong>Reminder:</strong> This textual description is <em>what we want the LLM to know about the tool</em>.</p>",ke,st,Ts="When we pass the previous string as part of the input to the LLM, the model will recognize it as a tool, and will know what it needs to pass as inputs and what to expect from the output.",Ee,nt,cs="If we want to provide additional tools, we must be consistent and always use the same format. This process can be fragile, and we might accidentally overlook some details.",We,it,ms="Is there a better way?",Ze,at,Re,ot,Js="Our tool was written in Python, and the implementation already provides everything we need:",Se,Mt,js="<li>A descriptive name of what it does: <code>calculator</code></li> <li>A longer description, provided by the function’s docstring comment: <code>Multiply two integers.</code></li> <li>The inputs and their type: the function clearly expects two <code>int</code>s.</li> <li>The type of the output.</li>",Qe,pt,hs="There’s a reason people use programming languages: they are expressive, concise, and precise.",Ye,rt,Us="We could provide the Python source code as the <em>specification</em> of the tool for the LLM, but the way the tool is implemented does not matter. All that matters is its name, what it does, the inputs it expects and the output it provides.",Ve,ut,ds="We will leverage Python’s introspection features to leverage the source code and build a tool description automatically for us. All we need is that the tool implementation uses type hints, docstrings, and sensible function names. We will write some code to extract the relevant portions from the source code.",ze,yt,Is="After we are done, we’ll only need to use a Python decorator to indicate that the <code>calculator</code> function is a tool:",qe,wt,Xe,Tt,Cs="Note the <code>@tool</code> decorator before the function definition.",Ne,ct,fs="With the implementation we’ll see next, we will be able to retrieve the following text automatically from the source code via the <code>to_string()</code> function provided by the decorator:",Pe,mt,Fe,Jt,bs="As you can see, it’s the same thing we wrote manually before!",De,jt,Ke,ht,As="We create a generic <code>Tool</code> class that we can reuse whenever we need to use a tool.",Oe,Ut,vs="<p><strong>Disclaimer:</strong> This example implementation is fictional but closely resembles real implementations in most libraries.</p>",tl,dt,el,It,gs="It may seem complicated, but if we go slowly through it we can see what it does. We define a <strong><code>Tool</code></strong> class that includes:",ll,Ct,xs="<li><strong><code>name</code></strong> (<em>str</em>): The name of the tool.</li> <li><strong><code>description</code></strong> (<em>str</em>): A brief description of what the tool does.</li> <li><strong><code>function</code></strong> (<em>callable</em>): The function the tool executes.</li> <li><strong><code>arguments</code></strong> (<em>list</em>): The expected input parameters.</li> <li><strong><code>outputs</code></strong> (<em>str</em> or <em>list</em>): The expected outputs of the tool.</li> <li><strong><code>__call__()</code></strong>: Calls the function when the tool instance is invoked.</li> <li><strong><code>to_string()</code></strong>: Converts the tool’s attributes into a textual representation.</li>",sl,ft,Bs="We could create a Tool with this class using code like the following:",nl,bt,il,At,_s="But we can also use Python’s <code>inspect</code> module to retrieve all the information for us! This is what the <code>@tool</code> decorator does.",al,vt,Hs="<p>If you are interested, you can disclose the following section to look at the decorator implementation.</p>",ol,j,Nt,Gs="decorator code",Hl,gt,Ml,xt,Ls="Just to reiterate, with this decorator in place we can implement our tool like this:",pl,Bt,rl,_t,$s="And we can use the <code>Tool</code>’s <code>to_string</code> method to automatically retrieve a text suitable to be used as a tool description for an LLM:",ul,Ht,yl,Gt,ks="The description is <strong>injected</strong> in the system prompt. Taking the example with which we started this section, here is how it would look like after replacing the <code>tools_description</code>:",wl,Lt,Es,Tl,$t,Ws='In the <a href="actions">Actions</a> section, we will learn more about how an Agent can <strong>Call</strong> this tool we just created.',cl,kt,ml,Et,Zs=`Model Context Protocol (MCP) is an <strong>open protocol</strong> that standardizes how applications <strong>provide tools to LLMs</strong>.
MCP provides:`,Jl,Wt,Rs="<li>A growing list of pre-built integrations that your LLM can directly plug into</li> <li>The flexibility to switch between LLM providers and vendors</li> <li>Best practices for securing your data within your infrastructure</li>",jl,Zt,Ss="This means that <strong>any framework implementing MCP can leverage tools defined within the protocol</strong>, eliminating the need to reimplement the same tool interface for each framework.",hl,Rt,Qs='If you want to dive deeper about MCP, you can check our <a href="https://huggingface.co/learn/mcp-course/" rel="nofollow">free MCP Course</a>.',Ul,dl,Il,St,Ys="Tools play a crucial role in enhancing the capabilities of AI agents.",Cl,Qt,Vs="To summarize, we learned:",fl,Yt,zs="<li><p><em>What Tools Are</em>: Functions that give LLMs extra capabilities, such as performing calculations or accessing external data.</p></li> <li><p><em>How to Define a Tool</em>: By providing a clear textual description, inputs, outputs, and a callable function.</p></li> <li><p><em>Why Tools Are Essential</em>: They enable Agents to overcome the limitations of static model training, handle real-time tasks, and perform specialized actions.</p></li>",bl,Vt,qs='Now, we can move on to the <a href="agent-steps-and-structure">Agent Workflow</a> where you’ll see how an Agent observes, thinks, and acts. This <strong>brings together everything we’ve covered so far</strong> and sets the stage for creating your own fully functional AI Agent.',Al,zt,Xs="But first, it’s time for another short quiz!",vl,qt,gl,Ft,xl;return h=new Xt({props:{title:"What are Tools?",local:"what-are-tools",headingTag:"h1"}}),f=new Xt({props:{title:"What are AI Tools?",local:"what-are-ai-tools",headingTag:"h2"}}),$=new Xt({props:{title:"How do tools work?",local:"how-do-tools-work",headingTag:"h2"}}),S=new Xt({props:{title:"How do we give tools to an LLM?",local:"how-do-we-give-tools-to-an-llm",headingTag:"h2"}}),P=new J({props:{code:"ZGVmJTIwY2FsY3VsYXRvcihhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTXVsdGlwbHklMjB0d28lMjBpbnRlZ2Vycy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwKiUyMGI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b`,wrap:!1}}),et=new J({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),at=new Xt({props:{title:"Auto-formatting Tool sections",local:"auto-formatting-tool-sections",headingTag:"h3"}}),wt=new J({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),mt=new J({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),jt=new Xt({props:{title:"Generic Tool implementation",local:"generic-tool-implementation",headingTag:"h3"}}),dt=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Callable</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    A class representing a reusable piece of code (Tool).

    Attributes:
        name (str): Name of the tool.
        description (str): A textual description of what the tool does.
        func (callable): The function this tool wraps.
        arguments (list): A list of arguments.
        outputs (str or list): The return type(s) of the wrapped function.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self,
                 name: <span class="hljs-built_in">str</span>,
                 description: <span class="hljs-built_in">str</span>,
                 func: <span class="hljs-type">Callable</span>,
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return a string representation of the tool,
        including its name, description, arguments, and outputs.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])

        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Tool Name: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Description: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Arguments: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Outputs: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoke the underlying function (callable) with provided arguments.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),bt=new J({props:{code:"Y2FsY3VsYXRvcl90b29sJTIwJTNEJTIwVG9vbCglMEElMjAlMjAlMjAlMjAlMjJjYWxjdWxhdG9yJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbmFtZSUwQSUyMCUyMCUyMCUyMCUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVzY3JpcHRpb24lMEElMjAlMjAlMjAlMjBjYWxjdWxhdG9yJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZnVuY3Rpb24lMjB0byUyMGNhbGwlMEElMjAlMjAlMjAlMjAlNUIoJTIyYSUyMiUyQyUyMCUyMmludCUyMiklMkMlMjAoJTIyYiUyMiUyQyUyMCUyMmludCUyMiklNUQlMkMlMjAlMjAlMjAlMjMlMjBpbnB1dHMlMjAobmFtZXMlMjBhbmQlMjB0eXBlcyklMEElMjAlMjAlMjAlMjAlMjJpbnQlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBvdXRwdXQlMEEp",highlighted:`calculator_tool = Tool(
    <span class="hljs-string">&quot;calculator&quot;</span>,                   <span class="hljs-comment"># name</span>
    <span class="hljs-string">&quot;Multiply two integers.&quot;</span>,       <span class="hljs-comment"># description</span>
    calculator,                     <span class="hljs-comment"># function to call</span>
    [(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># inputs (names and types)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># output</span>
)`,wrap:!1}}),gt=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> inspect

<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A decorator that creates a Tool instance from the given function.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Get the function signature</span>
    signature = inspect.signature(func)

    <span class="hljs-comment"># Extract (param_name, param_annotation) pairs for inputs</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>)
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))

    <span class="hljs-comment"># Determine the return annotation</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;No return annotation&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>)
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )

    <span class="hljs-comment"># Use the function&#x27;s docstring as the description (default if None)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No description provided.&quot;</span>

    <span class="hljs-comment"># The function name becomes the Tool name</span>
    name = func.__name__

    <span class="hljs-comment"># Return a new Tool instance</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name,
        description=description,
        func=func,
        arguments=arguments,
        outputs=outputs
    )`,wrap:!1}}),Bt=new J({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),Ht=new J({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),kt=new Xt({props:{title:"Model Context Protocol (MCP): a unified tool interface",local:"model-context-protocol-mcp-a-unified-tool-interface",headingTag:"h3"}}),qt=new tn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tools.mdx"}}),{c(){m=a("meta"),Dt=n(),Pt=a("p"),Kt=n(),p(h.$$.fragment),Ot=n(),U=a("img"),te=n(),d=a("p"),d.innerHTML=El,ee=n(),I=a("p"),I.textContent=Wl,le=n(),C=a("p"),C.textContent=Zl,se=n(),p(f.$$.fragment),ne=n(),b=a("p"),b.innerHTML=Rl,ie=n(),A=a("p"),A.textContent=Sl,ae=n(),v=a("table"),v.innerHTML=Ql,oe=n(),g=a("p"),g.textContent=Yl,Me=n(),x=a("p"),x.innerHTML=Vl,pe=n(),B=a("p"),B.innerHTML=zl,re=n(),_=a("p"),_.innerHTML=ql,ue=n(),H=a("p"),H.textContent=Xl,ye=n(),G=a("img"),we=n(),L=a("ul"),L.innerHTML=Pl,Te=n(),p($.$$.fragment),ce=n(),k=a("p"),k.textContent=Fl,me=n(),E=a("p"),E.textContent=Dl,Je=n(),W=a("p"),W.innerHTML=Kl,je=n(),Z=a("p"),Z.textContent=Ol,he=n(),R=a("p"),R.textContent=ts,Ue=n(),p(S.$$.fragment),de=n(),Q=a("p"),Q.textContent=es,Ie=n(),Y=a("img"),Ce=n(),V=a("p"),V.textContent=ss,fe=n(),z=a("ol"),z.innerHTML=ns,be=n(),q=a("p"),q.innerHTML=is,Ae=n(),X=a("p"),X.textContent=as,ve=n(),N=a("p"),N.innerHTML=os,ge=n(),p(P.$$.fragment),xe=n(),F=a("p"),F.innerHTML=Ms,Be=n(),D=a("ul"),D.innerHTML=ps,_e=n(),K=a("p"),K.textContent=rs,He=n(),O=a("ul"),O.innerHTML=us,Ge=n(),tt=a("p"),tt.textContent=ys,Le=n(),p(et.$$.fragment),$e=n(),lt=a("blockquote"),lt.innerHTML=ws,ke=n(),st=a("p"),st.textContent=Ts,Ee=n(),nt=a("p"),nt.textContent=cs,We=n(),it=a("p"),it.textContent=ms,Ze=n(),p(at.$$.fragment),Re=n(),ot=a("p"),ot.textContent=Js,Se=n(),Mt=a("ul"),Mt.innerHTML=js,Qe=n(),pt=a("p"),pt.textContent=hs,Ye=n(),rt=a("p"),rt.innerHTML=Us,Ve=n(),ut=a("p"),ut.textContent=ds,ze=n(),yt=a("p"),yt.innerHTML=Is,qe=n(),p(wt.$$.fragment),Xe=n(),Tt=a("p"),Tt.innerHTML=Cs,Ne=n(),ct=a("p"),ct.innerHTML=fs,Pe=n(),p(mt.$$.fragment),Fe=n(),Jt=a("p"),Jt.textContent=bs,De=n(),p(jt.$$.fragment),Ke=n(),ht=a("p"),ht.innerHTML=As,Oe=n(),Ut=a("blockquote"),Ut.innerHTML=vs,tl=n(),p(dt.$$.fragment),el=n(),It=a("p"),It.innerHTML=gs,ll=n(),Ct=a("ul"),Ct.innerHTML=xs,sl=n(),ft=a("p"),ft.textContent=Bs,nl=n(),p(bt.$$.fragment),il=n(),At=a("p"),At.innerHTML=_s,al=n(),vt=a("blockquote"),vt.innerHTML=Hs,ol=n(),j=a("details"),Nt=a("summary"),Nt.textContent=Gs,Hl=n(),p(gt.$$.fragment),Ml=n(),xt=a("p"),xt.textContent=Ls,pl=n(),p(Bt.$$.fragment),rl=n(),_t=a("p"),_t.innerHTML=$s,ul=n(),p(Ht.$$.fragment),yl=n(),Gt=a("p"),Gt.innerHTML=ks,wl=n(),Lt=a("img"),Tl=n(),$t=a("p"),$t.innerHTML=Ws,cl=n(),p(kt.$$.fragment),ml=n(),Et=a("p"),Et.innerHTML=Zs,Jl=n(),Wt=a("ul"),Wt.innerHTML=Rs,jl=n(),Zt=a("p"),Zt.innerHTML=Ss,hl=n(),Rt=a("p"),Rt.innerHTML=Qs,Ul=n(),dl=a("hr"),Il=n(),St=a("p"),St.textContent=Ys,Cl=n(),Qt=a("p"),Qt.textContent=Vs,fl=n(),Yt=a("ul"),Yt.innerHTML=zs,bl=n(),Vt=a("p"),Vt.innerHTML=qs,Al=n(),zt=a("p"),zt.textContent=Xs,vl=n(),p(qt.$$.fragment),gl=n(),Ft=a("p"),this.h()},l(t){const e=Os("svelte-u9bgzb",document.head);m=o(e,"META",{name:!0,content:!0}),e.forEach(l),Dt=i(t),Pt=o(t,"P",{}),Gl(Pt).forEach(l),Kt=i(t),r(h.$$.fragment,t),Ot=i(t),U=o(t,"IMG",{src:!0,alt:!0}),te=i(t),d=o(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-12q0l6c"&&(d.innerHTML=El),ee=i(t),I=o(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-vccz0n"&&(I.textContent=Wl),le=i(t),C=o(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-g748wk"&&(C.textContent=Zl),se=i(t),r(f.$$.fragment,t),ne=i(t),b=o(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-d0memu"&&(b.innerHTML=Rl),ie=i(t),A=o(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1bnicmb"&&(A.textContent=Sl),ae=i(t),v=o(t,"TABLE",{"data-svelte-h":!0}),M(v)!=="svelte-1r7ovsn"&&(v.innerHTML=Ql),oe=i(t),g=o(t,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1fuccdy"&&(g.textContent=Yl),Me=i(t),x=o(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-178hc7g"&&(x.innerHTML=Vl),pe=i(t),B=o(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1redoxr"&&(B.innerHTML=zl),re=i(t),_=o(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1v1ck09"&&(_.innerHTML=ql),ue=i(t),H=o(t,"P",{"data-svelte-h":!0}),M(H)!=="svelte-mz2far"&&(H.textContent=Xl),ye=i(t),G=o(t,"IMG",{src:!0,alt:!0}),we=i(t),L=o(t,"UL",{"data-svelte-h":!0}),M(L)!=="svelte-gj3em1"&&(L.innerHTML=Pl),Te=i(t),r($.$$.fragment,t),ce=i(t),k=o(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-12sfw6d"&&(k.textContent=Fl),me=i(t),E=o(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-17ojdf7"&&(E.textContent=Dl),Je=i(t),W=o(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1ym7xfc"&&(W.innerHTML=Kl),je=i(t),Z=o(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-16cdakx"&&(Z.textContent=Ol),he=i(t),R=o(t,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1gym7on"&&(R.textContent=ts),Ue=i(t),r(S.$$.fragment,t),de=i(t),Q=o(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1m76tol"&&(Q.textContent=es),Ie=i(t),Y=o(t,"IMG",{src:!0,alt:!0}),Ce=i(t),V=o(t,"P",{"data-svelte-h":!0}),M(V)!=="svelte-e466s4"&&(V.textContent=ss),fe=i(t),z=o(t,"OL",{"data-svelte-h":!0}),M(z)!=="svelte-12vrnnv"&&(z.innerHTML=ns),be=i(t),q=o(t,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1lxlzbg"&&(q.innerHTML=is),Ae=i(t),X=o(t,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1p033lp"&&(X.textContent=as),ve=i(t),N=o(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1if40sb"&&(N.innerHTML=os),ge=i(t),r(P.$$.fragment,t),xe=i(t),F=o(t,"P",{"data-svelte-h":!0}),M(F)!=="svelte-somofk"&&(F.innerHTML=Ms),Be=i(t),D=o(t,"UL",{"data-svelte-h":!0}),M(D)!=="svelte-1qi2vj"&&(D.innerHTML=ps),_e=i(t),K=o(t,"P",{"data-svelte-h":!0}),M(K)!=="svelte-z90coj"&&(K.textContent=rs),He=i(t),O=o(t,"UL",{"data-svelte-h":!0}),M(O)!=="svelte-1rd1o27"&&(O.innerHTML=us),Ge=i(t),tt=o(t,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-1gl47rm"&&(tt.textContent=ys),Le=i(t),r(et.$$.fragment,t),$e=i(t),lt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(lt)!=="svelte-jn5onw"&&(lt.innerHTML=ws),ke=i(t),st=o(t,"P",{"data-svelte-h":!0}),M(st)!=="svelte-dd2uu2"&&(st.textContent=Ts),Ee=i(t),nt=o(t,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-1ec16zo"&&(nt.textContent=cs),We=i(t),it=o(t,"P",{"data-svelte-h":!0}),M(it)!=="svelte-xhigt1"&&(it.textContent=ms),Ze=i(t),r(at.$$.fragment,t),Re=i(t),ot=o(t,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-xwh6nk"&&(ot.textContent=Js),Se=i(t),Mt=o(t,"UL",{"data-svelte-h":!0}),M(Mt)!=="svelte-1mufwba"&&(Mt.innerHTML=js),Qe=i(t),pt=o(t,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-6ogn9l"&&(pt.textContent=hs),Ye=i(t),rt=o(t,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-2908e6"&&(rt.innerHTML=Us),Ve=i(t),ut=o(t,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-1nshzlk"&&(ut.textContent=ds),ze=i(t),yt=o(t,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-1iag2er"&&(yt.innerHTML=Is),qe=i(t),r(wt.$$.fragment,t),Xe=i(t),Tt=o(t,"P",{"data-svelte-h":!0}),M(Tt)!=="svelte-1xfdhk0"&&(Tt.innerHTML=Cs),Ne=i(t),ct=o(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-hj3bkt"&&(ct.innerHTML=fs),Pe=i(t),r(mt.$$.fragment,t),Fe=i(t),Jt=o(t,"P",{"data-svelte-h":!0}),M(Jt)!=="svelte-ah55dy"&&(Jt.textContent=bs),De=i(t),r(jt.$$.fragment,t),Ke=i(t),ht=o(t,"P",{"data-svelte-h":!0}),M(ht)!=="svelte-1g4lbet"&&(ht.innerHTML=As),Oe=i(t),Ut=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(Ut)!=="svelte-17jlnyo"&&(Ut.innerHTML=vs),tl=i(t),r(dt.$$.fragment,t),el=i(t),It=o(t,"P",{"data-svelte-h":!0}),M(It)!=="svelte-1m24zfs"&&(It.innerHTML=gs),ll=i(t),Ct=o(t,"UL",{"data-svelte-h":!0}),M(Ct)!=="svelte-1aoag7f"&&(Ct.innerHTML=xs),sl=i(t),ft=o(t,"P",{"data-svelte-h":!0}),M(ft)!=="svelte-9jg0w0"&&(ft.textContent=Bs),nl=i(t),r(bt.$$.fragment,t),il=i(t),At=o(t,"P",{"data-svelte-h":!0}),M(At)!=="svelte-imjo5d"&&(At.innerHTML=_s),al=i(t),vt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(vt)!=="svelte-5gslq7"&&(vt.innerHTML=Hs),ol=i(t),j=o(t,"DETAILS",{});var Bl=Gl(j);Nt=o(Bl,"SUMMARY",{"data-svelte-h":!0}),M(Nt)!=="svelte-14wmf42"&&(Nt.textContent=Gs),Hl=i(Bl),r(gt.$$.fragment,Bl),Bl.forEach(l),Ml=i(t),xt=o(t,"P",{"data-svelte-h":!0}),M(xt)!=="svelte-1pxgdsn"&&(xt.textContent=Ls),pl=i(t),r(Bt.$$.fragment,t),rl=i(t),_t=o(t,"P",{"data-svelte-h":!0}),M(_t)!=="svelte-oh725x"&&(_t.innerHTML=$s),ul=i(t),r(Ht.$$.fragment,t),yl=i(t),Gt=o(t,"P",{"data-svelte-h":!0}),M(Gt)!=="svelte-1gsasw4"&&(Gt.innerHTML=ks),wl=i(t),Lt=o(t,"IMG",{src:!0,alt:!0}),Tl=i(t),$t=o(t,"P",{"data-svelte-h":!0}),M($t)!=="svelte-14h2jbz"&&($t.innerHTML=Ws),cl=i(t),r(kt.$$.fragment,t),ml=i(t),Et=o(t,"P",{"data-svelte-h":!0}),M(Et)!=="svelte-123mz07"&&(Et.innerHTML=Zs),Jl=i(t),Wt=o(t,"UL",{"data-svelte-h":!0}),M(Wt)!=="svelte-jdb0o1"&&(Wt.innerHTML=Rs),jl=i(t),Zt=o(t,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-v0j64b"&&(Zt.innerHTML=Ss),hl=i(t),Rt=o(t,"P",{"data-svelte-h":!0}),M(Rt)!=="svelte-ki6njs"&&(Rt.innerHTML=Qs),Ul=i(t),dl=o(t,"HR",{}),Il=i(t),St=o(t,"P",{"data-svelte-h":!0}),M(St)!=="svelte-yaz9vn"&&(St.textContent=Ys),Cl=i(t),Qt=o(t,"P",{"data-svelte-h":!0}),M(Qt)!=="svelte-1mncb1b"&&(Qt.textContent=Vs),fl=i(t),Yt=o(t,"UL",{"data-svelte-h":!0}),M(Yt)!=="svelte-1lbaznq"&&(Yt.innerHTML=zs),bl=i(t),Vt=o(t,"P",{"data-svelte-h":!0}),M(Vt)!=="svelte-16mxhlc"&&(Vt.innerHTML=qs),Al=i(t),zt=o(t,"P",{"data-svelte-h":!0}),M(zt)!=="svelte-1w2njod"&&(zt.textContent=Xs),vl=i(t),r(qt.$$.fragment,t),gl=i(t),Ft=o(t,"P",{}),Gl(Ft).forEach(l),this.h()},h(){c(m,"name","hf:doc:metadata"),c(m,"content",ln),_l(U.src,kl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||c(U,"src",kl),c(U,"alt","Unit 1 planning"),_l(G.src,Nl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||c(G,"src",Nl),c(G,"alt","Weather"),_l(Y.src,ls="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||c(Y,"src",ls),c(Y,"alt","System prompt for tools"),_l(Lt.src,Es="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||c(Lt,"src",Es),c(Lt,"alt","System prompt for tools")},m(t,e){Ll(document.head,m),s(t,Dt,e),s(t,Pt,e),s(t,Kt,e),u(h,t,e),s(t,Ot,e),s(t,U,e),s(t,te,e),s(t,d,e),s(t,ee,e),s(t,I,e),s(t,le,e),s(t,C,e),s(t,se,e),u(f,t,e),s(t,ne,e),s(t,b,e),s(t,ie,e),s(t,A,e),s(t,ae,e),s(t,v,e),s(t,oe,e),s(t,g,e),s(t,Me,e),s(t,x,e),s(t,pe,e),s(t,B,e),s(t,re,e),s(t,_,e),s(t,ue,e),s(t,H,e),s(t,ye,e),s(t,G,e),s(t,we,e),s(t,L,e),s(t,Te,e),u($,t,e),s(t,ce,e),s(t,k,e),s(t,me,e),s(t,E,e),s(t,Je,e),s(t,W,e),s(t,je,e),s(t,Z,e),s(t,he,e),s(t,R,e),s(t,Ue,e),u(S,t,e),s(t,de,e),s(t,Q,e),s(t,Ie,e),s(t,Y,e),s(t,Ce,e),s(t,V,e),s(t,fe,e),s(t,z,e),s(t,be,e),s(t,q,e),s(t,Ae,e),s(t,X,e),s(t,ve,e),s(t,N,e),s(t,ge,e),u(P,t,e),s(t,xe,e),s(t,F,e),s(t,Be,e),s(t,D,e),s(t,_e,e),s(t,K,e),s(t,He,e),s(t,O,e),s(t,Ge,e),s(t,tt,e),s(t,Le,e),u(et,t,e),s(t,$e,e),s(t,lt,e),s(t,ke,e),s(t,st,e),s(t,Ee,e),s(t,nt,e),s(t,We,e),s(t,it,e),s(t,Ze,e),u(at,t,e),s(t,Re,e),s(t,ot,e),s(t,Se,e),s(t,Mt,e),s(t,Qe,e),s(t,pt,e),s(t,Ye,e),s(t,rt,e),s(t,Ve,e),s(t,ut,e),s(t,ze,e),s(t,yt,e),s(t,qe,e),u(wt,t,e),s(t,Xe,e),s(t,Tt,e),s(t,Ne,e),s(t,ct,e),s(t,Pe,e),u(mt,t,e),s(t,Fe,e),s(t,Jt,e),s(t,De,e),u(jt,t,e),s(t,Ke,e),s(t,ht,e),s(t,Oe,e),s(t,Ut,e),s(t,tl,e),u(dt,t,e),s(t,el,e),s(t,It,e),s(t,ll,e),s(t,Ct,e),s(t,sl,e),s(t,ft,e),s(t,nl,e),u(bt,t,e),s(t,il,e),s(t,At,e),s(t,al,e),s(t,vt,e),s(t,ol,e),s(t,j,e),Ll(j,Nt),Ll(j,Hl),u(gt,j,null),s(t,Ml,e),s(t,xt,e),s(t,pl,e),u(Bt,t,e),s(t,rl,e),s(t,_t,e),s(t,ul,e),u(Ht,t,e),s(t,yl,e),s(t,Gt,e),s(t,wl,e),s(t,Lt,e),s(t,Tl,e),s(t,$t,e),s(t,cl,e),u(kt,t,e),s(t,ml,e),s(t,Et,e),s(t,Jl,e),s(t,Wt,e),s(t,jl,e),s(t,Zt,e),s(t,hl,e),s(t,Rt,e),s(t,Ul,e),s(t,dl,e),s(t,Il,e),s(t,St,e),s(t,Cl,e),s(t,Qt,e),s(t,fl,e),s(t,Yt,e),s(t,bl,e),s(t,Vt,e),s(t,Al,e),s(t,zt,e),s(t,vl,e),u(qt,t,e),s(t,gl,e),s(t,Ft,e),xl=!0},p:Ps,i(t){xl||(y(h.$$.fragment,t),y(f.$$.fragment,t),y($.$$.fragment,t),y(S.$$.fragment,t),y(P.$$.fragment,t),y(et.$$.fragment,t),y(at.$$.fragment,t),y(wt.$$.fragment,t),y(mt.$$.fragment,t),y(jt.$$.fragment,t),y(dt.$$.fragment,t),y(bt.$$.fragment,t),y(gt.$$.fragment,t),y(Bt.$$.fragment,t),y(Ht.$$.fragment,t),y(kt.$$.fragment,t),y(qt.$$.fragment,t),xl=!0)},o(t){w(h.$$.fragment,t),w(f.$$.fragment,t),w($.$$.fragment,t),w(S.$$.fragment,t),w(P.$$.fragment,t),w(et.$$.fragment,t),w(at.$$.fragment,t),w(wt.$$.fragment,t),w(mt.$$.fragment,t),w(jt.$$.fragment,t),w(dt.$$.fragment,t),w(bt.$$.fragment,t),w(gt.$$.fragment,t),w(Bt.$$.fragment,t),w(Ht.$$.fragment,t),w(kt.$$.fragment,t),w(qt.$$.fragment,t),xl=!1},d(t){t&&(l(Dt),l(Pt),l(Kt),l(Ot),l(U),l(te),l(d),l(ee),l(I),l(le),l(C),l(se),l(ne),l(b),l(ie),l(A),l(ae),l(v),l(oe),l(g),l(Me),l(x),l(pe),l(B),l(re),l(_),l(ue),l(H),l(ye),l(G),l(we),l(L),l(Te),l(ce),l(k),l(me),l(E),l(Je),l(W),l(je),l(Z),l(he),l(R),l(Ue),l(de),l(Q),l(Ie),l(Y),l(Ce),l(V),l(fe),l(z),l(be),l(q),l(Ae),l(X),l(ve),l(N),l(ge),l(xe),l(F),l(Be),l(D),l(_e),l(K),l(He),l(O),l(Ge),l(tt),l(Le),l($e),l(lt),l(ke),l(st),l(Ee),l(nt),l(We),l(it),l(Ze),l(Re),l(ot),l(Se),l(Mt),l(Qe),l(pt),l(Ye),l(rt),l(Ve),l(ut),l(ze),l(yt),l(qe),l(Xe),l(Tt),l(Ne),l(ct),l(Pe),l(Fe),l(Jt),l(De),l(Ke),l(ht),l(Oe),l(Ut),l(tl),l(el),l(It),l(ll),l(Ct),l(sl),l(ft),l(nl),l(il),l(At),l(al),l(vt),l(ol),l(j),l(Ml),l(xt),l(pl),l(rl),l(_t),l(ul),l(yl),l(Gt),l(wl),l(Lt),l(Tl),l($t),l(cl),l(ml),l(Et),l(Jl),l(Wt),l(jl),l(Zt),l(hl),l(Rt),l(Ul),l(dl),l(Il),l(St),l(Cl),l(Qt),l(fl),l(Yt),l(bl),l(Vt),l(Al),l(zt),l(vl),l(gl),l(Ft)),l(m),T(h,t),T(f,t),T($,t),T(S,t),T(P,t),T(et,t),T(at,t),T(wt,t),T(mt,t),T(jt,t),T(dt,t),T(bt,t),T(gt),T(Bt,t),T(Ht,t),T(kt,t),T(qt,t)}}}const ln='{"title":"What are Tools?","local":"what-are-tools","sections":[{"title":"What are AI Tools?","local":"what-are-ai-tools","sections":[],"depth":2},{"title":"How do tools work?","local":"how-do-tools-work","sections":[],"depth":2},{"title":"How do we give tools to an LLM?","local":"how-do-we-give-tools-to-an-llm","sections":[{"title":"Auto-formatting Tool sections","local":"auto-formatting-tool-sections","sections":[],"depth":3},{"title":"Generic Tool implementation","local":"generic-tool-implementation","sections":[],"depth":3},{"title":"Model Context Protocol (MCP): a unified tool interface","local":"model-context-protocol-mcp-a-unified-tool-interface","sections":[],"depth":3}],"depth":2}],"depth":1}';function sn($l){return Fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rn extends Ds{constructor(m){super(),Ks(this,m,sn,en,Ns,{})}}export{rn as component};
