import{s as ot,n as it,o as pt}from"../chunks/scheduler.f6319a2a.js";import{S as yt,i as ut,g as M,s as n,r as p,A as jt,h as o,f as s,c as a,j as at,u as y,x as i,k as Mt,y as ct,a as e,v as u,d as j,t as c,w as r}from"../chunks/index.85aa684c.js";import{C as J}from"../chunks/CodeBlock.97b48fd2.js";import{D as rt}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as El,E as Ut}from"../chunks/EditOnGithub.006048dd.js";function Jt(Rl){let U,O,K,ll,w,tl,T,sl,m,Nl="In this tutorial, we’ll see how to implement an agent that leverages SQL using <code>smolagents</code>.",el,b,_l="<p>Let’s start with the golden question: why not keep it simple and use a standard text-to-SQL pipeline?</p>",nl,h,Gl="A standard text-to-sql pipeline is brittle, since the generated SQL query can be incorrect. Even worse, the query could be incorrect, but not raise an error, instead giving some incorrect/useless outputs without raising an alarm.",al,d,Vl="👉 Instead, an agent system is able to critically inspect outputs and decide if the query needs to be changed or not, thus giving it a huge performance boost.",Ml,I,xl="Let’s build this agent! 💪",ol,C,Hl="First, we setup the SQL environment:",il,g,pl,B,yl,f,Xl="Now let’s make our SQL table retrievable by a tool.",ul,Q,$l="The tool’s description attribute will be embedded in the LLM’s prompt by the agent system: it gives the LLM information about how to use the tool. This is where we want to describe the SQL table.",jl,q,cl,A,rl,W,Yl='Now let’s build our tool. It needs the following: (read <a href="../tutorials/tools">the tool doc</a> for more detail)',Ul,Z,Fl="<li>A docstring with an <code>Args:</code> part listing arguments.</li> <li>Type hints on both inputs and output.</li>",Jl,v,wl,S,Ll="Now let us create an agent that leverages this tool.",Tl,k,zl="We use the <code>CodeAgent</code>, which is smolagents’ main agent class: an agent that writes actions in code and can iterate on previous output according to the ReAct framework.",ml,E,Dl="The model is the LLM that powers the agent system. HfApiModel allows you to call LLMs using HF’s Inference API, either via Serverless or Dedicated endpoint, but you could also use any proprietary API.",bl,R,hl,N,dl,_,Kl="Now let’s make it more challenging! We want our agent to handle joins across multiple tables.",Il,G,Pl="So let’s make a second table recording the names of waiters for each receipt_id!",Cl,V,gl,x,Ol="Since we changed the table, we update the <code>SQLExecutorTool</code> with this table’s description to let the LLM properly leverage information from this table.",Bl,H,fl,X,lt='Since this request is a bit harder than the previous one, we’ll switch the LLM engine to use the more powerful <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow">Qwen/Qwen2.5-Coder-32B-Instruct</a>!',Ql,$,ql,Y,tt="It directly works! The setup was surprisingly simple, wasn’t it?",Al,F,st="This example is done! We’ve touched upon these concepts:",Wl,L,et="<li>Building new tools.</li> <li>Updating a tool’s description.</li> <li>Switching to a stronger LLM helps agent reasoning.</li>",Zl,z,nt="✅ Now you can go build this text-to-SQL system you’ve always dreamt of! ✨",vl,D,Sl,P,kl;return w=new El({props:{title:"Text-to-SQL",local:"text-to-sql",headingTag:"h1"}}),T=new rt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/text_to_sql.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/text_to_sql.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/text_to_sql.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/text_to_sql.ipynb"}]}}),g=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-comment"># create city SQL table</span>
table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),B=new El({props:{title:"Build our agent",local:"build-our-agent",headingTag:"h3"}}),q=new J({props:{code:"aW5zcGVjdG9yJTIwJTNEJTIwaW5zcGVjdChlbmdpbmUpJTBBY29sdW1uc19pbmZvJTIwJTNEJTIwJTVCKGNvbCU1QiUyMm5hbWUlMjIlNUQlMkMlMjBjb2wlNUIlMjJ0eXBlJTIyJTVEKSUyMGZvciUyMGNvbCUyMGluJTIwaW5zcGVjdG9yLmdldF9jb2x1bW5zKCUyMnJlY2VpcHRzJTIyKSU1RCUwQSUwQXRhYmxlX2Rlc2NyaXB0aW9uJTIwJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEFwcmludCh0YWJsZV9kZXNjcmlwdGlvbik=",highlighted:`inspector = inspect(engine)
columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(<span class="hljs-string">&quot;receipts&quot;</span>)]

table_description = <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-built_in">print</span>(table_description)`,wrap:!1}}),A=new J({props:{code:"Q29sdW1ucyUzQSUwQSUyMCUyMC0lMjByZWNlaXB0X2lkJTNBJTIwSU5URUdFUiUwQSUyMCUyMC0lMjBjdXN0b21lcl9uYW1lJTNBJTIwVkFSQ0hBUigxNiklMEElMjAlMjAtJTIwcHJpY2UlM0ElMjBGTE9BVCUwQSUyMCUyMC0lMjB0aXAlM0ElMjBGTE9BVA==",highlighted:`Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT`,wrap:!1}}),v=new J({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHNxbF9lbmdpbmUocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMFJldHVybnMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHJlc3VsdC4lMEElMjAlMjAlMjAlMjBUaGUlMjB0YWJsZSUyMGlzJTIwbmFtZWQlMjAncmVjZWlwdHMnLiUyMEl0cyUyMGRlc2NyaXB0aW9uJTIwaXMlMjBhcyUyMGZvbGxvd3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb2x1bW5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHJlY2VpcHRfaWQlM0ElMjBJTlRFR0VSJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMGN1c3RvbWVyX25hbWUlM0ElMjBWQVJDSEFSKDE2KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0lMjBwcmljZSUzQSUyMEZMT0FUJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHRpcCUzQSUyMEZMT0FUJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNBJTIwVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwY29ycmVjdCUyMFNRTC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmNvbm5lY3QoKSUyMGFzJTIwY29uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93cyUyMCUzRCUyMGNvbi5leGVjdXRlKHRleHQocXVlcnkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUyQiUzRCUyMCUyMiU1Q24lMjIlMjAlMkIlMjBzdHIocm93KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sql_engine</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Allows you to perform SQL queries on the table. Returns a string representation of the result.
    The table is named &#x27;receipts&#x27;. Its description is as follows:
        Columns:
        - receipt_id: INTEGER
        - customer_name: VARCHAR(16)
        - price: FLOAT
        - tip: FLOAT

    Args:
        query: The query to perform. This should be correct SQL.
    &quot;&quot;&quot;</span>
    output = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
        rows = con.execute(text(query))
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
            output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
    <span class="hljs-keyword">return</span> output`,wrap:!1}}),R=new J({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzcWxfZW5naW5lJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RIZkFwaU1vZGVsKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS04Qi1JbnN0cnVjdCUyMiklMkMlMEEpJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMGNsaWVudCUyMHdobyUyMGdvdCUyMHRoZSUyMG1vc3QlMjBleHBlbnNpdmUlMjByZWNlaXB0JTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

agent = CodeAgent(
    tools=[sql_engine],
    model=HfApiModel(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>),
)
agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)`,wrap:!1}}),N=new El({props:{title:"Level 2: Table joins",local:"level-2-table-joins",headingTag:"h3"}}),V=new J({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEFyZWNlaXB0cyUyMCUzRCUyMFRhYmxlKCUwQSUyMCUyMCUyMCUyMHRhYmxlX25hbWUlMkMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YV9vYmolMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycmVjZWlwdF9pZCUyMiUyQyUyMEludGVnZXIlMkMlMjBwcmltYXJ5X2tleSUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMndhaXRlcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEEpJTBBbWV0YWRhdGFfb2JqLmNyZWF0ZV9hbGwoZW5naW5lKSUwQSUwQXJvd3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMSUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyQ29yZXklMjBKb2huc29uJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAzJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNaWNoYWVsJTIwV2F0dHMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWFyZ2FyZXQlMjBKYW1lcyUyMiU3RCUyQyUwQSU1RCUwQWZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMHN0bXQlMjAlM0QlMjBpbnNlcnQocmVjZWlwdHMpLnZhbHVlcygqKnJvdyklMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmJlZ2luKCklMjBhcyUyMGNvbm5lY3Rpb24lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdXJzb3IlMjAlM0QlMjBjb25uZWN0aW9uLmV4ZWN1dGUoc3RtdCk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),H=new J({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
It can use the following tables:&quot;&quot;&quot;</span>

inspector = inspect(engine)
<span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),$=new J({props:{code:"c3FsX2VuZ2luZS5kZXNjcmlwdGlvbiUyMCUzRCUyMHVwZGF0ZWRfZGVzY3JpcHRpb24lMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNxbF9lbmdpbmUlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREhmQXBpTW9kZWwoJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUyQyUwQSklMEElMEFhZ2VudC5ydW4oJTIyV2hpY2glMjB3YWl0ZXIlMjBnb3QlMjBtb3JlJTIwdG90YWwlMjBtb25leSUyMGZyb20lMjB0aXBzJTNGJTIyKQ==",highlighted:`sql_engine.description = updated_description

agent = CodeAgent(
    tools=[sql_engine],
    model=HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>),
)

agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),D=new Ut({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/text_to_sql.md"}}),{c(){U=M("meta"),O=n(),K=M("p"),ll=n(),p(w.$$.fragment),tl=n(),p(T.$$.fragment),sl=n(),m=M("p"),m.innerHTML=Nl,el=n(),b=M("blockquote"),b.innerHTML=_l,nl=n(),h=M("p"),h.textContent=Gl,al=n(),d=M("p"),d.textContent=Vl,Ml=n(),I=M("p"),I.textContent=xl,ol=n(),C=M("p"),C.textContent=Hl,il=n(),p(g.$$.fragment),pl=n(),p(B.$$.fragment),yl=n(),f=M("p"),f.textContent=Xl,ul=n(),Q=M("p"),Q.textContent=$l,jl=n(),p(q.$$.fragment),cl=n(),p(A.$$.fragment),rl=n(),W=M("p"),W.innerHTML=Yl,Ul=n(),Z=M("ul"),Z.innerHTML=Fl,Jl=n(),p(v.$$.fragment),wl=n(),S=M("p"),S.textContent=Ll,Tl=n(),k=M("p"),k.innerHTML=zl,ml=n(),E=M("p"),E.textContent=Dl,bl=n(),p(R.$$.fragment),hl=n(),p(N.$$.fragment),dl=n(),_=M("p"),_.textContent=Kl,Il=n(),G=M("p"),G.textContent=Pl,Cl=n(),p(V.$$.fragment),gl=n(),x=M("p"),x.innerHTML=Ol,Bl=n(),p(H.$$.fragment),fl=n(),X=M("p"),X.innerHTML=lt,Ql=n(),p($.$$.fragment),ql=n(),Y=M("p"),Y.textContent=tt,Al=n(),F=M("p"),F.textContent=st,Wl=n(),L=M("ul"),L.innerHTML=et,Zl=n(),z=M("p"),z.textContent=nt,vl=n(),p(D.$$.fragment),Sl=n(),P=M("p"),this.h()},l(l){const t=jt("svelte-u9bgzb",document.head);U=o(t,"META",{name:!0,content:!0}),t.forEach(s),O=a(l),K=o(l,"P",{}),at(K).forEach(s),ll=a(l),y(w.$$.fragment,l),tl=a(l),y(T.$$.fragment,l),sl=a(l),m=o(l,"P",{"data-svelte-h":!0}),i(m)!=="svelte-1rrh2b0"&&(m.innerHTML=Nl),el=a(l),b=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(b)!=="svelte-1yhwgse"&&(b.innerHTML=_l),nl=a(l),h=o(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1hw7g6s"&&(h.textContent=Gl),al=a(l),d=o(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-i6rawm"&&(d.textContent=Vl),Ml=a(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1tzrwc8"&&(I.textContent=xl),ol=a(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-sjpq7n"&&(C.textContent=Hl),il=a(l),y(g.$$.fragment,l),pl=a(l),y(B.$$.fragment,l),yl=a(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-fdu5cw"&&(f.textContent=Xl),ul=a(l),Q=o(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-groxlc"&&(Q.textContent=$l),jl=a(l),y(q.$$.fragment,l),cl=a(l),y(A.$$.fragment,l),rl=a(l),W=o(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1snt6vj"&&(W.innerHTML=Yl),Ul=a(l),Z=o(l,"UL",{"data-svelte-h":!0}),i(Z)!=="svelte-idbd3h"&&(Z.innerHTML=Fl),Jl=a(l),y(v.$$.fragment,l),wl=a(l),S=o(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1t4r7cu"&&(S.textContent=Ll),Tl=a(l),k=o(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-sv1k2f"&&(k.innerHTML=zl),ml=a(l),E=o(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-kt9cj8"&&(E.textContent=Dl),bl=a(l),y(R.$$.fragment,l),hl=a(l),y(N.$$.fragment,l),dl=a(l),_=o(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-nr3fl7"&&(_.textContent=Kl),Il=a(l),G=o(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1ru0803"&&(G.textContent=Pl),Cl=a(l),y(V.$$.fragment,l),gl=a(l),x=o(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-l5upel"&&(x.innerHTML=Ol),Bl=a(l),y(H.$$.fragment,l),fl=a(l),X=o(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1uns4lf"&&(X.innerHTML=lt),Ql=a(l),y($.$$.fragment,l),ql=a(l),Y=o(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1umn140"&&(Y.textContent=tt),Al=a(l),F=o(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-13g6phr"&&(F.textContent=st),Wl=a(l),L=o(l,"UL",{"data-svelte-h":!0}),i(L)!=="svelte-1pz5sot"&&(L.innerHTML=et),Zl=a(l),z=o(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-bt1f1w"&&(z.textContent=nt),vl=a(l),y(D.$$.fragment,l),Sl=a(l),P=o(l,"P",{}),at(P).forEach(s),this.h()},h(){Mt(U,"name","hf:doc:metadata"),Mt(U,"content",wt)},m(l,t){ct(document.head,U),e(l,O,t),e(l,K,t),e(l,ll,t),u(w,l,t),e(l,tl,t),u(T,l,t),e(l,sl,t),e(l,m,t),e(l,el,t),e(l,b,t),e(l,nl,t),e(l,h,t),e(l,al,t),e(l,d,t),e(l,Ml,t),e(l,I,t),e(l,ol,t),e(l,C,t),e(l,il,t),u(g,l,t),e(l,pl,t),u(B,l,t),e(l,yl,t),e(l,f,t),e(l,ul,t),e(l,Q,t),e(l,jl,t),u(q,l,t),e(l,cl,t),u(A,l,t),e(l,rl,t),e(l,W,t),e(l,Ul,t),e(l,Z,t),e(l,Jl,t),u(v,l,t),e(l,wl,t),e(l,S,t),e(l,Tl,t),e(l,k,t),e(l,ml,t),e(l,E,t),e(l,bl,t),u(R,l,t),e(l,hl,t),u(N,l,t),e(l,dl,t),e(l,_,t),e(l,Il,t),e(l,G,t),e(l,Cl,t),u(V,l,t),e(l,gl,t),e(l,x,t),e(l,Bl,t),u(H,l,t),e(l,fl,t),e(l,X,t),e(l,Ql,t),u($,l,t),e(l,ql,t),e(l,Y,t),e(l,Al,t),e(l,F,t),e(l,Wl,t),e(l,L,t),e(l,Zl,t),e(l,z,t),e(l,vl,t),u(D,l,t),e(l,Sl,t),e(l,P,t),kl=!0},p:it,i(l){kl||(j(w.$$.fragment,l),j(T.$$.fragment,l),j(g.$$.fragment,l),j(B.$$.fragment,l),j(q.$$.fragment,l),j(A.$$.fragment,l),j(v.$$.fragment,l),j(R.$$.fragment,l),j(N.$$.fragment,l),j(V.$$.fragment,l),j(H.$$.fragment,l),j($.$$.fragment,l),j(D.$$.fragment,l),kl=!0)},o(l){c(w.$$.fragment,l),c(T.$$.fragment,l),c(g.$$.fragment,l),c(B.$$.fragment,l),c(q.$$.fragment,l),c(A.$$.fragment,l),c(v.$$.fragment,l),c(R.$$.fragment,l),c(N.$$.fragment,l),c(V.$$.fragment,l),c(H.$$.fragment,l),c($.$$.fragment,l),c(D.$$.fragment,l),kl=!1},d(l){l&&(s(O),s(K),s(ll),s(tl),s(sl),s(m),s(el),s(b),s(nl),s(h),s(al),s(d),s(Ml),s(I),s(ol),s(C),s(il),s(pl),s(yl),s(f),s(ul),s(Q),s(jl),s(cl),s(rl),s(W),s(Ul),s(Z),s(Jl),s(wl),s(S),s(Tl),s(k),s(ml),s(E),s(bl),s(hl),s(dl),s(_),s(Il),s(G),s(Cl),s(gl),s(x),s(Bl),s(fl),s(X),s(Ql),s(ql),s(Y),s(Al),s(F),s(Wl),s(L),s(Zl),s(z),s(vl),s(Sl),s(P)),s(U),r(w,l),r(T,l),r(g,l),r(B,l),r(q,l),r(A,l),r(v,l),r(R,l),r(N,l),r(V,l),r(H,l),r($,l),r(D,l)}}}const wt='{"title":"Text-to-SQL","local":"text-to-sql","sections":[{"title":"Build our agent","local":"build-our-agent","sections":[],"depth":3},{"title":"Level 2: Table joins","local":"level-2-table-joins","sections":[],"depth":3}],"depth":1}';function Tt(Rl){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends yt{constructor(U){super(),ut(this,U,Tt,Jt,ot,{})}}export{Ct as component};
