# Request a model addition in the Hugging Face collection on Azure

At the moment the Hugging Face collection on Azure AI / ML contains +10,000 open models from the Hugging Face Hub, leveraging open-source inference solutions such as Text Generation Inference (TGI), vLLM, SGLang, Text Embeddings Inference (TEI), or the Hugging Face Inference Toolkit, among others to come.

To request a model addition into the Hugging Face collection on the Azure AI / ML catalog (it's shared among those services), you can either navigate to the model card on the Hugging Face Hub via https://hf.co/models and then click the "Deploy" button and look for the "Deploy on Azure AI" option, that will automatically check whether a given model is already in the collection. If not available, then a "Request to add" button will appear.

![Request to add to Azure AI in the Hugging Face Hub](https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/request-to-add.png)

Alternatively, you can also [open an issue](https://github.com/huggingface/Microsoft-Azure/issues/new) with the model/s you'd like to see on the Hugging Face collection on Azure.

Before requesting a model addition, you need to make sure that the model or models that you'd like to see on the Hugging Face collection on Azure match the following criteria:

- Have any of the `Transformers`, `Diffusers` or `Sentence-Transformers` tags on the Hugging Face Hub, meaning that the model architecture is compatible with any of those. If the model you'd like to see in the collection doesn't match this criteria, you can maybe check the [Contributing a new model to Transformers](https://huggingface.co/docs/transformers/main/en/modular_transformers) guide on how to add new modular-based model architectures into Transformers.

- Make sure that the task-tag is any of the tasks supported at the moment, as per the listing at [Azure AI - Supported Tasks](../azure-ai/tasks). If it's not there neither among the listing of upcoming tasks in that same page, then feel free to [open an issue](https://github.com/huggingface/Microsoft-Azure/issues/new) requesting the addition of that given task. Again as per the point above, it needs to be a Transformers, Diffusers, or Sentence-Transformers compatible task.

- If you want to benefit from the production-like inference solutions and the OpenAI-compatible interfaces for text generation and embeddings, you should also make sure that the given model has either the `text-generation-inference` (shortened as `tgi`) or `text-embeddings-inference` (shortened as `tei`) tags, respectively.

- There might be some cases where either the "Deploy" or "Deploy on Azure AI" buttons are not enabled (shouldn't be the case, but can happen), in that case feel free to [open an issue](https://github.com/huggingface/Microsoft-Azure/issues/new) sharing the model card and we'll identify if that model can land on our catalog in Azure.

- The Hugging Face Hub models MUST be public and ideally without any kind of gating restrictions, private or gated models won't be considered at the moment.

- The Hugging Face Hub models with `trust_remote_code` are not allowed for security reasons, unless manually verified or coming from an already verified organization.

- And finally, the model weights need to be in Safetensors format and have passed the JFrog, ClamAV, and the rest of the security checks performed in the Hugging Face Hub.


<EditOnGithub source="https://github.com/huggingface/Microsoft-Azure/blob/main/docs/source/guides/request-model-addition.mdx" />