# Features & Benefits

1. Extensive Model Catalog Integration

    Over 10,000 Hugging Face models—including text, vision, speech, and multimodal models are directly accessible within Azure AI Foundry Hub and Azure Machine Learning Studio for one-click deployment.

    Continuous updates ensure day-0 releases of new and trending models from the Hugging Face Hub are available on Azure as soon as they launch.

2. Secure, Scalable, and Managed Deployments

    Models can be deployed on managed online endpoints within Azure Machine Learning, providing secure, scalable REST APIs for real-time inference.

    Azure's infrastructure supports both CPU and GPU deployments, with features like autoscaling, traffic splitting, and monitoring built in.

    Models are scanned for vulnerabilities, and certain model weights are hosted directly on Azure for enhanced security and compliance, including private network deployments with no external egress.

3. Multimodal and Domain-Specific Support

    The collaboration covers a wide range of modalities and tasks: text generation, translation, image classification, segmentation, speech recognition, audio classification, and more.

    Ongoing expansion includes support for video, 3D, time series, protein folding, and other specialized domains.

4. Enterprise-Grade Infrastructure and Developer Tools

    Integration leverages Azure's enterprise-grade infrastructure, including the latest GPU and CPU offerings.

    Hugging Face models are optimized for Azure's hardware, ensuring high performance and efficiency, especially for demanding generative AI applications.

    Integration with Azure Machine Learning SDK, Azure AI SDK, and Python APIs for seamless automation and scripting.

6. Community and Open-Source Ecosystem

    The partnership brings the innovation of Hugging Face's open-source community (nearly 2 million models and 8 million users) to Azure's enterprise customers.

    The Hugging Face models are powered by open-source inference engines backed by Transformers, Diffusers, or Sentence Transformers; as well as efficient production-ready solutions such as Text Generation Inference (TGI), vLLM, SGLang and Text Embeddings Inference (TEI), among others to come.

7. Enhanced Security, Compliance, and Monitoring

    All models available via Azure are subject to security scans and compliance checks, as the model weights are ensured to be distributed in Safetensors format, scanned with JFrog, Protect AI, and ClamAV, as Hugging Face Security Partners, and Hugging Face's Pickelscan.

    Azure's enterprise security features (private endpoints, network isolation, audit trails) are available for Hugging Face model deployments.

## Benefits for Enterprises and Developers

1. Accelerated AI Adoption and Innovation

    Rapid access to the latest open-source models and state-of-the-art AI capabilities without the overhead of infrastructure setup or maintenance.

    Enables organizations to build, experiment, and iterate on AI solutions faster, keeping pace with the evolving AI landscape.

2. Lower Barriers to Production-Ready AI

    Simplifies the deployment of complex models (like Transformers and LLMs) into secure, production environments with minimal configuration.

    Reduces the need for specialized DevOps or ML infrastructure expertise.

3. Flexibility and Control

    Enterprises retain full control over data, model selection, and deployment environments, supporting both public and private cloud scenarios.

4. Cost and Resource Optimization

    Azure's flexible scaling, global availability, and pay-as-you-go pricing help optimize costs for both experimentation and large-scale production.

    Efficient resource utilization through auto-scaling and traffic management features.

5. Security and Compliance

    Enterprise-grade security, compliance, and privacy controls are built into every stage of the model lifecycle.

    Models are vetted for vulnerabilities and can be deployed in isolated environments to meet regulatory requirements.

6. Future-Proofing and Ecosystem Growth

    Ongoing collaboration ensures regular updates, support for new modalities, and integration with emerging Azure and Hugging Face features.

    Access to both open and proprietary models, as well as tools for building modular, agentic, and composable AI applications.

---

This deep integration between Hugging Face and Microsoft Azure empowers organizations to harness the best of open-source AI with the reliability, security, and scalability of Azure's cloud ecosystem.


<EditOnGithub source="https://github.com/huggingface/Microsoft-Azure/blob/main/docs/source/features.mdx" />