# Supported Models

Around +11,000 open models from the Hugging Face Hub are made available on Azure AI / ML, which represents a subset out of the +1,800,000 public open-models, as the Hugging Face collection in Azure is a curated subset of the most downloaded / relevant models on the Hub, as well as compatible with Transformers, Sentence Transformers and Diffusers, as well as with other Hugging Face libraries and solutions.

<Tip>

Even if you don't have a Microsoft Azure account, you can still explore the [public Hugging Face Collection on Azure AI](https://ai.azure.com/catalog/publishers/hugging%20face,huggingface).

</Tip>

This being said, the supported models range different architectures and backends, but a way to identify whether a model from the Hugging Face Hub is made available within the model catalog in Azure AI / ML is to either:

1. Navigate to the model card of the given model under https://huggingface.co/models, and make sure that the "Deploy" button is made available and that the "Deploy on Azure AI" option is listed there. If that's the case, then if the model is available on Azure AI, the URL pointing to the model on Azure AI will be provided via the "Go to model on Azure AI" button, otherwise, the button "Request to add" will show to request the model addition (more information on the latter in [Request a model addition in the Hugging Face collection on Azure](../guides/request-model-addition)).

2. On the other hand, you can also navigate to either the Azure ML or the Azure AI Foundry (the latter only for Hub-based projects) model catalogs under the Hugging Face collection, and search the given model. If the model appears, it means it's supported and you can grab the URI pointing to it to programmatically deploy it, otherwise, you can either [open an issue](https://github.com/huggingface/Microsoft-Azure/issues/new) requesting the model addition, or request it via the Hugging Face Hub model card with the "Request to add" button as mentioned before.

3. Alternatively, you can also check if the given model is available on Azure AI programmatically with the following Python snippet, that sends a request to an Azure API that given a model ID from the Hugging Face Hub returns either HTTP 200 with the model URL if it's available, or just HTTP 404 if not available.

```python
import requests

model_id = "HuggingFaceTB/SmolLM3-3B"
response = requests.get("https://get-azure-ai-url.azurewebsites.net/api/get-azure-ai-url", params={"model_id": model_id})
if response.status_code == 200:
    print(response.json())
    # {"url": "https://ai.azure.com/explore/models/HuggingFaceTB-SmolLM3-3B/version/3/registry/HuggingFace"}
```

We are really excited for this partnership between Hugging Face and Microsoft Azure, and working really hard to bring Azure customers the best open models from the Hugging Face collection into Azure AI / ML, so stay tuned for updates and a lot more models to come in the following months!


<EditOnGithub source="https://github.com/huggingface/Microsoft-Azure/blob/main/docs/source/azure-ai/models.mdx" />